<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
    Released under the terms of the GNU General Public License, GPL, 
    as published by the Free Software Foundation, either version 3 
    of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_SALESTRANSVIEW';
$path_to_root = "../..";

include_once($path_to_root . "/sales/includes/cart_class.inc");
include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/sales/includes/sales_ui.inc");
include_once($path_to_root . "/sales/includes/sales_db.inc");
include_once($path_to_root . "/sales/includes/db/printing_db.inc");
include_once($path_to_root . "/inventory/includes/db/box_size_db.inc");

if (isset($_GET["trans_no"]))
{
    $trans_no = $_GET["trans_no"];
}

 //  for header
// $gate_pass = get_gate_pass($trans_no);
$invoice = get_customer_trans($trans_no, ST_CUSTDELIVERY);
// print_r($gate_pass);

 //  for Detail
$invoice_detail = get_customer_trans_details(ST_CUSTDELIVERY, $trans_no);
// print_r($gate_pass_detail);

?>

<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Print Gate Pass</title>
</head>
<body>
    <div class="container">
        <header>
            <?php 

             $logo = company_path() . "/images/header.PNG";
            
              if (get_company_prefs()['coy_logo'] != '' && file_exists($logo)) { //display_error($logo); ?>
             
                 <div id="logo" class="media" align="left" data-src="grace.png" src="<?php echo $logo; ?>"> <img id="logo" class="media" src="<?php echo $logo; ?>"></div>
             
             <?php  }else {  ?>

                    <div id="logo" ><?php echo get_company_prefs()['coy_name']; ?></div>
             
             <?php }  ?>
        </header>

        <div class="form-control">
            <!-- seperate division -->
            <div class="row">
                <!-- <h1 style="margin: 0, auto;">AHMED DIGITAL WORLD</h1> -->
                <h1 style="text-decoration: none; font-size: 14px; margin-top: 2px; margin-bottom: 2px;"> Customer Copy </h1>
                <span >Gate Pass</span>
                <table class="center" style="border-collapse: collapse;">
                <tr>
                    <th>Party</th>
                    <th>Date</th>
                    <th>GP #</th>
                    <th>REMARKS</th>
                </tr>

                <tr>
                    <th><?php echo $invoice['DebtorName'] ?></th>
                    <th> <?php echo sql2date($invoice['tran_date']);  ?> </th>
                    <th> <?php echo $invoice['reference'] ?> </th>
                    <th> <?php echo $invoice['memo_'] ?> </th>
                </tr>
                </table>
                <br>
                <table class="center" style="border-collapse: collapse;">
                  <tr>
                    <th style="min-width: 90px">SERIAL</th>
                    <th style="min-width: 130px">DESCRIPTION</th>
                    <th style="min-width: 75px">Printing</th>
                    <th style="min-width: 60px">Ply</th>
                    <th style="min-width: 150px">Carton Size</th>
                    <th style="min-width: 75px">Material</th>
                    <th style="min-width: 70px">UNIT</th>
                    <th style="min-width: 55px">QTY</th>
                  </tr>

                  <tr>
                    <?php 
                    $dec = user_price_dec();
                    while ($myrow = db_fetch($invoice_detail)) {
                        // $stock_id_name = get_unit_name_by_stock($myrow["stock_id"]);
                        label_cell($myrow["stock_id"], "align='center'");
                        label_cell($myrow["description"], "align='center'");
                        label_cell(get_printing_name($myrow["printing_id"]), "align='center'");
                        label_cell(get_ply_name($myrow["ply_id"]), "align='center'");
                        label_cell(get_box_size_name($myrow["box_size_id"]), "align='center'");
                        label_cell(get_material_name($myrow["material_id"]), "align='center'");
                        label_cell(get_unit_descr($myrow["unit_id"]), "align='center'");
                        qty_cell($myrow["quantity"], false, $dec );
                        end_row();

                        $qtyTotal +=  $myrow["quantity"];
                    }
                         ?>
                  </tr>

                  <tr>
                    <th>Name</th>
                    <th>Cell #</th>
                    <th>Vehicle #</th>
                    <th colspan="4"></th>
                    <th>Total</th>
                  </tr>

                  <tr>
                    <td> <?php echo $invoice['name_'];  ?> </td>
                    <td> <?php echo $invoice['cell_no'];  ?> </td>
                    <td> <?php echo $invoice['vehicle_no'];  ?> </td>
                    <td colspan="4"> </td>
                    <td> <?php echo $qtyTotal; ?> </td>
                  </tr>
                </table>
                <br><br><br>

                <div class="sign">
                    <div class="row">
                        <span style="text-decoration: overline;">Prepared By</span>
                        &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp
                        <span style="text-decoration: overline;">Approved By</span>
                        &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp
                        <span style="text-decoration: overline;">Received By</span>
                    </div><br><br><br><br>
                    <span>----------------------------------------------------------------------------------------------------------</span>
                    
                    
                </div>

            </div>

            <!--  -->

            <div class="row" style="margin-top: 8%">
                <!-- <h1 style="margin: 0, auto;">AHMED DIGITAL WORLD</h1> -->
            <header>
                <?php 

                 $logo = company_path() . "/images/header.PNG";
                
                  if (get_company_prefs()['coy_logo'] != '' && file_exists($logo)) { //display_error($logo); ?>
                 
                     <div id="logo" class="media" align="left" data-src="grace.png" src="<?php echo $logo; ?>"> <img id="logo" class="media" src="<?php echo $logo; ?>"></div>
                 
                 <?php  }else {  ?>

                        <div id="logo" ><?php echo get_company_prefs()['coy_name']; ?></div>
                 
                 <?php }  ?>
            </header>
                <h1 style="text-decoration: none; font-size: 14px; margin-top: 2px; margin-bottom: 2px;"> Gate Copy </h1>
                <span>Gate Pass</span>
                <table class="center" style="border-collapse: collapse;">
                <tr>
                    <th>Party</th>
                    <th>Date</th>
                    <th>GP #</th>
                    <th>REMARKS</th>
                </tr>

                <tr>
                    <th><?php echo $invoice['DebtorName'] ?></th>
                    <th> <?php echo sql2date($invoice['tran_date']);  ?> </th>
                    <th> <?php echo $invoice['reference'] ?> </th>
                    <th> <?php echo $invoice['memo_'] ?> </th>
                </tr>
                </table>
                <br>
                <table class="center" style="border-collapse: collapse;">
                 <tr>
                    <th style="min-width: 90px">SERIAL</th>
                    <th style="min-width: 130px">DESCRIPTION</th>
                    <th style="min-width: 75px">Printing</th>
                    <th style="min-width: 60px">Ply</th>
                    <th style="min-width: 150px">Carton Size</th>
                    <th style="min-width: 75px">Material</th>
                    <th style="min-width: 70px">UNIT</th>
                    <th style="min-width: 55px">QTY</th>
                  </tr>

                  <tr>
                    <?php 
                    $invoice_detail = get_customer_trans_details(ST_CUSTDELIVERY, $trans_no);
                    $dec = user_price_dec();
                    while ($myrow = db_fetch($invoice_detail)) {
                        // $stock_id_name = get_item($myrow["stock_id"]);
                        label_cell($myrow["stock_id"], "align='center'");
                        label_cell($myrow["description"], "align='center'");
                        label_cell(get_printing_name($myrow["printing_id"]), "align='center'");
                        label_cell(get_ply_name($myrow["ply_id"]), "align='center'");
                        label_cell(get_box_size_name($myrow["box_size_id"]), "align='center'");
                        label_cell(get_material_name($myrow["material_id"]), "align='center'");
                        label_cell(get_unit_descr($myrow["unit_id"]), "align='center'");
                        qty_cell($myrow["quantity"], false, $dec );
                        end_row();

                        $qtyTotal2nd +=  $myrow["quantity"];
                    }
                         ?>
                    <!-- <td>1</td>
                    <td>Maria Anders</td>
                    <td>Germany</td>
                    <td>Alfreds Futterkiste</td>
                    <td>Maria Anders</td>
                    <td>Germany</td> -->
                  </tr>

                 
                  <tr>
                    <th>Name</th>
                    <th>Cell #</th>
                    <th>Vehicle #</th>
                    <th colspan="4"></th>
                    <th>Total</th>
                  </tr>

                   <tr>
                    <td> <?php echo $invoice['name_'];  ?> </td>
                    <td> <?php echo $invoice['cell_no'];  ?> </td>
                    <td> <?php echo $invoice['vehicle_no'];  ?> </td>
                    <td colspan="4"> </td>
                    <td> <?php echo $qtyTotal2nd; ?> </td>
                  </tr>
                </table>
                <br><br><br>
                <div class="sign">
                    <div class="row">
                        <span style="text-decoration: overline;">Prepared By</span>
                        &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp
                        <span style="text-decoration: overline;">Approved By</span>
                        &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp
                        <span style="text-decoration: overline;">Received By</span>
                    </div>
                    <!-- <span>----------------------------------------------------------------------------------------------------------</span> -->
                </div>
            </div>

            <!-- 2nd -->
            <!-- 3RD -->


            <!-- 3RD -->
            <!-- seperate division -->
        </div>
    </div>
</body>
</html>

<style type="text/css">
    table, th, td {
  border: 1px solid;
}

.container{
    text-align: center;
}

.center {
  margin-left: auto;
  margin-right: auto;
  width: 500px;
  height: 50px;
}

h1{
    font-size: 13px;
}

#logo {
        width: 80%;
        text-align: center;
        -webkit-align-content: center;
        align-content: center;
        padding: 3px;
        margin: 1px;
        display: block;
        margin: 0 auto;
    }

@media print {
    html, body {
        height: 80%;
    }
}

</style>

