<?php
/****************************************
/*  Author 	: Kvvaradha
/*  Module 	: Extended HRM
/*  E-mail 	: admin@kvcodes.com
/*  Version : 1.0
/*  Http 	: www.kvcodes.com
*****************************************/
$page_security = 'HR_EMPLOYEE_SETUP';
$path_to_root="../..";

include($path_to_root . "/includes/session.inc"); 
add_access_extensions();
include($path_to_root . "/includes/ui.inc");
include_once($path_to_root . "/includes/data_checks.inc");

include($path_to_root . "/modules/ExtendedHRM/includes/Payroll.inc" );
$version_id = get_company_prefs('version_id');

$js = '';
if($version_id['version_id'] == '2.4.1'){
	if ($SysPrefs->use_popup_windows) 
		$js .= get_js_open_window(900, 500);	

	if (user_use_date_picker()) 
		$js .= get_js_date_picker();
	
}else{
	if ($use_popup_windows)
		$js .= get_js_open_window(900, 500);
	if ($use_date_picker)
		$js .= get_js_date_picker();
}

page(_("Grade Setup"), false, false, "", $js);

simple_page_mode(true);
//----------------------------------------------------------------------------------------------------

function can_process(){
	if (strlen($_POST['description']) == 0){
		display_error(_("The Description cannot be empty."));
		set_focus('description');
		return false;
	}

	if (strlen($_POST['sl']) == 0){
		display_error(_("The Sick Leave days cannot be empty."));
		set_focus('sl');
		return false;
	}

	if (strlen($_POST['ml']) == 0){
		display_error(_("The Maternity Leave cannot be empty."));
		set_focus('ml');
		return false;
	}

	if (strlen($_POST['al']) == 0){
		display_error(_("The Annual Leave cannot be empty."));
		set_focus('al');
		return false;
	}

	/*if (isset($_POST['selected_id']) && $_POST['selected_id'] ==-1 && key_in_foreign_table(date2sql($_POST['date']), 'kv_empl_grade', 'date')){
		display_error(_("Date Already exist in Holiday."));
		set_focus('date');
		return false;
	}*/
	return true;
}

//----------------------------------------------------------------------------------------------------
if ($Mode=='ADD_ITEM' && can_process()){

	$unit = (check_value('add_per_month') == 1 ? 12 : 1 );
	Insert('kv_empl_grade', array('description' => $_POST['description'], 'min_salary' => input_num('min_salary')*$unit, 'max_salary' => input_num('max_salary')*$unit,'sl' => $_POST['sl']*$unit, 'al' => $_POST['al']*$unit, 'ml' => $_POST['ml']*$unit, 'inactive' => ($_POST['inactive']==1 ? $_POST['inactive'] : 0 )));

	display_notification(_("New Grade has been added"));
	$Mode = 'RESET';
}

//----------------------------------------------------------------------------------------------------
if ($Mode=='UPDATE_ITEM' && can_process()){
	Update('kv_empl_grade', array('id' => $selected_id), array('description' => $_POST['description'], 'min_salary' => input_num('min_salary'), 'max_salary' => input_num('max_salary'),'sl' => $_POST['sl'], 'al' => $_POST['al'], 'ml' => $_POST['ml'], 'inactive' => ($_POST['inactive'] == 1 ? $_POST['inactive'] : 0 )));

$empl_id = GetSingleValue('kv_empl_job', 'empl_id', array('id' => $selected_id));
if($empl_id != '')
	Update('kv_empl_job', array('grade' => $selected_id), array('sl' => $_POST['sl'], 'al' => $_POST['al'], 'ml' => $_POST['ml']));
	
	display_notification(_("Selected Grade has been updated"));
	$Mode = 'RESET';
}

//----------------------------------------------------------------------------------------------------
if ($Mode == 'Delete'){
	$cancel_delete = 0;

	// PREVENT DELETES IF DEPENDENT RECORDS IN 'kv_empl_job'
	if (key_in_foreign_table($selected_id, 'kv_empl_job', 'grade'))	{
		$cancel_delete = 1;
		display_error(_("Cannot delete this grade because Employees have been created using this grade."));
	} 
	if ($cancel_delete == 0) {
		Delete('kv_empl_grade',array('id' => $selected_id));
		display_notification(_("Selected Grade has been deleted"));
	}	
	$Mode = 'RESET';
}

if ($Mode == 'RESET'){
	$selected_id = -1;
	$sav = get_post('show_inactive');
	unset($_POST);
	$_POST['show_inactive'] = $sav;
}


if(list_updated('per_month') ){
  	if(get_post('per_month') == 1)
		$checkAll = 12;
	else
   		$checkAll = 1;
   	$Ajax->activate('GradeDisplay');
}else
  	$checkAll = 1;

if(list_updated('add_per_month') ){
  	if(check_value('add_per_month') == 1){
		$txt = 'Month';
		$_POST['unit'] = 12;
  	}
	else{
   		$txt = 'Annum';
   		$_POST['unit'] = 1;
	}
   	$Ajax->activate('GradeAddEdit');
} else{
	$txt = 'Annum';
	$_POST['unit'] = 1;
}


  $dec = get_qty_dec();
//----------------------------------------------------------------------------------------------------
	start_form();

		start_table(TABLESTYLE_NOBORDER);
			check_row(_("Show Per month"), 'per_month', null, true);
		end_table();
		br();
		div_start('GradeDisplay');
		if(!check_value('show_inactive'))
			$result = GetAll('kv_empl_grade', array('inactive' => 0));
		else
			$result = GetAll('kv_empl_grade');
		start_table(TABLESTYLE, "width=80%");

		$th = array (_("Name"), _("Minimum Gross"), _("Maximum Gross"), _("Annual Leave"),_("Sick Leave "),_("Maternity Leave"), _("Allowed Leaves"), '','');
		inactive_control_column($th);
		table_header($th);

		foreach($result as $myrow){
			
			label_cell($myrow["description"]);			
			label_cell(round($myrow["min_salary"]/$checkAll, $dec));
			label_cell(round($myrow["max_salary"]/$checkAll, $dec));
			label_cell(round($myrow["al"]/$checkAll, $dec));
			label_cell(round($myrow["sl"]/$checkAll, $dec));
			label_cell(round($myrow["ml"]/$checkAll, $dec));
			label_cell(round( ($myrow["sl"]/$checkAll+$myrow["ml"]/$checkAll+$myrow['al']/$checkAll), $dec));
			inactive_control_cell($myrow["id"], $myrow["inactive"], 'kv_empl_grade', 'id');
		 	edit_button_cell("Edit".$myrow['id'], _("Edit"));
		 	delete_button_cell("Delete".$myrow['id'], _("Delete"));
			end_row();
		}
		inactive_control_row($th);
		end_table();
		br(2); 
		div_end();

	div_start('GradeAddEdit');
		//----------------------------------------------------------------------------------------------------
		start_table(TABLESTYLE2);
		table_section_title(_("Grade System"));
		if ($selected_id != -1){

		 	if ($Mode == 'Edit') {
				$myrow = GetRow('kv_empl_grade', array('id' => $selected_id));

				$_POST['description']  = $myrow["description"];
				$_POST['min_salary']  = $myrow["min_salary"]/$_POST['unit'];
				$_POST['max_salary']  = $myrow["max_salary"]/$_POST['unit'];
				$_POST['al']  = $myrow["al"]/$_POST['unit'];
				$_POST['ml']  = $myrow["ml"]/$_POST['unit'];
				$_POST['sl']  = $myrow["sl"]/$_POST['unit'];
				$_POST['inactive']  = $myrow["inactive"];
			}
			hidden('selected_id', $selected_id);
			//hidden('year', $myrow['year']);
			$Ajax->activate('GradeAddEdit');
		}else{
			$_POST['description']  = $_POST['hl'] = $_POST['al']=$_POST['sl'] = $_POST['ml'] = '';
			$_POST['min_salary']  = $_POST['max_salary']  = $_POST['inactive']  = 0; 
			hidden('selected_id', -1);
			check_row(_("Add Per month"), 'add_per_month', null, true);
		}
		
		text_row(_("Description:"), 'description', null, 40, 80);	
		amount_row(_("Minimum Gross Salary"). " :", 'min_salary', null, null, '/'.$txt , null, true); 
		amount_row(_("Maximum Gross Salary"). " :", 'max_salary', null, null, '/'.$txt , null, true); 		
		text_row_ex(_("Annual Leave"). " :", 'al', 10, 10, '', null, null, $txt );
		text_row_ex(_("Sick Leave days"). " :", 'sl', 10, 10, '', null, null, $txt );
		text_row_ex(_("Maternity Leave"). " :", 'ml', 10, 10, '', null, null, $txt );
		check_row(_("Inactive").':', 'inactive', null);

		end_table(1);
	div_end();
		submit_add_or_update_center($selected_id == -1, '', 'both');

	end_form();
end_page(); ?>
