<?php
/****************************************
/*  Author 	: Kvvaradha
/*  Module 	: Extended HRM
/*  E-mail 	: admin@kvcodes.com
/*  Version : 1.0
/*  Http 	: www.kvcodes.com
/* Notification to Employees
*****************************************/

$page_security = 'HR_EMPLOYEE_SETUP';
$path_to_root="../../..";
include_once($path_to_root . "/includes/session.inc");
add_access_extensions();
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/ui.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/modules/ExtendedHRM/includes/Payroll.inc" );

page(_("Notification"), @$_REQUEST['popup']);
 
simple_page_mode(true);

if ($Mode=='ADD_ITEM' || $Mode=='UPDATE_ITEM'){

	$input_error = 0;

	if (strlen($_POST['description']) == 0) {
		$input_error = 1;
		display_error(_("The Notification description cannot be empty."));
		set_focus('description');
	}	
	$BeginTime = date('H:i:s', strtotime($_POST['BeginTime_hour'].':'.str_pad($_POST['BeginTime_min'], 2, '0', STR_PAD_LEFT).' '.$_POST['BeginTime_ampm']));
		$_POST['BeginTime'] = $BeginTime;
		$EndTime = date('H:i:s', strtotime($_POST['EndTime_hour'].':'.str_pad($_POST['EndTime_min'], 2, '0', STR_PAD_LEFT).' '.$_POST['EndTime_ampm']));
		$_POST['EndTime'] = $EndTime;

	if(strtotime($_POST['BeginTime']) > strtotime($_POST['EndTime'])){
		$input_error = 1;
		display_error(_("The Notification Begin time is Greater than end time"));
		set_focus('BeginTime');
	}

	if ($input_error != 1)	{		

    	if ($selected_id != -1)     	{
    		Update('kv_empl_notification', array('id' => $selected_id), array('description'=>$_POST['description'], 'BeginTime' => $_POST['BeginTime'], 'EndTime' => $_POST['EndTime']));
			$note = _("Selected Notification has been updated");
    	}     	else     	{
    		Insert('kv_empl_notification', array('description' => $_POST['description'], 'BeginTime' => $_POST['BeginTime'], 'EndTime' => $_POST['EndTime']));
			$note = _("New Notification has been added");
    	}
    
		display_notification($note);    	
		$Mode = 'RESET';
	}
} 

if ($Mode == 'Delete'){

	$cancel_delete = 0;

	// PREVENT DELETES IF DEPENDENT RECORDS IN 'debtors_master'

	if (key_in_foreign_table($selected_id, 'kv_empl_job', 'id'))	{
		$cancel_delete = 1;
		display_error(_("Cannot delete this Notification because Employees have been created using this Notification."));
	} 
	if ($cancel_delete == 0) {
		Delete('kv_empl_notification', array('id' => $selected_id));
		display_notification(_("Selected Notification has been deleted"));
	} //end if Delete Notification
	$Mode = 'RESET';
} 

if ($Mode == 'RESET'){
	$selected_id = -1;
	$sav = get_post('show_inactive');
	unset($_POST);
	if ($sav) $_POST['show_inactive'] = 1;
}
//-------------------------------------------------------------------------------------------------


if(check_value('show_inactive'))
	$result = GetAll('kv_empl_notification', array('inactive' => check_value('show_inactive')));
else
	$result = GetAll('kv_empl_notification');

start_form();
start_table(TABLESTYLE, "width=30%");
$th = array(_("ID"), _("Description"), _("Begin Time"), _("End Time"), "", "");
inactive_control_column($th);

table_header($th);
$k = 0; 

 foreach($result as $myrow) {
	
	alt_table_row_color($k);
		
	label_cell($myrow["id"]);
	label_cell($myrow["description"]);
	label_cell($myrow["BeginTime"].' '._(""));
	label_cell($myrow["EndTime"].' '._(""));
	inactive_control_cell($myrow["id"], $myrow["inactive"], 'kv_empl_notification', 'id');
 	edit_button_cell("Edit".$myrow["id"], _("Edit"));
 	delete_button_cell("Delete".$myrow["id"], _("Delete"));
	end_row();
}

inactive_control_row($th);
end_table(1);

//-------------------------------------------------------------------------------------------------

start_table(TABLESTYLE2);

if ($selected_id != -1) {
 	if ($Mode == 'Edit') { //editing an existing department
		$myrow = GetRow('kv_empl_notification', array('id' => $selected_id));

		$_POST['description']  = $myrow["description"];
		$_POST['BeginTime']  = $myrow["BeginTime"];
		$_POST['EndTime']  = $myrow["EndTime"];
	}
	hidden("selected_id", $selected_id);
	label_row(_("ID"), $myrow["id"]);
} else{
	$_POST['BeginTime'] = $_POST['EndTime']  = '';
}

text_row_ex(_("Description:"), 'description', 30); 
TimeDropDown_row(_("Begin Time"), 'BeginTime', $_POST['BeginTime']);			
TimeDropDown_row(_("End Time"), 'EndTime', $_POST['EndTime']);

end_table(1);

submit_add_or_update_center($selected_id == -1, '', 'both');

end_form();

end_page();
?>