<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/

function add_latter_hand_setting($latter_head_id=0, $email='', $ntn_no=0, $strn_no=0, $contact_no=0, $address='', $file_name='')
{
	$sql = "INSERT INTO ".TB_PREF."latter_head_setting (latter_head_id, email, ntn_no, strn_no, contact_no, 
		file_name, address) VALUES (".db_escape($latter_head_id) . ", ".db_escape($email) . ", ".db_escape($ntn_no) . ", 
	".db_escape($strn_no) . ", ".db_escape($contact_no) . ", ".db_escape($file_name) . ", ".db_escape($address) . ")";
   	db_query($sql,"The sales area could not be added");
}

function update_latter_hand_setting($email='', $ntn_no=0, $strn_no=0, 
	$contact_no=0, $address='', $file_name='', $latter_head_id=0)
{
	$sql = "UPDATE ".TB_PREF."latter_head_setting SET email=".db_escape($email).",
		ntn_no=".db_escape($ntn_no).", strn_no=".db_escape($strn_no).",
		contact_no=".db_escape($contact_no).", file_name=".db_escape($file_name).", address=".db_escape($address)." WHERE latter_head_id = ".db_escape($latter_head_id);
   	db_query($sql,"The sales area could not be updated");
}

function delete_latter_hand_setting($selected_id)
{
	$sql="DELETE FROM ".TB_PREF."latter_head_setting WHERE id=".db_escape($selected_id);
	db_query($sql,"could not delete sales area");
}

function get_latter_hand_settings($show_inactive)
{
	$sql = "SELECT * FROM ".TB_PREF."latter_head_setting";
	if (!$show_inactive) $sql .= " WHERE !inactive";
	return db_query($sql,"could not get areas");
}

function get_latter_hand_setting($latter_head_id)
{
	$sql = "SELECT * FROM ".TB_PREF."latter_head_setting WHERE latter_head_id=".db_escape($latter_head_id);
	$result = db_query($sql,"could not get area");
	return db_fetch($result);
}

function get_latter_hand_setting_name($id)
{
	$sql = "SELECT name FROM ".TB_PREF."latter_head_setting WHERE id=".db_escape($id);
	$result = db_query($sql, "could not get sales type");
	$row = db_fetch_row($result);
	return is_array($row) ? $row[0] : false;
}