# MySQL dump of database 'nasakcaa_wrackler' on host 'localhost'
# Backup Date and Time: 2024-02-17 13:46
# Built by digitleysystem 2.4.11
# http://digitleysystem
# Company: WRACKLER
# User: Administrator

# Compatibility: 2.4.1


SET NAMES latin1;


### Structure of table `0_approval_trans` ###

DROP TABLE IF EXISTS `0_approval_trans`;

CREATE TABLE `0_approval_trans` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` int(11) NOT NULL,
  `trans_no` int(11) NOT NULL,
  `date` date NOT NULL DEFAULT '0000-00-00',
  `user_id` int(11) NOT NULL,
  `remarks` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ;

### Data of table `0_approval_trans` ###


### Structure of table `0_areas` ###

DROP TABLE IF EXISTS `0_areas`;

CREATE TABLE `0_areas` (
  `area_code` int(11) NOT NULL AUTO_INCREMENT,
  `description` varchar(60) NOT NULL DEFAULT '',
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`area_code`),
  UNIQUE KEY `description` (`description`)
) ENGINE=InnoDB AUTO_INCREMENT=387 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_areas` ###

INSERT INTO `0_areas` VALUES
('383', 'North Nazimabad', '0'),
('385', 'Clifton', '0'),
('386', 'Gulshan-e-Iqbal', '0');

### Structure of table `0_attachments` ###

DROP TABLE IF EXISTS `0_attachments`;

CREATE TABLE `0_attachments` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(60) NOT NULL DEFAULT '',
  `type_no` int(11) NOT NULL DEFAULT 0,
  `trans_no` int(11) NOT NULL DEFAULT 0,
  `unique_name` varchar(60) NOT NULL DEFAULT '',
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `filename` varchar(60) NOT NULL DEFAULT '',
  `filesize` int(11) NOT NULL DEFAULT 0,
  `filetype` varchar(60) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `type_no` (`type_no`,`trans_no`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_attachments` ###


### Structure of table `0_audit_trail` ###

DROP TABLE IF EXISTS `0_audit_trail`;

CREATE TABLE `0_audit_trail` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` smallint(6) unsigned NOT NULL DEFAULT 0,
  `trans_no` int(11) unsigned NOT NULL DEFAULT 0,
  `user` smallint(6) unsigned NOT NULL DEFAULT 0,
  `stamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `description` varchar(60) DEFAULT NULL,
  `fiscal_year` int(11) NOT NULL DEFAULT 0,
  `gl_date` date NOT NULL DEFAULT '0000-00-00',
  `gl_seq` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `Seq` (`fiscal_year`,`gl_date`,`gl_seq`),
  KEY `Type_and_Number` (`type`,`trans_no`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_audit_trail` ###


### Structure of table `0_bank_accounts` ###

DROP TABLE IF EXISTS `0_bank_accounts`;

CREATE TABLE `0_bank_accounts` (
  `account_code` varchar(15) NOT NULL DEFAULT '',
  `account_type` smallint(6) NOT NULL DEFAULT 0,
  `bank_account_name` varchar(60) NOT NULL DEFAULT '',
  `bank_account_number` varchar(100) NOT NULL DEFAULT '',
  `bank_name` varchar(60) NOT NULL DEFAULT '',
  `bank_address` tinytext DEFAULT NULL,
  `bank_curr_code` char(3) NOT NULL DEFAULT '',
  `dflt_curr_act` tinyint(1) NOT NULL DEFAULT 0,
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `bank_charge_act` varchar(15) NOT NULL DEFAULT '',
  `last_reconciled_date` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ending_reconcile_balance` double NOT NULL DEFAULT 0,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `bank_account_name` (`bank_account_name`),
  KEY `bank_account_number` (`bank_account_number`),
  KEY `account_code` (`account_code`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_bank_accounts` ###

INSERT INTO `0_bank_accounts` VALUES
('1020101001', '3', 'Cash in Hand - Lhr', 'N/A', 'Cash in Hand - Lhr', NULL, 'PKR', '0', '2', '40501001', '0000-00-00 00:00:00', '0', '0'),
('1020103005', '1', 'Bank Al Baraka  001002-77361-019', '', 'Bank Al Baraka  001002-77361-019', NULL, 'PKR', '0', '12', '40501001', '0000-00-00 00:00:00', '0', '0');

### Structure of table `0_bank_check_serial` ###

DROP TABLE IF EXISTS `0_bank_check_serial`;

CREATE TABLE `0_bank_check_serial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) NOT NULL,
  `serial_from` double NOT NULL,
  `serial_to` double NOT NULL,
  `inactive` tinyint(4) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_bank_check_serial` ###

INSERT INTO `0_bank_check_serial` VALUES
('8', '9', '160820297', '160820320', '0'),
('9', '1', '1945', '2000', '0'),
('10', '1', '1892', '1892', '0'),
('11', '1', '2001', '2100', '0'),
('12', '1', '2101', '2200', '0');

### Structure of table `0_bank_trans` ###

DROP TABLE IF EXISTS `0_bank_trans`;

CREATE TABLE `0_bank_trans` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` smallint(6) DEFAULT NULL,
  `trans_no` int(11) DEFAULT NULL,
  `bank_act` varchar(15) NOT NULL DEFAULT '',
  `ref` varchar(40) DEFAULT NULL,
  `trans_date` date NOT NULL DEFAULT '0000-00-00',
  `amount` double DEFAULT NULL,
  `dimension_id` int(11) NOT NULL DEFAULT 0,
  `dimension2_id` int(11) NOT NULL DEFAULT 0,
  `person_type_id` int(11) NOT NULL DEFAULT 0,
  `person_id` tinyblob DEFAULT NULL,
  `account_no` varchar(50) NOT NULL DEFAULT '',
  `account_name` varchar(250) NOT NULL DEFAULT '',
  `entry_date` date NOT NULL DEFAULT '0000-00-00',
  `imported` tinyint(4) NOT NULL DEFAULT 0,
  `reconciled` date DEFAULT NULL,
  `is_cheque_no` int(11) NOT NULL DEFAULT 0,
  `cheque_no` varchar(30) DEFAULT NULL,
  `po_no` int(11) NOT NULL DEFAULT 0,
  `file_system` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `bank_act` (`bank_act`,`ref`),
  KEY `type` (`type`,`trans_no`),
  KEY `bank_act_2` (`bank_act`,`reconciled`),
  KEY `bank_act_3` (`bank_act`,`trans_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_bank_trans` ###


### Structure of table `0_bom` ###

DROP TABLE IF EXISTS `0_bom`;

CREATE TABLE `0_bom` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `parent` char(20) NOT NULL DEFAULT '',
  `component` char(20) NOT NULL DEFAULT '',
  `workcentre_added` int(11) NOT NULL DEFAULT 0,
  `loc_code` char(5) NOT NULL DEFAULT '',
  `quantity` double NOT NULL DEFAULT 1,
  PRIMARY KEY (`parent`,`component`,`workcentre_added`,`loc_code`),
  KEY `component` (`component`),
  KEY `id` (`id`),
  KEY `loc_code` (`loc_code`),
  KEY `parent` (`parent`,`loc_code`),
  KEY `workcentre_added` (`workcentre_added`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_bom` ###


### Structure of table `0_budget_trans` ###

DROP TABLE IF EXISTS `0_budget_trans`;

CREATE TABLE `0_budget_trans` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `account` varchar(15) NOT NULL DEFAULT '',
  `memo_` tinytext NOT NULL,
  `amount` double NOT NULL DEFAULT 0,
  `dimension_id` int(11) DEFAULT 0,
  `dimension2_id` int(11) DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `Account` (`account`,`tran_date`,`dimension_id`,`dimension2_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_budget_trans` ###


### Structure of table `0_cancel_cheque` ###

DROP TABLE IF EXISTS `0_cancel_cheque`;

CREATE TABLE `0_cancel_cheque` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `bank_account_id` int(11) NOT NULL,
  `cheque_no` varchar(255) NOT NULL,
  `user_id` int(11) NOT NULL,
  `currentdate` date NOT NULL DEFAULT '0000-00-00',
  `inactive` tinyint(4) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ;

### Data of table `0_cancel_cheque` ###


### Structure of table `0_chart_class` ###

DROP TABLE IF EXISTS `0_chart_class`;

CREATE TABLE `0_chart_class` (
  `cid` varchar(3) NOT NULL,
  `class_name` varchar(60) NOT NULL DEFAULT '',
  `ctype` tinyint(1) NOT NULL DEFAULT 0,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`cid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_chart_class` ###

INSERT INTO `0_chart_class` VALUES
('1', 'Assets', '1', '0'),
('2', 'Liabilities', '2', '0'),
('3', 'Income', '4', '0'),
('4', 'Expenses', '6', '0'),
('404', 'Import Expenses', '6', '0'),
('5', 'Capital', '3', '0');

### Structure of table `0_chart_master` ###

DROP TABLE IF EXISTS `0_chart_master`;

CREATE TABLE `0_chart_master` (
  `account_code` varchar(15) NOT NULL DEFAULT '',
  `account_code2` varchar(15) NOT NULL DEFAULT '',
  `account_name` varchar(60) NOT NULL DEFAULT '',
  `account_type` varchar(10) NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`account_code`),
  KEY `account_name` (`account_name`),
  KEY `accounts_by_type` (`account_type`,`account_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_chart_master` ###

INSERT INTO `0_chart_master` VALUES
('10101001', '', 'Tengible Fixed Assets', '10101', '0'),
('10101002', '', 'Qualifying Assets', '10101', '0'),
('1010101001', '', 'Manual Stacker', '1010101', '0'),
('1010101002', '', 'Filling Machine Pump', '1010101', '0'),
('1010101003', '', 'Stacker Drum', '1010101', '0'),
('1010101004', '', 'Carb Clean Mixer - 1000 kg (Pneumatic)', '1010101', '0'),
('1010101005', '', 'Compressor', '1010101', '0'),
('1010101006', '', 'Tin Sealer', '1010101', '0'),
('1010101007', '', 'Dryer Machine', '1010101', '0'),
('1010101008', '', 'Sachet Packing Machine', '1010101', '0'),
('1010101009', '', 'Manual Sanction Pump', '1010101', '0'),
('1010101010', '', 'Coolant Filling Machine', '1010101', '0'),
('1010101011', '', 'Coolant Sealer Machine', '1010101', '0'),
('1010101012', '', 'Manual Hand Lifter', '1010101', '0'),
('1010101013', '', 'Induction Sealer - Manual', '1010101', '0'),
('1010101014', '', 'Sealing Machine', '1010101', '0'),
('1010101015', '', 'Batch Printing Machine', '1010101', '0'),
('1010101016', '', 'Aerosol Conveyer', '1010101', '0'),
('1010101017', '', 'Liquid Aerosol Filling Machine', '1010101', '0'),
('1010101018', '', 'Crymping/ Valve Punching Machine', '1010101', '0'),
('1010101019', '', 'LPG Gas Filling Machine - Single Headed', '1010101', '0'),
('1010101020', '', 'LPG Gas Filling Machine - Double Headed', '1010101', '0'),
('1010101021', '', 'Aerosol 3 in 1', '1010101', '0'),
('1010101022', '', 'Sanction Pump 3 in 1', '1010101', '0'),
('1010101023', '', 'Brake Oil Filling Machine', '1010101', '0'),
('1010101024', '', 'Induction Sealer - Auto', '1010101', '0'),
('1010101025', '', 'Air Compressor', '1010101', '0'),
('1010101026', '', 'Liquid Filling Maching - (Shampoo &amp; Cleaner)', '1010101', '0'),
('1010101027', '', 'DE Stench Plant', '1010101', '0'),
('1010101028', '', 'Liquid Filling Machine - ATF &amp; Power Steering', '1010101', '0'),
('1010101029', '', 'Attriator Big', '1010101', '0'),
('1010101030', '', 'Dryer Machine - Cupric Acetate', '1010101', '0'),
('1010101031', '', 'Di Ionized Plant', '1010101', '0'),
('1010101032', '', 'LPG Filling Machine - New Import', '1010101', '0'),
('1010101033', '', 'Crymping/ Punching Machine - New Import', '1010101', '0'),
('1010101034', '', 'Coolant Sanction Pump - Puneumatic', '1010101', '0'),
('1010101035', '', 'Di Ionized Plant', '1010101', '0'),
('1010101036', '', 'ATF/Power Steering Mixer', '1010101', '0'),
('1010101037', '', 'Gresae Mixer', '1010101', '0'),
('1010101038', '', 'Grease Filling ', '1010101', '0'),
('1010101039', '', 'Compressor', '1010101', '0'),
('1010101040', '', 'Transfer Pump - Cupric Acetate', '1010101', '0'),
('1010101041', '', 'Pneumatic Pump', '1010101', '0'),
('1010101042', '', 'Pouch Sealer Machine', '1010101', '0'),
('1010101043', '', 'Empty Vessel', '1010101', '0'),
('1010101044', '', 'Mixer - Coper Acetate', '1010101', '0'),
('1010101045', '', 'Lifter - Heli', '1010101', '0'),
('1010101046', '', 'Drum Handler', '1010101', '0'),
('1010102001', '', 'Chairs', '1010102', '0'),
('1010102002', '', 'Executive Chair', '1010102', '0'),
('1010102003', '', 'Office Table', '1010102', '0'),
('1010102004', '', 'Executive Table Set', '1010102', '0'),
('1010102005', '', 'Bench', '1010102', '0'),
('1010102006', '', 'Stool', '1010102', '0'),
('1010102007', '', 'Side Table', '1010102', '0'),
('1010102008', '', 'Office Chairs ', '1010102', '0'),
('1010102009', '', 'Office Table ', '1010102', '0'),
('1010103001', '', 'Suzuki Ravi - KS 9427', '1010103', '0'),
('1010103002', '', 'Suzuki Bolan - CY 6783', '1010103', '0'),
('1010103003', '', 'Master Truck - KQ 0837', '1010103', '0'),
('1010103004', '', 'Tyota Corola - BGL 517', '1010103', '0'),
('1010103005', '', 'MotorCycle', '1010103', '0'),
('1010103006', '', 'Loader Rikshaw Solar', '1010103', '0'),
('1010104001', '', 'Rack', '1010104', '0'),
('1010104002', '', 'Pallets', '1010104', '0'),
('1010104003', '', 'Cabinets, Doors  &amp; Fixture', '1010104', '0'),
('1010104004', '', 'Fixture Cubinet', '1010104', '0'),
('1010104005', '', 'Cupbord', '1010104', '0'),
('1010104006', '', 'Light Panel Stand', '1010104', '0'),
('1010105001', '', 'Water Dispenser', '1010105', '0'),
('1010105002', '', 'Digital Scale', '1010105', '0'),
('1010105003', '', 'Air Conditioner', '1010105', '0'),
('1010105004', '', 'IT Box', '1010105', '0'),
('1010105005', '', 'Camera', '1010105', '0'),
('1010105006', '', 'Ceiling Fan', '1010105', '0'),
('1010105007', '', 'Exaust Fan', '1010105', '0'),
('1010105008', '', 'Bracket Fan', '1010105', '0'),
('1010105009', '', 'Stablizer', '1010105', '0'),
('1010105010', '', 'Refrigerator', '1010105', '0'),
('1010105011', '', 'Electric Weging Scale', '1010105', '0'),
('1010105012', '', 'Motor - Small', '1010105', '0'),
('1010105013', '', 'Motor - Big', '1010105', '0'),
('1010105014', '', 'Padesatl Fan', '1010105', '0'),
('1010105015', '', 'Donkey Pump', '1010105', '0'),
('1010105016', '', 'Weighing Scale', '1010105', '0'),
('1010105017', '', 'Water Motor', '1010105', '0'),
('1010105018', '', 'Electric Water Cooler', '1010105', '0'),
('1010105019', '', 'Deep Freezer', '1010105', '0'),
('1010105020', '', 'Exahust Fan - Industrial', '1010105', '0'),
('1010105021', '', 'Water Sanction Motor', '1010105', '0'),
('1010105022', '', 'Weighing Scale', '1010105', '0'),
('1010105023', '', 'Room Coolar', '1010105', '0'),
('1010105024', '', 'UPS Batteries', '1010105', '0'),
('1010105025', '', 'Battery Charger', '1010105', '0'),
('1010105026', '', 'Solar Panel 900 Watt (Set)', '1010105', '0'),
('1010105027', '', 'Generator ', '1010105', '0'),
('1010106001', '', 'Locker', '1010106', '0'),
('1010106002', '', 'Fire Extinguisher', '1010106', '0'),
('1010106003', '', 'Lockers', '1010106', '0'),
('1010106004', '', 'Telephone Set', '1010106', '0'),
('1010106005', '', 'Racks', '1010106', '0'),
('1010106006', '', 'Display Racks', '1010106', '0'),
('1010106007', '', 'Attendence Machine', '1010106', '0'),
('1010107001', '', 'Viscosity Bath', '1010107', '0'),
('1010107002', '', 'Oven', '1010107', '0'),
('1010107003', '', 'Hot Plate', '1010107', '0'),
('1010107004', '', 'Mixer', '1010107', '0'),
('1010107005', '', 'Plannetry Mixer', '1010107', '0'),
('1010107006', '', 'Oil Paint Mixer', '1010107', '0'),
('1010107007', '', 'Attriator Small', '1010107', '0'),
('1010107008', '', 'Mixer', '1010107', '0'),
('1010107009', '', 'Viscosity Cup', '1010107', '0'),
('1010108001', '', 'Computer', '1010108', '0'),
('1010108002', '', 'Printer', '1010108', '0'),
('1010108003', '', 'Scanner', '1010108', '0'),
('1010108004', '', 'Lap Top', '1010108', '0'),
('1010109001', '', 'Ladder', '1010109', '0'),
('1010109002', '', 'Strip Cutter', '1010109', '0'),
('1010109003', '', 'Drum Stand (Roller)', '1010109', '0'),
('1010109004', '', 'Tool Box', '1010109', '0'),
('1010109005', '', 'Trunk - Iron', '1010109', '0'),
('1010109006', '', 'Tarplene', '1010109', '0'),
('1010109007', '', 'Trolley', '1010109', '0'),
('1010109008', '', 'Lap Top', '1010109', '0'),
('1010109009', '', 'Metal Stands', '1010109', '0'),
('1010109010', '', 'Big Ladder Stool', '1010109', '0'),
('1010109011', '', 'Ladder - Wood', '1010109', '0'),
('1010109012', '', 'Ladder - Aluminium', '1010109', '0'),
('1010109013', '', 'LPG Cyiders - Suzuki Ravi', '1010109', '0'),
('1010110001', '', 'Water Storage Tank 1000 L', '1010110', '0'),
('1010110002', '', 'Water Storage Tank 2500 L', '1010110', '0'),
('1010110003', '', 'Storage Tank 4500 ltr - Production', '1010110', '0'),
('1010110004', '', 'Storage Tank 1600 ltr - Production', '1010110', '0'),
('1010110005', '', 'Storage Tank 800 ltr - Production', '1010110', '0'),
('1010110006', '', 'LPG Stotage Tank', '1010110', '0'),
('1010110007', '', 'Steel Vessel 233 L', '1010110', '0'),
('1010110008', '', 'Steel Vessel 275 L', '1010110', '0'),
('1010110009', '', 'Steel Vessel 68 L', '1010110', '0'),
('1010110010', '', 'Steel Vessel 173 L', '1010110', '0'),
('1010110011', '', 'Steel Vessel 78 L', '1010110', '0'),
('1010110012', '', 'Steel Vessel 98 L', '1010110', '0'),
('1010110013', '', 'Steel Vessel 10.4 L', '1010110', '0'),
('1010110014', '', 'Blending Vessel - 150 Ltr', '1010110', '0'),
('1010110015', '', 'Blending Vessel - 100 Ltr', '1010110', '0'),
('1010110016', '', 'Blending Vessel - 1000 Ltr', '1010110', '0'),
('10102001', '', 'Intengeble Fixed Assets ', '10102', '0'),
('10102002', '', 'Intengeble Fixed Assets (In Process)', '10102', '0'),
('1010201001', '', 'TM-Class(4)-716871-Nasa Carb &amp; Throttle', '10105', '0'),
('1010201002', '', 'TM-Class(3)-608303-Body And Co', '10105', '0'),
('1010201003', '', 'CR-2625/2023-Nasa Rusto -Nil', '10105', '0'),
('1010201004', '', 'TM-Class(5)-664290-Chemsol', '10105', '0'),
('1010201005', '', 'CR-2623/2023-nasa carb clean', '10105', '0'),
('1010201006', '', 'TM-Class(4)-664291-Chemsol', '10105', '0'),
('1010201007', '', 'CR-Brake Fluid ', '10105', '0'),
('1010201008', '', 'TM-Class(3)-664291-Chemsol', '10105', '0'),
('1010201009', '', 'TM-Class(25)-678861-Pant-T', '10105', '0'),
('1010201010', '', 'TM-Class(35)-6642932-Chemsol', '10105', '0'),
('1010201011', '', 'TM-Class(4)-664296-MedSol', '10105', '0'),
('1010201012', '', 'TM-Class(2)-664297-MedSol', '10105', '0'),
('1010201013', '', 'TM-Class(1)-664298-MedSol', '10105', '0'),
('1010201014', '', 'TM-Class(5)-664299-Nasa Super Wash', '10105', '0'),
('1010201015', '', 'TM-Class(1)-664305-Nasa Super Wash', '10105', '0'),
('1010201016', '', 'TM-Class(4)-664302-Nasa Super Wash', '10105', '0'),
('1010201017', '', 'TM-Class(2)-664303-Nasa Super Wash', '10105', '0'),
('1010201018', '', 'TM-Class(3)-664304-Nasa Super Wash', '10105', '0'),
('1010201019', '', 'TM-Class(2)-664307-Nasa Power Wash', '10105', '0'),
('1010201020', '', 'TM-Class(5)-664310-Nasa Power Wash', '10105', '0'),
('1010201021', '', 'TM-Class(1)-664306-Nasa Power Wash', '10105', '0'),
('1010201022', '', 'TM-Class(4)-664309-Nasa Power Wash', '10105', '0'),
('1010201023', '', 'TM-Class(3)-665517-Beauty &amp; Co', '10105', '0'),
('1010201024', '', 'TM-Class(3)-664721-AIR MAX', '10105', '0'),
('1010201025', '', 'TM-Class(3)-665514-Pristine', '10105', '0'),
('1010201026', '', 'TM-Class(3)-664717-Skin Essential', '10105', '0'),
('1010201027', '', 'TM-Class(1)-664311-Bogle Industries', '10105', '0'),
('1010201028', '', 'TM-Class(3)-664715-Bogle Industries', '10105', '0'),
('1010201029', '', 'TM-Class(35)-664718-Bogle Industries', '10105', '0'),
('1010201030', '', 'TM-Class(2)-664716-Bogle Industries', '10105', '0'),
('1010201031', '', 'TM-Class(5)-664719-Bogle Industries', '10105', '0'),
('1010201032', '', 'TM-Class(4)-664720-Bogle Industries', '10105', '0'),
('1010201033', '', 'TM-Class(3)-664715-Bogle Industries', '10105', '0'),
('1010201034', '', 'TM-Class(35)-666199-Prime Speciality Chemicals', '10105', '0'),
('1010201035', '', 'TM-Class(3)-664723-Safeen', '10105', '0'),
('1010201036', '', 'TM-Class(3)-665515-Dolive', '10105', '0'),
('1010201037', '', 'TM-Class(3)-594137-Trucleen', '10105', '0'),
('1010201038', '', 'TM-Class(3)-664724-Novel', '10105', '0'),
('1010201039', '', 'TM-Class(4)-634887-Formula Car Scratch', '10105', '0'),
('1010201040', '', 'TM-Class(4)-633852-Formula Car Wax', '10105', '0'),
('1010201041', '', 'TM-Class(4)-634886-Formula Car Polish', '10105', '0'),
('1010202001', '', 'Preliminary Expense ( Boyles Industries)', '1010202', '0'),
('10103001', '', 'Accumulated Depreciation', '10103', '0'),
('10103002', '', 'Accumulated Amortization', '10103', '0'),
('10104001', '', 'CWIP - Office Room HO', '10104', '0'),
('10104002', '', 'CWIP-Up Lift Comstruction Work HUB', '10104', '0'),
('10106001', '', 'Reserves For Imports (Aerosol)', '10106', '0'),
('1020101001', '', 'Cash in Hand-LHR', '1020101', '0'),
('1020101002', '', 'Cash in Hand - HO', '1020101', '0'),
('1020101003', '', 'Cash in Hand - Hyd', '1020101', '0'),
('1020101004', '', 'Cash in Hand - ( HO  Reserved ) ', '1020101', '0'),
('1020101005', '', 'Cash in Hand-HUB', '1020101', '0'),
('1020102001', '', 'Petty Cash - HO', '1020102', '0'),
('1020102002', '', 'Petty Cash - WH', '1020102', '0'),
('1020102003', '', 'Petty Cash - Lhr', '1020102', '0'),
('1020102004', '', 'Petty Cash - Hyd', '1020102', '0'),
('1020102005', '', 'Petty Cash - Hub Factory', '1020102', '0'),
('1020103001', '', 'HBL-Nasa-00477900856003', '1020103', '0'),
('1020103002', '', 'Bank Al Barka', '1020103', '0'),
('1020103003', '', 'Habib Metro Bank', '1020103', '0'),
('1020103004', '', 'Bank Al Habib ', '1020103', '0'),
('1020103005', '', 'Bank Al Barka-001002-77361-019', '1020103', '0'),
('1020201001', '', 'Nasa - Inter Company Loans', '1020201', '0'),
('1020201002', '', 'Prime - Inter Company Loans', '1020201', '0'),
('1020202001', '', 'Loan Staff - Jahangir ', '1020202', '0'),
('1020202002', '', 'Loan Staff - Qaiser Mehmood (Warehouse)', '1020202', '0'),
('1020202003', '', 'Loan Staff - Haji Arif (Lahore)', '1020202', '0'),
('1020202004', '', 'Loan Staff - Rehan Anjum ', '1020202', '0'),
('1020202005', '', 'Loan Staff - Rana Tasawwar (TSO) RWP', '1020202', '0'),
('1020301001', '', 'Accounts Recieveables', '1020301', '0'),
('1020302001', '', 'Fahad Associates - Recieveable', '1020302', '0'),
('1020302002', '', 'Extol Pakistan - Recieveable', '1020302', '0'),
('1020303001', '', 'Green Trading House c/o (Usman Consultant)', '1020303', '0'),
('1020303002', '', 'Kamran Raza (Accountant)', '1020303', '0'),
('1020303003', '', 'Suspense Accounts', '1020303', '0'),
('1020303004', '', 'R Main Technical Engg (Grease Filling Machine)', '1020303', '0'),
('1020303005', '', 'R Main Technical', '1020303', '0'),
('1020303006', '', 'Asad Khan - Sales Person (Khi)', '1020303', '0'),
('1020303007', '', 'Ahmer - Sales Person (Khi)', '1020303', '0'),
('1020303008', '', 'Amir Shiekh - Sales Person (Khi)', '1020303', '0'),
('1020303009', '', 'Danish - Sales Person (Khi)', '1020303', '0'),
('1020303010', '', 'Sajid Khan - Sales Person (Khi)', '1020303', '0'),
('1020303011', '', 'Shakir - Sales Person (Khi)', '1020303', '0'),
('1020303012', '', 'Muhammad Yasir- Sales Person (Khi)', '1020303', '0'),
('1020401001', '', 'Chq In Hand - Security Deposits (Distb)', '1020401', '0'),
('1020402001', '', 'Ocean Express Pakistan Pvt Ltd (Security Deposit)', '1020402', '0'),
('1020402002', '', 'Asharaf Shipping Agency Pvt Ltd', '1020402', '0'),
('1020402003', '', 'Rehmat Shipping Pvt Ltd', '1020402', '0'),
('1020402004', '', 'Pacific Delta Shipping (Pvt.) Ltd', '1020402', '0'),
('1020402005', '', 'OOCL Pakistan (Pvt.) Ltd', '1020402', '0'),
('1020402006', '', 'COSCO Shipping Lines Pakistan (Pvt) LTD', '1020402', '0'),
('1020403001', '', 'Security Deposit - LIEDA', '1020403', '0'),
('1020403002', '', 'Security Deposit - Internet TransWord', '1020403', '0'),
('1020403003', '', 'Security Deposit - Parco Pearl Gas Co', '1020403', '0'),
('1020403004', '', 'Security Deposit - PSO', '1020403', '0'),
('1020403005', '', 'Security Deposit - Rent', '1020403', '0'),
('1020403006', '', 'Security Deposit - SSGC', '1020403', '0'),
('1020403007', '', 'Security Deposit-State Life Ins Rent', '1020403', '0'),
('1020403008', '', 'Security Deposit - Storm Fiber', '1020403', '0'),
('1020403009', '', 'Security Deposit ( Earnest Money  )', '1020403', '0'),
('1020501001', '', 'Advance To Mughees - Expesne', '1020501', '0'),
('1020501002', '', 'Advance to Ammar - Expense', '1020501', '0'),
('1020501003', '', 'Advance to Abrar - Expense', '1020501', '0'),
('1020501004', '', 'Advance to Asad (Hub) - Expense', '1020501', '0'),
('1020501005', '', 'Advance to Saad - Expense', '1020501', '0'),
('1020501006', '', 'Advance To Qaiser (WH) - Expesne', '1020501', '0'),
('1020501007', '', 'Advance to Abdul Rafay - Expenses', '1020501', '0'),
('1020501008', '', 'Advance to Asif (SGD) - Expenses', '1020501', '0'),
('1020502001', '', 'Adv - Azhar Rider (HO)', '1020502', '0'),
('1020502002', '', 'Adv  - Rehan Ali (HO)', '1020502', '0'),
('1020502003', '', 'Adv - Qasier Mehmood (Warehouse)', '1020502', '0'),
('1020502004', '', 'Adv - Nazir Driver (Warehouse)', '1020502', '0'),
('1020502005', '', 'Adv - Dur-e-Shehwar', '1020502', '0'),
('1020502006', '', 'Adv - Madam Shahnaz', '1020502', '0'),
('1020502007', '', 'Adv - Imtaiz Maseeh', '1020502', '0'),
('1020502008', '', 'Adv - Irfan Ali (Hyd)', '1020502', '0'),
('1020502009', '', 'Adv - Shoaib Jan Allah Wala', '1020502', '0'),
('1020502010', '', 'Adv - Ammar Ali (Purchase)', '1020502', '0'),
('1020502011', '', 'Adv - Labor Wokers (HUB)', '1020506', '0'),
('1020502012', '', 'Adv - Imtiaz Maseeh (Accounts)', '1020502', '0'),
('1020502013', '', 'Adv - Sohail Hamza (Corporate)', '1020502', '0'),
('1020503', '', 'Advance Salary - Dilfaraz Driver', '1020503', '0'),
('1020504', '', 'Advance Salary - Sheikh Muhammad Asif Lhr', '1020504', '0'),
('1020504001', '', 'Advance Salary - Abdul Habib Lhr', '1020504', '0'),
('1020504002', '', 'Advance Salary - Haji Arif Lhr', '1020504', '0'),
('1020504003', '', 'Advance Salary - Badar Haroon Lhr', '1020504', '0'),
('1020505', '', 'Advance Salary - Mohsin Driver (WH)', '1020503', '0'),
('1020601001', '', 'WHT - Local Supplies U/S 153 (a)/(b)', '1020601', '0'),
('1020601002', '', 'WHT - Imports U/S 148', '1020601', '0'),
('1020601003', '', 'WHT - Electricity U/S 235', '1020601', '0'),
('1020602001', '', 'WHT - U/S 253 (a)/(b)', '1020602', '0'),
('1020602002', '', 'WHT - U/S 236 ', '1020602', '0'),
('1020602003', '', 'WHT - Telecommunication U/S 236 (PTCL)', '1020602', '0'),
('1020603001', '', 'Advance Tax u/s 147 (Humayoun Sb)', '1020603', '0'),
('1020603002', '', 'Advance Tax u/s 147 (Fahad Sb)', '1020603', '0'),
('1020701001', '', 'Stock In Hand - Raw Material', '10207', '0'),
('1020701002', '', 'Stock In Hand - Stores &amp; Spares', '10207', '0'),
('1020701003', '', 'Stock In Hand - Semi Finished', '10207', '0'),
('1020701004', '', 'Stock In Hand - Finished Goods', '10207', '0'),
('1020701005', '', 'Stock In Hand - Quarantine', '10207', '0'),
('1020701006', '', 'Goods Received Clearing account', '2010102', '0'),
('10208001', '', 'Hydienci Test Charges - Prepaid', '10208', '0'),
('10208002', '', 'Prepaid Expense - Advertisement (Rozee.pk)', '10208', '0'),
('1060', '', 'Checking Account', '102', '0'),
('1065', '', 'Petty Cash', '102', '0'),
('1200', '', 'Accounts Receivables', '102', '0'),
('1205', '', 'Allowance for doubtful accounts', '102', '0'),
('14', '001', 'Telephone Expense 0222720103 - Hyd', '14', '0'),
('1510', '', 'Inventory', '2', '0'),
('1520', '', 'Stocks of Raw Materials', '2', '0'),
('1530', '', 'Stocks of Work In Progress', '2', '0'),
('1540', '', 'Stocks of Finished Goods', '2', '0'),
('1550', '', 'Goods Received Clearing account old', '2', '0'),
('1560', '', 'Quarantine Inventory', '2', '0'),
('1820', '', 'Office Furniture &amp; Equipment', '3', '0'),
('1825', '', 'Accum. Amort. -Furn. &amp; Equip.', '3', '0'),
('1840', '', 'Vehicle', '3', '0'),
('1845', '', 'Accum. Amort. -Vehicle', '3', '0'),
('2010101001', '', 'Vendors Payables.', '2010101', '0'),
('2010102', '', 'Vendors Payables', '20101', '0'),
('2010102001', '', 'State Life Building - Payable', '2010102', '0'),
('2010102002', '', 'Abaseen Securities Pvt Ltd', '2010102', '0'),
('2010102003', '', 'Bank Islami - Leasing Bolan CY 6783', '2010102', '0'),
('2010102004', '', 'Pakistan Telecommunication (PTCL)', '2010102', '0'),
('2010102005', '', 'K Electric ', '2010102', '0'),
('2010102006', '', 'Sui Southern Gas Company (SSGC)', '2010102', '0'),
('2010102007', '', 'Lasbela Electric (LIEDA)', '2010102', '0'),
('2010102008', '', 'Lahore Electric Supply  Company (LESCO)', '2010102', '0'),
('2010102009', '', 'Balochistan Social Security (BESSI)', '2010102', '0'),
('2010102010', '', 'Quality Transport', '2010102', '0'),
('2010102011', '', 'ITecknologi Tracking Services (Pvt.) Ltd', '2010102', '0'),
('2010102012', '', 'Employees Federation of Pakistan', '2010102', '0'),
('2010102013', '', 'Lasbela Industrial Dvelopment Authurity', '2010102', '0'),
('2010102014', '', 'PSO - Fuel Card Payable', '2010102', '0'),
('2010102015', '', 'Storm Fibers ', '2010102', '0'),
('2010102016', '', 'Imran Wood Works', '2010102', '0'),
('2010102017', '', 'Maven PK', '2010102', '0'),
('2010102018', '', 'M Asif &amp; Co ', '2010102', '0'),
('2010102019', '', 'Raza Engineering Works', '2010102', '0'),
('2010102020', '', 'Digitely Systems Pvt Ltd  ( ERP )', '2010102', '0'),
('2010102021', '', 'LIEDA Water Supply Payable', '2010102', '0'),
('2010102022', '', 'Aijaz Hussain (Trade Mark)', '2010102', '0'),
('2010102023', '', 'Employees Old Age Benefits (EOBI)', '2010102', '0'),
('2010103', '', 'Transporters Payables', '20101', '0'),
('2010201001', '', 'Salaries Payable', '2010201', '0'),
('2010201002', '', 'Rent Payable', '2010201', '0'),
('2010201003', '', 'Overtime Payable', '2010201', '0'),
('2010201004', '', 'Commission Payable', '2010201', '0'),
('2010201005', '', 'Conveyance  Expense Payable', '2010201', '0'),
('2010201006', '', 'Vehicle Maintenance Expense Payable', '2010201', '0'),
('2010201007', '', 'Mobile Expense Payable', '2010201', '0'),
('2010201008', '', 'Car Allowance Payable', '2010201', '0'),
('2010201009', '', 'Daily Allownwce Payable', '2010201', '0'),
('2010202001', '', 'Provision For Electricity Expense - HO', '2010202', '0'),
('2010202002', '', 'Provision For Telephone Expense', '2010202', '0'),
('2010301001', '', 'WHT Deducyed U/S 153 payable', '2010301', '0'),
('2010301002', '', 'WHT Deducted U/S 155 Payable', '2010301', '0'),
('2010301003', '', 'Income Tax Payable (Annual)', '2010301', '0'),
('2010301004', '', 'WHT Deducyed  Salary U/S 149 payable', '2010301', '0'),
('2010302001', '', 'Sales Tax Payable', '2010302', '0'),
('2010401001', '', 'Abdul Rafay - SF', '2010401', '0'),
('2010401002', '', 'Abrar Ahmad (Admin) - SF', '2010401', '0'),
('2010401003', '', 'ADEEL SF', '2010401', '0'),
('2010401004', '', ' Ahmer Saleman - Sf', '2010401', '0'),
('2010401005', '', 'Ajmal (Store) - Sf', '2010401', '0'),
('2010401006', '', 'Amir Sheikh Sf Karachi', '2010401', '0'),
('2010401007', '', 'Ammar Sf Karachi', '2010401', '0'),
('2010401008', '', 'Asad Ahmed Khan - Sf', '2010401', '0'),
('2010401009', '', 'Awais Malik Rwp- Sf', '2010401', '0'),
('2010401010', '', 'Azmat Quetta - Sf', '2010401', '0'),
('2010401011', '', 'Danish Saleman - Sf', '2010401', '0'),
('2010401012', '', 'Daniyal Sf Khi', '2010401', '0'),
('2010401013', '', 'Fabashir Rwp- Sf', '2010401', '0'),
('2010401014', '', 'Imtiaz Ali Multan - Sf', '2010401', '0'),
('2010401015', '', 'Ismail Quetta Sf', '2010401', '0'),
('2010401016', '', 'Jahangir Sf', '2010401', '0'),
('2010401017', '', 'Mughees - Sf', '2010401', '0'),
('2010401018', '', 'Muhammad Azhar (Rider) - Sf', '2010401', '0'),
('2010401019', '', 'Muhammad Usman - Sf', '2010401', '0'),
('2010401020', '', 'Muhammad Yousuf - Sf', '2010401', '0'),
('2010401021', '', 'Mukhtiar Ahmad - Sf', '2010401', '0'),
('2010401022', '', 'Nasir Abbas - Sf', '2010401', '0'),
('2010401023', '', 'Rehan Anjum - Sf', '2010401', '0'),
('2010401024', '', 'Saad Mehmood - Sf', '2010401', '0'),
('2010401025', '', 'Sajid Saleman - Sf', '2010401', '0'),
('2010401026', '', 'Shaheer Mazhar - Sf', '2010401', '0'),
('2010401027', '', 'Shakeel Ahmed Qureshi, Rwp S/F', '2010401', '0'),
('2010401028', '', 'Sharif Sf Gilgit', '2010401', '0'),
('2010401029', '', 'Shaukat Ali , Sialkot S.F.', '2010401', '0'),
('2010401030', '', 'Shehnaz Farooqui Sf', '2010401', '0'),
('2010401031', '', 'Zain Uddin - Sf', '2010401', '0'),
('2010401032', '', 'Zeeshan - Sf', '2010401', '0'),
('2010401033', '', 'Abdual Habib - Sf', '2010401', '0'),
('2010401034', '', 'Ajmal (Store) - Sf', '2010401', '0'),
('2010401035', '', ' Amir Naseer - Sf', '2010401', '0'),
('2010401036', '', ' Ammar Ejaz - Sf', '2010401', '0'),
('2010401037', '', 'Badar Haroon - Sf', '2010401', '0'),
('2010401038', '', 'Ch. Asif (Sgd) - Sf', '2010401', '0'),
('2010401039', '', 'Dilfaraz Khan Driver Sf', '2010401', '0'),
('2010401040', '', 'Fahim Ansari (Hyd) - Sf', '2010401', '0'),
('2010401041', '', 'Haji Arif - Sf', '2010401', '0'),
('2010401042', '', 'Ijaz-Ul-Haq (Rwp) - Sf', '2010401', '0'),
('2010401043', '', 'Irfan (Delivery Men) Hyd - Sf', '2010401', '0'),
('2010401044', '', 'Junaid Khan - Sf', '2010401', '0'),
('2010401045', '', 'Mohsin (Store) - Sf', '2010401', '0'),
('2010401046', '', 'Qaiser Mehmood - Sf', '2010401', '0'),
('2010401047', '', 'Shahid (Hyd) Asst. Accountant - Sf', '2010401', '0'),
('2010401048', '', 'Usman Ali - Sf', '2010401', '0'),
('2010401049', '', 'Waseem Sajjad - Lhr Sf', '2010401', '0'),
('2010401050', '', 'Zeeshan Ghafoor Sf', '2010401', '0'),
('2010401051', '', 'Zia Ur Rehman Sf', '2010401', '0'),
('2010401052', '', 'Imtiaz Maseeh SF', '2010401', '0'),
('2010401053', '', 'Shahid Pervaiz SF', '2010401', '0'),
('2010402001', '', 'Abdul Habib Lhr Pf', '2010402', '0'),
('2010402002', '', 'Adil Khan Pf', '2010402', '0'),
('2010402003', '', 'Ahmed Warehous Pf', '2010402', '0'),
('2010402004', '', 'Amir Naseer Pf', '2010402', '0'),
('2010402005', '', 'Ammar Ejaz Lhr Pf', '2010402', '0'),
('2010402006', '', 'Arif Ali Lhr Pf', '2010402', '0'),
('2010402007', '', 'Arif Aziz Pf', '2010402', '0'),
('2010402008', '', 'Asad Mustafa Pf', '2010402', '0'),
('2010402009', '', 'Asghar Driver Hub', '2010402', '0'),
('2010402010', '', 'Asif Sargodha Pf', '2010402', '0'),
('2010402011', '', 'Azghar Driver Pf', '2010402', '0'),
('2010402012', '', 'Badar Haroon Lhr Pf', '2010402', '0'),
('2010402013', '', 'Ch Habib Ahmed Pf', '2010402', '0'),
('2010402014', '', 'Dilfaraz Khan Pf', '2010402', '0'),
('2010402015', '', 'Fahim Ansari Hyd Pf', '2010402', '0'),
('2010402016', '', 'Ghazanfar Ali Pf', '2010402', '0'),
('2010402017', '', 'Gul Raaj Driver Pf', '2010402', '0'),
('2010402018', '', 'Humayoun Fareed Pf', '2010402', '0'),
('2010402019', '', 'Irfan Ali Hyd Pf', '2010402', '0'),
('2010402020', '', 'Junaid A Khan Pf', '2010402', '0'),
('2010402021', '', 'Malik Muhammad Haris Pf', '2010402', '0'),
('2010402022', '', 'Mohsin Anwer Pf', '2010402', '0'),
('2010402023', '', 'Mukaam Khan Pf', '2010402', '0'),
('2010402024', '', 'Nazir Ahmed Pf', '2010402', '0'),
('2010402025', '', 'Qaiser Mehmood Pf', '2010402', '0'),
('2010402026', '', 'Ramzan Sargodha Pf', '2010402', '0'),
('2010402027', '', 'Salman Ahmed Pf', '2010402', '0'),
('2010402028', '', 'Shayan Arshad Pf', '2010402', '0'),
('2010402029', '', 'Syed Shahid Ali Hyd Pf', '2010402', '0'),
('2010402030', '', 'Tahir Pf', '2010402', '0'),
('2010402031', '', 'Tanveer Ashraf Pf', '2010402', '0'),
('2010402032', '', 'Usman Ali Sargodha Pf', '2010402', '0'),
('2010402033', '', 'Waleed Raza Pf', '2010402', '0'),
('2010402034', '', ' Abdul Rafay Pf', '2010402', '0'),
('2010402035', '', 'Ali Raza Pf', '2010402', '0'),
('2010402036', '', 'Amir Malik Pf', '2010402', '0'),
('2010402037', '', 'Amir Naseer Pf', '2010402', '0'),
('2010402038', '', 'Ammar Ali (Procurement) Pf', '2010402', '0'),
('2010402039', '', 'Asad Ahmed Khan Pf', '2010402', '0'),
('2010402040', '', 'Awais Malik Rwp Pf', '2010402', '0'),
('2010402041', '', 'Azhar Hanif Pf', '2010402', '0'),
('2010402042', '', 'Daniyal Pf', '2010402', '0'),
('2010402043', '', 'Dur E Shahwar Pf', '2010402', '0'),
('2010402044', '', 'Fabasshir Rwp Pf', '2010402', '0'),
('2010402045', '', 'Imtiaz Ali Taj Multan Pf', '2010402', '0'),
('2010402046', '', 'Jahangir Pf', '2010402', '0'),
('2010402047', '', 'Junaid A Khan Pf', '2010402', '0'),
('2010402048', '', 'Mughees Ur Rehman Pf', '2010402', '0'),
('2010402049', '', 'Mukhtiyar Ahmed Dg Khan Pf', '2010402', '0'),
('2010402050', '', 'Rehan Ali Anjum Pf', '2010402', '0'),
('2010402051', '', 'Saad Mehmood Pf', '2010402', '0'),
('2010402052', '', 'Sajid Munaf Pf', '2010402', '0'),
('2010402053', '', 'Sameer Khalid Pf', '2010402', '0'),
('2010402054', '', 'Sharif Gilgit Pf', '2010402', '0'),
('2010402055', '', 'Shaukat Ali Sialkot Pf', '2010402', '0'),
('2010402056', '', 'Shoukat Ali Sialkot Pf', '2010402', '0'),
('2010402057', '', 'Umer Abdullah Pf', '2010402', '0'),
('2010402058', '', 'Zeeshan Pf', '2010402', '0'),
('2010402059', '', 'Zia Ur Rehman Pf', '2010402', '0'),
('2010402060', '', 'Shahid Pervaiz PF', '2010402', '0'),
('2010402061', '', 'Abrar Ahmed  (PF)', '2010402', '0'),
('2010402062', '', 'Shehnaz Farooqui PF', '2010402', '0'),
('2010402063', '', 'faraz Siddiqui (TSO Khi )  PF ', '2010402', '0'),
('2010403001', '', 'Shakir Sales Person - Final Settlement', '2010403', '0'),
('2010403002', '', 'Shoaib - Final Settlement', '2010403', '0'),
('2010403003', '', 'Yasir - Final Settlemnet', '2010403', '0'),
('2010403004', '', 'Juniad Khan - Final Settlemnet', '2010403', '0'),
('2010403005', '', 'Zeeshan - Final Settlemnet', '2010403', '0'),
('2010403006', '', 'Ahsun Mehboob ( RWP)  -  Final Settlement ', '2010403', '0'),
('2010403007', '', 'Awais ( RWP)  -  Final Settlement ', '2010403', '0'),
('2010403008', '', 'Zia-UR-Rehman  (Corporate)- Final Settlement', '2010403', '0'),
('2010403009', '', 'Badar Haroon (LHR)- Final Settlement', '2010403', '0'),
('2010403010', '', 'Muhammad Abbas (sawat)- Final Settlement', '2010403', '0'),
('2010403011', '', 'Ahsun  ZSM ( LHR)  -  Final Settlement ', '2010403', '0'),
('2010403012', '', 'Amir Malik ( Khi)  -  Final Settlement', '2010403', '0'),
('2010403013', '', 'Salman Sales Person (KHI) - Final Settlement', '2010403', '0'),
('2010403014', '', 'Saad Mehmood - Final Settlement', '2010403', '0'),
('20105001', '', 'Loan From Directors (Humayoun Sb)', '20105', '0'),
('2100', '', 'Accounts Payable', '201', '0'),
('2105', '', 'Deferred Income', '201', '0'),
('2110', '', 'Accrued Income Tax - Federal', '201', '0'),
('2120', '', 'Accrued Income Tax - State', '201', '0'),
('2130', '', 'Accrued Franchise Tax', '201', '0'),
('2140', '', 'Accrued Real &amp; Personal Prop Tax', '201', '0'),
('2150', '', 'Sales Tax', '201', '0'),
('2160', '', 'Accrued Use Tax Payable', '201', '0'),
('2210', '', 'Accrued Wages', '201', '0'),
('2220', '', 'Accrued Comp Time', '201', '0'),
('2230', '', 'Accrued Holiday Pay', '201', '0'),
('2240', '', 'Accrued Vacation Pay', '201', '0'),
('2310', '', 'Accr. Benefits - 401K', '201', '0'),
('2320', '', 'Accr. Benefits - Stock Purchase', '201', '0'),
('2330', '', 'Accr. Benefits - Med, Den', '201', '0'),
('2340', '', 'Accr. Benefits - Payroll Taxes', '201', '0'),
('2350', '', 'Accr. Benefits - Credit Union', '201', '0'),
('2360', '', 'Accr. Benefits - Savings Bond', '201', '0'),
('2370', '', 'Accr. Benefits - Garnish', '201', '0'),
('2380', '', 'Accr. Benefits - Charity Cont.', '201', '0'),
('2620', '', 'Bank Loans', '202', '0'),
('2680', '', 'Loans from Shareholders', '202', '0'),
('3010002001', '', 'Scrap Sales', '3010002', '0'),
('3010002002', '', 'Sales - Old Drums', '3010002', '0'),
('3010002003', '', 'Gain/Loss on Diposal of Assets', '3010002', '0'),
('3010002004', '', 'Other Income (Misc)', '3010002', '0'),
('3010010001', '', 'Sales Local', '3010001', '0'),
('3010010002', '', 'Sales Discount', '3010001', '0'),
('3010010003', '', 'Sales Imported', '3010001', '0'),
('3010010004', '', 'Sales Commission', '3010001', '0'),
('3010010005', '', 'sales Services', '3010001', '0'),
('302001', '', 'Other Income - Scrap Sales', '302', '0'),
('302002', '', 'Other Income - Old Drums', '9', '0'),
('3350', '', 'Common Shares', '5', '0'),
('3590', '', 'Retained Earnings - prior years', '7', '0'),
('4010', '', 'Sales', '8', '0'),
('40101001', '', 'Cost of Goods Sold - Normal', '40101', '0'),
('40101002', '', 'Factory Overhead Variance', '40101', '0'),
('40101003', '', 'Factory Overhaed Budgeted', '40101', '0'),
('40101004', '', 'Labor Expense Budgeted', '40101', '0'),
('40101005', '', 'Purchase Discount', '40101', '0'),
('40102001', '', 'Purchase Price Variance', '40102', '0'),
('40102002', '', 'Physical Inventory Variance', '40102', '0'),
('40201001', '', 'Toll  Expense  CY 6783 (Bolan) HUB', '40201', '0'),
('40203001', '', 'Repair &amp; Maintenance General - HUB', '40203', '0'),
('40203002', '', 'Repair &amp; Maintenance P &amp; M - HUB', '40203', '0'),
('40203003', '', 'Repair &amp; Maintenance 55 KVA Genset - HUB', '40203', '0'),
('40204001', '', 'Office Maintenance Expense - HUB', '40204', '0'),
('40204002', '', 'Janetorial Expense-HUB', '40204', '0'),
('40204003', '', 'Entertainment Expense - HUB', '40204', '0'),
('40204004', '', 'Drinking Water Expense-HUB', '40204', '0'),
('40204005', '', 'Medical  &amp; Welfare Expense - HUB ', '40204', '0'),
('40204006', '', 'Security Expense LIEDA - HUB', '40204', '0'),
('40205001', '', 'Vehicle Maintenance CY-6783 (Bolan)-HUB', '40205', '0'),
('40207001', '', 'Mobile Expense - HUB', '40207', '0'),
('40207002', '', 'Telephone Expense 0853-364065 - HUB', '40207', '0'),
('40207003', '', 'Telephone Expense 0853-363459 - HUB', '40207', '0'),
('40208001', '', 'Weight Expene - HUB', '40208', '0'),
('40208002', '', 'Cartage Inward - HUB', '40208', '0'),
('40208003', '', 'Labor Expense - HUB', '40208', '0'),
('40209001', '', 'Hygenic Fee Expense - HUB', '40209', '0'),
('40209002', '', 'BESSI Department Expense', '40209', '0'),
('40209003', '', 'EOBI Department Expense', '402', '0'),
('40209004', '', 'Labor Department Expense-HUB', '40209', '0'),
('40209005', '', 'Property y Tax Expense  D79 - D81', '40209', '0'),
('40209006', '', 'Property y Tax Expense  D82', '40209', '0'),
('40209007', '', 'Licence Fees Expense ( Chemical Tanls)', '40209', '0'),
('40210001', '', 'Research &amp; Development Expense  - Sufi Abdul Laltif', '40210', '0'),
('40210002', '', 'Product Research Expenses  - FOH', '40210', '0'),
('40210003', '', 'Product QC Expense  - FOH', '40210', '0'),
('40210004', '', 'Laboratory &amp; Testing Expenses', '40210', '0'),
('40210005', '', 'Printing &amp; Designing Expense - FOH', '40210', '0'),
('40211001', '', 'Safety &amp; Compliance Expense - HUB', '40204', '0'),
('40211002', '', 'LIEDA Water Supply Expense', '40204', '0'),
('40211003', '', 'LIEDA Service Charges Expense', '40204', '0'),
('40211004', '', 'Stationery &amp; Office Supplies Expense - HUB', '40204', '0'),
('40211005', '', 'Security Expense - HUB', '40204', '0'),
('40211006', '', 'Factory Rent Expense  D 82- HUB', '40204', '0'),
('40211007', '', 'Conveyance Expense - HUB', '40204', '0'),
('40211008', '', 'Transportation Expense (Contractor)', '40204', '0'),
('40211009', '', 'Enviornment Health &amp; Safety Expense - FOH', '40204', '0'),
('40212001', '', 'Petrol Expense Bolan CY6783 - HUB', '40212', '0'),
('40213001', '', 'Depriciation  Expense - FOH', '40213', '0'),
('40214001', '', 'Packaging Expense - HUB', '40214', '0'),
('40214002', '', 'Damages Stock Expense - HUB', '40214', '0'),
('40215001', '', 'Salaries Expense - HUB', '40215', '0'),
('40301001', '', 'Social Media Marketing Expenses', '40301', '0'),
('40301002', '', 'Promotional &amp; Marketing Expenses', '40301', '0'),
('40301003', '', 'Marketing Material &amp; Gfts Expenses', '40301', '0'),
('40301004', '', 'Tender Marketing Fee Expense', '40301', '0'),
('40301005', '', 'FOC Samples &amp; Gift Expenses', '40301', '0'),
('40303001', '', 'Commission Expense - Sales Man', '40303', '0'),
('40303002', '', 'Commission Expense - R S M/Executives', '40303', '0'),
('40303003', '', 'Commission Expense - Purchase', '40303', '0'),
('40304001', '', 'Computers Maintenance Expense', '40304', '0'),
('40304002', '', 'Printers Maintenance Expense', '40304', '0'),
('40304003', '', 'IT &amp; Networking Expense', '40304', '0'),
('40305001', '', 'Fuel Allowance Expense - Sales', '40305', '0'),
('40305002', '', 'Car Allowance Expense - Sales', '40305', '0'),
('40305003', '', 'Conveyance Allowance Expense - HO', '40305', '0'),
('40305004', '', 'Car Allowance  Expense - HO', '40305', '0'),
('40306001', '', 'Fuel Card Service Charges Expense', '40306', '0'),
('40306002', '', 'Petrol Expense - Ravi KS-9427', '40306', '0'),
('40306003', '', 'Diesel Expense - Master KQ-0837', '40306', '0'),
('40306004', '', 'Petrol Expense - Bike  2665', '40306', '0'),
('40306005', '', 'Fuel Allowanvce Expense (Inactive Account)', '40306', '1'),
('40307001', '', 'Web Hosting Sevice Charges', '40307', '0'),
('40307002', '', 'Internet Expense ( Stormfiber)', '40307', '0'),
('40308001', '', 'Mobile Expense 0333-0796314 (Asad Hub)', '40207', '0'),
('40308002', '', 'Mobile Expense 0333-0796315 ( Qaiser)', '40308', '0'),
('40308003', '', 'Mobile Expense 0333-0796313  (Imtiaz)', '40308', '0'),
('40308004', '', 'Mobile Expense 0333-0796319  (Ammar)', '40308', '0'),
('40308005', '', 'Mobile Expense 0336-3649965  (Saad)', '40308', '0'),
('40308006', '', 'Mobile Expense 0333-2232638 (Junaid)', '40308', '0'),
('40308007', '', 'Mobile Expense 0333-0796315 (Qaiser WH)', '40308', '1'),
('40308008', '', 'Mobile Expense 0326-3576797 (Mohsin WH)', '40308', '0'),
('40308009', '', 'Mobile Expense 0311-2757340 (Dilfaraz WH)', '40308', '0'),
('40308010', '', 'Mobile Expense 0333-1120195 ', '40308', '0'),
('40308011', '', 'Mobile Expense  (Madam Shahnaz)', '40308', '0'),
('40308012', '', 'Mobile Expense 0336-2334757 (CEO)', '40308', '0'),
('40308013', '', 'Mobile Expense 0345-5465670(Amanullah)', '40308', '0'),
('40308014', '', 'Mobile Allowance Expense Sales Team', '40308', '0'),
('40308015', '', 'Mobile Expense 0300-8433993 (Zia ur Rehman)', '40308', '0'),
('40309001', '', 'Electricity Expense 10056533 - Comm Center', '40309', '0'),
('40309002', '', 'Electricity Expense 35443299 - WH', '40309', '0'),
('40309003', '', 'Electricity Expense LIEDA - HUB', '40206', '0'),
('40309004', '', 'Sui Gas Expense 6187341000 - HUB', '40206', '0'),
('40309005', '', 'Electricity Expense - Hyd', '40309', '0'),
('40309006', '', 'Electricity Expense - Lhr', '40309', '0'),
('40309007', '', 'Electricity Expense - HO State Life', '40309', '0'),
('40310001', '', 'Telephone Expense 32636121 - HO', '14', '0'),
('40310002', '', 'Telephone Expense 32631753 - HO', '14', '0'),
('40310003', '', 'Telephone Expense 32276807 - HO', '14', '0'),
('40310004', '', 'Telephone Expense 32213658 - HO', '14', '0'),
('40310005', '', 'Telephone Expense 32213738 - Comm Center', '14', '0'),
('40310006', '', 'Telephone Expense 35141259 - WH', '14', '0'),
('40310007', '', 'PABX &amp; Telecom Expenses General', '14', '0'),
('40310008', '', 'Telephone Expense 042-3255878 - Lhr', '14', '0'),
('40311001', '', 'Travelling Expense - HO Staff', '40311', '0'),
('40311002', '', 'Travelling Expense - Hyderabad', '40311', '1'),
('40311003', '', 'Travelling Expense - Lahore', '40311', '1'),
('40311004', '', 'Travelling Expense - Sales Team', '40311', '0'),
('40311005', '', 'Travelling Expense - Directors', '40311', '0'),
('40312001', '', 'Vehicle Maintenance Allowance  - Sales ', '40312', '0'),
('40312002', '', 'Vehicle Maintenance - Belta', '40312', '0'),
('40312003', '', 'Vehicle Maintenance Ravi KS-9427', '40312', '0'),
('40312004', '', 'Vehicle Maintenance Master KQ-0837', '40312', '0'),
('40312005', '', 'Vehicle Maintenance Corolla BGL-517', '40312', '0'),
('40312006', '', 'Vehicle Maintenance Bike KFK-2665', '40312', '0'),
('40312007', '', 'Tracking Service Expense - KS 9427 (Ravi)', '40312', '0'),
('40312008', '', 'Vehicle Maintenance Bike LEY-104388 (LHR)', '40312', '0'),
('40312009', '', 'Tracking Service Expense - AWL 484 (Belta)', '40312', '0'),
('40312010', '', 'Tracking Service Expense - BG 4266 (Land Cruiser)', '40312', '0'),
('40312011', '', 'Tracking Service Expense - BNX 553 (Toyota Altis)', '40312', '0'),
('40313001', '', 'Attendence Allowance', '40313', '1'),
('40313002', '', 'Salaries Expense Admin Staff', '40313', '0'),
('40313003', '', 'Overtime Expense', '40313', '0'),
('40313004', '', 'Attendance Allowance Expense', '40313', '0'),
('40313005', '', 'Daily Allowance Expense', '40313', '0'),
('40313006', '', 'Salaries Expense Sales &amp; Distribution Staff', '40313', '0'),
('40313007', '', 'Salaries Expense Marketing Staff', '40313', '0'),
('40314001', '', 'Entertainment Expense', '40314', '0'),
('40314002', '', 'Courier Expenses', '40314', '0'),
('40314003', '', 'Janetorial Expense', '40314', '0'),
('40314004', '', 'Office Maintenance Expense', '40314', '0'),
('40314005', '', 'Stationery &amp; Office Supplies Expense', '40314', '0'),
('40314006', '', 'Security Expense - State Life Building', '40314', '0'),
('40314007', '', 'Zakat Expense', '40314', '0'),
('40314008', '', 'Staff Medical &amp; Walfare Expense', '40314', '0'),
('40314009', '', 'Drinking Water Expense', '40314', '0'),
('40314010', '', 'Fire Extinguisher Expense - HO', '40314', '0'),
('40314011', '', 'Office Generator Expense', '40314', '0'),
('40314012', '', 'Repair &amp; Maintenance - General', '40314', '0'),
('40314013', '', 'Office Rent Expense', '40314', '0'),
('40314014', '', 'Picnic Party &amp; Events Exoenses', '40314', '0'),
('40314015', '', 'Kitchen LPG Gas Expense', '40314', '0'),
('40314016', '', 'Postage &amp; Stamps Expenses', '40314', '0'),
('40314017', '', 'Charity, Donation &amp; Welfare Expense', '40314', '0'),
('40314018', '', 'Warehouse Rent Expense (Mehran Town)', '40314', '0'),
('40314019', '', 'Advertisement Expense ( HR &amp; Admin)', '40314', '0'),
('40314020', '', 'Water Bill Expense (State Life Building)', '40314', '0'),
('40314021', '', 'Trade Marks &amp; Services Expense', '40314', '0'),
('40314022', '', 'Parking Fee Expense - State Life Building', '40314', '0'),
('40314023', '', 'Water&amp; Sewerage Bill Expense - Lhr', '40314', '0'),
('40315001', '', 'Member Ship Fee - KCCI', '40315', '0'),
('40315002', '', 'Member Ship Fee - FPCCI', '40315', '0'),
('40315003', '', 'Membership Fee - Employees Federation', '40315', '0'),
('40315004', '', 'Legal &amp; Consultancy Expense', '40315', '0'),
('40315005', '', 'ISO Certification  (9001 - 2015) - Expense', '40315', '0'),
('40316001', '', 'Cartage Outward Expense', '40316', '0'),
('40316002', '', 'Loading &amp; Unloading Expense', '40208', '0'),
('40316003', '', 'Contractor Labor Fee Expense', '40208', '0'),
('40317001', '', 'Packaging Expenses', '40317', '0'),
('40317002', '', 'Courier &amp; Service Chages COD (Blue Ex)', '40317', '0'),
('40318001', '', 'Internet Expense', '40318', '0'),
('40319001', '', 'Toll Expense - Maste Truck', '40319', '0'),
('40319002', '', 'Toll Expense - Suzuki Ravi', '40319', '0'),
('40319003', '', 'Toll Expense (M Tag Rangers) - Directors', '40319', '0'),
('40320001', '', 'Bilty Expense Outstation Lhr', '40320', '0'),
('40320002', '', 'Bilty Expense Outstation Hyd', '40320', '0'),
('40320003', '', 'Bilty Expense Outstation DG Khan', '40320', '0'),
('40320004', '', 'Bilty Expense Outstation SDQ', '40320', '0'),
('40320005', '', 'Bilty Expense Outstation RYK', '40320', '0'),
('40320006', '', 'Bilty Expense Outstation FSD', '40320', '0'),
('40320007', '', 'Bilty Expense Outstation MLT', '40320', '0'),
('40320008', '', 'Bilty Expense Outstation GGT', '40320', '0'),
('40320009', '', 'Bilty Expense Outstation TTS', '40320', '0'),
('40320010', '', 'Bilty Expense Outstation SGD', '40320', '0'),
('40320011', '', 'Bilty Expense Outstation RWP', '40320', '0'),
('40320012', '', 'Bilty Expense Outstation KSHB', '40320', '0'),
('40320013', '', 'Bilty Expense Outstation SKT', '40320', '0'),
('40320014', '', 'Bilty Expense Outstation BWP', '40320', '0'),
('40320015', '', 'Bilty Expense Outstation MWL', '40320', '0'),
('40320016', '', 'Bilty Expense Outstation -  SKHR', '40320', '0'),
('40320017', '', 'Bilty Expense Outstation -  Bannu', '40320', '0'),
('40320018', '', 'Bilty Expense Outstation -  SWT', '40320', '0'),
('40320019', '', 'Bilty Expense Outstation -  PWR', '40320', '0'),
('40320020', '', 'Bilty Expense Outstation MRDAN', '40320', '0'),
('40320021', '', 'Builty Expense Outstation QTTA', '40320', '0'),
('40321001', '', 'Traffic Police Expense - Master', '40321', '0'),
('40321002', '', 'Traffic Police Expense -  Ravi', '40321', '0'),
('40322001', '', 'Depriciation  Expense ', '40322', '0'),
('40322002', '', 'Amortization Expense', '40322', '0'),
('40323001', '', 'Office Rent Expense - HO', '40323', '0'),
('40323002', '', 'Office Rent Expense - Lhr', '40323', '0'),
('40323003', '', 'Office Rent Expense - Hyd', '40323', '0'),
('40323004', '', 'Office Rent Expense - SGD', '40323', '0'),
('40401001', '', 'Custom Duty Expense', '40401', '0'),
('40401002', '', 'Additional Custom Duty Expense', '40401', '0'),
('40401003', '', 'Port Charges', '40401', '0'),
('40401004', '', 'Delivery Orders  Import Expense', '40401', '0'),
('40401005', '', 'CESS Imports Expense', '40401', '0'),
('40401006', '', 'Sindh Stamp Duty - Import Expense', '40401', '0'),
('40401007', '', 'Sales Tax - Import Expense', '40401', '0'),
('40401008', '', 'Income Tax - Import Expense', '40401', '0'),
('40401009', '', 'Detention Charges - Import Expense', '40401', '0'),
('40401010', '', 'Other Charges - Import Expense', '40401', '0'),
('40401011', '', 'Sea Frieght Charges - Import Expense', '40401', '0'),
('40401012', '', 'Clearing &amp; Service - Import Expense', '40401', '0'),
('40401013', '', 'Insurance Expesne - Imports', '40401', '0'),
('40501001', '', 'Bank Charges', '40501', '0'),
('40501002', '', 'Easy Paisa Charges', '40501', '0'),
('40501003', '', 'Fake Currency Expense', '40501', '0'),
('40501004', '', 'Round Off Difference Expense', '40501', '0'),
('40601001', '', 'Income Tax Expense ( Nasa Chemicals Pvt Ltd )', '40601', '0'),
('40601002', '', 'Income Tax Expense ( Fahad Associates )', '40601', '0'),
('40601003', '', 'Income Tax Expense ( Extol Pakistan )', '40601', '0'),
('4430', '', 'Shipping &amp; Handling', '9', '0'),
('4440', '', 'Interest', '9', '0'),
('4450', '', 'Foreign Exchange Gain', '9', '0'),
('4500', '', 'Prompt Payment Discounts', '9', '0'),
('4510', '', 'Discounts Given', '9', '0'),
('5010', '', 'Cost of Goods Sold - Retail', '401', '0'),
('5010001001', '', 'Paid-up Capital - Huammayon Muhmmad', '5010001', '0'),
('5010001002', '', 'Paid-up Capital - Nighat Perveen', '5010001', '0'),
('5010001003', '', 'Paid-up Capital - Faqir Muhammad', '5010001', '0'),
('5020', '', 'Material Usage Varaiance', '401', '0'),
('5020001001', '', 'Retained Earning', '5020001', '0'),
('5020001002', '', 'Prior Period Adjustments', '5020001', '0'),
('502001', '', 'Current Capital - Humayyon Muhammad', '502', '0'),
('502002', '', 'Current Capital - Mrs Nighat Perveen', '502', '0'),
('5030', '', 'Consumable Materials', '401', '0'),
('5030001001', '', 'Current Capital AC - Hummayon Muhammad', '5030001', '0'),
('5030001002', '', 'Current Capital AC - Ch Faqir Muhammad', '5030001', '0'),
('5030001003', '', 'Current Capital AC - Nighar Parveen', '5030001', '0'),
('5030001004', '', 'Openinga Balances - Account', '5030001', '0'),
('5040', '', 'Purchase price Variance', '401', '0'),
('50401001', '', 'Drawing - Cash (Hummayon Sb)', '5040001', '0'),
('50401002', '', 'Drawing - Electricity Bills', '5040001', '0'),
('50401003', '', 'Drawing - PTCL Bills', '5040001', '0'),
('50401004', '', 'Drawing - Credit Card Payment (HM)', '5040001', '0'),
('50401005', '', 'Drawing - Misc (Hummayon Sb)', '5040001', '0'),
('50401006', '', 'Drawing - SSGS Bills', '5040001', '0'),
('50401007', '', 'Drawing - Internet Expense(Transworld)', '5040001', '0'),
('50401008', '', 'Drawing - Zakat &amp; Charity', '5040001', '0'),
('50401009', '', 'Drawing - Madam Nighat', '5040001', '0'),
('50402001', '', 'Drawing - Credit Card Payment (FH)', '5040002', '0'),
('50402002', '', 'Drawing - Cash (Fahad Sb)', '5040002', '0'),
('50402003', '', 'Drawing - Misc (Fahad Sb)', '5040002', '0'),
('5050', '', 'Purchases of materials', '401', '0'),
('5060', '', 'Discounts Received', '401', '0'),
('5100', '', 'Freight', '401', '0'),
('5410', '', 'Wages &amp; Salaries', '402', '0'),
('5420', '', 'Wages - Overtime', '402', '0'),
('5430', '', 'Benefits - Comp Time', '402', '0'),
('5440', '', 'Benefits - Payroll Taxes', '402', '0'),
('5450', '', 'Benefits - Workers Comp', '402', '0'),
('5460', '', 'Benefits - Pension', '402', '0'),
('5470', '', 'Benefits - General Benefits', '402', '0'),
('5510', '', 'Inc Tax Exp - Federal', '402', '0'),
('5520', '', 'Inc Tax Exp - State', '402', '0'),
('5530', '', 'Taxes - Real Estate', '402', '0'),
('5540', '', 'Taxes - Personal Property', '402', '0'),
('5550', '', 'Taxes - Franchise', '402', '0'),
('5560', '', 'Taxes - Foreign Withholding', '402', '0'),
('5561', '', 'Labour Expense', '402', '0'),
('5562', '', 'Factory Overheads Expense', '402', '0'),
('5610', '', 'Accounting &amp; Legal', '403', '0'),
('5615', '', 'Advertising &amp; Promotions', '403', '0'),
('5620', '', 'Bad Debts', '403', '0'),
('5660', '', 'Amortization Expense', '403', '0'),
('5685', '', 'Cartage Outward', '403', '0'),
('5690', '', 'Interest &amp; Bank Charges', '403', '0'),
('5700', '', 'Office Supplies', '403', '0'),
('5760', '', 'Rent', '403', '0'),
('5765', '', 'Repair &amp; Maintenance', '403', '0'),
('5780', '', 'Telephone', '403', '0'),
('5785', '', 'Travel &amp; Entertainment', '403', '0'),
('5790', '', 'Utilities', '403', '0'),
('5795', '', 'Registrations', '403', '0'),
('5800', '', 'Licenses', '403', '0'),
('5810', '', 'Foreign Exchange Loss', '403', '0'),
('9990', '', 'Year Profit/Loss', '403', '0');

### Structure of table `0_chart_types` ###

DROP TABLE IF EXISTS `0_chart_types`;

CREATE TABLE `0_chart_types` (
  `id` varchar(10) NOT NULL,
  `name` varchar(60) NOT NULL DEFAULT '',
  `class_id` varchar(3) NOT NULL DEFAULT '',
  `parent` varchar(10) NOT NULL DEFAULT '-1',
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `name` (`name`),
  KEY `class_id` (`class_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_chart_types` ###

INSERT INTO `0_chart_types` VALUES
('101', 'Fixed Assets', '1', '', '0'),
('10101', 'Tengible Assets', '1', '101', '0'),
('1010101', 'Plant &amp; Machinery', '1', '10101', '0'),
('1010102', 'Furniture', '1', '10101', '0'),
('1010103', 'Vehicles', '1', '10101', '0'),
('1010104', 'Fixture &amp; Fittings', '1', '10101', '0'),
('1010105', 'Electrical Equipments', '1', '10101', '0'),
('1010106', 'Office Equipments', '1', '10101', '0'),
('1010107', 'Lab Equipments', '1', '10101', '0'),
('1010108', 'Computers &amp; IT Equipments', '1', '10101', '0'),
('1010109', 'Spares &amp; Tools', '1', '10101', '0'),
('10102', 'Intengeble Assets', '1', '101', '0'),
('1010201', 'Trade Mark', '1', '10102', '0'),
('1010202', 'Preliminary Expenses', '1', '101', '0'),
('10103', 'Accumulated Depreciation &amp; Amortization', '1', '101', '0'),
('10104', 'Capital Work in Process (CWIP)', '1', '101', '0'),
('10105', 'Intengeble Fixed Assets (In Process)', '1', '101', '0'),
('10106', 'Reserves &amp; Surplus', '1', '101', '0'),
('102', 'Current Assets', '1', '', '0'),
('10201', 'Cash &amp; Bank', '1', '102', '0'),
('1020101', 'Cash in Hand', '1', '10201', '0'),
('1020102', 'Petty Cash', '1', '10201', '0'),
('1020103', 'Banks', '1', '10201', '0'),
('10202', 'Short Term Loans', '1', '102', '0'),
('1020201', 'Loans - Inter Company ', '1', '10202', '0'),
('1020202', 'Loans - Staff ', '1', '10202', '0'),
('10203', 'Acoounts Recieveables', '1', '102', '0'),
('1020301', 'Accounts Recieveables-Customers', '1', '10203', '0'),
('1020302', 'Accounts Recieveables-Inter Company', '1', '10203', '0'),
('1020303', 'Accounts Recieveables-Others', '1', '10203', '0'),
('10204', 'Securities &amp; Deposits', '1', '102', '0'),
('1020401', 'Securities Distributors ', '1', '10204', '0'),
('1020402', 'Shipping Line Deposits', '1', '10204', '0'),
('1020403', 'Others Security Deposits', '1', '10204', '0'),
('10205', 'Advances - Staff', '1', '102', '0'),
('1020501', 'Advances For Expenses', '1', '10205', '0'),
('1020502', 'Advances - Head Office', '1', '10205', '0'),
('1020503', 'Advances - Warehouse', '1', '10205', '0'),
('1020504', 'Advances - Lahore Branch', '1', '10205', '0'),
('1020505', 'Advances - Hyderabad Branch', '1', '10205', '0'),
('1020506', 'Advances - Hub Factory', '1', '10205', '0'),
('10206', 'Advance Taxes', '1', '102', '0'),
('1020601', 'WHT - Supplies', '1', '10206', '0'),
('1020602', 'WHT - Services', '1', '10206', '0'),
('1020603', 'Advance Tax u/s 147', '1', '10206', '0'),
('10207', 'Stock In Hand', '1', '102', '0'),
('10208', 'Prepaid Expense', '1', '102', '0'),
('14', 'Telephone Expense', '1', '403', '0'),
('2', 'Inventory Assets', '1', '', '0'),
('201', 'Current Liabilities', '2', '', '0'),
('20101', 'Accounts Payables', '2', '201', '0'),
('2010101', 'Vendors Payables', '2', '20101', '0'),
('2010102', 'Others Payables', '2', '20101', '0'),
('20102', 'Accrued Liablities', '2', '201', '0'),
('2010201', 'Accrued Expenses', '2', '20102', '0'),
('2010202', 'Provision For Expenses', '2', '20102', '0'),
('20103', ' Tax Payables Payable', '2', '201', '0'),
('2010301', 'Income tax payable', '2', '20103', '0'),
('2010302', 'Sales Tax Liablity', '2', '20103', '0'),
('20104', 'Employees Funds', '2', '201', '0'),
('2010401', 'Employees Security Funds', '2', '20104', '0'),
('2010402', 'Employees Provident Funds', '2', '20104', '0'),
('2010403', 'Final Settlement Employees Payable', '2', '20104', '0'),
('20105', 'Short Term Loans Payables', '2', '201', '0'),
('202', 'Long Term Liabilities', '2', '', '0'),
('3', 'Income', '3', '', '0'),
('301', 'Sales &amp; Other Income Other Income', '3', '3', '0'),
('3010001', 'Sales Income ', '3', '301', '0'),
('3010002', 'Other Income ', '3', '301', '0'),
('302', 'Other Income', '3', '', '0'),
('401', 'Cost of Goods Sales', '4', '', '0'),
('40101', 'Cost of Goods Sold', '4', '401', '0'),
('40102', 'Purchase &amp; Budgeted Variances', '1', '401', '0'),
('402', 'Factory Overheads', '4', '', '0'),
('40201', 'Toll Expense Vehicles -FOH', '4', '402', '0'),
('40202', 'Salraies &amp; Wages Expense - FOH', '4', '402', '0'),
('40203', 'Repair &amp; Maintenance - FOH', '4', '402', '0'),
('40204', 'Admin &amp; HR EXpense - FOH', '4', '402', '0'),
('40205', 'Vehicle Maintenance - FOH', '4', '402', '0'),
('40206', 'Electricity &amp; Gas Expenses - FOH', '4', '402', '0'),
('40207', 'Telephone Expense - FOH', '4', '402', '0'),
('40208', 'Cartage &amp; Labour Expense  - FOH', '4', '402', '0'),
('40209', 'Legal &amp; Professional Expenses-HUB', '4', '402', '0'),
('40210', 'Research &amp; Development Expense - HUB', '4', '402', '0'),
('40211', 'Safety &amp; Comliance Expense - HUB', '4', '402', '0'),
('40212', 'Petrol &amp; Diesel Expenses - HUB', '4', '402', '0'),
('40213', 'Depriciation &amp; Amortization-HUB', '4', '402', '0'),
('40214', 'Misc Production Expense', '4', '402', '0'),
('40215', 'Salaries &amp; Staff Allowances - HUB', '4', '402', '0'),
('403', 'Operating Expenses', '4', '', '0'),
('40301', 'Advertisement &amp; Marketing Expenses', '4', '403', '0'),
('40302', 'Banks &amp; Financial Expenses', '4', '403', '0'),
('40303', 'Commission &amp; Incebtives Expenses', '4', '403', '0'),
('40304', 'Computers &amp; Printers Maintenance Expenses', '4', '403', '0'),
('40305', 'Conveyance Allowances &amp; Expenses', '4', '403', '0'),
('40306', 'Petrol &amp; Diesel Expenses', '4', '403', '0'),
('40307', 'Internet, Networking &amp; IT Expenses', '4', '403', '0'),
('40308', 'Mobile Expenses', '4', '403', '0'),
('40309', 'Electricity &amp; Gas Expenses', '4', '403', '0'),
('40310', 'Telephone Landline Expense', '4', '403', '0'),
('40311', 'Travelling Expense', '4', '403', '0'),
('40312', 'Vehicle Repair &amp; Maintenance', '4', '403', '0'),
('40313', 'Salaries &amp; Staff Allowances', '4', '403', '0'),
('40314', 'Admin &amp; Office Expense', '4', '403', '0'),
('40315', 'Legal, Consultancy &amp; Membership Expenses', '4', '403', '0'),
('40316', 'Cartage &amp; Labor Expenses', '4', '403', '0'),
('40317', 'Others Selling Expenses', '4', '403', '0'),
('40318', 'Internet &amp; Networking Expense', '4', '403', '0'),
('40319', 'Toll Expense Vehicles', '4', '403', '0'),
('40320', 'Builty Expense Outstation', '4', '403', '0'),
('40321', 'Traffic :Police &amp; Challan Expense', '4', '403', '0'),
('40322', 'Depriciation &amp; Amortization', '4', '403', '0'),
('40323', 'Office Rent Expense', '4', '403', '0'),
('404', 'Import &amp; Clearing Expenses', '4', '', '0'),
('40401', 'Import Expenses', '4', '404', '0'),
('405', '   Financial Charges', '4', '', '0'),
('40501', 'Bank Charges &amp; Easypaisa Charges', '4', '405', '0'),
('40601', 'Taxes Expense', '4', '403', '0'),
('5', 'Capital &amp; Equity', '5', '', '0'),
('501', 'Share Capital', '5', '', '0'),
('5010001', 'Paid-up Capital', '5', '501', '0'),
('502', 'Retained Earning', '5', '', '0'),
('5020001', 'Retained Earning - Share Holders', '5', '502', '0'),
('503', 'Capital Current Account', '5', '', '0'),
('5030001', 'Current Capital Account-Share Holders', '5', '503', '0'),
('504', 'Drawing', '5', '', '0'),
('5040001', 'Drawing - Hummayon Sb', '5', '504', '0'),
('5040002', 'Drawing - Fahad Sb', '5', '504', '0'),
('7', 'Retained Earnings', '2', '', '0'),
('8', 'Sales Revenue', '3', '', '0'),
('9', 'Other Revenue', '3', '', '0');

### Structure of table `0_city` ###

DROP TABLE IF EXISTS `0_city`;

CREATE TABLE `0_city` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `inactive` tinyint(4) DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=43 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_city` ###

INSERT INTO `0_city` VALUES
('1', 'Karachi', '0'),
('2', 'Hyderabad', '0'),
('3', 'Lahore', '0'),
('12', 'Rawalpindi', '0'),
('13', 'Quetta', '0'),
('14', 'Gilgit', '0'),
('15', 'Peshawar', '0'),
('16', 'Gujranwala', '0'),
('17', 'Faisalabad', '0'),
('18', 'Chakwal', '0'),
('19', 'Sukkur', '0'),
('20', 'Rahim Yar Khan', '0'),
('21', 'Sadiq Abad', '0'),
('22', 'Multan', '0'),
('23', 'Dera Ghazi Khan (DG)', '0'),
('24', 'Dera Ismail Khan ( DI Khan)', '0'),
('25', 'Layyah', '0'),
('26', 'Khushab', '0'),
('27', 'Sialkot', '0'),
('28', 'Sargodha', '0'),
('29', 'Khanewal', '0'),
('30', 'Muzaffarabad', '0'),
('31', 'Sahiwal', '0'),
('32', 'Toba Tek Singh', '0'),
('33', 'Jampur', '0'),
('34', 'Others', '0'),
('35', 'Mianwali', '0'),
('36', 'Bahawalpur', '0'),
('37', 'Islamabad', '0'),
('38', 'Swat', '0'),
('39', 'Bannu', '0'),
('40', 'Abbotabad', '0'),
('41', 'Vehari', '0'),
('42', 'Jhelum', '0');

### Structure of table `0_comments` ###

DROP TABLE IF EXISTS `0_comments`;

CREATE TABLE `0_comments` (
  `type` int(11) NOT NULL DEFAULT 0,
  `id` int(11) NOT NULL DEFAULT 0,
  `date_` date DEFAULT '0000-00-00',
  `memo_` tinytext DEFAULT NULL,
  KEY `type_and_id` (`type`,`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_comments` ###


### Structure of table `0_credit_status` ###

DROP TABLE IF EXISTS `0_credit_status`;

CREATE TABLE `0_credit_status` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reason_description` char(100) NOT NULL DEFAULT '',
  `dissallow_invoices` tinyint(1) NOT NULL DEFAULT 0,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `reason_description` (`reason_description`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_credit_status` ###

INSERT INTO `0_credit_status` VALUES
('1', 'Good History', '0', '0'),
('3', 'No more work until payment received', '1', '0'),
('4', 'In liquidation', '1', '0');

### Structure of table `0_crm_categories` ###

DROP TABLE IF EXISTS `0_crm_categories`;

CREATE TABLE `0_crm_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'pure technical key',
  `type` varchar(20) NOT NULL COMMENT 'contact type e.g. customer',
  `action` varchar(20) NOT NULL COMMENT 'detailed usage e.g. department',
  `name` varchar(30) NOT NULL COMMENT 'for category selector',
  `description` tinytext NOT NULL COMMENT 'usage description',
  `system` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'nonzero for core system usage',
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `type` (`type`,`action`),
  UNIQUE KEY `type_2` (`type`,`name`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_crm_categories` ###

INSERT INTO `0_crm_categories` VALUES
('1', 'cust_branch', 'general', 'General', 'General contact data for customer branch (overrides company setting)', '1', '0'),
('2', 'cust_branch', 'invoice', 'Invoices', 'Invoice posting (overrides company setting)', '1', '0'),
('3', 'cust_branch', 'order', 'Orders', 'Order confirmation (overrides company setting)', '1', '0'),
('4', 'cust_branch', 'delivery', 'Deliveries', 'Delivery coordination (overrides company setting)', '1', '0'),
('5', 'customer', 'general', 'General', 'General contact data for customer', '1', '0'),
('6', 'customer', 'order', 'Orders', 'Order confirmation', '1', '0'),
('7', 'customer', 'delivery', 'Deliveries', 'Delivery coordination', '1', '0'),
('8', 'customer', 'invoice', 'Invoices', 'Invoice posting', '1', '0'),
('9', 'supplier', 'general', 'General', 'General contact data for supplier', '1', '0'),
('10', 'supplier', 'order', 'Orders', 'Order confirmation', '1', '0'),
('11', 'supplier', 'delivery', 'Deliveries', 'Delivery coordination', '1', '0'),
('12', 'supplier', 'invoice', 'Invoices', 'Invoice posting', '1', '0');

### Structure of table `0_crm_contacts` ###

DROP TABLE IF EXISTS `0_crm_contacts`;

CREATE TABLE `0_crm_contacts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `person_id` int(11) NOT NULL DEFAULT 0 COMMENT 'foreign key to crm_persons',
  `type` varchar(20) NOT NULL COMMENT 'foreign key to crm_categories',
  `action` varchar(20) NOT NULL COMMENT 'foreign key to crm_categories',
  `entity_id` varchar(11) DEFAULT NULL COMMENT 'entity id in related class table',
  PRIMARY KEY (`id`),
  KEY `type` (`type`,`action`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_crm_contacts` ###

INSERT INTO `0_crm_contacts` VALUES
('1', '1', 'cust_branch', 'general', '1'),
('2', '1', 'customer', 'general', '1'),
('3', '2', 'cust_branch', 'general', '2'),
('4', '3', 'supplier', 'general', '1');

### Structure of table `0_crm_persons` ###

DROP TABLE IF EXISTS `0_crm_persons`;

CREATE TABLE `0_crm_persons` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ref` varchar(100) NOT NULL,
  `name` varchar(100) NOT NULL,
  `name2` varchar(60) DEFAULT NULL,
  `address` tinytext DEFAULT NULL,
  `phone` varchar(30) DEFAULT NULL,
  `phone2` varchar(30) DEFAULT NULL,
  `fax` varchar(30) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `lang` char(5) DEFAULT NULL,
  `notes` tinytext DEFAULT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `ref` (`ref`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_crm_persons` ###

INSERT INTO `0_crm_persons` VALUES
('1', 'CN-001', 'NFK INDUSTRIES', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('2', '', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('3', 'V-001', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0');

### Structure of table `0_currencies` ###

DROP TABLE IF EXISTS `0_currencies`;

CREATE TABLE `0_currencies` (
  `currency` varchar(60) NOT NULL DEFAULT '',
  `curr_abrev` char(3) NOT NULL DEFAULT '',
  `curr_symbol` varchar(10) NOT NULL DEFAULT '',
  `country` varchar(100) NOT NULL DEFAULT '',
  `hundreds_name` varchar(15) NOT NULL DEFAULT '',
  `auto_update` tinyint(1) NOT NULL DEFAULT 1,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`curr_abrev`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_currencies` ###

INSERT INTO `0_currencies` VALUES
('CA Dollars', 'CAD', '$', 'Canada', 'Cents', '1', '0'),
('Euro', 'EUR', '€', 'Europe', 'Cents', '1', '0'),
('Pounds', 'GBP', '£', 'England', 'Pence', '1', '0'),
('Rupee', 'PKR', 'Rs', 'Pakistan', 'Rupees', '1', '0'),
('US Dollars', 'USD', '$', 'United States', 'Cents', '1', '0');

### Structure of table `0_cust_allocations` ###

DROP TABLE IF EXISTS `0_cust_allocations`;

CREATE TABLE `0_cust_allocations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `person_id` int(11) DEFAULT NULL,
  `amt` double unsigned DEFAULT NULL,
  `date_alloc` date NOT NULL DEFAULT '0000-00-00',
  `trans_no_from` int(11) DEFAULT NULL,
  `trans_type_from` int(11) DEFAULT NULL,
  `trans_no_to` int(11) DEFAULT NULL,
  `trans_type_to` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `trans_type_from` (`person_id`,`trans_type_from`,`trans_no_from`,`trans_type_to`,`trans_no_to`),
  KEY `From` (`trans_type_from`,`trans_no_from`),
  KEY `To` (`trans_type_to`,`trans_no_to`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_cust_allocations` ###


### Structure of table `0_cust_branch` ###

DROP TABLE IF EXISTS `0_cust_branch`;

CREATE TABLE `0_cust_branch` (
  `branch_code` int(11) NOT NULL AUTO_INCREMENT,
  `debtor_no` int(11) NOT NULL DEFAULT 0,
  `br_name` varchar(100) NOT NULL DEFAULT '',
  `branch_ref` varchar(100) NOT NULL DEFAULT '',
  `br_address` tinytext NOT NULL,
  `area` int(11) DEFAULT NULL,
  `salesman` int(11) NOT NULL DEFAULT 0,
  `default_location` varchar(5) NOT NULL DEFAULT '',
  `tax_group_id` int(11) DEFAULT NULL,
  `sales_account` varchar(15) NOT NULL DEFAULT '',
  `sales_discount_account` varchar(15) NOT NULL DEFAULT '',
  `receivables_account` varchar(15) NOT NULL DEFAULT '',
  `payment_discount_account` varchar(15) NOT NULL DEFAULT '',
  `default_ship_via` int(11) NOT NULL DEFAULT 1,
  `br_post_address` tinytext NOT NULL,
  `group_no` int(11) NOT NULL DEFAULT 0,
  `notes` tinytext NOT NULL,
  `bank_account` varchar(60) DEFAULT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`branch_code`,`debtor_no`),
  KEY `branch_ref` (`branch_ref`),
  KEY `group_no` (`group_no`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_cust_branch` ###

INSERT INTO `0_cust_branch` VALUES
('1', '1', 'NFK INDUSTRIES', 'CN-001', '', '385', '3', 'DEF', '3', '', '3010010002', '1020301001', '3010010002', '1', '', '0', '', NULL, '0'),
('2', '1', 'NKF IND SRB', 'NKF IND SRB', '', '385', '3', 'DEF', '4', '', '3010010002', '1020301001', '3010010002', '1', '', '1', '', NULL, '0');

### Structure of table `0_debtor_trans` ###

DROP TABLE IF EXISTS `0_debtor_trans`;

CREATE TABLE `0_debtor_trans` (
  `trans_no` int(11) unsigned NOT NULL DEFAULT 0,
  `type` smallint(6) unsigned NOT NULL DEFAULT 0,
  `version` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `debtor_no` int(11) unsigned NOT NULL,
  `branch_code` int(11) NOT NULL DEFAULT -1,
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `due_date` date NOT NULL DEFAULT '0000-00-00',
  `reference` varchar(60) NOT NULL DEFAULT '',
  `tpe` int(11) NOT NULL DEFAULT 0,
  `order_` int(11) NOT NULL DEFAULT 0,
  `ov_amount` double NOT NULL DEFAULT 0,
  `ov_gst` double NOT NULL DEFAULT 0,
  `ov_freight` double NOT NULL DEFAULT 0,
  `ov_freight_tax` double NOT NULL DEFAULT 0,
  `ov_discount` double NOT NULL DEFAULT 0,
  `alloc` double NOT NULL DEFAULT 0,
  `prep_amount` double NOT NULL DEFAULT 0,
  `rate` double NOT NULL DEFAULT 1,
  `ship_via` int(11) DEFAULT NULL,
  `dimension_id` int(11) NOT NULL DEFAULT 0,
  `dimension2_id` int(11) NOT NULL DEFAULT 0,
  `sales_person` int(11) NOT NULL DEFAULT 0,
  `payment_terms` int(11) DEFAULT NULL,
  `tax_included` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `vehicle_no` varchar(100) DEFAULT NULL,
  `file_system` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`type`,`trans_no`,`debtor_no`),
  KEY `debtor_no` (`debtor_no`,`branch_code`),
  KEY `tran_date` (`tran_date`),
  KEY `order_` (`order_`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_debtor_trans` ###


### Structure of table `0_debtor_trans_details` ###

DROP TABLE IF EXISTS `0_debtor_trans_details`;

CREATE TABLE `0_debtor_trans_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `debtor_trans_no` int(11) DEFAULT NULL,
  `debtor_trans_type` int(11) DEFAULT NULL,
  `stock_id` varchar(20) NOT NULL DEFAULT '',
  `batch_no` varchar(30) NOT NULL,
  `exp_date` date NOT NULL,
  `description` tinytext DEFAULT NULL,
  `unit_price` double NOT NULL DEFAULT 0,
  `unit_tax` double NOT NULL DEFAULT 0,
  `quantity` double NOT NULL DEFAULT 0,
  `discount_percent` double NOT NULL DEFAULT 0,
  `standard_cost` double NOT NULL DEFAULT 0,
  `qty_done` double NOT NULL DEFAULT 0,
  `src_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `Transaction` (`debtor_trans_type`,`debtor_trans_no`),
  KEY `src_id` (`src_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_debtor_trans_details` ###


### Structure of table `0_debtors_master` ###

DROP TABLE IF EXISTS `0_debtors_master`;

CREATE TABLE `0_debtors_master` (
  `debtor_no` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL DEFAULT '',
  `debtor_ref` varchar(100) NOT NULL,
  `address` tinytext DEFAULT NULL,
  `tax_id` varchar(55) NOT NULL DEFAULT '',
  `trn_id` varchar(60) NOT NULL,
  `curr_code` char(3) NOT NULL DEFAULT '',
  `sales_type` int(11) NOT NULL DEFAULT 1,
  `dimension_id` int(11) NOT NULL DEFAULT 0,
  `dimension2_id` int(11) NOT NULL DEFAULT 0,
  `credit_status` int(11) NOT NULL DEFAULT 0,
  `payment_terms` int(11) DEFAULT NULL,
  `discount` double NOT NULL DEFAULT 0,
  `pymt_discount` double NOT NULL DEFAULT 0,
  `credit_limit` float NOT NULL DEFAULT 1000,
  `notes` tinytext DEFAULT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  `user_id` int(11) NOT NULL DEFAULT 0,
  `city_id` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`debtor_no`),
  UNIQUE KEY `debtor_ref` (`debtor_ref`),
  KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_debtors_master` ###

INSERT INTO `0_debtors_master` VALUES
('1', 'NFK INDUSTRIES', 'CN-001', NULL, '', '', 'PKR', '4', '0', '0', '1', '6', '0', '0', '0', NULL, '0', '0', '1');

### Structure of table `0_dimensions` ###

DROP TABLE IF EXISTS `0_dimensions`;

CREATE TABLE `0_dimensions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reference` varchar(60) NOT NULL DEFAULT '',
  `name` varchar(60) NOT NULL DEFAULT '',
  `type_` tinyint(1) NOT NULL DEFAULT 1,
  `closed` tinyint(1) NOT NULL DEFAULT 0,
  `date_` date NOT NULL DEFAULT '0000-00-00',
  `due_date` date NOT NULL DEFAULT '0000-00-00',
  `dimension_id` int(11) DEFAULT NULL COMMENT 'dimension_id is sub id of dimension l..',
  PRIMARY KEY (`id`),
  UNIQUE KEY `reference` (`reference`),
  KEY `date_` (`date_`),
  KEY `due_date` (`due_date`),
  KEY `type_` (`type_`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_dimensions` ###

INSERT INTO `0_dimensions` VALUES
('1', 'CC/001/2024', 'MARTINDOW ', '1', '0', '2022-01-01', '2024-03-15', '0'),
('2', 'CC/002/2024', 'NFK', '1', '0', '2022-02-01', '2024-03-15', '0');

### Structure of table `0_exchange_rates` ###

DROP TABLE IF EXISTS `0_exchange_rates`;

CREATE TABLE `0_exchange_rates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `curr_code` char(3) NOT NULL DEFAULT '',
  `rate_buy` double NOT NULL DEFAULT 0,
  `rate_sell` double NOT NULL DEFAULT 0,
  `date_` date NOT NULL DEFAULT '0000-00-00',
  PRIMARY KEY (`id`),
  UNIQUE KEY `curr_code` (`curr_code`,`date_`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_exchange_rates` ###

INSERT INTO `0_exchange_rates` VALUES
('11', 'USD', '272', '272', '2023-02-01'),
('12', 'USD', '265.664', '265.664', '2023-02-25'),
('13', 'USD', '262.417', '262.417', '2023-03-09'),
('14', 'USD', '262.417', '262.417', '2023-07-07'),
('15', 'USD', '262.42', '262.42', '2023-10-21'),
('16', 'USD', '302.789', '302.789', '2023-10-18'),
('17', 'USD', '306.366', '306.366', '2023-11-08'),
('18', 'USD', '306.366', '306.366', '2023-12-04');

### Structure of table `0_file_system` ###

DROP TABLE IF EXISTS `0_file_system`;

CREATE TABLE `0_file_system` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date_` date NOT NULL,
  `reference` varchar(225) NOT NULL,
  `name` varchar(225) NOT NULL,
  `description` varchar(3000) NOT NULL,
  `inactive` tinyint(4) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_file_system` ###

INSERT INTO `0_file_system` VALUES
('1', '2024-02-07', '001/2024', 'Default', 'Default', '0'),
('4', '2024-02-07', '002/2024', 'ABC-121-BF', 'ABC-121-BF', '0');

### Structure of table `0_fiscal_year` ###

DROP TABLE IF EXISTS `0_fiscal_year`;

CREATE TABLE `0_fiscal_year` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `begin` date DEFAULT '0000-00-00',
  `end` date DEFAULT '0000-00-00',
  `closed` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `begin` (`begin`),
  UNIQUE KEY `end` (`end`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_fiscal_year` ###

INSERT INTO `0_fiscal_year` VALUES
('4', '2022-07-01', '2023-07-31', '0'),
('6', '2023-08-01', '2024-06-30', '0');

### Structure of table `0_gate_pass` ###

DROP TABLE IF EXISTS `0_gate_pass`;

CREATE TABLE `0_gate_pass` (
  `trans_no` int(11) NOT NULL AUTO_INCREMENT,
  `type` smallint(6) NOT NULL,
  `debtor_no` int(11) NOT NULL,
  `branch_code` int(11) NOT NULL DEFAULT -1,
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `due_date` date NOT NULL DEFAULT '0000-00-00',
  `reference` varchar(60) NOT NULL DEFAULT '',
  `tpe` int(11) NOT NULL DEFAULT 0,
  `order_` int(11) NOT NULL DEFAULT 0,
  `ov_amount` double NOT NULL DEFAULT 0,
  `ov_discount` double NOT NULL DEFAULT 0,
  `ov_gst` double NOT NULL DEFAULT 0,
  `ov_freight` double NOT NULL DEFAULT 0,
  `ov_freight_tax` double NOT NULL DEFAULT 0,
  `rate` double NOT NULL DEFAULT 1,
  `ship_via` int(11) DEFAULT NULL,
  `alloc` int(11) NOT NULL,
  `dimension_id` int(11) NOT NULL DEFAULT 0,
  `dimension2_id` int(11) NOT NULL DEFAULT 0,
  `payment_terms` int(11) NOT NULL,
  `tax_included` tinyint(4) NOT NULL DEFAULT 0,
  `prep_amount` double DEFAULT NULL,
  `sales_person` int(11) NOT NULL DEFAULT 0,
  `vehicle_no` varchar(100) DEFAULT NULL,
  `file_system` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`trans_no`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_gate_pass` ###

INSERT INTO `0_gate_pass` VALUES
('2', '33', '1', '1', '2024-02-09', '2024-02-10', 'GP/002/2024', '4', '3', '0', '0', '74.8', '0', '0', '1', '1', '0', '0', '0', '1', '0', '0', '3', 'RST-987', '1'),
('3', '33', '1', '1', '2024-02-09', '2024-02-10', 'GP/003/2024', '4', '4', '0', '0', '37.4', '0', '0', '1', '1', '0', '0', '0', '1', '0', '0', '3', 'RST-987', '1'),
('4', '33', '1', '1', '2024-02-09', '2024-02-10', 'GP/004/2024', '4', '4', '0', '0', '243.1', '0', '0', '1', '1', '0', '0', '0', '1', '0', '0', '3', 'STU-963', '1'),
('6', '33', '1', '1', '2024-02-09', '2024-02-10', 'GP/006/2024', '4', '5', '0', '0', '34', '0', '0', '1', '1', '0', '0', '0', '1', '0', '0', '3', NULL, '1'),
('7', '33', '1', '1', '2024-02-09', '2024-02-10', 'GP/007/2024', '4', '5', '0', '0', '34', '0', '0', '1', '1', '0', '0', '0', '1', '0', '0', '3', NULL, '1'),
('8', '33', '1', '1', '2024-02-09', '2024-02-10', 'GP/008/2024', '4', '5', '0', '0', '34', '0', '0', '1', '1', '0', '0', '0', '1', '0', '0', '3', NULL, '1');

### Structure of table `0_gate_pass_details` ###

DROP TABLE IF EXISTS `0_gate_pass_details`;

CREATE TABLE `0_gate_pass_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `gate_pass_id` int(11) NOT NULL,
  `type` int(11) NOT NULL,
  `stock_id` varchar(20) NOT NULL DEFAULT '',
  `description` varchar(400) NOT NULL,
  `quantity` double NOT NULL DEFAULT 0,
  `unit_price` double NOT NULL DEFAULT 0,
  `unit_tax` double NOT NULL DEFAULT 0,
  `discount_percent` double NOT NULL DEFAULT 0,
  `standard_cost` double NOT NULL DEFAULT 0,
  `src_id` int(11) NOT NULL,
  `batch_no` varchar(30) NOT NULL DEFAULT '',
  `exp_date` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_gate_pass_details` ###

INSERT INTO `0_gate_pass_details` VALUES
('2', '2', '33', 'RM-001', 'New Item', '2', '220', '37.4', '0', '120', '6', 'IA/002/2024', '2024-02-09'),
('3', '3', '33', 'RM-001', 'New Item', '2', '110', '18.7', '0', '120', '7', 'GRN/001/2024', '2024-02-09'),
('4', '4', '33', 'RM-001', 'New Item', '13', '110', '18.7', '0', '120', '7', 'IA/002/2024', '2024-02-09'),
('6', '6', '33', 'RM-001', 'New Item', '2', '100', '17', '0', '120', '8', 'GRN/001/2024', '2024-02-09'),
('7', '7', '33', 'RM-001', 'New Item', '2', '100', '17', '0', '120', '8', 'GRN/001/2024', '2024-02-09'),
('8', '8', '33', 'RM-001', 'New Item', '2', '100', '17', '0', '120', '8', 'GRN/001/2024', '2024-02-09');

### Structure of table `0_gl_trans` ###

DROP TABLE IF EXISTS `0_gl_trans`;

CREATE TABLE `0_gl_trans` (
  `counter` int(11) NOT NULL AUTO_INCREMENT,
  `type` smallint(6) NOT NULL DEFAULT 0,
  `type_no` int(11) NOT NULL DEFAULT 0,
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `account` varchar(15) NOT NULL DEFAULT '',
  `memo_` tinytext NOT NULL,
  `amount` double NOT NULL DEFAULT 0,
  `dimension_id` int(11) NOT NULL DEFAULT 0,
  `dimension2_id` int(11) NOT NULL DEFAULT 0,
  `person_type_id` int(11) DEFAULT NULL,
  `person_id` tinyblob DEFAULT NULL,
  `file_system` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`counter`),
  KEY `Type_and_Number` (`type`,`type_no`),
  KEY `dimension_id` (`dimension_id`),
  KEY `dimension2_id` (`dimension2_id`),
  KEY `tran_date` (`tran_date`),
  KEY `account_and_tran_date` (`account`,`tran_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_gl_trans` ###


### Structure of table `0_grn_batch` ###

DROP TABLE IF EXISTS `0_grn_batch`;

CREATE TABLE `0_grn_batch` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `supplier_id` int(11) NOT NULL DEFAULT 0,
  `purch_order_no` int(11) DEFAULT NULL,
  `reference` varchar(60) NOT NULL DEFAULT '',
  `delivery_date` date NOT NULL DEFAULT '0000-00-00',
  `loc_code` varchar(5) DEFAULT NULL,
  `rate` double DEFAULT 1,
  `dc_no` varchar(20) NOT NULL DEFAULT '0',
  `vehicle_no` varchar(100) NOT NULL,
  `tax_group_id` int(11) NOT NULL,
  `dimension_id` int(11) NOT NULL,
  `dimension2_id` int(11) NOT NULL,
  `file_system` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `delivery_date` (`delivery_date`),
  KEY `purch_order_no` (`purch_order_no`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_grn_batch` ###


### Structure of table `0_grn_items` ###

DROP TABLE IF EXISTS `0_grn_items`;

CREATE TABLE `0_grn_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `grn_batch_id` int(11) DEFAULT NULL,
  `po_detail_item` int(11) NOT NULL DEFAULT 0,
  `item_code` varchar(20) NOT NULL DEFAULT '',
  `batch_no` varchar(30) NOT NULL,
  `exp_date` date DEFAULT NULL,
  `pack_size` double NOT NULL,
  `pack_unit` varchar(15) NOT NULL,
  `no_of_pack` double NOT NULL,
  `description` tinytext DEFAULT NULL,
  `qty_recd` double NOT NULL DEFAULT 0,
  `quantity_inv` double NOT NULL DEFAULT 0,
  `dim_line` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `grn_batch_id` (`grn_batch_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_grn_items` ###


### Structure of table `0_groups` ###

DROP TABLE IF EXISTS `0_groups`;

CREATE TABLE `0_groups` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(60) NOT NULL DEFAULT '',
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `description` (`description`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_groups` ###

INSERT INTO `0_groups` VALUES
('1', 'Karachi', '0');

### Structure of table `0_inward_grn` ###

DROP TABLE IF EXISTS `0_inward_grn`;

CREATE TABLE `0_inward_grn` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` int(11) NOT NULL,
  `order_no` int(11) NOT NULL,
  `po_line_id` int(11) NOT NULL,
  `ord_date` date NOT NULL DEFAULT '0000-00-00',
  `qty` double NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3148 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ;

### Data of table `0_inward_grn` ###

INSERT INTO `0_inward_grn` VALUES
('1', '47', '1', '1', '2023-02-06', '30'),
('2', '47', '1', '2', '2023-02-06', '75'),
('3', '47', '1', '3', '2023-02-06', '50'),
('4', '47', '1', '4', '2023-02-06', '75'),
('5', '47', '1', '5', '2023-02-06', '25'),
('6', '47', '2', '6', '2023-02-07', '615'),
('7', '47', '7', '15', '2023-02-08', '2700'),
('8', '47', '8', '16', '2023-02-08', '2700'),
('9', '47', '9', '17', '2023-02-09', '12'),
('10', '45', '1', '1', '2023-02-14', '30'),
('11', '45', '1', '2', '2023-02-14', '75'),
('12', '45', '1', '3', '2023-02-14', '50'),
('13', '45', '1', '4', '2023-02-14', '75'),
('14', '45', '1', '5', '2023-02-14', '25'),
('15', '45', '2', '6', '2023-02-14', '615'),
('16', '45', '7', '15', '2023-02-14', '2694.5'),
('17', '45', '8', '16', '2023-02-14', '2681.5'),
('18', '45', '9', '17', '2023-02-14', '12'),
('19', '47', '12', '28', '2023-03-22', '900'),
('20', '47', '21', '46', '2023-02-24', '10'),
('21', '47', '30', '56', '2023-02-01', '1127'),
('22', '47', '30', '57', '2023-02-01', '1127'),
('23', '45', '30', '56', '2023-03-06', '1127'),
('24', '45', '30', '57', '2023-03-06', '1127'),
('25', '47', '31', '58', '2023-02-01', '2016'),
('26', '47', '31', '59', '2023-02-01', '2020'),
('27', '47', '6', '13', '2023-02-01', '2303'),
('28', '47', '6', '14', '2023-02-01', '2300'),
('29', '45', '6', '13', '2023-03-07', '2303'),
('30', '45', '6', '14', '2023-03-07', '2300'),
('31', '45', '31', '58', '2023-03-07', '2016'),
('32', '45', '31', '59', '2023-03-07', '2020'),
('33', '47', '5', '11', '2023-02-07', '1456'),
('34', '47', '5', '21', '2023-02-07', '1500'),
('35', '45', '5', '11', '2023-03-07', '1456'),
('36', '45', '5', '21', '2023-03-07', '1500'),
('37', '47', '23', '47', '2023-03-08', '13500'),
('38', '45', '12', '28', '2023-03-10', '900'),
('39', '45', '21', '46', '2023-03-10', '10'),
('40', '45', '23', '47', '2023-03-10', '13500'),
('41', '47', '25', '51', '2023-02-15', '40'),
('42', '47', '26', '52', '2023-02-17', '899.999'),
('43', '47', '27', '53', '2023-02-17', '899.999'),
('44', '47', '28', '54', '2023-02-28', '764.999'),
('45', '47', '29', '55', '2023-02-28', '764.999'),
('46', '45', '28', '54', '2023-03-10', '764.999'),
('47', '45', '29', '55', '2023-03-10', '764.999'),
('48', '45', '26', '52', '2023-03-10', '899.999'),
('49', '45', '27', '53', '2023-03-10', '899.999'),
('50', '45', '25', '51', '2023-03-10', '40'),
('51', '47', '15', '34', '2023-02-18', '1025'),
('52', '47', '33', '62', '2023-02-01', '205'),
('53', '47', '33', '63', '2023-02-01', '1025'),
('54', '47', '33', '64', '2023-02-01', '410'),
('55', '47', '34', '65', '2023-02-09', '615'),
('56', '47', '35', '66', '2023-02-15', '1435'),
('57', '47', '35', '67', '2023-02-15', '1025'),
('58', '47', '36', '68', '2023-02-21', '1025'),
('59', '47', '37', '69', '2023-02-25', '2050'),
('60', '47', '38', '70', '2023-03-04', '2050'),
('61', '45', '15', '34', '2023-03-10', '1025'),
('62', '45', '33', '62', '2023-03-10', '205'),
('63', '45', '33', '63', '2023-03-10', '1025'),
('64', '45', '33', '64', '2023-03-10', '410'),
('65', '45', '34', '65', '2023-03-10', '615'),
('66', '45', '35', '66', '2023-03-10', '1435'),
('67', '45', '35', '67', '2023-03-10', '1025'),
('68', '45', '36', '68', '2023-03-10', '1025'),
('69', '45', '37', '69', '2023-03-10', '2050'),
('70', '45', '38', '70', '2023-03-10', '2050'),
('71', '47', '39', '71', '2023-03-01', '250'),
('72', '47', '39', '72', '2023-03-01', '50'),
('73', '47', '39', '73', '2023-03-01', '120'),
('74', '45', '39', '71', '2023-03-10', '250'),
('75', '45', '39', '72', '2023-03-10', '50'),
('76', '45', '39', '73', '2023-03-10', '120'),
('77', '47', '11', '22', '2023-03-02', '5075'),
('78', '47', '11', '23', '2023-03-02', '3000'),
('79', '47', '11', '24', '2023-03-02', '3000'),
('80', '47', '11', '25', '2023-03-02', '10025'),
('81', '47', '11', '26', '2023-03-02', '8000'),
('82', '47', '11', '27', '2023-03-02', '3000'),
('83', '45', '11', '22', '2023-03-14', '5075'),
('84', '45', '11', '23', '2023-03-14', '3000'),
('85', '45', '11', '24', '2023-03-14', '3000'),
('86', '45', '11', '25', '2023-03-14', '10025'),
('87', '45', '11', '26', '2023-03-14', '8000'),
('88', '45', '11', '27', '2023-03-14', '3000'),
('89', '47', '14', '32', '2023-03-14', '1208'),
('90', '47', '14', '33', '2023-03-14', '685'),
('91', '47', '16', '35', '2023-02-22', '10000'),
('92', '47', '18', '37', '2023-03-14', '510'),
('93', '47', '18', '38', '2023-03-14', '300'),
('94', '47', '18', '39', '2023-03-14', '310'),
('95', '47', '19', '40', '2023-03-06', '7800'),
('96', '47', '19', '43', '2023-03-06', '3200'),
('97', '47', '22', '45', '2023-03-14', '2396'),
('98', '47', '17', '36', '2023-03-02', '5'),
('99', '47', '54', '94', '2023-03-10', '960'),
('100', '47', '48', '85', '2023-03-08', '160'),
('101', '47', '24', '48', '2023-03-02', '1320'),
('102', '47', '24', '49', '2023-03-02', '300'),
('103', '47', '24', '50', '2023-03-02', '2250'),
('104', '47', '46', '82', '2023-03-13', '1120'),
('105', '47', '46', '83', '2023-03-13', '1099'),
('106', '47', '47', '84', '2023-02-25', '80'),
('107', '47', '55', '95', '2023-03-13', '569'),
('108', '47', '57', '98', '2023-03-14', '54400'),
('109', '47', '57', '99', '2023-03-14', '0'),
('110', '47', '20', '41', '2023-02-15', '1200'),
('111', '47', '20', '42', '2023-02-15', '3500'),
('112', '47', '41', '75', '2023-03-07', '1435'),
('113', '47', '23', '47', '2023-03-01', '540'),
('114', '47', '44', '80', '2023-03-04', '310'),
('115', '47', '45', '81', '2023-03-06', '3000'),
('116', '45', '14', '32', '2023-03-15', '1208'),
('117', '45', '14', '33', '2023-03-15', '685'),
('118', '45', '16', '35', '2023-03-15', '10000'),
('119', '45', '18', '37', '2023-03-15', '510'),
('120', '45', '18', '38', '2023-03-15', '300'),
('121', '45', '18', '39', '2023-03-15', '310'),
('122', '45', '19', '40', '2023-03-15', '7800'),
('123', '45', '19', '43', '2023-03-15', '3200'),
('124', '45', '20', '41', '2023-03-15', '1200'),
('125', '45', '20', '42', '2023-03-15', '3500'),
('126', '45', '22', '45', '2023-03-15', '2396'),
('127', '45', '44', '80', '2023-03-16', '310'),
('128', '45', '45', '81', '2023-03-16', '3000'),
('129', '45', '46', '82', '2023-03-16', '1120'),
('130', '45', '46', '83', '2023-03-16', '1099'),
('131', '45', '47', '84', '2023-03-16', '80'),
('132', '45', '55', '95', '2023-03-16', '569'),
('133', '45', '57', '98', '2023-03-16', '54400'),
('134', '45', '57', '99', '2023-03-16', '0'),
('135', '45', '17', '36', '2023-03-16', '5'),
('136', '45', '23', '47', '2023-03-16', '540'),
('137', '45', '24', '48', '2023-03-16', '1320'),
('138', '45', '24', '49', '2023-03-16', '300'),
('139', '45', '24', '50', '2023-03-16', '2250'),
('140', '45', '41', '75', '2023-03-16', '1435'),
('141', '45', '48', '85', '2023-03-16', '160'),
('142', '45', '54', '94', '2023-03-16', '960'),
('143', '45', '54', '94', '2023-03-16', '960'),
('144', '47', '19', '40', '2023-02-15', '1200'),
('145', '47', '19', '43', '2023-02-15', '3500'),
('146', '47', '61', '107', '2023-03-02', '1'),
('147', '47', '61', '108', '2023-03-02', '1'),
('148', '47', '62', '109', '2023-03-04', '2238.9'),
('149', '47', '63', '110', '2023-03-04', '878.1'),
('150', '47', '63', '110', '2023-03-10', '1463.7'),
('151', '47', '67', '116', '2023-02-13', '3969'),
('152', '47', '67', '117', '2023-02-13', '637'),
('153', '47', '67', '138', '2023-02-13', '4560'),
('154', '45', '67', '116', '2023-03-16', '3969'),
('155', '45', '67', '117', '2023-03-16', '637'),
('156', '45', '67', '138', '2023-03-16', '4560'),
('157', '45', '61', '107', '2023-03-17', '1'),
('158', '45', '61', '108', '2023-03-17', '1'),
('159', '45', '62', '109', '2023-03-17', '2238.9'),
('160', '45', '63', '110', '2023-03-17', '2341.8'),
('161', '47', '60', '104', '2023-03-18', '10'),
('162', '47', '60', '105', '2023-03-18', '5'),
('163', '47', '60', '106', '2023-03-18', '5'),
('164', '47', '76', '142', '2023-03-20', '900'),
('165', '47', '19', '40', '2023-03-18', '0'),
('166', '47', '19', '43', '2023-03-18', '2000'),
('167', '45', '19', '40', '2023-03-20', '1200'),
('168', '45', '19', '43', '2023-03-20', '5500'),
('169', '47', '68', '118', '2023-02-20', '1470'),
('170', '47', '68', '119', '2023-02-20', '1960'),
('171', '47', '68', '120', '2023-02-20', '1960'),
('172', '47', '68', '144', '2023-02-20', '1470'),
('173', '47', '70', '122', '2023-02-25', '392'),
('174', '47', '70', '123', '2023-02-25', '2408'),
('175', '47', '70', '124', '2023-02-25', '2850'),
('176', '47', '70', '139', '2023-02-25', '400'),
('177', '47', '71', '125', '2023-02-27', '1372'),
('178', '47', '71', '126', '2023-02-27', '1400'),
('179', '47', '71', '127', '2023-02-27', '1040'),
('180', '47', '71', '128', '2023-02-27', '1736'),
('181', '47', '71', '129', '2023-02-27', '1344'),
('182', '47', '71', '140', '2023-02-27', '1372'),
('183', '47', '71', '141', '2023-02-27', '1000'),
('184', '45', '68', '118', '2023-03-20', '1470'),
('185', '45', '68', '119', '2023-03-20', '1960'),
('186', '45', '68', '120', '2023-03-20', '1960'),
('187', '45', '68', '144', '2023-03-20', '1470'),
('188', '45', '70', '122', '2023-03-20', '392'),
('189', '45', '70', '123', '2023-03-20', '2408'),
('190', '45', '70', '124', '2023-03-20', '2850'),
('191', '45', '70', '139', '2023-03-20', '400'),
('192', '47', '77', '143', '2023-03-18', '19390'),
('193', '45', '71', '125', '2023-03-20', '1372'),
('194', '45', '71', '126', '2023-03-20', '1400'),
('195', '45', '71', '127', '2023-03-20', '1040'),
('196', '45', '71', '128', '2023-03-20', '1736'),
('197', '45', '71', '129', '2023-03-20', '1344'),
('198', '45', '71', '140', '2023-03-20', '1372'),
('199', '45', '71', '141', '2023-03-20', '1000'),
('200', '45', '77', '143', '2023-03-20', '19390'),
('201', '47', '42', '76', '2023-03-20', '720'),
('202', '47', '42', '77', '2023-03-20', '720'),
('203', '45', '42', '76', '2023-03-20', '720'),
('204', '45', '42', '77', '2023-03-20', '720'),
('205', '45', '76', '142', '2023-03-21', '900'),
('206', '45', '60', '104', '2023-03-21', '10'),
('207', '45', '60', '105', '2023-03-21', '5'),
('208', '45', '60', '106', '2023-03-21', '5'),
('209', '47', '78', '145', '2023-03-01', '3'),
('210', '47', '40', '74', '2023-03-21', '3840'),
('211', '47', '63', '110', '2023-03-10', '258.2'),
('212', '47', '57', '98', '2023-03-21', '45600'),
('213', '47', '57', '99', '2023-03-21', '0'),
('214', '45', '57', '98', '2023-03-21', '45600'),
('215', '45', '57', '99', '2023-03-21', '0'),
('216', '47', '85', '152', '2023-02-20', '1000'),
('217', '47', '85', '153', '2023-02-20', '1911'),
('218', '47', '85', '154', '2023-02-20', '6000'),
('219', '45', '40', '74', '2023-03-22', '3840'),
('220', '45', '85', '152', '2023-03-22', '1000'),
('221', '45', '85', '153', '2023-03-22', '1911'),
('222', '45', '85', '154', '2023-03-22', '6000'),
('223', '47', '58', '100', '2023-03-15', '9212'),
('224', '47', '58', '101', '2023-03-15', '5000'),
('225', '47', '58', '102', '2023-03-15', '8000'),
('226', '45', '63', '110', '2023-03-22', '258.2'),
('227', '45', '78', '145', '2023-03-22', '3'),
('228', '47', '62', '109', '2023-03-04', '361.1'),
('229', '45', '62', '109', '2023-03-25', '361.1'),
('230', '47', '87', '156', '2023-03-28', '1200'),
('231', '45', '87', '156', '2023-03-30', '1200'),
('232', '45', '87', '156', '2023-03-30', '1200'),
('233', '47', '13', '29', '2023-02-24', '5200'),
('234', '47', '13', '30', '2023-02-24', '0'),
('235', '47', '13', '31', '2023-02-24', '0'),
('236', '45', '13', '29', '2023-04-02', '5200'),
('237', '45', '13', '30', '2023-04-02', '0'),
('238', '45', '13', '31', '2023-04-02', '0'),
('239', '47', '64', '111', '2023-03-02', '18600'),
('240', '45', '64', '111', '2023-04-02', '18600'),
('241', '47', '89', '158', '2023-04-03', '5'),
('242', '47', '95', '165', '2023-04-03', '5'),
('243', '47', '94', '164', '2023-04-03', '0.5'),
('244', '47', '97', '167', '2023-04-03', '50'),
('245', '47', '91', '161', '2023-04-03', '50'),
('246', '47', '90', '159', '2023-03-31', '709'),
('247', '47', '90', '160', '2023-03-31', '2867'),
('248', '45', '90', '159', '2023-04-05', '709'),
('249', '45', '90', '160', '2023-04-05', '2867'),
('250', '47', '11', '22', '2023-04-05', '0'),
('251', '47', '11', '23', '2023-04-05', '1000'),
('252', '47', '11', '24', '2023-04-05', '1000'),
('253', '47', '11', '25', '2023-04-05', '0'),
('254', '47', '11', '26', '2023-04-05', '0'),
('255', '47', '11', '27', '2023-04-05', '0'),
('256', '47', '13', '29', '2023-04-05', '0'),
('257', '47', '13', '30', '2023-04-05', '4000'),
('258', '47', '13', '31', '2023-04-05', '0'),
('259', '47', '13', '29', '2023-04-05', '4800'),
('260', '47', '13', '30', '2023-04-05', '0'),
('261', '47', '13', '31', '2023-04-05', '4800'),
('262', '47', '44', '80', '2023-04-05', '275'),
('263', '47', '18', '37', '2023-03-04', '510'),
('264', '47', '18', '38', '2023-03-04', '219'),
('265', '47', '18', '39', '2023-03-04', '310'),
('266', '47', '22', '45', '2023-04-03', '2448'),
('267', '47', '99', '178', '2023-02-22', '6160'),
('268', '47', '40', '74', '2023-02-22', '6160'),
('269', '47', '43', '78', '2023-03-24', '6160'),
('270', '47', '43', '79', '2023-03-24', '5240'),
('271', '45', '89', '158', '2023-04-05', '5'),
('272', '45', '97', '167', '2023-04-05', '50'),
('273', '45', '91', '161', '2023-04-05', '50'),
('274', '45', '94', '164', '2023-04-05', '0.5'),
('275', '45', '95', '165', '2023-04-05', '5'),
('276', '47', '45', '81', '2023-03-24', '4000'),
('277', '47', '46', '82', '2023-03-31', '1030'),
('278', '47', '46', '83', '2023-03-31', '0'),
('279', '47', '50', '88', '2023-02-20', '360'),
('280', '47', '50', '89', '2023-02-20', '480'),
('281', '47', '56', '96', '2023-03-04', '110950'),
('282', '47', '56', '97', '2023-03-04', '30600'),
('283', '48', '56', '96', '2023-04-05', '200000'),
('284', '48', '56', '97', '2023-04-05', '100000'),
('285', '48', '56', '96', '2023-04-05', '110950'),
('286', '48', '56', '97', '2023-04-05', '30600'),
('287', '47', '59', '103', '2023-03-30', '14400'),
('288', '47', '65', '112', '2023-03-06', '6000'),
('289', '47', '65', '113', '2023-03-06', '3000'),
('290', '47', '65', '114', '2023-03-06', '3000'),
('291', '47', '92', '162', '2023-04-05', '613'),
('292', '47', '58', '100', '2023-04-06', '637'),
('293', '47', '58', '101', '2023-04-06', '0'),
('294', '47', '58', '102', '2023-04-06', '0'),
('295', '47', '58', '100', '2023-04-06', '13230'),
('296', '47', '58', '101', '2023-04-06', '8500'),
('297', '47', '58', '102', '2023-04-06', '0'),
('298', '47', '74', '136', '2023-04-03', '1694'),
('299', '47', '75', '137', '2023-03-16', '4000'),
('300', '47', '77', '143', '2023-04-06', '30250'),
('301', '47', '80', '147', '2023-03-13', '519'),
('302', '47', '81', '148', '2023-02-15', '200'),
('303', '47', '83', '150', '2023-02-24', '5000'),
('304', '45', '92', '162', '2023-04-06', '613'),
('305', '45', '43', '78', '2023-04-07', '6160'),
('306', '45', '43', '79', '2023-04-07', '5240'),
('307', '45', '44', '80', '2023-04-07', '275'),
('308', '45', '45', '81', '2023-04-07', '4000'),
('309', '47', '79', '146', '2023-03-21', '3000'),
('310', '45', '58', '100', '2023-04-07', '23079'),
('311', '45', '58', '101', '2023-04-07', '13500'),
('312', '45', '58', '102', '2023-04-07', '8000'),
('313', '45', '59', '103', '2023-04-07', '14400'),
('314', '45', '74', '136', '2023-04-07', '1694'),
('315', '45', '77', '143', '2023-04-07', '30250'),
('316', '45', '79', '146', '2023-04-07', '3000'),
('317', '45', '99', '178', '2023-04-07', '6160'),
('318', '47', '58', '100', '2023-03-02', '27979'),
('319', '47', '58', '101', '2023-03-02', '14856'),
('320', '47', '58', '102', '2023-03-02', '16958'),
('321', '45', '58', '100', '2023-04-07', '27979'),
('322', '45', '58', '101', '2023-04-07', '14856'),
('323', '45', '58', '102', '2023-04-07', '16958'),
('324', '47', '66', '115', '2023-02-22', '8000'),
('325', '45', '66', '115', '2023-04-07', '8000'),
('326', '45', '81', '148', '2023-04-09', '200'),
('327', '47', '113', '195', '2023-04-01', '200'),
('328', '45', '113', '195', '2023-04-09', '200'),
('329', '47', '103', '185', '2023-04-08', '25'),
('330', '47', '104', '186', '2023-04-08', '25'),
('331', '47', '110', '192', '2023-04-08', '160'),
('332', '47', '111', '193', '2023-04-08', '40'),
('333', '47', '114', '196', '2023-04-08', '8074.8'),
('334', '47', '115', '197', '2023-04-08', '1610'),
('335', '47', '116', '198', '2023-04-08', '300'),
('336', '47', '117', '199', '2023-04-08', '300'),
('337', '47', '118', '200', '2023-04-08', '1320'),
('338', '47', '112', '194', '2023-04-08', '4'),
('339', '47', '106', '188', '2023-04-08', '3'),
('340', '47', '77', '143', '2023-04-08', '360'),
('341', '47', '88', '157', '2023-04-08', '1196'),
('342', '47', '107', '189', '2023-04-08', '1845'),
('343', '47', '108', '190', '2023-04-08', '1640'),
('344', '47', '105', '187', '2023-04-08', '180'),
('345', '47', '88', '157', '2023-04-08', '4'),
('346', '47', '99', '178', '2023-04-10', '8840'),
('347', '47', '51', '90', '2023-02-13', '6'),
('348', '47', '51', '91', '2023-02-13', '85'),
('349', '47', '43', '78', '2023-04-06', '840'),
('350', '47', '43', '79', '2023-04-06', '1760'),
('351', '47', '58', '100', '2023-04-06', '2021'),
('352', '47', '58', '101', '2023-04-06', '7000'),
('353', '47', '58', '102', '2023-04-06', '0'),
('354', '47', '69', '121', '2023-04-06', '1911'),
('355', '45', '110', '192', '2023-04-11', '160'),
('356', '45', '108', '190', '2023-04-11', '1640'),
('357', '45', '107', '189', '2023-04-11', '1845'),
('358', '45', '106', '188', '2023-04-11', '3'),
('359', '45', '106', '188', '2023-04-11', '3'),
('360', '45', '106', '188', '2023-04-11', '3'),
('361', '45', '105', '187', '2023-04-11', '180'),
('362', '45', '88', '157', '2023-04-11', '1200'),
('363', '45', '88', '157', '2023-04-11', '1200'),
('364', '45', '103', '185', '2023-04-11', '25'),
('365', '45', '104', '186', '2023-04-11', '25'),
('366', '45', '111', '193', '2023-04-11', '40'),
('367', '45', '112', '194', '2023-04-11', '4'),
('368', '45', '118', '200', '2023-04-11', '1320'),
('369', '45', '114', '196', '2023-04-11', '8074.8'),
('370', '45', '114', '196', '2023-04-11', '8074.8'),
('371', '45', '115', '197', '2023-04-11', '1610'),
('372', '45', '116', '198', '2023-04-11', '300'),
('373', '45', '117', '199', '2023-04-11', '300'),
('374', '47', '130', '225', '2023-03-15', '3498'),
('375', '47', '130', '226', '2023-03-15', '3498'),
('376', '47', '130', '225', '2023-03-21', '6510'),
('377', '47', '130', '226', '2023-03-21', '6510'),
('378', '45', '130', '225', '2023-04-11', '10008'),
('379', '45', '130', '226', '2023-04-11', '10008'),
('380', '45', '69', '121', '2023-04-11', '1911'),
('381', '45', '75', '137', '2023-04-11', '4000'),
('382', '45', '77', '143', '2023-04-11', '360'),
('383', '45', '99', '178', '2023-04-11', '8840'),
('384', '45', '11', '22', '2023-04-11', '0'),
('385', '45', '11', '23', '2023-04-11', '1000'),
('386', '45', '11', '24', '2023-04-11', '1000'),
('387', '45', '11', '25', '2023-04-11', '0'),
('388', '45', '11', '26', '2023-04-11', '0'),
('389', '45', '11', '27', '2023-04-11', '0'),
('390', '45', '13', '29', '2023-04-11', '4800'),
('391', '45', '13', '30', '2023-04-11', '4000'),
('392', '45', '13', '31', '2023-04-11', '4800'),
('393', '45', '18', '37', '2023-04-11', '510'),
('394', '45', '18', '38', '2023-04-11', '219'),
('395', '45', '18', '39', '2023-04-11', '310'),
('396', '45', '22', '45', '2023-04-11', '2448'),
('397', '45', '40', '74', '2023-04-11', '6160'),
('398', '45', '43', '78', '2023-04-11', '840'),
('399', '45', '43', '79', '2023-04-11', '1760'),
('400', '45', '46', '82', '2023-04-11', '1030'),
('401', '45', '46', '83', '2023-04-11', '0'),
('402', '45', '50', '88', '2023-04-11', '360'),
('403', '45', '50', '89', '2023-04-11', '480'),
('404', '47', '119', '201', '2023-04-11', '1620'),
('405', '47', '120', '202', '2023-04-11', '330'),
('414', '45', '129', '217', '2023-04-11', '51514'),
('415', '45', '129', '218', '2023-04-11', '3440'),
('416', '45', '129', '219', '2023-04-11', '12073'),
('417', '45', '129', '220', '2023-04-11', '18115'),
('418', '45', '129', '221', '2023-04-11', '2960'),
('419', '45', '129', '222', '2023-04-11', '60000'),
('420', '45', '129', '223', '2023-04-11', '12500'),
('421', '45', '129', '224', '2023-04-11', '21550'),
('422', '47', '22', '45', '2023-04-11', '2400'),
('423', '47', '74', '136', '2023-04-13', '2200'),
('424', '47', '59', '103', '2023-04-13', '15600'),
('425', '47', '109', '191', '2023-04-12', '320'),
('426', '47', '131', '227', '2023-04-13', '499'),
('427', '47', '74', '136', '2023-04-13', '106'),
('428', '45', '109', '191', '2023-04-14', '320'),
('429', '45', '119', '201', '2023-04-14', '1620'),
('430', '45', '120', '202', '2023-04-14', '330'),
('431', '45', '74', '136', '2023-04-14', '2306'),
('432', '45', '131', '227', '2023-04-14', '499'),
('433', '45', '22', '45', '2023-04-14', '2400'),
('434', '45', '58', '100', '2023-04-14', '2021'),
('435', '45', '58', '101', '2023-04-14', '7000'),
('436', '45', '58', '102', '2023-04-14', '0'),
('437', '45', '59', '103', '2023-04-14', '15600'),
('438', '45', '65', '112', '2023-04-14', '6000'),
('439', '45', '65', '113', '2023-04-14', '3000'),
('440', '45', '65', '114', '2023-04-14', '3000'),
('441', '45', '80', '147', '2023-04-14', '519'),
('442', '45', '83', '150', '2023-04-14', '5000'),
('443', '47', '122', '204', '2023-04-06', '5378'),
('444', '47', '122', '204', '2023-04-15', '10290'),
('445', '47', '123', '205', '2023-04-15', '10000'),
('446', '47', '124', '206', '2023-04-15', '580'),
('447', '47', '126', '211', '2023-04-17', '738'),
('448', '47', '56', '96', '2023-03-06', '16200'),
('449', '47', '56', '97', '2023-03-06', '0'),
('450', '47', '56', '96', '2023-03-08', '13050'),
('451', '47', '56', '97', '2023-03-08', '100000'),
('452', '47', '56', '96', '2023-03-10', '18000'),
('453', '47', '56', '97', '2023-03-10', '0'),
('454', '47', '56', '96', '2023-04-05', '11700'),
('455', '47', '56', '97', '2023-04-05', '0'),
('456', '47', '56', '96', '2023-04-08', '15300'),
('457', '47', '56', '97', '2023-04-08', '0'),
('458', '47', '132', '228', '2023-04-17', '126'),
('459', '47', '19', '40', '2023-04-17', '0'),
('460', '47', '19', '43', '2023-04-17', '300'),
('461', '47', '133', '229', '2023-02-25', '51514'),
('462', '47', '133', '230', '2023-02-25', '3440'),
('463', '47', '133', '231', '2023-02-25', '12073'),
('464', '47', '133', '232', '2023-02-25', '18120'),
('465', '47', '133', '233', '2023-02-25', '2960'),
('466', '47', '133', '234', '2023-02-25', '60000'),
('467', '47', '133', '235', '2023-02-25', '12500'),
('468', '47', '133', '236', '2023-02-25', '21550'),
('469', '45', '133', '229', '2023-04-18', '51514'),
('470', '45', '133', '230', '2023-04-18', '3440'),
('471', '45', '133', '231', '2023-04-18', '12073'),
('472', '45', '133', '232', '2023-04-18', '18120'),
('473', '45', '133', '233', '2023-04-18', '2960'),
('474', '45', '133', '234', '2023-04-18', '60000'),
('475', '45', '133', '235', '2023-04-18', '12500'),
('476', '45', '133', '236', '2023-04-18', '21550'),
('477', '47', '133', '229', '2023-02-25', '51514'),
('478', '47', '133', '230', '2023-02-25', '3440'),
('479', '47', '133', '231', '2023-02-25', '12073'),
('480', '47', '133', '232', '2023-02-25', '18120'),
('481', '47', '133', '233', '2023-02-25', '2960'),
('482', '47', '133', '234', '2023-02-25', '60000'),
('483', '47', '133', '235', '2023-02-25', '12500'),
('484', '47', '133', '236', '2023-02-25', '21550'),
('485', '47', '133', '229', '2023-02-25', '51514'),
('486', '47', '133', '230', '2023-02-25', '3440'),
('487', '47', '133', '231', '2023-02-25', '12073'),
('488', '47', '133', '232', '2023-02-25', '18120'),
('489', '47', '133', '233', '2023-02-25', '2960'),
('490', '47', '133', '234', '2023-02-25', '60000'),
('491', '47', '133', '235', '2023-02-25', '12500'),
('492', '47', '133', '236', '2023-02-25', '21550'),
('493', '45', '133', '229', '2023-04-18', '51514'),
('494', '45', '133', '230', '2023-04-18', '3440'),
('495', '45', '133', '231', '2023-04-18', '12073'),
('496', '45', '133', '232', '2023-04-18', '18120'),
('497', '45', '133', '233', '2023-04-18', '2960'),
('498', '45', '133', '234', '2023-04-18', '60000'),
('499', '45', '133', '235', '2023-04-18', '12500'),
('500', '45', '133', '236', '2023-04-18', '21550'),
('501', '47', '125', '207', '2023-04-18', '550'),
('502', '47', '125', '208', '2023-04-18', '5293'),
('503', '47', '125', '209', '2023-04-18', '0'),
('504', '47', '125', '210', '2023-04-18', '2168'),
('505', '47', '125', '216', '2023-04-18', '0'),
('506', '47', '57', '98', '2023-03-18', '0'),
('507', '47', '57', '99', '2023-03-18', '1500'),
('508', '47', '57', '98', '2023-03-25', '0'),
('509', '47', '57', '99', '2023-03-25', '10200'),
('510', '47', '140', '248', '2023-03-09', '31773'),
('511', '47', '140', '249', '2023-03-09', '4530'),
('512', '47', '140', '250', '2023-03-09', '25700'),
('513', '47', '140', '251', '2023-03-09', '24493'),
('514', '47', '140', '252', '2023-03-09', '24512'),
('515', '47', '140', '253', '2023-03-09', '32320'),
('516', '47', '140', '254', '2023-03-09', '50000'),
('517', '47', '140', '255', '2023-03-09', '4530'),
('518', '47', '140', '256', '2023-03-09', '25470'),
('519', '47', '140', '248', '2023-03-09', '31773'),
('520', '47', '140', '249', '2023-03-09', '4530'),
('521', '47', '140', '250', '2023-03-09', '25700'),
('522', '47', '140', '251', '2023-03-09', '24493'),
('523', '47', '140', '252', '2023-03-09', '24512'),
('524', '47', '140', '253', '2023-03-09', '32320'),
('525', '47', '140', '254', '2023-03-09', '50000'),
('526', '47', '140', '255', '2023-03-09', '4530'),
('527', '47', '140', '256', '2023-03-09', '25470'),
('528', '47', '140', '248', '2023-03-09', '31773'),
('529', '47', '140', '249', '2023-03-09', '4530'),
('530', '47', '140', '250', '2023-03-09', '25700'),
('531', '47', '140', '251', '2023-03-09', '24493'),
('532', '47', '140', '252', '2023-03-09', '24512'),
('533', '47', '140', '253', '2023-03-09', '32320'),
('534', '47', '140', '254', '2023-03-09', '50000'),
('535', '47', '140', '255', '2023-03-09', '4530'),
('536', '47', '140', '256', '2023-03-09', '25470'),
('537', '47', '140', '248', '2023-03-09', '31773'),
('538', '47', '140', '249', '2023-03-09', '4530'),
('539', '47', '140', '250', '2023-03-09', '25700'),
('540', '47', '140', '251', '2023-03-09', '24493'),
('541', '47', '140', '252', '2023-03-09', '24512'),
('542', '47', '140', '253', '2023-03-09', '32320'),
('543', '47', '140', '254', '2023-03-09', '50000'),
('544', '47', '140', '255', '2023-03-09', '4530'),
('545', '47', '140', '256', '2023-03-09', '25470'),
('546', '45', '140', '248', '2023-04-20', '31773'),
('547', '45', '140', '249', '2023-04-20', '4530'),
('548', '45', '140', '250', '2023-04-20', '25700'),
('549', '45', '140', '251', '2023-04-20', '24493'),
('550', '45', '140', '252', '2023-04-20', '24512'),
('551', '45', '140', '253', '2023-04-20', '32320'),
('552', '45', '140', '254', '2023-04-20', '50000'),
('553', '45', '140', '255', '2023-04-20', '4530'),
('554', '45', '140', '256', '2023-04-20', '25470'),
('555', '45', '57', '98', '2023-04-22', '0'),
('556', '45', '57', '99', '2023-04-22', '11700'),
('557', '45', '122', '204', '2023-04-22', '15668'),
('558', '47', '52', '92', '2023-03-02', '710'),
('559', '47', '53', '93', '2023-03-02', '710'),
('560', '45', '52', '92', '2023-04-24', '710'),
('561', '45', '53', '93', '2023-04-24', '710'),
('562', '47', '141', '257', '2023-04-20', '10'),
('563', '47', '143', '259', '2023-03-11', '750'),
('564', '47', '144', '260', '2023-03-11', '750'),
('565', '47', '145', '261', '2023-03-16', '625'),
('566', '47', '146', '262', '2023-03-16', '625'),
('567', '47', '147', '263', '2023-03-22', '730'),
('568', '47', '148', '264', '2023-03-22', '730'),
('569', '47', '149', '265', '2023-04-01', '570'),
('570', '47', '150', '266', '2023-04-01', '570'),
('571', '47', '151', '267', '2023-04-11', '675'),
('572', '47', '152', '268', '2023-04-11', '675'),
('573', '47', '153', '269', '2023-04-18', '960'),
('574', '47', '154', '270', '2023-04-18', '960'),
('575', '45', '151', '267', '2023-04-26', '675'),
('576', '45', '152', '268', '2023-04-26', '675'),
('577', '45', '153', '269', '2023-04-26', '960'),
('578', '45', '154', '270', '2023-04-26', '960'),
('579', '45', '144', '260', '2023-04-26', '750'),
('580', '45', '144', '260', '2023-04-26', '750'),
('581', '45', '145', '261', '2023-04-26', '625'),
('582', '45', '143', '259', '2023-04-26', '625'),
('583', '45', '143', '259', '2023-04-26', '730'),
('584', '45', '143', '259', '2023-04-26', '730'),
('585', '45', '143', '259', '2023-04-26', '570'),
('586', '45', '143', '259', '2023-04-26', '570'),
('587', '45', '143', '259', '2023-04-26', '750'),
('588', '45', '146', '262', '2023-04-26', '625'),
('589', '45', '147', '263', '2023-04-26', '730'),
('590', '45', '148', '264', '2023-04-26', '730'),
('591', '45', '123', '205', '2023-04-26', '10000'),
('592', '45', '124', '206', '2023-04-26', '580'),
('593', '45', '125', '207', '2023-04-26', '550'),
('594', '45', '125', '208', '2023-04-26', '5293'),
('595', '45', '125', '209', '2023-04-26', '0'),
('596', '45', '125', '210', '2023-04-26', '2168'),
('597', '45', '125', '216', '2023-04-26', '0'),
('598', '45', '126', '211', '2023-04-26', '738'),
('599', '45', '132', '228', '2023-04-26', '126'),
('600', '45', '56', '96', '2023-04-26', '74250'),
('601', '45', '56', '97', '2023-04-26', '100000'),
('602', '47', '137', '243', '2023-03-03', '2080'),
('603', '47', '142', '258', '2023-03-25', '1000'),
('604', '45', '142', '258', '2023-04-26', '1000'),
('605', '47', '57', '98', '2023-04-20', '0'),
('606', '47', '57', '99', '2023-04-20', '7500'),
('607', '47', '127', '212', '2023-04-17', '9400'),
('608', '47', '127', '213', '2023-04-17', '11160'),
('609', '45', '141', '257', '2023-04-27', '10'),
('610', '47', '134', '237', '2023-04-06', '5378'),
('611', '47', '134', '238', '2023-04-06', '0'),
('612', '47', '134', '239', '2023-04-06', '0'),
('613', '45', '134', '237', '2023-04-27', '5378'),
('614', '45', '134', '238', '2023-04-27', '0'),
('615', '45', '134', '239', '2023-04-27', '0'),
('616', '47', '122', '204', '2023-04-06', '5378'),
('617', '45', '122', '204', '2023-04-27', '5378'),
('618', '47', '122', '204', '2023-04-15', '10290'),
('619', '45', '122', '204', '2023-04-27', '10290'),
('620', '47', '155', '272', '2023-03-18', '637'),
('621', '45', '127', '212', '2023-04-27', '9400'),
('622', '45', '127', '213', '2023-04-27', '11160'),
('623', '45', '57', '98', '2023-04-27', '0'),
('624', '45', '57', '99', '2023-04-27', '7500'),
('625', '45', '155', '272', '2023-04-27', '637'),
('626', '47', '128', '214', '2023-04-27', '0'),
('627', '47', '128', '215', '2023-04-27', '27000'),
('628', '47', '158', '275', '2023-03-04', '427'),
('629', '47', '158', '276', '2023-03-04', '240'),
('630', '45', '158', '275', '2023-04-28', '427'),
('631', '45', '158', '276', '2023-04-28', '240'),
('632', '45', '137', '243', '2023-04-29', '2080'),
('633', '47', '90', '159', '2023-05-04', '5'),
('634', '47', '90', '160', '2023-05-04', '0'),
('639', '47', '160', '280', '2023-05-06', '1500'),
('640', '47', '160', '281', '2023-05-06', '1500'),
('641', '47', '58', '100', '2023-05-05', '0'),
('642', '47', '58', '101', '2023-05-05', '3144'),
('643', '47', '58', '102', '2023-05-05', '0'),
('644', '47', '123', '205', '2023-05-05', '7156'),
('645', '47', '122', '204', '2023-05-05', '10290'),
('646', '47', '86', '155', '2023-05-04', '1344'),
('647', '47', '86', '279', '2023-05-04', '1345'),
('648', '47', '57', '98', '2023-05-06', '0'),
('649', '47', '57', '99', '2023-05-06', '4500'),
('650', '45', '160', '280', '2023-05-08', '1500'),
('651', '45', '160', '281', '2023-05-08', '1500'),
('652', '45', '58', '100', '2023-05-08', '0'),
('653', '45', '58', '101', '2023-05-08', '3144'),
('654', '45', '58', '102', '2023-05-08', '0'),
('655', '45', '86', '155', '2023-05-08', '1344'),
('656', '45', '86', '279', '2023-05-08', '1345'),
('657', '45', '90', '159', '2023-05-08', '5'),
('658', '45', '90', '160', '2023-05-08', '0'),
('659', '45', '57', '98', '2023-05-08', '0'),
('660', '45', '57', '99', '2023-05-08', '4500'),
('661', '47', '134', '238', '2023-05-08', '0'),
('662', '47', '134', '239', '2023-05-08', '2310'),
('663', '47', '134', '271', '2023-05-08', '0'),
('664', '47', '156', '273', '2023-04-18', '960'),
('665', '47', '157', '274', '2023-04-18', '960'),
('666', '45', '134', '238', '2023-05-08', '0'),
('667', '45', '134', '239', '2023-05-08', '2310'),
('668', '45', '134', '271', '2023-05-08', '0'),
('669', '45', '156', '273', '2023-05-08', '960'),
('670', '45', '157', '274', '2023-05-08', '960'),
('671', '45', '122', '204', '2023-05-10', '10290'),
('672', '45', '128', '214', '2023-05-10', '0'),
('673', '45', '128', '215', '2023-05-10', '27000'),
('674', '45', '123', '205', '2023-05-10', '7156'),
('675', '47', '128', '214', '2023-05-10', '0'),
('676', '47', '128', '215', '2023-05-10', '49300'),
('677', '45', '128', '214', '2023-05-10', '0'),
('678', '45', '128', '215', '2023-05-10', '49300'),
('679', '47', '128', '214', '2023-05-10', '0'),
('680', '47', '128', '215', '2023-05-10', '23700'),
('681', '47', '168', '292', '2023-05-10', '9300'),
('682', '47', '135', '240', '2023-05-09', '10100'),
('683', '47', '135', '241', '2023-05-09', '10100'),
('684', '45', '168', '292', '2023-05-10', '9300'),
('685', '45', '128', '214', '2023-05-10', '0'),
('686', '45', '128', '215', '2023-05-10', '23700'),
('687', '45', '135', '240', '2023-05-10', '10100'),
('688', '45', '135', '241', '2023-05-10', '10100'),
('689', '47', '161', '282', '2023-05-09', '670'),
('690', '47', '162', '283', '2023-05-11', '670'),
('691', '45', '161', '282', '2023-05-11', '670'),
('692', '45', '162', '283', '2023-05-11', '670'),
('693', '47', '159', '277', '2023-05-11', '2238.9'),
('694', '47', '159', '278', '2023-05-11', '100'),
('695', '47', '171', '299', '2023-05-12', '1'),
('696', '47', '171', '300', '2023-05-12', '1'),
('697', '47', '159', '277', '2023-05-11', '2238.9'),
('698', '47', '159', '278', '2023-05-11', '100'),
('699', '47', '177', '314', '2023-03-04', '2400'),
('700', '47', '179', '316', '2023-04-03', '2400'),
('701', '45', '177', '314', '2023-05-12', '2400'),
('702', '45', '179', '316', '2023-05-12', '2400'),
('703', '47', '22', '45', '2023-03-04', '2400'),
('704', '45', '22', '45', '2023-05-13', '2400'),
('705', '47', '22', '45', '2023-03-10', '2400'),
('706', '45', '22', '45', '2023-05-13', '2400'),
('707', '47', '22', '45', '2023-04-03', '2448'),
('708', '45', '22', '45', '2023-05-13', '2448'),
('709', '47', '177', '314', '2023-03-10', '2400'),
('710', '45', '177', '314', '2023-05-13', '2400'),
('711', '47', '179', '316', '2023-04-03', '2400'),
('712', '45', '179', '316', '2023-05-13', '2400'),
('713', '45', '159', '277', '2023-05-13', '2238.9'),
('714', '45', '159', '278', '2023-05-13', '100'),
('715', '45', '171', '299', '2023-05-13', '1'),
('716', '45', '171', '300', '2023-05-13', '1'),
('717', '45', '51', '90', '2023-05-15', '6'),
('718', '45', '51', '91', '2023-05-15', '85'),
('719', '47', '125', '207', '2023-05-04', '1490'),
('720', '47', '125', '208', '2023-05-04', '5293'),
('721', '47', '125', '209', '2023-05-04', '533'),
('722', '47', '125', '210', '2023-05-04', '2168'),
('723', '47', '125', '216', '2023-05-04', '783'),
('724', '47', '183', '321', '2023-05-11', '2400'),
('725', '45', '183', '321', '2023-05-15', '2400'),
('726', '47', '185', '323', '2023-03-30', '2.55'),
('727', '47', '185', '324', '2023-03-30', '8.5'),
('728', '47', '184', '322', '2023-03-27', '50'),
('729', '47', '182', '320', '2023-03-30', '3'),
('730', '45', '185', '323', '2023-05-16', '2.55'),
('731', '45', '185', '324', '2023-05-16', '8.5'),
('732', '45', '182', '320', '2023-05-16', '3'),
('733', '45', '184', '322', '2023-05-16', '50'),
('734', '47', '163', '284', '2023-05-16', '0.4'),
('735', '47', '122', '204', '2023-05-15', '4042'),
('736', '47', '123', '205', '2023-05-15', '5300'),
('737', '47', '134', '238', '2023-05-15', '0'),
('738', '47', '134', '239', '2023-05-15', '2690'),
('739', '47', '134', '271', '2023-05-15', '6248'),
('740', '45', '163', '284', '2023-05-16', '0.4'),
('741', '47', '176', '309', '2023-05-15', '0'),
('742', '47', '176', '310', '2023-05-15', '2310'),
('743', '47', '176', '311', '2023-05-15', '0'),
('744', '45', '122', '204', '2023-05-16', '4042'),
('745', '45', '123', '205', '2023-05-16', '5300'),
('746', '45', '125', '207', '2023-05-16', '1490'),
('747', '45', '125', '208', '2023-05-16', '5293'),
('748', '45', '125', '209', '2023-05-16', '533'),
('749', '45', '125', '210', '2023-05-16', '2168'),
('750', '45', '125', '216', '2023-05-16', '783'),
('751', '45', '134', '238', '2023-05-16', '0'),
('752', '45', '134', '239', '2023-05-16', '2690'),
('753', '45', '134', '271', '2023-05-16', '6248'),
('754', '45', '176', '309', '2023-05-16', '0'),
('755', '45', '176', '310', '2023-05-16', '2310'),
('756', '45', '176', '311', '2023-05-16', '0'),
('757', '47', '186', '325', '2023-05-15', '830'),
('758', '47', '187', '326', '2023-05-15', '830'),
('759', '45', '186', '325', '2023-05-16', '830'),
('760', '45', '187', '326', '2023-05-16', '830'),
('761', '47', '125', '207', '2023-05-04', '550'),
('762', '47', '125', '208', '2023-05-04', '0'),
('763', '47', '125', '209', '2023-05-04', '0'),
('764', '47', '125', '210', '2023-05-04', '0'),
('765', '47', '125', '216', '2023-05-04', '0'),
('766', '45', '125', '207', '2023-05-16', '550'),
('767', '45', '125', '208', '2023-05-16', '0'),
('768', '45', '125', '209', '2023-05-16', '0'),
('769', '45', '125', '210', '2023-05-16', '0'),
('770', '45', '125', '216', '2023-05-16', '0'),
('771', '47', '192', '331', '2023-05-19', '500'),
('772', '47', '139', '246', '2023-05-16', '3810'),
('773', '47', '139', '247', '2023-05-16', '0'),
('774', '45', '192', '331', '2023-05-22', '500'),
('775', '45', '139', '246', '2023-05-23', '3810'),
('776', '45', '139', '247', '2023-05-23', '0'),
('777', '47', '189', '328', '2023-05-20', '725'),
('778', '47', '190', '329', '2023-05-20', '725'),
('779', '45', '189', '328', '2023-05-23', '725'),
('780', '45', '190', '329', '2023-05-23', '725'),
('781', '47', '139', '246', '2023-05-17', '1170'),
('782', '47', '139', '247', '2023-05-17', '5010'),
('783', '45', '139', '246', '2023-05-23', '1170'),
('784', '45', '139', '247', '2023-05-23', '5010'),
('785', '47', '123', '205', '2023-05-23', '8300'),
('786', '47', '134', '238', '2023-05-23', '0'),
('787', '47', '134', '239', '2023-05-23', '0'),
('788', '47', '134', '271', '2023-05-23', '8752'),
('789', '47', '176', '309', '2023-05-23', '1538'),
('790', '47', '176', '310', '2023-05-23', '0'),
('791', '47', '176', '311', '2023-05-23', '0'),
('792', '47', '176', '309', '2023-05-23', '0'),
('793', '47', '176', '310', '2023-05-23', '2000'),
('794', '47', '176', '311', '2023-05-23', '0'),
('795', '45', '134', '238', '2023-05-24', '0'),
('796', '45', '134', '239', '2023-05-24', '0'),
('797', '45', '134', '271', '2023-05-24', '8752'),
('798', '45', '176', '309', '2023-05-24', '1538'),
('799', '45', '176', '310', '2023-05-24', '2000'),
('800', '45', '176', '311', '2023-05-24', '0'),
('801', '45', '123', '205', '2023-05-24', '8300'),
('802', '47', '196', '335', '2023-05-20', '120'),
('803', '45', '196', '335', '2023-05-24', '120'),
('804', '47', '193', '332', '2023-05-25', '900'),
('805', '47', '194', '333', '2023-05-25', '975'),
('806', '47', '195', '334', '2023-05-25', '975'),
('807', '45', '194', '333', '2023-05-26', '975'),
('808', '45', '195', '334', '2023-05-26', '975'),
('809', '47', '176', '309', '2023-05-30', '5782'),
('810', '47', '176', '310', '2023-05-30', '0'),
('811', '47', '176', '311', '2023-05-30', '0'),
('812', '45', '176', '309', '2023-06-02', '5782'),
('813', '45', '176', '310', '2023-06-02', '0'),
('814', '45', '176', '311', '2023-06-02', '0'),
('815', '47', '123', '205', '2023-05-30', '4244'),
('816', '47', '134', '238', '2023-05-30', '1538'),
('817', '47', '134', '239', '2023-05-30', '0'),
('818', '47', '134', '271', '2023-05-30', '0'),
('819', '47', '176', '309', '2023-05-31', '1960'),
('820', '47', '176', '310', '2023-05-31', '0'),
('821', '47', '176', '311', '2023-05-31', '0'),
('822', '45', '123', '205', '2023-06-02', '4244'),
('823', '45', '134', '238', '2023-06-02', '1538'),
('824', '45', '134', '239', '2023-06-02', '0'),
('825', '45', '134', '271', '2023-06-02', '0'),
('826', '45', '176', '309', '2023-06-03', '1960'),
('827', '45', '176', '310', '2023-06-03', '0'),
('828', '45', '176', '311', '2023-06-03', '0'),
('829', '47', '220', '359', '2023-06-01', '2700'),
('830', '47', '222', '361', '2023-05-31', '25'),
('831', '47', '138', '244', '2023-05-17', '5002'),
('832', '47', '138', '245', '2023-05-17', '4900'),
('833', '47', '175', '307', '2023-05-24', '64400'),
('834', '47', '175', '308', '2023-05-24', '37400'),
('835', '47', '136', '242', '2023-06-25', '1000'),
('836', '47', '180', '317', '2023-05-25', '0'),
('837', '47', '180', '318', '2023-05-25', '180'),
('838', '47', '221', '360', '2023-05-31', '3406'),
('839', '47', '169', '293', '2023-05-31', '762'),
('840', '47', '180', '317', '2023-05-31', '38'),
('841', '47', '180', '318', '2023-05-31', '0'),
('842', '47', '134', '238', '2023-05-31', '1960'),
('843', '47', '134', '239', '2023-05-31', '0'),
('844', '47', '134', '271', '2023-05-31', '0'),
('845', '47', '176', '309', '2023-06-01', '1960'),
('846', '47', '176', '310', '2023-06-01', '0'),
('847', '47', '176', '311', '2023-06-01', '0'),
('848', '45', '221', '360', '2023-06-03', '3406'),
('849', '45', '180', '317', '2023-06-03', '38'),
('850', '45', '180', '318', '2023-06-03', '180'),
('851', '45', '134', '238', '2023-06-03', '1960'),
('852', '45', '134', '239', '2023-06-03', '0'),
('853', '45', '134', '271', '2023-06-03', '0'),
('854', '45', '136', '242', '2023-06-03', '1000'),
('855', '45', '138', '244', '2023-06-03', '5002'),
('856', '45', '138', '245', '2023-06-03', '4900'),
('857', '45', '175', '307', '2023-06-03', '64400'),
('858', '45', '175', '308', '2023-06-03', '37400'),
('859', '45', '176', '309', '2023-06-03', '1960'),
('860', '45', '176', '310', '2023-06-03', '0'),
('861', '45', '176', '311', '2023-06-03', '0'),
('862', '45', '169', '293', '2023-06-03', '762'),
('863', '47', '180', '317', '2023-06-03', '1910'),
('864', '47', '180', '318', '2023-06-03', '0'),
('865', '47', '134', '238', '2023-06-03', '1960'),
('866', '47', '134', '239', '2023-06-03', '0'),
('867', '47', '134', '271', '2023-06-03', '0'),
('868', '45', '220', '359', '2023-06-06', '2700'),
('869', '45', '222', '361', '2023-06-06', '25'),
('870', '45', '193', '332', '2023-06-06', '900'),
('871', '45', '180', '317', '2023-06-06', '1910'),
('872', '45', '180', '318', '2023-06-06', '0'),
('873', '45', '134', '238', '2023-06-06', '1960'),
('874', '45', '134', '239', '2023-06-06', '0'),
('875', '45', '134', '271', '2023-06-06', '0'),
('876', '47', '134', '238', '2023-06-06', '4000'),
('877', '47', '134', '239', '2023-06-06', '0'),
('878', '47', '134', '271', '2023-06-06', '0'),
('879', '47', '176', '309', '2023-06-03', '3920'),
('880', '47', '176', '310', '2023-06-03', '0'),
('881', '47', '176', '311', '2023-06-03', '0'),
('882', '45', '134', '238', '2023-06-08', '4000'),
('883', '45', '134', '239', '2023-06-08', '0'),
('884', '45', '134', '271', '2023-06-08', '0'),
('885', '45', '176', '309', '2023-06-08', '3920'),
('886', '45', '176', '310', '2023-06-08', '0'),
('887', '45', '176', '311', '2023-06-08', '0'),
('888', '47', '245', '386', '2023-06-03', '250'),
('889', '47', '245', '387', '2023-06-03', '210'),
('890', '47', '245', '388', '2023-06-03', '50'),
('891', '45', '245', '386', '2023-06-10', '250'),
('892', '45', '245', '387', '2023-06-10', '210'),
('893', '45', '245', '388', '2023-06-10', '50'),
('894', '47', '247', '391', '2023-06-10', '25'),
('895', '47', '180', '317', '2023-06-09', '860'),
('896', '47', '180', '318', '2023-06-09', '1300'),
('897', '47', '176', '309', '2023-06-05', '3871'),
('898', '47', '176', '310', '2023-06-05', '0'),
('899', '47', '176', '311', '2023-06-05', '3790'),
('900', '47', '176', '309', '2023-06-08', '3479'),
('901', '47', '176', '310', '2023-06-08', '0'),
('902', '47', '176', '311', '2023-06-08', '3480'),
('903', '47', '166', '288', '2023-06-10', '0'),
('904', '47', '166', '289', '2023-06-10', '1950'),
('905', '47', '166', '290', '2023-06-10', '0'),
('906', '47', '249', '393', '2023-06-12', '5'),
('907', '47', '223', '362', '2023-06-12', '542'),
('908', '47', '223', '363', '2023-06-12', '1169'),
('909', '47', '223', '364', '2023-06-12', '0'),
('910', '47', '180', '317', '2023-06-12', '870'),
('911', '47', '180', '318', '2023-06-12', '0'),
('912', '45', '223', '362', '2023-06-12', '542'),
('913', '45', '223', '363', '2023-06-12', '1169'),
('914', '45', '223', '364', '2023-06-12', '0'),
('915', '45', '180', '317', '2023-06-12', '1730'),
('916', '45', '180', '318', '2023-06-12', '1300'),
('917', '47', '176', '309', '2023-05-23', '1538'),
('918', '47', '176', '310', '2023-05-23', '0'),
('919', '47', '176', '311', '2023-05-23', '0'),
('920', '47', '176', '309', '2023-05-24', '1960'),
('921', '47', '176', '310', '2023-05-24', '0'),
('922', '47', '176', '311', '2023-05-24', '0'),
('923', '47', '176', '309', '2023-05-30', '5782'),
('924', '47', '176', '310', '2023-05-30', '0'),
('925', '47', '176', '311', '2023-05-30', '0'),
('926', '47', '176', '309', '2023-06-01', '1960'),
('927', '47', '176', '310', '2023-06-01', '0'),
('928', '47', '176', '311', '2023-06-01', '0'),
('929', '47', '176', '309', '2023-06-03', '3920'),
('930', '47', '176', '310', '2023-06-03', '0'),
('931', '47', '176', '311', '2023-06-03', '0'),
('932', '47', '176', '309', '2023-06-05', '3871'),
('933', '47', '176', '310', '2023-06-05', '0'),
('934', '47', '176', '311', '2023-06-05', '0'),
('935', '45', '166', '288', '2023-06-12', '0'),
('936', '45', '166', '289', '2023-06-12', '1950'),
('937', '45', '166', '290', '2023-06-12', '0'),
('938', '45', '176', '309', '2023-06-12', '19031'),
('939', '45', '176', '310', '2023-06-12', '0'),
('940', '45', '176', '311', '2023-06-12', '0'),
('941', '47', '248', '392', '2023-06-13', '25'),
('942', '45', '249', '393', '2023-06-13', '5'),
('943', '45', '248', '392', '2023-06-13', '25'),
('944', '45', '247', '391', '2023-06-13', '25'),
('945', '47', '246', '389', '2023-06-12', '4315.3'),
('946', '47', '246', '390', '2023-06-12', '1250'),
('947', '47', '251', '396', '2023-02-28', '348'),
('948', '45', '251', '396', '2023-06-13', '348'),
('949', '47', '252', '397', '2023-03-31', '12'),
('950', '45', '252', '397', '2023-06-13', '12'),
('951', '47', '253', '398', '2023-06-05', '500'),
('952', '45', '246', '389', '2023-06-14', '4315.3'),
('953', '45', '246', '390', '2023-06-14', '1250'),
('954', '45', '253', '398', '2023-06-14', '500'),
('955', '47', '176', '309', '2023-06-13', '1813'),
('956', '47', '176', '310', '2023-06-13', '0'),
('957', '47', '176', '311', '2023-06-13', '3000'),
('958', '47', '254', '399', '2023-03-24', '1624'),
('959', '47', '254', '399', '2023-03-27', '504'),
('960', '45', '254', '399', '2023-06-14', '2128'),
('961', '47', '250', '394', '2023-06-14', '714.5'),
('962', '47', '250', '395', '2023-06-14', '1077.4'),
('963', '47', '255', '400', '2023-04-08', '25'),
('964', '45', '255', '400', '2023-06-14', '25'),
('965', '47', '166', '288', '2023-05-30', '0'),
('966', '47', '166', '289', '2023-05-30', '1950'),
('967', '47', '166', '290', '2023-05-30', '0'),
('968', '47', '166', '288', '2023-06-14', '754'),
('969', '47', '166', '289', '2023-06-14', '0'),
('970', '47', '166', '290', '2023-06-14', '750'),
('971', '48', '166', '288', '2023-05-30', '0'),
('972', '48', '166', '289', '2023-05-30', '1950'),
('973', '48', '166', '290', '2023-05-30', '0'),
('974', '48', '166', '288', '2023-06-14', '754'),
('975', '48', '166', '289', '2023-06-14', '1950'),
('976', '48', '166', '290', '2023-06-14', '750'),
('977', '45', '176', '309', '2023-06-15', '1813'),
('978', '45', '176', '310', '2023-06-15', '0'),
('979', '45', '176', '311', '2023-06-15', '3000'),
('980', '47', '166', '288', '2023-06-13', '754'),
('981', '47', '166', '289', '2023-06-13', '3900'),
('982', '47', '166', '290', '2023-06-13', '750'),
('983', '48', '166', '288', '2023-06-14', '754'),
('984', '48', '166', '289', '2023-06-14', '1950'),
('985', '48', '166', '290', '2023-06-14', '750'),
('986', '47', '166', '288', '2023-06-15', '754'),
('987', '47', '166', '289', '2023-06-15', '1950'),
('988', '47', '166', '290', '2023-06-15', '750'),
('989', '45', '166', '288', '2023-06-15', '754'),
('990', '45', '166', '289', '2023-06-15', '1950'),
('991', '45', '166', '290', '2023-06-15', '750'),
('992', '47', '176', '309', '2023-06-15', '1862'),
('993', '47', '176', '310', '2023-06-15', '0'),
('994', '47', '176', '311', '2023-06-15', '785'),
('995', '45', '176', '309', '2023-06-15', '1862'),
('996', '45', '176', '310', '2023-06-15', '0'),
('997', '45', '176', '311', '2023-06-15', '785'),
('998', '47', '57', '98', '2023-06-15', '0'),
('999', '47', '57', '99', '2023-06-15', '3300'),
('1000', '45', '57', '98', '2023-06-16', '0'),
('1001', '45', '57', '99', '2023-06-16', '3300'),
('1002', '45', '250', '394', '2023-06-16', '714.5'),
('1003', '45', '250', '395', '2023-06-16', '1077.4'),
('1004', '47', '176', '309', '2023-06-16', '2449'),
('1005', '47', '176', '310', '2023-06-16', '0'),
('1006', '47', '176', '311', '2023-06-16', '2450'),
('1007', '47', '57', '98', '2023-06-16', '0'),
('1008', '47', '57', '99', '2023-06-16', '13800'),
('1009', '45', '176', '309', '2023-06-16', '2449'),
('1010', '45', '176', '310', '2023-06-16', '0'),
('1011', '45', '176', '311', '2023-06-16', '2450'),
('1012', '45', '57', '98', '2023-06-16', '0'),
('1013', '45', '57', '99', '2023-06-16', '13800'),
('1014', '47', '260', '405', '2023-06-12', '687'),
('1015', '47', '261', '406', '2023-06-13', '1039'),
('1016', '45', '260', '405', '2023-06-17', '687'),
('1017', '45', '261', '406', '2023-06-17', '1039'),
('1018', '47', '57', '98', '2023-06-17', '0'),
('1019', '47', '57', '99', '2023-06-17', '6300'),
('1020', '45', '57', '98', '2023-06-17', '0'),
('1021', '45', '57', '99', '2023-06-17', '6300'),
('1022', '47', '180', '317', '2023-06-19', '1050'),
('1023', '47', '180', '318', '2023-06-19', '1007'),
('1024', '45', '180', '317', '2023-06-19', '1050'),
('1025', '45', '180', '318', '2023-06-19', '1007'),
('1026', '47', '265', '410', '2023-06-20', '2000'),
('1027', '45', '265', '410', '2023-06-20', '2000'),
('1028', '47', '266', '411', '2023-06-20', '5110'),
('1029', '47', '266', '412', '2023-06-20', '5025'),
('1030', '47', '266', '413', '2023-06-20', '5100'),
('1031', '47', '266', '414', '2023-06-20', '5130'),
('1032', '45', '266', '411', '2023-06-20', '5110'),
('1033', '45', '266', '412', '2023-06-20', '5025'),
('1034', '45', '266', '413', '2023-06-20', '5100'),
('1035', '45', '266', '414', '2023-06-20', '5130'),
('1036', '47', '267', '415', '2023-06-20', '220'),
('1037', '47', '176', '309', '2023-06-21', '9212'),
('1038', '47', '176', '310', '2023-06-21', '5000'),
('1039', '47', '176', '311', '2023-06-21', '4500'),
('1040', '45', '176', '309', '2023-06-22', '9212'),
('1041', '45', '176', '310', '2023-06-22', '5000'),
('1042', '45', '176', '311', '2023-06-22', '4500'),
('1043', '47', '86', '155', '2023-06-21', '3696'),
('1044', '47', '86', '279', '2023-06-21', '3705'),
('1045', '47', '223', '362', '2023-06-19', '542'),
('1046', '47', '223', '363', '2023-06-19', '1169'),
('1047', '47', '223', '364', '2023-06-19', '375'),
('1048', '45', '223', '362', '2023-06-22', '542'),
('1049', '45', '223', '363', '2023-06-22', '1169'),
('1050', '45', '223', '364', '2023-06-22', '375'),
('1051', '45', '86', '155', '2023-06-22', '3696'),
('1052', '45', '86', '279', '2023-06-22', '3705'),
('1053', '47', '84', '151', '2023-02-22', '5'),
('1054', '45', '267', '415', '2023-06-23', '220'),
('1055', '45', '84', '151', '2023-06-23', '5'),
('1056', '47', '86', '155', '2023-05-04', '1344'),
('1057', '47', '86', '279', '2023-05-04', '1345'),
('1058', '45', '86', '155', '2023-06-23', '1344'),
('1059', '45', '86', '279', '2023-06-23', '1345'),
('1060', '47', '139', '246', '2023-05-17', '4980'),
('1061', '47', '139', '247', '2023-05-17', '5010'),
('1062', '45', '139', '246', '2023-06-23', '4980');
INSERT INTO `0_inward_grn` VALUES
('1063', '45', '139', '247', '2023-06-23', '5010'),
('1064', '47', '100', '179', '2023-04-17', '9400'),
('1065', '47', '100', '180', '2023-04-17', '11160'),
('1066', '45', '100', '179', '2023-06-23', '9400'),
('1067', '45', '100', '180', '2023-06-23', '11160'),
('1068', '47', '262', '407', '2023-06-13', '600'),
('1069', '47', '263', '408', '2023-06-13', '600'),
('1070', '45', '262', '407', '2023-06-23', '600'),
('1071', '45', '263', '408', '2023-06-23', '600'),
('1072', '47', '268', '416', '2023-06-23', '900'),
('1073', '47', '269', '417', '2023-06-23', '2160'),
('1074', '47', '269', '418', '2023-06-23', '0'),
('1075', '45', '269', '417', '2023-06-23', '2160'),
('1076', '45', '269', '418', '2023-06-23', '0'),
('1077', '47', '270', '419', '2023-06-24', '5000'),
('1078', '45', '270', '419', '2023-06-24', '5000'),
('1079', '47', '180', '317', '2023-06-24', '0'),
('1080', '47', '180', '318', '2023-06-24', '804'),
('1081', '45', '268', '416', '2023-06-26', '900'),
('1082', '47', '275', '432', '2023-06-24', '320'),
('1083', '47', '176', '309', '2023-06-27', '3871'),
('1084', '47', '176', '310', '2023-06-27', '1500'),
('1085', '47', '176', '311', '2023-06-27', '3000'),
('1086', '45', '176', '309', '2023-06-27', '3871'),
('1087', '45', '176', '310', '2023-06-27', '1500'),
('1088', '45', '176', '311', '2023-06-27', '3000'),
('1089', '45', '180', '317', '2023-06-27', '0'),
('1090', '45', '180', '318', '2023-06-27', '804'),
('1091', '45', '275', '432', '2023-07-03', '320'),
('1092', '47', '272', '421', '2023-07-03', '2'),
('1093', '47', '272', '422', '2023-07-03', '1'),
('1094', '47', '272', '423', '2023-07-03', '1'),
('1095', '47', '272', '424', '2023-07-03', '1'),
('1096', '47', '272', '425', '2023-07-03', '1'),
('1097', '47', '272', '426', '2023-07-03', '2'),
('1098', '45', '272', '421', '2023-07-03', '2'),
('1099', '45', '272', '422', '2023-07-03', '1'),
('1100', '45', '272', '423', '2023-07-03', '1'),
('1101', '45', '272', '424', '2023-07-03', '1'),
('1102', '45', '272', '425', '2023-07-03', '1'),
('1103', '45', '272', '426', '2023-07-03', '2'),
('1104', '47', '56', '96', '2023-04-15', '0'),
('1105', '47', '56', '97', '2023-04-15', '17900'),
('1106', '45', '56', '96', '2023-07-04', '0'),
('1107', '45', '56', '97', '2023-07-04', '17900'),
('1108', '47', '180', '317', '2023-06-24', '0'),
('1109', '47', '180', '318', '2023-06-24', '804'),
('1110', '48', '180', '317', '2023-06-24', '0'),
('1111', '48', '180', '318', '2023-06-24', '804'),
('1112', '47', '289', '471', '2023-07-07', '10'),
('1113', '45', '289', '471', '2023-07-07', '10'),
('1114', '47', '98', '168', '2023-07-07', '27744'),
('1115', '47', '98', '169', '2023-07-07', '33750'),
('1116', '47', '98', '170', '2023-07-07', '27744'),
('1117', '47', '98', '171', '2023-07-07', '33750'),
('1118', '47', '98', '172', '2023-07-07', '0'),
('1119', '47', '98', '173', '2023-07-07', '180000'),
('1120', '47', '98', '174', '2023-07-07', '35360'),
('1121', '47', '98', '175', '2023-07-07', '50000'),
('1122', '47', '98', '438', '2023-07-07', '0'),
('1123', '47', '98', '439', '2023-07-07', '60000'),
('1124', '45', '98', '168', '2023-07-07', '27744'),
('1125', '45', '98', '169', '2023-07-07', '33750'),
('1126', '45', '98', '170', '2023-07-07', '27744'),
('1127', '45', '98', '171', '2023-07-07', '33750'),
('1128', '45', '98', '172', '2023-07-07', '0'),
('1129', '45', '98', '173', '2023-07-07', '180000'),
('1130', '45', '98', '174', '2023-07-07', '35360'),
('1131', '45', '98', '175', '2023-07-07', '50000'),
('1132', '45', '98', '438', '2023-07-07', '0'),
('1133', '45', '98', '439', '2023-07-07', '60000'),
('1134', '48', '180', '317', '2023-06-24', '0'),
('1135', '48', '180', '318', '2023-06-24', '804'),
('1136', '47', '98', '168', '2023-07-08', '0'),
('1137', '47', '98', '169', '2023-07-08', '0'),
('1138', '47', '98', '170', '2023-07-08', '8845'),
('1139', '47', '98', '171', '2023-07-08', '0'),
('1140', '47', '98', '172', '2023-07-08', '25200'),
('1141', '47', '98', '173', '2023-07-08', '0'),
('1142', '47', '98', '174', '2023-07-08', '38662'),
('1143', '47', '98', '175', '2023-07-08', '25000'),
('1144', '47', '98', '438', '2023-07-08', '57802'),
('1145', '47', '98', '439', '2023-07-08', '0'),
('1146', '45', '98', '168', '2023-07-08', '0'),
('1147', '45', '98', '169', '2023-07-08', '0'),
('1148', '45', '98', '170', '2023-07-08', '8845'),
('1149', '45', '98', '171', '2023-07-08', '0'),
('1150', '45', '98', '172', '2023-07-08', '25200'),
('1151', '45', '98', '173', '2023-07-08', '0'),
('1152', '45', '98', '174', '2023-07-08', '38662'),
('1153', '45', '98', '175', '2023-07-08', '25000'),
('1154', '45', '98', '438', '2023-07-08', '57802'),
('1155', '45', '98', '439', '2023-07-08', '0'),
('1156', '47', '180', '317', '2023-07-08', '0'),
('1157', '47', '180', '318', '2023-07-08', '804'),
('1158', '45', '180', '317', '2023-07-08', '0'),
('1159', '45', '180', '318', '2023-07-08', '804'),
('1160', '47', '269', '417', '2023-07-08', '3960'),
('1161', '47', '269', '418', '2023-07-08', '0'),
('1162', '45', '269', '417', '2023-07-10', '3960'),
('1163', '45', '269', '418', '2023-07-10', '0'),
('1164', '47', '19', '40', '2023-03-18', '9000'),
('1165', '47', '19', '43', '2023-03-18', '8700'),
('1166', '45', '19', '40', '2023-07-10', '9000'),
('1167', '45', '19', '43', '2023-07-10', '8700'),
('1168', '47', '276', '433', '2023-07-05', '325'),
('1169', '47', '277', '434', '2023-07-05', '325'),
('1170', '45', '276', '433', '2023-07-10', '325'),
('1171', '45', '277', '434', '2023-07-10', '325'),
('1172', '47', '294', '477', '2023-07-11', '2050'),
('1173', '47', '295', '478', '2023-07-11', '1280'),
('1174', '47', '128', '214', '2023-07-11', '13800'),
('1175', '47', '128', '215', '2023-07-11', '0'),
('1176', '45', '295', '478', '2023-07-12', '1280'),
('1177', '45', '294', '477', '2023-07-12', '2050'),
('1178', '47', '98', '168', '2023-07-13', '0'),
('1179', '47', '98', '169', '2023-07-13', '0'),
('1180', '47', '98', '170', '2023-07-13', '0'),
('1181', '47', '98', '171', '2023-07-13', '0'),
('1182', '47', '98', '172', '2023-07-13', '149353'),
('1183', '47', '98', '173', '2023-07-13', '0'),
('1184', '47', '98', '174', '2023-07-13', '0'),
('1185', '47', '98', '175', '2023-07-13', '0'),
('1186', '47', '98', '438', '2023-07-13', '0'),
('1187', '47', '98', '439', '2023-07-13', '0'),
('1188', '47', '303', '491', '2023-07-12', '655'),
('1189', '47', '304', '492', '2023-07-12', '655'),
('1190', '45', '303', '491', '2023-07-13', '655'),
('1191', '45', '304', '492', '2023-07-13', '655'),
('1192', '45', '98', '168', '2023-07-14', '0'),
('1193', '45', '98', '169', '2023-07-14', '0'),
('1194', '45', '98', '170', '2023-07-14', '0'),
('1195', '45', '98', '171', '2023-07-14', '0'),
('1196', '45', '98', '172', '2023-07-14', '149353'),
('1197', '45', '98', '173', '2023-07-14', '0'),
('1198', '45', '98', '174', '2023-07-14', '0'),
('1199', '45', '98', '175', '2023-07-14', '0'),
('1200', '45', '98', '438', '2023-07-14', '0'),
('1201', '45', '98', '439', '2023-07-14', '0'),
('1202', '47', '306', '496', '2023-07-13', '16'),
('1203', '45', '306', '496', '2023-07-14', '16'),
('1204', '47', '329', '547', '2023-07-08', '1254'),
('1205', '45', '329', '547', '2023-07-14', '1254'),
('1206', '47', '325', '540', '2023-07-14', '5000'),
('1207', '47', '297', '480', '2023-07-15', '328.4'),
('1208', '47', '297', '481', '2023-07-15', '0'),
('1209', '47', '302', '488', '2023-07-17', '0'),
('1210', '47', '302', '489', '2023-07-17', '0'),
('1211', '47', '302', '490', '2023-07-17', '1'),
('1212', '47', '311', '502', '2023-07-17', '0.1'),
('1213', '47', '311', '503', '2023-07-17', '0.1'),
('1214', '47', '311', '504', '2023-07-17', '0.1'),
('1215', '47', '311', '505', '2023-07-17', '0.1'),
('1216', '47', '311', '506', '2023-07-17', '1'),
('1217', '47', '318', '521', '2023-07-17', '0.25'),
('1218', '47', '319', '522', '2023-07-17', '0.5'),
('1219', '47', '320', '523', '2023-07-17', '1'),
('1220', '47', '320', '524', '2023-07-17', '0.8'),
('1221', '47', '320', '525', '2023-07-17', '0.5'),
('1222', '47', '320', '526', '2023-07-17', '1'),
('1223', '47', '320', '527', '2023-07-17', '1'),
('1224', '47', '320', '528', '2023-07-17', '0.5'),
('1225', '47', '320', '529', '2023-07-17', '1'),
('1226', '47', '320', '530', '2023-07-17', '1'),
('1227', '47', '320', '531', '2023-07-17', '2'),
('1228', '47', '327', '542', '2023-07-17', '0.5'),
('1229', '47', '327', '543', '2023-07-17', '0.5'),
('1230', '47', '327', '544', '2023-07-17', '0.5'),
('1231', '47', '327', '545', '2023-07-17', '0.5'),
('1232', '47', '317', '512', '2023-07-17', '0.5'),
('1233', '47', '317', '513', '2023-07-17', '0.5'),
('1234', '47', '317', '514', '2023-07-17', '1'),
('1235', '47', '317', '515', '2023-07-17', '0.45'),
('1236', '47', '317', '516', '2023-07-17', '0.5'),
('1237', '47', '317', '517', '2023-07-17', '1'),
('1238', '47', '317', '518', '2023-07-17', '1'),
('1239', '47', '317', '519', '2023-07-17', '0.8'),
('1240', '47', '317', '520', '2023-07-17', '0.25'),
('1241', '47', '287', '467', '2023-07-08', '360'),
('1242', '47', '299', '485', '2023-07-17', '30'),
('1243', '47', '300', '486', '2023-07-17', '60'),
('1244', '45', '325', '540', '2023-07-17', '5000'),
('1245', '47', '293', '476', '2023-07-15', '2150.2'),
('1246', '47', '297', '480', '2023-07-15', '1.6'),
('1247', '47', '297', '481', '2023-07-15', '2696.6'),
('1248', '47', '315', '510', '2023-07-14', '885'),
('1249', '47', '316', '511', '2023-07-14', '885'),
('1250', '45', '315', '510', '2023-07-18', '885'),
('1251', '45', '316', '511', '2023-07-18', '885'),
('1252', '47', '363', '664', '2023-07-18', '11'),
('1253', '47', '363', '665', '2023-07-18', '11'),
('1254', '47', '363', '666', '2023-07-18', '22'),
('1255', '47', '363', '667', '2023-07-18', '4'),
('1256', '47', '363', '668', '2023-07-18', '100'),
('1257', '47', '274', '431', '2023-07-18', '2000'),
('1258', '45', '302', '488', '2023-07-18', '0'),
('1259', '45', '302', '489', '2023-07-18', '0'),
('1260', '45', '302', '490', '2023-07-18', '1'),
('1261', '45', '300', '486', '2023-07-18', '60'),
('1262', '45', '299', '485', '2023-07-18', '30'),
('1263', '45', '297', '480', '2023-07-18', '330'),
('1264', '45', '297', '481', '2023-07-18', '2696.6'),
('1265', '45', '293', '476', '2023-07-18', '2150.2'),
('1266', '45', '363', '664', '2023-07-19', '11'),
('1267', '45', '363', '665', '2023-07-19', '11'),
('1268', '45', '363', '666', '2023-07-19', '22'),
('1269', '45', '363', '667', '2023-07-19', '4'),
('1270', '45', '363', '668', '2023-07-19', '100'),
('1271', '48', '128', '214', '2023-07-19', '18000'),
('1272', '48', '128', '215', '2023-07-19', '0'),
('1273', '47', '285', '464', '2023-07-19', '6336'),
('1274', '47', '374', '717', '2023-07-18', '1'),
('1275', '47', '301', '487', '2023-07-19', '320'),
('1276', '47', '176', '309', '2023-07-19', '2940'),
('1277', '47', '176', '310', '2023-07-19', '0'),
('1278', '47', '176', '311', '2023-07-19', '5000'),
('1279', '47', '351', '608', '2023-07-17', '1180'),
('1280', '45', '351', '608', '2023-07-20', '1180'),
('1281', '45', '176', '309', '2023-07-20', '2940'),
('1282', '45', '176', '310', '2023-07-20', '0'),
('1283', '45', '176', '311', '2023-07-20', '5000'),
('1284', '45', '374', '717', '2023-07-20', '1'),
('1285', '45', '285', '464', '2023-07-20', '6336'),
('1286', '45', '274', '431', '2023-07-20', '2000'),
('1287', '47', '364', '669', '2023-07-20', '5'),
('1288', '47', '364', '670', '2023-07-20', '5'),
('1289', '47', '364', '671', '2023-07-20', '5'),
('1290', '47', '364', '672', '2023-07-20', '1'),
('1291', '47', '364', '673', '2023-07-20', '3'),
('1292', '47', '364', '674', '2023-07-20', '3'),
('1293', '47', '364', '675', '2023-07-20', '1'),
('1294', '47', '364', '676', '2023-07-20', '3'),
('1295', '47', '364', '677', '2023-07-20', '3'),
('1296', '47', '364', '678', '2023-07-20', '3'),
('1297', '47', '364', '679', '2023-07-20', '1'),
('1298', '47', '364', '680', '2023-07-20', '1'),
('1299', '47', '364', '681', '2023-07-20', '2'),
('1300', '47', '364', '682', '2023-07-20', '2'),
('1301', '47', '364', '683', '2023-07-20', '1'),
('1302', '45', '364', '669', '2023-07-20', '5'),
('1303', '45', '364', '670', '2023-07-20', '5'),
('1304', '45', '364', '671', '2023-07-20', '5'),
('1305', '45', '364', '672', '2023-07-20', '1'),
('1306', '45', '364', '673', '2023-07-20', '3'),
('1307', '45', '364', '674', '2023-07-20', '3'),
('1308', '45', '364', '675', '2023-07-20', '1'),
('1309', '45', '364', '676', '2023-07-20', '3'),
('1310', '45', '364', '677', '2023-07-20', '3'),
('1311', '45', '364', '678', '2023-07-20', '3'),
('1312', '45', '364', '679', '2023-07-20', '1'),
('1313', '45', '364', '680', '2023-07-20', '1'),
('1314', '45', '364', '681', '2023-07-20', '2'),
('1315', '45', '364', '682', '2023-07-20', '2'),
('1316', '45', '364', '683', '2023-07-20', '1'),
('1317', '47', '365', '684', '2023-07-20', '1'),
('1318', '47', '365', '685', '2023-07-20', '1'),
('1319', '45', '365', '684', '2023-07-20', '1'),
('1320', '45', '365', '685', '2023-07-20', '1'),
('1321', '47', '366', '686', '2023-07-20', '24'),
('1322', '47', '366', '687', '2023-07-20', '12'),
('1323', '47', '366', '688', '2023-07-20', '12'),
('1324', '47', '366', '689', '2023-07-20', '12'),
('1325', '47', '366', '690', '2023-07-20', '12'),
('1326', '45', '366', '686', '2023-07-20', '24'),
('1327', '45', '366', '687', '2023-07-20', '12'),
('1328', '45', '366', '688', '2023-07-20', '12'),
('1329', '45', '366', '689', '2023-07-20', '12'),
('1330', '45', '366', '690', '2023-07-20', '12'),
('1331', '47', '367', '691', '2023-07-18', '2'),
('1332', '45', '367', '691', '2023-07-20', '2'),
('1333', '47', '287', '467', '2023-07-19', '540'),
('1334', '45', '301', '487', '2023-07-21', '320'),
('1335', '45', '287', '467', '2023-07-21', '900'),
('1336', '47', '176', '309', '2023-07-21', '9800'),
('1337', '47', '176', '310', '2023-07-21', '0'),
('1338', '47', '176', '311', '2023-07-21', '9800'),
('1339', '45', '176', '309', '2023-07-21', '9800'),
('1340', '45', '176', '310', '2023-07-21', '0'),
('1341', '45', '176', '311', '2023-07-21', '9800'),
('1342', '47', '409', '794', '2023-07-21', '8'),
('1343', '47', '409', '795', '2023-07-21', '8'),
('1344', '45', '409', '794', '2023-07-21', '8'),
('1345', '45', '409', '795', '2023-07-21', '8'),
('1346', '47', '296', '479', '2023-07-21', '1065'),
('1347', '47', '302', '488', '2023-07-21', '25'),
('1348', '47', '302', '489', '2023-07-21', '50'),
('1349', '47', '302', '490', '2023-07-21', '0'),
('1350', '47', '341', '573', '2023-07-19', '690'),
('1351', '47', '342', '574', '2023-07-19', '690'),
('1352', '45', '341', '573', '2023-07-22', '690'),
('1353', '45', '342', '574', '2023-07-22', '690'),
('1354', '47', '286', '465', '2023-07-22', '2100'),
('1355', '47', '286', '466', '2023-07-22', '2100'),
('1356', '45', '286', '465', '2023-07-24', '2100'),
('1357', '45', '286', '466', '2023-07-24', '2100'),
('1358', '47', '414', '800', '2023-07-24', '5'),
('1359', '47', '414', '801', '2023-07-24', '2'),
('1360', '47', '414', '802', '2023-07-24', '1'),
('1361', '47', '414', '803', '2023-07-24', '1'),
('1362', '47', '414', '804', '2023-07-24', '1'),
('1363', '47', '176', '309', '2023-07-24', '2254'),
('1364', '47', '176', '310', '2023-07-24', '0'),
('1365', '47', '176', '311', '2023-07-24', '2500'),
('1366', '47', '269', '417', '2023-07-24', '1380'),
('1367', '47', '269', '418', '2023-07-24', '0'),
('1368', '45', '176', '309', '2023-07-24', '2254'),
('1369', '45', '176', '310', '2023-07-24', '0'),
('1370', '45', '176', '311', '2023-07-24', '2500'),
('1371', '45', '269', '417', '2023-07-24', '1380'),
('1372', '45', '269', '418', '2023-07-24', '0'),
('1373', '47', '324', '539', '2023-07-15', '5'),
('1374', '47', '387', '755', '2023-07-24', '720'),
('1375', '47', '387', '756', '2023-07-24', '4'),
('1376', '47', '269', '417', '2023-07-24', '0'),
('1377', '47', '269', '418', '2023-07-24', '7500'),
('1378', '45', '269', '417', '2023-07-25', '0'),
('1379', '45', '269', '418', '2023-07-25', '7500'),
('1380', '47', '256', '401', '2023-05-12', '5'),
('1381', '47', '412', '798', '2023-07-25', '635'),
('1382', '47', '386', '754', '2023-07-22', '203'),
('1383', '47', '386', '754', '2023-07-22', '7'),
('1384', '45', '296', '479', '2023-07-25', '1065'),
('1385', '45', '302', '488', '2023-07-25', '25'),
('1386', '45', '302', '489', '2023-07-25', '50'),
('1387', '45', '302', '490', '2023-07-25', '0'),
('1388', '45', '414', '800', '2023-07-25', '5'),
('1389', '45', '414', '801', '2023-07-25', '2'),
('1390', '45', '414', '802', '2023-07-25', '1'),
('1391', '45', '414', '803', '2023-07-25', '1'),
('1392', '45', '414', '804', '2023-07-25', '1'),
('1393', '45', '320', '523', '2023-07-25', '1'),
('1394', '45', '320', '524', '2023-07-25', '0.8'),
('1395', '45', '320', '525', '2023-07-25', '0.5'),
('1396', '45', '320', '526', '2023-07-25', '1'),
('1397', '45', '320', '527', '2023-07-25', '1'),
('1398', '45', '320', '528', '2023-07-25', '0.5'),
('1399', '45', '320', '529', '2023-07-25', '1'),
('1400', '45', '320', '530', '2023-07-25', '1'),
('1401', '45', '320', '531', '2023-07-25', '2'),
('1402', '45', '319', '522', '2023-07-25', '0.5'),
('1403', '45', '318', '521', '2023-07-25', '0.25'),
('1404', '45', '317', '512', '2023-07-25', '0.5'),
('1405', '45', '317', '513', '2023-07-25', '0.5'),
('1406', '45', '317', '514', '2023-07-25', '1'),
('1407', '45', '317', '515', '2023-07-25', '0.45'),
('1408', '45', '317', '516', '2023-07-25', '0.5'),
('1409', '45', '317', '517', '2023-07-25', '1'),
('1410', '45', '317', '518', '2023-07-25', '1'),
('1411', '45', '317', '519', '2023-07-25', '0.8'),
('1412', '45', '317', '520', '2023-07-25', '0.25'),
('1413', '45', '412', '798', '2023-07-25', '635'),
('1414', '45', '387', '755', '2023-07-25', '720'),
('1415', '45', '387', '756', '2023-07-25', '4'),
('1416', '45', '311', '502', '2023-07-25', '0.1'),
('1417', '45', '311', '503', '2023-07-25', '0.1'),
('1418', '45', '311', '504', '2023-07-25', '0.1'),
('1419', '45', '311', '505', '2023-07-25', '0.1'),
('1420', '45', '311', '506', '2023-07-25', '1'),
('1421', '45', '386', '754', '2023-07-25', '210'),
('1422', '45', '327', '542', '2023-07-25', '0.5'),
('1423', '45', '327', '543', '2023-07-25', '0.5'),
('1424', '45', '327', '544', '2023-07-25', '0.5'),
('1425', '45', '327', '545', '2023-07-25', '0.5'),
('1426', '45', '324', '539', '2023-07-25', '5'),
('1427', '47', '340', '572', '2023-07-26', '4'),
('1428', '47', '424', '814', '2023-07-26', '5'),
('1429', '47', '424', '815', '2023-07-26', '1'),
('1430', '47', '446', '888', '2023-06-17', '0.045'),
('1431', '47', '438', '868', '2023-06-08', '0.05'),
('1432', '47', '438', '869', '2023-06-08', '0.05'),
('1433', '47', '438', '870', '2023-06-08', '0.05'),
('1434', '47', '448', '891', '2023-07-17', '3'),
('1435', '47', '448', '892', '2023-07-17', '10'),
('1436', '47', '448', '893', '2023-07-17', '0.05'),
('1437', '47', '448', '894', '2023-07-17', '0.05'),
('1438', '47', '457', '916', '2023-06-03', '2'),
('1439', '45', '448', '891', '2023-07-26', '3'),
('1440', '45', '448', '892', '2023-07-26', '10'),
('1441', '45', '448', '893', '2023-07-26', '0.05'),
('1442', '45', '448', '894', '2023-07-26', '0.05'),
('1443', '45', '340', '572', '2023-07-26', '4'),
('1444', '45', '424', '814', '2023-07-26', '5'),
('1445', '45', '424', '815', '2023-07-26', '1'),
('1446', '47', '412', '798', '2023-07-21', '770'),
('1447', '47', '413', '799', '2023-07-21', '770'),
('1448', '45', '412', '798', '2023-07-27', '770'),
('1449', '45', '413', '799', '2023-07-27', '770'),
('1450', '47', '3', '17', '2023-08-01', '2100'),
('1451', '45', '3', '17', '2023-08-01', '2100'),
('1452', '47', '2', '4', '2023-08-03', '10'),
('1453', '47', '2', '5', '2023-08-03', '10'),
('1454', '47', '2', '6', '2023-08-03', '2'),
('1455', '47', '2', '7', '2023-08-03', '0.1'),
('1456', '47', '2', '8', '2023-08-03', '1'),
('1457', '47', '2', '9', '2023-08-03', '24'),
('1458', '47', '2', '10', '2023-08-03', '3'),
('1459', '47', '2', '11', '2023-08-03', '2'),
('1460', '47', '2', '12', '2023-08-03', '2'),
('1461', '47', '2', '14', '2023-08-03', '1'),
('1462', '47', '2', '15', '2023-08-03', '2'),
('1463', '47', '2', '16', '2023-08-03', '1'),
('1464', '47', '2', '18', '2023-08-03', '1'),
('1465', '47', '2', '37', '2023-08-03', '2'),
('1466', '47', '2', '38', '2023-08-03', '1'),
('1467', '47', '9', '30', '2023-08-03', '1'),
('1468', '47', '9', '31', '2023-08-03', '0.5'),
('1469', '47', '9', '32', '2023-08-03', '0.5'),
('1470', '47', '9', '34', '2023-08-03', '1'),
('1471', '47', '11', '39', '2023-08-03', '12'),
('1472', '47', '11', '40', '2023-08-03', '36'),
('1473', '47', '11', '41', '2023-08-03', '12'),
('1474', '47', '11', '42', '2023-08-03', '2'),
('1475', '47', '11', '43', '2023-08-03', '4'),
('1476', '47', '11', '44', '2023-08-03', '2'),
('1477', '47', '11', '45', '2023-08-03', '2'),
('1478', '47', '11', '46', '2023-08-03', '2'),
('1479', '47', '11', '47', '2023-08-03', '8'),
('1480', '47', '11', '49', '2023-08-03', '1'),
('1481', '47', '11', '50', '2023-08-03', '2'),
('1482', '45', '2', '4', '2023-08-03', '10'),
('1483', '45', '2', '5', '2023-08-03', '10'),
('1484', '45', '2', '6', '2023-08-03', '2'),
('1485', '45', '2', '7', '2023-08-03', '0.1'),
('1486', '45', '2', '8', '2023-08-03', '1'),
('1487', '45', '2', '9', '2023-08-03', '24'),
('1488', '45', '2', '10', '2023-08-03', '3'),
('1489', '45', '2', '11', '2023-08-03', '2'),
('1490', '45', '2', '12', '2023-08-03', '2'),
('1491', '45', '2', '14', '2023-08-03', '1'),
('1492', '45', '2', '15', '2023-08-03', '2'),
('1493', '45', '2', '16', '2023-08-03', '1'),
('1494', '45', '2', '18', '2023-08-03', '1'),
('1495', '45', '2', '37', '2023-08-03', '2'),
('1496', '45', '2', '38', '2023-08-03', '1'),
('1497', '45', '9', '30', '2023-08-03', '1'),
('1498', '45', '9', '31', '2023-08-03', '0.5'),
('1499', '45', '9', '32', '2023-08-03', '0.5'),
('1500', '45', '9', '34', '2023-08-03', '1'),
('1501', '45', '11', '39', '2023-08-03', '12'),
('1502', '45', '11', '40', '2023-08-03', '36'),
('1503', '45', '11', '41', '2023-08-03', '12'),
('1504', '45', '11', '42', '2023-08-03', '2'),
('1505', '45', '11', '43', '2023-08-03', '4'),
('1506', '45', '11', '44', '2023-08-03', '2'),
('1507', '45', '11', '45', '2023-08-03', '2'),
('1508', '45', '11', '46', '2023-08-03', '2'),
('1509', '45', '11', '47', '2023-08-03', '8'),
('1510', '45', '11', '49', '2023-08-03', '1'),
('1511', '45', '11', '50', '2023-08-03', '2'),
('1512', '47', '1', '1', '2023-08-03', '12'),
('1513', '47', '1', '2', '2023-08-03', '3'),
('1514', '47', '1', '3', '2023-08-03', '15'),
('1515', '45', '1', '1', '2023-08-04', '12'),
('1516', '45', '1', '2', '2023-08-04', '3'),
('1517', '45', '1', '3', '2023-08-04', '15'),
('1518', '47', '14', '65', '2023-08-04', '1'),
('1519', '47', '14', '66', '2023-08-04', '5'),
('1520', '47', '14', '67', '2023-08-04', '5'),
('1521', '45', '14', '65', '2023-08-04', '1'),
('1522', '45', '14', '66', '2023-08-04', '5'),
('1523', '45', '14', '67', '2023-08-04', '5'),
('1524', '47', '21', '95', '2023-08-02', '1'),
('1525', '47', '21', '96', '2023-08-02', '1'),
('1526', '45', '21', '95', '2023-08-04', '1'),
('1527', '45', '21', '96', '2023-08-04', '1'),
('1528', '47', '22', '97', '2023-08-04', '1'),
('1529', '45', '22', '97', '2023-08-04', '1'),
('1530', '47', '23', '98', '2023-08-04', '1'),
('1531', '45', '23', '98', '2023-08-04', '1'),
('1532', '47', '25', '100', '2023-08-05', '2100'),
('1533', '45', '25', '100', '2023-08-05', '2100'),
('1534', '47', '24', '99', '2023-08-03', '6480'),
('1535', '45', '24', '99', '2023-08-05', '6480'),
('1536', '47', '27', '103', '2023-08-03', '360'),
('1537', '45', '27', '103', '2023-08-05', '360'),
('1538', '47', '15', '68', '2023-08-04', '6'),
('1539', '47', '16', '70', '2023-08-04', '90'),
('1540', '47', '16', '71', '2023-08-04', '90'),
('1541', '47', '16', '72', '2023-08-04', '0'),
('1542', '47', '16', '73', '2023-08-04', '1'),
('1543', '47', '16', '74', '2023-08-04', '6'),
('1544', '47', '16', '75', '2023-08-04', '2'),
('1545', '47', '16', '76', '2023-08-04', '1'),
('1546', '47', '16', '77', '2023-08-04', '10'),
('1547', '47', '16', '78', '2023-08-04', '10'),
('1548', '47', '16', '79', '2023-08-04', '1'),
('1549', '45', '15', '68', '2023-08-05', '6'),
('1550', '45', '16', '70', '2023-08-05', '90'),
('1551', '45', '16', '71', '2023-08-05', '90'),
('1552', '45', '16', '72', '2023-08-05', '0'),
('1553', '45', '16', '73', '2023-08-05', '1'),
('1554', '45', '16', '74', '2023-08-05', '6'),
('1555', '45', '16', '75', '2023-08-05', '2'),
('1556', '45', '16', '76', '2023-08-05', '1'),
('1557', '45', '16', '77', '2023-08-05', '10'),
('1558', '45', '16', '78', '2023-08-05', '10'),
('1559', '45', '16', '79', '2023-08-05', '1'),
('1560', '47', '25', '105', '2023-08-05', '2100'),
('1561', '45', '25', '105', '2023-08-05', '2100'),
('1562', '47', '29', '106', '2023-08-01', '2'),
('1563', '45', '29', '106', '2023-08-05', '2'),
('1564', '47', '26', '101', '2023-08-07', '3233.6'),
('1565', '47', '26', '102', '2023-08-07', '0'),
('1566', '47', '26', '101', '2023-08-07', '0'),
('1567', '47', '26', '102', '2023-08-07', '892.2'),
('1568', '47', '20', '94', '2023-08-05', '5'),
('1569', '45', '20', '94', '2023-08-07', '5'),
('1570', '47', '34', '125', '2023-08-02', '1'),
('1571', '45', '34', '125', '2023-08-07', '1'),
('1572', '47', '10', '36', '2023-08-07', '1750'),
('1573', '47', '12', '51', '2023-08-05', '32'),
('1574', '47', '12', '52', '2023-08-05', '12'),
('1575', '47', '12', '53', '2023-08-05', '1'),
('1576', '48', '12', '51', '2023-08-07', '32'),
('1577', '48', '12', '52', '2023-08-07', '12'),
('1578', '48', '12', '53', '2023-08-07', '1'),
('1579', '48', '12', '51', '2023-08-04', '32'),
('1580', '48', '12', '52', '2023-08-04', '12'),
('1581', '48', '12', '53', '2023-08-04', '1'),
('1582', '47', '26', '101', '2023-08-07', '3233.1'),
('1583', '47', '26', '102', '2023-08-07', '0'),
('1584', '47', '18', '88', '2023-08-07', '24'),
('1585', '47', '18', '89', '2023-08-07', '0'),
('1586', '47', '18', '90', '2023-08-07', '0'),
('1587', '47', '18', '91', '2023-08-07', '0'),
('1588', '47', '18', '92', '2023-08-07', '3'),
('1589', '45', '18', '88', '2023-08-07', '24'),
('1590', '45', '18', '89', '2023-08-07', '0'),
('1591', '45', '18', '90', '2023-08-07', '0'),
('1592', '45', '18', '91', '2023-08-07', '0'),
('1593', '45', '18', '92', '2023-08-07', '3'),
('1594', '47', '26', '101', '2023-08-07', '0'),
('1595', '47', '26', '102', '2023-08-07', '890.4'),
('1596', '47', '30', '107', '2023-08-01', '3'),
('1597', '47', '30', '108', '2023-08-01', '2'),
('1598', '47', '30', '109', '2023-08-01', '2'),
('1599', '47', '30', '110', '2023-08-01', '1'),
('1600', '47', '30', '111', '2023-08-01', '3'),
('1601', '47', '30', '112', '2023-08-01', '1'),
('1602', '47', '30', '113', '2023-08-01', '2'),
('1603', '48', '30', '107', '2023-08-01', '3'),
('1604', '48', '30', '108', '2023-08-01', '2'),
('1605', '48', '30', '109', '2023-08-01', '2'),
('1606', '48', '30', '110', '2023-08-01', '1'),
('1607', '48', '30', '111', '2023-08-01', '3'),
('1608', '48', '30', '112', '2023-08-01', '1'),
('1609', '48', '30', '113', '2023-08-01', '2'),
('1610', '47', '37', '130', '2023-08-01', '1'),
('1611', '48', '37', '130', '2023-08-07', '1'),
('1612', '47', '37', '130', '2023-08-01', '1'),
('1613', '45', '37', '130', '2023-08-07', '1'),
('1614', '47', '4', '19', '2023-08-08', '72'),
('1615', '47', '4', '20', '2023-08-08', '48'),
('1616', '45', '4', '19', '2023-08-08', '72'),
('1617', '45', '4', '20', '2023-08-08', '48'),
('1618', '47', '32', '119', '2023-08-08', '1'),
('1619', '47', '17', '80', '2023-08-08', '1'),
('1620', '47', '17', '81', '2023-08-08', '1'),
('1621', '47', '17', '82', '2023-08-08', '4'),
('1622', '47', '17', '87', '2023-08-08', '2'),
('1623', '45', '32', '119', '2023-08-08', '1'),
('1624', '45', '17', '80', '2023-08-08', '1'),
('1625', '45', '17', '81', '2023-08-08', '1'),
('1626', '45', '17', '82', '2023-08-08', '4'),
('1627', '45', '17', '87', '2023-08-08', '2'),
('1628', '47', '39', '133', '2023-08-02', '1'),
('1629', '47', '39', '134', '2023-08-02', '1'),
('1630', '47', '41', '137', '2023-08-03', '6'),
('1631', '47', '42', '138', '2023-08-03', '2'),
('1632', '47', '43', '139', '2023-08-04', '12'),
('1633', '47', '43', '140', '2023-08-04', '1'),
('1634', '47', '45', '142', '2023-08-07', '1'),
('1635', '47', '46', '143', '2023-08-07', '1'),
('1636', '45', '26', '101', '2023-08-09', '6466.7'),
('1637', '45', '26', '102', '2023-08-09', '1782.6'),
('1638', '45', '10', '36', '2023-08-09', '1750'),
('1639', '47', '4', '19', '2023-08-09', '0'),
('1640', '47', '4', '20', '2023-08-09', '96'),
('1641', '45', '4', '19', '2023-08-09', '0'),
('1642', '45', '4', '20', '2023-08-09', '96'),
('1643', '47', '10', '36', '2023-08-07', '1750'),
('1644', '45', '10', '36', '2023-08-09', '1750'),
('1645', '47', '35', '126', '2023-08-09', '25'),
('1646', '47', '35', '127', '2023-08-09', '240'),
('1647', '47', '35', '128', '2023-08-09', '75'),
('1648', '47', '36', '129', '2023-08-09', '6'),
('1649', '47', '59', '164', '2023-08-09', '2100'),
('1650', '47', '59', '165', '2023-08-09', '6300'),
('1651', '45', '59', '164', '2023-08-09', '2100'),
('1652', '45', '59', '165', '2023-08-09', '6300'),
('1653', '47', '49', '149', '2023-08-03', '1'),
('1654', '47', '47', '144', '2023-08-09', '50'),
('1655', '47', '47', '145', '2023-08-09', '50'),
('1656', '47', '47', '146', '2023-08-09', '50'),
('1657', '47', '47', '147', '2023-08-09', '50'),
('1658', '47', '13', '54', '2023-08-10', '2'),
('1659', '47', '13', '55', '2023-08-10', '140'),
('1660', '47', '13', '56', '2023-08-10', '2'),
('1661', '47', '13', '57', '2023-08-10', '4'),
('1662', '47', '13', '58', '2023-08-10', '2'),
('1663', '47', '13', '59', '2023-08-10', '2'),
('1664', '47', '13', '60', '2023-08-10', '1'),
('1665', '47', '13', '61', '2023-08-10', '2'),
('1666', '47', '13', '62', '2023-08-10', '1'),
('1667', '47', '13', '63', '2023-08-10', '1'),
('1668', '47', '13', '64', '2023-08-10', '1'),
('1669', '45', '13', '54', '2023-08-10', '2'),
('1670', '45', '13', '55', '2023-08-10', '140'),
('1671', '45', '13', '56', '2023-08-10', '2'),
('1672', '45', '13', '57', '2023-08-10', '4'),
('1673', '45', '13', '58', '2023-08-10', '2'),
('1674', '45', '13', '59', '2023-08-10', '2'),
('1675', '45', '13', '60', '2023-08-10', '1'),
('1676', '45', '13', '61', '2023-08-10', '2'),
('1677', '45', '13', '62', '2023-08-10', '1'),
('1678', '45', '13', '63', '2023-08-10', '1'),
('1679', '45', '13', '64', '2023-08-10', '1'),
('1680', '47', '4', '19', '2023-08-10', '72'),
('1681', '47', '4', '20', '2023-08-10', '0'),
('1682', '45', '4', '19', '2023-08-10', '72'),
('1683', '45', '4', '20', '2023-08-10', '0'),
('1684', '45', '47', '144', '2023-08-10', '50'),
('1685', '45', '47', '145', '2023-08-10', '50'),
('1686', '45', '47', '146', '2023-08-10', '50'),
('1687', '45', '47', '147', '2023-08-10', '50'),
('1688', '45', '39', '133', '2023-08-10', '1'),
('1689', '45', '39', '134', '2023-08-10', '1'),
('1690', '45', '41', '137', '2023-08-10', '6'),
('1691', '45', '42', '138', '2023-08-10', '2'),
('1692', '45', '43', '139', '2023-08-10', '12'),
('1693', '45', '43', '140', '2023-08-10', '1'),
('1694', '45', '45', '142', '2023-08-10', '1'),
('1695', '45', '46', '143', '2023-08-10', '1'),
('1696', '45', '49', '149', '2023-08-10', '1'),
('1697', '48', '30', '107', '2023-08-01', '3'),
('1698', '48', '30', '108', '2023-08-01', '2'),
('1699', '48', '30', '109', '2023-08-01', '2'),
('1700', '48', '30', '110', '2023-08-01', '1'),
('1701', '48', '30', '111', '2023-08-01', '3'),
('1702', '48', '30', '112', '2023-08-01', '1'),
('1703', '48', '30', '113', '2023-08-01', '2'),
('1704', '48', '30', '107', '2023-08-10', '3'),
('1705', '48', '30', '108', '2023-08-10', '2'),
('1706', '48', '30', '109', '2023-08-10', '2'),
('1707', '48', '30', '110', '2023-08-10', '1'),
('1708', '48', '30', '111', '2023-08-10', '3'),
('1709', '48', '30', '112', '2023-08-10', '1'),
('1710', '48', '30', '113', '2023-08-10', '2'),
('1711', '45', '36', '129', '2023-08-10', '6'),
('1712', '45', '35', '126', '2023-08-10', '25'),
('1713', '45', '35', '127', '2023-08-10', '240'),
('1714', '45', '35', '128', '2023-08-10', '75'),
('1715', '47', '48', '148', '2023-08-10', '1966.5'),
('1716', '47', '33', '120', '2023-08-10', '4'),
('1717', '47', '33', '121', '2023-08-10', '4'),
('1718', '47', '33', '122', '2023-08-10', '2'),
('1719', '47', '33', '123', '2023-08-10', '100'),
('1720', '47', '33', '124', '2023-08-10', '2'),
('1721', '47', '53', '153', '2023-08-10', '50'),
('1722', '45', '53', '153', '2023-08-10', '50'),
('1723', '45', '33', '120', '2023-08-11', '4'),
('1724', '45', '33', '121', '2023-08-11', '4'),
('1725', '45', '33', '122', '2023-08-11', '2'),
('1726', '45', '33', '123', '2023-08-11', '100'),
('1727', '45', '33', '124', '2023-08-11', '2'),
('1728', '47', '54', '154', '2023-08-11', '1'),
('1729', '47', '54', '155', '2023-08-11', '1'),
('1730', '47', '54', '156', '2023-08-11', '1'),
('1731', '47', '54', '157', '2023-08-11', '1'),
('1732', '47', '54', '158', '2023-08-11', '1'),
('1733', '47', '54', '159', '2023-08-11', '2'),
('1734', '45', '54', '154', '2023-08-11', '1'),
('1735', '45', '54', '155', '2023-08-11', '1'),
('1736', '45', '54', '156', '2023-08-11', '1'),
('1737', '45', '54', '157', '2023-08-11', '1'),
('1738', '45', '54', '158', '2023-08-11', '1'),
('1739', '45', '54', '159', '2023-08-11', '2'),
('1740', '47', '63', '171', '2023-08-11', '1'),
('1741', '45', '63', '171', '2023-08-11', '1'),
('1742', '47', '68', '178', '2023-08-11', '1'),
('1743', '45', '68', '178', '2023-08-11', '1'),
('1744', '47', '58', '163', '2023-08-11', '1500'),
('1745', '47', '26', '101', '2023-08-07', '13.3'),
('1746', '47', '26', '102', '2023-08-07', '9'),
('1747', '47', '48', '148', '2023-08-10', '9.9'),
('1748', '47', '69', '179', '2023-08-11', '530'),
('1749', '45', '69', '179', '2023-08-12', '530'),
('1750', '45', '58', '163', '2023-08-12', '1500'),
('1751', '47', '71', '181', '2023-08-12', '2842'),
('1752', '47', '71', '182', '2023-08-12', '2626'),
('1753', '45', '71', '181', '2023-08-12', '2842'),
('1754', '45', '71', '182', '2023-08-12', '2626'),
('1755', '45', '48', '148', '2023-08-15', '1976.4'),
('1756', '45', '26', '101', '2023-08-15', '13.3'),
('1757', '45', '26', '102', '2023-08-15', '9'),
('1758', '47', '74', '189', '2023-08-12', '2'),
('1759', '45', '74', '189', '2023-08-15', '2'),
('1760', '47', '73', '188', '2023-08-09', '100'),
('1761', '45', '73', '188', '2023-08-15', '100'),
('1762', '47', '65', '173', '2023-08-09', '3'),
('1763', '45', '65', '173', '2023-08-15', '3'),
('1764', '47', '52', '152', '2023-08-03', '1'),
('1765', '45', '52', '152', '2023-08-15', '1'),
('1766', '47', '75', '190', '2023-08-10', '6'),
('1767', '45', '75', '190', '2023-08-15', '6'),
('1768', '47', '79', '194', '2023-08-15', '2'),
('1769', '45', '79', '194', '2023-08-15', '2'),
('1770', '47', '80', '195', '2023-08-16', '3'),
('1771', '47', '80', '196', '2023-08-16', '2'),
('1772', '47', '80', '197', '2023-08-16', '2'),
('1773', '47', '80', '198', '2023-08-16', '2'),
('1774', '47', '80', '199', '2023-08-16', '1'),
('1775', '47', '80', '200', '2023-08-16', '3'),
('1776', '47', '80', '201', '2023-08-16', '1'),
('1777', '45', '80', '195', '2023-08-16', '3'),
('1778', '45', '80', '196', '2023-08-16', '2'),
('1779', '45', '80', '197', '2023-08-16', '2'),
('1780', '45', '80', '198', '2023-08-16', '2'),
('1781', '45', '80', '199', '2023-08-16', '1'),
('1782', '45', '80', '200', '2023-08-16', '3'),
('1783', '45', '80', '201', '2023-08-16', '1'),
('1784', '47', '40', '135', '2023-08-15', '0'),
('1785', '47', '40', '136', '2023-08-15', '990'),
('1786', '47', '81', '202', '2023-08-16', '2100'),
('1787', '47', '81', '203', '2023-08-16', '2100'),
('1788', '45', '81', '202', '2023-08-16', '2100'),
('1789', '45', '81', '203', '2023-08-16', '2100'),
('1790', '45', '40', '135', '2023-08-17', '0'),
('1791', '45', '40', '136', '2023-08-17', '990'),
('1792', '47', '16', '70', '2023-08-18', '0'),
('1793', '47', '16', '71', '2023-08-18', '0'),
('1794', '47', '16', '72', '2023-08-18', '5'),
('1795', '47', '16', '73', '2023-08-18', '0'),
('1796', '47', '16', '74', '2023-08-18', '0'),
('1797', '47', '16', '75', '2023-08-18', '0'),
('1798', '47', '16', '76', '2023-08-18', '0'),
('1799', '47', '16', '77', '2023-08-18', '0'),
('1800', '47', '16', '78', '2023-08-18', '0'),
('1801', '47', '16', '79', '2023-08-18', '0'),
('1802', '48', '16', '70', '2023-08-18', '0'),
('1803', '48', '16', '71', '2023-08-18', '0'),
('1804', '48', '16', '72', '2023-08-18', '5'),
('1805', '48', '16', '73', '2023-08-18', '0'),
('1806', '48', '16', '74', '2023-08-18', '0'),
('1807', '48', '16', '75', '2023-08-18', '0'),
('1808', '48', '16', '76', '2023-08-18', '0'),
('1809', '48', '16', '77', '2023-08-18', '0'),
('1810', '48', '16', '78', '2023-08-18', '0'),
('1811', '48', '16', '79', '2023-08-18', '0'),
('1812', '47', '76', '191', '2023-08-18', '1500'),
('1813', '48', '16', '70', '2023-08-18', '0'),
('1814', '48', '16', '71', '2023-08-18', '0'),
('1815', '48', '16', '72', '2023-08-18', '5'),
('1816', '48', '16', '73', '2023-08-18', '0'),
('1817', '48', '16', '74', '2023-08-18', '0'),
('1818', '48', '16', '75', '2023-08-18', '0'),
('1819', '48', '16', '76', '2023-08-18', '0'),
('1820', '48', '16', '77', '2023-08-18', '0'),
('1821', '48', '16', '78', '2023-08-18', '0'),
('1822', '48', '16', '79', '2023-08-18', '0'),
('1823', '48', '16', '70', '2023-08-18', '0'),
('1824', '48', '16', '71', '2023-08-18', '0'),
('1825', '48', '16', '72', '2023-08-18', '5'),
('1826', '48', '16', '73', '2023-08-18', '0'),
('1827', '48', '16', '74', '2023-08-18', '0'),
('1828', '48', '16', '75', '2023-08-18', '0'),
('1829', '48', '16', '76', '2023-08-18', '0'),
('1830', '48', '16', '77', '2023-08-18', '0'),
('1831', '48', '16', '78', '2023-08-18', '0'),
('1832', '48', '16', '79', '2023-08-18', '0'),
('1833', '48', '16', '70', '2023-08-18', '0'),
('1834', '48', '16', '71', '2023-08-18', '0'),
('1835', '48', '16', '72', '2023-08-18', '5'),
('1836', '48', '16', '73', '2023-08-18', '0'),
('1837', '48', '16', '74', '2023-08-18', '0'),
('1838', '48', '16', '75', '2023-08-18', '0'),
('1839', '48', '16', '76', '2023-08-18', '0'),
('1840', '48', '16', '77', '2023-08-18', '0'),
('1841', '48', '16', '78', '2023-08-18', '0'),
('1842', '48', '16', '79', '2023-08-18', '0'),
('1843', '47', '84', '207', '2023-08-18', '220'),
('1844', '45', '84', '207', '2023-08-18', '220'),
('1845', '45', '76', '191', '2023-08-18', '1500'),
('1846', '47', '85', '208', '2023-08-18', '8'),
('1847', '48', '85', '208', '2023-08-18', '8'),
('1848', '47', '85', '208', '2023-08-18', '8'),
('1849', '45', '85', '208', '2023-08-18', '8'),
('1850', '47', '72', '183', '2023-08-19', '0'),
('1851', '47', '72', '184', '2023-08-19', '1805'),
('1852', '47', '72', '185', '2023-08-19', '0'),
('1853', '47', '72', '186', '2023-08-19', '400'),
('1854', '47', '72', '187', '2023-08-19', '4334'),
('1855', '45', '72', '183', '2023-08-21', '0'),
('1856', '45', '72', '184', '2023-08-21', '1805'),
('1857', '45', '72', '185', '2023-08-21', '0'),
('1858', '45', '72', '186', '2023-08-21', '400'),
('1859', '45', '72', '187', '2023-08-21', '4334'),
('1860', '47', '81', '202', '2023-08-21', '2100'),
('1861', '47', '81', '203', '2023-08-21', '2100'),
('1862', '45', '81', '202', '2023-08-21', '2100'),
('1863', '45', '81', '203', '2023-08-21', '2100'),
('1864', '47', '87', '214', '2023-08-21', '10'),
('1865', '45', '87', '214', '2023-08-21', '10'),
('1866', '47', '86', '209', '2023-08-21', '3'),
('1867', '47', '86', '210', '2023-08-21', '6'),
('1868', '47', '86', '211', '2023-08-21', '4'),
('1869', '47', '86', '212', '2023-08-21', '12'),
('1870', '47', '86', '213', '2023-08-21', '6'),
('1871', '45', '86', '209', '2023-08-21', '3'),
('1872', '45', '86', '210', '2023-08-21', '6'),
('1873', '45', '86', '211', '2023-08-21', '4'),
('1874', '45', '86', '212', '2023-08-21', '12'),
('1875', '45', '86', '213', '2023-08-21', '6'),
('1876', '47', '88', '215', '2023-08-21', '1'),
('1877', '47', '88', '216', '2023-08-21', '1'),
('1878', '47', '88', '220', '2023-08-21', '1'),
('1879', '45', '88', '215', '2023-08-21', '1'),
('1880', '45', '88', '216', '2023-08-21', '1'),
('1881', '45', '88', '220', '2023-08-21', '1'),
('1882', '47', '92', '222', '2023-08-21', '24'),
('1883', '48', '92', '222', '2023-08-21', '24'),
('1884', '47', '92', '222', '2023-08-21', '24'),
('1885', '45', '92', '222', '2023-08-21', '24'),
('1886', '47', '90', '218', '2023-08-21', '1'),
('1887', '47', '90', '219', '2023-08-21', '1'),
('1888', '45', '90', '218', '2023-08-21', '1'),
('1889', '45', '90', '219', '2023-08-21', '1'),
('1890', '47', '96', '226', '2023-08-22', '1280'),
('1891', '47', '89', '217', '2023-08-22', '1500'),
('1892', '47', '93', '223', '2023-08-23', '432'),
('1893', '45', '93', '223', '2023-08-23', '432'),
('1894', '45', '96', '226', '2023-08-23', '1280'),
('1895', '45', '89', '217', '2023-08-23', '1500'),
('1896', '47', '48', '148', '2023-08-23', '3.6'),
('1897', '47', '26', '101', '2023-08-23', '0'),
('1898', '47', '26', '102', '2023-08-23', '8.4'),
('1899', '47', '101', '234', '2023-08-23', '150'),
('1900', '45', '26', '101', '2023-08-23', '0'),
('1901', '45', '26', '102', '2023-08-23', '8.4'),
('1902', '45', '48', '148', '2023-08-23', '3.6'),
('1903', '45', '101', '234', '2023-08-23', '150'),
('1904', '45', '16', '70', '2023-08-23', '0'),
('1905', '45', '16', '71', '2023-08-23', '0'),
('1906', '45', '16', '72', '2023-08-23', '5'),
('1907', '45', '16', '73', '2023-08-23', '0'),
('1908', '45', '16', '74', '2023-08-23', '0'),
('1909', '45', '16', '75', '2023-08-23', '0'),
('1910', '45', '16', '76', '2023-08-23', '0'),
('1911', '45', '16', '77', '2023-08-23', '0'),
('1912', '45', '16', '78', '2023-08-23', '0'),
('1913', '45', '16', '79', '2023-08-23', '0'),
('1914', '47', '83', '205', '2023-08-23', '3500'),
('1915', '47', '83', '206', '2023-08-23', '0'),
('1916', '45', '83', '205', '2023-08-23', '3500'),
('1917', '45', '83', '206', '2023-08-23', '0'),
('1918', '47', '81', '202', '2023-08-24', '2100'),
('1919', '47', '81', '203', '2023-08-24', '2100'),
('1920', '45', '81', '202', '2023-08-24', '2100'),
('1921', '45', '81', '203', '2023-08-24', '2100'),
('1922', '47', '78', '193', '2023-08-24', '21000'),
('1923', '45', '78', '193', '2023-08-24', '21000'),
('1924', '47', '111', '253', '2023-08-24', '1714'),
('1925', '47', '111', '254', '2023-08-24', '1720'),
('1926', '45', '111', '253', '2023-08-24', '1714'),
('1927', '45', '111', '254', '2023-08-24', '1720'),
('1928', '47', '103', '237', '2023-08-24', '16000'),
('1929', '45', '103', '237', '2023-08-24', '16000'),
('1930', '47', '40', '135', '2023-08-24', '11340'),
('1931', '47', '40', '136', '2023-08-24', '330'),
('1932', '47', '105', '239', '2023-08-25', '1470'),
('1933', '45', '105', '239', '2023-08-25', '1470'),
('1934', '47', '115', '263', '2023-08-25', '1'),
('1935', '45', '115', '263', '2023-08-25', '1'),
('1936', '47', '97', '227', '2023-08-26', '2000'),
('1937', '45', '97', '227', '2023-08-26', '2000'),
('1938', '47', '98', '228', '2023-08-26', '1000'),
('1939', '47', '98', '229', '2023-08-26', '1000'),
('1940', '47', '98', '230', '2023-08-26', '1000'),
('1941', '47', '98', '231', '2023-08-26', '1000'),
('1942', '45', '98', '228', '2023-08-26', '1000'),
('1943', '45', '98', '229', '2023-08-26', '1000'),
('1944', '45', '98', '230', '2023-08-26', '1000'),
('1945', '45', '98', '231', '2023-08-26', '1000'),
('1946', '47', '100', '233', '2023-08-26', '1000'),
('1947', '45', '100', '233', '2023-08-26', '1000'),
('1948', '45', '40', '135', '2023-08-26', '11340'),
('1949', '45', '40', '136', '2023-08-26', '330'),
('1950', '47', '77', '192', '2023-08-28', '10000'),
('1951', '45', '77', '192', '2023-08-28', '10000'),
('1952', '47', '123', '271', '2023-08-28', '400'),
('1953', '45', '123', '271', '2023-08-28', '400'),
('1954', '47', '92', '222', '2023-08-28', '24'),
('1955', '45', '92', '222', '2023-08-28', '24'),
('1956', '47', '110', '248', '2023-08-28', '1'),
('1957', '47', '110', '249', '2023-08-28', '1'),
('1958', '47', '110', '250', '2023-08-28', '0'),
('1959', '47', '110', '251', '2023-08-28', '0'),
('1960', '47', '110', '252', '2023-08-28', '3'),
('1961', '45', '110', '248', '2023-08-28', '1'),
('1962', '45', '110', '249', '2023-08-28', '1'),
('1963', '45', '110', '250', '2023-08-28', '0'),
('1964', '45', '110', '251', '2023-08-28', '0'),
('1965', '45', '110', '252', '2023-08-28', '3'),
('1966', '47', '110', '248', '2023-08-28', '0'),
('1967', '47', '110', '249', '2023-08-28', '0'),
('1968', '47', '110', '250', '2023-08-28', '1'),
('1969', '47', '110', '251', '2023-08-28', '0'),
('1970', '47', '110', '252', '2023-08-28', '0'),
('1971', '45', '110', '248', '2023-08-28', '0'),
('1972', '45', '110', '249', '2023-08-28', '0'),
('1973', '45', '110', '250', '2023-08-28', '1'),
('1974', '45', '110', '251', '2023-08-28', '0'),
('1975', '45', '110', '252', '2023-08-28', '0'),
('1976', '47', '113', '257', '2023-08-28', '24'),
('1977', '47', '113', '258', '2023-08-28', '1'),
('1978', '47', '113', '259', '2023-08-28', '2'),
('1979', '47', '113', '260', '2023-08-28', '12'),
('1980', '45', '113', '257', '2023-08-28', '24'),
('1981', '45', '113', '258', '2023-08-28', '1'),
('1982', '45', '113', '259', '2023-08-28', '2'),
('1983', '45', '113', '260', '2023-08-28', '12'),
('1984', '47', '114', '261', '2023-08-28', '1'),
('1985', '47', '114', '262', '2023-08-28', '1'),
('1986', '45', '114', '261', '2023-08-28', '1'),
('1987', '45', '114', '262', '2023-08-28', '1'),
('1988', '47', '122', '270', '2023-08-28', '1'),
('1989', '45', '122', '270', '2023-08-28', '1'),
('1990', '47', '118', '266', '2023-08-28', '1'),
('1991', '45', '118', '266', '2023-08-28', '1'),
('1992', '47', '72', '183', '2023-08-28', '1000'),
('1993', '47', '72', '184', '2023-08-28', '19'),
('1994', '47', '72', '185', '2023-08-28', '800'),
('1995', '47', '72', '186', '2023-08-28', '700'),
('1996', '47', '72', '187', '2023-08-28', '66'),
('1997', '45', '72', '183', '2023-08-28', '1000'),
('1998', '45', '72', '184', '2023-08-28', '19'),
('1999', '45', '72', '185', '2023-08-28', '800'),
('2000', '45', '72', '186', '2023-08-28', '700'),
('2001', '45', '72', '187', '2023-08-28', '66'),
('2002', '47', '95', '225', '2023-08-28', '800'),
('2003', '45', '95', '225', '2023-08-28', '800'),
('2004', '47', '83', '205', '2023-08-28', '3500'),
('2005', '47', '83', '206', '2023-08-28', '0'),
('2006', '45', '83', '205', '2023-08-28', '3500'),
('2007', '45', '83', '206', '2023-08-28', '0'),
('2008', '47', '128', '287', '2023-08-28', '30'),
('2009', '47', '128', '288', '2023-08-28', '33'),
('2010', '47', '128', '289', '2023-08-28', '22'),
('2011', '47', '128', '290', '2023-08-28', '11'),
('2012', '47', '128', '291', '2023-08-28', '60'),
('2013', '47', '128', '292', '2023-08-28', '36'),
('2014', '45', '128', '287', '2023-08-28', '30'),
('2015', '45', '128', '288', '2023-08-28', '33'),
('2016', '45', '128', '289', '2023-08-28', '22'),
('2017', '45', '128', '290', '2023-08-28', '11'),
('2018', '45', '128', '291', '2023-08-28', '60'),
('2019', '45', '128', '292', '2023-08-28', '36'),
('2020', '47', '18', '88', '2023-08-28', '0'),
('2021', '47', '18', '89', '2023-08-28', '0.32'),
('2022', '47', '18', '90', '2023-08-28', '0.32'),
('2023', '47', '18', '91', '2023-08-28', '0.32'),
('2024', '47', '18', '92', '2023-08-28', '0'),
('2025', '45', '18', '88', '2023-08-28', '0'),
('2026', '45', '18', '89', '2023-08-28', '0.32'),
('2027', '45', '18', '90', '2023-08-28', '0.32'),
('2028', '45', '18', '91', '2023-08-28', '0.32'),
('2029', '45', '18', '92', '2023-08-28', '0'),
('2030', '47', '108', '242', '2023-08-28', '0.25'),
('2031', '47', '109', '243', '2023-08-28', '0.25'),
('2032', '47', '109', '244', '2023-08-28', '0.25'),
('2033', '47', '109', '246', '2023-08-28', '0.5'),
('2034', '47', '109', '247', '2023-08-28', '0.5'),
('2035', '47', '109', '255', '2023-08-28', '0'),
('2036', '45', '108', '242', '2023-08-29', '0.25'),
('2037', '45', '109', '243', '2023-08-29', '0.25'),
('2038', '45', '109', '244', '2023-08-29', '0.25'),
('2039', '45', '109', '246', '2023-08-29', '0.5'),
('2040', '45', '109', '247', '2023-08-29', '0.5'),
('2041', '45', '109', '255', '2023-08-29', '0'),
('2042', '47', '132', '316', '2023-08-30', '4200'),
('2043', '45', '132', '316', '2023-08-30', '4200'),
('2044', '47', '78', '193', '2023-08-30', '39000'),
('2045', '45', '78', '193', '2023-08-30', '39000'),
('2046', '47', '104', '238', '2023-08-30', '12600'),
('2047', '45', '104', '238', '2023-08-30', '12600'),
('2048', '47', '105', '239', '2023-08-29', '30'),
('2049', '47', '121', '269', '2023-08-30', '12'),
('2050', '45', '121', '269', '2023-08-30', '12'),
('2051', '47', '117', '265', '2023-08-29', '1500'),
('2052', '47', '109', '243', '2023-08-28', '0'),
('2053', '47', '109', '244', '2023-08-28', '0'),
('2054', '47', '109', '246', '2023-08-28', '0'),
('2055', '47', '109', '247', '2023-08-28', '0'),
('2056', '47', '109', '255', '2023-08-28', '3'),
('2057', '47', '130', '301', '2023-08-30', '1'),
('2058', '47', '130', '302', '2023-08-30', '1'),
('2059', '45', '130', '301', '2023-08-30', '1'),
('2060', '45', '130', '302', '2023-08-30', '1'),
('2061', '47', '131', '303', '2023-08-30', '10'),
('2062', '47', '131', '304', '2023-08-30', '2'),
('2063', '47', '131', '305', '2023-08-30', '6'),
('2064', '47', '131', '306', '2023-08-30', '4'),
('2065', '47', '131', '307', '2023-08-30', '4'),
('2066', '47', '131', '308', '2023-08-30', '12'),
('2067', '47', '131', '309', '2023-08-30', '4'),
('2068', '47', '131', '310', '2023-08-30', '24'),
('2069', '47', '131', '311', '2023-08-30', '24'),
('2070', '47', '131', '312', '2023-08-30', '48'),
('2071', '47', '131', '313', '2023-08-30', '12'),
('2072', '47', '131', '314', '2023-08-30', '15'),
('2073', '47', '131', '315', '2023-08-30', '3'),
('2074', '45', '131', '303', '2023-08-30', '10'),
('2075', '45', '131', '304', '2023-08-30', '2'),
('2076', '45', '131', '305', '2023-08-30', '6'),
('2077', '45', '131', '306', '2023-08-30', '4'),
('2078', '45', '131', '307', '2023-08-30', '4'),
('2079', '45', '131', '308', '2023-08-30', '12'),
('2080', '45', '131', '309', '2023-08-30', '4'),
('2081', '45', '131', '310', '2023-08-30', '24'),
('2082', '45', '131', '311', '2023-08-30', '24'),
('2083', '45', '131', '312', '2023-08-30', '48'),
('2084', '45', '131', '313', '2023-08-30', '12'),
('2085', '45', '131', '314', '2023-08-30', '15'),
('2086', '45', '131', '315', '2023-08-30', '3'),
('2087', '47', '133', '317', '2023-08-29', '220'),
('2088', '47', '12', '51', '2023-08-30', '32'),
('2089', '47', '12', '52', '2023-08-30', '12'),
('2090', '47', '12', '53', '2023-08-30', '1'),
('2091', '47', '81', '202', '2023-08-30', '2100'),
('2092', '47', '81', '203', '2023-08-30', '2100'),
('2093', '45', '81', '202', '2023-08-30', '2100'),
('2094', '45', '81', '203', '2023-08-30', '2100'),
('2095', '45', '12', '51', '2023-08-30', '32'),
('2096', '45', '12', '52', '2023-08-30', '12'),
('2097', '45', '12', '53', '2023-08-30', '1'),
('2098', '45', '117', '265', '2023-08-30', '1500'),
('2099', '45', '105', '239', '2023-08-30', '30'),
('2100', '45', '109', '243', '2023-08-30', '0'),
('2101', '45', '109', '244', '2023-08-30', '0'),
('2102', '45', '109', '246', '2023-08-30', '0'),
('2103', '45', '109', '247', '2023-08-30', '0'),
('2104', '45', '109', '255', '2023-08-30', '3'),
('2105', '45', '133', '317', '2023-08-30', '220'),
('2106', '47', '83', '205', '2023-08-31', '0'),
('2107', '47', '83', '206', '2023-08-31', '10000'),
('2108', '45', '83', '205', '2023-09-01', '0'),
('2109', '45', '83', '206', '2023-09-01', '10000'),
('2110', '47', '112', '256', '2023-09-01', '20'),
('2111', '45', '112', '256', '2023-09-01', '20'),
('2112', '47', '83', '205', '2023-09-02', '1400'),
('2113', '47', '83', '206', '2023-09-02', '0'),
('2114', '45', '83', '205', '2023-09-02', '1400'),
('2115', '45', '83', '206', '2023-09-02', '0'),
('2116', '47', '142', '342', '2023-09-02', '50'),
('2117', '47', '142', '345', '2023-09-02', '0'),
('2118', '45', '142', '342', '2023-09-02', '50'),
('2119', '45', '142', '345', '2023-09-02', '0'),
('2120', '47', '120', '268', '2023-09-02', '900');
INSERT INTO `0_inward_grn` VALUES
('2121', '47', '150', '351', '2023-09-04', '6'),
('2122', '45', '150', '351', '2023-09-04', '6'),
('2123', '47', '138', '322', '2023-09-04', '1500'),
('2124', '47', '151', '352', '2023-09-04', '710'),
('2125', '45', '120', '268', '2023-09-04', '900'),
('2126', '45', '138', '322', '2023-09-04', '1500'),
('2127', '45', '151', '352', '2023-09-04', '710'),
('2128', '47', '148', '349', '2023-09-05', '100'),
('2129', '45', '148', '349', '2023-09-05', '100'),
('2130', '47', '164', '391', '2023-09-06', '18'),
('2131', '45', '164', '391', '2023-09-06', '18'),
('2132', '47', '165', '392', '2023-09-06', '226'),
('2133', '45', '165', '392', '2023-09-06', '226'),
('2134', '47', '166', '393', '2023-09-06', '19'),
('2135', '47', '166', '394', '2023-09-06', '10'),
('2136', '47', '166', '395', '2023-09-06', '8'),
('2137', '47', '166', '396', '2023-09-06', '4'),
('2138', '47', '166', '397', '2023-09-06', '17'),
('2139', '45', '166', '393', '2023-09-06', '19'),
('2140', '45', '166', '394', '2023-09-06', '10'),
('2141', '45', '166', '395', '2023-09-06', '8'),
('2142', '45', '166', '396', '2023-09-06', '4'),
('2143', '45', '166', '397', '2023-09-06', '17'),
('2144', '47', '137', '321', '2023-09-07', '4850'),
('2145', '45', '137', '321', '2023-09-07', '4850'),
('2146', '47', '147', '348', '2023-09-07', '2880'),
('2147', '45', '147', '348', '2023-09-07', '2880'),
('2148', '47', '162', '373', '2023-09-07', '1'),
('2149', '47', '162', '374', '2023-09-07', '1'),
('2150', '47', '162', '375', '2023-09-07', '1.5'),
('2151', '47', '162', '376', '2023-09-07', '1'),
('2152', '47', '162', '377', '2023-09-07', '1'),
('2153', '47', '162', '378', '2023-09-07', '1.5'),
('2154', '47', '162', '379', '2023-09-07', '0.5'),
('2155', '47', '162', '380', '2023-09-07', '0.5'),
('2156', '47', '162', '381', '2023-09-07', '0.25'),
('2157', '47', '162', '382', '2023-09-07', '0.5'),
('2158', '47', '162', '383', '2023-09-07', '0.5'),
('2159', '47', '162', '384', '2023-09-07', '0.5'),
('2160', '47', '162', '385', '2023-09-07', '1'),
('2161', '47', '162', '386', '2023-09-07', '1'),
('2162', '47', '162', '387', '2023-09-07', '1'),
('2163', '47', '162', '388', '2023-09-07', '10'),
('2164', '47', '162', '389', '2023-09-07', '1'),
('2165', '47', '161', '368', '2023-09-07', '5'),
('2166', '47', '161', '369', '2023-09-07', '0.5'),
('2167', '47', '161', '370', '2023-09-07', '0.5'),
('2168', '47', '161', '371', '2023-09-07', '1'),
('2169', '47', '161', '372', '2023-09-07', '1'),
('2170', '47', '160', '366', '2023-09-07', '1'),
('2171', '47', '160', '367', '2023-09-07', '1'),
('2172', '47', '168', '402', '2023-09-07', '2'),
('2173', '47', '168', '403', '2023-09-07', '2'),
('2174', '47', '168', '405', '2023-09-07', '4'),
('2175', '47', '144', '344', '2023-09-07', '1'),
('2176', '45', '144', '344', '2023-09-07', '1'),
('2177', '45', '160', '366', '2023-09-08', '1'),
('2178', '45', '160', '367', '2023-09-08', '1'),
('2179', '45', '161', '368', '2023-09-08', '5'),
('2180', '45', '161', '369', '2023-09-08', '0.5'),
('2181', '45', '161', '370', '2023-09-08', '0.5'),
('2182', '45', '161', '371', '2023-09-08', '1'),
('2183', '45', '161', '372', '2023-09-08', '1'),
('2184', '45', '168', '402', '2023-09-08', '2'),
('2185', '45', '168', '403', '2023-09-08', '2'),
('2186', '45', '168', '405', '2023-09-08', '4'),
('2187', '47', '156', '362', '2023-09-07', '2150.8'),
('2188', '47', '155', '361', '2023-09-07', '5921.3'),
('2189', '47', '155', '361', '2023-09-07', '18.7'),
('2190', '47', '156', '362', '2023-09-07', '9.2'),
('2191', '47', '169', '404', '2023-09-09', '2'),
('2192', '45', '169', '404', '2023-09-09', '2'),
('2193', '45', '155', '361', '2023-09-09', '5940'),
('2194', '45', '156', '362', '2023-09-09', '2160'),
('2195', '47', '176', '413', '2023-09-11', '3'),
('2196', '47', '176', '414', '2023-09-11', '1'),
('2197', '47', '176', '415', '2023-09-11', '2'),
('2198', '47', '176', '416', '2023-09-11', '1'),
('2199', '47', '176', '417', '2023-09-11', '3'),
('2200', '47', '176', '418', '2023-09-11', '3'),
('2201', '47', '176', '419', '2023-09-11', '1'),
('2202', '47', '176', '420', '2023-09-11', '2'),
('2203', '47', '176', '421', '2023-09-11', '4'),
('2204', '47', '176', '422', '2023-09-11', '1'),
('2205', '45', '176', '413', '2023-09-11', '3'),
('2206', '45', '176', '414', '2023-09-11', '1'),
('2207', '45', '176', '415', '2023-09-11', '2'),
('2208', '45', '176', '416', '2023-09-11', '1'),
('2209', '45', '176', '417', '2023-09-11', '3'),
('2210', '45', '176', '418', '2023-09-11', '3'),
('2211', '45', '176', '419', '2023-09-11', '1'),
('2212', '45', '176', '420', '2023-09-11', '2'),
('2213', '45', '176', '421', '2023-09-11', '4'),
('2214', '45', '176', '422', '2023-09-11', '1'),
('2215', '47', '177', '423', '2023-09-11', '1'),
('2216', '45', '177', '423', '2023-09-11', '1'),
('2217', '47', '178', '424', '2023-09-12', '2'),
('2218', '47', '178', '425', '2023-09-12', '5'),
('2219', '45', '178', '424', '2023-09-12', '2'),
('2220', '45', '178', '425', '2023-09-12', '5'),
('2221', '47', '159', '365', '2023-09-12', '1500'),
('2222', '45', '159', '365', '2023-09-12', '1500'),
('2223', '47', '142', '342', '2023-09-12', '0'),
('2224', '47', '142', '345', '2023-09-12', '1'),
('2225', '45', '142', '342', '2023-09-12', '0'),
('2226', '45', '142', '345', '2023-09-12', '1'),
('2227', '47', '182', '429', '2023-09-12', '494'),
('2228', '45', '182', '429', '2023-09-12', '494'),
('2229', '45', '162', '373', '2023-09-13', '1'),
('2230', '45', '162', '374', '2023-09-13', '1'),
('2231', '45', '162', '375', '2023-09-13', '1.5'),
('2232', '45', '162', '376', '2023-09-13', '1'),
('2233', '45', '162', '377', '2023-09-13', '1'),
('2234', '45', '162', '378', '2023-09-13', '1.5'),
('2235', '45', '162', '379', '2023-09-13', '0.5'),
('2236', '45', '162', '380', '2023-09-13', '0.5'),
('2237', '45', '162', '381', '2023-09-13', '0.25'),
('2238', '45', '162', '382', '2023-09-13', '0.5'),
('2239', '45', '162', '383', '2023-09-13', '0.5'),
('2240', '45', '162', '384', '2023-09-13', '0.5'),
('2241', '45', '162', '385', '2023-09-13', '1'),
('2242', '45', '162', '386', '2023-09-13', '1'),
('2243', '45', '162', '387', '2023-09-13', '1'),
('2244', '45', '162', '388', '2023-09-13', '10'),
('2245', '45', '162', '389', '2023-09-13', '1'),
('2246', '47', '184', '432', '2023-09-13', '2000'),
('2247', '45', '184', '432', '2023-09-13', '2000'),
('2248', '47', '188', '437', '2023-09-13', '67'),
('2249', '45', '188', '437', '2023-09-13', '67'),
('2250', '47', '185', '433', '2023-09-13', '4'),
('2251', '47', '185', '434', '2023-09-13', '1'),
('2252', '45', '185', '433', '2023-09-14', '4'),
('2253', '45', '185', '434', '2023-09-14', '1'),
('2254', '47', '170', '406', '2023-09-15', '1546'),
('2255', '47', '175', '412', '2023-09-15', '1390'),
('2256', '45', '175', '412', '2023-09-16', '1390'),
('2257', '45', '170', '406', '2023-09-16', '1546'),
('2258', '47', '157', '363', '2023-09-15', '320'),
('2259', '47', '194', '443', '2023-09-16', '1000'),
('2260', '45', '194', '443', '2023-09-18', '1000'),
('2261', '47', '173', '410', '2023-09-16', '30'),
('2262', '45', '173', '410', '2023-09-19', '30'),
('2263', '47', '180', '427', '2023-09-18', '45000'),
('2264', '45', '180', '427', '2023-09-19', '45000'),
('2265', '47', '152', '353', '2023-09-18', '2000'),
('2266', '47', '152', '354', '2023-09-18', '2000'),
('2267', '47', '152', '355', '2023-09-18', '5000'),
('2268', '47', '152', '356', '2023-09-18', '300'),
('2269', '45', '152', '353', '2023-09-19', '2000'),
('2270', '45', '152', '354', '2023-09-19', '2000'),
('2271', '45', '152', '355', '2023-09-19', '5000'),
('2272', '45', '152', '356', '2023-09-19', '300'),
('2273', '47', '154', '360', '2023-09-18', '24000'),
('2274', '45', '154', '360', '2023-09-19', '24000'),
('2275', '45', '157', '363', '2023-09-19', '320'),
('2276', '47', '202', '449', '2023-09-18', '28'),
('2277', '47', '202', '450', '2023-09-18', '30'),
('2278', '45', '202', '449', '2023-09-19', '28'),
('2279', '45', '202', '450', '2023-09-19', '30'),
('2280', '47', '203', '451', '2023-09-19', '4'),
('2281', '47', '204', '452', '2023-09-19', '8'),
('2282', '45', '203', '451', '2023-09-19', '4'),
('2283', '45', '204', '452', '2023-09-19', '8'),
('2284', '47', '201', '448', '2023-09-20', '200'),
('2285', '45', '201', '448', '2023-09-20', '200'),
('2286', '47', '208', '459', '2023-09-20', '6'),
('2287', '45', '208', '459', '2023-09-20', '6'),
('2288', '47', '171', '408', '2023-09-20', '1'),
('2289', '45', '171', '408', '2023-09-20', '1'),
('2290', '47', '193', '442', '2023-09-20', '1'),
('2291', '45', '193', '442', '2023-09-20', '1'),
('2292', '47', '205', '460', '2023-09-18', '4177'),
('2293', '45', '205', '460', '2023-09-20', '4177'),
('2294', '47', '198', '444', '2023-09-21', '612'),
('2295', '45', '198', '444', '2023-09-21', '612'),
('2296', '47', '145', '346', '2023-09-21', '22800'),
('2297', '45', '145', '346', '2023-09-21', '22800'),
('2298', '47', '180', '427', '2023-09-21', '55000'),
('2299', '45', '180', '427', '2023-09-21', '55000'),
('2300', '47', '210', '462', '2023-09-21', '5000'),
('2301', '45', '210', '462', '2023-09-21', '5000'),
('2302', '47', '145', '346', '2023-09-21', '16200'),
('2303', '45', '145', '346', '2023-09-21', '16200'),
('2304', '47', '158', '364', '2023-09-21', '160'),
('2305', '47', '213', '465', '2023-09-22', '24'),
('2306', '45', '213', '465', '2023-09-22', '24'),
('2307', '47', '217', '471', '2023-09-22', '3'),
('2308', '47', '219', '474', '2023-09-22', '24'),
('2309', '45', '219', '474', '2023-09-22', '24'),
('2310', '45', '217', '471', '2023-09-22', '3'),
('2311', '45', '158', '364', '2023-09-22', '160'),
('2312', '47', '222', '477', '2023-09-16', '1'),
('2313', '45', '222', '477', '2023-09-22', '1'),
('2314', '47', '225', '481', '2023-09-24', '48'),
('2315', '45', '225', '481', '2023-09-24', '48'),
('2316', '47', '221', '476', '2023-09-22', '1'),
('2317', '47', '199', '445', '2023-09-22', '2'),
('2318', '47', '200', '446', '2023-09-22', '1'),
('2319', '47', '200', '447', '2023-09-22', '1'),
('2320', '47', '227', '483', '2023-09-25', '3.2'),
('2321', '47', '228', '484', '2023-09-26', '6'),
('2322', '47', '214', '466', '2023-09-21', '1'),
('2323', '45', '214', '466', '2023-09-26', '1'),
('2324', '45', '221', '476', '2023-09-26', '1'),
('2325', '45', '199', '445', '2023-09-26', '2'),
('2326', '45', '200', '446', '2023-09-26', '1'),
('2327', '45', '200', '447', '2023-09-26', '1'),
('2328', '45', '227', '483', '2023-09-26', '3.2'),
('2329', '47', '145', '346', '2023-09-26', '8400'),
('2330', '45', '145', '346', '2023-09-26', '8400'),
('2331', '47', '154', '360', '2023-09-26', '21600'),
('2332', '45', '154', '360', '2023-09-26', '21600'),
('2333', '47', '174', '411', '2023-09-26', '19800'),
('2334', '45', '174', '411', '2023-09-26', '19800'),
('2335', '47', '214', '466', '2023-09-26', '39'),
('2336', '47', '220', '475', '2023-09-26', '1'),
('2337', '45', '220', '475', '2023-09-26', '1'),
('2338', '45', '214', '466', '2023-09-26', '39'),
('2339', '47', '153', '357', '2023-09-26', '3000'),
('2340', '47', '153', '359', '2023-09-26', '3000'),
('2341', '45', '153', '357', '2023-09-26', '3000'),
('2342', '45', '153', '359', '2023-09-26', '3000'),
('2343', '47', '230', '489', '2023-09-26', '60'),
('2344', '47', '230', '490', '2023-09-26', '60'),
('2345', '45', '230', '489', '2023-09-26', '60'),
('2346', '45', '230', '490', '2023-09-26', '60'),
('2347', '47', '231', '491', '2023-09-26', '60'),
('2348', '45', '231', '491', '2023-09-26', '60'),
('2349', '47', '234', '494', '2023-08-03', '1'),
('2350', '47', '234', '495', '2023-08-03', '1'),
('2351', '47', '235', '496', '2023-08-05', '1'),
('2352', '47', '236', '497', '2023-08-22', '1'),
('2353', '47', '236', '498', '2023-08-22', '1'),
('2354', '47', '238', '501', '2023-08-28', '1'),
('2355', '47', '238', '502', '2023-08-28', '1'),
('2356', '45', '234', '494', '2023-09-27', '1'),
('2357', '45', '234', '495', '2023-09-27', '1'),
('2358', '45', '235', '496', '2023-09-27', '1'),
('2359', '45', '236', '497', '2023-09-27', '1'),
('2360', '45', '236', '498', '2023-09-27', '1'),
('2361', '45', '238', '501', '2023-09-27', '1'),
('2362', '45', '238', '502', '2023-09-27', '1'),
('2363', '45', '228', '484', '2023-09-27', '6'),
('2364', '47', '214', '466', '2023-09-26', '30'),
('2365', '45', '214', '466', '2023-09-27', '30'),
('2366', '47', '149', '350', '2023-09-26', '4'),
('2367', '47', '211', '463', '2023-09-27', '1500'),
('2368', '47', '174', '411', '2023-09-27', '44400'),
('2369', '45', '174', '411', '2023-09-27', '44400'),
('2370', '47', '150', '351', '2023-09-01', '6'),
('2371', '45', '150', '351', '2023-09-27', '6'),
('2372', '47', '244', '512', '2023-09-27', '470'),
('2373', '47', '215', '467', '2023-09-30', '30'),
('2374', '47', '232', '492', '2023-09-28', '1'),
('2375', '45', '211', '463', '2023-09-30', '1500'),
('2376', '45', '244', '512', '2023-09-30', '470'),
('2377', '45', '149', '350', '2023-09-30', '4'),
('2378', '47', '181', '428', '2023-10-02', '1020'),
('2379', '45', '181', '428', '2023-10-02', '1020'),
('2380', '47', '247', '515', '2023-09-28', '0.5'),
('2381', '47', '248', '516', '2023-09-28', '0.5'),
('2382', '47', '249', '517', '2023-09-28', '1'),
('2383', '47', '83', '205', '2023-10-03', '1600'),
('2384', '47', '83', '206', '2023-10-03', '0'),
('2385', '45', '83', '205', '2023-10-03', '1600'),
('2386', '45', '83', '206', '2023-10-03', '0'),
('2387', '47', '262', '545', '2023-10-03', '1'),
('2388', '47', '262', '546', '2023-10-03', '1'),
('2389', '47', '263', '547', '2023-10-02', '1'),
('2390', '47', '264', '549', '2023-10-02', '1'),
('2391', '45', '262', '545', '2023-10-04', '1'),
('2392', '45', '262', '546', '2023-10-04', '1'),
('2393', '45', '263', '547', '2023-10-04', '1'),
('2394', '45', '264', '549', '2023-10-04', '1'),
('2395', '45', '232', '492', '2023-10-04', '1'),
('2396', '45', '247', '515', '2023-10-04', '0.5'),
('2397', '45', '248', '516', '2023-10-04', '0.5'),
('2398', '45', '249', '517', '2023-10-04', '1'),
('2399', '45', '215', '467', '2023-10-04', '30'),
('2400', '47', '266', '553', '2023-10-04', '1'),
('2401', '47', '266', '554', '2023-10-04', '1'),
('2402', '47', '174', '411', '2023-10-05', '35800'),
('2403', '45', '174', '411', '2023-10-05', '35800'),
('2404', '47', '257', '526', '2023-10-05', '420'),
('2405', '45', '257', '526', '2023-10-05', '420'),
('2406', '47', '269', '557', '2023-10-05', '13'),
('2407', '47', '269', '558', '2023-10-05', '60'),
('2408', '47', '269', '559', '2023-10-05', '8'),
('2409', '47', '269', '560', '2023-10-05', '59'),
('2410', '47', '269', '561', '2023-10-05', '4'),
('2411', '47', '269', '562', '2023-10-05', '1'),
('2412', '47', '269', '563', '2023-10-05', '1'),
('2413', '47', '269', '564', '2023-10-05', '1'),
('2414', '47', '269', '565', '2023-10-05', '1'),
('2415', '47', '269', '566', '2023-10-05', '4'),
('2416', '47', '269', '567', '2023-10-05', '1'),
('2417', '47', '269', '568', '2023-10-05', '1'),
('2418', '47', '269', '569', '2023-10-05', '3'),
('2419', '45', '269', '557', '2023-10-05', '13'),
('2420', '45', '269', '558', '2023-10-05', '60'),
('2421', '45', '269', '559', '2023-10-05', '8'),
('2422', '45', '269', '560', '2023-10-05', '59'),
('2423', '45', '269', '561', '2023-10-05', '4'),
('2424', '45', '269', '562', '2023-10-05', '1'),
('2425', '45', '269', '563', '2023-10-05', '1'),
('2426', '45', '269', '564', '2023-10-05', '1'),
('2427', '45', '269', '565', '2023-10-05', '1'),
('2428', '45', '269', '566', '2023-10-05', '4'),
('2429', '45', '269', '567', '2023-10-05', '1'),
('2430', '45', '269', '568', '2023-10-05', '1'),
('2431', '45', '269', '569', '2023-10-05', '3'),
('2432', '47', '206', '454', '2023-10-07', '1500'),
('2433', '47', '206', '455', '2023-10-07', '0'),
('2434', '45', '206', '454', '2023-10-07', '1500'),
('2435', '45', '206', '455', '2023-10-07', '0'),
('2436', '45', '266', '553', '2023-10-09', '1'),
('2437', '45', '266', '554', '2023-10-09', '1'),
('2438', '47', '181', '428', '2023-10-09', '1020'),
('2439', '45', '181', '428', '2023-10-09', '1020'),
('2440', '47', '206', '454', '2023-10-09', '0'),
('2441', '47', '206', '455', '2023-10-09', '2998'),
('2442', '45', '206', '454', '2023-10-09', '0'),
('2443', '45', '206', '455', '2023-10-09', '2998'),
('2444', '47', '181', '428', '2023-10-10', '1261'),
('2445', '45', '181', '428', '2023-10-10', '1261'),
('2446', '47', '207', '456', '2023-10-11', '281'),
('2447', '47', '207', '457', '2023-10-11', '0'),
('2448', '47', '207', '458', '2023-10-11', '300'),
('2449', '45', '207', '456', '2023-10-11', '281'),
('2450', '45', '207', '457', '2023-10-11', '0'),
('2451', '45', '207', '458', '2023-10-11', '300'),
('2452', '47', '81', '202', '2023-10-12', '2100'),
('2453', '47', '81', '203', '2023-10-12', '2100'),
('2454', '45', '81', '202', '2023-10-12', '2100'),
('2455', '45', '81', '203', '2023-10-12', '2100'),
('2456', '47', '282', '585', '2023-10-12', '4'),
('2457', '47', '287', '594', '2023-10-11', '6'),
('2458', '47', '287', '595', '2023-10-11', '3'),
('2459', '45', '287', '594', '2023-10-12', '6'),
('2460', '45', '287', '595', '2023-10-12', '3'),
('2461', '45', '282', '585', '2023-10-12', '4'),
('2462', '47', '270', '570', '2023-10-12', '1500'),
('2463', '47', '292', '600', '2023-10-12', '270'),
('2464', '47', '183', '430', '2023-10-10', '5350'),
('2465', '47', '183', '603', '2023-10-10', '5350'),
('2466', '45', '183', '430', '2023-10-13', '5350'),
('2467', '45', '183', '603', '2023-10-13', '5350'),
('2468', '45', '292', '600', '2023-10-13', '270'),
('2469', '45', '270', '570', '2023-10-14', '1500'),
('2470', '47', '300', '610', '2023-10-17', '1'),
('2471', '45', '300', '610', '2023-10-17', '1'),
('2472', '47', '301', '611', '2023-10-17', '22'),
('2473', '45', '301', '611', '2023-10-17', '22'),
('2474', '47', '303', '613', '2023-10-18', '1'),
('2475', '45', '303', '613', '2023-10-18', '1'),
('2476', '47', '278', '579', '2023-10-18', '0'),
('2477', '47', '278', '614', '2023-10-18', '500'),
('2478', '45', '278', '579', '2023-10-18', '0'),
('2479', '45', '278', '614', '2023-10-18', '500'),
('2480', '47', '280', '582', '2023-10-18', '300'),
('2481', '45', '280', '582', '2023-10-18', '300'),
('2482', '47', '154', '360', '2023-10-18', '45000'),
('2483', '45', '154', '360', '2023-10-18', '45000'),
('2484', '47', '305', '616', '2023-10-18', '23'),
('2485', '45', '305', '616', '2023-10-18', '23'),
('2486', '47', '308', '619', '2023-10-19', '200'),
('2487', '47', '308', '620', '2023-10-19', '1'),
('2488', '47', '308', '621', '2023-10-19', '1'),
('2489', '47', '308', '622', '2023-10-19', '1'),
('2490', '47', '308', '623', '2023-10-19', '2'),
('2491', '47', '308', '624', '2023-10-19', '2'),
('2492', '45', '308', '619', '2023-10-19', '200'),
('2493', '45', '308', '620', '2023-10-19', '1'),
('2494', '45', '308', '621', '2023-10-19', '1'),
('2495', '45', '308', '622', '2023-10-19', '1'),
('2496', '45', '308', '623', '2023-10-19', '2'),
('2497', '45', '308', '624', '2023-10-19', '2'),
('2498', '47', '207', '456', '2023-10-20', '0'),
('2499', '47', '207', '457', '2023-10-20', '877'),
('2500', '47', '207', '458', '2023-10-20', '0'),
('2501', '45', '207', '456', '2023-10-20', '0'),
('2502', '45', '207', '457', '2023-10-20', '877'),
('2503', '45', '207', '458', '2023-10-20', '0'),
('2504', '47', '285', '590', '2023-10-20', '1'),
('2505', '47', '285', '591', '2023-10-20', '1'),
('2506', '47', '285', '592', '2023-10-20', '1'),
('2507', '45', '285', '590', '2023-10-20', '1'),
('2508', '45', '285', '591', '2023-10-20', '1'),
('2509', '45', '285', '592', '2023-10-20', '1'),
('2510', '47', '286', '593', '2023-10-20', '4'),
('2511', '47', '298', '608', '2023-10-20', '32'),
('2512', '45', '298', '608', '2023-10-20', '32'),
('2513', '45', '286', '593', '2023-10-20', '4'),
('2514', '47', '309', '625', '2023-10-20', '3'),
('2515', '45', '309', '625', '2023-10-20', '3'),
('2516', '47', '310', '626', '2023-10-01', '1'),
('2517', '45', '310', '626', '2023-10-20', '1'),
('2518', '47', '154', '360', '2023-10-21', '9400'),
('2519', '45', '154', '360', '2023-10-21', '9400'),
('2520', '47', '311', '627', '2023-10-21', '480'),
('2521', '45', '311', '627', '2023-10-23', '480'),
('2522', '47', '316', '634', '2023-10-23', '44'),
('2523', '45', '316', '634', '2023-10-23', '44'),
('2524', '47', '127', '283', '2023-10-21', '50331'),
('2525', '47', '127', '284', '2023-10-21', '37500'),
('2526', '45', '127', '283', '2023-10-23', '50331'),
('2527', '45', '127', '284', '2023-10-23', '37500'),
('2528', '47', '126', '279', '2023-10-21', '0'),
('2529', '47', '126', '280', '2023-10-21', '0'),
('2530', '47', '126', '281', '2023-10-21', '0'),
('2531', '47', '126', '282', '2023-10-21', '0'),
('2532', '47', '126', '286', '2023-10-21', '0'),
('2533', '47', '126', '633', '2023-10-21', '18000'),
('2534', '45', '126', '279', '2023-10-23', '0'),
('2535', '45', '126', '280', '2023-10-23', '0'),
('2536', '45', '126', '281', '2023-10-23', '0'),
('2537', '45', '126', '282', '2023-10-23', '0'),
('2538', '45', '126', '286', '2023-10-23', '0'),
('2539', '45', '126', '633', '2023-10-23', '18000'),
('2540', '47', '318', '637', '2023-10-23', '1'),
('2541', '47', '318', '638', '2023-10-23', '1'),
('2542', '47', '81', '202', '2023-10-23', '1100'),
('2543', '47', '81', '203', '2023-10-23', '1100'),
('2544', '45', '81', '202', '2023-10-23', '1100'),
('2545', '45', '81', '203', '2023-10-23', '1100'),
('2546', '47', '60', '166', '2023-10-23', '1000'),
('2547', '47', '60', '167', '2023-10-23', '1000'),
('2548', '47', '60', '168', '2023-10-23', '0'),
('2549', '45', '60', '166', '2023-10-23', '1000'),
('2550', '45', '60', '167', '2023-10-23', '1000'),
('2551', '45', '60', '168', '2023-10-23', '0'),
('2552', '47', '317', '635', '2023-10-23', '1'),
('2553', '47', '317', '636', '2023-10-23', '1'),
('2554', '45', '318', '637', '2023-10-24', '1'),
('2555', '45', '318', '638', '2023-10-24', '1'),
('2556', '45', '317', '635', '2023-10-24', '1'),
('2557', '45', '317', '636', '2023-10-24', '1'),
('2558', '47', '312', '628', '2023-10-24', '1290'),
('2559', '45', '312', '628', '2023-10-25', '1290'),
('2560', '47', '278', '579', '2023-10-26', '1909'),
('2561', '47', '278', '614', '2023-10-26', '0'),
('2562', '45', '278', '579', '2023-10-26', '1909'),
('2563', '45', '278', '614', '2023-10-26', '0'),
('2564', '47', '326', '647', '2023-10-26', '1'),
('2565', '47', '326', '648', '2023-10-26', '1'),
('2566', '47', '326', '649', '2023-10-26', '1'),
('2567', '45', '326', '647', '2023-10-26', '1'),
('2568', '45', '326', '648', '2023-10-26', '1'),
('2569', '45', '326', '649', '2023-10-26', '1'),
('2570', '47', '327', '650', '2023-10-27', '1'),
('2571', '47', '327', '651', '2023-10-27', '1'),
('2572', '47', '327', '652', '2023-10-27', '1'),
('2573', '47', '327', '653', '2023-10-27', '1'),
('2574', '47', '327', '654', '2023-10-27', '1'),
('2575', '47', '327', '655', '2023-10-27', '1'),
('2576', '47', '328', '656', '2023-10-27', '0.1'),
('2577', '47', '183', '430', '2023-10-27', '6000'),
('2578', '47', '183', '603', '2023-10-27', '6000'),
('2579', '45', '183', '430', '2023-10-27', '6000'),
('2580', '45', '183', '603', '2023-10-27', '6000'),
('2581', '47', '276', '576', '2023-10-27', '3600'),
('2582', '47', '276', '577', '2023-10-27', '0'),
('2583', '45', '276', '576', '2023-10-27', '3600'),
('2584', '45', '276', '577', '2023-10-27', '0'),
('2585', '47', '291', '599', '2023-10-28', '3000'),
('2586', '45', '291', '599', '2023-10-28', '3000'),
('2587', '47', '299', '609', '2023-10-28', '5800'),
('2588', '45', '299', '609', '2023-10-28', '5800'),
('2589', '47', '331', '659', '2023-10-28', '3000'),
('2590', '47', '332', '660', '2023-10-28', '2000'),
('2591', '45', '331', '659', '2023-10-28', '3000'),
('2592', '45', '332', '660', '2023-10-28', '2000'),
('2593', '47', '336', '664', '2023-10-28', '100'),
('2594', '45', '336', '664', '2023-10-28', '100'),
('2595', '47', '306', '617', '2023-10-28', '900'),
('2596', '47', '60', '166', '2023-10-30', '2100'),
('2597', '47', '60', '167', '2023-10-30', '2100'),
('2598', '47', '60', '168', '2023-10-30', '0'),
('2599', '45', '60', '166', '2023-10-30', '2100'),
('2600', '45', '60', '167', '2023-10-30', '2100'),
('2601', '45', '60', '168', '2023-10-30', '0'),
('2602', '47', '335', '663', '2023-10-30', '1500'),
('2603', '45', '335', '663', '2023-10-30', '1500'),
('2604', '47', '338', '667', '2023-10-30', '200'),
('2605', '45', '306', '617', '2023-10-30', '900'),
('2606', '45', '338', '667', '2023-10-30', '200'),
('2607', '47', '281', '583', '2023-11-01', '2000'),
('2608', '47', '281', '584', '2023-11-01', '2000'),
('2609', '45', '281', '583', '2023-11-01', '2000'),
('2610', '45', '281', '584', '2023-11-01', '2000'),
('2611', '47', '340', '669', '2023-11-01', '28'),
('2612', '47', '340', '670', '2023-11-01', '28'),
('2613', '45', '340', '669', '2023-11-01', '28'),
('2614', '45', '340', '670', '2023-11-01', '28'),
('2615', '47', '127', '283', '2023-10-21', '50331'),
('2616', '47', '127', '284', '2023-10-21', '37500'),
('2617', '47', '127', '671', '2023-10-21', '18000'),
('2618', '47', '341', '672', '2023-11-01', '550'),
('2619', '47', '307', '618', '2023-11-01', '7340'),
('2620', '45', '307', '618', '2023-11-02', '7340'),
('2621', '45', '341', '672', '2023-11-02', '550'),
('2622', '47', '344', '675', '2023-11-02', '96'),
('2623', '45', '344', '675', '2023-11-02', '96'),
('2624', '47', '239', '503', '2023-11-03', '5'),
('2625', '45', '239', '503', '2023-11-03', '5'),
('2626', '47', '240', '504', '2023-11-03', '0.5'),
('2627', '47', '240', '505', '2023-11-03', '1'),
('2628', '47', '240', '506', '2023-11-03', '0.5'),
('2629', '45', '240', '504', '2023-11-03', '0.5'),
('2630', '45', '240', '505', '2023-11-03', '1'),
('2631', '45', '240', '506', '2023-11-03', '0.5'),
('2632', '47', '241', '507', '2023-11-03', '2'),
('2633', '47', '241', '508', '2023-11-03', '0.1'),
('2634', '47', '241', '509', '2023-11-03', '0.1'),
('2635', '45', '241', '507', '2023-11-03', '2'),
('2636', '45', '241', '508', '2023-11-03', '0.1'),
('2637', '45', '241', '509', '2023-11-03', '0.1'),
('2638', '47', '242', '510', '2023-11-03', '0.5'),
('2639', '45', '242', '510', '2023-11-03', '0.5'),
('2640', '47', '183', '430', '2023-11-03', '3000'),
('2641', '47', '183', '603', '2023-11-03', '3000'),
('2642', '45', '183', '430', '2023-11-03', '3000'),
('2643', '45', '183', '603', '2023-11-03', '3000'),
('2644', '47', '333', '661', '2023-11-03', '57000'),
('2645', '45', '333', '661', '2023-11-03', '57000'),
('2646', '47', '127', '283', '2023-10-18', '50331'),
('2647', '47', '127', '284', '2023-10-18', '37500'),
('2648', '47', '127', '671', '2023-10-18', '18000'),
('2649', '45', '127', '283', '2023-11-03', '50331'),
('2650', '45', '127', '284', '2023-11-03', '37500'),
('2651', '45', '127', '671', '2023-11-03', '18000'),
('2652', '47', '127', '283', '2023-10-18', '50331'),
('2653', '47', '127', '284', '2023-10-18', '37500'),
('2654', '47', '127', '671', '2023-10-18', '18000'),
('2655', '45', '127', '283', '2023-11-04', '50331'),
('2656', '45', '127', '284', '2023-11-04', '37500'),
('2657', '45', '127', '671', '2023-11-04', '18000'),
('2658', '47', '356', '699', '2023-11-06', '5'),
('2659', '45', '356', '699', '2023-11-06', '5'),
('2660', '47', '349', '691', '2023-11-06', '1'),
('2661', '47', '349', '692', '2023-11-06', '1'),
('2662', '47', '355', '698', '2023-11-06', '5'),
('2663', '47', '358', '701', '2023-11-06', '48'),
('2664', '45', '358', '701', '2023-11-06', '48'),
('2665', '47', '319', '639', '2023-11-06', '500'),
('2666', '45', '319', '639', '2023-11-06', '500'),
('2667', '47', '359', '702', '2023-11-06', '38'),
('2668', '45', '359', '702', '2023-11-06', '38'),
('2669', '47', '360', '703', '2023-11-06', '89'),
('2670', '47', '360', '704', '2023-11-06', '8'),
('2671', '47', '360', '705', '2023-11-06', '1'),
('2672', '47', '360', '706', '2023-11-06', '2'),
('2673', '45', '360', '703', '2023-11-06', '89'),
('2674', '45', '360', '704', '2023-11-06', '8'),
('2675', '45', '360', '705', '2023-11-06', '1'),
('2676', '45', '360', '706', '2023-11-06', '2'),
('2677', '47', '352', '695', '2023-11-06', '1573.275'),
('2678', '47', '361', '707', '2023-11-07', '48'),
('2679', '45', '361', '707', '2023-11-07', '48'),
('2680', '45', '349', '691', '2023-11-07', '1'),
('2681', '45', '349', '692', '2023-11-07', '1'),
('2682', '47', '363', '709', '2023-11-07', '24'),
('2683', '45', '363', '709', '2023-11-07', '24'),
('2684', '47', '334', '662', '2023-11-08', '5000'),
('2685', '45', '334', '662', '2023-11-08', '5000'),
('2686', '47', '299', '609', '2023-11-08', '100'),
('2687', '45', '299', '609', '2023-11-08', '100'),
('2688', '47', '183', '430', '2023-11-08', '9799'),
('2689', '47', '183', '603', '2023-11-08', '9735'),
('2690', '45', '183', '430', '2023-11-08', '9799'),
('2691', '45', '183', '603', '2023-11-08', '9735'),
('2692', '47', '342', '673', '2023-11-08', '750'),
('2693', '47', '343', '674', '2023-11-08', '750'),
('2694', '47', '366', '713', '2023-11-08', '50'),
('2695', '47', '367', '714', '2023-11-08', '150'),
('2696', '47', '320', '640', '2023-11-08', '10000'),
('2697', '47', '320', '641', '2023-11-08', '10000'),
('2698', '45', '320', '640', '2023-11-08', '10000'),
('2699', '45', '320', '641', '2023-11-08', '10000'),
('2700', '47', '190', '439', '2023-11-08', '20000'),
('2701', '45', '190', '439', '2023-11-08', '20000'),
('2702', '47', '371', '720', '2023-11-08', '2400'),
('2703', '45', '371', '720', '2023-11-08', '2400'),
('2704', '47', '370', '718', '2023-11-08', '43'),
('2705', '47', '370', '719', '2023-11-08', '50'),
('2706', '45', '370', '718', '2023-11-08', '43'),
('2707', '45', '370', '719', '2023-11-08', '50'),
('2708', '45', '367', '714', '2023-11-08', '150'),
('2709', '45', '366', '713', '2023-11-08', '50'),
('2710', '45', '355', '698', '2023-11-08', '5'),
('2711', '45', '328', '656', '2023-11-08', '0.1'),
('2712', '45', '342', '673', '2023-11-08', '750'),
('2713', '45', '343', '674', '2023-11-08', '750'),
('2714', '45', '327', '650', '2023-11-08', '1'),
('2715', '45', '327', '651', '2023-11-08', '1'),
('2716', '45', '327', '652', '2023-11-08', '1'),
('2717', '45', '327', '653', '2023-11-08', '1'),
('2718', '45', '327', '654', '2023-11-08', '1'),
('2719', '45', '327', '655', '2023-11-08', '1'),
('2720', '47', '373', '727', '2023-10-26', '1'),
('2721', '45', '373', '727', '2023-11-08', '1'),
('2722', '47', '374', '728', '2023-11-08', '96'),
('2723', '45', '374', '728', '2023-11-08', '96'),
('2724', '47', '60', '166', '2023-11-10', '2100'),
('2725', '47', '60', '167', '2023-11-10', '2100'),
('2726', '47', '60', '168', '2023-11-10', '0'),
('2727', '45', '60', '166', '2023-11-10', '2100'),
('2728', '45', '60', '167', '2023-11-10', '2100'),
('2729', '45', '60', '168', '2023-11-10', '0'),
('2730', '47', '206', '454', '2023-11-10', '1200'),
('2731', '47', '206', '455', '2023-11-10', '2400'),
('2732', '45', '206', '454', '2023-11-10', '1200'),
('2733', '45', '206', '455', '2023-11-10', '2400'),
('2734', '45', '352', '695', '2023-11-11', '1573.275'),
('2735', '47', '126', '279', '2023-11-08', '83856'),
('2736', '47', '126', '280', '2023-11-08', '35059'),
('2737', '47', '126', '281', '2023-11-08', '43769'),
('2738', '47', '126', '282', '2023-11-08', '103500'),
('2739', '47', '126', '286', '2023-11-08', '45000'),
('2740', '47', '126', '633', '2023-11-08', '18000'),
('2741', '45', '126', '279', '2023-11-11', '83856'),
('2742', '45', '126', '280', '2023-11-11', '35059'),
('2743', '45', '126', '281', '2023-11-11', '43769'),
('2744', '45', '126', '282', '2023-11-11', '103500'),
('2745', '45', '126', '286', '2023-11-11', '45000'),
('2746', '45', '126', '633', '2023-11-11', '18000'),
('2747', '47', '368', '715', '2023-11-11', '1280'),
('2748', '47', '369', '716', '2023-11-11', '2160'),
('2749', '47', '369', '717', '2023-11-11', '0'),
('2750', '47', '369', '716', '2023-11-11', '0'),
('2751', '47', '369', '717', '2023-11-11', '2697.2'),
('2752', '47', '364', '710', '2023-11-11', '5339.6'),
('2753', '47', '181', '428', '2023-11-11', '989'),
('2754', '45', '181', '428', '2023-11-13', '989'),
('2755', '47', '307', '618', '2023-11-08', '3076'),
('2756', '45', '307', '618', '2023-11-13', '3076'),
('2757', '47', '377', '731', '2023-11-11', '4830'),
('2758', '45', '377', '731', '2023-11-13', '4830'),
('2759', '45', '364', '710', '2023-11-13', '5339.6'),
('2760', '47', '378', '732', '2023-11-13', '6'),
('2761', '45', '378', '732', '2023-11-13', '6'),
('2762', '47', '181', '428', '2023-11-13', '270'),
('2763', '45', '181', '428', '2023-11-13', '270'),
('2764', '47', '290', '598', '2023-11-13', '350'),
('2765', '45', '290', '598', '2023-11-13', '350'),
('2766', '47', '381', '735', '2023-11-13', '130'),
('2767', '45', '381', '735', '2023-11-14', '130'),
('2768', '47', '364', '710', '2023-11-08', '30.8'),
('2769', '47', '369', '716', '2023-11-08', '0'),
('2770', '47', '369', '717', '2023-11-08', '2.8'),
('2771', '47', '384', '738', '2023-11-15', '48'),
('2772', '45', '384', '738', '2023-11-15', '48'),
('2773', '45', '364', '710', '2023-11-15', '30.8'),
('2774', '45', '368', '715', '2023-11-15', '1280'),
('2775', '45', '369', '716', '2023-11-15', '2160'),
('2776', '45', '369', '717', '2023-11-15', '2700'),
('2777', '47', '357', '700', '2023-11-16', '5000'),
('2778', '45', '357', '700', '2023-11-16', '5000'),
('2779', '47', '379', '733', '2023-11-16', '1500'),
('2780', '47', '385', '739', '2023-11-16', '50'),
('2781', '45', '385', '739', '2023-11-16', '50'),
('2782', '47', '386', '740', '2023-11-16', '240'),
('2783', '45', '379', '733', '2023-11-16', '1500'),
('2784', '45', '386', '740', '2023-11-16', '240'),
('2785', '47', '333', '661', '2023-11-20', '12000'),
('2786', '45', '333', '661', '2023-11-20', '12000'),
('2787', '47', '353', '696', '2023-11-20', '100'),
('2788', '45', '353', '696', '2023-11-20', '100'),
('2789', '47', '333', '661', '2023-11-20', '22800'),
('2790', '45', '333', '661', '2023-11-20', '22800'),
('2791', '47', '391', '745', '2023-11-20', '3375'),
('2792', '45', '391', '745', '2023-11-21', '3375'),
('2793', '47', '333', '661', '2023-11-21', '8200'),
('2794', '45', '333', '661', '2023-11-21', '8200'),
('2795', '47', '396', '750', '2023-11-21', '200'),
('2796', '45', '396', '750', '2023-11-21', '200'),
('2797', '47', '395', '749', '2023-11-21', '10'),
('2798', '47', '387', '741', '2023-11-21', '1400'),
('2799', '45', '387', '741', '2023-11-21', '1400'),
('2800', '47', '388', '742', '2023-11-21', '120'),
('2801', '45', '388', '742', '2023-11-21', '120'),
('2802', '45', '395', '749', '2023-11-21', '10'),
('2803', '47', '391', '745', '2023-11-21', '675'),
('2804', '47', '400', '751', '2023-11-24', '950'),
('2805', '47', '390', '744', '2023-11-24', '0.4'),
('2806', '45', '400', '751', '2023-11-25', '950'),
('2807', '45', '391', '745', '2023-11-25', '675'),
('2808', '47', '129', '293', '2023-11-25', '0'),
('2809', '47', '129', '294', '2023-11-25', '100000'),
('2810', '47', '129', '295', '2023-11-25', '0'),
('2811', '47', '129', '296', '2023-11-25', '112500'),
('2812', '47', '129', '297', '2023-11-25', '24515'),
('2813', '47', '129', '298', '2023-11-25', '38500'),
('2814', '47', '129', '299', '2023-11-25', '0'),
('2815', '47', '129', '300', '2023-11-25', '24000'),
('2816', '45', '129', '293', '2023-11-25', '0'),
('2817', '45', '129', '294', '2023-11-25', '100000'),
('2818', '45', '129', '295', '2023-11-25', '0'),
('2819', '45', '129', '296', '2023-11-25', '112500'),
('2820', '45', '129', '297', '2023-11-25', '24515'),
('2821', '45', '129', '298', '2023-11-25', '38500'),
('2822', '45', '129', '299', '2023-11-25', '0'),
('2823', '45', '129', '300', '2023-11-25', '24000'),
('2824', '45', '390', '744', '2023-11-25', '0.4'),
('2825', '47', '389', '743', '2023-11-25', '60'),
('2826', '45', '389', '743', '2023-11-27', '60'),
('2827', '47', '405', '756', '2023-11-02', '1'),
('2828', '45', '405', '756', '2023-11-27', '1'),
('2829', '47', '129', '293', '2023-11-29', '44120'),
('2830', '47', '129', '294', '2023-11-29', '0'),
('2831', '47', '129', '295', '2023-11-29', '0'),
('2832', '47', '129', '296', '2023-11-29', '7500'),
('2833', '47', '129', '297', '2023-11-29', '0'),
('2834', '47', '129', '298', '2023-11-29', '0'),
('2835', '47', '129', '299', '2023-11-29', '24000'),
('2836', '47', '129', '300', '2023-11-29', '0'),
('2837', '45', '129', '293', '2023-11-29', '44120'),
('2838', '45', '129', '294', '2023-11-29', '0'),
('2839', '45', '129', '295', '2023-11-29', '0'),
('2840', '45', '129', '296', '2023-11-29', '7500'),
('2841', '45', '129', '297', '2023-11-29', '0'),
('2842', '45', '129', '298', '2023-11-29', '0'),
('2843', '45', '129', '299', '2023-11-29', '24000'),
('2844', '45', '129', '300', '2023-11-29', '0'),
('2845', '47', '392', '746', '2023-11-29', '25'),
('2846', '45', '392', '746', '2023-11-29', '25'),
('2847', '47', '414', '765', '2023-11-29', '660'),
('2848', '47', '389', '743', '2023-11-30', '60'),
('2849', '45', '389', '743', '2023-11-30', '60'),
('2850', '47', '403', '754', '2023-11-30', '1500'),
('2851', '47', '408', '759', '2023-11-30', '958.8'),
('2852', '45', '403', '754', '2023-11-30', '1500'),
('2853', '45', '408', '759', '2023-11-30', '958.8'),
('2854', '45', '414', '765', '2023-11-30', '660'),
('2855', '47', '401', '752', '2023-11-30', '230'),
('2856', '45', '401', '752', '2023-11-30', '230'),
('2857', '47', '406', '757', '2023-11-30', '236'),
('2858', '45', '406', '757', '2023-11-30', '236'),
('2859', '47', '431', '801', '2023-11-30', '50'),
('2860', '47', '129', '293', '2023-12-01', '55880'),
('2861', '47', '129', '294', '2023-12-01', '0'),
('2862', '47', '129', '295', '2023-12-01', '120000'),
('2863', '47', '129', '296', '2023-12-01', '0'),
('2864', '47', '129', '297', '2023-12-01', '0'),
('2865', '47', '129', '298', '2023-12-01', '0'),
('2866', '47', '129', '299', '2023-12-01', '0'),
('2867', '47', '129', '300', '2023-12-01', '0'),
('2868', '45', '129', '293', '2023-12-01', '55880'),
('2869', '45', '129', '294', '2023-12-01', '0'),
('2870', '45', '129', '295', '2023-12-01', '120000'),
('2871', '45', '129', '296', '2023-12-01', '0'),
('2872', '45', '129', '297', '2023-12-01', '0'),
('2873', '45', '129', '298', '2023-12-01', '0'),
('2874', '45', '129', '299', '2023-12-01', '0'),
('2875', '45', '129', '300', '2023-12-01', '0'),
('2876', '47', '430', '800', '2023-12-01', '990'),
('2877', '47', '428', '798', '2023-11-30', '8'),
('2878', '45', '431', '801', '2023-12-01', '50'),
('2879', '47', '424', '792', '2023-12-02', '1'),
('2880', '47', '424', '793', '2023-12-02', '1'),
('2881', '47', '389', '743', '2023-12-02', '60'),
('2882', '45', '389', '743', '2023-12-02', '60'),
('2883', '45', '428', '798', '2023-12-02', '3.75'),
('2884', '47', '427', '797', '2023-12-02', '1040'),
('2885', '47', '419', '774', '2023-12-02', '40'),
('2886', '47', '432', '802', '2023-12-02', '1'),
('2887', '45', '432', '802', '2023-12-02', '1'),
('2888', '47', '434', '804', '2023-11-25', '22'),
('2889', '47', '434', '805', '2023-11-25', '0'),
('2890', '47', '434', '806', '2023-11-25', '0'),
('2891', '47', '434', '807', '2023-11-25', '0'),
('2892', '47', '434', '808', '2023-11-25', '0'),
('2893', '45', '434', '804', '2023-12-02', '22'),
('2894', '45', '434', '805', '2023-12-02', '0'),
('2895', '45', '434', '806', '2023-12-02', '0'),
('2896', '45', '434', '807', '2023-12-02', '0'),
('2897', '45', '434', '808', '2023-12-02', '0'),
('2898', '47', '434', '804', '2023-11-29', '0'),
('2899', '47', '434', '805', '2023-11-29', '12758'),
('2900', '47', '434', '806', '2023-11-29', '0'),
('2901', '47', '434', '807', '2023-11-29', '0'),
('2902', '47', '434', '808', '2023-11-29', '40000'),
('2903', '45', '434', '804', '2023-12-02', '0'),
('2904', '45', '434', '805', '2023-12-02', '12758'),
('2905', '45', '434', '806', '2023-12-02', '0'),
('2906', '45', '434', '807', '2023-12-02', '0'),
('2907', '45', '434', '808', '2023-12-02', '40000'),
('2908', '47', '434', '804', '2023-12-01', '0'),
('2909', '47', '434', '805', '2023-12-01', '0'),
('2910', '47', '434', '806', '2023-12-01', '8463'),
('2911', '47', '434', '807', '2023-12-01', '0'),
('2912', '47', '434', '808', '2023-12-01', '0'),
('2913', '45', '434', '804', '2023-12-02', '0'),
('2914', '45', '434', '805', '2023-12-02', '0'),
('2915', '45', '434', '806', '2023-12-02', '8463'),
('2916', '45', '434', '807', '2023-12-02', '0'),
('2917', '45', '434', '808', '2023-12-02', '0'),
('2918', '47', '434', '804', '2023-12-01', '0'),
('2919', '47', '434', '805', '2023-12-01', '0'),
('2920', '47', '434', '806', '2023-12-01', '0'),
('2921', '47', '434', '807', '2023-12-01', '17200'),
('2922', '47', '434', '808', '2023-12-01', '0'),
('2923', '45', '434', '804', '2023-12-02', '0'),
('2924', '45', '434', '805', '2023-12-02', '0'),
('2925', '45', '434', '806', '2023-12-02', '0'),
('2926', '45', '434', '807', '2023-12-02', '17200'),
('2927', '45', '434', '808', '2023-12-02', '0'),
('2928', '47', '415', '766', '2023-12-04', '18000'),
('2929', '47', '415', '767', '2023-12-04', '3700'),
('2930', '47', '415', '768', '2023-12-04', '14700'),
('2931', '45', '415', '766', '2023-12-04', '18000'),
('2932', '45', '415', '767', '2023-12-04', '3700'),
('2933', '45', '415', '768', '2023-12-04', '14700'),
('2934', '45', '430', '800', '2023-12-05', '990'),
('2935', '45', '427', '797', '2023-12-05', '1040'),
('2936', '45', '428', '798', '2023-12-05', '4.25'),
('2937', '47', '181', '428', '2023-12-04', '732'),
('2938', '45', '181', '428', '2023-12-05', '732'),
('2939', '47', '206', '454', '2023-12-04', '300'),
('2940', '47', '206', '455', '2023-12-04', '3299'),
('2941', '45', '206', '454', '2023-12-05', '300'),
('2942', '45', '206', '455', '2023-12-05', '3299'),
('2943', '47', '389', '743', '2023-12-01', '54'),
('2944', '45', '389', '743', '2023-12-05', '54'),
('2945', '45', '419', '774', '2023-12-05', '40'),
('2946', '47', '435', '809', '2023-12-05', '1020'),
('2947', '45', '435', '809', '2023-12-05', '1020'),
('2948', '47', '440', '814', '2023-12-04', '335'),
('2949', '45', '440', '814', '2023-12-05', '335'),
('2950', '47', '416', '769', '2023-12-06', '500'),
('2951', '45', '416', '769', '2023-12-06', '500'),
('2952', '47', '448', '823', '2023-12-06', '27'),
('2953', '45', '448', '823', '2023-12-06', '27'),
('2954', '47', '420', '775', '2023-12-06', '50'),
('2955', '45', '420', '775', '2023-12-06', '50'),
('2956', '47', '437', '811', '2023-12-06', '160'),
('2957', '47', '439', '813', '2023-12-07', '990'),
('2958', '45', '439', '813', '2023-12-07', '990'),
('2959', '45', '424', '792', '2023-12-07', '1'),
('2960', '45', '424', '793', '2023-12-07', '1'),
('2961', '47', '183', '430', '2023-12-07', '851'),
('2962', '47', '183', '603', '2023-12-07', '915'),
('2963', '47', '348', '689', '2023-12-07', '6034'),
('2964', '47', '348', '690', '2023-12-07', '5985'),
('2965', '45', '183', '430', '2023-12-07', '851'),
('2966', '45', '183', '603', '2023-12-07', '915'),
('2967', '45', '348', '689', '2023-12-07', '6034'),
('2968', '45', '348', '690', '2023-12-07', '5985'),
('2969', '47', '452', '827', '2023-10-04', '1'),
('2970', '47', '453', '828', '2023-12-07', '1'),
('2971', '45', '452', '827', '2023-12-07', '1'),
('2972', '45', '453', '828', '2023-12-07', '1'),
('2973', '47', '454', '829', '2023-12-07', '1'),
('2974', '45', '454', '829', '2023-12-07', '1'),
('2975', '47', '455', '830', '2023-12-09', '9'),
('2976', '47', '429', '799', '2023-12-09', '1640'),
('2977', '47', '426', '795', '2023-12-08', '4000'),
('2978', '47', '426', '796', '2023-12-08', '4000'),
('2979', '45', '426', '795', '2023-12-11', '4000'),
('2980', '45', '426', '796', '2023-12-11', '4000'),
('2981', '47', '425', '794', '2023-12-09', '7076'),
('2982', '45', '425', '794', '2023-12-11', '7076'),
('2983', '45', '455', '830', '2023-12-11', '9'),
('2984', '47', '467', '850', '2023-12-08', '50'),
('2985', '45', '467', '850', '2023-12-11', '50'),
('2986', '45', '437', '811', '2023-12-11', '160'),
('2987', '47', '406', '757', '2023-12-09', '120'),
('2988', '45', '406', '757', '2023-12-11', '120'),
('2989', '47', '469', '852', '2023-12-09', '41'),
('2990', '45', '469', '852', '2023-12-11', '41'),
('2991', '47', '348', '689', '2023-12-11', '6300'),
('2992', '47', '348', '690', '2023-12-11', '6300'),
('2993', '45', '348', '689', '2023-12-11', '6300'),
('2994', '45', '348', '690', '2023-12-11', '6300'),
('2995', '47', '436', '810', '2023-12-12', '4000'),
('2996', '45', '436', '810', '2023-12-12', '4000'),
('2997', '47', '147', '348', '2023-12-12', '50'),
('2998', '45', '147', '348', '2023-12-12', '50'),
('2999', '47', '468', '851', '2023-12-12', '1460'),
('3000', '47', '421', '776', '2023-12-12', '1260'),
('3001', '47', '474', '858', '2023-12-12', '30'),
('3002', '47', '474', '859', '2023-12-12', '60'),
('3003', '47', '478', '864', '2023-12-12', '2160'),
('3004', '47', '478', '865', '2023-12-12', '0'),
('3005', '47', '478', '866', '2023-12-12', '0'),
('3006', '47', '478', '864', '2023-12-12', '0'),
('3007', '47', '478', '865', '2023-12-12', '0'),
('3008', '47', '478', '866', '2023-12-12', '2640'),
('3009', '47', '478', '864', '2023-12-12', '0'),
('3010', '47', '478', '865', '2023-12-12', '2473'),
('3011', '47', '478', '866', '2023-12-12', '0'),
('3012', '47', '206', '454', '2023-12-13', '1249'),
('3013', '47', '206', '455', '2023-12-13', '0'),
('3014', '45', '206', '454', '2023-12-13', '1249'),
('3015', '45', '206', '455', '2023-12-13', '0'),
('3016', '45', '421', '776', '2023-12-13', '1260'),
('3017', '45', '478', '864', '2023-12-13', '2160'),
('3018', '45', '478', '865', '2023-12-13', '2473'),
('3019', '45', '478', '866', '2023-12-13', '2640'),
('3020', '45', '468', '851', '2023-12-13', '1460'),
('3021', '47', '463', '839', '2023-12-13', '0'),
('3022', '47', '463', '840', '2023-12-13', '0'),
('3023', '47', '463', '841', '2023-12-13', '0'),
('3024', '47', '463', '842', '2023-12-13', '0'),
('3025', '47', '463', '843', '2023-12-13', '0'),
('3026', '47', '463', '844', '2023-12-13', '0'),
('3027', '47', '463', '845', '2023-12-13', '0'),
('3028', '47', '463', '846', '2023-12-13', '2'),
('3029', '45', '463', '839', '2023-12-13', '0'),
('3030', '45', '463', '840', '2023-12-13', '0'),
('3031', '45', '463', '841', '2023-12-13', '0'),
('3032', '45', '463', '842', '2023-12-13', '0'),
('3033', '45', '463', '843', '2023-12-13', '0'),
('3034', '45', '463', '844', '2023-12-13', '0'),
('3035', '45', '463', '845', '2023-12-13', '0'),
('3036', '45', '463', '846', '2023-12-13', '2'),
('3037', '47', '461', '836', '2023-12-14', '5000'),
('3038', '47', '461', '837', '2023-12-14', '4000'),
('3039', '45', '461', '836', '2023-12-14', '5000'),
('3040', '45', '461', '837', '2023-12-14', '4000'),
('3041', '47', '206', '454', '2023-12-14', '76'),
('3042', '47', '206', '455', '2023-12-14', '0'),
('3043', '45', '206', '454', '2023-12-14', '76'),
('3044', '45', '206', '455', '2023-12-14', '0'),
('3045', '47', '489', '881', '2023-12-14', '474'),
('3046', '45', '489', '881', '2023-12-14', '474'),
('3047', '47', '407', '758', '2023-12-13', '8'),
('3048', '47', '472', '856', '2023-12-13', '0.4'),
('3049', '45', '407', '758', '2023-12-15', '8'),
('3050', '45', '472', '856', '2023-12-15', '0.4'),
('3051', '45', '474', '858', '2023-12-15', '30'),
('3052', '45', '474', '859', '2023-12-15', '60'),
('3053', '47', '475', '860', '2023-12-13', '1'),
('3054', '47', '471', '855', '2023-12-14', '640'),
('3055', '45', '471', '855', '2023-12-15', '640'),
('3056', '45', '475', '860', '2023-12-15', '1'),
('3057', '47', '487', '875', '2023-12-15', '1380'),
('3058', '45', '487', '875', '2023-12-15', '1380'),
('3059', '47', '477', '863', '2023-12-12', '10734.4'),
('3060', '47', '478', '864', '2023-12-15', '0'),
('3061', '47', '478', '865', '2023-12-15', '3152'),
('3062', '47', '478', '866', '2023-12-15', '0'),
('3063', '47', '429', '799', '2023-12-09', '1640'),
('3064', '47', '462', '838', '2023-12-16', '217'),
('3065', '47', '457', '832', '2023-12-16', '1100'),
('3066', '47', '425', '794', '2023-12-16', '2754'),
('3067', '45', '477', '863', '2023-12-18', '10734.4'),
('3068', '45', '429', '799', '2023-12-18', '1640'),
('3069', '45', '478', '864', '2023-12-18', '0'),
('3070', '45', '478', '865', '2023-12-18', '3152'),
('3071', '45', '478', '866', '2023-12-18', '0'),
('3072', '47', '495', '887', '2023-12-16', '6'),
('3073', '45', '462', '838', '2023-12-18', '217'),
('3074', '45', '425', '794', '2023-12-18', '2754'),
('3075', '45', '457', '832', '2023-12-18', '1100'),
('3076', '45', '495', '887', '2023-12-18', '6'),
('3077', '47', '348', '689', '2023-12-18', '10500'),
('3078', '47', '348', '690', '2023-12-18', '9966'),
('3079', '45', '348', '689', '2023-12-18', '10500'),
('3080', '45', '348', '690', '2023-12-18', '9966'),
('3081', '47', '492', '884', '2023-12-16', '2475'),
('3082', '47', '493', '885', '2023-12-19', '1500'),
('3083', '47', '488', '876', '2023-12-19', '0.25'),
('3084', '47', '488', '877', '2023-12-19', '1'),
('3085', '47', '488', '878', '2023-12-19', '1'),
('3086', '47', '488', '879', '2023-12-19', '1'),
('3087', '47', '488', '880', '2023-12-19', '0.25'),
('3088', '47', '499', '892', '2023-12-19', '50'),
('3089', '45', '493', '885', '2023-12-19', '1500'),
('3090', '45', '499', '892', '2023-12-19', '50'),
('3091', '47', '362', '708', '2023-12-21', '1'),
('3092', '45', '362', '708', '2023-12-21', '1'),
('3093', '47', '485', '873', '2023-12-21', '3'),
('3094', '47', '498', '891', '2023-12-21', '1'),
('3095', '47', '473', '857', '2023-12-21', '3'),
('3096', '47', '447', '822', '2023-12-21', '5000'),
('3097', '47', '450', '825', '2023-12-21', '4000'),
('3098', '47', '460', '835', '2023-12-21', '5000'),
('3099', '47', '484', '872', '2023-12-21', '1199'),
('3100', '47', '458', '833', '2023-12-21', '30000'),
('3101', '47', '465', '848', '2023-12-21', '600'),
('3102', '47', '470', '853', '2023-12-21', '40'),
('3103', '47', '470', '854', '2023-12-21', '40'),
('3104', '47', '456', '831', '2023-12-21', '1400'),
('3105', '47', '429', '799', '2023-12-21', '410'),
('3106', '47', '479', '867', '2023-12-21', '640'),
('3107', '47', '480', '868', '2023-12-21', '200'),
('3108', '45', '456', '831', '2023-12-21', '1400'),
('3109', '45', '484', '872', '2023-12-21', '1199'),
('3110', '45', '460', '835', '2023-12-21', '5000'),
('3111', '45', '465', '848', '2023-12-21', '600'),
('3112', '45', '447', '822', '2023-12-21', '5000'),
('3113', '45', '450', '825', '2023-12-21', '4000'),
('3114', '45', '458', '833', '2023-12-21', '30000'),
('3115', '47', '502', '895', '2023-12-21', '200'),
('3116', '45', '502', '895', '2023-12-22', '200'),
('3117', '45', '473', '857', '2023-12-22', '3'),
('3118', '45', '480', '868', '2023-12-22', '200'),
('3119', '45', '492', '884', '2023-12-22', '2475'),
('3120', '45', '498', '891', '2023-12-22', '1'),
('3121', '45', '479', '867', '2023-12-22', '640'),
('3122', '45', '485', '873', '2023-12-22', '3'),
('3123', '45', '429', '799', '2023-12-22', '410'),
('3124', '47', '458', '833', '2023-12-23', '48000'),
('3125', '47', '496', '888', '2023-12-23', '130'),
('3126', '47', '496', '889', '2023-12-23', '240'),
('3127', '45', '458', '833', '2023-12-26', '48000'),
('3128', '45', '496', '888', '2023-12-26', '130'),
('3129', '45', '496', '889', '2023-12-26', '240'),
('3130', '45', '470', '853', '2023-12-27', '40'),
('3131', '45', '470', '854', '2023-12-27', '40'),
('3132', '47', '501', '894', '2023-12-27', '1500'),
('3133', '45', '501', '894', '2023-12-27', '1500'),
('3134', '47', '508', '902', '2023-12-27', '40'),
('3135', '45', '508', '902', '2023-12-27', '40'),
('3136', '47', '483', '871', '2023-12-27', '417'),
('3137', '47', '505', '899', '2023-12-27', '250'),
('3138', '47', '509', '903', '2023-12-27', '108'),
('3139', '47', '458', '833', '2023-12-27', '42000'),
('3140', '47', '486', '874', '2023-12-27', '3598'),
('3141', '47', '486', '912', '2023-12-27', '3584'),
('3142', '47', '512', '913', '2023-12-27', '22'),
('3143', '47', '512', '914', '2023-12-27', '65'),
('3144', '47', '514', '916', '2024-01-27', '100'),
('3145', '45', '514', '916', '2024-01-27', '100'),
('3146', '47', '515', '917', '2024-01-27', '300'),
('3147', '45', '515', '917', '2024-01-27', '300');

### Structure of table `0_item_codes` ###

DROP TABLE IF EXISTS `0_item_codes`;

CREATE TABLE `0_item_codes` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `item_code` varchar(20) NOT NULL,
  `stock_id` varchar(20) NOT NULL,
  `description` varchar(200) NOT NULL DEFAULT '',
  `category_id` smallint(6) unsigned NOT NULL,
  `quantity` double NOT NULL DEFAULT 1,
  `is_foreign` tinyint(1) NOT NULL DEFAULT 0,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `stock_id` (`stock_id`,`item_code`),
  KEY `item_code` (`item_code`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_item_codes` ###

INSERT INTO `0_item_codes` VALUES
('1', 'FG-001', 'FG-001', 'Racking System Local', '42', '1', '0', '0'),
('2', 'SER-001', 'SER-001', 'Racking System Imported', '41', '1', '0', '0');

### Structure of table `0_item_group` ###

DROP TABLE IF EXISTS `0_item_group`;

CREATE TABLE `0_item_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` varchar(100) NOT NULL,
  `fixed_asset` int(11) NOT NULL DEFAULT 0,
  `inactive` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=33 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_item_group` ###

INSERT INTO `0_item_group` VALUES
('1', 'Default', '0', '0');

### Structure of table `0_item_packings` ###

DROP TABLE IF EXISTS `0_item_packings`;

CREATE TABLE `0_item_packings` (
  `abbr` varchar(20) NOT NULL,
  `name` varchar(40) NOT NULL,
  `decimals` tinyint(2) NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`abbr`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_item_packings` ###

INSERT INTO `0_item_packings` VALUES
('BD', 'Bundes', '2', '0'),
('BG', 'Bags', '2', '0'),
('Box', 'Box', '0', '0'),
('CTN', 'Carton', '2', '0'),
('DM', 'Drums', '2', '0'),
('GLN', 'Galan', '2', '0'),
('JR', 'Jars', '2', '0'),
('Pack', 'Pack', '0', '0'),
('Pcs', 'Pcs', '0', '0'),
('Vessels', 'Vessels', '0', '0');

### Structure of table `0_item_tax_type_exemptions` ###

DROP TABLE IF EXISTS `0_item_tax_type_exemptions`;

CREATE TABLE `0_item_tax_type_exemptions` (
  `item_tax_type_id` int(11) NOT NULL DEFAULT 0,
  `tax_type_id` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`item_tax_type_id`,`tax_type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_item_tax_type_exemptions` ###


### Structure of table `0_item_tax_types` ###

DROP TABLE IF EXISTS `0_item_tax_types`;

CREATE TABLE `0_item_tax_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(60) NOT NULL DEFAULT '',
  `exempt` tinyint(1) NOT NULL DEFAULT 0,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_item_tax_types` ###

INSERT INTO `0_item_tax_types` VALUES
('1', 'Regular', '0', '0');

### Structure of table `0_item_units` ###

DROP TABLE IF EXISTS `0_item_units`;

CREATE TABLE `0_item_units` (
  `abbr` varchar(20) NOT NULL,
  `name` varchar(40) NOT NULL,
  `decimals` tinyint(2) NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`abbr`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_item_units` ###

INSERT INTO `0_item_units` VALUES
('BG', 'Bag', '4', '0'),
('Book', 'Book', '0', '0'),
('Bot', 'Bottle', '0', '0'),
('Box', 'Box', '0', '0'),
('Ctn', 'Ctn', '4', '0'),
('each', 'Each', '0', '0'),
('Ft', 'Feet', '0', '0'),
('gm', 'gm', '0', '0'),
('GRM', 'GRM', '4', '0'),
('KG', 'KG', '5', '0'),
('LTR', 'Liter', '5', '0'),
('Meter', 'Meter', '0', '0'),
('Pair', 'Pair', '0', '0'),
('Pckt', 'Packet', '0', '0'),
('Pcs', 'Pcs', '2', '0'),
('PKR', 'PKR', '0', '0');

### Structure of table `0_journal` ###

DROP TABLE IF EXISTS `0_journal`;

CREATE TABLE `0_journal` (
  `type` smallint(6) NOT NULL DEFAULT 0,
  `trans_no` int(11) NOT NULL DEFAULT 0,
  `tran_date` date DEFAULT '0000-00-00',
  `reference` varchar(60) NOT NULL DEFAULT '',
  `source_ref` longtext NOT NULL,
  `event_date` date DEFAULT '0000-00-00',
  `doc_date` date NOT NULL DEFAULT '0000-00-00',
  `currency` char(3) NOT NULL DEFAULT '',
  `amount` double NOT NULL DEFAULT 0,
  `rate` double NOT NULL DEFAULT 1,
  `file_system` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`type`,`trans_no`),
  KEY `tran_date` (`tran_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_journal` ###


### Structure of table `0_kv_bank_trans_settings` ###

DROP TABLE IF EXISTS `0_kv_bank_trans_settings`;

CREATE TABLE `0_kv_bank_trans_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_name` varchar(250) DEFAULT NULL,
  `pay_type` int(11) DEFAULT -1,
  `person_id` text NOT NULL,
  `keyword` text NOT NULL,
  `min_price` int(11) NOT NULL,
  `max_price` int(11) NOT NULL,
  `negative_only` tinyint(4) NOT NULL DEFAULT 0,
  `notes` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_kv_bank_trans_settings` ###


### Structure of table `0_loc_stock` ###

DROP TABLE IF EXISTS `0_loc_stock`;

CREATE TABLE `0_loc_stock` (
  `loc_code` char(5) NOT NULL DEFAULT '',
  `stock_id` char(20) NOT NULL DEFAULT '',
  `reorder_level` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`loc_code`,`stock_id`),
  KEY `stock_id` (`stock_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_loc_stock` ###

INSERT INTO `0_loc_stock` VALUES
('001', 'FG-001', '0'),
('001', 'SER-001', '0'),
('002', 'FG-001', '0'),
('002', 'SER-001', '0'),
('003', 'FG-001', '0'),
('003', 'SER-001', '0'),
('004', 'FG-001', '0'),
('004', 'SER-001', '0'),
('005', 'FG-001', '0'),
('005', 'SER-001', '0'),
('006', 'FG-001', '0'),
('006', 'SER-001', '0'),
('AYNT', 'FG-001', '0'),
('AYNT', 'SER-001', '0'),
('DEF', 'FG-001', '0'),
('DEF', 'SER-001', '0'),
('FAT', 'FG-001', '0'),
('FAT', 'SER-001', '0'),
('FGKAR', 'FG-001', '0'),
('FGKAR', 'SER-001', '0'),
('NAZT', 'FG-001', '0'),
('NAZT', 'SER-001', '0');

### Structure of table `0_locations` ###

DROP TABLE IF EXISTS `0_locations`;

CREATE TABLE `0_locations` (
  `loc_code` varchar(5) NOT NULL DEFAULT '',
  `location_name` varchar(60) NOT NULL DEFAULT '',
  `delivery_address` tinytext NOT NULL,
  `phone` varchar(30) NOT NULL DEFAULT '',
  `phone2` varchar(30) NOT NULL DEFAULT '',
  `fax` varchar(30) NOT NULL DEFAULT '',
  `email` varchar(100) NOT NULL DEFAULT '',
  `contact` varchar(30) NOT NULL DEFAULT '',
  `fixed_asset` tinyint(1) NOT NULL DEFAULT 0,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`loc_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_locations` ###

INSERT INTO `0_locations` VALUES
('001', 'Head Office (FA)', 'Karachi', '', '', '', '', '', '1', '0'),
('AYNT', 'Ayan Traders', 'Ayan Traders', '', '', '', '', '', '0', '0'),
('DEF', 'Wrackler', 'Wrackler', '', '', '', '', '', '0', '0'),
('FAT', 'Fast Tech', 'Fast Tech', '', '', '', '', '', '0', '0'),
('NAZT', 'Naz Traders', 'Naz Traders', '', '', '', '', '', '0', '0');

### Structure of table `0_master_login` ###

DROP TABLE IF EXISTS `0_master_login`;

CREATE TABLE `0_master_login` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(60) NOT NULL,
  `role` int(11) NOT NULL,
  `companies` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_master_login` ###

INSERT INTO `0_master_login` VALUES
('1', 'admin', '2', 'YTo0OntpOjA7aTowO2k6MTtpOjE7aToyO2k6MjtpOjM7aTozO30='),
('2', 'ammar', '6', 'YTo0OntpOjA7aTowO2k6MTtpOjE7aToyO2k6MjtpOjM7aTozO30='),
('3', 'Qaiser', '13', 'YTozOntpOjA7aTowO2k6MTtpOjE7aToyO2k6Mjt9'),
('4', 'Imtiaz', '9', 'YTozOntpOjA7aTowO2k6MTtpOjE7aToyO2k6Mjt9'),
('5', 'Waleed', '5', 'YToxOntpOjA7aTowO30='),
('6', 'Waheed', '9', 'YTozOntpOjA7aTowO2k6MTtpOjE7aToyO2k6Mjt9'),
('7', 'Durreshahwar', '16', 'YToyOntpOjA7aTowO2k6MTtpOjE7fQ=='),
('8', 'Saad', '14', 'YTozOntpOjA7aTowO2k6MTtpOjE7aToyO2k6Mjt9'),
('9', 'Jahangir', '9', 'YTozOntpOjA7aTowO2k6MTtpOjE7aToyO2k6Mjt9'),
('10', 'amir', '2', 'YTo0OntpOjA7aTowO2k6MTtpOjE7aToyO2k6MjtpOjM7aTozO30='),
('11', 'Ammar Ejaz', '15', 'YTozOntpOjA7aTowO2k6MTtpOjE7aToyO2k6Mjt9'),
('12', 'Shahid', '1', 'YToyOntpOjA7aTowO2k6MTtpOjI7fQ=='),
('13', 'Shoaib', '11', 'YTozOntpOjA7aTowO2k6MTtpOjE7aToyO2k6Mjt9'),
('14', 'Imran', '9', 'YTozOntpOjA7aTowO2k6MTtpOjE7aToyO2k6Mjt9'),
('15', 'Amanullah', '1', 'YTozOntpOjA7aTowO2k6MTtpOjE7aToyO2k6Mjt9'),
('16', 'fahad', '2', 'YTo0OntpOjA7aTowO2k6MTtpOjE7aToyO2k6MjtpOjM7aTozO30='),
('17', 'ShahidHO', '18', 'YTozOntpOjA7aTowO2k6MTtpOjE7aToyO2k6Mjt9'),
('18', 'Shahnaz', '14', 'YTozOntpOjA7aTowO2k6MTtpOjE7aToyO2k6Mjt9'),
('19', 'Sana', '23', 'YTozOntpOjA7aTowO2k6MTtpOjE7aToyO2k6Mjt9'),
('20', 'admin1', '2', 'YTo0OntpOjA7aTowO2k6MTtpOjE7aToyO2k6MjtpOjM7aTozO30='),
('21', 'Asif', '2', 'YTo0OntpOjA7aTowO2k6MTtpOjE7aToyO2k6MjtpOjM7aTozO30='),
('22', 'Abdulrafay', '13', 'YTozOntpOjA7aTowO2k6MTtpOjE7aToyO2k6Mjt9'),
('23', 'arif', '4', 'YTowOnt9');

### Structure of table `0_payment_terms` ###

DROP TABLE IF EXISTS `0_payment_terms`;

CREATE TABLE `0_payment_terms` (
  `terms_indicator` int(11) NOT NULL AUTO_INCREMENT,
  `terms` char(80) NOT NULL DEFAULT '',
  `days_before_due` smallint(6) NOT NULL DEFAULT 0,
  `day_in_following_month` smallint(6) NOT NULL DEFAULT 0,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`terms_indicator`),
  UNIQUE KEY `terms` (`terms`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_payment_terms` ###

INSERT INTO `0_payment_terms` VALUES
('1', '15 Credit Days', '15', '0', '0'),
('2', '30 Credit Days', '30', '0', '0'),
('3', '45 Credit Days', '45', '0', '0'),
('4', 'Cash Only', '1', '0', '0'),
('5', 'Advance Payment', '0', '0', '0'),
('6', '60 Credit Days', '60', '0', '0'),
('7', '75 Credit Days', '75', '0', '0'),
('8', '90 Credit Days', '90', '0', '0'),
('9', '7 Credit Days', '7', '0', '0'),
('10', '20 Days Credit', '20', '0', '0');

### Structure of table `0_post_cheque_trans` ###

DROP TABLE IF EXISTS `0_post_cheque_trans`;

CREATE TABLE `0_post_cheque_trans` (
  `trans_no` int(11) NOT NULL AUTO_INCREMENT,
  `type` smallint(6) DEFAULT NULL,
  `date_` date NOT NULL,
  `pay_to` int(11) NOT NULL,
  `person_id` varchar(225) NOT NULL DEFAULT '0',
  `bank_id` int(11) NOT NULL DEFAULT 0,
  `is_cheque_no` int(11) NOT NULL DEFAULT 0,
  `cheque_no` varchar(60) NOT NULL,
  `post_date` date NOT NULL,
  `comments` varchar(500) DEFAULT NULL,
  `dimension_id` int(11) NOT NULL DEFAULT 0,
  `dimension2_id` int(11) NOT NULL DEFAULT 0,
  `charge` varchar(225) DEFAULT NULL,
  `total_amount` varchar(60) DEFAULT NULL,
  `is_posted_status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`trans_no`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_post_cheque_trans` ###

INSERT INTO `0_post_cheque_trans` VALUES
('1', '22', '2023-08-11', '0', '120', '1', '1', '1951', '2023-08-11', NULL, '17', '25', '0', '258925', '1'),
('2', '1', '2023-08-24', '0', 'Chq1968 dt:10-9-23 Rent Statlife May-23 to Sep23', '1', '1', '1968', '2023-09-10', NULL, '0', '0', NULL, '738705', '1'),
('3', '22', '2023-08-28', '0', '90', '1', '1', '1973', '2023-09-01', 'Chq1973 dt:1-9-23 Fine Daily Pvt Ltd ', '21', '29', '0', '2000000', '1'),
('4', '22', '2023-09-27', '0', '170', '1', '1', '2018', '2023-09-27', 'chq2018 dt:27-9-23 to Naseeb Online Services Pvt ltd(rozee.pk)', '17', '25', '0', '86784', '1'),
('5', '22', '2023-09-27', '0', '170', '1', '1', '2018', '2023-09-27', 'chq2018 dt:27-9-23 to Naseeb Online Services Pvt ltd(rozee.pk)', '17', '25', '0', '86784', '1'),
('6', '1', '2023-11-03', '6', '', '1', '1', '2081', '2023-11-10', 'Chq2081 dt:10-11-23 Quality Transport Pakistan PO126', '0', '0', NULL, '353061', '1'),
('7', '22', '2023-11-06', '0', '120', '1', '1', '2102', '2023-11-06', 'Chq2102 dt:7-11-23 M.Asif &amp; Co ', '18', '25', '0', '258925', '1'),
('8', '22', '2023-11-06', '0', '120', '1', '1', '2102', '2023-11-06', 'Chq2102 dt:7-11-23 M.Asif &amp; Co SaleTax Inv-A-041/24', '18', '25', '0', '258925', '1'),
('9', '22', '2023-11-06', '0', '120', '1', '1', '2102', '2023-11-07', 'Chq2102 dt:7-11-23 M.Asif &amp; Co SaleTax Inv-A-041/24', '18', '25', '0', '290000', '1'),
('10', '1', '2023-11-15', '3', '90', '1', '1', '2114', '2023-11-16', '3rdAdvancePayment Chq2114 dt:16-11-23 FineDaily PerformalInvFD08/2023', '0', '0', NULL, '1800000', '1'),
('11', '1', '2023-11-15', '3', '90', '1', '1', '2115', '2023-11-20', '4thAdvancePayment Chq2115 dt:16-11-23 FineDaily PerformalInvFD08/2023', '0', '0', NULL, '2000000', '1'),
('12', '1', '2023-11-28', '3', '90', '1', '1', '2128', '2023-12-01', 'Chq2128 dt:1-12-23 Fine Daily Pvt Ltd', '0', '0', NULL, '2500000', '1'),
('13', '1', '2023-11-28', '3', '90', '1', '1', '2129', '2023-12-10', 'Chq2129 dt:1-12-23 Fine Daily Pvt Ltd', '0', '0', NULL, '2500000', '1'),
('14', '1', '2023-12-13', '3', '49', '1', '1', '2157', '2023-12-20', 'Chq2157 dt:20-12-23 International Petrochem PO385/2023', '0', '0', NULL, '202000', '1');

### Structure of table `0_post_trans_detail` ###

DROP TABLE IF EXISTS `0_post_trans_detail`;

CREATE TABLE `0_post_trans_detail` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` smallint(6) NOT NULL DEFAULT 0,
  `trans_no` int(11) NOT NULL DEFAULT 0,
  `account` varchar(15) NOT NULL,
  `dimension_id` int(11) NOT NULL DEFAULT 0,
  `dimension2_id` int(11) NOT NULL DEFAULT 0,
  `memo_` text NOT NULL,
  `amount` double NOT NULL DEFAULT 0,
  `invocie_type` int(11) NOT NULL DEFAULT 0,
  `invocie_trans_no` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_post_trans_detail` ###

INSERT INTO `0_post_trans_detail` VALUES
('1', '22', '1', '0', '0', '0', 'Supplier Payment', '290000', '20', '34'),
('2', '1', '2', '2010201002', '17', '25', 'Chq1968 dt:10-9-23 Rent Statlife May-23 to Sep23', '738705', '0', '0'),
('3', '22', '3', '0', '0', '0', 'Supplier Payment', '2000000', '18', '129'),
('4', '22', '4', '0', '0', '0', 'Supplier Payment', '90400', '20', '191'),
('5', '22', '5', '0', '0', '0', 'Supplier Payment', '90400', '20', '191'),
('6', '1', '6', '40401011', '22', '25', 'Chq2081 dt:10-11-23 Quality Transport Pakistan PO126', '353061', '0', '0'),
('7', '22', '7', '0', '0', '0', 'Supplier Payment', '290000', '20', '330'),
('8', '22', '8', '0', '0', '0', 'Supplier Payment', '290000', '20', '330'),
('9', '22', '9', '0', '0', '0', 'Supplier Payment', '290000', '20', '330'),
('10', '1', '10', '2010101001', '0', '0', '3rdAdvancePayment Chq2114 dt:16-11-23 FineDaily PerformalInvFD08/2023', '1800000', '0', '0'),
('11', '1', '11', '2010101001', '0', '0', '4thAdvancePayment Chq2115 dt:16-11-23 FineDaily PerformalInvFD08/2023', '2000000', '0', '0'),
('12', '1', '12', '2010101001', '0', '0', 'Chq2128 dt:1-12-23 Fine Daily Pvt Ltd', '2500000', '0', '0'),
('13', '1', '13', '2010101001', '0', '0', 'Chq2129 dt:1-12-23 Fine Daily Pvt Ltd', '2500000', '0', '0'),
('14', '1', '14', '2010101001', '0', '0', 'Chq2157 dt:20-12-23 International Petrochem PO385/2023', '202000', '0', '0');

### Structure of table `0_prices` ###

DROP TABLE IF EXISTS `0_prices`;

CREATE TABLE `0_prices` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `stock_id` varchar(20) NOT NULL DEFAULT '',
  `sales_type_id` int(11) NOT NULL DEFAULT 0,
  `curr_abrev` char(3) NOT NULL DEFAULT '',
  `price` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `price` (`stock_id`,`sales_type_id`,`curr_abrev`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_prices` ###


### Structure of table `0_print_profiles` ###

DROP TABLE IF EXISTS `0_print_profiles`;

CREATE TABLE `0_print_profiles` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `profile` varchar(30) NOT NULL,
  `report` varchar(5) DEFAULT NULL,
  `printer` tinyint(3) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `profile` (`profile`,`report`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_print_profiles` ###

INSERT INTO `0_print_profiles` VALUES
('1', 'Out of office', NULL, '0'),
('2', 'Sales Department', NULL, '0'),
('3', 'Central', NULL, '2'),
('4', 'Sales Department', '104', '2'),
('5', 'Sales Department', '105', '2'),
('6', 'Sales Department', '107', '2'),
('7', 'Sales Department', '109', '2'),
('8', 'Sales Department', '110', '2'),
('9', 'Sales Department', '201', '2');

### Structure of table `0_printers` ###

DROP TABLE IF EXISTS `0_printers`;

CREATE TABLE `0_printers` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(20) NOT NULL,
  `description` varchar(60) NOT NULL,
  `queue` varchar(20) NOT NULL,
  `host` varchar(40) NOT NULL,
  `port` smallint(11) unsigned NOT NULL,
  `timeout` tinyint(3) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_printers` ###

INSERT INTO `0_printers` VALUES
('1', 'QL500', 'Label printer', 'QL500', 'server', '127', '20'),
('2', 'Samsung', 'Main network printer', 'scx4521F', 'server', '515', '5'),
('3', 'Local', 'Local print server at user IP', 'lp', '', '515', '10');

### Structure of table `0_production_planing` ###

DROP TABLE IF EXISTS `0_production_planing`;

CREATE TABLE `0_production_planing` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tran_date` varchar(20) NOT NULL,
  `item` varchar(20) NOT NULL,
  `target_qty` int(11) NOT NULL,
  `order_qty` int(11) NOT NULL,
  `status` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_production_planing` ###

INSERT INTO `0_production_planing` VALUES
('1', '2022-07-26', 'CM-001', '100', '50', '0'),
('2', '2022-07-26', 'FG-009', '120', '60', '1'),
('3', '2022-07-26', 'FG-009', '120', '80', '2'),
('4', '2022-07-26', 'FG-009', '100', '95', '0'),
('5', '2022-08-01', 'FG-008', '100', '80', '0'),
('6', '2023-05-28', 'FG-001', '500', '250', '0');

### Structure of table `0_purch_data` ###

DROP TABLE IF EXISTS `0_purch_data`;

CREATE TABLE `0_purch_data` (
  `supplier_id` int(11) NOT NULL DEFAULT 0,
  `stock_id` char(20) NOT NULL DEFAULT '',
  `price` double NOT NULL DEFAULT 0,
  `suppliers_uom` char(50) NOT NULL DEFAULT '',
  `conversion_factor` double NOT NULL DEFAULT 1,
  `supplier_description` char(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`supplier_id`,`stock_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_purch_data` ###


### Structure of table `0_purch_order_details` ###

DROP TABLE IF EXISTS `0_purch_order_details`;

CREATE TABLE `0_purch_order_details` (
  `po_detail_item` int(11) NOT NULL AUTO_INCREMENT,
  `order_no` int(11) NOT NULL DEFAULT 0,
  `item_code` varchar(20) NOT NULL DEFAULT '',
  `description` tinytext DEFAULT NULL,
  `delivery_date` date NOT NULL DEFAULT '0000-00-00',
  `qty_invoiced` double NOT NULL DEFAULT 0,
  `unit_price` double NOT NULL DEFAULT 0,
  `act_price` double NOT NULL DEFAULT 0,
  `std_cost_unit` double NOT NULL DEFAULT 0,
  `quantity_ordered` double NOT NULL DEFAULT 0,
  `quantity_received` double NOT NULL DEFAULT 0,
  `in_ward_qty` double NOT NULL DEFAULT 0,
  `qc_qty` double NOT NULL DEFAULT 0,
  `out_ward_qty` double NOT NULL DEFAULT 0,
  `dim_line` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`po_detail_item`),
  KEY `order` (`order_no`,`po_detail_item`),
  KEY `itemcode` (`item_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_purch_order_details` ###


### Structure of table `0_purch_orders` ###

DROP TABLE IF EXISTS `0_purch_orders`;

CREATE TABLE `0_purch_orders` (
  `order_no` int(11) NOT NULL AUTO_INCREMENT,
  `supplier_id` int(11) NOT NULL DEFAULT 0,
  `comments` longtext DEFAULT NULL,
  `ord_date` date NOT NULL DEFAULT '0000-00-00',
  `qc_req_date` date NOT NULL DEFAULT '0000-00-00',
  `reference` tinytext NOT NULL,
  `requisition_no` tinytext DEFAULT NULL,
  `into_stock_location` varchar(5) NOT NULL DEFAULT '',
  `delivery_address` tinytext NOT NULL,
  `total` double NOT NULL DEFAULT 0,
  `ex_rate` double NOT NULL DEFAULT 1,
  `prep_amount` double NOT NULL DEFAULT 0,
  `alloc` double NOT NULL DEFAULT 0,
  `tax_group_id` int(11) NOT NULL,
  `tax_included` tinyint(1) NOT NULL DEFAULT 0,
  `req_no` int(11) DEFAULT NULL,
  `is_qc_complete` int(11) NOT NULL DEFAULT 0,
  `is_close` int(11) DEFAULT 0,
  `dimension_id` int(11) NOT NULL DEFAULT 0,
  `dimension2_id` int(11) NOT NULL DEFAULT 0,
  `payment_terms` int(11) NOT NULL DEFAULT 0,
  `file_system` int(11) NOT NULL DEFAULT 0,
  `payterm` longtext DEFAULT NULL,
  `approved` int(11) NOT NULL DEFAULT 0,
  `commission_person` varchar(225) NOT NULL,
  `commission_amt` varchar(225) NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_no`),
  KEY `ord_date` (`ord_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_purch_orders` ###


### Structure of table `0_purch_quotation` ###

DROP TABLE IF EXISTS `0_purch_quotation`;

CREATE TABLE `0_purch_quotation` (
  `order_no` int(11) NOT NULL AUTO_INCREMENT,
  `supplier_id` int(11) NOT NULL DEFAULT 0,
  `comments` longtext DEFAULT NULL,
  `ord_date` date NOT NULL DEFAULT '0000-00-00',
  `reference` tinytext NOT NULL,
  `requisition_no` tinytext DEFAULT NULL,
  `into_stock_location` varchar(5) NOT NULL DEFAULT '',
  `delivery_address` tinytext NOT NULL,
  `total` double NOT NULL DEFAULT 0,
  `prep_amount` double NOT NULL DEFAULT 0,
  `alloc` double NOT NULL DEFAULT 0,
  `tax_group_id` int(11) NOT NULL,
  `tax_included` tinyint(1) NOT NULL DEFAULT 0,
  `req_no` int(11) DEFAULT NULL,
  `is_qc_complete` int(11) NOT NULL DEFAULT 0,
  `is_close` int(11) DEFAULT 0,
  PRIMARY KEY (`order_no`),
  KEY `ord_date` (`ord_date`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_purch_quotation` ###

INSERT INTO `0_purch_quotation` VALUES
('1', '9', 'abc123', '2023-01-25', 'PQ/001/2023', NULL, 'DEF', 'Head Office Karachi', '965.25', '0', '0', '1', '0', '0', '0', '0'),
('2', '69', NULL, '2023-07-05', 'PQ/002/2023', 'open market ', 'DEF', 'Head Office Karachi', '1140', '0', '0', '2', '0', '0', '0', '0'),
('3', '18', NULL, '2023-07-18', 'PQ/003/2023', NULL, 'DEF', 'Head Office Karachi', '160000', '0', '0', '2', '0', '0', '0', '0'),
('4', '12', NULL, '2023-07-18', 'PQ/004/2023', NULL, 'DEF', 'Head Office Karachi', '193050', '0', '0', '1', '0', '0', '0', '0'),
('5', '69', 'Last Rate July : \nMC :\n250/- AC - 235/- HR\nBenzene :\n550/- COC \nMethanol :\nAhmed Impex 218/- ', '2023-08-04', 'PQ/005/2023', NULL, 'DEF', 'Head Office Karachi', '2835603.2', '0', '0', '2', '0', '0', '0', '0'),
('6', '12', 'Last Rate July : \nMC :\n250/- AC - 235/- HR\n', '2023-08-04', 'PQ/006/2023', NULL, 'DEF', 'Head Office Karachi', '1587600', '0', '0', '2', '0', '0', '0', '0'),
('7', '103', 'Last Rate July : \nAhmed Impex 218/- ', '2023-08-04', 'PQ/007/2023', NULL, 'DEF', 'Head Office Karachi', '150400', '0', '0', '2', '0', '0', '0', '0'),
('8', '69', NULL, '2023-09-13', 'PQ/008/2023', NULL, 'DEF', 'Head Office Karachi', '2010', '0', '0', '2', '0', '0', '0', '0');

### Structure of table `0_purch_quotation_details` ###

DROP TABLE IF EXISTS `0_purch_quotation_details`;

CREATE TABLE `0_purch_quotation_details` (
  `po_detail_item` int(11) NOT NULL AUTO_INCREMENT,
  `order_no` int(11) NOT NULL DEFAULT 0,
  `item_code` varchar(20) NOT NULL DEFAULT '',
  `description` tinytext DEFAULT NULL,
  `delivery_date` date NOT NULL DEFAULT '0000-00-00',
  `qty_invoiced` double NOT NULL DEFAULT 0,
  `unit_price` double NOT NULL DEFAULT 0,
  `act_price` double NOT NULL DEFAULT 0,
  `std_cost_unit` double NOT NULL DEFAULT 0,
  `quantity_ordered` double NOT NULL DEFAULT 0,
  `quantity_received` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`po_detail_item`),
  KEY `order` (`order_no`,`po_detail_item`),
  KEY `itemcode` (`item_code`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_purch_quotation_details` ###

INSERT INTO `0_purch_quotation_details` VALUES
('1', '1', 'FG-070', 'Nasa ATF - 20 Ltr', '2023-02-04', '0', '150', '0', '0', '5', '0'),
('2', '1', 'SFG-101', 'ATF-Lubricanta', '2023-02-04', '0', '15', '0', '0', '5', '0'),
('3', '2', 'GEN-010', 'Bleach Bottle', '2023-07-15', '0', '70', '0', '0', '2', '0'),
('4', '2', 'GEN-020', 'Floor Glycrine ', '2023-07-15', '0', '500', '0', '0', '2', '0'),
('5', '3', 'RM-036', 'Carton-Carb Clean - (300ml x 48) Master', '2023-07-28', '0', '160', '0', '0', '1000', '0'),
('6', '4', 'RM-036', 'Carton-Carb Clean - (300ml x 48) Master', '2023-07-28', '0', '165', '0', '0', '1000', '0'),
('7', '5', 'CM-021', 'Methylene chloride - (CMC-300)', '2023-08-14', '0', '245', '0', '0', '6480', '0'),
('8', '5', 'CM-007', 'Benzene - (CBN-200)', '2023-08-14', '0', '590', '0', '0', '1800', '0'),
('9', '5', 'CM-020', 'Methanol - (AMT-100)', '2023-08-14', '0', '290.63', '0', '0', '640', '0'),
('10', '6', 'CM-021', 'Methylene chloride - (CMC-300)', '2023-08-14', '0', '245', '0', '0', '6480', '0'),
('11', '7', 'CM-020', 'Methanol - (AMT-100)', '2023-08-14', '0', '235', '0', '0', '640', '0'),
('12', '8', 'MET-165', 'Cable CAT 6', '2023-09-23', '0', '30', '0', '0', '67', '0');

### Structure of table `0_qc_setup` ###

DROP TABLE IF EXISTS `0_qc_setup`;

CREATE TABLE `0_qc_setup` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type_id` int(11) NOT NULL,
  `name` varchar(100) NOT NULL,
  `qc_type` int(11) NOT NULL,
  `min` int(11) DEFAULT NULL,
  `max` int(11) DEFAULT NULL,
  `options` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=80 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_qc_setup` ###

INSERT INTO `0_qc_setup` VALUES
('6', '1', 'Name', '1', '0', '0', NULL),
('7', '1', 'Qty', '2', '1', '50', NULL),
('8', '1', 'Expiry date', '3', '0', '0', NULL),
('9', '1', 'All correct', '5', '0', '0', NULL),
('10', '1', 'Defact Type', '6', '0', '0', 'all defected , half defected , some defected'),
('11', '1', 'Detals', '4', '0', '0', NULL),
('12', '2', 'Defact Type', '6', '0', '0', 'all defected , half defected , some defected'),
('13', '2', 'Name', '1', '0', '0', NULL),
('14', '2', 'Qty', '2', '1', '50', NULL),
('15', '2', 'Expiry date', '3', '0', '0', NULL),
('16', '2', 'All correct', '5', '0', '0', NULL),
('17', '2', 'Detals', '4', '0', '0', NULL),
('18', '2', 'Defact Type', '6', '0', '0', 'all defected , half defected , some defected'),
('19', '3', 'Name', '1', '0', '0', NULL),
('20', '3', 'Qty', '2', '1', '50', NULL),
('21', '3', 'Expiry date', '3', '0', '0', NULL),
('22', '3', 'All correct', '5', '0', '0', NULL),
('23', '3', 'Detals', '4', '0', '0', NULL),
('24', '2', 'Defact Type', '6', '0', '0', 'all defected , half defected , some defected'),
('25', '4', 'Name', '1', '0', '0', NULL),
('26', '4', 'Qty', '2', '1', '50', NULL),
('27', '4', 'Expiry date', '3', '0', '0', NULL),
('28', '4', 'All correct', '5', '0', '0', NULL),
('29', '4', 'Detals', '4', '0', '0', NULL),
('30', '8', 'Composition', '5', '0', '0', NULL),
('31', '8', 'Color', '5', '0', '0', NULL),
('32', '8', 'Quantity', '2', '0', '100000', NULL),
('34', '10', 'Quantity', '1', '0', '0', NULL),
('35', '9', 'Weight', '2', '1', '100000', NULL),
('36', '9', 'Packaging', '5', '0', '0', NULL),
('37', '8', 'Bottle/Can', '5', '0', '0', NULL),
('38', '8', 'Valve', '5', '0', '0', NULL),
('39', '8', 'Caps', '5', '0', '0', NULL),
('40', '8', 'Sticker', '5', '0', '0', NULL),
('41', '8', 'Packaging', '5', '0', '0', NULL),
('42', '9', 'Chemical ', '5', '0', '0', NULL),
('43', '14', 'Quantity', '5', '0', '0', NULL),
('44', '10', 'Appearence', '1', '0', '0', NULL),
('45', '10', 'Viscosity @ 100 C', '1', '0', '0', NULL),
('46', '10', 'Viscosity @ 40 C', '1', '0', '0', NULL),
('47', '10', 'Viscosity Index', '4', '0', '0', NULL),
('48', '10', 'Density at Room Temeoearture', '4', '0', '0', NULL),
('49', '10', 'Boiling Point', '1', '0', '0', NULL),
('50', '10', 'Color', '1', '0', '0', NULL),
('51', '10', 'Evaporation Rate', '1', '0', '0', NULL),
('52', '15', 'Name', '1', '0', '0', NULL),
('53', '15', 'Quantity', '1', '0', '0', NULL),
('54', '15', 'Appearence', '1', '0', '0', NULL),
('55', '15', 'Color', '1', '0', '0', NULL),
('56', '15', 'Viscosity @ 100 C', '1', '0', '0', NULL),
('57', '15', 'Viscosity @ 40 C', '1', '0', '0', NULL),
('58', '15', 'Viscosity Index', '1', '0', '0', NULL),
('59', '15', 'Specific Gravity', '1', '0', '0', NULL),
('60', '15', 'Freezing Point', '1', '0', '0', NULL),
('61', '10', 'Freezing Point', '1', '0', '0', NULL),
('62', '15', 'PH Value', '1', '0', '0', NULL),
('63', '15', 'Moisture', '6', '0', '0', 'Yes,No'),
('64', '15', 'Density at Room Temeoearture', '1', '0', '0', NULL),
('65', '15', 'Boiling Point', '1', '0', '0', NULL),
('66', '15', 'Pour Point', '1', '0', '0', NULL),
('67', '15', 'Evaporation Rate', '1', '0', '0', NULL),
('68', '11', 'Name', '1', '0', '0', NULL),
('69', '12', 'Name', '1', '0', '0', NULL),
('70', '12', 'Quantity', '1', '0', '0', NULL),
('71', '12', 'Frangnance', '1', '0', '0', NULL),
('72', '11', 'Quantity', '1', '0', '0', NULL),
('73', '11', 'Color', '1', '0', '0', NULL),
('74', '13', 'Name', '1', '0', '0', NULL),
('75', '13', 'Quantity', '1', '0', '0', NULL),
('76', '13', 'Appearence', '1', '0', '0', NULL),
('77', '13', 'Temeprature ', '6', '0', '0', 'Melt, Non Melt'),
('78', '10', 'PH Value', '1', '0', '0', NULL),
('79', '10', 'Expiry Date', '3', '0', '0', NULL);

### Structure of table `0_qc_trans` ###

DROP TABLE IF EXISTS `0_qc_trans`;

CREATE TABLE `0_qc_trans` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `trans_no` int(11) NOT NULL COMMENT 'QC trans No',
  `po_order_no` int(11) NOT NULL,
  `type` int(11) NOT NULL,
  `field_id` int(11) NOT NULL,
  `label_name` varchar(200) DEFAULT NULL,
  `value` text DEFAULT NULL,
  `date_time` datetime NOT NULL DEFAULT current_timestamp(),
  `qc_status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_qc_trans` ###


### Structure of table `0_quick_entries` ###

DROP TABLE IF EXISTS `0_quick_entries`;

CREATE TABLE `0_quick_entries` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `type` tinyint(1) NOT NULL DEFAULT 0,
  `description` varchar(60) NOT NULL,
  `usage` varchar(120) DEFAULT NULL,
  `base_amount` double NOT NULL DEFAULT 0,
  `base_desc` varchar(60) DEFAULT NULL,
  `bal_type` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `description` (`description`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_quick_entries` ###


### Structure of table `0_quick_entry_lines` ###

DROP TABLE IF EXISTS `0_quick_entry_lines`;

CREATE TABLE `0_quick_entry_lines` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `qid` smallint(6) unsigned NOT NULL,
  `amount` double DEFAULT 0,
  `memo` tinytext NOT NULL,
  `action` varchar(2) NOT NULL,
  `dest_id` varchar(15) NOT NULL DEFAULT '',
  `dimension_id` smallint(6) unsigned DEFAULT NULL,
  `dimension2_id` smallint(6) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `qid` (`qid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_quick_entry_lines` ###


### Structure of table `0_recurrent_invoices` ###

DROP TABLE IF EXISTS `0_recurrent_invoices`;

CREATE TABLE `0_recurrent_invoices` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(60) NOT NULL DEFAULT '',
  `order_no` int(11) unsigned NOT NULL,
  `debtor_no` int(11) unsigned DEFAULT NULL,
  `group_no` smallint(6) unsigned DEFAULT NULL,
  `days` int(11) NOT NULL DEFAULT 0,
  `monthly` int(11) NOT NULL DEFAULT 0,
  `begin` date NOT NULL DEFAULT '0000-00-00',
  `end` date NOT NULL DEFAULT '0000-00-00',
  `last_sent` date NOT NULL DEFAULT '0000-00-00',
  PRIMARY KEY (`id`),
  UNIQUE KEY `description` (`description`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_recurrent_invoices` ###


### Structure of table `0_reflines` ###

DROP TABLE IF EXISTS `0_reflines`;

CREATE TABLE `0_reflines` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `trans_type` int(11) NOT NULL,
  `prefix` char(5) NOT NULL DEFAULT '',
  `pattern` varchar(35) NOT NULL DEFAULT '1',
  `description` varchar(60) NOT NULL DEFAULT '',
  `default` tinyint(1) NOT NULL DEFAULT 0,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `prefix` (`trans_type`,`prefix`)
) ENGINE=InnoDB AUTO_INCREMENT=33 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_reflines` ###

INSERT INTO `0_reflines` VALUES
('1', '0', '', 'JE/{001}/{YYYY}', '', '1', '0'),
('2', '1', '', 'BP/{001}/{YYYY}', '', '1', '0'),
('3', '2', '', 'BD/{001}/{YYYY}', '', '1', '0'),
('4', '4', '', 'BT/{001}/{YYYY}', '', '1', '0'),
('5', '10', '', 'SI/{001}/{YYYY}', '', '1', '0'),
('6', '11', '', 'CN/{001}/{YYYY}', '', '1', '0'),
('7', '12', '', 'CP/{001}/{YYYY}', '', '1', '0'),
('8', '13', '', 'DN/{001}/{YYYY}', '', '1', '0'),
('9', '16', '', 'LT/{001}/{YYYY}', '', '1', '0'),
('10', '17', '', 'IA/{001}/{YYYY}', '', '1', '0'),
('11', '18', '', 'PO/{001}/{YYYY}', '', '1', '0'),
('12', '20', '', 'SPI/{001}/{YYYY}', '', '1', '0'),
('13', '21', '', 'SC/{001}/{YYYY}', '', '1', '0'),
('14', '22', '', 'SP/{001}/{YYYY}', '', '1', '0'),
('15', '25', '', 'GRN/{001}/{YYYY}', '', '1', '0'),
('16', '26', '', 'WO/{001}/{YYYY}', '', '1', '0'),
('17', '28', '', 'WOIS/{001}/{YYYY}', '', '1', '0'),
('18', '29', '', 'WORC/{001}/{YYYY}', '', '1', '0'),
('19', '30', '', 'SO/{001}/{YYYY}', '', '1', '0'),
('20', '32', '', 'SQ/{001}/{YYYY}', '', '1', '0'),
('21', '35', '', 'CUP/{001}/{YYYY}', '', '1', '0'),
('22', '40', '', 'CC/{001}/{YYYY}', '', '1', '0'),
('23', '43', '', 'REQ/{001}/{YYYY}', '', '1', '0'),
('24', '111', '', '{00001}', '', '1', '0'),
('25', '37', '', 'IC/{001}/{YYYY}', '', '1', '0'),
('26', '46', '', 'PQ/{001}/{YYYY}', '', '1', '0'),
('27', '49', '', '{001}/{YYYY}', '', '1', '0'),
('28', '50', '', 'V-{001}', '', '1', '0'),
('29', '51', '', 'CN-{001}', '', '1', '0'),
('30', '52', '', '{001}/{WOT}/{YYYY}', '', '1', '0'),
('31', '38', '', '{001}/{YYYY}', '', '1', '0'),
('32', '33', '', 'GP/{001}/{YYYY}', '', '1', '0');

### Structure of table `0_refs` ###

DROP TABLE IF EXISTS `0_refs`;

CREATE TABLE `0_refs` (
  `id` int(11) NOT NULL DEFAULT 0,
  `type` int(11) NOT NULL DEFAULT 0,
  `reference` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`,`type`),
  KEY `Type_and_Reference` (`type`,`reference`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_refs` ###


### Structure of table `0_req_order_details` ###

DROP TABLE IF EXISTS `0_req_order_details`;

CREATE TABLE `0_req_order_details` (
  `po_detail_item` int(11) NOT NULL AUTO_INCREMENT,
  `order_no` int(11) NOT NULL DEFAULT 0,
  `item_code` varchar(20) NOT NULL DEFAULT '',
  `description` tinytext DEFAULT NULL,
  `unit_code` varchar(20) NOT NULL DEFAULT '0',
  `delivery_date` date NOT NULL DEFAULT '0000-00-00',
  `qty_invoiced` double NOT NULL DEFAULT 0,
  `unit_price` double NOT NULL DEFAULT 0,
  `act_price` double NOT NULL DEFAULT 0,
  `std_cost_unit` double NOT NULL DEFAULT 0,
  `quantity_ordered` double NOT NULL DEFAULT 0,
  `quantity_received` double NOT NULL DEFAULT 0,
  `qty_delivered` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`po_detail_item`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_req_order_details` ###


### Structure of table `0_req_orders` ###

DROP TABLE IF EXISTS `0_req_orders`;

CREATE TABLE `0_req_orders` (
  `order_no` int(11) NOT NULL AUTO_INCREMENT,
  `supplier_id` int(11) NOT NULL DEFAULT 0,
  `comments` tinytext DEFAULT NULL,
  `ord_date` date NOT NULL DEFAULT '0000-00-00',
  `reference` tinytext NOT NULL,
  `requisition_no` tinytext DEFAULT NULL,
  `into_stock_location` varchar(5) DEFAULT NULL COMMENT 'To Location',
  `delivery_address` tinytext NOT NULL,
  `total` double NOT NULL DEFAULT 0,
  `prep_amount` double NOT NULL DEFAULT 0,
  `alloc` double NOT NULL DEFAULT 0,
  `tax_included` tinyint(1) NOT NULL DEFAULT 0,
  `lot_no` varchar(20) DEFAULT NULL,
  `approved` int(11) DEFAULT 0,
  `is_complete` int(11) NOT NULL DEFAULT 0,
  `is_closed` int(11) NOT NULL DEFAULT 0,
  `request_location` varchar(15) DEFAULT NULL COMMENT 'From Location',
  `is_store_issue` int(11) NOT NULL DEFAULT 0,
  `is_purchase_request` int(11) NOT NULL DEFAULT 0,
  `is_purch_req_no` int(11) NOT NULL DEFAULT 0 COMMENT 'Requsition To send Purch Req to save Prv req No',
  `wo_order` int(11) NOT NULL DEFAULT 0,
  `gl_entry_no` int(11) NOT NULL DEFAULT 0 COMMENT 'Gl For Cunsuming Itemsn',
  PRIMARY KEY (`order_no`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_req_orders` ###


### Structure of table `0_requisition_details` ###

DROP TABLE IF EXISTS `0_requisition_details`;

CREATE TABLE `0_requisition_details` (
  `requisition_detail_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `requisition_id` int(11) DEFAULT NULL,
  `item_code` varchar(20) DEFAULT NULL,
  `supplier_id` int(11) DEFAULT NULL,
  `lpo_id` int(11) DEFAULT 0,
  `order_quantity` int(11) NOT NULL DEFAULT 0,
  `estimate_price` double NOT NULL DEFAULT 0,
  `quantity` int(11) NOT NULL DEFAULT 0,
  `price` double NOT NULL DEFAULT 0,
  `purpose` varchar(320) DEFAULT NULL,
  PRIMARY KEY (`requisition_detail_id`),
  KEY `0_requisition_details_requisition_id` (`requisition_id`),
  KEY `0_requisition_details_item_code` (`item_code`),
  KEY `0_requisition_details_supplier_id` (`supplier_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_requisition_details` ###


### Structure of table `0_requisitions` ###

DROP TABLE IF EXISTS `0_requisitions`;

CREATE TABLE `0_requisitions` (
  `requisition_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `point_of_use` varchar(50) DEFAULT NULL,
  `narrative` varchar(240) DEFAULT NULL,
  `application_date` timestamp NOT NULL DEFAULT current_timestamp(),
  `completed` tinyint(4) NOT NULL DEFAULT 0,
  `processed` tinyint(4) NOT NULL DEFAULT 0,
  `inactive` tinyint(4) NOT NULL DEFAULT 0,
  `details` text DEFAULT NULL,
  PRIMARY KEY (`requisition_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_requisitions` ###


### Structure of table `0_sales_order_details` ###

DROP TABLE IF EXISTS `0_sales_order_details`;

CREATE TABLE `0_sales_order_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `order_no` int(11) NOT NULL DEFAULT 0,
  `trans_type` smallint(6) NOT NULL DEFAULT 30,
  `stk_code` varchar(20) NOT NULL DEFAULT '',
  `description` tinytext DEFAULT NULL,
  `qty_sent` double NOT NULL DEFAULT 0,
  `unit_price` double NOT NULL DEFAULT 0,
  `quantity` double NOT NULL DEFAULT 0,
  `invoiced` double NOT NULL DEFAULT 0,
  `discount_percent` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `sorder` (`trans_type`,`order_no`),
  KEY `stkcode` (`stk_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_sales_order_details` ###


### Structure of table `0_sales_orders` ###

DROP TABLE IF EXISTS `0_sales_orders`;

CREATE TABLE `0_sales_orders` (
  `order_no` int(11) NOT NULL,
  `trans_type` smallint(6) NOT NULL DEFAULT 30,
  `version` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `type` tinyint(1) NOT NULL DEFAULT 0,
  `debtor_no` int(11) NOT NULL DEFAULT 0,
  `branch_code` int(11) NOT NULL DEFAULT 0,
  `reference` varchar(100) NOT NULL DEFAULT '',
  `customer_ref` longtext NOT NULL,
  `comments` longtext DEFAULT NULL,
  `ord_date` date NOT NULL DEFAULT '0000-00-00',
  `order_type` int(11) NOT NULL DEFAULT 0,
  `ship_via` int(11) NOT NULL DEFAULT 0,
  `delivery_address` tinytext NOT NULL,
  `contact_phone` varchar(30) DEFAULT NULL,
  `contact_email` varchar(100) DEFAULT NULL,
  `deliver_to` tinytext NOT NULL,
  `freight_cost` double NOT NULL DEFAULT 0,
  `from_stk_loc` varchar(5) NOT NULL DEFAULT '',
  `delivery_date` date NOT NULL DEFAULT '0000-00-00',
  `payment_terms` int(11) DEFAULT NULL,
  `sales_person` int(11) NOT NULL DEFAULT 0,
  `total` double NOT NULL DEFAULT 0,
  `prep_amount` double NOT NULL DEFAULT 0,
  `alloc` double NOT NULL DEFAULT 0,
  `dimension_id` int(11) NOT NULL DEFAULT 0,
  `dimension2_id` int(11) NOT NULL DEFAULT 0,
  `file_system` int(11) NOT NULL DEFAULT 0,
  `approved` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`trans_type`,`order_no`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_sales_orders` ###


### Structure of table `0_sales_pos` ###

DROP TABLE IF EXISTS `0_sales_pos`;

CREATE TABLE `0_sales_pos` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `pos_name` varchar(30) NOT NULL,
  `cash_sale` tinyint(1) NOT NULL,
  `credit_sale` tinyint(1) NOT NULL,
  `pos_location` varchar(5) NOT NULL,
  `pos_account` smallint(6) unsigned NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `pos_name` (`pos_name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_sales_pos` ###

INSERT INTO `0_sales_pos` VALUES
('1', 'Default', '1', '1', 'DEF', '2', '0');

### Structure of table `0_sales_types` ###

DROP TABLE IF EXISTS `0_sales_types`;

CREATE TABLE `0_sales_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sales_type` char(50) NOT NULL DEFAULT '',
  `tax_included` int(1) NOT NULL DEFAULT 0,
  `factor` double NOT NULL DEFAULT 1,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `sales_type` (`sales_type`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_sales_types` ###

INSERT INTO `0_sales_types` VALUES
('3', 'Wholesale', '0', '1', '0'),
('4', 'Retail', '0', '1', '0');

### Structure of table `0_salesman` ###

DROP TABLE IF EXISTS `0_salesman`;

CREATE TABLE `0_salesman` (
  `salesman_code` int(11) NOT NULL AUTO_INCREMENT,
  `salesman_name` char(60) NOT NULL DEFAULT '',
  `salesman_phone` char(30) NOT NULL DEFAULT '',
  `salesman_fax` char(30) NOT NULL DEFAULT '',
  `salesman_email` varchar(100) NOT NULL DEFAULT '',
  `provision` double NOT NULL DEFAULT 0,
  `break_pt` double NOT NULL DEFAULT 0,
  `provision2` double NOT NULL DEFAULT 0,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`salesman_code`),
  UNIQUE KEY `salesman_name` (`salesman_name`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_salesman` ###

INSERT INTO `0_salesman` VALUES
('3', 'WAQAS', '', '', '', '0', '0', '0', '0'),
('4', 'CEO', '', '', '', '0', '0', '0', '0');

### Structure of table `0_security_roles` ###

DROP TABLE IF EXISTS `0_security_roles`;

CREATE TABLE `0_security_roles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `role` varchar(30) NOT NULL,
  `description` varchar(50) DEFAULT NULL,
  `sections` text DEFAULT NULL,
  `areas` text DEFAULT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `role` (`role`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_security_roles` ###

INSERT INTO `0_security_roles` VALUES
('1', 'Inquiries', 'Inquiries', '768;2816;3072;3328;5632;5888;8192;8448;10752;11008;13312;15872;16128', '257;258;259;260;513;514;515;516;517;518;519;520;521;522;523;524;525;773;774;2822;3073;3075;3076;3077;3329;3330;3331;3332;3333;3334;3335;5377;5633;5640;5889;5890;5891;7937;7938;7939;7940;8193;8194;8450;8451;10497;10753;11009;11010;11012;13313;13315;15617;15618;15619;15620;15621;15622;15623;15624;15625;15626;15873;15882;16129;16130;16131;16132;775', '0'),
('2', 'System Administrator', 'System Administrator', '256;512;768;2816;3072;3328;5376;5632;5888;7936;8192;8448;9216;9472;9728;10496;10752;11008;13056;13312;15616;15872;16128;18176;18432;18688;20736;353280;418816', '257;513;514;515;516;517;518;519;520;521;522;523;524;525;526;769;770;771;772;773;774;775;776;778;2817;2818;2819;2820;2821;2822;2823;3073;3074;3082;3075;3076;3077;3078;3079;3080;3081;3329;3330;3331;3332;3333;3334;3335;5377;5633;5646;5647;5648;5649;5634;5635;5636;5637;5641;5638;5639;5640;5642;5643;5650;5889;5890;5891;5892;5908;7937;7938;7939;7940;8193;8194;8195;8196;8197;8200;8198;8199;8449;8450;8451;9217;9218;9220;9473;9474;9475;9476;9729;10497;10753;10754;10755;10756;10757;11009;11010;11011;11012;13057;13313;13314;13315;15617;15618;15619;15620;15621;15622;15623;15624;15628;15625;15626;15627;15630;15629;15632;15873;15874;15875;15876;15877;15878;15879;15880;15883;15881;15882;15884;15885;16129;16130;16131;16132;18177;18434;18689;18690;18691;18692;18693;18694;18695;18696;18697;18698;18699;18700;18701;18702;18703;18704;18705;18706;18707;18708;18709;18710;18711;18712;18713;18714;18715;18716;18717;18718;18719;18720;18721;18722;18723;18724;18725;18726;18727;18728;18729;18730;18731;18732;18733;18734;18735;18736;18737;18738;18739;18740;18741;18742;18743;18744;18745;18746;18747;18748;18749;18750;18751;18752;18753;18754;18755;18756;18757;18758;18759;18760;20737;20738;20739;20740;20741;20742;20743;20744;20745;20746;20747;20748;20749;20750;20751;20752;20753;20754;20755;20756;20757;20758;20759;20760;20761;20762;20763;20764;20765;20766;20767;20769;353380;418916;418917', '0'),
('3', 'Salesman', 'Salesman', '768;3072;3328;5632;8192;15872', '773;774;775;3073;3082;3075;3081;3329;3330;3332;3334;3335;5633;5644;8194;8196;8199;15873', '0'),
('4', 'Stock Manager', 'Stock Manager', '768;5632;5888;7936;8192;8448;15616;18176;18432;18688;20736', '774;776;5633;5647;5648;5649;5636;5641;5638;5642;5643;5644;5892;7937;8193;8194;8196;8200;8199;8449;8450;8451;15629;18177;18434;18713;18716;18717;18733;18735;18738;20747;20748;20749;2818;2822;3073;3076;3077;3329;3330;3331;3332;3333;3334;3335;10753;11009;11010;11012;13313;13315;15882;16129;16130;16131;16132', '0'),
('5', 'Production Manager', 'Production Manager', '768;5632;5888;7936;8192;10496;10752;11008;15616;20736', '774;776;5642;5643;5644;5889;5892;7937;8193;8194;8196;8200;8199;10497;10753;10754;10755;10756;10757;11009;11010;11011;15629;20746;20748;20751;3329;3330;3331;3332;3333;3334;3335;8450;8451;13313;13315;15876;15877;15880;15882;16129;16130;16131;16132', '0'),
('6', 'Purchase Officer', 'Purchase Officer', '256;768;3328;5632;5888;7936;8192;8448;9216;9472;9728;18688;20736;287744', '773;774;776;3329;5633;5646;5647;5649;5634;5652;5635;5636;5637;5638;5643;5644;5645;5889;5890;5891;5892;7937;7939;7940;8449;8450;8451;9217;9473;18703;18704;18705;18707;18708;18709;18711;18713;18715;18716;18717;18720;18730;18731;18733;18734;18735;18736;18737;20739;20741;20748;20749;20750;20765;287844;287845;2821;2822;2823;3073;3074;3076;3077;3078;3079;3080;3081;5377;11009;11010;11012;13313;13315;15617;15619;15620;15621;15624;15876;15877;15880;15882;16129;16130;16131;16132', '0'),
('7', 'AR Officer', 'AR Officer', '512;768;2816;3072;3328;5632;5888;8192;8448;10752;11008;13312;15616;15872;16128', '521;523;524;771;773;774;2818;2819;2820;2821;2822;2823;3073;3073;3074;3075;3076;3077;3078;3079;3080;3081;3081;3329;3330;3330;3330;3331;3331;3332;3333;3334;3335;5633;5633;5634;5637;5638;5639;5640;5640;5889;5890;5891;8193;8194;8194;8196;8197;8450;8451;10753;10755;11009;11010;11012;13313;13315;15617;15619;15620;15621;15624;15624;15873;15876;15877;15878;15880;15882;16129;16130;16131;16132;775', '0'),
('8', 'AP Officer', 'AP Officer', '512;768;2816;3072;3328;5376;5632;5888;8192;8448;10752;11008;13312;15616;15872;16128', '257;258;259;260;521;523;524;769;770;771;772;773;774;2818;2819;2820;2821;2822;2823;3073;3074;3082;3076;3077;3078;3079;3080;3081;3329;3330;3331;3332;3333;3334;3335;5377;5633;5635;5640;5889;5890;5891;7937;7938;7939;7940;8193;8194;8196;8197;8449;8450;8451;10497;10753;10755;11009;11010;11012;13057;13313;13315;15617;15619;15620;15621;15624;15876;15877;15880;15882;16129;16130;16131;16132;775', '0'),
('9', 'Accountant', 'New Accountant', '512;768;2816;3072;3328;5376;5632;5888;7936;8192;8448;10752;11008;13312;15616;15872;16128;18688;20736', '521;523;524;771;772;773;774;775;776;2818;2819;2820;2821;2822;2823;3073;3074;3075;3076;3077;3078;3079;3080;3081;3329;3330;3331;3332;3333;3334;3335;5377;5633;5646;5647;5649;5634;5635;5636;5637;5638;5639;5640;5643;5889;5890;5891;7937;8193;8194;8196;8197;8449;8450;8451;10753;10755;11009;11010;11012;13313;13315;15617;15618;15619;15620;15621;15624;15629;15873;15874;15876;15877;15878;15880;15883;15882;16129;16130;16131;16132;18689;18690;18691;18692;18693;18694;18697;18698;18699;18703;18704;18705;18706;18707;18708;18711;18714;18715;18716;18717;18718;18719;18720;18723;18724;18725;18726;18727;18728;18729;18730;18731;18736;18737;18746;18748;18749;18750;18751;18752;18753;18754;18755;18756;18757;20745;20748;20749;20750;20760;257;258;259;260;10497', '0'),
('10', 'Sub Admin', 'Sub Admin', '512;768;2816;3072;3328;5376;5632;5888;8192;8448;10752;11008;13312;15616;15872;16128', '257;258;259;260;521;523;524;771;772;773;774;2818;2819;2820;2821;2822;2823;3073;3074;3082;3075;3076;3077;3078;3079;3080;3081;3329;3330;3331;3332;3333;3334;3335;5377;5633;5634;5635;5637;5638;5639;5640;5889;5890;5891;7937;7938;7939;7940;8193;8194;8196;8197;8449;8450;8451;10497;10753;10755;11009;11010;11012;13057;13313;13315;15617;15619;15620;15621;15624;15873;15874;15876;15877;15878;15879;15880;15882;16129;16130;16131;16132;775', '0'),
('11', 'Supply Chain Manager', 'Supply Chain Manager', '768;2816;3072;3328;5376;5632;5888;7936;8192;8448;10752;11008;15872;18688;20736;287744', '774;2817;2818;2819;2820;2821;2822;2823;3073;3074;3082;3075;3076;3077;3078;3079;3080;3081;3329;3330;3331;3332;3333;3334;3335;5377;5633;5646;5647;5648;5649;5634;5635;5636;5637;5641;5638;5639;5640;5642;5643;5644;5645;5650;5889;5890;5891;7937;7938;7939;7940;8193;8194;8195;8196;8197;8198;8199;8449;8450;8451;10753;11009;11010;11011;11012;15873;18689;18690;18691;18692;18693;18694;18695;18696;18697;18698;18699;18700;18701;18702;18703;18704;18705;18706;18707;18708;18709;18710;18711;18712;18713;18714;18715;18716;18717;18718;18719;18720;18721;18722;18723;18724;18725;18726;18727;18728;18729;18730;18731;18732;18733;18734;18735;18736;18737;18738;18739;18740;18741;18742;18743;18744;18745;18746;20739;20741;20749;20750;20751;20756;20757;20765;287844;287845;15617;15618;15619;15620;15621;15622;15623;15624;15628;15625;15626;15627;15630;16129;16130;16131;16132', '0'),
('12', 'ERP', 'ERP', '2816;3072;3328;5376;5632;5888;7936;8192;8448;9216;9472;9728;10496;10752;11008;13056;13312;15616;15872;16128;287744', '2817;2818;2819;2820;2821;2822;2823;3073;3074;3082;3075;3076;3077;3078;3079;3080;3081;3329;3330;3331;3332;3333;3334;3335;5377;5633;5634;5635;5636;5637;5641;5638;5639;5640;5889;5890;5891;7937;7938;7939;7940;8193;8194;8195;8196;8197;8449;8450;8451;9217;9218;9220;9473;9474;9475;9476;9729;10497;10753;10754;10755;10756;10757;11009;11010;11011;11012;13057;13313;13314;13315;15617;15618;15619;15620;15621;15622;15623;15624;15628;15625;15626;15627;15630;15873;15874;15875;15876;15877;15878;15879;15880;15883;15881;15882;15884;16129;16130;16131;16132;287844;287845', '0'),
('13', 'Finish To Deliver', 'Finish To Deliver', '768;3072;3328;5632;5888;7936;8192;8448;15616;15872;16128;18176;18432;18688;20736', '771;774;776;3073;3076;3077;3078;5646;5647;5649;5635;5636;5637;5638;5643;5644;5892;7937;8193;8194;8196;8199;8449;8450;8451;15873;15874;15876;16131;18177;18434;18697;18698;18699;18701;18713;18716;18717;18719;18733;18735;18738;18748;18758;20743;20744;20745;20746;20747;20748;20749', '0'),
('14', 'Asst Sales Manager', 'Asst Sales Manager', '768;2816;3072;3328;5632;5888;7936;8192;8448;18688;20736', '771;774;778;3073;3082;3075;3083;3076;3079;3329;3330;3331;3332;3333;3334;3335;5648;5644;5892;8193;8194;8196;8199;8450;8451;18689;18690;18691;18692;18693;18694;18695;18696;18697;18698;18699;18701;18702;18717;18722;18723;18724;18725;18726;18727;18728;18733;20743;20744;20745;20746', '0'),
('15', 'Branch Manager ', 'Branch Manager ', '768;3072;3328;5632;5888;7936;8192;8448;15616;15872;16128;18688;20736', '771;772;774;776;778;3073;3074;3082;3075;3076;3077;3078;3079;3080;3081;3329;3330;3332;3333;3334;3335;5647;5649;5635;5636;5637;5643;5644;5892;7937;8193;8194;8196;8200;8199;8450;8451;15629;15873;15874;15876;15877;15878;16129;16131;16132;18689;18690;18691;18692;18693;18694;18697;18698;18699;18701;18702;18717;18723;18724;18725;18726;18727;18728;18733;18738;18748;18758;20743;20744;20745;20747;20748;20749', '0'),
('16', 'Admin  &amp; HR', 'Admin &amp; HR ', '768;3072;3328;5632;5888;7936;8192;8448;15872;16128;18176;18432;18688;20736', '774;776;778;3073;3082;3075;3076;3077;3078;3079;3329;3330;3331;3332;3333;3334;3335;5633;5646;5647;5648;5649;5635;5636;5637;5643;5644;5892;7937;8193;8194;8196;8199;8450;15873;15874;15876;15877;15883;16132;18177;18434;18689;18697;18698;18699;18701;18702;18717;18722;18723;18724;18725;18726;18727;18733;20743;20745;20746;20747;20748;20749;20750', '0'),
('17', 'Maintenance', 'Maintenance', '768;5632;7936;8192;8448;18176;20736', '774;5633;5647;5648;5649;5636;5642;5643;5644;7937;8193;8194;8196;8199;8450;18177;20746;20747;20748;20749', '0'),
('18', 'Cashier', 'Cash Handling', '768;3072;5632;5888;15616;15872;16128;18688', '774;776;3073;3075;3080;5633;5646;5644;5889;5890;5892;15873;15874;15876;15877;15878;15880;16129;16131;16132;18689;18703;18748;18751', '0'),
('22', 'QC &amp; Lab Officer', 'QC &amp; Lab Officer', '768;5632;7936;8192;8448;10496;20736', '774;776;5647;5642;5643;5644;7937;8193;8194;8196;8200;8199;8450;10497;20746;20748', '0'),
('23', 'Marketing Manager', 'Marketing Manager', '768;2816;3072;3328;5376;5632;5888;7936;8192;8448;9216;9472;9728;15872;16128;18176;18432;20736;287744', '774;2817;2818;2819;2820;2821;2822;2823;3073;3074;3082;3075;3076;3077;3078;3079;3080;3081;3329;3330;3331;3332;3333;3334;3335;5377;5633;5646;5647;5648;5649;5634;5635;5636;5637;5641;5638;5639;5640;5642;5643;5644;5645;5650;5889;5890;5891;5892;7937;7938;7939;7940;8193;8194;8195;8196;8197;8198;8199;8449;8450;9217;9218;9220;9473;9474;9475;9476;9729;15873;15874;15875;15876;15877;15878;15879;15880;15883;15881;16129;16130;16131;16132;18177;18434;20737;20738;20739;20740;20741;20742;20743;20744;20745;20746;20747;20748;20749;20750;20751;20752;20753;20754;20755;20756;20757;20758;20759;20760;20761;20762;20763;20764;20765;20766;20767;20769;20770;20771;20772;287844;10497;10753;10754;10755;10756;10757', '0'),
('24', 'Import Officer', 'Import Officer', '256;512;768;3328;5632;5888;7936;8192;8448;9216;9472;9728;18688;20736;287744', '770;773;774;776;3329;5633;5646;5647;5649;5634;5635;5636;5637;5638;5643;5644;5645;5889;5890;5891;5892;7937;7939;7940;8449;8450;8451;9217;9473;18716;18717;18720;18733;18734;18735;18736;18737;20739;20741;20748;20749;20750;20765;287844;287845;2821;2822;2823;3073;3074;3076;3077;3078;3079;3080;3081;5377;11009;11010;11012;13313;13315;15617;15619;15620;15621;15624;15876;15877;15880;15882;16129;16130;16131;16132', '0');

### Structure of table `0_shippers` ###

DROP TABLE IF EXISTS `0_shippers`;

CREATE TABLE `0_shippers` (
  `shipper_id` int(11) NOT NULL AUTO_INCREMENT,
  `shipper_name` varchar(60) NOT NULL DEFAULT '',
  `phone` varchar(30) NOT NULL DEFAULT '',
  `phone2` varchar(30) NOT NULL DEFAULT '',
  `contact` tinytext NOT NULL,
  `address` tinytext NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`shipper_id`),
  UNIQUE KEY `name` (`shipper_name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_shippers` ###

INSERT INTO `0_shippers` VALUES
('1', 'Default', '', '', '', '', '0');

### Structure of table `0_sql_trail` ###

DROP TABLE IF EXISTS `0_sql_trail`;

CREATE TABLE `0_sql_trail` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `sql` text NOT NULL,
  `result` tinyint(1) NOT NULL,
  `msg` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_sql_trail` ###


### Structure of table `0_stock_category` ###

DROP TABLE IF EXISTS `0_stock_category`;

CREATE TABLE `0_stock_category` (
  `category_id` int(11) NOT NULL AUTO_INCREMENT,
  `description` varchar(60) NOT NULL DEFAULT '',
  `cat_abr` varchar(10) NOT NULL,
  `dflt_tax_type` int(11) NOT NULL DEFAULT 1,
  `dflt_units` varchar(20) NOT NULL DEFAULT 'each',
  `dflt_mb_flag` char(1) NOT NULL DEFAULT 'B',
  `dflt_sales_act` varchar(15) NOT NULL DEFAULT '',
  `dflt_cogs_act` varchar(15) NOT NULL DEFAULT '',
  `dflt_inventory_act` varchar(15) NOT NULL DEFAULT '',
  `dflt_adjustment_act` varchar(15) NOT NULL DEFAULT '',
  `dflt_wip_act` varchar(15) NOT NULL DEFAULT '',
  `dflt_dim1` int(11) DEFAULT NULL,
  `dflt_dim2` int(11) DEFAULT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  `dflt_no_sale` tinyint(1) NOT NULL DEFAULT 0,
  `dflt_no_purchase` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`category_id`),
  UNIQUE KEY `description` (`description`)
) ENGINE=InnoDB AUTO_INCREMENT=43 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_stock_category` ###

INSERT INTO `0_stock_category` VALUES
('41', 'SERVICE', 'SER', '1', 'Pcs', 'D', '3010010005', '40101001', '1020701001', '40102002', '1020701003', '0', '0', '0', '0', '0'),
('42', 'Finish Good', 'FG', '1', 'Pcs', 'B', '3010010001', '40101001', '1020701001', '40102002', '1020701003', '0', '0', '0', '0', '0');

### Structure of table `0_stock_fa_class` ###

DROP TABLE IF EXISTS `0_stock_fa_class`;

CREATE TABLE `0_stock_fa_class` (
  `fa_class_id` varchar(20) NOT NULL DEFAULT '',
  `parent_id` varchar(20) NOT NULL DEFAULT '',
  `description` varchar(200) NOT NULL DEFAULT '',
  `long_description` tinytext NOT NULL,
  `depreciation_rate` double NOT NULL DEFAULT 0,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`fa_class_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_stock_fa_class` ###

INSERT INTO `0_stock_fa_class` VALUES
('001', '01', 'Attendence Machines', 'Equipment', '10', '0'),
('002', '', 'Office Chairs', '', '10', '0'),
('003', '', 'Office Tables', '', '10', '0'),
('004', '', 'Air Conditioners', '', '15', '0'),
('005', '', 'Water Dispensers', '', '15', '0'),
('006', '', 'Bracket Fans', '', '15', '0'),
('007', '', 'Electric Motor', '', '15', '0'),
('008', '', 'UPS, Batteries &amp; Stablizers', '', '15', '0'),
('009', '', 'Cabinets', '', '15', '0'),
('010', '', 'Security Cameras', '', '15', '0'),
('011', '', 'Cieling Fans', '', '15', '0'),
('012', '', 'Compressors', '', '15', '0'),
('013', '', 'Desktop Computers ', '', '20', '0'),
('014', '', 'Conveyars &amp; SS Tables', '', '15', '0'),
('015', '', 'Cots', '', '20', '0'),
('016', '', 'Electric Devices', '', '20', '0'),
('017', '', 'Digital Scales', '', '15', '0'),
('018', '', 'Exhaust Fan', '', '20', '0'),
('019', '', 'Fire Extinguishers', '', '15', '0'),
('020', '', 'Generators', '', '15', '0'),
('021', '', 'IT Devices', '', '20', '0'),
('022', '', 'Lab-Tools &amp; Machines', '', '15', '0'),
('023', '', 'Laptops', '', '20', '0'),
('024', '', 'LCD &amp; Projectors', '', '20', '0'),
('025', '', 'Lifter &amp; Stackers', '', '15', '0'),
('026', '', 'Lockers &amp; Safe', '', '15', '0'),
('027', '', 'LPG Cylinders', '', '15', '0'),
('028', '', 'Moulds', '', '15', '0'),
('029', '', 'Padestal Fan', '', '20', '0'),
('030', '', 'Printers &amp; Scanners', '', '20', '0'),
('031', '', 'Production Machinery', '', '15', '0'),
('032', '', 'Pumps ', '', '15', '0'),
('033', '', 'Racks', '', '20', '0'),
('034', '', 'Refrigerator &amp; Deep Frezers', '\n', '20', '0'),
('035', '', 'Room Coolers', '', '20', '0'),
('036', '', 'Sofa Set', '', '15', '0'),
('037', '', 'Spare s &amp; Tools', '', '15', '0'),
('038', '', 'Stool &amp; Benchs', '', '15', '0'),
('039', '', 'Vehicle', '', '20', '0'),
('040', '', 'Vessels', '', '15', '0'),
('041', '', 'Liquid Storage Tanks', '', '20', '0'),
('042', '', 'Chemical Storage Tanks', 'Chemical Storage Tanks', '10', '0'),
('043', '', 'Trade Marks', '', '10', '0'),
('044', '', 'Fixture &amp; Fittings', '', '20', '0');

### Structure of table `0_stock_master` ###

DROP TABLE IF EXISTS `0_stock_master`;

CREATE TABLE `0_stock_master` (
  `stock_id` varchar(20) NOT NULL DEFAULT '',
  `category_id` int(11) NOT NULL DEFAULT 0,
  `item_group_id` int(11) NOT NULL DEFAULT 0,
  `tax_type_id` int(11) NOT NULL DEFAULT 0,
  `description` varchar(200) NOT NULL DEFAULT '',
  `long_description` tinytext NOT NULL,
  `units` varchar(20) NOT NULL DEFAULT 'each',
  `mb_flag` char(1) NOT NULL DEFAULT 'B',
  `sales_account` varchar(15) NOT NULL DEFAULT '',
  `cogs_account` varchar(15) NOT NULL DEFAULT '',
  `inventory_account` varchar(15) NOT NULL DEFAULT '',
  `adjustment_account` varchar(15) NOT NULL DEFAULT '',
  `wip_account` varchar(15) NOT NULL DEFAULT '',
  `dimension_id` int(11) DEFAULT NULL,
  `dimension2_id` int(11) DEFAULT NULL,
  `purchase_cost` double NOT NULL DEFAULT 0,
  `material_cost` double NOT NULL DEFAULT 0,
  `labour_cost` double NOT NULL DEFAULT 0,
  `overhead_cost` double NOT NULL DEFAULT 0,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  `no_sale` tinyint(1) NOT NULL DEFAULT 0,
  `no_purchase` tinyint(1) NOT NULL DEFAULT 0,
  `editable` tinyint(1) NOT NULL DEFAULT 0,
  `is_cunsumption` int(11) NOT NULL DEFAULT 0,
  `depreciation_method` char(1) NOT NULL DEFAULT 'S',
  `depreciation_rate` double NOT NULL DEFAULT 0,
  `depreciation_factor` double NOT NULL DEFAULT 1,
  `depreciation_start` date NOT NULL DEFAULT '0000-00-00',
  `depreciation_date` date NOT NULL DEFAULT '0000-00-00',
  `fa_class_id` varchar(20) NOT NULL DEFAULT '',
  `fixed_asset` int(11) NOT NULL DEFAULT 0,
  `day` varchar(255) NOT NULL DEFAULT '0',
  PRIMARY KEY (`stock_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_stock_master` ###

INSERT INTO `0_stock_master` VALUES
('FG-001', '42', '2', '1', 'Racking System Local', 'Racking System Local', 'Pcs', 'B', '3010010001', '40101001', '1020701004', '40102002', '1020701003', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', ''),
('SER-001', '41', '1', '1', 'Racking System Imported', 'Racking System Imported', 'Pcs', 'B', '3010010003', '40101001', '1020701004', '40102002', '1020701003', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '');

### Structure of table `0_stock_moves` ###

DROP TABLE IF EXISTS `0_stock_moves`;

CREATE TABLE `0_stock_moves` (
  `trans_id` int(11) NOT NULL AUTO_INCREMENT,
  `trans_no` int(11) NOT NULL DEFAULT 0,
  `stock_id` char(20) NOT NULL DEFAULT '',
  `batch_no` varchar(30) NOT NULL,
  `exp_date` date NOT NULL,
  `type` smallint(6) NOT NULL DEFAULT 0,
  `loc_code` char(5) NOT NULL DEFAULT '',
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `price` double NOT NULL DEFAULT 0,
  `reference` char(40) NOT NULL DEFAULT '',
  `qty` double NOT NULL DEFAULT 1,
  `standard_cost` double NOT NULL DEFAULT 0,
  `file_system` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`trans_id`),
  KEY `type` (`type`,`trans_no`),
  KEY `Move` (`stock_id`,`loc_code`,`tran_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_stock_moves` ###


### Structure of table `0_supp_allocations` ###

DROP TABLE IF EXISTS `0_supp_allocations`;

CREATE TABLE `0_supp_allocations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `person_id` int(11) DEFAULT NULL,
  `amt` double unsigned DEFAULT NULL,
  `date_alloc` date NOT NULL DEFAULT '0000-00-00',
  `trans_no_from` int(11) DEFAULT NULL,
  `trans_type_from` int(11) DEFAULT NULL,
  `trans_no_to` int(11) DEFAULT NULL,
  `trans_type_to` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `trans_type_from` (`person_id`,`trans_type_from`,`trans_no_from`,`trans_type_to`,`trans_no_to`),
  KEY `From` (`trans_type_from`,`trans_no_from`),
  KEY `To` (`trans_type_to`,`trans_no_to`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_supp_allocations` ###


### Structure of table `0_supp_invoice_items` ###

DROP TABLE IF EXISTS `0_supp_invoice_items`;

CREATE TABLE `0_supp_invoice_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `supp_trans_no` int(11) DEFAULT NULL,
  `supp_trans_type` int(11) DEFAULT NULL,
  `gl_code` varchar(15) NOT NULL DEFAULT '',
  `grn_item_id` int(11) DEFAULT NULL,
  `po_detail_item_id` int(11) DEFAULT NULL,
  `stock_id` varchar(20) NOT NULL DEFAULT '',
  `description` tinytext DEFAULT NULL,
  `quantity` double NOT NULL DEFAULT 0,
  `unit_price` double NOT NULL DEFAULT 0,
  `unit_tax` double NOT NULL DEFAULT 0,
  `memo_` tinytext DEFAULT NULL,
  `dimension_id` int(11) NOT NULL DEFAULT 0,
  `dimension2_id` int(11) NOT NULL DEFAULT 0,
  `sales_invoice_no` int(11) NOT NULL DEFAULT 0 COMMENT 'Sales invoice No ',
  `dim_line` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `Transaction` (`supp_trans_type`,`supp_trans_no`,`stock_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_supp_invoice_items` ###


### Structure of table `0_supp_trans` ###

DROP TABLE IF EXISTS `0_supp_trans`;

CREATE TABLE `0_supp_trans` (
  `trans_no` int(11) unsigned NOT NULL DEFAULT 0,
  `type` smallint(6) unsigned NOT NULL DEFAULT 0,
  `supplier_id` int(11) unsigned NOT NULL,
  `reference` tinytext NOT NULL,
  `supp_reference` varchar(60) NOT NULL DEFAULT '',
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `due_date` date NOT NULL DEFAULT '0000-00-00',
  `ov_amount` double NOT NULL DEFAULT 0,
  `ov_discount` double NOT NULL DEFAULT 0,
  `ov_gst` double NOT NULL DEFAULT 0,
  `rate` double NOT NULL DEFAULT 1,
  `alloc` double NOT NULL DEFAULT 0,
  `tax_included` tinyint(1) NOT NULL DEFAULT 0,
  `sales_invoice_no` int(11) NOT NULL DEFAULT 0,
  `payment_terms` int(11) NOT NULL DEFAULT 0,
  `file_system` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`type`,`trans_no`,`supplier_id`),
  KEY `supplier_id` (`supplier_id`),
  KEY `tran_date` (`tran_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_supp_trans` ###


### Structure of table `0_suppliers` ###

DROP TABLE IF EXISTS `0_suppliers`;

CREATE TABLE `0_suppliers` (
  `supplier_id` int(11) NOT NULL AUTO_INCREMENT,
  `supp_name` varchar(60) NOT NULL DEFAULT '',
  `supp_ref` varchar(30) NOT NULL DEFAULT '',
  `address` tinytext NOT NULL,
  `supp_address` tinytext DEFAULT NULL,
  `gst_no` varchar(25) NOT NULL DEFAULT '',
  `trn_id` varchar(40) DEFAULT NULL,
  `contact` varchar(60) NOT NULL DEFAULT '',
  `supp_account_no` varchar(40) NOT NULL DEFAULT '',
  `website` varchar(100) NOT NULL DEFAULT '',
  `bank_account` varchar(60) NOT NULL DEFAULT '',
  `curr_code` char(3) DEFAULT NULL,
  `payment_terms` int(11) DEFAULT NULL,
  `tax_included` tinyint(1) NOT NULL DEFAULT 0,
  `dimension_id` int(11) DEFAULT 0,
  `dimension2_id` int(11) DEFAULT 0,
  `tax_group_id` int(11) DEFAULT NULL,
  `credit_limit` double NOT NULL DEFAULT 0,
  `purchase_account` varchar(15) NOT NULL DEFAULT '',
  `payable_account` varchar(15) NOT NULL DEFAULT '',
  `payment_discount_account` varchar(15) NOT NULL DEFAULT '',
  `notes` tinytext DEFAULT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`supplier_id`),
  KEY `supp_ref` (`supp_ref`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_suppliers` ###

INSERT INTO `0_suppliers` VALUES
('1', 'Supp', 'V-001', '', NULL, '', NULL, '', '', '', '', 'PKR', '3', '0', '0', '0', '1', '0', '', '2010101001', '3010010002', NULL, '0');

### Structure of table `0_sys_prefs` ###

DROP TABLE IF EXISTS `0_sys_prefs`;

CREATE TABLE `0_sys_prefs` (
  `name` varchar(35) NOT NULL DEFAULT '',
  `category` varchar(30) DEFAULT NULL,
  `type` varchar(20) NOT NULL DEFAULT '',
  `length` smallint(6) DEFAULT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`name`),
  KEY `category` (`category`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_sys_prefs` ###

INSERT INTO `0_sys_prefs` VALUES
('accounts_alpha', 'glsetup.general', 'tinyint', '1', '0'),
('accumulate_shipping', 'glsetup.customer', 'tinyint', '1', '0'),
('add_pct', 'setup.company', 'int', '5', '-1'),
('allow_negative_prices', 'glsetup.inventory', 'tinyint', '1', '1'),
('allow_negative_stock', 'glsetup.inventory', 'tinyint', '1', '0'),
('alternative_tax_include_on_docs', 'setup.company', 'tinyint', '1', ''),
('auto_curr_reval', 'setup.company', 'smallint', '6', '1'),
('bank_charge_act', 'glsetup.general', 'varchar', '15', '40501001'),
('barcodes_on_stock', 'setup.company', 'tinyint', '1', '0'),
('base_sales', 'setup.company', 'int', '11', '0'),
('bcc_email', 'setup.company', 'varchar', '100', ''),
('company_logo_report', 'setup.company', 'tinyint', '1', '1'),
('coy_logo', 'setup.company', 'varchar', '100', ''),
('coy_name', 'setup.company', 'varchar', '60', 'Digitley (Pvt) Ltd'),
('coy_no', 'setup.company', 'varchar', '25', ''),
('creditors_act', 'glsetup.purchase', 'varchar', '15', '2010101001'),
('curr_default', 'setup.company', 'char', '3', 'PKR'),
('debtors_act', 'glsetup.sales', 'varchar', '15', '1020301001'),
('default_adj_act', 'glsetup.items', 'varchar', '15', '40102002'),
('default_cogs_act', 'glsetup.items', 'varchar', '15', '40101001'),
('default_credit_limit', 'glsetup.customer', 'int', '11', '0'),
('default_delivery_required', 'glsetup.sales', 'smallint', '6', '1'),
('default_dim_required', 'glsetup.dims', 'int', '11', '30'),
('default_inv_sales_act', 'glsetup.items', 'varchar', '15', '3010010001'),
('default_inventory_act', 'glsetup.items', 'varchar', '15', '1020701001'),
('default_labour_acc', 'glsetup.inventory', 'int', '1', '40101004'),
('default_loss_on_asset_disposal_act', 'glsetup.items', 'varchar', '15', '3010002003'),
('default_overhead_acc', 'glsetup.inventory', 'int', '1', '40101003'),
('default_prompt_payment_act', 'glsetup.sales', 'varchar', '15', '3010010002'),
('default_quote_valid_days', 'glsetup.sales', 'smallint', '6', '30'),
('default_receival_required', 'glsetup.purchase', 'smallint', '6', '10'),
('default_sales_act', 'glsetup.sales', 'varchar', '15', '3010010001'),
('default_sales_discount_act', 'glsetup.sales', 'varchar', '15', '3010010002'),
('default_whtax_act', 'glsetup.customer', 'varchar', '15', '1020601001'),
('default_wip_act', 'glsetup.items', 'varchar', '15', '1020701003'),
('default_workorder_required', 'glsetup.manuf', 'int', '11', '1'),
('deferred_income_act', 'glsetup.sales', 'varchar', '15', '2105'),
('depreciation_period', 'glsetup.company', 'tinyint', '1', '0'),
('dim_on_recurrent_invoice', 'setup.company', 'tinyint', '1', '0'),
('dim1_name', 'setup.company', 'tinyint', '1', 'Project'),
('dim2_name', 'setup.company', 'tinyint', '1', 'Cost Center'),
('domicile', 'setup.company', 'varchar', '55', '123456789'),
('email', 'setup.company', 'varchar', '100', ''),
('exchange_diff_act', 'glsetup.general', 'varchar', '15', '4450'),
('f_year', 'setup.company', 'int', '11', '6'),
('fax', 'setup.company', 'varchar', '30', ''),
('freight_act', 'glsetup.customer', 'varchar', '15', '4430'),
('gl_closing_date', 'setup.closing_date', 'date', '8', ''),
('grn_clearing_act', 'glsetup.purchase', 'varchar', '15', '1020701006'),
('gst_no', 'setup.company', 'varchar', '25', '1234567-8'),
('kv_batch', 'setup.company', 'tinyint', '1', '1'),
('kv_exp_date', 'setup.company', 'tinyint', '1', '0'),
('legal_text', 'glsetup.customer', 'tinytext', '0', ''),
('loc_notification', 'glsetup.inventory', 'tinyint', '1', '1'),
('login_tout', 'setup.company', 'smallint', '6', '9999999999'),
('long_description_invoice', 'setup.company', 'tinyint', '1', '0'),
('max_days_in_docs', 'setup.company', 'smallint', '5', '180'),
('no_customer_list', 'setup.company', 'tinyint', '1', '0'),
('no_item_list', 'setup.company', 'tinyint', '1', '1'),
('no_supplier_list', 'setup.company', 'tinyint', '1', '0'),
('no_zero_lines_amount', 'glsetup.sales', 'tinyint', '1', '1'),
('past_due_days', 'glsetup.general', 'int', '11', '30'),
('phone', 'setup.company', 'varchar', '30', ''),
('po_inward_act', 'glsetup.purchase', 'varchar', '15', '1020701005'),
('po_outward_act', 'glsetup.purchase', 'varchar', '15', '1020701005'),
('po_over_charge', 'glsetup.purchase', 'int', '11', '0'),
('po_over_receive', 'glsetup.purchase', 'int', '11', '0'),
('po_term', 'glsetup.customer', 'tinytext', '0', 'Payment Term \r\nfirst true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence \r\nstructures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always \r\nfree from repetition, injected humor, or non-characteristic words etc.'),
('postal_address', 'setup.company', 'tinytext', '0', 'Address 1\r\nAddress 2\r\nAddress 3'),
('print_dialog_direct', 'setup.company', 'tinyint', '1', '0'),
('print_invoice_no', 'glsetup.sales', 'tinyint', '1', '0'),
('print_item_images_on_quote', 'glsetup.inventory', 'tinyint', '1', ''),
('profit_loss_year_act', 'glsetup.general', 'varchar', '15', '9990'),
('pyt_discount_act', 'glsetup.purchase', 'varchar', '15', '3010010002'),
('ref_no_auto_increase', 'setup.company', 'tinyint', '1', '0'),
('retained_earnings_act', 'glsetup.general', 'varchar', '15', '5020001001'),
('round_to', 'setup.company', 'int', '5', '1'),
('shortname_name_in_list', 'setup.company', 'tinyint', '1', '1'),
('show_po_item_codes', 'glsetup.purchase', 'tinyint', '1', '1'),
('suppress_tax_rates', 'setup.company', 'tinyint', '1', ''),
('tax_algorithm', 'glsetup.customer', 'tinyint', '1', '1'),
('tax_last', 'setup.company', 'int', '11', '1'),
('tax_prd', 'setup.company', 'int', '11', '1'),
('time_zone', 'setup.company', 'tinyint', '1', '0'),
('use_dimension', 'setup.company', 'tinyint', '1', '1'),
('use_fixed_assets', 'setup.company', 'tinyint', '1', ''),
('use_manufacturing', 'setup.company', 'tinyint', '1', ''),
('version_id', 'system', 'varchar', '11', '2.4.1');

### Structure of table `0_tag_associations` ###

DROP TABLE IF EXISTS `0_tag_associations`;

CREATE TABLE `0_tag_associations` (
  `record_id` varchar(15) NOT NULL,
  `tag_id` int(11) NOT NULL,
  PRIMARY KEY (`record_id`,`tag_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_tag_associations` ###


### Structure of table `0_tags` ###

DROP TABLE IF EXISTS `0_tags`;

CREATE TABLE `0_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` smallint(6) NOT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(60) DEFAULT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `type` (`type`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_tags` ###


### Structure of table `0_tax_group_items` ###

DROP TABLE IF EXISTS `0_tax_group_items`;

CREATE TABLE `0_tax_group_items` (
  `tax_group_id` int(11) NOT NULL DEFAULT 0,
  `tax_type_id` int(11) NOT NULL DEFAULT 0,
  `tax_shipping` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`tax_group_id`,`tax_type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_tax_group_items` ###

INSERT INTO `0_tax_group_items` VALUES
('1', '1', '1'),
('3', '2', '0'),
('4', '3', '0'),
('5', '4', '0'),
('6', '5', '0');

### Structure of table `0_tax_groups` ###

DROP TABLE IF EXISTS `0_tax_groups`;

CREATE TABLE `0_tax_groups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(60) NOT NULL DEFAULT '',
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_tax_groups` ###

INSERT INTO `0_tax_groups` VALUES
('1', 'Sales Tax @ 17 %', '0'),
('2', 'Tax Exempt', '0'),
('3', 'Sales Tax @ 18 %', '0'),
('4', 'SRB 13%', '0'),
('5', 'PRB @ 16%', '0'),
('6', 'Sales Tax @ 3rd  Schedule', '0');

### Structure of table `0_tax_types` ###

DROP TABLE IF EXISTS `0_tax_types`;

CREATE TABLE `0_tax_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rate` double NOT NULL DEFAULT 0,
  `sales_gl_code` varchar(15) NOT NULL DEFAULT '',
  `purchasing_gl_code` varchar(15) NOT NULL DEFAULT '',
  `name` varchar(60) NOT NULL DEFAULT '',
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_tax_types` ###

INSERT INTO `0_tax_types` VALUES
('1', '17', '2010302001', '2010302001', 'GST @ 17 %', '0'),
('2', '18', '2010302001', '2010302001', 'GST @ 18 %', '0'),
('3', '13', '2010302001', '2010302001', 'SRB @ 13 %', '0'),
('4', '16', '2010302001', '2010302001', 'PRB @ 16%', '0'),
('5', '19.98', '2010302001', '2010302001', 'GST @ 3rd Schedule', '0');

### Structure of table `0_trans_tax_details` ###

DROP TABLE IF EXISTS `0_trans_tax_details`;

CREATE TABLE `0_trans_tax_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `trans_type` smallint(6) DEFAULT NULL,
  `trans_no` int(11) DEFAULT NULL,
  `tran_date` date NOT NULL,
  `tax_type_id` int(11) NOT NULL DEFAULT 0,
  `rate` double NOT NULL DEFAULT 0,
  `ex_rate` double NOT NULL DEFAULT 1,
  `included_in_price` tinyint(1) NOT NULL DEFAULT 0,
  `net_amount` double NOT NULL DEFAULT 0,
  `amount` double NOT NULL DEFAULT 0,
  `memo` tinytext DEFAULT NULL,
  `reg_type` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `Type_and_Number` (`trans_type`,`trans_no`),
  KEY `tran_date` (`tran_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_trans_tax_details` ###


### Structure of table `0_transfer_trans` ###

DROP TABLE IF EXISTS `0_transfer_trans`;

CREATE TABLE `0_transfer_trans` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `from_loc` varchar(20) NOT NULL,
  `to_loc` varchar(20) NOT NULL,
  `trans_no` int(11) NOT NULL,
  `type` int(11) NOT NULL,
  `po_inv` int(11) NOT NULL DEFAULT 0,
  `req_no` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_transfer_trans` ###


### Structure of table `0_useronline` ###

DROP TABLE IF EXISTS `0_useronline`;

CREATE TABLE `0_useronline` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `timestamp` int(15) NOT NULL DEFAULT 0,
  `ip` varchar(40) NOT NULL DEFAULT '',
  `file` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `timestamp` (`timestamp`),
  KEY `ip` (`ip`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_useronline` ###


### Structure of table `0_users` ###

DROP TABLE IF EXISTS `0_users`;

CREATE TABLE `0_users` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(60) NOT NULL DEFAULT '',
  `password` varchar(100) NOT NULL DEFAULT '',
  `real_name` varchar(100) NOT NULL DEFAULT '',
  `role_id` int(11) NOT NULL DEFAULT 1,
  `phone` varchar(30) NOT NULL DEFAULT '',
  `email` varchar(100) DEFAULT NULL,
  `language` varchar(20) DEFAULT NULL,
  `date_format` tinyint(1) NOT NULL DEFAULT 0,
  `date_sep` tinyint(1) NOT NULL DEFAULT 0,
  `tho_sep` tinyint(1) NOT NULL DEFAULT 0,
  `dec_sep` tinyint(1) NOT NULL DEFAULT 0,
  `theme` varchar(20) NOT NULL DEFAULT 'LTE',
  `page_size` varchar(20) NOT NULL DEFAULT 'A4',
  `prices_dec` smallint(6) NOT NULL DEFAULT 2,
  `qty_dec` smallint(6) NOT NULL DEFAULT 2,
  `rates_dec` smallint(6) NOT NULL DEFAULT 4,
  `percent_dec` smallint(6) NOT NULL DEFAULT 1,
  `show_gl` tinyint(1) NOT NULL DEFAULT 1,
  `show_codes` tinyint(1) NOT NULL DEFAULT 0,
  `show_hints` tinyint(1) NOT NULL DEFAULT 0,
  `last_visit_date` datetime DEFAULT NULL,
  `query_size` tinyint(1) unsigned NOT NULL DEFAULT 10,
  `graphic_links` tinyint(1) DEFAULT 1,
  `pos` smallint(6) DEFAULT 1,
  `print_profile` varchar(30) NOT NULL DEFAULT '',
  `rep_popup` tinyint(1) DEFAULT 1,
  `sticky_doc_date` tinyint(1) DEFAULT 0,
  `startup_tab` varchar(20) NOT NULL DEFAULT '',
  `transaction_days` smallint(6) NOT NULL DEFAULT 30,
  `save_report_selections` smallint(6) NOT NULL DEFAULT 0,
  `use_date_picker` tinyint(1) NOT NULL DEFAULT 1,
  `def_print_destination` tinyint(1) NOT NULL DEFAULT 0,
  `def_print_orientation` tinyint(1) NOT NULL DEFAULT 0,
  `location` varchar(500) DEFAULT NULL COMMENT 'Form Location',
  `qc_location` varchar(500) DEFAULT NULL COMMENT 'qc_location',
  `to_location` varchar(500) DEFAULT NULL COMMENT 'To Location',
  `user_bank_acc` varchar(255) DEFAULT NULL,
  `item_category` varchar(255) DEFAULT NULL,
  `city_id` varchar(255) DEFAULT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=51 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_users` ###

INSERT INTO `0_users` VALUES
('1', 'admin', '81dc9bdb52d04dc20036dbd8313ed055', 'Administrator', '2', '', 'wrapandg@wrapandgoofficial.com', 'C', '1', '0', '0', '0', 'LTE', 'Letter', '2', '5', '3', '2', '1', '1', '0', '2024-02-17 13:45:38', '20', '1', '1', '', '1', '0', 'orders', '36', '0', '1', '0', '0', 'DEF', 'DEF', 'DEF,001', '12,2', '41,42', '36,18,23,24,17,14,16,2,37,33,1,29,26,3,25,35,22,30,34,15,13,20,12,21,31,28,27,19,32', '0'),
('46', 'CEO.', 'd41d8cd98f00b204e9800998ecf8427e', 'CEO.', '2', '', NULL, 'C', '1', '0', '0', '0', 'LTE', 'Letter', '2', '5', '3', '2', '1', '1', '0', NULL, '20', '1', '1', '', '1', '0', 'orders', '30', '0', '1', '0', '0', 'AYNT,FAT,001,NAZT,DEF', 'AYNT,FAT,001,NAZT,DEF', 'AYNT,FAT,001,NAZT,DEF', '12,2', '41,42', '1', '0'),
('47', 'khalidsiddiqui', '81dc9bdb52d04dc20036dbd8313ed055', 'Khalid Siddiqui', '2', '', NULL, 'C', '1', '0', '0', '0', 'LTE', 'Letter', '2', '5', '3', '2', '1', '1', '0', '2024-02-15 16:55:04', '20', '1', '1', '', '1', '0', 'orders', '30', '0', '1', '0', '0', 'AYNT,FAT,001,NAZT,DEF', 'AYNT,FAT,001,NAZT,DEF', 'AYNT,FAT,001,NAZT,DEF', '12,2', '41,42', '1', '0'),
('48', 'munawarhafeez', '81dc9bdb52d04dc20036dbd8313ed055', 'Munawar Hafeez', '2', '', NULL, 'C', '1', '0', '0', '0', 'LTE', 'Letter', '2', '5', '3', '2', '1', '1', '0', NULL, '20', '1', '1', '', '1', '0', 'orders', '30', '0', '1', '0', '0', 'AYNT,FAT,001,NAZT,DEF', 'AYNT,FAT,001,NAZT,DEF', 'AYNT,FAT,001,NAZT,DEF', '12,2', '41,42', '1', '0'),
('49', 'arslananis', 'd41d8cd98f00b204e9800998ecf8427e', 'Arslan Anis', '2', '', NULL, 'C', '1', '0', '0', '0', 'LTE', 'Letter', '2', '5', '3', '2', '1', '1', '0', NULL, '20', '1', '1', '', '1', '0', 'orders', '30', '0', '1', '0', '0', 'AYNT,FAT,001,NAZT,DEF', 'AYNT,FAT,001,NAZT,DEF', 'AYNT,FAT,001,NAZT,DEF', '12,2', '41,42', '1', '0'),
('50', 'jibranellahi', '81dc9bdb52d04dc20036dbd8313ed055', 'Jibran Ellahi', '2', '', NULL, 'C', '1', '0', '0', '0', 'LTE', 'Letter', '2', '5', '3', '2', '1', '1', '0', NULL, '20', '1', '1', '', '1', '0', 'orders', '30', '0', '1', '0', '0', 'AYNT,FAT,001,NAZT,DEF', 'AYNT,FAT,001,NAZT,DEF', 'AYNT,FAT,001,NAZT,DEF', '12,2', '41,42', '1', '0');

### Structure of table `0_voided` ###

DROP TABLE IF EXISTS `0_voided`;

CREATE TABLE `0_voided` (
  `type` int(11) NOT NULL DEFAULT 0,
  `id` int(11) NOT NULL DEFAULT 0,
  `date_` date NOT NULL DEFAULT '0000-00-00',
  `memo_` tinytext NOT NULL,
  UNIQUE KEY `id` (`type`,`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_voided` ###


### Structure of table `0_wo_costing` ###

DROP TABLE IF EXISTS `0_wo_costing`;

CREATE TABLE `0_wo_costing` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `workorder_id` int(11) NOT NULL DEFAULT 0,
  `cost_type` tinyint(1) NOT NULL DEFAULT 0,
  `trans_type` int(11) NOT NULL DEFAULT 0,
  `trans_no` int(11) NOT NULL DEFAULT 0,
  `factor` double NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_wo_costing` ###


### Structure of table `0_wo_issue_items` ###

DROP TABLE IF EXISTS `0_wo_issue_items`;

CREATE TABLE `0_wo_issue_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `stock_id` varchar(40) DEFAULT NULL,
  `batch_no` varchar(30) NOT NULL,
  `exp_date` date NOT NULL,
  `issue_id` int(11) DEFAULT NULL,
  `qty_issued` double DEFAULT NULL,
  `unit_cost` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_wo_issue_items` ###


### Structure of table `0_wo_issues` ###

DROP TABLE IF EXISTS `0_wo_issues`;

CREATE TABLE `0_wo_issues` (
  `issue_no` int(11) NOT NULL AUTO_INCREMENT,
  `workorder_id` int(11) NOT NULL DEFAULT 0,
  `reference` varchar(100) DEFAULT NULL,
  `issue_date` date DEFAULT NULL,
  `loc_code` varchar(5) DEFAULT NULL,
  `workcentre_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`issue_no`),
  KEY `workorder_id` (`workorder_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_wo_issues` ###


### Structure of table `0_wo_manufacture` ###

DROP TABLE IF EXISTS `0_wo_manufacture`;

CREATE TABLE `0_wo_manufacture` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reference` varchar(100) DEFAULT NULL,
  `workorder_id` int(11) NOT NULL DEFAULT 0,
  `quantity` double NOT NULL DEFAULT 0,
  `date_` date NOT NULL DEFAULT '0000-00-00',
  `batch_no` varchar(15) NOT NULL,
  `pack_size` double NOT NULL,
  `pack_unit` varchar(15) NOT NULL,
  `no_of_pack` double NOT NULL,
  PRIMARY KEY (`id`),
  KEY `workorder_id` (`workorder_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_wo_manufacture` ###


### Structure of table `0_wo_requirements` ###

DROP TABLE IF EXISTS `0_wo_requirements`;

CREATE TABLE `0_wo_requirements` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `workorder_id` int(11) NOT NULL DEFAULT 0,
  `stock_id` char(20) NOT NULL DEFAULT '',
  `workcentre` int(11) NOT NULL DEFAULT 0,
  `units_req` double NOT NULL DEFAULT 1,
  `unit_cost` double NOT NULL DEFAULT 0,
  `loc_code` char(5) NOT NULL DEFAULT '',
  `units_issued` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `workorder_id` (`workorder_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_wo_requirements` ###


### Structure of table `0_workcentres` ###

DROP TABLE IF EXISTS `0_workcentres`;

CREATE TABLE `0_workcentres` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` char(40) NOT NULL DEFAULT '',
  `description` char(50) NOT NULL DEFAULT '',
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_workcentres` ###

INSERT INTO `0_workcentres` VALUES
('1', 'Blending station', 'Chemical Mixture', '0'),
('2', 'Packing Station', 'Packing Station', '0');

### Structure of table `0_workorders` ###

DROP TABLE IF EXISTS `0_workorders`;

CREATE TABLE `0_workorders` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `wo_ref` varchar(60) NOT NULL DEFAULT '',
  `loc_code` varchar(5) NOT NULL DEFAULT '',
  `units_reqd` double NOT NULL DEFAULT 1,
  `stock_id` varchar(20) NOT NULL DEFAULT '',
  `date_` date NOT NULL DEFAULT '0000-00-00',
  `type` tinyint(4) NOT NULL DEFAULT 0,
  `required_by` date NOT NULL DEFAULT '0000-00-00',
  `released_date` date NOT NULL DEFAULT '0000-00-00',
  `units_issued` double NOT NULL DEFAULT 0,
  `batch_no` varchar(30) DEFAULT NULL,
  `closed` tinyint(1) NOT NULL DEFAULT 0,
  `released` tinyint(1) NOT NULL DEFAULT 0,
  `additional_costs` double NOT NULL DEFAULT 0,
  `work_center_status` int(11) NOT NULL DEFAULT 0,
  `is_qc` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `wo_ref` (`wo_ref`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_workorders` ###
