<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/

function add_day_limit($bank_account, $day_limit_amt)
{
	$sql = "INSERT INTO ".TB_PREF."day_limit_amount (bank_account, day_limit_amt) VALUES 
		(".db_escape($bank_account) . ", ".db_escape($day_limit_amt) . ")";
   	db_query($sql,"The sales area could not be added");
}

function update_day_limit($selected_id, $bank_account, $day_limit_amt)
{
	$sql = "UPDATE ".TB_PREF."day_limit_amount SET bank_account=".db_escape($bank_account).",
		day_limit_amt=".db_escape($day_limit_amt)." WHERE id = ".db_escape($selected_id);
   	db_query($sql,"The sales area could not be updated");
}

function delete_day_limit($selected_id)
{
	$sql="DELETE FROM ".TB_PREF."day_limit_amount WHERE id=".db_escape($selected_id);
	db_query($sql,"could not delete sales area");
}

function get_day_limits($show_inactive)
{
	$sql = "SELECT * FROM ".TB_PREF."day_limit_amount";
	if (!$show_inactive) $sql .= " WHERE !inactive";
	return db_query($sql,"could not get areas");
}

function get_day_limit($selected_id)
{
	$sql = "SELECT * FROM ".TB_PREF."day_limit_amount WHERE id=".db_escape($selected_id);

	$result = db_query($sql,"could not get area");
	return db_fetch($result);
}

function get_day_limit_name($id)
{
	$sql = "SELECT description FROM ".TB_PREF."day_limit_amount WHERE id=".db_escape($id);

	$result = db_query($sql, "could not get sales type");

	$row = db_fetch_row($result);
	return is_array($row) ? $row[0] : false;
}

function get_day_limit_amt($bank_account)
{
	$sql = "SELECT * FROM ".TB_PREF."day_limit_amount WHERE bank_account=".db_escape($bank_account);
	$result = db_query($sql,"could not get area");
	return db_fetch($result);
}
