<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_PAYMENT';
$path_to_root="../..";
include_once($path_to_root . "/includes/db_pager.inc");
include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/purchasing/includes/purchasing_ui.inc");
include_once($path_to_root . "/reporting/includes/reporting.inc");

$js = "";
if ($SysPrefs->use_popup_windows)
	$js .= get_js_open_window(900, 500);
if (user_use_date_picker())
	$js .= get_js_date_picker();
page(_($help_context = "Post Date Inquiry"), false, false, "", $js);

//---------------------------------------------------------------------------------------------

function get_bank_acc_name($row)
{
	return get_bank_account_name($row['bank_id']);
}

function post_cheque_date($row)
{
	return sql2date($row["date_"]);
}

function post_cheque_post_date($row)
{
	return sql2date($row["post_date"]);
}

function systype_name($dummy, $type)
{
	global $systypes_array;
	return $systypes_array[$type];
}

function post_date_link($row) 
{
 if($row['type']==ST_SUPPAYMENT)
 return pager_link(_("Payment"), "/purchasing/supplier_payment.php?New=1&post_check_trans_no=".$row["trans_no"], ICON_RECEIVE);
 else
  return pager_link(_("Payment"), "/gl/gl_bank.php?NewPayment=Yes&post_check_trans_no=".$row["trans_no"], ICON_RECEIVE);
}

function post_date_trans_link($row)
{
	if($row['type']==ST_SUPPAYMENT)
	 	return viewer_link($row['trans_no'] ,'/gl/view/gl_post_date_trans_view.php?supp_pay='.$row['trans_no']);
    else
		return viewer_link($row['trans_no'] ,'/gl/view/gl_post_date_trans_view.php?trans_no='.$row['trans_no']);
}

function prt_link_post_dated($row){

	return print_document_link($row['trans_no']."-".ST_BANKPAYMENT_POST_DATED, _("Print Receipt"), true, ST_BANKPAYMENT_POST_DATED, ICON_PRINT);
}

start_form();

start_table(TABLESTYLE_NOBORDER);
start_row();
ref_cells(_("Cheque No."), 'cheque_no', '',null, '', true);
date_cells(_("from:"), 'OrdersAfterDate', '', null, -user_transaction_days());
date_cells(_("to:"), 'OrdersToDate');
// submit_cells('SearchOrders', _("Search"),'',_('Select documents'), 'default');
end_row();
end_table();
start_table(TABLESTYLE_NOBORDER);
start_row();
bank_accounts_list_cells(_("From Account:"), 'bank_account', null, true, false, true);
submit_cells('SearchOrders', _("Search"),'',_('Select documents'), 'default');
end_row();
end_table(1);


//---------------------------------------------------------------------------------------------

$sql = get_post_date_inquiry(get_post('OrdersAfterDate'), get_post('OrdersToDate'),get_post('cheque_no'),
		get_post('bank_account'));

$cols = array(
	_("Trans No.") => array('fun'=>'post_date_trans_link', 'ord'=>'', 'align'=>'center'),
	_("Type") => array('fun'=>'systype_name', 'ord'=>'', 'align'=>'center'),
	_("Date") => array('fun'=>'post_cheque_date', 'ord'=>'', 'align'=>'center'),
	_("Bank Account") => array('fun'=>'get_bank_acc_name', 'ord'=>'', 'align'=>'center'),
	_("Cheque No.") => array('cheque_no', 'align'=>'center'),
	_("Post Date") => array('fun'=>'post_cheque_post_date', 'ord'=>'', 'align'=>'center'),
	_("Total Amount.") => array('total_amount', 'align'=>'center'),
	_("Memo") => array('comments', 'align'=>'center'),
	_("") => array('fun'=>'post_date_link', 'ord'=>'', 'align'=>'center'),
	array('insert'=>true, 'fun'=>'prt_link_post_dated')
);

//---------------------------------------------------------------------------------------------------

$table =& new_db_pager('orders_tbl', $sql, $cols);

$table->width = "80%";
display_db_pager($table);

end_form();
end_page();
