<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_BANKSEQUENCE';
$path_to_root = "../..";
include($path_to_root . "/includes/session.inc");

page(_($help_context = "Bank Cheque Serial"));

include($path_to_root . "/includes/ui.inc");

simple_page_mode(true);

if ($Mode=='ADD_ITEM' || $Mode=='UPDATE_ITEM') 
{
	// $bankbsc = get_bank_check_serial($_POST['bank_id']);
	// print_r($bankbsc);

	$input_error = 0;

	if (strlen($_POST['serial_from']) == 0) 
	{
		$input_error = 1;
		display_error(_("The  serial from cannot be empty."));
		set_focus('serial_from');
	}

	if (strlen($_POST['serial_to']) == 0) 
	{
		$input_error = 1;
		display_error(_("The serial to cannot be empty."));
		set_focus('serial_to');
	}

	if ($input_error != 1)
	{
    	if ($selected_id != -1) 
    	{
    		update_bank_check_serial($selected_id,
    		$_POST['serial_from'], $_POST['serial_to']);
			$note = _('Selected Back Serial has been updated');
    	} 
    	else 
    	{
    		add_bank_check_serial(input_num('bank_id'), $_POST['serial_from'], 
    			$_POST['serial_to']);
			$note = _('New Back Serial has been added');
			// display_error(input_num('bank_id'));
    	}
    
		display_notification($note);    	
		$Mode = 'RESET';
	}
} 
if ($Mode == 'Delete')
{

	$cancel_delete = 0;

	// PREVENT DELETES IF DEPENDENT RECORDS IN 'debtors_master'

	// if (key_in_foreign_table($selected_id, 'cust_branch', 'area'))
	// {
	// 	$cancel_delete = 1;
	// 	display_error(_("Cannot delete this area because customer branches have been created using this area."));
	// } 
	if ($cancel_delete == 0) 
	{
		delete_bank_check_serial($selected_id);
		// display_error($selected_id);

		display_notification(_('Selected Back Serial has been deleted'));
	} //end if Delete area
	$Mode = 'RESET';
} 

if ($Mode == 'RESET')
{
	$selected_id = -1;
	$sav = get_post('show_inactive');
	unset($_POST);
	$_POST['show_inactive'] = $sav;
}

//-------------------------------------------------------------------------------------------------

start_form();
echo "<center>" . "&nbsp";
bank_accounts_list_cells(_("Bank Account:"), 'bank_id', null, true,false,1);
echo "<hr></center>";
start_table(TABLESTYLE, "width='30%'");

$th = array(_("Serial From"), _("Serial To"), "", "");
inactive_control_column($th);

$result = get_bank_check_serials(check_value('show_inactive'),$_POST['bank_id']);
table_header($th);
$k = 0; 

while ($myrow = db_fetch($result)) 
{
	
	alt_table_row_color($k);
	// label_cell($myrow["bank_id"], "align=center");
	label_cell($myrow["serial_from"], "align=center");
	label_cell($myrow["serial_to"],  "align='center'");

	inactive_control_cell($myrow["id"], $myrow["inactive"], 'bank_check_serial', 'id');

 	edit_button_cell("Edit".$myrow["id"], _("Edit"));
 	delete_button_cell("Delete".$myrow["id"], _("Delete"));
	end_row();
}
	
inactive_control_row($th);
end_table();
echo '<br>';

//-------------------------------------------------------------------------------------------------

start_table(TABLESTYLE2);

if ($selected_id != -1) 
{
 	if ($Mode == 'Edit') {
		//editing an existing area
		$myrow = get_bank_check_serial_id($selected_id);

		$_POST['serial_from']  = $myrow["serial_from"];
		$_POST['serial_to']  = $myrow["serial_to"];
	//	display_error($_POST['serial_from']." == ".$_POST['serial_to']);
	}
	hidden("selected_id", $selected_id);
} 
$bankacc = get_bank_account($_POST['bank_id']);
if ($bankacc['account_type'] != BT_CASH){
text_row_ex(_("Serial From:"), 'serial_from', 30); 
text_row_ex(_("Serial To:"), 'serial_to', 30); 
}
end_table(1);

submit_add_or_update_center($selected_id == -1, '', 'both');

end_form();

end_page();
