<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/

function add_job_order($reference, $location, $quantity, $stock_id, $date_, $memo_)
{
	global $Refs;

	$sql = "INSERT INTO ".TB_PREF."joborder (reference, location, qty, stock_id, date_, memo) VALUES (".db_escape($reference) . ", ".db_escape($location) . ",
	".db_escape($quantity) . ", ".db_escape($stock_id) . ", '".sql2date($date_) . "',
	".db_escape($memo_) . ")";
   	db_query($sql,"The job order could not be added");
   	$joid = db_insert_id();
	add_comments(ST_WORKORDER, $joid, $date_, $memo_);
	$Refs->save(ST_WORKORDER, $joid, $reference);
	add_audit_trail(ST_WORKORDER, $joid, $date_);
	return $joid;
}

function get_job_order($joid)
{
	$sql = "SELECT * FROM ".TB_PREF."joborder WHERE id=".db_escape($joid);
	$result = db_query($sql,"could not job order");
	return db_fetch($result);
}

function get_joborder_inquiry($jobnumber='', $ref='', $from='', $to='',
			$items='', $location='')
{
	$date_after = date2sql($from);
	$date_before = date2sql($to);

	$sql = "SELECT 
			id,
			reference,
			date_,
			location
	FROM ".TB_PREF."joborder WHERE id";

	if($jobnumber != "")
	{
		$sql .= " AND id LIKE ".db_escape('%' . $jobnumber . '%');
	}
	if($ref != "")
	{
		$sql .= " AND reference LIKE ".db_escape('%' . $ref . '%');
	}
	if($items != "")
	{
		$sql .= " AND stock_id =".db_escape($items);
	}
	if($location != "")
	{
		$sql .= " AND location =".db_escape($location);
	}
	if($from != "")
		$sql .=  " AND date_ >= '$date_after'";
	if($to != "")
		$sql .=  " AND date_ <= '$date_before'";
	return $sql;
}

function delete_job_order($selected_id)
{
	$sql="DELETE FROM ".TB_PREF."joborder WHERE id=".db_escape($selected_id);
	db_query($sql,"could not delete sales group");
}

function get_wo_consumption($joid, $type)
{
	$sql = "SELECT * FROM ".TB_PREF."wo_consumption WHERE trans_no=".db_escape($joid). " AND type=".db_escape($type);
	return db_query($sql,"could not job order");
}