<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
function add_sub_loc($sub_loc, $location)
{
	$sql = "INSERT INTO ".TB_PREF."sub_location (sub_loc, location) VALUES (".db_escape($sub_loc) . ",
	".db_escape($location) . ")";
   	db_query($sql,"The sales area could not be added");
}

function update_sub_loc($selected_id, $sub_loc, $location)
{
	$sql = "UPDATE ".TB_PREF."sub_location SET sub_loc=".db_escape($sub_loc).", location=".db_escape($location)." WHERE id = ".db_escape($selected_id);
   	db_query($sql,"The sales area could not be updated");
}

function delete_sub_loc($selected_id)
{
	$sql="DELETE FROM ".TB_PREF."sub_location WHERE id=".db_escape($selected_id);
	db_query($sql,"could not delete sales area");
}

function get_sub_locs($show_inactive, $location='')
{
	$sql = "SELECT * FROM ".TB_PREF."sub_location";
	if (!$show_inactive) $sql .= " WHERE !inactive";
	if($location != '')
		$sql .= " AND location=".db_escape($location);
	return db_query($sql,"could not get areas");
}

function get_sub_loc($selected_id)
{
	$sql = "SELECT * FROM ".TB_PREF."sub_location WHERE id=".db_escape($selected_id);

	$result = db_query($sql,"could not get area");
	return db_fetch($result);
}

function get_sub_loc_name($id)
{
	$sql = "SELECT sub_loc FROM ".TB_PREF."sub_location WHERE id=".db_escape($id);

	$result = db_query($sql, "could not get sales type");

	$row = db_fetch_row($result);
	return is_array($row) ? $row[0] : false;
}