<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_WORKORDERENTRY';
$path_to_root="../..";
include_once($path_to_root . "/includes/db_pager.inc");
include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/sales/includes/sales_ui.inc");
include_once($path_to_root . "/reporting/includes/reporting.inc");

$js = "";
if ($SysPrefs->use_popup_windows)
	$js .= get_js_open_window(900, 500);
if (user_use_date_picker())
	$js .= get_js_date_picker();
page(_($help_context = "Job Inquiry"), false, false, "", $js);

//---------------------------------------------------------------------------------------------
function trans_view($row)
{
	return get_trans_view_str(ST_WORKORDER, $row["id"]);
}

function location_name($row)
{
	$location_name =  get_item_location($row['location']);
	return $location_name['location_name'];
}

function delete_link($row)
{
	return  delete_button_cell("Delete".$row['id'], _("Delete"),	_('Remove invocie'));
}

function consumption_link($row) 
{
  return pager_link( _(""),
	"/inventory/consumption.php?NewCunsumption=1&id=".$row["id"], ICON_RECEIVE);
}

function wo_adjust_link($row) 
{
  return pager_link( _(""),
	"/inventory/joborder.php?job_order_id=".$row["id"], ICON_RECEIVE);
}


//-----------------------------------------------------------------------------------
// Ajax updates
//
if (get_post('SearchOrders')) 
{
	$Ajax->activate('orders_tbl');
} elseif (get_post('_order_number_changed')) 
{
	$disable = get_post('order_number') !== '';

	$Ajax->addDisable(true, 'OrdersAfterDate', $disable);
	$Ajax->addDisable(true, 'OrdersToDate', $disable);
	$Ajax->addDisable(true, 'StockLocation', $disable);
	$Ajax->addDisable(true, '_SelectStockFromList_edit', $disable);
	$Ajax->addDisable(true, 'SelectStockFromList', $disable);

	if ($disable) {
		$Ajax->addFocus(true, 'order_number');
	} else
		$Ajax->addFocus(true, 'OrdersAfterDate');

	$Ajax->activate('orders_tbl');
}
//---------------------------------------------------------------------------------------------

start_form();

$id = find_submit('Delete');
if ($id!=-1){

	$cancel_delete = 0;
	if (key_in_foreign_table($id, 'wo_consumption', 'trans_no'))
	{
		$cancel_delete = 1;
		display_error(_("Cannot delete this job order because consumption was created against this job order."));
	} 
	if ($cancel_delete == 0) 
	{
		delete_job_order($id);
		display_notification(_('Selected job order has been deleted'));
	} 
	$Ajax->activate('orders_tbl');
}

start_table(TABLESTYLE_NOBORDER);
start_row();
ref_cells(_("#:"), 'JobNumber', '',null, '', true);
ref_cells(_("Ref"), 'OrderReference', '',null, '', true);

date_cells(_("From:"), 'OrdersAfterDate', '', null, -user_transaction_days());
date_cells(_("To:"), 'OrdersToDate');

end_row();
end_table();

start_table(TABLESTYLE_NOBORDER);
start_row();

stock_items_list_cells(_("Item:"), 'SelectStockFromList', null, true);
locations_list_cells(_("Location:"), 'Location', null, true);

submit_cells('SearchOrders', _("Search"),'',_('Select documents'), 'default');
end_row();
end_table(1);

//---------------------------------------------------------------------------------------------

$sql = get_joborder_inquiry(get_post('JobNumber'), get_post('OrderReference'), 
	get_post('OrdersAfterDate'), get_post('OrdersToDate'), get_post('SelectStockFromList'),
	get_post('Location'));

$cols = array(
		_("#") => array('fun'=>'trans_view', 'ord'=>'', 'align'=>'center'), 
		_("Reference") => array('ord'=>'', 'align'=>'center'), 
		_("Job Order Date") => array('name'=>'ord_date', 'type'=>'date', 'ord'=>'desc'),
		_("Location") => array('fun'=>'location_name', 'ord'=>'', 'align'=>'center'), 
		_("Consumption") => array('fun'=>'consumption_link', 'align'=>'center', 'ord' => ''),
		_("Enter Finish Item") => array('fun'=>'wo_adjust_link', 'align'=>'center', 'ord' => ''),
		_(" Delete") => array('insert'=>true, 'fun'=>'delete_link')
);

if (get_post('StockLocation') != ALL_TEXT) {
	$cols[_("Location")] = 'skip';
}

//---------------------------------------------------------------------------------------------------

$table =& new_db_pager('orders_tbl', $sql, $cols);

$table->width = "80%";

display_db_pager($table);

end_form();
end_page();
