<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_PRODUCTION_PLANNING';
$path_to_root = "../..";
include_once($path_to_root . "/includes/session.inc");

include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/banking.inc");
include_once($path_to_root . "/sales/includes/sales_db.inc");
include_once($path_to_root . "/inventory/includes/db/work_plan_db.inc");


include_once($path_to_root . "/includes/ui.inc");
$js = "";
if ($SysPrefs->use_popup_windows)
	$js .= get_js_open_window(800, 500);
if (user_use_date_picker())
	$js .= get_js_date_picker();


	$_SESSION['page_title'] = _($help_context = "Production Work Plane");

page($_SESSION['page_title'], isset($_GET['stock_id']), false, "", $js);

simple_page_mode(true);

//------------------------------------------------------------------------------------------------

if (get_post('fixed_asset') == 1)
	check_db_has_fixed_assets(_("There are no fixed asset defined in the system."));
else
	check_db_has_stock_items(_("There are no items defined in the system."));

if(get_post('ShowMoves'))
{
	$Ajax->activate('doc_tbl');
}

if (isset($_GET['stock_id']))
{
	$_POST['stock_id'] = $_GET['stock_id'];
}


function can_process()
{
	// if (strlen($_POST['sales_type']) == 0)
	// {
	// 	display_error(_("The sales type description cannot be empty."));
	// 	set_focus('sales_type');
	// 	return false;
	// }
// display_error(input_num('pqty', 0)." sami");
	if (!input_num('ptarget_qty', 0))
	{
		display_error(_(" target qty must be valid positive number."));
		set_focus('factor');
		return false;
	}
	if (!input_num('porder_qty', 0))
	{
		display_error(_(" target qty must be valid positive number."));
		set_focus('factor');
		return false;
	}
	return true;
}

//----------------------------------------------------------------------------------------------------

if ($Mode=='ADD_ITEM' && can_process())
{
	// add_sales_type($_POST['sales_type'], check_value('tax_included'),
	//     input_num('factor'));
    write_work_plan($selected, $_POST['pdate'], $_POST['stock_id'], $_POST['ptarget_qty'], $_POST['porder_qty'],$_POST['status']);
	display_notification(_('New work has been added'));
	$Mode = 'RESET';
}

//----------------------------------------------------------------------------------------------------

if ($Mode=='UPDATE_ITEM' && can_process())
{

  write_work_plan($_POST['selected_id'], $_POST['pdate'], $_POST['stock_id'], $_POST['ptarget_qty'], $_POST['porder_qty'],$_POST['status']);
	display_notification(_('Selected Work plan has been updated'));
	$Mode = 'RESET';
}

//----------------------------------------------------------------------------------------------------

if ($Mode == 'Delete')
{
	// PREVENT DELETES IF DEPENDENT RECORDS IN 'debtor_trans'
	
			// delete_sales_type($selected_id);
			display_notification(_('Selected  has been deleted'));
		
	 //end if sales type used in debtor transactions or in customers set up
	$Mode = 'RESET';
}

if ($Mode == 'RESET')
{
	$selected_id = -1;
	$sav = get_post('show_inactive');
	unset($_POST);
	$_POST['show_inactive'] = $sav;
}

start_form();

hidden('fixed_asset');

if (!isset($_POST['stock_id']))
	$_POST['stock_id'] = get_global_stock_item();



start_table(TABLESTYLE_NOBORDER);
start_row();
		// stock_costable_items_list_cells(_("Item:"), 'stock_id', $_POST['stock_id']);

		// stock_costable_items_list_cells(_("Item:"), 'stock_id', $_POST['stock_id']);

date_cells(_("From:"), 'AfterDate', '', null, -user_transaction_days());
date_cells(_("To:"), 'BeforeDate');

submit_cells('ShowMoves',_("Search"),'',_('Refresh Inquiry'), 'default');
end_row();
end_table();

br(2);
set_global_stock_item($_POST['stock_id']);

$before_date = date2sql($_POST['BeforeDate']);
$after_date = date2sql($_POST['AfterDate']);
$display_location = !$_POST['StockLocation'];

$result = get_all_work_plan($_POST['BeforeDate'], $_POST['AfterDate']);

div_start('doc_tbl');
start_table(TABLESTYLE);
$th = array(_("S/NO"), _("Date"), _("Item"), _("Target(Pcs)"), _("Order Qty(Pcs)"), _("Status"), '','');


// array_push($th,  _("Quantity In"), _("Quantity Out"), _("Quantity On Hand"));
table_header($th);
$j = 1;
$k = 0; //row colour counter

$total_in = 0;
$total_out = 0;
global $planing_status;

while ($myrow = db_fetch($result))
{

	alt_table_row_color($k);

	$trandate = sql2date($myrow["tran_date"]);


	label_cell($j);	
	label_cell($trandate,'align=center');
	$item_row = get_item($myrow['item']);
	label_cell($myrow['item']." ".$item_row['description'],'align=center');
	label_cell($myrow['target_qty'],'align=center');
	label_cell($myrow['order_qty'],'align=center');
	if($myrow['status']==0)
	$label='<span class="label label-primary">'.$planing_status[$myrow['status']].'<span>';
		elseif($myrow['status']==1)
	$label='<span class="label label-success">'.$planing_status[$myrow['status']].'<span>';
		elseif($myrow['status']==2)
	$label='<span class="label label-warning">'.$planing_status[$myrow['status']].'<span>';	
    label_cell($label,'align=center');
     	edit_button_cell("Edit".$myrow['id'], _("Edit"));
 	// delete_button_cell("Delete".$myrow['id'], _("Delete"));

	// qty_cell($after_qty, false, $dec);
	end_row();

	$j++;
	if ($j == 12)
	{
		$j = 1;
		table_header($th);
	}
}

// $header_span=3;
// start_row("class='inquirybg'");
// label_cell("<b>"._("Quantity on hand after") . " " . $_POST['BeforeDate']."</b>", "align=center colspan=$header_span");
// qty_cell($total_in, false, $dec);
// qty_cell($total_out, false, $dec);
// qty_cell($after_qty, false, $dec);
// end_row();

end_table(1);





start_table(TABLESTYLE2, "width='70%'");

if ($selected_id != -1)
{

 	if ($Mode == 'Edit') {
		$myrow = get_work_plan($selected_id);

		$_POST['pdate']  = sql2date($myrow["tran_date"]);
		$_POST['stock_id']  = $myrow["item"];
		$_POST['ptarget_qty']  = $myrow["target_qty"];
				$_POST['porder_qty']  = $myrow["order_qty"];
				$_POST['status']  = $myrow["status"];

	}
	hidden('selected_id', $selected_id);
} 


date_row(_("Date:"), 'pdate',null,null,0,0,0,'colspan=3');
start_row();
// stock_costable_items_list_cells(_("Item:"), 'item_code', $_POST['item_code']);
		stock_costable_items_list_cells(_("Item:"), 'stock_id', $_POST['stock_id']);

end_row();
amount_row(_("Target Qty (Pcs)").':', 'ptarget_qty', null, 'colspan=2', null, 4);
amount_row(_("Order Qty (Pcs)").':', 'porder_qty', null, 'colspan=2', null, 4);

number_list_array_row(_("Status"), 'status', $_POST['status'], 0, 2, false,array('Start', 'Continue', 'Order Complete'));
// check_row(_("Tax included").':', 'tax_included', $_POST['tax_included']);

end_table(1);

submit_add_or_update_center($selected_id == -1, '', 'both');




div_end();
end_form();
end_page();

