<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
    Released under the terms of the GNU General Public License, GPL, 
    as published by the Free Software Foundation, either version 3 
    of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_WORKORDERENTRY';
$path_to_root = "..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/ui/items_cart.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/inventory/includes/inventory_db.inc");
include_once($path_to_root . "/gl/includes/db/gl_journal.inc");
include_once($path_to_root . "/manufacturing/includes/manufacturing_db.inc");
include_once($path_to_root . "/manufacturing/includes/manufacturing_ui.inc");

$js = "";
if ($SysPrefs->use_popup_windows)
    $js .= get_js_open_window(900, 500);
if (user_use_date_picker())
    $js .= get_js_date_picker();
page(_($help_context = "Job Order Entry"), false, false, "", $js);


check_db_has_manufacturable_items(_("There are no manufacturable items defined in the system."));

check_db_has_locations(("There are no inventory locations defined in the system."));

//---------------------------------------------------------------------------------------

if (isset($_GET['job_order_id'])) {
    $job_id = $_GET['job_order_id'];
    hidden('job_order_id', $job_id);
}
$jobId = $job_id ? $job_id : $_POST['job_order_id'];
//---------------------------------------------------------------------------------------

if (isset($_GET['AddedID']))
{
    $id = $_GET['AddedID'];
    $stype = ST_WORKORDER;

    display_notification_centered(_("The job order been added."));

    display_note(get_trans_view_str($stype, $id, _("View this Job Order")), 0, 0);
    hyperlink_no_params("", _("Enter a new job order"));
    hyperlink_no_params($path_to_root."/inventory/inquiry/joborder_inquiry.php", _("JobOrder Inquiry"));
    display_footer_exit();
}

//---------------------------------------------------------------------------------------

if (isset($_GET['UpdatedID']))
{
    $id = $_GET['UpdatedID'];

    display_notification_centered(_("The job order been updated."));
    safe_exit();
}

//---------------------------------------------------------------------------------------

function safe_exit()
{
    global $path_to_root;

    hyperlink_no_params("", _("Enter a new job order"));
    hyperlink_no_params("search_work_orders.php", _("Select an existing job order"));
    
    display_footer_exit();
}

//-------------------------------------------------------------------------------------
if (!isset($_POST['date_']))
{
    $_POST['date_'] = new_doc_date();
    if (!is_date_in_fiscalyear($_POST['date_']))
        $_POST['date_'] = end_fiscalyear();
}

function can_process()
{
    global $selected_id, $SysPrefs;

    
    if (!check_reference($_POST['reference'], ST_WORKORDER))
    {
        set_focus('reference');
        return false;
    }

    if (!check_num('quantity', 0.1))
    {
        display_error( _("The quantity entered is invalid or less than zero."));
        set_focus('quantity');
        return false;
    }
  
    if (!is_date($_POST['date_']))
    {
        display_error( _("The date entered is in an invalid format."));
        set_focus('date_');
        return false;
    }
    elseif (!is_date_in_fiscalyear($_POST['date_']))
    {
        display_error(_("The entered date is out of fiscal year or is closed for further data entry."));
        set_focus('date_');
        return false;
    }

    return true;
}

//-------------------------------------------------------------------------------------
if (isset($_POST['ADD_ITEM']) && can_process())
{
    if (!$jobId) {
        $id = add_job_order($_POST['reference'], $_POST['location'], input_num('quantity'),
            $_POST['stock_id'], $_POST['date_'], $_POST['memo_']);
    }
    $adj_id = get_next_trans_no(ST_INVADJUST);
    $result2 = get_job_order($jobId);
    if($jobId){
        $trans_no = add_stock_adjustment_item($adj_id, $result2['stock_id'], $result2['location'], sql2date($result2['date_']), $_POST['reference'], input_num('quantity'), (abs($_POST['consumption_total'])/$result2['qty']), $_POST['memo_'], $_POST['batch_no'], Today(), 0);
    }

    new_doc_date($_POST['date_']);
    meta_forward($_SERVER['PHP_SELF'], "AddedID=$id&type=".ST_WORKORDER);
}

//-------------------------------------------------------------------------------------

// if (isset($_POST['UPDATE_ITEM']) && can_process())
// {

//     update_work_order($selected_id, $_POST['location'], input_num('quantity'),
//         $_POST['stock_id'],  $_POST['date_'], $_POST['RequDate'], $_POST['memo_']);
//     new_doc_date($_POST['date_']);
//     meta_forward($_SERVER['PHP_SELF'], "UpdatedID=$selected_id");
// }

//-------------------------------------------------------------------------------------
if (get_post('_type_update')) 
{
  $Ajax->activate('_page_body');
}
//-------------------------------------------------------------------------------------

start_form();
$result = get_wo_consumption($jobId, ST_WORKORDER);
display_heading("Consumption Item");
start_table(TABLESTYLE, "width='30%'");
$th = array(_("Item Code"), _("Description"), _("Quantity"), _("Units"), _("Unit Cost"),
    _("Line Total"));
table_header($th);
while ($data2 = db_fetch($result)) {
    $cunsumption_items = get_stock_cunsumption_items($data2['comsump_no']);
    while ($data = db_fetch($cunsumption_items)) {
        alt_table_row_color($k);

        label_cell($data['stock_id'], "align='center'");
        label_cell($data['description'], "align='center'");
        qty_cell(abs($data['qty']), false, get_qty_dec($data['stock_id']));
        label_cell($data['units'], "align='center'");
        amount_decimal_cell(abs($data['standard_cost']));
        amount_decimal_cell(abs($data['qty'])*$data['standard_cost'], "align='center'");
        $display_sub_tot += $data['qty']*$data['standard_cost'];
        hidden('consumption_total', $display_sub_tot);
    }

}
 label_row(_("Total"), number_format2(abs($display_sub_tot)), "align=right colspan=5",
"nowrap align=right", 1);
end_table();
br(2);

start_table(TABLESTYLE2);

ref_row(_("Reference:"), 'reference', '', $Refs->get_next(ST_WORKORDER, null, get_post('date_')), false, ST_WORKORDER);
$row = get_job_order($jobId);
if($jobId){
    $_POST['stock_id'] = $row['stock_id'];
    $_POST['quantity'] = $row['qty'];
    $_POST['batch_no'] = $_POST['reference'];
}
stock_manufactured_items_list_row(_("Item:"), 'stock_id', null, false, true);
date_row(_("Date") . ":", 'date_', '', true);
if($jobId)
text_row(_("Batch No:"), 'batch_no', null, 20, 20, null, "", "", true); 
else
hidden('batch_no' , 0);
locations_list_row(_("Location:"), 'location', null);
$readonly = $jobId ? 'readonly' : '';
qty_row(_("Quantity:"), 'quantity', null, null, null, $dec, true, $readonly);

if (list_updated('stock_id'))
    $Ajax->activate('quantity');
if(get_post('quantity'))
{
    global $Ajax;

    $Ajax->activate('_page_body');

}

textarea_row(_("Memo:"), 'memo_', null, 40, 5);
end_table(1);

// if (isset($selected_id))
// {
//     echo "<table align=center><tr>";

//     submit_cells('UPDATE_ITEM', _("Update"), '', _('Save changes to job order'), 'default');
//     if (get_post('released'))
//     {
//         submit_cells('close', _("Close This job order"),'','',true);
//     }
//     submit_cells('delete', _("Delete This job order"),'','',true);

//     echo "</tr></table>";
// }
// else
// {
// }
if($jobId)
    submit_center('ADD_ITEM', _("Produce"), true, '', 'default');    
else
    submit_center('ADD_ITEM', _("Add Workorder"), true, '', 'default');

end_form();
end_page();

