<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_WORKORDERENTRY';
$path_to_root = "../..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/manufacturing/includes/manufacturing_db.inc");
include_once($path_to_root . "/manufacturing/includes/manufacturing_ui.inc");
include_once($path_to_root . "/inventory/includes/inventory_db.inc");

$js = "";
if ($SysPrefs->use_popup_windows)
	$js .= get_js_open_window(800, 500);
page(_($help_context = "View Job Order"), true, false, "", $js);

//-------------------------------------------------------------------------------------------------
$poid = 0;
if ($_GET['trans_no'] != "")
{
	$poid = $_GET['trans_no'];
}

display_heading(_("Job Order") . " # " . $poid);

$myrow = get_job_order($poid);
br(1);
start_table(TABLESTYLE2, "width='90%'");
start_row();
label_cells(_("Reference"), $myrow['reference'], "class='tableheader2'");
$item_name = get_item($myrow['stock_id']);
label_cells(_("Item"), $myrow['stock_id'] .' - '. $item_name['description'], "class='tableheader2'");
label_cells(_("Date"), sql2date($myrow['date_']), "class='tableheader2'");
$location_name =  get_item_location($myrow['location']);
label_cells(_("Location"), $location_name['location_name'], "class='tableheader2'", "colspan=6");
label_cells(_("Quantity"), $myrow['qty'], "class='tableheader2'", "colspan=6");
end_row();
comments_display_row(ST_WORKORDER, $poid);
end_table();

br(2);

$result = get_wo_consumption($poid, ST_WORKORDER);
display_heading("Consumption Item");
start_table(TABLESTYLE, "width='30%'");
$th = array(_("Item Code"), _("Description"), _("Quantity"), _("Units"), _("Unit Cost"),
    _("Line Total"));
table_header($th);
while ($data2 = db_fetch($result)) {
    $cunsumption_items = get_stock_cunsumption_items($data2['comsump_no']);
    while ($data = db_fetch($cunsumption_items)) {
        alt_table_row_color($k);
        
        label_cell($data['stock_id'], "align='center'");
        label_cell($data['description'], "align='center'");
        qty_cell(abs($data['qty']), false, get_qty_dec($data['stock_id']));
        label_cell($data['units'], "align='center'");
        amount_decimal_cell(abs($data['standard_cost']));
        amount_decimal_cell(abs($data['qty'])*$data['standard_cost'], "align='center'");
        $display_sub_tot += $data['qty']*$data['standard_cost'];
    }

}
 label_row(_("Total"), number_format2(abs($display_sub_tot)), "align=right colspan=5",
"nowrap align=right", 1);
end_table();

is_voided_display(ST_WORKORDER, $poid, _("This work order has been voided."));
end_page(true, false, false, ST_WORKORDER, $poid);