<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_ITEMSTRANSVIEW';
$path_to_root = "../..";

include($path_to_root . "/includes/session.inc");

page(_($help_context = "View Inventory Cunsumption"), true);

include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/ui.inc");
include_once($path_to_root . "/inventory/includes/inventory_db.inc");

if (isset($_GET["trans_no"]))
{
	$trans_no = $_GET["trans_no"];
}

display_heading($systypes_array[ST_CUNSUMPTION] . " #$trans_no");

br(1);
$cunsumption_items = get_stock_cunsumption_items($trans_no);
$k = 0;
$header_shown = false;
$kv_batch = get_company_pref('kv_batch');
$kv_exp_date = get_company_pref('kv_exp_date');

while ($cunsumption = db_fetch($cunsumption_items)){
	if (!$header_shown)	{

		start_table(TABLESTYLE2, "width='90%'");
		start_row();
		label_cells(_("At Location"), $cunsumption['location_name'], "class='tableheader2'");
    	label_cells(_("Reference"), $cunsumption['reference'], "class='tableheader2'", "colspan=6");
		label_cells(_("Date"), sql2date($cunsumption['tran_date']), "class='tableheader2'");
		end_row();
		comments_display_row(ST_CUNSUMPTION, $trans_no);

		end_table();
		$header_shown = true;

		echo "<br>";
		start_table(TABLESTYLE, "width='90%'");

    	$th = array(_("Item Code"), _("Description"), _("Consume Qty"), _("Quantity"),		_("Units"), _("Unit Cost")); //, _("Wastage Qty")
		if($kv_exp_date){
			array_splice( $th, 2, 0, _("Batch No") );
			array_splice( $th, 3, 0, _("Exp Date") );
		}elseif($kv_batch){
			array_splice( $th, 2, 0, _("Batch No") );			
		}	
    	table_header($th);
	}

    alt_table_row_color($k);

    label_cell($cunsumption['stock_id']);
    label_cell($cunsumption['description']);
	if($kv_exp_date){
		label_cell($cunsumption['batch_no']);
		label_cell(sql2date($cunsumption['exp_date']));
	} elseif($kv_batch)
		label_cell($cunsumption['batch_no']);
    // qty_cell($cunsumption['wastage_qty'] ? $cunsumption['wastage_qty'] : '-', false, get_qty_dec($cunsumption['stock_id']));
    qty_cell($cunsumption['consume_qty'] ? $cunsumption['consume_qty'] : '-', false, get_qty_dec($cunsumption['stock_id']));
    qty_cell($cunsumption['qty'], false, get_qty_dec($cunsumption['stock_id']));
    label_cell($cunsumption['units']);
    amount_decimal_cell($cunsumption['standard_cost']);
    end_row();
}

end_table(1);

is_voided_display(ST_CUNSUMPTION, $trans_no, _("This cunsumption has been voided."));

end_page(true, false, false, ST_CUNSUMPTION, $trans_no);
