<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_FILE_SYSTEM';
$path_to_root = "../..";
include($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/purchasing/includes/db/file_system_db.inc");

page(_($help_context = "File System"));
include($path_to_root . "/includes/ui.inc");

simple_page_mode(true);

if(isset($_GET['ModifyFileSystemEntry'])){
$selected_id = $_GET['ModifyFileSystemEntry'];
}


if ($Mode=='ADD_ITEM' || $Mode=='UPDATE_ITEM') 
{

	$input_error = 0;

	if (strlen($_POST['name']) == 0) 
	{
		$input_error = 1;
		display_error(_("The name cannot be empty."));
		set_focus('name');
	}

	if ($input_error != 1)
	{
    	if ($selected_id != -1) 
    	{
    		update_file_system($selected_id, $_POST['date_'], $_POST['reference'], $_POST['name'], $_POST['description']);
			$note = _('Selected file system has been updated');
    	} 
    	else 
    	{
    		add_file_system($_POST['date_'], $_POST['reference'], $_POST['name'], $_POST['description']);
			$note = _('New file system has been added');
    	}
    
		display_notification($note);    	
		$Mode = 'RESET';
	}
}

//----------------------------------------------------------------------------------

if ($Mode == 'Delete')
{

	// PREVENT DELETES IF DEPENDENT RECORDS IN 'stock_master'

	// if (item_unit_used($selected_id))
	// {
	// 	display_error(_("Cannot delete this unit of measure because items have been created using this unit."));

	// }
	// else
	// {
		delete_file_system($selected_id);
		display_notification(_('Selected file system has been deleted'));
	// }
	$Mode = 'RESET';
}

if ($Mode == 'RESET')
{
	$selected_id = -1;
	$sav = get_post('show_inactive');
	unset($_POST);
	$_POST['show_inactive'] = $sav;
}

//----------------------------------------------------------------------------------

$result = get_file_systems(check_value('show_inactive'));

start_form();
start_table(TABLESTYLE, "width='40%'");
$th = array(_('Date'), _('Reference'), _('Name'), _('Description'), "", "");
inactive_control_column($th);

table_header($th);
$k = 0; //row colour counter

while ($myrow = db_fetch($result))
{

	alt_table_row_color($k);
	label_cell(sql2date($myrow["date_"]));
	label_cell($myrow["reference"]);	
	label_cell($myrow["name"]);
	label_cell($myrow["description"]);
	inactive_control_cell($myrow["id"], $myrow["inactive"], 'file_system', 'id');
 	edit_button_cell("Edit".$myrow["id"], _("Edit"));
 	delete_button_cell("Delete".$myrow["id"], _("Delete"));
	end_row();
}

inactive_control_row($th);
end_table(1);

//----------------------------------------------------------------------------------

start_table(TABLESTYLE2);

if ($selected_id != -1) 
{
 	// if ($Mode == 'Edit') {
		//editing an existing item category

	$myrow = get_file_system($selected_id);

	$_POST['date_'] = sql2date($myrow["name"]);
	$_POST['reference'] = $myrow["reference"];
	$_POST['name'] = $myrow["name"];
	$_POST['description'] = $myrow["description"];
	// }
	hidden('selected_id', $myrow["id"]);
}

date_row(_("Date") . ":", 'date_');
ref_row(_("Reference:"), 'reference', '', null, false, ST_FILE_SYSTEM, array('date'=> @$_POST['date_']));
text_row(_("Name:"), 'name', null, 30, 70);
textarea_row(_("Description:"), 'description', null, 30, 8);


end_table(1);
submit_add_or_update_center($selected_id == -1, '', 'both');

end_form();

end_page();

