<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_SUPPLIERPAYMNT';
$path_to_root = "..";
include_once($path_to_root . "/includes/ui/allocation_cart.inc");
include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/ui.inc");
include_once($path_to_root . "/includes/banking.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/purchasing/includes/purchasing_db.inc");
include_once($path_to_root . "/reporting/includes/reporting.inc");
include_once($path_to_root . "/gl/includes/db/day_limit_db.inc");

$js = "";
if ($SysPrefs->use_popup_windows)
	$js .= get_js_open_window(900, 500);
if (user_use_date_picker())
	$js .= get_js_date_picker();

add_js_file('payalloc.js');

page(_($help_context = "Supplier Payment Entry"), false, false, "", $js);

if (isset($_GET['supplier_id']))
{
	$_POST['supplier_id'] = $_GET['supplier_id'];
}

if (isset($_GET['post_check_trans_no'])) {
	$_POST['post_check_trans_no'] = $_GET['post_check_trans_no'];
}

//----------------------------------------------------------------------------------------

check_db_has_suppliers(_("There are no suppliers defined in the system."));

check_db_has_bank_accounts(_("There are no bank accounts defined in the system."));

//----------------------------------------------------------------------------------------

if (!isset($_POST['supplier_id']))
	$_POST['supplier_id'] = get_global_supplier(false);

if (!isset($_POST['DatePaid']))
{
	$_POST['DatePaid'] = new_doc_date();
	if (!is_date_in_fiscalyear($_POST['DatePaid']))
		$_POST['DatePaid'] = end_fiscalyear();
}

if (isset($_POST['_DatePaid_changed'])) {
  $Ajax->activate('_ex_rate');
}

//----------------------------------------------------------------------------------------

if (!isset($_POST['bank_account'])) { // first page call
	$_SESSION['alloc'] = new allocation(ST_SUPPAYMENT, 0, get_post('supplier_id'));

	if (isset($_GET['PInvoice'])) {
		$supp = isset($_POST['supplier_id']) ? $_POST['supplier_id'] : null;
		//  get date and supplier
		$inv = get_supp_trans($_GET['PInvoice'], $_GET['trans_type'], $supp);
		if ($inv) {
			$_SESSION['alloc']->person_id = $_POST['supplier_id'] = $inv['supplier_id'];
			$_SESSION['alloc']->read();
			$_POST['DatePaid'] = sql2date($inv['tran_date']);
			$_POST['memo_'] = $inv['supp_reference'];
			foreach($_SESSION['alloc']->allocs as $line => $trans) {
				if ($trans->type == $_GET['trans_type'] && $trans->type_no == $_GET['PInvoice']) {
					$un_allocated = abs($trans->amount) - $trans->amount_allocated;
					$_SESSION['alloc']->amount = $_SESSION['alloc']->allocs[$line]->current_allocated = $un_allocated;
					$_POST['amount'] = $_POST['amount'.$line] = price_format($un_allocated);
					break;
				}
			}
			unset($inv);
		} else
			display_error(_("Invalid purchase invoice number."));
	}
}

if($_POST['post_check_trans_no'])
	$_SESSION['alloc']->post_check_trans_no=$_POST['post_check_trans_no'];

// trans  no is use for post date cheque data ..!!!!
if($_SESSION['alloc']->post_check_trans_no)
{

	$post_date_trans = get_post_date_trans($_SESSION['alloc']->post_check_trans_no);

		$_POST['supplier_id'] = $post_date_trans['person_id'];
		$_POST['bank_account'] = $post_date_trans['bank_id'];
		$_POST['DatePaid'] = sql2date($post_date_trans['date_']);
		$_POST['charge'] = $post_date_trans['charge'];
		$_POST['dimension_id'] = $post_date_trans['dimension_id'];
		$_POST['dimension2_id'] = $post_date_trans['dimension2_id'];
		$_POST['is_check_no'] = $post_date_trans['is_cheque_no'];
		$_POST['cheque_no'] = $post_date_trans['cheque_no'];
		$_POST['memo_'] = $post_date_trans['comments'];
		// $_POST['amount'] = $post_date_trans['amount'];
		
	

	$result = get_post_date_trans_details($_SESSION['alloc']->post_check_trans_no);
	while ($myrow = db_fetch($result)) {
            foreach($_SESSION['alloc']->allocs as $line => $trans) {
// display_error($trans->type ."==". $myrow['invocie_type']."  =".$line);
			if ($trans->type == $myrow['invocie_type'] && $trans->type_no == $myrow['invocie_trans_no']) {
					$_POST['amount'.$line] = $trans->current_allocated=$myrow['amount'];
					// $_SESSION['alloc']->amount = $_SESSION['alloc']->allocs[$line]->current_allocated = $un_allocated;
					// $_POST['amount'] = $_POST['amount'.$line] = price_format($un_allocated);
					// break;
				$amt+=$myrow['amount'];
				}
			}
		
	 }

	 			$_POST['amount'] = $amt;
		
}

if (isset($_GET['AddedID'])) {
	$payment_id = $_GET['AddedID'];

   	display_notification_centered( _("Payment has been sucessfully entered"));

	submenu_print(_("&Print This Remittance"), ST_SUPPAYMENT, $payment_id."-".ST_SUPPAYMENT, 'prtopt');
	submenu_print(_("&Print This Voucher"), ST_SUPPAYMENT_NEW, $payment_id."-".ST_SUPPAYMENT, 'prtopt');
	submenu_print(_("&Email This Remittance"), ST_SUPPAYMENT, $payment_id."-".ST_SUPPAYMENT, null, 1);

	submenu_view(_("View this Payment"), ST_SUPPAYMENT, $payment_id);
    display_note(get_gl_view_str(ST_SUPPAYMENT, $payment_id, _("View the GL &Journal Entries for this Payment")), 0, 1);

	submenu_option(_("Enter another supplier &payment"), "/purchasing/supplier_payment.php?supplier_id=".$_POST['supplier_id']);
	submenu_option(_("Enter Other &Payment"), "/gl/gl_bank.php?NewPayment=Yes");
	submenu_option(_("Enter &Customer Payment"), "/sales/customer_payments.php");
	submenu_option(_("Enter Other &Deposit"), "/gl/gl_bank.php?NewDeposit=Yes");
	submenu_option(_("Bank Account &Transfer"), "/gl/bank_transfer.php");

	display_footer_exit();
}


if (isset($_GET['AddedPOD'])) {
	$trans_no = $_GET['AddedPOD'];

 	// display_notification_centered( _("Payment has been sucessfully entered"));
	// submenu_print(_("&Print This Remittance"), ST_SUPPAYMENT, $payment_id."-".ST_SUPPAYMENT, 'prtopt');
	// submenu_print(_("&Email This Remittance"), ST_SUPPAYMENT, $payment_id."-".ST_SUPPAYMENT, null, 1);
	// submenu_view(_("View this Payment"), ST_SUPPAYMENT, $payment_id);
  //   display_note(get_gl_view_str(ST_SUPPAYMENT, $payment_id, _("View the GL &Journal Entries for this Payment")), 0, 1);

	hyperlink_params("$path_to_root/gl/view/gl_post_date_trans_view.php", _("View Post Date Trans"), "supp_pay=$trans_no");
	hyperlink_params($_SERVER['PHP_SELF'], _("Enter Another &Payment"), "New=1");
	hyperlink_params("$path_to_root/gl/inquiry/post_date_inquiry.php", 
		_("Post Date Trans Inquiry"), null);

	// submenu_option(_("Enter Other &Payment"), "/gl/gl_bank.php?NewPayment=Yes");
	// submenu_option(_("Enter &Customer Payment"), "/sales/customer_payments.php");
	// submenu_option(_("Enter Other &Deposit"), "/gl/gl_bank.php?NewDeposit=Yes");
	// submenu_option(_("Bank Account &Transfer"), "/gl/bank_transfer.php");

	display_footer_exit();
}


//----------------------------------------------------------------------------------------

function get_default_supplier_payment_bank_account($supplier_id, $date)
{
	$previous_payment = get_supp_payment_before($supplier_id, date2sql($date));
	if ($previous_payment)
	{
		return $previous_payment['bank_id'];
	}
	return get_default_supplier_bank_account($supplier_id);
}
//----------------------------------------------------------------------------------------

function check_inputs()
{
	global $Refs;

	if (!get_post('supplier_id')) 
	{
		display_error(_("There is no supplier selected."));
		set_focus('supplier_id');
		return false;
	} 
	
	if (@$_POST['amount'] == "") 
	{
		$_POST['amount'] = price_format(0);
	}

	if (!check_num('amount', 0))
	{
		display_error(_("The entered amount is invalid or less than zero."));
		set_focus('amount');
		return false;
	}

	if (isset($_POST['charge']) && !check_num('charge', 0)) {
		display_error(_("The entered amount is invalid or less than zero."));
		set_focus('charge');
		return false;
	}

	if (isset($_POST['charge']) && input_num('charge') > 0) {
		$charge_acct = get_bank_charge_account($_POST['bank_account']);
		if (get_gl_account($charge_acct) == false) {
			display_error(_("The Bank Charge Account has not been set in System and General GL Setup."));
			set_focus('charge');
			return false;
		}	
	}

	if (@$_POST['discount'] == "") 
	{
		$_POST['discount'] = 0;
	}

	if (!check_num('discount', 0))
	{
		display_error(_("The entered discount is invalid or less than zero."));
		set_focus('amount');
		return false;
	}

	//if (input_num('amount') - input_num('discount') <= 0) 
	if (input_num('amount') <= 0) 
	{
		display_error(_("The total of the amount and the discount is zero or negative. Please enter positive values."));
		set_focus('amount');
		return false;
	}

	if (isset($_POST['bank_amount']) && input_num('bank_amount')<=0)
	{
		display_error(_("The entered bank amount is zero or negative."));
		set_focus('bank_amount');
		return false;
	}


   	if (!is_date($_POST['DatePaid']))
   	{
		display_error(_("The entered date is invalid."));
		set_focus('DatePaid');
		return false;
	} 
	elseif (!is_date_in_fiscalyear($_POST['DatePaid'])) 
	{
		display_error(_("The entered date is out of fiscal year or is closed for further data entry."));
		set_focus('DatePaid');
		return false;
	}

	$limit = get_bank_account_limit($_POST['bank_account'], $_POST['DatePaid']);

	if (($limit !== null) && (floatcmp($limit, input_num('amount')) < 0))
	{
		display_error(sprintf(_("The total bank amount exceeds allowed limit (%s)."), price_format($limit)));
		set_focus('amount');
		return false;
	}

	if (!check_reference($_POST['ref'], ST_SUPPAYMENT))
	{
		set_focus('ref');
		return false;
	}

	$all_payment = get_all_payments($_POST['bank_account'], ST_SUPPAYMENT);
	$day_limit_amt = get_day_limit_amt($_POST['bank_account']);
	if ($day_limit_amt['day_limit_amt'] > 0) {
		$sum_amt = input_num('amount')+abs($all_payment['amount']);
		if ($sum_amt > $day_limit_amt['day_limit_amt']) {
			display_error("Do not exceed the daily limit amount. ". number_format2(abs($day_limit_amt['day_limit_amt'])));
			set_focus('amount');
			return false;
		}
	}


	if (!db_has_currency_rates(get_supplier_currency($_POST['supplier_id']), $_POST['DatePaid'], true))
		return false;

	$_SESSION['alloc']->amount = -input_num('amount');

	if (isset($_POST["TotalNumberOfAllocs"]))
		return check_allocations();
	else
		return true;
}

//----------------------------------------------------------------------------------------

function handle_add_payment()
{
	begin_transaction();
	if ($_POST['is_check_no'] == 1 && !$_SESSION['alloc']->post_check_trans_no) {
		$sql = "INSERT INTO ".TB_PREF."post_cheque_trans (type, date_, pay_to,
			person_id, bank_id, is_cheque_no, cheque_no, post_date, comments, dimension_id, dimension2_id,
			charge,total_amount)";

	$sql .= "VALUES (".db_escape(ST_SUPPAYMENT).",'". date2sql($_POST['DatePaid'])."', '0', 
	 ".db_escape($_POST['supplier_id']).", ".db_escape($_POST['bank_account']).", 
	 ".db_escape(input_num('is_check_no')).",  ".db_escape($_POST['cheque_no']).", 
	 '".date2sql($_POST['post_date'])."', ".db_escape($_POST['memo_']).", 
	 ".db_escape($_POST['dimension_id']).",".db_escape($_POST['dimension2_id']).",
		 ".db_escape(input_num('charge')).", ".db_escape(input_num('amount')).")";
	 // display_error($sql);
	 db_query($sql, "can't insert batch expiry date option");
	 $trans_no = db_insert_id();

	 	$dec = user_price_dec();
	 	foreach ($_SESSION['alloc']->allocs as $alloc_item)
		{
			if ($alloc_item->current_allocated > 0)
			{
				$amount = round($alloc_item->current_allocated, $dec);

				$sql = "INSERT INTO ".TB_PREF."post_trans_detail (type, trans_no,
						account, dimension_id, dimension2_id, memo_, amount, invocie_type, invocie_trans_no";
					$sql .= ") ";
					$sql .= "VALUES (".db_escape(ST_SUPPAYMENT).", ".db_escape($trans_no).",
						'0', '0', '0', 'Supplier Payment', ".db_escape($amount).", 
						".db_escape($alloc_item->type).", ".db_escape($alloc_item->type_no)."";
					$sql .= ") ";
					// display_error($sql);
					db_query($sql);
			}
		}			 
	commit_transaction();   	 	
  meta_forward($_SERVER['PHP_SELF'], "AddedPOD=".$trans_no);
	}else{
	$payment_id = write_supp_payment(0, $_POST['supplier_id'], $_POST['bank_account'],
		$_POST['DatePaid'], $_POST['ref'], input_num('amount'),	input_num('discount'), $_POST['memo_'], 
		input_num('charge'), input_num('bank_amount', input_num('amount')), $_POST['dimension_id'], 
		$_POST['dimension2_id'],input_num('whtax'), input_num('is_check_no'), $_POST['cheque_no'], input_num('file_system'));
	new_doc_date($_POST['DatePaid']);

	$_SESSION['alloc']->trans_no = $payment_id;
	$_SESSION['alloc']->date_ = $_POST['DatePaid'];
	$_SESSION['alloc']->write();
    if($_SESSION['alloc']->post_check_trans_no)
    {
    	 $sql = "UPDATE ".TB_PREF."post_cheque_trans SET is_posted_status=1 WHERE 
			     trans_no=".db_escape($_SESSION['alloc']->post_check_trans_no);
   		 db_query($sql,"The post_cheque_trans could not be updated");
   		 // display_error($sql);
    }
	commit_transaction();
	}

   	unset($_POST['bank_account']);
   	unset($_POST['DatePaid']);
   	unset($_POST['currency']);
   	unset($_POST['memo_']);
   	unset($_POST['amount']);
   	unset($_POST['discount']);
   	unset($_POST['ProcessSuppPayment']);
	meta_forward($_SERVER['PHP_SELF'], "AddedID=$payment_id&supplier_id=".$_POST['supplier_id']);
}


// print_r($_SESSION['alloc']);
//----------------------------------------------------------------------------------------

if (isset($_POST['ProcessSuppPayment']))
{
	 /*First off  check for valid inputs */
    if (check_inputs() == true) 
    {
    	handle_add_payment();
    	end_page();
     	exit;
    }
}

//----------------------------------------------------------------------------------------

start_form();

	start_outer_table(TABLESTYLE2, "width='60%'", 5);

	table_section(1);

    supplier_list_row(_("Payment To:"), 'supplier_id', null, false, true);

	if (list_updated('supplier_id')) {
		$_POST['amount'] = price_format(0);
		$_SESSION['alloc']->person_id = get_post('supplier_id');
		$Ajax->activate('amount');
	} elseif (list_updated('bank_account'))
		$Ajax->activate('alloc_tbl');

	if (list_updated('supplier_id') || list_updated('bank_account')) {
	  $_SESSION['alloc']->read();
	  $_POST['memo_'] = $_POST['amount'] = '';
	  $Ajax->activate('alloc_tbl');
	}

	set_global_supplier($_POST['supplier_id']);

	if (!list_updated('bank_account') && !get_post('__ex_rate_changed') && !$_SESSION['alloc']->post_check_trans_no)
	{
		$_POST['bank_account'] = get_default_supplier_payment_bank_account($_POST['supplier_id'], $_POST['DatePaid']);
	} else
	{
		$_POST['amount'] = price_format(0);
	}

    bank_accounts_list_row(_("From Bank Account:"), 'bank_account', null, true);

	bank_balance_row($_POST['bank_account']);

	table_section(2);

    date_row(_("Date Paid") . ":", 'DatePaid', '', true, 0, 0, 0, null, true);

    ref_row(_("Reference:"), 'ref', '', $Refs->get_next(ST_SUPPAYMENT, null, 
    	array('supplier'=>get_post('supplier_id'), 'date'=>get_post('DatePaid'))), false, ST_SUPPAYMENT);


	table_section(3);

	$comp_currency = get_company_currency();
	$supplier_currency = $_SESSION['alloc']->set_person($_POST['supplier_id'], PT_SUPPLIER);
	if (!$supplier_currency)
			$supplier_currency = $comp_currency;
	$_SESSION['alloc']->currency = $bank_currency = get_bank_account_currency($_POST['bank_account']);

	if ($bank_currency != $supplier_currency) 
	{
		amount_row(_("Bank Amount:"), 'bank_amount', null, '', $bank_currency);
	}

	amount_row(_("Bank Charge:"), 'charge', null, '', $bank_currency);

	$row = get_supplier($_POST['supplier_id']);
	if(!$_POST['dimension_id'])
	$_POST['dimension_id'] = @$row['dimension_id'];
 if(!$_POST['dimension2_id'])
	$_POST['dimension2_id'] = @$row['dimension2_id'];

	$dim = get_company_pref('use_dimension');
	if ($dim > 0)
		dimensions_list_row(_($SysPrefs->prefs['dim1_name']), 'dimension_id',
			$_POST['dimension_id'], true, ' ', false, 1, false);
	else
		hidden('dimension_id', 0);
	if ($dim > 1)
		dimensions_list_row(_($SysPrefs->prefs['dim2_name']), 'dimension2_id',
			$_POST['dimension2_id'], true, ' ', false, 2, false);
	else
		hidden('dimension2_id', 0);

   
    
   $bank_row = get_bank_account($_POST['bank_account']);

    // display_error($bank_row['account_type']." == ".BT_CREDIT);
   if($bank_row['account_type']==BT_CREDIT)
   {
		global $Ajax,$path_to_root;
		include_once($path_to_root . "/gl/includes/db/cancel_cheque_db.inc");
		bank_serial_row(_("Cheque No:"), 'cheque_no', null , true, $_POST['bank_account']);

	  $Ajax->activate('_page_body');
    
   }

	check_row(_("Post Dated:"), 'is_check_no', $_POST['is_check_no'],
	true, _('Set this option to issue payment with cheque No.'));

// 	if($_POST['is_check_no'])
// 	{
//       	 $Ajax->activate('_page_body');
//           ref_row(_("Cheque No:"), 'cheque_no', '', $_POST['cheque_no'], false, ST_CHEQUE_NO, get_post('date_'));
// 	}else
	$Ajax->activate('_page_body');
	if($_POST['is_check_no'])
    date_row(_("Post Date:"), 'post_date', '', true, 0, 0, 0, $_POST['post_date'], true);

	end_outer_table(1);
	div_start('alloc_tbl');
	show_allocatable(false);
	div_end();

	start_table(TABLESTYLE, "width='60%'");
	amount_row(_("Amount of Discount:"), 'discount', null, '', $supplier_currency);
	amount_row(_("W.H.T:"), 'whtax', null, '', $cust_currency);
	amount_row(_("Amount of Payment:"), 'amount', null, '', $supplier_currency,null,false,'readonly');
	textarea_row(_("Memo:"), 'memo_', null, 22, 4);
	end_table(1);

	submit_center('ProcessSuppPayment',_("Enter Payment"), true, '', 'default');

end_form();

end_page();
