<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
    Released under the terms of the GNU General Public License, GPL, 
    as published by the Free Software Foundation, either version 3 
    of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_CREATE_QC';
$path_to_root = "../..";
include($path_to_root . "/purchasing/includes/po_class.inc");

include($path_to_root . "/includes/session.inc");
include($path_to_root . "/purchasing/includes/purchasing_ui.inc");

$js = "";
if ($SysPrefs->use_popup_windows)
    $js .= get_js_open_window(900, 500);
page(_($help_context = "View Purchase Order"), true, false, "", $js);


if (!isset($_GET['trans_no']))
{
    die ("<br>" . _("This page must be called with a purchase order number to review."));
}


start_table(TABLESTYLE, "width='90%'", 6);
echo "<tr><td valign=top>"; // outer table

// display_heading2(_("Line Details"));

if($_GET['type']==ST_WORKORDER)
$res = get_qc_trans($_GET['trans_no'], ST_WORKORDER);
else
$res = get_qc_trans($_GET['trans_no'], ST_SALESORDER);

start_table(TABLESTYLE, "width='100%'");


    start_table(TABLESTYLE, "width='50%'", 6);
    echo "<tr><td valign=top>"; // outer table

    display_heading2(_("QC Details"));

    start_table(TABLESTYLE2, "width='100%'");

    $th = array(_("Label Name"), _("Details"));
    table_header($th);
    while ($myrow = db_fetch($res))
    {
        // print_r($myrow);exit();
        display_po_qc_details($myrow['label_name'],$myrow['qc_type'],$myrow['value'],$myrow['options']);

    }    




end_table();
?>