<?php

	global $SysPrefs,$tax_label;
$tax_label = $_SESSION['SysPrefs']->prefs['tax_label'];

	$Addr1 = array(
			'title' => _("Pay To"),
			'name' => @get_counterparty_name(ST_BANKPAYMENT, $this->formData['document_number']),
			// 'name_arabic' => @$this->formData['br_name_arabic'] ? $this->formData['br_name_arabic'] : get_debtor_name_arabic($this->formData['debtor_no']),
			'address' => @$this->formData['br_address'] ? $this->formData['br_address'] : @$this->formData['address']
	);
	$Addr2 = array(
			'title' => _("Pay From"),
			'name' => @$this->formData['bank_account_name'],
			'address' => @$this->formData['delivery_address']
	);
	// display_error($this->formData['bank_account_name']);

	// default item column headers
	$this->headers = array(_("A/c Code"), _("A/c Description & Narration "), _($SysPrefs->prefs['dim1_name']),
			_($SysPrefs->prefs['dim2_name']),_("Debit"), _("Credit"));

	// for links use 'text' => 'url'
	$Footer[0] = _("All amounts stated in") . " - " . @$this->formData['curr_code'];

	if (!in_array($this->formData['doctype'], array(ST_STATEMENT, ST_WORKORDER)))
	{
		$row = get_payment_terms($this->formData['payment_terms']);
		$Payment_Terms = _("Payment Terms") . ': ' . $row["terms"];
		if ($this->formData['doctype'] == ST_SALESINVOICE && $this->formData['prepaid'])
			$this->formData['prepaid'] = ($row['days_before_due'] >= 0) ? 'final' : 'partial';
	}


	switch ($this->formData['doctype'])
	{
		
		case ST_BANKPAYMENT:

		    if($this->formData['account_type']==3)
			$this->title = _("Cash Payment Voucher");
		   else
		   		$this->title = _("Bank Payment Voucher");
			$this->formData['document_name'] =_("Payment No");
			$Footer[0] = _("Please quote Credit no. when paying. All amounts stated in") . " - " . $this->formData['curr_code'];

			$aux_info = array(
				_("Reference") => @$this->formData["ref"],
				_("Sales Person") => get_salesman_name($this->formData['salesman']),
				_("Your ".$tax_label.".") => $this->formData['tax_id'],
				_("Our Order No") => $this->formData['order_'],
				_("Due Date") => '',
			);
			break;


		case ST_BANKDEPOSIT:
		   if($this->formData['account_type']==3)
			$this->title = _("Cash Payment Received");
		  else
		   		$this->title = _("Bank Payment Received");

			$this->formData['document_name'] =_("Deposit No");
			$Footer[0] = _("Please quote Credit no. when paying. All amounts stated in") . " - " . $this->formData['curr_code'];

			$aux_info = array(
				_("Reference") => @$this->formData["ref"],
				_("Sales Person") => get_salesman_name($this->formData['salesman']),
				_("Your ".$tax_label.".") => $this->formData['tax_id'],
				_("Our Order No") => $this->formData['order_'],
				_("Due Date") => '',
			);
			break;	
			
		case ST_CUSTPAYMENT:
		 
		   		$this->title = _("Customer Payment Voucher");

			$this->formData['document_name'] =_("Voucher No");
			$Footer[0] = _("Please quote Credit no. when paying. All amounts stated in") . " - " . $this->formData['curr_code'];
                 $this->formData['person_id']= get_customer_name($this->formData['person_id']);//get_counterparty_name($this->formData['type'], $this->formData['document_number']);
			$aux_info = array(
				_("Reference") => @$this->formData["ref"],
				_("Sales Person") => get_salesman_name($this->formData['salesman']),
				_("Your ".$tax_label.".") => $this->formData['tax_id'],
				_("Our Order No") => $this->formData['order_'],
				_("Due Date") => '',
			);
			break;		

		case ST_SUPPAYMENT:
		 
		   		$this->title = _("Supplier Payment Voucher");

			$this->formData['document_name'] =_("Voucher No");
			$Footer[0] = _("Please quote Credit no. when paying. All amounts stated in") . " - " . $this->formData['curr_code'];
                 $this->formData['person_id']= get_supplier_name($this->formData['person_id']);//get_counterparty_name($this->formData['type'], $this->formData['document_number']);
			$aux_info = array(
				_("Reference") => @$this->formData["ref"],
				_("Sales Person") => get_salesman_name($this->formData['salesman']),
				_("Your ".$tax_label.".") => $this->formData['tax_id'],
				_("Our Order No") => $this->formData['order_'],
				_("Due Date") => '',
			);
			break;	
			
			case ST_BANKPAYMENT_POST_DATED:
		   global $payment_person_types;
		    if($this->formData['account_type']==3)
			$this->title = _("Cash Payment Voucher");
		   else
		   		$this->title = _("Post Date Voucher");
			$this->formData['document_name'] =_("Payment No");

			$this->formData['trans_date']=$this->formData['date_'];
			 $this->formData['ref']= $this->formData['trans_no'];
                 



			if( $this->formData['pay_to']==2)
			$this->formData['person_id']= $payment_person_types[$this->formData['pay_to']]." - ".get_customer_name($this->formData['person_id']);
			elseif($this->formData['pay_to']==3)
			$this->formData['person_id']= $payment_person_types[$this->formData['pay_to']]." - ".get_supplier_name($this->formData['person_id']);
			else
				$this->formData['person_id']=$payment_person_types[$this->formData['pay_to']]." ";
			// $Footer[0] = _("Please quote Credit no. when paying. All amounts stated in") . " - " . $this->formData['curr_code'];
            // print_r($this->formData);exit();

			$aux_info = array(
				_("Reference") => @$this->formData["ref"],
				_("Sales Person") => get_salesman_name($this->formData['salesman']),
				_("Your ".$tax_label.".") => $this->formData['tax_id'],
				_("Our Order No") => $this->formData['order_'],
				_("Due Date") => '',
			);
		break;	
	

		 case ST_BANKTRANSFER:

		    if($this->formData['account_type']==3)
			$this->title = _("Cash Transfer Voucher");
		   else
		   	$this->title = _("Bank Transfer Voucher");
		   
			$this->formData['document_name'] =_("Payment No");
			$Footer[0] = _("Please quote Credit no. when paying. All amounts stated in") . " - " . $this->formData['curr_code'];

			$aux_info = array(
				_("Reference") => @$this->formData["ref"],
				_("Sales Person") => get_salesman_name($this->formData['salesman']),
				_("Your ".$tax_label.".") => $this->formData['tax_id'],
				_("Our Order No") => $this->formData['order_'],
				_("Due Date") => '',
			);
			break;	


		case ST_JOURNAL:

	   		$this->title = _("Journal Voucher");

	   		$this->formData['ref']=$this->formData['reference'];
	   		$this->formData['trans_date']=$this->formData['tran_date'];

			$this->formData['document_name'] =_("Deposit No");
			$Footer[0] = _("Please quote Credit no. when paying. All amounts stated in") . " - " . $this->formData['curr_code'];

			$aux_info = array(
				_("Reference") => @$this->formData["ref"],
				_("Sales Person") => get_salesman_name($this->formData['salesman']),
				_("Your ".$tax_label.".") => $this->formData['tax_id'],
				_("Our Order No") => $this->formData['order_'],
				_("Due Date") => '',
			);
			break;	
			
	}

	// default values
	if (!isset($this->formData['document_date']))
		$this->formData['document_date'] = $this->formData['tran_date'];

	if (!isset($this->formData['document_number']))
		$this->formData['document_number'] = $SysPrefs->print_invoice_no() == 0 && isset($this->formData['reference'])
			? $this->formData['reference'] : @$this->formData['trans_no'];

	// footer generic content
	if (@$this->formData['bank_name'])
		$Footer[] = _("Bank"). ": ".$this->formData['bank_name']. ", " . _("Bank Account") . ": " . $this->formData['bank_account_number'];

	if (@$this->formData['payment_service'])	//payment link
	{
		$amt = number_format($this->formData["ov_freight"] + $this->formData["ov_gst"] + $this->formData["ov_amount"], user_price_dec());
		$service = $this->formData['payment_service'];
		$url = payment_link($service, array(
			'company_email' => $this->company['email'],
			'amount' => $amt,
			'currency' => $this->formData['curr_code'],
			'comment' => $this->title . " " . $this->formData['reference']
			));
		$Footer[_("You can pay through"). " $service: "] = "$url";
	}

	if ($this->formData['doctype'] == ST_CUSTPAYMENT)
 		$Footer[] = _("* Subject to Realisation of the Cheque.");

	if ($this->params['comments'] != '')
		$Footer[] = $this->params['comments'];

	if (($this->formData['doctype'] == ST_SALESINVOICE || $this->formData['doctype'] == ST_STATEMENT) && $this->company['legal_text'] != "") 
	{
		foreach(explode("\n", $this->company['legal_text']) as $line)
			$Footer[] = $line;
	}

	$this->formData['recipient_name'] = $Addr1['name'];
