<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/

/**
	Document blueprint use following parameters set in doctext.inc:

	$Addr1,	$Addr2 - address info
	$Payment_Terms - payment terms line
	$Footer - footer texts
	$this->company - company info
	$this->title - report title
	$this->formData - some other info
***/

		$this->row = $this->pageHeight - $this->topMargin;

		$upper = $this->row - 2 * $this->lineHeight;
		$lower = $this->bottomMargin + 8 * $this->lineHeight;
		$iline1 = $upper - 7.5 * $this->lineHeight;
		$iline2 = $iline1 - 5 * $this->lineHeight;
		$iline3 = $iline2 - 1.5 * $this->lineHeight;
		$iline4 = $iline3 - 1.5 * $this->lineHeight;
		$iline5 = $iline4 - 3 * $this->lineHeight;
		$iline6 = $iline5 - 1.5 * $this->lineHeight;
		$iline7 = $lower;
		$right = $this->pageWidth - $this->rightMargin;
		$width = ($right - $this->leftMargin) / 5;
		$icol = $this->pageWidth / 2;
		$ccol = $this->cols[0] + 4;
		$c2col = $ccol + 60;
		$ccol2 = $icol / 2;
		$mcol = $icol + 8;
		$mcol2 = $this->pageWidth - $ccol2;
		$cols = count($this->cols);
		// $this->SetDrawColor(205, 205, 205);
		// // $this->Line($iline1, 3);
		// $this->SetDrawColor(128, 128, 128);
		// $this->Line($iline1);
		// $this->rectangle($this->leftMargin, $iline2, $right - $this->leftMargin, $iline2 - $iline3, "F", null, array(222, 231, 236));   
		// $this->Line($iline2);
		// $this->Line($iline3);
		// $this->Line($iline4);
		// $this->rectangle($this->leftMargin, $iline5, $right - $this->leftMargin, $iline5 - $iline6, "F", null, array(222, 231, 236)); 
		$this->Line($iline5);
		$this->Line($iline6);
		if($this->formData['doctype'] != 13){
			$this->Line($iline7+150);
			$this->Line($iline7+130);
			$this->Line($iline7+110);
			$this->Line($iline7+90);
		}
		// if(!$this->formData['tot_discount'] && $this->formData['tax_group_id'] == 2 && $this->formData['doctype'] == 13)
		// 	$this->Line($iline7+90);

		// print_r($this->formData['tot_discount'] .'=='. $this->formData['tax_group_id']);exit();

		if($this->formData['doctype'] == 13)
			$this->Line($iline7+70);


		if($this->formData['doctype'] == 10 && $this->formData['tax_group_id'] != 2)
			$this->Line($iline7+70);
		if($this->formData['doctype'] == 10 && $this->formData['tax_group_id'] != 2 && $this->formData['tot_discount'])
			$this->Line($iline7+50);

		if($this->formData['doctype'] == 10 && $this->formData['tax_group_id'] == 2 && $this->formData['tot_discount'])
			$this->Line($iline7+70);

		if($this->formData['tot_discount'] && $this->formData['tax_group_id'] != 2 && $this->formData['doctype'] == 32 && $this->formData['doctype'] != 10){
			$this->Line($iline7+50);
			$this->Line($iline7+70);
		}
		if(!$this->formData['tot_discount'] && $this->formData['tax_group_id'] != 2 && $this->formData['doctype'] != 18
			&& $this->formData['tax_group_id'] != 0 && $this->formData['doctype'] != 10 && $this->formData['doctype'] != 13)
			$this->Line($iline7+70);
		elseif($this->formData['doctype'] == 18  && $this->formData['tax_group_id'] != 2 && $this->formData['doctype'] != 10 && $this->formData['doctype'] != 13)
			$this->Line($iline7+70);
		if($this->formData['tot_discount'] && $this->formData['tax_group_id'] == 2 && $this->formData['doctype'] != 32 &&
			 $this->formData['doctype'] != 30 && $this->formData['doctype'] != 10 && $this->formData['doctype'] != 13)
			$this->Line($iline7+50);
		if($this->formData['tot_discount'] && $this->formData['tax_group_id'] == 2 && $this->formData['doctype'] == 32 && $this->formData['doctype'] != 13)
			$this->Line($iline7+70);

		if($this->formData['tot_discount'] && $this->formData['tax_group_id'] != 2 && $this->formData['doctype'] == 30 && $this->formData['doctype'] != 13){
			$this->Line($iline7+50);
			$this->Line($iline7+70);
		}elseif($this->formData['tot_discount'] && $this->formData['tax_group_id'] == 2 && $this->formData['doctype'] == 30 && $this->formData['doctype'] != 13)
			$this->Line($iline7+70);
		// print_r($this->formData);exit();

  		for ($i = 1; $i < count($this->cols) - 1; $i++) {
  			if($i == 5 && $this->formData['tot_discount'] && $this->formData['tax_group_id'] == 2 && $this->formData['doctype'] != 10)
    		$this->LineTo($this->cols[$i] - 5, $iline5, $this->cols[$i]+2, $iline7+70);
    		elseif($i == 5 && !$this->formData['tot_discount'] && $this->formData['tax_group_id'] != 2 && $this->formData['doctype'] != 10
    		&& $this->formData['doctype'] != 13 && $this->formData['doctype'] != 32 && $this->formData['doctype'] != 30)
    		$this->LineTo($this->cols[$i]+2, $iline5, $this->cols[$i]+2, $iline7+90);

    		elseif($i == 5 && !$this->formData['tot_discount'] && $this->formData['tax_group_id'] == 2 && $this->formData['doctype'] != 13
    			&& $this->formData['doctype'] != 10 && $this->formData['doctype'] != 18 && $this->formData['doctype'] != 32 && $this->formData['doctype'] != 30)
    		$this->LineTo($this->cols[$i]+2, $iline5, $this->cols[$i]+2, $iline7+70);


    		elseif($i == 5 && !$this->formData['tot_discount'] && $this->formData['tax_group_id'] != 2 && $this->formData['tax_group_id'] != 0 && $this->formData['doctype'] == 32 )
    		$this->LineTo($this->cols[$i]+2, $iline5, $this->cols[$i]+2, $iline7+90);

    		elseif($i == 5 && !$this->formData['tot_discount'] && $this->formData['tax_group_id'] != 2 && $this->formData['tax_group_id'] != 0 && $this->formData['doctype'] == 30)
    		$this->LineTo($this->cols[$i]+2, $iline5, $this->cols[$i]+2, $iline7+90);


    		elseif($i == 5 && !$this->formData['tot_discount'] && $this->formData['tax_group_id'] == 2 && $this->formData['doctype'] == 13)
    		$this->LineTo($this->cols[$i]+2, $iline5, $this->cols[$i]+2, $iline7+90);


    		elseif($i == 5 && !$this->formData['tot_discount'] && $this->formData['tax_group_id'] == 2 && $this->formData['doctype'] != 10
    		&& $this->formData['doctype'] != 13)
    		$this->LineTo($this->cols[$i]+2, $iline5, $this->cols[$i]+2, $iline7+90);

    		elseif($i == 5 && $this->formData['tot_discount'] && $this->formData['tax_group_id'] != 2 && $this->formData['doctype'] != 10 && $this->formData['doctype'] != 13)
    		$this->LineTo($this->cols[$i]+2, $iline5, $this->cols[$i]+2, $iline7+50);

    		elseif($i == 5 && !$this->formData['tot_discount'] && $this->formData['tax_group_id'] == 2 && $this->formData['doctype'] == 10)
    		$this->LineTo($this->cols[$i]+2, $iline5, $this->cols[$i]+2, $iline7+110);

    		elseif($i == 5 && $this->formData['tax_group_id'] == 2 && $this->formData['doctype'] == 10)
    		$this->LineTo($this->cols[$i]+2, $iline5, $this->cols[$i]+2, $iline7+90);

			elseif($i == 5 && $this->formData['tot_discount']>0 && $this->formData['tax_group_id'] != 0 && $this->formData['tax_group_id'] != 2 && $this->formData['doctype'] == 10)
    		$this->LineTo($this->cols[$i]+2, $iline5, $this->cols[$i]+2, $iline7+70);

    		elseif($i == 5 && !$this->formData['tot_discount'] && $this->formData['tax_group_id'] != 0 && $this->formData['tax_group_id'] != 2 && $this->formData['doctype'] == 10)
    		$this->LineTo($this->cols[$i] - 5, $iline5, $this->cols[$i] - 5, $iline7+90);

    		elseif($i == 5 && $this->formData['doctype'] == 13)
    			$this->LineTo($this->cols[$i] - 5, $iline5, $this->cols[$i] - 5, $iline7 + 70);

  			elseif($i == 1 && $this->formData['doctype'] != 13)
    		$this->LineTo($this->cols[$i] - 5, $iline5, $this->cols[$i] - 5, $iline7 + 150);
    		elseif($i == 2 && $this->formData['doctype'] != 13)
    		$this->LineTo($this->cols[$i] - 5, $iline5, $this->cols[$i] - 5, $iline7 + 150);
    		elseif($i == 3 && $this->formData['doctype'] != 13)
    		$this->LineTo($this->cols[$i] - 5, $iline5, $this->cols[$i] - 5, $iline7 + 150);
    		elseif($i == 4 && $this->formData['doctype'] != 13)
    		$this->LineTo($this->cols[$i] - 5, $iline5, $this->cols[$i] - 5, $iline7 + 150);
    		elseif($i == 5 && $this->formData['doctype'] != 13)
    		$this->LineTo($this->cols[$i] - 5, $iline5, $this->cols[$i] - 5, $iline7 + 150);

		}
		// $this->LineTo($this->leftMargin, $iline2 ,$this->leftMargin, $iline4);
		// $col = $this->leftMargin;
		// for ($i = 0; $i < 5; $i++)
		// {
		// 	$this->LineTo($col += $width, $iline2,$col, $iline4);
		// }
		if($this->formData['tot_discount'] && $this->formData['tax_group_id'] != 2 && $this->formData['doctype'] != 10 && $this->formData['doctype'] != 13)
			$this->LineTo($this->leftMargin, $iline5 ,$this->leftMargin, $iline7+ 50);
		elseif(!$this->formData['tot_discount'] && $this->formData['tax_group_id'] == 2 && $this->formData['doctype'] != 10 && $this->formData['doctype'] != 13)
			$this->LineTo($this->leftMargin, $iline5 ,$this->leftMargin, $iline7+ 90);
		elseif($this->formData['doctype'] == 20 && $this->formData['tax_group_id'] == 0 && $this->formData['doctype'] != 10 && $this->formData['doctype'] != 13)
			$this->LineTo($this->leftMargin, $iline5 ,$this->leftMargin, $iline7+ 90);
		
		elseif($this->formData['tot_discount'] && $this->formData['tax_group_id'] != 0 && $this->formData['tax_group_id'] != 2 && $this->formData['doctype'] == 10)
			$this->LineTo($this->leftMargin, $iline5 ,$this->leftMargin, $iline7+ 50);

		elseif(!$this->formData['tot_discount'] && $this->formData['tax_group_id'] != 0 && $this->formData['tax_group_id'] != 2 && $this->formData['doctype'] == 10)
			$this->LineTo($this->leftMargin, $iline5 ,$this->leftMargin, $iline7+ 70);


		elseif($this->formData['doctype'] == 10 && $this->formData['tax_group_id'] == 2 && $this->formData['tot_discount'])
			$this->LineTo($this->leftMargin, $iline5 ,$this->leftMargin, $iline7+ 70);


		elseif($this->formData['doctype'] != 10)
			$this->LineTo($this->leftMargin, $iline5 ,$this->leftMargin, $iline7+ 70);

		elseif(!$this->formData['tot_discount'] && $this->formData['tax_group_id'] == 2 && $this->formData['doctype'] == 10)
			$this->LineTo($this->leftMargin, $iline5 ,$this->leftMargin, $iline7+ 90);
		// if(!$this->hide_header){  // hide for quet 2nd page payment term

		// if ($this->l['a_meta_dir'] == 'rtl') // avoid line overwrite in rtl language
		// 	$this->LineTo($this->cols[$cols - 2], $iline5 ,$this->cols[$cols - 2], $iline7);
		// else	
		// 	$this->LineTo($this->cols[$cols - 2] + 4, $iline5 ,$this->cols[$cols - 2] + 4, $iline7);
		// 	}
		if($this->formData['tot_discount'] && $this->formData['tax_group_id'] != 2 && $this->formData['doctype'] != 10 && $this->formData['doctype'] != 13)
		$this->LineTo($right, $iline5 ,$right, $iline7 + 50);
		elseif(!$this->formData['tot_discount'] && $this->formData['tax_group_id'] == 2 && $this->formData['doctype'] != 10 && $this->formData['doctype'] != 13)
			$this->LineTo($right, $iline5 ,$right, $iline7 + 90);
		elseif($this->formData['doctype'] == 20 && $this->formData['tax_group_id'] == 0 && $this->formData['doctype'] != 10 && $this->formData['doctype'] != 13)
			$this->LineTo($right, $iline5 ,$right, $iline7 + 90);
		
		elseif($this->formData['tot_discount']>0 && $this->formData['tax_group_id'] != 0 && $this->formData['tax_group_id'] != 2 && $this->formData['doctype'] == 10)
			$this->LineTo($right, $iline5 ,$right, $iline7 + 50);

		elseif(!$this->formData['tot_discount']  && $this->formData['tax_group_id'] != 0 && $this->formData['tax_group_id'] != 2 && $this->formData['doctype'] == 10)
			$this->LineTo($right, $iline5 ,$right, $iline7 + 70);

		elseif($this->formData['doctype'] == 10 && $this->formData['tax_group_id'] == 2 && $this->formData['tot_discount'])
			$this->LineTo($right, $iline5 ,$right, $iline7 + 70);


		elseif($this->formData['doctype'] != 10)
			$this->LineTo($right, $iline5 ,$right, $iline7 + 70);

		elseif(!$this->formData['tot_discount'] && $this->formData['tax_group_id'] == 2 && $this->formData['doctype'] == 10)
			$this->LineTo($right, $iline5 ,$right, $iline7 + 90);


		// Company Logo
		// $logo = company_path() . "/images/" . $this->company['coy_logo'];
		// if ($this->company['coy_logo'] != '' && file_exists($logo))
		// {
		// 	$this->NewLine();
		// 	$this->AddImage($logo, $ccol+20, $this->row-60, 0, 80);
		// }

	    $company_id = get_latter_hand_setting($this->formData['company_id']);
		
		if($this->company['coy_logo'] || $company_id['file_name']){
			if($company_id['file_name'])
			$coy_logo  = $company_id['file_name'];
			else
			$coy_logo = $this->company['coy_logo'];
		}


		$logo = company_path() . "/images/" . $coy_logo;
		if ($this->company['coy_logo'] != '' || $company_id['file_name'] && file_exists($logo))
		{
			$this->NewLine();
			if($this->formData['doctype'] == 18 OR $this->formData['doctype'] == 20)
				$this->AddImage($logo, $ccol-20, $this->row-60, 0, 100);
			else
				$this->AddImage($logo, $ccol-20, $this->row-70, 0, 100);
			// $this->AddImage($logo, $ccol-23, $this->row+10, 0, 60);
			// $this->AddImage($logo, $ccol-23, $this->row-60, 0, 60);
		}

		$this->NewLine();
		$this->fontSize += 9;
		$this->Font('BU', 'courier');
		// $this->Text($ccol, $this->company['coy_name'], $icol);
		// print_r($this->formData['doctype']);exit();
        if($this->formData['doctype'] == 18)
			$title = "Purchase Order";
		elseif($this->formData['doctype'] == 30)
		    $title = "Sale Order";
		elseif($this->formData['doctype'] == 32)
		    $title = "Quotation";
		elseif($this->formData['doctype'] == 13)
		    $title = "Delivery Note";
		else
			$title = "Bill";
        $this->TextWrap(50,670,500, $title, 'center');
		$this->Font();
		$this->fontSize -= 9;
		// Document title
		$this->SetTextColor(190, 190, 190);
		$this->fontSize += 10;
		$this->Font('bold');
		// $this->TextWrap($mcol, $this->row, $this->pageWidth - $this->rightMargin - $mcol - 20, $this->title, 'right');
		$this->Font();
		$this->fontSize -= 10;
		$this->NewLine();
		$this->SetTextColor(0, 0, 0);
		$adrline = $this->row;

		// Company data
		// $this->TextWrapLines($ccol, $icol, $this->company['postal_address']);
		// $this->Font('italic');
		// if (@$this->company['phone'])
		// {
		// 	$this->Text($ccol, _("Phone"), $c2col);
		// 	$this->Text($c2col, $this->company['phone'], $mcol);
		// 	$this->NewLine();
		// }
		$this->NewLine(9);
		// $this->TextWrapLines($mcol + 70, $icol, $this->company['postal_address']);
		// if (@$this->company['email']  || $company_id['email'])
		// {
		// 	$this->Text($mcol + 70, _("Email"), $c2col);
		// 	if($company_id['email'])
		// 		$email = $company_id['email'];
		// 	else
		// 		$email = $this->company['email'];

		// 	$url = "mailto:" . $email;
		// 	$this->SetTextColor(0, 0, 255);
		// 	$this->Text($mcol + 170, $email, $mcol);
		// 	$this->SetTextColor(0, 0, 0);
		// 	$this->addLink($url, $c2col, $this->row, $mcol, $this->row + $this->lineHeight);

		// 	$this->NewLine();
		// }

		// if (@$this->formData['domicile'])
		// {
		// 	$this->Text($mcol + 70, _("STRN# "));
		// 	$this->Text($mcol + 170, $this->company['domicile']);

		// 	// $this->Text($ccol, _("STRN # "), $c2col);
		// 	// $this->Text($c2col, $this->company['domicile'], $mcol);
		// 	$this->NewLine();
		// }
		$this->Font();
		$this->row = $adrline;

		$this->NewLine(8);
		$this->Font('B');
		$this->Text($mcol + 70, $this->formData['document_name']);
		$this->Text($mcol + 170, $this->formData['document_number']);
		$this->Font();
		if($this->formData['order_']){
			$order_ref = get_sales_order_header($this->formData['order_'], ST_SALESORDER);
			$this->NewLine();
			$this->Text($mcol + 70, _("Sale Order No."));
			$this->Text($mcol + 170, $order_ref['reference']);
		}
		if ($this->formData['so_link_quotation']) {
			$this->NewLine();
			$this->Text($mcol + 70, _("Quotation No."));
			$this->Text($mcol + 170, $this->formData['so_link_quotation']);
		}
		if ($this->formData['po_no']) {
			$this->NewLine();
			$this->Text($mcol + 70, _("PO No."));
			$this->Text($mcol + 170, $this->formData['po_no']);
		}
		$this->NewLine();
		$this->Text($mcol + 70, _("Date"));
		$originalDate = $this->formData['document_date'];
		$formattedDate = date('d/M/Y', strtotime($originalDate));
		$this->Text($mcol + 170, $formattedDate);
       // print_r($this->formData);exit();
		$this->NewLine();
		if (@$this->company['gst_no'] && $this->formData['company_id'] != 1)
		{
			if($company_id['ntn_no'])
				$gst_no = $company_id['ntn_no'];
			else
				$gst_no = $this->company['gst_no'];
			// $this->NewLine();
			$this->Text($mcol + 70, _("NTN#"));
			$this->Text($mcol + 170, $gst_no);
			// $this->Text($ccol, _("NTN No."), $c2col);
			// $this->Text($c2col, $this->company['gst_no'], $mcol);
			$this->NewLine();
		}
		if (@$this->company['fax'] && $this->formData['company_id'] != 1)
		{
			$this->Text($mcol + 70, _("SRB# "));
			$this->Text($mcol + 170, $this->company['fax']);

			// $this->Text($ccol, _("SRB#"), $c2col);
			// $this->Text($c2col, $this->company['fax'], $mcol);
			$this->NewLine();
		}
       if($this->formData['wo_order'])
       {

			$this->NewLine();
			$this->Text($mcol + 70, _("Work Order # "));
			$this->Text($mcol + 170, $this->formData['wo_order']);
			$this->NewLine(2);
       }else
       $this->NewLine(2);
	
		if ($this->pageNumber > 1)
			$this->Text($mcol + 100, _("Page") . ' ' . $this->pageNumber);
		$this->row = $iline1 - $this->lineHeight;
		// $this->fontSize -= 4;
		// $this->Text($ccol, $Addr1['title'], $icol);
		// $this->Text($mcol, $Addr2['title']);
		// $this->fontSize += 4;


		// print_r($this->formData);exit();
// address1
		$temp = $this->row = $this->row - $this->lineHeight - 5;
		$this->Font('B');
		$this->Text($ccol, $Addr1['name'], $icol);
		$this->Font();
		$this->NewLine(2);
		$this->TextWrapLines($ccol, $icol - $ccol, ($this->formData['delivery_address'] != 'N/A') ? $this->formData['delivery_address'] : $this->formData['delivery_address']);

// 		// address2
// 		$this->row = $temp;
// 		$this->Text($mcol, $Addr2['name']);
// 		$this->NewLine();
// 		$this->TextWrapLines($mcol, $this->rightMargin - $mcol, $Addr2['address'], 'left', 0, 0, NULL, 1);
		// print_r($this->formData['company_id']);exit();
		// $this->NewLine(2);
		if ($this->formData['phone'] || $this->formData['contact_phone']) {
		$this->Text($ccol, _("Tel :"));
		$this->TextWrapLines($ccol+30, $icol - $ccol, $this->formData['phone'] ? $this->formData['phone'] : $this->formData['contact_phone']);
		}
		if ($this->formData['tax_id'] && $this->formData['company_id'] != 1) {
		$this->Text($ccol, _("NTN#"));
		$this->TextWrapLines($ccol+30, $icol - $ccol, $this->formData['tax_id']);
		}
   	  
	   	if ($this->formData['subject']) {
	   	  	$this->Font('BU');
	   	    // $this->TextWrap(30,530,700, _("SUB :". strtoupper($this->formData['subject'])));
	   	    $old_row2 = $this->row;
	   	    $this->row = 550;
			$this->TextWrapLines(30, 550, _("SUB :". strtoupper($this->formData['subject'])), 100);
	   	    $this->row = $old_row2;
	   	    $this->Font();
   		}
		// Auxiliary document information
		$col = $this->leftMargin;
		foreach($aux_info as $info_header => $info_content)
		{

			$this->row = $iline2 - $this->lineHeight - 1;
			$this->TextWrap($col, $this->row, $width, $info_header, 'C');
			$this->row = $iline3 - $this->lineHeight - 1;
			$this->TextWrap($col, $this->row, $width, $info_content, 'C');
			$col += $width;
		}
		// Payment terms
		$this->row -= (2 * $this->lineHeight);
		$this->Font('italic');
		$this->TextWrap($ccol, $this->row, $right-$ccol, $Payment_Terms);
		$this->Font();

		// Line headers
		$this->row = $iline5 - $this->lineHeight - 1;
		$this->Font('bold');
		$count = count($this->headers);
		$this->cols[$count] = $right - 3;
		for ($i = 0; $i < $count; $i++)
			$this->TextCol($i, $i + 1, $this->headers[$i], -8);
		$this->Font();

		// Footer
		$this->Font('italic');
		$this->row = $iline7 - $this->lineHeight - 6;

		foreach ($Footer as $line => $txt)
		{
			if (!is_numeric($line))	// title => link
			{
				$this->fontSize -= 2;
				$this->TextWrap($ccol, $this->row, $right - $ccol, $line, 'C');
				$this->row -= $this->lineHeight;
				$this->SetTextColor(0, 0, 255);
				$this->TextWrap($ccol, $this->row, $right - $ccol, $txt, 'C');
				$this->SetTextColor(0, 0, 0);
				$this->addLink($txt, $ccol, $this->row, $this->pageWidth - $this->rightMargin, $this->row + $this->lineHeight);
				$this->fontSize += 2;
			}
			else
				$this->TextWrap($ccol, $this->row, $right - $ccol, $txt, 'C');
			$this->row -= $this->lineHeight;

		}

		if ($_SESSION['hide_doc_label'] != 1 && $this->formData['doctype'] != 32) {
			$this->SetTextColor(255, 0, 0);
			$this->TextWrap($ccol, 800 ,300, '( This Document System Generated No Need to signature and stemp )', 'L');
			$this->SetTextColor(0, 0, 0);
		}


		$this->Font();
		$temp = $iline6 - $this->lineHeight - 2;
