<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_REP_AGED_CUST_REP';
// ----------------------------------------------------------------
// $ Revision:	2.0 $
// Creator:	Joe Hunt
// date_:	2005-05-19
// Title:	Aged Customer Balances
// ----------------------------------------------------------------
$path_to_root="..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/gl/includes/gl_db.inc");
include_once($path_to_root . "/sales/includes/db/city_db.inc");

//----------------------------------------------------------------------------------------------------

print_aged_customer_analysis();

function get_invoices($customer_id, $to, $all=true)
{
	$todate = date2sql($to);
	$PastDueDays1 = get_company_pref('past_due_days');
	$PastDueDays2 = 2 * $PastDueDays1;

	// Revomed allocated from sql
	if ($all)
    	$value = "(ov_amount + ov_gst + ov_freight + ov_freight_tax + ov_discount)";
	else
    	$value = "(ov_amount + ov_gst + ov_freight + ov_freight_tax + ov_discount - alloc)";
	$sign = "IF(`type` IN(".implode(',',  array(ST_CUSTCREDIT,ST_CUSTPAYMENT,ST_BANKDEPOSIT,ST_JOURNAL))."), -1, 1)";
	$due = "IF (type=".ST_SALESINVOICE.", tran_date, tran_date)";

	$sql = "SELECT type, reference, tran_date, trans_no,payment_terms,debtor_no,branch_code,
		$sign*$value as Balance,
		IF ((TO_DAYS('$todate') - TO_DAYS($due)) > 0,$sign*$value,0) AS Due,
		IF ((TO_DAYS('$todate') - TO_DAYS($due)) > $PastDueDays1,$sign*$value,0) AS Overdue1,
		IF ((TO_DAYS('$todate') - TO_DAYS($due)) > $PastDueDays2,$sign*$value,0) AS Overdue2

		FROM ".TB_PREF."debtor_trans trans

		WHERE debtor_no = $customer_id 
			AND tran_date <= '$todate'
			AND ABS(ov_amount + ov_gst + ov_freight + ov_freight_tax + ov_discount) > " . FLOAT_COMP_DELTA;
   //         type <> ".ST_CUSTDELIVERY."
			// AND 


	if (!$all)
		$sql .= "AND ABS(ov_amount + ov_gst + ov_freight + ov_freight_tax + ov_discount - alloc) > " . FLOAT_COMP_DELTA;
	$sql .= "ORDER BY tran_date";

	return db_query($sql, "The customer transactions could not be retrieved");
}


function check_pending_delivery($trans_no){

  $sql = " SELECT SUM(quantity) as qty , SUM(qty_done) as qty_done FROM ".TB_PREF."debtor_trans_details WHERE debtor_trans_type=".ST_CUSTDELIVERY." AND debtor_trans_no=".db_escape($trans_no)." ";
  $res=db_query($sql);
  $row=db_fetch($res);


  // display_error($sql);

  if($row['qty']>$row['qty_done'])	return 1; else return 0;


}
//----------------------------------------------------------------------------------------------------

function print_aged_customer_analysis()
{
    global $path_to_root, $systypes_array, $SysPrefs;

    $to = $_POST['PARAM_0'];
    $fromcust = $_POST['PARAM_1'];
    $branch_id = $_POST['PARAM_2'];
    $city_id = $_POST['PARAM_3'];
    $currency = $_POST['PARAM_4'];
    $show_all = $_POST['PARAM_5'];
	$summaryOnly = $_POST['PARAM_6'];
    $no_zeros = $_POST['PARAM_7'];
    $graphics = $_POST['PARAM_8'];
    $comments = $_POST['PARAM_9'];
	$orientation = $_POST['PARAM_10'];
	$destination = $_POST['PARAM_11'];
	if ($destination)
		include_once($path_to_root . "/reporting/includes/excel_report.inc");
	else
		include_once($path_to_root . "/reporting/includes/pdf_report.inc");
	$orientation = ($orientation ? 'L' : 'P');
	if ($graphics)
	{
		include_once($path_to_root . "/reporting/includes/class.graphic.inc");
		$pg = new chart($graphics);
	}

	if ($fromcust == ALL_TEXT)
		$from = _('All');
	else
		$from = get_customer_name($fromcust);

	if ($branch_id == 0)
		$dim2 = _('All');
	else
		$dim2 = get_dimension_string($branch_id);

	if ($city_id == 0)
		$citty = _('All');
	else
		$citty = get_city_name($city_id);

    	$dec = user_price_dec();

	if ($summaryOnly == 1)
		$summary = _('Summary Only');
	else
		$summary = _('Detailed Report');
	if ($currency == ALL_TEXT)
	{
		$convert = true;
		$currency = _('Balances in Home Currency');
	}
	else
		$convert = false;

	if ($no_zeros) $nozeros = _('Yes');
	else $nozeros = _('No');
	if ($show_all) $show = _('Yes');
	else $show = _('No');

	$PastDueDays1 = get_company_pref('past_due_days');
	$PastDueDays2 = 2 * $PastDueDays1;
	$nowdue = "1-" . $PastDueDays1 . " " . _('Days');
	$pastdue1 = $PastDueDays1 + 1 . "-" . $PastDueDays2 . " " . _('Days');
	$pastdue2 = _('Over') . " " . $PastDueDays2 . " " . _('Days');

	$cols = array(0, 100, 150, 190,250,320,	370, 420, 465, 515,	565);
	$headers = array(_('Customer'),	'',	'',	'Salesman',	'Payment Term',	_('Current'), $nowdue, $pastdue1, $pastdue2,
		_('Total Balance'));

	$aligns = array('left',	'left',	'left',	'right','right',  'right', 'right', 'right', 'right',	'right');

    	$params =   array( 	0 => $comments,
    				1 => array('text' => _('End Date'), 'from' => $to, 'to' => ''),
    				2 => array('text' => _('Customer'),	'from' => $from, 'to' => ''),
    				3 => array('text' => _('Currency'), 'from' => $currency, 'to' => ''),
                    4 => array('text' => _('Type'),		'from' => $summary,'to' => ''),
                    5 => array('text' => _('Show Also Allocated'), 'from' => $show, 'to' => ''),		
					6 => array('text' => _('Suppress Zeros'), 'from' => $nozeros, 'to' => ''),
					7 => array('text' => _('Branch'), 'from' => $dim2, 'to' => ''),
                    8 => array('text' => _('City'), 'from' => $citty, 'to' => ''));

	if ($convert)
		$headers[2] = _('Currency');
    $rep = new FrontReport(_('Aged Customer Analysis'), "AgedCustomerAnalysis", user_pagesize(), 9, $orientation);
    if ($orientation == 'L')
    	recalculate_cols($cols);

    $rep->Font();
    $rep->Info($params, $cols, $headers, $aligns);
    $rep->NewPage();

	$total = array(0,0,0,0, 0);

	$sql = "SELECT debtor_no, name, debtor_ref, curr_code FROM ".TB_PREF."debtors_master WHERE !inactive";
	if ($fromcust != ALL_TEXT)
		$sql .= " WHERE debtor_no=".db_escape($fromcust);
	if ($branch_id != 0)
		$sql .= " AND dimension2_id =".db_escape($branch_id);
	 // display_error($branch_id);
	if ($city_id != 0)
	 	$sql .= " AND city_id =".db_escape($city_id);
	$sql .= " ORDER BY name";
	$result = db_query($sql, "The customers could not be retrieved");

	while ($myrow=db_fetch($result))
	{
		if (!$convert && $currency != $myrow['curr_code'])
			continue;

		if ($convert) $rate = get_exchange_rate_from_home_currency($myrow['curr_code'], $to);
		else $rate = 1.0;
		$custrec = get_customer_details($myrow['debtor_no'], $to, $show_all);
		if (!$custrec)
			continue;
		$custrec['Balance'] *= $rate;
		$custrec['Due'] *= $rate;
		$custrec['Overdue1'] *= $rate;
		$custrec['Overdue2'] *= $rate;
		$str = array($custrec["Balance"] - $custrec["Due"],
			$custrec["Due"]-$custrec["Overdue1"],
			$custrec["Overdue1"]-$custrec["Overdue2"],
			$custrec["Overdue2"],
			$custrec["Balance"]);
		if ($no_zeros && floatcmp(array_sum($str), 0) == 0) continue;

		$rep->fontSize += 2;
		$rep->TextCol(0, 2, $myrow['debtor_ref']." - ".$myrow["name"]);
		if ($convert) $rep->TextCol(2, 3,	$myrow['curr_code']);
		$rep->fontSize -= 2;
		$total[0] += ($custrec["Balance"] - $custrec["Due"]);
		$total[1] += ($custrec["Due"]-$custrec["Overdue1"]);
		$total[2] += ($custrec["Overdue1"]-$custrec["Overdue2"]);
		$total[3] += $custrec["Overdue2"];
		$total[4] += $custrec["Balance"];
		for ($i = 0; $i < count($str); $i++)
			$rep->AmountCol($i + 5, $i + 6, $str[$i], $dec);
		$rep->NewLine(1, 2);
		if (!$summaryOnly)
		{
			$res = get_invoices($myrow['debtor_no'], $to, $show_all);
    		if (db_num_rows($res)==0)
				continue;
    		$rep->Line($rep->row + 4);
			while ($trans=db_fetch($res))
			{
                if( $trans['type']==ST_CUSTDELIVERY && !check_pending_delivery($trans['trans_no']))
                	continue;


				$rep->NewLine(1, 2);
        		$rep->TextCol(0, 1, $systypes_array[$trans['type']], -2);
				$rep->TextCol(1, 2,	$trans['reference'], -2);
				$rep->DateCol(2, 3, $trans['tran_date'], true, -2);
				$brnach_row =get_cust_branch($trans['debtor_no'], $trans['branch_code']);
				$sales_man =get_salesman_name($brnach_row['salesman']);
				$rep->TextCol(3, 4, $sales_man, true, -2);
				$term_row = get_payment_terms($trans['payment_terms']);
				$Payment_Terms =  ($term_row["terms"]) ? $term_row["terms"] : '-';
				$rep->TextCol(4, 5, $Payment_Terms, true, -2);

				if ($trans['type'] == ST_CUSTCREDIT || $trans['type'] == ST_CUSTPAYMENT || $trans['type'] == ST_BANKDEPOSIT)
				{
					$trans['Balance'] *= -1;
					$trans['Due'] *= -1;
					$trans['Overdue1'] *= -1;
					$trans['Overdue2'] *= -1;
				}

				foreach ($trans as $i => $value)
					$trans[$i] = (float)$trans[$i] * $rate;
				$str = array($trans["Balance"] - $trans["Due"],
					$trans["Due"]-$trans["Overdue1"],
					$trans["Overdue1"]-$trans["Overdue2"],
					$trans["Overdue2"],
					$trans["Balance"]);
				for ($i = 0; $i < count($str); $i++)
					$rep->AmountCol($i + 5, $i + 6, $str[$i], $dec);
			}
			$rep->Line($rep->row - 8);
			$rep->NewLine(2);
		}
	}
	if ($summaryOnly)
	{
    	$rep->Line($rep->row  + 4);
    	$rep->NewLine();
	}
	$rep->fontSize += 2;
	$rep->TextCol(0, 3, _('Grand Total'));
	$rep->fontSize -= 2;
	$serie = array();
	for ($i = 0; $i < count($total); $i++)
	{
		$rep->AmountCol($i + 5, $i + 6, $total[$i], $dec);
		if ($graphics && $i < count($total) - 1)
		{
			$serie[] = abs($total[$i]);
		}
	}
   	$rep->Line($rep->row - 8);
   	if ($graphics)
   	{
		$pg->setStream('png');
		$pg->addSerie(_('Balances'), $serie);
		$pg->setLabels(array(_('Current'), $nowdue, $pastdue1, $pastdue2));
		$pg->setTitle($rep->title);
		$pg->setXTitle(_("Days"));
		$pg->setYTitle(_("Amount"));
		$pg->setDTitle(number_format2($total[4]));
		$pg->setValues(true);
		$pg->latin_notation = ($SysPrefs->decseps[user_dec_sep()] != ".");
		$filename = company_path(). "/pdf_files/". random_id().".png";
		$pg->display($filename);
		//sleep(5);
		$w = $pg->width / 1.5;
		$h = $pg->height / 1.5;
		$x = ($rep->pageWidth - $w) / 2;
		$rep->NewLine(2);
		if ($rep->row - $h < $rep->bottomMargin)
			$rep->NewPage();
		$rep->AddImage($filename, $x, $rep->row - $h, $w, $h);
	}
	$rep->NewLine();
    $rep->End();
}
