<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = $_POST['PARAM_0'] == $_POST['PARAM_1'] ?
	'SA_REP_PRINT_SALES_QUOTATION' : 'SA_REP_PRINT_SALES_QUOTATION';
// ----------------------------------------------------------------
// $ Revision:	2.0 $
// Creator:	Joe Hunt
// date_:	2005-05-19
// Title:	Print Sales Quotations
// ----------------------------------------------------------------
$path_to_root="..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/sales/includes/sales_db.inc");
include_once($path_to_root . "/taxes/tax_calc.inc");

//----------------------------------------------------------------------------------------------------

print_sales_quotations();

function print_sales_quotations()
{
	global $path_to_root, $SysPrefs;

	include_once($path_to_root . "/reporting/includes/pdf_report.inc");

	$from = $_POST['PARAM_0'];
	$to = $_POST['PARAM_1'];
	$currency = $_POST['PARAM_2'];
	$email = $_POST['PARAM_3'];
	$comments = $_POST['PARAM_4'];
	$orientation = $_POST['PARAM_5'];

	if (!$from || !$to) return;

	$orientation = ($orientation ? 'L' : 'P');
	$dec = user_price_dec();

	$pictures = $SysPrefs->print_item_images_on_quote();
	// If you want a larger image, then increase pic_height f.i.
	// $SysPrefs->pic_height += 25;
	
	$cols = array(4, 50, 280, 340, 400, 465, 525);
	// $headers in doctext.inc
	$aligns = array('center',	'left',	'center', 'center', 'right', 'right');

	$params = array('comments' => $comments);

	$cur = get_company_Pref('curr_default');

	if ($email == 0)
		$rep = new FrontReport(_("SALES QUOTATION"), "SalesQuotationBulk", user_pagesize(), 9, $orientation);
    if ($orientation == 'L')
    	recalculate_cols($cols);

	for ($i = $from; $i <= $to; $i++)
	{
		$myrow = get_sales_order_header($i, ST_SALESQUOTE);
		if ($currency != ALL_TEXT && $myrow['curr_code'] != $currency) {
			continue;
		}
		$baccount = get_default_bank_account($myrow['curr_code']);
		$params['bankaccount'] = $baccount['id'];
		$branch = get_branch($myrow["branch_code"]);
		if ($email == 1)
		{
			$rep = new FrontReport("", "", user_pagesize(), 9, $orientation);
			if ($SysPrefs->print_invoice_no() == 1)
				$rep->filename = "SalesQuotation" . $i . ".pdf";
			else	
				$rep->filename = "SalesQuotation" . $myrow['reference'] . ".pdf";
		}
		$rep->currency = $cur;
		$rep->Font();
		$rep->Info($params, $cols, null, $aligns);

		$contacts = get_branch_contacts($branch['branch_code'], 'order', $branch['debtor_no'], true);
		$rep->SetCommonData($myrow, $branch, $myrow, $baccount, ST_SALESQUOTE, $contacts);
		$rep->SetHeaderType('Header2');
		$rep->NewPage();

		$rep->hide_pay_term=1;

		$result = get_sales_order_details($i, ST_SALESQUOTE);
		$SubTotal = 0;
		$items = $prices = array();
		$item_group = '';
		$s_no = 1 ;
		while ($myrow2=db_fetch($result))
		{

			$item_group_id = get_item($myrow2['stk_code']);
			$item_group_des =  get_item_group_name($item_group_id['item_group_id']);
  			if ($item_group != $item_group_des)
			{
				$item_group = $item_group_des;
				$rep->Font('bold');
				// $rep->NewLine(0.5);
				// $rep->TextCol(1, 2, $item_group_des);
				$rep->TextWrapLines($rep->cols[1], 210, $item_group_des, 100);

				$rep->Font();
				$rep->NewLine(1.5);
					if ($rep->row < $rep->bottomMargin + (27 * $rep->lineHeight)){

						$rep->show_sub_total($rep,$SubTotal);
				            $rep->NewPage();
					}
			}

			$Net = round2(((1 - $myrow2["discount_percent"]) * $myrow2["unit_price"] * $myrow2["quantity"]),
			   user_price_dec());
			$prices[] = $Net;
			$items[] = $myrow2['stk_code'];
			$SubTotal += $Net;
			$DisplayPrice = number_format2($myrow2["unit_price"],$dec);
			$DisplayQty = number_format2($myrow2["quantity"],get_qty_dec($myrow2['stk_code']));
			$DisplayNet = number_format2($Net,$dec);

			if ($myrow2["discount_percent"]==0)
				$DisplayDiscount ="";
			else
				$DisplayDiscount = number_format2($myrow2["discount_percent"]*100,user_percent_dec()) . "%";
			// $rep->TextCol(0, 1,	$myrow2['stk_code'], -2);
			$rep->TextCol(0, 1,	"0".$s_no++, -2);
			$oldrow = $rep->row;
			$rep->TextColLines(1, 2, $myrow2['description'], -2);
			$newrow = $rep->row;
			$rep->row = $oldrow;
			if ($Net != 0.0 || !is_service($myrow2['mb_flag']) || !$SysPrefs->no_zero_lines_amount())
			{
				$rep->TextCol(2, 3,	$DisplayQty, -2);
				$rep->TextCol(3, 4,	$myrow2['units'], -2);
				$rep->TextCol(4, 5,	$DisplayPrice, -2);
				// $rep->TextCol(5, 6,	$DisplayDiscount, -2);
				$rep->TextCol(5, 6,	$DisplayNet, -2);
			}
			$rep->row = $newrow;
			
			// if ($pictures)
			// {
			// 	$image = company_path(). "/images/" . item_img_name($myrow2['stk_code']) . ".jpg";
			// 	if (file_exists($image))
			// 	{
			// 		if ($rep->row - $SysPrefs->pic_height < $rep->bottomMargin)
			// 			$rep->NewPage();
			// 		$rep->AddImage($image, $rep->cols[1], $rep->row - $SysPrefs->pic_height, 0, $SysPrefs->pic_height);
			// 		$rep->row -= $SysPrefs->pic_height;
			// 		$rep->NewLine();
			// 	}
			// }
			if ($rep->row < $rep->bottomMargin + (27 * $rep->lineHeight))
				$rep->NewPage();
		}
		// if ($myrow['comments'] != "")
		// {
		// 	$rep->NewLine();
		// 	$rep->TextColLines(1, 3, $myrow['comments'], -2);
		// }
		$DisplaySubTot = number_format2($SubTotal,$dec);

		$rep->row = $rep->bottomMargin + (20 * $rep->lineHeight);
		$rep->cols[2] += 20;
		$rep->cols[3] += 20;
		$doctype = ST_SALESQUOTE;
		$rep->cols[1] = 40;
		$rep->aligns[1] = 'left';

		// $rep->TextCol(3, 6, _("Sub-total"), -2);
		// $rep->TextCol(6, 7,	$DisplaySubTot, -2);
		// $rep->NewLine(-0.4);
		$rep->NewLine(0.7);
		$rep->Font('bold');
		$rep->TextCol(1, 2, _("Total"), -2);
		$rep->TextCol(5, 6,	'Rs '. $DisplaySubTot, -2);
		$rep->Font();
		// if ($myrow['freight_cost'] != 0.0)
		// {
		// 	$DisplayFreight = number_format2($myrow["freight_cost"],$dec);
		// 	$rep->TextCol(3, 6, _("Shipping"), -2);
		// 	$rep->TextCol(6, 7,	$DisplayFreight, -2);
		// 	$rep->NewLine();
		// }	
		// $DisplayTotal = number_format2($myrow["freight_cost"] + $SubTotal, $dec);
		// if ($myrow['tax_included'] == 0) {
		// 	$rep->TextCol(3, 6, _("TOTAL ORDER EX TAX"), - 2);
		// 	$rep->TextCol(6, 7,	$DisplayTotal, -2);
		// 	$rep->NewLine();
		// }

		$tax_items = get_tax_for_items($items, $prices, $myrow["freight_cost"],
		  $myrow['tax_group_id'], $myrow['tax_included'],  null);
		$first = true;
		foreach($tax_items as $tax_item)
		{
			if ($tax_item['Value'] == 0)
				continue;
			$DisplayTax = number_format2($tax_item['Value'], $dec);

			$tax_type_name = $tax_item['tax_type_name'];

			if ($myrow['tax_included'])
			{
				if ($SysPrefs->alternative_tax_include_on_docs() == 1)
				{
					if ($first)
					{
						$rep->TextCol(3, 6, _("Total Tax Excluded"), -2);
						$rep->TextCol(6, 7,	number_format2($tax_item['net_amount'], $dec), -2);
						$rep->NewLine();
					}
					$rep->TextCol(1, 2, $tax_type_name, -2);
					$rep->TextCol(5, 6,	'Rs '. $DisplayTax, -2);
					$first = false;
				}
				else
					$rep->TextCol(3, 7, _("Included") . " " . $tax_type_name . " " . _("Amount") . ": " . $DisplayTax, -2);
			}
			else
			{
				$SubTotal += $tax_item['Value'];
				$rep->NewLine(1.7);
				$rep->Font('bold');
				$rep->TextCol(1, 2, $myrow['tax_group_name'], -2);
				$rep->TextCol(5, 6,	'Rs '. $DisplayTax, -2);
				$rep->Font();
			}
			$rep->NewLine();
		}

		if($myrow['tot_discount']){
			if($myrow['tax_group_id'] != 2)
			$rep->NewLine(0.5);
			else
			$rep->NewLine(1.5);
			$rep->Font('bold');
			$rep->TextCol(1, 2, _("Discount Amount"), -2);			
			$rep->TextCol(5, 6, 'Rs '. number_format2($myrow['tot_discount'], $dec), -2);
			$SubTotal-=$myrow['tot_discount'];
			if($myrow['tax_group_id'] != 2)
				$rep->NewLine();
		 	$rep->Font();
		}

		if($myrow['tax_group_id']==2)
			$rep->NewLine(1.5);
		else
			$rep->NewLine(0.6);
		$DisplayTotal = number_format2($myrow["freight_cost"] + $SubTotal, $dec);
		$rep->Font('bold');
		// $rep->TextCol(3, 6, _("TOTAL ORDER TAX INCL."), - 2);
		// $rep->NewLine();
		$rep->TextCol(1, 2, _("Net Total."), - 2);
		$rep->TextCol(5, 6,  'Rs '.	$DisplayTotal, -2);
		$words = price_in_words($myrow["freight_cost"] + $SubTotal, ST_SALESQUOTE);
		if ($words != "")
		{
			$rep->NewLine(1.7);
			$rep->TextCol(1, 7, $myrow['curr_code'] . ": " . strtoupper($words), - 2);

		}	
		$rep->Font();
		$count = count($rep->headers);
		for ($si = 0; $si < $count; $si++)
			$rep->headers[$si]="";
            // unset($rep->headers[$i]);
             // $rep->hide_header=1;


					// display_error($i ."  ==");exit();
			// if ($myrow['comments'] != "")
		// {
// 			$rep->NewPage();
			// $rep->Font('bold');
// 			$rep->NewLine();

// 			$rep->fontSize += 2;

				// $rep->lineHeight=13;
			// $rep->TextCol(0, 7, _("Payment Terms: (Option 1 - Price may vary)"), - 2);

		
			// $rep->NewLine(3);

			// $rep->NewLine();
			// $rep->TextColLines(0, 7, $myrow['comments'], -2);
           	// $rep->Font();
			// $rep->TextColLines(0, 7, _("                -  50 % advance payment at the time of order confirmation.
   //              -  payment in advance at the time of shipment of empty aerosol cans.
   //              -  payment at the arrival of shipment.
   //              -  payment before delivery of order."), -2);

   
			// $rep->NewLine(1);
			// $rep->Font('bold');
			// $rep->TextCol(0, 7, _("Paymennt Term"), - 2);

			// $rep->Font();
			// $rep->NewLine(1);

			// $rep->TextColLines(0, 7, _("               - 70% advance payment at the time of order confirmation.
   //             - 20 % payment at the time of shipment of empty aerosol cans.
   //             - 10 % payment before delivery of order."), -2);


			// $rep->NewLine(1);
			// $rep->Font('bold');
			// $rep->TextCol(0, 7, _("Terms and condition:"), - 2);

			// $rep->Font();
			// $rep->NewLine(1);

			// $rep->TextColLines(0, 7, _("               - Above quotation is valid till 10-15 days.
   //             - Above mention Rates are Exclusive of GST and all Govt taxes.
   //             - Quoted prices are Ex-Karachi delivery.
   //             - Trade Mark certificate required at the time of design finalization.
   //             - After quotation validity prices may be revised if there is fluctuation in currency or freight charges.
   //             - Delivery time will be 90-120 days after order confirmation and tin plates approval."), -2);
                 // $rep->lineHeight=12;

// 			$rep->fontSize -= 2;

		// }

	  $rep->Font('bold');
	  $rep->TextWrap(30,150,180,"Term & Condition :"); 
	  $rep->TextWrap(30,135,180,"Validity:"); 
	  $rep->Font();
	  $rep->TextWrap(80,135,180,"Only One Week");
	  $rep->Font('bold'); 
	  $rep->TextWrap(30,125,180,"Payment :");
	  $rep->Font();
	  $rep->TextWrap(80,125,300,"50 % Advance along your valued work Order, 50 % after job completion");
	  $rep->Font('bold'); 
	  $rep->TextWrap(30,115,300,"Job Completion");
	  $rep->Font();
	  $rep->TextWrap(110,115,300,"With in 30 working days after start of work");
	  $rep->Font('bold'); 
	  $rep->TextWrap(30,105,600,"Civil Work :");
	  $rep->Font(); 
	  $rep->TextWrap(100,105,600,"Civil work will be the responsibility of the Hospital includingof the Hospital "); 
	  $rep->TextWrap(30,95,600,"of the Hospital including cutting of walls, burried trenches & electrical work etc."); 

	 // $rep->TextWrap(30,25,180,"REGARDS, ");
	 $rep->Font('bold');  
	 // if($myrow['company_id'] != 1)
     // 	$rep->TextWrap(30,50,180,_("MEDICARE NETWORK PVT. LTD."));
	 // else
 	 $rep->TextWrap(30,50,180,_("MEDICARE NETWORK."));
 	 $rep->TextWrap(150,20,400,"**COMPUTER GENERATED DOCUMENT-NO SIGNATURE REQUIRED**");  
 	 // $rep->Font(); 
     $rep->TextWrap(410,47,180,"________________________________________________"); 
	 // $rep->TextWrap(410,35,180, _("For ".$rep->company['coy_name']),'center');
     $rep->TextWrap(410,30,180, _("Receiver`s Signature"),'center');

		if ($email == 1)
		{
			if ($SysPrefs->print_invoice_no() == 1)
				$myrow['reference'] = $i;
			$rep->End($email);
		}
	}
	if ($email == 0)
		$rep->End();
}

