<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
    Released under the terms of the GNU General Public License, GPL, 
    as published by the Free Software Foundation, either version 3 
    of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_REP_PRINT_PUCHASE_QUOTAION';
// ----------------------------------------------------------------
// $ Revision:  2.0 $
// Creator: Joe Hunt
// date_:   2005-05-19
// Title:   List of Journal Entries
// ----------------------------------------------------------------
$path_to_root="..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/gl/includes/gl_db.inc");
include_once($path_to_root . "/includes/ui/ui_view.inc");

//----------------------------------------------------------------------------------------------------

print_list_of_journal_entries();

//----------------------------------------------------------------------------------------------------

function get_supp_pq($from,$to,$ref_no='')
{
    $from = date2sql($from);
    $to = date2sql($to);
    $sql = "SELECT pq.*, supplier.supp_name, supplier.supp_account_no,supplier.tax_included,
        supplier.gst_no AS tax_id, supplier.trn_id ,
        supplier.curr_code, supplier.payment_terms,
        supplier.address, supplier.contact, pq.tax_group_id
        FROM ".TB_PREF."purch_quotation pq,"
            .TB_PREF."suppliers supplier WHERE  ord_date >= '$from' AND ord_date <= '$to' ";
        if($ref_no!=''){
         $ref=explode(',',$ref_no);
        foreach ($ref as $key => $value) {
        // code...
        if($key==0)
         $sql.=" AND ( pq.reference=".db_escape(trim($value));
        else
         $sql.=" OR  pq.reference=".db_escape(trim($value))." )"; 
         }
        }

        $sql.=" AND pq.supplier_id = supplier.supplier_id";
        return db_query($sql, "The order cannot be retrieved");
    
}

function get_supp_pq_details($order_no){

    $sql = " SELECT * FROM ".TB_PREF."purch_quotation_details WHERE order_no= ".db_escape($order_no);
    return db_query($sql);
}

function print_list_of_journal_entries()
{
    global $path_to_root, $systypes_array;

    $from = $_POST['PARAM_0'];
    $to = $_POST['PARAM_1'];
    $fromsupp = $_POST['PARAM_2'];
    $po_ref = $_POST['PARAM_3'];
    $orientation = $_POST['PARAM_4'];
    $destination = $_POST['PARAM_5'];
    if ($destination)
        include_once($path_to_root . "/reporting/includes/excel_report.inc");
    else
        include_once($path_to_root . "/reporting/includes/pdf_report.inc");

    $orientation = ($orientation ? 'L' : 'P');
    $dec = user_price_dec();

    if($po_ref!=''){
        $ref=explode(',',$po_ref);
        // display_error(count($ref));
    if(count($ref)==1){
        display_error("Compare Quotation Must Be Two Reference Also With 
        Comma Saperated ");
     }
    }

    $cols = array(0, 100, 240, 310, 380);

    $headers = array(_('Item Code'), _('Description'), _('Quantity'), 
        _('Price'), _('Total'));

    $aligns = array('left', 'left', 'left', 'left', 'right');

    $params =   array(  0 => $comments,
    1 => array('text' => _('Period'), 'from' => $from,'to' => $to),
    2 => array('text' => _('Compare ref.'), 'from' => $po_ref,'to' => ''));

    $rep = new FrontReport(_('PURCHASE QUOTATION'), "PurchaseQuotationBulk", user_pagesize(), 9, $orientation);
    if ($orientation == 'L')
        recalculate_cols($cols);

    $rep->Font();
    $rep->Info($params, $cols, $headers, $aligns);
    $rep->NewPage();

    if ($systype == -1)
        $systype = null;

        $result = get_supp_pq($from,$to,$po_ref );
        $SubTotal = 0;
        $items = $prices = array();
        while ($myrow2=db_fetch($result))
        {
            $rep->Font('bold');
            $rep->TextCol(0, 4, $myrow2['supp_name']."   -   ".$myrow2['reference']."   -   ". sql2date($myrow2['ord_date']), -2);
            $rep->Font();
  
            $rep->NewLine(1);
            $res=get_supp_pq_details($myrow2['order_no']);
            while($row =db_fetch($res)){
            $c=0;

            $rep->TextCol($c, ++$c, $row['item_code'], -2);
            $rep->TextCol($c, ++$c, $row['description'], -2);
            // $rep->TextCol($c, ++$c, sql2date($row['delivery_date']), -2);

            $rep->TextCol($c, ++$c, number_format2($row['quantity_ordered']), -2);

            $rep->TextCol($c, ++$c, number_format2($row['unit_price']), -2);
            $line_total= number_format2($row['unit_price']*$row['quantity_ordered']);
            $rep->TextCol($c, ++$c,$line_total, -2);
            $rep->NewLine(1);
              }
            $rep->Line($rep->row += 6);
            $rep->NewLine(2);
            if ($rep->row < $rep->bottomMargin + (15 * $rep->lineHeight))
                $rep->NewPage();
        }
    if ($typeno != 0)
    {
        $rep->Line($rep->row += 6);
        $rep->NewLine();
        $rep->AmountCol(4, 5, $debit, $dec);
        $rep->AmountCol(5, 6, abs($credit), $dec);
        $totdeb += $debit;
        $totcre += $credit;
        $rep->Line($rep->row -= 4);
        $rep->NewLine();
        $rep->TextCol(0, 4, _("Total"));
        $rep->AmountCol(4, 5, $totdeb, $dec);
        $rep->AmountCol(5, 6, abs($totcre), $dec);
        $rep->Line($rep->row -= 4);
    }
    $rep->End();
}

