<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_REP_SALES_REPORT';
// ----------------------------------------------------------------
// $ Revision:	2.0 $
// Creator:	Joe Hunt
// date_:	2005-05-19
// Title:	Sales Summary Report
// ----------------------------------------------------------------
$path_to_root="..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/gl/includes/gl_db.inc");

//------------------------------------------------------------------


print_sales_summary_report();

// function getTaxTransactions($from, $to, $tax_id)
// {
// 	$fromdate = date2sql($from);
// 	$todate = date2sql($to);

// 	$sql = "SELECT d.debtor_no, d.name AS cust_name, d.tax_id, dt.type, dt.trans_no,  
// 			CASE WHEN dt.type=".ST_CUSTCREDIT." THEN (ov_amount+ov_freight+ov_discount)*-1 
// 			ELSE (ov_amount+ov_freight+ov_discount) END *dt.rate AS total
// 		FROM ".TB_PREF."debtor_trans dt
// 			LEFT JOIN ".TB_PREF."debtors_master d ON d.debtor_no=dt.debtor_no
// 		WHERE (dt.type=".ST_SALESINVOICE." OR dt.type=".ST_CUSTCREDIT.") ";
// 	if ($tax_id)
// 		$sql .= "AND tax_id<>'' ";
// 	$sql .= "AND dt.tran_date >=".db_escape($fromdate)." AND dt.tran_date<=".db_escape($todate)."
// 		ORDER BY d.debtor_no"; 
//     return db_query($sql,"No transactions were returned");
// }

function getSalesReport($from, $to, $customer_id=0, $dimension_id=0, $dimension_id2=0, $city_id=0, $branch_id=0, $area=0, $broker=0, $stock_id, $item_group_id=0, $sales_type=0){
	$fromdate = date2sql($from);
	$todate = date2sql($to);

	$sql = " SELECT dtd.stock_id, dtd.description, SUM(dtd.quantity) as quantity,SUM((dtd.unit_price * dtd.quantity) * dt.rate) AS total,dtd.unit_price, sm.units 
	      FROM
			".TB_PREF."debtor_trans as dt,  ".TB_PREF."debtor_trans_details as dtd,
			".TB_PREF."debtors_master as dm,  ".TB_PREF."stock_master as sm,  ".TB_PREF."cust_branch as cb
			WHERE dt.trans_no=dtd.debtor_trans_no AND dtd.debtor_trans_type=dt.type AND  dt.debtor_no=dm.debtor_no AND dtd.stock_id=sm.stock_id AND  dt.debtor_no=cb.debtor_no AND ( dt.type=10 ) AND  dtd.quantity>0 ";

			 $sql .= " AND dt.tran_date >=".db_escape($fromdate)." AND dt.tran_date<=".db_escape($todate);
			 if ($customer_id != 0)
			 $sql .= " AND dm.debtor_no =".db_escape($customer_id);
			  if ($dimension_id != 0)
			 $sql .= " AND dt.dimension_id =".db_escape($dimension_id);

			 if ($dimension_id2 != 0)
			 $sql .= " AND dt.dimension2_id =".db_escape($dimension_id2);

			 if ($city_id != 0)
			 $sql .= " AND dm.city_id =".db_escape($city_id);
			 
			 if ($area != 0)
			 $sql .= " AND cb.area =".db_escape($area); 
			if ($broker != -1)
			 $sql .= " AND dt.sales_person =".db_escape($broker);
			 if ($item_group_id != 0)
			 $sql .= " AND sm.item_group_id =".db_escape($item_group_id); 
			 if ($sales_type != 0)
			 $sql .= " AND dm.sales_type =".db_escape($sales_type);
			  if ($stock_id != '')
			 $sql .= " AND sm.stock_id =".db_escape($stock_id); 

              $sql.=" GROUP BY dtd.stock_id";
			 // display_error($sql);
			 $result = db_query($sql);
			 return $result;
			 // return db_fetch($result);

			 // return $result;
	// return db_query($sql,"No transactions were returned" );
}

// function getTaxes($type, $trans_no)
// {
// 	$sql = "SELECT included_in_price, SUM(CASE WHEN trans_type=".ST_CUSTCREDIT." THEN -amount ELSE amount END * ex_rate) AS tax
// 		FROM ".TB_PREF."trans_tax_details WHERE trans_type=$type AND trans_no=$trans_no GROUP BY included_in_price";

//     $result = db_query($sql,"No transactions were returned");
//     if ($result !== false)
//     	return db_fetch($result);
//     else
//     	return null;
// }    	

//----------------------------------------------------------------------------------------------------

function print_sales_summary_report()
{
	global $path_to_root;
	
	$from = $_POST['PARAM_0'];
	$to = $_POST['PARAM_1'];
	$customer_id = $_POST['PARAM_2'];
	$dimension_id = $_POST['PARAM_3'];
	$dimension_id2 = $_POST['PARAM_4'];
	$city_id = $_POST['PARAM_5'];
	$area = $_POST['PARAM_6'];
	$broker = $_POST['PARAM_7'];
	$stock_id = $_POST['PARAM_8'];
	$item_group_id = $_POST['PARAM_9'];
	$sales_type = $_POST['PARAM_10'];
	$orientation = $_POST['PARAM_11'];
	$destination = $_POST['PARAM_12'];
	
	if ($destination)
		include_once($path_to_root . "/reporting/includes/excel_report.inc");
	else
		include_once($path_to_root . "/reporting/includes/pdf_report.inc");
	$orientation = ($orientation ? 'L' : 'P');

	if ($customer_id == ALL_TEXT)
		$cust = _('All');
	else
		$cust = get_customer_name($customer_id);
		
		
	
	if ($dimension_id == 0)
		$dim = _('All');
	else
		$dim = get_dimension_string($dimension_id);

	if ($dimension_id2 == 0)
		$dim2 = _('All');
	else
		$dim2 = get_dimension_string($dimension_id2);

	if ($city_id == 0)
		$citty = _('All');
	else
		$citty = get_city_name($city_id);
		
	$dec = user_price_dec();

	if ($broker == -1) 
		$sale_Prsn = _('All');
	else
		$sale_Prsn = get_sales_group_name($broker);

	if ($area == 0)
		$sarea = _('All');
	else
		$sarea = get_area_name($area);

	if ($item_group_id == 0) 
	 	$item_group = _('All');
	 else
	 	$item_group = get_item_group_name($item_group_id);
	
	if ($sales_type == 0) 
		$type = _('All');
	else
		$type = get_sales_type_name($sales_type);

	$rep = new FrontReport(_('Sales Report'), "SalesReport", user_pagesize(), 9, $orientation);

	$params =   array( 	0 => $comments,
						1 => array('text' => _('Period'), 'from' => $from, 'to' => $to),
						2 => array( 'text' => _('Customer Id'),'from' => $cust,'to' => ''),
						3 => array( 'text' => _('Dimension'),'from' => $dim,'to' => ''),
						4 => array( 'text' => _('Dimension-2'),'from' => $dim2,'to' => ''),
						5 => array( 'text' => _('City'),'from' => $citty,'to' => ''),
						6 => array( 'text' => _('Area'),'from' => $sarea,'to' => ''),
						7 => array( 'text' => _('Sales Person'),'from' => $sale_Prsn,'to' => ''),
						8 => array( 'text' => _('Item Stock'),'from' => $stock_id,'to' => ''),
						9 => array( 'text' => _('Items Group'),'from' => $item_group,'to' => ''),
						10 => array( 'text' => _('Sales Type'),'from' => $type,'to' => ''));
						// 2 => array( 'text' => _('Tax Id Only'),'from' => $tid,'to' => ''),
						// 4 => array( 'text' => _('Branch Id'),'branch_id' => $branch_id,'to' => ''),

	$cols = array(0, 130, 230, 310, 450, 530, 550);

	$headers = array(_('Item Details'), _('Unit'), _(' Sale Qty'), _(' Sale Amt'), _('Avg Price'));
	$aligns = array('left', 'center', 'right', 'right', 'right');
    if ($orientation == 'L')
    	recalculate_cols($cols);

	$rep->Font();
	$rep->Info($params, $cols, $headers, $aligns);
	$rep->NewPage();
	
	$totalnet = 0.0;
	$transactions = getSalesReport($from, $to, $customer_id, $dimension_id, $dimension_id2, $city_id, $branch_id, $area, $broker, $stock_id, $item_group_id, $sales_type);

	$rep->NewLine(2);
	
	$amt_total = 0;
	$qty_total = 0;
	while ($trans=db_fetch($transactions))
	{
		
				$rep->TextCol(0, 1, $trans['stock_id']." - ".$trans['description']);
				$rep->TextCol(1, 2,	$trans['units']);
				$rep->TextCol(2, 3,	$trans['quantity']);
				// $total = $trans['quantity']*$trans['unit_price'];
				$rep->AmountCol(3, 4, $trans['total'] , $dec);

				$rep->AmountCol(4, 5, $trans['total']/$trans['quantity'] , $dec);
				
				$rep->NewLine();

				if ($rep->row < $rep->bottomMargin + $rep->lineHeight)
				{
					$rep->Line($rep->row - 2);
					$rep->NewPage();
				}
		
	$amt_total += $trans['total'] ;
	$qty_total += $trans['quantity'];
	// display_error($amt_total);
	}

	$rep->Font('bold');
	$rep->NewLine();
	$rep->Line($rep->row + $rep->lineHeight);
	$rep->TextCol(0, 2,	_("Total"));
	$rep->AmountCol(2, 3, $qty_total, $dec);
	$rep->AmountCol(3, 4, $amt_total, $dec);
	$rep->Line($rep->row - 5);
	$rep->Font();

	$rep->End();
}

