<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_REP_OF_PARTIES_NOT_SALE_REPORT';
// ----------------------------------------------------------------
// $ Revision:	2.0 $
// Creator:	Joe Hunt
// date_:	2005-05-19
// Title:	Sales Summary Report
// ----------------------------------------------------------------
$path_to_root="..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/gl/includes/gl_db.inc");
include_once($path_to_root . "/sales/includes/db/city_db.inc");

//------------------------------------------------------------------
report_of_parties_not_sale();

function get_all_customer($customer_id='', $city_id='', $branch_id='')
{
	$sql = "SELECT dt.* FROM ".TB_PREF."debtors_master as dt WHERE !inactive ";
	if($customer_id != '')
		$sql.= " AND dt.debtor_no=".db_escape($customer_id);
	if ($branch_id != 0)
		$sql .= " AND dimension2_id =".db_escape($branch_id);
	 // display_error($branch_id);
	if ($city_id != 0)
	 	$sql .= " AND city_id =".db_escape($city_id);
    return db_query($sql,"No transactions were returned");
}


function _get_debtor_trans($from, $to, $debtor_no='')
{
	$fromdate = date2sql($from);
	$todate = date2sql($to);

	$sql = "SELECT * FROM ".TB_PREF."debtor_trans WHERE type=10 AND debtor_no=".db_escape($debtor_no). " AND tran_date >=".db_escape($fromdate). " AND tran_date<=".db_escape($todate);  
	// display_error($sql);
    $result = db_query($sql,"No transactions were returned");
    return db_num_rows($result);
}

function getTransactions($debtor_no)
{
	$sql = "SELECT dt.* FROM ".TB_PREF."debtor_trans as dt WHERE dt.type=10  AND
		dt.debtor_no=".db_escape($debtor_no);
	$sql .= " ORDER BY dt.debtor_no DESC";
	// display_error($sql);
    $result = db_query($sql,"No transactions were returned");
    return db_fetch($result);
}

//----------------------------------------------------------------------------------------------------

function report_of_parties_not_sale()
{
	global $path_to_root;
	
	$from = $_POST['PARAM_0'];
	$to   = $_POST['PARAM_1'];
	$city_id = $_POST['PARAM_2'];
    $branch_id = $_POST['PARAM_3'];
	$customer_id = $_POST['PARAM_4'];
	$orientation = $_POST['PARAM_5'];
	$destination = $_POST['PARAM_6'];

	if ($destination)
		include_once($path_to_root . "/reporting/includes/excel_report.inc");
	else
		include_once($path_to_root . "/reporting/includes/pdf_report.inc");
	$orientation = ($orientation ? 'L' : 'P');

	if ($customer_id == '') 
	 	$_customer_id = _('All');
    else
	 	$_customer_id = get_customer_name($customer_id);

	 if ($branch_id == 0)
		$dim2 = _('All');
	else
		$dim2 = get_dimension_string($branch_id);

	if ($city_id == 0)
		$citty = _('All');
	else
		$citty = get_city_name($city_id);

	$dec = user_price_dec();

	$rep = new FrontReport(_('Report of Parties Not Sale'), "ReportofPartiesNotSaleReport", user_pagesize(), 9, $orientation);

	$params =   array( 	0 => $comments,
						1 => array('text' => _('Period'), 'from' => $from, 'to' => $to),
						2 => array('text' => _('Customer'),'from' => $_customer_id,'to' => ''),
						3 => array('text' => _('Branch'), 'from' => $dim2, 'to' => ''),
                    	4 => array('text' => _('City'), 'from' => $citty, 'to' => '')
					);

	$cols = array(0, 190, 280, 370, 530, 550);

	$headers = array(_('Customer / Parties'), _('Last Invoice Date'), _('Invoice Number'), _('Last Invoice Amount'));
	$aligns = array('left', 'left', 'right', 'right');
    if ($orientation == 'L')
    	recalculate_cols($cols);

	$rep->Font();
	$rep->Info($params, $cols, $headers, $aligns);
	$rep->NewPage();

	include_once($path_to_root . "/includes/db/customers_db.inc");

	$all_cust = get_all_customer($customer_id, $city_id, $branch_id);	
	while ($trans=db_fetch($all_cust))
	{
		$num_row = _get_debtor_trans($from, $to, $trans['debtor_no']);
		if ($num_row > 0) continue;

		$rep->NewLine();
		$rep->TextCol(0, 1, $trans['debtor_ref'] ." - ". get_customer_name($trans['debtor_no']));


		$transactions = getTransactions($trans['debtor_no']);
		$rep->TextCol(1, 2,	sql2date(($transactions['tran_date'])) ? sql2date($transactions['tran_date']) : '-');
		$rep->TextCol(2, 3, ($transactions['trans_no']) ? $transactions['trans_no'] :
			'-');
		$rep->TextCol(3, 4, ($transactions['ov_amount']) ? $transactions['ov_amount'] : '-');
		$total += $transactions['ov_amount'];
	}
	
	$totalnet += $total;
	$rep->NewLine();

	$rep->Font('bold');
	$rep->NewLine();
	$rep->Line($rep->row + $rep->lineHeight);
	$rep->TextCol(0, 2,	_("Total"));
	$rep->AmountCol(3, 4, $totalnet, $dec);
	$rep->Line($rep->row - 5);
	$rep->Font();
	$rep->End();
}

