<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_REP_LEAS_TIME_OF_ITEM';
// ----------------------------------------------------------------
// $ Revision:	2.0 $
// Creator:	Joe Hunt
// date_:	2005-05-19
// Title:	Sales Summary Report
// ----------------------------------------------------------------
$path_to_root="..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/gl/includes/gl_db.inc");

//------------------------------------------------------------------

print_lead_of_item_report();

function getLeadOfItem($category_id, $item_group_id)
{
	$sql = "SELECT * FROM ".TB_PREF."stock_master WHERE category_id != -1 ";
	if ($category_id != -1)
		$sql .= " AND category_id = ".db_escape($category_id);
	if ($item_group_id)
		$sql .= " AND item_group_id = ".db_escape($item_group_id);
	$sql .= " ORDER BY category_id";
	display_error($sql);
    return db_query($sql,"No transactions were returned");
}


//----------------------------------------------------------------------------------------------------

function print_lead_of_item_report()
{
	global $path_to_root;
	
	$category_id = $_POST['PARAM_0'];
	$item_group_id = $_POST['PARAM_1'];
	$orientation = $_POST['PARAM_2'];
	$destination = $_POST['PARAM_3'];

	if ($category_id == -1)
		$category = _('All');
	else
		$category = get_category_name($category_id);

	if ($item_group_id == 0)
		$item_group = _('All');
	else
		$item_group = get_item_group_name($item_group_id);


	if ($destination)
		include_once($path_to_root . "/reporting/includes/excel_report.inc");
	else
		include_once($path_to_root . "/reporting/includes/pdf_report.inc");
	$orientation = ($orientation ? 'L' : 'P');

	$dec = user_price_dec();

	$rep = new FrontReport(_('Lead Time Of Item'), "LeadTimeofItem", user_pagesize(), 9, $orientation);

	$params =   array( 	0 => $comments,
						1 => array('text' => _('Category'), 'from' => $category, 'to' => $to),
						2 => array(  'text' => _('Item Group'),'from' => $item_group,'to' => ''));

	$cols = array(0, 50, 350, 400);

	$headers = array(_('Serial No'), _('Item Name'), _('Lead Time'));
	$aligns = array('left', 'left', 'right', 'right');
    if ($orientation == 'L')
    	recalculate_cols($cols);

	$rep->Font();
	$rep->Info($params, $cols, $headers, $aligns);
	$rep->NewPage();
	
	$transactions = getLeadOfItem($category_id, $item_group_id);

	$rep->NewLine(2);
	
	$catt = '';
	while ($trans=db_fetch($transactions))
	{
		if ($catt != $trans['category_id'])
		{
			if ($catt != '')
			{
				$rep->Line($rep->row - 2);
				$rep->NewLine(2, 3);
			}
			$rep->Font('bold');
			$rep->TextCol(1, 2, get_category_name($trans['category_id']));
			$rep->Font('');
			$serial_no = 1;
			$catt = $trans['category_id'];
			$rep->NewLine();
		}
		
			$rep->TextCol(0, 1, $serial_no++);
			$rep->TextCol(1, 2, $trans['stock_id']." ".$trans['description']);
			$rep->TextCol(2, 3,	$trans['day']);
			$rep->NewLine();

			if ($rep->row < $rep->bottomMargin + $rep->lineHeight)
			{
				$rep->Line($rep->row - 2);
				$rep->NewPage();
			}
	}
	$rep->Line($rep->row - 5);
	$rep->Font();

	$rep->End();
}

