<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_REP_AGING_BILL_WISE_SUPP_REPORT';
// ----------------------------------------------------------------
// $ Revision:	2.0 $
// Creator:	Joe Hunt
// date_:	2005-05-19
// Title:	Sales Summary Report
// ----------------------------------------------------------------
$path_to_root="..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/gl/includes/gl_db.inc");

//------------------------------------------------------------------


print_Aging_Bill_wise_report();

function getAgingBillWise($from, $to, $supplier_id, $invoice_no)
{
	$fromdate = date2sql($from);
	$todate = date2sql($to);
	// supp_invoice_items

	$sql = " SELECT * ,(ov_amount + ov_gst + ov_discount) AS TotalAmount,
				alloc AS Allocated FROM ".TB_PREF."supp_trans WHERE ";

	$sql .= "  ov_amount!=0   AND tran_date >=".db_escape($fromdate)." AND tran_date<=".db_escape($todate);

	// $sq.=" AND ((ov_amount + ov_gst + ov_discount)-alloc)>0 ";

			if ($supplier_id)
				$sql .= " AND supplier_id =".db_escape($supplier_id);
			if ($invoice_no)
				$sql .= " AND trans_no =".db_escape($invoice_no);

			$sql.= " ORDER BY tran_date";


			return db_query($sql,"No transactions were returned");
}

function get_po_grn_number($type, $trans_no)
{
	$sql = " SELECT * FROM ".TB_PREF."grn_items as gi, ".TB_PREF."supp_invoice_items as sit, ".TB_PREF."grn_batch as gb WHERE gi.id=sit.grn_item_id AND 
		gi.grn_batch_id=gb.id AND sit.supp_trans_type=".db_escape($type) ."  AND sit.supp_trans_no=".db_escape($trans_no);
		// return db_query($sql,"No transactions were returned");
		$result = db_query($sql);
		return db_fetch($result);
}

  	

//----------------------------------------------------------------------------------------------------

function print_Aging_Bill_wise_report()
{
	global $path_to_root;
	$from = $_POST['PARAM_0'];
	$to = $_POST['PARAM_1'];
	$supplier_id = $_POST['PARAM_2'];
	$invoice_no = $_POST['PARAM_3'];
	$aging_id = $_POST['PARAM_4'];
	$orientation = $_POST['PARAM_5'];
	$destination = $_POST['PARAM_6'];

	if ($destination)
		include_once($path_to_root . "/reporting/includes/excel_report.inc");
	else
		include_once($path_to_root . "/reporting/includes/pdf_report.inc");
	$orientation = ($orientation ? 'L' : 'P');

	if ($supplier_id == ALL_TEXT)
		$supp = _('All');
	else
		$supp = get_supplier_name($supplier_id);

	if ($invoice_no == '')
		$Invoice = _('All');
	else
		$Invoice = $invoice_no;

	$dec = user_price_dec();

	$rep = new FrontReport(_('Aging Bill Wise Report'), "AgingBillWiseReport", user_pagesize(), 9, $orientation);

	$params =   array( 	0 => $comments,
						1 => array('text' => _('Period'), 'from' => $from, 'to' => $to),
						2 => array( 'text' => _('Supplier Id'),'from' => $supp,'to' => ''),
						3 => array( 'text' => _('Invoice #'),'from' => $Invoice,'to' => ''),
						// 4 => array( 'text' => _('Sales Person'),'from' => $sale_Prsn,'to' => ''),
						// 5 => array( 'text' => _('Item Stock'),'from' => $stock_id,'to' => ''),
						// 6 => array( 'text' => _('Items Group'),'from' => $item_group,'to' => ''),
						// 7 => array( 'text' => _('Sales Type'),'from' => $type,'to' => '')
					);

	$cols = array(0, 110, 170, 220, 290, 360, 410, 460, 510, 550);

$headers = array(_('Account'), _('PO NO'), _('GRN'), _('Invoice NO'), _('Inv Date'), _('Total Amt'), _('Payment Amt'), _('Due Date'), _('Days'));
	$aligns = array('left', 'left', 'left', 'left', 'center', 'center', 'left', 'left', 'left', 'left', 'left');
    if ($orientation == 'L')
    	recalculate_cols($cols);

	$rep->Font();
	$rep->Info($params, $cols, $headers, $aligns);
	$rep->NewPage();
	
	// $totalnet = 0.0;
	$transactions = getAgingBillWise($from, $to, $supplier_id, $invoice_no);

	$rep->NewLine(2);
	
	$amt_total = 0;
	$qty_total = 0;
	$bal_amt   = 0;
	while ($trans=db_fetch($transactions))
	{
		// global $systypes_array;
		if(abs($trans['TotalAmount'])==$trans['alloc'])
			continue;
		
				$rep->TextCol(0, 1, get_supplier_name($trans['supplier_id']));

				$po_grn = get_po_grn_number($trans['type'], $trans['trans_no']);
				$rep->TextCol(1, 2,	($po_grn['purch_order_no']) ? $po_grn['purch_order_no'] : '-');
				$rep->TextCol(2, 3,	($po_grn['grn_batch_id']) ? $po_grn['grn_batch_id'] : '-');
				$rep->TextCol(3, 4,	$trans['reference']);
				// $rep->TextCol(4, 5,	$systypes_array[$trans['type']]);
				// $data = get_sales_parent_numbers(ST_SALESINVOICE, $trans['trans_no']);
				$rep->TextCol(4, 5, $trans['tran_date']);
				$rep->AmountCol(5, 6,abs($trans['TotalAmount']),2,0,0,0,0,null,1,true);
				// ($c, $n, $txt, $dec=0, $corr=0, $r=0, $border=0, $fill=0, $link=NULL, $stretch=1, $color_red=false)
				$pending=$trans['TotalAmount']-$trans['alloc'];
				$rep->AmountCol(6, 7,	$pending);
				$rep->TextCol(7, 8,	$trans['due_date']);
				$data = Today();

				$bal_amt=$bal_amt+$trans['TotalAmount'];
				// display_error($data);
				if(!$aging_id)
				$numberDays = date_diff2(sql2date($trans['tran_date']), $data, 'd');
				else
					$numberDays = date_diff2(sql2date($trans['due_date']), $data, 'd');
				// display_error(Today($trans['tran_date']));
					// $rep->AmountCol(7, 8, $numberDays);
				$rep->TextCol(8, 9, abs($numberDays));	
				$total = $trans['TotalAmount']; //($trans['quantity']*$trans['unit_price']) * $trans['rate'] ;
				// $rep->AmountCol(10, 11, $total, $dec);


				
				$rep->NewLine();

				if ($rep->row < $rep->bottomMargin + $rep->lineHeight)
				{
					$rep->Line($rep->row - 2);
					$rep->NewPage();
				}
		
	$amt_total += $total;
	$qty_total += $trans['alloc'];
	// display_error($amt_total);
	}

	$rep->Font('bold');
	$rep->NewLine();
	$rep->Line($rep->row + $rep->lineHeight);
	$rep->TextCol(0, 2,	_("Total"));
	$rep->AmountCol(5, 6, $amt_total, $dec);
	$rep->AmountCol(6, 7, $qty_total, $dec);
	$rep->Line($rep->row - 5);
	$rep->Font();

	$rep->End();
}

