<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_REP_ITEM_WISE_PURCAHSE';
// ----------------------------------------------------------------
// $ Revision:	2.0 $
// Creator:	Joe Hunt
// date_:	2005-05-19
// Title:	Sales Summary Report
// ----------------------------------------------------------------
$path_to_root="..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/gl/includes/gl_db.inc");

//------------------------------------------------------------------


Print_Item_wise_purchase_report();

function getItemWisePurchaseReport($from, $to, $item_id, $supplier_id, $po, $grn, $invoice_no)
{
	$fromdate = date2sql($from);
	$todate = date2sql($to);

	$sql = " SELECT st.*, sit.*, gb.*, gi.*, pod.*, gi.item_code, gb.dc_no FROM ".TB_PREF."supp_trans as st, ".TB_PREF."supp_invoice_items as sit, ".TB_PREF."grn_items as gi, ".TB_PREF."purch_order_details as pod, ".TB_PREF."grn_batch as gb WHERE st.trans_no=sit.supp_trans_no AND st.type=sit.supp_trans_type AND sit.grn_item_id=gi.id AND gi.po_detail_item=pod.po_detail_item AND gi.grn_batch_id=gb.id";
	

			$sql .= " AND st.tran_date >=".db_escape($fromdate)." AND st.tran_date<=".db_escape($todate);

			if ($item_id)
				$sql .= " AND gi.item_code =".db_escape($item_id);

			if ($supplier_id)
				$sql .= " AND st.supplier_id =".db_escape($supplier_id);

			if ($po)
				$sql .= " AND gb.purch_order_no =".db_escape($po);

			if ($grn)
				$sql .= " AND gb.id =".db_escape($grn);

			if ($invoice_no)
				$sql .= " AND st.trans_no =".db_escape($invoice_no);
		// display_error($sql);
			return db_query($sql,"No transactions were returned");
}

function get_po_grn_number($type, $trans_no)
{
	$sql = " SELECT * FROM ".TB_PREF."grn_items as gi, ".TB_PREF."supp_invoice_items as sit, ".TB_PREF."grn_batch as gb WHERE gi.id=sit.grn_item_id AND 
		gi.grn_batch_id=gb.id AND sit.supp_trans_type=".db_escape($type) ."  AND sit.supp_trans_no=".db_escape($trans_no);
		// return db_query($sql,"No transactions were returned");
		$result = db_query($sql);
		return db_fetch($result);
}

  	

//----------------------------------------------------------------------------------------------------

function Print_Item_wise_purchase_report()
{
	global $path_to_root;
	$from = $_POST['PARAM_0'];
	$to = $_POST['PARAM_1'];
	$item_id = $_POST['PARAM_2'];
	$supplier_id = $_POST['PARAM_3'];
	$po = $_POST['PARAM_4'];
	$grn = $_POST['PARAM_5'];
	$invoice_no = $_POST['PARAM_6'];
	$orientation = $_POST['PARAM_7'];
	$destination = $_POST['PARAM_8'];

	if ($destination)
		include_once($path_to_root . "/reporting/includes/excel_report.inc");
	else
		include_once($path_to_root . "/reporting/includes/pdf_report.inc");
	$orientation = ($orientation ? 'L' : 'L');

	if ($supplier_id == ALL_TEXT)
		$supp = _('All');
	else
		$supp = get_supplier_name($supplier_id);

	if ($item_id == ALL_TEXT) {
		// display_error($item_id);
		display_error(_("Item must be select !"));
		exit();
	}

	if ($po == '')
		$PO_no = _('All');
	else
		$PO_no = $po;

	if ($grn == '')
		$GRN_no = _('All');
	else
		$GRN_no = $grn;

	if ($invoice_no == '')
		$Invoice = _('All');
	else
		$Invoice = $invoice_no;


	$dec = user_price_dec();

	$rep = new FrontReport(_('Item Wise Purchase Report'), "ItemWisePurchaseReport", user_pagesize(), 9, $orientation);


	$params =   array( 	0 => $comments,
						1 => array('text' => _('Period'), 'from' => $from, 'to' => $to),
						2 => array( 'text' => _('Supplier Id'),'from' => $supp,'to' => ''),
						3 => array( 'text' => _('PO NO'),'from' => $PO_no,'to' => ''),
						4 => array( 'text' => _('GRN NO'),'from' => $GRN_no,'to' => ''),
						5 => array( 'text' => _('Invoice #'),'from' => $Invoice,'to' => ''),
						// 4 => array( 'text' => _('Sales Person'),'from' => $sale_Prsn,'to' => ''),
						// 5 => array( 'text' => _('Item Stock'),'from' => $stock_id,'to' => ''),
						// 6 => array( 'text' => _('Items Group'),'from' => $item_group,'to' => ''),
						// 7 => array( 'text' => _('Sales Type'),'from' => $type,'to' => '')
					);

	$cols = array(0, 60, 130, 170, 210, 260, 310, 400, 450, 480, 530, 600);

$headers = array(_('Date'), _('Vendor'), _('PO #'), _('GRN #'), _('Invoice #'), _('DC #'), _('RCVD Location'), _('Qty'), _('Unit'), _('Price'), _('Amount'));
	$aligns = array('left', 'left', 'left', 'left', 'left', 'left', 'left', 'left', 'left', 'left', 'left', 'left');
    if ($orientation == 'L')
    	recalculate_cols($cols);

	$rep->Font();
	$rep->Info($params, $cols, $headers, $aligns);
	$rep->NewPage();
	
	// $totalnet = 0.0;
	$transactions = getItemWisePurchaseReport($from, $to, $item_id, $supplier_id, $po, $grn, $invoice_no);

	$rep->NewLine(2);
	
	$unit_price = 0;
	$qty_total = 0;
	$amt_total = 0;
	$item = '';
	while ($trans=db_fetch($transactions))
	{
		if ($item != $trans['description'])
		{
			if ($item != '')
			{
				$rep->Line($rep->row - 2);
				$rep->NewLine(2, 3);
			}
			$rep->Font('bold');
			$rep->TextCol(0, 2, $trans['description']);
			$rep->Font('');
			$item = $trans['description'];
			$rep->NewLine();
		}
		
				$rep->TextCol(0, 1, $trans['tran_date']);
				$oldrow = $rep->row;
				$rep->TextColLines(1, 2, get_supplier_name($trans['supplier_id']));
				$newrow = $rep->row;
				$rep->row = $oldrow;
				$po_grn = get_po_grn_number($trans['type'], $trans['trans_no']);
				$rep->TextCol(2, 3,	$po_grn['purch_order_no']);
				$rep->TextCol(3, 4,	$po_grn['grn_batch_id']);
				$rep->TextCol(4, 5,	$trans['trans_no']);
				$rep->TextCol(5, 6,	$trans['dc_no']);
				$rep->TextCol(6, 7,	$trans['loc_code']);
				$rep->TextCol(7, 8,	$trans['quantity']);
				$data = get_item($trans['item_code']);
				$rep->TextCol(8, 9, $data['units'] ? $data['units'] : '-');
				$rep->TextCol(9, 10, $trans['unit_price']);
				$amount = $trans['quantity']*$trans['unit_price'];
				$rep->TextCol(10, 11, $amount);
				$rep->row = $newrow;
				$rep->NewLine();

				if ($rep->row < $rep->bottomMargin + $rep->lineHeight)
				{
					$rep->Line($rep->row - 2);
					$rep->NewPage();
				}
		
	$qty_total += $trans['quantity'];
	$unit_price += $trans['unit_price'];
	$amt_total += $amount;
	// display_error($amt_total);
	}

	$rep->Font('bold');
	$rep->NewLine();
	$rep->Line($rep->row + $rep->lineHeight);
	$rep->TextCol(0, 2,	_("Total"));
	$rep->AmountCol(7, 8, $qty_total, $dec);
	$rep->AmountCol(9, 10, $unit_price, $dec);
	$rep->AmountCol(10, 11, $amt_total, $dec);
	$rep->Line($rep->row - 5);
	$rep->Font();

	$rep->End();
}

