<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_REP_PURCHASE_SUMMARY_SUPPLIER';
// ----------------------------------------------------------------
// $ Revision:	2.0 $
// Creator:	Joe Hunt
// date_:	2005-05-19
// Title:	Sales Summary Report
// ----------------------------------------------------------------
$path_to_root="..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/gl/includes/gl_db.inc");

//------------------------------------------------------------------

print_lead_of_item_report();

function getPurchaseSummary($from, $to, $item_id, $supplier_id)
{
	$fromdate = date2sql($from);
	$todate = date2sql($to);

	$sql = "SELECT supp.*, sii.*, st.* FROM ".TB_PREF."suppliers as supp, ".TB_PREF."supp_trans as st, ".TB_PREF."supp_invoice_items as sii WHERE st.trans_no=sii.supp_trans_no
	 AND st.supplier_id=supp.supplier_id";

	 $sql .= " AND st.tran_date >=".db_escape($fromdate)." AND st.tran_date<=".db_escape($todate);

	if ($item_id)
		$sql .= " AND sii.stock_id = ".db_escape($item_id);
	if ($supplier_id)
		$sql .= " AND st.supplier_id = ".db_escape($supplier_id);
	// display_error($sql);
	// $sql .= " ORDER BY category_id";
    return db_query($sql,"No transactions were returned");
}

//----------------------------------------------------------------------------------------------------

function print_lead_of_item_report()
{
	global $path_to_root;
	
	$from = $_POST['PARAM_0'];
	$to = $_POST['PARAM_1'];
	$item_id = $_POST['PARAM_2'];
	$supplier_id = $_POST['PARAM_3'];
	$orientation = $_POST['PARAM_4'];
	$destination = $_POST['PARAM_5'];

	if ($category_id == -1)
		$category = _('All');
	else
		$category = get_category_name($category_id);

	if ($item_group_id == 0)
		$item_group = _('All');
	else
		$item_group = get_item_group_name($item_group_id);


	if ($destination)
		include_once($path_to_root . "/reporting/includes/excel_report.inc");
	else
		include_once($path_to_root . "/reporting/includes/pdf_report.inc");
	$orientation = ($orientation ? 'L' : 'P');

	$dec = user_price_dec();

	$rep = new FrontReport(_('PurchaseSummaryVendorReport'), "Purchase Summary Vendor Report", user_pagesize(), 9, $orientation);

	$params =   array( 	0 => $comments,
						1 => array('text' => _('Category'), 'from' => $category, 'to' => $to),
						2 => array(  'text' => _('Item Group'),'from' => $item_group,'to' => ''));

	$cols = array(0, 50, 250, 350, 450, 550);

	$headers = array(_('Serial No'), _('Item Name'), _('Quantity'), _('UOM'), _('Amount'));
	$aligns = array('left', 'center', 'center', 'center', 'center');
    if ($orientation == 'L')
    	recalculate_cols($cols);

	$rep->Font();
	$rep->Info($params, $cols, $headers, $aligns);
	$rep->NewPage();

	$transactions = getPurchaseSummary($from, $to, $item_id, $supplier_id);

	$rep->NewLine(2);
	
	$catt = '';
	$serial_no = 1;
	while ($trans=db_fetch($transactions))
	{
		if ($catt != $trans['supp_name'])
		{
			if ($catt != '')
			{
				$rep->Line($rep->row - 2);
				$rep->NewLine(2, 3);
			}
			$rep->Font('bold');
			$rep->TextCol(0, 2, $trans['supp_name']);
			$rep->Font('');
			// $serial_no = 1;
			$catt = $trans['supp_name'];
			$rep->NewLine();
		}
		
			$rep->TextCol(0, 1, $serial_no++);
			$rep->TextCol(1, 2, $trans['description']);
			$rep->TextCol(2, 3,	$trans['quantity']);
			// display_error($trans['stock_id']);
			$data = get_item($trans['stock_id']);
			$rep->TextCol(3, 4, $data['units']);
			$rep->TextCol(4, 5,	abs($trans['ov_amount']));
			$rep->NewLine();

			if ($rep->row < $rep->bottomMargin + $rep->lineHeight)
			{
				$rep->Line($rep->row - 2);
				$rep->NewPage();
			}
	}
	$rep->Line($rep->row - 5);
	$rep->Font();

	$rep->End();
}

