<?php

$page_security = 'SA_PAYMENT';
$path_to_root="..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/sales/includes/sales_db.inc");
include_once($path_to_root . "/reporting/amount_words.php");

print_payment_report();

//pk
function checking_report($id){
	$sql = " SELECT * FROM ".TB_PREF."report_sign WHERE rep_id = '$id' ";
	 // display_error($sql);
	$result = db_query($sql,"Did not Executed");
	return $result;
}

//----------------------------------------------------------------------------------------------------

function print_payment_report()
{
	global $path_to_root, $SysPrefs, $bank_transfer_types;
	
	include_once($path_to_root . "/reporting/includes/pdf_report_payment.inc");

	$form= $_POST['PARAM_0'];
	$to = $_POST['PARAM_1'];
	$currency = $_POST['PARAM_2'];
	$email = $_POST['PARAM_3'];
	$paylink = $_POST['PARAM_4'];
	$comments = $_POST['PARAM_5'];
	$orientation = $_POST['PARAM_6'];
	$REPORT_ID = 974;

     $from  = explode('-', $form);
     $trans_id=$from[0];
     $type = $from[1];
	if (!$trans_id || !$to) return;

	$orientation = ($orientation ? 'L' : 'P');
	$dec = user_price_dec();

 	 
	$cols = array(4, 60, 250, 350, 450, 500, 460);

	// $headers in doctext.inc
	$aligns = array('left',	'left',	'left',	'left', 'right', 'right');

	$params = array('comments' => $comments);

	$cur = get_company_Pref('curr_default');

	if ($email == 0)
		$rep = new FrontReport(_('Bank Payment'), "BankPayment", user_pagesize(), 8, $orientation);
    if ($orientation == 'L')
    	recalculate_cols($cols);

 
 // display_error($trans_id);exit();
    if($type==ST_JOURNAL)
    $result = get_gl_trans( $type, $trans_id);
    else
    $result = get_bank_trans(  $type, $trans_id);
	// if (db_num_rows($result) != 1){
	// 	display_db_error("duplicate payment bank transaction found", "");
	// 	exit;
	// }

	$voided = is_voided_display(  $type, $trans_id, _("This payment has been voided."));
	$myrow = db_fetch($result);
	// print_r($myrow);exit();
	
		// $myrow = get_customer_trans($trans_id, ST_CUSTCREDIT);
		
		$branch=null;
		$baccount=null;
		$sales_order = null;
		$contacts=null;
		if ($email == 1)
		{
			$rep = new FrontReport("", "", user_pagesize(), 9, $orientation);
			$rep->title = _('Bank Payment');
			$rep->filename = "BankPayment" . $myrow['ref'] . ".pdf";
		}
		$rep->currency = $cur;
		$rep->Font();
		$rep->Info($params, $cols, null, $aligns);

		$rep->SetCommonData($myrow, $branch, $sales_order, $baccount,   $type, $contacts);
		$rep->SetHeaderType('Header2');
		$rep->NewPage();


		$rep->selectFont('times');
		
		$items = get_gl_trans(  $type, $trans_id);
		if (db_num_rows($items)==0){
			display_error(_("There are no items for this payment."));
			exit;
		}
		 $rec_row=158;
		while ($item = db_fetch($items)){
			// if ($item["account"] != $myrow["account_code"]){

				$rep->TextCol(0, 1, $item["account"]);
            
            $counterpartyname = get_subaccount_name($item["account"], $item["person_id"]);

				$oldrow = $rep->row;
				$rep->TextColLines(1, 2, $item["account_name"]." \n".$counterpartyname);
				$newrow[] = $rep->row;
				$rep->row = $oldrow;

				if($item['dimension_id'] > 0){
					$oldrow = $rep->row;
					$rep->TextColLines(2, 3, trim(get_dimension_string($item['dimension_id'], true)));
					$newrow[] = $rep->row;
					$rep->row = $oldrow;
				}
				else
				$rep->TextCol(2, 3, '-');	
				if($item['dimension2_id'] > 0){
					$oldrow = $rep->row;
					$rep->TextColLines(3, 4, trim(get_dimension_string($item['dimension2_id'], true)));
					$newrow[] = $rep->row;
					$rep->row = $oldrow;
				}
				else
				$rep->TextCol(3, 4, '-');	

                if($item['amount']<0.0)				
				$rep->AmountCol(5, 6, abs($item['amount']), $dec);
			    else
			    $rep->AmountCol(4, 5, $item['amount'], $dec);	
				// if($item['memo_'] != null){
					$rep->row = min($newrow);
					// $rep->newLine(0.5);
					$rep->TextColLines(1, 2, $item['memo_']);
					// $rep->newLine(0.5);
					$newrow[] = $rep->row;
					$rep->row = $oldrow;

			

			if ($item['amount'] > 0 ) 
            $debit += $item['amount'];
            else 
            $credit += abs($item['amount']);

				$h_val=$rep->row-min($newrow);	
				$rep->row = min($newrow);
			// display_error($rep->row." == ". min($newrow)." == ".$h_val);
				unset($newrow);
				// $rep->newLine(0.5);
				// $rep->Line($rep->row+12);
			$rep->SetLineStyle(array('width' => 0.5, 'cap' => 'butt', 'join' => 'miter', 'dash' =>0, 'color' => array(0, 0, 0)));
			// display_error($rec_row." ==  ".$h_val);
			$rep->RoundedRect(30,$rec_row, 560, $h_val, 5, '0000', 'D');
			$rec_row+=$h_val;
				// unset($newrow);
				$total_amount += $item["amount"];
				if ($rep->row < $rep->bottomMargin + (15 * $rep->lineHeight-80)){
						 $rec_row=109;
					$rep->NewPage();
				}
				// else
				// 	$rep->Line($rep->row+12);


			// }

		     
		}

		$rep->Font('bold');

		$rep->AmountCol(5, 6, $debit, $dec);

		$rep->AmountCol(4, 5, $credit, $dec);	
		$rep->Font('bold');

		$rep->TextColLines(0, 5, ucwords(numberTowords($debit)." only"));
// 		$rec_row+=$h_val;
// $rep->RoundedRect(30,$rec_row+$h_val, 560, $h_val, 5, '0000', 'D');

$rep->RoundedRect(30,$rec_row, 560, $h_val*3, 5, '0110', 'D');
	$rec_row+=$h_val;

$rep->NewLine(3);

$user_row = get_audit_trail_last_data($type, $trans_id);

        $rep->TextWrap(55,$rep->row+5,150,$user_row['user_id']); 
        $rep->TextWrap(35,$rep->row,150,"__________________"); 
        $rep->TextWrap(45,$rep->row-10,150,'Prepared By'); 


        $rep->TextWrap(145,$rep->row,150,"__________________"); 
        $rep->TextWrap(155,$rep->row-10,150,'Checked By'); 

        $rep->TextWrap(255,$rep->row,150,"____________________________"); 
        $rep->TextWrap(265,$rep->row-10,150,'G. Manager / F. Manager'); 
       

        $rep->TextWrap(410,$rep->row,150,"__________________"); 
        $rep->TextWrap(420,$rep->row-10,150,'Authorized By');

        $rep->TextWrap(515,$rep->row,150,"_______________"); 
        $rep->TextWrap(525,$rep->row-10,150,'Received By');


		


		
		if ($email == 1)
		{
			$rep->End($email);
		}


	if ($email == 0)
		$rep->End();
}

