<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL,
	as published by the Free Software Foundation, either version 3
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$path_to_root="..";
$page_security = 'SA_OPEN';
include_once($path_to_root . "/includes/session.inc");

include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/includes/ui.inc");
include_once($path_to_root . "/reporting/includes/reports_classes.inc");
$js = "";
if ($SysPrefs->use_popup_windows && $SysPrefs->use_popup_search)
	$js .= get_js_open_window(900, 500);
if (user_use_date_picker())
	$js .= get_js_date_picker();

add_js_file('reports.js');

page(_($help_context = "Reports and Analysis"), false, false, "", $js);

$reports = new BoxReports;

$dim = get_company_pref('use_dimension');

$reports->addReportClass(_('Customer'), RC_CUSTOMER);
$reports->addReport(RC_CUSTOMER, 101, _('Customer &Balances'),
	array(	_('Start Date') => 'DATEBEGIN',
			_('End Date') => 'DATEENDM',
			_('Customer') => 'CUSTOMERS_NO_FILTER',
			_('Show Balance') => 'NO_YES',
			_('Currency Filter') => 'CURRENCY',
			_('Suppress Zeros') => 'YES_NO',
			_('Comments') => 'TEXTBOX',
			_('Branch') =>  'DIMENSIONS2',
			_('City') => 'CITY',
			_('Sales Types') => 'SALESTYPES',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'), SA_REP_CUSTOMER_BALANCE);
$reports->addReport(RC_CUSTOMER, 117, _('New Customer Ledger Report'),
	array(	_('Start Date') => 'DATEBEGIN',
			_('End Date') => 'DATEENDM',
			_('Customer') => 'CUSTOMERS_NO_FILTER',
			_('Show Balance') => 'YES_NO',
			_('Currency Filter') => 'CURRENCY',
			_('Suppress Zeros') => 'YES_NO',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'),SA_REP_CUSTOMER_BALANCE);

$reports->addReport(RC_CUSTOMER, 116, _('Multi Select Customer &Balances'),
	array(	_('Start Date') => 'DATEBEGIN',
			_('End Date') => 'DATEENDM',
			_('Customer') => 'MULTI_CUSTOMERS',
			_('Show Balance') => 'NO_YES',
			_('Currency Filter') => 'CURRENCY',
			_('Suppress Zeros') => 'YES_NO',
			_('Comments') => 'TEXTBOX',
			_('Branch') =>  'DIMENSIONS2',
			_('City') => 'CITY',
			_('Sales Types') => 'SALESTYPES',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'), SA_REP_CUSTOMER_BALANCE);

$reports->addReport(RC_CUSTOMER, 102, _('&Aged Customer Analysis'),
	array(	_('End Date') => 'DATE',
			_('Customer') => 'CUSTOMERS_NO_FILTER',
			_('Branch') =>  'DIMENSIONS2',
			_('City') => 'CITY',
			_('Currency Filter') => 'CURRENCY',
			_('Show Also Allocated') => 'YES_NO',
			_('Summary Only') => 'YES_NO',
			_('Suppress Zeros') => 'YES_NO',
			_('Graphics') => 'GRAPHIC',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'), SA_REP_AGED_CUST_REP);
$reports->addReport(RC_CUSTOMER, 115, _('Customer Trial Balance'),
    array(  _('Start Date') => 'DATEBEGIN',
            _('End Date') => 'DATEENDM',
            _('Customer') => 'CUSTOMERS_NO_FILTER',
            _('Sales Areas') => 'AREAS',
            _('Branch') =>  'DIMENSIONS2',
			_('City') => 'CITY',
            _('Sales Folk') => 'SALESMEN',
            _('Sales Types') => 'SALESTYPES',
            _('Currency Filter') => 'CURRENCY',
            _('Suppress Zeros') => 'YES_NO',
            _('Comments') => 'TEXTBOX',
            _('Orientation') => 'ORIENTATION',
            _('Destination') => 'DESTINATION'), SA_REP_CUST_TRIAL_BALANCE);
$reports->addReport(RC_CUSTOMER, 103, _('Customer &Detail Listing'),
	array(	_('Activity Since') => 'DATEBEGIN',
			_('City') => 'CITY',
			_('Sales Areas') => 'AREAS',
			_('Dimension')." 2" =>  'DIMENSIONS2',
			_('Sales Folk') => 'SALESMEN',
			_('Sales Types') => 'SALESTYPES',
			_('Activity Greater Than') => 'TEXT',
			_('Activity Less Than') => 'TEXT',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'), SA_REP_CUST_DETAIL_LISTING);
$reports->addReport(RC_CUSTOMER, 114, _('Sales &Summary Report'),
	array(	_('Start Date') => 'DATEBEGINTAX',
			_('End Date') => 'DATEENDTAX',
			_('Branch') =>  'DIMENSIONS2',
			_('City') => 'CITY',
			_('Tax Id Only') => 'YES_NO',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'), SA_REP_SALES_SUMMARY);
	$reports->addReport(RC_CUSTOMER, 214, _('Sales &Report'),
	array(	_('Start Date') => 'DATEBEGINTAX',
			_('End Date') => 'DATEENDM',
			_('Customers') => 'CUSTOMERS_NO_FILTER',
			_('Dimension')." 1" =>  'DIMENSIONS1',
			_('Dimension')." 2" =>  'DIMENSIONS2',
			_('City') => 'CITY',
			_('Area') => 'AREAS',
			_('Broker/ sales person') => 'SALESMEN',
			_('Items') => 'ITEMS_STOCK',
			_('Items Group') => 'ITEMS_GROUP',
			_('Sales Type') => 'SALESTYPES',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'), SA_REP_SALES_REPORT);
$reports->addReport(RC_CUSTOMER, 215, _('Total Sales Customer Wise &Report'),
	array(	_('Start Date') => 'DATEBEGINTAX',
			_('End Date') => 'DATEENDM',
			_('Customers') => 'CUSTOMERS_NO_FILTER',
			_('Area') => 'AREAS',
			_('Dimension')." 2" =>  'DIMENSIONS2',
			_('City') => 'CITY',
			_('Broker/ sales person') => 'SALESMEN',
			_('Items') => 'ITEMS_STOCK',
			_('Items Group') => 'ITEMS_GROUP',
			_('Sales Type') => 'SALESTYPES',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'), SA_REP_TOTAL_SALES_CUSTOMER_WISE_REPORT);
$reports->addReport(RC_CUSTOMER, 220, _('Total Credit Note Customer Wise &Report'),
	array(	_('Start Date') => 'DATEBEGINTAX',
			_('End Date') => 'DATEENDM',
			_('Customers') => 'CUSTOMERS_NO_FILTER',
			_('Area') => 'AREAS',
			_('Dimension')." 2" =>  'DIMENSIONS2',
			_('City') => 'CITY',
			_('Broker/ sales person') => 'SALESMEN',
			_('Items') => 'ITEMS_STOCK',
			_('Items Group') => 'ITEMS_GROUP',
			_('Sales Type') => 'SALESTYPES',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'), SA_REP_TOTAL_CREDIT_NOTE_CUSTOMER_WISE_REPORT);			
$reports->addReport(RC_CUSTOMER, 216, _('Sales Detail &Report'),
	array(	_('Start Date') => 'DATEBEGINTAX',
			_('End Date') => 'DATEENDM',
			_('City') => 'CITY',
			_('Dimension')." 2" =>  'DIMENSIONS2',
			_('Customers') => 'CUSTOMERS_NO_FILTER',
			_('Area') => 'AREAS',
			_('Broker/ sales person') => 'SALESMEN',
			_('Items') => 'ITEMS_STOCK',
			_('Items Group') => 'ITEMS_GROUP',
			_('Sales Type') => 'SALESTYPES',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'), SA_REP_SALES_DETAIL_REPORT);
			
$reports->addReport(RC_CUSTOMER, 225, _('Gross Profit Analysis'),
	array(	_('Start Date') => 'DATEBEGINTAX',
			_('End Date') => 'DATEENDM',
			_('City') => 'CITY',
			_('Dimension')." 2" =>  'DIMENSIONS2',
			_('Customers') => 'CUSTOMERS_NO_FILTER',
			_('Area') => 'AREAS',
			_('Broker/ sales person') => 'SALESMEN',
			_('Items') => 'ITEMS_STOCK',
			_('Items Group') => 'ITEMS_GROUP',
			_('Sales Type') => 'SALESTYPES',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'), SA_REP_TOTAL_CREDIT_NOTE_CUSTOMER_WISE_REPORT);
			
$reports->addReport(RC_CUSTOMER, 221, _('Credit Note Detail &Report'),
	array(	_('Start Date') => 'DATEBEGINTAX',
			_('End Date') => 'DATEENDM',
			_('City') => 'CITY',
			_('Dimension')." 2" =>  'DIMENSIONS2',
			_('Customers') => 'CUSTOMERS_NO_FILTER',
			_('Area') => 'AREAS',
			_('Broker/ sales person') => 'SALESMEN',
			_('Items') => 'ITEMS_STOCK',
			_('Items Group') => 'ITEMS_GROUP',
			_('Sales Type') => 'SALESTYPES',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'), SA_REP_CREDIT_NOTE_DETAIL_REPORT);			
$reports->addReport(RC_CUSTOMER, 217, _('Aging Bill Wise &Report'),
	array(	_('Start Date') => 'DATEBEGINTAX',
			_('End Date') => 'DATEENDM',
			_('Customers') => 'CUSTOMERS_NO_FILTER',
			_('Show Balance') => 'NO_YES',
			_('Dimension')." 2" =>  'DIMENSIONS2',
			_('City') => 'CITY',
			_('Area') => 'AREAS',
			_('Broker/ sales person') => 'SALESMEN',
			_('Items') => 'ITEMS_STOCK',
			_('Items Group') => 'ITEMS_GROUP',
			_('Sales Type') => 'SALESTYPES',
			_('Aging List') => 'AGING_LIST',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'), SA_REP_AGING_BILL_WISE_CUST_REPORT);
			
$reports->addReport(RC_CUSTOMER, 218, _('Report Of &Parties Not Sale'),
	array(	_('Start Date') => 'DATEBEGINM',
			_('End Date') => 'DATEENDM',
			_('City') => 'CITY',
			_('Branch') =>  'DIMENSIONS2',
			_('Parties / Customers') => 'CUSTOMERS_NO_FILTER',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'), SA_REP_OF_PARTIES_NOT_SALE_REPORT);
			
$reports->addReport(RC_CUSTOMER, 104, _('&Price Listing'),
	array(	_('Currency Filter') => 'CURRENCY',
			_('Inventory Category') => 'CATEGORIES',
			_('Sales Types') => 'SALESTYPES',
			_('Show Pictures') => 'YES_NO',
			_('Show GP %') => 'YES_NO',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'), SA_REP_PRICE_LISTING);
$reports->addReport(RC_CUSTOMER, 105, _('&Order Status Listing'),
	array(	_('Start Date') => 'DATEBEGINM',
			_('End Date') => 'DATEENDM',
			_('Inventory Category') => 'CATEGORIES',
			_('Stock Location') => 'LOCATIONS',
			_('Back Orders Only') => 'YES_NO',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'), SA_REP_ORDER_STATUS_LISTING);
$reports->addReport(RC_CUSTOMER, 106, _('&Salesman Listing'),
	array(	_('Start Date') => 'DATEBEGINM',
			_('End Date') => 'DATEENDM',
			_('Summary Only') => 'YES_NO',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'), SA_REP_SALESMAN_LISTING);
$reports->addReport(RC_CUSTOMER, 107, _('Print &Invoices'),
	array(	_('From') => 'INVOICE',
			_('To') => 'INVOICE',
			_('Currency Filter') => 'CURRENCY',
			_('email Customers') => 'YES_NO',
			_('Payment Link') => 'PAYMENT_LINK',
			_('Comments') => 'TEXTBOX',
			_('Customer') => 'CUSTOMERS_NO_FILTER',
			_('Orientation') => 'ORIENTATION'), SA_REP_PRINT_INVOCIES);
$reports->addReport(RC_CUSTOMER, 113, _('Print &Credit Notes'),
	array(	_('From') => 'CREDIT',
			_('To') => 'CREDIT',
			_('Currency Filter') => 'CURRENCY',
			_('email Customers') => 'YES_NO',
			_('Payment Link') => 'PAYMENT_LINK',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION'), SA_REP_PRINT_CREDIT_NOTES);
$reports->addReport(RC_CUSTOMER, 110, _('Print &Deliveries'),
	array(	_('From') => 'DELIVERY',
			_('To') => 'DELIVERY',
			_('email Customers') => 'YES_NO',
			_('Print as Packing Slip') => 'YES_NO',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION'), SA_REP_PRINT_DELIVERIS);
$reports->addReport(RC_CUSTOMER, 108, _('Print &Statements'),
	array(	_('Customer') => 'CUSTOMERS_NO_FILTER',
			_('Currency Filter') => 'CURRENCY',
			_('Show Also Allocated') => 'YES_NO',
			_('Email Customers') => 'YES_NO',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION'), SA_REP_PRINT_STATEMNTS);
$reports->addReport(RC_CUSTOMER, 109, _('&Print Sales Orders'),
	array(	_('From') => 'ORDERS',
			_('To') => 'ORDERS',
			_('Currency Filter') => 'CURRENCY',
			_('Email Customers') => 'YES_NO',
			_('Print as Quote') => 'YES_NO',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION'), SA_REP_PRINT_SALES_ORDER);
$reports->addReport(RC_CUSTOMER, 111, _('&Print Sales Quotations'),
	array(	_('From') => 'QUOTATIONS',
			_('To') => 'QUOTATIONS',
			_('Currency Filter') => 'CURRENCY',
			_('Email Customers') => 'YES_NO',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION'), SA_REP_PRINT_SALES_QUOTATION);
$reports->addReport(RC_CUSTOMER, 112, _('Print Receipts'),
	array(	_('From') => 'RECEIPT',
			_('To') => 'RECEIPT',
			_('Currency Filter') => 'CURRENCY',
            _('Email Customers') => 'YES_NO',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION'), SA_REP_PRINT_RECEIPTS_REPORT);

$reports->addReport(RC_CUSTOMER, 222, _('Outstanding &Sales Order Report'),
	array(	_('Start Date') => 'DATEBEGIN',
			_('End Date') => 'DATEENDM',
			_('Customer') => 'CUSTOMERS_NO_FILTER',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'), SA_REP_OUSTANDING_DEV_REPORT);	

$reports->addReport(RC_CUSTOMER, 224, _('Sales Order Inquiry report'),
	array(	_('Start Date') => 'DATEBEGIN',
			_('End Date') => 'DATEENDM',
			_('Customer') => 'CUSTOMERS_NO_FILTER',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'), SA_REP_OUSTANDING_DEV_REPORT);			

$reports->addReportClass(_('Supplier'), RC_SUPPLIER);
$reports->addReport(RC_SUPPLIER, 201, _('Supplier &Balances'),
	array(	_('Start Date') => 'DATEBEGIN',
			_('End Date') => 'DATEENDM',
			_('Supplier') => 'SUPPLIERS_NO_FILTER',
			_('Show Balance') => 'NO_YES',
			_('Currency Filter') => 'CURRENCY',
			_('Suppress Zeros') => 'YES_NO',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'), SA_REP_SUPPLIER_BALANCES);
$reports->addReport(RC_SUPPLIER, 202, _('&Aged Supplier Analyses'),
	array(	_('End Date') => 'DATE',
			_('Supplier') => 'SUPPLIERS_NO_FILTER',
			_('Currency Filter') => 'CURRENCY',
			_('Show Also Allocated') => 'YES_NO',
			_('Summary Only') => 'YES_NO',
			_('Suppress Zeros') => 'YES_NO',
			_('Graphics') => 'GRAPHIC',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'), SA_REP_AGED_SUPP_ANALYSES);
			
$reports->addReport(RC_SUPPLIER, 314, _('Aging Bill Wise &Report'),
	array(	_('Start Date') => 'DATEBEGINTAX',
			_('End Date') => 'DATEENDM',
			_('Supplier') => 'SUPPLIERS_NO_FILTER',
			_('Invoice #') => 'TEXT',
			_('Aging List') => 'AGING_LIST',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'), SA_REP_AGING_BILL_WISE_SUPP_REPORT);

// $reports->addReport(RC_SUPPLIER, 316, _('Item Wise Purchase &Report'),
// 	array(	_('Start Date') => 'DATEBEGINTAX',
// 			_('End Date') => 'DATEENDM',
// 			_('Items') => 'ITEMS_STOCK',
// 			_('Supplier') => 'SUPPLIERS_NO_FILTER',
// 			_('PO #') => 'TEXT',
// 			_('GRN #') => 'TEXT',
// 			_('Invoice #') => 'TEXT',
// 			_('Orientation') => 'ORIENTATION',
// 			_('Destination') => 'DESTINATION'));


$reports->addReport(RC_SUPPLIER, 219, _('Purchase Analaysis Report'), 
	array(	
			_('Start Date') => 'DATEBEGINM',
			_('End Date') => 'DATEENDM',
		    _('Items') => 'ITEMS_STOCK',
		    _('Supplier') => 'SUPPLIERS_NO_FILTER',
			_('Location') => 'LOCATIONS',
			_('PO') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'), SA_REP_PURCHASE_ANALAYSIS_REPORT);			

$reports->addReport(RC_SUPPLIER, 2022, _('&Aged Supplier Invoice Analyses '),
	array(	_('End Date') => 'DATE',
			_('Supplier') => 'SUPPLIERS_NO_FILTER',
			_('Currency Filter') => 'CURRENCY',
			_('Show Also Allocated') => 'YES_NO',
			_('Summary Only') => 'YES_NO',
			_('Suppress Zeros') => 'YES_NO',
			_('Graphics') => 'GRAPHIC',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'), SA_REP_AGED_SUPPLIER_IVOICE_ANALYSIS);
$reports->addReport(RC_SUPPLIER, 206, _('Supplier &Trial Balances'),
    array(  _('Start Date') => 'DATEBEGIN',
            _('End Date') => 'DATEENDM',
            _('Supplier') => 'SUPPLIERS_NO_FILTER',
            _('Currency Filter') => 'CURRENCY',
            _('Suppress Zeros') => 'YES_NO',
            _('Comments') => 'TEXTBOX',
            _('Orientation') => 'ORIENTATION',
            _('Destination') => 'DESTINATION'), SA_REP_SUPP_TRIAL_BALANCES);
$reports->addReport(RC_SUPPLIER, 203, _('&Payment Report'),
	array(	_('End Date') => 'DATE',
			_('Supplier') => 'SUPPLIERS_NO_FILTER',
			_('Currency Filter') => 'CURRENCY',
			_('Suppress Zeros') => 'YES_NO',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'), SA_REP_PAYMENT_REPORT);
$reports->addReport(RC_SUPPLIER, 204, _('Outstanding &Invoice Report'),
	array(	_('Start Date') => 'DATEBEGIN',
			_('End Date') => 'DATEENDM',
			_('Supplier') => 'SUPPLIERS_NO_FILTER',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'), SA_REP_OUTSTANDING_GRNS_REPORT);
$reports->addReport(RC_SUPPLIER, 205, _('Supplier &Detail Listing'),
	array(	_('Activity Since') => 'DATEBEGIN',
			_('Activity Greater Than') => 'TEXT',
			_('Activity Less Than') => 'TEXT',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'), SA_REP_SUPP_DETAIL_LISTING);
$reports->addReport(RC_SUPPLIER, 209, _('Print Purchase &Orders'),
	array(	_('From') => 'PO',
			_('To') => 'PO',
			_('Currency Filter') => 'CURRENCY',
			_('Email Suppliers') => 'YES_NO',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION'), SA_REP_PRINT_PURCH_ORDER);
$reports->addReport(RC_SUPPLIER, 213, _('Print Purchase &Quotation'),
	array(	_('From') => 'DATE',
			_('To') => 'DATEEND',
			_('Supplier') => 'SUPPLIERS_NO_FILTER',
			_('Compare Refernce') => 'TEXT',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'), SA_REP_PRINT_PUCHASE_QUOTAION);
$reports->addReport(RC_SUPPLIER, 210, _('Print Remi&ttances'),
	array(	_('From') => 'REMITTANCE',
			_('To') => 'REMITTANCE',
			_('Currency Filter') => 'CURRENCY',
			_('Email Suppliers') => 'YES_NO',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION'), SA_REP_PRINT_REMITTANCES);

$reports->addReport(RC_SUPPLIER, 223, _('Outstanding &Purchase Orders Report'),
	array(	_('Start Date') => 'DATEBEGIN',
			_('End Date') => 'DATEENDM',
			_('Supplier') => 'SUPPLIERS_NO_FILTER',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'), SA_REP_OUSTANDING_PO_REPORT);			

$reports->addReportClass(_('Inventory'), RC_INVENTORY);
$reports->addReport(RC_INVENTORY,  301, _('Inventory &Valuation Report'),
	array(	_('End Date') => 'DATE',
			_('Inventory Category') => 'CATEGORIES',
			_('Location') => 'LOCATIONS',
			_('Summary Only') => 'YES_NO',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'), SA_REP_INVENTORY_VALUATION_REPORT);
$reports->addReport(RC_INVENTORY,  302, _('Inventory &Planning Report'),
	array(	_('Inventory Category') => 'CATEGORIES',
			_('Location') => 'LOCATIONS',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'), SA_REP_INVENTORY_PLANNING_REPORT);
$reports->addReport(RC_INVENTORY, 303, _('Stock &Check Sheets'),
	array(	_('Inventory Category') => 'CATEGORIES',
			_('Location') => 'LOCATIONS',
			_('Show Pictures') => 'YES_NO',
			_('Inventory Column') => 'YES_NO',
			_('Show Only Shortages') => 'YES_NO',
			_('Suppress Zeros') => 'YES_NO',
			_('Item Like') => 'TEXT',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'), SA_STOCK_CHECK_SHEETS);
			
//new
$reports->addReport(RC_INVENTORY, 311, _('Closing Stock &Summary Report'),   
	array( 	_('End Date') => 'DATE',
			_('Items') => 'ITEMS_STOCK',
			_('Category') => 'CATEGORIES',
			_('Item Group') => 'ITEMS_GROUP',
			_('Select Multi Location') => 'MULTISELECTLOCATION',
			_('Suppress Zeros') => 'YES_NO',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'), SA_REP_CLOSING_STOCK_SUMMARY);

$reports->addReport(RC_INVENTORY, 313, _('Lead Time &of Item'),
	array(	
			_('Category') => 'CATEGORIES',
			_('Item Group') => 'ITEMS_GROUP',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'), SA_REP_LEAS_TIME_OF_ITEM);

$reports->addReport(RC_INVENTORY, 315, _('Inventory Aging &Report'),
	array(	_('End Date') => 'DATEENDM',
			_('Items') => 'ITEMS_STOCK',
			_('Location') => 'LOCATIONS',
			_('Stock Category') => 'CATEGORIES',
			_('Aging Days Greater Then') => 'TEXT',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'), SA_REP_INVENTORY_AGING_REPORT);	
			
$reports->addReport(RC_INVENTORY, 316, _('Item Wise Purchase &Report'),
	array(	_('Start Date') => 'DATEBEGINTAX',
			_('End Date') => 'DATEENDM',
			_('Items') => 'ITEMS_P',
			_('Supplier') => 'SUPPLIERS_NO_FILTER',
			_('PO #') => 'TEXT',
			_('GRN #') => 'TEXT',
			_('Invoice #') => 'TEXT',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'), SA_REP_ITEM_WISE_PURCAHSE);

$reports->addReport(RC_INVENTORY, 317, _('Supplier Wise Purchase &Report'),
	array(	_('Start Date') => 'DATEBEGINTAX',
			_('End Date') => 'DATEENDM',
			_('Items') => 'ITEMS_ALL',
			_('Supplier') => 'SUPPLIERS_NO_FILTER',
			_('PO #') => 'TEXT',
			_('GRN #') => 'TEXT',
			_('Invoice #') => 'TEXT',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'), SA_REP_SUPPLIER_WISE_PURCHASE);

$reports->addReport(RC_INVENTORY, 318, _('Purchase Summary Supplier &Report'),
	array(	_('Start Date') => 'DATEBEGINTAX',
			_('End Date') => 'DATEENDM',
			_('Item') => 'ITEMS_ALL',
			_('Vendor') => 'SUPPLIERS_NO_FILTER',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'), SA_REP_PURCHASE_SUMMARY_SUPPLIER);

$reports->addReport(RC_INVENTORY, 312, _('Stock &Ledger Report'), 
	array(	
			_('Start Date') => 'DATEBEGINM',
			_('End Date') => 'DATEENDM',
			_('Location') => 'LOCATIONS',
		    _('Items') => 'ITEMS_STOCK',
			_('Transection Type') => 'SYS_TYPES_ALL',
			// _('Item Group') => 'ITEMS_GROUP',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'), SA_REP_STOCK_LEDGER_REPORT);
//new			
$reports->addReport(RC_INVENTORY, 304, _('Inventory &Sales Report'),
	array(	_('Start Date') => 'DATEBEGINM',
			_('End Date') => 'DATEENDM',
			_('Inventory Category') => 'CATEGORIES',
			_('Location') => 'LOCATIONS',
			_('Customer') => 'CUSTOMERS_NO_FILTER',
			_('Show Service Items') => 'YES_NO',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'), SA_REP_INVENTORY_SALES_REPORT);
$reports->addReport(RC_INVENTORY, 305, _('&GRN Valuation Report'),
	array(	_('Start Date') => 'DATEBEGINM',
			_('End Date') => 'DATEENDM',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'), SA_REP_GRN_VALUATION_REPORT);
$reports->addReport(RC_INVENTORY, 306, _('Inventory P&urchasing Report'),
	array(	_('Start Date') => 'DATEBEGINM',
			_('End Date') => 'DATEENDM',
			_('Inventory Category') => 'CATEGORIES',
			_('Location') => 'LOCATIONS',
			_('Supplier') => 'SUPPLIERS_NO_FILTER',
			_('Items') => 'ITEMS_P',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'), SA_REP_INVENTORY_PURCHASING_REPORT);
$reports->addReport(RC_INVENTORY, 307, _('Inventory &Movement Report'),
	array(	_('Start Date') => 'DATEBEGINM',
			_('End Date') => 'DATEENDM',
			_('Inventory Category') => 'CATEGORIES',
			_('Location') => 'LOCATIONS',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'), SA_REP_INVENTORY_MOVEMENT_REPORT);				
$reports->addReport(RC_INVENTORY, 308, _('C&osted Inventory Movement Report'),
	array(	_('Start Date') => 'DATEBEGINM',
			_('End Date') => 'DATEENDM',
			_('Inventory Category') => 'CATEGORIES',
			_('Location') => 'LOCATIONS',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'), SA_REP_COSTED_INVENTORY_MOVEMENT_REPORT);				
$reports->addReport(RC_INVENTORY, 309,_('Item &Sales Summary Report'),
	array(	_('Start Date') => 'DATEBEGINM',
			_('End Date') => 'DATEENDM',
			_('Inventory Category') => 'CATEGORIES',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'), SA_ITEM_SALES_SUMMARY_REPORT);				
$reports->addReport(RC_INVENTORY, 310, _('Inventory Purchasing - &Transaction Based'),
	array(	_('Start Date') => 'DATEBEGINM',
			_('End Date') => 'DATEENDM',
			_('Inventory Category') => 'CATEGORIES',
			_('Location') => 'LOCATIONS',
			_('Supplier') => 'SUPPLIERS_NO_FILTER',
			_('Items') => 'ITEMS_P',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'), SA_REP_INVENTORY_PURCH_TRANS_BASED);

$reports->addReport(RC_INVENTORY, 319, _('Inventory Movement Report'),
	array(	_('Start Date') => 'DATEBEGINM',
			_('End Date') => 'DATEENDM',
			_('Location') => 'LOCATIONS',
			_('Items') => 'ITEMS_P',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'), SA_REP_INVENTORY_MOVEMENT);

if (get_company_pref('use_manufacturing'))
{
	$reports->addReportClass(_('Manufacturing'), RC_MANUFACTURE);
	$reports->addReport(RC_MANUFACTURE, 401, _('&Bill of Material Listing'),
		array(	_('From product') => 'ITEMS',
				_('To product') => 'ITEMS',
				_('Comments') => 'TEXTBOX',
				_('Orientation') => 'ORIENTATION',
				_('Destination') => 'DESTINATION'), SA_REP_BILL_OF_MATERIAL_LISTING);
	$reports->addReport(RC_MANUFACTURE, 402, _('Work Order &Listing'),
		array(	_('Items') => 'ITEMS_ALL',
				_('Location') => 'LOCATIONS',
				_('Outstanding Only') => 'YES_NO',
				_('Show GL Rows') => 'YES_NO',
				_('Comments') => 'TEXTBOX',
				_('Orientation') => 'ORIENTATION',
				_('Destination') => 'DESTINATION'), SA_REP_WORK_ORDER_LISTING);
	$reports->addReport(RC_MANUFACTURE, 409, _('Print &Work Orders'),
		array(	_('From') => 'WORKORDER',
				_('To') => 'WORKORDER',
				_('Email Locations') => 'YES_NO',
				_('Comments') => 'TEXTBOX',
				_('Orientation') => 'ORIENTATION'), SA_REP_PRINT_WO);
				
	$reports->addReport(RC_MANUFACTURE, 410, _('Cost Of &Production Report'),
		array(_('Start Date') => 'DATEBEGINTAX',
			_('End Date') => 'DATEENDM',
			_('Items') => 'ITEMS_STOCK',
			_('Work Oder #') => 'TEXT',
			_('Batch #') => 'TEXT',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'), SA_REP_COST_OF_PRODUCTION);
		$reports->addReport(RC_MANUFACTURE, 411, _('Material  &Consumption Report'),
		array(_('Start Date') => 'DATEBEGINTAX',
			_('End Date') => 'DATEENDM',
			_('Items') => 'ITEMS_STOCK',
			_('Work Oder #') => 'TEXT',
			_('Batch #') => 'TEXT',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'), SA_REP_MATERIAL_CONSUMPTION);
		$reports->addReport(RC_MANUFACTURE, 412, _('Wastage  &Report'),
		array(_('Start Date') => 'DATEBEGINTAX',
			_('End Date') => 'DATEENDM',
			_('Items') => 'ITEMS_STOCK',
			_('Work Oder #') => 'TEXT',
			_('Batch #') => 'TEXT',
			_('Item Group') => 'ITEMS_GROUP',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'), SA_REP_WASTAGE_REPORT);
			
		$reports->addReport(RC_MANUFACTURE, 413, _('Production  &Summary Report'), 
		array(_('Start Date') => 'DATEBEGINTAX',
			_('End Date') => 'DATEENDM',
			_('Items') => 'ITEMS_STOCK',
			_('Work Oder #') => 'TEXT',
			_('Batch #') => 'TEXT',
			_('Item Group') => 'ITEMS_GROUP',
			_('Item Type') => 'CATEGORIES',
			_('Department') => 'LOCATIONS',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'), SA_REP_PRODUCTION_SUMMARY_REPORT);
}
if (get_company_pref('use_fixed_assets'))
{
	$reports->addReportClass(_('Fixed Assets'), RC_FIXEDASSETS);
	$reports->addReport(RC_FIXEDASSETS, 451, _('&Fixed Assets Valuation'),
		array(	_('End Date') => 'DATE',
				_('Fixed Assets Class') => 'FCLASS',
				_('Fixed Assets Location') => 'FLOCATIONS',
				_('Summary Only') => 'YES_NO',
				_('Comments') => 'TEXTBOX',
				_('Orientation') => 'ORIENTATION',
				_('Destination') => 'DESTINATION'), SA_REP_FIXED_ASSETS_REPORT);
}				
$reports->addReportClass(_('Dimensions'), RC_DIMENSIONS);
if ($dim > 0)
{
	$reports->addReport(RC_DIMENSIONS, 501, _('Dimension &Summary'),
	array(	_('From Dimension') => 'DIMENSION',
			_('To Dimension') => 'DIMENSION',
			_('Show Balance') => 'YES_NO',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'), SA_REP_DIMENSION_SUMMARY);
	$reports->addReport(RC_DIMENSIONS, 502, _('All Project &Report'),
	array(	// _('From Dimension') => 'DIMENSION',
			// _('To Dimension') => 'DIMENSION',
			// _('Show Balance') => 'YES_NO',
			_('Start Date') => 'DATEBEGINM',
			_('End Date') => 'DATEENDM',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'), SA_REP_DIMENSION_SUMMARY);
}
$reports->addReportClass(_('Banking'), RC_BANKING);
	$reports->addReport(RC_BANKING,  601, _('Bank &Statement'),
	array(	_('Bank Accounts') => 'BANK_ACCOUNTS_NO_FILTER',
			_('Start Date') => 'DATEBEGINM',
			_('End Date') => 'DATEENDM',
			_('Zero values') => 'YES_NO',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'), SA_REP_BANK_STATEMENT);

	$reports->addReport(RC_BANKING,  603, _('Bank &Statement Cash Accounts'),
	array(	_('Bank Accounts') => 'BANK_ACCOUNTS_NO_FILTER',
			_('Start Date') => 'DATE',
			_('End Date') => 'DATE',
			_('Zero values') => 'YES_NO',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'), SA_REP_BANK_STATEMENT);

	$reports->addReport(RC_BANKING,  602, _('Bank Statement w/ &Reconcile'),
	array(	_('Bank Accounts') => 'BANK_ACCOUNTS',
			_('Start Date') => 'DATEBEGINM',
			_('End Date') => 'DATEENDM',
			_('Comments') => 'TEXTBOX',
			_('Destination') => 'DESTINATION'), SA_REP_BANK_STATEMENT_RECONCILE);

$reports->addReportClass(_('General Ledger'), RC_GL);
$reports->addReport(RC_GL, 701, _('Chart of &Accounts'),
	array(	_('Show Balances') => 'YES_NO',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'), SA_REP_GERNAL_LEDGER);
$reports->addReport(RC_GL, 702, _('List of &Journal Entries'),
	array(	_('Start Date') => 'DATEBEGINM',
			_('End Date') => 'DATEENDM',
			_('Type') => 'SYS_TYPES',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'), SA_REP_LIST_OF_JOURNAL_ENTRIES);

if ($dim == 2)
{
		$reports->addReport(RC_GL, 704, _('GL Account &Transactions'),
	array(	_('Start Date') => 'DATEBEGINM',
			_('End Date') => 'DATEENDM',
			_('From Account') => 'GL_ACCOUNTS',
			_('To Account') => 'GL_ACCOUNTS',
			_('Customer') => 'CUSTOMERS_NO_FILTER',
			_('Supplier') => 'SUPPLIERS_NO_FILTER',
			_('Dimension')." 1" =>  'DIMENSIONS1',
			_('Dimension')." 2" =>  'DIMENSIONS2',
			_('Comments') => 'TEXTBOX',
			_('Show Contra  Account Details') => 'YES_NO',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'), SA_REP_GL_ACCOUNT_TRANSACTION);
	$reports->addReport(RC_GL, 705, _('Annual &Expense Breakdown'),
	array(	_('Year') => 'TRANS_YEARS',
			_('Dimension')." 1" =>  'DIMENSIONS1',
			_('Dimension')." 2" =>  'DIMENSIONS2',
			_('Account Tags') =>  'ACCOUNTTAGS',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Amounts in thousands') => 'YES_NO',
			_('Destination') => 'DESTINATION'), SA_REP_ANNUAL_EXPENSE_BREAKDOWN);
	$reports->addReport(RC_GL, 706, _('&Balance Sheet'),
	array(	_('Start Date') => 'DATEBEGIN',
			_('End Date') => 'DATEENDM',
			_('Dimension')." 1" => 'DIMENSIONS1',
			_('Dimension')." 2" => 'DIMENSIONS2',
			_('Account Tags') =>  'ACCOUNTTAGS',
			_('Decimal values') => 'YES_NO',
			_('Graphics') => 'GRAPHIC',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'), SA_REP_BALANCE_SHEET);
	$reports->addReport(RC_GL, 707, _('&Profit and Loss Statement'),
	array(	_('Start Date') => 'DATEBEGINM',
			_('End Date') => 'DATEENDM',
			_('Compare to') => 'COMPARE',
			_('Dimension')." 1" =>  'DIMENSIONS1',
			_('Dimension')." 2" =>  'DIMENSIONS2',
			_('Account Tags') =>  'ACCOUNTTAGS',
			_('Decimal values') => 'YES_NO',
			_('Graphics') => 'GRAPHIC',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'), SA_REP_PROFIT_AND_LOSS_STAT);
	$reports->addReport(RC_GL, 708, _('Trial &Balance'),
	array(	_('Start Date') => 'DATEBEGINM',
			_('End Date') => 'DATEENDM',
			_('Zero values') => 'YES_NO',
			_('Only balances') => 'NO_YES',
			_('Dimension')." 1" =>  'DIMENSIONS1',
			_('Dimension')." 2" =>  'DIMENSIONS2',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'), SA_REP_TRAIL_BALANCE);
}
elseif ($dim == 1)
{
	$reports->addReport(RC_GL, 704, _('GL Account &Transactions'),
	array(	_('Start Date') => 'DATEBEGINM',
			_('End Date') => 'DATEENDM',
			_('From Account') => 'GL_ACCOUNTS',
			_('To Account') => 'GL_ACCOUNTS',
			_('Customer') => 'CUSTOMERS_NO_FILTER',
			_('Supplier') => 'SUPPLIERS_NO_FILTER',
			_('Dimension') =>  'DIMENSIONS1',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'), SA_REP_GL_ACCOUNT_TRANSACTION);
	$reports->addReport(RC_GL, 705, _('Annual &Expense Breakdown'),
	array(	_('Year') => 'TRANS_YEARS',
			_('Dimension') =>  'DIMENSIONS1',
			_('Account Tags') =>  'ACCOUNTTAGS',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Amounts in thousands') => 'YES_NO',
			_('Destination') => 'DESTINATION'), SA_REP_ANNUAL_EXPENSE_BREAKDOWN);
	$reports->addReport(RC_GL, 706, _('&Balance Sheet'),
	array(	_('Start Date') => 'DATEBEGIN',
			_('End Date') => 'DATEENDM',
			_('Dimension') => 'DIMENSIONS1',
			_('Account Tags') =>  'ACCOUNTTAGS',
			_('Decimal values') => 'YES_NO',
			_('Graphics') => 'GRAPHIC',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'), SA_REP_BALANCE_SHEET);
	$reports->addReport(RC_GL, 707, _('&Profit and Loss Statement'),
	array(	_('Start Date') => 'DATEBEGINM',
			_('End Date') => 'DATEENDM',
			_('Compare to') => 'COMPARE',
			_('Dimension') => 'DIMENSIONS1',
			_('Account Tags') =>  'ACCOUNTTAGS',
			_('Decimal values') => 'YES_NO',
			_('Graphics') => 'GRAPHIC',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'), SA_REP_PROFIT_AND_LOSS_STAT);
	$reports->addReport(RC_GL, 708, _('Trial &Balance'),
	array(	_('Start Date') => 'DATEBEGINM',
			_('End Date') => 'DATEENDM',
			_('Zero values') => 'YES_NO',
			_('Only balances') => 'YES_NO',
			_('Dimension') => 'DIMENSIONS1',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'), SA_REP_TRAIL_BALANCE);
}
else
{
	$reports->addReport(RC_GL, 704, _('GL Account &Transactions'),
	array(	_('Start Date') => 'DATEBEGINM',
			_('End Date') => 'DATEENDM',
			_('From Account') => 'GL_ACCOUNTS',
			_('To Account') => 'GL_ACCOUNTS',
			_('Customer') => 'CUSTOMERS_NO_FILTER',
			_('Supplier') => 'SUPPLIERS_NO_FILTER',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'), SA_REP_GL_ACCOUNT_TRANSACTION);
	$reports->addReport(RC_GL, 705, _('Annual &Expense Breakdown'),
	array(	_('Year') => 'TRANS_YEARS',
			_('Account Tags') =>  'ACCOUNTTAGS',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Amounts in thousands') => 'YES_NO',
			_('Destination') => 'DESTINATION'), SA_REP_ANNUAL_EXPENSE_BREAKDOWN);
	$reports->addReport(RC_GL, 706, _('&Balance Sheet'),
	array(	_('Start Date') => 'DATEBEGIN',
			_('End Date') => 'DATEENDM',
			_('Account Tags') =>  'ACCOUNTTAGS',
			_('Decimal values') => 'YES_NO',
			_('Graphics') => 'GRAPHIC',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'), SA_REP_BALANCE_SHEET);
	$reports->addReport(RC_GL, 707, _('&Profit and Loss Statement'),
	array(	_('Start Date') => 'DATEBEGINM',
			_('End Date') => 'DATEENDM',
			_('Compare to') => 'COMPARE',
			_('Account Tags') =>  'ACCOUNTTAGS',
			_('Decimal values') => 'YES_NO',
			_('Graphics') => 'GRAPHIC',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'), SA_REP_PROFIT_AND_LOSS_STAT);
	$reports->addReport(RC_GL, 708, _('Trial &Balance'),
	array(	_('Start Date') => 'DATEBEGINM',
			_('End Date') => 'DATEENDM',
			_('Zero values') => 'YES_NO',
			_('Only balances') => 'YES_NO',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'), SA_REP_TRAIL_BALANCE);
}
$reports->addReport(RC_GL, 709, _('Ta&x Report'),
	array(	_('Start Date') => 'DATEBEGINTAX',
			_('End Date') => 'DATEENDTAX',
			_('Summary Only') => 'YES_NO',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'), SA_REP_TAX_REPORT);
$reports->addReport(RC_GL, 710, _('Audit Trail'),
	array(	_('Start Date') => 'DATEBEGINM',
			_('End Date') => 'DATEENDM',
			_('Type') => 'SYS_TYPES_ALL',
			_('User') => 'USERS',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'), SA_REP_AUDIT_TRAIL);

add_custom_reports($reports);

echo $reports->getDisplay();

  global $Ajax;
	$js= " $('select').select2({
           width: '300px' // need to override the changed default
         });";
		$Ajax->addScript(true, $js);


end_page();
?>

<script type="text/javascript">
	$('select').select2({
    width: '300px' // need to override the changed default
});
</script>