<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
//-----------------------------------------------------------------------------
// insert/update sales delivery
//
function write_gate_pass(&$delivery,$bo_policy)
{
	print_r($delivery);
	global $Refs;

	$freight_tax = $delivery->get_shipping_tax();

	$tax_total = 0;
	$taxes = $delivery->get_taxes(); // all taxes with freight_tax

	foreach ($taxes as $taxitem) {
		$taxitem['Value'] =  round2($taxitem['Value'], user_price_dec());
		$tax_total +=  $taxitem['Value'];
	}

	$delivery_no = write_gate_pass_header(ST_GATE_PASS, $delivery->customer_id,
		$delivery->Branch, $delivery->document_date, $delivery->reference,
		$delivery_items_total, 0,
		$delivery->tax_included ? 0 : $tax_total-$freight_tax,
		$delivery->freight_cost,
		$delivery->tax_included ? 0 : $freight_tax,
		$delivery->sales_type, $delivery->order_no,
		$delivery->ship_via, $delivery->due_date, 0, 0, $delivery->dimension_id, 
		$delivery->dimension2_id, $delivery->payment, $delivery->tax_included, $delivery->prep_amount, $delivery->sales_person, $delivery->vehicle_no, $delivery->file_system);

	foreach ($delivery->line_items as $line_no => $delivery_line) {

	$qty = $delivery_line->qty_dispatched;
	$line_price = $delivery_line->line_price();
	$line_taxfree_price = get_tax_free_price_for_item($delivery_line->stock_id,
	$delivery_line->price*$qty, 0, $delivery->tax_included,
	$delivery->tax_group_array);

	$line_tax = get_full_price_for_item($delivery_line->stock_id,
	$delivery_line->price * $qty, 0, $delivery->tax_included, $delivery->tax_group_array) - $line_taxfree_price;

	$delivery_line->standard_cost =  (get_betch_price($delivery_line->batch_no,$delivery_line->stock_id) ) ? get_betch_price($delivery_line->batch_no,$delivery_line->stock_id) :0 ;

	write_gate_pass_detail_item(ST_GATE_PASS, $delivery_no, $delivery_line->stock_id, $delivery_line->item_description, $delivery_line->qty_dispatched,
			$delivery_line->line_price(), $qty ? $line_tax/$qty : 0, $delivery_line->discount_percent, $delivery_line->standard_cost, $delivery_line->src_id,
			$trans_no ? $delivery_line->id : 0, $delivery_line->batch_no, $delivery_line->exp_date);
	}

	$Refs->save(ST_GATE_PASS, $delivery_no, $delivery->reference);
	hook_db_postwrite($delivery, ST_GATE_PASS);

	return $delivery_no;
}

function write_gate_pass_header($trans_type, $debtor_no, $BranchNo,
	$date_, $reference, $Total, $discount=0, $Tax=0, $Freight=0, $FreightTax=0,
	$sales_type=0, $order_no=0, $ship_via=0, $due_date="",
	$AllocAmt=0, $rate=0, $dimension_id=0, $dimension2_id=0, $payment_terms=null, $tax_included=0, 
	$prep_amount=0, $sales_person=0 ,$vehicle_no=null, $file_system=0)
{
	$curr = get_customer_currency($debtor_no);
	if ($rate == 0)
		$rate = get_exchange_rate_from_home_currency($curr, $date_);

	$SQLDate = date2sql($date_);
	if ($due_date == "")
		$SQLDueDate = "0000-00-00";
	else
		$SQLDueDate = date2sql($due_date);
	
   	$trans_no = get_next_trans_no($trans_type);

	$sql = "INSERT INTO ".TB_PREF."gate_pass (type, debtor_no, branch_code, tran_date, due_date, reference, tpe, order_, ov_amount, ov_discount, ov_gst, ov_freight, ov_freight_tax, rate, ship_via, alloc, dimension_id, dimension2_id, payment_terms, tax_included, prep_amount, sales_person, vehicle_no, file_system) 
	VALUES (".db_escape($trans_type).", ".db_escape($debtor_no).", ".db_escape($BranchNo).", '$SQLDate', '$SQLDueDate', ".db_escape($reference).", ".db_escape($sales_type).", ".db_escape($order_no).", ".db_escape(!empty($Total) ? $Total : 0).", ".db_escape($discount).", ".db_escape(!empty($Tax) ? $Tax : 0).", ".db_escape($Freight).", $FreightTax, $rate, ".db_escape($ship_via).", ".db_escape(!empty($AllocAmt) ? $AllocAmt : 0).", ".db_escape($dimension_id).", ".db_escape($dimension2_id).", ".db_escape($payment_terms, true).", ".db_escape($tax_included).", ".db_escape($prep_amount).", ".db_escape($sales_person).", ".db_escape($vehicle_no).", ".db_escape($file_system).")";

	db_query($sql, "The debtor transaction record could not be inserted");
	return $trans_no;
}

function write_gate_pass_detail_item($type, $gate_pass_id, $stock_id, $description,$quantity, 
	$unit_price, $unit_tax, $discount_percent, $std_cost, $src_id, $line_id=0, $batch_no=null, 
	$exp_date=null){

	$kv_exp_date = get_company_pref('kv_exp_date');
    if(!$kv_exp_date)
     $exp_date=Today();	

	$sql = "INSERT INTO ".TB_PREF."gate_pass_details (gate_pass_id, type, stock_id, description, quantity, unit_price, unit_tax, discount_percent, standard_cost, src_id, batch_no, exp_date)
	VALUES (".db_escape($gate_pass_id).", ".db_escape($type).", ".db_escape($stock_id).	", ".db_escape($description).",	$quantity, $unit_price, $unit_tax, 	$discount_percent, $std_cost,".db_escape($src_id).", 
	".db_escape($batch_no).", ".db_escape(date2sql($exp_date)).")";

	db_query($sql, "The debtor transaction detail could not be written");
}

function get_gate_pass_header($trans_no)
{
	$sql = "SELECT * FROM ".TB_PREF."gate_pass WHERE trans_no=".db_escape($trans_no);
	$result = db_query($sql,"could not get group");
	return db_fetch($result);
}

function get_gate_pass_details($type, $trans_no)
{
	$sql = "SELECT * FROM ".TB_PREF."gate_pass_details WHERE gate_pass_id=".db_escape($trans_no). " AND type=".db_escape($type);
	return db_query($sql,"could not get group");
}

function get_gate_pass_so($order_no)
{
	$sql = "SELECT * FROM ".TB_PREF."gate_pass WHERE order_=".db_escape($order_no);
	return db_query($sql,"could not get group");
}

function get_gate_pass_so_details($order_no)
{
	$sql = " SELECT * FROM ".TB_PREF."gate_pass as gp , ".TB_PREF."gate_pass_details as gpd
			WHERE gp.trans_no=gpd.gate_pass_id AND order_=".db_escape($order_no);
	return db_query($sql);
}

function gate_pass_inquiry($gate_pass_no='', $ref='', $order_no='', $from='', $to='',
			$items='', $customer_id='')
{

	$date_after = date2sql($from);
	$date_before = date2sql($to);

	$sql = " SELECT trans_no, 
				reference,
				debtor_no,
				tran_date
				FROM ".TB_PREF."gate_pass as gp ,
				".TB_PREF."gate_pass_details as gpd
			WHERE gp.trans_no=gpd.gate_pass_id ";

	if($gate_pass_no != "")
	{
		$sql .= " AND gp.trans_no LIKE ".db_escape('%' . $gate_pass_no . '%');
	}
	if($ref != "")
	{
		$sql .= " AND gp.reference LIKE ".db_escape('%' . $ref . '%');
	}
	if($order_no != "")
	{
		$sql .= " AND gp.order_ LIKE ".db_escape('%' . $order_no . '%');
	}
	if($items != "")
	{
		$sql .= " AND gpd.stock_id =".db_escape($items);
	}
	if($customer_id != "")
	{
		$sql .= " AND gp.debtor_no =".db_escape($customer_id);
	}
	if($from != "")
		$sql .=  " AND gp.tran_date >= '$date_after'";
	if($to != "")
		$sql .=  " AND gp.tran_date <= '$date_before'";

	return $sql;
}

function delete_gate_pass($id)
{
	$sql = "DELETE gp, gpd 
        FROM " . TB_PREF . "gate_pass AS gp
        JOIN " . TB_PREF . "gate_pass_details AS gpd ON gp.trans_no = gpd.gate_pass_id
        WHERE gp.trans_no = " . db_escape($id);
	db_query($sql,"could not delete sales group");
}