<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_SALESTRANSVIEW';
$path_to_root="../..";
include_once($path_to_root . "/includes/db_pager.inc");
include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/sales/includes/sales_ui.inc");
include_once($path_to_root . "/reporting/includes/reporting.inc");

$js = "";
if ($SysPrefs->use_popup_windows)
	$js .= get_js_open_window(900, 500);
if (user_use_date_picker())
	$js .= get_js_date_picker();
page(_($help_context = "Gate Pass Inquiry"), false, false, "", $js);

//---------------------------------------------------------------------------------------------
function trans_view($row)
{
	return get_trans_view_str(ST_GATE_PASS, $row["trans_no"]);
}

function customer_name($row)
{
	return get_customer_name($row['debtor_no']);
}

function receive_link($row) 
{
	global $page_nested;
	
	return $page_nested || !$row['OverDue'] ? '' :
		pager_link( _("Receive"),
			"/purchasing/po_receive_items.php?PONumber=" . $row["order_no"], ICON_RECEIVE);
}

function delete_link($row)
{

$name = "2chgtpl" .$row['trans_no'];
		$value = $row['approved'] ? 1:0;
	
	if(!$row['approved'])
	return checkbox(null, $name, $value, true,
	_("Set the approved GT Order's ")) 
	. hidden('last['.$row['trans_no'].']', $value, false)."<span style='color:red;' > Delete This Gate Pass <span>";

}
$id2 = find_submit('_2chgtpl');
if ($id2 != -1)
{

	delete_gate_pass($id2, check_value('2chgtpl'.$id2));
	$Ajax->activate('orders_tbl');
}


//-----------------------------------------------------------------------------------
// Ajax updates
//
if (get_post('SearchOrders')) 
{
	$Ajax->activate('orders_tbl');
} elseif (get_post('_order_number_changed')) 
{
	$disable = get_post('order_number') !== '';

	$Ajax->addDisable(true, 'OrdersAfterDate', $disable);
	$Ajax->addDisable(true, 'OrdersToDate', $disable);
	$Ajax->addDisable(true, 'StockLocation', $disable);
	$Ajax->addDisable(true, '_SelectStockFromList_edit', $disable);
	$Ajax->addDisable(true, 'SelectStockFromList', $disable);

	if ($disable) {
		$Ajax->addFocus(true, 'order_number');
	} else
		$Ajax->addFocus(true, 'OrdersAfterDate');

	$Ajax->activate('orders_tbl');
}
//---------------------------------------------------------------------------------------------

start_form();

start_table(TABLESTYLE_NOBORDER);
start_row();
ref_cells(_("#:"), 'GatePassNumber', '',null, '', true);
ref_cells(_("Ref"), 'OrderReference', '',null, '', true);
ref_cells(_("Order No.:"), 'OrderNumber', '',null, '', true);

date_cells(_("From:"), 'OrdersAfterDate', '', null, -user_transaction_days());
date_cells(_("To:"), 'OrdersToDate');

end_row();
end_table();

start_table(TABLESTYLE_NOBORDER);
start_row();

stock_items_list_cells(_("Item:"), 'SelectStockFromList', null, true);

if (!$page_nested)
	customer_list_cells(_("Select a customer: "), 'customer_id', null, true, true);

submit_cells('SearchOrders', _("Search"),'',_('Select documents'), 'default');
end_row();
end_table(1);

//---------------------------------------------------------------------------------------------

$sql = gate_pass_inquiry(get_post('GatePassNumber'), get_post('OrderReference'), 
	get_post('OrderNumber'), get_post('OrdersAfterDate'), get_post('OrdersToDate'), 
	get_post('StockLocation'), get_post('SelectStockFromList'),
	get_post('customer_id'));

$cols = array(
		_("#") => array('fun'=>'trans_view', 'ord'=>'', 'align'=>'center'), 
		_("Reference") => array('ord'=>'', 'align'=>'center'), 
		_("Customer") => array('fun'=>'customer_name', 'ord'=>'', 'align'=>'center'), 
		_("Order Date") => array('name'=>'ord_date', 'type'=>'date', 'ord'=>'desc'),
		_("") => array('fun'=>'delete_link', 'ord'=>'', 'align'=>'center'), 
);

if (get_post('StockLocation') != ALL_TEXT) {
	$cols[_("Location")] = 'skip';
}

//---------------------------------------------------------------------------------------------------

$table =& new_db_pager('orders_tbl', $sql, $cols);

$table->width = "80%";

display_db_pager($table);

end_form();
end_page();
