<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_SALESAREA';
$path_to_root = "../..";
include($path_to_root . "/includes/session.inc");


if (isset($_GET['FixedAsset']) || $_POST['FixedAsset']==1 ) {
  $help_context = "Fixed Assets  Group";

  // page(_($help_context = "Fixed Assets  Group"));
  // $help_context = "Fixed Assets  Group";
  if(isset($_GET['FixedAsset']))
  $_POST['FixedAsset']= $_GET['FixedAsset'];


}
else {

$help_context = "Item Group";
$_POST['FixedAsset']=0;
}

page(_($help_context));
include($path_to_root . "/includes/ui.inc");

simple_page_mode(true);

if ($Mode=='ADD_ITEM' || $Mode=='UPDATE_ITEM') 
{

	$input_error = 0;

	if (strlen($_POST['description']) == 0) 
	{
		$input_error = 1;
		display_error(_("The  description cannot be empty."));
		set_focus('description');
	}

	if ($input_error != 1)
	{
    	if ($selected_id != -1) 
    	{
    		update_item_group($selected_id, $_POST['description'], $_POST['group_description'], $_POST['FixedAsset']
    			);
			$note = _('Selected item group has been updated');
    	} 
    	else 
    	{
    		add_item_group($_POST['description'], $_POST['group_description'],$_POST['FixedAsset']);
			$note = _('New item group has been added');
    	}
    
		display_notification($note);    	
		$Mode = 'RESET';
	}
} 

if ($Mode == 'Delete')
{

	$cancel_delete = 0;

	// PREVENT DELETES IF DEPENDENT RECORDS IN 'debtors_master'

	if (key_in_foreign_table($selected_id, 'stock_master', 'item_group'))
	{
		$cancel_delete = 1;
		display_error(_("Cannot delete this item group because customer branches have been created using this item group."));
	} 
	if ($cancel_delete == 0) 
	{
		delete_item_group($selected_id);

		display_notification(_('Selected item group has been deleted'));
	} //end if Delete area
	$Mode = 'RESET';
} 

if ($Mode == 'RESET')
{
	$selected_id = -1;
	$sav = get_post('show_inactive');
	$FixedAsset = $_POST['FixedAsset'];
	unset($_POST);
	$_POST['show_inactive'] = $sav;
		$_POST['FixedAsset'] = $FixedAsset;
}

//-------------------------------------------------------------------------------------------------

// display_error( $_POST['FixedAsset'] ." insid222e");
$result = get_item_groups(check_value('show_inactive'),$_POST['FixedAsset']);




start_form();
start_table(TABLESTYLE, "width='30%'");

$th = array(_("id"),_("Item Group Name"),_("Description"), "", "");
inactive_control_column($th);

table_header($th);
$k = 0; 

while ($myrow = db_fetch($result)) 
{
	
	alt_table_row_color($k);
	label_cell($myrow["id"]);
	label_cell($myrow["description"]);
	label_cell($myrow["group_description"]);

	inactive_control_cell($myrow["id"], $myrow["inactive"], 'item_group', 'id');

 	edit_button_cell("Edit".$myrow["id"], _("Edit"));
 	delete_button_cell("Delete".$myrow["id"], _("Delete"));
	end_row();
}
	
inactive_control_row($th);
end_table();
echo '<br>';

//-------------------------------------------------------------------------------------------------

start_table(TABLESTYLE2);
hidden('FixedAsset',$_POST['FixedAsset']);

if ($selected_id != -1) 
{
 	if ($Mode == 'Edit') {
		//editing an existing area
		$myrow = get_item_group($selected_id);

		$_POST['description']  = $myrow["description"];
		$_POST['group_description']  = $myrow["group_description"];
	}
	hidden("selected_id", $selected_id);
} 


text_row_ex(_("Item Group Name:"), 'description', 30); 
// text_row_ex(_("Description:"), 'group_description', 30); 
textarea_row(_("Description:"), 'group_description', null, 36, 5);

end_table(1);

submit_add_or_update_center($selected_id == -1, '', 'both');

end_form();

end_page();
