<?php
/****************************************
/*  Author 	: Kvvaradha
/*  Module 	: Enhanced HRM
/*  E-mail 	: admin@kvcodes.com
/*  Version : 1.0
/*  Http 	: www.kvcodes.com
*****************************************/

$page_security = 'HR_PAYSLIP';
$path_to_root="../..";
include($path_to_root . "/includes/session.inc");
add_access_extensions();
$version_id = get_company_prefs('version_id');

$js = '';
if($version_id['version_id'] == '2.4.1'){
	if ($SysPrefs->use_popup_windows) 
		$js .= get_js_open_window(900, 500);	

	if (user_use_date_picker()) 
		$js .= get_js_date_picker();
	
}else{
	if ($use_popup_windows)
		$js .= get_js_open_window(900, 500);
	if ($use_date_picker)
		$js .= get_js_date_picker();
}
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/ui.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include($path_to_root . "/modules/ExtendedHRM/includes/Payroll.inc" );

page(_("Leaving Indemnity"), @$_REQUEST['popup'], false, "", $js);
if (isset($_GET['employee_id'])){
	$_POST['employee_id'] = $_GET['employee_id'];
}
if(isset($_GET['added']))
	display_notification(_("The Employee End of Service Benefit generated Successfully!"));
$employee_id = get_post('employee_id','');
 
if(isset($_POST['ProcessESB'])){
  
	Insert('kv_empl_esb', array('empl_id' => $_POST['empl_id'], 'last_gross' => $_POST['last_gross'], 'days_worked' => $_POST['days_worked'], 'date' => array(Today(), 'date'), 'status' => $_POST['status'], 'amount' => $_POST['amount'], 'loan_amount' => $_POST['loan_amount']));
	meta_forward($path_to_root.'/modules/ExtendedHRM/esb.php?', 'employee_id='.$_POST['empl_id'].'&added=yes');
} 
if(list_updated('employee_id')) {
	$Ajax->activate('ESB');
}
div_start('ESB');

start_form();
		if (db_has_employees()) {
			start_table(TABLESTYLE_NOBORDER);
			start_row();
			department_list_cells(_("Select a Department")." :", 'dept_id', null, _("No Department"), true, check_value('show_inactive'));
			employee_list_cells(_("Select an Employee:"), 'employee_id', null,_("Select An Employee"), true, check_value('show_inactive'), false, false, false, true);	
			end_row();	
			end_table();
			br();
			if (get_post('_show_inactive_update')) {
				$Ajax->activate('employee_id');
				set_focus('employee_id');
			}
		} 
		else {	
			hidden('employee_id');
		}
		
		if($employee_id){ 
			$paid_esb = GetRow('kv_empl_esb', array('empl_id' => $employee_id));
			global $hrm_empl_status;
			$status = GetSingleValue('kv_empl_info', 'status', array('empl_id' => $employee_id));  
			$status_text  = $hrm_empl_status[$status];
			$n_period = GetSingleValue('kv_empl_info', 'n_period', array('empl_id' => $employee_id)); 
			$date_of_status_change = GetSingleValue('kv_empl_info', 'date_of_status_change', array('empl_id' => $employee_id)); 
			$sql = "SELECT TIMESTAMPDIFF( YEAR, joining, info.date_of_status_change ) as year, TIMESTAMPDIFF( MONTH, joining, info.date_of_status_change ) % 12 as month, FLOOR( TIMESTAMPDIFF( DAY, joining, info.date_of_status_change ) % 30.4375 ) as day FROM  ".TB_PREF."kv_empl_job AS job, ".TB_PREF."kv_empl_info AS info  WHERE  job.empl_id=info.empl_id AND job.empl_id=".db_escape($employee_id); 
			$result_3 = db_query($sql, "Can't get result");
			if($empl_service = db_fetch($result_3)){
					$years = $empl_service['year'];
					$month = $empl_service['month'];
					$days = $empl_service['day'];
					$yearsonly =  $years + ($empl_service['month']/12) + ($empl_service['day']/365);
			}
			$last_payroll_date=GetSingleValue('kv_empl_salary', 'MAX(`date`)', array('empl_id' => $employee_id),null,array('empl_id')); 
			start_outer_table(TABLESTYLE);
					table_section(1);
					label_row(_("Employee No")." :", $employee_id, null, 30, 30);
					label_row(_("Employee Name")." :", kv_get_empl_name($employee_id), null, 30, 30);
					label_row(_("Service Period")." :", $years .' Years and '.$month.' Months and '.$days.' Days');
					label_row(_("Employee Status"), $status_text);
					label_row(_("Actual termination date"), sql2date($date_of_status_change));
					label_row(_("Notice Period"),  sql2date($n_period));
					label_row(_("Last payroll process date"),  sql2date($last_payroll_date));

					
			if(empty($paid_esb)){			
				$esb_country = get_hrm_option('esb_country');
				$esb_salary = get_hrm_option('esb_salary');
				$basic_id = kv_get_basic();
				if($esb_salary && $basic_id){								
					$last_paid_salary =  GetSingleValue('kv_empl_salary', "`".$basic_id."`", array('empl_id' => $employee_id), array('id' => 'DESC')); 
				} else {
					$last_paid_salary =  GetSingleValue('kv_empl_salary', 'gross', array('empl_id' => $employee_id), array('id' => 'DESC')); 
				}
				
				$sql_2 = "SELECT TIMESTAMPDIFF( DAY, joining, info.date_of_status_change ) FROM  ".TB_PREF."kv_empl_job AS job, ".TB_PREF."kv_empl_info AS info  WHERE job.empl_id=info.empl_id AND job.empl_id=".db_escape($employee_id); 
				$result_2 = db_query($sql_2, _("Can't get result"));
				if($empl_esb = db_fetch($result_2))
					$DaysOnly =  $empl_esb[0]; 
				else
					$DaysOnly = 0;
				if($esb_salary)
					label_row(_("Last Paid Basic Salary"), price_format($last_paid_salary));
				else
					label_row(_("Last Paid Gross"), price_format($last_paid_salary));
				if($esb_country == 1){ //bahrain 
					if($status_text == 'Resigned' || $status_text == 'Terminated' || $status_text == 'Decesed'){						
						$firstPeriod = $secondPeriod = 0; // set periods
						if ($yearsonly > 3) {
							$firstPeriod = 3;
							$secondPeriod = $yearsonly - 3;
						}   else {
							$firstPeriod = $yearsonly;
						}
						// calculate
						$result_3 = ($firstPeriod * $last_paid_salary * 0.5) + ($secondPeriod * $last_paid_salary);
					}
				} elseif($esb_country == 2) {  // saudi based
					if($status_text == 'Resigned'){	
						if ($yearsonly < 2) {
							 $result_3 = _("Not eligible end of service benefits");
						}  elseif ($yearsonly <= 5) {
							 $result_3 = (1 / 6) * $last_paid_salary * $yearsonly;
						} elseif ($yearsonly <= 10) {

							 $result_3 = ((1 / 3) * $last_paid_salary * 5) + ((2 / 3) * $last_paid_salary * ($yearsonly - 5));
						} else {
							 $result_3 = (0.5 * $last_paid_salary * 5) + ($last_paid_salary * ($yearsonly - 5));
						}   	
					} elseif($status_text == 'Terminated' || $status_text == 'Decesed'){						
						$firstPeriod = $secondPeriod = 0; // set periods
						if ($yearsonly > 5) {
						
							$firstPeriod = 5;
							$secondPeriod = $yearsonly - 5;
						} else 
							 $firstPeriod = $yearsonly; 
							 
						$result_3 = ($firstPeriod * $last_paid_salary * 0.5) + ($secondPeriod * $last_paid_salary); // calculate
						
					} else
						$result_3 = 0;
				}elseif($esb_country == 3){  // India
						if($status_text == 'Resigned' || $status_text == 'Terminated' || $status_text == 'Decesed'){		
								if ($yearsonly < 1) {
									$result_3 = ( $last_paid_salary * 2);
								}elseif($yearsonly < 5) {
									$result_3 =  ($last_paid_salary * 6);
								} elseif($yearsonly < 11) {
									$result_3 = ($last_paid_salary * 12);
								} elseif($yearsonly < 20) {
									$result_3 = ($last_paid_salary * 20); 
								}elseif($yearsonly > 20){
									$result_3 = ($month * 6) + ($days * 33);
								}else
									$result_3 = 0;
							}

				}

				
				$loan_amt = get_employee_balance_loan($employee_id);

				if(is_numeric($result_3)){					
					label_row(_("Loan Balance"), price_format($loan_amt));  					
					label_row(_("Calculated EOSB"), price_format($result_3));  
					label_row(_("Payable EOSB After Loan Deduction"), price_format($result_3-$loan_amt));  
					hidden('amount', $result_3);	
					hidden('loan_amount', $loan_amt);	
				}
				else{
					label_row(_("Loan Balance"), price_format($loan_amt));  
					label_row(_("ESB"),'', ' style="border: 1px solid #ff9900;background-color: #ffff00; color: #ff5500;" ', ' style="border: 1px solid #ff9900;background-color: #ffff00; color: #ff5500; " ');  
					hidden('amount', '-1');	
					hidden('loan_amount', $loan_amt);
				}
				
				hidden('empl_id', $employee_id);			
				hidden('last_gross', $last_paid_salary);			
				hidden('status', $status);		
				hidden('days_worked', $DaysOnly);	
				hidden('date', date('Y-m-d'));	

				end_outer_table();
				br();
				submit_center('ProcessESB', _("Process ESB"));
			}else {
				label_row(_("Last Paid Gross"), price_format($paid_esb['last_gross']));
				label_row(_("Loan Balance"), price_format($paid_esb['loan_amount']));
				label_row(_("Payable ESB ")." :", price_format($paid_esb['amount']-$paid_esb['loan_amount']));
				end_outer_table();
			}
		}
	end_form();
	div_end();
end_page();?>
<style>
	/*table { width: auto; }*/
</style>
