<?php
/****************************************
/*  Author 	: Kvvaradha
/*  Module 	: Extended HRM
/*  E-mail 	: admin@kvcodes.com
/*  Version : 1.0
/*  Http 	: www.kvcodes.com
*****************************************/

$page_security = 'SA_OPEN';
$path_to_root="../../..";
include($path_to_root . "/includes/session.inc");
$version_id = get_company_prefs('version_id');

$js = '';
if($version_id['version_id'] == '2.4.1'){
	if ($SysPrefs->use_popup_windows) 
		$js .= get_js_open_window(900, 500);	

	if (user_use_date_picker()) 
		$js .= get_js_date_picker();
	
}else{
	if ($use_popup_windows)
		$js .= get_js_open_window(900, 500);
	if ($use_date_picker)
		$js .= get_js_date_picker();
}
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/ui.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include($path_to_root . "/modules/ExtendedHRM/includes/Payroll.inc" );

page(_("Taxes"), @$_REQUEST['popup'], false, "", $js);


// $Tax = GetSingleValue('kv_empl_allowances','id',array('Tax' => 1));

	CheckEmptyResult('kv_empl_allowances', sprintf(_("There is no allowances in this system. Kindly Open '%s' to update it"), "<a href='".$path_to_root."/modules/ExtendedHRM/manage/allowances.php'>"._("Allowance")."</a>"),array('Tax'=> 1));
 
 //check_db_has_employees(sprintf(_("There is no employee in this system. Kindly Open '%s' to update it"), "<a href='".$path_to_root."/modules/ExtendedHRM/manage/employees.php'>"._("Add And Manage Employees")."</a>"));
 
 check_db_has_salary_account(_("There are no Salary Account defined in this system. Kindly Open")." <a href='".$path_to_root."/modules/ExtendedHRM/manage/hrm_settings.php'>"._("Settings")."</a> "._("to update it."));


simple_page_mode(true);

if (isset($_GET['year'])){
	$_POST['year'] = $_GET['year'];
}
if (isset($_GET['allowance_id'])){
	$_POST['allowance_id'] = $_GET['allowance_id'];
}

if ($Mode=='ADD_ITEM' || $Mode=='UPDATE_ITEM'){

	$input_error = 0;

	if (!is_numeric(input_num('min_sal')) || (input_num('min_sal')<= 0) ) {
		$input_error = 1;
		display_error(_("The Minimum Salary cannot be empty | Non numeric OR less than zero."));
		set_focus('min_sal');
	}

	if (!is_numeric(input_num('max_sal')) || (input_num('max_sal')<1 ) || (input_num('max_sal')< input_num('min_sal') ) ) {
		$input_error = 1;
		display_error(_("The Maximum Salary cannot be empty | Non numeric OR less than zero."));
		set_focus('max_sal');
	}

	if(input_num('allowance_id') == 0){
		$input_error = 1;
		display_error(_("Please select an allowance to continue."));
		set_focus('allowance_id');
	}
	if ($input_error != 1)	{
		if(get_post('per_month')) {
			$min_sal = input_num('min_sal')*12;
			$max_sal = input_num('max_sal')*12;
			$taxable_salary = input_num('taxable_salary')*12;
			$offset = input_num('offset')*12;
		} else {
			$min_sal = input_num('min_sal');
			$max_sal = input_num('max_sal');
			$taxable_salary = input_num('taxable_salary');
			$offset = input_num('offset');
		}
    	if ($selected_id != -1)   {			
    		Update('kv_empl_taxes', array('id' => $selected_id), array('year' => $_POST['selected_year'], 'description' => $_POST['description'], 'min_sal' => $min_sal, 'max_sal' => $max_sal, 'taxable_salary' => $taxable_salary, 'percentage' => input_num('percentage'),  'offset' => $offset,  'allowance_id' => $_POST['selected_allowance_id']));	
    		$note = _("Selected Tax Type has been updated");
		} 	else  	{			
			Insert('kv_empl_taxes', array('year' => $_POST['selected_year'], 'description' => $_POST['description'], 'min_sal' => $min_sal, 'max_sal' => $max_sal,  'taxable_salary' => $taxable_salary, 'percentage' => input_num('percentage'),  'offset' => $offset, 'allowance_id' => $_POST['selected_allowance_id']));
    		$note = _("New Tax type has been added");
    	}
    
		display_notification($note);    	
		$Mode = 'RESET';
	}
} 

if ($Mode == 'Delete'){

	$cancel_delete = 0;

	// PREVENT DELETES IF DEPENDENT RECORDS IN 'debtors_master'

	/*if (key_in_foreign_table($selected_id, 'kv_empl_job', 'department'))	{
		$cancel_delete = 1;
		display_error(_("Cannot delete this department because Employees have been created using this department."));
	} */
	if ($cancel_delete == 0) {
		Delete('kv_empl_taxes', array('id' => $selected_id));	
		display_notification(_("Selected Tax has been deleted"));
	} //end if Delete department
	$Mode = 'RESET';
} 

if ($Mode == 'RESET'){
	$selected_id = -1;
	$sav = get_post('show_inactive');
	$selected_year = $_POST['selected_year'];
	unset($_POST);
	$_POST['year'] = $selected_year;
	if ($sav) $_POST['show_inactive'] = 1;
}

if(list_updated('per_month') ){
  	//if(get_post('per_month'))
		//$checkAll = 12;
	//else
   		//$checkAll = 1;
   	$Ajax->activate('TaxDisplay');
}//else
  	//$checkAll = 1;

  $dec = user_price_dec();

start_form();
	//if (db_has_employees()) {
		start_table(TABLESTYLE_NOBORDER);
		start_row();
		hrm_empl_tax_allowances_list_cells(_("Tax Allowances:"), 'allowance_id',null,true,

			_("All Tax Types"));
		kv_fiscalyears_list_cells(_("Fiscal Year").":", 'year', null, true);	
		check_cells(_("Show Per month"), 'per_month', null, true);
		end_row();
		end_table();
		br();
		if (get_post('_show_inactive_update')) {
			$Ajax->activate('year');
			set_focus('year');
		}
	$year = get_post('year');
	$allownce_id = get_post('allowance_id'); 
	$ar_condition = array('year' => $year);
	if(list_updated('allowance_id')){
		if(get_post('allowance_id')>0)
		$ar_condition['allowance_id'] = get_post('allowance_id');
		$Ajax->activate('TaxDisplay');
	}
	//else {			
	//	hidden('year');
	//}

	
	div_start('TaxDisplay');
	$rows = GetAll('kv_empl_taxes', $ar_condition);
	start_table(TABLESTYLE, "width=60%");
	if(get_post('per_month')){
		$th = array(_("Year"), _("Description"), _("Minimum Wage/Month"), _("Maximum Wage/Month"), _("Percentage(%)"),_("Taxable Salary/Month"), _("Offset/Month"),_("Allowances"),"", "");
		$groupString = _("Month");
		$checkAll = 12;
	} else {
		$th = array(_("Year"), _("Description"), _("Minimum Wage/Annum"), _("Maximum Wage/Anum"), _("Percentage(%)"),_("Taxable Salary/Anum"), _("Offset/Anum"),_("Allowances"),"", "");
		$groupString = _("Annum");
		$checkAll = 1;
	}
	//inactive_control_column($th);

	table_header($th);
	$k = 0; 

	foreach($rows as $myrow) {
		
		alt_table_row_color($k);
			$yearselected = get_fiscalyear($myrow['year']);
		label_cell(sql2date($yearselected['begin']).' - '.sql2date($yearselected['end']));
		label_cell($myrow["description"]);
		label_cell(round($myrow["min_sal"]/$checkAll, $dec));
		label_cell(round($myrow["max_sal"]/$checkAll, $dec));
		label_cell($myrow["percentage"]);		
		label_cell(round($myrow["taxable_salary"]/$checkAll, $dec));
		label_cell(round($myrow["offset"]/$checkAll, $dec));
		label_cell(GetSingleValue('kv_empl_allowances', 'description', array('id' => $myrow["allowance_id"])));
		//inactive_control_cell($myrow["id"], $myrow["inactive"], 'departments', 'id');
	 	edit_button_cell("Edit".$myrow["id"], _("Edit"));
	 	delete_button_cell("Delete".$myrow["id"], _("Delete"));
		end_row();
	}

	//inactive_control_row($th);
	end_table(1);

	//-------------------------------------------------------------------------------
	start_table(TABLESTYLE2);

	if ($selected_id != -1) {
	 	if ($Mode == 'Edit') {
			//editing an existing department
			$myrow = GetRow('kv_empl_taxes', array('id' => $selected_id));

			$_POST['year']  = $myrow["year"];
			$_POST['allowance_id']  = $myrow["allowance_id"];
			$_POST['description']  = $myrow["description"];
			$_POST['min_sal']  = round($myrow["min_sal"]/$checkAll, $dec);
			$_POST['max_sal']  = round($myrow["max_sal"]/$checkAll, $dec);
			$_POST['taxable_salary']  = round($myrow["taxable_salary"]/$checkAll, $dec);
			$_POST['percentage']  = $myrow["percentage"];			//$_POST['frequency']  = $myrow["frequency"];
			$_POST['offset']  = round($myrow["offset"]/$checkAll, $dec);
			hidden("selected_allowance_id", $myrow["allowance_id"]);
		}

		hidden("selected_id", $selected_id);
		
		label_row(_("ID"), $myrow["id"]); 
	} 
	hidden("selected_year", $_POST['year']);
	hidden("selected_allowance_id", $_POST['allowance_id']);
	text_row_ex(_("Description"). " :", 'description', 30); 
	amount_row(_("Minimum Salary"). " :", 'min_sal', null, null, '/'.$groupString, null, true ); 
	amount_row(_("Maximum Salary"). " :", 'max_sal', null, null, '/'.$groupString, null, true ); 
	amount_row(_("Taxable Salary"). " :", 'taxable_salary', null, null,'/'.$groupString, null, true); 
	text_row_ex(_("Percentage"). " :", 'percentage', 10, 10, '', null, null, "%");	//TaxFrequency_List_row(_("Frequency"), 'frequency', null );
	amount_row(_("Offset"). " :", 'offset', null,null,'/'.$groupString); 
	end_table(1);

	submit_add_or_update_center($selected_id == -1, '', 'both');

	div_end();
	//display_notification($selected_id);

	end_form();
end_page();
?>