<?php

global $unknown ,$path_to_root;
include_once($path_to_root . "/modules/Kvcodes_importexport/includes/items.inc");  
include_once($path_to_root . "/modules/Kvcodes_importexport/includes/customers.inc");
include_once($path_to_root . "/modules/Kvcodes_importexport/includes/suppliers.inc");
include_once($path_to_root . "/modules/Kvcodes_importexport/includes/inventory.inc");
include_once($path_to_root . "/modules/Kvcodes_importexport/includes/journal_entry.inc");
include_once($path_to_root . "/modules/Kvcodes_importexport/includes/bank_statement.inc");
include_once($path_to_root . "/modules/Kvcodes_importexport/includes/chart_of_accounts.inc");
include_once($path_to_root . "/modules/Kvcodes_importexport/includes/bom.inc");
include_once($path_to_root . "/modules/Kvcodes_importexport/includes/kvcodes.inc");
function get_default_value($data,$value){
    global $unknown;
    if($data ==''){
       return $value." is empty in this row ! "; 
    }
    return false;
}
function check_empty($array=array()){
   global $unknown;
   $error="";
   foreach ($array as $key => $value) {
       if($value ==''){
            $error .=$key." is empty in this row ! "; 
        }
   }
    return $error;
}
function get_tax_type_id($tax_type){
    $tax_type_id =GetSingleValue('item_tax_types','id',array('name'=>$tax_type));
    if(!$tax_type_id){
        $tax_type_id =Insert('item_tax_types',array('name'=>$tax_type));
    }
    return $tax_type_id ;
}
function value_exists_stock_master($data,$value){
    $stock_exists =GetSingleValue('stock_master','stock_id',array('stock_id'=>$data));
    if($stock_exists ){
        return $value." is already exists!";
    }
    return false;
}


function get_sales_type_id($sales_type){
    $sales_type_id =GetSingleValue('sales_types','id',array('sales_type'=>$sales_type));
    if(!$sales_type_id ){
        $sales_type_id =Insert('sales_types',array('sales_type'=>$sales_type,'tax_included'=>1));
    }
    return $sales_type_id;
}
function get_curr_abrev($get_curr_abrev){
    if($get_curr_abrev ==""){
        // return GetSingleValue('sys_prefs','value',array('name'=>'curr_default'));
        return get_sys_defaults('','curr_default');
    }
    $curr_abrev=GetSingleValue('currencies','curr_abrev',array('curr_abrev'=>$get_curr_abrev));
    if(!$curr_abrev){
        return false;
    }
    return $curr_abrev;
}

function put_csv($data) {
        if(!file_exists(company_path().'/csv/tmp')){
            mkdir(company_path().'/csv/tmp');
        }
        $fh = fopen(company_path().'/csv/tmp/'.$_FILES['file']['name'], 'w+'); 
        foreach ( $data as $row ) {
            fputcsv($fh, $row);
        }
        rewind($fh);
        $csv = stream_get_contents($fh);
        fclose($fh);       
}

function get_sys_defaults($item,$name)
{
    if($item ==""){
        return get_company_pref($name);
    }
    return $item;
}
function default_stock_cvalue($value,$col,$category_id)
{
   if($value ==""){
        return GetSingleValue('stock_category',$col,array('category_id'=>$category_id));
   }
   return $value;
}
function value_exists_debtors_master($data,$value){
    $stock_exists =GetSingleValue('debtors_master','name',array('debtor_ref'=>$data));
    if($stock_exists ){
        return $value." is already exists!";
    }
    return false;
}

function value_exists_suppliers($data,$value){
    $stock_exists =GetSingleValue('suppliers','supp_ref',array('supp_ref'=>$data));
    if($stock_exists ){
        return $value." is already exists!";
    }
    return false;
}
function value_exists_stock_moves($data,$value){
    $stock_exists =GetSingleValue('stock_moves','stock_id',array('stock_id'=>$data));
    if($stock_exists ){
        return $value." is already exists!";
    }
    return false;
}
function get_payment_terms_id($payment_terms){

    $payment_terms_id=GetSingleValue('payment_terms','terms_indicator',array('terms'=>$payment_terms));
    if(!$payment_terms_id){
        return false;
    }
    return $payment_terms_id;
}

function get_tax_group_id_two($tax_group){

    $tax_group_id=GetSingleValue('tax_groups','id',array('name'=>$tax_group));
    if(!$tax_group_id){
        return false;
    }
    return $tax_group_id;
}
function get_area_code($area){
    if($area ==''){
        $area_code=GetRow('areas');
        if(!$area_code){
            return false;
        }
        $area_code =$area_code['area_code'];
    }
    else{
        $area_code=GetSingleValue('areas','area_code',array('description'=>$area));
        if(!$area_code){
            $area_code =Insert('areas',array('description'=>$area));
        }
    }
    return $area_code;
}

function get_sales_person_id($person){
    if($person ==''){
        $sales_person_id=GetRow('salesman');
        if(!$sales_person_id){
            return false;
        }
        $sales_person_id = $sales_person_id['salesman_code'];
    }
    else{
        $sales_person_id=GetSingleValue('salesman','salesman_code',array('salesman_name'=>$person));
        if(!$sales_person_id){
            return false;
        }
    }
    return $sales_person_id;
}

function get_location_code($loc_code){
	if($loc_code ==''){
		$locations =GetRow('locations');
        if($locations)
    	   $locations['loc_code'];
        else
            $locations =false;
	}else{
		$loc_code_check =GetSingleValue('locations','loc_code',array('loc_code'=>$loc_code));
	}
	if($loc_code_check){
		return $loc_code_check;
	}
	return false;
}

function get_credit_status_id($credit_status){
    if($credit_status ==''){
        $credit_status_row =GetRow('credit_status');
        if($credit_status_row)
           $credit_status_id=$credit_status_row['id'];
        else
            $credit_status_id =false;
    }else{
        $credit_status_id =GetSingleValue('credit_status','id',array('reason_description'=>$credit_status));
    }

    if($credit_status_id){
        return $credit_status_id;
    }
    return false;
}



function get_chart_class_id($class_name,$class_type){
    $chart_class_id=GetSingleValue('chart_class','cid',array('class_name'=>$class_name,'ctype'=>is_numeric($class_type)?$class_type: constant($class_type)));
    if(!$chart_class_id){
        $chart_class_id = GetSingleValue('chart_class',"max(cast(cid as unsigned) ) AS MaximumValue")+1;
        Insert('chart_class',array('class_name'=>$class_name,'ctype'=>is_numeric($class_type)?$class_type: constant($class_type),'cid'=>$chart_class_id));
    }
    return $chart_class_id;
}

function get_chart_type_id($type_name,$class_id){
    $get_chart_type_id=GetSingleValue('chart_types','id',array('name'=>$type_name,'class_id'=>$class_id));
    if(!$get_chart_type_id){
        $get_chart_type_id = GetSingleValue('chart_types',"max(cast(id as unsigned) ) AS MaximumValue")+1;
        Insert('chart_types',array('name'=>$type_name,'class_id'=>$class_id,'id'=>$get_chart_type_id));
    }
    return $get_chart_type_id;
}

function export_csv($data,$file_name)
{
    $file_path=company_path().'/csv/'.uniqid().".csv"; 
    if(!file_exists(company_path().'/csv')){
        mkdir(company_path().'/csv');
    }
    $file = fopen($file_path,"w");

    foreach ($data as $line) {
      fputcsv($file, $line);
    }
    rewind($file);
    fclose($file);

    header("Content-type: text/csv");
    header('Content-Disposition: attachment; filename='.$file_name.".csv");  
    echo file_get_contents($file_path); 
    if(file_exists( $file_path) && !is_dir( $file_path))     
        unlink( $file_path);
    exit();

}



?>
