<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_IMPORT';
$path_to_root = "../../..";

include_once($path_to_root . "/includes/db_pager.inc");
include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/ui.inc");

$js ="";
add_access_extensions();
page(_($help_context = "Kv import/export system info"), true, false, "", $js);

if(isset($_GET['type'])){
	$type =$_GET['type'];
}else{
	$type = "all";
}

//for customers


if($type=='all' || $type=='customers' || $type=='journal'){
display_heading("Customers");
$sql = "SELECT debtor_no ,debtor_ref FROM ".TB_PREF."debtors_master WHERE 1";
$cols = array(
	_("id") => 'debtor_no',
	_("Customer Name") => array('name'=>'debtor_ref'));
	
$table =& new_db_pager('debtors_master', $sql, $cols, 'debtors_master' );
$table->width = "80%";
display_db_pager($table);
br();
}

// for suppliers
if($type=='all' || $type =='suppliers'|| $type=='journal'){
display_heading("Suppliers");
$sql = "SELECT supplier_id ,supp_ref FROM ".TB_PREF."suppliers WHERE 1";
$cols = array(
	_("id") => 'supplier_id',
	_("Supplier Name") => array('name'=>'supp_ref'));
	
$table =& new_db_pager('suppliers', $sql, $cols, 'suppliers' );
$table->width = "80%";
display_db_pager($table);
br();
}

// for items tax types
if($type=='all' || $type=='items'){
display_heading("Items Tax Types");
$sql = "SELECT id ,name FROM ".TB_PREF."item_tax_types WHERE 1";
$cols = array(
	_("id") => 'id',
	_("Item tax name") => array('name'=>'name'));
	
$table =& new_db_pager('item_tax_types', $sql, $cols, 'item_tax_types' );
$table->width = "80%";
display_db_pager($table);
br();
}

// for sales types
if($type=='all' || $type =='items' ||$type=='customers'){
display_heading("Sales Types");
$sql = "SELECT id ,sales_type FROM ".TB_PREF."sales_types WHERE 1";
$cols = array(
	_("id") => 'id',
	_("Sales type name") => array('name'=>'sales_type'));
	
$table =& new_db_pager('sales_types', $sql, $cols, 'sales_types' );
$table->width = "80%";
display_db_pager($table);
br();
}

// for tax groups
if($type=='all' ||$type=='customers' || $type =='suppliers'){
display_heading("Tax Groups");
$sql = "SELECT id ,name FROM ".TB_PREF."tax_groups WHERE 1";
$cols = array(
	_("id") => 'id',
	_("Tax group name") => array('name'=>'name'));
	
$table =& new_db_pager('tax_groups', $sql, $cols, 'tax_groups' );
$table->width = "80%";
display_db_pager($table);
br();
}

// for tax types
if($type=='all' ||$type=='items' ||$type=='journal'){
display_heading("Tax Types");
$sql = "SELECT id ,name FROM ".TB_PREF."tax_types WHERE 1";
$cols = array(
	_("id") => 'id',
	_("Tax type name") => array('name'=>'name'));
	
$table =& new_db_pager('tax_types', $sql, $cols, 'tax_types' );
$table->width = "80%";
display_db_pager($table);
br();
}

// for tax Chart of accounts
if($type=='journal'){
display_heading("Chart of accounts");
$sql = "SELECT account_code ,account_name FROM ".TB_PREF."chart_master WHERE 1";
$cols = array(
	_("Account Code") => 'account_code',
	_("Account Name") => array('name'=>'account_name'));
	
$table =& new_db_pager('tax_types', $sql, $cols, 'tax_types' );
$table->width = "80%";
display_db_pager($table);
br();
}

// for currencies
if($type=='all' || $type=='items' ||$type=='customers' || $type =='suppliers'){
display_heading("Currencies");
$sql = "SELECT curr_abrev ,currency FROM ".TB_PREF."currencies WHERE 1";
$cols = array(
	_("Currency Code") => 'curr_abrev',
	_("Currency") => array('name'=>'currency'));
	
$table =& new_db_pager('currencies', $sql, $cols, 'currencies' );
$table->width = "80%";
display_db_pager($table);
br();
}

// for payment terms
if($type=='all' ||$type=='customers' || $type =='suppliers'){
display_heading("Payment Terms");
$sql = "SELECT terms_indicator ,terms FROM ".TB_PREF."payment_terms WHERE 1";
$cols = array(
	_("Id") => 'curr_abrev',
	_("Terms") => array('name'=>'terms'));
	
$table =& new_db_pager('payment_terms', $sql, $cols, 'payment_terms' );
$table->width = "80%";
display_db_pager($table);
br();
}

// for areas
if($type=='all' || $type =='adjustment'){
display_heading("Areas");
$sql = "SELECT area_code ,description FROM ".TB_PREF."areas WHERE 1";
$cols = array(
	_("Area code") => 'area_code',
	_("Description") => array('name'=>'description'));
	
$table =& new_db_pager('areas', $sql, $cols, 'areas' );
$table->width = "80%";
display_db_pager($table);
br();
}

// for Stock manufacturable items
if($type=='bom'){
display_heading("Manufacturable items");
$sql = "SELECT stock_id, description ,units
			FROM ".TB_PREF."stock_master WHERE mb_flag!='F' AND (mb_flag= 'M') ORDER BY stock_id";
$cols = array(
	_("Stock Id") => 'stock_id',
	_("Description") => array('name'=>'description'),
	_("Unit") => array('name'=>'units')
);
	
$table =& new_db_pager('stock_master', $sql, $cols, 'stock_master' );
$table->width = "80%";
display_db_pager($table);
br();
}


// for Stock items
if($type=='all' || $type =='adjustment' || $type=='items' || $type =='bom'){
display_heading("Stock items");
$sql = "SELECT stock_id ,description,units FROM ".TB_PREF."stock_master WHERE 1";
$cols = array(
	_("Stock Id") => 'stock_id',
	_("Description") => array('name'=>'description'),
	_("Unit") => array('name'=>'units'),
);
	
$table =& new_db_pager('stock_master', $sql, $cols, 'stock_master' );
$table->width = "80%";
display_db_pager($table);
br();
}

// for Locations
if($type =='bom'){
display_heading("Locations");
$sql = "SELECT loc_code, location_name, inactive FROM ".TB_PREF."locations WHERE 1";
$cols = array(
	_("Code") => 'loc_code',
	_("Name") => array('name'=>'location_name'),
);
	
$table =& new_db_pager('locations', $sql, $cols, 'locations' );
$table->width = "80%";
display_db_pager($table);
br();
}


// for Stock Work centres
if($type =='bom'){
display_heading("Work Centres");
$sql = "SELECT id, name FROM ".TB_PREF."workcentres WHERE inactive=0";
$cols = array(
	_("Code") => 'id',
	_("Name") => array('name'=>'name'),
);
	
$table =& new_db_pager('workcentres', $sql, $cols, 'workcentres' );
$table->width = "80%";
display_db_pager($table);
br();
}

// for Stock Work centres
if($type =='items'){
display_heading("Item flag types");
global $stock_types;
start_table(TABLESTYLE,'width=80%');
$th =array(_('Flag'),_('Name'));
table_header($th);
$k=0;
if($stock_types){
	foreach ($stock_types as $key=> $value) {
		
		start_row();
		alt_table_row_color($k);
		label_cell($key);
		label_cell($value);
		end_row();
	}
}
end_table();
br();
}

// for Stock Work centres
if($type =='bank_statement'){
display_heading("Bank accounts");
$sql = "SELECT bank_account_name, bank_account_number FROM ".TB_PREF."bank_accounts  WHERE 1";
$cols = array(
	_("Account Name") => 'bank_account_name',
	_("Account Number") => array('name'=>'bank_account_number'),
);
	
$table =& new_db_pager('bank_accounts', $sql, $cols, 'bank_accounts' );
$table->width = "80%";
display_db_pager($table);
br();

}

end_row();
end_table();

end_page();

