<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_VOIDTRANSACTION';
$path_to_root = "../../..";
include($path_to_root . "/includes/db_pager.inc");
include_once($path_to_root . "/includes/session.inc");

include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/ui.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/admin/db/transactions_db.inc");

include_once($path_to_root . "/admin/db/voiding_db.inc");

include_once($path_to_root . "/modules/Kvcodes_importexport/includes/kvcodes.inc");

$js = "";
if (user_use_date_picker())
	$js .= get_js_date_picker();
if ($SysPrefs->use_popup_windows)
	$js .= get_js_open_window(800, 500);

if(isset($_GET['id']) && isset($_GET['trans_type']) && isset($_GET['trans_no'])){
	$selected_id=$_GET['id'];
	$_POST['selected_id']=$selected_id;
	$_POST['filterType']=$_GET['trans_type'];
	$_POST['trans_no']=$_GET['trans_no'];
}elseif(isset($_GET['close']) || (isset($_POST['id']) && isset($_POST['trans_type']) && isset($_POST['trans_no']))){
	$js.= "window.self.close()";
	page(_($help_context = "Void a Transaction"), false, false, "", $js);
	end_page();
	exit();
}
page(_($help_context = "Void a Transaction"), false, false, "", $js);
simple_page_mode(true);
//----------------------------------------------------------------------------------------
function exist_transaction($type, $type_no)
{
	$void_entry = get_voided_entry($type, $type_no);

	if ($void_entry != null)
		return false;

	switch ($type) 
	{
		case ST_JOURNAL : // it's a journal entry
			if (!exists_gl_trans($type, $type_no))
				return false;
			break;

		case ST_BANKPAYMENT : // it's a payment
		case ST_BANKDEPOSIT : // it's a deposit
		case ST_BANKTRANSFER : // it's a transfer
			if (!exists_bank_trans($type, $type_no))
				return false;
			break;

		case ST_SALESINVOICE : // it's a customer invoice
		case ST_CUSTCREDIT : // it's a customer credit note
		case ST_CUSTPAYMENT : // it's a customer payment
		case ST_CUSTDELIVERY : // it's a customer dispatch
			if (!exists_customer_trans($type, $type_no))
				return false;
			break;

		case ST_LOCTRANSFER : // it's a stock transfer
			if (get_stock_transfer_items($type_no) == null)
				return false;
			break;

		case ST_INVADJUST : // it's a stock adjustment
			if (get_stock_adjustment_items($type_no) == null)
				return false;
			break;

		case ST_PURCHORDER : // it's a PO
			return false;

		case ST_SUPPRECEIVE : // it's a GRN
			if (!exists_grn($type_no))
				return false;
			break;

		case ST_SUPPINVOICE : // it's a suppler invoice
		case ST_SUPPCREDIT : // it's a supplier credit note
		case ST_SUPPAYMENT : // it's a supplier payment
			if (!exists_supp_trans($type, $type_no))
				return false;
			break;

		case ST_WORKORDER : // it's a work order
			if (!get_work_order($type_no, true))
				return false;
			break;

		case ST_MANUISSUE : // it's a work order issue
			if (!exists_work_order_issue($type_no))
				return false;
			break;

		case ST_MANURECEIVE : // it's a work order production
			if (!exists_work_order_produce($type_no))
				return false;
			break;

		case ST_SALESORDER: // it's a sales order
		case ST_SALESQUOTE: // it's a sales quotation
			return false;
		case ST_COSTUPDATE : // it's a stock cost update
			return false;
	}

	return true;
}

function is_selected($row) // Function added by faisal
{
	global $selected_id;
	return $row['trans_no'] == $selected_id ? true : false;
}

function voiding_controls()
{
	global $selected_id;

	$not_implemented =  array(ST_PURCHORDER, ST_SALESORDER, ST_SALESQUOTE, ST_COSTUPDATE);

	start_form();

	start_table(TABLESTYLE2);

	if ($selected_id != -1)
	{
		hidden('trans_no', $selected_id);
		hidden('selected_id', $selected_id);
	}
	else
	{
		hidden('trans_no', '');
		$_POST['memo_'] = '';
	}	
    label_row(_("Transaction #:"), ($selected_id==-1?'':$selected_id));

    date_row(_("Voiding Date:"), 'date_');

    textarea_row(_("Memo:"), 'memo_', null, 30, 4);

	end_table(1);

    if (!isset($_POST['ProcessVoiding']))
    	submit_center('ProcessVoiding', _("Void Transaction"), true, '', 'default');
    else 
    {
 		if (!exist_transaction($_POST['filterType'],$_POST['trans_no']))
 		{
			display_error(_("The entered transaction does not exist or cannot be voided."));
			unset($_POST['trans_no']);
			unset($_POST['memo_']);
			unset($_POST['date_']);
    		submit_center('ProcessVoiding', _("Void Transaction"), true, '', 'default');
		}	
 		else
 		{
           	if ($_POST['filterType'] == ST_SUPPRECEIVE) { 
                $result = get_grn_items($_POST['trans_no']);
                if (db_num_rows($result) > 0) {
                    while ($myrow = db_fetch($result)) {
                        if (is_inventory_item($myrow["item_code"])) {
                            if (check_negative_stock($myrow["item_code"], -$myrow["qty_recd"], null, $_POST['date_'])) {
                                $stock = get_item($myrow["item_code"]);
                                display_error(_("The void cannot be processed because there is an insufficient quantity for item:") .
                                    " " . $stock['stock_id'] . " - " . $stock['description'] . " - " .
                                    _("Quantity On Hand") . " = " . number_format2(get_qoh_on_date($stock['stock_id'], null, 
                                    $_POST['date_']), get_qty_dec($stock['stock_id'])));
                                return false;
                            }
                        }
                    }
                }
            }
       		display_warning(_("Are you sure you want to void this transaction ? This action cannot be undone."), 0, 1);
   			br();
    		submit_center_first('ConfirmVoiding', _("Proceed"), '', true);
    		submit_center_last('CancelVoiding', _("Cancel"), '', 'cancel');
    	}	
    }
    hidden('filterType',$_POST['filterType']);
    hidden('trans_no',$_POST['trans_no']);
    hidden('selected_id',$_POST['selected_id']);
	end_form();
}

//----------------------------------------------------------------------------------------

function check_valid_entries()
{
	if (is_closed_trans($_POST['filterType'],$_POST['trans_no']))
	{
		display_error(_("The selected transaction was closed for edition and cannot be voided."));
		set_focus('trans_no');
		return false;
	}
	if (!is_date($_POST['date_']))
	{
		display_error(_("The entered date is invalid."));
		set_focus('date_');
		return false;
	}
	if (!is_date_in_fiscalyear($_POST['date_']))
	{
		display_error(_("The entered date is out of fiscal year or is closed for further data entry."));
		set_focus('date_');
		return false;
	}

	if (!is_numeric($_POST['trans_no']) OR $_POST['trans_no'] <= 0)
	{
		display_error(_("The transaction number is expected to be numeric and greater than zero."));
		set_focus('trans_no');
		return false;
	}

	return true;
}

//----------------------------------------------------------------------------------------

function handle_void_transaction()
{
	if (check_valid_entries()==true) 
	{
		$void_entry = get_voided_entry($_POST['filterType'], $_POST['trans_no']);
		if ($void_entry != null) 
		{
			display_error(_("The selected transaction has already been voided."), true);
			unset($_POST['trans_no']);
			unset($_POST['memo_']);
			unset($_POST['date_']);
			set_focus('trans_no');
			return;
		}

		$msg = void_transaction($_POST['filterType'], $_POST['trans_no'],
			$_POST['date_'], $_POST['memo_']);

		if (!$msg) 
		{
			display_notification_centered(_("Selected transaction has been voided."));
			unset($_POST['trans_no']);
			unset($_POST['memo_']);
		}
		else {
			display_error($msg);
			set_focus('trans_no');

		}
	}
}

//----------------------------------------------------------------------------------------

if (!isset($_POST['date_']))
{
	$_POST['date_'] = Today();
	if (!is_date_in_fiscalyear($_POST['date_']))
		$_POST['date_'] = end_fiscalyear();
}		
	
if (isset($_POST['ProcessVoiding']))
{
	if (!check_valid_entries())
		unset($_POST['ProcessVoiding']);
	$Ajax->activate('_page_body');
}

if (isset($_POST['ConfirmVoiding']))
{
	$current_bank_trans =GetRow('bank_trans',array('id'=>$_POST['selected_id']));

	$trans_no_payment = get_next_trans_no(ST_UNDEFINED);
    Insert('bank_trans', array('type' => ST_UNDEFINED, 'trans_no' => $trans_no_payment, 'bank_act' => $current_bank_trans['bank_act'], 'ref' => '', 'trans_date' => $current_bank_trans['trans_date'], 'amount' => $current_bank_trans['amount'], 'person_type_id' => 0, 'person_id' => null, 'account_no' => $current_bank_trans['account_no'], 'account_name' => $current_bank_trans['account_name'], 'entry_date' => $current_bank_trans['entry_date'], 'imported' => 1));
    Insert('comments', array('type' => ST_UNDEFINED, 'id' => $trans_no_payment, 'memo_' => get_comments_string($current_bank_trans['type'], $current_bank_trans['trans_no']), 'date_' => $current_bank_trans['trans_date']));

	handle_void_transaction();
	meta_forward($_SERVER['PHP_SELF'], "close=yes");
	$Ajax->activate('_page_body');
}

if (isset($_POST['CancelVoiding']))
{
	$selected_id = -1;
	$Ajax->activate('_page_body');
}

//----------------------------------------------------------------------------------------

voiding_controls();

end_page();

