# MySQL dump of database 'nasakcaa_erp' on host 'localhost'
# Backup Date and Time: 2023-01-19 14:13
# Built by digitleysystem 2.4.11
# http://digitleysystem
# Company: NASA CHEMICALS
# User: Administrator

# Compatibility: 2.4.1


SET NAMES latin1;


### Structure of table `0_approval_trans` ###

DROP TABLE IF EXISTS `0_approval_trans`;

CREATE TABLE `0_approval_trans` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` int(11) NOT NULL,
  `trans_no` int(11) NOT NULL,
  `date` date NOT NULL DEFAULT '0000-00-00',
  `user_id` int(11) NOT NULL,
  `remarks` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ;

### Data of table `0_approval_trans` ###


### Structure of table `0_areas` ###

DROP TABLE IF EXISTS `0_areas`;

CREATE TABLE `0_areas` (
  `area_code` int(11) NOT NULL AUTO_INCREMENT,
  `description` varchar(60) NOT NULL DEFAULT '',
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`area_code`),
  UNIQUE KEY `description` (`description`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_areas` ###

INSERT INTO `0_areas` VALUES
('1', 'Global', '0'),
('2', 'Korangi', '0'),
('3', 'Malir', '0'),
('4', 'DHA', '0');

### Structure of table `0_attachments` ###

DROP TABLE IF EXISTS `0_attachments`;

CREATE TABLE `0_attachments` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(60) NOT NULL DEFAULT '',
  `type_no` int(11) NOT NULL DEFAULT 0,
  `trans_no` int(11) NOT NULL DEFAULT 0,
  `unique_name` varchar(60) NOT NULL DEFAULT '',
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `filename` varchar(60) NOT NULL DEFAULT '',
  `filesize` int(11) NOT NULL DEFAULT 0,
  `filetype` varchar(60) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `type_no` (`type_no`,`trans_no`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_attachments` ###


### Structure of table `0_audit_trail` ###

DROP TABLE IF EXISTS `0_audit_trail`;

CREATE TABLE `0_audit_trail` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` smallint(6) unsigned NOT NULL DEFAULT 0,
  `trans_no` int(11) unsigned NOT NULL DEFAULT 0,
  `user` smallint(6) unsigned NOT NULL DEFAULT 0,
  `stamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `description` varchar(60) DEFAULT NULL,
  `fiscal_year` int(11) NOT NULL DEFAULT 0,
  `gl_date` date NOT NULL DEFAULT '0000-00-00',
  `gl_seq` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `Seq` (`fiscal_year`,`gl_date`,`gl_seq`),
  KEY `Type_and_Number` (`type`,`trans_no`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_audit_trail` ###

INSERT INTO `0_audit_trail` VALUES
('1', '17', '1', '1', '2023-01-19 09:08:58', NULL, '4', '2023-01-16', '0');

### Structure of table `0_bank_accounts` ###

DROP TABLE IF EXISTS `0_bank_accounts`;

CREATE TABLE `0_bank_accounts` (
  `account_code` varchar(15) NOT NULL DEFAULT '',
  `account_type` smallint(6) NOT NULL DEFAULT 0,
  `bank_account_name` varchar(60) NOT NULL DEFAULT '',
  `bank_account_number` varchar(100) NOT NULL DEFAULT '',
  `bank_name` varchar(60) NOT NULL DEFAULT '',
  `bank_address` tinytext DEFAULT NULL,
  `bank_curr_code` char(3) NOT NULL DEFAULT '',
  `dflt_curr_act` tinyint(1) NOT NULL DEFAULT 0,
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `bank_charge_act` varchar(15) NOT NULL DEFAULT '',
  `last_reconciled_date` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ending_reconcile_balance` double NOT NULL DEFAULT 0,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `bank_account_name` (`bank_account_name`),
  KEY `bank_account_number` (`bank_account_number`),
  KEY `account_code` (`account_code`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_bank_accounts` ###

INSERT INTO `0_bank_accounts` VALUES
('1060', '0', 'HBL-PVT-856003', '856003', 'Habib Bank Ltd', 'Annexe Branch', 'PKR', '0', '1', '5690', '2022-10-28 00:00:00', '0', '0'),
('1065', '3', 'Cash In Hand', 'N/A', 'N/A', NULL, 'PKR', '0', '2', '5690', '0000-00-00 00:00:00', '0', '0'),
('1020102003', '3', 'Petty Cash - Lhr', '', '', NULL, 'PKR', '0', '3', '5690', '0000-00-00 00:00:00', '0', '0'),
('1020102004', '3', 'Petty Cash - HYD', '', 'Petty Cash', NULL, 'PKR', '0', '4', '5690', '0000-00-00 00:00:00', '0', '0'),
('1020102002', '3', 'Petty Cash - WH', '', '', NULL, 'PKR', '0', '5', '5690', '0000-00-00 00:00:00', '0', '0'),
('1020102005', '3', 'Petty Cash - HUB', '', '', NULL, 'PKR', '1', '6', '5690', '0000-00-00 00:00:00', '0', '0'),
('1020102001', '3', 'Petty Cash - HO', '', '', NULL, 'PKR', '0', '7', '5690', '0000-00-00 00:00:00', '0', '0');

### Structure of table `0_bank_trans` ###

DROP TABLE IF EXISTS `0_bank_trans`;

CREATE TABLE `0_bank_trans` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` smallint(6) DEFAULT NULL,
  `trans_no` int(11) DEFAULT NULL,
  `bank_act` varchar(15) NOT NULL DEFAULT '',
  `ref` varchar(40) DEFAULT NULL,
  `trans_date` date NOT NULL DEFAULT '0000-00-00',
  `amount` double DEFAULT NULL,
  `dimension_id` int(11) NOT NULL DEFAULT 0,
  `dimension2_id` int(11) NOT NULL DEFAULT 0,
  `person_type_id` int(11) NOT NULL DEFAULT 0,
  `person_id` tinyblob DEFAULT NULL,
  `account_no` varchar(50) NOT NULL DEFAULT '',
  `account_name` varchar(250) NOT NULL DEFAULT '',
  `entry_date` date NOT NULL DEFAULT '0000-00-00',
  `imported` tinyint(4) NOT NULL DEFAULT 0,
  `reconciled` date DEFAULT NULL,
  `is_cheque_no` int(11) NOT NULL DEFAULT 0,
  `cheque_no` varchar(30) DEFAULT NULL,
  `po_no` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `bank_act` (`bank_act`,`ref`),
  KEY `type` (`type`,`trans_no`),
  KEY `bank_act_2` (`bank_act`,`reconciled`),
  KEY `bank_act_3` (`bank_act`,`trans_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_bank_trans` ###


### Structure of table `0_bom` ###

DROP TABLE IF EXISTS `0_bom`;

CREATE TABLE `0_bom` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `parent` char(20) NOT NULL DEFAULT '',
  `component` char(20) NOT NULL DEFAULT '',
  `workcentre_added` int(11) NOT NULL DEFAULT 0,
  `loc_code` char(5) NOT NULL DEFAULT '',
  `quantity` double NOT NULL DEFAULT 1,
  PRIMARY KEY (`parent`,`component`,`workcentre_added`,`loc_code`),
  KEY `component` (`component`),
  KEY `id` (`id`),
  KEY `loc_code` (`loc_code`),
  KEY `parent` (`parent`,`loc_code`),
  KEY `workcentre_added` (`workcentre_added`)
) ENGINE=InnoDB AUTO_INCREMENT=234 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_bom` ###

INSERT INTO `0_bom` VALUES
('21', '', 'CM-002', '1', 'PFLOR', '0.0103'),
('10', '', 'CM-003', '1', 'PFLOR', '0.9063'),
('32', '', 'CM-008', '1', 'PFLOR', '0.0008'),
('34', '', 'CM-010', '1', 'PFLOR', '0.0077'),
('33', '', 'CM-014', '1', 'PFLOR', '0.7615'),
('18', '', 'CM-023', '1', 'PFLOR', '0.91'),
('22', '', 'CM-030', '1', 'PFLOR', '0.0622'),
('20', '', 'CM-032', '1', 'PFLOR', '0.0001'),
('19', '', 'CM-033', '1', 'PFLOR', '0.0001'),
('23', '', 'RM-023', '2', 'PFLR2', '1'),
('35', '', 'RM-118', '2', 'PFLR2', '1'),
('17', 'FG-001', 'RM-023', '2', 'PFLR2', '1'),
('25', 'FG-001', 'RM-070', '2', 'PFLR2', '0.0833'),
('24', 'FG-001', 'RM-125', '2', 'PFLR2', '1'),
('91', 'FG-001', 'SFG-101', '2', 'PFLR2', '1'),
('8', 'FG-002', 'CM-010', '1', 'PFLOR', '0.0075'),
('7', 'FG-002', 'CM-019', '1', 'PFLOR', '0.0025'),
('27', 'FG-008', 'CM-008', '1', 'PFLOR', '0.0008'),
('29', 'FG-008', 'CM-010', '1', 'PFLOR', '0.0077'),
('28', 'FG-008', 'CM-014', '1', 'PFLOR', '0.7615'),
('30', 'FG-008', 'RM-023', '2', 'PFLR2', '1'),
('31', 'FG-008', 'RM-118', '2', 'PFLR2', '1'),
('36', 'FG-009', 'CM-008', '1', 'PFLOR', '0.0003'),
('38', 'FG-009', 'CM-010', '1', 'PFLOR', '0.0031'),
('37', 'FG-009', 'CM-014', '1', 'PFLOR', '0.3066'),
('41', 'FG-009', 'RM-003', '2', 'PFLR2', '1'),
('44', 'FG-009', 'RM-054', '2', 'PFLR2', '0.0417'),
('42', 'FG-009', 'RM-094', '2', 'PFLR2', '1'),
('43', 'FG-009', 'RM-117', '2', 'PFLR2', '1'),
('84', 'FG-010', 'CM-007', '1', 'PFLOR', '0.11'),
('80', 'FG-010', 'CM-013', '1', 'PFLOR', '0.0025'),
('78', 'FG-010', 'CM-016', '1', 'PFLOR', '0.0005'),
('79', 'FG-010', 'CM-025', '1', 'PFLOR', '0.0005'),
('82', 'FG-010', 'CM-026', '1', 'PFLOR', '0.0125'),
('83', 'FG-010', 'CM-028', '1', 'PFLOR', '0.005'),
('85', 'FG-010', 'CM-032', '1', 'PFLOR', '0.0001'),
('81', 'FG-010', 'CM-035', '1', 'PFLOR', '0.0015'),
('86', 'FG-010', 'RM-019', '2', 'PFLR2', '1'),
('87', 'FG-010', 'RM-059', '2', 'PFLR2', '1'),
('49', 'FG-013', 'RM-004', '2', 'PFLR2', '1'),
('51', 'FG-013', 'RM-036', '2', 'PFLR2', '0.0209'),
('52', 'FG-013', 'RM-037', '2', 'PFLR2', '0.0147'),
('50', 'FG-013', 'RM-085', '2', 'PFLR2', '1'),
('98', 'FG-013', 'SFG-102', '1', 'PFLR2', '0.3'),
('61', 'FG-021', 'RM-021', '2', 'PFLR2', '1'),
('64', 'FG-021', 'RM-045', '2', 'PFLR2', '0.0833'),
('63', 'FG-021', 'RM-088', '2', 'PFLR2', '1'),
('62', 'FG-021', 'RM-096', '2', 'PFLR2', '1'),
('99', 'FG-021', 'SFG-103', '2', 'PFLR2', '1'),
('67', 'FG-030', 'CM-009', '1', 'PFLOR', '0.0015'),
('66', 'FG-030', 'CM-016', '1', 'PFLOR', '8'),
('65', 'FG-030', 'CM-022', '1', 'PFLOR', '1.386'),
('68', 'FG-030', 'CM-025', '1', 'PFLOR', '0.003'),
('69', 'FG-030', 'RM-028', '2', 'PFLR2', '1'),
('71', 'FG-030', 'RM-044', '2', 'PFLR2', '0'),
('70', 'FG-030', 'RM-105', '2', 'PFLR2', '1'),
('123', 'FG-042', 'RM-024', '2', 'PFLR2', '1'),
('122', 'FG-042', 'RM-084', '2', 'PFLR2', '0.08'),
('121', 'FG-042', 'RM-108', '2', 'PFLR2', '1'),
('120', 'FG-042', 'SFG-108', '2', 'PFLR2', '1'),
('76', 'FG-043', 'RM-021', '2', 'PFLR2', '1'),
('77', 'FG-043', 'RM-083', '2', 'PFLR2', '0'),
('75', 'FG-043', 'RM-107', '2', 'PFLR2', '1'),
('119', 'FG-043', 'SFG-107', '2', 'PFLR2', '1'),
('147', 'FG-062', 'CM-001', '1', 'PFLOR', '0.1935'),
('146', 'FG-062', 'CM-012', '1', 'PFLOR', '0.0322'),
('148', 'FG-062', 'SFG-119', '1', 'PFLOR', '0.774'),
('94', 'SFG-101', 'CM-002', '1', 'PFLOR', '0.0069'),
('95', 'SFG-101', 'CM-003', '1', 'PFLOR', '0.0049'),
('92', 'SFG-101', 'CM-023', '1', 'PFLOR', '0.74'),
('93', 'SFG-101', 'CM-030', '1', 'PFLOR', '0.247'),
('96', 'SFG-101', 'CM-033', '1', 'PFLOR', '0.0001'),
('104', 'SFG-102', 'CM-007', '1', 'PFLOR', '0.0698'),
('105', 'SFG-102', 'CM-020', '1', 'PFLOR', '0.1794'),
('103', 'SFG-102', 'CM-021', '1', 'PFLOR', '0.7508'),
('101', 'SFG-103', 'CM-009', '1', 'PFLOR', '0.0015'),
('102', 'SFG-103', 'CM-016', '1', 'PFLOR', '0.0006'),
('127', 'SFG-103', 'CM-022', '1', 'PFLOR', '0.055'),
('100', 'SFG-103', 'CM-025', '1', 'PFLOR', '0.001'),
('205', 'SFG-103', 'CM-033', '1', 'PFLOR', '0.0005'),
('206', 'SFG-103', 'SFG-119', '1', 'PFLOR', '0.945'),
('108', 'SFG-104', 'CM-009', '1', 'PFLOR', '0.0015'),
('109', 'SFG-104', 'CM-016', '1', 'PFLOR', '0.0006'),
('110', 'SFG-104', 'CM-022', '1', 'PFLOR', '0.44'),
('107', 'SFG-104', 'CM-025', '1', 'PFLOR', '0.001'),
('130', 'SFG-104', 'CM-032', '1', 'PFLOR', '0.0002'),
('131', 'SFG-104', 'CM-034', '1', 'PFLOR', '0'),
('188', 'SFG-104', 'SFG-119', '1', 'PFLOR', '0.56'),
('224', 'SFG-105', 'CM-011', '1', 'PFLOR', '0.001'),
('225', 'SFG-105', 'CM-041', '1', 'PFLOR', '0.00283'),
('126', 'SFG-106', 'CM-008', '1', 'PFLOR', '0.01'),
('124', 'SFG-106', 'CM-019', '1', 'PFLOR', '0.89'),
('125', 'SFG-106', 'CM-024', '1', 'PFLOR', '0.08'),
('113', 'SFG-107', 'CM-003', '1', 'PFLOR', '0.01'),
('112', 'SFG-107', 'CM-004', '1', 'PFLOR', '0.025'),
('111', 'SFG-107', 'CM-017', '1', 'PFLOR', '0.92'),
('115', 'SFG-107', 'CM-023', '1', 'PFLOR', '0.1714'),
('118', 'SFG-108', 'CM-003', '1', 'PFLOR', '0.008'),
('117', 'SFG-108', 'CM-004', '1', 'PFLOR', '0.0266'),
('114', 'SFG-108', 'CM-023', '1', 'PFLOR', '0.506'),
('145', 'SFG-108', 'CM-043', '1', 'PFLOR', '0.46'),
('190', 'SFG-109', 'CM-009', '1', 'PFLOR', '0.0015'),
('191', 'SFG-109', 'CM-016', '1', 'PFLOR', '0.0006'),
('192', 'SFG-109', 'CM-022', '1', 'PFLOR', '0.44'),
('189', 'SFG-109', 'CM-025', '1', 'PFLOR', '0.001'),
('196', 'SFG-109', 'CM-033', '1', 'PFLOR', '0.0005'),
('197', 'SFG-109', 'SFG-119', '1', 'PFLOR', '0.56'),
('156', 'SFG-110', 'CM-013', '1', 'PFLOR', '0.005'),
('158', 'SFG-110', 'CM-020', '1', 'PFLOR', '0.001'),
('157', 'SFG-110', 'CM-025', '1', 'PFLOR', '0.002'),
('154', 'SFG-110', 'CM-027', '1', 'PFLOR', '0.275'),
('155', 'SFG-110', 'CM-042', '1', 'PFLOR', '0.00916'),
('159', 'SFG-110', 'CM-045', '1', 'PFLOR', '0.001'),
('160', 'SFG-110', 'CM-046', '1', 'PFLOR', '0.00005'),
('161', 'SFG-110', 'CM-047', '1', 'PFLOR', '0.003'),
('162', 'SFG-110', 'SFG-119', '1', 'PFLOR', '0.7537'),
('165', 'SFG-111', 'CM-013', '1', 'PFLOR', '0.005'),
('167', 'SFG-111', 'CM-020', '1', 'PFLOR', '0.001'),
('166', 'SFG-111', 'CM-025', '1', 'PFLOR', '0.002'),
('163', 'SFG-111', 'CM-027', '1', 'PFLOR', '0.225'),
('172', 'SFG-111', 'CM-032', '1', 'PFLOR', '0.00015'),
('173', 'SFG-111', 'CM-039', '1', 'PFLOR', '0.003'),
('164', 'SFG-111', 'CM-042', '1', 'PFLOR', '0.00916'),
('168', 'SFG-111', 'CM-045', '1', 'PFLOR', '0.001'),
('174', 'SFG-111', 'SFG-119', '1', 'PFLOR', '0.7537'),
('232', 'SFG-113', 'CM-016', '1', 'PFLOR', '0.0009'),
('150', 'SFG-113', 'CM-025', '1', 'PFLOR', '0.0188'),
('152', 'SFG-113', 'CM-039', '1', 'PFLOR', '0.0377'),
('149', 'SFG-113', 'CM-044', '1', 'PFLOR', '0.2827'),
('233', 'SFG-113', 'SFG-119', '1', 'PFLOR', '0.6597'),
('137', 'SFG-114', 'CM-001', '1', 'PFLOR', '0.001'),
('140', 'SFG-114', 'CM-006', '1', 'PFLOR', '0.00086'),
('139', 'SFG-114', 'CM-008', '1', 'PFLOR', '0.01'),
('136', 'SFG-114', 'CM-013', '1', 'PFLOR', '0.005'),
('230', 'SFG-114', 'CM-016', '1', 'PFLOR', '0.001'),
('138', 'SFG-114', 'CM-020', '1', 'PFLOR', '0.09'),
('135', 'SFG-114', 'CM-027', '1', 'PFLOR', '0.025'),
('142', 'SFG-114', 'CM-039', '1', 'PFLOR', '0.003'),
('141', 'SFG-114', 'CM-042', '1', 'PFLOR', '0.0085'),
('231', 'SFG-114', 'SFG-119', '1', 'PFLOR', '0.8804'),
('133', 'SFG-115', 'CM-007', '1', 'PFLOR', '0.05'),
('134', 'SFG-115', 'CM-020', '1', 'PFLOR', '0.25'),
('132', 'SFG-115', 'CM-021', '1', 'PFLOR', '0.7'),
('177', 'SFG-120', 'CM-004', '1', 'PFLOR', '0.00661'),
('179', 'SFG-120', 'CM-015', '1', 'PFLOR', '0.33047'),
('176', 'SFG-120', 'CM-023', '1', 'PFLOR', '0.7553'),
('175', 'SFG-120', 'CM-030', '1', 'PFLOR', '0.59484'),
('178', 'SFG-120', 'CM-036', '1', 'PFLOR', '0.00198'),
('182', 'SFG-121', 'CM-007', '1', 'PFLOR', '0.03333'),
('181', 'SFG-121', 'CM-021', '1', 'PFLOR', '0.43333'),
('180', 'SFG-121', 'CM-048', '1', 'PFLOR', '0.53333'),
('185', 'SFG-122', 'CM-008', '1', 'PFLOR', '0.001'),
('184', 'SFG-122', 'CM-010', '1', 'PFLOR', '0.01'),
('183', 'SFG-122', 'CM-049', '1', 'PFLOR', '0.989'),
('199', 'SFG-123', 'CM-009', '1', 'PFLOR', '0.0015'),
('200', 'SFG-123', 'CM-016', '1', 'PFLOR', '0.0006'),
('201', 'SFG-123', 'CM-022', '1', 'PFLOR', '0.055'),
('198', 'SFG-123', 'CM-025', '1', 'PFLOR', '0.001'),
('202', 'SFG-123', 'CM-032', '1', 'PFLOR', '0.00016'),
('203', 'SFG-123', 'CM-034', '1', 'PFLOR', '0.00004'),
('204', 'SFG-123', 'SFG-119', '1', 'PFLOR', '0.56'),
('209', 'SFG-124', 'CM-009', '1', 'PFLOR', '0.0015'),
('210', 'SFG-124', 'CM-016', '1', 'PFLOR', '0.0006'),
('207', 'SFG-124', 'CM-022', '1', 'PFLOR', '0.055'),
('208', 'SFG-124', 'CM-025', '1', 'PFLOR', '0.001'),
('211', 'SFG-124', 'CM-031', '1', 'PFLOR', '0.0001'),
('212', 'SFG-124', 'SFG-119', '1', 'PFLOR', '0.56'),
('215', 'SFG-125', 'CM-009', '1', 'PFLOR', '0.0015'),
('216', 'SFG-125', 'CM-016', '1', 'PFLOR', '0.0006'),
('213', 'SFG-125', 'CM-022', '1', 'PFLOR', '0.44'),
('214', 'SFG-125', 'CM-025', '1', 'PFLOR', '0.001'),
('217', 'SFG-125', 'CM-031', '1', 'PFLOR', '0.0001'),
('218', 'SFG-125', 'SFG-119', '1', 'PFLOR', '0.56'),
('219', 'SFG-126', 'CM-005', '1', 'PFLOR', '0.3'),
('220', 'SFG-126', 'CM-041', '1', 'PFLOR', '0.2'),
('223', 'SFG-126', 'CM-051', '1', 'PFLOR', '0.5'),
('221', 'SFG-127', 'CM-042', '1', 'PFLOR', '0.35829'),
('222', 'SFG-127', 'CM-051', '1', 'PFLOR', '0.64171'),
('228', 'SFG-128', 'CM-002', '1', 'PFLOR', '0.0069'),
('229', 'SFG-128', 'CM-003', '1', 'PFLOR', '0.0049'),
('226', 'SFG-128', 'CM-023', '1', 'PFLOR', '0.3943'),
('227', 'SFG-128', 'CM-030', '1', 'PFLOR', '0.64327');

### Structure of table `0_budget_trans` ###

DROP TABLE IF EXISTS `0_budget_trans`;

CREATE TABLE `0_budget_trans` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `account` varchar(15) NOT NULL DEFAULT '',
  `memo_` tinytext NOT NULL,
  `amount` double NOT NULL DEFAULT 0,
  `dimension_id` int(11) DEFAULT 0,
  `dimension2_id` int(11) DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `Account` (`account`,`tran_date`,`dimension_id`,`dimension2_id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_budget_trans` ###

INSERT INTO `0_budget_trans` VALUES
('1', '2022-01-01', '1060', '', '5000', '0', '0'),
('2', '2022-02-01', '1060', '', '5000', '0', '0'),
('3', '2022-03-01', '1060', '', '6000', '0', '0'),
('4', '2022-04-01', '1060', '', '6000', '0', '0'),
('5', '2022-05-01', '1060', '', '6000', '0', '0'),
('6', '2022-06-01', '1060', '', '0', '0', '0'),
('7', '2022-07-01', '1060', '', '0', '0', '0'),
('8', '2022-08-01', '1060', '', '0', '0', '0'),
('9', '2022-09-01', '1060', '', '0', '0', '0'),
('10', '2022-10-01', '1060', '', '0', '0', '0'),
('11', '2022-11-01', '1060', '', '0', '0', '0'),
('12', '2022-12-01', '1060', '', '0', '0', '0');

### Structure of table `0_chart_class` ###

DROP TABLE IF EXISTS `0_chart_class`;

CREATE TABLE `0_chart_class` (
  `cid` varchar(3) NOT NULL,
  `class_name` varchar(60) NOT NULL DEFAULT '',
  `ctype` tinyint(1) NOT NULL DEFAULT 0,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`cid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_chart_class` ###

INSERT INTO `0_chart_class` VALUES
('1', 'Assets', '1', '0'),
('2', 'Liabilities', '2', '0'),
('3', 'Income', '4', '0'),
('4', 'Expenses', '6', '0'),
('5', 'Capital', '3', '0');

### Structure of table `0_chart_master` ###

DROP TABLE IF EXISTS `0_chart_master`;

CREATE TABLE `0_chart_master` (
  `account_code` varchar(15) NOT NULL DEFAULT '',
  `account_code2` varchar(15) NOT NULL DEFAULT '',
  `account_name` varchar(60) NOT NULL DEFAULT '',
  `account_type` varchar(10) NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`account_code`),
  KEY `account_name` (`account_name`),
  KEY `accounts_by_type` (`account_type`,`account_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_chart_master` ###

INSERT INTO `0_chart_master` VALUES
('1010101001', '', 'Manual Stacker', '1010101', '0'),
('1010101002', '', 'Filling Machine Pump', '1010101', '0'),
('1010101003', '', 'Stacker Drum', '1010101', '0'),
('1010101004', '', 'Carb Clean Mixer - 1000 kg (Pneumatic)', '1010101', '0'),
('1010101005', '', 'Compressor', '1010101', '0'),
('1010101006', '', 'Tin Sealer', '1010101', '0'),
('1010101007', '', 'Dryer Machine', '1010101', '0'),
('1010101008', '', 'Sachet Packing Machine', '1010101', '0'),
('1010101009', '', 'Manual Sanction Pump', '1010101', '0'),
('1010101010', '', 'Coolant Filling Machine', '1010101', '0'),
('1010101011', '', 'Coolant Sealer Machine', '1010101', '0'),
('1010101012', '', 'Manual Hand Lifter', '1010101', '0'),
('1010101013', '', 'Induction Sealer - Manual', '1010101', '0'),
('1010101014', '', 'Sealing Machine', '1010101', '0'),
('1010101015', '', 'Batch Printing Machine', '1010101', '0'),
('1010101016', '', 'Aerosol Conveyer', '1010101', '0'),
('1010101017', '', 'Liquid Aerosol Filling Machine', '1010101', '0'),
('1010101018', '', 'Crymping/ Valve Punching Machine', '1010101', '0'),
('1010101019', '', 'LPG Gas Filling Machine - Single Headed', '1010101', '0'),
('1010101020', '', 'LPG Gas Filling Machine - Double Headed', '1010101', '0'),
('1010101021', '', 'Aerosol 3 in 1', '1010101', '0'),
('1010101022', '', 'Sanction Pump 3 in 1', '1010101', '0'),
('1010101023', '', 'Brake Oil Filling Machine', '1010101', '0'),
('1010101024', '', 'Induction Sealer - Auto', '1010101', '0'),
('1010101025', '', 'Air Compressor', '1010101', '0'),
('1010101026', '', 'Liquid Filling Maching - (Shampoo &amp; Cleaner)', '1010101', '0'),
('1010101027', '', 'DE Stench Plant', '1010101', '0'),
('1010101028', '', 'Liquid Filling Machine - ATF &amp; Power Steering', '1010101', '0'),
('1010101029', '', 'Attriator Big', '1010101', '0'),
('1010101030', '', 'Dryer Machine - Cupric Acetate', '1010101', '0'),
('1010101031', '', 'Di Ionized Plant', '1010101', '0'),
('1010101032', '', 'LPG Filling Machine - New Import', '1010101', '0'),
('1010101033', '', 'Crymping/ Punching Machine - New Import', '1010101', '0'),
('1010101034', '', 'Coolant Sanction Pump - Puneumatic', '1010101', '0'),
('1010101035', '', 'Di Ionized Plant', '1010101', '0'),
('1010101036', '', 'ATF/Power Steering Mixer', '1010101', '0'),
('1010101037', '', 'Gresae Mixer', '1010101', '0'),
('1010101038', '', 'Grease Filling ', '1010101', '0'),
('1010101039', '', 'Compressor', '1010101', '0'),
('1010101040', '', 'Transfer Pump - Cupric Acetate', '1010101', '0'),
('1010101041', '', 'Pneumatic Pump', '1010101', '0'),
('1010101042', '', 'Pouch Sealer Machine', '1010101', '0'),
('1010101043', '', 'Empty Vessel', '1010101', '0'),
('1010101044', '', 'Mixer - Coper Acetate', '1010101', '0'),
('1010101045', '', 'Lifter - Heli', '1010101', '0'),
('1010101046', '', 'Drum Handler', '1010101', '0'),
('1010102001', '', 'Chairs', '1010102', '0'),
('1010102002', '', 'Executive Chair', '1010102', '0'),
('1010102003', '', 'Office Table', '1010102', '0'),
('1010102004', '', 'Executive Table Set', '1010102', '0'),
('1010102005', '', 'Bench', '1010102', '0'),
('1010102006', '', 'Stool', '1010102', '0'),
('1010102007', '', 'Side Table', '1010102', '0'),
('1010102008', '', 'Office Chairs ', '1010102', '0'),
('1010102009', '', 'Office Table ', '1010102', '0'),
('1010103001', '', 'Suzuki Ravi - KS 9427', '1010103', '0'),
('1010103002', '', 'Suzuki Bolan - CY 6783', '1010103', '0'),
('1010103003', '', 'Master Truck - KQ 0837', '1010103', '0'),
('1010103004', '', 'Tyota Corola - BGL 517', '1010103', '0'),
('1010103005', '', 'MotorCycle', '1010103', '0'),
('1010103006', '', 'Loader Rikshaw Solar', '1010103', '0'),
('1010104001', '', 'Rack', '1010104', '0'),
('1010104002', '', 'Pallets', '1010104', '0'),
('1010104003', '', 'Cabinets, Doors  &amp; Fixture', '1010104', '0'),
('1010104004', '', 'Fixture Cubinet', '1010104', '0'),
('1010104005', '', 'Cupbord', '1010104', '0'),
('1010104006', '', 'Light Panel Stand', '1010104', '0'),
('1010105001', '', 'Water Dispenser', '1010105', '0'),
('1010105002', '', 'Digital Scale', '1010105', '0'),
('1010105003', '', 'Air Conditioner', '1010105', '0'),
('1010105004', '', 'IT Box', '1010105', '0'),
('1010105005', '', 'Camera', '1010105', '0'),
('1010105006', '', 'Ceiling Fan', '1010105', '0'),
('1010105007', '', 'Exaust Fan', '1010105', '0'),
('1010105008', '', 'Bracket Fan', '1010105', '0'),
('1010105009', '', 'Stablizer', '1010105', '0'),
('1010105010', '', 'Refrigerator', '1010105', '0'),
('1010105011', '', 'Electric Weging Scale', '1010105', '0'),
('1010105012', '', 'Motor - Small', '1010105', '0'),
('1010105013', '', 'Motor - Big', '1010105', '0'),
('1010105014', '', 'Padesatl Fan', '1010105', '0'),
('1010105015', '', 'Donkey Pump', '1010105', '0'),
('1010105016', '', 'Weighing Scale', '1010105', '0'),
('1010105017', '', 'Water Motor', '1010105', '0'),
('1010105018', '', 'Electric Water Cooler', '1010105', '0'),
('1010105019', '', 'Deep Freezer', '1010105', '0'),
('1010105020', '', 'Exahust Fan - Industrial', '1010105', '0'),
('1010105021', '', 'Water Sanction Motor', '1010105', '0'),
('1010105022', '', 'Weighing Scale', '1010105', '0'),
('1010105023', '', 'Room Coolar', '1010105', '0'),
('1010105024', '', 'UPS Batteries', '1010105', '0'),
('1010105025', '', 'Battery Charger', '1010105', '0'),
('1010105026', '', 'Solar Panel 900 Watt (Set)', '1010105', '0'),
('1010105027', '', 'Generator ', '1010105', '0'),
('1010106001', '', 'Locker', '1010106', '0'),
('1010106002', '', 'Fire Extinguisher', '1010106', '0'),
('1010106003', '', 'Lockers', '1010106', '0'),
('1010106004', '', 'Telephone Set', '1010106', '0'),
('1010106005', '', 'Racks', '1010106', '0'),
('1010106006', '', 'Display Racks', '1010106', '0'),
('1010106007', '', 'Attendence Machine', '1010106', '0'),
('1010107001', '', 'Viscosity Bath', '1010107', '0'),
('1010107002', '', 'Oven', '1010107', '0'),
('1010107003', '', 'Hot Plate', '1010107', '0'),
('1010107004', '', 'Mixer', '1010107', '0'),
('1010107005', '', 'Plannetry Mixer', '1010107', '0'),
('1010107006', '', 'Oil Paint Mixer', '1010107', '0'),
('1010107007', '', 'Attriator Small', '1010107', '0'),
('1010107008', '', 'Mixer', '1010107', '0'),
('1010107009', '', 'Viscosity Cup', '1010107', '0'),
('1010108001', '', 'Computer', '1010108', '0'),
('1010108002', '', 'Printer', '1010108', '0'),
('1010108003', '', 'Scanner', '1010108', '0'),
('1010108004', '', 'Lap Top', '1010108', '0'),
('1010109001', '', 'Ladder', '1010109', '0'),
('1010109002', '', 'Strip Cutter', '1010109', '0'),
('1010109003', '', 'Drum Stand (Roller)', '1010109', '0'),
('1010109004', '', 'Tool Box', '1010109', '0'),
('1010109005', '', 'Trunk - Iron', '1010109', '0'),
('1010109006', '', 'Tarplene', '1010109', '0'),
('1010109007', '', 'Trolley', '1010109', '0'),
('1010109008', '', 'Lap Top', '1010109', '0'),
('1010109009', '', 'Metal Stands', '1010109', '0'),
('1010109010', '', 'Big Ladder Stool', '1010109', '0'),
('1010109011', '', 'Ladder - Wood', '1010109', '0'),
('1010109012', '', 'Ladder - Aluminium', '1010109', '0'),
('1010109013', '', 'LPG Cyiders - Suzuki Ravi', '1010109', '0'),
('1010110001', '', 'Water Storage Tank 1000 L', '1010110', '0'),
('1010110002', '', 'Water Storage Tank 2500 L', '1010110', '0'),
('1010110003', '', 'Storage Tank 4500 ltr - Production', '1010110', '0'),
('1010110004', '', 'Storage Tank 1600 ltr - Production', '1010110', '0'),
('1010110005', '', 'Storage Tank 800 ltr - Production', '1010110', '0'),
('1010110006', '', 'LPG Stotage Tank', '1010110', '0'),
('1010110007', '', 'Steel Vessel 233 L', '1010110', '0'),
('1010110008', '', 'Steel Vessel 275 L', '1010110', '0'),
('1010110009', '', 'Steel Vessel 68 L', '1010110', '0'),
('1010110010', '', 'Steel Vessel 173 L', '1010110', '0'),
('1010110011', '', 'Steel Vessel 78 L', '1010110', '0'),
('1010110012', '', 'Steel Vessel 98 L', '1010110', '0'),
('1010110013', '', 'Steel Vessel 10.4 L', '1010110', '0'),
('1010110014', '', 'Blending Vessel - 150 Ltr', '1010110', '0'),
('1010110015', '', 'Blending Vessel - 100 Ltr', '1010110', '0'),
('1010110016', '', 'Blending Vessel - 1000 Ltr', '1010110', '0'),
('1010201001', '', 'Trade Mark - Air Max', '1010201', '0'),
('1010201002', '', 'Trade Mark - Allgo', '1010201', '0'),
('1010201003', '', 'Trade Mark - Beauty &amp; Co', '1010201', '0'),
('1010201004', '', 'Trade Mark - Body &amp; Co', '1010201', '0'),
('1010201005', '', 'Trade Mark - Boyle Industries', '1010201', '0'),
('1010201006', '', 'Trade Mark - Carb X', '1010201', '0'),
('1010201007', '', 'Trade Mark - Carbo Nil', '1010201', '0'),
('1010201008', '', 'Trade Mark - Chemsol', '1010201', '0'),
('1010201009', '', 'Trade Mark - Daddy Cool', '1010201', '0'),
('1010201010', '', 'Trade Mark - Dolive', '1010201', '0'),
('1010201011', '', 'Trade Mark - Extech Industries Pak.', '1010201', '0'),
('1010201012', '', 'Trade Mark - Extol Pakistan', '1010201', '0'),
('1010201013', '', 'Trade Mark - Fondle', '1010201', '0'),
('1010201014', '', 'Trade Mark - Formula Car Polish', '1010201', '0'),
('1010201015', '', 'Trade Mark - Formula Car Scratch Remover', '1010201', '0'),
('1010201016', '', 'Trade Mark - Formula Car Wax', '1010201', '0'),
('1010201017', '', 'Trade Mark - Medsol', '1010201', '0'),
('1010201018', '', 'Trade Mark - Nasa Chemicals Pvt Ltd', '1010201', '0'),
('1010201019', '', 'Trade Mark - Nasa Super Wash', '1010201', '0'),
('1010201020', '', 'Trade Mark - Neeto', '1010201', '0'),
('1010201021', '', 'Trade Mark - Novel', '1010201', '0'),
('1010201022', '', 'Trade Mark - Opera', '1010201', '0'),
('1010201023', '', 'Trade Mark - Power Wash', '1010201', '0'),
('1010201024', '', 'Trade Mark - Prestine', '1010201', '0'),
('1010201025', '', 'Trade Mark - Prime Speciality Chemicals', '1010201', '0'),
('1010201026', '', 'Trade Mark - Primex', '1010201', '0'),
('1010201027', '', 'Trade Mark - Safeen', '1010201', '0'),
('1010201028', '', 'Trade Mark - Serene', '1010201', '0'),
('1010201029', '', 'Trade Mark - Skin Essential', '1010201', '0'),
('1010201030', '', 'Trade Mark - Swans', '1010201', '0'),
('1010201031', '', 'Trade Mark - Trucleen', '1010201', '0'),
('1010201032', '', 'Trade Mark - Tune Up', '1010201', '0'),
('1010201033', '', 'Trade Mark - Weldon', '1010201', '0'),
('1010201034', '', 'Trade Mark - WelmanS', '1010201', '0'),
('1020101001', '', 'Cash in Hand-HO', '1020101', '0'),
('1020102001', '', 'Petty Cash - HO', '1020102', '0'),
('1020102002', '', 'Petty Cash - WH', '1020102', '0'),
('1020102003', '', 'Petty Cash - Lhr', '1020102', '0'),
('1020102004', '', 'Petty Cash - Hyd', '1020102', '0'),
('1020102005', '', 'Petty Cash - Hub Factory', '1020102', '0'),
('1020103001', '', 'HBL-Nasa-00477900856003', '1020103', '0'),
('1020103002', '', 'AL Baraka Bank-Nasa-001002-77361-019', '1020103', '0'),
('1020201001', '', 'Nasa - Inter Company Loans', '1020201', '0'),
('1020201002', '', 'Prime - Inter Company Loans', '1020201', '0'),
('1020401001', '', 'Chq In Hand - Security Deposits (Distb)', '1020401', '0'),
('1020402001', '', 'Riazeda Pvt Ltd (Security Deposit)', '1020402', '0'),
('1020402002', '', 'Asharaf Shipping Agency Pvt Ltd', '1020402', '0'),
('1020403001', '', 'Security Deposit - LIEDA', '1020403', '0'),
('1020403002', '', 'Security Deposit - Internet TransWord', '1020403', '0'),
('1020403003', '', 'Security Deposit - Parco Pearl Gas Co', '1020403', '0'),
('1020403004', '', 'Security Deposit - PSO', '1020403', '0'),
('1020403005', '', 'Security Deposit - Rent', '1020403', '0'),
('1020403006', '', 'Security Deposit - SSGC', '1020403', '0'),
('1020403007', '', 'Security Deposit-State Life Ins Rent', '1020403', '0'),
('1020403008', '', 'Security Deposit - Storm Fiber', '1020403', '0'),
('1020501001', '', 'Advance To Mughees - Expesne', '1020501', '0'),
('1020501002', '', 'Advance to Ammar - Expense', '1020501', '0'),
('1020501003', '', 'Advance to Abrar - Expense', '1020501', '0'),
('1020501004', '', 'Advance to Asad (Hub) - Expense', '1020501', '0'),
('1020501005', '', 'Advance to Saad - Expense', '1020501', '0'),
('1020502001', '', 'Adv - Azhar Rider (HO)', '1020502', '0'),
('1020502002', '', 'Adv To Rehan Ali (HO)', '1020502', '0'),
('1020502003', '', 'Adv - Qasier Mehmood (Warehouse)', '1020502', '0'),
('1020502004', '', 'Adv - Nazir Driver (Warehouse)', '1020502', '0'),
('1020502005', '', 'Adv - Ammar (Lhr)', '1020502', '0'),
('1020502006', '', 'Adv - Haji Arif (Lhr)', '1020502', '0'),
('1020502007', '', 'Adv - Shahid (Hyd)', '1020502', '0'),
('1020502008', '', 'Adv - Irfan Ali (Hyd)', '1020502', '0'),
('1020502009', '', 'Adv - Arif Aziz (Hub)', '1020502', '0'),
('1020502010', '', 'Adv - Adil (Hub)', '1020502', '0'),
('1020601001', '', 'WHT -Kia Motors Kings Gate - Multan Road Lhr', '1020601', '0'),
('1020601002', '', 'WHT -Toyota Town Ship Motors Peco Road-Lahore', '1020601', '0'),
('1020601003', '', 'WHT -Toyota Ravi Motors Thokar Niaz Baig-LHR', '1020601', '0'),
('1020601004', '', 'WHT -Honda Canal Bank Motor Johar Town-Lahore', '1020601', '0'),
('1020601005', '', 'WHT -Honda Point Pvt Ltd Airport Road-Lahore', '1020601', '0'),
('1020601006', '', 'WHT -Honda Town Ship Peco Road Lahore', '1020601', '0'),
('1020601007', '', 'WHT -Isuzu Ravi Motors Tokhar Niaz Baig Lhr', '1020601', '0'),
('1060', '', 'Checking Account', '102', '0'),
('1065', '', 'Petty Cash', '102', '0'),
('1200', '', 'Accounts Receivables', '102', '0'),
('1205', '', 'Allowance for doubtful accounts', '102', '0'),
('14', '001', 'Telephone Expense 123456', '14', '0'),
('1510', '', 'Inventory', '2', '0'),
('1520', '', 'Stocks of Raw Materials', '2', '0'),
('1530', '', 'Stocks of Work In Progress', '2', '0'),
('1540', '', 'Stocks of Finished Goods', '2', '0'),
('1550', '', 'Goods Received Clearing account', '2', '0'),
('1560', '', 'Quarantine Inventory', '2', '0'),
('1820', '', 'Office Furniture &amp; Equipment', '3', '0'),
('1825', '', 'Accum. Amort. -Furn. &amp; Equip.', '3', '0'),
('1840', '', 'Vehicle', '3', '0'),
('1845', '', 'Accum. Amort. -Vehicle', '3', '0'),
('2010101001', '', 'Protech', '2010101', '0'),
('2010101002', '', 'Pak Pet (Pvt) Ltd', '2010101', '0'),
('2010101003', '', 'Mijukom ', '2010101', '0'),
('2010101004', '', 'Techno Pack', '2010101', '0'),
('2010101005', '', 'I.C.I Pakistan', '2010101', '0'),
('2010101006', '', 'Pro Care Industries (Pvt) Ltd', '2010101', '0'),
('2010101007', '', 'Pakistan State Oil Ltd', '2010101', '0'),
('2010102001', '', 'State Life Building ', '2010102', '0'),
('2010102002', '', 'Abaseen Securities Pvt Ltd', '2010102', '0'),
('2010102003', '', 'Bank Islami - Leasing Bolan CY 6783', '2010102', '0'),
('2100', '', 'Accounts Payable', '201', '0'),
('2105', '', 'Deferred Income', '201', '0'),
('2110', '', 'Accrued Income Tax - Federal', '201', '0'),
('2120', '', 'Accrued Income Tax - State', '201', '0'),
('2130', '', 'Accrued Franchise Tax', '201', '0'),
('2140', '', 'Accrued Real &amp; Personal Prop Tax', '201', '0'),
('2150', '', 'Sales Tax', '201', '0'),
('2160', '', 'Accrued Use Tax Payable', '201', '0'),
('2210', '', 'Accrued Wages', '201', '0'),
('2220', '', 'Accrued Comp Time', '201', '0'),
('2230', '', 'Accrued Holiday Pay', '201', '0'),
('2240', '', 'Accrued Vacation Pay', '201', '0'),
('2310', '', 'Accr. Benefits - 401K', '201', '0'),
('2320', '', 'Accr. Benefits - Stock Purchase', '201', '0'),
('2330', '', 'Accr. Benefits - Med, Den', '201', '0'),
('2340', '', 'Accr. Benefits - Payroll Taxes', '201', '0'),
('2350', '', 'Accr. Benefits - Credit Union', '201', '0'),
('2360', '', 'Accr. Benefits - Savings Bond', '201', '0'),
('2370', '', 'Accr. Benefits - Garnish', '201', '0'),
('2380', '', 'Accr. Benefits - Charity Cont.', '201', '0'),
('2620', '', 'Bank Loans', '5', '0'),
('2680', '', 'Loans from Shareholders', '5', '0'),
('302001', '', 'Other Income - Scrap Sales', '302', '0'),
('302002', '', 'Other Income - Old Drums', '9', '0'),
('3350', '', 'Common Shares', '6', '0'),
('3590', '', 'Retained Earnings - prior years', '7', '0'),
('4010', '', 'Sales', '8', '0'),
('4430', '', 'Shipping &amp; Handling', '9', '0'),
('4440', '', 'Interest', '9', '0'),
('4450', '', 'Foreign Exchange Gain', '9', '0'),
('4500', '', 'Prompt Payment Discounts', '9', '0'),
('4510', '', 'Discounts Given', '9', '0'),
('5010', '', 'Cost of Goods Sold - Retail', '401', '0'),
('5020', '', 'Material Usage Varaiance', '401', '0'),
('502001', '', 'Current Capital - Humayyon Muhammad', '502', '0'),
('502002', '', 'Current Capital - Mrs Nighat Perveen', '502', '0'),
('5030', '', 'Consumable Materials', '401', '0'),
('5040', '', 'Purchase price Variance', '401', '0'),
('5050', '', 'Purchases of materials', '401', '0'),
('5060', '', 'Discounts Received', '401', '0'),
('5100', '', 'Freight', '401', '0'),
('5410', '', 'Wages &amp; Salaries', '402', '0'),
('5420', '', 'Wages - Overtime', '402', '0'),
('5430', '', 'Benefits - Comp Time', '402', '0'),
('5440', '', 'Benefits - Payroll Taxes', '402', '0'),
('5450', '', 'Benefits - Workers Comp', '402', '0'),
('5460', '', 'Benefits - Pension', '402', '0'),
('5470', '', 'Benefits - General Benefits', '402', '0'),
('5510', '', 'Inc Tax Exp - Federal', '402', '0'),
('5520', '', 'Inc Tax Exp - State', '402', '0'),
('5530', '', 'Taxes - Real Estate', '402', '0'),
('5540', '', 'Taxes - Personal Property', '402', '0'),
('5550', '', 'Taxes - Franchise', '402', '0'),
('5560', '', 'Taxes - Foreign Withholding', '402', '0'),
('5610', '', 'Accounting &amp; Legal', '403', '0'),
('5615', '', 'Advertising &amp; Promotions', '403', '0'),
('5620', '', 'Bad Debts', '403', '0'),
('5660', '', 'Amortization Expense', '403', '0'),
('5685', '', 'Insurance', '403', '0'),
('5690', '', 'Interest &amp; Bank Charges', '403', '0'),
('5700', '', 'Office Supplies', '403', '0'),
('5760', '', 'Rent', '403', '0'),
('5765', '', 'Repair &amp; Maintenance', '403', '0'),
('5780', '', 'Telephone', '403', '0'),
('5785', '', 'Travel &amp; Entertainment', '403', '0'),
('5790', '', 'Utilities', '403', '0'),
('5795', '', 'Registrations', '403', '0'),
('5800', '', 'Licenses', '403', '0'),
('5810', '', 'Foreign Exchange Loss', '403', '0'),
('9990', '', 'Year Profit/Loss', '403', '0');

### Structure of table `0_chart_types` ###

DROP TABLE IF EXISTS `0_chart_types`;

CREATE TABLE `0_chart_types` (
  `id` varchar(10) NOT NULL,
  `name` varchar(60) NOT NULL DEFAULT '',
  `class_id` varchar(3) NOT NULL DEFAULT '',
  `parent` varchar(10) NOT NULL DEFAULT '-1',
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `name` (`name`),
  KEY `class_id` (`class_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_chart_types` ###

INSERT INTO `0_chart_types` VALUES
('101', 'Fixed Assets', '1', '', '0'),
('10101', 'Tengible Assets', '1', '101', '0'),
('1010101', 'Plant &amp; Machinery', '1', '10101', '0'),
('1010102', 'Furniture', '1', '10101', '0'),
('1010103', 'Vehicles', '1', '10101', '0'),
('1010104', 'Fixture &amp; Fittings', '1', '10101', '0'),
('1010105', 'Electrical Equipments', '1', '10101', '0'),
('1010106', 'Office Equipments', '1', '10101', '0'),
('1010107', 'Lab Equipments', '1', '10101', '0'),
('1010108', 'Computers &amp; IT Equipments', '1', '10101', '0'),
('1010109', 'Spares &amp; Tools', '1', '10101', '0'),
('10102', 'Intengeble Assets', '1', '101', '0'),
('1010201', 'Trade Mark', '1', '10102', '0'),
('102', 'Current Assets', '1', '', '0'),
('10201', 'Cash &amp; Bank', '1', '102', '0'),
('1020101', 'Cash in Hand', '1', '10201', '0'),
('1020102', 'Petty Cash', '1', '10201', '0'),
('1020103', 'Banks', '1', '10201', '0'),
('10202', 'Short Term Loans', '1', '102', '0'),
('1020201', 'Loans - Inter Company ', '1', '10202', '0'),
('1020202', 'Loans - Staff ', '1', '10202', '0'),
('10203', 'Acoounts Recieveables', '1', '102', '0'),
('1020301', 'Accounts Recieveables-KHI', '1', '10203', '0'),
('1020302', 'Accounts Recieveables-LHR', '1', '10203', '0'),
('1020303', 'Accounts Recieveables-HYD', '1', '10203', '0'),
('10204', 'Securities &amp; Deposits', '1', '102', '0'),
('1020401', 'Securities Distributors ', '1', '10204', '0'),
('1020402', 'Shipping Line Deposits', '1', '10204', '0'),
('1020403', 'Others Security Deposits', '1', '10204', '0'),
('10205', 'Advances - Staff', '1', '102', '0'),
('1020501', 'Advances For Expenses', '1', '10205', '0'),
('1020502', 'Advances - Head Office', '1', '10205', '0'),
('1020503', 'Advances - Warehouse', '1', '10205', '0'),
('1020504', 'Advances - Lahore Branch', '1', '10205', '0'),
('1020505', 'Advances - Hyderabad Branch', '1', '10205', '0'),
('1020506', 'Advances - Hub Factory', '1', '10205', '0'),
('10206', 'Advance Taxes', '1', '102', '0'),
('1020601', 'WHT - Supplies', '1', '10206', '0'),
('10207', 'Stock In Hand', '1', '102', '0'),
('1020701', 'Finsished Goods', '1', '10207', '0'),
('1020702', 'Raw Material', '1', '10207', '0'),
('1020703', 'Work In Process', '1', '10207', '0'),
('14', 'Telephone Expense', '1', '403', '0'),
('2', 'Inventory Assets', '1', '', '0'),
('201', 'Current Liabilities', '2', '', '0'),
('20101', 'Accounts Payables', '2', '201', '0'),
('2010101', 'Vendors Payables', '2', '20101', '0'),
('2010102', 'Others Payables', '2', '20101', '0'),
('3', 'Capital Assets', '1', '', '0'),
('301', 'Sales', '3', '', '0'),
('302', 'Other Income', '3', '', '0'),
('401', 'Cost of Goods Sold', '4', '', '0'),
('402', 'Factory Overheads', '4', '', '0'),
('403', 'Operating Expenses', '4', '', '0'),
('5', 'Long Term Liabilities', '2', '', '0'),
('501', 'Paid Up Capital ', '5', '', '0'),
('502', 'Capital Current Account', '5', '', '0'),
('503', 'Retained Earning', '5', '', '0'),
('504', 'Drawing', '5', '', '0'),
('6', 'Share Capital', '2', '', '0'),
('7', 'Retained Earnings', '2', '', '0'),
('8', 'Sales Revenue', '3', '', '0'),
('9', 'Other Revenue', '3', '', '0');

### Structure of table `0_comments` ###

DROP TABLE IF EXISTS `0_comments`;

CREATE TABLE `0_comments` (
  `type` int(11) NOT NULL DEFAULT 0,
  `id` int(11) NOT NULL DEFAULT 0,
  `date_` date DEFAULT '0000-00-00',
  `memo_` tinytext DEFAULT NULL,
  KEY `type_and_id` (`type`,`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_comments` ###

INSERT INTO `0_comments` VALUES
('17', '1', '2023-01-16', 'Opening Balance');

### Structure of table `0_credit_status` ###

DROP TABLE IF EXISTS `0_credit_status`;

CREATE TABLE `0_credit_status` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reason_description` char(100) NOT NULL DEFAULT '',
  `dissallow_invoices` tinyint(1) NOT NULL DEFAULT 0,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `reason_description` (`reason_description`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_credit_status` ###

INSERT INTO `0_credit_status` VALUES
('1', 'Good History', '0', '0'),
('3', 'No more work until payment received', '1', '0'),
('4', 'In liquidation', '1', '0');

### Structure of table `0_crm_categories` ###

DROP TABLE IF EXISTS `0_crm_categories`;

CREATE TABLE `0_crm_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'pure technical key',
  `type` varchar(20) NOT NULL COMMENT 'contact type e.g. customer',
  `action` varchar(20) NOT NULL COMMENT 'detailed usage e.g. department',
  `name` varchar(30) NOT NULL COMMENT 'for category selector',
  `description` tinytext NOT NULL COMMENT 'usage description',
  `system` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'nonzero for core system usage',
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `type` (`type`,`action`),
  UNIQUE KEY `type_2` (`type`,`name`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_crm_categories` ###

INSERT INTO `0_crm_categories` VALUES
('1', 'cust_branch', 'general', 'General', 'General contact data for customer branch (overrides company setting)', '1', '0'),
('2', 'cust_branch', 'invoice', 'Invoices', 'Invoice posting (overrides company setting)', '1', '0'),
('3', 'cust_branch', 'order', 'Orders', 'Order confirmation (overrides company setting)', '1', '0'),
('4', 'cust_branch', 'delivery', 'Deliveries', 'Delivery coordination (overrides company setting)', '1', '0'),
('5', 'customer', 'general', 'General', 'General contact data for customer', '1', '0'),
('6', 'customer', 'order', 'Orders', 'Order confirmation', '1', '0'),
('7', 'customer', 'delivery', 'Deliveries', 'Delivery coordination', '1', '0'),
('8', 'customer', 'invoice', 'Invoices', 'Invoice posting', '1', '0'),
('9', 'supplier', 'general', 'General', 'General contact data for supplier', '1', '0'),
('10', 'supplier', 'order', 'Orders', 'Order confirmation', '1', '0'),
('11', 'supplier', 'delivery', 'Deliveries', 'Delivery coordination', '1', '0'),
('12', 'supplier', 'invoice', 'Invoices', 'Invoice posting', '1', '0');

### Structure of table `0_crm_contacts` ###

DROP TABLE IF EXISTS `0_crm_contacts`;

CREATE TABLE `0_crm_contacts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `person_id` int(11) NOT NULL DEFAULT 0 COMMENT 'foreign key to crm_persons',
  `type` varchar(20) NOT NULL COMMENT 'foreign key to crm_categories',
  `action` varchar(20) NOT NULL COMMENT 'foreign key to crm_categories',
  `entity_id` varchar(11) DEFAULT NULL COMMENT 'entity id in related class table',
  PRIMARY KEY (`id`),
  KEY `type` (`type`,`action`)
) ENGINE=InnoDB AUTO_INCREMENT=2202 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_crm_contacts` ###

INSERT INTO `0_crm_contacts` VALUES
('1', '1', 'cust_branch', 'general', '1'),
('2', '1', 'customer', 'general', '1'),
('3', '2', 'cust_branch', 'general', '2'),
('4', '2', 'customer', 'general', '2'),
('5', '3', 'cust_branch', 'general', '3'),
('6', '3', 'customer', 'general', '3'),
('7', '4', 'cust_branch', 'general', '4'),
('8', '4', 'customer', 'general', '4'),
('9', '5', 'cust_branch', 'general', '5'),
('10', '5', 'customer', 'general', '5'),
('11', '6', 'cust_branch', 'general', '6'),
('12', '6', 'customer', 'general', '6'),
('13', '7', 'cust_branch', 'general', '7'),
('14', '7', 'customer', 'general', '7'),
('15', '8', 'cust_branch', 'general', '8'),
('16', '8', 'customer', 'general', '8'),
('17', '9', 'cust_branch', 'general', '9'),
('18', '9', 'customer', 'general', '9'),
('19', '10', 'cust_branch', 'general', '10'),
('20', '10', 'customer', 'general', '10'),
('21', '11', 'cust_branch', 'general', '11'),
('22', '11', 'customer', 'general', '11'),
('23', '12', 'cust_branch', 'general', '12'),
('24', '12', 'customer', 'general', '12'),
('25', '13', 'cust_branch', 'general', '13'),
('26', '13', 'customer', 'general', '13'),
('27', '14', 'cust_branch', 'general', '14'),
('28', '14', 'customer', 'general', '14'),
('29', '15', 'cust_branch', 'general', '15'),
('30', '15', 'customer', 'general', '15'),
('31', '16', 'cust_branch', 'general', '16'),
('32', '16', 'customer', 'general', '16'),
('33', '17', 'cust_branch', 'general', '17'),
('34', '17', 'customer', 'general', '17'),
('35', '18', 'cust_branch', 'general', '18'),
('36', '18', 'customer', 'general', '18'),
('37', '19', 'cust_branch', 'general', '19'),
('38', '19', 'customer', 'general', '19'),
('39', '20', 'cust_branch', 'general', '20'),
('40', '20', 'customer', 'general', '20'),
('41', '21', 'cust_branch', 'general', '21'),
('42', '21', 'customer', 'general', '21'),
('43', '22', 'cust_branch', 'general', '22'),
('44', '22', 'customer', 'general', '22'),
('45', '23', 'cust_branch', 'general', '23'),
('46', '23', 'customer', 'general', '23'),
('47', '24', 'cust_branch', 'general', '24'),
('48', '24', 'customer', 'general', '24'),
('49', '25', 'cust_branch', 'general', '25'),
('50', '25', 'customer', 'general', '25'),
('51', '26', 'cust_branch', 'general', '26'),
('52', '26', 'customer', 'general', '26'),
('53', '27', 'cust_branch', 'general', '27'),
('54', '27', 'customer', 'general', '27'),
('55', '28', 'cust_branch', 'general', '28'),
('56', '28', 'customer', 'general', '28'),
('57', '29', 'cust_branch', 'general', '29'),
('58', '29', 'customer', 'general', '29'),
('59', '30', 'cust_branch', 'general', '30'),
('60', '30', 'customer', 'general', '30'),
('61', '31', 'cust_branch', 'general', '31'),
('62', '31', 'customer', 'general', '31'),
('63', '32', 'cust_branch', 'general', '32'),
('64', '32', 'customer', 'general', '32'),
('65', '33', 'cust_branch', 'general', '33'),
('66', '33', 'customer', 'general', '33'),
('67', '34', 'cust_branch', 'general', '34'),
('68', '34', 'customer', 'general', '34'),
('69', '35', 'cust_branch', 'general', '35'),
('70', '35', 'customer', 'general', '35'),
('71', '36', 'cust_branch', 'general', '36'),
('72', '36', 'customer', 'general', '36'),
('73', '37', 'cust_branch', 'general', '37'),
('74', '37', 'customer', 'general', '37'),
('75', '38', 'cust_branch', 'general', '38'),
('76', '38', 'customer', 'general', '38'),
('77', '39', 'cust_branch', 'general', '39'),
('78', '39', 'customer', 'general', '39'),
('79', '40', 'cust_branch', 'general', '40'),
('80', '40', 'customer', 'general', '40'),
('81', '41', 'cust_branch', 'general', '41'),
('82', '41', 'customer', 'general', '41'),
('83', '42', 'cust_branch', 'general', '42'),
('84', '42', 'customer', 'general', '42'),
('85', '43', 'cust_branch', 'general', '43'),
('86', '43', 'customer', 'general', '43'),
('87', '44', 'cust_branch', 'general', '44'),
('88', '44', 'customer', 'general', '44'),
('89', '45', 'cust_branch', 'general', '45'),
('90', '45', 'customer', 'general', '45'),
('91', '46', 'cust_branch', 'general', '46'),
('92', '46', 'customer', 'general', '46'),
('93', '47', 'cust_branch', 'general', '47'),
('94', '47', 'customer', 'general', '47'),
('95', '48', 'cust_branch', 'general', '48'),
('96', '48', 'customer', 'general', '48'),
('97', '49', 'cust_branch', 'general', '49'),
('98', '49', 'customer', 'general', '49'),
('99', '50', 'cust_branch', 'general', '50'),
('100', '50', 'customer', 'general', '50'),
('101', '51', 'cust_branch', 'general', '51'),
('102', '51', 'customer', 'general', '51'),
('103', '52', 'cust_branch', 'general', '52'),
('104', '52', 'customer', 'general', '52'),
('105', '53', 'cust_branch', 'general', '53'),
('106', '53', 'customer', 'general', '53'),
('107', '54', 'cust_branch', 'general', '54'),
('108', '54', 'customer', 'general', '54'),
('109', '55', 'cust_branch', 'general', '55'),
('110', '55', 'customer', 'general', '55'),
('111', '56', 'cust_branch', 'general', '56'),
('112', '56', 'customer', 'general', '56'),
('113', '57', 'cust_branch', 'general', '57'),
('114', '57', 'customer', 'general', '57'),
('115', '58', 'cust_branch', 'general', '58'),
('116', '58', 'customer', 'general', '58'),
('117', '59', 'cust_branch', 'general', '59'),
('118', '59', 'customer', 'general', '59'),
('119', '60', 'cust_branch', 'general', '60'),
('120', '60', 'customer', 'general', '60'),
('121', '61', 'cust_branch', 'general', '61'),
('122', '61', 'customer', 'general', '61'),
('123', '62', 'cust_branch', 'general', '62'),
('124', '62', 'customer', 'general', '62'),
('125', '63', 'cust_branch', 'general', '63'),
('126', '63', 'customer', 'general', '63'),
('127', '64', 'cust_branch', 'general', '64'),
('128', '64', 'customer', 'general', '64'),
('129', '65', 'cust_branch', 'general', '65'),
('130', '65', 'customer', 'general', '65'),
('131', '66', 'cust_branch', 'general', '66'),
('132', '66', 'customer', 'general', '66'),
('133', '67', 'cust_branch', 'general', '67'),
('134', '67', 'customer', 'general', '67'),
('135', '68', 'cust_branch', 'general', '68'),
('136', '68', 'customer', 'general', '68'),
('137', '69', 'cust_branch', 'general', '69'),
('138', '69', 'customer', 'general', '69'),
('139', '70', 'cust_branch', 'general', '70'),
('140', '70', 'customer', 'general', '70'),
('141', '71', 'cust_branch', 'general', '71'),
('142', '71', 'customer', 'general', '71'),
('143', '72', 'cust_branch', 'general', '72'),
('144', '72', 'customer', 'general', '72'),
('145', '73', 'cust_branch', 'general', '73'),
('146', '73', 'customer', 'general', '73'),
('147', '74', 'cust_branch', 'general', '74'),
('148', '74', 'customer', 'general', '74'),
('149', '75', 'cust_branch', 'general', '75'),
('150', '75', 'customer', 'general', '75'),
('151', '76', 'cust_branch', 'general', '76'),
('152', '76', 'customer', 'general', '76'),
('153', '77', 'cust_branch', 'general', '77'),
('154', '77', 'customer', 'general', '77'),
('155', '78', 'cust_branch', 'general', '78'),
('156', '78', 'customer', 'general', '78'),
('157', '79', 'cust_branch', 'general', '79'),
('158', '79', 'customer', 'general', '79'),
('159', '80', 'cust_branch', 'general', '80'),
('160', '80', 'customer', 'general', '80'),
('161', '81', 'cust_branch', 'general', '81'),
('162', '81', 'customer', 'general', '81'),
('163', '82', 'cust_branch', 'general', '82'),
('164', '82', 'customer', 'general', '82'),
('165', '83', 'cust_branch', 'general', '83'),
('166', '83', 'customer', 'general', '83'),
('167', '84', 'cust_branch', 'general', '84'),
('168', '84', 'customer', 'general', '84'),
('169', '85', 'cust_branch', 'general', '85'),
('170', '85', 'customer', 'general', '85'),
('171', '86', 'cust_branch', 'general', '86'),
('172', '86', 'customer', 'general', '86'),
('173', '87', 'cust_branch', 'general', '87'),
('174', '87', 'customer', 'general', '87'),
('175', '88', 'cust_branch', 'general', '88'),
('176', '88', 'customer', 'general', '88'),
('177', '89', 'cust_branch', 'general', '89'),
('178', '89', 'customer', 'general', '89'),
('179', '90', 'cust_branch', 'general', '90'),
('180', '90', 'customer', 'general', '90'),
('181', '91', 'cust_branch', 'general', '91'),
('182', '91', 'customer', 'general', '91'),
('183', '92', 'cust_branch', 'general', '92'),
('184', '92', 'customer', 'general', '92'),
('185', '93', 'cust_branch', 'general', '93'),
('186', '93', 'customer', 'general', '93'),
('187', '94', 'cust_branch', 'general', '94'),
('188', '94', 'customer', 'general', '94'),
('189', '95', 'cust_branch', 'general', '95'),
('190', '95', 'customer', 'general', '95'),
('191', '96', 'cust_branch', 'general', '96'),
('192', '96', 'customer', 'general', '96'),
('193', '97', 'cust_branch', 'general', '97'),
('194', '97', 'customer', 'general', '97'),
('195', '98', 'cust_branch', 'general', '98'),
('196', '98', 'customer', 'general', '98'),
('197', '99', 'cust_branch', 'general', '99'),
('198', '99', 'customer', 'general', '99'),
('199', '100', 'cust_branch', 'general', '100'),
('200', '100', 'customer', 'general', '100'),
('201', '101', 'cust_branch', 'general', '101'),
('202', '101', 'customer', 'general', '101'),
('203', '102', 'cust_branch', 'general', '102'),
('204', '102', 'customer', 'general', '102'),
('205', '103', 'cust_branch', 'general', '103'),
('206', '103', 'customer', 'general', '103'),
('207', '104', 'cust_branch', 'general', '104'),
('208', '104', 'customer', 'general', '104'),
('209', '105', 'cust_branch', 'general', '105'),
('210', '105', 'customer', 'general', '105'),
('211', '106', 'cust_branch', 'general', '106'),
('212', '106', 'customer', 'general', '106'),
('213', '107', 'cust_branch', 'general', '107'),
('214', '107', 'customer', 'general', '107'),
('215', '108', 'cust_branch', 'general', '108'),
('216', '108', 'customer', 'general', '108'),
('217', '109', 'cust_branch', 'general', '109'),
('218', '109', 'customer', 'general', '109'),
('219', '110', 'cust_branch', 'general', '110'),
('220', '110', 'customer', 'general', '110'),
('221', '111', 'cust_branch', 'general', '111'),
('222', '111', 'customer', 'general', '111'),
('223', '112', 'cust_branch', 'general', '112'),
('224', '112', 'customer', 'general', '112'),
('225', '113', 'cust_branch', 'general', '113'),
('226', '113', 'customer', 'general', '113'),
('227', '114', 'cust_branch', 'general', '114'),
('228', '114', 'customer', 'general', '114'),
('229', '115', 'cust_branch', 'general', '115'),
('230', '115', 'customer', 'general', '115'),
('231', '116', 'cust_branch', 'general', '116'),
('232', '116', 'customer', 'general', '116'),
('233', '117', 'cust_branch', 'general', '117'),
('234', '117', 'customer', 'general', '117'),
('235', '118', 'cust_branch', 'general', '118'),
('236', '118', 'customer', 'general', '118'),
('237', '119', 'cust_branch', 'general', '119'),
('238', '119', 'customer', 'general', '119'),
('239', '120', 'cust_branch', 'general', '120'),
('240', '120', 'customer', 'general', '120'),
('241', '121', 'cust_branch', 'general', '121'),
('242', '121', 'customer', 'general', '121'),
('243', '122', 'cust_branch', 'general', '122'),
('244', '122', 'customer', 'general', '122'),
('245', '123', 'cust_branch', 'general', '123'),
('246', '123', 'customer', 'general', '123'),
('247', '124', 'cust_branch', 'general', '124'),
('248', '124', 'customer', 'general', '124'),
('249', '125', 'cust_branch', 'general', '125'),
('250', '125', 'customer', 'general', '125'),
('251', '126', 'cust_branch', 'general', '126'),
('252', '126', 'customer', 'general', '126'),
('253', '127', 'cust_branch', 'general', '127'),
('254', '127', 'customer', 'general', '127'),
('255', '128', 'cust_branch', 'general', '128'),
('256', '128', 'customer', 'general', '128'),
('257', '129', 'cust_branch', 'general', '129'),
('258', '129', 'customer', 'general', '129'),
('259', '130', 'cust_branch', 'general', '130'),
('260', '130', 'customer', 'general', '130'),
('261', '131', 'cust_branch', 'general', '131'),
('262', '131', 'customer', 'general', '131'),
('263', '132', 'cust_branch', 'general', '132'),
('264', '132', 'customer', 'general', '132'),
('265', '133', 'cust_branch', 'general', '133'),
('266', '133', 'customer', 'general', '133'),
('267', '134', 'cust_branch', 'general', '134'),
('268', '134', 'customer', 'general', '134'),
('269', '135', 'cust_branch', 'general', '135'),
('270', '135', 'customer', 'general', '135'),
('271', '136', 'cust_branch', 'general', '136'),
('272', '136', 'customer', 'general', '136'),
('273', '137', 'cust_branch', 'general', '137'),
('274', '137', 'customer', 'general', '137'),
('275', '138', 'cust_branch', 'general', '138'),
('276', '138', 'customer', 'general', '138'),
('277', '139', 'cust_branch', 'general', '139'),
('278', '139', 'customer', 'general', '139'),
('279', '140', 'cust_branch', 'general', '140'),
('280', '140', 'customer', 'general', '140'),
('281', '141', 'cust_branch', 'general', '141'),
('282', '141', 'customer', 'general', '141'),
('283', '142', 'cust_branch', 'general', '142'),
('284', '142', 'customer', 'general', '142'),
('285', '143', 'cust_branch', 'general', '143'),
('286', '143', 'customer', 'general', '143'),
('287', '144', 'cust_branch', 'general', '144'),
('288', '144', 'customer', 'general', '144'),
('289', '145', 'cust_branch', 'general', '145'),
('290', '145', 'customer', 'general', '145'),
('291', '146', 'cust_branch', 'general', '146'),
('292', '146', 'customer', 'general', '146'),
('293', '147', 'cust_branch', 'general', '147'),
('294', '147', 'customer', 'general', '147'),
('295', '148', 'cust_branch', 'general', '148'),
('296', '148', 'customer', 'general', '148'),
('297', '149', 'cust_branch', 'general', '149'),
('298', '149', 'customer', 'general', '149'),
('299', '150', 'cust_branch', 'general', '150'),
('300', '150', 'customer', 'general', '150'),
('301', '151', 'cust_branch', 'general', '151'),
('302', '151', 'customer', 'general', '151'),
('303', '152', 'cust_branch', 'general', '152'),
('304', '152', 'customer', 'general', '152'),
('305', '153', 'cust_branch', 'general', '153'),
('306', '153', 'customer', 'general', '153'),
('307', '154', 'cust_branch', 'general', '154'),
('308', '154', 'customer', 'general', '154'),
('309', '155', 'cust_branch', 'general', '155'),
('310', '155', 'customer', 'general', '155'),
('311', '156', 'cust_branch', 'general', '156'),
('312', '156', 'customer', 'general', '156'),
('313', '157', 'cust_branch', 'general', '157'),
('314', '157', 'customer', 'general', '157'),
('315', '158', 'cust_branch', 'general', '158'),
('316', '158', 'customer', 'general', '158'),
('317', '159', 'cust_branch', 'general', '159'),
('318', '159', 'customer', 'general', '159'),
('319', '160', 'cust_branch', 'general', '160'),
('320', '160', 'customer', 'general', '160'),
('321', '161', 'cust_branch', 'general', '161'),
('322', '161', 'customer', 'general', '161'),
('323', '162', 'cust_branch', 'general', '162'),
('324', '162', 'customer', 'general', '162'),
('325', '163', 'cust_branch', 'general', '163'),
('326', '163', 'customer', 'general', '163'),
('327', '164', 'cust_branch', 'general', '164'),
('328', '164', 'customer', 'general', '164'),
('329', '165', 'cust_branch', 'general', '165'),
('330', '165', 'customer', 'general', '165'),
('331', '166', 'cust_branch', 'general', '166'),
('332', '166', 'customer', 'general', '166'),
('333', '167', 'cust_branch', 'general', '167'),
('334', '167', 'customer', 'general', '167'),
('335', '168', 'cust_branch', 'general', '168'),
('336', '168', 'customer', 'general', '168'),
('337', '169', 'cust_branch', 'general', '169'),
('338', '169', 'customer', 'general', '169'),
('339', '170', 'cust_branch', 'general', '170'),
('340', '170', 'customer', 'general', '170'),
('341', '171', 'cust_branch', 'general', '171'),
('342', '171', 'customer', 'general', '171'),
('343', '172', 'cust_branch', 'general', '172'),
('344', '172', 'customer', 'general', '172'),
('345', '173', 'cust_branch', 'general', '173'),
('346', '173', 'customer', 'general', '173'),
('347', '174', 'cust_branch', 'general', '174'),
('348', '174', 'customer', 'general', '174'),
('349', '175', 'cust_branch', 'general', '175'),
('350', '175', 'customer', 'general', '175'),
('351', '176', 'cust_branch', 'general', '176'),
('352', '176', 'customer', 'general', '176'),
('353', '177', 'cust_branch', 'general', '177'),
('354', '177', 'customer', 'general', '177'),
('355', '178', 'cust_branch', 'general', '178'),
('356', '178', 'customer', 'general', '178'),
('357', '179', 'cust_branch', 'general', '179'),
('358', '179', 'customer', 'general', '179'),
('359', '180', 'cust_branch', 'general', '180'),
('360', '180', 'customer', 'general', '180'),
('361', '181', 'cust_branch', 'general', '181'),
('362', '181', 'customer', 'general', '181'),
('363', '182', 'cust_branch', 'general', '182'),
('364', '182', 'customer', 'general', '182'),
('365', '183', 'cust_branch', 'general', '183'),
('366', '183', 'customer', 'general', '183'),
('367', '184', 'cust_branch', 'general', '184'),
('368', '184', 'customer', 'general', '184'),
('369', '185', 'cust_branch', 'general', '185'),
('370', '185', 'customer', 'general', '185'),
('371', '186', 'cust_branch', 'general', '186'),
('372', '186', 'customer', 'general', '186'),
('373', '187', 'cust_branch', 'general', '187'),
('374', '187', 'customer', 'general', '187'),
('375', '188', 'cust_branch', 'general', '188'),
('376', '188', 'customer', 'general', '188'),
('377', '189', 'cust_branch', 'general', '189'),
('378', '189', 'customer', 'general', '189'),
('379', '190', 'cust_branch', 'general', '190'),
('380', '190', 'customer', 'general', '190'),
('381', '191', 'cust_branch', 'general', '191'),
('382', '191', 'customer', 'general', '191'),
('383', '192', 'cust_branch', 'general', '192'),
('384', '192', 'customer', 'general', '192'),
('385', '193', 'cust_branch', 'general', '193'),
('386', '193', 'customer', 'general', '193'),
('387', '194', 'cust_branch', 'general', '194'),
('388', '194', 'customer', 'general', '194'),
('389', '195', 'cust_branch', 'general', '195'),
('390', '195', 'customer', 'general', '195'),
('391', '196', 'cust_branch', 'general', '196'),
('392', '196', 'customer', 'general', '196'),
('393', '197', 'cust_branch', 'general', '197'),
('394', '197', 'customer', 'general', '197'),
('395', '198', 'cust_branch', 'general', '198'),
('396', '198', 'customer', 'general', '198'),
('397', '199', 'cust_branch', 'general', '199'),
('398', '199', 'customer', 'general', '199'),
('399', '200', 'cust_branch', 'general', '200'),
('400', '200', 'customer', 'general', '200'),
('401', '201', 'cust_branch', 'general', '201'),
('402', '201', 'customer', 'general', '201'),
('403', '202', 'cust_branch', 'general', '202'),
('404', '202', 'customer', 'general', '202'),
('405', '203', 'cust_branch', 'general', '203'),
('406', '203', 'customer', 'general', '203'),
('407', '204', 'cust_branch', 'general', '204'),
('408', '204', 'customer', 'general', '204'),
('409', '205', 'cust_branch', 'general', '205'),
('410', '205', 'customer', 'general', '205'),
('411', '206', 'cust_branch', 'general', '206'),
('412', '206', 'customer', 'general', '206'),
('413', '207', 'cust_branch', 'general', '207'),
('414', '207', 'customer', 'general', '207'),
('415', '208', 'cust_branch', 'general', '208'),
('416', '208', 'customer', 'general', '208'),
('417', '209', 'cust_branch', 'general', '209'),
('418', '209', 'customer', 'general', '209'),
('419', '210', 'cust_branch', 'general', '210'),
('420', '210', 'customer', 'general', '210'),
('421', '211', 'cust_branch', 'general', '211'),
('422', '211', 'customer', 'general', '211'),
('423', '212', 'cust_branch', 'general', '212'),
('424', '212', 'customer', 'general', '212'),
('425', '213', 'cust_branch', 'general', '213'),
('426', '213', 'customer', 'general', '213'),
('427', '214', 'cust_branch', 'general', '214'),
('428', '214', 'customer', 'general', '214'),
('429', '215', 'cust_branch', 'general', '215'),
('430', '215', 'customer', 'general', '215'),
('431', '216', 'cust_branch', 'general', '216'),
('432', '216', 'customer', 'general', '216'),
('433', '217', 'cust_branch', 'general', '217'),
('434', '217', 'customer', 'general', '217'),
('435', '218', 'cust_branch', 'general', '218'),
('436', '218', 'customer', 'general', '218'),
('437', '219', 'cust_branch', 'general', '219'),
('438', '219', 'customer', 'general', '219'),
('439', '220', 'cust_branch', 'general', '220'),
('440', '220', 'customer', 'general', '220'),
('441', '221', 'cust_branch', 'general', '221'),
('442', '221', 'customer', 'general', '221'),
('443', '222', 'cust_branch', 'general', '222'),
('444', '222', 'customer', 'general', '222'),
('445', '223', 'cust_branch', 'general', '223'),
('446', '223', 'customer', 'general', '223'),
('447', '224', 'cust_branch', 'general', '224'),
('448', '224', 'customer', 'general', '224'),
('449', '225', 'cust_branch', 'general', '225'),
('450', '225', 'customer', 'general', '225'),
('451', '226', 'cust_branch', 'general', '226'),
('452', '226', 'customer', 'general', '226'),
('453', '227', 'cust_branch', 'general', '227'),
('454', '227', 'customer', 'general', '227'),
('455', '228', 'cust_branch', 'general', '228'),
('456', '228', 'customer', 'general', '228'),
('457', '229', 'cust_branch', 'general', '229'),
('458', '229', 'customer', 'general', '229'),
('459', '230', 'cust_branch', 'general', '230'),
('460', '230', 'customer', 'general', '230'),
('461', '231', 'cust_branch', 'general', '231'),
('462', '231', 'customer', 'general', '231'),
('463', '232', 'cust_branch', 'general', '232'),
('464', '232', 'customer', 'general', '232'),
('465', '233', 'cust_branch', 'general', '233'),
('466', '233', 'customer', 'general', '233'),
('467', '234', 'cust_branch', 'general', '234'),
('468', '234', 'customer', 'general', '234'),
('469', '235', 'cust_branch', 'general', '235'),
('470', '235', 'customer', 'general', '235'),
('471', '236', 'cust_branch', 'general', '236'),
('472', '236', 'customer', 'general', '236'),
('473', '237', 'cust_branch', 'general', '237'),
('474', '237', 'customer', 'general', '237'),
('475', '238', 'cust_branch', 'general', '238'),
('476', '238', 'customer', 'general', '238'),
('477', '239', 'cust_branch', 'general', '239'),
('478', '239', 'customer', 'general', '239'),
('479', '240', 'cust_branch', 'general', '240'),
('480', '240', 'customer', 'general', '240'),
('481', '241', 'cust_branch', 'general', '241'),
('482', '241', 'customer', 'general', '241'),
('483', '242', 'cust_branch', 'general', '242'),
('484', '242', 'customer', 'general', '242'),
('485', '243', 'cust_branch', 'general', '243'),
('486', '243', 'customer', 'general', '243'),
('487', '244', 'cust_branch', 'general', '244'),
('488', '244', 'customer', 'general', '244'),
('489', '245', 'cust_branch', 'general', '245'),
('490', '245', 'customer', 'general', '245'),
('491', '246', 'cust_branch', 'general', '246'),
('492', '246', 'customer', 'general', '246'),
('493', '247', 'cust_branch', 'general', '247'),
('494', '247', 'customer', 'general', '247'),
('495', '248', 'cust_branch', 'general', '248'),
('496', '248', 'customer', 'general', '248'),
('497', '249', 'cust_branch', 'general', '249'),
('498', '249', 'customer', 'general', '249'),
('499', '250', 'cust_branch', 'general', '250'),
('500', '250', 'customer', 'general', '250'),
('501', '251', 'cust_branch', 'general', '251'),
('502', '251', 'customer', 'general', '251'),
('503', '252', 'cust_branch', 'general', '252'),
('504', '252', 'customer', 'general', '252'),
('505', '253', 'cust_branch', 'general', '253'),
('506', '253', 'customer', 'general', '253'),
('507', '254', 'cust_branch', 'general', '254'),
('508', '254', 'customer', 'general', '254'),
('509', '255', 'cust_branch', 'general', '255'),
('510', '255', 'customer', 'general', '255'),
('511', '256', 'cust_branch', 'general', '256'),
('512', '256', 'customer', 'general', '256'),
('513', '257', 'cust_branch', 'general', '257'),
('514', '257', 'customer', 'general', '257'),
('515', '258', 'cust_branch', 'general', '258'),
('516', '258', 'customer', 'general', '258'),
('517', '259', 'cust_branch', 'general', '259'),
('518', '259', 'customer', 'general', '259'),
('519', '260', 'cust_branch', 'general', '260'),
('520', '260', 'customer', 'general', '260'),
('521', '261', 'cust_branch', 'general', '261'),
('522', '261', 'customer', 'general', '261'),
('523', '262', 'cust_branch', 'general', '262'),
('524', '262', 'customer', 'general', '262'),
('525', '263', 'cust_branch', 'general', '263'),
('526', '263', 'customer', 'general', '263'),
('527', '264', 'cust_branch', 'general', '264'),
('528', '264', 'customer', 'general', '264'),
('529', '265', 'cust_branch', 'general', '265'),
('530', '265', 'customer', 'general', '265'),
('531', '266', 'cust_branch', 'general', '266'),
('532', '266', 'customer', 'general', '266'),
('533', '267', 'cust_branch', 'general', '267'),
('534', '267', 'customer', 'general', '267'),
('535', '268', 'cust_branch', 'general', '268'),
('536', '268', 'customer', 'general', '268'),
('537', '269', 'cust_branch', 'general', '269'),
('538', '269', 'customer', 'general', '269'),
('539', '270', 'cust_branch', 'general', '270'),
('540', '270', 'customer', 'general', '270'),
('541', '271', 'cust_branch', 'general', '271'),
('542', '271', 'customer', 'general', '271'),
('543', '272', 'cust_branch', 'general', '272'),
('544', '272', 'customer', 'general', '272'),
('545', '273', 'cust_branch', 'general', '273'),
('546', '273', 'customer', 'general', '273'),
('547', '274', 'cust_branch', 'general', '274'),
('548', '274', 'customer', 'general', '274'),
('549', '275', 'cust_branch', 'general', '275'),
('550', '275', 'customer', 'general', '275'),
('551', '276', 'cust_branch', 'general', '276'),
('552', '276', 'customer', 'general', '276'),
('553', '277', 'cust_branch', 'general', '277'),
('554', '277', 'customer', 'general', '277'),
('555', '278', 'cust_branch', 'general', '278'),
('556', '278', 'customer', 'general', '278'),
('557', '279', 'cust_branch', 'general', '279'),
('558', '279', 'customer', 'general', '279'),
('559', '280', 'cust_branch', 'general', '280'),
('560', '280', 'customer', 'general', '280'),
('561', '281', 'cust_branch', 'general', '281'),
('562', '281', 'customer', 'general', '281'),
('563', '282', 'cust_branch', 'general', '282'),
('564', '282', 'customer', 'general', '282'),
('565', '283', 'cust_branch', 'general', '283'),
('566', '283', 'customer', 'general', '283'),
('567', '284', 'cust_branch', 'general', '284'),
('568', '284', 'customer', 'general', '284'),
('569', '285', 'cust_branch', 'general', '285'),
('570', '285', 'customer', 'general', '285'),
('571', '286', 'cust_branch', 'general', '286'),
('572', '286', 'customer', 'general', '286'),
('573', '287', 'cust_branch', 'general', '287'),
('574', '287', 'customer', 'general', '287'),
('575', '288', 'cust_branch', 'general', '288'),
('576', '288', 'customer', 'general', '288'),
('577', '289', 'cust_branch', 'general', '289'),
('578', '289', 'customer', 'general', '289'),
('579', '290', 'cust_branch', 'general', '290'),
('580', '290', 'customer', 'general', '290'),
('581', '291', 'cust_branch', 'general', '291'),
('582', '291', 'customer', 'general', '291'),
('583', '292', 'cust_branch', 'general', '292'),
('584', '292', 'customer', 'general', '292'),
('585', '293', 'cust_branch', 'general', '293'),
('586', '293', 'customer', 'general', '293'),
('587', '294', 'cust_branch', 'general', '294'),
('588', '294', 'customer', 'general', '294'),
('589', '295', 'cust_branch', 'general', '295'),
('590', '295', 'customer', 'general', '295'),
('591', '296', 'cust_branch', 'general', '296'),
('592', '296', 'customer', 'general', '296'),
('593', '297', 'cust_branch', 'general', '297'),
('594', '297', 'customer', 'general', '297'),
('595', '298', 'cust_branch', 'general', '298'),
('596', '298', 'customer', 'general', '298'),
('597', '299', 'cust_branch', 'general', '299'),
('598', '299', 'customer', 'general', '299'),
('599', '300', 'cust_branch', 'general', '300'),
('600', '300', 'customer', 'general', '300'),
('601', '301', 'cust_branch', 'general', '301'),
('602', '301', 'customer', 'general', '301'),
('603', '302', 'cust_branch', 'general', '302'),
('604', '302', 'customer', 'general', '302'),
('605', '303', 'cust_branch', 'general', '303'),
('606', '303', 'customer', 'general', '303'),
('607', '304', 'cust_branch', 'general', '304'),
('608', '304', 'customer', 'general', '304'),
('609', '305', 'cust_branch', 'general', '305'),
('610', '305', 'customer', 'general', '305'),
('611', '306', 'cust_branch', 'general', '306'),
('612', '306', 'customer', 'general', '306'),
('613', '307', 'cust_branch', 'general', '307'),
('614', '307', 'customer', 'general', '307'),
('615', '308', 'cust_branch', 'general', '308'),
('616', '308', 'customer', 'general', '308'),
('617', '309', 'cust_branch', 'general', '309'),
('618', '309', 'customer', 'general', '309'),
('619', '310', 'cust_branch', 'general', '310'),
('620', '310', 'customer', 'general', '310'),
('621', '311', 'cust_branch', 'general', '311'),
('622', '311', 'customer', 'general', '311'),
('623', '312', 'cust_branch', 'general', '312'),
('624', '312', 'customer', 'general', '312'),
('625', '313', 'cust_branch', 'general', '313'),
('626', '313', 'customer', 'general', '313'),
('627', '314', 'cust_branch', 'general', '314'),
('628', '314', 'customer', 'general', '314'),
('629', '315', 'cust_branch', 'general', '315'),
('630', '315', 'customer', 'general', '315'),
('631', '316', 'cust_branch', 'general', '316'),
('632', '316', 'customer', 'general', '316'),
('633', '317', 'cust_branch', 'general', '317'),
('634', '317', 'customer', 'general', '317'),
('635', '318', 'cust_branch', 'general', '318'),
('636', '318', 'customer', 'general', '318'),
('637', '319', 'cust_branch', 'general', '319'),
('638', '319', 'customer', 'general', '319'),
('639', '320', 'cust_branch', 'general', '320'),
('640', '320', 'customer', 'general', '320'),
('641', '321', 'cust_branch', 'general', '321'),
('642', '321', 'customer', 'general', '321'),
('643', '322', 'cust_branch', 'general', '322'),
('644', '322', 'customer', 'general', '322'),
('645', '323', 'cust_branch', 'general', '323'),
('646', '323', 'customer', 'general', '323'),
('647', '324', 'cust_branch', 'general', '324'),
('648', '324', 'customer', 'general', '324'),
('649', '325', 'cust_branch', 'general', '325'),
('650', '325', 'customer', 'general', '325'),
('651', '326', 'cust_branch', 'general', '326'),
('652', '326', 'customer', 'general', '326'),
('653', '327', 'cust_branch', 'general', '327'),
('654', '327', 'customer', 'general', '327'),
('655', '328', 'cust_branch', 'general', '328'),
('656', '328', 'customer', 'general', '328'),
('657', '329', 'cust_branch', 'general', '329'),
('658', '329', 'customer', 'general', '329'),
('659', '330', 'cust_branch', 'general', '330'),
('660', '330', 'customer', 'general', '330'),
('661', '331', 'cust_branch', 'general', '331'),
('662', '331', 'customer', 'general', '331'),
('663', '332', 'cust_branch', 'general', '332'),
('664', '332', 'customer', 'general', '332'),
('665', '333', 'cust_branch', 'general', '333'),
('666', '333', 'customer', 'general', '333'),
('667', '334', 'cust_branch', 'general', '334'),
('668', '334', 'customer', 'general', '334'),
('669', '335', 'cust_branch', 'general', '335'),
('670', '335', 'customer', 'general', '335'),
('671', '336', 'cust_branch', 'general', '336'),
('672', '336', 'customer', 'general', '336'),
('673', '337', 'cust_branch', 'general', '337'),
('674', '337', 'customer', 'general', '337'),
('675', '338', 'cust_branch', 'general', '338'),
('676', '338', 'customer', 'general', '338'),
('677', '339', 'cust_branch', 'general', '339'),
('678', '339', 'customer', 'general', '339'),
('679', '340', 'cust_branch', 'general', '340'),
('680', '340', 'customer', 'general', '340'),
('681', '341', 'cust_branch', 'general', '341'),
('682', '341', 'customer', 'general', '341'),
('683', '342', 'cust_branch', 'general', '342'),
('684', '342', 'customer', 'general', '342'),
('685', '343', 'cust_branch', 'general', '343'),
('686', '343', 'customer', 'general', '343'),
('687', '344', 'cust_branch', 'general', '344'),
('688', '344', 'customer', 'general', '344'),
('689', '345', 'cust_branch', 'general', '345'),
('690', '345', 'customer', 'general', '345'),
('691', '346', 'cust_branch', 'general', '346'),
('692', '346', 'customer', 'general', '346'),
('693', '347', 'cust_branch', 'general', '347'),
('694', '347', 'customer', 'general', '347'),
('695', '348', 'cust_branch', 'general', '348'),
('696', '348', 'customer', 'general', '348'),
('697', '349', 'cust_branch', 'general', '349'),
('698', '349', 'customer', 'general', '349'),
('699', '350', 'cust_branch', 'general', '350'),
('700', '350', 'customer', 'general', '350'),
('701', '351', 'cust_branch', 'general', '351'),
('702', '351', 'customer', 'general', '351'),
('703', '352', 'cust_branch', 'general', '352'),
('704', '352', 'customer', 'general', '352'),
('705', '353', 'cust_branch', 'general', '353'),
('706', '353', 'customer', 'general', '353'),
('707', '354', 'cust_branch', 'general', '354'),
('708', '354', 'customer', 'general', '354'),
('709', '355', 'cust_branch', 'general', '355'),
('710', '355', 'customer', 'general', '355'),
('711', '356', 'cust_branch', 'general', '356'),
('712', '356', 'customer', 'general', '356'),
('713', '357', 'cust_branch', 'general', '357'),
('714', '357', 'customer', 'general', '357'),
('715', '358', 'cust_branch', 'general', '358'),
('716', '358', 'customer', 'general', '358'),
('717', '359', 'cust_branch', 'general', '359'),
('718', '359', 'customer', 'general', '359'),
('719', '360', 'cust_branch', 'general', '360'),
('720', '360', 'customer', 'general', '360'),
('721', '361', 'cust_branch', 'general', '361'),
('722', '361', 'customer', 'general', '361'),
('723', '362', 'cust_branch', 'general', '362'),
('724', '362', 'customer', 'general', '362'),
('725', '363', 'cust_branch', 'general', '363'),
('726', '363', 'customer', 'general', '363'),
('727', '364', 'cust_branch', 'general', '364'),
('728', '364', 'customer', 'general', '364'),
('729', '365', 'cust_branch', 'general', '365'),
('730', '365', 'customer', 'general', '365'),
('731', '366', 'cust_branch', 'general', '366'),
('732', '366', 'customer', 'general', '366'),
('733', '367', 'cust_branch', 'general', '367'),
('734', '367', 'customer', 'general', '367'),
('735', '368', 'cust_branch', 'general', '368'),
('736', '368', 'customer', 'general', '368'),
('737', '369', 'cust_branch', 'general', '369'),
('738', '369', 'customer', 'general', '369'),
('739', '370', 'cust_branch', 'general', '370'),
('740', '370', 'customer', 'general', '370'),
('741', '371', 'cust_branch', 'general', '371'),
('742', '371', 'customer', 'general', '371'),
('743', '372', 'cust_branch', 'general', '372'),
('744', '372', 'customer', 'general', '372'),
('745', '373', 'cust_branch', 'general', '373'),
('746', '373', 'customer', 'general', '373'),
('747', '374', 'cust_branch', 'general', '374'),
('748', '374', 'customer', 'general', '374'),
('749', '375', 'cust_branch', 'general', '375'),
('750', '375', 'customer', 'general', '375'),
('751', '376', 'cust_branch', 'general', '376'),
('752', '376', 'customer', 'general', '376'),
('753', '377', 'cust_branch', 'general', '377'),
('754', '377', 'customer', 'general', '377'),
('755', '378', 'cust_branch', 'general', '378'),
('756', '378', 'customer', 'general', '378'),
('757', '379', 'cust_branch', 'general', '379'),
('758', '379', 'customer', 'general', '379'),
('759', '380', 'cust_branch', 'general', '380'),
('760', '380', 'customer', 'general', '380'),
('761', '381', 'cust_branch', 'general', '381'),
('762', '381', 'customer', 'general', '381'),
('763', '382', 'cust_branch', 'general', '382'),
('764', '382', 'customer', 'general', '382'),
('765', '383', 'cust_branch', 'general', '383'),
('766', '383', 'customer', 'general', '383'),
('767', '384', 'cust_branch', 'general', '384'),
('768', '384', 'customer', 'general', '384'),
('769', '385', 'cust_branch', 'general', '385'),
('770', '385', 'customer', 'general', '385'),
('771', '386', 'cust_branch', 'general', '386'),
('772', '386', 'customer', 'general', '386'),
('773', '387', 'cust_branch', 'general', '387'),
('774', '387', 'customer', 'general', '387'),
('775', '388', 'cust_branch', 'general', '388'),
('776', '388', 'customer', 'general', '388'),
('777', '389', 'cust_branch', 'general', '389'),
('778', '389', 'customer', 'general', '389'),
('779', '390', 'cust_branch', 'general', '390'),
('780', '390', 'customer', 'general', '390'),
('781', '391', 'cust_branch', 'general', '391'),
('782', '391', 'customer', 'general', '391'),
('783', '392', 'cust_branch', 'general', '392'),
('784', '392', 'customer', 'general', '392'),
('785', '393', 'cust_branch', 'general', '393'),
('786', '393', 'customer', 'general', '393'),
('787', '394', 'cust_branch', 'general', '394'),
('788', '394', 'customer', 'general', '394'),
('789', '395', 'cust_branch', 'general', '395'),
('790', '395', 'customer', 'general', '395'),
('791', '396', 'cust_branch', 'general', '396'),
('792', '396', 'customer', 'general', '396'),
('793', '397', 'cust_branch', 'general', '397'),
('794', '397', 'customer', 'general', '397'),
('795', '398', 'cust_branch', 'general', '398'),
('796', '398', 'customer', 'general', '398'),
('797', '399', 'cust_branch', 'general', '399'),
('798', '399', 'customer', 'general', '399'),
('799', '400', 'cust_branch', 'general', '400'),
('800', '400', 'customer', 'general', '400'),
('801', '401', 'cust_branch', 'general', '401'),
('802', '401', 'customer', 'general', '401'),
('803', '402', 'cust_branch', 'general', '402'),
('804', '402', 'customer', 'general', '402'),
('805', '403', 'cust_branch', 'general', '403'),
('806', '403', 'customer', 'general', '403'),
('807', '404', 'cust_branch', 'general', '404'),
('808', '404', 'customer', 'general', '404'),
('809', '405', 'cust_branch', 'general', '405'),
('810', '405', 'customer', 'general', '405'),
('811', '406', 'cust_branch', 'general', '406'),
('812', '406', 'customer', 'general', '406'),
('813', '407', 'cust_branch', 'general', '407'),
('814', '407', 'customer', 'general', '407'),
('815', '408', 'cust_branch', 'general', '408'),
('816', '408', 'customer', 'general', '408'),
('817', '409', 'cust_branch', 'general', '409'),
('818', '409', 'customer', 'general', '409'),
('819', '410', 'cust_branch', 'general', '410'),
('820', '410', 'customer', 'general', '410'),
('821', '411', 'cust_branch', 'general', '411'),
('822', '411', 'customer', 'general', '411'),
('823', '412', 'cust_branch', 'general', '412'),
('824', '412', 'customer', 'general', '412'),
('825', '413', 'cust_branch', 'general', '413'),
('826', '413', 'customer', 'general', '413'),
('827', '414', 'cust_branch', 'general', '414'),
('828', '414', 'customer', 'general', '414'),
('829', '415', 'cust_branch', 'general', '415'),
('830', '415', 'customer', 'general', '415'),
('831', '416', 'cust_branch', 'general', '418'),
('832', '416', 'customer', 'general', '431'),
('833', '417', 'cust_branch', 'general', '419'),
('834', '417', 'customer', 'general', '432'),
('835', '418', 'cust_branch', 'general', '420'),
('836', '418', 'customer', 'general', '433'),
('837', '419', 'cust_branch', 'general', '421'),
('838', '419', 'customer', 'general', '434'),
('839', '420', 'cust_branch', 'general', '422'),
('840', '420', 'customer', 'general', '435'),
('841', '421', 'cust_branch', 'general', '423'),
('842', '421', 'customer', 'general', '436'),
('843', '422', 'cust_branch', 'general', '424'),
('844', '422', 'customer', 'general', '437'),
('845', '423', 'cust_branch', 'general', '425'),
('846', '423', 'customer', 'general', '438'),
('847', '424', 'cust_branch', 'general', '426'),
('848', '424', 'customer', 'general', '439'),
('849', '425', 'cust_branch', 'general', '427'),
('850', '425', 'customer', 'general', '440'),
('851', '426', 'cust_branch', 'general', '428'),
('852', '426', 'customer', 'general', '441'),
('853', '427', 'cust_branch', 'general', '429'),
('854', '427', 'customer', 'general', '442'),
('855', '428', 'cust_branch', 'general', '430'),
('856', '428', 'customer', 'general', '443'),
('857', '429', 'cust_branch', 'general', '431'),
('858', '429', 'customer', 'general', '444'),
('859', '430', 'cust_branch', 'general', '432'),
('860', '430', 'customer', 'general', '445'),
('861', '431', 'cust_branch', 'general', '433'),
('862', '431', 'customer', 'general', '446'),
('863', '432', 'cust_branch', 'general', '434'),
('864', '432', 'customer', 'general', '447'),
('865', '433', 'cust_branch', 'general', '435'),
('866', '433', 'customer', 'general', '448'),
('867', '434', 'cust_branch', 'general', '436'),
('868', '434', 'customer', 'general', '449'),
('869', '435', 'cust_branch', 'general', '437'),
('870', '435', 'customer', 'general', '450'),
('871', '436', 'cust_branch', 'general', '438'),
('872', '436', 'customer', 'general', '451'),
('873', '437', 'cust_branch', 'general', '439'),
('874', '437', 'customer', 'general', '452'),
('875', '438', 'cust_branch', 'general', '440'),
('876', '438', 'customer', 'general', '453'),
('877', '439', 'cust_branch', 'general', '441'),
('878', '439', 'customer', 'general', '454'),
('879', '440', 'cust_branch', 'general', '442'),
('880', '440', 'customer', 'general', '455'),
('881', '441', 'cust_branch', 'general', '443'),
('882', '441', 'customer', 'general', '456'),
('883', '442', 'cust_branch', 'general', '444'),
('884', '442', 'customer', 'general', '457'),
('885', '443', 'cust_branch', 'general', '445'),
('886', '443', 'customer', 'general', '458'),
('888', '444', 'customer', 'general', '459'),
('889', '445', 'cust_branch', 'general', '447'),
('890', '445', 'customer', 'general', '460'),
('891', '446', 'cust_branch', 'general', '448'),
('892', '446', 'customer', 'general', '461'),
('893', '447', 'cust_branch', 'general', '449'),
('894', '447', 'customer', 'general', '462'),
('895', '448', 'cust_branch', 'general', '450'),
('896', '448', 'customer', 'general', '463'),
('897', '449', 'cust_branch', 'general', '451'),
('898', '449', 'customer', 'general', '464'),
('899', '450', 'cust_branch', 'general', '452'),
('900', '450', 'customer', 'general', '465'),
('901', '451', 'cust_branch', 'general', '453'),
('902', '451', 'customer', 'general', '466'),
('903', '452', 'cust_branch', 'general', '454'),
('904', '452', 'customer', 'general', '467'),
('905', '453', 'cust_branch', 'general', '455'),
('906', '453', 'customer', 'general', '468'),
('907', '454', 'cust_branch', 'general', '456'),
('908', '454', 'customer', 'general', '469'),
('909', '455', 'cust_branch', 'general', '457'),
('910', '455', 'customer', 'general', '470'),
('911', '456', 'cust_branch', 'general', '458'),
('912', '456', 'customer', 'general', '471'),
('913', '457', 'cust_branch', 'general', '459'),
('914', '457', 'customer', 'general', '472'),
('915', '458', 'cust_branch', 'general', '460'),
('916', '458', 'customer', 'general', '473'),
('917', '459', 'cust_branch', 'general', '461'),
('918', '459', 'customer', 'general', '474'),
('919', '460', 'cust_branch', 'general', '462'),
('920', '460', 'customer', 'general', '475'),
('921', '461', 'cust_branch', 'general', '463'),
('922', '461', 'customer', 'general', '476'),
('923', '462', 'cust_branch', 'general', '464'),
('924', '462', 'customer', 'general', '477'),
('925', '463', 'cust_branch', 'general', '465'),
('926', '463', 'customer', 'general', '478'),
('927', '464', 'cust_branch', 'general', '466'),
('928', '464', 'customer', 'general', '479'),
('929', '465', 'cust_branch', 'general', '467'),
('930', '465', 'customer', 'general', '480'),
('931', '466', 'cust_branch', 'general', '468'),
('932', '466', 'customer', 'general', '481'),
('933', '467', 'cust_branch', 'general', '469'),
('934', '467', 'customer', 'general', '482'),
('935', '468', 'cust_branch', 'general', '470'),
('936', '468', 'customer', 'general', '483'),
('937', '469', 'cust_branch', 'general', '471'),
('938', '469', 'customer', 'general', '484'),
('939', '470', 'cust_branch', 'general', '472'),
('940', '470', 'customer', 'general', '485'),
('941', '471', 'cust_branch', 'general', '473'),
('942', '471', 'customer', 'general', '486'),
('943', '472', 'cust_branch', 'general', '474'),
('944', '472', 'customer', 'general', '487'),
('945', '473', 'cust_branch', 'general', '475'),
('946', '473', 'customer', 'general', '488'),
('947', '474', 'cust_branch', 'general', '476'),
('948', '474', 'customer', 'general', '489'),
('949', '475', 'cust_branch', 'general', '477'),
('950', '475', 'customer', 'general', '490'),
('951', '476', 'cust_branch', 'general', '478'),
('952', '476', 'customer', 'general', '491'),
('953', '477', 'cust_branch', 'general', '479'),
('954', '477', 'customer', 'general', '492'),
('955', '478', 'cust_branch', 'general', '480'),
('956', '478', 'customer', 'general', '493'),
('957', '479', 'cust_branch', 'general', '481'),
('958', '479', 'customer', 'general', '494'),
('959', '480', 'cust_branch', 'general', '482'),
('960', '480', 'customer', 'general', '495'),
('961', '481', 'cust_branch', 'general', '483'),
('962', '481', 'customer', 'general', '496'),
('963', '482', 'cust_branch', 'general', '484'),
('964', '482', 'customer', 'general', '497'),
('965', '483', 'cust_branch', 'general', '485'),
('966', '483', 'customer', 'general', '498'),
('967', '484', 'cust_branch', 'general', '486'),
('968', '484', 'customer', 'general', '499'),
('969', '485', 'cust_branch', 'general', '487'),
('970', '485', 'customer', 'general', '500'),
('971', '486', 'cust_branch', 'general', '488'),
('972', '486', 'customer', 'general', '501'),
('973', '487', 'cust_branch', 'general', '489'),
('974', '487', 'customer', 'general', '502'),
('975', '488', 'cust_branch', 'general', '490'),
('976', '488', 'customer', 'general', '503'),
('977', '489', 'cust_branch', 'general', '491'),
('978', '489', 'customer', 'general', '504'),
('979', '490', 'cust_branch', 'general', '492'),
('980', '490', 'customer', 'general', '505'),
('981', '491', 'cust_branch', 'general', '493'),
('982', '491', 'customer', 'general', '506'),
('983', '492', 'cust_branch', 'general', '494'),
('984', '492', 'customer', 'general', '507'),
('985', '493', 'cust_branch', 'general', '495'),
('986', '493', 'customer', 'general', '508'),
('987', '494', 'cust_branch', 'general', '496'),
('988', '494', 'customer', 'general', '509'),
('989', '495', 'cust_branch', 'general', '497'),
('990', '495', 'customer', 'general', '510'),
('991', '496', 'cust_branch', 'general', '498'),
('992', '496', 'customer', 'general', '511'),
('993', '497', 'cust_branch', 'general', '499'),
('994', '497', 'customer', 'general', '512'),
('995', '498', 'cust_branch', 'general', '500'),
('996', '498', 'customer', 'general', '513'),
('997', '499', 'cust_branch', 'general', '501'),
('998', '499', 'customer', 'general', '514'),
('999', '500', 'cust_branch', 'general', '502'),
('1000', '500', 'customer', 'general', '515'),
('1001', '501', 'cust_branch', 'general', '503'),
('1002', '501', 'customer', 'general', '516'),
('1003', '502', 'cust_branch', 'general', '504'),
('1004', '502', 'customer', 'general', '517'),
('1005', '503', 'cust_branch', 'general', '505'),
('1006', '503', 'customer', 'general', '518'),
('1007', '504', 'cust_branch', 'general', '506'),
('1008', '504', 'customer', 'general', '519'),
('1009', '505', 'cust_branch', 'general', '507'),
('1010', '505', 'customer', 'general', '520'),
('1011', '506', 'cust_branch', 'general', '508'),
('1012', '506', 'customer', 'general', '521'),
('1013', '507', 'cust_branch', 'general', '509'),
('1014', '507', 'customer', 'general', '522'),
('1015', '508', 'cust_branch', 'general', '510'),
('1016', '508', 'customer', 'general', '523'),
('1017', '509', 'cust_branch', 'general', '511'),
('1018', '509', 'customer', 'general', '524'),
('1019', '510', 'cust_branch', 'general', '512'),
('1020', '510', 'customer', 'general', '525'),
('1021', '511', 'cust_branch', 'general', '513'),
('1022', '511', 'customer', 'general', '526'),
('1023', '512', 'cust_branch', 'general', '514'),
('1024', '512', 'customer', 'general', '527'),
('1025', '513', 'cust_branch', 'general', '515'),
('1026', '513', 'customer', 'general', '528'),
('1027', '514', 'cust_branch', 'general', '516'),
('1028', '514', 'customer', 'general', '529'),
('1029', '515', 'cust_branch', 'general', '517'),
('1030', '515', 'customer', 'general', '530'),
('1031', '516', 'cust_branch', 'general', '518'),
('1032', '516', 'customer', 'general', '531'),
('1033', '517', 'cust_branch', 'general', '519'),
('1034', '517', 'customer', 'general', '532'),
('1035', '518', 'cust_branch', 'general', '520'),
('1036', '518', 'customer', 'general', '533'),
('1037', '519', 'cust_branch', 'general', '521'),
('1038', '519', 'customer', 'general', '534'),
('1039', '520', 'cust_branch', 'general', '522'),
('1040', '520', 'customer', 'general', '535'),
('1041', '521', 'cust_branch', 'general', '523'),
('1042', '521', 'customer', 'general', '536'),
('1043', '522', 'cust_branch', 'general', '524'),
('1044', '522', 'customer', 'general', '537'),
('1045', '523', 'cust_branch', 'general', '525'),
('1046', '523', 'customer', 'general', '538'),
('1047', '524', 'cust_branch', 'general', '526'),
('1048', '524', 'customer', 'general', '539'),
('1049', '525', 'cust_branch', 'general', '527'),
('1050', '525', 'customer', 'general', '540'),
('1051', '526', 'cust_branch', 'general', '528'),
('1052', '526', 'customer', 'general', '541'),
('1053', '527', 'cust_branch', 'general', '529'),
('1054', '527', 'customer', 'general', '542'),
('1055', '528', 'cust_branch', 'general', '530'),
('1056', '528', 'customer', 'general', '543'),
('1057', '529', 'cust_branch', 'general', '531'),
('1058', '529', 'customer', 'general', '544'),
('1059', '530', 'cust_branch', 'general', '532'),
('1060', '530', 'customer', 'general', '545'),
('1061', '531', 'cust_branch', 'general', '533'),
('1062', '531', 'customer', 'general', '546'),
('1063', '532', 'cust_branch', 'general', '534'),
('1064', '532', 'customer', 'general', '547'),
('1065', '533', 'cust_branch', 'general', '535'),
('1066', '533', 'customer', 'general', '548'),
('1067', '534', 'cust_branch', 'general', '536'),
('1068', '534', 'customer', 'general', '549'),
('1069', '535', 'cust_branch', 'general', '537'),
('1070', '535', 'customer', 'general', '550'),
('1071', '536', 'cust_branch', 'general', '538'),
('1072', '536', 'customer', 'general', '551'),
('1073', '537', 'cust_branch', 'general', '539'),
('1074', '537', 'customer', 'general', '552'),
('1075', '538', 'cust_branch', 'general', '540'),
('1076', '538', 'customer', 'general', '553'),
('1077', '539', 'cust_branch', 'general', '541'),
('1078', '539', 'customer', 'general', '554'),
('1079', '540', 'cust_branch', 'general', '542'),
('1080', '540', 'customer', 'general', '555'),
('1081', '541', 'cust_branch', 'general', '543'),
('1082', '541', 'customer', 'general', '556'),
('1083', '542', 'cust_branch', 'general', '544'),
('1084', '542', 'customer', 'general', '557'),
('1085', '543', 'cust_branch', 'general', '545'),
('1086', '543', 'customer', 'general', '558'),
('1087', '544', 'cust_branch', 'general', '546'),
('1088', '544', 'customer', 'general', '559'),
('1089', '545', 'cust_branch', 'general', '547'),
('1090', '545', 'customer', 'general', '560'),
('1091', '546', 'cust_branch', 'general', '548'),
('1092', '546', 'customer', 'general', '561'),
('1093', '547', 'cust_branch', 'general', '549'),
('1094', '547', 'customer', 'general', '562'),
('1095', '548', 'cust_branch', 'general', '550'),
('1096', '548', 'customer', 'general', '563'),
('1097', '549', 'cust_branch', 'general', '551'),
('1098', '549', 'customer', 'general', '564'),
('1099', '550', 'cust_branch', 'general', '552'),
('1100', '550', 'customer', 'general', '565'),
('1101', '551', 'cust_branch', 'general', '553'),
('1102', '551', 'customer', 'general', '566'),
('1103', '552', 'cust_branch', 'general', '554'),
('1104', '552', 'customer', 'general', '567'),
('1105', '553', 'cust_branch', 'general', '555'),
('1106', '553', 'customer', 'general', '568'),
('1107', '554', 'cust_branch', 'general', '556'),
('1108', '554', 'customer', 'general', '569');
INSERT INTO `0_crm_contacts` VALUES
('1109', '555', 'cust_branch', 'general', '557'),
('1110', '555', 'customer', 'general', '570'),
('1111', '556', 'cust_branch', 'general', '558'),
('1112', '556', 'customer', 'general', '571'),
('1113', '557', 'cust_branch', 'general', '559'),
('1114', '557', 'customer', 'general', '572'),
('1115', '558', 'cust_branch', 'general', '560'),
('1116', '558', 'customer', 'general', '573'),
('1117', '559', 'cust_branch', 'general', '561'),
('1118', '559', 'customer', 'general', '574'),
('1119', '560', 'cust_branch', 'general', '562'),
('1120', '560', 'customer', 'general', '575'),
('1121', '561', 'cust_branch', 'general', '563'),
('1122', '561', 'customer', 'general', '576'),
('1123', '562', 'cust_branch', 'general', '564'),
('1124', '562', 'customer', 'general', '577'),
('1125', '563', 'cust_branch', 'general', '565'),
('1126', '563', 'customer', 'general', '578'),
('1127', '564', 'cust_branch', 'general', '566'),
('1128', '564', 'customer', 'general', '579'),
('1129', '565', 'cust_branch', 'general', '567'),
('1130', '565', 'customer', 'general', '580'),
('1131', '566', 'cust_branch', 'general', '568'),
('1132', '566', 'customer', 'general', '581'),
('1133', '567', 'cust_branch', 'general', '569'),
('1134', '567', 'customer', 'general', '582'),
('1135', '568', 'cust_branch', 'general', '570'),
('1136', '568', 'customer', 'general', '583'),
('1137', '569', 'cust_branch', 'general', '571'),
('1138', '569', 'customer', 'general', '584'),
('1139', '570', 'cust_branch', 'general', '572'),
('1140', '570', 'customer', 'general', '585'),
('1141', '571', 'cust_branch', 'general', '573'),
('1142', '571', 'customer', 'general', '586'),
('1143', '572', 'cust_branch', 'general', '574'),
('1144', '572', 'customer', 'general', '587'),
('1145', '573', 'cust_branch', 'general', '575'),
('1146', '573', 'customer', 'general', '588'),
('1147', '574', 'cust_branch', 'general', '576'),
('1148', '574', 'customer', 'general', '589'),
('1149', '575', 'cust_branch', 'general', '577'),
('1150', '575', 'customer', 'general', '590'),
('1151', '576', 'cust_branch', 'general', '578'),
('1152', '576', 'customer', 'general', '591'),
('1153', '577', 'cust_branch', 'general', '579'),
('1154', '577', 'customer', 'general', '592'),
('1155', '578', 'cust_branch', 'general', '580'),
('1156', '578', 'customer', 'general', '593'),
('1157', '579', 'cust_branch', 'general', '581'),
('1158', '579', 'customer', 'general', '594'),
('1159', '580', 'cust_branch', 'general', '582'),
('1160', '580', 'customer', 'general', '595'),
('1161', '581', 'cust_branch', 'general', '583'),
('1162', '581', 'customer', 'general', '596'),
('1163', '582', 'cust_branch', 'general', '584'),
('1164', '582', 'customer', 'general', '597'),
('1165', '583', 'cust_branch', 'general', '585'),
('1166', '583', 'customer', 'general', '598'),
('1167', '584', 'cust_branch', 'general', '586'),
('1168', '584', 'customer', 'general', '599'),
('1169', '585', 'cust_branch', 'general', '587'),
('1170', '585', 'customer', 'general', '600'),
('1171', '586', 'cust_branch', 'general', '588'),
('1172', '586', 'customer', 'general', '601'),
('1173', '587', 'cust_branch', 'general', '589'),
('1174', '587', 'customer', 'general', '602'),
('1175', '588', 'cust_branch', 'general', '590'),
('1176', '588', 'customer', 'general', '603'),
('1177', '589', 'cust_branch', 'general', '591'),
('1178', '589', 'customer', 'general', '604'),
('1179', '590', 'cust_branch', 'general', '592'),
('1180', '590', 'customer', 'general', '605'),
('1181', '591', 'cust_branch', 'general', '593'),
('1182', '591', 'customer', 'general', '606'),
('1183', '592', 'cust_branch', 'general', '594'),
('1184', '592', 'customer', 'general', '607'),
('1185', '593', 'cust_branch', 'general', '595'),
('1186', '593', 'customer', 'general', '608'),
('1187', '594', 'cust_branch', 'general', '596'),
('1188', '594', 'customer', 'general', '609'),
('1189', '595', 'cust_branch', 'general', '597'),
('1190', '595', 'customer', 'general', '610'),
('1191', '596', 'cust_branch', 'general', '598'),
('1192', '596', 'customer', 'general', '611'),
('1193', '597', 'cust_branch', 'general', '599'),
('1194', '597', 'customer', 'general', '612'),
('1195', '598', 'cust_branch', 'general', '600'),
('1196', '598', 'customer', 'general', '613'),
('1197', '599', 'cust_branch', 'general', '601'),
('1198', '599', 'customer', 'general', '614'),
('1199', '600', 'cust_branch', 'general', '602'),
('1200', '600', 'customer', 'general', '615'),
('1201', '601', 'cust_branch', 'general', '603'),
('1202', '601', 'customer', 'general', '616'),
('1203', '602', 'cust_branch', 'general', '604'),
('1204', '602', 'customer', 'general', '617'),
('1205', '603', 'cust_branch', 'general', '605'),
('1206', '603', 'customer', 'general', '618'),
('1207', '604', 'cust_branch', 'general', '606'),
('1208', '604', 'customer', 'general', '619'),
('1209', '605', 'cust_branch', 'general', '607'),
('1210', '605', 'customer', 'general', '620'),
('1211', '606', 'cust_branch', 'general', '608'),
('1212', '606', 'customer', 'general', '621'),
('1213', '607', 'cust_branch', 'general', '609'),
('1214', '607', 'customer', 'general', '622'),
('1215', '608', 'cust_branch', 'general', '610'),
('1216', '608', 'customer', 'general', '623'),
('1217', '609', 'cust_branch', 'general', '611'),
('1218', '609', 'customer', 'general', '624'),
('1219', '610', 'cust_branch', 'general', '612'),
('1220', '610', 'customer', 'general', '625'),
('1221', '611', 'cust_branch', 'general', '613'),
('1222', '611', 'customer', 'general', '626'),
('1223', '612', 'cust_branch', 'general', '614'),
('1224', '612', 'customer', 'general', '627'),
('1225', '613', 'cust_branch', 'general', '615'),
('1226', '613', 'customer', 'general', '628'),
('1227', '614', 'cust_branch', 'general', '616'),
('1228', '614', 'customer', 'general', '629'),
('1229', '615', 'cust_branch', 'general', '617'),
('1230', '615', 'customer', 'general', '630'),
('1231', '616', 'cust_branch', 'general', '618'),
('1232', '616', 'customer', 'general', '631'),
('1233', '617', 'cust_branch', 'general', '619'),
('1234', '617', 'customer', 'general', '632'),
('1235', '618', 'cust_branch', 'general', '620'),
('1236', '618', 'customer', 'general', '633'),
('1237', '619', 'cust_branch', 'general', '621'),
('1238', '619', 'customer', 'general', '634'),
('1239', '620', 'cust_branch', 'general', '622'),
('1240', '620', 'customer', 'general', '635'),
('1241', '621', 'cust_branch', 'general', '623'),
('1242', '621', 'customer', 'general', '636'),
('1243', '622', 'cust_branch', 'general', '624'),
('1244', '622', 'customer', 'general', '637'),
('1245', '623', 'cust_branch', 'general', '625'),
('1246', '623', 'customer', 'general', '638'),
('1247', '624', 'cust_branch', 'general', '626'),
('1248', '624', 'customer', 'general', '639'),
('1249', '625', 'cust_branch', 'general', '627'),
('1250', '625', 'customer', 'general', '640'),
('1251', '626', 'cust_branch', 'general', '628'),
('1252', '626', 'customer', 'general', '641'),
('1253', '627', 'cust_branch', 'general', '629'),
('1254', '627', 'customer', 'general', '642'),
('1255', '628', 'cust_branch', 'general', '630'),
('1256', '628', 'customer', 'general', '643'),
('1257', '629', 'cust_branch', 'general', '631'),
('1258', '629', 'customer', 'general', '644'),
('1259', '630', 'cust_branch', 'general', '632'),
('1260', '630', 'customer', 'general', '645'),
('1261', '631', 'cust_branch', 'general', '633'),
('1262', '631', 'customer', 'general', '646'),
('1263', '632', 'cust_branch', 'general', '634'),
('1264', '632', 'customer', 'general', '647'),
('1265', '633', 'cust_branch', 'general', '635'),
('1266', '633', 'customer', 'general', '648'),
('1267', '634', 'cust_branch', 'general', '636'),
('1268', '634', 'customer', 'general', '649'),
('1269', '635', 'cust_branch', 'general', '637'),
('1270', '635', 'customer', 'general', '650'),
('1271', '636', 'cust_branch', 'general', '638'),
('1272', '636', 'customer', 'general', '651'),
('1273', '637', 'cust_branch', 'general', '639'),
('1274', '637', 'customer', 'general', '652'),
('1275', '638', 'cust_branch', 'general', '640'),
('1276', '638', 'customer', 'general', '653'),
('1277', '639', 'cust_branch', 'general', '641'),
('1278', '639', 'customer', 'general', '654'),
('1279', '640', 'cust_branch', 'general', '642'),
('1280', '640', 'customer', 'general', '655'),
('1281', '641', 'cust_branch', 'general', '643'),
('1282', '641', 'customer', 'general', '656'),
('1283', '642', 'cust_branch', 'general', '644'),
('1284', '642', 'customer', 'general', '657'),
('1285', '643', 'cust_branch', 'general', '645'),
('1286', '643', 'customer', 'general', '658'),
('1287', '644', 'cust_branch', 'general', '646'),
('1288', '644', 'customer', 'general', '659'),
('1289', '645', 'cust_branch', 'general', '647'),
('1290', '645', 'customer', 'general', '660'),
('1291', '646', 'cust_branch', 'general', '648'),
('1292', '646', 'customer', 'general', '661'),
('1293', '647', 'cust_branch', 'general', '649'),
('1294', '647', 'customer', 'general', '662'),
('1295', '648', 'cust_branch', 'general', '650'),
('1296', '648', 'customer', 'general', '663'),
('1297', '649', 'cust_branch', 'general', '651'),
('1298', '649', 'customer', 'general', '664'),
('1299', '650', 'cust_branch', 'general', '652'),
('1300', '650', 'customer', 'general', '665'),
('1301', '651', 'cust_branch', 'general', '653'),
('1302', '651', 'customer', 'general', '666'),
('1303', '652', 'cust_branch', 'general', '654'),
('1304', '652', 'customer', 'general', '667'),
('1305', '653', 'cust_branch', 'general', '655'),
('1306', '653', 'customer', 'general', '668'),
('1307', '654', 'cust_branch', 'general', '656'),
('1308', '654', 'customer', 'general', '669'),
('1309', '655', 'cust_branch', 'general', '657'),
('1310', '655', 'customer', 'general', '670'),
('1311', '656', 'cust_branch', 'general', '658'),
('1312', '656', 'customer', 'general', '671'),
('1313', '657', 'cust_branch', 'general', '659'),
('1314', '657', 'customer', 'general', '672'),
('1315', '658', 'cust_branch', 'general', '660'),
('1316', '658', 'customer', 'general', '673'),
('1317', '659', 'cust_branch', 'general', '661'),
('1318', '659', 'customer', 'general', '674'),
('1319', '660', 'cust_branch', 'general', '662'),
('1320', '660', 'customer', 'general', '675'),
('1321', '661', 'cust_branch', 'general', '663'),
('1322', '661', 'customer', 'general', '676'),
('1323', '662', 'cust_branch', 'general', '664'),
('1324', '662', 'customer', 'general', '677'),
('1325', '663', 'cust_branch', 'general', '665'),
('1326', '663', 'customer', 'general', '678'),
('1327', '664', 'cust_branch', 'general', '666'),
('1328', '664', 'customer', 'general', '679'),
('1329', '665', 'cust_branch', 'general', '667'),
('1330', '665', 'customer', 'general', '680'),
('1331', '666', 'cust_branch', 'general', '668'),
('1332', '666', 'customer', 'general', '681'),
('1333', '667', 'cust_branch', 'general', '669'),
('1334', '667', 'customer', 'general', '682'),
('1335', '668', 'cust_branch', 'general', '670'),
('1336', '668', 'customer', 'general', '683'),
('1337', '669', 'cust_branch', 'general', '671'),
('1338', '669', 'customer', 'general', '684'),
('1339', '670', 'cust_branch', 'general', '672'),
('1340', '670', 'customer', 'general', '685'),
('1341', '671', 'cust_branch', 'general', '673'),
('1342', '671', 'customer', 'general', '686'),
('1343', '672', 'cust_branch', 'general', '674'),
('1344', '672', 'customer', 'general', '687'),
('1345', '673', 'cust_branch', 'general', '675'),
('1346', '673', 'customer', 'general', '688'),
('1347', '674', 'cust_branch', 'general', '676'),
('1348', '674', 'customer', 'general', '689'),
('1349', '675', 'cust_branch', 'general', '677'),
('1350', '675', 'customer', 'general', '690'),
('1351', '676', 'cust_branch', 'general', '678'),
('1352', '676', 'customer', 'general', '691'),
('1353', '677', 'cust_branch', 'general', '679'),
('1354', '677', 'customer', 'general', '692'),
('1355', '678', 'cust_branch', 'general', '680'),
('1356', '678', 'customer', 'general', '693'),
('1357', '679', 'cust_branch', 'general', '681'),
('1358', '679', 'customer', 'general', '694'),
('1359', '680', 'cust_branch', 'general', '682'),
('1360', '680', 'customer', 'general', '695'),
('1361', '681', 'cust_branch', 'general', '683'),
('1362', '681', 'customer', 'general', '696'),
('1363', '682', 'cust_branch', 'general', '684'),
('1364', '682', 'customer', 'general', '697'),
('1365', '683', 'cust_branch', 'general', '685'),
('1366', '683', 'customer', 'general', '698'),
('1367', '684', 'cust_branch', 'general', '686'),
('1368', '684', 'customer', 'general', '699'),
('1369', '685', 'cust_branch', 'general', '687'),
('1370', '685', 'customer', 'general', '700'),
('1371', '686', 'cust_branch', 'general', '688'),
('1372', '686', 'customer', 'general', '701'),
('1373', '687', 'cust_branch', 'general', '689'),
('1374', '687', 'customer', 'general', '702'),
('1375', '688', 'cust_branch', 'general', '690'),
('1376', '688', 'customer', 'general', '703'),
('1377', '689', 'cust_branch', 'general', '691'),
('1378', '689', 'customer', 'general', '704'),
('1379', '690', 'cust_branch', 'general', '692'),
('1380', '690', 'customer', 'general', '705'),
('1381', '691', 'cust_branch', 'general', '693'),
('1382', '691', 'customer', 'general', '706'),
('1383', '692', 'cust_branch', 'general', '694'),
('1384', '692', 'customer', 'general', '707'),
('1385', '693', 'cust_branch', 'general', '695'),
('1386', '693', 'customer', 'general', '708'),
('1387', '694', 'cust_branch', 'general', '696'),
('1388', '694', 'customer', 'general', '709'),
('1389', '695', 'cust_branch', 'general', '697'),
('1390', '695', 'customer', 'general', '710'),
('1391', '696', 'cust_branch', 'general', '698'),
('1392', '696', 'customer', 'general', '711'),
('1393', '697', 'cust_branch', 'general', '699'),
('1394', '697', 'customer', 'general', '712'),
('1395', '698', 'cust_branch', 'general', '700'),
('1396', '698', 'customer', 'general', '713'),
('1397', '699', 'cust_branch', 'general', '701'),
('1398', '699', 'customer', 'general', '714'),
('1399', '700', 'cust_branch', 'general', '702'),
('1400', '700', 'customer', 'general', '715'),
('1401', '701', 'cust_branch', 'general', '703'),
('1402', '701', 'customer', 'general', '716'),
('1403', '702', 'cust_branch', 'general', '704'),
('1404', '702', 'customer', 'general', '717'),
('1405', '703', 'cust_branch', 'general', '705'),
('1406', '703', 'customer', 'general', '718'),
('1407', '704', 'cust_branch', 'general', '706'),
('1408', '704', 'customer', 'general', '719'),
('1409', '705', 'cust_branch', 'general', '707'),
('1410', '705', 'customer', 'general', '720'),
('1411', '706', 'cust_branch', 'general', '708'),
('1412', '706', 'customer', 'general', '721'),
('1413', '707', 'cust_branch', 'general', '709'),
('1414', '707', 'customer', 'general', '722'),
('1415', '708', 'cust_branch', 'general', '710'),
('1416', '708', 'customer', 'general', '723'),
('1417', '709', 'cust_branch', 'general', '711'),
('1418', '709', 'customer', 'general', '724'),
('1419', '710', 'cust_branch', 'general', '712'),
('1420', '710', 'customer', 'general', '725'),
('1421', '711', 'cust_branch', 'general', '713'),
('1422', '711', 'customer', 'general', '726'),
('1423', '712', 'cust_branch', 'general', '714'),
('1424', '712', 'customer', 'general', '727'),
('1425', '713', 'cust_branch', 'general', '715'),
('1426', '713', 'customer', 'general', '728'),
('1427', '714', 'cust_branch', 'general', '716'),
('1428', '714', 'customer', 'general', '729'),
('1429', '715', 'cust_branch', 'general', '717'),
('1430', '715', 'customer', 'general', '730'),
('1431', '716', 'cust_branch', 'general', '718'),
('1432', '716', 'customer', 'general', '731'),
('1433', '717', 'cust_branch', 'general', '719'),
('1434', '717', 'customer', 'general', '732'),
('1435', '718', 'cust_branch', 'general', '720'),
('1436', '718', 'customer', 'general', '733'),
('1437', '719', 'cust_branch', 'general', '721'),
('1438', '719', 'customer', 'general', '734'),
('1439', '720', 'cust_branch', 'general', '722'),
('1440', '720', 'customer', 'general', '735'),
('1441', '721', 'cust_branch', 'general', '723'),
('1442', '721', 'customer', 'general', '736'),
('1443', '722', 'cust_branch', 'general', '724'),
('1444', '722', 'customer', 'general', '737'),
('1445', '723', 'cust_branch', 'general', '725'),
('1446', '723', 'customer', 'general', '738'),
('1447', '724', 'cust_branch', 'general', '726'),
('1448', '724', 'customer', 'general', '739'),
('1449', '725', 'cust_branch', 'general', '727'),
('1450', '725', 'customer', 'general', '740'),
('1451', '726', 'cust_branch', 'general', '728'),
('1452', '726', 'customer', 'general', '741'),
('1453', '727', 'cust_branch', 'general', '729'),
('1454', '727', 'customer', 'general', '742'),
('1455', '728', 'cust_branch', 'general', '730'),
('1456', '728', 'customer', 'general', '743'),
('1457', '729', 'cust_branch', 'general', '731'),
('1458', '729', 'customer', 'general', '744'),
('1459', '730', 'cust_branch', 'general', '732'),
('1460', '730', 'customer', 'general', '745'),
('1461', '731', 'cust_branch', 'general', '733'),
('1462', '731', 'customer', 'general', '746'),
('1463', '732', 'cust_branch', 'general', '734'),
('1464', '732', 'customer', 'general', '747'),
('1465', '733', 'cust_branch', 'general', '735'),
('1466', '733', 'customer', 'general', '748'),
('1467', '734', 'cust_branch', 'general', '736'),
('1468', '734', 'customer', 'general', '749'),
('1469', '735', 'cust_branch', 'general', '737'),
('1470', '735', 'customer', 'general', '750'),
('1471', '736', 'cust_branch', 'general', '738'),
('1472', '736', 'customer', 'general', '751'),
('1473', '737', 'cust_branch', 'general', '739'),
('1474', '737', 'customer', 'general', '752'),
('1475', '738', 'cust_branch', 'general', '740'),
('1476', '738', 'customer', 'general', '753'),
('1477', '739', 'cust_branch', 'general', '741'),
('1478', '739', 'customer', 'general', '754'),
('1479', '740', 'cust_branch', 'general', '742'),
('1480', '740', 'customer', 'general', '755'),
('1481', '741', 'cust_branch', 'general', '743'),
('1482', '741', 'customer', 'general', '756'),
('1483', '742', 'cust_branch', 'general', '744'),
('1484', '742', 'customer', 'general', '757'),
('1485', '743', 'cust_branch', 'general', '745'),
('1486', '743', 'customer', 'general', '758'),
('1487', '744', 'cust_branch', 'general', '746'),
('1488', '744', 'customer', 'general', '759'),
('1489', '745', 'cust_branch', 'general', '747'),
('1490', '745', 'customer', 'general', '760'),
('1491', '746', 'cust_branch', 'general', '748'),
('1492', '746', 'customer', 'general', '761'),
('1493', '747', 'cust_branch', 'general', '749'),
('1494', '747', 'customer', 'general', '762'),
('1495', '748', 'cust_branch', 'general', '750'),
('1496', '748', 'customer', 'general', '763'),
('1497', '749', 'cust_branch', 'general', '751'),
('1498', '749', 'customer', 'general', '764'),
('1499', '750', 'cust_branch', 'general', '752'),
('1500', '750', 'customer', 'general', '765'),
('1501', '751', 'cust_branch', 'general', '753'),
('1502', '751', 'customer', 'general', '766'),
('1503', '752', 'cust_branch', 'general', '754'),
('1504', '752', 'customer', 'general', '767'),
('1505', '753', 'cust_branch', 'general', '755'),
('1506', '753', 'customer', 'general', '768'),
('1507', '754', 'cust_branch', 'general', '756'),
('1508', '754', 'customer', 'general', '769'),
('1509', '755', 'cust_branch', 'general', '757'),
('1510', '755', 'customer', 'general', '770'),
('1511', '756', 'cust_branch', 'general', '758'),
('1512', '756', 'customer', 'general', '771'),
('1513', '757', 'cust_branch', 'general', '759'),
('1514', '757', 'customer', 'general', '772'),
('1515', '758', 'cust_branch', 'general', '760'),
('1516', '758', 'customer', 'general', '773'),
('1517', '759', 'cust_branch', 'general', '761'),
('1518', '759', 'customer', 'general', '774'),
('1519', '760', 'cust_branch', 'general', '762'),
('1520', '760', 'customer', 'general', '775'),
('1521', '761', 'cust_branch', 'general', '763'),
('1522', '761', 'customer', 'general', '776'),
('1523', '762', 'cust_branch', 'general', '764'),
('1524', '762', 'customer', 'general', '777'),
('1525', '763', 'cust_branch', 'general', '765'),
('1526', '763', 'customer', 'general', '778'),
('1527', '764', 'cust_branch', 'general', '766'),
('1528', '764', 'customer', 'general', '779'),
('1529', '765', 'cust_branch', 'general', '767'),
('1530', '765', 'customer', 'general', '780'),
('1531', '766', 'cust_branch', 'general', '768'),
('1532', '766', 'customer', 'general', '781'),
('1533', '767', 'cust_branch', 'general', '769'),
('1534', '767', 'customer', 'general', '782'),
('1535', '768', 'cust_branch', 'general', '770'),
('1536', '768', 'customer', 'general', '783'),
('1537', '769', 'cust_branch', 'general', '771'),
('1538', '769', 'customer', 'general', '784'),
('1539', '770', 'cust_branch', 'general', '772'),
('1540', '770', 'customer', 'general', '785'),
('1541', '771', 'cust_branch', 'general', '773'),
('1542', '771', 'customer', 'general', '786'),
('1543', '772', 'cust_branch', 'general', '774'),
('1544', '772', 'customer', 'general', '787'),
('1545', '773', 'cust_branch', 'general', '775'),
('1546', '773', 'customer', 'general', '788'),
('1547', '774', 'cust_branch', 'general', '776'),
('1548', '774', 'customer', 'general', '789'),
('1549', '775', 'cust_branch', 'general', '777'),
('1550', '775', 'customer', 'general', '790'),
('1551', '776', 'cust_branch', 'general', '778'),
('1552', '776', 'customer', 'general', '791'),
('1553', '777', 'cust_branch', 'general', '779'),
('1554', '777', 'customer', 'general', '792'),
('1555', '778', 'cust_branch', 'general', '780'),
('1556', '778', 'customer', 'general', '793'),
('1557', '779', 'cust_branch', 'general', '781'),
('1558', '779', 'customer', 'general', '794'),
('1559', '780', 'cust_branch', 'general', '782'),
('1560', '780', 'customer', 'general', '795'),
('1561', '781', 'cust_branch', 'general', '783'),
('1562', '781', 'customer', 'general', '796'),
('1563', '782', 'cust_branch', 'general', '784'),
('1564', '782', 'customer', 'general', '797'),
('1565', '783', 'cust_branch', 'general', '785'),
('1566', '783', 'customer', 'general', '798'),
('1567', '784', 'cust_branch', 'general', '786'),
('1568', '784', 'customer', 'general', '799'),
('1569', '785', 'cust_branch', 'general', '787'),
('1570', '785', 'customer', 'general', '800'),
('1571', '786', 'cust_branch', 'general', '788'),
('1572', '786', 'customer', 'general', '801'),
('1573', '787', 'cust_branch', 'general', '789'),
('1574', '787', 'customer', 'general', '802'),
('1575', '788', 'cust_branch', 'general', '790'),
('1576', '788', 'customer', 'general', '803'),
('1577', '789', 'cust_branch', 'general', '791'),
('1578', '789', 'customer', 'general', '804'),
('1579', '790', 'cust_branch', 'general', '792'),
('1580', '790', 'customer', 'general', '805'),
('1581', '791', 'cust_branch', 'general', '793'),
('1582', '791', 'customer', 'general', '806'),
('1583', '792', 'cust_branch', 'general', '794'),
('1584', '792', 'customer', 'general', '807'),
('1585', '793', 'cust_branch', 'general', '795'),
('1586', '793', 'customer', 'general', '808'),
('1587', '794', 'cust_branch', 'general', '796'),
('1588', '794', 'customer', 'general', '809'),
('1589', '795', 'cust_branch', 'general', '797'),
('1590', '795', 'customer', 'general', '810'),
('1591', '796', 'cust_branch', 'general', '798'),
('1592', '796', 'customer', 'general', '811'),
('1593', '797', 'cust_branch', 'general', '799'),
('1594', '797', 'customer', 'general', '812'),
('1595', '798', 'cust_branch', 'general', '800'),
('1596', '798', 'customer', 'general', '813'),
('1597', '799', 'cust_branch', 'general', '801'),
('1598', '799', 'customer', 'general', '814'),
('1599', '800', 'cust_branch', 'general', '802'),
('1600', '800', 'customer', 'general', '815'),
('1601', '801', 'cust_branch', 'general', '803'),
('1602', '801', 'customer', 'general', '816'),
('1603', '802', 'cust_branch', 'general', '804'),
('1604', '802', 'customer', 'general', '817'),
('1605', '803', 'cust_branch', 'general', '805'),
('1606', '803', 'customer', 'general', '818'),
('1607', '804', 'cust_branch', 'general', '806'),
('1608', '804', 'customer', 'general', '819'),
('1609', '805', 'cust_branch', 'general', '807'),
('1610', '805', 'customer', 'general', '820'),
('1611', '806', 'cust_branch', 'general', '808'),
('1612', '806', 'customer', 'general', '821'),
('1613', '807', 'cust_branch', 'general', '809'),
('1614', '807', 'customer', 'general', '822'),
('1615', '808', 'cust_branch', 'general', '810'),
('1616', '808', 'customer', 'general', '823'),
('1617', '809', 'cust_branch', 'general', '811'),
('1618', '809', 'customer', 'general', '824'),
('1619', '810', 'cust_branch', 'general', '812'),
('1620', '810', 'customer', 'general', '825'),
('1621', '811', 'cust_branch', 'general', '813'),
('1622', '811', 'customer', 'general', '826'),
('1623', '812', 'cust_branch', 'general', '814'),
('1624', '812', 'customer', 'general', '827'),
('1625', '813', 'cust_branch', 'general', '815'),
('1626', '813', 'customer', 'general', '828'),
('1627', '814', 'cust_branch', 'general', '816'),
('1628', '814', 'customer', 'general', '829'),
('1629', '815', 'cust_branch', 'general', '817'),
('1630', '815', 'customer', 'general', '830'),
('1631', '816', 'cust_branch', 'general', '818'),
('1632', '816', 'customer', 'general', '831'),
('1633', '817', 'cust_branch', 'general', '819'),
('1634', '817', 'customer', 'general', '832'),
('1635', '818', 'cust_branch', 'general', '820'),
('1636', '818', 'customer', 'general', '833'),
('1637', '819', 'cust_branch', 'general', '821'),
('1638', '819', 'customer', 'general', '834'),
('1639', '820', 'cust_branch', 'general', '822'),
('1640', '820', 'customer', 'general', '835'),
('1641', '821', 'cust_branch', 'general', '823'),
('1642', '821', 'customer', 'general', '836'),
('1643', '822', 'cust_branch', 'general', '824'),
('1644', '822', 'customer', 'general', '837'),
('1645', '823', 'cust_branch', 'general', '825'),
('1646', '823', 'customer', 'general', '838'),
('1647', '824', 'cust_branch', 'general', '826'),
('1648', '824', 'customer', 'general', '839'),
('1649', '825', 'cust_branch', 'general', '827'),
('1650', '825', 'customer', 'general', '840'),
('1651', '826', 'cust_branch', 'general', '828'),
('1652', '826', 'customer', 'general', '841'),
('1653', '827', 'cust_branch', 'general', '829'),
('1654', '827', 'customer', 'general', '842'),
('1655', '828', 'cust_branch', 'general', '830'),
('1656', '828', 'customer', 'general', '843'),
('1657', '829', 'cust_branch', 'general', '831'),
('1658', '829', 'customer', 'general', '844'),
('1659', '830', 'cust_branch', 'general', '832'),
('1660', '830', 'customer', 'general', '845'),
('1661', '831', 'cust_branch', 'general', '833'),
('1662', '831', 'customer', 'general', '846'),
('1663', '832', 'cust_branch', 'general', '834'),
('1664', '832', 'customer', 'general', '847'),
('1665', '833', 'cust_branch', 'general', '835'),
('1666', '833', 'customer', 'general', '848'),
('1667', '834', 'cust_branch', 'general', '836'),
('1668', '834', 'customer', 'general', '849'),
('1669', '835', 'cust_branch', 'general', '837'),
('1670', '835', 'customer', 'general', '850'),
('1671', '836', 'cust_branch', 'general', '838'),
('1672', '836', 'customer', 'general', '851'),
('1673', '837', 'cust_branch', 'general', '839'),
('1674', '837', 'customer', 'general', '852'),
('1675', '838', 'cust_branch', 'general', '840'),
('1676', '838', 'customer', 'general', '853'),
('1677', '839', 'cust_branch', 'general', '841'),
('1678', '839', 'customer', 'general', '854'),
('1679', '840', 'cust_branch', 'general', '842'),
('1680', '840', 'customer', 'general', '855'),
('1681', '841', 'cust_branch', 'general', '843'),
('1682', '841', 'customer', 'general', '856'),
('1683', '842', 'cust_branch', 'general', '844'),
('1684', '842', 'customer', 'general', '857'),
('1685', '843', 'cust_branch', 'general', '845'),
('1686', '843', 'customer', 'general', '858'),
('1687', '844', 'cust_branch', 'general', '846'),
('1688', '844', 'customer', 'general', '859'),
('1689', '845', 'cust_branch', 'general', '847'),
('1690', '845', 'customer', 'general', '860'),
('1691', '846', 'cust_branch', 'general', '848'),
('1692', '846', 'customer', 'general', '861'),
('1693', '847', 'cust_branch', 'general', '849'),
('1694', '847', 'customer', 'general', '862'),
('1695', '848', 'cust_branch', 'general', '850'),
('1696', '848', 'customer', 'general', '863'),
('1697', '849', 'cust_branch', 'general', '851'),
('1698', '849', 'customer', 'general', '864'),
('1699', '850', 'cust_branch', 'general', '852'),
('1700', '850', 'customer', 'general', '865'),
('1701', '851', 'cust_branch', 'general', '853'),
('1702', '851', 'customer', 'general', '866'),
('1703', '852', 'cust_branch', 'general', '854'),
('1704', '852', 'customer', 'general', '867'),
('1705', '853', 'cust_branch', 'general', '855'),
('1706', '853', 'customer', 'general', '868'),
('1707', '854', 'cust_branch', 'general', '856'),
('1708', '854', 'customer', 'general', '869'),
('1709', '855', 'cust_branch', 'general', '857'),
('1710', '855', 'customer', 'general', '870'),
('1711', '856', 'cust_branch', 'general', '858'),
('1712', '856', 'customer', 'general', '871'),
('1713', '857', 'cust_branch', 'general', '859'),
('1714', '857', 'customer', 'general', '872'),
('1715', '858', 'cust_branch', 'general', '860'),
('1716', '858', 'customer', 'general', '873'),
('1717', '859', 'cust_branch', 'general', '861'),
('1718', '859', 'customer', 'general', '874'),
('1719', '860', 'cust_branch', 'general', '862'),
('1720', '860', 'customer', 'general', '875'),
('1721', '861', 'cust_branch', 'general', '863'),
('1722', '861', 'customer', 'general', '876'),
('1723', '862', 'cust_branch', 'general', '864'),
('1724', '862', 'customer', 'general', '877'),
('1725', '863', 'cust_branch', 'general', '865'),
('1726', '863', 'customer', 'general', '878'),
('1727', '864', 'cust_branch', 'general', '866'),
('1728', '864', 'customer', 'general', '879'),
('1729', '865', 'cust_branch', 'general', '867'),
('1730', '865', 'customer', 'general', '880'),
('1731', '866', 'cust_branch', 'general', '868'),
('1732', '866', 'customer', 'general', '881'),
('1733', '867', 'cust_branch', 'general', '869'),
('1734', '867', 'customer', 'general', '882'),
('1735', '868', 'cust_branch', 'general', '870'),
('1736', '868', 'customer', 'general', '883'),
('1737', '869', 'cust_branch', 'general', '871'),
('1738', '869', 'customer', 'general', '884'),
('1739', '870', 'cust_branch', 'general', '872'),
('1740', '870', 'customer', 'general', '885'),
('1741', '871', 'cust_branch', 'general', '873'),
('1742', '871', 'customer', 'general', '886'),
('1743', '872', 'cust_branch', 'general', '874'),
('1744', '872', 'customer', 'general', '887'),
('1745', '873', 'cust_branch', 'general', '875'),
('1746', '873', 'customer', 'general', '888'),
('1747', '874', 'cust_branch', 'general', '876'),
('1748', '874', 'customer', 'general', '889'),
('1749', '875', 'cust_branch', 'general', '877'),
('1750', '875', 'customer', 'general', '890'),
('1751', '876', 'cust_branch', 'general', '878'),
('1752', '876', 'customer', 'general', '891'),
('1753', '877', 'cust_branch', 'general', '879'),
('1754', '877', 'customer', 'general', '892'),
('1755', '878', 'cust_branch', 'general', '880'),
('1756', '878', 'customer', 'general', '893'),
('1757', '879', 'cust_branch', 'general', '881'),
('1758', '879', 'customer', 'general', '894'),
('1759', '880', 'cust_branch', 'general', '882'),
('1760', '880', 'customer', 'general', '895'),
('1761', '881', 'cust_branch', 'general', '883'),
('1762', '881', 'customer', 'general', '896'),
('1763', '882', 'cust_branch', 'general', '884'),
('1764', '882', 'customer', 'general', '897'),
('1765', '883', 'cust_branch', 'general', '885'),
('1766', '883', 'customer', 'general', '898'),
('1767', '884', 'cust_branch', 'general', '886'),
('1768', '884', 'customer', 'general', '899'),
('1769', '885', 'cust_branch', 'general', '887'),
('1770', '885', 'customer', 'general', '900'),
('1771', '886', 'cust_branch', 'general', '888'),
('1772', '886', 'customer', 'general', '901'),
('1773', '887', 'cust_branch', 'general', '889'),
('1774', '887', 'customer', 'general', '902'),
('1775', '888', 'cust_branch', 'general', '890'),
('1776', '888', 'customer', 'general', '903'),
('1777', '889', 'cust_branch', 'general', '891'),
('1778', '889', 'customer', 'general', '904'),
('1779', '890', 'cust_branch', 'general', '892'),
('1780', '890', 'customer', 'general', '905'),
('1781', '891', 'cust_branch', 'general', '893'),
('1782', '891', 'customer', 'general', '906'),
('1783', '892', 'cust_branch', 'general', '894'),
('1784', '892', 'customer', 'general', '907'),
('1785', '893', 'cust_branch', 'general', '895'),
('1786', '893', 'customer', 'general', '908'),
('1787', '894', 'cust_branch', 'general', '896'),
('1788', '894', 'customer', 'general', '909'),
('1789', '895', 'cust_branch', 'general', '897'),
('1790', '895', 'customer', 'general', '910'),
('1791', '896', 'cust_branch', 'general', '898'),
('1792', '896', 'customer', 'general', '911'),
('1793', '897', 'cust_branch', 'general', '899'),
('1794', '897', 'customer', 'general', '912'),
('1795', '898', 'cust_branch', 'general', '900'),
('1796', '898', 'customer', 'general', '913'),
('1797', '899', 'cust_branch', 'general', '901'),
('1798', '899', 'customer', 'general', '914'),
('1799', '900', 'cust_branch', 'general', '902'),
('1800', '900', 'customer', 'general', '915'),
('1801', '901', 'cust_branch', 'general', '903'),
('1802', '901', 'customer', 'general', '916'),
('1803', '902', 'cust_branch', 'general', '904'),
('1804', '902', 'customer', 'general', '917'),
('1805', '903', 'cust_branch', 'general', '905'),
('1806', '903', 'customer', 'general', '918'),
('1807', '904', 'cust_branch', 'general', '906'),
('1808', '904', 'customer', 'general', '919'),
('1809', '905', 'cust_branch', 'general', '907'),
('1810', '905', 'customer', 'general', '920'),
('1811', '906', 'cust_branch', 'general', '908'),
('1812', '906', 'customer', 'general', '921'),
('1813', '907', 'cust_branch', 'general', '909'),
('1814', '907', 'customer', 'general', '922'),
('1815', '908', 'cust_branch', 'general', '910'),
('1816', '908', 'customer', 'general', '923'),
('1817', '909', 'cust_branch', 'general', '911'),
('1818', '909', 'customer', 'general', '924'),
('1819', '910', 'cust_branch', 'general', '912'),
('1820', '910', 'customer', 'general', '925'),
('1821', '911', 'cust_branch', 'general', '913'),
('1822', '911', 'customer', 'general', '926'),
('1823', '912', 'cust_branch', 'general', '914'),
('1824', '912', 'customer', 'general', '927'),
('1825', '913', 'cust_branch', 'general', '915'),
('1826', '913', 'customer', 'general', '928'),
('1827', '914', 'cust_branch', 'general', '916'),
('1828', '914', 'customer', 'general', '929'),
('1829', '915', 'cust_branch', 'general', '917'),
('1830', '915', 'customer', 'general', '930'),
('1831', '916', 'cust_branch', 'general', '918'),
('1832', '916', 'customer', 'general', '931'),
('1833', '917', 'cust_branch', 'general', '919'),
('1834', '917', 'customer', 'general', '932'),
('1835', '918', 'cust_branch', 'general', '920'),
('1836', '918', 'customer', 'general', '933'),
('1837', '919', 'cust_branch', 'general', '921'),
('1838', '919', 'customer', 'general', '934'),
('1839', '920', 'cust_branch', 'general', '922'),
('1840', '920', 'customer', 'general', '935'),
('1841', '921', 'cust_branch', 'general', '923'),
('1842', '921', 'customer', 'general', '936'),
('1843', '922', 'cust_branch', 'general', '924'),
('1844', '922', 'customer', 'general', '937'),
('1845', '923', 'cust_branch', 'general', '925'),
('1846', '923', 'customer', 'general', '938'),
('1847', '924', 'cust_branch', 'general', '926'),
('1848', '924', 'customer', 'general', '939'),
('1849', '925', 'cust_branch', 'general', '927'),
('1850', '925', 'customer', 'general', '940'),
('1851', '926', 'cust_branch', 'general', '928'),
('1852', '926', 'customer', 'general', '941'),
('1853', '927', 'cust_branch', 'general', '929'),
('1854', '927', 'customer', 'general', '942'),
('1855', '928', 'cust_branch', 'general', '930'),
('1856', '928', 'customer', 'general', '943'),
('1857', '929', 'cust_branch', 'general', '931'),
('1858', '929', 'customer', 'general', '944'),
('1859', '930', 'cust_branch', 'general', '932'),
('1860', '930', 'customer', 'general', '945'),
('1861', '931', 'cust_branch', 'general', '933'),
('1862', '931', 'customer', 'general', '946'),
('1863', '932', 'cust_branch', 'general', '934'),
('1864', '932', 'customer', 'general', '947'),
('1865', '933', 'cust_branch', 'general', '935'),
('1866', '933', 'customer', 'general', '948'),
('1867', '934', 'cust_branch', 'general', '936'),
('1868', '934', 'customer', 'general', '949'),
('1869', '935', 'cust_branch', 'general', '937'),
('1870', '935', 'customer', 'general', '950'),
('1871', '936', 'cust_branch', 'general', '938'),
('1872', '936', 'customer', 'general', '951'),
('1873', '937', 'cust_branch', 'general', '939'),
('1874', '937', 'customer', 'general', '952'),
('1875', '938', 'cust_branch', 'general', '940'),
('1876', '938', 'customer', 'general', '953'),
('1877', '939', 'cust_branch', 'general', '941'),
('1878', '939', 'customer', 'general', '954'),
('1879', '940', 'cust_branch', 'general', '942'),
('1880', '940', 'customer', 'general', '955'),
('1881', '941', 'cust_branch', 'general', '943'),
('1882', '941', 'customer', 'general', '956'),
('1883', '942', 'cust_branch', 'general', '944'),
('1884', '942', 'customer', 'general', '957'),
('1885', '943', 'cust_branch', 'general', '945'),
('1886', '943', 'customer', 'general', '958'),
('1887', '944', 'cust_branch', 'general', '946'),
('1888', '944', 'customer', 'general', '959'),
('1889', '945', 'cust_branch', 'general', '947'),
('1890', '945', 'customer', 'general', '960'),
('1891', '946', 'cust_branch', 'general', '948'),
('1892', '946', 'customer', 'general', '961'),
('1893', '947', 'cust_branch', 'general', '949'),
('1894', '947', 'customer', 'general', '962'),
('1895', '948', 'cust_branch', 'general', '950'),
('1896', '948', 'customer', 'general', '963'),
('1897', '949', 'cust_branch', 'general', '951'),
('1898', '949', 'customer', 'general', '964'),
('1899', '950', 'cust_branch', 'general', '952'),
('1900', '950', 'customer', 'general', '965'),
('1901', '951', 'cust_branch', 'general', '953'),
('1902', '951', 'customer', 'general', '966'),
('1903', '952', 'cust_branch', 'general', '954'),
('1904', '952', 'customer', 'general', '967'),
('1905', '953', 'cust_branch', 'general', '955'),
('1906', '953', 'customer', 'general', '968'),
('1907', '954', 'cust_branch', 'general', '956'),
('1908', '954', 'customer', 'general', '969'),
('1909', '955', 'cust_branch', 'general', '957'),
('1910', '955', 'customer', 'general', '970'),
('1911', '956', 'cust_branch', 'general', '958'),
('1912', '956', 'customer', 'general', '971'),
('1913', '957', 'cust_branch', 'general', '959'),
('1914', '957', 'customer', 'general', '972'),
('1915', '958', 'cust_branch', 'general', '960'),
('1916', '958', 'customer', 'general', '973'),
('1917', '959', 'cust_branch', 'general', '961'),
('1918', '959', 'customer', 'general', '974'),
('1919', '960', 'cust_branch', 'general', '962'),
('1920', '960', 'customer', 'general', '975'),
('1921', '961', 'cust_branch', 'general', '963'),
('1922', '961', 'customer', 'general', '976'),
('1923', '962', 'cust_branch', 'general', '964'),
('1924', '962', 'customer', 'general', '977'),
('1925', '963', 'cust_branch', 'general', '965'),
('1926', '963', 'customer', 'general', '978'),
('1927', '964', 'cust_branch', 'general', '966'),
('1928', '964', 'customer', 'general', '979'),
('1929', '965', 'cust_branch', 'general', '967'),
('1930', '965', 'customer', 'general', '980'),
('1931', '966', 'cust_branch', 'general', '968'),
('1932', '966', 'customer', 'general', '981'),
('1933', '967', 'cust_branch', 'general', '969'),
('1934', '967', 'customer', 'general', '982'),
('1935', '968', 'cust_branch', 'general', '970'),
('1936', '968', 'customer', 'general', '983'),
('1937', '969', 'cust_branch', 'general', '971'),
('1938', '969', 'customer', 'general', '984'),
('1939', '970', 'cust_branch', 'general', '972'),
('1940', '970', 'customer', 'general', '985'),
('1941', '971', 'cust_branch', 'general', '973'),
('1942', '971', 'customer', 'general', '986'),
('1943', '972', 'cust_branch', 'general', '974'),
('1944', '972', 'customer', 'general', '987'),
('1945', '973', 'cust_branch', 'general', '975'),
('1946', '973', 'customer', 'general', '988'),
('1947', '974', 'cust_branch', 'general', '976'),
('1948', '974', 'customer', 'general', '989'),
('1949', '975', 'cust_branch', 'general', '977'),
('1950', '975', 'customer', 'general', '990'),
('1951', '976', 'cust_branch', 'general', '978'),
('1952', '976', 'customer', 'general', '991'),
('1953', '977', 'cust_branch', 'general', '979'),
('1954', '977', 'customer', 'general', '992'),
('1955', '978', 'cust_branch', 'general', '980'),
('1956', '978', 'customer', 'general', '993'),
('1957', '979', 'cust_branch', 'general', '981'),
('1958', '979', 'customer', 'general', '994'),
('1959', '980', 'cust_branch', 'general', '982'),
('1960', '980', 'customer', 'general', '995'),
('1961', '981', 'cust_branch', 'general', '983'),
('1962', '981', 'customer', 'general', '996'),
('1963', '982', 'cust_branch', 'general', '984'),
('1964', '982', 'customer', 'general', '997'),
('1965', '983', 'cust_branch', 'general', '985'),
('1966', '983', 'customer', 'general', '998'),
('1967', '984', 'cust_branch', 'general', '986'),
('1968', '984', 'customer', 'general', '999'),
('1969', '985', 'cust_branch', 'general', '987'),
('1970', '985', 'customer', 'general', '1000'),
('1971', '986', 'cust_branch', 'general', '988'),
('1972', '986', 'customer', 'general', '1001'),
('1973', '987', 'cust_branch', 'general', '989'),
('1974', '987', 'customer', 'general', '1002'),
('1975', '988', 'cust_branch', 'general', '990'),
('1976', '988', 'customer', 'general', '1003'),
('1977', '989', 'cust_branch', 'general', '991'),
('1978', '989', 'customer', 'general', '1004'),
('1979', '990', 'cust_branch', 'general', '992'),
('1980', '990', 'customer', 'general', '1005'),
('1981', '991', 'cust_branch', 'general', '993'),
('1982', '991', 'customer', 'general', '1006'),
('1983', '992', 'cust_branch', 'general', '994'),
('1984', '992', 'customer', 'general', '1007'),
('1985', '993', 'cust_branch', 'general', '995'),
('1986', '993', 'customer', 'general', '1008'),
('1987', '994', 'cust_branch', 'general', '996'),
('1988', '994', 'customer', 'general', '1009'),
('1989', '995', 'cust_branch', 'general', '997'),
('1990', '995', 'customer', 'general', '1010'),
('1991', '996', 'cust_branch', 'general', '998'),
('1992', '996', 'customer', 'general', '1011'),
('1993', '997', 'cust_branch', 'general', '999'),
('1994', '997', 'customer', 'general', '1012'),
('1995', '998', 'cust_branch', 'general', '1000'),
('1996', '998', 'customer', 'general', '1013'),
('1997', '999', 'cust_branch', 'general', '1001'),
('1998', '999', 'customer', 'general', '1014'),
('1999', '1000', 'cust_branch', 'general', '1002'),
('2000', '1000', 'customer', 'general', '1015'),
('2001', '1001', 'cust_branch', 'general', '1003'),
('2002', '1001', 'customer', 'general', '1016'),
('2003', '1002', 'cust_branch', 'general', '1004'),
('2004', '1002', 'customer', 'general', '1017'),
('2005', '1003', 'cust_branch', 'general', '1005'),
('2006', '1003', 'customer', 'general', '1018'),
('2007', '1004', 'cust_branch', 'general', '1006'),
('2008', '1004', 'customer', 'general', '1019'),
('2009', '1005', 'cust_branch', 'general', '1007'),
('2010', '1005', 'customer', 'general', '1020'),
('2011', '1006', 'cust_branch', 'general', '1008'),
('2012', '1006', 'customer', 'general', '1021'),
('2013', '1007', 'cust_branch', 'general', '1009'),
('2014', '1007', 'customer', 'general', '1022'),
('2015', '1008', 'cust_branch', 'general', '1010'),
('2016', '1008', 'customer', 'general', '1023'),
('2017', '1009', 'cust_branch', 'general', '1011'),
('2018', '1009', 'customer', 'general', '1024'),
('2019', '1010', 'cust_branch', 'general', '1012'),
('2020', '1010', 'customer', 'general', '1025'),
('2021', '1011', 'cust_branch', 'general', '1013'),
('2022', '1011', 'customer', 'general', '1026'),
('2023', '1012', 'cust_branch', 'general', '1014'),
('2024', '1012', 'customer', 'general', '1027'),
('2025', '1013', 'cust_branch', 'general', '1015'),
('2026', '1013', 'customer', 'general', '1028'),
('2027', '1014', 'cust_branch', 'general', '1016'),
('2028', '1014', 'customer', 'general', '1029'),
('2029', '1015', 'cust_branch', 'general', '1017'),
('2030', '1015', 'customer', 'general', '1030'),
('2031', '1016', 'cust_branch', 'general', '1018'),
('2032', '1016', 'customer', 'general', '1031'),
('2033', '1017', 'cust_branch', 'general', '1019'),
('2034', '1017', 'customer', 'general', '1032'),
('2035', '1018', 'cust_branch', 'general', '1020'),
('2036', '1018', 'customer', 'general', '1033'),
('2037', '1019', 'cust_branch', 'general', '1021'),
('2038', '1019', 'customer', 'general', '1034'),
('2039', '1020', 'cust_branch', 'general', '1022'),
('2040', '1020', 'customer', 'general', '1035'),
('2041', '1021', 'cust_branch', 'general', '1023'),
('2042', '1021', 'customer', 'general', '1036'),
('2043', '1022', 'cust_branch', 'general', '1024'),
('2044', '1022', 'customer', 'general', '1037'),
('2045', '1023', 'cust_branch', 'general', '1025'),
('2046', '1023', 'customer', 'general', '1038'),
('2047', '1024', 'cust_branch', 'general', '1026'),
('2048', '1024', 'customer', 'general', '1039'),
('2049', '1025', 'cust_branch', 'general', '1027'),
('2050', '1025', 'customer', 'general', '1040'),
('2051', '1026', 'cust_branch', 'general', '1028'),
('2052', '1026', 'customer', 'general', '1041'),
('2053', '1027', 'cust_branch', 'general', '1029'),
('2054', '1027', 'customer', 'general', '1042'),
('2055', '1028', 'cust_branch', 'general', '1030'),
('2056', '1028', 'customer', 'general', '1043'),
('2057', '1029', 'cust_branch', 'general', '1031'),
('2058', '1029', 'customer', 'general', '1044'),
('2059', '1030', 'cust_branch', 'general', '1032'),
('2060', '1030', 'customer', 'general', '1045'),
('2061', '1031', 'cust_branch', 'general', '1033'),
('2062', '1031', 'customer', 'general', '1046'),
('2063', '1032', 'cust_branch', 'general', '1034'),
('2064', '1032', 'customer', 'general', '1047'),
('2065', '1033', 'cust_branch', 'general', '1035'),
('2066', '1033', 'customer', 'general', '1048'),
('2067', '1034', 'cust_branch', 'general', '1036'),
('2068', '1034', 'customer', 'general', '1049'),
('2069', '1035', 'cust_branch', 'general', '1037'),
('2070', '1035', 'customer', 'general', '1050'),
('2071', '1036', 'cust_branch', 'general', '1038'),
('2072', '1036', 'customer', 'general', '1051'),
('2073', '1037', 'cust_branch', 'general', '1039'),
('2074', '1037', 'customer', 'general', '1052'),
('2075', '1038', 'cust_branch', 'general', '1040'),
('2076', '1038', 'customer', 'general', '1053'),
('2077', '1039', 'cust_branch', 'general', '1041'),
('2078', '1039', 'customer', 'general', '1054'),
('2079', '1040', 'cust_branch', 'general', '1042'),
('2080', '1040', 'customer', 'general', '1055'),
('2081', '1041', 'cust_branch', 'general', '1043'),
('2082', '1041', 'customer', 'general', '1056'),
('2083', '1042', 'cust_branch', 'general', '1044'),
('2084', '1042', 'customer', 'general', '1057'),
('2085', '1043', 'cust_branch', 'general', '1045'),
('2086', '1043', 'customer', 'general', '1058'),
('2087', '1044', 'cust_branch', 'general', '1046'),
('2088', '1044', 'customer', 'general', '1059'),
('2089', '1045', 'cust_branch', 'general', '1047'),
('2090', '1045', 'customer', 'general', '1060'),
('2091', '1046', 'cust_branch', 'general', '1048'),
('2092', '1046', 'customer', 'general', '1061'),
('2093', '1047', 'cust_branch', 'general', '1049'),
('2094', '1047', 'customer', 'general', '1062'),
('2095', '1048', 'cust_branch', 'general', '1050'),
('2096', '1048', 'customer', 'general', '1063'),
('2097', '1049', 'cust_branch', 'general', '1051'),
('2098', '1049', 'customer', 'general', '1064'),
('2099', '1050', 'cust_branch', 'general', '1052'),
('2100', '1050', 'customer', 'general', '1065'),
('2101', '1051', 'cust_branch', 'general', '1053'),
('2102', '1051', 'customer', 'general', '1066'),
('2103', '1052', 'cust_branch', 'general', '1054'),
('2104', '1052', 'customer', 'general', '1067'),
('2105', '1053', 'cust_branch', 'general', '1055'),
('2106', '1053', 'customer', 'general', '1068'),
('2107', '1054', 'cust_branch', 'general', '1056'),
('2108', '1054', 'customer', 'general', '1069'),
('2109', '1055', 'cust_branch', 'general', '1057'),
('2110', '1055', 'customer', 'general', '1070'),
('2111', '1056', 'cust_branch', 'general', '1058'),
('2112', '1056', 'customer', 'general', '1071'),
('2113', '1057', 'cust_branch', 'general', '1059'),
('2114', '1057', 'customer', 'general', '1072'),
('2115', '1058', 'cust_branch', 'general', '1060'),
('2116', '1058', 'customer', 'general', '1073'),
('2117', '1059', 'cust_branch', 'general', '1061'),
('2118', '1059', 'customer', 'general', '1074'),
('2119', '1060', 'cust_branch', 'general', '1062'),
('2120', '1060', 'customer', 'general', '1075'),
('2121', '1061', 'cust_branch', 'general', '1063'),
('2122', '1061', 'customer', 'general', '1076'),
('2123', '1062', 'cust_branch', 'general', '1064'),
('2124', '1062', 'customer', 'general', '1077'),
('2125', '1063', 'cust_branch', 'general', '1065'),
('2126', '1063', 'customer', 'general', '1078'),
('2127', '1064', 'cust_branch', 'general', '1066'),
('2128', '1064', 'customer', 'general', '1079'),
('2129', '1065', 'cust_branch', 'general', '1067'),
('2130', '1065', 'customer', 'general', '1080'),
('2131', '1066', 'cust_branch', 'general', '1068'),
('2132', '1066', 'customer', 'general', '1081'),
('2133', '1067', 'cust_branch', 'general', '1069'),
('2134', '1067', 'customer', 'general', '1082'),
('2135', '1068', 'cust_branch', 'general', '1070'),
('2136', '1068', 'customer', 'general', '1083'),
('2137', '1069', 'cust_branch', 'general', '1071'),
('2138', '1069', 'customer', 'general', '1084'),
('2139', '1070', 'cust_branch', 'general', '1072'),
('2140', '1070', 'customer', 'general', '1085'),
('2141', '1071', 'cust_branch', 'general', '1073'),
('2142', '1071', 'customer', 'general', '1086'),
('2143', '1072', 'cust_branch', 'general', '1074'),
('2144', '1072', 'customer', 'general', '1087'),
('2145', '1073', 'cust_branch', 'general', '1075'),
('2146', '1073', 'customer', 'general', '1088'),
('2147', '1074', 'cust_branch', 'general', '1076'),
('2148', '1074', 'customer', 'general', '1089'),
('2149', '1075', 'cust_branch', 'general', '1077'),
('2150', '1075', 'customer', 'general', '1090'),
('2151', '1076', 'cust_branch', 'general', '1078'),
('2152', '1076', 'customer', 'general', '1091'),
('2153', '1077', 'cust_branch', 'general', '1079'),
('2154', '1077', 'customer', 'general', '1092'),
('2155', '1078', 'cust_branch', 'general', '1080'),
('2156', '1078', 'customer', 'general', '1093'),
('2157', '1079', 'cust_branch', 'general', '1081'),
('2158', '1079', 'customer', 'general', '1094'),
('2159', '1080', 'cust_branch', 'general', '1082'),
('2160', '1080', 'customer', 'general', '1095'),
('2161', '1081', 'cust_branch', 'general', '1083'),
('2162', '1081', 'customer', 'general', '1096'),
('2163', '1082', 'cust_branch', 'general', '1084'),
('2164', '1082', 'customer', 'general', '1097'),
('2165', '1083', 'cust_branch', 'general', '1085'),
('2166', '1083', 'customer', 'general', '1098'),
('2167', '1084', 'cust_branch', 'general', '1086'),
('2168', '1084', 'customer', 'general', '1099'),
('2169', '1085', 'cust_branch', 'general', '1087'),
('2170', '1085', 'customer', 'general', '1100'),
('2171', '1086', 'cust_branch', 'general', '1088'),
('2172', '1086', 'customer', 'general', '1101'),
('2173', '1087', 'cust_branch', 'general', '1089'),
('2174', '1087', 'customer', 'general', '1102');
INSERT INTO `0_crm_contacts` VALUES
('2175', '1088', 'cust_branch', 'general', '1090'),
('2176', '1088', 'customer', 'general', '1103'),
('2177', '1089', 'cust_branch', 'general', '1091'),
('2178', '1089', 'customer', 'general', '1104'),
('2179', '1090', 'cust_branch', 'general', '1092'),
('2180', '1090', 'customer', 'general', '1105'),
('2181', '1091', 'cust_branch', 'general', '1093'),
('2182', '1091', 'customer', 'general', '1106'),
('2183', '1092', 'cust_branch', 'general', '1094'),
('2184', '1092', 'customer', 'general', '1107'),
('2185', '1093', 'cust_branch', 'general', '1095'),
('2186', '1093', 'customer', 'general', '1108'),
('2187', '1094', 'cust_branch', 'general', '1096'),
('2188', '1094', 'customer', 'general', '1109'),
('2189', '1095', 'cust_branch', 'general', '1097'),
('2190', '1095', 'customer', 'general', '1110'),
('2191', '1096', 'cust_branch', 'general', '1098'),
('2192', '1096', 'customer', 'general', '1111'),
('2193', '1097', 'supplier', 'general', '5'),
('2194', '1098', 'supplier', 'general', '6'),
('2195', '1099', 'supplier', 'general', '7'),
('2196', '1100', 'supplier', 'general', '8'),
('2197', '1101', 'supplier', 'general', '9'),
('2198', '1102', 'supplier', 'general', '10'),
('2199', '1103', 'supplier', 'general', '11'),
('2201', '444', 'cust_branch', 'general', '446');

### Structure of table `0_crm_persons` ###

DROP TABLE IF EXISTS `0_crm_persons`;

CREATE TABLE `0_crm_persons` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ref` varchar(100) NOT NULL,
  `name` varchar(100) NOT NULL,
  `name2` varchar(60) DEFAULT NULL,
  `address` tinytext DEFAULT NULL,
  `phone` varchar(30) DEFAULT NULL,
  `phone2` varchar(30) DEFAULT NULL,
  `fax` varchar(30) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `lang` char(5) DEFAULT NULL,
  `notes` tinytext DEFAULT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `ref` (`ref`)
) ENGINE=InnoDB AUTO_INCREMENT=1104 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_crm_persons` ###

INSERT INTO `0_crm_persons` VALUES
('1', 'A.A Joyland (Pvt) Ltd', 'A.A Joyland (Pvt) Ltd', NULL, 'Karachi', '+92-21- 111-111-734', NULL, NULL, NULL, NULL, NULL, '0'),
('2', 'Allied Industries Hub (Pvt.) Ltd.', 'Allied Industries Hub (Pvt.) Ltd.', NULL, 'Karachi', '92-21-32428851', NULL, NULL, NULL, NULL, NULL, '0'),
('3', 'Ams Industrial &amp; Eng. Co (Htl Express)	', 'Ams Industrial &amp; Eng. Co (Htl Express)	', NULL, 'Karachi', '021-34329918', NULL, NULL, NULL, NULL, NULL, '0'),
('4', 'Greaves Pakistan (Pvt.) Ltd', 'Greaves Pakistan (Pvt.) Ltd', NULL, 'Karachi', '021-35682565 ', NULL, NULL, NULL, NULL, NULL, '0'),
('5', 'Honda Quaideen', 'Honda Quaideen', NULL, 'Karachi', '021-34556510-12', NULL, NULL, NULL, NULL, NULL, '0'),
('6', 'Honda South (Private) Limited', 'Honda South (Private) Limited', NULL, 'Karachi', '021-35050251', NULL, NULL, NULL, NULL, NULL, '0'),
('7', 'Ideal Power Engineering Services', 'Ideal Power Engineering Services', NULL, 'Karachi', '021-34527965', NULL, NULL, NULL, NULL, NULL, '0'),
('8', 'Jaffer Brothers (Pvt) Ltd', 'Jaffer Brothers (Pvt) Ltd', NULL, 'Karachi', '021-34373078', NULL, NULL, NULL, NULL, NULL, '0'),
('9', 'Karim Container (Pvt) Ltd', 'Karim Container (Pvt) Ltd', NULL, 'Karachi', '32572417', NULL, NULL, NULL, NULL, NULL, '0'),
('10', 'M/ S Honda Drive In', 'M/ S Honda Drive In', NULL, 'Karachi', '021-34992832-6', NULL, NULL, NULL, NULL, NULL, '0'),
('11', 'M/ S Hyundai South', 'M/ S Hyundai South', NULL, 'Karachi', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('12', 'M/S Advance Colours', 'M/S Advance Colours', NULL, 'Karachi', '021-32563535-38', NULL, NULL, NULL, NULL, NULL, '0'),
('13', 'M/S Dewan Motors (Pvt.) Ltd-Bmw', 'M/S Dewan Motors (Pvt.) Ltd-Bmw', NULL, 'Karachi', '92-21-505-8757', NULL, NULL, NULL, NULL, NULL, '0'),
('14', 'M/S Dewan Mushtaq Motors Co (Pvt.) Ltd', 'M/S Dewan Mushtaq Motors Co (Pvt.) Ltd', NULL, 'Karachi', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('15', 'M/S Honda Khair (Pvt.) Ltd.', 'M/S Honda Khair (Pvt.) Ltd.', NULL, 'Karachi', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('16', 'M/S Kia Motor - South', 'M/S Kia Motor - South', NULL, 'Karachi', '021-35110152-56', NULL, NULL, NULL, NULL, NULL, '0'),
('17', 'M/S Kia Motors Macca', 'M/S Kia Motors Macca', NULL, 'Karachi', '021-34588997', NULL, NULL, NULL, NULL, NULL, '0'),
('18', 'M/S Loads Limited', 'M/S Loads Limited', NULL, 'Karachi', '021 - 35065001 - 5', NULL, NULL, NULL, NULL, NULL, '0'),
('19', 'M/S Mandviwala Motors (Private) Ltd', 'M/S Mandviwala Motors (Private) Ltd', NULL, 'Karachi', '021-32425225', NULL, NULL, NULL, NULL, NULL, '0'),
('20', 'M/S Mg Centre', 'M/S Mg Centre', NULL, 'Karachi', '0300-0459730', NULL, NULL, NULL, NULL, NULL, '0'),
('21', 'M/S Nabi Qasim Industries (Pvt.) Ltd.', 'M/S Nabi Qasim Industries (Pvt.) Ltd.', NULL, 'Karachi', '021-111-742-762', NULL, NULL, NULL, NULL, NULL, '0'),
('22', 'M/S Naseer Autos', 'M/S Naseer Autos', NULL, 'Karachi', '021-32573266-67-68', NULL, NULL, NULL, NULL, NULL, '0'),
('23', 'M/S National Foods Limited', 'M/S National Foods Limited', NULL, 'Karachi', '021-32577707-10', NULL, NULL, NULL, NULL, NULL, '0'),
('24', 'M/S O &amp; A International', 'M/S O &amp; A International', NULL, 'Karachi', '35810557', NULL, NULL, NULL, NULL, NULL, '0'),
('25', 'M/S Phoenix Armour (Pvt.) Ltd', 'M/S Phoenix Armour (Pvt.) Ltd', NULL, 'Karachi', '021-32315031', NULL, NULL, NULL, NULL, NULL, '0'),
('26', 'M/S R M Salt', 'M/S R M Salt', NULL, 'Karachi', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('27', 'M/S Riaz Motors', 'M/S Riaz Motors', NULL, 'Karachi', '021-35122190', NULL, NULL, NULL, NULL, NULL, '0'),
('28', 'M/S Sna Motors', 'M/S Sna Motors', NULL, 'Karachi', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('29', 'M/S Suzuki Nadeem International', 'M/S Suzuki Nadeem International', NULL, 'Karachi', '35001524', NULL, NULL, NULL, NULL, NULL, '0'),
('30', 'M/S Toyota Creek Motors (Pvt.) Ltd', 'M/S Toyota Creek Motors (Pvt.) Ltd', NULL, 'Karachi', '021-35881898', NULL, NULL, NULL, NULL, NULL, '0'),
('31', 'M/S Toyota Highway Motors', 'M/S Toyota Highway Motors', NULL, 'Karachi', '021-36880702-4', NULL, NULL, NULL, NULL, NULL, '0'),
('32', 'M/S Toyota Society Motors (Pvt.) Ltd.', 'M/S Toyota Society Motors (Pvt.) Ltd.', NULL, 'Karachi', '021-34383213-7', NULL, NULL, NULL, NULL, NULL, '0'),
('33', 'M/S Union Fabrics (Pvt.) Ltd', 'M/S Union Fabrics (Pvt.) Ltd', NULL, 'Karachi', '021-32567881', NULL, NULL, NULL, NULL, NULL, '0'),
('34', 'M/S Toyota Central Motors', 'M/S Toyota Central Motors', NULL, 'Karachi', '021-34532246 - 50', NULL, NULL, NULL, NULL, NULL, '0'),
('35', 'Marshal Traders', 'Marshal Traders', NULL, 'Karachi', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('36', 'Pak Suzuki Motor Co. Ltd', 'Pak Suzuki Motor Co. Ltd', NULL, 'Karachi', '021-111-789-854', NULL, NULL, NULL, NULL, NULL, '0'),
('37', 'Pakistan Petroleum Limited', 'Pakistan Petroleum Limited', NULL, 'Karachi', '+92-21-111-568-568', NULL, NULL, NULL, NULL, NULL, '0'),
('38', 'Parson Industries (Pvt) Ltd. - S.I.T.E', 'Parson Industries (Pvt) Ltd. - S.I.T.E', NULL, 'Karachi', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('39', 'Presson Descon Int (Pvt) Ltd', 'Presson Descon Int (Pvt) Ltd', NULL, 'Karachi', '(042) 35880390', NULL, NULL, NULL, NULL, NULL, '0'),
('40', 'Quetta Textile Mills Ltd', 'Quetta Textile Mills Ltd', NULL, 'Karachi', '021-32414334-6', NULL, NULL, NULL, NULL, NULL, '0'),
('41', 'R.A Engineering (Pvt.) Ltd', 'R.A Engineering (Pvt.) Ltd', NULL, 'Karachi', '021-34852125', NULL, NULL, NULL, NULL, NULL, '0'),
('42', 'S.M Jaffer &amp; Company', 'S.M Jaffer &amp; Company', NULL, 'Karachi', '32850780 32863621', NULL, NULL, NULL, NULL, NULL, '0'),
('43', 'Sapphire Textile Mills Ltd', 'Sapphire Textile Mills Ltd', NULL, 'Karachi', '021-32417869', NULL, NULL, NULL, NULL, NULL, '0'),
('44', 'Specialized Autoparts Ind. (Pvt.) Ltd', 'Specialized Autoparts Ind. (Pvt.) Ltd', NULL, 'Karachi', '021 - 35065001-5', NULL, NULL, NULL, NULL, NULL, '0'),
('45', 'SSGC LPG (Pvt.) Ltd', 'SSGC LPG (Pvt.) Ltd', NULL, 'Karachi', '021-35202973', NULL, NULL, NULL, NULL, NULL, '0'),
('46', 'Sui Southern Gas Company Ltd', 'Sui Southern Gas Company Ltd', NULL, 'Karachi', '9221-99021000', NULL, NULL, NULL, NULL, NULL, '0'),
('47', 'Taqi &amp; Sons', 'Taqi &amp; Sons', NULL, 'Karachi', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('48', 'Technovative Era Pvt Ltd', 'Technovative Era Pvt Ltd', NULL, 'Karachi', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('49', 'Toyota Port Qasim Motors (Pvt) Ltd', 'Toyota Port Qasim Motors (Pvt) Ltd', NULL, 'Karachi', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('50', 'Unregistrator Company Sales Ncpl', 'Unregistrator Company Sales Ncpl', NULL, 'Karachi', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('51', 'Areeb Auto', 'Areeb Auto', NULL, 'Hyderabad', '0345-3721642', NULL, NULL, NULL, NULL, NULL, '0'),
('52', 'Ayan Ali Auto', 'Ayan Ali Auto', NULL, 'Hyderabad', '0311-3175055', NULL, NULL, NULL, NULL, NULL, '0'),
('53', 'Bhitai Auto ', 'Bhitai Auto ', NULL, 'Hyderabad', '0301-3582494', NULL, NULL, NULL, NULL, NULL, '0'),
('54', 'Data Autos', 'Data Autos', NULL, 'Hyderabad', '0312-300017', NULL, NULL, NULL, NULL, NULL, '0'),
('55', 'Data Body Parts', 'Data Body Parts', NULL, 'Hyderabad', '0315-3774020', NULL, NULL, NULL, NULL, NULL, '0'),
('56', 'Hamza Autos', 'Hamza Autos', NULL, 'Hyderabad', '0333-26033651', NULL, NULL, NULL, NULL, NULL, '0'),
('57', 'Hanif Autos', 'Hanif Autos', NULL, 'Hyderabad', '0303-7215014', NULL, NULL, NULL, NULL, NULL, '0'),
('58', 'Hoorain Auto', 'Hoorain Auto', NULL, 'Hyderabad', '0315-8330154', NULL, NULL, NULL, NULL, NULL, '0'),
('59', 'New Data Oil', 'New Data Oil', NULL, 'Hyderabad', '0314-7517663', NULL, NULL, NULL, NULL, NULL, '0'),
('60', 'Prince Siddiquei  Motor', 'Prince Siddiquei  Motor', NULL, 'Hyderabad', '0345-385186', NULL, NULL, NULL, NULL, NULL, '0'),
('61', 'qalandri', 'qalandri', NULL, 'Hyderabad', '0314-2483864', NULL, NULL, NULL, NULL, NULL, '0'),
('62', 'Zeeshan Autos ', 'Zeeshan Autos ', NULL, 'Hyderabad', '034-3799381', NULL, NULL, NULL, NULL, NULL, '0'),
('63', 'B.S Autos', 'B.S Autos', NULL, 'Hyderabad', '0300-3790086', NULL, NULL, NULL, NULL, NULL, '0'),
('64', 'Hussain Auto', 'Hussain Auto', NULL, 'Hyderabad', '0333-3091655', NULL, NULL, NULL, NULL, NULL, '0'),
('65', 'Leavenge Oil Change', 'Leavenge Oil Change', NULL, 'Hyderabad', '0300-3790086', NULL, NULL, NULL, NULL, NULL, '0'),
('66', 'Muflah Autos', 'Muflah Autos', NULL, 'Hyderabad', '0315-3799812', NULL, NULL, NULL, NULL, NULL, '0'),
('67', 'Quick Oil', 'Quick Oil', NULL, 'Hyderabad', '0315-3134840', NULL, NULL, NULL, NULL, NULL, '0'),
('68', 'Qureshi Auto', 'Qureshi Auto', NULL, 'Hyderabad', '0315-3134840', NULL, NULL, NULL, NULL, NULL, '0'),
('69', 'New Sindh Motor', 'New Sindh Motor', NULL, 'Hyderabad', '0315-5547693', NULL, NULL, NULL, NULL, NULL, '0'),
('70', 'Noor Motor', 'Noor Motor', NULL, 'Hyderabad', '0316-3127506', NULL, NULL, NULL, NULL, NULL, '0'),
('71', 'Akram Auto', 'Akram Auto', NULL, 'Hyderabad', '0334-2047481', NULL, NULL, NULL, NULL, NULL, '0'),
('72', 'Indus Autos', 'Indus Autos', NULL, 'Hyderabad', '0346-7000800', NULL, NULL, NULL, NULL, NULL, '0'),
('73', 'Pak Autos', 'Pak Autos', NULL, 'Hyderabad', '0312-3089260', NULL, NULL, NULL, NULL, NULL, '0'),
('74', 'Shair Khan Autos', 'Shair Khan Autos', NULL, 'Hyderabad', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('75', 'A.R Autos', 'A.R Autos', NULL, 'Hyderabad', '0310-3588547', NULL, NULL, NULL, NULL, NULL, '0'),
('76', 'Imtiaz Auto', 'Imtiaz Auto', NULL, 'Hyderabad', '0315-8462699', NULL, NULL, NULL, NULL, NULL, '0'),
('77', 'Khan Auto', 'Khan Auto', NULL, 'Hyderabad', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('78', 'Suzuki Motor High Way', 'Suzuki Motor High Way', NULL, 'Hyderabad', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('79', 'Kia Motor J', 'Kia Motor J', NULL, 'Hyderabad', '0317 0319618', NULL, NULL, NULL, NULL, NULL, '0'),
('80', 'Bhalai Auto', 'Bhalai Auto', NULL, 'Hyderabad', '0306-0130665', NULL, NULL, NULL, NULL, NULL, '0'),
('81', 'J.S Autos', 'J.S Autos', NULL, 'Hyderabad', '0305-4344045', NULL, NULL, NULL, NULL, NULL, '0'),
('82', 'S.A Malik Autos ', 'S.A Malik Autos ', NULL, 'Hyderabad', '0313-1307727', NULL, NULL, NULL, NULL, NULL, '0'),
('83', 'Al Fazal Auto', 'Al Fazal Auto', NULL, 'Hyderabad', '0345-3772970', NULL, NULL, NULL, NULL, NULL, '0'),
('84', 'Alam Autos', 'Alam Autos', NULL, 'Hyderabad', '0333-7521546', NULL, NULL, NULL, NULL, NULL, '0'),
('85', 'Bismillah Auto ', 'Bismillah Auto ', NULL, 'Hyderabad', '0307-0039722', NULL, NULL, NULL, NULL, NULL, '0'),
('86', 'Bukhari Auto', 'Bukhari Auto', NULL, 'Hyderabad', '0300-3062155', NULL, NULL, NULL, NULL, NULL, '0'),
('87', 'National Serhad Auot', 'National Serhad Auot', NULL, 'Hyderabad', '0300-9374885', NULL, NULL, NULL, NULL, NULL, '0'),
('88', 'Sheikh Zahoor Oil', 'Sheikh Zahoor Oil', NULL, 'Hyderabad', '0333-2602797', NULL, NULL, NULL, NULL, NULL, '0'),
('89', 'Auto Resq', 'Auto Resq', NULL, 'Hyderabad', '0314-3610535', NULL, NULL, NULL, NULL, NULL, '0'),
('90', 'Jawaid Autos', 'Jawaid Autos', NULL, 'Hyderabad', '0314-3610535', NULL, NULL, NULL, NULL, NULL, '0'),
('91', 'Taj Motor', 'Taj Motor', NULL, 'Hyderabad', '0342-3544256', NULL, NULL, NULL, NULL, NULL, '0'),
('92', 'Umar Car Ac', 'Umar Car Ac', NULL, 'Hyderabad', '0315-3671957', NULL, NULL, NULL, NULL, NULL, '0'),
('93', 'Wel Come Autos', 'Wel Come Autos', NULL, 'Hyderabad', '0315-3671957', NULL, NULL, NULL, NULL, NULL, '0'),
('94', 'Ab Jabbar', 'Ab Jabbar', NULL, 'Hyderabad', '0315-357424', NULL, NULL, NULL, NULL, NULL, '0'),
('95', 'Al Noor Autos', 'Al Noor Autos', NULL, 'Hyderabad', '0333-2870245', NULL, NULL, NULL, NULL, NULL, '0'),
('96', 'Baloch Auto', 'Baloch Auto', NULL, 'Hyderabad', '0315-0309987', NULL, NULL, NULL, NULL, NULL, '0'),
('97', 'Khiuwaja Rafique', 'Khiuwaja Rafique', NULL, 'Hyderabad', '0313-1331700', NULL, NULL, NULL, NULL, NULL, '0'),
('98', 'Qureshi Auto 2', 'Qureshi Auto 2', NULL, 'Hyderabad', '0300-3797741', NULL, NULL, NULL, NULL, NULL, '0'),
('99', 'Jawaid Autos 2', 'Jawaid Autos 2', NULL, 'Hyderabad', '0313-3086365', NULL, NULL, NULL, NULL, NULL, '0'),
('100', 'Wel Come Autos 2', 'Wel Come Autos 2', NULL, 'Hyderabad', '0300-3099336', NULL, NULL, NULL, NULL, NULL, '0'),
('101', 'Mehran Autos', 'Mehran Autos', NULL, 'Hyderabad', '0346-3881948', NULL, NULL, NULL, NULL, NULL, '0'),
('102', 'Sattar Auto Electric', 'Sattar Auto Electric', NULL, 'Hyderabad', '0333-2709254', NULL, NULL, NULL, NULL, NULL, '0'),
('103', 'Shahzad Auto', 'Shahzad Auto', NULL, 'Hyderabad', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('104', 'Bermati Show Parts', 'Bermati Show Parts', NULL, 'Hyderabad', '0333-7501235', NULL, NULL, NULL, NULL, NULL, '0'),
('105', 'Faraz Auto', 'Faraz Auto', NULL, 'Hyderabad', '0311-3001613', NULL, NULL, NULL, NULL, NULL, '0'),
('106', 'Fatima Show Parts', 'Fatima Show Parts', NULL, 'Hyderabad', '0312-2222910', NULL, NULL, NULL, NULL, NULL, '0'),
('107', 'Gulistan Autos', 'Gulistan Autos', NULL, 'Hyderabad', '0312-8252648', NULL, NULL, NULL, NULL, NULL, '0'),
('108', 'New Sindh Motor 2', 'New Sindh Motor 2', NULL, 'Hyderabad', '0345-3738417', NULL, NULL, NULL, NULL, NULL, '0'),
('109', 'Sakhi Lal Show Parts', 'Sakhi Lal Show Parts', NULL, 'Hyderabad', '0310-3102712', NULL, NULL, NULL, NULL, NULL, '0'),
('110', 'Shah Autos', 'Shah Autos', NULL, 'Hyderabad', '0312-4202379', NULL, NULL, NULL, NULL, NULL, '0'),
('111', 'Jahangeri Auto ', 'Jahangeri Auto ', NULL, 'Hyderabad', '0333-2555023', NULL, NULL, NULL, NULL, NULL, '0'),
('112', 'M.Ismail Autos ', 'M.Ismail Autos ', NULL, 'Hyderabad', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('113', 'Aslam ', 'Aslam ', NULL, 'Hyderabad', '0300-3027275', NULL, NULL, NULL, NULL, NULL, '0'),
('114', 'Hassan Autos -', 'Hassan Autos -', NULL, 'Hyderabad', '0344-9253112', NULL, NULL, NULL, NULL, NULL, '0'),
('115', 'Star Auto', 'Star Auto', NULL, 'Hyderabad', '0318-3045998', NULL, NULL, NULL, NULL, NULL, '0'),
('116', 'Iqbal Autos ', 'Iqbal Autos ', NULL, 'Hyderabad', '0312-3370243', NULL, NULL, NULL, NULL, NULL, '0'),
('117', 'Ajmeri Autos ', 'Ajmeri Autos ', NULL, 'Hyderabad', '0300-3030471', NULL, NULL, NULL, NULL, NULL, '0'),
('118', 'Al Hamd', 'Al Hamd', NULL, 'Hyderabad', '0331-3982721', NULL, NULL, NULL, NULL, NULL, '0'),
('119', 'New Al Mehran Autos', 'New Al Mehran Autos', NULL, 'Hyderabad', '0344-3278277', NULL, NULL, NULL, NULL, NULL, '0'),
('120', 'Saeed Autos', 'Saeed Autos', NULL, 'Hyderabad', '0344-3641242', NULL, NULL, NULL, NULL, NULL, '0'),
('121', 'KPK Autos ', 'KPK Autos ', NULL, 'Hyderabad', '0346-8900002', NULL, NULL, NULL, NULL, NULL, '0'),
('122', 'Bab-e-Khyber Autos', 'Bab-e-Khyber Autos', NULL, 'Hyderabad', '0313-3105390', NULL, NULL, NULL, NULL, NULL, '0'),
('123', 'Rizwan Autos ', 'Rizwan Autos ', NULL, 'Hyderabad', '0316-2643525', NULL, NULL, NULL, NULL, NULL, '0'),
('124', 'Noor Autos', 'Noor Autos', NULL, 'Hyderabad', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('125', 'Super Autos ', 'Super Autos ', NULL, 'Hyderabad', '0331-8016110', NULL, NULL, NULL, NULL, NULL, '0'),
('126', 'Abbu Baker', 'Abbu Baker', NULL, 'Hyderabad', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('127', 'Al Raza Auto', 'Al Raza Auto', NULL, 'Hyderabad', '0300-3247703', NULL, NULL, NULL, NULL, NULL, '0'),
('128', 'Al Reman Autos', 'Al Reman Autos', NULL, 'Hyderabad', '0333-2002670', NULL, NULL, NULL, NULL, NULL, '0'),
('129', 'Arsalan Motor', 'Arsalan Motor', NULL, 'Hyderabad', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('130', 'Auto Mart', 'Auto Mart', NULL, 'Hyderabad', '0342-3016529', NULL, NULL, NULL, NULL, NULL, '0'),
('131', 'Azhar Autos', 'Azhar Autos', NULL, 'Hyderabad', '0300-3015158', NULL, NULL, NULL, NULL, NULL, '0'),
('132', 'Bilal Motor', 'Bilal Motor', NULL, 'Hyderabad', '0333-12652', NULL, NULL, NULL, NULL, NULL, '0'),
('133', 'Dubai Autos ', 'Dubai Autos ', NULL, 'Hyderabad', '0344-3445169', NULL, NULL, NULL, NULL, NULL, '0'),
('134', 'Faisal Motor', 'Faisal Motor', NULL, 'Hyderabad', '0332-263150', NULL, NULL, NULL, NULL, NULL, '0'),
('135', 'Fayaz', 'Fayaz', NULL, 'Hyderabad', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('136', 'Hadi Autos', 'Hadi Autos', NULL, 'Hyderabad', '0313-3100595', NULL, NULL, NULL, NULL, NULL, '0'),
('137', 'Honda Centre ', 'Honda Centre ', NULL, 'Hyderabad', '0336-3038596', NULL, NULL, NULL, NULL, NULL, '0'),
('138', 'Idrees Autos', 'Idrees Autos', NULL, 'Hyderabad', '0332-2638600', NULL, NULL, NULL, NULL, NULL, '0'),
('139', 'Imran', 'Imran', NULL, 'Hyderabad', '0343-3587924', NULL, NULL, NULL, NULL, NULL, '0'),
('140', 'Imtiaz Autos ', 'Imtiaz Autos ', NULL, 'Hyderabad', '0315-213552', NULL, NULL, NULL, NULL, NULL, '0'),
('141', 'Iqra Autos', 'Iqra Autos', NULL, 'Hyderabad', '0313-4924075', NULL, NULL, NULL, NULL, NULL, '0'),
('142', 'Junaid Rubber', 'Junaid Rubber', NULL, 'Hyderabad', '022-2786256', NULL, NULL, NULL, NULL, NULL, '0'),
('143', 'Khalique Motor', 'Khalique Motor', NULL, 'Hyderabad', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('144', 'Khan Motor', 'Khan Motor', NULL, 'Hyderabad', '0333-266872', NULL, NULL, NULL, NULL, NULL, '0'),
('145', 'M.R Auto', 'M.R Auto', NULL, 'Hyderabad', '0307-3071897', NULL, NULL, NULL, NULL, NULL, '0'),
('146', 'Madina Rubber ', 'Madina Rubber ', NULL, 'Hyderabad', '0333-2655632', NULL, NULL, NULL, NULL, NULL, '0'),
('147', 'Mehran Auto', 'Mehran Auto', NULL, 'Hyderabad', '0333-2632730', NULL, NULL, NULL, NULL, NULL, '0'),
('148', 'Missan Bukhari', 'Missan Bukhari', NULL, 'Hyderabad', '0300-9955991', NULL, NULL, NULL, NULL, NULL, '0'),
('149', 'Moien Autos', 'Moien Autos', NULL, 'Hyderabad', '0333-2607198', NULL, NULL, NULL, NULL, NULL, '0'),
('150', 'Nazeer', 'Nazeer', NULL, 'Hyderabad', '0345-3549491', NULL, NULL, NULL, NULL, NULL, '0'),
('151', 'Pakistan Rools', 'Pakistan Rools', NULL, 'Hyderabad', '0342-3680728', NULL, NULL, NULL, NULL, NULL, '0'),
('152', 'Pervaiz Auto ', 'Pervaiz Auto ', NULL, 'Hyderabad', '0333-32656482', NULL, NULL, NULL, NULL, NULL, '0'),
('153', 'Quality ', 'Quality ', NULL, 'Hyderabad', '0317-3044138', NULL, NULL, NULL, NULL, NULL, '0'),
('154', 'Raza Tools ', 'Raza Tools ', NULL, 'Hyderabad', '0332-2675421', NULL, NULL, NULL, NULL, NULL, '0'),
('155', 'Rehan Autos', 'Rehan Autos', NULL, 'Hyderabad', '0333-851469', NULL, NULL, NULL, NULL, NULL, '0'),
('156', 'Riaz Lubricant', 'Riaz Lubricant', NULL, 'Hyderabad', '0333-2722183', NULL, NULL, NULL, NULL, NULL, '0'),
('157', 'Rohan Tools', 'Rohan Tools', NULL, 'Hyderabad', '0300-3037440', NULL, NULL, NULL, NULL, NULL, '0'),
('158', 'Sahfique Autos', 'Sahfique Autos', NULL, 'Hyderabad', '0333-2637620', NULL, NULL, NULL, NULL, NULL, '0'),
('159', 'Sattar Autos', 'Sattar Autos', NULL, 'Hyderabad', '0333-2409996', NULL, NULL, NULL, NULL, NULL, '0'),
('160', 'Shafique Autos', 'Shafique Autos', NULL, 'Hyderabad', '0311-7464162', NULL, NULL, NULL, NULL, NULL, '0'),
('161', 'Syed Auto', 'Syed Auto', NULL, 'Hyderabad', '0346-2098560', NULL, NULL, NULL, NULL, NULL, '0'),
('162', 'Taiwan Auto', 'Taiwan Auto', NULL, 'Hyderabad', '022-278210', NULL, NULL, NULL, NULL, NULL, '0'),
('163', 'Toyota House ', 'Toyota House ', NULL, 'Hyderabad', '0317-3698847', NULL, NULL, NULL, NULL, NULL, '0'),
('164', 'Urooj Auto', 'Urooj Auto', NULL, 'Hyderabad', '0312-9378790', NULL, NULL, NULL, NULL, NULL, '0'),
('165', 'Zaib Auto', 'Zaib Auto', NULL, 'Hyderabad', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('166', 'Zeeshan Autos  2', 'Zeeshan Autos  2', NULL, 'Hyderabad', '0333-266872', NULL, NULL, NULL, NULL, NULL, '0'),
('167', 'Bilal Autos', 'Bilal Autos', NULL, 'Hyderabad', '0300-9375669', NULL, NULL, NULL, NULL, NULL, '0'),
('168', 'Kazim Autos ', 'Kazim Autos ', NULL, 'Hyderabad', '0306-9780329', NULL, NULL, NULL, NULL, NULL, '0'),
('169', 'M.Ayan Autos ', 'M.Ayan Autos ', NULL, 'Hyderabad', '0344-1850395', NULL, NULL, NULL, NULL, NULL, '0'),
('170', 'Makhdoom Fakhro Zaman ', 'Makhdoom Fakhro Zaman ', NULL, 'Hyderabad', '0332-2967305', NULL, NULL, NULL, NULL, NULL, '0'),
('171', 'Tawakal Autos Hala-', 'Tawakal Autos Hala-', NULL, 'Hyderabad', '0345-3635924', NULL, NULL, NULL, NULL, NULL, '0'),
('172', 'Afridi Autos', 'Afridi Autos', NULL, 'Hyderabad', '0346-8900002', NULL, NULL, NULL, NULL, NULL, '0'),
('173', 'Akbar Autos ', 'Akbar Autos ', NULL, 'Hyderabad', '0333-2487232', NULL, NULL, NULL, NULL, NULL, '0'),
('174', 'Arain Autos ', 'Arain Autos ', NULL, 'Hyderabad', '0300-4135566', NULL, NULL, NULL, NULL, NULL, '0'),
('175', 'B.S Autos 2', 'B.S Autos 2', NULL, 'Hyderabad', '0300-3060125', NULL, NULL, NULL, NULL, NULL, '0'),
('176', 'Malik Autos ', 'Malik Autos ', NULL, 'Hyderabad', '0302-3223280', NULL, NULL, NULL, NULL, NULL, '0'),
('177', 'Shah Noorani Autos ', 'Shah Noorani Autos ', NULL, 'Hyderabad', '0300-3258358', NULL, NULL, NULL, NULL, NULL, '0'),
('178', 'Abbassi Auto', 'Abbassi Auto', NULL, 'Hyderabad', '0300-3440086', NULL, NULL, NULL, NULL, NULL, '0'),
('179', 'Karamat Autos', 'Karamat Autos', NULL, 'Hyderabad', '0333-7008985', NULL, NULL, NULL, NULL, NULL, '0'),
('180', 'Madina Autos h', 'Madina Autos h', NULL, 'Hyderabad', '0300-3225547', NULL, NULL, NULL, NULL, NULL, '0'),
('181', 'Madina Autos ', 'Madina Autos ', NULL, 'Hyderabad', '0300-0260717', NULL, NULL, NULL, NULL, NULL, '0'),
('182', 'Mistri Ghulam Rasool', 'Mistri Ghulam Rasool', NULL, 'Hyderabad', '0300-3237440', NULL, NULL, NULL, NULL, NULL, '0'),
('183', 'Naz Autos-Nawabshah', 'Naz Autos-Nawabshah', NULL, 'Hyderabad', '0332-2820990', NULL, NULL, NULL, NULL, NULL, '0'),
('184', 'Sheikh Autos', 'Sheikh Autos', NULL, 'Hyderabad', '0304-2984909', NULL, NULL, NULL, NULL, NULL, '0'),
('185', 'Sindh Autos', 'Sindh Autos', NULL, 'Hyderabad', '0300-7009193', NULL, NULL, NULL, NULL, NULL, '0'),
('186', 'Siraj Autos ', 'Siraj Autos ', NULL, 'Hyderabad', '0333-7004793', NULL, NULL, NULL, NULL, NULL, '0'),
('187', 'Zakir Hussain ', 'Zakir Hussain ', NULL, 'Hyderabad', '0315-3064409', NULL, NULL, NULL, NULL, NULL, '0'),
('188', '786 Autos ', '786 Autos ', NULL, 'Hyderabad', '0313-808876', NULL, NULL, NULL, NULL, NULL, '0'),
('189', 'Mashallah Autos', 'Mashallah Autos', NULL, 'Hyderabad', '0312-2812690', NULL, NULL, NULL, NULL, NULL, '0'),
('190', 'Ashraf Autos ', 'Ashraf Autos ', NULL, 'Hyderabad', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('191', 'sohail And Adeel', 'sohail And Adeel', NULL, 'Hyderabad', '0306-3000592', NULL, NULL, NULL, NULL, NULL, '0'),
('192', 'Sindh Auto', 'Sindh Auto', NULL, 'Hyderabad', '0313-2204586', NULL, NULL, NULL, NULL, NULL, '0'),
('193', 'S.M Tools ', 'S.M Tools ', NULL, 'Hyderabad', '0315-2274799', NULL, NULL, NULL, NULL, NULL, '0'),
('194', 'Shah Noor Autos', 'Shah Noor Autos', NULL, 'Hyderabad', '0316-0039328', NULL, NULL, NULL, NULL, NULL, '0'),
('195', 'Al Furqan Auto', 'Al Furqan Auto', NULL, 'Hyderabad', '0317-3014108', NULL, NULL, NULL, NULL, NULL, '0'),
('196', 'Classic Rubber', 'Classic Rubber', NULL, 'Hyderabad', '0312-2186613', NULL, NULL, NULL, NULL, NULL, '0'),
('197', 'Kamran Autos ', 'Kamran Autos ', NULL, 'Hyderabad', '0312-2186613', NULL, NULL, NULL, NULL, NULL, '0'),
('198', 'Abdullah Auto ', 'Abdullah Auto ', NULL, 'Hyderabad', '0311-3055190', NULL, NULL, NULL, NULL, NULL, '0'),
('199', 'Azan Auto', 'Azan Auto', NULL, 'Hyderabad', 'f', NULL, NULL, NULL, NULL, NULL, '0'),
('200', 'Kashif Wahid Rubber ', 'Kashif Wahid Rubber ', NULL, 'Hyderabad', '0311-2113784', NULL, NULL, NULL, NULL, NULL, '0'),
('201', 'Amir Autos ', 'Amir Autos ', NULL, 'Hyderabad', '0322-720702', NULL, NULL, NULL, NULL, NULL, '0'),
('202', 'Abdul Wahab Autos ', 'Abdul Wahab Autos ', NULL, 'Hyderabad', '0312-9370630', NULL, NULL, NULL, NULL, NULL, '0'),
('203', 'Hussaini Autos', 'Hussaini Autos', NULL, 'Hyderabad', '0300-3270841', NULL, NULL, NULL, NULL, NULL, '0'),
('204', 'Al Hydri Mill Store-', 'Al Hydri Mill Store-', NULL, 'Hyderabad', '0300-9370404', NULL, NULL, NULL, NULL, NULL, '0'),
('205', 'Sindh Machinery ', 'Sindh Machinery ', NULL, 'Hyderabad', '0315-5008551', NULL, NULL, NULL, NULL, NULL, '0'),
('206', 'Badri Mills', 'Badri Mills', NULL, 'Hyderabad', '0333-0355110', NULL, NULL, NULL, NULL, NULL, '0'),
('207', 'Vella Mills Stora', 'Vella Mills Stora', NULL, 'Hyderabad', '0315-5008551', NULL, NULL, NULL, NULL, NULL, '0'),
('208', 'Bohri Mills', 'Bohri Mills', NULL, 'Hyderabad', '0342-4533651', NULL, NULL, NULL, NULL, NULL, '0'),
('209', 'Huzaifa Mill Store ', 'Huzaifa Mill Store ', NULL, 'Hyderabad', '0300-0937078', NULL, NULL, NULL, NULL, NULL, '0'),
('210', 'Adam Jee Wali Jee ', 'Adam Jee Wali Jee ', NULL, 'Hyderabad', '0318-4353080', NULL, NULL, NULL, NULL, NULL, '0'),
('211', 'Fatima Bearing', 'Fatima Bearing', NULL, 'Hyderabad', '0300-3015899', NULL, NULL, NULL, NULL, NULL, '0'),
('212', 'Sharafally Mulla Ahmedji', 'Sharafally Mulla Ahmedji', NULL, 'Hyderabad', '0347-3603033', NULL, NULL, NULL, NULL, NULL, '0'),
('213', 'Muhammadi Mill Store ', 'Muhammadi Mill Store ', NULL, 'Hyderabad', '0334-9058443', NULL, NULL, NULL, NULL, NULL, '0'),
('214', 'Ahmed Bux Rahim Bux ', 'Ahmed Bux Rahim Bux ', NULL, 'Hyderabad', '0333-2655632', NULL, NULL, NULL, NULL, NULL, '0'),
('215', 'Mehran Machinery', 'Mehran Machinery', NULL, 'Hyderabad', '0346-3609611', NULL, NULL, NULL, NULL, NULL, '0'),
('216', 'Asfand Machinery ', 'Asfand Machinery ', NULL, 'Hyderabad', '0321-3001801', NULL, NULL, NULL, NULL, NULL, '0'),
('217', 'Fida Hussain Abdul Ali ', 'Fida Hussain Abdul Ali ', NULL, 'Hyderabad', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('218', 'Hussain Armoury', 'Hussain Armoury', NULL, 'Hyderabad', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('219', 'Alamgir Trader', 'Alamgir Trader', NULL, 'Hyderabad', '0313-3721852', NULL, NULL, NULL, NULL, NULL, '0'),
('220', 'Ahmed Ali Shamsuddin', 'Ahmed Ali Shamsuddin', NULL, 'Hyderabad', '0222-72882', NULL, NULL, NULL, NULL, NULL, '0'),
('221', 'Yousuf Ali Moosaji ', 'Yousuf Ali Moosaji ', NULL, 'Hyderabad', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('222', '786 Auto B Block Model Town-Lahore', '786 Auto B Block Model Town-Lahore', NULL, 'Lahore  Model Town', '0321-1128907', NULL, NULL, NULL, NULL, NULL, '0'),
('223', '786 Auto Badami Bagh LHR', '786 Auto Badami Bagh LHR', NULL, 'Lahore  Badami Bagh', '0336-2334767', NULL, NULL, NULL, NULL, NULL, '0'),
('224', '786 Auto Misri Shah-Lahore', '786 Auto Misri Shah-Lahore', NULL, 'Lahore  Misri Shah', '0323-4442372', NULL, NULL, NULL, NULL, NULL, '0'),
('225', '786 Auto Motors Model Town-Lahore', '786 Auto Motors Model Town-Lahore', NULL, 'Lahore  Model Town', '042-35887786', NULL, NULL, NULL, NULL, NULL, '0'),
('226', 'Aadil Auto Naqi Road Nila Gumbad', 'Aadil Auto Naqi Road Nila Gumbad', NULL, 'Lahore  Nila Gumbad', '0321-9419450', NULL, NULL, NULL, NULL, NULL, '0'),
('227', 'Aamir Brother Auto,Auto Centre B.Bagh', 'Aamir Brother Auto,Auto Centre B.Bagh', NULL, 'Lahore  Badami Bagh', '0300-8808041', NULL, NULL, NULL, NULL, NULL, '0'),
('228', 'Abdul Rehman Auto Badami Bagh', 'Abdul Rehman Auto Badami Bagh', NULL, 'Lahore  Badami Bagh', '0423-224340841', NULL, NULL, NULL, NULL, NULL, '0'),
('229', 'Abia Motors Auto Centre Badami Bagh', 'Abia Motors Auto Centre Badami Bagh', NULL, 'Lahore  Badami Bagh', '0423-7720153', NULL, NULL, NULL, NULL, NULL, '0'),
('230', 'Abid Auto Badami Bagh-Lahore', 'Abid Auto Badami Bagh-Lahore', NULL, 'Lahore  Badami Bagh', '0333-4388550', NULL, NULL, NULL, NULL, NULL, '0'),
('231', 'Adil Arms Nila Gumbad-Lahore', 'Adil Arms Nila Gumbad-Lahore', NULL, 'Lahore  Nila Gumbad', '0423-7313946', NULL, NULL, NULL, NULL, NULL, '0'),
('232', 'Adnan Auto,Auto Centre Basement BB', 'Adnan Auto,Auto Centre Basement BB', NULL, 'Lahore  Badami Bagh', '0323-4889689', NULL, NULL, NULL, NULL, NULL, '0'),
('233', 'Adnan Supplier Badami Bagh', 'Adnan Supplier Badami Bagh', NULL, 'Lahore  Badami Bagh', '0323-4889689', NULL, NULL, NULL, NULL, NULL, '0'),
('234', 'Afia Auto Near Islamia College Sialkot', 'Afia Auto Near Islamia College Sialkot', NULL, 'Lahore  Sialkot', '0321-6107699', NULL, NULL, NULL, NULL, NULL, '0'),
('235', 'Ahmad Autos Peco Road Lahore', 'Ahmad Autos Peco Road Lahore', NULL, 'Lahore  Peco Road', '0340-8482785', NULL, NULL, NULL, NULL, NULL, '0'),
('236', 'Ahsan Autos Badami Bagh-Lahore', 'Ahsan Autos Badami Bagh-Lahore', NULL, 'Lahore  Badami Bagh', '0423-7725433', NULL, NULL, NULL, NULL, NULL, '0'),
('237', 'Akhter Autos Narowal-Lahore', 'Akhter Autos Narowal-Lahore', NULL, 'Lahore  Narowal', '0300-7146863', NULL, NULL, NULL, NULL, NULL, '0'),
('238', 'Al Hadi Auto Badami Bagh-Lahore', 'Al Hadi Auto Badami Bagh-Lahore', NULL, 'Lahore  Badami Bagh', '0331-4117855', NULL, NULL, NULL, NULL, NULL, '0'),
('239', 'Al Khan Auto Lahore', 'Al Khan Auto Lahore', NULL, 'Lahore  Badami Bagh', '0331-8877000', NULL, NULL, NULL, NULL, NULL, '0'),
('240', 'Al Madina Auto Shop #1 Peco Road', 'Al Madina Auto Shop #1 Peco Road', NULL, 'Lahore  Peco Road', '0300-4253830', NULL, NULL, NULL, NULL, NULL, '0'),
('241', 'Al Munir Auto Badami Bagh Lhr', 'Al Munir Auto Badami Bagh Lhr', NULL, 'Lahore  Badami Bagh', '0333-4207971', NULL, NULL, NULL, NULL, NULL, '0'),
('242', 'Al Noor Motors LG 92-93 Auto Centre 2 BB', 'Al Noor Motors LG 92-93 Auto Centre 2 BB', NULL, 'Lahore  Badami Bagh', '0423-7706900', NULL, NULL, NULL, NULL, NULL, '0'),
('243', 'Al Wahab Autos Badami Bagh-Lahore', 'Al Wahab Autos Badami Bagh-Lahore', NULL, 'Lahore  Badami Bagh', '0323-8414985', NULL, NULL, NULL, NULL, NULL, '0'),
('244', 'Al-Waqar Lube Shop-Sargodha', 'Al-Waqar Lube Shop-Sargodha', NULL, 'Lahore  Sargodha', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('245', 'Ali Auto Qasoor Centre Badami Bagh', 'Ali Auto Qasoor Centre Badami Bagh', NULL, 'Lahore  Badami Bagh', '0300-8832398', NULL, NULL, NULL, NULL, NULL, '0'),
('246', 'Ali Usman Auto Badami Bagh', 'Ali Usman Auto Badami Bagh', NULL, 'Lahore  Badami Bagh', '0306-6934122', NULL, NULL, NULL, NULL, NULL, '0'),
('247', 'Altaf Traders 11 Auto Centre Badami Bagh', 'Altaf Traders 11 Auto Centre Badami Bagh', NULL, 'Lahore  Badami Bagh', '0305-4598873', NULL, NULL, NULL, NULL, NULL, '0'),
('248', 'Amaan Autos Badami Bagh-Lahore', 'Amaan Autos Badami Bagh-Lahore', NULL, 'Lahore  Badami Bagh', '0300-4235284', NULL, NULL, NULL, NULL, NULL, '0'),
('249', 'Anas Traders Old Anarkali-Lahore', 'Anas Traders Old Anarkali-Lahore', NULL, 'Lahore  Anarkali', '0333-4536434', NULL, NULL, NULL, NULL, NULL, '0'),
('250', 'Arif Autos A.Block Model Town-Lahore', 'Arif Autos A.Block Model Town-Lahore', NULL, 'Lahore  Model Town', '0423-5882630', NULL, NULL, NULL, NULL, NULL, '0'),
('251', 'Arshad &amp; Co Arms Nila Gumbad-Lahore', 'Arshad &amp; Co Arms Nila Gumbad-Lahore', NULL, 'Lahore  Nila Gumbad', '0423-7113985', NULL, NULL, NULL, NULL, NULL, '0'),
('252', 'Arshad Ali Arms 101 Ravi Road-Lahore', 'Arshad Ali Arms 101 Ravi Road-Lahore', NULL, 'Lahore  Ravi Road', '0321-4920013', NULL, NULL, NULL, NULL, NULL, '0'),
('253', 'Arshad Auto Taj Chamber Basement BB', 'Arshad Auto Taj Chamber Basement BB', NULL, 'Lahore  Badami Bagh', '0337-9793345', NULL, NULL, NULL, NULL, NULL, '0'),
('254', 'Asif Auto Green Market Badami Bagh', 'Asif Auto Green Market Badami Bagh', NULL, 'Lahore  Badami Bagh', '0300-4148536', NULL, NULL, NULL, NULL, NULL, '0'),
('255', 'Asif Auto Model Town-Lahore', 'Asif Auto Model Town-Lahore', NULL, 'Lahore  Model Town', '0324-4173486', NULL, NULL, NULL, NULL, NULL, '0'),
('256', 'Asif Filter Badami Bagh-Lahore', 'Asif Filter Badami Bagh-Lahore', NULL, 'Lahore  Badami Bagh', '0315-4534461', NULL, NULL, NULL, NULL, NULL, '0'),
('257', 'Auto Centre Shad Bagh Near Allied Bank', 'Auto Centre Shad Bagh Near Allied Bank', NULL, 'Lahore  Shad Bagh', '0321-8479163', NULL, NULL, NULL, NULL, NULL, '0'),
('258', 'Ayub Arm Misri Shah Ganda Nala-Lahore', 'Ayub Arm Misri Shah Ganda Nala-Lahore', NULL, 'Lahore  Misri Shah', '0311-0424172', NULL, NULL, NULL, NULL, NULL, '0'),
('259', 'Bakhshi Auto Peco Road Kot Lakh Pat', 'Bakhshi Auto Peco Road Kot Lakh Pat', NULL, 'Lahore  Peco Road', '0322-4102839', NULL, NULL, NULL, NULL, NULL, '0'),
('260', 'Bakhar Aslah House,Sargodha-Lahore', 'Bakhar Aslah House,Sargodha-Lahore', NULL, 'Lahore  Sargodha', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('261', 'Bilal Autos Badami Bagh-Lahore', 'Bilal Autos Badami Bagh-Lahore', NULL, 'Lahore  Badami Bagh', '0423-7722331', NULL, NULL, NULL, NULL, NULL, '0'),
('262', 'Bismillah Autos Township-Lahore', 'Bismillah Autos Township-Lahore', NULL, 'Lahore  Township', '0323-8839077', NULL, NULL, NULL, NULL, NULL, '0'),
('263', 'Bismillah Oil Township-Lahore', 'Bismillah Oil Township-Lahore', NULL, 'Lahore  Township', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('264', 'Bukhari Traders Peco Road-Lahore', 'Bukhari Traders Peco Road-Lahore', NULL, 'Lahore  Peco Road', '0423-5833497', NULL, NULL, NULL, NULL, NULL, '0'),
('265', 'Buraq Motors Peco Road Kot Lakpat-Lahore', 'Buraq Motors Peco Road Kot Lakpat-Lahore', NULL, 'Lahore  Peco Road', '0423-5946344', NULL, NULL, NULL, NULL, NULL, '0'),
('266', 'Butt Auto Shad Bagh Near Allied Bank', 'Butt Auto Shad Bagh Near Allied Bank', NULL, 'Lahore  Shad Bagh', '0300-4353052', NULL, NULL, NULL, NULL, NULL, '0'),
('267', 'Car Care Township Peco Road-Lahore', 'Car Care Township Peco Road-Lahore', NULL, 'Lahore  Peco Road', '0423-5141626,0322-4991827', NULL, NULL, NULL, NULL, NULL, '0'),
('268', 'Chand Terminal Supplier Badami Bagh', 'Chand Terminal Supplier Badami Bagh', NULL, 'Lahore  Badami Bagh', '0324-8406305', NULL, NULL, NULL, NULL, NULL, '0'),
('269', 'Chaudhry Arms Nila Gumbad Lahore', 'Chaudhry Arms Nila Gumbad Lahore', NULL, 'Lahore  Nila Gumbad', '0300-9554101', NULL, NULL, NULL, NULL, NULL, '0'),
('270', 'Dar Autos Badami Bagh-Lahore', 'Dar Autos Badami Bagh-Lahore', NULL, 'Lahore  Badami Bagh', '0423-7726490', NULL, NULL, NULL, NULL, NULL, '0'),
('271', 'Ebba Motors Autos Centre Badami Bagh Lhr', 'Ebba Motors Autos Centre Badami Bagh Lhr', NULL, 'Lahore  Badami Bagh', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('272', 'Ehsan Autos Qadri Chowk Town Ship-Lahore', 'Ehsan Autos Qadri Chowk Town Ship-Lahore', NULL, 'Lahore  Township', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('273', 'Faisal Supplier Township-Lahore', 'Faisal Supplier Township-Lahore', NULL, 'Lahore  Township', '0336-4273646', NULL, NULL, NULL, NULL, NULL, '0'),
('274', 'FOCOUS ARMS NILS GUMBAND MALL VIEW LHR', 'FOCOUS ARMS NILS GUMBAND MALL VIEW LHR', NULL, 'Lahore  Nila Gumbad', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('275', 'Friends Arms', 'Friends Arms', NULL, 'Lahore  Badami Bagh', '0345-4585000', NULL, NULL, NULL, NULL, NULL, '0'),
('276', 'G.M Autos A-Block Model Town-Lahore', 'G.M Autos A-Block Model Town-Lahore', NULL, 'Lahore  Model Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('277', 'Green Autos Badami Bagh-Lahore', 'Green Autos Badami Bagh-Lahore', NULL, 'Lahore  Badami Bagh', '0423-7701462', NULL, NULL, NULL, NULL, NULL, '0'),
('278', 'H Hamid&amp;co Pvt (ltd) Mall View LHR', 'H Hamid&amp;co Pvt (ltd) Mall View LHR', NULL, 'Lahore  Nila Gumbad', '0423-7116556', NULL, NULL, NULL, NULL, NULL, '0'),
('279', 'Hafiz Traders Badami Bagh Lahore', 'Hafiz Traders Badami Bagh Lahore', NULL, 'Lahore  Badami Bagh', '0300-4740035', NULL, NULL, NULL, NULL, NULL, '0'),
('280', 'Haider Arms Mall View Nila Gumbad', 'Haider Arms Mall View Nila Gumbad', NULL, 'Lahore  Nila Gumbad', '0300-4320877', NULL, NULL, NULL, NULL, NULL, '0'),
('281', 'Haji Auto Chowk Na Khuda-Lahore', 'Haji Auto Chowk Na Khuda-Lahore', NULL, 'Lahore  Chowk Nakhuda', '0303-8284688', NULL, NULL, NULL, NULL, NULL, '0'),
('282', 'Haji Jannat Arms 63 Ravi Road-Lahore', 'Haji Jannat Arms 63 Ravi Road-Lahore', NULL, 'Lahore  Ravi Road', '0344-4404396', NULL, NULL, NULL, NULL, NULL, '0'),
('283', 'Haji Zar Wali Arms Bhatti Chowk LHR', 'Haji Zar Wali Arms Bhatti Chowk LHR', NULL, 'Lahore  Bhatti Chowk', '0336-3649907', NULL, NULL, NULL, NULL, NULL, '0'),
('284', 'Hajveri Auot Khokhar Road-Lahore', 'Hajveri Auot Khokhar Road-Lahore', NULL, 'Lahore  Khokhar Road', '0322-8437798', NULL, NULL, NULL, NULL, NULL, '0'),
('285', 'Hamza Autos Model Town-Lahore', 'Hamza Autos Model Town-Lahore', NULL, 'Lahore  Model Town', '0321-4251771', NULL, NULL, NULL, NULL, NULL, '0'),
('286', 'Hamza Eagle Eye Phase II Badami Bagh', 'Hamza Eagle Eye Phase II Badami Bagh', NULL, 'Lahore  Badami Bagh', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('287', 'HANAN TAYYAB AUTO BADAMI BAGH LHR', 'HANAN TAYYAB AUTO BADAMI BAGH LHR', NULL, 'Lahore  Badami Bagh', '0423-7721600', NULL, NULL, NULL, NULL, NULL, '0'),
('288', 'Haq Auto Model Town-Lahore', 'Haq Auto Model Town-Lahore', NULL, 'Lahore  Model Town', '0300-4513255', NULL, NULL, NULL, NULL, NULL, '0'),
('289', 'Hassan Ali Auto,Auto Centre Badami Bagh', 'Hassan Ali Auto,Auto Centre Badami Bagh', NULL, 'Lahore  Badami Bagh', '0322-9191910', NULL, NULL, NULL, NULL, NULL, '0'),
('290', 'Hassan Khan Arms Ravi Road-Lahore', 'Hassan Khan Arms Ravi Road-Lahore', NULL, 'Lahore  Ravi Road', '0423-7707634', NULL, NULL, NULL, NULL, NULL, '0'),
('291', 'Heera Autos Peco Road-Lahore', 'Heera Autos Peco Road-Lahore', NULL, 'Lahore  Peco Road', '0345-4623909', NULL, NULL, NULL, NULL, NULL, '0'),
('292', 'Hira Arms Nila Gumbad-Lahore', 'Hira Arms Nila Gumbad-Lahore', NULL, 'Lahore  Nila Gumbad', '0423-7322224', NULL, NULL, NULL, NULL, NULL, '0'),
('293', 'Honda Canal Bank Motor Johar Town-Lahore', 'Honda Canal Bank Motor Johar Town-Lahore', NULL, 'Lahore  Johar Town', '0423-5300822-3', NULL, NULL, NULL, NULL, NULL, '0'),
('294', 'Honda City Sale Ferozpur Road Lhr', 'Honda City Sale Ferozpur Road Lhr', NULL, 'Lahore  Ferozpur Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('295', 'Honda Fort Pvt Ltd Queen Road-Lahore', 'Honda Fort Pvt Ltd Queen Road-Lahore', NULL, 'Lahore  Queens Road', '0423-6309062', NULL, NULL, NULL, NULL, NULL, '0'),
('296', 'Honda Point Pvt Ltd Airport Road-Lahore', 'Honda Point Pvt Ltd Airport Road-Lahore', NULL, 'Lahore  Airport Road', '0423-5700994-7', NULL, NULL, NULL, NULL, NULL, '0'),
('297', 'Honda Town Ship Peco Road Lahore', 'Honda Town Ship Peco Road Lahore', NULL, 'Lahore  Peco Road', '0423-5843995', NULL, NULL, NULL, NULL, NULL, '0'),
('298', 'Hundai Town Ship Motors Peco Road-Lahore', 'Hundai Town Ship Motors Peco Road-Lahore', NULL, 'Lahore  Peco Road', '0423-5151518-9', NULL, NULL, NULL, NULL, NULL, '0'),
('299', 'Hyundai Motors Airport Road Lahore', 'Hyundai Motors Airport Road Lahore', NULL, 'Lahore  Airport Road', '0305-4414167', NULL, NULL, NULL, NULL, NULL, '0'),
('300', 'I.F Suzuki Peco Road-Lahore', 'I.F Suzuki Peco Road-Lahore', NULL, 'Lahore  Peco Road', '0423-5920199', NULL, NULL, NULL, NULL, NULL, '0'),
('301', 'Ikhlaq Auto Khalid Centre Township', 'Ikhlaq Auto Khalid Centre Township', NULL, 'Lahore  Township', '0321-4894633', NULL, NULL, NULL, NULL, NULL, '0'),
('302', 'Imran &amp; Co. Arms Nila Gumbad - Lahore', 'Imran &amp; Co. Arms Nila Gumbad - Lahore', NULL, 'Lahore  Nila Gumbad', '0423-7357315', NULL, NULL, NULL, NULL, NULL, '0'),
('303', 'Inaam Auto G 39-40 Auto Centre Badami B', 'Inaam Auto G 39-40 Auto Centre Badami B', NULL, 'Lahore  Badami Bagh', '0300-8067675', NULL, NULL, NULL, NULL, NULL, '0'),
('304', 'Iqbal Aslah House,Sargodha-Lahore', 'Iqbal Aslah House,Sargodha-Lahore', NULL, 'Lahore  Sargodha', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('305', 'Iqbal Auto Naqi Road Nila Gumbad', 'Iqbal Auto Naqi Road Nila Gumbad', NULL, 'Lahore  Nila Gumbad', '0423-7323601', NULL, NULL, NULL, NULL, NULL, '0'),
('306', 'Ishfaq Auto, Auto Centre Basement B.Bagh', 'Ishfaq Auto, Auto Centre Basement B.Bagh', NULL, 'Lahore  Badami Bagh', '0303-5014625', NULL, NULL, NULL, NULL, NULL, '0'),
('307', 'Isuzu Ravi Motors Tokhar Niaz Baig Lhr', 'Isuzu Ravi Motors Tokhar Niaz Baig Lhr', NULL, 'Lahore  Lahore-Branch', '0334-1043353', NULL, NULL, NULL, NULL, NULL, '0'),
('308', 'Itefaq Autos Peco Road-Lahore', 'Itefaq Autos Peco Road-Lahore', NULL, 'Lahore  Peco Road', '042-35970044,0332-4531763', NULL, NULL, NULL, NULL, NULL, '0'),
('309', 'Jabir Khan Arm Ravi Road-Lahore', 'Jabir Khan Arm Ravi Road-Lahore', NULL, 'Lahore  Ravi Road', '0300-4007421', NULL, NULL, NULL, NULL, NULL, '0'),
('310', 'Japan Autos Peco Road-Lahore', 'Japan Autos Peco Road-Lahore', NULL, 'Lahore  Peco Road', '0300-9475092', NULL, NULL, NULL, NULL, NULL, '0'),
('311', 'Javed Sons Qasoor Centre Badami Bagh', 'Javed Sons Qasoor Centre Badami Bagh', NULL, 'Lahore  Badami Bagh', '0311-7722727', NULL, NULL, NULL, NULL, NULL, '0'),
('312', 'Junaid Autos Q.Block Model Town-Lahore', 'Junaid Autos Q.Block Model Town-Lahore', NULL, 'Lahore  Model Town', '0323-4816046', NULL, NULL, NULL, NULL, NULL, '0'),
('313', 'K G N Auto Supply Badami Bagh Lahore', 'K G N Auto Supply Badami Bagh Lahore', NULL, 'Lahore  Badami Bagh', '0313-7070888', NULL, NULL, NULL, NULL, NULL, '0'),
('314', 'Kamboo Auto Al Nasir Plaza Badami Bagh', 'Kamboo Auto Al Nasir Plaza Badami Bagh', NULL, 'Lahore  Badami Bagh', '0301-4143566', NULL, NULL, NULL, NULL, NULL, '0'),
('315', 'Kazim Battery Model Town Lahore', 'Kazim Battery Model Town Lahore', NULL, 'Lahore  Model Town', '0333-8444176', NULL, NULL, NULL, NULL, NULL, '0'),
('316', 'Khalid Motors Nabi Park-Lahore', 'Khalid Motors Nabi Park-Lahore', NULL, 'Lahore  Nabi Park', '0423-7726295', NULL, NULL, NULL, NULL, NULL, '0'),
('317', 'Khalid Motors Oil Ravi Road-Lahore', 'Khalid Motors Oil Ravi Road-Lahore', NULL, 'Lahore  Ravi Road', '0321-4587376', NULL, NULL, NULL, NULL, NULL, '0'),
('318', 'Khan Arm Misri Shah-Lahore', 'Khan Arm Misri Shah-Lahore', NULL, 'Lahore  Misri Shah', '0300-4132980', NULL, NULL, NULL, NULL, NULL, '0'),
('319', 'Khan Brother Aslah Dealer Ravi Road Lhr', 'Khan Brother Aslah Dealer Ravi Road Lhr', NULL, 'Lahore  Ravi Road', '042-37730092', NULL, NULL, NULL, NULL, NULL, '0'),
('320', 'Khan Industries 23/191,Mori Gate-Sialkot', 'Khan Industries 23/191,Mori Gate-Sialkot', NULL, 'Lahore  Sialkot', '0333-8643090', NULL, NULL, NULL, NULL, NULL, '0'),
('321', 'Khizar Motor 58-Ravi Road-Lahore', 'Khizar Motor 58-Ravi Road-Lahore', NULL, 'Lahore  Ravi Road', '0324-4344510', NULL, NULL, NULL, NULL, NULL, '0'),
('322', 'Khurram Ashraf House No 2 Badami Bagh', 'Khurram Ashraf House No 2 Badami Bagh', NULL, 'Lahore  Badami Bagh', '3214502247', NULL, NULL, NULL, NULL, NULL, '0'),
('323', 'Kia Motors Kings Gate Multan Road LHR', 'Kia Motors Kings Gate Multan Road LHR', NULL, 'Lahore  Multan Road', '3226701556', NULL, NULL, NULL, NULL, NULL, '0'),
('324', 'Labaik Petroleum Badami Bagh Lahore', 'Labaik Petroleum Badami Bagh Lahore', NULL, 'Lahore  Badami Bagh', '0322-7010001', NULL, NULL, NULL, NULL, NULL, '0'),
('325', 'Lahore Auto Model Town-Lahore', 'Lahore Auto Model Town-Lahore', NULL, 'Lahore  Model Town', '0323-4921821', NULL, NULL, NULL, NULL, NULL, '0'),
('326', 'Lahore Light Centre 189 Green Market BB', 'Lahore Light Centre 189 Green Market BB', NULL, 'Lahore  Badami Bagh', '0423-7726786', NULL, NULL, NULL, NULL, NULL, '0'),
('327', 'Lal Din &amp; Sons Badami Bagh Lahore', 'Lal Din &amp; Sons Badami Bagh Lahore', NULL, 'Lahore  Badami Bagh', '0423-7709340', NULL, NULL, NULL, NULL, NULL, '0'),
('328', 'Latif Autos Badami Bagh-Lahore', 'Latif Autos Badami Bagh-Lahore', NULL, 'Lahore  Badami Bagh', '0423-7700717', NULL, NULL, NULL, NULL, NULL, '0'),
('329', 'LDS TRADER BADAMI BAGH LHR', 'LDS TRADER BADAMI BAGH LHR', NULL, 'Lahore  Badami Bagh', '0423-7700215', NULL, NULL, NULL, NULL, NULL, '0'),
('330', 'MG Motors Packages Mall Lahore', 'MG Motors Packages Mall Lahore', NULL, 'Lahore  Mall', '0300-4341675', NULL, NULL, NULL, NULL, NULL, '0'),
('331', 'M Ali Brothers Badami Bagh', 'M Ali Brothers Badami Bagh', NULL, 'Lahore  Badami Bagh', '0423-7704616', NULL, NULL, NULL, NULL, NULL, '0'),
('332', 'M.A Autos Model Town-Lahore', 'M.A Autos Model Town-Lahore', NULL, 'Lahore  Model Town', '0323-4147112', NULL, NULL, NULL, NULL, NULL, '0'),
('333', 'M.Abbas &amp; Brothers Badami Bagh-Lahore', 'M.Abbas &amp; Brothers Badami Bagh-Lahore', NULL, 'Lahore  Badami Bagh', '042-37727173', NULL, NULL, NULL, NULL, NULL, '0'),
('334', 'M.Anwar-ul-Haq &amp; Sons Nila Gumbad-Lahore', 'M.Anwar-ul-Haq &amp; Sons Nila Gumbad-Lahore', NULL, 'Lahore  Nila Gumbad', '0423-7234814,0300-4822509', NULL, NULL, NULL, NULL, NULL, '0'),
('335', 'M.Iqbal Ishaq Arms Nila Gumbad-Lahore', 'M.Iqbal Ishaq Arms Nila Gumbad-Lahore', NULL, 'Lahore  Nila Gumbad', '0423-7324563,0313-37324563', NULL, NULL, NULL, NULL, NULL, '0'),
('336', 'M.T.C Auto,Auto Centre Badami Bagh', 'M.T.C Auto,Auto Centre Badami Bagh', NULL, 'Lahore  Badami Bagh', '0348-2120750', NULL, NULL, NULL, NULL, NULL, '0'),
('337', 'Madina Auto Peco Road-Lahore', 'Madina Auto Peco Road-Lahore', NULL, 'Lahore  Peco Road', '0423-5970069', NULL, NULL, NULL, NULL, NULL, '0'),
('338', 'Madina Motor Auto Center Badami Bagh-LHR', 'Madina Motor Auto Center Badami Bagh-LHR', NULL, 'Lahore  Badami Bagh', '0423-7946846,0322-8693853', NULL, NULL, NULL, NULL, NULL, '0'),
('339', 'Madina Oil Traders Badami Bagh-Lahore', 'Madina Oil Traders Badami Bagh-Lahore', NULL, 'Lahore  Badami Bagh', '0423-7728626,0321-4142984', NULL, NULL, NULL, NULL, NULL, '0'),
('340', 'Madni Auto Khokhar Road Near City Kanta', 'Madni Auto Khokhar Road Near City Kanta', NULL, 'Lahore  Khokhar Road', '0323-4160102', NULL, NULL, NULL, NULL, NULL, '0'),
('341', 'Makkhan Air Gun Block No 5 Lahore', 'Makkhan Air Gun Block No 5 Lahore', NULL, 'Lahore  Badami Bagh', '0304-8600246', NULL, NULL, NULL, NULL, NULL, '0'),
('342', 'Makki Oil Traders Peco Road-Lahore', 'Makki Oil Traders Peco Road-Lahore', NULL, 'Lahore  Peco Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('343', 'Malik Arm Misri Shah-Lahore', 'Malik Arm Misri Shah-Lahore', NULL, 'Lahore  Misri Shah', '0321-8898392', NULL, NULL, NULL, NULL, NULL, '0'),
('344', 'Malik Auto Khokhar Road-Lahore', 'Malik Auto Khokhar Road-Lahore', NULL, 'Lahore  Khokhar Road', '0303-8811632', NULL, NULL, NULL, NULL, NULL, '0'),
('345', 'Malik G Auto 516 Main Peco Road', 'Malik G Auto 516 Main Peco Road', NULL, 'Lahore  Peco Road', '0300-6205320', NULL, NULL, NULL, NULL, NULL, '0'),
('346', 'Malik Ji Oil Peco Road-Lahore', 'Malik Ji Oil Peco Road-Lahore', NULL, 'Lahore  Peco Road', '0423-5943171,0300-6205320', NULL, NULL, NULL, NULL, NULL, '0'),
('347', 'Malik Traders Arms Nila Gumbad-Lahore', 'Malik Traders Arms Nila Gumbad-Lahore', NULL, 'Lahore  Nila Gumbad', '0301-4306346', NULL, NULL, NULL, NULL, NULL, '0'),
('348', 'Mansoor Mehboob Autos Model Town Lhr', 'Mansoor Mehboob Autos Model Town Lhr', NULL, 'Lahore  Model Town', '0423-5851938', NULL, NULL, NULL, NULL, NULL, '0'),
('349', 'Manzoor Autos Model Town-Lahore', 'Manzoor Autos Model Town-Lahore', NULL, 'Lahore  Model Town', '0423-5856929,0323-4299903', NULL, NULL, NULL, NULL, NULL, '0'),
('350', 'Mian Akram Auto Qadri Chowk Township', 'Mian Akram Auto Qadri Chowk Township', NULL, 'Lahore  Township', '0423-5150829', NULL, NULL, NULL, NULL, NULL, '0'),
('351', 'Mian Autos Model Town-Lahore', 'Mian Autos Model Town-Lahore', NULL, 'Lahore  Model Town', '0423-5855034', NULL, NULL, NULL, NULL, NULL, '0'),
('352', 'Modern Poshash Badami Bagh-Lahore', 'Modern Poshash Badami Bagh-Lahore', NULL, 'Lahore  Badami Bagh', '0324-4118493', NULL, NULL, NULL, NULL, NULL, '0'),
('353', 'Mohsin Auto Green Market Badami Bagh', 'Mohsin Auto Green Market Badami Bagh', NULL, 'Lahore  Badami Bagh', '0304-4818948', NULL, NULL, NULL, NULL, NULL, '0'),
('354', 'Mokal International Arms Nila Gumbad-LHR', 'Mokal International Arms Nila Gumbad-LHR', NULL, 'Lahore  Nila Gumbad', '042-37310689', NULL, NULL, NULL, NULL, NULL, '0'),
('355', 'Montgomery Autos Township-Lahore', 'Montgomery Autos Township-Lahore', NULL, 'Lahore  Township', '0423-5213312', NULL, NULL, NULL, NULL, NULL, '0'),
('356', 'Muaz Autos Badami Bagh-Lahore', 'Muaz Autos Badami Bagh-Lahore', NULL, 'Lahore  Badami Bagh', '0423-7724502', NULL, NULL, NULL, NULL, NULL, '0'),
('357', 'Muraad Engineering Co. Johar Town-Lahore', 'Muraad Engineering Co. Johar Town-Lahore', NULL, 'Lahore  Johar Town', '0323-4444119', NULL, NULL, NULL, NULL, NULL, '0'),
('358', 'Mueed Saleem MIB Data Centre Kot Lakh Pa', 'Mueed Saleem MIB Data Centre Kot Lakh Pa', NULL, 'Lahore  Kot Lakh Pat', '0323-4355668', NULL, NULL, NULL, NULL, NULL, '0'),
('359', 'Mughal Auto G.T Road Mian Channu', 'Mughal Auto G.T Road Mian Channu', NULL, 'Lahore  Mian Channu', '0346-7930196', NULL, NULL, NULL, NULL, NULL, '0'),
('360', 'Nadeem Auto Badami Bagh', 'Nadeem Auto Badami Bagh', NULL, 'Lahore  Badami Bagh', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('361', 'Naeem Auto Misri Shah-Lahore', 'Naeem Auto Misri Shah-Lahore', NULL, 'Lahore  Misri Shah', '0320-0406533', NULL, NULL, NULL, NULL, NULL, '0'),
('362', 'Naeem Sons Badami Bagh-Lahore', 'Naeem Sons Badami Bagh-Lahore', NULL, 'Lahore  Badami Bagh', '0323-9573409', NULL, NULL, NULL, NULL, NULL, '0'),
('363', 'Naveed Khan &amp; Co Ravi Road Lahore', 'Naveed Khan &amp; Co Ravi Road Lahore', NULL, 'Lahore  Ravi Road', '0323-9876592', NULL, NULL, NULL, NULL, NULL, '0'),
('364', 'Nazir Arms Ravi Road Lahore', 'Nazir Arms Ravi Road Lahore', NULL, 'Lahore  Ravi Road', '0300-4914418', NULL, NULL, NULL, NULL, NULL, '0'),
('365', 'New Alfalah Autos Ravi Road-Lahore', 'New Alfalah Autos Ravi Road-Lahore', NULL, 'Lahore  Ravi Road', '0320-4064604', NULL, NULL, NULL, NULL, NULL, '0'),
('366', 'New Auto World Qadri Chowk Township', 'New Auto World Qadri Chowk Township', NULL, 'Lahore  Township', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('367', 'New Faiz Lasani Autos Badami Bagh-Lahore', 'New Faiz Lasani Autos Badami Bagh-Lahore', NULL, 'Lahore  Badami Bagh', '0423-7725244', NULL, NULL, NULL, NULL, NULL, '0'),
('368', 'New Khan Road Runners LTD-Lahore', 'New Khan Road Runners LTD-Lahore', NULL, 'Lahore  Badami Bagh', '0303-6782454', NULL, NULL, NULL, NULL, NULL, '0'),
('369', 'New Punjab Auto Model Town-Lahore', 'New Punjab Auto Model Town-Lahore', NULL, 'Lahore  Model Town', '0304-4754826', NULL, NULL, NULL, NULL, NULL, '0'),
('370', 'Nisar Khan Supplier Badami Bagh Lahore', 'Nisar Khan Supplier Badami Bagh Lahore', NULL, 'Lahore  Badami Bagh', '0322-4498297', NULL, NULL, NULL, NULL, NULL, '0'),
('371', 'Noman Auto Badami Bagh Lahore', 'Noman Auto Badami Bagh Lahore', NULL, 'Lahore  Badami Bagh', '0321-4903110', NULL, NULL, NULL, NULL, NULL, '0'),
('372', 'Noman Autos Badami Bagh-Lahore', 'Noman Autos Badami Bagh-Lahore', NULL, 'Lahore  Badami Bagh', '0423-7700117', NULL, NULL, NULL, NULL, NULL, '0'),
('373', 'Orient Trader Mall View Nila Gumbad', 'Orient Trader Mall View Nila Gumbad', NULL, 'Lahore  Nila Gumbad', '0333-4510891', NULL, NULL, NULL, NULL, NULL, '0'),
('374', 'Pak Auto Agency Badami Bagh', 'Pak Auto Agency Badami Bagh', NULL, 'Lahore  Badami Bagh', '0423-7704253', NULL, NULL, NULL, NULL, NULL, '0');
INSERT INTO `0_crm_persons` VALUES
('375', 'Pakistan Auto Oil Ravi Road', 'Pakistan Auto Oil Ravi Road', NULL, 'Lahore  Ravi Road', '0321-4315909', NULL, NULL, NULL, NULL, NULL, '0'),
('376', 'Prime Motors Badami Bagh Lahore', 'Prime Motors Badami Bagh Lahore', NULL, 'Lahore  Badami Bagh', '0324-7717666', NULL, NULL, NULL, NULL, NULL, '0'),
('377', 'Punjab Filter House Fasilabad', 'Punjab Filter House Fasilabad', NULL, 'Lahore  Faislabad', '0332-6676229', NULL, NULL, NULL, NULL, NULL, '0'),
('378', 'Qadria Motor Naqi Road Nila Gumbad', 'Qadria Motor Naqi Road Nila Gumbad', NULL, 'Lahore  Nila Gumbad', '0423-7323597', NULL, NULL, NULL, NULL, NULL, '0'),
('379', 'Ramzan Auto Ramzan Chamber Badami Bagh', 'Ramzan Auto Ramzan Chamber Badami Bagh', NULL, 'Lahore  Badami Bagh', '0323-4141177', NULL, NULL, NULL, NULL, NULL, '0'),
('380', 'Rashad Auto A Block Model Town', 'Rashad Auto A Block Model Town', NULL, 'Lahore  Model Town', '0333-4232760', NULL, NULL, NULL, NULL, NULL, '0'),
('381', 'Rashid Arm Mall View Nila Gumbad', 'Rashid Arm Mall View Nila Gumbad', NULL, 'Lahore  Nila Gumbad', '0302-4796094', NULL, NULL, NULL, NULL, NULL, '0'),
('382', 'Ratta Auto Main Peco Road Town Ship', 'Ratta Auto Main Peco Road Town Ship', NULL, 'Lahore  Township', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('383', 'Ravi Auto 227-N Block Model Town Ext', 'Ravi Auto 227-N Block Model Town Ext', NULL, 'Lahore  Model Town', '0305-4480566', NULL, NULL, NULL, NULL, NULL, '0'),
('384', 'Rehman Auto Centre Badami Bagh Lhr', 'Rehman Auto Centre Badami Bagh Lhr', NULL, 'Lahore  Badami Bagh', '0423-7730117', NULL, NULL, NULL, NULL, NULL, '0'),
('385', 'Rehman Autos Qadri Chowk-Lahore', 'Rehman Autos Qadri Chowk-Lahore', NULL, 'Lahore  Township', '0323-8841762', NULL, NULL, NULL, NULL, NULL, '0'),
('386', 'Rizwan Oil Store Green Market BB', 'Rizwan Oil Store Green Market BB', NULL, 'Lahore  Badami Bagh', '0300-4172556', NULL, NULL, NULL, NULL, NULL, '0'),
('387', 'Sabri Trading Co. Railway Road-Lahore', 'Sabri Trading Co. Railway Road-Lahore', NULL, 'Lahore  Railway Road', '0423-7653900', NULL, NULL, NULL, NULL, NULL, '0'),
('388', 'Saad Traders Sargodha Road Mianwali', 'Saad Traders Sargodha Road Mianwali', NULL, 'Lahore  Mianwali', '459235695,0300-8604595', NULL, NULL, NULL, NULL, NULL, '0'),
('389', 'Saeed Air Guns Arms Mall View', 'Saeed Air Guns Arms Mall View', NULL, 'Lahore  Nila Gumbad', '0335-9259707', NULL, NULL, NULL, NULL, NULL, '0'),
('390', 'Salman Autos Peco Road-Lahore', 'Salman Autos Peco Road-Lahore', NULL, 'Lahore  Peco Road', '0423-5885180', NULL, NULL, NULL, NULL, NULL, '0'),
('391', 'Saqib Auto Badami Bagh-Lahore', 'Saqib Auto Badami Bagh-Lahore', NULL, 'Lahore  Badami Bagh', '0300-9424821', NULL, NULL, NULL, NULL, NULL, '0'),
('392', 'Shabir Oil Store Township-Lahore', 'Shabir Oil Store Township-Lahore', NULL, 'Lahore  Township', '0300-8182499', NULL, NULL, NULL, NULL, NULL, '0'),
('393', 'Shah Mehmood Shad Bagh Near Meezan Bank', 'Shah Mehmood Shad Bagh Near Meezan Bank', NULL, 'Lahore  Shad Bagh', '0312-4266586', NULL, NULL, NULL, NULL, NULL, '0'),
('394', 'Shah Wali &amp; Son Arms New Anarkali-Lahore', 'Shah Wali &amp; Son Arms New Anarkali-Lahore', NULL, 'Lahore  Anarkali', '0322-8039328', NULL, NULL, NULL, NULL, NULL, '0'),
('395', 'Shahbaz Autos Badami Bagh-Lahore', 'Shahbaz Autos Badami Bagh-Lahore', NULL, 'Lahore  Badami Bagh', '0423-7726275,0321-4365664', NULL, NULL, NULL, NULL, NULL, '0'),
('396', 'Shahid Sons Autos Badami Bagh-Lahore', 'Shahid Sons Autos Badami Bagh-Lahore', NULL, 'Lahore  Badami Bagh', '0423-7700886', NULL, NULL, NULL, NULL, NULL, '0'),
('397', 'Shaheen Auto Store Narowal-Lahore', 'Shaheen Auto Store Narowal-Lahore', NULL, 'Lahore  Narowal', '0300-7760836', NULL, NULL, NULL, NULL, NULL, '0'),
('398', 'Shakil Autos Badami Bagh-Lahore', 'Shakil Autos Badami Bagh-Lahore', NULL, 'Lahore  Badami Bagh', '0323-4693709', NULL, NULL, NULL, NULL, NULL, '0'),
('399', 'Shalimar Arms Co Mall Road Lahore', 'Shalimar Arms Co Mall Road Lahore', NULL, 'Lahore  Mall Road', '0321-9464111', NULL, NULL, NULL, NULL, NULL, '0'),
('400', 'Shamim Auto Naqi Road Nila Gumbad', 'Shamim Auto Naqi Road Nila Gumbad', NULL, 'Lahore  Nila Gumbad', '0333-4244488', NULL, NULL, NULL, NULL, NULL, '0'),
('401', 'Shan Auto Ghory Shah Road-Lahore', 'Shan Auto Ghory Shah Road-Lahore', NULL, 'Lahore  Ghory Shah', '0300-4999787', NULL, NULL, NULL, NULL, NULL, '0'),
('402', 'Sheikh Auto New LMC Market Badami Bagh', 'Sheikh Auto New LMC Market Badami Bagh', NULL, 'Lahore  Badami Bagh', '0337-4961805', NULL, NULL, NULL, NULL, NULL, '0'),
('403', 'Sheikh Autos Qadri Chowk Township-Lahore', 'Sheikh Autos Qadri Chowk Township-Lahore', NULL, 'Lahore  Township', '0321-4790485', NULL, NULL, NULL, NULL, NULL, '0'),
('404', 'Sheikh Ehsan Auto Qadri Chowk Township', 'Sheikh Ehsan Auto Qadri Chowk Township', NULL, 'Lahore  Township', '0307-4128036', NULL, NULL, NULL, NULL, NULL, '0'),
('405', 'Sheraz Oil Traders New LMC Market BB', 'Sheraz Oil Traders New LMC Market BB', NULL, 'Lahore  Badami Bagh', '0301-8484834', NULL, NULL, NULL, NULL, NULL, '0'),
('406', 'Shoaib Autos Badami Bagh-Lahore', 'Shoaib Autos Badami Bagh-Lahore', NULL, 'Lahore  Badami Bagh', '0423-7707656,0300-8195226', NULL, NULL, NULL, NULL, NULL, '0'),
('407', 'Sigma Motors DHA Phase 8-Lahore', 'Sigma Motors DHA Phase 8-Lahore', NULL, 'Lahore  Dha Phase 8', '0423-7337411-2', NULL, NULL, NULL, NULL, NULL, '0'),
('408', 'Smart Honda Badian Road Lahore', 'Smart Honda Badian Road Lahore', NULL, 'Lahore  Badian Road', '0321-4341117', NULL, NULL, NULL, NULL, NULL, '0'),
('409', 'Sufi Autos Nila Gumbad-Lahore', 'Sufi Autos Nila Gumbad-Lahore', NULL, 'Lahore  Nila Gumbad', '0333-4283967', NULL, NULL, NULL, NULL, NULL, '0'),
('410', 'Sunny Autos Peco Road Lahore', 'Sunny Autos Peco Road Lahore', NULL, 'Lahore  Peco Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('411', 'Suntec Autos Peco Road-Lahore', 'Suntec Autos Peco Road-Lahore', NULL, 'Lahore  Peco Road', '0423-5946654,0300-42127008', NULL, NULL, NULL, NULL, NULL, '0'),
('412', 'Suzuki Canal Motors 13 Km Multan Road', 'Suzuki Canal Motors 13 Km Multan Road', NULL, 'Lahore  Multan Road', '0304-0064654', NULL, NULL, NULL, NULL, NULL, '0'),
('413', 'SUZUKI PUNJAB MOTORS 17 KM MULTAN RD LHR', 'SUZUKI PUNJAB MOTORS 17 KM MULTAN RD LHR', NULL, 'Lahore  Multan Road', '0423-7512741', NULL, NULL, NULL, NULL, NULL, '0'),
('414', 'Suzuki Raiwind Motors Raiwind Road LHR', 'Suzuki Raiwind Motors Raiwind Road LHR', NULL, 'Lahore  Raiwind Road', '0322-6701556', NULL, NULL, NULL, NULL, NULL, '0'),
('415', 'Suzuki Summit Motor 16 Km S.Pura Road', 'Suzuki Summit Motor 16 Km S.Pura Road', NULL, 'Lahore  Sheikhupura Road', '0306-0425448', NULL, NULL, NULL, NULL, NULL, '0'),
('416', 'Suzuki Town Ship Motors Peco Road-Lahore', 'Suzuki Town Ship Motors Peco Road-Lahore', NULL, 'Lahore  Peco Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('417', 'Tariq Motors Badami Bagh-Lahore', 'Tariq Motors Badami Bagh-Lahore', NULL, 'Lahore  Badami Bagh', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('418', 'Tayyab Autos Badami Bagh-Lahore', 'Tayyab Autos Badami Bagh-Lahore', NULL, 'Lahore  Badami Bagh', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('419', 'TM KHAN ARMS RAVI ROAD LAHORE', 'TM KHAN ARMS RAVI ROAD LAHORE', NULL, 'Lahore  Ravi Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('420', 'Touqeer Auto,Auto Centre Badami Bagh', 'Touqeer Auto,Auto Centre Badami Bagh', NULL, 'Lahore  Badami Bagh', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('421', 'Town Autos Peco Road-Lahore', 'Town Autos Peco Road-Lahore', NULL, 'Lahore  Peco Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('422', 'Toyota Garden Motors FerozPur Rd Lhr', 'Toyota Garden Motors FerozPur Rd Lhr', NULL, 'Lahore  Ferozpur Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('423', 'Toyota Jinnah Motors FerozPur Rd Lhr', 'Toyota Jinnah Motors FerozPur Rd Lhr', NULL, 'Lahore  Ferozpur Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('424', 'Toyota Motors Airport Road-Lahore', 'Toyota Motors Airport Road-Lahore', NULL, 'Lahore  Airport Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('425', 'Toyota Ravi Motors Thokar Niaz Baig-LHR', 'Toyota Ravi Motors Thokar Niaz Baig-LHR', NULL, 'Lahore  Thokar Niaz Baig', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('426', 'Toyota Sahara Motors Jail Road-Lahore', 'Toyota Sahara Motors Jail Road-Lahore', NULL, 'Lahore  Jail Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('427', 'Toyota Town Ship Motors Peco Road-Lahore', 'Toyota Town Ship Motors Peco Road-Lahore', NULL, 'Lahore  Peco Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('428', 'Toyota Walton Motor Walton Road-Lahore', 'Toyota Walton Motor Walton Road-Lahore', NULL, 'Lahore  Walton Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('429', 'UK Motors Ramzan Chamber Badami Bagh', 'UK Motors Ramzan Chamber Badami Bagh', NULL, 'Lahore  Badami Bagh', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('430', 'Umer Brothers Ik Auto Badami Bagh', 'Umer Brothers Ik Auto Badami Bagh', NULL, 'Lahore  Badami Bagh', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('431', 'Unique Oil Change Peco Road-Lahore', 'Unique Oil Change Peco Road-Lahore', NULL, 'Lahore  Peco Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('432', 'Usman Ali Auto Badami Bagh LHR', 'Usman Ali Auto Badami Bagh LHR', NULL, 'Lahore  Badami Bagh', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('433', 'Usman Autos Model Town-Lahore', 'Usman Autos Model Town-Lahore', NULL, 'Lahore  Model Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('434', 'Vital Oil Store Peco Road-Lahore', 'Vital Oil Store Peco Road-Lahore', NULL, 'Lahore  Peco Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('435', 'Wahab Autos Model Town-Lahore', 'Wahab Autos Model Town-Lahore', NULL, 'Lahore  Model Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('436', 'Waheed Autos Badami Bagh-Lahore', 'Waheed Autos Badami Bagh-Lahore', NULL, 'Lahore  Badami Bagh', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('437', 'Waheed Supplier Badami Bagh-Lahore', 'Waheed Supplier Badami Bagh-Lahore', NULL, 'Lahore  Badami Bagh', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('438', 'Waqar Autos Badami Bagh-Lahore', 'Waqar Autos Badami Bagh-Lahore', NULL, 'Lahore  Badami Bagh', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('439', 'Yaseen Autos Badami Bagh-Lahore', 'Yaseen Autos Badami Bagh-Lahore', NULL, 'Lahore  Badami Bagh', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('440', 'Younis Arms Nila Gumbad-Lahore', 'Younis Arms Nila Gumbad-Lahore', NULL, 'Lahore  Nila Gumbad', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('441', 'Zahid Autos Badami Bagh-Lahore', 'Zahid Autos Badami Bagh-Lahore', NULL, 'Lahore  Badami Bagh', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('442', 'Zahid Mehmood Auto Badami Bagh Lahore', 'Zahid Mehmood Auto Badami Bagh Lahore', NULL, 'Lahore  Badami Bagh', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('443', 'Zaiyad Autos Badami Bagh Lahore', 'Zaiyad Autos Badami Bagh Lahore', NULL, 'Lahore  Badami Bagh', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('444', '03425109461', 'Ammar', NULL, 'Lahore  ', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('445', '786 Auto Motors Montgomery  Road Lahore', '786 Auto Motors Montgomery  Road Lahore', NULL, 'Lahore  Montgomery Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('446', '786 Auto Parts Multan Road Lahore', '786 Auto Parts Multan Road Lahore', NULL, 'Lahore  Multan Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('447', '786 Montgomery Road Lahore', '786 Montgomery Road Lahore', NULL, 'Lahore  Montgomery Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('448', 'A&amp;N motors w/shop joher town', 'A&amp;N motors w/shop joher town', NULL, 'Lahore  Johar Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('449', 'A.A Auto Main Gulshan E Ravi-Lahore', 'A.A Auto Main Gulshan E Ravi-Lahore', NULL, 'Lahore  Gulshan E Ravi', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('450', 'A.R Traders GT Road Okara-Lahore', 'A.R Traders GT Road Okara-Lahore', NULL, 'Lahore  Okara', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('451', 'A.S Classic Motors Johar Town-Lahore', 'A.S Classic Motors Johar Town-Lahore', NULL, 'Lahore  Johar Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('452', 'AA Cool Centre 65-Kacha Ferozpur LOS', 'AA Cool Centre 65-Kacha Ferozpur LOS', NULL, 'Lahore  Ferozpur Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('453', 'Aamir Auto Main Walto Road Cantt', 'Aamir Auto Main Walto Road Cantt', NULL, 'Lahore  Walton Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('454', 'Aamir Auto Near Pepsi Factory Gulberg 3', 'Aamir Auto Near Pepsi Factory Gulberg 3', NULL, 'Lahore  Gulberg', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('455', 'Abbas Auto Near Canal View Gate-Lahore', 'Abbas Auto Near Canal View Gate-Lahore', NULL, 'Lahore  Canal View', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('456', 'Abdul Rehman Autos Hafizabad-Lahore', 'Abdul Rehman Autos Hafizabad-Lahore', NULL, 'Lahore  Hafizabad', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('457', 'Abdul Wahab Auto Sadar Cantt', 'Abdul Wahab Auto Sadar Cantt', NULL, 'Lahore  Sadar', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('458', 'Abdullah Auto Baba Market 10 Montgomery', 'Abdullah Auto Baba Market 10 Montgomery', NULL, 'Lahore  Montgomery Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('459', 'Abdullah Auto Montgomery Road Lahore', 'Abdullah Auto Montgomery Road Lahore', NULL, 'Lahore  Montgomery Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('460', 'Abdullah Autos Johar Town-Lahore', 'Abdullah Autos Johar Town-Lahore', NULL, 'Lahore  Johar Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('461', 'Abdullah Autos Qasoor-Lahore', 'Abdullah Autos Qasoor-Lahore', NULL, 'Lahore  Qasoor', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('462', 'Abrar Radiator Canal View Multan Road', 'Abrar Radiator Canal View Multan Road', NULL, 'Lahore  Canal View', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('463', 'ABW Auto Revenue Society Johar Town', 'ABW Auto Revenue Society Johar Town', NULL, 'Lahore  Johar Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('464', 'Acha Oil Change Mian Sabzazar PSO Pump', 'Acha Oil Change Mian Sabzazar PSO Pump', NULL, 'Lahore  Sabzazar', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('465', 'Adil Zafar Motors Main Multan Road LHR', 'Adil Zafar Motors Main Multan Road LHR', NULL, 'Lahore  Multan Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('466', 'Aftab Arms Multan Road Chauburji-Lahore', 'Aftab Arms Multan Road Chauburji-Lahore', NULL, 'Lahore  Chauburji', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('467', 'Ahmad Auto 422 Park Iqbal Town', 'Ahmad Auto 422 Park Iqbal Town', NULL, 'Lahore  Iqbal Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('468', 'Ahmad Autos Gujranwala Hafizabad Lhr', 'Ahmad Autos Gujranwala Hafizabad Lhr', NULL, 'Lahore  Hafizabad', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('469', 'Ahmed Auto Engineering 22/A A.Karim Road', 'Ahmed Auto Engineering 22/A A.Karim Road', NULL, 'Lahore  Karim Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('470', 'Ahmed Autos Khokha Stop Band Rd-Lahore', 'Ahmed Autos Khokha Stop Band Rd-Lahore', NULL, 'Lahore  Band Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('471', 'Ahmed Autos Samnabad-Lahore', 'Ahmed Autos Samnabad-Lahore', NULL, 'Lahore  Samnabad', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('472', 'Ahmed Oil Point Iqbal Town-Lahore', 'Ahmed Oil Point Iqbal Town-Lahore', NULL, 'Lahore  Iqbal Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('473', 'Ahmed Oil Store 5 B/b OR Society Johar T', 'Ahmed Oil Store 5 B/b OR Society Johar T', NULL, 'Lahore  Johar Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('474', 'Akeel Auto Queens Road Lhr', 'Akeel Auto Queens Road Lhr', NULL, 'Lahore  Queens Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('475', 'Akhtar Saeed Arms Multan Road Lahore', 'Akhtar Saeed Arms Multan Road Lahore', NULL, 'Lahore  Multan Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('476', 'Akram Autos GT Road Okara-Lahore', 'Akram Autos GT Road Okara-Lahore', NULL, 'Lahore  Okara', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('477', 'Akram Radiator Works Gurjranwal - Lhr', 'Akram Radiator Works Gurjranwal - Lhr', NULL, 'Lahore  Gujranwala', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('478', 'Al - Sheikh Autos GT Rd Gujranwala Lhr', 'Al - Sheikh Autos GT Rd Gujranwala Lhr', NULL, 'Lahore  Gujranwala', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('479', 'Al Akhwan Auto Gt Road-Lahore', 'Al Akhwan Auto Gt Road-Lahore', NULL, 'Lahore  Gt Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('480', 'Al Aqeel Auto Store Sheikhpura-Lahore', 'Al Aqeel Auto Store Sheikhpura-Lahore', NULL, 'Lahore  Sheikhpura', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('481', 'Al Fazal Auto &amp; Oil Mandi Stop Multan Ro', 'Al Fazal Auto &amp; Oil Mandi Stop Multan Ro', NULL, 'Lahore  Multan Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('482', 'Al Hafeez Bhola Radiator Sheikhpura-LHR', 'Al Hafeez Bhola Radiator Sheikhpura-LHR', NULL, 'Lahore  Sheikhpura', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('483', 'Al Hamad Oil Change 12-A Nawab Town', 'Al Hamad Oil Change 12-A Nawab Town', NULL, 'Lahore  Nawab Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('484', 'Al Haram Car Point PIA Housing Society', 'Al Haram Car Point PIA Housing Society', NULL, 'Lahore  Pia Housing Society', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('485', 'Al Karam Oil Johar Town-Lahore', 'Al Karam Oil Johar Town-Lahore', NULL, 'Lahore  Johar Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('486', 'Al Khair Autos Johar Town-Lahore', 'Al Khair Autos Johar Town-Lahore', NULL, 'Lahore  Johar Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('487', 'Al Madina Oil Store 25 No Stop S.Pura Ro', 'Al Madina Oil Store 25 No Stop S.Pura Ro', NULL, 'Lahore  Sheikhupura Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('488', 'Al Madina Oil Store Shahdra-Lahore', 'Al Madina Oil Store Shahdra-Lahore', NULL, 'Lahore  Shahdara', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('489', 'Al Madina Oil Store Sheikhupura Road Lhr', 'Al Madina Oil Store Sheikhupura Road Lhr', NULL, 'Lahore  Sheikhupura Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('490', 'Al Makkah Oil Shadara-Lahore', 'Al Makkah Oil Shadara-Lahore', NULL, 'Lahore  Shahdara', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('491', 'Al Makkah Oil Sheikhpura Road-Lahore', 'Al Makkah Oil Sheikhpura Road-Lahore', NULL, 'Lahore  Sheikhpura', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('492', 'Al Qadri LX 273 Ravi Block AIT', 'Al Qadri LX 273 Ravi Block AIT', NULL, 'Lahore  Allama Iqbal Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('493', 'Al Qasim Auto Ghazi Road Punjab Society', 'Al Qasim Auto Ghazi Road Punjab Society', NULL, 'Lahore  Ghazi Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('494', 'Al Rauf Auto Parts Gujranwala-Lahore', 'Al Rauf Auto Parts Gujranwala-Lahore', NULL, 'Lahore  Gujranwala', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('495', 'AL Rehman Auto Fsilabad Road Shekhupura', 'AL Rehman Auto Fsilabad Road Shekhupura', NULL, 'Lahore  Sheikhpura', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('496', 'Al Rehman Auto Plot 6 Wahdat Road', 'Al Rehman Auto Plot 6 Wahdat Road', NULL, 'Lahore  Wahdat Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('497', 'Al Riaz Autos Ferozpur Road-Lahore', 'Al Riaz Autos Ferozpur Road-Lahore', NULL, 'Lahore  Ferozpur Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('498', 'Al Subhan Autos Gujranwala-Lahore', 'Al Subhan Autos Gujranwala-Lahore', NULL, 'Lahore  Gujranwala', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('499', 'Alaf Autos Johar Town-Lahore', 'Alaf Autos Johar Town-Lahore', NULL, 'Lahore  Johar Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('500', 'Alam Oil Store Johar Town-Lahore', 'Alam Oil Store Johar Town-Lahore', NULL, 'Lahore  Johar Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('501', 'Ali Ahmed Autos Gulberg-Lahore', 'Ali Ahmed Autos Gulberg-Lahore', NULL, 'Lahore  Gulberg', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('502', 'Ali Auto Main Gulshan E Ravi-Lahore', 'Ali Auto Main Gulshan E Ravi-Lahore', NULL, 'Lahore  Gulshan E Ravi', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('503', 'Ali Auto Shade Wal Chowk Joher Town', 'Ali Auto Shade Wal Chowk Joher Town', NULL, 'Lahore  Johar Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('504', 'Ali Baba Decoration Pak Block Iqbal Town', 'Ali Baba Decoration Pak Block Iqbal Town', NULL, 'Lahore  Iqbal Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('505', 'Ali Lube Shop Steel Bagh Mor Qasoor', 'Ali Lube Shop Steel Bagh Mor Qasoor', NULL, 'Lahore  Qasoor', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('506', 'Ali Lube Shope Shekhupura', 'Ali Lube Shope Shekhupura', NULL, 'Lahore  Sheikhpura', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('507', 'ALLAH Hu Motor Gulshan E Ravi-Lahore', 'ALLAH Hu Motor Gulshan E Ravi-Lahore', NULL, 'Lahore  Gulshan E Ravi', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('508', 'Alpha Auto Decoration Gujranwala-Lahore', 'Alpha Auto Decoration Gujranwala-Lahore', NULL, 'Lahore  Gujranwala', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('509', 'Altaf Auto Montgomery Road Lahore', 'Altaf Auto Montgomery Road Lahore', NULL, 'Lahore  Montgomery Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('510', 'Amin Sons HardWare Sheikhupura Lahore', 'Amin Sons HardWare Sheikhupura Lahore', NULL, 'Lahore  Sheikhpura', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('511', 'Amir Auto Workshop Canal Park Gulberg 2', 'Amir Auto Workshop Canal Park Gulberg 2', NULL, 'Lahore  Gulberg', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('512', 'Amjad Auto Montgomery Road', 'Amjad Auto Montgomery Road', NULL, 'Lahore  Montgomery Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('513', 'Amjad Autos Patoki-Lahore', 'Amjad Autos Patoki-Lahore', NULL, 'Lahore  Patoki', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('514', 'Arsalan &amp; Co Gulberg Lahore', 'Arsalan &amp; Co Gulberg Lahore', NULL, 'Lahore  Gulberg', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('515', 'Asad Auto Oil Pak Block Iqbal Town', 'Asad Auto Oil Pak Block Iqbal Town', NULL, 'Lahore  Iqbal Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('516', 'Ashfaq Autos Lari Adda Qasoor Lhr', 'Ashfaq Autos Lari Adda Qasoor Lhr', NULL, 'Lahore  Qasoor', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('517', 'Ashraf Auto Pak Block Iqbal Town', 'Ashraf Auto Pak Block Iqbal Town', NULL, 'Lahore  Iqbal Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('518', 'Asif Auto Parts Gurumanget Gulberg III', 'Asif Auto Parts Gurumanget Gulberg III', NULL, 'Lahore  Gulberg', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('519', 'Asif Auto Spare Parts Gujrawala', 'Asif Auto Spare Parts Gujrawala', NULL, 'Lahore  Gujranwala', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('520', 'Asif Autos Sheikhpura Road-Lahore', 'Asif Autos Sheikhpura Road-Lahore', NULL, 'Lahore  Sheikhupura Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('521', 'Asif Battery Autos Gulberg ll lahore', 'Asif Battery Autos Gulberg ll lahore', NULL, 'Lahore  Gulberg', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('522', 'Asif Oil Change Kacha Ferozpur Road', 'Asif Oil Change Kacha Ferozpur Road', NULL, 'Lahore  Ferozpur Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('523', 'Atteeq Oil Faisalabad Rd Sheikhupura Lhr', 'Atteeq Oil Faisalabad Rd Sheikhupura Lhr', NULL, 'Lahore  Sheikhpura', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('524', 'AUTO BANK SHEIKHUPURA', 'AUTO BANK SHEIKHUPURA', NULL, 'Lahore  Sheikhupura ', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('525', 'Auto Care Clinic Wahdat Road-Lahore', 'Auto Care Clinic Wahdat Road-Lahore', NULL, 'Lahore  Wahadat Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('526', 'Auto Centre 35/B Faisal Town Opp Kotha', 'Auto Centre 35/B Faisal Town Opp Kotha', NULL, 'Lahore  Faisal Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('527', 'Auto Club Walton Road-Lahore', 'Auto Club Walton Road-Lahore', NULL, 'Lahore  Walton Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('528', 'Auto Expert 6 Rasool Park LOS-Lahore', 'Auto Expert 6 Rasool Park LOS-Lahore', NULL, 'Lahore  Rasool Park', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('529', 'Auto King Oil Store Johar Town-Lahore', 'Auto King Oil Store Johar Town-Lahore', NULL, 'Lahore  Johar Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('530', 'Auto Solutions 8-Montgomery Road', 'Auto Solutions 8-Montgomery Road', NULL, 'Lahore  Montgomery Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('531', 'Auto Spot PIA Society Near Goga Neelam', 'Auto Spot PIA Society Near Goga Neelam', NULL, 'Lahore  Pia Housing Society', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('532', 'Auto Zone Spare Parts Gujrawala', 'Auto Zone Spare Parts Gujrawala', NULL, 'Lahore  Gujranwala', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('533', 'Awami Autos Gulberg-Lahore', 'Awami Autos Gulberg-Lahore', NULL, 'Lahore  Gulberg', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('534', 'Awan Autos Gujranwala-Lahore', 'Awan Autos Gujranwala-Lahore', NULL, 'Lahore  Gujranwala', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('535', 'Awan Autos Gulberg-Lahore', 'Awan Autos Gulberg-Lahore', NULL, 'Lahore  Gulberg', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('536', 'Awan Autos Khark Nala Multan Road-Lahore', 'Awan Autos Khark Nala Multan Road-Lahore', NULL, 'Lahore  Multan Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('537', 'Awan Autos Okara-Lahore', 'Awan Autos Okara-Lahore', NULL, 'Lahore  Okara', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('538', 'Azaan Oil Change 32-29 Islamia Park LOS', 'Azaan Oil Change 32-29 Islamia Park LOS', NULL, 'Lahore  Los', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('539', 'Azeem Electronics Data Market Hall Road', 'Azeem Electronics Data Market Hall Road', NULL, 'Lahore  Hall Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('540', 'Babar Motors Montgomery Road', 'Babar Motors Montgomery Road', NULL, 'Lahore  Montgomery Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('541', 'Babar Oil Store GT Road Okara-Lahore', 'Babar Oil Store GT Road Okara-Lahore', NULL, 'Lahore  Okara', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('542', 'Badami Bagh Autos Iqbal Town-Lahore', 'Badami Bagh Autos Iqbal Town-Lahore', NULL, 'Lahore  Iqbal Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('543', 'Bahoo Autos Sabzazar-Lahore', 'Bahoo Autos Sabzazar-Lahore', NULL, 'Lahore  Sabzazar', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('544', 'Bari Auto Work Shop Iqbal Town Lahore', 'Bari Auto Work Shop Iqbal Town Lahore', NULL, 'Lahore  Iqbal Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('545', 'Barkat Auto Lariada Okara', 'Barkat Auto Lariada Okara', NULL, 'Lahore  Okara', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('546', 'Basra Enterprises 5-a Montgomery Park', 'Basra Enterprises 5-a Montgomery Park', NULL, 'Lahore  Montgomery Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('547', 'Bhatti Autos Jia Moosa Lahore', 'Bhatti Autos Jia Moosa Lahore', NULL, 'Lahore  Jia Moosa', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('548', 'Bismillah Arms Shop Hafizabad-Lahore', 'Bismillah Arms Shop Hafizabad-Lahore', NULL, 'Lahore  Hafizabad', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('549', 'Bismillah Auto Gulberg 2 LHR', 'Bismillah Auto Gulberg 2 LHR', NULL, 'Lahore  Gulberg', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('550', 'Bismillah Auto Jinnah Chowk Hafizabad', 'Bismillah Auto Jinnah Chowk Hafizabad', NULL, 'Lahore  Hafizabad', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('551', 'Bismillah Auto Parts Barkat Town GT Road', 'Bismillah Auto Parts Barkat Town GT Road', NULL, 'Lahore  Barkat Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('552', 'Bismillah Auto Scheme Mor Iqbal Town', 'Bismillah Auto Scheme Mor Iqbal Town', NULL, 'Lahore  Iqbal Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('553', 'Bismillah Auto Shade Wal Chowk J.T', 'Bismillah Auto Shade Wal Chowk J.T', NULL, 'Lahore  Johar Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('554', 'Bismillah Auto Spare Parts Kala Khtatai', 'Bismillah Auto Spare Parts Kala Khtatai', NULL, 'Lahore  Kala Khatai', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('555', 'Bismillah Autos Chauburji-Lahore', 'Bismillah Autos Chauburji-Lahore', NULL, 'Lahore  Chauburji', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('556', 'Bismillah Autos Diyal Singh-Lahore', 'Bismillah Autos Diyal Singh-Lahore', NULL, 'Lahore  Dayal Singh Mention', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('557', 'Bismillah Autos Gulberg Lll Lahore', 'Bismillah Autos Gulberg Lll Lahore', NULL, 'Lahore  Gulberg', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('558', 'Bismillah Rehman Autos Faisal Town Lhr', 'Bismillah Rehman Autos Faisal Town Lhr', NULL, 'Lahore  Faisal Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('559', 'BM Auto Decoration H Block Bijli Ghr', 'BM Auto Decoration H Block Bijli Ghr', NULL, 'Lahore  Sabzazar', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('560', 'Bobi Auto Allam Iqbal Road-Lahore', 'Bobi Auto Allam Iqbal Road-Lahore', NULL, 'Lahore  Allama Iqbal Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('561', 'Bright Autos Qasoor-Lahore', 'Bright Autos Qasoor-Lahore', NULL, 'Lahore  Qasoor', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('562', 'Brother Auto Imamia Colony Phatak GT Roa', 'Brother Auto Imamia Colony Phatak GT Roa', NULL, 'Lahore  Gt Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('563', 'Brother Auto Joher Town', 'Brother Auto Joher Town', NULL, 'Lahore  Johar Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('564', 'Butt Auto Store Rasheed Plaza Sabzazar', 'Butt Auto Store Rasheed Plaza Sabzazar', NULL, 'Lahore  Sabzazar', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('565', 'Butt Autos Band Road Lahore', 'Butt Autos Band Road Lahore', NULL, 'Lahore  Band Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('566', 'Butt Autos G.T Road Okara Lahore', 'Butt Autos G.T Road Okara Lahore', NULL, 'Lahore  Okara', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('567', 'Butt Oil 308 Kalma Chowk Near Silk Bank', 'Butt Oil 308 Kalma Chowk Near Silk Bank', NULL, 'Lahore  Kalma Chowk', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('568', 'Butt Rubber Decor Masjid Market Montgome', 'Butt Rubber Decor Masjid Market Montgome', NULL, 'Lahore  Montgomery Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('569', 'Caltex Auto Care Sheikhpura-Lahore', 'Caltex Auto Care Sheikhpura-Lahore', NULL, 'Lahore  Sheikhpura', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('570', 'Cantt Autos Walton Road-Lahore', 'Cantt Autos Walton Road-Lahore', NULL, 'Lahore  Walton Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('571', 'Car Care 8-C Nawab Town Raiwind Road', 'Car Care 8-C Nawab Town Raiwind Road', NULL, 'Lahore  Nawab Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('572', 'Car Help Line 150 Garden Block Garden T', 'Car Help Line 150 Garden Block Garden T', NULL, 'Lahore  Garden Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('573', 'Ch.Faiz Oil Auto Store Montgomery Rd-LHR', 'Ch.Faiz Oil Auto Store Montgomery Rd-LHR', NULL, 'Lahore  Montgomery Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('574', 'Channo Auto Chughtai Market 10 Montgomer', 'Channo Auto Chughtai Market 10 Montgomer', NULL, 'Lahore  Montgomery Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('575', 'Chaudhary Auto G T Toad Gujrat', 'Chaudhary Auto G T Toad Gujrat', NULL, 'Lahore  Gujrat', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('576', 'Chaudhary Auto Opp Packages Mall Walton', 'Chaudhary Auto Opp Packages Mall Walton', NULL, 'Lahore  Walton Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('577', 'Chaudhary Auto Store 17-A Montgomery Roa', 'Chaudhary Auto Store 17-A Montgomery Roa', NULL, 'Lahore  Montgomery Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('578', 'Chaudhary Auto Wahdat Road Iqbal Town', 'Chaudhary Auto Wahdat Road Iqbal Town', NULL, 'Lahore  Iqbal Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('579', 'Chaudhary Oil Store 14 Km Multan Road', 'Chaudhary Oil Store 14 Km Multan Road', NULL, 'Lahore  Multan Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('580', 'Chaudhry Arms Dealer Qasoor-Lahore', 'Chaudhry Arms Dealer Qasoor-Lahore', NULL, 'Lahore  Qasoor', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('581', 'Chaudhry Arms Gulberg III-Lahore', 'Chaudhry Arms Gulberg III-Lahore', NULL, 'Lahore  Gulberg', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('582', 'Chaudhry Autos G T Road Okara', 'Chaudhry Autos G T Road Okara', NULL, 'Lahore  Okara', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('583', 'Chaudhry Autos-Gujranwala', 'Chaudhry Autos-Gujranwala', NULL, 'Lahore  Gujranwala', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('584', 'Chaudhry Car Clinic Karim Block Iqbal To', 'Chaudhry Car Clinic Karim Block Iqbal To', NULL, 'Lahore  Iqbal Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('585', 'Cheema Oil 45-A Revenue Society Johar.T', 'Cheema Oil 45-A Revenue Society Johar.T', NULL, 'Lahore  Johar Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('586', 'Chevrolet Platinum Abbat Road-Lahore', 'Chevrolet Platinum Abbat Road-Lahore', NULL, 'Lahore  Abbat Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('587', 'City Autos Multan Road Patoki-Lahore', 'City Autos Multan Road Patoki-Lahore', NULL, 'Lahore  Patoki', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('588', 'City Car Care 25 No.Stop-Lahore', 'City Car Care 25 No.Stop-Lahore', NULL, 'Lahore  Shahdra', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('589', 'Crystal Autos GT Road Gujrat-Lahore', 'Crystal Autos GT Road Gujrat-Lahore', NULL, 'Lahore  Gujrat', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('590', 'Danewal Auto Wahdat Road', 'Danewal Auto Wahdat Road', NULL, 'Lahore  Wahdat Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('591', 'Dar Lube Naqsha Stop Wahdat Road', 'Dar Lube Naqsha Stop Wahdat Road', NULL, 'Lahore  Wahdat Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('592', 'Data Oil Store Faisal Town Lahore', 'Data Oil Store Faisal Town Lahore', NULL, 'Lahore  Faisal Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('593', 'Dawn Motors 17-A Montgomery Road', 'Dawn Motors 17-A Montgomery Road', NULL, 'Lahore  Montgomery Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('594', 'Dildar Oil Montgomery Road-Lahore', 'Dildar Oil Montgomery Road-Lahore', NULL, 'Lahore  Montgomery Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('595', 'Doctor Auto Main Gulshan E Ravi', 'Doctor Auto Main Gulshan E Ravi', NULL, 'Lahore  Gulshan E Ravi', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('596', 'Dogar Oil Store Gulshan E Ravi-Lahore', 'Dogar Oil Store Gulshan E Ravi-Lahore', NULL, 'Lahore  Gulshan E Ravi', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('597', 'Dubai Autos Band Road Lahore', 'Dubai Autos Band Road Lahore', NULL, 'Lahore  Band Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('598', 'Elahi Oil Store GT Road-Okara', 'Elahi Oil Store GT Road-Okara', NULL, 'Lahore  Okara', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('599', 'Ettehad Auto Chowk Beighum Kot-Lahore', 'Ettehad Auto Chowk Beighum Kot-Lahore', NULL, 'Lahore  Beighum Kot', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('600', 'Ettehad Auto Ghazi Road Punjab Society', 'Ettehad Auto Ghazi Road Punjab Society', NULL, 'Lahore  Punjab Society', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('601', 'Express Auto Johar Town Lahore', 'Express Auto Johar Town Lahore', NULL, 'Lahore  Johar Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('602', 'Fahad Auto Montgomery Road Lahore', 'Fahad Auto Montgomery Road Lahore', NULL, 'Lahore  Montgomery Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('603', 'Faisal Movers Bund Road Lahore', 'Faisal Movers Bund Road Lahore', NULL, 'Lahore  Band Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('604', 'Faisal Movers Bund Road Near Abdullah Tr', 'Faisal Movers Bund Road Near Abdullah Tr', NULL, 'Lahore  Band Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('605', 'Faizan Auto Spare Parts Walton Road', 'Faizan Auto Spare Parts Walton Road', NULL, 'Lahore  Walton Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('606', 'Faizan E Muhammadi Oil LOS Samanabad', 'Faizan E Muhammadi Oil LOS Samanabad', NULL, 'Lahore  Samnabad', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('607', 'Fareed Khan Lodhi Oil G.T Rd Okara Lhr', 'Fareed Khan Lodhi Oil G.T Rd Okara Lhr', NULL, 'Lahore  Okara', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('608', 'Farooq Brother G.T Road Gujranwala-Lahor', 'Farooq Brother G.T Road Gujranwala-Lahor', NULL, 'Lahore  Gujranwala', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('609', 'Fazal Autos Wahdat Road-Lahore', 'Fazal Autos Wahdat Road-Lahore', NULL, 'Lahore  Wahadat Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('610', 'Fiazan Auto Spare Parts Walton  Road', 'Fiazan Auto Spare Parts Walton  Road', NULL, 'Lahore  Walton Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('611', 'Fine Auto main Market Gulberg Lhr', 'Fine Auto main Market Gulberg Lhr', NULL, 'Lahore  Gulberg', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('612', 'Fine Autos Gulberg ll Lahore', 'Fine Autos Gulberg ll Lahore', NULL, 'Lahore  Gulberg', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('613', 'Finish Line Autos Multan Road Lhr', 'Finish Line Autos Multan Road Lhr', NULL, 'Lahore  Multan Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('614', 'Five Star Work Shop Joher Town', 'Five Star Work Shop Joher Town', NULL, 'Lahore  Johar Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('615', 'G.A Suzuki Center Chuburji-Lahore', 'G.A Suzuki Center Chuburji-Lahore', NULL, 'Lahore  Chuburji', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('616', 'Geely Ravi Motors Bypass Road-Lahore', 'Geely Ravi Motors Bypass Road-Lahore', NULL, 'Lahore  ', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('617', 'General Autos Hafizabad-Lahore', 'General Autos Hafizabad-Lahore', NULL, 'Lahore  Hafizabad', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('618', 'Geo Oil Store Gulberg III-Lahore', 'Geo Oil Store Gulberg III-Lahore', NULL, 'Lahore  Gulberg', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('619', 'Ghaus Autos Johar Town-Lahore', 'Ghaus Autos Johar Town-Lahore', NULL, 'Lahore  Johar Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('620', 'Ghous Auto Parts Johar Town', 'Ghous Auto Parts Johar Town', NULL, 'Lahore  Johar Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('621', 'Ghousia Auto Super Auto Market Chuburji', 'Ghousia Auto Super Auto Market Chuburji', NULL, 'Lahore  Chuburji', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('622', 'GM Auto 1071 A Block Sabzazar Multan Roa', 'GM Auto 1071 A Block Sabzazar Multan Roa', NULL, 'Lahore  Multan Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('623', 'Go-4 Repair Autos GT Road Gujrat-Lahore', 'Go-4 Repair Autos GT Road Gujrat-Lahore', NULL, 'Lahore  Gujrat', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('624', 'Gold Autos Gujranwala-Lahore', 'Gold Autos Gujranwala-Lahore', NULL, 'Lahore  Gujranwala', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('625', 'Gondal  Autos GT Road  Okara Lahore', 'Gondal  Autos GT Road  Okara Lahore', NULL, 'Lahore  Okara', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('626', 'Green Suzuki Autos Montgomery Road', 'Green Suzuki Autos Montgomery Road', NULL, 'Lahore  Montgomery Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('627', 'Gujranwala Autos Oil Gujranwala-Lahore', 'Gujranwala Autos Oil Gujranwala-Lahore', NULL, 'Lahore  Gujranwala', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('628', 'H.I Motor Auto Parts Waris Road-Lahore', 'H.I Motor Auto Parts Waris Road-Lahore', NULL, 'Lahore  Waris Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('629', 'H.M Engineering Co.Johar Town-Lahore', 'H.M Engineering Co.Johar Town-Lahore', NULL, 'Lahore  Johar Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('630', 'Habib &amp; Sons Hardwere Store-Gujranwala', 'Habib &amp; Sons Hardwere Store-Gujranwala', NULL, 'Lahore  Gujranwala', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('631', 'Hafiz Auto Spare Parts 22 Lawrence Road', 'Hafiz Auto Spare Parts 22 Lawrence Road', NULL, 'Lahore  Lawrence Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('632', 'Hafiz Autos Waris Road-Lahore', 'Hafiz Autos Waris Road-Lahore', NULL, 'Lahore  Waris Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('633', 'Hafiz Brothers Walton Road-Lahore', 'Hafiz Brothers Walton Road-Lahore', NULL, 'Lahore  Walton Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('634', 'Hafiz G Oil Change Bijli Ghr Sabzazar', 'Hafiz G Oil Change Bijli Ghr Sabzazar', NULL, 'Lahore  Sabzazar', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('635', 'Hafiz Kamran Autos Johar Town Lahore', 'Hafiz Kamran Autos Johar Town Lahore', NULL, 'Lahore  Johar Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('636', 'Hafiz Karachi Autos Gujranwala-Lahore', 'Hafiz Karachi Autos Gujranwala-Lahore', NULL, 'Lahore  Gujranwala', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('637', 'Hafiz Karachi Autos Oil Shaikhpura Rd Lhr', 'Hafiz Karachi Autos Oil Shaikhpura Rd Lhr', NULL, 'Lahore  Sheikhpura', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('638', 'Haider Auto 25 Fateh Shair Road Mozang', 'Haider Auto 25 Fateh Shair Road Mozang', NULL, 'Lahore  Fateh Shair Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('639', 'Haider Autos Faislabad Road Sheikhupura', 'Haider Autos Faislabad Road Sheikhupura', NULL, 'Lahore  Sheikhupura', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('640', 'Haji Abdul Al Rashid G-market Qasoor Lhr', 'Haji Abdul Al Rashid G-market Qasoor Lhr', NULL, 'Lahore  Qasoor', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('641', 'Haji Auto Main Walton Road Cantt', 'Haji Auto Main Walton Road Cantt', NULL, 'Lahore  Walton Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('642', 'Haji Ibrahim Mill Store-Lahore', 'Haji Ibrahim Mill Store-Lahore', NULL, 'Lahore  ', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('643', 'Hajveri Oil Change Bund Road Niazi Adda', 'Hajveri Oil Change Bund Road Niazi Adda', NULL, 'Lahore  Band Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('644', 'Hajveri Oil Store Johar Town-Lahore', 'Hajveri Oil Store Johar Town-Lahore', NULL, 'Lahore  Johar Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('645', 'Hannan Auto Joher Town Lahore', 'Hannan Auto Joher Town Lahore', NULL, 'Lahore  Johar Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('646', 'HARRON AUTO CANAL BANK GULBERG 2 LAHORE', 'HARRON AUTO CANAL BANK GULBERG 2 LAHORE', NULL, 'Lahore  Gulberg', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('647', 'Hasnain Auto Joher Town', 'Hasnain Auto Joher Town', NULL, 'Lahore  Johar Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('648', 'Hassan Auto Safa Wala Chowk Ganga Ram Lh', 'Hassan Auto Safa Wala Chowk Ganga Ram Lh', NULL, 'Lahore  Gangaram', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('649', 'Highway Autos Sheikhpura-Lahore', 'Highway Autos Sheikhpura-Lahore', NULL, 'Lahore  Sheikhpura', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('650', 'Honda Hub Montgomery Road-Lahore', 'Honda Hub Montgomery Road-Lahore', NULL, 'Lahore  Montgomery Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('651', 'Honda Johar Town Motors Johar Town-LHR', 'Honda Johar Town Motors Johar Town-LHR', NULL, 'Lahore  Johar Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('652', 'Honda Ring Road Motors Ring Road Lahore', 'Honda Ring Road Motors Ring Road Lahore', NULL, 'Lahore  Ring Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('653', 'Honda Samanabad Motors-Lahore', 'Honda Samanabad Motors-Lahore', NULL, 'Lahore  Samnabad', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('654', 'Hussain Auto Spare Parts Opp Canal View', 'Hussain Auto Spare Parts Opp Canal View', NULL, 'Lahore  Canal View', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('655', 'I.A Traders Walton Road-Lahore', 'I.A Traders Walton Road-Lahore', NULL, 'Lahore  Walton Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('656', 'Ikhlaq Autos Khokha Stop Band Rd-Lahore', 'Ikhlaq Autos Khokha Stop Band Rd-Lahore', NULL, 'Lahore  Band Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('657', 'Imran Auto Samsani Road Johar Town', 'Imran Auto Samsani Road Johar Town', NULL, 'Lahore  Johar Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('658', 'Inam &amp; Co G.T Road Gujranwala Lhr', 'Inam &amp; Co G.T Road Gujranwala Lhr', NULL, 'Lahore  Gujranwala', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('659', 'Inayat Ali &amp;company HafizaBad', 'Inayat Ali &amp;company HafizaBad', NULL, 'Lahore  Hafizabad', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('660', 'International Autos Chauburji-Lahore', 'International Autos Chauburji-Lahore', NULL, 'Lahore  Chauburji', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('661', 'Iqbal Auto Abbot Road-Lahore', 'Iqbal Auto Abbot Road-Lahore', NULL, 'Lahore  Abbot Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('662', 'Ishfaq Auto Store Lari Adda Qasoor', 'Ishfaq Auto Store Lari Adda Qasoor', NULL, 'Lahore  Qasoor', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('663', 'Ishfaq Autos Gulshan E Ravi Road-Lahore', 'Ishfaq Autos Gulshan E Ravi Road-Lahore', NULL, 'Lahore  Gulshan E Ravi', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('664', 'Ishfaq Autos Sheikuhpura-Lahore', 'Ishfaq Autos Sheikuhpura-Lahore', NULL, 'Lahore  Sheikhpura', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('665', 'Israr Autos Super Market Okara-Lahore', 'Israr Autos Super Market Okara-Lahore', NULL, 'Lahore  Okara', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('666', 'Itehad Autos Sheikhpura Road-Lahore', 'Itehad Autos Sheikhpura Road-Lahore', NULL, 'Lahore  Sheikhpura', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('667', 'Ittefaq Motors Montgomery Road-Lahore', 'Ittefaq Motors Montgomery Road-Lahore', NULL, 'Lahore  Montgomery Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('668', 'Jalandar Auto Chungi No 7 Okara', 'Jalandar Auto Chungi No 7 Okara', NULL, 'Lahore  Okara', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('669', 'Jamil Autos Faisalabad Road Okara Lhr', 'Jamil Autos Faisalabad Road Okara Lhr', NULL, 'Lahore  Okara', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('670', 'Jani Autos Band Road-Lahore', 'Jani Autos Band Road-Lahore', NULL, 'Lahore  Band Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('671', 'Javaid Auto Oil Store Bund Road LHR', 'Javaid Auto Oil Store Bund Road LHR', NULL, 'Lahore  Band Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('672', 'Jawed Auto Store Patoki-Lahore', 'Jawed Auto Store Patoki-Lahore', NULL, 'Lahore  Patoki', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('673', 'K&amp;W Oil Store 63 Kacha Ferozpur Road LOS', 'K&amp;W Oil Store 63 Kacha Ferozpur Road LOS', NULL, 'Lahore  Ferozpur Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('674', 'K.G.N Oil Store Joher Town', 'K.G.N Oil Store Joher Town', NULL, 'Lahore  Johar Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('675', 'Kar Kraft Model Town Ext Main Faisal Tow', 'Kar Kraft Model Town Ext Main Faisal Tow', NULL, 'Lahore  Faisal Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('676', 'Karim Auto Bijli Ghar Stop Sabzazar', 'Karim Auto Bijli Ghar Stop Sabzazar', NULL, 'Lahore  Sabzazar', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('677', 'Khadim Suzuki House Chauburji-Lahore', 'Khadim Suzuki House Chauburji-Lahore', NULL, 'Lahore  Chauburji', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('678', 'Khalid Autos G.T Road Gujarat Lhr', 'Khalid Autos G.T Road Gujarat Lhr', NULL, 'Lahore  Gujrat', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('679', 'Khalid Autos Multan Road-Lahore', 'Khalid Autos Multan Road-Lahore', NULL, 'Lahore  Multan Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('680', 'Khan &amp; Son Autos Chauburji-Lahore', 'Khan &amp; Son Autos Chauburji-Lahore', NULL, 'Lahore  Chauburji', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('681', 'Khan Auto Oil Change Canal View Gate', 'Khan Auto Oil Change Canal View Gate', NULL, 'Lahore  Canal View', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('682', 'Khan Baba Aslah Dealer Gujrat - Lahore', 'Khan Baba Aslah Dealer Gujrat - Lahore', NULL, 'Lahore  Gujrat', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('683', 'Khokhar Agri Parts Gujranwala-Lahore', 'Khokhar Agri Parts Gujranwala-Lahore', NULL, 'Lahore  Gujranwala', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('684', 'Khursheed Auto Montgomery Road Lahore', 'Khursheed Auto Montgomery Road Lahore', NULL, 'Lahore  Montgomery Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('685', 'K-Jalil &amp; Company Chowk Begium Rd LHR', 'K-Jalil &amp; Company Chowk Begium Rd LHR', NULL, 'Lahore  Beighum Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('686', 'Lahore Auto Near Bank Alfalah Montgomery', 'Lahore Auto Near Bank Alfalah Montgomery', NULL, 'Lahore  Montgomery Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('687', 'Lahore Oil Shadara Mor-Lahore', 'Lahore Oil Shadara Mor-Lahore', NULL, 'Lahore  Shahdara', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('688', 'Lahore Oil Store Johar Town -Lahore', 'Lahore Oil Store Johar Town -Lahore', NULL, 'Lahore  Johar Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('689', 'Lahoria Autos Gujranwala-Lahore', 'Lahoria Autos Gujranwala-Lahore', NULL, 'Lahore  Gujranwala', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('690', 'Latif Autos Waris Road Lahore', 'Latif Autos Waris Road Lahore', NULL, 'Lahore  Waris Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('691', 'Lube Shop Johar Town-Lahore', 'Lube Shop Johar Town-Lahore', NULL, 'Lahore  Johar Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('692', 'Lubes Shop 2 GT Roadnear Lal Haveli', 'Lubes Shop 2 GT Roadnear Lal Haveli', NULL, 'Lahore  Lal Haveli', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('693', 'M Ahmed Auto Spare Parts Shahdra', 'M Ahmed Auto Spare Parts Shahdra', NULL, 'Lahore  Shahdra', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('694', 'M BASHIR AUTO BHALA CHOWK JOHER TOWN', 'M BASHIR AUTO BHALA CHOWK JOHER TOWN', NULL, 'Lahore  Johar Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('695', 'M Ilyas Oil Change Samsani Road J.Town', 'M Ilyas Oil Change Samsani Road J.Town', NULL, 'Lahore  Johar Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('696', 'M Tariq Oil Store Faisal Town-Lahore', 'M Tariq Oil Store Faisal Town-Lahore', NULL, 'Lahore  Faisal Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('697', 'M Usman Nes Pak Society Canal Bank Road', 'M Usman Nes Pak Society Canal Bank Road', NULL, 'Lahore  Canal Bank', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('698', 'MA Auto Oil Change Iqbal Town Lahore', 'MA Auto Oil Change Iqbal Town Lahore', NULL, 'Lahore  Iqbal Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('699', 'Madina Auto Main Boulevard Ghazi Road', 'Madina Auto Main Boulevard Ghazi Road', NULL, 'Lahore  Ghazi Road', NULL, NULL, NULL, NULL, NULL, NULL, '0');
INSERT INTO `0_crm_persons` VALUES
('700', 'Madina Auto Store Multan Road-Lahore', 'Madina Auto Store Multan Road-Lahore', NULL, 'Lahore  Multan Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('701', 'Madina Motors Main Ferozpur Road-Lahore', 'Madina Motors Main Ferozpur Road-Lahore', NULL, 'Lahore  Ferozpur Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('702', 'Madina Oil Store Patoki-Lahore', 'Madina Oil Store Patoki-Lahore', NULL, 'Lahore  Patoki', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('703', 'Madni Motors Industrial Area Gulberg-LHR', 'Madni Motors Industrial Area Gulberg-LHR', NULL, 'Lahore  Gulberg', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('704', 'Majid Auto Traders Sharif Mension Gangar', 'Majid Auto Traders Sharif Mension Gangar', NULL, 'Lahore  Sharif Mension', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('705', 'Makkah Autos GT Road Gujrat-Lahore', 'Makkah Autos GT Road Gujrat-Lahore', NULL, 'Lahore  Gujrat', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('706', 'Makkah Autso Johar Town Lhr', 'Makkah Autso Johar Town Lhr', NULL, 'Lahore  Johar Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('707', 'Makkah Poshish Sadat Market 8-Montgomery', 'Makkah Poshish Sadat Market 8-Montgomery', NULL, 'Lahore  Montgomery Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('708', 'Makki Oil Store Faisal Town-Lahore', 'Makki Oil Store Faisal Town-Lahore', NULL, 'Lahore  Faisal Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('709', 'Makki Oil Store Wapda Town-Lahore', 'Makki Oil Store Wapda Town-Lahore', NULL, 'Lahore  Wapdatown', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('710', 'Malik Auto Bank Stop Main Walton Road', 'Malik Auto Bank Stop Main Walton Road', NULL, 'Lahore  Walton Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('711', 'Malik Auto Suzuki Parts 8-Montgomery', 'Malik Auto Suzuki Parts 8-Montgomery', NULL, 'Lahore  Montgomery Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('712', 'Malik Autos Main Johar Town-Lahore', 'Malik Autos Main Johar Town-Lahore', NULL, 'Lahore  Johar Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('713', 'Malik Autos Qasoor-Lahore', 'Malik Autos Qasoor-Lahore', NULL, 'Lahore  Qasoor', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('714', 'Malik Autos Walton Road-Lahore', 'Malik Autos Walton Road-Lahore', NULL, 'Lahore  Walton Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('715', 'Malik Imran Auto 222 Multan Road', 'Malik Imran Auto 222 Multan Road', NULL, 'Lahore  Multan Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('716', 'Malik Paper Badar Pura Stop Multan Road', 'Malik Paper Badar Pura Stop Multan Road', NULL, 'Lahore  Multan Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('717', 'Mansoor &amp; Zahoor Oil Shalimar Link Road', 'Mansoor &amp; Zahoor Oil Shalimar Link Road', NULL, 'Lahore  Shalimar Link Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('718', 'Mansoor Bro Oil Store GT Road Okara', 'Mansoor Bro Oil Store GT Road Okara', NULL, 'Lahore  Okara', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('719', 'Mansoor Brothers Autos GT Road Okara-LHR', 'Mansoor Brothers Autos GT Road Okara-LHR', NULL, 'Lahore  Okara', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('720', 'Mashallah Auto Canal Park Gulberg', 'Mashallah Auto Canal Park Gulberg', NULL, 'Lahore  Gulberg', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('721', 'Mashallah Auto Joher Town', 'Mashallah Auto Joher Town', NULL, 'Lahore  Johar Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('722', 'Master Auto Main Walton Road Cantt Marke', 'Master Auto Main Walton Road Cantt Marke', NULL, 'Lahore  Walton Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('723', 'Master Autos Walton Road-Lahore', 'Master Autos Walton Road-Lahore', NULL, 'Lahore  Walton Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('724', 'Meer Autos Gujrat Lahore', 'Meer Autos Gujrat Lahore', NULL, 'Lahore  Gujrat', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('725', 'Mian Auto 326-D Main PIA Road,Johar Town', 'Mian Auto 326-D Main PIA Road,Johar Town', NULL, 'Lahore  Johar Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('726', 'Mian Auto Bhalla Stop Johar Town', 'Mian Auto Bhalla Stop Johar Town', NULL, 'Lahore  Johar Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('727', 'Mian Auto near Wali Hospital Kasoor', 'Mian Auto near Wali Hospital Kasoor', NULL, 'Lahore  Qasoor', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('728', 'Mian Auto Parts Canda Qila Gujrawala', 'Mian Auto Parts Canda Qila Gujrawala', NULL, 'Lahore  Gujranwala', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('729', 'Mian Auto Wahdat Road Near Orange Train', 'Mian Auto Wahdat Road Near Orange Train', NULL, 'Lahore  Wahdat Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('730', 'Mian Auto Walton Road', 'Mian Auto Walton Road', NULL, 'Lahore  Walton Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('731', 'Mian Autos Johar Town-Lahore', 'Mian Autos Johar Town-Lahore', NULL, 'Lahore  Johar Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('732', 'Mian Autos Sabzazar-Lahore', 'Mian Autos Sabzazar-Lahore', NULL, 'Lahore  Sabzazar', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('733', 'Mian Bro s Main Boulevard Road Sabzazar', 'Mian Bro s Main Boulevard Road Sabzazar', NULL, 'Lahore  Sabzazar', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('734', 'Mian Khalil Autos Bahawalpur Rd-Lahore', 'Mian Khalil Autos Bahawalpur Rd-Lahore', NULL, 'Lahore  Bahawalpur Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('735', 'Mian Shuja &amp; Bro Shahdra Chowk-Lahore', 'Mian Shuja &amp; Bro Shahdra Chowk-Lahore', NULL, 'Lahore  Shahdra', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('736', 'Mian Yaqoob Autos G.T Rd Okara Lhr', 'Mian Yaqoob Autos G.T Rd Okara Lhr', NULL, 'Lahore  Okara', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('737', 'Millat Rubber Store-Lahore', 'Millat Rubber Store-Lahore', NULL, 'Lahore  ', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('738', 'Minhaj Autos Walton Road-Lahore', 'Minhaj Autos Walton Road-Lahore', NULL, 'Lahore  Walton Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('739', 'Mini Motors Gulberg III-Lahore', 'Mini Motors Gulberg III-Lahore', NULL, 'Lahore  Gulberg', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('740', 'MIR Auto Gujrawala Golden Market', 'MIR Auto Gujrawala Golden Market', NULL, 'Lahore  Gujranwala', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('741', 'Mirza Auto Store G T Road Gujrat', 'Mirza Auto Store G T Road Gujrat', NULL, 'Lahore  Gujrat', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('742', 'Mobeen Autos Gujranwala Rd Hafizabad-Lhr', 'Mobeen Autos Gujranwala Rd Hafizabad-Lhr', NULL, 'Lahore  Hafizabad', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('743', 'Model Lube Shop Allama Iqbal Road', 'Model Lube Shop Allama Iqbal Road', NULL, 'Lahore  Iqbal Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('744', 'Modern Auto Workshop Johar Town', 'Modern Auto Workshop Johar Town', NULL, 'Lahore  Johar Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('745', 'Mohsin Autos Johar Town-Lahore', 'Mohsin Autos Johar Town-Lahore', NULL, 'Lahore  Johar Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('746', 'MOON AUTO GANA RAM LAHORE', 'MOON AUTO GANA RAM LAHORE', NULL, 'Lahore  Gangaram', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('747', 'Mother Autos Johar Town-Lahore', 'Mother Autos Johar Town-Lahore', NULL, 'Lahore  Johar Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('748', 'Motor Clean Opposite Packages Mall', 'Motor Clean Opposite Packages Mall', NULL, 'Lahore  Pacakages Mall', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('749', 'MS Auto Back Side Dayal Singh Mention', 'MS Auto Back Side Dayal Singh Mention', NULL, 'Lahore  Dayal Singh Mention', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('750', 'MSB Motors/Auto Johar Town Lahore', 'MSB Motors/Auto Johar Town Lahore', NULL, 'Lahore  Johar Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('751', 'Mughal Arms Gujranwala Road Hafizabad', 'Mughal Arms Gujranwala Road Hafizabad', NULL, 'Lahore  Hafizabad', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('752', 'Mughal Auto Ghazi Road Punjab Society', 'Mughal Auto Ghazi Road Punjab Society', NULL, 'Lahore  Punjab Society', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('753', 'Mughal Autos Band Road Lahore', 'Mughal Autos Band Road Lahore', NULL, 'Lahore  Band Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('754', 'Mughal Autos GT Road Gujrat-Lahore', 'Mughal Autos GT Road Gujrat-Lahore', NULL, 'Lahore  Gujrat', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('755', 'Mughal Autos GT Road Okara-Lahore', 'Mughal Autos GT Road Okara-Lahore', NULL, 'Lahore  Okara', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('756', 'Mughal Autos Johar Town Lahore', 'Mughal Autos Johar Town Lahore', NULL, 'Lahore  Johar Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('757', 'Mughal Autos Montgomery Road-Lahore', 'Mughal Autos Montgomery Road-Lahore', NULL, 'Lahore  Montgomery Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('758', 'Muhammadan Auto 426 Pak Block Iqbal Town', 'Muhammadan Auto 426 Pak Block Iqbal Town', NULL, 'Lahore  Iqbal Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('759', 'Muhammadan Autos Iqbal Town-Lahore', 'Muhammadan Autos Iqbal Town-Lahore', NULL, 'Lahore  Iqbal Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('760', 'Multi Autos Gujrat General Bus Stand Lhr', 'Multi Autos Gujrat General Bus Stand Lhr', NULL, 'Lahore  Gujrat', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('761', 'Munawar Sons Chauburji-Lahore', 'Munawar Sons Chauburji-Lahore', NULL, 'Lahore  Chauburji', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('762', 'N Hydari Auto Main Boulevard Ghazi Road', 'N Hydari Auto Main Boulevard Ghazi Road', NULL, 'Lahore  Ghazi Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('763', 'Nadeem Autos Montgomery Road LHR', 'Nadeem Autos Montgomery Road LHR', NULL, 'Lahore  Montgomery Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('764', 'Naeem &amp; Sons Montgomery', 'Naeem &amp; Sons Montgomery', NULL, 'Lahore  Montgomery Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('765', 'Naeem AM Industries Bilal Ganj-Lahore', 'Naeem AM Industries Bilal Ganj-Lahore', NULL, 'Lahore  Bilal Ganj', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('766', 'Nasir Auto Montgomery Road LHR', 'Nasir Auto Montgomery Road LHR', NULL, 'Lahore  Montgomery Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('767', 'Nasir Autos Walton Road-Lahore', 'Nasir Autos Walton Road-Lahore', NULL, 'Lahore  Walton Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('768', 'Nawaz Auto Near Metro Stop Multan Road', 'Nawaz Auto Near Metro Stop Multan Road', NULL, 'Lahore  Multan Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('769', 'Nazir Autos Montgomery Road-Lahore', 'Nazir Autos Montgomery Road-Lahore', NULL, 'Lahore  Montgomery Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('770', 'New Al Madina Autos Okara-Lahore', 'New Al Madina Autos Okara-Lahore', NULL, 'Lahore  Okara', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('771', 'New Bilal Auto GT Road Gujranwala-Lahore', 'New Bilal Auto GT Road Gujranwala-Lahore', NULL, 'Lahore  Gujranwala', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('772', 'New Khalid Auto Parts Multan Rd-Lahore', 'New Khalid Auto Parts Multan Rd-Lahore', NULL, 'Lahore  Multan Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('773', 'New Lahore Autos Ferozpur Road-Lahore', 'New Lahore Autos Ferozpur Road-Lahore', NULL, 'Lahore  Ferozpur Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('774', 'New M.A Electric Store Mughal Centre Lhr', 'New M.A Electric Store Mughal Centre Lhr', NULL, 'Lahore  ', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('775', 'New Mian Bhai Auto 10-Montgomery Road', 'New Mian Bhai Auto 10-Montgomery Road', NULL, 'Lahore  Montgomery Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('776', 'New Pak Auto P Block Main Sabzazar', 'New Pak Auto P Block Main Sabzazar', NULL, 'Lahore  Sabzazar', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('777', 'New Pak Autos Gujrat-Lahore', 'New Pak Autos Gujrat-Lahore', NULL, 'Lahore  Gujrat', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('778', 'New Suzuki Centre Montgomery Road Lahore', 'New Suzuki Centre Montgomery Road Lahore', NULL, 'Lahore  Montgomery Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('779', 'Niazi # 99 Bund Road-Lahore', 'Niazi # 99 Bund Road-Lahore', NULL, 'Lahore  Band Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('780', 'Niazi Arms Multan Road-Lahore', 'Niazi Arms Multan Road-Lahore', NULL, 'Lahore  Multan Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('781', 'Niazi Autos Montgomery Road-Lahore', 'Niazi Autos Montgomery Road-Lahore', NULL, 'Lahore  Montgomery Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('782', 'Noor Autos GT Road Gujrat-Lahore', 'Noor Autos GT Road Gujrat-Lahore', NULL, 'Lahore  Gujrat', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('783', 'Noor Filter House Montgomery Road-Lahore', 'Noor Filter House Montgomery Road-Lahore', NULL, 'Lahore  Montgomery Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('784', 'Norani Autos Multan Road-Lahore', 'Norani Autos Multan Road-Lahore', NULL, 'Lahore  Multan Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('785', 'Norani Bearing Store-Gujranwala', 'Norani Bearing Store-Gujranwala', NULL, 'Lahore  Gujranwala', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('786', 'O.R Motors Gurumanget Gulberg-Lahore', 'O.R Motors Gurumanget Gulberg-Lahore', NULL, 'Lahore  Gulberg', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('787', 'P.M Oil Traders Chauburji-Lahore', 'P.M Oil Traders Chauburji-Lahore', NULL, 'Lahore  Chauburji', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('788', 'Pak auto said pur Multan road', 'Pak auto said pur Multan road', NULL, 'Lahore  Multan Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('789', 'Pak Auto Store Badar Pura Multan Road', 'Pak Auto Store Badar Pura Multan Road', NULL, 'Lahore  Multan Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('790', 'Pak Autos Sheikhpura-Lahore', 'Pak Autos Sheikhpura-Lahore', NULL, 'Lahore  Sheikhpura', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('791', 'Pak Madina Autos Sheikhpura Rd-Lahore', 'Pak Madina Autos Sheikhpura Rd-Lahore', NULL, 'Lahore  Sheikhpura', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('792', 'Pak Madina Oil Shadara-Lahore', 'Pak Madina Oil Shadara-Lahore', NULL, 'Lahore  Shahdara', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('793', 'Pak Motors Rehmat Market-Lahore', 'Pak Motors Rehmat Market-Lahore', NULL, 'Lahore  Rehmat Market', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('794', 'Pak Poshish Sadat Market 8-Montgomery', 'Pak Poshish Sadat Market 8-Montgomery', NULL, 'Lahore  Montgomery Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('795', 'Pakistan Arms Chuburji Centre LHR', 'Pakistan Arms Chuburji Centre LHR', NULL, 'Lahore  Chauburji', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('796', 'Pakistan Auto Kot Khawaja Saeed', 'Pakistan Auto Kot Khawaja Saeed', NULL, 'Lahore  Kot Khawaja Saeed', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('797', 'Pakistan Oil Change Mustafa Town Wahdat', 'Pakistan Oil Change Mustafa Town Wahdat', NULL, 'Lahore  Mustafa Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('798', 'Pakistan Oil Change,Go Pump Sabzazar', 'Pakistan Oil Change,Go Pump Sabzazar', NULL, 'Lahore  Sabzazar', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('799', 'Pakistan Oil Traders GT Road Gujrat-LHR', 'Pakistan Oil Traders GT Road Gujrat-LHR', NULL, 'Lahore  Gujrat', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('800', 'Paracha Poshish Queens Road', 'Paracha Poshish Queens Road', NULL, 'Lahore  Queens Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('801', 'Parwaiz Asla Dealer Khachri Bazar Okara', 'Parwaiz Asla Dealer Khachri Bazar Okara', NULL, 'Lahore  Okara', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('802', 'Pervez Brothgers &amp; Co Kachehri Road Lhr', 'Pervez Brothgers &amp; Co Kachehri Road Lhr', NULL, 'Lahore  Okara', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('803', 'Peshawar Auto Samsani Road Johar Town', 'Peshawar Auto Samsani Road Johar Town', NULL, 'Lahore  Johar Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('804', 'Pioneer Motors Ferozpur Road-Lahore', 'Pioneer Motors Ferozpur Road-Lahore', NULL, 'Lahore  Ferozpur Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('805', 'Prime Car Care Main Multan Road', 'Prime Car Care Main Multan Road', NULL, 'Lahore  Multan Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('806', 'Prince Auto Care Abbat Road Lahore', 'Prince Auto Care Abbat Road Lahore', NULL, 'Lahore  Montgomery Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('807', 'Prince Suzuki Center Montgomery Road-LHR', 'Prince Suzuki Center Montgomery Road-LHR', NULL, 'Lahore  Montgomery Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('808', 'Punjab Autos Gold Plaza Gujranwala Lhr', 'Punjab Autos Gold Plaza Gujranwala Lhr', NULL, 'Lahore  Gujranwala', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('809', 'Punjab Autos Johar Town-Lahore', 'Punjab Autos Johar Town-Lahore', NULL, 'Lahore  Johar Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('810', 'Punjab Autos Qasoor-Lahore', 'Punjab Autos Qasoor-Lahore', NULL, 'Lahore  Qasoor', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('811', 'Qasim Auto Gulshan E Ravi Near Bund Road', 'Qasim Auto Gulshan E Ravi Near Bund Road', NULL, 'Lahore  Band Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('812', 'Quality Lube Shop Gulberg Lahore', 'Quality Lube Shop Gulberg Lahore', NULL, 'Lahore  Gulberg', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('813', 'Rahim Oil Stor Joher Town', 'Rahim Oil Stor Joher Town', NULL, 'Lahore  Johar Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('814', 'Raja Auto Workshop Faisal Town Lahore', 'Raja Auto Workshop Faisal Town Lahore', NULL, 'Lahore  Faisal Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('815', 'Rajpoot MOtors Rana Town Lahore', 'Rajpoot MOtors Rana Town Lahore', NULL, 'Lahore  Rana Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('816', 'Rana Asif Autos Iqbal Town-Lahore', 'Rana Asif Autos Iqbal Town-Lahore', NULL, 'Lahore  Iqbal Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('817', 'Rana Auto Care WorkShop Gujrnwala-Lahore', 'Rana Auto Care WorkShop Gujrnwala-Lahore', NULL, 'Lahore  Gujranwala', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('818', 'Rana Autos Johar Town-Lahore', 'Rana Autos Johar Town-Lahore', NULL, 'Lahore  Johar Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('819', 'Rana Autos Multan Road-Lahore', 'Rana Autos Multan Road-Lahore', NULL, 'Lahore  Multan Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('820', 'Rana Autos Oil Gujranwala-Lahore', 'Rana Autos Oil Gujranwala-Lahore', NULL, 'Lahore  Gujranwala', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('821', 'Rao Autos Sabzazar Multan Rd-Lahore', 'Rao Autos Sabzazar Multan Rd-Lahore', NULL, 'Lahore  Multan Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('822', 'Ravi Auto Store Band Raod-Lahore', 'Ravi Auto Store Band Raod-Lahore', NULL, 'Lahore  Band Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('823', 'Razaq Autos Ferozpur Road-Lahore', 'Razaq Autos Ferozpur Road-Lahore', NULL, 'Lahore  Ferozpur Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('824', 'Rehman Auto Waris Road', 'Rehman Auto Waris Road', NULL, 'Lahore  Waris Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('825', 'Rehman Autos Ferozpur Road-Lahore', 'Rehman Autos Ferozpur Road-Lahore', NULL, 'Lahore  Ferozpur Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('826', 'Rehman Autos Johar Town-Lahore', 'Rehman Autos Johar Town-Lahore', NULL, 'Lahore  Johar Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('827', 'Riaz Auto Shahdra Chowk-Lahore', 'Riaz Auto Shahdra Chowk-Lahore', NULL, 'Lahore  Shahdara', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('828', 'Roa Abdullah Autos  Okara Lahore', 'Roa Abdullah Autos  Okara Lahore', NULL, 'Lahore  Okara', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('829', 'Sadiq Autos Gujranwala-Lahore', 'Sadiq Autos Gujranwala-Lahore', NULL, 'Lahore  Gujranwala', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('830', 'Saeed Suzuki Autos Sabzazar-Lahore', 'Saeed Suzuki Autos Sabzazar-Lahore', NULL, 'Lahore  Sabzazar', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('831', 'Saigal Autos Montcomery Road-Lahore', 'Saigal Autos Montcomery Road-Lahore', NULL, 'Lahore  Montgomery Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('832', 'Sajid Autos Gulberg Industrial Area-LHR', 'Sajid Autos Gulberg Industrial Area-LHR', NULL, 'Lahore  Gulberg', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('833', 'Sajjad Auto Super Auto Market Chuburji', 'Sajjad Auto Super Auto Market Chuburji', NULL, 'Lahore  Chauburji', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('834', 'Sajjad Autos Sheikhpura-Lahore', 'Sajjad Autos Sheikhpura-Lahore', NULL, 'Lahore  Sheikhpura', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('835', 'Saqib Auto Khiyali Bypass Gujrawala', 'Saqib Auto Khiyali Bypass Gujrawala', NULL, 'Lahore  Gujranwala', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('836', 'Sardar Auto Near PSO Pump Multan Road', 'Sardar Auto Near PSO Pump Multan Road', NULL, 'Lahore  Multan Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('837', 'Sarwar Oil Store Rasool Park LOS', 'Sarwar Oil Store Rasool Park LOS', NULL, 'Lahore  Los', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('838', 'Seigal Auto Montgomery Road', 'Seigal Auto Montgomery Road', NULL, 'Lahore  Montgomery Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('839', 'Shafqat Auto Main Montgomery Road-Lahore', 'Shafqat Auto Main Montgomery Road-Lahore', NULL, 'Lahore  Montgomery Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('840', 'Shah Jamal Autos Iqbal Town-Lahore', 'Shah Jamal Autos Iqbal Town-Lahore', NULL, 'Lahore  Iqbal Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('841', 'Shah Jee Autos Qasoor-Lahore', 'Shah Jee Autos Qasoor-Lahore', NULL, 'Lahore  Qasoor', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('842', 'Shah Nafees Auto Waris Road', 'Shah Nafees Auto Waris Road', NULL, 'Lahore  Waris Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('843', 'Shahbaz Oil Change Tokey Wala Chowk', 'Shahbaz Oil Change Tokey Wala Chowk', NULL, 'Lahore  Tokey Wala Chowk', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('844', 'Shahid Auto PAk Block Iqbal Town', 'Shahid Auto PAk Block Iqbal Town', NULL, 'Lahore  Iqbal Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('845', 'Shahid Bhai Auto Yateem Khana Multan Roa', 'Shahid Bhai Auto Yateem Khana Multan Roa', NULL, 'Lahore  Multan Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('846', 'Shahzad Autos Johar Town-Lahore', 'Shahzad Autos Johar Town-Lahore', NULL, 'Lahore  Johar Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('847', 'Shalimar Auto Steel Bagh Qasoor', 'Shalimar Auto Steel Bagh Qasoor', NULL, 'Lahore  Qasoor', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('848', 'Shalimar Autos Qasoor-Lahore', 'Shalimar Autos Qasoor-Lahore', NULL, 'Lahore  Qasoor', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('849', 'Sharif Autos Qasoor-Lahore', 'Sharif Autos Qasoor-Lahore', NULL, 'Lahore  Qasoor', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('850', 'Sharjah Oil Harbanspura Canal Park', 'Sharjah Oil Harbanspura Canal Park', NULL, 'Lahore  Canal Park', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('851', 'Shehnaz &amp; Sons GT Road-Gujranwala', 'Shehnaz &amp; Sons GT Road-Gujranwala', NULL, 'Lahore  Gujranwala', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('852', 'Sheikh Auto Pak Block Iqbal Town', 'Sheikh Auto Pak Block Iqbal Town', NULL, 'Lahore  Iqbal Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('853', 'Sheikh Auto Purana Lari Adda Qasoor', 'Sheikh Auto Purana Lari Adda Qasoor', NULL, 'Lahore  Qasoor', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('854', 'Sheikh Auto Spare Parts Main Walton Road', 'Sheikh Auto Spare Parts Main Walton Road', NULL, 'Lahore  Walton Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('855', 'Shenshah Car Poshish Bijli Ghar Stop', 'Shenshah Car Poshish Bijli Ghar Stop', NULL, 'Lahore  Sabzazar', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('856', 'Sher E Imam Autos Montgomery  Road Lhr', 'Sher E Imam Autos Montgomery  Road Lhr', NULL, 'Lahore  Montgomery Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('857', 'Sher E Rabani Autos Hafizabad Gujranwala', 'Sher E Rabani Autos Hafizabad Gujranwala', NULL, 'Lahore  Gujranwala', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('858', 'SKY LINE AUTO SHO[ JOHER TOWN', 'SKY LINE AUTO SHO[ JOHER TOWN', NULL, 'Lahore  Johar Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('859', 'Subhan Auto Battery Gulberg 2 LHR', 'Subhan Auto Battery Gulberg 2 LHR', NULL, 'Lahore  Gulberg', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('860', 'Subhan Auto Gulberg II Lahore', 'Subhan Auto Gulberg II Lahore', NULL, 'Lahore  Gulberg', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('861', 'Subhan Auto Pepsi Road Gulberg III', 'Subhan Auto Pepsi Road Gulberg III', NULL, 'Lahore  Gulberg', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('862', 'Subhan Autos Gulberg ll Lahore', 'Subhan Autos Gulberg ll Lahore', NULL, 'Lahore  Gulberg', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('863', 'Subhan Oil &amp; Auto Sheikhpura Road-Lahore', 'Subhan Oil &amp; Auto Sheikhpura Road-Lahore', NULL, 'Lahore  Sheikhpura', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('864', 'Sun Shine Lube Workshop Walinshia Town', 'Sun Shine Lube Workshop Walinshia Town', NULL, 'Lahore  Walansia Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('865', 'Suntec Company Gulberg-Lahore', 'Suntec Company Gulberg-Lahore', NULL, 'Lahore  Gulberg', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('866', 'Suzuki Ali Jan Queens Road', 'Suzuki Ali Jan Queens Road', NULL, 'Lahore  Queens Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('867', 'Suzuki Auto Center Sabzazar-Lahore', 'Suzuki Auto Center Sabzazar-Lahore', NULL, 'Lahore  Sabzazar', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('868', 'Suzuki Auto House Auto Gujrawala', 'Suzuki Auto House Auto Gujrawala', NULL, 'Lahore  Gujranwala', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('869', 'Suzuki Centre Super Market Chauburji Lhr', 'Suzuki Centre Super Market Chauburji Lhr', NULL, 'Lahore  Chauburji', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('870', 'Suzuki House Gujranwala Road-Lahore', 'Suzuki House Gujranwala Road-Lahore', NULL, 'Lahore  Gujranwala', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('871', 'Suzuki Motors Diyal Singh-Lahore', 'Suzuki Motors Diyal Singh-Lahore', NULL, 'Lahore  Dayal Singh Mention', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('872', 'Syed Masood Shah Auto Queens Road', 'Syed Masood Shah Auto Queens Road', NULL, 'Lahore  Queens Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('873', 'T&amp;T AUTOS JOHER TOWN', 'T&amp;T AUTOS JOHER TOWN', NULL, 'Lahore  Johar Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('874', 'Taha Auto Rehman Garden-Lahore', 'Taha Auto Rehman Garden-Lahore', NULL, 'Lahore  Rehman Garden', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('875', 'Tanveer Autos Montgomery Road-Lahore', 'Tanveer Autos Montgomery Road-Lahore', NULL, 'Lahore  Montgomery Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('876', 'Tariq &amp; Sons Auto 6-A Montgomery Road', 'Tariq &amp; Sons Auto 6-A Montgomery Road', NULL, 'Lahore  Montgomery Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('877', 'Tariq Auto Shedewal Johar Town-Lahore', 'Tariq Auto Shedewal Johar Town-Lahore', NULL, 'Lahore  Johar Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('878', 'Tariq Car A/C GT Road Okara-Lahore', 'Tariq Car A/C GT Road Okara-Lahore', NULL, 'Lahore  Okara', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('879', 'Tariq Suzuki Autos Johar Town-Lahore', 'Tariq Suzuki Autos Johar Town-Lahore', NULL, 'Lahore  Johar Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('880', 'Tassawur Auto Pepsi Road Gulberg II', 'Tassawur Auto Pepsi Road Gulberg II', NULL, 'Lahore  Gulberg', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('881', 'Techno Auto W/Shop Shahdra Chowk', 'Techno Auto W/Shop Shahdra Chowk', NULL, 'Lahore  Shahdra', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('882', 'Toyota Cantt Main Walton Road', 'Toyota Cantt Main Walton Road', NULL, 'Lahore  Walton Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('883', 'Toyota Suzuki House Sheikhpura-Lahore', 'Toyota Suzuki House Sheikhpura-Lahore', NULL, 'Lahore  Sheikhpura', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('884', 'Umar Autos Johar Town-Lahore', 'Umar Autos Johar Town-Lahore', NULL, 'Lahore  Johar Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('885', 'Umer Auto Oil Store Multan Raod Lahore', 'Umer Auto Oil Store Multan Raod Lahore', NULL, 'Lahore  Multan Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('886', 'Usman Autos Chauburji-Lahore', 'Usman Autos Chauburji-Lahore', NULL, 'Lahore  Chauburji', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('887', 'Usman Autos Hafizabad-Lahore', 'Usman Autos Hafizabad-Lahore', NULL, 'Lahore  Hafizabad', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('888', 'Usman Autos Saddar Bazar Lahore', 'Usman Autos Saddar Bazar Lahore', NULL, 'Lahore  Sadar', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('889', 'Usman Autos Zaki Ada Qasoor Lhr', 'Usman Autos Zaki Ada Qasoor Lhr', NULL, 'Lahore  Qasoor', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('890', 'Victory Auto 10-Montgomery Road Lahore', 'Victory Auto 10-Montgomery Road Lahore', NULL, 'Lahore  Montgomery Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('891', 'Wahab Auto Pepsi Road Gurumanget Gulberg', 'Wahab Auto Pepsi Road Gurumanget Gulberg', NULL, 'Lahore  Gulberg', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('892', 'Waheed Motors Montgomery Road LHR', 'Waheed Motors Montgomery Road LHR', NULL, 'Lahore  Montgomery Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('893', 'Waqas Auto Canal Bank Hajveri Colony', 'Waqas Auto Canal Bank Hajveri Colony', NULL, 'Lahore  Canal Bank', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('894', 'Waqas Autos Gujranwala Rd Hafizabad Lhr', 'Waqas Autos Gujranwala Rd Hafizabad Lhr', NULL, 'Lahore  Hafizabad', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('895', 'Yaseen Autos GT Road Gujrat-Lahore', 'Yaseen Autos GT Road Gujrat-Lahore', NULL, 'Lahore  Gujrat', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('896', 'Yousaf Auto Shade Wal Chowk Joher Town', 'Yousaf Auto Shade Wal Chowk Joher Town', NULL, 'Lahore  Johar Town', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('897', 'ZA Auto Montgomery Road-Lahore', 'ZA Auto Montgomery Road-Lahore', NULL, 'Lahore  Montgomery Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('898', 'Zaheer Autos Multan Road-Lahore', 'Zaheer Autos Multan Road-Lahore', NULL, 'Lahore  Multan Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('899', 'Zahid Auto Osaka Display Walton Road', 'Zahid Auto Osaka Display Walton Road', NULL, 'Lahore  Walton Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('900', 'Zahid Mehmood Tools Latif Centre Nishtar', 'Zahid Mehmood Tools Latif Centre Nishtar', NULL, 'Lahore  Nishtar Colony', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('901', 'Zain Auto near Toyota Motros Walton Lhr', 'Zain Auto near Toyota Motros Walton Lhr', NULL, 'Lahore  Walton Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('902', 'Zameer Autos Gujranwala-Lahore', 'Zameer Autos Gujranwala-Lahore', NULL, 'Lahore  Gujranwala', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('903', 'Zeeshan &amp; Co Qasoor-Lahore', 'Zeeshan &amp; Co Qasoor-Lahore', NULL, 'Lahore  Qasoor', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('904', 'Zeeshan Autos Infentri Road-Lahore', 'Zeeshan Autos Infentri Road-Lahore', NULL, 'Lahore  Infentri Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('905', 'Zubair Autos Qasoor-Lahore', 'Zubair Autos Qasoor-Lahore', NULL, 'Lahore  Qasoor', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('906', 'A Y Lube Shop Jorry Pull-Lahore', 'A Y Lube Shop Jorry Pull-Lahore', NULL, 'Lahore  Jorry Pull', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('907', 'A.G Auto Bao Wala-Lahore', 'A.G Auto Bao Wala-Lahore', NULL, 'Lahore  Bao Wala', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('908', 'A.H Oil Ghazi Abad Near Imran Bakery', 'A.H Oil Ghazi Abad Near Imran Bakery', NULL, 'Lahore  Ghazi Abad', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('909', 'Abdullah Auto Dera Gujjran-Lahore', 'Abdullah Auto Dera Gujjran-Lahore', NULL, 'Lahore  Dera Gujjran', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('910', 'Afzal &amp; Sons Sukh Nehar GT Road-Lahore', 'Afzal &amp; Sons Sukh Nehar GT Road-Lahore', NULL, 'Lahore  Gt Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('911', 'Ahmed Auto Zone Ali Pur Garden Badian', 'Ahmed Auto Zone Ali Pur Garden Badian', NULL, 'Lahore  Ali Pur Garden', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('912', 'Al Awan Auto Jorry Pull-Lahore', 'Al Awan Auto Jorry Pull-Lahore', NULL, 'Lahore  Jorry Pull', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('913', 'Al Aziz Auto Bhatta Chowk-Lahore', 'Al Aziz Auto Bhatta Chowk-Lahore', NULL, 'Lahore  Bhatta Chowk', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('914', 'Al Aziz Oil Para Gon Society-Lahore', 'Al Aziz Oil Para Gon Society-Lahore', NULL, 'Lahore  Para Gon Society', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('915', 'Al Fareed Oil Zaitoon Colony Salamat Pur', 'Al Fareed Oil Zaitoon Colony Salamat Pur', NULL, 'Lahore  Salamt Pura', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('916', 'Al Kareem Auto Bhatta Chowk-Lahore', 'Al Kareem Auto Bhatta Chowk-Lahore', NULL, 'Lahore  Bhatta Chowk', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('917', 'Al Khair Oil Tajpura-Lahore', 'Al Khair Oil Tajpura-Lahore', NULL, 'Lahore  Tajpura', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('918', 'Al Kuwait Auto GT Raod-Lahore', 'Al Kuwait Auto GT Raod-Lahore', NULL, 'Lahore  Gt Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('919', 'Al Madina Auto 204 Q-Block Defence', 'Al Madina Auto 204 Q-Block Defence', NULL, 'Lahore  Defence', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('920', 'Al Madina Auto Bhatta Chowk', 'Al Madina Auto Bhatta Chowk', NULL, 'Lahore  Bhatta Chowk', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('921', 'Al Madina Auto near Rangers HQ', 'Al Madina Auto near Rangers HQ', NULL, 'Lahore  Bhatta Chowk', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('922', 'Al Rehman Oil Store Mughalpura-Lahore', 'Al Rehman Oil Store Mughalpura-Lahore', NULL, 'Lahore  Mughalpura', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('923', 'Al Riaz Oil House Infentri Road-Lahore', 'Al Riaz Oil House Infentri Road-Lahore', NULL, 'Lahore  Infentri Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('924', 'Al Sadiq Auto Durand Road-Lahore', 'Al Sadiq Auto Durand Road-Lahore', NULL, 'Lahore  Durand Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('925', 'Al Saeed Oil Mew Garden-Lahore', 'Al Saeed Oil Mew Garden-Lahore', NULL, 'Lahore  Mew Garden', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('926', 'Ali Auto Sadar Near Dipu Stop-Lahore', 'Ali Auto Sadar Near Dipu Stop-Lahore', NULL, 'Lahore  Sadar', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('927', 'Ali Haider Auto Bao Wala-Lahore', 'Ali Haider Auto Bao Wala-Lahore', NULL, 'Lahore  Bao Wala', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('928', 'Ali Hajveri Auto Allama Iqbal Road', 'Ali Hajveri Auto Allama Iqbal Road', NULL, 'Lahore  Allama Iqbal Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('929', 'Ali Hajveri Auto Jallo Pind-Lahore', 'Ali Hajveri Auto Jallo Pind-Lahore', NULL, 'Lahore  Jallo Pind', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('930', 'Ali Oil Store Infentri Road-Lahore', 'Ali Oil Store Infentri Road-Lahore', NULL, 'Lahore  Infentri Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('931', 'Altaf Auto Daroghywala-Lahore', 'Altaf Auto Daroghywala-Lahore', NULL, 'Lahore  Daroghywala', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('932', 'Anwar E Sidra Auto Gt Road-Lahore', 'Anwar E Sidra Auto Gt Road-Lahore', NULL, 'Lahore  Gt Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('933', 'Auto Speed Infentri Road-Lahore', 'Auto Speed Infentri Road-Lahore', NULL, 'Lahore  Infentri Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('934', 'Ayesha Auto Gari Shahu-Lahore', 'Ayesha Auto Gari Shahu-Lahore', NULL, 'Lahore  Gari Shahu', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('935', 'Aziz Auto Infentry Road Lahore', 'Aziz Auto Infentry Road Lahore', NULL, 'Lahore  Infentri Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('936', 'Badami Bagh Auto Daroghy Wala-Lahore', 'Badami Bagh Auto Daroghy Wala-Lahore', NULL, 'Lahore  Daroghywala', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('937', 'Badami Bagh Auto Jorry Pull-Lahore', 'Badami Bagh Auto Jorry Pull-Lahore', NULL, 'Lahore  Jorry Pull', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('938', 'Basheer &amp; Sons Infentri Road-Lahore', 'Basheer &amp; Sons Infentri Road-Lahore', NULL, 'Lahore  Infentri Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('939', 'Bilal Auto Bata Pur-Lahore', 'Bilal Auto Bata Pur-Lahore', NULL, 'Lahore  Bata Pur', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('940', 'Bilal Auto GT Road-Lahore', 'Bilal Auto GT Road-Lahore', NULL, 'Lahore  Gt Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('941', 'Bilal Auto Tajpura-Lahore', 'Bilal Auto Tajpura-Lahore', NULL, 'Lahore  Tajpura', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('942', 'Billa Auto Bata Pur-Lahore', 'Billa Auto Bata Pur-Lahore', NULL, 'Lahore  Bata Pur', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('943', 'Bismillah Auto Bao Wala-Lahore', 'Bismillah Auto Bao Wala-Lahore', NULL, 'Lahore  Bao Wala', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('944', 'Bismillah Auto Jorry Pull-Lahore', 'Bismillah Auto Jorry Pull-Lahore', NULL, 'Lahore  Jorry Pull', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('945', 'Bismillah Tyres Pakistan Mint-Lahore', 'Bismillah Tyres Pakistan Mint-Lahore', NULL, 'Lahore  Pakistan Mint', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('946', 'Butt Auto Barki Road-Lahore', 'Butt Auto Barki Road-Lahore', NULL, 'Lahore  Barki Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('947', 'Butt Auto Para Gon Society-Lahore', 'Butt Auto Para Gon Society-Lahore', NULL, 'Lahore  Para Gon Society', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('948', 'C.P Auto Bao Wala-Lahore', 'C.P Auto Bao Wala-Lahore', NULL, 'Lahore  Bao Wala', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('949', 'Car Decoration Bata Pur-Lahore', 'Car Decoration Bata Pur-Lahore', NULL, 'Lahore  Bata Pur', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('950', 'Car Mechanic Soutter Mill Mani Road-LHR', 'Car Mechanic Soutter Mill Mani Road-LHR', NULL, 'Lahore  Soutter Mill', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('951', 'Car Point Bhatta Chowk-Lahore', 'Car Point Bhatta Chowk-Lahore', NULL, 'Lahore  Bhatta Chowk', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('952', 'Car Saloon Fateh Ghar-Lahore', 'Car Saloon Fateh Ghar-Lahore', NULL, 'Lahore  Fateh Ghar', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('953', 'Car View Auto Batapur-Lahore', 'Car View Auto Batapur-Lahore', NULL, 'Lahore  Bata Pur', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('954', 'Chohan Auto Bao Wala-Lahore', 'Chohan Auto Bao Wala-Lahore', NULL, 'Lahore  Bao Wala', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('955', 'City Auto Workshop Airport Chowk-Lahore', 'City Auto Workshop Airport Chowk-Lahore', NULL, 'Lahore  Airport Chowk', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('956', 'Coast To Coast Oil Daroghywala-Lahore', 'Coast To Coast Oil Daroghywala-Lahore', NULL, 'Lahore  Daroghywala', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('957', 'DATA Auto GT ROAD LAHORE', 'DATA Auto GT ROAD LAHORE', NULL, 'Lahore  Gt Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('958', 'Dawoud Auto Bhatta Chowk-Lahore', 'Dawoud Auto Bhatta Chowk-Lahore', NULL, 'Lahore  Bhatta Chowk', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('959', 'Decent Auto Manawan-Lahore', 'Decent Auto Manawan-Lahore', NULL, 'Lahore  Manawan', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('960', 'Defence Auto Bhatta Chowk-Lahore', 'Defence Auto Bhatta Chowk-Lahore', NULL, 'Lahore  Bhatta Chowk', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('961', 'Extreme Performance Bhatta Chowk', 'Extreme Performance Bhatta Chowk', NULL, 'Lahore  Bhatta Chowk', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('962', 'Faraz Auto GT Road Near Gourmet Resturan', 'Faraz Auto GT Road Near Gourmet Resturan', NULL, 'Lahore  Gt Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('963', 'Faridi Auto Daroghy Wala Near Bund Road', 'Faridi Auto Daroghy Wala Near Bund Road', NULL, 'Lahore  Daroghywala', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('964', 'Farooq Auto Sadar Near Dipu Stop-Lahore', 'Farooq Auto Sadar Near Dipu Stop-Lahore', NULL, 'Lahore  Sadar', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('965', 'Filter Land Para Gone Society-Lahore', 'Filter Land Para Gone Society-Lahore', NULL, 'Lahore  Para Gon Society', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('966', 'Fine Auto Mew Garden-Lahore', 'Fine Auto Mew Garden-Lahore', NULL, 'Lahore  Mew Garden', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('967', 'Fine Oil Land Dhaka Road Sadar-Lahore', 'Fine Oil Land Dhaka Road Sadar-Lahore', NULL, 'Lahore  Sadar', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('968', 'Future Auto Bata Pur-Lahore', 'Future Auto Bata Pur-Lahore', NULL, 'Lahore  Bata Pur', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('969', 'Ganj Baksh Auto Opposite UET GT Road', 'Ganj Baksh Auto Opposite UET GT Road', NULL, 'Lahore  Gt Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('970', 'Ghousia Auto Durand Road-Lahore', 'Ghousia Auto Durand Road-Lahore', NULL, 'Lahore  Durand Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('971', 'Golden Star Auto Mian Infentry Road Laho', 'Golden Star Auto Mian Infentry Road Laho', NULL, 'Lahore  Infentri Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('972', 'Habibi Auto New Pull Near Auto Market', 'Habibi Auto New Pull Near Auto Market', NULL, 'Lahore  Tajpura', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('973', 'Hafiz Oil Store Bahar Shah Road-Lahore', 'Hafiz Oil Store Bahar Shah Road-Lahore', NULL, 'Lahore  Bahar Shah Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('974', 'Hamdard Auto Bhatta Chowk-Lahore', 'Hamdard Auto Bhatta Chowk-Lahore', NULL, 'Lahore  Bhatta Chowk', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('975', 'Hamza Auto Salamat Pura-Lahore', 'Hamza Auto Salamat Pura-Lahore', NULL, 'Lahore  Salamt Pura', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('976', 'Haq Bahu Auto Manawan Bagh Wali Puli', 'Haq Bahu Auto Manawan Bagh Wali Puli', NULL, 'Lahore  Manawan', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('977', 'Hascol Oil Sukh Nehar-Lahore', 'Hascol Oil Sukh Nehar-Lahore', NULL, 'Lahore  Gt Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('978', 'Hussain Auto GT Road-Lahore', 'Hussain Auto GT Road-Lahore', NULL, 'Lahore  Gt Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('979', 'Hussain Auto Sadar Near Dipu Stop-Lahore', 'Hussain Auto Sadar Near Dipu Stop-Lahore', NULL, 'Lahore  Sadar', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('980', 'I.A Oil Change Bhatta Chowk-Lahore', 'I.A Oil Change Bhatta Chowk-Lahore', NULL, 'Lahore  Bhatta Chowk', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('981', 'I.N.H Auto Bhatta Chowk-Lahore', 'I.N.H Auto Bhatta Chowk-Lahore', NULL, 'Lahore  Bhatta Chowk', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('982', 'Imran Oil Centre Infentri Road Sadar', 'Imran Oil Centre Infentri Road Sadar', NULL, 'Lahore  Infentri Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('983', 'Irfan Auto Sadar Dhaka Road-Lahore', 'Irfan Auto Sadar Dhaka Road-Lahore', NULL, 'Lahore  Sadar', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('984', 'Japan Auto Bhatta Chowk-Lahore', 'Japan Auto Bhatta Chowk-Lahore', NULL, 'Lahore  Bhatta Chowk', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('985', 'Japan Auto Mew Garden-Lahore', 'Japan Auto Mew Garden-Lahore', NULL, 'Lahore  Mew Garden', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('986', 'Japan Autos Infentri Road-Lahore', 'Japan Autos Infentri Road-Lahore', NULL, 'Lahore  Infentri Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('987', 'Javaid Auto Shadi Pura-Lahore', 'Javaid Auto Shadi Pura-Lahore', NULL, 'Lahore  Shadi Pura', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('988', 'Junaid Auto Jallo Mor', 'Junaid Auto Jallo Mor', NULL, 'Lahore  Jallo Mor', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('989', 'Junaid Auto Sadar Dhaka Road-Lahore', 'Junaid Auto Sadar Dhaka Road-Lahore', NULL, 'Lahore  Sadar', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('990', 'K2S Auto Jallo Pind Near Ghurki Hospital', 'K2S Auto Jallo Pind Near Ghurki Hospital', NULL, 'Lahore  Jallo Pind', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('991', 'Khan Auto Daroghywala-Lahore', 'Khan Auto Daroghywala-Lahore', NULL, 'Lahore  Daroghywala', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('992', 'Khan Auto Tajpura Near Railway Crossing', 'Khan Auto Tajpura Near Railway Crossing', NULL, 'Lahore  Tajpura', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('993', 'Lahore Oil Bao Wala-Lahore', 'Lahore Oil Bao Wala-Lahore', NULL, 'Lahore  Bao Wala', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('994', 'Lahore Oil Gt Road-Lahore', 'Lahore Oil Gt Road-Lahore', NULL, 'Lahore  Gt Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('995', 'M R Oil Change Jorry Pull', 'M R Oil Change Jorry Pull', NULL, 'Lahore  Jorry Pull', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('996', 'M.R Auto Gt Road-Lahore', 'M.R Auto Gt Road-Lahore', NULL, 'Lahore  Gt Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('997', 'Macca Auto Jorry Pull-Lahore', 'Macca Auto Jorry Pull-Lahore', NULL, 'Lahore  Jorry Pull', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('998', 'Madina Auto Badian Road-Lahore', 'Madina Auto Badian Road-Lahore', NULL, 'Lahore  Badian ', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('999', 'Madina Auto Gari Shahu-Lahore', 'Madina Auto Gari Shahu-Lahore', NULL, 'Lahore  Gari Shahu', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1000', 'Madina Auto Imamia Colony GT Road-Lahore', 'Madina Auto Imamia Colony GT Road-Lahore', NULL, 'Lahore  Gt Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1001', 'Malik Auto Jorry Pull-Lahore', 'Malik Auto Jorry Pull-Lahore', NULL, 'Lahore  Jorry Pull', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1002', 'Malik Auto Momin Pura-Lahore', 'Malik Auto Momin Pura-Lahore', NULL, 'Lahore  Momin Pura', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1003', 'Malik Brother Auto Bao Wala-Lahore', 'Malik Brother Auto Bao Wala-Lahore', NULL, 'Lahore  Bao Wala', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1004', 'MASHALLAH Auto Jallo Pind Ghurki Hospita', 'MASHALLAH Auto Jallo Pind Ghurki Hospita', NULL, 'Lahore  Jallo Pind', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1005', 'Mashallah Auto Quaid E Azam Interchange', 'Mashallah Auto Quaid E Azam Interchange', NULL, 'Lahore  Quaid E Azam Inerchange', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1006', 'MASHALLAH Auto Tajpura', 'MASHALLAH Auto Tajpura', NULL, 'Lahore  Tajpura', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1007', 'MASHALLAH Oil Change Manawan-Lahore', 'MASHALLAH Oil Change Manawan-Lahore', NULL, 'Lahore  Manawan', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1008', 'Master Auto Tajpura-Lahore', 'Master Auto Tajpura-Lahore', NULL, 'Lahore  Tajpura', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1009', 'Master Latif Auto Jallo Pind-Lahore', 'Master Latif Auto Jallo Pind-Lahore', NULL, 'Lahore  Jallo Pind', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1010', 'Mehar Auto Workshop Manawan-Lahore', 'Mehar Auto Workshop Manawan-Lahore', NULL, 'Lahore  Manawan', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1011', 'Mehar Latif Mehmood Booti Ring Road', 'Mehar Latif Mehmood Booti Ring Road', NULL, 'Lahore  Mehmood Booti', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1012', 'Mian Auto Badian Road-Lahore', 'Mian Auto Badian Road-Lahore', NULL, 'Lahore  Badian ', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1013', 'Mian Auto Gt Road-Lahore', 'Mian Auto Gt Road-Lahore', NULL, 'Lahore  Gt Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1014', 'Mian Filter Bata Pur-Lahore', 'Mian Filter Bata Pur-Lahore', NULL, 'Lahore  Bata Pur', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1015', 'Mian Meer Oil Infentri Road-Lahore', 'Mian Meer Oil Infentri Road-Lahore', NULL, 'Lahore  Infentri Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1016', 'Mian Oil Change Imamia Colony-Lahore', 'Mian Oil Change Imamia Colony-Lahore', NULL, 'Lahore  Imamia Colony', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1017', 'Mubashir Khan Oil Tajpura-Lahore', 'Mubashir Khan Oil Tajpura-Lahore', NULL, 'Lahore  Tajpura', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1018', 'Mubashir Oil Allama Iqbal Road-Lahore', 'Mubashir Oil Allama Iqbal Road-Lahore', NULL, 'Lahore  Allama Iqbal Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1019', 'Mubashir Oil Bao Wala-Lahore', 'Mubashir Oil Bao Wala-Lahore', NULL, 'Lahore  Bao Wala', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1020', 'Muhammadi Oil Change Gari Shahu', 'Muhammadi Oil Change Gari Shahu', NULL, 'Lahore  Gari Shahu', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1021', 'Mujahid Autos GT Road-Lahore', 'Mujahid Autos GT Road-Lahore', NULL, 'Lahore  Gt Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1022', 'Mushtaq Autos GT Road-Lahore', 'Mushtaq Autos GT Road-Lahore', NULL, 'Lahore  Gt Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1023', 'Muzammil Auto Harbanspura-Lahore', 'Muzammil Auto Harbanspura-Lahore', NULL, 'Lahore  Harbanspura', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1024', 'Nadeem Auto Tajpura-Lahore', 'Nadeem Auto Tajpura-Lahore', NULL, 'Lahore  Tajpura', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1025', 'Najaf Oil Harbanspura-Lahore', 'Najaf Oil Harbanspura-Lahore', NULL, 'Lahore  Harbanspura', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1026', 'Naveed Auto Tajpura-Lahore', 'Naveed Auto Tajpura-Lahore', NULL, 'Lahore  Tajpura', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1027', 'Nawaz Auto Gt Road-Lahore', 'Nawaz Auto Gt Road-Lahore', NULL, 'Lahore  Gt Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1028', 'New Al Madina Auto Manawan Hospital', 'New Al Madina Auto Manawan Hospital', NULL, 'Lahore  Manawan', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1029', 'New Bismillah Auto Jorry-Lahore', 'New Bismillah Auto Jorry-Lahore', NULL, 'Lahore  Jorry Pull', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1030', 'New Friend Auto Daroghywala-Lahore', 'New Friend Auto Daroghywala-Lahore', NULL, 'Lahore  Daroghywala', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1031', 'New Khan Auto Para Gon Society-Lahore', 'New Khan Auto Para Gon Society-Lahore', NULL, 'Lahore  Para Gon Society', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1032', 'New Madni Auto Airport Road Bhatta Chowk', 'New Madni Auto Airport Road Bhatta Chowk', NULL, 'Lahore  Bhatta Chowk', NULL, NULL, NULL, NULL, NULL, NULL, '0');
INSERT INTO `0_crm_persons` VALUES
('1033', 'New Muhammadi Oil Centre Sadar Gol Chakk', 'New Muhammadi Oil Centre Sadar Gol Chakk', NULL, 'Lahore  Sadar', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1034', 'New Rafique Auto Mew Garden-Lahore', 'New Rafique Auto Mew Garden-Lahore', NULL, 'Lahore  Mew Garden', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1035', 'New Safi Mazda Bund Road Daroghywala', 'New Safi Mazda Bund Road Daroghywala', NULL, 'Lahore  Daroghywala', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1036', 'New Shalimar Oil Gt Road-Lahore', 'New Shalimar Oil Gt Road-Lahore', NULL, 'Lahore  Gt Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1037', 'New Siddique Auto Taj Pura-Lahore', 'New Siddique Auto Taj Pura-Lahore', NULL, 'Lahore  Tajpura', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1038', 'New Tayyab Auto Kot Khawaja Saeed', 'New Tayyab Auto Kot Khawaja Saeed', NULL, 'Lahore  Kot Khawaja Saeed', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1039', 'New Umer Oil Store Harbanspura Phatak', 'New Umer Oil Store Harbanspura Phatak', NULL, 'Lahore  Harbanspura', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1040', 'New Usman Auto Sadar Dhaka Road-Lahore', 'New Usman Auto Sadar Dhaka Road-Lahore', NULL, 'Lahore  Sadar', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1041', 'Nisar Sons Jorry Pull-Lahore', 'Nisar Sons Jorry Pull-Lahore', NULL, 'Lahore  Jorry Pull', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1042', 'NoShahi Auto Tajpura-Lahore', 'NoShahi Auto Tajpura-Lahore', NULL, 'Lahore  Tajpura', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1043', 'Number Dar Auto Near Rangers HQ', 'Number Dar Auto Near Rangers HQ', NULL, 'Lahore  Bhatta Chowk', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1044', 'Oil Change Taj Bagh-Lahore', 'Oil Change Taj Bagh-Lahore', NULL, 'Lahore  Taj Bagh', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1045', 'P.R.O Lube Shop Barki Road-Lahore', 'P.R.O Lube Shop Barki Road-Lahore', NULL, 'Lahore  Bao Wala', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1046', 'Pak Madina Oil Allama Iqbal Road-Lahore', 'Pak Madina Oil Allama Iqbal Road-Lahore', NULL, 'Lahore  Allama Iqbal Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1047', 'PSO Pump Sadar-Lahore', 'PSO Pump Sadar-Lahore', NULL, 'Lahore  Sadar', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1048', 'Punjab Oil Jorry Pull-Lahore', 'Punjab Oil Jorry Pull-Lahore', NULL, 'Lahore  Jorry Pull', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1049', 'Qasim Auto Badian Road-Lahore', 'Qasim Auto Badian Road-Lahore', NULL, 'Lahore  Badian ', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1050', 'Qazi Golden Motor Dhaka Road Sadar', 'Qazi Golden Motor Dhaka Road Sadar', NULL, 'Lahore  Sadar', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1051', 'Rafai Auto Tajpura Near Railway Crossing', 'Rafai Auto Tajpura Near Railway Crossing', NULL, 'Lahore  Tajpura', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1052', 'Rafaqat Oil GT Road-Lahore', 'Rafaqat Oil GT Road-Lahore', NULL, 'Lahore  Gt Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1053', 'Rafiq Auto Dharam Pura-Lahore', 'Rafiq Auto Dharam Pura-Lahore', NULL, 'Lahore  Dharam Pura', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1054', 'Rafiq Oil Badian Road-Lahore', 'Rafiq Oil Badian Road-Lahore', NULL, 'Lahore  Badian ', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1055', 'Rehan Auto Sher Shah Road-Lahore', 'Rehan Auto Sher Shah Road-Lahore', NULL, 'Lahore  Sher Shah Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1056', 'Royal Auto Harbanspura Railway Crossing', 'Royal Auto Harbanspura Railway Crossing', NULL, 'Lahore  Harbanspura', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1057', 'Sabir Auto Manawan-Lahore', 'Sabir Auto Manawan-Lahore', NULL, 'Lahore  Manawan', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1058', 'Sagheer &amp; Son Auto Harbanspure Near 1122', 'Sagheer &amp; Son Auto Harbanspure Near 1122', NULL, 'Lahore  Harbanspura', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1059', 'Saleem Auto Bao Wala-Lahore', 'Saleem Auto Bao Wala-Lahore', NULL, 'Lahore  Bao Wala', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1060', 'Sarwar Lube Shop Allama Iqbal Road', 'Sarwar Lube Shop Allama Iqbal Road', NULL, 'Lahore  Allama Iqbal Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1061', 'Shafqat Ali Arm Gt Road phatak-Lahore', 'Shafqat Ali Arm Gt Road phatak-Lahore', NULL, 'Lahore  Gt Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1062', 'Shah G Battery Centre Sadar-Lahore', 'Shah G Battery Centre Sadar-Lahore', NULL, 'Lahore  Sadar', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1063', 'Shahbaz Auto Jorry Pull-Lahore', 'Shahbaz Auto Jorry Pull-Lahore', NULL, 'Lahore  Jorry Pull', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1064', 'Shahbaz Bro Dhaka Road Sadar Cantt', 'Shahbaz Bro Dhaka Road Sadar Cantt', NULL, 'Lahore  Sadar', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1065', 'Shahid Auto Momin Pura Near Daroghy Wala', 'Shahid Auto Momin Pura Near Daroghy Wala', NULL, 'Lahore  Daroghywala', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1066', 'Shalimar Auto Gt Road-Lahore', 'Shalimar Auto Gt Road-Lahore', NULL, 'Lahore  Gt Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1067', 'Shalimar Auto Manawan-Lahore', 'Shalimar Auto Manawan-Lahore', NULL, 'Lahore  Manawan', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1068', 'Sharif Autos Saddar Bazar Cantt-Lahore', 'Sharif Autos Saddar Bazar Cantt-Lahore', NULL, 'Lahore  Sadar', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1069', 'Sheraz Oil Sukh Neahr GT Road-Lahore', 'Sheraz Oil Sukh Neahr GT Road-Lahore', NULL, 'Lahore  Gt Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1070', 'Siddiqui Auto New Pull Near Auto Market', 'Siddiqui Auto New Pull Near Auto Market', NULL, 'Lahore  Tajpura', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1071', 'Sohni Autos G.T Road Singhpura-Lahore', 'Sohni Autos G.T Road Singhpura-Lahore', NULL, 'Lahore  Gt Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1072', 'Subhan Auto Islam Park Gt Road-Lahore', 'Subhan Auto Islam Park Gt Road-Lahore', NULL, 'Lahore  Gt Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1073', 'Subhan Auto Near Jorry Pull-Lahore', 'Subhan Auto Near Jorry Pull-Lahore', NULL, 'Lahore  Jorry Pull', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1074', 'Subhan Auto Souter Mill Mani Road-Lahore', 'Subhan Auto Souter Mill Mani Road-Lahore', NULL, 'Lahore  Soutter Mill', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1075', 'Sunny Auto GT Road-Lahore', 'Sunny Auto GT Road-Lahore', NULL, 'Lahore  Gt Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1076', 'Super Car Wash Qalandar Pura-Lahore', 'Super Car Wash Qalandar Pura-Lahore', NULL, 'Lahore  Qalandarpura', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1077', 'Syed Auto Bata Pur-Lahore', 'Syed Auto Bata Pur-Lahore', NULL, 'Lahore  Bata Pur', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1078', 'Tahir Auto Parts Bund Road Daroghy Wala', 'Tahir Auto Parts Bund Road Daroghy Wala', NULL, 'Lahore  Daroghywala', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1079', 'Taimoor Auto Copper Store-Lahore', 'Taimoor Auto Copper Store-Lahore', NULL, 'Lahore  Copper Store', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1080', 'Taimoor Auto Gt Road-Lahore', 'Taimoor Auto Gt Road-Lahore', NULL, 'Lahore  Gt Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1081', 'Taj Din Auto GT Road Pso Pump Lahore', 'Taj Din Auto GT Road Pso Pump Lahore', NULL, 'Lahore  Gt Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1082', 'Tayyeba Lube ShopTufail Road Saddar Cant', 'Tayyeba Lube ShopTufail Road Saddar Cant', NULL, 'Lahore  Sadar', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1083', 'Touheed Auto Infentri Road-Lahore', 'Touheed Auto Infentri Road-Lahore', NULL, 'Lahore  Infentri Road', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1084', 'Umer Oil Centre Airport Road Bhatta Chow', 'Umer Oil Centre Airport Road Bhatta Chow', NULL, 'Lahore  Bhatta Chowk', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1085', 'Unique Auto 204 DHA Phase I Cantt', 'Unique Auto 204 DHA Phase I Cantt', NULL, 'Lahore  Dha  ', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1086', 'Unique Auto Bhatta Chowk-Lahore', 'Unique Auto Bhatta Chowk-Lahore', NULL, 'Lahore  Bhatta Chowk', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1087', 'Unique Oil Bhatta Chowk-Lahore', 'Unique Oil Bhatta Chowk-Lahore', NULL, 'Lahore  Bhatta Chowk', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1088', 'Usama Battaries Centre New Pull Tajpura', 'Usama Battaries Centre New Pull Tajpura', NULL, 'Lahore  Tajpura', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1089', 'Usman Auto Bata Pur-Lahore', 'Usman Auto Bata Pur-Lahore', NULL, 'Lahore  Bata Pur', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1090', 'Usman Auto Taj Bagh-Lahore', 'Usman Auto Taj Bagh-Lahore', NULL, 'Lahore  Taj Bagh', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1091', 'Waheed Auto Daroghy Wala-Lahore', 'Waheed Auto Daroghy Wala-Lahore', NULL, 'Lahore  Daroghywala', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1092', 'Yaqoob Auto Badian Road-Lahore', 'Yaqoob Auto Badian Road-Lahore', NULL, 'Lahore  Badian ', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1093', 'Yaseen Auto Gari Shahu-Lahore', 'Yaseen Auto Gari Shahu-Lahore', NULL, 'Lahore  Gari Shahu', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1094', 'Yaseen Oil Store Bund Road Daroghy Wala', 'Yaseen Oil Store Bund Road Daroghy Wala', NULL, 'Lahore  Daroghywala', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1095', 'Z.A Auto Tajpura-Lahore', 'Z.A Auto Tajpura-Lahore', NULL, 'Lahore  Tajpura', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1096', 'Zeeshan Oil Bhatta Chowk-Lahore', 'Zeeshan Oil Bhatta Chowk-Lahore', NULL, 'Lahore  Bhatta Chowk', NULL, NULL, NULL, NULL, NULL, NULL, '0'),
('1097', 'Protech', 'Protech', NULL, 'N/A', '0308-0911909', NULL, NULL, NULL, NULL, NULL, '0'),
('1098', 'Pak Pet (Pvt) Ltd', 'Pak Pet (Pvt) Ltd', NULL, 'N/A', '0300-8276334', NULL, NULL, NULL, NULL, NULL, '0'),
('1099', 'Mijukom', 'Mijukom', NULL, 'N/A', '0333-2280907', NULL, NULL, NULL, NULL, NULL, '0'),
('1100', 'Techno Pack', 'Techno Pack', NULL, 'N/A', '0313-0242842', NULL, NULL, NULL, NULL, NULL, '0'),
('1101', 'I.C.I Pakistan', 'I.C.I Pakistan', NULL, 'N/A', '0301-8221471', NULL, NULL, NULL, NULL, NULL, '0'),
('1102', 'Pro Care Industries (Pvt) Ltd', 'Pro Care Industries (Pvt) Ltd', NULL, 'N/A', '0334-3039527', NULL, NULL, NULL, NULL, NULL, '0'),
('1103', 'Pakistan State Oil Ltd', 'Pakistan State Oil Ltd', NULL, 'N/A', '0333-2134540', NULL, NULL, NULL, NULL, NULL, '0');

### Structure of table `0_currencies` ###

DROP TABLE IF EXISTS `0_currencies`;

CREATE TABLE `0_currencies` (
  `currency` varchar(60) NOT NULL DEFAULT '',
  `curr_abrev` char(3) NOT NULL DEFAULT '',
  `curr_symbol` varchar(10) NOT NULL DEFAULT '',
  `country` varchar(100) NOT NULL DEFAULT '',
  `hundreds_name` varchar(15) NOT NULL DEFAULT '',
  `auto_update` tinyint(1) NOT NULL DEFAULT 1,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`curr_abrev`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_currencies` ###

INSERT INTO `0_currencies` VALUES
('CA Dollars', 'CAD', '$', 'Canada', 'Cents', '1', '0'),
('Euro', 'EUR', '€', 'Europe', 'Cents', '1', '0'),
('Pounds', 'GBP', '£', 'England', 'Pence', '1', '0'),
('Rupee', 'PKR', 'Rs', 'Pakistan', 'Rupees', '1', '0'),
('US Dollars', 'USD', '$', 'United States', 'Cents', '1', '0');

### Structure of table `0_cust_allocations` ###

DROP TABLE IF EXISTS `0_cust_allocations`;

CREATE TABLE `0_cust_allocations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `person_id` int(11) DEFAULT NULL,
  `amt` double unsigned DEFAULT NULL,
  `date_alloc` date NOT NULL DEFAULT '0000-00-00',
  `trans_no_from` int(11) DEFAULT NULL,
  `trans_type_from` int(11) DEFAULT NULL,
  `trans_no_to` int(11) DEFAULT NULL,
  `trans_type_to` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `trans_type_from` (`person_id`,`trans_type_from`,`trans_no_from`,`trans_type_to`,`trans_no_to`),
  KEY `From` (`trans_type_from`,`trans_no_from`),
  KEY `To` (`trans_type_to`,`trans_no_to`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_cust_allocations` ###


### Structure of table `0_cust_branch` ###

DROP TABLE IF EXISTS `0_cust_branch`;

CREATE TABLE `0_cust_branch` (
  `branch_code` int(11) NOT NULL AUTO_INCREMENT,
  `debtor_no` int(11) NOT NULL DEFAULT 0,
  `br_name` varchar(100) NOT NULL DEFAULT '',
  `branch_ref` varchar(100) NOT NULL DEFAULT '',
  `br_address` tinytext NOT NULL,
  `area` int(11) DEFAULT NULL,
  `salesman` int(11) NOT NULL DEFAULT 0,
  `default_location` varchar(5) NOT NULL DEFAULT '',
  `tax_group_id` int(11) DEFAULT NULL,
  `sales_account` varchar(15) NOT NULL DEFAULT '',
  `sales_discount_account` varchar(15) NOT NULL DEFAULT '',
  `receivables_account` varchar(15) NOT NULL DEFAULT '',
  `payment_discount_account` varchar(15) NOT NULL DEFAULT '',
  `default_ship_via` int(11) NOT NULL DEFAULT 1,
  `br_post_address` tinytext NOT NULL,
  `group_no` int(11) NOT NULL DEFAULT 0,
  `notes` tinytext NOT NULL,
  `bank_account` varchar(60) DEFAULT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`branch_code`,`debtor_no`),
  KEY `branch_ref` (`branch_ref`),
  KEY `group_no` (`group_no`)
) ENGINE=InnoDB AUTO_INCREMENT=1099 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_cust_branch` ###

INSERT INTO `0_cust_branch` VALUES
('1', '1', 'A.A Joyland (Pvt) Ltd', 'A.A Joyland (Pvt) Ltd 2', 'Karachi', '2', '1', 'DEF', '1', '', '4510', '1200', '1200', '1', 'Karachi', '0', '', NULL, '0'),
('2', '2', 'Allied Industries Hub (Pvt.) Ltd.', 'Allied Industries Hub (Pvt.) Ltd.', 'Karachi', '2', '1', '001', '1', '', '4510', '1200', '1200', '1', 'Karachi', '0', '', NULL, '0'),
('3', '3', 'Ams Industrial &amp; Eng. Co (Htl Express)	', 'Ams Industrial &amp; Eng. Co (Htl Express)	', 'Karachi', '2', '1', '001', '1', '', '4510', '1200', '1200', '1', 'Karachi', '0', '', NULL, '0'),
('4', '4', 'Greaves Pakistan (Pvt.) Ltd', 'Greaves Pakistan (Pvt.) Ltd', 'Karachi', '2', '1', '001', '1', '', '4510', '1200', '1200', '1', 'Karachi', '0', '', NULL, '0'),
('5', '5', 'Honda Quaideen', 'Honda Quaideen', 'Karachi', '2', '1', '001', '1', '', '4510', '1200', '1200', '1', 'Karachi', '0', '', NULL, '0'),
('6', '6', 'Honda South (Private) Limited', 'Honda South (Private) Limited', 'Karachi', '2', '1', '001', '1', '', '4510', '1200', '1200', '1', 'Karachi', '0', '', NULL, '0'),
('7', '7', 'Ideal Power Engineering Services', 'Ideal Power Engineering Services', 'Karachi', '2', '1', '001', '1', '', '4510', '1200', '1200', '1', 'Karachi', '0', '', NULL, '0'),
('8', '8', 'Jaffer Brothers (Pvt) Ltd', 'Jaffer Brothers (Pvt) Ltd', 'Karachi', '2', '1', '001', '1', '', '4510', '1200', '1200', '1', 'Karachi', '0', '', NULL, '0'),
('9', '9', 'Karim Container (Pvt) Ltd', 'Karim Container (Pvt) Ltd', 'Karachi', '2', '1', '001', '1', '', '4510', '1200', '1200', '1', 'Karachi', '0', '', NULL, '0'),
('10', '10', 'M/ S Honda Drive In', 'M/ S Honda Drive In', 'Karachi', '2', '1', '001', '1', '', '4510', '1200', '1200', '1', 'Karachi', '0', '', NULL, '0'),
('11', '11', 'M/ S Hyundai South', 'M/ S Hyundai South', 'Karachi', '2', '1', '001', '1', '', '4510', '1200', '1200', '1', 'Karachi', '0', '', NULL, '0'),
('12', '12', 'M/S Advance Colours', 'M/S Advance Colours', 'Karachi', '2', '1', '001', '1', '', '4510', '1200', '1200', '1', 'Karachi', '0', '', NULL, '0'),
('13', '13', 'M/S Dewan Motors (Pvt.) Ltd-Bmw', 'M/S Dewan Motors (Pvt.) Ltd-Bmw', 'Karachi', '2', '1', '001', '1', '', '4510', '1200', '1200', '1', 'Karachi', '0', '', NULL, '0'),
('14', '14', 'M/S Dewan Mushtaq Motors Co (Pvt.) Ltd', 'M/S Dewan Mushtaq Motors Co (Pvt.) Ltd', 'Karachi', '2', '1', '001', '1', '', '4510', '1200', '1200', '1', 'Karachi', '0', '', NULL, '0'),
('15', '15', 'M/S Honda Khair (Pvt.) Ltd.', 'M/S Honda Khair (Pvt.) Ltd.', 'Karachi', '2', '1', '001', '1', '', '4510', '1200', '1200', '1', 'Karachi', '0', '', NULL, '0'),
('16', '16', 'M/S Kia Motor - South', 'M/S Kia Motor - South', 'Karachi', '2', '1', '001', '1', '', '4510', '1200', '1200', '1', 'Karachi', '0', '', NULL, '0'),
('17', '17', 'M/S Kia Motors Macca', 'M/S Kia Motors Macca', 'Karachi', '2', '1', '001', '1', '', '4510', '1200', '1200', '1', 'Karachi', '0', '', NULL, '0'),
('18', '18', 'M/S Loads Limited', 'M/S Loads Limited', 'Karachi', '2', '1', '001', '1', '', '4510', '1200', '1200', '1', 'Karachi', '0', '', NULL, '0'),
('19', '19', 'M/S Mandviwala Motors (Private) Ltd', 'M/S Mandviwala Motors (Private) Ltd', 'Karachi', '2', '1', '001', '1', '', '4510', '1200', '1200', '1', 'Karachi', '0', '', NULL, '0'),
('20', '20', 'M/S Mg Centre', 'M/S Mg Centre', 'Karachi', '2', '1', '001', '1', '', '4510', '1200', '1200', '1', 'Karachi', '0', '', NULL, '0'),
('21', '21', 'M/S Nabi Qasim Industries (Pvt.) Ltd.', 'M/S Nabi Qasim Industries (Pvt.) Ltd.', 'Karachi', '2', '1', '001', '1', '', '4510', '1200', '1200', '1', 'Karachi', '0', '', NULL, '0'),
('22', '22', 'M/S Naseer Autos', 'M/S Naseer Autos', 'Karachi', '2', '1', '001', '1', '', '4510', '1200', '1200', '1', 'Karachi', '0', '', NULL, '0'),
('23', '23', 'M/S National Foods Limited', 'M/S National Foods Limited', 'Karachi', '2', '1', '001', '1', '', '4510', '1200', '1200', '1', 'Karachi', '0', '', NULL, '0'),
('24', '24', 'M/S O &amp; A International', 'M/S O &amp; A International', 'Karachi', '2', '1', '001', '1', '', '4510', '1200', '1200', '1', 'Karachi', '0', '', NULL, '0'),
('25', '25', 'M/S Phoenix Armour (Pvt.) Ltd', 'M/S Phoenix Armour (Pvt.) Ltd', 'Karachi', '2', '1', '001', '1', '', '4510', '1200', '1200', '1', 'Karachi', '0', '', NULL, '0'),
('26', '26', 'M/S R M Salt', 'M/S R M Salt', 'Karachi', '2', '1', '001', '1', '', '4510', '1200', '1200', '1', 'Karachi', '0', '', NULL, '0'),
('27', '27', 'M/S Riaz Motors', 'M/S Riaz Motors', 'Karachi', '2', '1', '001', '1', '', '4510', '1200', '1200', '1', 'Karachi', '0', '', NULL, '0'),
('28', '28', 'M/S Sna Motors', 'M/S Sna Motors', 'Karachi', '2', '1', '001', '1', '', '4510', '1200', '1200', '1', 'Karachi', '0', '', NULL, '0'),
('29', '29', 'M/S Suzuki Nadeem International', 'M/S Suzuki Nadeem International', 'Karachi', '2', '1', '001', '1', '', '4510', '1200', '1200', '1', 'Karachi', '0', '', NULL, '0'),
('30', '30', 'M/S Toyota Creek Motors (Pvt.) Ltd', 'M/S Toyota Creek Motors (Pvt.) Ltd', 'Karachi', '2', '1', '001', '1', '', '4510', '1200', '1200', '1', 'Karachi', '0', '', NULL, '0'),
('31', '31', 'M/S Toyota Highway Motors', 'M/S Toyota Highway Motors', 'Karachi', '2', '1', '001', '1', '', '4510', '1200', '1200', '1', 'Karachi', '0', '', NULL, '0'),
('32', '32', 'M/S Toyota Society Motors (Pvt.) Ltd.', 'M/S Toyota Society Motors (Pvt.) Ltd.', 'Karachi', '2', '1', '001', '1', '', '4510', '1200', '1200', '1', 'Karachi', '0', '', NULL, '0'),
('33', '33', 'M/S Union Fabrics (Pvt.) Ltd', 'M/S Union Fabrics (Pvt.) Ltd', 'Karachi', '2', '1', '001', '1', '', '4510', '1200', '1200', '1', 'Karachi', '0', '', NULL, '0'),
('34', '34', 'M/S Toyota Central Motors', 'M/S Toyota Central Motors', 'Karachi', '2', '1', '001', '1', '', '4510', '1200', '1200', '1', 'Karachi', '0', '', NULL, '0'),
('35', '35', 'Marshal Traders', 'Marshal Traders', 'Karachi', '2', '1', '001', '1', '', '4510', '1200', '1200', '1', 'Karachi', '0', '', NULL, '0'),
('36', '36', 'Pak Suzuki Motor Co. Ltd', 'Pak Suzuki Motor Co. Ltd', 'Karachi', '2', '1', '001', '1', '', '4510', '1200', '1200', '1', 'Karachi', '0', '', NULL, '0'),
('37', '37', 'Pakistan Petroleum Limited', 'Pakistan Petroleum Limited', 'Karachi', '2', '1', '001', '1', '', '4510', '1200', '1200', '1', 'Karachi', '0', '', NULL, '0'),
('38', '38', 'Parson Industries (Pvt) Ltd. - S.I.T.E', 'Parson Industries (Pvt) Ltd. - S.I.T.E', 'Karachi', '2', '1', '001', '1', '', '4510', '1200', '1200', '1', 'Karachi', '0', '', NULL, '0'),
('39', '39', 'Presson Descon Int (Pvt) Ltd', 'Presson Descon Int (Pvt) Ltd', 'Karachi', '2', '1', '001', '1', '', '4510', '1200', '1200', '1', 'Karachi', '0', '', NULL, '0'),
('40', '40', 'Quetta Textile Mills Ltd', 'Quetta Textile Mills Ltd', 'Karachi', '2', '1', '001', '1', '', '4510', '1200', '1200', '1', 'Karachi', '0', '', NULL, '0'),
('41', '41', 'R.A Engineering (Pvt.) Ltd', 'R.A Engineering (Pvt.) Ltd', 'Karachi', '2', '1', '001', '1', '', '4510', '1200', '1200', '1', 'Karachi', '0', '', NULL, '0'),
('42', '42', 'S.M Jaffer &amp; Company', 'S.M Jaffer &amp; Company', 'Karachi', '2', '1', '001', '1', '', '4510', '1200', '1200', '1', 'Karachi', '0', '', NULL, '0'),
('43', '43', 'Sapphire Textile Mills Ltd', 'Sapphire Textile Mills Ltd', 'Karachi', '2', '1', '001', '1', '', '4510', '1200', '1200', '1', 'Karachi', '0', '', NULL, '0'),
('44', '44', 'Specialized Autoparts Ind. (Pvt.) Ltd', 'Specialized Autoparts Ind. (Pvt.) Ltd', 'Karachi', '2', '1', '001', '1', '', '4510', '1200', '1200', '1', 'Karachi', '0', '', NULL, '0'),
('45', '45', 'SSGC LPG (Pvt.) Ltd', 'SSGC LPG (Pvt.) Ltd', 'Karachi', '2', '1', '001', '1', '', '4510', '1200', '1200', '1', 'Karachi', '0', '', NULL, '0'),
('46', '46', 'Sui Southern Gas Company Ltd', 'Sui Southern Gas Company Ltd', 'Karachi', '2', '1', '001', '1', '', '4510', '1200', '1200', '1', 'Karachi', '0', '', NULL, '0'),
('47', '47', 'Taqi &amp; Sons', 'Taqi &amp; Sons', 'Karachi', '2', '1', '001', '1', '', '4510', '1200', '1200', '1', 'Karachi', '0', '', NULL, '0'),
('48', '48', 'Technovative Era Pvt Ltd', 'Technovative Era Pvt Ltd', 'Karachi', '2', '1', '001', '1', '', '4510', '1200', '1200', '1', 'Karachi', '0', '', NULL, '0'),
('49', '49', 'Toyota Port Qasim Motors (Pvt) Ltd', 'Toyota Port Qasim Motors (Pvt) Ltd', 'Karachi', '2', '1', '001', '1', '', '4510', '1200', '1200', '1', 'Karachi', '0', '', NULL, '0'),
('50', '50', 'Unregistrator Company Sales Ncpl', 'Unregistrator Company Sales Ncpl', 'Karachi', '2', '1', '001', '1', '', '4510', '1200', '1200', '1', 'Karachi', '0', '', NULL, '0'),
('51', '51', 'Areeb Auto', 'Areeb Auto', 'Hyderabad', '4', '2', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('52', '52', 'Ayan Ali Auto', 'Ayan Ali Auto', 'Hyderabad', '4', '2', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('53', '53', 'Bhitai Auto ', 'Bhitai Auto ', 'Hyderabad', '4', '2', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('54', '54', 'Data Autos', 'Data Autos', 'Hyderabad', '4', '2', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('55', '55', 'Data Body Parts', 'Data Body Parts', 'Hyderabad', '4', '2', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('56', '56', 'Hamza Autos', 'Hamza Autos', 'Hyderabad', '4', '2', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('57', '57', 'Hanif Autos', 'Hanif Autos', 'Hyderabad', '4', '2', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('58', '58', 'Hoorain Auto', 'Hoorain Auto', 'Hyderabad', '4', '2', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('59', '59', 'New Data Oil', 'New Data Oil', 'Hyderabad', '4', '2', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('60', '60', 'Prince Siddiquei  Motor', 'Prince Siddiquei  Motor', 'Hyderabad', '4', '2', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('61', '61', 'qalandri', 'qalandri', 'Hyderabad', '4', '2', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('62', '62', 'Zeeshan Autos ', 'Zeeshan Autos ', 'Hyderabad', '4', '2', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('63', '63', 'B.S Autos', 'B.S Autos', 'Hyderabad', '4', '2', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('64', '64', 'Hussain Auto', 'Hussain Auto', 'Hyderabad', '4', '2', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('65', '65', 'Leavenge Oil Change', 'Leavenge Oil Change', 'Hyderabad', '4', '2', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('66', '66', 'Muflah Autos', 'Muflah Autos', 'Hyderabad', '4', '2', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('67', '67', 'Quick Oil', 'Quick Oil', 'Hyderabad', '4', '2', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('68', '68', 'Qureshi Auto', 'Qureshi Auto', 'Hyderabad', '4', '2', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('69', '69', 'New Sindh Motor', 'New Sindh Motor', 'Hyderabad', '4', '2', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('70', '70', 'Noor Motor', 'Noor Motor', 'Hyderabad', '4', '2', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('71', '71', 'Akram Auto', 'Akram Auto', 'Hyderabad', '4', '2', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('72', '72', 'Indus Autos', 'Indus Autos', 'Hyderabad', '4', '2', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('73', '73', 'Pak Autos', 'Pak Autos', 'Hyderabad', '4', '2', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('74', '74', 'Shair Khan Autos', 'Shair Khan Autos', 'Hyderabad', '4', '2', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('75', '75', 'A.R Autos', 'A.R Autos', 'Hyderabad', '4', '2', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('76', '76', 'Imtiaz Auto', 'Imtiaz Auto', 'Hyderabad', '4', '2', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('77', '77', 'Khan Auto', 'Khan Auto', 'Hyderabad', '4', '2', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('78', '78', 'Suzuki Motor High Way', 'Suzuki Motor High Way', 'Hyderabad', '4', '2', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('79', '79', 'Kia Motor J', 'Kia Motor J', 'Hyderabad', '4', '2', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('80', '80', 'Bhalai Auto', 'Bhalai Auto', 'Hyderabad', '4', '2', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('81', '81', 'J.S Autos', 'J.S Autos', 'Hyderabad', '4', '2', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('82', '82', 'S.A Malik Autos ', 'S.A Malik Autos ', 'Hyderabad', '4', '2', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('83', '83', 'Al Fazal Auto', 'Al Fazal Auto', 'Hyderabad', '4', '2', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('84', '84', 'Alam Autos', 'Alam Autos', 'Hyderabad', '4', '2', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('85', '85', 'Bismillah Auto ', 'Bismillah Auto ', 'Hyderabad', '4', '2', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('86', '86', 'Bukhari Auto', 'Bukhari Auto', 'Hyderabad', '4', '2', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('87', '87', 'National Serhad Auot', 'National Serhad Auot', 'Hyderabad', '4', '2', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('88', '88', 'Sheikh Zahoor Oil', 'Sheikh Zahoor Oil', 'Hyderabad', '4', '2', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('89', '89', 'Auto Resq', 'Auto Resq', 'Hyderabad', '4', '2', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('90', '90', 'Jawaid Autos', 'Jawaid Autos', 'Hyderabad', '4', '2', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('91', '91', 'Taj Motor', 'Taj Motor', 'Hyderabad', '4', '2', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('92', '92', 'Umar Car Ac', 'Umar Car Ac', 'Hyderabad', '4', '2', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('93', '93', 'Wel Come Autos', 'Wel Come Autos', 'Hyderabad', '4', '2', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('94', '94', 'Ab Jabbar', 'Ab Jabbar', 'Hyderabad', '4', '2', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('95', '95', 'Al Noor Autos', 'Al Noor Autos', 'Hyderabad', '4', '2', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('96', '96', 'Baloch Auto', 'Baloch Auto', 'Hyderabad', '4', '2', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('97', '97', 'Khiuwaja Rafique', 'Khiuwaja Rafique', 'Hyderabad', '4', '2', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('98', '98', 'Qureshi Auto 2', 'Qureshi Auto 2', 'Hyderabad', '4', '2', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('99', '99', 'Jawaid Autos 2', 'Jawaid Autos 2', 'Hyderabad', '4', '2', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('100', '100', 'Wel Come Autos 2', 'Wel Come Autos 2', 'Hyderabad', '4', '2', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('101', '101', 'Mehran Autos', 'Mehran Autos', 'Hyderabad', '4', '2', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('102', '102', 'Sattar Auto Electric', 'Sattar Auto Electric', 'Hyderabad', '4', '2', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('103', '103', 'Shahzad Auto', 'Shahzad Auto', 'Hyderabad', '4', '2', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('104', '104', 'Bermati Show Parts', 'Bermati Show Parts', 'Hyderabad', '4', '2', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('105', '105', 'Faraz Auto', 'Faraz Auto', 'Hyderabad', '4', '2', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('106', '106', 'Fatima Show Parts', 'Fatima Show Parts', 'Hyderabad', '4', '2', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('107', '107', 'Gulistan Autos', 'Gulistan Autos', 'Hyderabad', '4', '2', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('108', '108', 'New Sindh Motor 2', 'New Sindh Motor 2', 'Hyderabad', '4', '2', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('109', '109', 'Sakhi Lal Show Parts', 'Sakhi Lal Show Parts', 'Hyderabad', '4', '2', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('110', '110', 'Shah Autos', 'Shah Autos', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('111', '111', 'Jahangeri Auto ', 'Jahangeri Auto ', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('112', '112', 'M.Ismail Autos ', 'M.Ismail Autos ', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('113', '113', 'Aslam ', 'Aslam ', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('114', '114', 'Hassan Autos -', 'Hassan Autos -', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('115', '115', 'Star Auto', 'Star Auto', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('116', '116', 'Iqbal Autos ', 'Iqbal Autos ', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('117', '117', 'Ajmeri Autos ', 'Ajmeri Autos ', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('118', '118', 'Al Hamd', 'Al Hamd', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('119', '119', 'New Al Mehran Autos', 'New Al Mehran Autos', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('120', '120', 'Saeed Autos', 'Saeed Autos', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('121', '121', 'KPK Autos ', 'KPK Autos ', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('122', '122', 'Bab-e-Khyber Autos', 'Bab-e-Khyber Autos', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('123', '123', 'Rizwan Autos ', 'Rizwan Autos ', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('124', '124', 'Noor Autos', 'Noor Autos', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('125', '125', 'Super Autos ', 'Super Autos ', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('126', '126', 'Abbu Baker', 'Abbu Baker', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('127', '127', 'Al Raza Auto', 'Al Raza Auto', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('128', '128', 'Al Reman Autos', 'Al Reman Autos', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('129', '129', 'Arsalan Motor', 'Arsalan Motor', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('130', '130', 'Auto Mart', 'Auto Mart', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('131', '131', 'Azhar Autos', 'Azhar Autos', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('132', '132', 'Bilal Motor', 'Bilal Motor', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('133', '133', 'Dubai Autos ', 'Dubai Autos ', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('134', '134', 'Faisal Motor', 'Faisal Motor', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('135', '135', 'Fayaz', 'Fayaz', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('136', '136', 'Hadi Autos', 'Hadi Autos', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('137', '137', 'Honda Centre ', 'Honda Centre ', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('138', '138', 'Idrees Autos', 'Idrees Autos', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('139', '139', 'Imran', 'Imran', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('140', '140', 'Imtiaz Autos ', 'Imtiaz Autos ', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('141', '141', 'Iqra Autos', 'Iqra Autos', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('142', '142', 'Junaid Rubber', 'Junaid Rubber', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('143', '143', 'Khalique Motor', 'Khalique Motor', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('144', '144', 'Khan Motor', 'Khan Motor', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('145', '145', 'M.R Auto', 'M.R Auto', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('146', '146', 'Madina Rubber ', 'Madina Rubber ', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('147', '147', 'Mehran Auto', 'Mehran Auto', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('148', '148', 'Missan Bukhari', 'Missan Bukhari', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('149', '149', 'Moien Autos', 'Moien Autos', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('150', '150', 'Nazeer', 'Nazeer', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('151', '151', 'Pakistan Rools', 'Pakistan Rools', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('152', '152', 'Pervaiz Auto ', 'Pervaiz Auto ', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('153', '153', 'Quality ', 'Quality ', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('154', '154', 'Raza Tools ', 'Raza Tools ', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('155', '155', 'Rehan Autos', 'Rehan Autos', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('156', '156', 'Riaz Lubricant', 'Riaz Lubricant', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('157', '157', 'Rohan Tools', 'Rohan Tools', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('158', '158', 'Sahfique Autos', 'Sahfique Autos', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('159', '159', 'Sattar Autos', 'Sattar Autos', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('160', '160', 'Shafique Autos', 'Shafique Autos', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('161', '161', 'Syed Auto', 'Syed Auto', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('162', '162', 'Taiwan Auto', 'Taiwan Auto', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('163', '163', 'Toyota House ', 'Toyota House ', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('164', '164', 'Urooj Auto', 'Urooj Auto', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('165', '165', 'Zaib Auto', 'Zaib Auto', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('166', '166', 'Zeeshan Autos  2', 'Zeeshan Autos  2', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('167', '167', 'Bilal Autos', 'Bilal Autos', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('168', '168', 'Kazim Autos ', 'Kazim Autos ', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('169', '169', 'M.Ayan Autos ', 'M.Ayan Autos ', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('170', '170', 'Makhdoom Fakhro Zaman ', 'Makhdoom Fakhro Zaman ', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('171', '171', 'Tawakal Autos Hala-', 'Tawakal Autos Hala-', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('172', '172', 'Afridi Autos', 'Afridi Autos', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('173', '173', 'Akbar Autos ', 'Akbar Autos ', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('174', '174', 'Arain Autos ', 'Arain Autos ', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('175', '175', 'B.S Autos 2', 'B.S Autos 2', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('176', '176', 'Malik Autos ', 'Malik Autos ', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('177', '177', 'Shah Noorani Autos ', 'Shah Noorani Autos ', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('178', '178', 'Abbassi Auto', 'Abbassi Auto', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('179', '179', 'Karamat Autos', 'Karamat Autos', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('180', '180', 'Madina Autos h', 'Madina Autos h', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('181', '181', 'Madina Autos ', 'Madina Autos ', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('182', '182', 'Mistri Ghulam Rasool', 'Mistri Ghulam Rasool', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('183', '183', 'Naz Autos-Nawabshah', 'Naz Autos-Nawabshah', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('184', '184', 'Sheikh Autos', 'Sheikh Autos', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('185', '185', 'Sindh Autos', 'Sindh Autos', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('186', '186', 'Siraj Autos ', 'Siraj Autos ', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('187', '187', 'Zakir Hussain ', 'Zakir Hussain ', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('188', '188', '786 Autos ', '786 Autos ', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('189', '189', 'Mashallah Autos', 'Mashallah Autos', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('190', '190', 'Ashraf Autos ', 'Ashraf Autos ', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('191', '191', 'sohail And Adeel', 'sohail And Adeel', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('192', '192', 'Sindh Auto', 'Sindh Auto', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('193', '193', 'S.M Tools ', 'S.M Tools ', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('194', '194', 'Shah Noor Autos', 'Shah Noor Autos', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('195', '195', 'Al Furqan Auto', 'Al Furqan Auto', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('196', '196', 'Classic Rubber', 'Classic Rubber', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('197', '197', 'Kamran Autos ', 'Kamran Autos ', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('198', '198', 'Abdullah Auto ', 'Abdullah Auto ', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('199', '199', 'Azan Auto', 'Azan Auto', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('200', '200', 'Kashif Wahid Rubber ', 'Kashif Wahid Rubber ', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('201', '201', 'Amir Autos ', 'Amir Autos ', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('202', '202', 'Abdul Wahab Autos ', 'Abdul Wahab Autos ', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('203', '203', 'Hussaini Autos', 'Hussaini Autos', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('204', '204', 'Al Hydri Mill Store-', 'Al Hydri Mill Store-', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('205', '205', 'Sindh Machinery ', 'Sindh Machinery ', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('206', '206', 'Badri Mills', 'Badri Mills', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('207', '207', 'Vella Mills Stora', 'Vella Mills Stora', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('208', '208', 'Bohri Mills', 'Bohri Mills', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('209', '209', 'Huzaifa Mill Store ', 'Huzaifa Mill Store ', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('210', '210', 'Adam Jee Wali Jee ', 'Adam Jee Wali Jee ', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('211', '211', 'Fatima Bearing', 'Fatima Bearing', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('212', '212', 'Sharafally Mulla Ahmedji', 'Sharafally Mulla Ahmedji', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('213', '213', 'Muhammadi Mill Store ', 'Muhammadi Mill Store ', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('214', '214', 'Ahmed Bux Rahim Bux ', 'Ahmed Bux Rahim Bux ', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('215', '215', 'Mehran Machinery', 'Mehran Machinery', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('216', '216', 'Asfand Machinery ', 'Asfand Machinery ', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('217', '217', 'Fida Hussain Abdul Ali ', 'Fida Hussain Abdul Ali ', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('218', '218', 'Hussain Armoury', 'Hussain Armoury', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('219', '219', 'Alamgir Trader', 'Alamgir Trader', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('220', '220', 'Ahmed Ali Shamsuddin', 'Ahmed Ali Shamsuddin', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('221', '221', 'Yousuf Ali Moosaji ', 'Yousuf Ali Moosaji ', 'Hyderabad', '4', '3', '001', '2', '', '4510', '1200', '1200', '1', 'Hyderabad', '0', '', NULL, '0'),
('222', '222', '786 Auto B Block Model Town-Lahore', '786 Auto B Block Model Town-Lahore', 'Lahore  Model Town', '3', '4', 'DEF', '1', '', '4510', '1200', '1200', '1', 'Lahore  Model Town', '0', '', NULL, '0'),
('223', '223', '786 Auto Badami Bagh LHR', '786 Auto Badami Bagh LHR', 'Lahore  Badami Bagh', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badami Bagh', '0', '', NULL, '0'),
('224', '224', '786 Auto Misri Shah-Lahore', '786 Auto Misri Shah-Lahore', 'Lahore  Misri Shah', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Misri Shah', '0', '', NULL, '0'),
('225', '225', '786 Auto Motors Model Town-Lahore', '786 Auto Motors Model Town-Lahore', 'Lahore  Model Town', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Model Town', '0', '', NULL, '0'),
('226', '226', 'Aadil Auto Naqi Road Nila Gumbad', 'Aadil Auto Naqi Road Nila Gumbad', 'Lahore  Nila Gumbad', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Nila Gumbad', '0', '', NULL, '0'),
('227', '227', 'Aamir Brother Auto,Auto Centre B.Bagh', 'Aamir Brother Auto,Auto Centre B.Bagh', 'Lahore  Badami Bagh', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badami Bagh', '0', '', NULL, '0'),
('228', '228', 'Abdul Rehman Auto Badami Bagh', 'Abdul Rehman Auto Badami Bagh', 'Lahore  Badami Bagh', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badami Bagh', '0', '', NULL, '0'),
('229', '229', 'Abia Motors Auto Centre Badami Bagh', 'Abia Motors Auto Centre Badami Bagh', 'Lahore  Badami Bagh', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badami Bagh', '0', '', NULL, '0'),
('230', '230', 'Abid Auto Badami Bagh-Lahore', 'Abid Auto Badami Bagh-Lahore', 'Lahore  Badami Bagh', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badami Bagh', '0', '', NULL, '0'),
('231', '231', 'Adil Arms Nila Gumbad-Lahore', 'Adil Arms Nila Gumbad-Lahore', 'Lahore  Nila Gumbad', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Nila Gumbad', '0', '', NULL, '0'),
('232', '232', 'Adnan Auto,Auto Centre Basement BB', 'Adnan Auto,Auto Centre Basement BB', 'Lahore  Badami Bagh', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badami Bagh', '0', '', NULL, '0'),
('233', '233', 'Adnan Supplier Badami Bagh', 'Adnan Supplier Badami Bagh', 'Lahore  Badami Bagh', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badami Bagh', '0', '', NULL, '0'),
('234', '234', 'Afia Auto Near Islamia College Sialkot', 'Afia Auto Near Islamia College Sialkot', 'Lahore  Sialkot', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Sialkot', '0', '', NULL, '0'),
('235', '235', 'Ahmad Autos Peco Road Lahore', 'Ahmad Autos Peco Road Lahore', 'Lahore  Peco Road', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Peco Road', '0', '', NULL, '0'),
('236', '236', 'Ahsan Autos Badami Bagh-Lahore', 'Ahsan Autos Badami Bagh-Lahore', 'Lahore  Badami Bagh', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badami Bagh', '0', '', NULL, '0'),
('237', '237', 'Akhter Autos Narowal-Lahore', 'Akhter Autos Narowal-Lahore', 'Lahore  Narowal', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Narowal', '0', '', NULL, '0'),
('238', '238', 'Al Hadi Auto Badami Bagh-Lahore', 'Al Hadi Auto Badami Bagh-Lahore', 'Lahore  Badami Bagh', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badami Bagh', '0', '', NULL, '0'),
('239', '239', 'Al Khan Auto Lahore', 'Al Khan Auto Lahore', 'Lahore  Badami Bagh', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badami Bagh', '0', '', NULL, '0'),
('240', '240', 'Al Madina Auto Shop #1 Peco Road', 'Al Madina Auto Shop #1 Peco Road', 'Lahore  Peco Road', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Peco Road', '0', '', NULL, '0'),
('241', '241', 'Al Munir Auto Badami Bagh Lhr', 'Al Munir Auto Badami Bagh Lhr', 'Lahore  Badami Bagh', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badami Bagh', '0', '', NULL, '0'),
('242', '242', 'Al Noor Motors LG 92-93 Auto Centre 2 BB', 'Al Noor Motors LG 92-93 Auto Centre 2 BB', 'Lahore  Badami Bagh', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badami Bagh', '0', '', NULL, '0'),
('243', '243', 'Al Wahab Autos Badami Bagh-Lahore', 'Al Wahab Autos Badami Bagh-Lahore', 'Lahore  Badami Bagh', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badami Bagh', '0', '', NULL, '0'),
('244', '244', 'Al-Waqar Lube Shop-Sargodha', 'Al-Waqar Lube Shop-Sargodha', 'Lahore  Sargodha', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Sargodha', '0', '', NULL, '0'),
('245', '245', 'Ali Auto Qasoor Centre Badami Bagh', 'Ali Auto Qasoor Centre Badami Bagh', 'Lahore  Badami Bagh', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badami Bagh', '0', '', NULL, '0'),
('246', '246', 'Ali Usman Auto Badami Bagh', 'Ali Usman Auto Badami Bagh', 'Lahore  Badami Bagh', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badami Bagh', '0', '', NULL, '0'),
('247', '247', 'Altaf Traders 11 Auto Centre Badami Bagh', 'Altaf Traders 11 Auto Centre Badami Bagh', 'Lahore  Badami Bagh', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badami Bagh', '0', '', NULL, '0'),
('248', '248', 'Amaan Autos Badami Bagh-Lahore', 'Amaan Autos Badami Bagh-Lahore', 'Lahore  Badami Bagh', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badami Bagh', '0', '', NULL, '0'),
('249', '249', 'Anas Traders Old Anarkali-Lahore', 'Anas Traders Old Anarkali-Lahore', 'Lahore  Anarkali', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Anarkali', '0', '', NULL, '0'),
('250', '250', 'Arif Autos A.Block Model Town-Lahore', 'Arif Autos A.Block Model Town-Lahore', 'Lahore  Model Town', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Model Town', '0', '', NULL, '0'),
('251', '251', 'Arshad &amp; Co Arms Nila Gumbad-Lahore', 'Arshad &amp; Co Arms Nila Gumbad-Lahore', 'Lahore  Nila Gumbad', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Nila Gumbad', '0', '', NULL, '0'),
('252', '252', 'Arshad Ali Arms 101 Ravi Road-Lahore', 'Arshad Ali Arms 101 Ravi Road-Lahore', 'Lahore  Ravi Road', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Ravi Road', '0', '', NULL, '0'),
('253', '253', 'Arshad Auto Taj Chamber Basement BB', 'Arshad Auto Taj Chamber Basement BB', 'Lahore  Badami Bagh', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badami Bagh', '0', '', NULL, '0'),
('254', '254', 'Asif Auto Green Market Badami Bagh', 'Asif Auto Green Market Badami Bagh', 'Lahore  Badami Bagh', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badami Bagh', '0', '', NULL, '0'),
('255', '255', 'Asif Auto Model Town-Lahore', 'Asif Auto Model Town-Lahore', 'Lahore  Model Town', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Model Town', '0', '', NULL, '0'),
('256', '256', 'Asif Filter Badami Bagh-Lahore', 'Asif Filter Badami Bagh-Lahore', 'Lahore  Badami Bagh', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badami Bagh', '0', '', NULL, '0'),
('257', '257', 'Auto Centre Shad Bagh Near Allied Bank', 'Auto Centre Shad Bagh Near Allied Bank', 'Lahore  Shad Bagh', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Shad Bagh', '0', '', NULL, '0'),
('258', '258', 'Ayub Arm Misri Shah Ganda Nala-Lahore', 'Ayub Arm Misri Shah Ganda Nala-Lahore', 'Lahore  Misri Shah', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Misri Shah', '0', '', NULL, '0'),
('259', '259', 'Bakhshi Auto Peco Road Kot Lakh Pat', 'Bakhshi Auto Peco Road Kot Lakh Pat', 'Lahore  Peco Road', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Peco Road', '0', '', NULL, '0'),
('260', '260', 'Bakhar Aslah House,Sargodha-Lahore', 'Bakhar Aslah House,Sargodha-Lahore', 'Lahore  Sargodha', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Sargodha', '0', '', NULL, '0'),
('261', '261', 'Bilal Autos Badami Bagh-Lahore', 'Bilal Autos Badami Bagh-Lahore', 'Lahore  Badami Bagh', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badami Bagh', '0', '', NULL, '0'),
('262', '262', 'Bismillah Autos Township-Lahore', 'Bismillah Autos Township-Lahore', 'Lahore  Township', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Township', '0', '', NULL, '0'),
('263', '263', 'Bismillah Oil Township-Lahore', 'Bismillah Oil Township-Lahore', 'Lahore  Township', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Township', '0', '', NULL, '0'),
('264', '264', 'Bukhari Traders Peco Road-Lahore', 'Bukhari Traders Peco Road-Lahore', 'Lahore  Peco Road', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Peco Road', '0', '', NULL, '0'),
('265', '265', 'Buraq Motors Peco Road Kot Lakpat-Lahore', 'Buraq Motors Peco Road Kot Lakpat-Lahore', 'Lahore  Peco Road', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Peco Road', '0', '', NULL, '0'),
('266', '266', 'Butt Auto Shad Bagh Near Allied Bank', 'Butt Auto Shad Bagh Near Allied Bank', 'Lahore  Shad Bagh', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Shad Bagh', '0', '', NULL, '0'),
('267', '267', 'Car Care Township Peco Road-Lahore', 'Car Care Township Peco Road-Lahore', 'Lahore  Peco Road', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Peco Road', '0', '', NULL, '0'),
('268', '268', 'Chand Terminal Supplier Badami Bagh', 'Chand Terminal Supplier Badami Bagh', 'Lahore  Badami Bagh', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badami Bagh', '0', '', NULL, '0'),
('269', '269', 'Chaudhry Arms Nila Gumbad Lahore', 'Chaudhry Arms Nila Gumbad Lahore', 'Lahore  Nila Gumbad', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Nila Gumbad', '0', '', NULL, '0'),
('270', '270', 'Dar Autos Badami Bagh-Lahore', 'Dar Autos Badami Bagh-Lahore', 'Lahore  Badami Bagh', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badami Bagh', '0', '', NULL, '0'),
('271', '271', 'Ebba Motors Autos Centre Badami Bagh Lhr', 'Ebba Motors Autos Centre Badami Bagh Lhr', 'Lahore  Badami Bagh', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badami Bagh', '0', '', NULL, '0'),
('272', '272', 'Ehsan Autos Qadri Chowk Town Ship-Lahore', 'Ehsan Autos Qadri Chowk Town Ship-Lahore', 'Lahore  Township', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Township', '0', '', NULL, '0'),
('273', '273', 'Faisal Supplier Township-Lahore', 'Faisal Supplier Township-Lahore', 'Lahore  Township', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Township', '0', '', NULL, '0'),
('274', '274', 'FOCOUS ARMS NILS GUMBAND MALL VIEW LHR', 'FOCOUS ARMS NILS GUMBAND MALL VIEW LHR', 'Lahore  Nila Gumbad', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Nila Gumbad', '0', '', NULL, '0'),
('275', '275', 'Friends Arms', 'Friends Arms', 'Lahore  Badami Bagh', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badami Bagh', '0', '', NULL, '0'),
('276', '276', 'G.M Autos A-Block Model Town-Lahore', 'G.M Autos A-Block Model Town-Lahore', 'Lahore  Model Town', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Model Town', '0', '', NULL, '0'),
('277', '277', 'Green Autos Badami Bagh-Lahore', 'Green Autos Badami Bagh-Lahore', 'Lahore  Badami Bagh', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badami Bagh', '0', '', NULL, '0'),
('278', '278', 'H Hamid&amp;co Pvt (ltd) Mall View LHR', 'H Hamid&amp;co Pvt (ltd) Mall View LHR', 'Lahore  Nila Gumbad', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Nila Gumbad', '0', '', NULL, '0'),
('279', '279', 'Hafiz Traders Badami Bagh Lahore', 'Hafiz Traders Badami Bagh Lahore', 'Lahore  Badami Bagh', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badami Bagh', '0', '', NULL, '0'),
('280', '280', 'Haider Arms Mall View Nila Gumbad', 'Haider Arms Mall View Nila Gumbad', 'Lahore  Nila Gumbad', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Nila Gumbad', '0', '', NULL, '0'),
('281', '281', 'Haji Auto Chowk Na Khuda-Lahore', 'Haji Auto Chowk Na Khuda-Lahore', 'Lahore  Chowk Nakhuda', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Chowk Nakhuda', '0', '', NULL, '0'),
('282', '282', 'Haji Jannat Arms 63 Ravi Road-Lahore', 'Haji Jannat Arms 63 Ravi Road-Lahore', 'Lahore  Ravi Road', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Ravi Road', '0', '', NULL, '0'),
('283', '283', 'Haji Zar Wali Arms Bhatti Chowk LHR', 'Haji Zar Wali Arms Bhatti Chowk LHR', 'Lahore  Bhatti Chowk', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Bhatti Chowk', '0', '', NULL, '0'),
('284', '284', 'Hajveri Auot Khokhar Road-Lahore', 'Hajveri Auot Khokhar Road-Lahore', 'Lahore  Khokhar Road', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Khokhar Road', '0', '', NULL, '0'),
('285', '285', 'Hamza Autos Model Town-Lahore', 'Hamza Autos Model Town-Lahore', 'Lahore  Model Town', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Model Town', '0', '', NULL, '0'),
('286', '286', 'Hamza Eagle Eye Phase II Badami Bagh', 'Hamza Eagle Eye Phase II Badami Bagh', 'Lahore  Badami Bagh', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badami Bagh', '0', '', NULL, '0'),
('287', '287', 'HANAN TAYYAB AUTO BADAMI BAGH LHR', 'HANAN TAYYAB AUTO BADAMI BAGH LHR', 'Lahore  Badami Bagh', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badami Bagh', '0', '', NULL, '0'),
('288', '288', 'Haq Auto Model Town-Lahore', 'Haq Auto Model Town-Lahore', 'Lahore  Model Town', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Model Town', '0', '', NULL, '0'),
('289', '289', 'Hassan Ali Auto,Auto Centre Badami Bagh', 'Hassan Ali Auto,Auto Centre Badami Bagh', 'Lahore  Badami Bagh', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badami Bagh', '0', '', NULL, '0'),
('290', '290', 'Hassan Khan Arms Ravi Road-Lahore', 'Hassan Khan Arms Ravi Road-Lahore', 'Lahore  Ravi Road', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Ravi Road', '0', '', NULL, '0'),
('291', '291', 'Heera Autos Peco Road-Lahore', 'Heera Autos Peco Road-Lahore', 'Lahore  Peco Road', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Peco Road', '0', '', NULL, '0'),
('292', '292', 'Hira Arms Nila Gumbad-Lahore', 'Hira Arms Nila Gumbad-Lahore', 'Lahore  Nila Gumbad', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Nila Gumbad', '0', '', NULL, '0'),
('293', '293', 'Honda Canal Bank Motor Johar Town-Lahore', 'Honda Canal Bank Motor Johar Town-Lahore', 'Lahore  Johar Town', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Johar Town', '0', '', NULL, '0'),
('294', '294', 'Honda City Sale Ferozpur Road Lhr', 'Honda City Sale Ferozpur Road Lhr', 'Lahore  Ferozpur Road', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Ferozpur Road', '0', '', NULL, '0'),
('295', '295', 'Honda Fort Pvt Ltd Queen Road-Lahore', 'Honda Fort Pvt Ltd Queen Road-Lahore', 'Lahore  Queens Road', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Queens Road', '0', '', NULL, '0'),
('296', '296', 'Honda Point Pvt Ltd Airport Road-Lahore', 'Honda Point Pvt Ltd Airport Road-Lahore', 'Lahore  Airport Road', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Airport Road', '0', '', NULL, '0'),
('297', '297', 'Honda Town Ship Peco Road Lahore', 'Honda Town Ship Peco Road Lahore', 'Lahore  Peco Road', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Peco Road', '0', '', NULL, '0'),
('298', '298', 'Hundai Town Ship Motors Peco Road-Lahore', 'Hundai Town Ship Motors Peco Road-Lahore', 'Lahore  Peco Road', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Peco Road', '0', '', NULL, '0'),
('299', '299', 'Hyundai Motors Airport Road Lahore', 'Hyundai Motors Airport Road Lahore', 'Lahore  Airport Road', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Airport Road', '0', '', NULL, '0');
INSERT INTO `0_cust_branch` VALUES
('300', '300', 'I.F Suzuki Peco Road-Lahore', 'I.F Suzuki Peco Road-Lahore', 'Lahore  Peco Road', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Peco Road', '0', '', NULL, '0'),
('301', '301', 'Ikhlaq Auto Khalid Centre Township', 'Ikhlaq Auto Khalid Centre Township', 'Lahore  Township', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Township', '0', '', NULL, '0'),
('302', '302', 'Imran &amp; Co. Arms Nila Gumbad - Lahore', 'Imran &amp; Co. Arms Nila Gumbad - Lahore', 'Lahore  Nila Gumbad', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Nila Gumbad', '0', '', NULL, '0'),
('303', '303', 'Inaam Auto G 39-40 Auto Centre Badami B', 'Inaam Auto G 39-40 Auto Centre Badami B', 'Lahore  Badami Bagh', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badami Bagh', '0', '', NULL, '0'),
('304', '304', 'Iqbal Aslah House,Sargodha-Lahore', 'Iqbal Aslah House,Sargodha-Lahore', 'Lahore  Sargodha', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Sargodha', '0', '', NULL, '0'),
('305', '305', 'Iqbal Auto Naqi Road Nila Gumbad', 'Iqbal Auto Naqi Road Nila Gumbad', 'Lahore  Nila Gumbad', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Nila Gumbad', '0', '', NULL, '0'),
('306', '306', 'Ishfaq Auto, Auto Centre Basement B.Bagh', 'Ishfaq Auto, Auto Centre Basement B.Bagh', 'Lahore  Badami Bagh', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badami Bagh', '0', '', NULL, '0'),
('307', '307', 'Isuzu Ravi Motors Tokhar Niaz Baig Lhr', 'Isuzu Ravi Motors Tokhar Niaz Baig Lhr', 'Lahore  Lahore-Branch', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Lahore-Branch', '0', '', NULL, '0'),
('308', '308', 'Itefaq Autos Peco Road-Lahore', 'Itefaq Autos Peco Road-Lahore', 'Lahore  Peco Road', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Peco Road', '0', '', NULL, '0'),
('309', '309', 'Jabir Khan Arm Ravi Road-Lahore', 'Jabir Khan Arm Ravi Road-Lahore', 'Lahore  Ravi Road', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Ravi Road', '0', '', NULL, '0'),
('310', '310', 'Japan Autos Peco Road-Lahore', 'Japan Autos Peco Road-Lahore', 'Lahore  Peco Road', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Peco Road', '0', '', NULL, '0'),
('311', '311', 'Javed Sons Qasoor Centre Badami Bagh', 'Javed Sons Qasoor Centre Badami Bagh', 'Lahore  Badami Bagh', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badami Bagh', '0', '', NULL, '0'),
('312', '312', 'Junaid Autos Q.Block Model Town-Lahore', 'Junaid Autos Q.Block Model Town-Lahore', 'Lahore  Model Town', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Model Town', '0', '', NULL, '0'),
('313', '313', 'K G N Auto Supply Badami Bagh Lahore', 'K G N Auto Supply Badami Bagh Lahore', 'Lahore  Badami Bagh', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badami Bagh', '0', '', NULL, '0'),
('314', '314', 'Kamboo Auto Al Nasir Plaza Badami Bagh', 'Kamboo Auto Al Nasir Plaza Badami Bagh', 'Lahore  Badami Bagh', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badami Bagh', '0', '', NULL, '0'),
('315', '315', 'Kazim Battery Model Town Lahore', 'Kazim Battery Model Town Lahore', 'Lahore  Model Town', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Model Town', '0', '', NULL, '0'),
('316', '316', 'Khalid Motors Nabi Park-Lahore', 'Khalid Motors Nabi Park-Lahore', 'Lahore  Nabi Park', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Nabi Park', '0', '', NULL, '0'),
('317', '317', 'Khalid Motors Oil Ravi Road-Lahore', 'Khalid Motors Oil Ravi Road-Lahore', 'Lahore  Ravi Road', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Ravi Road', '0', '', NULL, '0'),
('318', '318', 'Khan Arm Misri Shah-Lahore', 'Khan Arm Misri Shah-Lahore', 'Lahore  Misri Shah', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Misri Shah', '0', '', NULL, '0'),
('319', '319', 'Khan Brother Aslah Dealer Ravi Road Lhr', 'Khan Brother Aslah Dealer Ravi Road Lhr', 'Lahore  Ravi Road', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Ravi Road', '0', '', NULL, '0'),
('320', '320', 'Khan Industries 23/191,Mori Gate-Sialkot', 'Khan Industries 23/191,Mori Gate-Sialkot', 'Lahore  Sialkot', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Sialkot', '0', '', NULL, '0'),
('321', '321', 'Khizar Motor 58-Ravi Road-Lahore', 'Khizar Motor 58-Ravi Road-Lahore', 'Lahore  Ravi Road', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Ravi Road', '0', '', NULL, '0'),
('322', '322', 'Khurram Ashraf House No 2 Badami Bagh', 'Khurram Ashraf House No 2 Badami Bagh', 'Lahore  Badami Bagh', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badami Bagh', '0', '', NULL, '0'),
('323', '323', 'Kia Motors Kings Gate Multan Road LHR', 'Kia Motors Kings Gate Multan Road LHR', 'Lahore  Multan Road', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Multan Road', '0', '', NULL, '0'),
('324', '324', 'Labaik Petroleum Badami Bagh Lahore', 'Labaik Petroleum Badami Bagh Lahore', 'Lahore  Badami Bagh', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badami Bagh', '0', '', NULL, '0'),
('325', '325', 'Lahore Auto Model Town-Lahore', 'Lahore Auto Model Town-Lahore', 'Lahore  Model Town', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Model Town', '0', '', NULL, '0'),
('326', '326', 'Lahore Light Centre 189 Green Market BB', 'Lahore Light Centre 189 Green Market BB', 'Lahore  Badami Bagh', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badami Bagh', '0', '', NULL, '0'),
('327', '327', 'Lal Din &amp; Sons Badami Bagh Lahore', 'Lal Din &amp; Sons Badami Bagh Lahore', 'Lahore  Badami Bagh', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badami Bagh', '0', '', NULL, '0'),
('328', '328', 'Latif Autos Badami Bagh-Lahore', 'Latif Autos Badami Bagh-Lahore', 'Lahore  Badami Bagh', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badami Bagh', '0', '', NULL, '0'),
('329', '329', 'LDS TRADER BADAMI BAGH LHR', 'LDS TRADER BADAMI BAGH LHR', 'Lahore  Badami Bagh', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badami Bagh', '0', '', NULL, '0'),
('330', '330', 'MG Motors Packages Mall Lahore', 'MG Motors Packages Mall Lahore', 'Lahore  Mall', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Mall', '0', '', NULL, '0'),
('331', '331', 'M Ali Brothers Badami Bagh', 'M Ali Brothers Badami Bagh', 'Lahore  Badami Bagh', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badami Bagh', '0', '', NULL, '0'),
('332', '332', 'M.A Autos Model Town-Lahore', 'M.A Autos Model Town-Lahore', 'Lahore  Model Town', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Model Town', '0', '', NULL, '0'),
('333', '333', 'M.Abbas &amp; Brothers Badami Bagh-Lahore', 'M.Abbas &amp; Brothers Badami Bagh-Lahore', 'Lahore  Badami Bagh', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badami Bagh', '0', '', NULL, '0'),
('334', '334', 'M.Anwar-ul-Haq &amp; Sons Nila Gumbad-Lahore', 'M.Anwar-ul-Haq &amp; Sons Nila Gumbad-Lahore', 'Lahore  Nila Gumbad', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Nila Gumbad', '0', '', NULL, '0'),
('335', '335', 'M.Iqbal Ishaq Arms Nila Gumbad-Lahore', 'M.Iqbal Ishaq Arms Nila Gumbad-Lahore', 'Lahore  Nila Gumbad', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Nila Gumbad', '0', '', NULL, '0'),
('336', '336', 'M.T.C Auto,Auto Centre Badami Bagh', 'M.T.C Auto,Auto Centre Badami Bagh', 'Lahore  Badami Bagh', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badami Bagh', '0', '', NULL, '0'),
('337', '337', 'Madina Auto Peco Road-Lahore', 'Madina Auto Peco Road-Lahore', 'Lahore  Peco Road', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Peco Road', '0', '', NULL, '0'),
('338', '338', 'Madina Motor Auto Center Badami Bagh-LHR', 'Madina Motor Auto Center Badami Bagh-LHR', 'Lahore  Badami Bagh', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badami Bagh', '0', '', NULL, '0'),
('339', '339', 'Madina Oil Traders Badami Bagh-Lahore', 'Madina Oil Traders Badami Bagh-Lahore', 'Lahore  Badami Bagh', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badami Bagh', '0', '', NULL, '0'),
('340', '340', 'Madni Auto Khokhar Road Near City Kanta', 'Madni Auto Khokhar Road Near City Kanta', 'Lahore  Khokhar Road', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Khokhar Road', '0', '', NULL, '0'),
('341', '341', 'Makkhan Air Gun Block No 5 Lahore', 'Makkhan Air Gun Block No 5 Lahore', 'Lahore  Badami Bagh', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badami Bagh', '0', '', NULL, '0'),
('342', '342', 'Makki Oil Traders Peco Road-Lahore', 'Makki Oil Traders Peco Road-Lahore', 'Lahore  Peco Road', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Peco Road', '0', '', NULL, '0'),
('343', '343', 'Malik Arm Misri Shah-Lahore', 'Malik Arm Misri Shah-Lahore', 'Lahore  Misri Shah', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Misri Shah', '0', '', NULL, '0'),
('344', '344', 'Malik Auto Khokhar Road-Lahore', 'Malik Auto Khokhar Road-Lahore', 'Lahore  Khokhar Road', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Khokhar Road', '0', '', NULL, '0'),
('345', '345', 'Malik G Auto 516 Main Peco Road', 'Malik G Auto 516 Main Peco Road', 'Lahore  Peco Road', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Peco Road', '0', '', NULL, '0'),
('346', '346', 'Malik Ji Oil Peco Road-Lahore', 'Malik Ji Oil Peco Road-Lahore', 'Lahore  Peco Road', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Peco Road', '0', '', NULL, '0'),
('347', '347', 'Malik Traders Arms Nila Gumbad-Lahore', 'Malik Traders Arms Nila Gumbad-Lahore', 'Lahore  Nila Gumbad', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Nila Gumbad', '0', '', NULL, '0'),
('348', '348', 'Mansoor Mehboob Autos Model Town Lhr', 'Mansoor Mehboob Autos Model Town Lhr', 'Lahore  Model Town', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Model Town', '0', '', NULL, '0'),
('349', '349', 'Manzoor Autos Model Town-Lahore', 'Manzoor Autos Model Town-Lahore', 'Lahore  Model Town', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Model Town', '0', '', NULL, '0'),
('350', '350', 'Mian Akram Auto Qadri Chowk Township', 'Mian Akram Auto Qadri Chowk Township', 'Lahore  Township', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Township', '0', '', NULL, '0'),
('351', '351', 'Mian Autos Model Town-Lahore', 'Mian Autos Model Town-Lahore', 'Lahore  Model Town', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Model Town', '0', '', NULL, '0'),
('352', '352', 'Modern Poshash Badami Bagh-Lahore', 'Modern Poshash Badami Bagh-Lahore', 'Lahore  Badami Bagh', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badami Bagh', '0', '', NULL, '0'),
('353', '353', 'Mohsin Auto Green Market Badami Bagh', 'Mohsin Auto Green Market Badami Bagh', 'Lahore  Badami Bagh', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badami Bagh', '0', '', NULL, '0'),
('354', '354', 'Mokal International Arms Nila Gumbad-LHR', 'Mokal International Arms Nila Gumbad-LHR', 'Lahore  Nila Gumbad', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Nila Gumbad', '0', '', NULL, '0'),
('355', '355', 'Montgomery Autos Township-Lahore', 'Montgomery Autos Township-Lahore', 'Lahore  Township', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Township', '0', '', NULL, '0'),
('356', '356', 'Muaz Autos Badami Bagh-Lahore', 'Muaz Autos Badami Bagh-Lahore', 'Lahore  Badami Bagh', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badami Bagh', '0', '', NULL, '0'),
('357', '357', 'Muraad Engineering Co. Johar Town-Lahore', 'Muraad Engineering Co. Johar Town-Lahore', 'Lahore  Johar Town', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Johar Town', '0', '', NULL, '0'),
('358', '358', 'Mueed Saleem MIB Data Centre Kot Lakh Pa', 'Mueed Saleem MIB Data Centre Kot Lakh Pa', 'Lahore  Kot Lakh Pat', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Kot Lakh Pat', '0', '', NULL, '0'),
('359', '359', 'Mughal Auto G.T Road Mian Channu', 'Mughal Auto G.T Road Mian Channu', 'Lahore  Mian Channu', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Mian Channu', '0', '', NULL, '0'),
('360', '360', 'Nadeem Auto Badami Bagh', 'Nadeem Auto Badami Bagh', 'Lahore  Badami Bagh', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badami Bagh', '0', '', NULL, '0'),
('361', '361', 'Naeem Auto Misri Shah-Lahore', 'Naeem Auto Misri Shah-Lahore', 'Lahore  Misri Shah', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Misri Shah', '0', '', NULL, '0'),
('362', '362', 'Naeem Sons Badami Bagh-Lahore', 'Naeem Sons Badami Bagh-Lahore', 'Lahore  Badami Bagh', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badami Bagh', '0', '', NULL, '0'),
('363', '363', 'Naveed Khan &amp; Co Ravi Road Lahore', 'Naveed Khan &amp; Co Ravi Road Lahore', 'Lahore  Ravi Road', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Ravi Road', '0', '', NULL, '0'),
('364', '364', 'Nazir Arms Ravi Road Lahore', 'Nazir Arms Ravi Road Lahore', 'Lahore  Ravi Road', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Ravi Road', '0', '', NULL, '0'),
('365', '365', 'New Alfalah Autos Ravi Road-Lahore', 'New Alfalah Autos Ravi Road-Lahore', 'Lahore  Ravi Road', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Ravi Road', '0', '', NULL, '0'),
('366', '366', 'New Auto World Qadri Chowk Township', 'New Auto World Qadri Chowk Township', 'Lahore  Township', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Township', '0', '', NULL, '0'),
('367', '367', 'New Faiz Lasani Autos Badami Bagh-Lahore', 'New Faiz Lasani Autos Badami Bagh-Lahore', 'Lahore  Badami Bagh', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badami Bagh', '0', '', NULL, '0'),
('368', '368', 'New Khan Road Runners LTD-Lahore', 'New Khan Road Runners LTD-Lahore', 'Lahore  Badami Bagh', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badami Bagh', '0', '', NULL, '0'),
('369', '369', 'New Punjab Auto Model Town-Lahore', 'New Punjab Auto Model Town-Lahore', 'Lahore  Model Town', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Model Town', '0', '', NULL, '0'),
('370', '370', 'Nisar Khan Supplier Badami Bagh Lahore', 'Nisar Khan Supplier Badami Bagh Lahore', 'Lahore  Badami Bagh', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badami Bagh', '0', '', NULL, '0'),
('371', '371', 'Noman Auto Badami Bagh Lahore', 'Noman Auto Badami Bagh Lahore', 'Lahore  Badami Bagh', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badami Bagh', '0', '', NULL, '0'),
('372', '372', 'Noman Autos Badami Bagh-Lahore', 'Noman Autos Badami Bagh-Lahore', 'Lahore  Badami Bagh', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badami Bagh', '0', '', NULL, '0'),
('373', '373', 'Orient Trader Mall View Nila Gumbad', 'Orient Trader Mall View Nila Gumbad', 'Lahore  Nila Gumbad', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Nila Gumbad', '0', '', NULL, '0'),
('374', '374', 'Pak Auto Agency Badami Bagh', 'Pak Auto Agency Badami Bagh', 'Lahore  Badami Bagh', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badami Bagh', '0', '', NULL, '0'),
('375', '375', 'Pakistan Auto Oil Ravi Road', 'Pakistan Auto Oil Ravi Road', 'Lahore  Ravi Road', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Ravi Road', '0', '', NULL, '0'),
('376', '376', 'Prime Motors Badami Bagh Lahore', 'Prime Motors Badami Bagh Lahore', 'Lahore  Badami Bagh', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badami Bagh', '0', '', NULL, '0'),
('377', '377', 'Punjab Filter House Fasilabad', 'Punjab Filter House Fasilabad', 'Lahore  Faislabad', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Faislabad', '0', '', NULL, '0'),
('378', '378', 'Qadria Motor Naqi Road Nila Gumbad', 'Qadria Motor Naqi Road Nila Gumbad', 'Lahore  Nila Gumbad', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Nila Gumbad', '0', '', NULL, '0'),
('379', '379', 'Ramzan Auto Ramzan Chamber Badami Bagh', 'Ramzan Auto Ramzan Chamber Badami Bagh', 'Lahore  Badami Bagh', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badami Bagh', '0', '', NULL, '0'),
('380', '380', 'Rashad Auto A Block Model Town', 'Rashad Auto A Block Model Town', 'Lahore  Model Town', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Model Town', '0', '', NULL, '0'),
('381', '381', 'Rashid Arm Mall View Nila Gumbad', 'Rashid Arm Mall View Nila Gumbad', 'Lahore  Nila Gumbad', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Nila Gumbad', '0', '', NULL, '0'),
('382', '382', 'Ratta Auto Main Peco Road Town Ship', 'Ratta Auto Main Peco Road Town Ship', 'Lahore  Township', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Township', '0', '', NULL, '0'),
('383', '383', 'Ravi Auto 227-N Block Model Town Ext', 'Ravi Auto 227-N Block Model Town Ext', 'Lahore  Model Town', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Model Town', '0', '', NULL, '0'),
('384', '384', 'Rehman Auto Centre Badami Bagh Lhr', 'Rehman Auto Centre Badami Bagh Lhr', 'Lahore  Badami Bagh', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badami Bagh', '0', '', NULL, '0'),
('385', '385', 'Rehman Autos Qadri Chowk-Lahore', 'Rehman Autos Qadri Chowk-Lahore', 'Lahore  Township', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Township', '0', '', NULL, '0'),
('386', '386', 'Rizwan Oil Store Green Market BB', 'Rizwan Oil Store Green Market BB', 'Lahore  Badami Bagh', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badami Bagh', '0', '', NULL, '0'),
('387', '387', 'Sabri Trading Co. Railway Road-Lahore', 'Sabri Trading Co. Railway Road-Lahore', 'Lahore  Railway Road', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Railway Road', '0', '', NULL, '0'),
('388', '388', 'Saad Traders Sargodha Road Mianwali', 'Saad Traders Sargodha Road Mianwali', 'Lahore  Mianwali', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Mianwali', '0', '', NULL, '0'),
('389', '389', 'Saeed Air Guns Arms Mall View', 'Saeed Air Guns Arms Mall View', 'Lahore  Nila Gumbad', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Nila Gumbad', '0', '', NULL, '0'),
('390', '390', 'Salman Autos Peco Road-Lahore', 'Salman Autos Peco Road-Lahore', 'Lahore  Peco Road', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Peco Road', '0', '', NULL, '0'),
('391', '391', 'Saqib Auto Badami Bagh-Lahore', 'Saqib Auto Badami Bagh-Lahore', 'Lahore  Badami Bagh', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badami Bagh', '0', '', NULL, '0'),
('392', '392', 'Shabir Oil Store Township-Lahore', 'Shabir Oil Store Township-Lahore', 'Lahore  Township', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Township', '0', '', NULL, '0'),
('393', '393', 'Shah Mehmood Shad Bagh Near Meezan Bank', 'Shah Mehmood Shad Bagh Near Meezan Bank', 'Lahore  Shad Bagh', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Shad Bagh', '0', '', NULL, '0'),
('394', '394', 'Shah Wali &amp; Son Arms New Anarkali-Lahore', 'Shah Wali &amp; Son Arms New Anarkali-Lahore', 'Lahore  Anarkali', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Anarkali', '0', '', NULL, '0'),
('395', '395', 'Shahbaz Autos Badami Bagh-Lahore', 'Shahbaz Autos Badami Bagh-Lahore', 'Lahore  Badami Bagh', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badami Bagh', '0', '', NULL, '0'),
('396', '396', 'Shahid Sons Autos Badami Bagh-Lahore', 'Shahid Sons Autos Badami Bagh-Lahore', 'Lahore  Badami Bagh', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badami Bagh', '0', '', NULL, '0'),
('397', '397', 'Shaheen Auto Store Narowal-Lahore', 'Shaheen Auto Store Narowal-Lahore', 'Lahore  Narowal', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Narowal', '0', '', NULL, '0'),
('398', '398', 'Shakil Autos Badami Bagh-Lahore', 'Shakil Autos Badami Bagh-Lahore', 'Lahore  Badami Bagh', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badami Bagh', '0', '', NULL, '0'),
('399', '399', 'Shalimar Arms Co Mall Road Lahore', 'Shalimar Arms Co Mall Road Lahore', 'Lahore  Mall Road', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Mall Road', '0', '', NULL, '0'),
('400', '400', 'Shamim Auto Naqi Road Nila Gumbad', 'Shamim Auto Naqi Road Nila Gumbad', 'Lahore  Nila Gumbad', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Nila Gumbad', '0', '', NULL, '0'),
('401', '401', 'Shan Auto Ghory Shah Road-Lahore', 'Shan Auto Ghory Shah Road-Lahore', 'Lahore  Ghory Shah', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Ghory Shah', '0', '', NULL, '0'),
('402', '402', 'Sheikh Auto New LMC Market Badami Bagh', 'Sheikh Auto New LMC Market Badami Bagh', 'Lahore  Badami Bagh', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badami Bagh', '0', '', NULL, '0'),
('403', '403', 'Sheikh Autos Qadri Chowk Township-Lahore', 'Sheikh Autos Qadri Chowk Township-Lahore', 'Lahore  Township', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Township', '0', '', NULL, '0'),
('404', '404', 'Sheikh Ehsan Auto Qadri Chowk Township', 'Sheikh Ehsan Auto Qadri Chowk Township', 'Lahore  Township', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Township', '0', '', NULL, '0'),
('405', '405', 'Sheraz Oil Traders New LMC Market BB', 'Sheraz Oil Traders New LMC Market BB', 'Lahore  Badami Bagh', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badami Bagh', '0', '', NULL, '0'),
('406', '406', 'Shoaib Autos Badami Bagh-Lahore', 'Shoaib Autos Badami Bagh-Lahore', 'Lahore  Badami Bagh', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badami Bagh', '0', '', NULL, '0'),
('407', '407', 'Sigma Motors DHA Phase 8-Lahore', 'Sigma Motors DHA Phase 8-Lahore', 'Lahore  Dha Phase 8', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Dha Phase 8', '0', '', NULL, '0'),
('408', '408', 'Smart Honda Badian Road Lahore', 'Smart Honda Badian Road Lahore', 'Lahore  Badian Road', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badian Road', '0', '', NULL, '0'),
('409', '409', 'Sufi Autos Nila Gumbad-Lahore', 'Sufi Autos Nila Gumbad-Lahore', 'Lahore  Nila Gumbad', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Nila Gumbad', '0', '', NULL, '0'),
('410', '410', 'Sunny Autos Peco Road Lahore', 'Sunny Autos Peco Road Lahore', 'Lahore  Peco Road', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Peco Road', '0', '', NULL, '0'),
('411', '411', 'Suntec Autos Peco Road-Lahore', 'Suntec Autos Peco Road-Lahore', 'Lahore  Peco Road', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Peco Road', '0', '', NULL, '0'),
('412', '412', 'Suzuki Canal Motors 13 Km Multan Road', 'Suzuki Canal Motors 13 Km Multan Road', 'Lahore  Multan Road', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Multan Road', '0', '', NULL, '0'),
('413', '413', 'SUZUKI PUNJAB MOTORS 17 KM MULTAN RD LHR', 'SUZUKI PUNJAB MOTORS 17 KM MULTAN RD LHR', 'Lahore  Multan Road', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Multan Road', '0', '', NULL, '0'),
('414', '414', 'Suzuki Raiwind Motors Raiwind Road LHR', 'Suzuki Raiwind Motors Raiwind Road LHR', 'Lahore  Raiwind Road', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Raiwind Road', '0', '', NULL, '0'),
('415', '415', 'Suzuki Summit Motor 16 Km S.Pura Road', 'Suzuki Summit Motor 16 Km S.Pura Road', 'Lahore  Sheikhupura Road', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Sheikhupura Road', '0', '', NULL, '0'),
('418', '431', 'Suzuki Town Ship Motors Peco Road-Lahore', 'Suzuki Town Ship Motors Peco Road-Lahore', 'Lahore  Peco Road', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Peco Road', '0', '', NULL, '0'),
('419', '432', 'Tariq Motors Badami Bagh-Lahore', 'Tariq Motors Badami Bagh-Lahore', 'Lahore  Badami Bagh', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badami Bagh', '0', '', NULL, '0'),
('420', '433', 'Tayyab Autos Badami Bagh-Lahore', 'Tayyab Autos Badami Bagh-Lahore', 'Lahore  Badami Bagh', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badami Bagh', '0', '', NULL, '0'),
('421', '434', 'TM KHAN ARMS RAVI ROAD LAHORE', 'TM KHAN ARMS RAVI ROAD LAHORE', 'Lahore  Ravi Road', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Ravi Road', '0', '', NULL, '0'),
('422', '435', 'Touqeer Auto,Auto Centre Badami Bagh', 'Touqeer Auto,Auto Centre Badami Bagh', 'Lahore  Badami Bagh', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badami Bagh', '0', '', NULL, '0'),
('423', '436', 'Town Autos Peco Road-Lahore', 'Town Autos Peco Road-Lahore', 'Lahore  Peco Road', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Peco Road', '0', '', NULL, '0'),
('424', '437', 'Toyota Garden Motors FerozPur Rd Lhr', 'Toyota Garden Motors FerozPur Rd Lhr', 'Lahore  Ferozpur Road', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Ferozpur Road', '0', '', NULL, '0'),
('425', '438', 'Toyota Jinnah Motors FerozPur Rd Lhr', 'Toyota Jinnah Motors FerozPur Rd Lhr', 'Lahore  Ferozpur Road', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Ferozpur Road', '0', '', NULL, '0'),
('426', '439', 'Toyota Motors Airport Road-Lahore', 'Toyota Motors Airport Road-Lahore', 'Lahore  Airport Road', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Airport Road', '0', '', NULL, '0'),
('427', '440', 'Toyota Ravi Motors Thokar Niaz Baig-LHR', 'Toyota Ravi Motors Thokar Niaz Baig-LHR', 'Lahore  Thokar Niaz Baig', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Thokar Niaz Baig', '0', '', NULL, '0'),
('428', '441', 'Toyota Sahara Motors Jail Road-Lahore', 'Toyota Sahara Motors Jail Road-Lahore', 'Lahore  Jail Road', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Jail Road', '0', '', NULL, '0'),
('429', '442', 'Toyota Town Ship Motors Peco Road-Lahore', 'Toyota Town Ship Motors Peco Road-Lahore', 'Lahore  Peco Road', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Peco Road', '0', '', NULL, '0'),
('430', '443', 'Toyota Walton Motor Walton Road-Lahore', 'Toyota Walton Motor Walton Road-Lahore', 'Lahore  Walton Road', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Walton Road', '0', '', NULL, '0'),
('431', '444', 'UK Motors Ramzan Chamber Badami Bagh', 'UK Motors Ramzan Chamber Badami Bagh', 'Lahore  Badami Bagh', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badami Bagh', '0', '', NULL, '0'),
('432', '445', 'Umer Brothers Ik Auto Badami Bagh', 'Umer Brothers Ik Auto Badami Bagh', 'Lahore  Badami Bagh', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badami Bagh', '0', '', NULL, '0'),
('433', '446', 'Unique Oil Change Peco Road-Lahore', 'Unique Oil Change Peco Road-Lahore', 'Lahore  Peco Road', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Peco Road', '0', '', NULL, '0'),
('434', '447', 'Usman Ali Auto Badami Bagh LHR', 'Usman Ali Auto Badami Bagh LHR', 'Lahore  Badami Bagh', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badami Bagh', '0', '', NULL, '0'),
('435', '448', 'Usman Autos Model Town-Lahore', 'Usman Autos Model Town-Lahore', 'Lahore  Model Town', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Model Town', '0', '', NULL, '0'),
('436', '449', 'Vital Oil Store Peco Road-Lahore', 'Vital Oil Store Peco Road-Lahore', 'Lahore  Peco Road', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Peco Road', '0', '', NULL, '0'),
('437', '450', 'Wahab Autos Model Town-Lahore', 'Wahab Autos Model Town-Lahore', 'Lahore  Model Town', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Model Town', '0', '', NULL, '0'),
('438', '451', 'Waheed Autos Badami Bagh-Lahore', 'Waheed Autos Badami Bagh-Lahore', 'Lahore  Badami Bagh', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badami Bagh', '0', '', NULL, '0'),
('439', '452', 'Waheed Supplier Badami Bagh-Lahore', 'Waheed Supplier Badami Bagh-Lahore', 'Lahore  Badami Bagh', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badami Bagh', '0', '', NULL, '0'),
('440', '453', 'Waqar Autos Badami Bagh-Lahore', 'Waqar Autos Badami Bagh-Lahore', 'Lahore  Badami Bagh', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badami Bagh', '0', '', NULL, '0'),
('441', '454', 'Yaseen Autos Badami Bagh-Lahore', 'Yaseen Autos Badami Bagh-Lahore', 'Lahore  Badami Bagh', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badami Bagh', '0', '', NULL, '0'),
('442', '455', 'Younis Arms Nila Gumbad-Lahore', 'Younis Arms Nila Gumbad-Lahore', 'Lahore  Nila Gumbad', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Nila Gumbad', '0', '', NULL, '0'),
('443', '456', 'Zahid Autos Badami Bagh-Lahore', 'Zahid Autos Badami Bagh-Lahore', 'Lahore  Badami Bagh', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badami Bagh', '0', '', NULL, '0'),
('444', '457', 'Zahid Mehmood Auto Badami Bagh Lahore', 'Zahid Mehmood Auto Badami Bagh Lahore', 'Lahore  Badami Bagh', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badami Bagh', '0', '', NULL, '0'),
('445', '458', 'Zaiyad Autos Badami Bagh Lahore', 'Zaiyad Autos Badami Bagh Lahore', 'Lahore  Badami Bagh', '3', '4', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badami Bagh', '0', '', NULL, '0'),
('446', '459', 'Joher Town - Lhr', 'Joher Town - Lhr', 'Lahore  Johar Town', '3', '5', 'FGLHR', '1', '', '4510', '1200', '1200', '1', 'Lahore  Johar Town', '0', '', NULL, '0'),
('447', '460', '786 Auto Motors Montgomery  Road Lahore', '786 Auto Motors Montgomery  Road Lahore', 'Lahore  Montgomery Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Montgomery Road', '0', '', NULL, '0'),
('448', '461', '786 Auto Parts Multan Road Lahore', '786 Auto Parts Multan Road Lahore', 'Lahore  Multan Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Multan Road', '0', '', NULL, '0'),
('449', '462', '786 Montgomery Road Lahore', '786 Montgomery Road Lahore', 'Lahore  Montgomery Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Montgomery Road', '0', '', NULL, '0'),
('450', '463', 'A&amp;N motors w/shop joher town', 'A&amp;N motors w/shop joher town', 'Lahore  Johar Town', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Johar Town', '0', '', NULL, '0'),
('451', '464', 'A.A Auto Main Gulshan E Ravi-Lahore', 'A.A Auto Main Gulshan E Ravi-Lahore', 'Lahore  Gulshan E Ravi', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gulshan E Ravi', '0', '', NULL, '0'),
('452', '465', 'A.R Traders GT Road Okara-Lahore', 'A.R Traders GT Road Okara-Lahore', 'Lahore  Okara', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Okara', '0', '', NULL, '0'),
('453', '466', 'A.S Classic Motors Johar Town-Lahore', 'A.S Classic Motors Johar Town-Lahore', 'Lahore  Johar Town', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Johar Town', '0', '', NULL, '0'),
('454', '467', 'AA Cool Centre 65-Kacha Ferozpur LOS', 'AA Cool Centre 65-Kacha Ferozpur LOS', 'Lahore  Ferozpur Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Ferozpur Road', '0', '', NULL, '0'),
('455', '468', 'Aamir Auto Main Walto Road Cantt', 'Aamir Auto Main Walto Road Cantt', 'Lahore  Walton Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Walton Road', '0', '', NULL, '0'),
('456', '469', 'Aamir Auto Near Pepsi Factory Gulberg 3', 'Aamir Auto Near Pepsi Factory Gulberg 3', 'Lahore  Gulberg', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gulberg', '0', '', NULL, '0'),
('457', '470', 'Abbas Auto Near Canal View Gate-Lahore', 'Abbas Auto Near Canal View Gate-Lahore', 'Lahore  Canal View', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Canal View', '0', '', NULL, '0'),
('458', '471', 'Abdul Rehman Autos Hafizabad-Lahore', 'Abdul Rehman Autos Hafizabad-Lahore', 'Lahore  Hafizabad', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Hafizabad', '0', '', NULL, '0'),
('459', '472', 'Abdul Wahab Auto Sadar Cantt', 'Abdul Wahab Auto Sadar Cantt', 'Lahore  Sadar', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Sadar', '0', '', NULL, '0'),
('460', '473', 'Abdullah Auto Baba Market 10 Montgomery', 'Abdullah Auto Baba Market 10 Montgomery', 'Lahore  Montgomery Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Montgomery Road', '0', '', NULL, '0'),
('461', '474', 'Abdullah Auto Montgomery Road Lahore', 'Abdullah Auto Montgomery Road Lahore', 'Lahore  Montgomery Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Montgomery Road', '0', '', NULL, '0'),
('462', '475', 'Abdullah Autos Johar Town-Lahore', 'Abdullah Autos Johar Town-Lahore', 'Lahore  Johar Town', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Johar Town', '0', '', NULL, '0'),
('463', '476', 'Abdullah Autos Qasoor-Lahore', 'Abdullah Autos Qasoor-Lahore', 'Lahore  Qasoor', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Qasoor', '0', '', NULL, '0'),
('464', '477', 'Abrar Radiator Canal View Multan Road', 'Abrar Radiator Canal View Multan Road', 'Lahore  Canal View', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Canal View', '0', '', NULL, '0'),
('465', '478', 'ABW Auto Revenue Society Johar Town', 'ABW Auto Revenue Society Johar Town', 'Lahore  Johar Town', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Johar Town', '0', '', NULL, '0'),
('466', '479', 'Acha Oil Change Mian Sabzazar PSO Pump', 'Acha Oil Change Mian Sabzazar PSO Pump', 'Lahore  Sabzazar', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Sabzazar', '0', '', NULL, '0'),
('467', '480', 'Adil Zafar Motors Main Multan Road LHR', 'Adil Zafar Motors Main Multan Road LHR', 'Lahore  Multan Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Multan Road', '0', '', NULL, '0'),
('468', '481', 'Aftab Arms Multan Road Chauburji-Lahore', 'Aftab Arms Multan Road Chauburji-Lahore', 'Lahore  Chauburji', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Chauburji', '0', '', NULL, '0'),
('469', '482', 'Ahmad Auto 422 Park Iqbal Town', 'Ahmad Auto 422 Park Iqbal Town', 'Lahore  Iqbal Town', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Iqbal Town', '0', '', NULL, '0'),
('470', '483', 'Ahmad Autos Gujranwala Hafizabad Lhr', 'Ahmad Autos Gujranwala Hafizabad Lhr', 'Lahore  Hafizabad', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Hafizabad', '0', '', NULL, '0'),
('471', '484', 'Ahmed Auto Engineering 22/A A.Karim Road', 'Ahmed Auto Engineering 22/A A.Karim Road', 'Lahore  Karim Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Karim Road', '0', '', NULL, '0'),
('472', '485', 'Ahmed Autos Khokha Stop Band Rd-Lahore', 'Ahmed Autos Khokha Stop Band Rd-Lahore', 'Lahore  Band Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Band Road', '0', '', NULL, '0'),
('473', '486', 'Ahmed Autos Samnabad-Lahore', 'Ahmed Autos Samnabad-Lahore', 'Lahore  Samnabad', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Samnabad', '0', '', NULL, '0'),
('474', '487', 'Ahmed Oil Point Iqbal Town-Lahore', 'Ahmed Oil Point Iqbal Town-Lahore', 'Lahore  Iqbal Town', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Iqbal Town', '0', '', NULL, '0'),
('475', '488', 'Ahmed Oil Store 5 B/b OR Society Johar T', 'Ahmed Oil Store 5 B/b OR Society Johar T', 'Lahore  Johar Town', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Johar Town', '0', '', NULL, '0'),
('476', '489', 'Akeel Auto Queens Road Lhr', 'Akeel Auto Queens Road Lhr', 'Lahore  Queens Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Queens Road', '0', '', NULL, '0'),
('477', '490', 'Akhtar Saeed Arms Multan Road Lahore', 'Akhtar Saeed Arms Multan Road Lahore', 'Lahore  Multan Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Multan Road', '0', '', NULL, '0'),
('478', '491', 'Akram Autos GT Road Okara-Lahore', 'Akram Autos GT Road Okara-Lahore', 'Lahore  Okara', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Okara', '0', '', NULL, '0'),
('479', '492', 'Akram Radiator Works Gurjranwal - Lhr', 'Akram Radiator Works Gurjranwal - Lhr', 'Lahore  Gujranwala', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gujranwala', '0', '', NULL, '0'),
('480', '493', 'Al - Sheikh Autos GT Rd Gujranwala Lhr', 'Al - Sheikh Autos GT Rd Gujranwala Lhr', 'Lahore  Gujranwala', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gujranwala', '0', '', NULL, '0'),
('481', '494', 'Al Akhwan Auto Gt Road-Lahore', 'Al Akhwan Auto Gt Road-Lahore', 'Lahore  Gt Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gt Road', '0', '', NULL, '0'),
('482', '495', 'Al Aqeel Auto Store Sheikhpura-Lahore', 'Al Aqeel Auto Store Sheikhpura-Lahore', 'Lahore  Sheikhpura', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Sheikhpura', '0', '', NULL, '0'),
('483', '496', 'Al Fazal Auto &amp; Oil Mandi Stop Multan Ro', 'Al Fazal Auto &amp; Oil Mandi Stop Multan Ro', 'Lahore  Multan Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Multan Road', '0', '', NULL, '0'),
('484', '497', 'Al Hafeez Bhola Radiator Sheikhpura-LHR', 'Al Hafeez Bhola Radiator Sheikhpura-LHR', 'Lahore  Sheikhpura', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Sheikhpura', '0', '', NULL, '0'),
('485', '498', 'Al Hamad Oil Change 12-A Nawab Town', 'Al Hamad Oil Change 12-A Nawab Town', 'Lahore  Nawab Town', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Nawab Town', '0', '', NULL, '0'),
('486', '499', 'Al Haram Car Point PIA Housing Society', 'Al Haram Car Point PIA Housing Society', 'Lahore  Pia Housing Society', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Pia Housing Society', '0', '', NULL, '0'),
('487', '500', 'Al Karam Oil Johar Town-Lahore', 'Al Karam Oil Johar Town-Lahore', 'Lahore  Johar Town', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Johar Town', '0', '', NULL, '0'),
('488', '501', 'Al Khair Autos Johar Town-Lahore', 'Al Khair Autos Johar Town-Lahore', 'Lahore  Johar Town', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Johar Town', '0', '', NULL, '0'),
('489', '502', 'Al Madina Oil Store 25 No Stop S.Pura Ro', 'Al Madina Oil Store 25 No Stop S.Pura Ro', 'Lahore  Sheikhupura Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Sheikhupura Road', '0', '', NULL, '0'),
('490', '503', 'Al Madina Oil Store Shahdra-Lahore', 'Al Madina Oil Store Shahdra-Lahore', 'Lahore  Shahdara', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Shahdara', '0', '', NULL, '0'),
('491', '504', 'Al Madina Oil Store Sheikhupura Road Lhr', 'Al Madina Oil Store Sheikhupura Road Lhr', 'Lahore  Sheikhupura Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Sheikhupura Road', '0', '', NULL, '0'),
('492', '505', 'Al Makkah Oil Shadara-Lahore', 'Al Makkah Oil Shadara-Lahore', 'Lahore  Shahdara', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Shahdara', '0', '', NULL, '0'),
('493', '506', 'Al Makkah Oil Sheikhpura Road-Lahore', 'Al Makkah Oil Sheikhpura Road-Lahore', 'Lahore  Sheikhpura', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Sheikhpura', '0', '', NULL, '0'),
('494', '507', 'Al Qadri LX 273 Ravi Block AIT', 'Al Qadri LX 273 Ravi Block AIT', 'Lahore  Allama Iqbal Town', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Allama Iqbal Town', '0', '', NULL, '0'),
('495', '508', 'Al Qasim Auto Ghazi Road Punjab Society', 'Al Qasim Auto Ghazi Road Punjab Society', 'Lahore  Ghazi Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Ghazi Road', '0', '', NULL, '0'),
('496', '509', 'Al Rauf Auto Parts Gujranwala-Lahore', 'Al Rauf Auto Parts Gujranwala-Lahore', 'Lahore  Gujranwala', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gujranwala', '0', '', NULL, '0'),
('497', '510', 'AL Rehman Auto Fsilabad Road Shekhupura', 'AL Rehman Auto Fsilabad Road Shekhupura', 'Lahore  Sheikhpura', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Sheikhpura', '0', '', NULL, '0'),
('498', '511', 'Al Rehman Auto Plot 6 Wahdat Road', 'Al Rehman Auto Plot 6 Wahdat Road', 'Lahore  Wahdat Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Wahdat Road', '0', '', NULL, '0'),
('499', '512', 'Al Riaz Autos Ferozpur Road-Lahore', 'Al Riaz Autos Ferozpur Road-Lahore', 'Lahore  Ferozpur Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Ferozpur Road', '0', '', NULL, '0'),
('500', '513', 'Al Subhan Autos Gujranwala-Lahore', 'Al Subhan Autos Gujranwala-Lahore', 'Lahore  Gujranwala', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gujranwala', '0', '', NULL, '0'),
('501', '514', 'Alaf Autos Johar Town-Lahore', 'Alaf Autos Johar Town-Lahore', 'Lahore  Johar Town', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Johar Town', '0', '', NULL, '0'),
('502', '515', 'Alam Oil Store Johar Town-Lahore', 'Alam Oil Store Johar Town-Lahore', 'Lahore  Johar Town', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Johar Town', '0', '', NULL, '0'),
('503', '516', 'Ali Ahmed Autos Gulberg-Lahore', 'Ali Ahmed Autos Gulberg-Lahore', 'Lahore  Gulberg', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gulberg', '0', '', NULL, '0'),
('504', '517', 'Ali Auto Main Gulshan E Ravi-Lahore', 'Ali Auto Main Gulshan E Ravi-Lahore', 'Lahore  Gulshan E Ravi', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gulshan E Ravi', '0', '', NULL, '0'),
('505', '518', 'Ali Auto Shade Wal Chowk Joher Town', 'Ali Auto Shade Wal Chowk Joher Town', 'Lahore  Johar Town', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Johar Town', '0', '', NULL, '0'),
('506', '519', 'Ali Baba Decoration Pak Block Iqbal Town', 'Ali Baba Decoration Pak Block Iqbal Town', 'Lahore  Iqbal Town', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Iqbal Town', '0', '', NULL, '0'),
('507', '520', 'Ali Lube Shop Steel Bagh Mor Qasoor', 'Ali Lube Shop Steel Bagh Mor Qasoor', 'Lahore  Qasoor', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Qasoor', '0', '', NULL, '0'),
('508', '521', 'Ali Lube Shope Shekhupura', 'Ali Lube Shope Shekhupura', 'Lahore  Sheikhpura', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Sheikhpura', '0', '', NULL, '0'),
('509', '522', 'ALLAH Hu Motor Gulshan E Ravi-Lahore', 'ALLAH Hu Motor Gulshan E Ravi-Lahore', 'Lahore  Gulshan E Ravi', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gulshan E Ravi', '0', '', NULL, '0'),
('510', '523', 'Alpha Auto Decoration Gujranwala-Lahore', 'Alpha Auto Decoration Gujranwala-Lahore', 'Lahore  Gujranwala', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gujranwala', '0', '', NULL, '0'),
('511', '524', 'Altaf Auto Montgomery Road Lahore', 'Altaf Auto Montgomery Road Lahore', 'Lahore  Montgomery Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Montgomery Road', '0', '', NULL, '0'),
('512', '525', 'Amin Sons HardWare Sheikhupura Lahore', 'Amin Sons HardWare Sheikhupura Lahore', 'Lahore  Sheikhpura', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Sheikhpura', '0', '', NULL, '0'),
('513', '526', 'Amir Auto Workshop Canal Park Gulberg 2', 'Amir Auto Workshop Canal Park Gulberg 2', 'Lahore  Gulberg', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gulberg', '0', '', NULL, '0'),
('514', '527', 'Amjad Auto Montgomery Road', 'Amjad Auto Montgomery Road', 'Lahore  Montgomery Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Montgomery Road', '0', '', NULL, '0'),
('515', '528', 'Amjad Autos Patoki-Lahore', 'Amjad Autos Patoki-Lahore', 'Lahore  Patoki', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Patoki', '0', '', NULL, '0'),
('516', '529', 'Arsalan &amp; Co Gulberg Lahore', 'Arsalan &amp; Co Gulberg Lahore', 'Lahore  Gulberg', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gulberg', '0', '', NULL, '0'),
('517', '530', 'Asad Auto Oil Pak Block Iqbal Town', 'Asad Auto Oil Pak Block Iqbal Town', 'Lahore  Iqbal Town', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Iqbal Town', '0', '', NULL, '0'),
('518', '531', 'Ashfaq Autos Lari Adda Qasoor Lhr', 'Ashfaq Autos Lari Adda Qasoor Lhr', 'Lahore  Qasoor', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Qasoor', '0', '', NULL, '0'),
('519', '532', 'Ashraf Auto Pak Block Iqbal Town', 'Ashraf Auto Pak Block Iqbal Town', 'Lahore  Iqbal Town', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Iqbal Town', '0', '', NULL, '0'),
('520', '533', 'Asif Auto Parts Gurumanget Gulberg III', 'Asif Auto Parts Gurumanget Gulberg III', 'Lahore  Gulberg', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gulberg', '0', '', NULL, '0'),
('521', '534', 'Asif Auto Spare Parts Gujrawala', 'Asif Auto Spare Parts Gujrawala', 'Lahore  Gujranwala', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gujranwala', '0', '', NULL, '0'),
('522', '535', 'Asif Autos Sheikhpura Road-Lahore', 'Asif Autos Sheikhpura Road-Lahore', 'Lahore  Sheikhupura Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Sheikhupura Road', '0', '', NULL, '0'),
('523', '536', 'Asif Battery Autos Gulberg ll lahore', 'Asif Battery Autos Gulberg ll lahore', 'Lahore  Gulberg', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gulberg', '0', '', NULL, '0'),
('524', '537', 'Asif Oil Change Kacha Ferozpur Road', 'Asif Oil Change Kacha Ferozpur Road', 'Lahore  Ferozpur Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Ferozpur Road', '0', '', NULL, '0'),
('525', '538', 'Atteeq Oil Faisalabad Rd Sheikhupura Lhr', 'Atteeq Oil Faisalabad Rd Sheikhupura Lhr', 'Lahore  Sheikhpura', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Sheikhpura', '0', '', NULL, '0'),
('526', '539', 'AUTO BANK SHEIKHUPURA', 'AUTO BANK SHEIKHUPURA', 'Lahore  Sheikhupura ', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Sheikhupura ', '0', '', NULL, '0'),
('527', '540', 'Auto Care Clinic Wahdat Road-Lahore', 'Auto Care Clinic Wahdat Road-Lahore', 'Lahore  Wahadat Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Wahadat Road', '0', '', NULL, '0'),
('528', '541', 'Auto Centre 35/B Faisal Town Opp Kotha', 'Auto Centre 35/B Faisal Town Opp Kotha', 'Lahore  Faisal Town', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Faisal Town', '0', '', NULL, '0'),
('529', '542', 'Auto Club Walton Road-Lahore', 'Auto Club Walton Road-Lahore', 'Lahore  Walton Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Walton Road', '0', '', NULL, '0'),
('530', '543', 'Auto Expert 6 Rasool Park LOS-Lahore', 'Auto Expert 6 Rasool Park LOS-Lahore', 'Lahore  Rasool Park', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Rasool Park', '0', '', NULL, '0'),
('531', '544', 'Auto King Oil Store Johar Town-Lahore', 'Auto King Oil Store Johar Town-Lahore', 'Lahore  Johar Town', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Johar Town', '0', '', NULL, '0'),
('532', '545', 'Auto Solutions 8-Montgomery Road', 'Auto Solutions 8-Montgomery Road', 'Lahore  Montgomery Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Montgomery Road', '0', '', NULL, '0'),
('533', '546', 'Auto Spot PIA Society Near Goga Neelam', 'Auto Spot PIA Society Near Goga Neelam', 'Lahore  Pia Housing Society', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Pia Housing Society', '0', '', NULL, '0'),
('534', '547', 'Auto Zone Spare Parts Gujrawala', 'Auto Zone Spare Parts Gujrawala', 'Lahore  Gujranwala', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gujranwala', '0', '', NULL, '0'),
('535', '548', 'Awami Autos Gulberg-Lahore', 'Awami Autos Gulberg-Lahore', 'Lahore  Gulberg', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gulberg', '0', '', NULL, '0'),
('536', '549', 'Awan Autos Gujranwala-Lahore', 'Awan Autos Gujranwala-Lahore', 'Lahore  Gujranwala', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gujranwala', '0', '', NULL, '0'),
('537', '550', 'Awan Autos Gulberg-Lahore', 'Awan Autos Gulberg-Lahore', 'Lahore  Gulberg', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gulberg', '0', '', NULL, '0'),
('538', '551', 'Awan Autos Khark Nala Multan Road-Lahore', 'Awan Autos Khark Nala Multan Road-Lahore', 'Lahore  Multan Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Multan Road', '0', '', NULL, '0'),
('539', '552', 'Awan Autos Okara-Lahore', 'Awan Autos Okara-Lahore', 'Lahore  Okara', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Okara', '0', '', NULL, '0'),
('540', '553', 'Azaan Oil Change 32-29 Islamia Park LOS', 'Azaan Oil Change 32-29 Islamia Park LOS', 'Lahore  Los', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Los', '0', '', NULL, '0');
INSERT INTO `0_cust_branch` VALUES
('541', '554', 'Azeem Electronics Data Market Hall Road', 'Azeem Electronics Data Market Hall Road', 'Lahore  Hall Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Hall Road', '0', '', NULL, '0'),
('542', '555', 'Babar Motors Montgomery Road', 'Babar Motors Montgomery Road', 'Lahore  Montgomery Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Montgomery Road', '0', '', NULL, '0'),
('543', '556', 'Babar Oil Store GT Road Okara-Lahore', 'Babar Oil Store GT Road Okara-Lahore', 'Lahore  Okara', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Okara', '0', '', NULL, '0'),
('544', '557', 'Badami Bagh Autos Iqbal Town-Lahore', 'Badami Bagh Autos Iqbal Town-Lahore', 'Lahore  Iqbal Town', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Iqbal Town', '0', '', NULL, '0'),
('545', '558', 'Bahoo Autos Sabzazar-Lahore', 'Bahoo Autos Sabzazar-Lahore', 'Lahore  Sabzazar', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Sabzazar', '0', '', NULL, '0'),
('546', '559', 'Bari Auto Work Shop Iqbal Town Lahore', 'Bari Auto Work Shop Iqbal Town Lahore', 'Lahore  Iqbal Town', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Iqbal Town', '0', '', NULL, '0'),
('547', '560', 'Barkat Auto Lariada Okara', 'Barkat Auto Lariada Okara', 'Lahore  Okara', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Okara', '0', '', NULL, '0'),
('548', '561', 'Basra Enterprises 5-a Montgomery Park', 'Basra Enterprises 5-a Montgomery Park', 'Lahore  Montgomery Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Montgomery Road', '0', '', NULL, '0'),
('549', '562', 'Bhatti Autos Jia Moosa Lahore', 'Bhatti Autos Jia Moosa Lahore', 'Lahore  Jia Moosa', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Jia Moosa', '0', '', NULL, '0'),
('550', '563', 'Bismillah Arms Shop Hafizabad-Lahore', 'Bismillah Arms Shop Hafizabad-Lahore', 'Lahore  Hafizabad', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Hafizabad', '0', '', NULL, '0'),
('551', '564', 'Bismillah Auto Gulberg 2 LHR', 'Bismillah Auto Gulberg 2 LHR', 'Lahore  Gulberg', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gulberg', '0', '', NULL, '0'),
('552', '565', 'Bismillah Auto Jinnah Chowk Hafizabad', 'Bismillah Auto Jinnah Chowk Hafizabad', 'Lahore  Hafizabad', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Hafizabad', '0', '', NULL, '0'),
('553', '566', 'Bismillah Auto Parts Barkat Town GT Road', 'Bismillah Auto Parts Barkat Town GT Road', 'Lahore  Barkat Town', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Barkat Town', '0', '', NULL, '0'),
('554', '567', 'Bismillah Auto Scheme Mor Iqbal Town', 'Bismillah Auto Scheme Mor Iqbal Town', 'Lahore  Iqbal Town', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Iqbal Town', '0', '', NULL, '0'),
('555', '568', 'Bismillah Auto Shade Wal Chowk J.T', 'Bismillah Auto Shade Wal Chowk J.T', 'Lahore  Johar Town', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Johar Town', '0', '', NULL, '0'),
('556', '569', 'Bismillah Auto Spare Parts Kala Khtatai', 'Bismillah Auto Spare Parts Kala Khtatai', 'Lahore  Kala Khatai', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Kala Khatai', '0', '', NULL, '0'),
('557', '570', 'Bismillah Autos Chauburji-Lahore', 'Bismillah Autos Chauburji-Lahore', 'Lahore  Chauburji', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Chauburji', '0', '', NULL, '0'),
('558', '571', 'Bismillah Autos Diyal Singh-Lahore', 'Bismillah Autos Diyal Singh-Lahore', 'Lahore  Dayal Singh Mention', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Dayal Singh Mention', '0', '', NULL, '0'),
('559', '572', 'Bismillah Autos Gulberg Lll Lahore', 'Bismillah Autos Gulberg Lll Lahore', 'Lahore  Gulberg', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gulberg', '0', '', NULL, '0'),
('560', '573', 'Bismillah Rehman Autos Faisal Town Lhr', 'Bismillah Rehman Autos Faisal Town Lhr', 'Lahore  Faisal Town', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Faisal Town', '0', '', NULL, '0'),
('561', '574', 'BM Auto Decoration H Block Bijli Ghr', 'BM Auto Decoration H Block Bijli Ghr', 'Lahore  Sabzazar', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Sabzazar', '0', '', NULL, '0'),
('562', '575', 'Bobi Auto Allam Iqbal Road-Lahore', 'Bobi Auto Allam Iqbal Road-Lahore', 'Lahore  Allama Iqbal Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Allama Iqbal Road', '0', '', NULL, '0'),
('563', '576', 'Bright Autos Qasoor-Lahore', 'Bright Autos Qasoor-Lahore', 'Lahore  Qasoor', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Qasoor', '0', '', NULL, '0'),
('564', '577', 'Brother Auto Imamia Colony Phatak GT Roa', 'Brother Auto Imamia Colony Phatak GT Roa', 'Lahore  Gt Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gt Road', '0', '', NULL, '0'),
('565', '578', 'Brother Auto Joher Town', 'Brother Auto Joher Town', 'Lahore  Johar Town', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Johar Town', '0', '', NULL, '0'),
('566', '579', 'Butt Auto Store Rasheed Plaza Sabzazar', 'Butt Auto Store Rasheed Plaza Sabzazar', 'Lahore  Sabzazar', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Sabzazar', '0', '', NULL, '0'),
('567', '580', 'Butt Autos Band Road Lahore', 'Butt Autos Band Road Lahore', 'Lahore  Band Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Band Road', '0', '', NULL, '0'),
('568', '581', 'Butt Autos G.T Road Okara Lahore', 'Butt Autos G.T Road Okara Lahore', 'Lahore  Okara', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Okara', '0', '', NULL, '0'),
('569', '582', 'Butt Oil 308 Kalma Chowk Near Silk Bank', 'Butt Oil 308 Kalma Chowk Near Silk Bank', 'Lahore  Kalma Chowk', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Kalma Chowk', '0', '', NULL, '0'),
('570', '583', 'Butt Rubber Decor Masjid Market Montgome', 'Butt Rubber Decor Masjid Market Montgome', 'Lahore  Montgomery Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Montgomery Road', '0', '', NULL, '0'),
('571', '584', 'Caltex Auto Care Sheikhpura-Lahore', 'Caltex Auto Care Sheikhpura-Lahore', 'Lahore  Sheikhpura', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Sheikhpura', '0', '', NULL, '0'),
('572', '585', 'Cantt Autos Walton Road-Lahore', 'Cantt Autos Walton Road-Lahore', 'Lahore  Walton Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Walton Road', '0', '', NULL, '0'),
('573', '586', 'Car Care 8-C Nawab Town Raiwind Road', 'Car Care 8-C Nawab Town Raiwind Road', 'Lahore  Nawab Town', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Nawab Town', '0', '', NULL, '0'),
('574', '587', 'Car Help Line 150 Garden Block Garden T', 'Car Help Line 150 Garden Block Garden T', 'Lahore  Garden Town', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Garden Town', '0', '', NULL, '0'),
('575', '588', 'Ch.Faiz Oil Auto Store Montgomery Rd-LHR', 'Ch.Faiz Oil Auto Store Montgomery Rd-LHR', 'Lahore  Montgomery Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Montgomery Road', '0', '', NULL, '0'),
('576', '589', 'Channo Auto Chughtai Market 10 Montgomer', 'Channo Auto Chughtai Market 10 Montgomer', 'Lahore  Montgomery Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Montgomery Road', '0', '', NULL, '0'),
('577', '590', 'Chaudhary Auto G T Toad Gujrat', 'Chaudhary Auto G T Toad Gujrat', 'Lahore  Gujrat', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gujrat', '0', '', NULL, '0'),
('578', '591', 'Chaudhary Auto Opp Packages Mall Walton', 'Chaudhary Auto Opp Packages Mall Walton', 'Lahore  Walton Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Walton Road', '0', '', NULL, '0'),
('579', '592', 'Chaudhary Auto Store 17-A Montgomery Roa', 'Chaudhary Auto Store 17-A Montgomery Roa', 'Lahore  Montgomery Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Montgomery Road', '0', '', NULL, '0'),
('580', '593', 'Chaudhary Auto Wahdat Road Iqbal Town', 'Chaudhary Auto Wahdat Road Iqbal Town', 'Lahore  Iqbal Town', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Iqbal Town', '0', '', NULL, '0'),
('581', '594', 'Chaudhary Oil Store 14 Km Multan Road', 'Chaudhary Oil Store 14 Km Multan Road', 'Lahore  Multan Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Multan Road', '0', '', NULL, '0'),
('582', '595', 'Chaudhry Arms Dealer Qasoor-Lahore', 'Chaudhry Arms Dealer Qasoor-Lahore', 'Lahore  Qasoor', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Qasoor', '0', '', NULL, '0'),
('583', '596', 'Chaudhry Arms Gulberg III-Lahore', 'Chaudhry Arms Gulberg III-Lahore', 'Lahore  Gulberg', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gulberg', '0', '', NULL, '0'),
('584', '597', 'Chaudhry Autos G T Road Okara', 'Chaudhry Autos G T Road Okara', 'Lahore  Okara', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Okara', '0', '', NULL, '0'),
('585', '598', 'Chaudhry Autos-Gujranwala', 'Chaudhry Autos-Gujranwala', 'Lahore  Gujranwala', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gujranwala', '0', '', NULL, '0'),
('586', '599', 'Chaudhry Car Clinic Karim Block Iqbal To', 'Chaudhry Car Clinic Karim Block Iqbal To', 'Lahore  Iqbal Town', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Iqbal Town', '0', '', NULL, '0'),
('587', '600', 'Cheema Oil 45-A Revenue Society Johar.T', 'Cheema Oil 45-A Revenue Society Johar.T', 'Lahore  Johar Town', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Johar Town', '0', '', NULL, '0'),
('588', '601', 'Chevrolet Platinum Abbat Road-Lahore', 'Chevrolet Platinum Abbat Road-Lahore', 'Lahore  Abbat Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Abbat Road', '0', '', NULL, '0'),
('589', '602', 'City Autos Multan Road Patoki-Lahore', 'City Autos Multan Road Patoki-Lahore', 'Lahore  Patoki', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Patoki', '0', '', NULL, '0'),
('590', '603', 'City Car Care 25 No.Stop-Lahore', 'City Car Care 25 No.Stop-Lahore', 'Lahore  Shahdra', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Shahdra', '0', '', NULL, '0'),
('591', '604', 'Crystal Autos GT Road Gujrat-Lahore', 'Crystal Autos GT Road Gujrat-Lahore', 'Lahore  Gujrat', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gujrat', '0', '', NULL, '0'),
('592', '605', 'Danewal Auto Wahdat Road', 'Danewal Auto Wahdat Road', 'Lahore  Wahdat Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Wahdat Road', '0', '', NULL, '0'),
('593', '606', 'Dar Lube Naqsha Stop Wahdat Road', 'Dar Lube Naqsha Stop Wahdat Road', 'Lahore  Wahdat Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Wahdat Road', '0', '', NULL, '0'),
('594', '607', 'Data Oil Store Faisal Town Lahore', 'Data Oil Store Faisal Town Lahore', 'Lahore  Faisal Town', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Faisal Town', '0', '', NULL, '0'),
('595', '608', 'Dawn Motors 17-A Montgomery Road', 'Dawn Motors 17-A Montgomery Road', 'Lahore  Montgomery Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Montgomery Road', '0', '', NULL, '0'),
('596', '609', 'Dildar Oil Montgomery Road-Lahore', 'Dildar Oil Montgomery Road-Lahore', 'Lahore  Montgomery Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Montgomery Road', '0', '', NULL, '0'),
('597', '610', 'Doctor Auto Main Gulshan E Ravi', 'Doctor Auto Main Gulshan E Ravi', 'Lahore  Gulshan E Ravi', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gulshan E Ravi', '0', '', NULL, '0'),
('598', '611', 'Dogar Oil Store Gulshan E Ravi-Lahore', 'Dogar Oil Store Gulshan E Ravi-Lahore', 'Lahore  Gulshan E Ravi', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gulshan E Ravi', '0', '', NULL, '0'),
('599', '612', 'Dubai Autos Band Road Lahore', 'Dubai Autos Band Road Lahore', 'Lahore  Band Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Band Road', '0', '', NULL, '0'),
('600', '613', 'Elahi Oil Store GT Road-Okara', 'Elahi Oil Store GT Road-Okara', 'Lahore  Okara', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Okara', '0', '', NULL, '0'),
('601', '614', 'Ettehad Auto Chowk Beighum Kot-Lahore', 'Ettehad Auto Chowk Beighum Kot-Lahore', 'Lahore  Beighum Kot', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Beighum Kot', '0', '', NULL, '0'),
('602', '615', 'Ettehad Auto Ghazi Road Punjab Society', 'Ettehad Auto Ghazi Road Punjab Society', 'Lahore  Punjab Society', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Punjab Society', '0', '', NULL, '0'),
('603', '616', 'Express Auto Johar Town Lahore', 'Express Auto Johar Town Lahore', 'Lahore  Johar Town', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Johar Town', '0', '', NULL, '0'),
('604', '617', 'Fahad Auto Montgomery Road Lahore', 'Fahad Auto Montgomery Road Lahore', 'Lahore  Montgomery Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Montgomery Road', '0', '', NULL, '0'),
('605', '618', 'Faisal Movers Bund Road Lahore', 'Faisal Movers Bund Road Lahore', 'Lahore  Band Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Band Road', '0', '', NULL, '0'),
('606', '619', 'Faisal Movers Bund Road Near Abdullah Tr', 'Faisal Movers Bund Road Near Abdullah Tr', 'Lahore  Band Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Band Road', '0', '', NULL, '0'),
('607', '620', 'Faizan Auto Spare Parts Walton Road', 'Faizan Auto Spare Parts Walton Road', 'Lahore  Walton Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Walton Road', '0', '', NULL, '0'),
('608', '621', 'Faizan E Muhammadi Oil LOS Samanabad', 'Faizan E Muhammadi Oil LOS Samanabad', 'Lahore  Samnabad', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Samnabad', '0', '', NULL, '0'),
('609', '622', 'Fareed Khan Lodhi Oil G.T Rd Okara Lhr', 'Fareed Khan Lodhi Oil G.T Rd Okara Lhr', 'Lahore  Okara', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Okara', '0', '', NULL, '0'),
('610', '623', 'Farooq Brother G.T Road Gujranwala-Lahor', 'Farooq Brother G.T Road Gujranwala-Lahor', 'Lahore  Gujranwala', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gujranwala', '0', '', NULL, '0'),
('611', '624', 'Fazal Autos Wahdat Road-Lahore', 'Fazal Autos Wahdat Road-Lahore', 'Lahore  Wahadat Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Wahadat Road', '0', '', NULL, '0'),
('612', '625', 'Fiazan Auto Spare Parts Walton  Road', 'Fiazan Auto Spare Parts Walton  Road', 'Lahore  Walton Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Walton Road', '0', '', NULL, '0'),
('613', '626', 'Fine Auto main Market Gulberg Lhr', 'Fine Auto main Market Gulberg Lhr', 'Lahore  Gulberg', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gulberg', '0', '', NULL, '0'),
('614', '627', 'Fine Autos Gulberg ll Lahore', 'Fine Autos Gulberg ll Lahore', 'Lahore  Gulberg', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gulberg', '0', '', NULL, '0'),
('615', '628', 'Finish Line Autos Multan Road Lhr', 'Finish Line Autos Multan Road Lhr', 'Lahore  Multan Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Multan Road', '0', '', NULL, '0'),
('616', '629', 'Five Star Work Shop Joher Town', 'Five Star Work Shop Joher Town', 'Lahore  Johar Town', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Johar Town', '0', '', NULL, '0'),
('617', '630', 'G.A Suzuki Center Chuburji-Lahore', 'G.A Suzuki Center Chuburji-Lahore', 'Lahore  Chuburji', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Chuburji', '0', '', NULL, '0'),
('618', '631', 'Geely Ravi Motors Bypass Road-Lahore', 'Geely Ravi Motors Bypass Road-Lahore', 'Lahore  ', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  ', '0', '', NULL, '0'),
('619', '632', 'General Autos Hafizabad-Lahore', 'General Autos Hafizabad-Lahore', 'Lahore  Hafizabad', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Hafizabad', '0', '', NULL, '0'),
('620', '633', 'Geo Oil Store Gulberg III-Lahore', 'Geo Oil Store Gulberg III-Lahore', 'Lahore  Gulberg', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gulberg', '0', '', NULL, '0'),
('621', '634', 'Ghaus Autos Johar Town-Lahore', 'Ghaus Autos Johar Town-Lahore', 'Lahore  Johar Town', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Johar Town', '0', '', NULL, '0'),
('622', '635', 'Ghous Auto Parts Johar Town', 'Ghous Auto Parts Johar Town', 'Lahore  Johar Town', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Johar Town', '0', '', NULL, '0'),
('623', '636', 'Ghousia Auto Super Auto Market Chuburji', 'Ghousia Auto Super Auto Market Chuburji', 'Lahore  Chuburji', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Chuburji', '0', '', NULL, '0'),
('624', '637', 'GM Auto 1071 A Block Sabzazar Multan Roa', 'GM Auto 1071 A Block Sabzazar Multan Roa', 'Lahore  Multan Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Multan Road', '0', '', NULL, '0'),
('625', '638', 'Go-4 Repair Autos GT Road Gujrat-Lahore', 'Go-4 Repair Autos GT Road Gujrat-Lahore', 'Lahore  Gujrat', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gujrat', '0', '', NULL, '0'),
('626', '639', 'Gold Autos Gujranwala-Lahore', 'Gold Autos Gujranwala-Lahore', 'Lahore  Gujranwala', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gujranwala', '0', '', NULL, '0'),
('627', '640', 'Gondal  Autos GT Road  Okara Lahore', 'Gondal  Autos GT Road  Okara Lahore', 'Lahore  Okara', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Okara', '0', '', NULL, '0'),
('628', '641', 'Green Suzuki Autos Montgomery Road', 'Green Suzuki Autos Montgomery Road', 'Lahore  Montgomery Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Montgomery Road', '0', '', NULL, '0'),
('629', '642', 'Gujranwala Autos Oil Gujranwala-Lahore', 'Gujranwala Autos Oil Gujranwala-Lahore', 'Lahore  Gujranwala', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gujranwala', '0', '', NULL, '0'),
('630', '643', 'H.I Motor Auto Parts Waris Road-Lahore', 'H.I Motor Auto Parts Waris Road-Lahore', 'Lahore  Waris Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Waris Road', '0', '', NULL, '0'),
('631', '644', 'H.M Engineering Co.Johar Town-Lahore', 'H.M Engineering Co.Johar Town-Lahore', 'Lahore  Johar Town', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Johar Town', '0', '', NULL, '0'),
('632', '645', 'Habib &amp; Sons Hardwere Store-Gujranwala', 'Habib &amp; Sons Hardwere Store-Gujranwala', 'Lahore  Gujranwala', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gujranwala', '0', '', NULL, '0'),
('633', '646', 'Hafiz Auto Spare Parts 22 Lawrence Road', 'Hafiz Auto Spare Parts 22 Lawrence Road', 'Lahore  Lawrence Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Lawrence Road', '0', '', NULL, '0'),
('634', '647', 'Hafiz Autos Waris Road-Lahore', 'Hafiz Autos Waris Road-Lahore', 'Lahore  Waris Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Waris Road', '0', '', NULL, '0'),
('635', '648', 'Hafiz Brothers Walton Road-Lahore', 'Hafiz Brothers Walton Road-Lahore', 'Lahore  Walton Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Walton Road', '0', '', NULL, '0'),
('636', '649', 'Hafiz G Oil Change Bijli Ghr Sabzazar', 'Hafiz G Oil Change Bijli Ghr Sabzazar', 'Lahore  Sabzazar', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Sabzazar', '0', '', NULL, '0'),
('637', '650', 'Hafiz Kamran Autos Johar Town Lahore', 'Hafiz Kamran Autos Johar Town Lahore', 'Lahore  Johar Town', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Johar Town', '0', '', NULL, '0'),
('638', '651', 'Hafiz Karachi Autos Gujranwala-Lahore', 'Hafiz Karachi Autos Gujranwala-Lahore', 'Lahore  Gujranwala', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gujranwala', '0', '', NULL, '0'),
('639', '652', 'Hafiz Karachi Autos Oil Shaikhpura Rd Lhr', 'Hafiz Karachi Autos Oil Shaikhpura Rd Lhr', 'Lahore  Sheikhpura', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Sheikhpura', '0', '', NULL, '0'),
('640', '653', 'Haider Auto 25 Fateh Shair Road Mozang', 'Haider Auto 25 Fateh Shair Road Mozang', 'Lahore  Fateh Shair Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Fateh Shair Road', '0', '', NULL, '0'),
('641', '654', 'Haider Autos Faislabad Road Sheikhupura', 'Haider Autos Faislabad Road Sheikhupura', 'Lahore  Sheikhupura', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Sheikhupura', '0', '', NULL, '0'),
('642', '655', 'Haji Abdul Al Rashid G-market Qasoor Lhr', 'Haji Abdul Al Rashid G-market Qasoor Lhr', 'Lahore  Qasoor', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Qasoor', '0', '', NULL, '0'),
('643', '656', 'Haji Auto Main Walton Road Cantt', 'Haji Auto Main Walton Road Cantt', 'Lahore  Walton Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Walton Road', '0', '', NULL, '0'),
('644', '657', 'Haji Ibrahim Mill Store-Lahore', 'Haji Ibrahim Mill Store-Lahore', 'Lahore  ', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  ', '0', '', NULL, '0'),
('645', '658', 'Hajveri Oil Change Bund Road Niazi Adda', 'Hajveri Oil Change Bund Road Niazi Adda', 'Lahore  Band Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Band Road', '0', '', NULL, '0'),
('646', '659', 'Hajveri Oil Store Johar Town-Lahore', 'Hajveri Oil Store Johar Town-Lahore', 'Lahore  Johar Town', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Johar Town', '0', '', NULL, '0'),
('647', '660', 'Hannan Auto Joher Town Lahore', 'Hannan Auto Joher Town Lahore', 'Lahore  Johar Town', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Johar Town', '0', '', NULL, '0'),
('648', '661', 'HARRON AUTO CANAL BANK GULBERG 2 LAHORE', 'HARRON AUTO CANAL BANK GULBERG 2 LAHORE', 'Lahore  Gulberg', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gulberg', '0', '', NULL, '0'),
('649', '662', 'Hasnain Auto Joher Town', 'Hasnain Auto Joher Town', 'Lahore  Johar Town', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Johar Town', '0', '', NULL, '0'),
('650', '663', 'Hassan Auto Safa Wala Chowk Ganga Ram Lh', 'Hassan Auto Safa Wala Chowk Ganga Ram Lh', 'Lahore  Gangaram', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gangaram', '0', '', NULL, '0'),
('651', '664', 'Highway Autos Sheikhpura-Lahore', 'Highway Autos Sheikhpura-Lahore', 'Lahore  Sheikhpura', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Sheikhpura', '0', '', NULL, '0'),
('652', '665', 'Honda Hub Montgomery Road-Lahore', 'Honda Hub Montgomery Road-Lahore', 'Lahore  Montgomery Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Montgomery Road', '0', '', NULL, '0'),
('653', '666', 'Honda Johar Town Motors Johar Town-LHR', 'Honda Johar Town Motors Johar Town-LHR', 'Lahore  Johar Town', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Johar Town', '0', '', NULL, '0'),
('654', '667', 'Honda Ring Road Motors Ring Road Lahore', 'Honda Ring Road Motors Ring Road Lahore', 'Lahore  Ring Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Ring Road', '0', '', NULL, '0'),
('655', '668', 'Honda Samanabad Motors-Lahore', 'Honda Samanabad Motors-Lahore', 'Lahore  Samnabad', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Samnabad', '0', '', NULL, '0'),
('656', '669', 'Hussain Auto Spare Parts Opp Canal View', 'Hussain Auto Spare Parts Opp Canal View', 'Lahore  Canal View', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Canal View', '0', '', NULL, '0'),
('657', '670', 'I.A Traders Walton Road-Lahore', 'I.A Traders Walton Road-Lahore', 'Lahore  Walton Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Walton Road', '0', '', NULL, '0'),
('658', '671', 'Ikhlaq Autos Khokha Stop Band Rd-Lahore', 'Ikhlaq Autos Khokha Stop Band Rd-Lahore', 'Lahore  Band Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Band Road', '0', '', NULL, '0'),
('659', '672', 'Imran Auto Samsani Road Johar Town', 'Imran Auto Samsani Road Johar Town', 'Lahore  Johar Town', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Johar Town', '0', '', NULL, '0'),
('660', '673', 'Inam &amp; Co G.T Road Gujranwala Lhr', 'Inam &amp; Co G.T Road Gujranwala Lhr', 'Lahore  Gujranwala', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gujranwala', '0', '', NULL, '0'),
('661', '674', 'Inayat Ali &amp;company HafizaBad', 'Inayat Ali &amp;company HafizaBad', 'Lahore  Hafizabad', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Hafizabad', '0', '', NULL, '0'),
('662', '675', 'International Autos Chauburji-Lahore', 'International Autos Chauburji-Lahore', 'Lahore  Chauburji', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Chauburji', '0', '', NULL, '0'),
('663', '676', 'Iqbal Auto Abbot Road-Lahore', 'Iqbal Auto Abbot Road-Lahore', 'Lahore  Abbot Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Abbot Road', '0', '', NULL, '0'),
('664', '677', 'Ishfaq Auto Store Lari Adda Qasoor', 'Ishfaq Auto Store Lari Adda Qasoor', 'Lahore  Qasoor', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Qasoor', '0', '', NULL, '0'),
('665', '678', 'Ishfaq Autos Gulshan E Ravi Road-Lahore', 'Ishfaq Autos Gulshan E Ravi Road-Lahore', 'Lahore  Gulshan E Ravi', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gulshan E Ravi', '0', '', NULL, '0'),
('666', '679', 'Ishfaq Autos Sheikuhpura-Lahore', 'Ishfaq Autos Sheikuhpura-Lahore', 'Lahore  Sheikhpura', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Sheikhpura', '0', '', NULL, '0'),
('667', '680', 'Israr Autos Super Market Okara-Lahore', 'Israr Autos Super Market Okara-Lahore', 'Lahore  Okara', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Okara', '0', '', NULL, '0'),
('668', '681', 'Itehad Autos Sheikhpura Road-Lahore', 'Itehad Autos Sheikhpura Road-Lahore', 'Lahore  Sheikhpura', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Sheikhpura', '0', '', NULL, '0'),
('669', '682', 'Ittefaq Motors Montgomery Road-Lahore', 'Ittefaq Motors Montgomery Road-Lahore', 'Lahore  Montgomery Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Montgomery Road', '0', '', NULL, '0'),
('670', '683', 'Jalandar Auto Chungi No 7 Okara', 'Jalandar Auto Chungi No 7 Okara', 'Lahore  Okara', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Okara', '0', '', NULL, '0'),
('671', '684', 'Jamil Autos Faisalabad Road Okara Lhr', 'Jamil Autos Faisalabad Road Okara Lhr', 'Lahore  Okara', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Okara', '0', '', NULL, '0'),
('672', '685', 'Jani Autos Band Road-Lahore', 'Jani Autos Band Road-Lahore', 'Lahore  Band Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Band Road', '0', '', NULL, '0'),
('673', '686', 'Javaid Auto Oil Store Bund Road LHR', 'Javaid Auto Oil Store Bund Road LHR', 'Lahore  Band Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Band Road', '0', '', NULL, '0'),
('674', '687', 'Jawed Auto Store Patoki-Lahore', 'Jawed Auto Store Patoki-Lahore', 'Lahore  Patoki', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Patoki', '0', '', NULL, '0'),
('675', '688', 'K&amp;W Oil Store 63 Kacha Ferozpur Road LOS', 'K&amp;W Oil Store 63 Kacha Ferozpur Road LOS', 'Lahore  Ferozpur Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Ferozpur Road', '0', '', NULL, '0'),
('676', '689', 'K.G.N Oil Store Joher Town', 'K.G.N Oil Store Joher Town', 'Lahore  Johar Town', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Johar Town', '0', '', NULL, '0'),
('677', '690', 'Kar Kraft Model Town Ext Main Faisal Tow', 'Kar Kraft Model Town Ext Main Faisal Tow', 'Lahore  Faisal Town', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Faisal Town', '0', '', NULL, '0'),
('678', '691', 'Karim Auto Bijli Ghar Stop Sabzazar', 'Karim Auto Bijli Ghar Stop Sabzazar', 'Lahore  Sabzazar', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Sabzazar', '0', '', NULL, '0'),
('679', '692', 'Khadim Suzuki House Chauburji-Lahore', 'Khadim Suzuki House Chauburji-Lahore', 'Lahore  Chauburji', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Chauburji', '0', '', NULL, '0'),
('680', '693', 'Khalid Autos G.T Road Gujarat Lhr', 'Khalid Autos G.T Road Gujarat Lhr', 'Lahore  Gujrat', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gujrat', '0', '', NULL, '0'),
('681', '694', 'Khalid Autos Multan Road-Lahore', 'Khalid Autos Multan Road-Lahore', 'Lahore  Multan Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Multan Road', '0', '', NULL, '0'),
('682', '695', 'Khan &amp; Son Autos Chauburji-Lahore', 'Khan &amp; Son Autos Chauburji-Lahore', 'Lahore  Chauburji', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Chauburji', '0', '', NULL, '0'),
('683', '696', 'Khan Auto Oil Change Canal View Gate', 'Khan Auto Oil Change Canal View Gate', 'Lahore  Canal View', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Canal View', '0', '', NULL, '0'),
('684', '697', 'Khan Baba Aslah Dealer Gujrat - Lahore', 'Khan Baba Aslah Dealer Gujrat - Lahore', 'Lahore  Gujrat', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gujrat', '0', '', NULL, '0'),
('685', '698', 'Khokhar Agri Parts Gujranwala-Lahore', 'Khokhar Agri Parts Gujranwala-Lahore', 'Lahore  Gujranwala', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gujranwala', '0', '', NULL, '0'),
('686', '699', 'Khursheed Auto Montgomery Road Lahore', 'Khursheed Auto Montgomery Road Lahore', 'Lahore  Montgomery Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Montgomery Road', '0', '', NULL, '0'),
('687', '700', 'K-Jalil &amp; Company Chowk Begium Rd LHR', 'K-Jalil &amp; Company Chowk Begium Rd LHR', 'Lahore  Beighum Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Beighum Road', '0', '', NULL, '0'),
('688', '701', 'Lahore Auto Near Bank Alfalah Montgomery', 'Lahore Auto Near Bank Alfalah Montgomery', 'Lahore  Montgomery Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Montgomery Road', '0', '', NULL, '0'),
('689', '702', 'Lahore Oil Shadara Mor-Lahore', 'Lahore Oil Shadara Mor-Lahore', 'Lahore  Shahdara', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Shahdara', '0', '', NULL, '0'),
('690', '703', 'Lahore Oil Store Johar Town -Lahore', 'Lahore Oil Store Johar Town -Lahore', 'Lahore  Johar Town', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Johar Town', '0', '', NULL, '0'),
('691', '704', 'Lahoria Autos Gujranwala-Lahore', 'Lahoria Autos Gujranwala-Lahore', 'Lahore  Gujranwala', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gujranwala', '0', '', NULL, '0'),
('692', '705', 'Latif Autos Waris Road Lahore', 'Latif Autos Waris Road Lahore', 'Lahore  Waris Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Waris Road', '0', '', NULL, '0'),
('693', '706', 'Lube Shop Johar Town-Lahore', 'Lube Shop Johar Town-Lahore', 'Lahore  Johar Town', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Johar Town', '0', '', NULL, '0'),
('694', '707', 'Lubes Shop 2 GT Roadnear Lal Haveli', 'Lubes Shop 2 GT Roadnear Lal Haveli', 'Lahore  Lal Haveli', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Lal Haveli', '0', '', NULL, '0'),
('695', '708', 'M Ahmed Auto Spare Parts Shahdra', 'M Ahmed Auto Spare Parts Shahdra', 'Lahore  Shahdra', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Shahdra', '0', '', NULL, '0'),
('696', '709', 'M BASHIR AUTO BHALA CHOWK JOHER TOWN', 'M BASHIR AUTO BHALA CHOWK JOHER TOWN', 'Lahore  Johar Town', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Johar Town', '0', '', NULL, '0'),
('697', '710', 'M Ilyas Oil Change Samsani Road J.Town', 'M Ilyas Oil Change Samsani Road J.Town', 'Lahore  Johar Town', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Johar Town', '0', '', NULL, '0'),
('698', '711', 'M Tariq Oil Store Faisal Town-Lahore', 'M Tariq Oil Store Faisal Town-Lahore', 'Lahore  Faisal Town', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Faisal Town', '0', '', NULL, '0'),
('699', '712', 'M Usman Nes Pak Society Canal Bank Road', 'M Usman Nes Pak Society Canal Bank Road', 'Lahore  Canal Bank', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Canal Bank', '0', '', NULL, '0'),
('700', '713', 'MA Auto Oil Change Iqbal Town Lahore', 'MA Auto Oil Change Iqbal Town Lahore', 'Lahore  Iqbal Town', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Iqbal Town', '0', '', NULL, '0'),
('701', '714', 'Madina Auto Main Boulevard Ghazi Road', 'Madina Auto Main Boulevard Ghazi Road', 'Lahore  Ghazi Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Ghazi Road', '0', '', NULL, '0'),
('702', '715', 'Madina Auto Store Multan Road-Lahore', 'Madina Auto Store Multan Road-Lahore', 'Lahore  Multan Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Multan Road', '0', '', NULL, '0'),
('703', '716', 'Madina Motors Main Ferozpur Road-Lahore', 'Madina Motors Main Ferozpur Road-Lahore', 'Lahore  Ferozpur Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Ferozpur Road', '0', '', NULL, '0'),
('704', '717', 'Madina Oil Store Patoki-Lahore', 'Madina Oil Store Patoki-Lahore', 'Lahore  Patoki', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Patoki', '0', '', NULL, '0'),
('705', '718', 'Madni Motors Industrial Area Gulberg-LHR', 'Madni Motors Industrial Area Gulberg-LHR', 'Lahore  Gulberg', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gulberg', '0', '', NULL, '0'),
('706', '719', 'Majid Auto Traders Sharif Mension Gangar', 'Majid Auto Traders Sharif Mension Gangar', 'Lahore  Sharif Mension', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Sharif Mension', '0', '', NULL, '0'),
('707', '720', 'Makkah Autos GT Road Gujrat-Lahore', 'Makkah Autos GT Road Gujrat-Lahore', 'Lahore  Gujrat', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gujrat', '0', '', NULL, '0'),
('708', '721', 'Makkah Autso Johar Town Lhr', 'Makkah Autso Johar Town Lhr', 'Lahore  Johar Town', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Johar Town', '0', '', NULL, '0'),
('709', '722', 'Makkah Poshish Sadat Market 8-Montgomery', 'Makkah Poshish Sadat Market 8-Montgomery', 'Lahore  Montgomery Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Montgomery Road', '0', '', NULL, '0'),
('710', '723', 'Makki Oil Store Faisal Town-Lahore', 'Makki Oil Store Faisal Town-Lahore', 'Lahore  Faisal Town', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Faisal Town', '0', '', NULL, '0'),
('711', '724', 'Makki Oil Store Wapda Town-Lahore', 'Makki Oil Store Wapda Town-Lahore', 'Lahore  Wapdatown', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Wapdatown', '0', '', NULL, '0'),
('712', '725', 'Malik Auto Bank Stop Main Walton Road', 'Malik Auto Bank Stop Main Walton Road', 'Lahore  Walton Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Walton Road', '0', '', NULL, '0'),
('713', '726', 'Malik Auto Suzuki Parts 8-Montgomery', 'Malik Auto Suzuki Parts 8-Montgomery', 'Lahore  Montgomery Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Montgomery Road', '0', '', NULL, '0'),
('714', '727', 'Malik Autos Main Johar Town-Lahore', 'Malik Autos Main Johar Town-Lahore', 'Lahore  Johar Town', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Johar Town', '0', '', NULL, '0'),
('715', '728', 'Malik Autos Qasoor-Lahore', 'Malik Autos Qasoor-Lahore', 'Lahore  Qasoor', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Qasoor', '0', '', NULL, '0'),
('716', '729', 'Malik Autos Walton Road-Lahore', 'Malik Autos Walton Road-Lahore', 'Lahore  Walton Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Walton Road', '0', '', NULL, '0'),
('717', '730', 'Malik Imran Auto 222 Multan Road', 'Malik Imran Auto 222 Multan Road', 'Lahore  Multan Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Multan Road', '0', '', NULL, '0'),
('718', '731', 'Malik Paper Badar Pura Stop Multan Road', 'Malik Paper Badar Pura Stop Multan Road', 'Lahore  Multan Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Multan Road', '0', '', NULL, '0'),
('719', '732', 'Mansoor &amp; Zahoor Oil Shalimar Link Road', 'Mansoor &amp; Zahoor Oil Shalimar Link Road', 'Lahore  Shalimar Link Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Shalimar Link Road', '0', '', NULL, '0'),
('720', '733', 'Mansoor Bro Oil Store GT Road Okara', 'Mansoor Bro Oil Store GT Road Okara', 'Lahore  Okara', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Okara', '0', '', NULL, '0'),
('721', '734', 'Mansoor Brothers Autos GT Road Okara-LHR', 'Mansoor Brothers Autos GT Road Okara-LHR', 'Lahore  Okara', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Okara', '0', '', NULL, '0'),
('722', '735', 'Mashallah Auto Canal Park Gulberg', 'Mashallah Auto Canal Park Gulberg', 'Lahore  Gulberg', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gulberg', '0', '', NULL, '0'),
('723', '736', 'Mashallah Auto Joher Town', 'Mashallah Auto Joher Town', 'Lahore  Johar Town', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Johar Town', '0', '', NULL, '0'),
('724', '737', 'Master Auto Main Walton Road Cantt Marke', 'Master Auto Main Walton Road Cantt Marke', 'Lahore  Walton Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Walton Road', '0', '', NULL, '0'),
('725', '738', 'Master Autos Walton Road-Lahore', 'Master Autos Walton Road-Lahore', 'Lahore  Walton Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Walton Road', '0', '', NULL, '0'),
('726', '739', 'Meer Autos Gujrat Lahore', 'Meer Autos Gujrat Lahore', 'Lahore  Gujrat', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gujrat', '0', '', NULL, '0'),
('727', '740', 'Mian Auto 326-D Main PIA Road,Johar Town', 'Mian Auto 326-D Main PIA Road,Johar Town', 'Lahore  Johar Town', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Johar Town', '0', '', NULL, '0'),
('728', '741', 'Mian Auto Bhalla Stop Johar Town', 'Mian Auto Bhalla Stop Johar Town', 'Lahore  Johar Town', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Johar Town', '0', '', NULL, '0'),
('729', '742', 'Mian Auto near Wali Hospital Kasoor', 'Mian Auto near Wali Hospital Kasoor', 'Lahore  Qasoor', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Qasoor', '0', '', NULL, '0'),
('730', '743', 'Mian Auto Parts Canda Qila Gujrawala', 'Mian Auto Parts Canda Qila Gujrawala', 'Lahore  Gujranwala', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gujranwala', '0', '', NULL, '0'),
('731', '744', 'Mian Auto Wahdat Road Near Orange Train', 'Mian Auto Wahdat Road Near Orange Train', 'Lahore  Wahdat Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Wahdat Road', '0', '', NULL, '0'),
('732', '745', 'Mian Auto Walton Road', 'Mian Auto Walton Road', 'Lahore  Walton Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Walton Road', '0', '', NULL, '0'),
('733', '746', 'Mian Autos Johar Town-Lahore', 'Mian Autos Johar Town-Lahore', 'Lahore  Johar Town', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Johar Town', '0', '', NULL, '0'),
('734', '747', 'Mian Autos Sabzazar-Lahore', 'Mian Autos Sabzazar-Lahore', 'Lahore  Sabzazar', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Sabzazar', '0', '', NULL, '0'),
('735', '748', 'Mian Bro s Main Boulevard Road Sabzazar', 'Mian Bro s Main Boulevard Road Sabzazar', 'Lahore  Sabzazar', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Sabzazar', '0', '', NULL, '0'),
('736', '749', 'Mian Khalil Autos Bahawalpur Rd-Lahore', 'Mian Khalil Autos Bahawalpur Rd-Lahore', 'Lahore  Bahawalpur Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Bahawalpur Road', '0', '', NULL, '0'),
('737', '750', 'Mian Shuja &amp; Bro Shahdra Chowk-Lahore', 'Mian Shuja &amp; Bro Shahdra Chowk-Lahore', 'Lahore  Shahdra', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Shahdra', '0', '', NULL, '0'),
('738', '751', 'Mian Yaqoob Autos G.T Rd Okara Lhr', 'Mian Yaqoob Autos G.T Rd Okara Lhr', 'Lahore  Okara', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Okara', '0', '', NULL, '0'),
('739', '752', 'Millat Rubber Store-Lahore', 'Millat Rubber Store-Lahore', 'Lahore  ', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  ', '0', '', NULL, '0'),
('740', '753', 'Minhaj Autos Walton Road-Lahore', 'Minhaj Autos Walton Road-Lahore', 'Lahore  Walton Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Walton Road', '0', '', NULL, '0'),
('741', '754', 'Mini Motors Gulberg III-Lahore', 'Mini Motors Gulberg III-Lahore', 'Lahore  Gulberg', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gulberg', '0', '', NULL, '0'),
('742', '755', 'MIR Auto Gujrawala Golden Market', 'MIR Auto Gujrawala Golden Market', 'Lahore  Gujranwala', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gujranwala', '0', '', NULL, '0'),
('743', '756', 'Mirza Auto Store G T Road Gujrat', 'Mirza Auto Store G T Road Gujrat', 'Lahore  Gujrat', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gujrat', '0', '', NULL, '0'),
('744', '757', 'Mobeen Autos Gujranwala Rd Hafizabad-Lhr', 'Mobeen Autos Gujranwala Rd Hafizabad-Lhr', 'Lahore  Hafizabad', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Hafizabad', '0', '', NULL, '0'),
('745', '758', 'Model Lube Shop Allama Iqbal Road', 'Model Lube Shop Allama Iqbal Road', 'Lahore  Iqbal Town', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Iqbal Town', '0', '', NULL, '0'),
('746', '759', 'Modern Auto Workshop Johar Town', 'Modern Auto Workshop Johar Town', 'Lahore  Johar Town', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Johar Town', '0', '', NULL, '0'),
('747', '760', 'Mohsin Autos Johar Town-Lahore', 'Mohsin Autos Johar Town-Lahore', 'Lahore  Johar Town', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Johar Town', '0', '', NULL, '0'),
('748', '761', 'MOON AUTO GANA RAM LAHORE', 'MOON AUTO GANA RAM LAHORE', 'Lahore  Gangaram', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gangaram', '0', '', NULL, '0'),
('749', '762', 'Mother Autos Johar Town-Lahore', 'Mother Autos Johar Town-Lahore', 'Lahore  Johar Town', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Johar Town', '0', '', NULL, '0'),
('750', '763', 'Motor Clean Opposite Packages Mall', 'Motor Clean Opposite Packages Mall', 'Lahore  Pacakages Mall', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Pacakages Mall', '0', '', NULL, '0'),
('751', '764', 'MS Auto Back Side Dayal Singh Mention', 'MS Auto Back Side Dayal Singh Mention', 'Lahore  Dayal Singh Mention', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Dayal Singh Mention', '0', '', NULL, '0'),
('752', '765', 'MSB Motors/Auto Johar Town Lahore', 'MSB Motors/Auto Johar Town Lahore', 'Lahore  Johar Town', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Johar Town', '0', '', NULL, '0'),
('753', '766', 'Mughal Arms Gujranwala Road Hafizabad', 'Mughal Arms Gujranwala Road Hafizabad', 'Lahore  Hafizabad', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Hafizabad', '0', '', NULL, '0'),
('754', '767', 'Mughal Auto Ghazi Road Punjab Society', 'Mughal Auto Ghazi Road Punjab Society', 'Lahore  Punjab Society', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Punjab Society', '0', '', NULL, '0'),
('755', '768', 'Mughal Autos Band Road Lahore', 'Mughal Autos Band Road Lahore', 'Lahore  Band Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Band Road', '0', '', NULL, '0'),
('756', '769', 'Mughal Autos GT Road Gujrat-Lahore', 'Mughal Autos GT Road Gujrat-Lahore', 'Lahore  Gujrat', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gujrat', '0', '', NULL, '0'),
('757', '770', 'Mughal Autos GT Road Okara-Lahore', 'Mughal Autos GT Road Okara-Lahore', 'Lahore  Okara', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Okara', '0', '', NULL, '0'),
('758', '771', 'Mughal Autos Johar Town Lahore', 'Mughal Autos Johar Town Lahore', 'Lahore  Johar Town', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Johar Town', '0', '', NULL, '0'),
('759', '772', 'Mughal Autos Montgomery Road-Lahore', 'Mughal Autos Montgomery Road-Lahore', 'Lahore  Montgomery Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Montgomery Road', '0', '', NULL, '0'),
('760', '773', 'Muhammadan Auto 426 Pak Block Iqbal Town', 'Muhammadan Auto 426 Pak Block Iqbal Town', 'Lahore  Iqbal Town', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Iqbal Town', '0', '', NULL, '0'),
('761', '774', 'Muhammadan Autos Iqbal Town-Lahore', 'Muhammadan Autos Iqbal Town-Lahore', 'Lahore  Iqbal Town', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Iqbal Town', '0', '', NULL, '0'),
('762', '775', 'Multi Autos Gujrat General Bus Stand Lhr', 'Multi Autos Gujrat General Bus Stand Lhr', 'Lahore  Gujrat', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gujrat', '0', '', NULL, '0'),
('763', '776', 'Munawar Sons Chauburji-Lahore', 'Munawar Sons Chauburji-Lahore', 'Lahore  Chauburji', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Chauburji', '0', '', NULL, '0'),
('764', '777', 'N Hydari Auto Main Boulevard Ghazi Road', 'N Hydari Auto Main Boulevard Ghazi Road', 'Lahore  Ghazi Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Ghazi Road', '0', '', NULL, '0'),
('765', '778', 'Nadeem Autos Montgomery Road LHR', 'Nadeem Autos Montgomery Road LHR', 'Lahore  Montgomery Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Montgomery Road', '0', '', NULL, '0'),
('766', '779', 'Naeem &amp; Sons Montgomery', 'Naeem &amp; Sons Montgomery', 'Lahore  Montgomery Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Montgomery Road', '0', '', NULL, '0'),
('767', '780', 'Naeem AM Industries Bilal Ganj-Lahore', 'Naeem AM Industries Bilal Ganj-Lahore', 'Lahore  Bilal Ganj', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Bilal Ganj', '0', '', NULL, '0'),
('768', '781', 'Nasir Auto Montgomery Road LHR', 'Nasir Auto Montgomery Road LHR', 'Lahore  Montgomery Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Montgomery Road', '0', '', NULL, '0'),
('769', '782', 'Nasir Autos Walton Road-Lahore', 'Nasir Autos Walton Road-Lahore', 'Lahore  Walton Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Walton Road', '0', '', NULL, '0'),
('770', '783', 'Nawaz Auto Near Metro Stop Multan Road', 'Nawaz Auto Near Metro Stop Multan Road', 'Lahore  Multan Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Multan Road', '0', '', NULL, '0'),
('771', '784', 'Nazir Autos Montgomery Road-Lahore', 'Nazir Autos Montgomery Road-Lahore', 'Lahore  Montgomery Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Montgomery Road', '0', '', NULL, '0'),
('772', '785', 'New Al Madina Autos Okara-Lahore', 'New Al Madina Autos Okara-Lahore', 'Lahore  Okara', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Okara', '0', '', NULL, '0'),
('773', '786', 'New Bilal Auto GT Road Gujranwala-Lahore', 'New Bilal Auto GT Road Gujranwala-Lahore', 'Lahore  Gujranwala', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gujranwala', '0', '', NULL, '0'),
('774', '787', 'New Khalid Auto Parts Multan Rd-Lahore', 'New Khalid Auto Parts Multan Rd-Lahore', 'Lahore  Multan Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Multan Road', '0', '', NULL, '0'),
('775', '788', 'New Lahore Autos Ferozpur Road-Lahore', 'New Lahore Autos Ferozpur Road-Lahore', 'Lahore  Ferozpur Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Ferozpur Road', '0', '', NULL, '0'),
('776', '789', 'New M.A Electric Store Mughal Centre Lhr', 'New M.A Electric Store Mughal Centre Lhr', 'Lahore  ', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  ', '0', '', NULL, '0'),
('777', '790', 'New Mian Bhai Auto 10-Montgomery Road', 'New Mian Bhai Auto 10-Montgomery Road', 'Lahore  Montgomery Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Montgomery Road', '0', '', NULL, '0'),
('778', '791', 'New Pak Auto P Block Main Sabzazar', 'New Pak Auto P Block Main Sabzazar', 'Lahore  Sabzazar', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Sabzazar', '0', '', NULL, '0'),
('779', '792', 'New Pak Autos Gujrat-Lahore', 'New Pak Autos Gujrat-Lahore', 'Lahore  Gujrat', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gujrat', '0', '', NULL, '0');
INSERT INTO `0_cust_branch` VALUES
('780', '793', 'New Suzuki Centre Montgomery Road Lahore', 'New Suzuki Centre Montgomery Road Lahore', 'Lahore  Montgomery Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Montgomery Road', '0', '', NULL, '0'),
('781', '794', 'Niazi # 99 Bund Road-Lahore', 'Niazi # 99 Bund Road-Lahore', 'Lahore  Band Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Band Road', '0', '', NULL, '0'),
('782', '795', 'Niazi Arms Multan Road-Lahore', 'Niazi Arms Multan Road-Lahore', 'Lahore  Multan Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Multan Road', '0', '', NULL, '0'),
('783', '796', 'Niazi Autos Montgomery Road-Lahore', 'Niazi Autos Montgomery Road-Lahore', 'Lahore  Montgomery Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Montgomery Road', '0', '', NULL, '0'),
('784', '797', 'Noor Autos GT Road Gujrat-Lahore', 'Noor Autos GT Road Gujrat-Lahore', 'Lahore  Gujrat', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gujrat', '0', '', NULL, '0'),
('785', '798', 'Noor Filter House Montgomery Road-Lahore', 'Noor Filter House Montgomery Road-Lahore', 'Lahore  Montgomery Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Montgomery Road', '0', '', NULL, '0'),
('786', '799', 'Norani Autos Multan Road-Lahore', 'Norani Autos Multan Road-Lahore', 'Lahore  Multan Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Multan Road', '0', '', NULL, '0'),
('787', '800', 'Norani Bearing Store-Gujranwala', 'Norani Bearing Store-Gujranwala', 'Lahore  Gujranwala', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gujranwala', '0', '', NULL, '0'),
('788', '801', 'O.R Motors Gurumanget Gulberg-Lahore', 'O.R Motors Gurumanget Gulberg-Lahore', 'Lahore  Gulberg', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gulberg', '0', '', NULL, '0'),
('789', '802', 'P.M Oil Traders Chauburji-Lahore', 'P.M Oil Traders Chauburji-Lahore', 'Lahore  Chauburji', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Chauburji', '0', '', NULL, '0'),
('790', '803', 'Pak auto said pur Multan road', 'Pak auto said pur Multan road', 'Lahore  Multan Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Multan Road', '0', '', NULL, '0'),
('791', '804', 'Pak Auto Store Badar Pura Multan Road', 'Pak Auto Store Badar Pura Multan Road', 'Lahore  Multan Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Multan Road', '0', '', NULL, '0'),
('792', '805', 'Pak Autos Sheikhpura-Lahore', 'Pak Autos Sheikhpura-Lahore', 'Lahore  Sheikhpura', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Sheikhpura', '0', '', NULL, '0'),
('793', '806', 'Pak Madina Autos Sheikhpura Rd-Lahore', 'Pak Madina Autos Sheikhpura Rd-Lahore', 'Lahore  Sheikhpura', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Sheikhpura', '0', '', NULL, '0'),
('794', '807', 'Pak Madina Oil Shadara-Lahore', 'Pak Madina Oil Shadara-Lahore', 'Lahore  Shahdara', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Shahdara', '0', '', NULL, '0'),
('795', '808', 'Pak Motors Rehmat Market-Lahore', 'Pak Motors Rehmat Market-Lahore', 'Lahore  Rehmat Market', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Rehmat Market', '0', '', NULL, '0'),
('796', '809', 'Pak Poshish Sadat Market 8-Montgomery', 'Pak Poshish Sadat Market 8-Montgomery', 'Lahore  Montgomery Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Montgomery Road', '0', '', NULL, '0'),
('797', '810', 'Pakistan Arms Chuburji Centre LHR', 'Pakistan Arms Chuburji Centre LHR', 'Lahore  Chauburji', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Chauburji', '0', '', NULL, '0'),
('798', '811', 'Pakistan Auto Kot Khawaja Saeed', 'Pakistan Auto Kot Khawaja Saeed', 'Lahore  Kot Khawaja Saeed', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Kot Khawaja Saeed', '0', '', NULL, '0'),
('799', '812', 'Pakistan Oil Change Mustafa Town Wahdat', 'Pakistan Oil Change Mustafa Town Wahdat', 'Lahore  Mustafa Town', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Mustafa Town', '0', '', NULL, '0'),
('800', '813', 'Pakistan Oil Change,Go Pump Sabzazar', 'Pakistan Oil Change,Go Pump Sabzazar', 'Lahore  Sabzazar', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Sabzazar', '0', '', NULL, '0'),
('801', '814', 'Pakistan Oil Traders GT Road Gujrat-LHR', 'Pakistan Oil Traders GT Road Gujrat-LHR', 'Lahore  Gujrat', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gujrat', '0', '', NULL, '0'),
('802', '815', 'Paracha Poshish Queens Road', 'Paracha Poshish Queens Road', 'Lahore  Queens Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Queens Road', '0', '', NULL, '0'),
('803', '816', 'Parwaiz Asla Dealer Khachri Bazar Okara', 'Parwaiz Asla Dealer Khachri Bazar Okara', 'Lahore  Okara', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Okara', '0', '', NULL, '0'),
('804', '817', 'Pervez Brothgers &amp; Co Kachehri Road Lhr', 'Pervez Brothgers &amp; Co Kachehri Road Lhr', 'Lahore  Okara', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Okara', '0', '', NULL, '0'),
('805', '818', 'Peshawar Auto Samsani Road Johar Town', 'Peshawar Auto Samsani Road Johar Town', 'Lahore  Johar Town', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Johar Town', '0', '', NULL, '0'),
('806', '819', 'Pioneer Motors Ferozpur Road-Lahore', 'Pioneer Motors Ferozpur Road-Lahore', 'Lahore  Ferozpur Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Ferozpur Road', '0', '', NULL, '0'),
('807', '820', 'Prime Car Care Main Multan Road', 'Prime Car Care Main Multan Road', 'Lahore  Multan Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Multan Road', '0', '', NULL, '0'),
('808', '821', 'Prince Auto Care Abbat Road Lahore', 'Prince Auto Care Abbat Road Lahore', 'Lahore  Montgomery Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Montgomery Road', '0', '', NULL, '0'),
('809', '822', 'Prince Suzuki Center Montgomery Road-LHR', 'Prince Suzuki Center Montgomery Road-LHR', 'Lahore  Montgomery Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Montgomery Road', '0', '', NULL, '0'),
('810', '823', 'Punjab Autos Gold Plaza Gujranwala Lhr', 'Punjab Autos Gold Plaza Gujranwala Lhr', 'Lahore  Gujranwala', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gujranwala', '0', '', NULL, '0'),
('811', '824', 'Punjab Autos Johar Town-Lahore', 'Punjab Autos Johar Town-Lahore', 'Lahore  Johar Town', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Johar Town', '0', '', NULL, '0'),
('812', '825', 'Punjab Autos Qasoor-Lahore', 'Punjab Autos Qasoor-Lahore', 'Lahore  Qasoor', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Qasoor', '0', '', NULL, '0'),
('813', '826', 'Qasim Auto Gulshan E Ravi Near Bund Road', 'Qasim Auto Gulshan E Ravi Near Bund Road', 'Lahore  Band Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Band Road', '0', '', NULL, '0'),
('814', '827', 'Quality Lube Shop Gulberg Lahore', 'Quality Lube Shop Gulberg Lahore', 'Lahore  Gulberg', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gulberg', '0', '', NULL, '0'),
('815', '828', 'Rahim Oil Stor Joher Town', 'Rahim Oil Stor Joher Town', 'Lahore  Johar Town', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Johar Town', '0', '', NULL, '0'),
('816', '829', 'Raja Auto Workshop Faisal Town Lahore', 'Raja Auto Workshop Faisal Town Lahore', 'Lahore  Faisal Town', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Faisal Town', '0', '', NULL, '0'),
('817', '830', 'Rajpoot MOtors Rana Town Lahore', 'Rajpoot MOtors Rana Town Lahore', 'Lahore  Rana Town', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Rana Town', '0', '', NULL, '0'),
('818', '831', 'Rana Asif Autos Iqbal Town-Lahore', 'Rana Asif Autos Iqbal Town-Lahore', 'Lahore  Iqbal Town', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Iqbal Town', '0', '', NULL, '0'),
('819', '832', 'Rana Auto Care WorkShop Gujrnwala-Lahore', 'Rana Auto Care WorkShop Gujrnwala-Lahore', 'Lahore  Gujranwala', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gujranwala', '0', '', NULL, '0'),
('820', '833', 'Rana Autos Johar Town-Lahore', 'Rana Autos Johar Town-Lahore', 'Lahore  Johar Town', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Johar Town', '0', '', NULL, '0'),
('821', '834', 'Rana Autos Multan Road-Lahore', 'Rana Autos Multan Road-Lahore', 'Lahore  Multan Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Multan Road', '0', '', NULL, '0'),
('822', '835', 'Rana Autos Oil Gujranwala-Lahore', 'Rana Autos Oil Gujranwala-Lahore', 'Lahore  Gujranwala', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gujranwala', '0', '', NULL, '0'),
('823', '836', 'Rao Autos Sabzazar Multan Rd-Lahore', 'Rao Autos Sabzazar Multan Rd-Lahore', 'Lahore  Multan Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Multan Road', '0', '', NULL, '0'),
('824', '837', 'Ravi Auto Store Band Raod-Lahore', 'Ravi Auto Store Band Raod-Lahore', 'Lahore  Band Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Band Road', '0', '', NULL, '0'),
('825', '838', 'Razaq Autos Ferozpur Road-Lahore', 'Razaq Autos Ferozpur Road-Lahore', 'Lahore  Ferozpur Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Ferozpur Road', '0', '', NULL, '0'),
('826', '839', 'Rehman Auto Waris Road', 'Rehman Auto Waris Road', 'Lahore  Waris Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Waris Road', '0', '', NULL, '0'),
('827', '840', 'Rehman Autos Ferozpur Road-Lahore', 'Rehman Autos Ferozpur Road-Lahore', 'Lahore  Ferozpur Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Ferozpur Road', '0', '', NULL, '0'),
('828', '841', 'Rehman Autos Johar Town-Lahore', 'Rehman Autos Johar Town-Lahore', 'Lahore  Johar Town', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Johar Town', '0', '', NULL, '0'),
('829', '842', 'Riaz Auto Shahdra Chowk-Lahore', 'Riaz Auto Shahdra Chowk-Lahore', 'Lahore  Shahdara', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Shahdara', '0', '', NULL, '0'),
('830', '843', 'Roa Abdullah Autos  Okara Lahore', 'Roa Abdullah Autos  Okara Lahore', 'Lahore  Okara', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Okara', '0', '', NULL, '0'),
('831', '844', 'Sadiq Autos Gujranwala-Lahore', 'Sadiq Autos Gujranwala-Lahore', 'Lahore  Gujranwala', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gujranwala', '0', '', NULL, '0'),
('832', '845', 'Saeed Suzuki Autos Sabzazar-Lahore', 'Saeed Suzuki Autos Sabzazar-Lahore', 'Lahore  Sabzazar', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Sabzazar', '0', '', NULL, '0'),
('833', '846', 'Saigal Autos Montcomery Road-Lahore', 'Saigal Autos Montcomery Road-Lahore', 'Lahore  Montgomery Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Montgomery Road', '0', '', NULL, '0'),
('834', '847', 'Sajid Autos Gulberg Industrial Area-LHR', 'Sajid Autos Gulberg Industrial Area-LHR', 'Lahore  Gulberg', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gulberg', '0', '', NULL, '0'),
('835', '848', 'Sajjad Auto Super Auto Market Chuburji', 'Sajjad Auto Super Auto Market Chuburji', 'Lahore  Chauburji', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Chauburji', '0', '', NULL, '0'),
('836', '849', 'Sajjad Autos Sheikhpura-Lahore', 'Sajjad Autos Sheikhpura-Lahore', 'Lahore  Sheikhpura', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Sheikhpura', '0', '', NULL, '0'),
('837', '850', 'Saqib Auto Khiyali Bypass Gujrawala', 'Saqib Auto Khiyali Bypass Gujrawala', 'Lahore  Gujranwala', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gujranwala', '0', '', NULL, '0'),
('838', '851', 'Sardar Auto Near PSO Pump Multan Road', 'Sardar Auto Near PSO Pump Multan Road', 'Lahore  Multan Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Multan Road', '0', '', NULL, '0'),
('839', '852', 'Sarwar Oil Store Rasool Park LOS', 'Sarwar Oil Store Rasool Park LOS', 'Lahore  Los', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Los', '0', '', NULL, '0'),
('840', '853', 'Seigal Auto Montgomery Road', 'Seigal Auto Montgomery Road', 'Lahore  Montgomery Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Montgomery Road', '0', '', NULL, '0'),
('841', '854', 'Shafqat Auto Main Montgomery Road-Lahore', 'Shafqat Auto Main Montgomery Road-Lahore', 'Lahore  Montgomery Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Montgomery Road', '0', '', NULL, '0'),
('842', '855', 'Shah Jamal Autos Iqbal Town-Lahore', 'Shah Jamal Autos Iqbal Town-Lahore', 'Lahore  Iqbal Town', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Iqbal Town', '0', '', NULL, '0'),
('843', '856', 'Shah Jee Autos Qasoor-Lahore', 'Shah Jee Autos Qasoor-Lahore', 'Lahore  Qasoor', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Qasoor', '0', '', NULL, '0'),
('844', '857', 'Shah Nafees Auto Waris Road', 'Shah Nafees Auto Waris Road', 'Lahore  Waris Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Waris Road', '0', '', NULL, '0'),
('845', '858', 'Shahbaz Oil Change Tokey Wala Chowk', 'Shahbaz Oil Change Tokey Wala Chowk', 'Lahore  Tokey Wala Chowk', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Tokey Wala Chowk', '0', '', NULL, '0'),
('846', '859', 'Shahid Auto PAk Block Iqbal Town', 'Shahid Auto PAk Block Iqbal Town', 'Lahore  Iqbal Town', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Iqbal Town', '0', '', NULL, '0'),
('847', '860', 'Shahid Bhai Auto Yateem Khana Multan Roa', 'Shahid Bhai Auto Yateem Khana Multan Roa', 'Lahore  Multan Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Multan Road', '0', '', NULL, '0'),
('848', '861', 'Shahzad Autos Johar Town-Lahore', 'Shahzad Autos Johar Town-Lahore', 'Lahore  Johar Town', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Johar Town', '0', '', NULL, '0'),
('849', '862', 'Shalimar Auto Steel Bagh Qasoor', 'Shalimar Auto Steel Bagh Qasoor', 'Lahore  Qasoor', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Qasoor', '0', '', NULL, '0'),
('850', '863', 'Shalimar Autos Qasoor-Lahore', 'Shalimar Autos Qasoor-Lahore', 'Lahore  Qasoor', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Qasoor', '0', '', NULL, '0'),
('851', '864', 'Sharif Autos Qasoor-Lahore', 'Sharif Autos Qasoor-Lahore', 'Lahore  Qasoor', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Qasoor', '0', '', NULL, '0'),
('852', '865', 'Sharjah Oil Harbanspura Canal Park', 'Sharjah Oil Harbanspura Canal Park', 'Lahore  Canal Park', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Canal Park', '0', '', NULL, '0'),
('853', '866', 'Shehnaz &amp; Sons GT Road-Gujranwala', 'Shehnaz &amp; Sons GT Road-Gujranwala', 'Lahore  Gujranwala', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gujranwala', '0', '', NULL, '0'),
('854', '867', 'Sheikh Auto Pak Block Iqbal Town', 'Sheikh Auto Pak Block Iqbal Town', 'Lahore  Iqbal Town', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Iqbal Town', '0', '', NULL, '0'),
('855', '868', 'Sheikh Auto Purana Lari Adda Qasoor', 'Sheikh Auto Purana Lari Adda Qasoor', 'Lahore  Qasoor', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Qasoor', '0', '', NULL, '0'),
('856', '869', 'Sheikh Auto Spare Parts Main Walton Road', 'Sheikh Auto Spare Parts Main Walton Road', 'Lahore  Walton Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Walton Road', '0', '', NULL, '0'),
('857', '870', 'Shenshah Car Poshish Bijli Ghar Stop', 'Shenshah Car Poshish Bijli Ghar Stop', 'Lahore  Sabzazar', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Sabzazar', '0', '', NULL, '0'),
('858', '871', 'Sher E Imam Autos Montgomery  Road Lhr', 'Sher E Imam Autos Montgomery  Road Lhr', 'Lahore  Montgomery Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Montgomery Road', '0', '', NULL, '0'),
('859', '872', 'Sher E Rabani Autos Hafizabad Gujranwala', 'Sher E Rabani Autos Hafizabad Gujranwala', 'Lahore  Gujranwala', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gujranwala', '0', '', NULL, '0'),
('860', '873', 'SKY LINE AUTO SHO[ JOHER TOWN', 'SKY LINE AUTO SHO[ JOHER TOWN', 'Lahore  Johar Town', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Johar Town', '0', '', NULL, '0'),
('861', '874', 'Subhan Auto Battery Gulberg 2 LHR', 'Subhan Auto Battery Gulberg 2 LHR', 'Lahore  Gulberg', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gulberg', '0', '', NULL, '0'),
('862', '875', 'Subhan Auto Gulberg II Lahore', 'Subhan Auto Gulberg II Lahore', 'Lahore  Gulberg', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gulberg', '0', '', NULL, '0'),
('863', '876', 'Subhan Auto Pepsi Road Gulberg III', 'Subhan Auto Pepsi Road Gulberg III', 'Lahore  Gulberg', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gulberg', '0', '', NULL, '0'),
('864', '877', 'Subhan Autos Gulberg ll Lahore', 'Subhan Autos Gulberg ll Lahore', 'Lahore  Gulberg', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gulberg', '0', '', NULL, '0'),
('865', '878', 'Subhan Oil &amp; Auto Sheikhpura Road-Lahore', 'Subhan Oil &amp; Auto Sheikhpura Road-Lahore', 'Lahore  Sheikhpura', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Sheikhpura', '0', '', NULL, '0'),
('866', '879', 'Sun Shine Lube Workshop Walinshia Town', 'Sun Shine Lube Workshop Walinshia Town', 'Lahore  Walansia Town', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Walansia Town', '0', '', NULL, '0'),
('867', '880', 'Suntec Company Gulberg-Lahore', 'Suntec Company Gulberg-Lahore', 'Lahore  Gulberg', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gulberg', '0', '', NULL, '0'),
('868', '881', 'Suzuki Ali Jan Queens Road', 'Suzuki Ali Jan Queens Road', 'Lahore  Queens Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Queens Road', '0', '', NULL, '0'),
('869', '882', 'Suzuki Auto Center Sabzazar-Lahore', 'Suzuki Auto Center Sabzazar-Lahore', 'Lahore  Sabzazar', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Sabzazar', '0', '', NULL, '0'),
('870', '883', 'Suzuki Auto House Auto Gujrawala', 'Suzuki Auto House Auto Gujrawala', 'Lahore  Gujranwala', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gujranwala', '0', '', NULL, '0'),
('871', '884', 'Suzuki Centre Super Market Chauburji Lhr', 'Suzuki Centre Super Market Chauburji Lhr', 'Lahore  Chauburji', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Chauburji', '0', '', NULL, '0'),
('872', '885', 'Suzuki House Gujranwala Road-Lahore', 'Suzuki House Gujranwala Road-Lahore', 'Lahore  Gujranwala', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gujranwala', '0', '', NULL, '0'),
('873', '886', 'Suzuki Motors Diyal Singh-Lahore', 'Suzuki Motors Diyal Singh-Lahore', 'Lahore  Dayal Singh Mention', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Dayal Singh Mention', '0', '', NULL, '0'),
('874', '887', 'Syed Masood Shah Auto Queens Road', 'Syed Masood Shah Auto Queens Road', 'Lahore  Queens Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Queens Road', '0', '', NULL, '0'),
('875', '888', 'T&amp;T AUTOS JOHER TOWN', 'T&amp;T AUTOS JOHER TOWN', 'Lahore  Johar Town', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Johar Town', '0', '', NULL, '0'),
('876', '889', 'Taha Auto Rehman Garden-Lahore', 'Taha Auto Rehman Garden-Lahore', 'Lahore  Rehman Garden', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Rehman Garden', '0', '', NULL, '0'),
('877', '890', 'Tanveer Autos Montgomery Road-Lahore', 'Tanveer Autos Montgomery Road-Lahore', 'Lahore  Montgomery Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Montgomery Road', '0', '', NULL, '0'),
('878', '891', 'Tariq &amp; Sons Auto 6-A Montgomery Road', 'Tariq &amp; Sons Auto 6-A Montgomery Road', 'Lahore  Montgomery Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Montgomery Road', '0', '', NULL, '0'),
('879', '892', 'Tariq Auto Shedewal Johar Town-Lahore', 'Tariq Auto Shedewal Johar Town-Lahore', 'Lahore  Johar Town', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Johar Town', '0', '', NULL, '0'),
('880', '893', 'Tariq Car A/C GT Road Okara-Lahore', 'Tariq Car A/C GT Road Okara-Lahore', 'Lahore  Okara', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Okara', '0', '', NULL, '0'),
('881', '894', 'Tariq Suzuki Autos Johar Town-Lahore', 'Tariq Suzuki Autos Johar Town-Lahore', 'Lahore  Johar Town', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Johar Town', '0', '', NULL, '0'),
('882', '895', 'Tassawur Auto Pepsi Road Gulberg II', 'Tassawur Auto Pepsi Road Gulberg II', 'Lahore  Gulberg', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gulberg', '0', '', NULL, '0'),
('883', '896', 'Techno Auto W/Shop Shahdra Chowk', 'Techno Auto W/Shop Shahdra Chowk', 'Lahore  Shahdra', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Shahdra', '0', '', NULL, '0'),
('884', '897', 'Toyota Cantt Main Walton Road', 'Toyota Cantt Main Walton Road', 'Lahore  Walton Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Walton Road', '0', '', NULL, '0'),
('885', '898', 'Toyota Suzuki House Sheikhpura-Lahore', 'Toyota Suzuki House Sheikhpura-Lahore', 'Lahore  Sheikhpura', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Sheikhpura', '0', '', NULL, '0'),
('886', '899', 'Umar Autos Johar Town-Lahore', 'Umar Autos Johar Town-Lahore', 'Lahore  Johar Town', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Johar Town', '0', '', NULL, '0'),
('887', '900', 'Umer Auto Oil Store Multan Raod Lahore', 'Umer Auto Oil Store Multan Raod Lahore', 'Lahore  Multan Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Multan Road', '0', '', NULL, '0'),
('888', '901', 'Usman Autos Chauburji-Lahore', 'Usman Autos Chauburji-Lahore', 'Lahore  Chauburji', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Chauburji', '0', '', NULL, '0'),
('889', '902', 'Usman Autos Hafizabad-Lahore', 'Usman Autos Hafizabad-Lahore', 'Lahore  Hafizabad', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Hafizabad', '0', '', NULL, '0'),
('890', '903', 'Usman Autos Saddar Bazar Lahore', 'Usman Autos Saddar Bazar Lahore', 'Lahore  Sadar', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Sadar', '0', '', NULL, '0'),
('891', '904', 'Usman Autos Zaki Ada Qasoor Lhr', 'Usman Autos Zaki Ada Qasoor Lhr', 'Lahore  Qasoor', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Qasoor', '0', '', NULL, '0'),
('892', '905', 'Victory Auto 10-Montgomery Road Lahore', 'Victory Auto 10-Montgomery Road Lahore', 'Lahore  Montgomery Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Montgomery Road', '0', '', NULL, '0'),
('893', '906', 'Wahab Auto Pepsi Road Gurumanget Gulberg', 'Wahab Auto Pepsi Road Gurumanget Gulberg', 'Lahore  Gulberg', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gulberg', '0', '', NULL, '0'),
('894', '907', 'Waheed Motors Montgomery Road LHR', 'Waheed Motors Montgomery Road LHR', 'Lahore  Montgomery Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Montgomery Road', '0', '', NULL, '0'),
('895', '908', 'Waqas Auto Canal Bank Hajveri Colony', 'Waqas Auto Canal Bank Hajveri Colony', 'Lahore  Canal Bank', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Canal Bank', '0', '', NULL, '0'),
('896', '909', 'Waqas Autos Gujranwala Rd Hafizabad Lhr', 'Waqas Autos Gujranwala Rd Hafizabad Lhr', 'Lahore  Hafizabad', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Hafizabad', '0', '', NULL, '0'),
('897', '910', 'Yaseen Autos GT Road Gujrat-Lahore', 'Yaseen Autos GT Road Gujrat-Lahore', 'Lahore  Gujrat', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gujrat', '0', '', NULL, '0'),
('898', '911', 'Yousaf Auto Shade Wal Chowk Joher Town', 'Yousaf Auto Shade Wal Chowk Joher Town', 'Lahore  Johar Town', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Johar Town', '0', '', NULL, '0'),
('899', '912', 'ZA Auto Montgomery Road-Lahore', 'ZA Auto Montgomery Road-Lahore', 'Lahore  Montgomery Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Montgomery Road', '0', '', NULL, '0'),
('900', '913', 'Zaheer Autos Multan Road-Lahore', 'Zaheer Autos Multan Road-Lahore', 'Lahore  Multan Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Multan Road', '0', '', NULL, '0'),
('901', '914', 'Zahid Auto Osaka Display Walton Road', 'Zahid Auto Osaka Display Walton Road', 'Lahore  Walton Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Walton Road', '0', '', NULL, '0'),
('902', '915', 'Zahid Mehmood Tools Latif Centre Nishtar', 'Zahid Mehmood Tools Latif Centre Nishtar', 'Lahore  Nishtar Colony', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Nishtar Colony', '0', '', NULL, '0'),
('903', '916', 'Zain Auto near Toyota Motros Walton Lhr', 'Zain Auto near Toyota Motros Walton Lhr', 'Lahore  Walton Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Walton Road', '0', '', NULL, '0'),
('904', '917', 'Zameer Autos Gujranwala-Lahore', 'Zameer Autos Gujranwala-Lahore', 'Lahore  Gujranwala', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gujranwala', '0', '', NULL, '0'),
('905', '918', 'Zeeshan &amp; Co Qasoor-Lahore', 'Zeeshan &amp; Co Qasoor-Lahore', 'Lahore  Qasoor', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Qasoor', '0', '', NULL, '0'),
('906', '919', 'Zeeshan Autos Infentri Road-Lahore', 'Zeeshan Autos Infentri Road-Lahore', 'Lahore  Infentri Road', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Infentri Road', '0', '', NULL, '0'),
('907', '920', 'Zubair Autos Qasoor-Lahore', 'Zubair Autos Qasoor-Lahore', 'Lahore  Qasoor', '3', '5', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Qasoor', '0', '', NULL, '0'),
('908', '921', 'A Y Lube Shop Jorry Pull-Lahore', 'A Y Lube Shop Jorry Pull-Lahore', 'Lahore  Jorry Pull', '3', '6', 'DEF', '1', '', '4510', '1200', '1200', '1', 'Lahore  Jorry Pull', '0', '', NULL, '0'),
('909', '922', 'A.G Auto Bao Wala-Lahore', 'A.G Auto Bao Wala-Lahore', 'Lahore  Bao Wala', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Bao Wala', '0', '', NULL, '0'),
('910', '923', 'A.H Oil Ghazi Abad Near Imran Bakery', 'A.H Oil Ghazi Abad Near Imran Bakery', 'Lahore  Ghazi Abad', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Ghazi Abad', '0', '', NULL, '0'),
('911', '924', 'Abdullah Auto Dera Gujjran-Lahore', 'Abdullah Auto Dera Gujjran-Lahore', 'Lahore  Dera Gujjran', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Dera Gujjran', '0', '', NULL, '0'),
('912', '925', 'Afzal &amp; Sons Sukh Nehar GT Road-Lahore', 'Afzal &amp; Sons Sukh Nehar GT Road-Lahore', 'Lahore  Gt Road', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gt Road', '0', '', NULL, '0'),
('913', '926', 'Ahmed Auto Zone Ali Pur Garden Badian', 'Ahmed Auto Zone Ali Pur Garden Badian', 'Lahore  Ali Pur Garden', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Ali Pur Garden', '0', '', NULL, '0'),
('914', '927', 'Al Awan Auto Jorry Pull-Lahore', 'Al Awan Auto Jorry Pull-Lahore', 'Lahore  Jorry Pull', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Jorry Pull', '0', '', NULL, '0'),
('915', '928', 'Al Aziz Auto Bhatta Chowk-Lahore', 'Al Aziz Auto Bhatta Chowk-Lahore', 'Lahore  Bhatta Chowk', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Bhatta Chowk', '0', '', NULL, '0'),
('916', '929', 'Al Aziz Oil Para Gon Society-Lahore', 'Al Aziz Oil Para Gon Society-Lahore', 'Lahore  Para Gon Society', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Para Gon Society', '0', '', NULL, '0'),
('917', '930', 'Al Fareed Oil Zaitoon Colony Salamat Pur', 'Al Fareed Oil Zaitoon Colony Salamat Pur', 'Lahore  Salamt Pura', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Salamt Pura', '0', '', NULL, '0'),
('918', '931', 'Al Kareem Auto Bhatta Chowk-Lahore', 'Al Kareem Auto Bhatta Chowk-Lahore', 'Lahore  Bhatta Chowk', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Bhatta Chowk', '0', '', NULL, '0'),
('919', '932', 'Al Khair Oil Tajpura-Lahore', 'Al Khair Oil Tajpura-Lahore', 'Lahore  Tajpura', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Tajpura', '0', '', NULL, '0'),
('920', '933', 'Al Kuwait Auto GT Raod-Lahore', 'Al Kuwait Auto GT Raod-Lahore', 'Lahore  Gt Road', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gt Road', '0', '', NULL, '0'),
('921', '934', 'Al Madina Auto 204 Q-Block Defence', 'Al Madina Auto 204 Q-Block Defence', 'Lahore  Defence', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Defence', '0', '', NULL, '0'),
('922', '935', 'Al Madina Auto Bhatta Chowk', 'Al Madina Auto Bhatta Chowk', 'Lahore  Bhatta Chowk', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Bhatta Chowk', '0', '', NULL, '0'),
('923', '936', 'Al Madina Auto near Rangers HQ', 'Al Madina Auto near Rangers HQ', 'Lahore  Bhatta Chowk', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Bhatta Chowk', '0', '', NULL, '0'),
('924', '937', 'Al Rehman Oil Store Mughalpura-Lahore', 'Al Rehman Oil Store Mughalpura-Lahore', 'Lahore  Mughalpura', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Mughalpura', '0', '', NULL, '0'),
('925', '938', 'Al Riaz Oil House Infentri Road-Lahore', 'Al Riaz Oil House Infentri Road-Lahore', 'Lahore  Infentri Road', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Infentri Road', '0', '', NULL, '0'),
('926', '939', 'Al Sadiq Auto Durand Road-Lahore', 'Al Sadiq Auto Durand Road-Lahore', 'Lahore  Durand Road', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Durand Road', '0', '', NULL, '0'),
('927', '940', 'Al Saeed Oil Mew Garden-Lahore', 'Al Saeed Oil Mew Garden-Lahore', 'Lahore  Mew Garden', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Mew Garden', '0', '', NULL, '0'),
('928', '941', 'Ali Auto Sadar Near Dipu Stop-Lahore', 'Ali Auto Sadar Near Dipu Stop-Lahore', 'Lahore  Sadar', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Sadar', '0', '', NULL, '0'),
('929', '942', 'Ali Haider Auto Bao Wala-Lahore', 'Ali Haider Auto Bao Wala-Lahore', 'Lahore  Bao Wala', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Bao Wala', '0', '', NULL, '0'),
('930', '943', 'Ali Hajveri Auto Allama Iqbal Road', 'Ali Hajveri Auto Allama Iqbal Road', 'Lahore  Allama Iqbal Road', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Allama Iqbal Road', '0', '', NULL, '0'),
('931', '944', 'Ali Hajveri Auto Jallo Pind-Lahore', 'Ali Hajveri Auto Jallo Pind-Lahore', 'Lahore  Jallo Pind', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Jallo Pind', '0', '', NULL, '0'),
('932', '945', 'Ali Oil Store Infentri Road-Lahore', 'Ali Oil Store Infentri Road-Lahore', 'Lahore  Infentri Road', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Infentri Road', '0', '', NULL, '0'),
('933', '946', 'Altaf Auto Daroghywala-Lahore', 'Altaf Auto Daroghywala-Lahore', 'Lahore  Daroghywala', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Daroghywala', '0', '', NULL, '0'),
('934', '947', 'Anwar E Sidra Auto Gt Road-Lahore', 'Anwar E Sidra Auto Gt Road-Lahore', 'Lahore  Gt Road', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gt Road', '0', '', NULL, '0'),
('935', '948', 'Auto Speed Infentri Road-Lahore', 'Auto Speed Infentri Road-Lahore', 'Lahore  Infentri Road', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Infentri Road', '0', '', NULL, '0'),
('936', '949', 'Ayesha Auto Gari Shahu-Lahore', 'Ayesha Auto Gari Shahu-Lahore', 'Lahore  Gari Shahu', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gari Shahu', '0', '', NULL, '0'),
('937', '950', 'Aziz Auto Infentry Road Lahore', 'Aziz Auto Infentry Road Lahore', 'Lahore  Infentri Road', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Infentri Road', '0', '', NULL, '0'),
('938', '951', 'Badami Bagh Auto Daroghy Wala-Lahore', 'Badami Bagh Auto Daroghy Wala-Lahore', 'Lahore  Daroghywala', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Daroghywala', '0', '', NULL, '0'),
('939', '952', 'Badami Bagh Auto Jorry Pull-Lahore', 'Badami Bagh Auto Jorry Pull-Lahore', 'Lahore  Jorry Pull', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Jorry Pull', '0', '', NULL, '0'),
('940', '953', 'Basheer &amp; Sons Infentri Road-Lahore', 'Basheer &amp; Sons Infentri Road-Lahore', 'Lahore  Infentri Road', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Infentri Road', '0', '', NULL, '0'),
('941', '954', 'Bilal Auto Bata Pur-Lahore', 'Bilal Auto Bata Pur-Lahore', 'Lahore  Bata Pur', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Bata Pur', '0', '', NULL, '0'),
('942', '955', 'Bilal Auto GT Road-Lahore', 'Bilal Auto GT Road-Lahore', 'Lahore  Gt Road', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gt Road', '0', '', NULL, '0'),
('943', '956', 'Bilal Auto Tajpura-Lahore', 'Bilal Auto Tajpura-Lahore', 'Lahore  Tajpura', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Tajpura', '0', '', NULL, '0'),
('944', '957', 'Billa Auto Bata Pur-Lahore', 'Billa Auto Bata Pur-Lahore', 'Lahore  Bata Pur', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Bata Pur', '0', '', NULL, '0'),
('945', '958', 'Bismillah Auto Bao Wala-Lahore', 'Bismillah Auto Bao Wala-Lahore', 'Lahore  Bao Wala', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Bao Wala', '0', '', NULL, '0'),
('946', '959', 'Bismillah Auto Jorry Pull-Lahore', 'Bismillah Auto Jorry Pull-Lahore', 'Lahore  Jorry Pull', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Jorry Pull', '0', '', NULL, '0'),
('947', '960', 'Bismillah Tyres Pakistan Mint-Lahore', 'Bismillah Tyres Pakistan Mint-Lahore', 'Lahore  Pakistan Mint', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Pakistan Mint', '0', '', NULL, '0'),
('948', '961', 'Butt Auto Barki Road-Lahore', 'Butt Auto Barki Road-Lahore', 'Lahore  Barki Road', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Barki Road', '0', '', NULL, '0'),
('949', '962', 'Butt Auto Para Gon Society-Lahore', 'Butt Auto Para Gon Society-Lahore', 'Lahore  Para Gon Society', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Para Gon Society', '0', '', NULL, '0'),
('950', '963', 'C.P Auto Bao Wala-Lahore', 'C.P Auto Bao Wala-Lahore', 'Lahore  Bao Wala', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Bao Wala', '0', '', NULL, '0'),
('951', '964', 'Car Decoration Bata Pur-Lahore', 'Car Decoration Bata Pur-Lahore', 'Lahore  Bata Pur', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Bata Pur', '0', '', NULL, '0'),
('952', '965', 'Car Mechanic Soutter Mill Mani Road-LHR', 'Car Mechanic Soutter Mill Mani Road-LHR', 'Lahore  Soutter Mill', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Soutter Mill', '0', '', NULL, '0'),
('953', '966', 'Car Point Bhatta Chowk-Lahore', 'Car Point Bhatta Chowk-Lahore', 'Lahore  Bhatta Chowk', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Bhatta Chowk', '0', '', NULL, '0'),
('954', '967', 'Car Saloon Fateh Ghar-Lahore', 'Car Saloon Fateh Ghar-Lahore', 'Lahore  Fateh Ghar', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Fateh Ghar', '0', '', NULL, '0'),
('955', '968', 'Car View Auto Batapur-Lahore', 'Car View Auto Batapur-Lahore', 'Lahore  Bata Pur', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Bata Pur', '0', '', NULL, '0'),
('956', '969', 'Chohan Auto Bao Wala-Lahore', 'Chohan Auto Bao Wala-Lahore', 'Lahore  Bao Wala', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Bao Wala', '0', '', NULL, '0'),
('957', '970', 'City Auto Workshop Airport Chowk-Lahore', 'City Auto Workshop Airport Chowk-Lahore', 'Lahore  Airport Chowk', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Airport Chowk', '0', '', NULL, '0'),
('958', '971', 'Coast To Coast Oil Daroghywala-Lahore', 'Coast To Coast Oil Daroghywala-Lahore', 'Lahore  Daroghywala', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Daroghywala', '0', '', NULL, '0'),
('959', '972', 'DATA Auto GT ROAD LAHORE', 'DATA Auto GT ROAD LAHORE', 'Lahore  Gt Road', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gt Road', '0', '', NULL, '0'),
('960', '973', 'Dawoud Auto Bhatta Chowk-Lahore', 'Dawoud Auto Bhatta Chowk-Lahore', 'Lahore  Bhatta Chowk', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Bhatta Chowk', '0', '', NULL, '0'),
('961', '974', 'Decent Auto Manawan-Lahore', 'Decent Auto Manawan-Lahore', 'Lahore  Manawan', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Manawan', '0', '', NULL, '0'),
('962', '975', 'Defence Auto Bhatta Chowk-Lahore', 'Defence Auto Bhatta Chowk-Lahore', 'Lahore  Bhatta Chowk', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Bhatta Chowk', '0', '', NULL, '0'),
('963', '976', 'Extreme Performance Bhatta Chowk', 'Extreme Performance Bhatta Chowk', 'Lahore  Bhatta Chowk', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Bhatta Chowk', '0', '', NULL, '0'),
('964', '977', 'Faraz Auto GT Road Near Gourmet Resturan', 'Faraz Auto GT Road Near Gourmet Resturan', 'Lahore  Gt Road', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gt Road', '0', '', NULL, '0'),
('965', '978', 'Faridi Auto Daroghy Wala Near Bund Road', 'Faridi Auto Daroghy Wala Near Bund Road', 'Lahore  Daroghywala', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Daroghywala', '0', '', NULL, '0'),
('966', '979', 'Farooq Auto Sadar Near Dipu Stop-Lahore', 'Farooq Auto Sadar Near Dipu Stop-Lahore', 'Lahore  Sadar', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Sadar', '0', '', NULL, '0'),
('967', '980', 'Filter Land Para Gone Society-Lahore', 'Filter Land Para Gone Society-Lahore', 'Lahore  Para Gon Society', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Para Gon Society', '0', '', NULL, '0'),
('968', '981', 'Fine Auto Mew Garden-Lahore', 'Fine Auto Mew Garden-Lahore', 'Lahore  Mew Garden', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Mew Garden', '0', '', NULL, '0'),
('969', '982', 'Fine Oil Land Dhaka Road Sadar-Lahore', 'Fine Oil Land Dhaka Road Sadar-Lahore', 'Lahore  Sadar', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Sadar', '0', '', NULL, '0'),
('970', '983', 'Future Auto Bata Pur-Lahore', 'Future Auto Bata Pur-Lahore', 'Lahore  Bata Pur', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Bata Pur', '0', '', NULL, '0'),
('971', '984', 'Ganj Baksh Auto Opposite UET GT Road', 'Ganj Baksh Auto Opposite UET GT Road', 'Lahore  Gt Road', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gt Road', '0', '', NULL, '0'),
('972', '985', 'Ghousia Auto Durand Road-Lahore', 'Ghousia Auto Durand Road-Lahore', 'Lahore  Durand Road', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Durand Road', '0', '', NULL, '0'),
('973', '986', 'Golden Star Auto Mian Infentry Road Laho', 'Golden Star Auto Mian Infentry Road Laho', 'Lahore  Infentri Road', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Infentri Road', '0', '', NULL, '0'),
('974', '987', 'Habibi Auto New Pull Near Auto Market', 'Habibi Auto New Pull Near Auto Market', 'Lahore  Tajpura', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Tajpura', '0', '', NULL, '0'),
('975', '988', 'Hafiz Oil Store Bahar Shah Road-Lahore', 'Hafiz Oil Store Bahar Shah Road-Lahore', 'Lahore  Bahar Shah Road', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Bahar Shah Road', '0', '', NULL, '0'),
('976', '989', 'Hamdard Auto Bhatta Chowk-Lahore', 'Hamdard Auto Bhatta Chowk-Lahore', 'Lahore  Bhatta Chowk', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Bhatta Chowk', '0', '', NULL, '0'),
('977', '990', 'Hamza Auto Salamat Pura-Lahore', 'Hamza Auto Salamat Pura-Lahore', 'Lahore  Salamt Pura', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Salamt Pura', '0', '', NULL, '0'),
('978', '991', 'Haq Bahu Auto Manawan Bagh Wali Puli', 'Haq Bahu Auto Manawan Bagh Wali Puli', 'Lahore  Manawan', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Manawan', '0', '', NULL, '0'),
('979', '992', 'Hascol Oil Sukh Nehar-Lahore', 'Hascol Oil Sukh Nehar-Lahore', 'Lahore  Gt Road', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gt Road', '0', '', NULL, '0'),
('980', '993', 'Hussain Auto GT Road-Lahore', 'Hussain Auto GT Road-Lahore', 'Lahore  Gt Road', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gt Road', '0', '', NULL, '0'),
('981', '994', 'Hussain Auto Sadar Near Dipu Stop-Lahore', 'Hussain Auto Sadar Near Dipu Stop-Lahore', 'Lahore  Sadar', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Sadar', '0', '', NULL, '0'),
('982', '995', 'I.A Oil Change Bhatta Chowk-Lahore', 'I.A Oil Change Bhatta Chowk-Lahore', 'Lahore  Bhatta Chowk', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Bhatta Chowk', '0', '', NULL, '0'),
('983', '996', 'I.N.H Auto Bhatta Chowk-Lahore', 'I.N.H Auto Bhatta Chowk-Lahore', 'Lahore  Bhatta Chowk', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Bhatta Chowk', '0', '', NULL, '0'),
('984', '997', 'Imran Oil Centre Infentri Road Sadar', 'Imran Oil Centre Infentri Road Sadar', 'Lahore  Infentri Road', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Infentri Road', '0', '', NULL, '0'),
('985', '998', 'Irfan Auto Sadar Dhaka Road-Lahore', 'Irfan Auto Sadar Dhaka Road-Lahore', 'Lahore  Sadar', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Sadar', '0', '', NULL, '0'),
('986', '999', 'Japan Auto Bhatta Chowk-Lahore', 'Japan Auto Bhatta Chowk-Lahore', 'Lahore  Bhatta Chowk', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Bhatta Chowk', '0', '', NULL, '0'),
('987', '1000', 'Japan Auto Mew Garden-Lahore', 'Japan Auto Mew Garden-Lahore', 'Lahore  Mew Garden', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Mew Garden', '0', '', NULL, '0'),
('988', '1001', 'Japan Autos Infentri Road-Lahore', 'Japan Autos Infentri Road-Lahore', 'Lahore  Infentri Road', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Infentri Road', '0', '', NULL, '0'),
('989', '1002', 'Javaid Auto Shadi Pura-Lahore', 'Javaid Auto Shadi Pura-Lahore', 'Lahore  Shadi Pura', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Shadi Pura', '0', '', NULL, '0'),
('990', '1003', 'Junaid Auto Jallo Mor', 'Junaid Auto Jallo Mor', 'Lahore  Jallo Mor', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Jallo Mor', '0', '', NULL, '0'),
('991', '1004', 'Junaid Auto Sadar Dhaka Road-Lahore', 'Junaid Auto Sadar Dhaka Road-Lahore', 'Lahore  Sadar', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Sadar', '0', '', NULL, '0'),
('992', '1005', 'K2S Auto Jallo Pind Near Ghurki Hospital', 'K2S Auto Jallo Pind Near Ghurki Hospital', 'Lahore  Jallo Pind', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Jallo Pind', '0', '', NULL, '0'),
('993', '1006', 'Khan Auto Daroghywala-Lahore', 'Khan Auto Daroghywala-Lahore', 'Lahore  Daroghywala', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Daroghywala', '0', '', NULL, '0'),
('994', '1007', 'Khan Auto Tajpura Near Railway Crossing', 'Khan Auto Tajpura Near Railway Crossing', 'Lahore  Tajpura', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Tajpura', '0', '', NULL, '0'),
('995', '1008', 'Lahore Oil Bao Wala-Lahore', 'Lahore Oil Bao Wala-Lahore', 'Lahore  Bao Wala', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Bao Wala', '0', '', NULL, '0'),
('996', '1009', 'Lahore Oil Gt Road-Lahore', 'Lahore Oil Gt Road-Lahore', 'Lahore  Gt Road', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gt Road', '0', '', NULL, '0'),
('997', '1010', 'M R Oil Change Jorry Pull', 'M R Oil Change Jorry Pull', 'Lahore  Jorry Pull', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Jorry Pull', '0', '', NULL, '0'),
('998', '1011', 'M.R Auto Gt Road-Lahore', 'M.R Auto Gt Road-Lahore', 'Lahore  Gt Road', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gt Road', '0', '', NULL, '0'),
('999', '1012', 'Macca Auto Jorry Pull-Lahore', 'Macca Auto Jorry Pull-Lahore', 'Lahore  Jorry Pull', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Jorry Pull', '0', '', NULL, '0'),
('1000', '1013', 'Madina Auto Badian Road-Lahore', 'Madina Auto Badian Road-Lahore', 'Lahore  Badian ', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badian ', '0', '', NULL, '0'),
('1001', '1014', 'Madina Auto Gari Shahu-Lahore', 'Madina Auto Gari Shahu-Lahore', 'Lahore  Gari Shahu', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gari Shahu', '0', '', NULL, '0'),
('1002', '1015', 'Madina Auto Imamia Colony GT Road-Lahore', 'Madina Auto Imamia Colony GT Road-Lahore', 'Lahore  Gt Road', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gt Road', '0', '', NULL, '0'),
('1003', '1016', 'Malik Auto Jorry Pull-Lahore', 'Malik Auto Jorry Pull-Lahore', 'Lahore  Jorry Pull', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Jorry Pull', '0', '', NULL, '0'),
('1004', '1017', 'Malik Auto Momin Pura-Lahore', 'Malik Auto Momin Pura-Lahore', 'Lahore  Momin Pura', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Momin Pura', '0', '', NULL, '0'),
('1005', '1018', 'Malik Brother Auto Bao Wala-Lahore', 'Malik Brother Auto Bao Wala-Lahore', 'Lahore  Bao Wala', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Bao Wala', '0', '', NULL, '0'),
('1006', '1019', 'MASHALLAH Auto Jallo Pind Ghurki Hospita', 'MASHALLAH Auto Jallo Pind Ghurki Hospita', 'Lahore  Jallo Pind', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Jallo Pind', '0', '', NULL, '0'),
('1007', '1020', 'Mashallah Auto Quaid E Azam Interchange', 'Mashallah Auto Quaid E Azam Interchange', 'Lahore  Quaid E Azam Inerchange', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Quaid E Azam Inerchange', '0', '', NULL, '0'),
('1008', '1021', 'MASHALLAH Auto Tajpura', 'MASHALLAH Auto Tajpura', 'Lahore  Tajpura', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Tajpura', '0', '', NULL, '0'),
('1009', '1022', 'MASHALLAH Oil Change Manawan-Lahore', 'MASHALLAH Oil Change Manawan-Lahore', 'Lahore  Manawan', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Manawan', '0', '', NULL, '0'),
('1010', '1023', 'Master Auto Tajpura-Lahore', 'Master Auto Tajpura-Lahore', 'Lahore  Tajpura', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Tajpura', '0', '', NULL, '0'),
('1011', '1024', 'Master Latif Auto Jallo Pind-Lahore', 'Master Latif Auto Jallo Pind-Lahore', 'Lahore  Jallo Pind', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Jallo Pind', '0', '', NULL, '0'),
('1012', '1025', 'Mehar Auto Workshop Manawan-Lahore', 'Mehar Auto Workshop Manawan-Lahore', 'Lahore  Manawan', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Manawan', '0', '', NULL, '0'),
('1013', '1026', 'Mehar Latif Mehmood Booti Ring Road', 'Mehar Latif Mehmood Booti Ring Road', 'Lahore  Mehmood Booti', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Mehmood Booti', '0', '', NULL, '0'),
('1014', '1027', 'Mian Auto Badian Road-Lahore', 'Mian Auto Badian Road-Lahore', 'Lahore  Badian ', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badian ', '0', '', NULL, '0'),
('1015', '1028', 'Mian Auto Gt Road-Lahore', 'Mian Auto Gt Road-Lahore', 'Lahore  Gt Road', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gt Road', '0', '', NULL, '0'),
('1016', '1029', 'Mian Filter Bata Pur-Lahore', 'Mian Filter Bata Pur-Lahore', 'Lahore  Bata Pur', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Bata Pur', '0', '', NULL, '0'),
('1017', '1030', 'Mian Meer Oil Infentri Road-Lahore', 'Mian Meer Oil Infentri Road-Lahore', 'Lahore  Infentri Road', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Infentri Road', '0', '', NULL, '0'),
('1018', '1031', 'Mian Oil Change Imamia Colony-Lahore', 'Mian Oil Change Imamia Colony-Lahore', 'Lahore  Imamia Colony', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Imamia Colony', '0', '', NULL, '0'),
('1019', '1032', 'Mubashir Khan Oil Tajpura-Lahore', 'Mubashir Khan Oil Tajpura-Lahore', 'Lahore  Tajpura', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Tajpura', '0', '', NULL, '0'),
('1020', '1033', 'Mubashir Oil Allama Iqbal Road-Lahore', 'Mubashir Oil Allama Iqbal Road-Lahore', 'Lahore  Allama Iqbal Road', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Allama Iqbal Road', '0', '', NULL, '0');
INSERT INTO `0_cust_branch` VALUES
('1021', '1034', 'Mubashir Oil Bao Wala-Lahore', 'Mubashir Oil Bao Wala-Lahore', 'Lahore  Bao Wala', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Bao Wala', '0', '', NULL, '0'),
('1022', '1035', 'Muhammadi Oil Change Gari Shahu', 'Muhammadi Oil Change Gari Shahu', 'Lahore  Gari Shahu', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gari Shahu', '0', '', NULL, '0'),
('1023', '1036', 'Mujahid Autos GT Road-Lahore', 'Mujahid Autos GT Road-Lahore', 'Lahore  Gt Road', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gt Road', '0', '', NULL, '0'),
('1024', '1037', 'Mushtaq Autos GT Road-Lahore', 'Mushtaq Autos GT Road-Lahore', 'Lahore  Gt Road', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gt Road', '0', '', NULL, '0'),
('1025', '1038', 'Muzammil Auto Harbanspura-Lahore', 'Muzammil Auto Harbanspura-Lahore', 'Lahore  Harbanspura', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Harbanspura', '0', '', NULL, '0'),
('1026', '1039', 'Nadeem Auto Tajpura-Lahore', 'Nadeem Auto Tajpura-Lahore', 'Lahore  Tajpura', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Tajpura', '0', '', NULL, '0'),
('1027', '1040', 'Najaf Oil Harbanspura-Lahore', 'Najaf Oil Harbanspura-Lahore', 'Lahore  Harbanspura', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Harbanspura', '0', '', NULL, '0'),
('1028', '1041', 'Naveed Auto Tajpura-Lahore', 'Naveed Auto Tajpura-Lahore', 'Lahore  Tajpura', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Tajpura', '0', '', NULL, '0'),
('1029', '1042', 'Nawaz Auto Gt Road-Lahore', 'Nawaz Auto Gt Road-Lahore', 'Lahore  Gt Road', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gt Road', '0', '', NULL, '0'),
('1030', '1043', 'New Al Madina Auto Manawan Hospital', 'New Al Madina Auto Manawan Hospital', 'Lahore  Manawan', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Manawan', '0', '', NULL, '0'),
('1031', '1044', 'New Bismillah Auto Jorry-Lahore', 'New Bismillah Auto Jorry-Lahore', 'Lahore  Jorry Pull', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Jorry Pull', '0', '', NULL, '0'),
('1032', '1045', 'New Friend Auto Daroghywala-Lahore', 'New Friend Auto Daroghywala-Lahore', 'Lahore  Daroghywala', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Daroghywala', '0', '', NULL, '0'),
('1033', '1046', 'New Khan Auto Para Gon Society-Lahore', 'New Khan Auto Para Gon Society-Lahore', 'Lahore  Para Gon Society', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Para Gon Society', '0', '', NULL, '0'),
('1034', '1047', 'New Madni Auto Airport Road Bhatta Chowk', 'New Madni Auto Airport Road Bhatta Chowk', 'Lahore  Bhatta Chowk', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Bhatta Chowk', '0', '', NULL, '0'),
('1035', '1048', 'New Muhammadi Oil Centre Sadar Gol Chakk', 'New Muhammadi Oil Centre Sadar Gol Chakk', 'Lahore  Sadar', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Sadar', '0', '', NULL, '0'),
('1036', '1049', 'New Rafique Auto Mew Garden-Lahore', 'New Rafique Auto Mew Garden-Lahore', 'Lahore  Mew Garden', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Mew Garden', '0', '', NULL, '0'),
('1037', '1050', 'New Safi Mazda Bund Road Daroghywala', 'New Safi Mazda Bund Road Daroghywala', 'Lahore  Daroghywala', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Daroghywala', '0', '', NULL, '0'),
('1038', '1051', 'New Shalimar Oil Gt Road-Lahore', 'New Shalimar Oil Gt Road-Lahore', 'Lahore  Gt Road', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gt Road', '0', '', NULL, '0'),
('1039', '1052', 'New Siddique Auto Taj Pura-Lahore', 'New Siddique Auto Taj Pura-Lahore', 'Lahore  Tajpura', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Tajpura', '0', '', NULL, '0'),
('1040', '1053', 'New Tayyab Auto Kot Khawaja Saeed', 'New Tayyab Auto Kot Khawaja Saeed', 'Lahore  Kot Khawaja Saeed', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Kot Khawaja Saeed', '0', '', NULL, '0'),
('1041', '1054', 'New Umer Oil Store Harbanspura Phatak', 'New Umer Oil Store Harbanspura Phatak', 'Lahore  Harbanspura', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Harbanspura', '0', '', NULL, '0'),
('1042', '1055', 'New Usman Auto Sadar Dhaka Road-Lahore', 'New Usman Auto Sadar Dhaka Road-Lahore', 'Lahore  Sadar', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Sadar', '0', '', NULL, '0'),
('1043', '1056', 'Nisar Sons Jorry Pull-Lahore', 'Nisar Sons Jorry Pull-Lahore', 'Lahore  Jorry Pull', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Jorry Pull', '0', '', NULL, '0'),
('1044', '1057', 'NoShahi Auto Tajpura-Lahore', 'NoShahi Auto Tajpura-Lahore', 'Lahore  Tajpura', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Tajpura', '0', '', NULL, '0'),
('1045', '1058', 'Number Dar Auto Near Rangers HQ', 'Number Dar Auto Near Rangers HQ', 'Lahore  Bhatta Chowk', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Bhatta Chowk', '0', '', NULL, '0'),
('1046', '1059', 'Oil Change Taj Bagh-Lahore', 'Oil Change Taj Bagh-Lahore', 'Lahore  Taj Bagh', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Taj Bagh', '0', '', NULL, '0'),
('1047', '1060', 'P.R.O Lube Shop Barki Road-Lahore', 'P.R.O Lube Shop Barki Road-Lahore', 'Lahore  Bao Wala', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Bao Wala', '0', '', NULL, '0'),
('1048', '1061', 'Pak Madina Oil Allama Iqbal Road-Lahore', 'Pak Madina Oil Allama Iqbal Road-Lahore', 'Lahore  Allama Iqbal Road', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Allama Iqbal Road', '0', '', NULL, '0'),
('1049', '1062', 'PSO Pump Sadar-Lahore', 'PSO Pump Sadar-Lahore', 'Lahore  Sadar', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Sadar', '0', '', NULL, '0'),
('1050', '1063', 'Punjab Oil Jorry Pull-Lahore', 'Punjab Oil Jorry Pull-Lahore', 'Lahore  Jorry Pull', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Jorry Pull', '0', '', NULL, '0'),
('1051', '1064', 'Qasim Auto Badian Road-Lahore', 'Qasim Auto Badian Road-Lahore', 'Lahore  Badian ', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badian ', '0', '', NULL, '0'),
('1052', '1065', 'Qazi Golden Motor Dhaka Road Sadar', 'Qazi Golden Motor Dhaka Road Sadar', 'Lahore  Sadar', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Sadar', '0', '', NULL, '0'),
('1053', '1066', 'Rafai Auto Tajpura Near Railway Crossing', 'Rafai Auto Tajpura Near Railway Crossing', 'Lahore  Tajpura', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Tajpura', '0', '', NULL, '0'),
('1054', '1067', 'Rafaqat Oil GT Road-Lahore', 'Rafaqat Oil GT Road-Lahore', 'Lahore  Gt Road', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gt Road', '0', '', NULL, '0'),
('1055', '1068', 'Rafiq Auto Dharam Pura-Lahore', 'Rafiq Auto Dharam Pura-Lahore', 'Lahore  Dharam Pura', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Dharam Pura', '0', '', NULL, '0'),
('1056', '1069', 'Rafiq Oil Badian Road-Lahore', 'Rafiq Oil Badian Road-Lahore', 'Lahore  Badian ', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badian ', '0', '', NULL, '0'),
('1057', '1070', 'Rehan Auto Sher Shah Road-Lahore', 'Rehan Auto Sher Shah Road-Lahore', 'Lahore  Sher Shah Road', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Sher Shah Road', '0', '', NULL, '0'),
('1058', '1071', 'Royal Auto Harbanspura Railway Crossing', 'Royal Auto Harbanspura Railway Crossing', 'Lahore  Harbanspura', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Harbanspura', '0', '', NULL, '0'),
('1059', '1072', 'Sabir Auto Manawan-Lahore', 'Sabir Auto Manawan-Lahore', 'Lahore  Manawan', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Manawan', '0', '', NULL, '0'),
('1060', '1073', 'Sagheer &amp; Son Auto Harbanspure Near 1122', 'Sagheer &amp; Son Auto Harbanspure Near 1122', 'Lahore  Harbanspura', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Harbanspura', '0', '', NULL, '0'),
('1061', '1074', 'Saleem Auto Bao Wala-Lahore', 'Saleem Auto Bao Wala-Lahore', 'Lahore  Bao Wala', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Bao Wala', '0', '', NULL, '0'),
('1062', '1075', 'Sarwar Lube Shop Allama Iqbal Road', 'Sarwar Lube Shop Allama Iqbal Road', 'Lahore  Allama Iqbal Road', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Allama Iqbal Road', '0', '', NULL, '0'),
('1063', '1076', 'Shafqat Ali Arm Gt Road phatak-Lahore', 'Shafqat Ali Arm Gt Road phatak-Lahore', 'Lahore  Gt Road', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gt Road', '0', '', NULL, '0'),
('1064', '1077', 'Shah G Battery Centre Sadar-Lahore', 'Shah G Battery Centre Sadar-Lahore', 'Lahore  Sadar', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Sadar', '0', '', NULL, '0'),
('1065', '1078', 'Shahbaz Auto Jorry Pull-Lahore', 'Shahbaz Auto Jorry Pull-Lahore', 'Lahore  Jorry Pull', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Jorry Pull', '0', '', NULL, '0'),
('1066', '1079', 'Shahbaz Bro Dhaka Road Sadar Cantt', 'Shahbaz Bro Dhaka Road Sadar Cantt', 'Lahore  Sadar', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Sadar', '0', '', NULL, '0'),
('1067', '1080', 'Shahid Auto Momin Pura Near Daroghy Wala', 'Shahid Auto Momin Pura Near Daroghy Wala', 'Lahore  Daroghywala', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Daroghywala', '0', '', NULL, '0'),
('1068', '1081', 'Shalimar Auto Gt Road-Lahore', 'Shalimar Auto Gt Road-Lahore', 'Lahore  Gt Road', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gt Road', '0', '', NULL, '0'),
('1069', '1082', 'Shalimar Auto Manawan-Lahore', 'Shalimar Auto Manawan-Lahore', 'Lahore  Manawan', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Manawan', '0', '', NULL, '0'),
('1070', '1083', 'Sharif Autos Saddar Bazar Cantt-Lahore', 'Sharif Autos Saddar Bazar Cantt-Lahore', 'Lahore  Sadar', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Sadar', '0', '', NULL, '0'),
('1071', '1084', 'Sheraz Oil Sukh Neahr GT Road-Lahore', 'Sheraz Oil Sukh Neahr GT Road-Lahore', 'Lahore  Gt Road', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gt Road', '0', '', NULL, '0'),
('1072', '1085', 'Siddiqui Auto New Pull Near Auto Market', 'Siddiqui Auto New Pull Near Auto Market', 'Lahore  Tajpura', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Tajpura', '0', '', NULL, '0'),
('1073', '1086', 'Sohni Autos G.T Road Singhpura-Lahore', 'Sohni Autos G.T Road Singhpura-Lahore', 'Lahore  Gt Road', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gt Road', '0', '', NULL, '0'),
('1074', '1087', 'Subhan Auto Islam Park Gt Road-Lahore', 'Subhan Auto Islam Park Gt Road-Lahore', 'Lahore  Gt Road', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gt Road', '0', '', NULL, '0'),
('1075', '1088', 'Subhan Auto Near Jorry Pull-Lahore', 'Subhan Auto Near Jorry Pull-Lahore', 'Lahore  Jorry Pull', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Jorry Pull', '0', '', NULL, '0'),
('1076', '1089', 'Subhan Auto Souter Mill Mani Road-Lahore', 'Subhan Auto Souter Mill Mani Road-Lahore', 'Lahore  Soutter Mill', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Soutter Mill', '0', '', NULL, '0'),
('1077', '1090', 'Sunny Auto GT Road-Lahore', 'Sunny Auto GT Road-Lahore', 'Lahore  Gt Road', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gt Road', '0', '', NULL, '0'),
('1078', '1091', 'Super Car Wash Qalandar Pura-Lahore', 'Super Car Wash Qalandar Pura-Lahore', 'Lahore  Qalandarpura', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Qalandarpura', '0', '', NULL, '0'),
('1079', '1092', 'Syed Auto Bata Pur-Lahore', 'Syed Auto Bata Pur-Lahore', 'Lahore  Bata Pur', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Bata Pur', '0', '', NULL, '0'),
('1080', '1093', 'Tahir Auto Parts Bund Road Daroghy Wala', 'Tahir Auto Parts Bund Road Daroghy Wala', 'Lahore  Daroghywala', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Daroghywala', '0', '', NULL, '0'),
('1081', '1094', 'Taimoor Auto Copper Store-Lahore', 'Taimoor Auto Copper Store-Lahore', 'Lahore  Copper Store', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Copper Store', '0', '', NULL, '0'),
('1082', '1095', 'Taimoor Auto Gt Road-Lahore', 'Taimoor Auto Gt Road-Lahore', 'Lahore  Gt Road', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gt Road', '0', '', NULL, '0'),
('1083', '1096', 'Taj Din Auto GT Road Pso Pump Lahore', 'Taj Din Auto GT Road Pso Pump Lahore', 'Lahore  Gt Road', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gt Road', '0', '', NULL, '0'),
('1084', '1097', 'Tayyeba Lube ShopTufail Road Saddar Cant', 'Tayyeba Lube ShopTufail Road Saddar Cant', 'Lahore  Sadar', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Sadar', '0', '', NULL, '0'),
('1085', '1098', 'Touheed Auto Infentri Road-Lahore', 'Touheed Auto Infentri Road-Lahore', 'Lahore  Infentri Road', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Infentri Road', '0', '', NULL, '0'),
('1086', '1099', 'Umer Oil Centre Airport Road Bhatta Chow', 'Umer Oil Centre Airport Road Bhatta Chow', 'Lahore  Bhatta Chowk', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Bhatta Chowk', '0', '', NULL, '0'),
('1087', '1100', 'Unique Auto 204 DHA Phase I Cantt', 'Unique Auto 204 DHA Phase I Cantt', 'Lahore  Dha  ', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Dha  ', '0', '', NULL, '0'),
('1088', '1101', 'Unique Auto Bhatta Chowk-Lahore', 'Unique Auto Bhatta Chowk-Lahore', 'Lahore  Bhatta Chowk', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Bhatta Chowk', '0', '', NULL, '0'),
('1089', '1102', 'Unique Oil Bhatta Chowk-Lahore', 'Unique Oil Bhatta Chowk-Lahore', 'Lahore  Bhatta Chowk', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Bhatta Chowk', '0', '', NULL, '0'),
('1090', '1103', 'Usama Battaries Centre New Pull Tajpura', 'Usama Battaries Centre New Pull Tajpura', 'Lahore  Tajpura', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Tajpura', '0', '', NULL, '0'),
('1091', '1104', 'Usman Auto Bata Pur-Lahore', 'Usman Auto Bata Pur-Lahore', 'Lahore  Bata Pur', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Bata Pur', '0', '', NULL, '0'),
('1092', '1105', 'Usman Auto Taj Bagh-Lahore', 'Usman Auto Taj Bagh-Lahore', 'Lahore  Taj Bagh', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Taj Bagh', '0', '', NULL, '0'),
('1093', '1106', 'Waheed Auto Daroghy Wala-Lahore', 'Waheed Auto Daroghy Wala-Lahore', 'Lahore  Daroghywala', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Daroghywala', '0', '', NULL, '0'),
('1094', '1107', 'Yaqoob Auto Badian Road-Lahore', 'Yaqoob Auto Badian Road-Lahore', 'Lahore  Badian ', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Badian ', '0', '', NULL, '0'),
('1095', '1108', 'Yaseen Auto Gari Shahu-Lahore', 'Yaseen Auto Gari Shahu-Lahore', 'Lahore  Gari Shahu', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Gari Shahu', '0', '', NULL, '0'),
('1096', '1109', 'Yaseen Oil Store Bund Road Daroghy Wala', 'Yaseen Oil Store Bund Road Daroghy Wala', 'Lahore  Daroghywala', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Daroghywala', '0', '', NULL, '0'),
('1097', '1110', 'Z.A Auto Tajpura-Lahore', 'Z.A Auto Tajpura-Lahore', 'Lahore  Tajpura', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Tajpura', '0', '', NULL, '0'),
('1098', '1111', 'Zeeshan Oil Bhatta Chowk-Lahore', 'Zeeshan Oil Bhatta Chowk-Lahore', 'Lahore  Bhatta Chowk', '3', '6', '001', '2', '', '4510', '1200', '1200', '1', 'Lahore  Bhatta Chowk', '0', '', NULL, '0');

### Structure of table `0_debtor_trans` ###

DROP TABLE IF EXISTS `0_debtor_trans`;

CREATE TABLE `0_debtor_trans` (
  `trans_no` int(11) unsigned NOT NULL DEFAULT 0,
  `type` smallint(6) unsigned NOT NULL DEFAULT 0,
  `version` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `debtor_no` int(11) unsigned NOT NULL,
  `branch_code` int(11) NOT NULL DEFAULT -1,
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `due_date` date NOT NULL DEFAULT '0000-00-00',
  `reference` varchar(60) NOT NULL DEFAULT '',
  `tpe` int(11) NOT NULL DEFAULT 0,
  `order_` int(11) NOT NULL DEFAULT 0,
  `ov_amount` double NOT NULL DEFAULT 0,
  `ov_gst` double NOT NULL DEFAULT 0,
  `ov_freight` double NOT NULL DEFAULT 0,
  `ov_freight_tax` double NOT NULL DEFAULT 0,
  `ov_discount` double NOT NULL DEFAULT 0,
  `alloc` double NOT NULL DEFAULT 0,
  `prep_amount` double NOT NULL DEFAULT 0,
  `rate` double NOT NULL DEFAULT 1,
  `ship_via` int(11) DEFAULT NULL,
  `dimension_id` int(11) NOT NULL DEFAULT 0,
  `dimension2_id` int(11) NOT NULL DEFAULT 0,
  `sales_person` int(11) NOT NULL DEFAULT 0,
  `payment_terms` int(11) DEFAULT NULL,
  `tax_included` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `vehicle_no` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`type`,`trans_no`,`debtor_no`),
  KEY `debtor_no` (`debtor_no`,`branch_code`),
  KEY `tran_date` (`tran_date`),
  KEY `order_` (`order_`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_debtor_trans` ###


### Structure of table `0_debtor_trans_details` ###

DROP TABLE IF EXISTS `0_debtor_trans_details`;

CREATE TABLE `0_debtor_trans_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `debtor_trans_no` int(11) DEFAULT NULL,
  `debtor_trans_type` int(11) DEFAULT NULL,
  `stock_id` varchar(20) NOT NULL DEFAULT '',
  `batch_no` varchar(30) NOT NULL,
  `exp_date` date NOT NULL,
  `description` tinytext DEFAULT NULL,
  `unit_price` double NOT NULL DEFAULT 0,
  `unit_tax` double NOT NULL DEFAULT 0,
  `quantity` double NOT NULL DEFAULT 0,
  `discount_percent` double NOT NULL DEFAULT 0,
  `standard_cost` double NOT NULL DEFAULT 0,
  `qty_done` double NOT NULL DEFAULT 0,
  `src_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `Transaction` (`debtor_trans_type`,`debtor_trans_no`),
  KEY `src_id` (`src_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_debtor_trans_details` ###


### Structure of table `0_debtors_master` ###

DROP TABLE IF EXISTS `0_debtors_master`;

CREATE TABLE `0_debtors_master` (
  `debtor_no` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL DEFAULT '',
  `debtor_ref` varchar(100) NOT NULL,
  `address` tinytext DEFAULT NULL,
  `tax_id` varchar(55) NOT NULL DEFAULT '',
  `trn_id` varchar(60) NOT NULL,
  `curr_code` char(3) NOT NULL DEFAULT '',
  `sales_type` int(11) NOT NULL DEFAULT 1,
  `dimension_id` int(11) NOT NULL DEFAULT 0,
  `dimension2_id` int(11) NOT NULL DEFAULT 0,
  `credit_status` int(11) NOT NULL DEFAULT 0,
  `payment_terms` int(11) DEFAULT NULL,
  `discount` double NOT NULL DEFAULT 0,
  `pymt_discount` double NOT NULL DEFAULT 0,
  `credit_limit` float NOT NULL DEFAULT 1000,
  `notes` tinytext DEFAULT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  `user_id` int(11) NOT NULL,
  PRIMARY KEY (`debtor_no`),
  UNIQUE KEY `debtor_ref` (`debtor_ref`),
  KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=1112 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_debtors_master` ###

INSERT INTO `0_debtors_master` VALUES
('1', 'A.A Joyland (Pvt) Ltd', 'N-0001', 'Karachi', '12-03-9999-431-46', '', 'PKR', '3', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('2', 'Allied Industries Hub (Pvt.) Ltd.', 'N-0002', 'Karachi', '06-01-8545-005-73', '', 'PKR', '3', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('3', 'Ams Industrial &amp; Eng. Co (Htl Express)	', 'N-0003', 'Karachi', '32-77-8761-769-54', '', 'PKR', '3', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('4', 'Greaves Pakistan (Pvt.) Ltd', 'N-0004', 'Karachi', '12-00-8414-002-55', '', 'PKR', '3', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('5', 'Honda Quaideen', 'N-0005', 'Karachi', '', '', 'PKR', '3', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('6', 'Honda South (Private) Limited', 'N-0006', 'Karachi', '17-12-8708-201-91', '', 'PKR', '3', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('7', 'Ideal Power Engineering Services', 'N-0007', 'Karachi', '17-00-1583-755-14', '', 'PKR', '3', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('8', 'Jaffer Brothers (Pvt) Ltd', 'N-0008', 'Karachi', '12-20-9999-028-73', '', 'PKR', '3', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('9', 'Karim Container (Pvt) Ltd', 'N-0009', 'Karachi', '', '', 'PKR', '3', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('10', 'M/ S Honda Drive In', 'N-0010', 'Karachi', '17-00-8711-01-373', '', 'PKR', '3', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('11', 'M/ S Hyundai South', 'N-0011', 'Karachi', '32-77-8761-888-36', '', 'PKR', '3', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('12', 'M/S Advance Colours', 'N-0012', 'Karachi', '32-77-8761-907-46', '', 'PKR', '3', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('13', 'M/S Dewan Motors (Pvt.) Ltd-Bmw', 'N-0013', 'Karachi', '12-00-8703-107-28', '', 'PKR', '3', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('14', 'M/S Dewan Mushtaq Motors Co (Pvt.) Ltd', 'N-0014', 'Karachi', '17-00-8708-004-19', '', 'PKR', '3', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('15', 'M/S Honda Khair (Pvt.) Ltd.', 'N-0015', 'Karachi', '32-77-8761-741-25', '', 'PKR', '3', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('16', 'M/S Kia Motor - South', 'N-0016', 'Karachi', '32-77-8761-721 96', '', 'PKR', '3', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('17', 'M/S Kia Motors Macca', 'N-0017', 'Karachi', '17-00-3816-182-15', '', 'PKR', '3', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('18', 'M/S Loads Limited', 'N-0018', 'Karachi', '02-05-8708-012-64', '', 'PKR', '3', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('19', 'M/S Mandviwala Motors (Private) Ltd', 'N-0019', 'Karachi', '12-00-8703-001-73', '', 'PKR', '3', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('20', 'M/S Mg Centre', 'N-0020', 'Karachi', '32-77-8762-291-91', '', 'PKR', '3', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('21', 'M/S Nabi Qasim Industries (Pvt.) Ltd.', 'N-0021', 'Karachi', '12-00-3000-014-91', '', 'PKR', '3', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('22', 'M/S Naseer Autos', 'N-0022', 'Karachi', '12-00-8703-104-91', '', 'PKR', '3', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('23', 'M/S National Foods Limited', 'N-0023', 'Karachi', '02-01-2000-001-19', '', 'PKR', '3', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('24', 'M/S O &amp; A International', 'N-0024', 'Karachi', '17-12-6200-026-73', '', 'PKR', '3', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('25', 'M/S Phoenix Armour (Pvt.) Ltd', 'N-0025', 'Karachi', '12-00-8512-004-28', '', 'PKR', '3', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('26', 'M/S R M Salt', 'N-0026', 'Karachi', '32-77-8761-164-66', '', 'PKR', '3', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('27', 'M/S Riaz Motors', 'N-0027', 'Karachi', '17-12-8703-005-91', '', 'PKR', '3', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('28', 'M/S Sna Motors', 'N-0028', 'Karachi', '17-12-8703-008-37', '', 'PKR', '3', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('29', 'M/S Suzuki Nadeem International', 'N-0029', 'Karachi', '', '', 'PKR', '3', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('30', 'M/S Toyota Creek Motors (Pvt.) Ltd', 'N-0030', 'Karachi', '17-00-4170-729-19', '', 'PKR', '3', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('31', 'M/S Toyota Highway Motors', 'N-0031', 'Karachi', '17-12-8705-011-55', '', 'PKR', '3', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('32', 'M/S Toyota Society Motors (Pvt.) Ltd.', 'N-0032', 'Karachi', '32-77-8761-698-05', '', 'PKR', '3', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('33', 'M/S Union Fabrics (Pvt.) Ltd', 'N-0033', 'Karachi', '11-00-5208-005-82', '', 'PKR', '3', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('34', 'M/S Toyota Central Motors', 'N-0034', 'Karachi', '12-21-9999-223-37', '', 'PKR', '3', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('35', 'Marshal Traders', 'N-0035', 'Karachi', '17-04-9999-087-82', '', 'PKR', '3', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('36', 'Pak Suzuki Motor Co. Ltd', 'N-0036', 'Karachi', '02-14-8703-001-37', '', 'PKR', '3', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('37', 'Pakistan Petroleum Limited', 'N-0037', 'Karachi', '12-00-27-11-007-73', '', 'PKR', '3', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('38', 'Parson Industries (Pvt) Ltd. - S.I.T.E', 'N-0038', 'Karachi', '', '', 'PKR', '3', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('39', 'Presson Descon Int (Pvt) Ltd', 'N-0039', 'Karachi', '03-01-9999-531-46', '', 'PKR', '3', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('40', 'Quetta Textile Mills Ltd', 'N-0040', 'Karachi', '12-00-5205-021-73', '', 'PKR', '3', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('41', 'R.A Engineering (Pvt.) Ltd', 'N-0041', 'Karachi', '32-77-8761-33-927', '', 'PKR', '3', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('42', 'S.M Jaffer &amp; Company', 'N-0042', 'Karachi', '12-90-9999-925-91', '', 'PKR', '3', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('43', 'Sapphire Textile Mills Ltd', 'N-0043', 'Karachi', '12-06-5205-009-64', '', 'PKR', '3', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('44', 'Specialized Autoparts Ind. (Pvt.) Ltd', 'N-0044', 'Karachi', '17-12-8708-047-64', '', 'PKR', '3', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('45', 'SSGC LPG (Pvt.) Ltd', 'N-0045', 'Karachi', '17-00-3909-035-12', '', 'PKR', '3', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('46', 'Sui Southern Gas Company Ltd', 'N-0046', 'Karachi', '02-04-9028-00-119', '', 'PKR', '3', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('47', 'Taqi &amp; Sons', 'N-0047', 'Karachi', '', '', 'PKR', '3', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('48', 'Technovative Era Pvt Ltd', 'N-0048', 'Karachi', '32-77-8762-060-44', '', 'PKR', '3', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('49', 'Toyota Port Qasim Motors (Pvt) Ltd', 'N-0049', 'Karachi', '32-77-8761-752-70', '', 'PKR', '3', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('50', 'Unregistrator Company Sales Ncpl', 'N-0050', 'Karachi', '', '', 'PKR', '3', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('51', 'Areeb Auto', 'N-0051', 'Hyderabad', '', '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('52', 'Ayan Ali Auto', 'N-0052', 'Hyderabad', '', '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('53', 'Bhitai Auto ', 'N-0053', 'Hyderabad', '', '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('54', 'Data Autos', 'N-0054', 'Hyderabad', '', '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('55', 'Data Body Parts', 'N-0055', 'Hyderabad', '', '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('56', 'Hamza Autos', 'N-0056', 'Hyderabad', '', '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('57', 'Hanif Autos', 'N-0057', 'Hyderabad', '', '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('58', 'Hoorain Auto', 'N-0058', 'Hyderabad', '', '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('59', 'New Data Oil', 'N-0059', 'Hyderabad', '', '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('60', 'Prince Siddiquei  Motor', 'N-0060', 'Hyderabad', '', '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('61', 'qalandri', 'N-0061', 'Hyderabad', '', '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('62', 'Zeeshan Autos ', 'N-0062', 'Hyderabad', '', '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('63', 'B.S Autos', 'N-0063', 'Hyderabad', '', '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('64', 'Hussain Auto', 'N-0064', 'Hyderabad', '', '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('65', 'Leavenge Oil Change', 'N-0065', 'Hyderabad', '', '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('66', 'Muflah Autos', 'N-0066', 'Hyderabad', '', '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('67', 'Quick Oil', 'N-0067', 'Hyderabad', '', '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('68', 'Qureshi Auto', 'N-0068', 'Hyderabad', '', '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('69', 'New Sindh Motor', 'N-0069', 'Hyderabad', '', '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('70', 'Noor Motor', 'N-0070', 'Hyderabad', '', '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('71', 'Akram Auto', 'N-0071', 'Hyderabad', '', '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('72', 'Indus Autos', 'N-0072', 'Hyderabad', '', '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('73', 'Pak Autos', 'N-0073', 'Hyderabad', '', '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('74', 'Shair Khan Autos', 'N-0074', 'Hyderabad', '', '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('75', 'A.R Autos', 'N-0075', 'Hyderabad', '', '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('76', 'Imtiaz Auto', 'N-0076', 'Hyderabad', '', '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('77', 'Khan Auto', 'N-0077', 'Hyderabad', '', '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('78', 'Suzuki Motor High Way', 'N-0078', 'Hyderabad', '', '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('79', 'Kia Motor J', 'N-0079', 'Hyderabad', '', '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('80', 'Bhalai Auto', 'N-0080', 'Hyderabad', '', '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('81', 'J.S Autos', 'N-0081', 'Hyderabad', '', '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('82', 'S.A Malik Autos ', 'N-0082', 'Hyderabad', '', '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('83', 'Al Fazal Auto', 'N-0083', 'Hyderabad', '', '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('84', 'Alam Autos', 'N-0084', 'Hyderabad', '', '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('85', 'Bismillah Auto ', 'N-0085', 'Hyderabad', '', '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('86', 'Bukhari Auto', 'N-0086', 'Hyderabad', '', '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('87', 'National Serhad Auot', 'N-0087', 'Hyderabad', '', '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('88', 'Sheikh Zahoor Oil', 'N-0088', 'Hyderabad', '', '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('89', 'Auto Resq', 'N-0089', 'Hyderabad', '', '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('90', 'Jawaid Autos', 'N-0090', 'Hyderabad', '', '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('91', 'Taj Motor', 'N-0091', 'Hyderabad', '', '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('92', 'Umar Car Ac', 'N-0092', 'Hyderabad', '', '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('93', 'Wel Come Autos', 'N-0093', 'Hyderabad', '', '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('94', 'Ab Jabbar', 'N-0094', 'Hyderabad', '', '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('95', 'Al Noor Autos', 'N-0095', 'Hyderabad', '', '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('96', 'Baloch Auto', 'N-0096', 'Hyderabad', '', '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('97', 'Khiuwaja Rafique', 'N-0097', 'Hyderabad', '', '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('98', 'Qureshi Auto 2', 'N-0098', 'Hyderabad', '', '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('99', 'Jawaid Autos 2', 'N-0099', 'Hyderabad', '', '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('100', 'Wel Come Autos 2', 'N-0100', 'Hyderabad', '', '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('101', 'Mehran Autos', 'N-0101', 'Hyderabad', '', '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('102', 'Sattar Auto Electric', 'N-0102', 'Hyderabad', '', '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('103', 'Shahzad Auto', 'N-0103', 'Hyderabad', '', '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('104', 'Bermati Show Parts', 'N-0104', 'Hyderabad', '', '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('105', 'Faraz Auto', 'N-0105', 'Hyderabad', '', '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('106', 'Fatima Show Parts', 'N-0106', 'Hyderabad', '', '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('107', 'Gulistan Autos', 'N-0107', 'Hyderabad', '', '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('108', 'New Sindh Motor 2', 'N-0108', 'Hyderabad', '', '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('109', 'Sakhi Lal Show Parts', 'N-0109', 'Hyderabad', '', '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('110', 'Shah Autos', 'N-0110', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('111', 'Jahangeri Auto ', 'N-0111', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('112', 'M.Ismail Autos ', 'N-0112', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('113', 'Aslam ', 'N-0113', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('114', 'Hassan Autos -', 'N-0114', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('115', 'Star Auto', 'N-0115', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('116', 'Iqbal Autos ', 'N-0116', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('117', 'Ajmeri Autos ', 'N-0117', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('118', 'Al Hamd', 'N-0118', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('119', 'New Al Mehran Autos', 'N-0119', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('120', 'Saeed Autos', 'N-0120', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('121', 'KPK Autos ', 'N-0121', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('122', 'Bab-e-Khyber Autos', 'N-0122', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('123', 'Rizwan Autos ', 'N-0123', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('124', 'Noor Autos', 'N-0124', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('125', 'Super Autos ', 'N-0125', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('126', 'Abbu Baker', 'N-0126', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('127', 'Al Raza Auto', 'N-0127', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('128', 'Al Reman Autos', 'N-0128', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('129', 'Arsalan Motor', 'N-0129', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('130', 'Auto Mart', 'N-0130', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('131', 'Azhar Autos', 'N-0131', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('132', 'Bilal Motor', 'N-0132', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('133', 'Dubai Autos ', 'N-0133', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('134', 'Faisal Motor', 'N-0134', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('135', 'Fayaz', 'N-0135', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('136', 'Hadi Autos', 'N-0136', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('137', 'Honda Centre ', 'N-0137', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('138', 'Idrees Autos', 'N-0138', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('139', 'Imran', 'N-0139', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('140', 'Imtiaz Autos ', 'N-0140', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('141', 'Iqra Autos', 'N-0141', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('142', 'Junaid Rubber', 'N-0142', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('143', 'Khalique Motor', 'N-0143', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('144', 'Khan Motor', 'N-0144', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('145', 'M.R Auto', 'N-0145', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('146', 'Madina Rubber ', 'N-0146', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('147', 'Mehran Auto', 'N-0147', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('148', 'Missan Bukhari', 'N-0148', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('149', 'Moien Autos', 'N-0149', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('150', 'Nazeer', 'N-0150', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('151', 'Pakistan Rools', 'N-0151', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('152', 'Pervaiz Auto ', 'N-0152', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('153', 'Quality ', 'N-0153', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('154', 'Raza Tools ', 'N-0154', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('155', 'Rehan Autos', 'N-0155', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('156', 'Riaz Lubricant', 'N-0156', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('157', 'Rohan Tools', 'N-0157', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('158', 'Sahfique Autos', 'N-0158', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('159', 'Sattar Autos', 'N-0159', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('160', 'Shafique Autos', 'N-0160', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('161', 'Syed Auto', 'N-0161', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('162', 'Taiwan Auto', 'N-0162', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('163', 'Toyota House ', 'N-0163', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('164', 'Urooj Auto', 'N-0164', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('165', 'Zaib Auto', 'N-0165', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('166', 'Zeeshan Autos  2', 'N-0166', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('167', 'Bilal Autos', 'N-0167', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('168', 'Kazim Autos ', 'N-0168', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('169', 'M.Ayan Autos ', 'N-0169', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('170', 'Makhdoom Fakhro Zaman ', 'N-0170', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('171', 'Tawakal Autos Hala-', 'N-0171', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('172', 'Afridi Autos', 'N-0172', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('173', 'Akbar Autos ', 'N-0173', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('174', 'Arain Autos ', 'N-0174', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('175', 'B.S Autos 2', 'N-0175', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('176', 'Malik Autos ', 'N-0176', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('177', 'Shah Noorani Autos ', 'N-0177', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('178', 'Abbassi Auto', 'N-0178', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('179', 'Karamat Autos', 'N-0179', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('180', 'Madina Autos h', 'N-0180', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('181', 'Madina Autos ', 'N-0181', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('182', 'Mistri Ghulam Rasool', 'N-0182', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('183', 'Naz Autos-Nawabshah', 'N-0183', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('184', 'Sheikh Autos', 'N-0184', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('185', 'Sindh Autos', 'N-0185', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('186', 'Siraj Autos ', 'N-0186', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('187', 'Zakir Hussain ', 'N-0187', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('188', '786 Autos ', 'N-0188', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('189', 'Mashallah Autos', 'N-0189', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('190', 'Ashraf Autos ', 'N-0190', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('191', 'sohail And Adeel', 'N-0191', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('192', 'Sindh Auto', 'N-0192', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('193', 'S.M Tools ', 'N-0193', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('194', 'Shah Noor Autos', 'N-0194', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('195', 'Al Furqan Auto', 'N-0195', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('196', 'Classic Rubber', 'N-0196', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('197', 'Kamran Autos ', 'N-0197', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('198', 'Abdullah Auto ', 'N-0198', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('199', 'Azan Auto', 'N-0199', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('200', 'Kashif Wahid Rubber ', 'N-0200', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('201', 'Amir Autos ', 'N-0201', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('202', 'Abdul Wahab Autos ', 'N-0202', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('203', 'Hussaini Autos', 'N-0203', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('204', 'Al Hydri Mill Store-', 'N-0204', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('205', 'Sindh Machinery ', 'N-0205', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('206', 'Badri Mills', 'N-0206', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('207', 'Vella Mills Stora', 'N-0207', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('208', 'Bohri Mills', 'N-0208', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('209', 'Huzaifa Mill Store ', 'N-0209', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('210', 'Adam Jee Wali Jee ', 'N-0210', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('211', 'Fatima Bearing', 'N-0211', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('212', 'Sharafally Mulla Ahmedji', 'N-0212', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('213', 'Muhammadi Mill Store ', 'N-0213', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('214', 'Ahmed Bux Rahim Bux ', 'N-0214', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('215', 'Mehran Machinery', 'N-0215', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('216', 'Asfand Machinery ', 'N-0216', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('217', 'Fida Hussain Abdul Ali ', 'N-0217', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('218', 'Hussain Armoury', 'N-0218', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('219', 'Alamgir Trader', 'N-0219', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('220', 'Ahmed Ali Shamsuddin', 'N-0220', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('221', 'Yousuf Ali Moosaji ', 'N-0221', 'Hyderabad', '', '', 'PKR', '4', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('222', '786 Auto B Block Model Town-Lahore', 'N-0222', 'Lahore  Model Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('223', '786 Auto Badami Bagh LHR', 'N-0223', 'Lahore  Badami Bagh', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('224', '786 Auto Misri Shah-Lahore', 'N-0224', 'Lahore  Misri Shah', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('225', '786 Auto Motors Model Town-Lahore', 'N-0225', 'Lahore  Model Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('226', 'Aadil Auto Naqi Road Nila Gumbad', 'N-0226', 'Lahore  Nila Gumbad', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('227', 'Aamir Brother Auto,Auto Centre B.Bagh', 'N-0227', 'Lahore  Badami Bagh', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('228', 'Abdul Rehman Auto Badami Bagh', 'N-0228', 'Lahore  Badami Bagh', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('229', 'Abia Motors Auto Centre Badami Bagh', 'N-0229', 'Lahore  Badami Bagh', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('230', 'Abid Auto Badami Bagh-Lahore', 'N-0230', 'Lahore  Badami Bagh', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('231', 'Adil Arms Nila Gumbad-Lahore', 'N-0231', 'Lahore  Nila Gumbad', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('232', 'Adnan Auto,Auto Centre Basement BB', 'N-0232', 'Lahore  Badami Bagh', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('233', 'Adnan Supplier Badami Bagh', 'N-0233', 'Lahore  Badami Bagh', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('234', 'Afia Auto Near Islamia College Sialkot', 'N-0234', 'Lahore  Sialkot', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('235', 'Ahmad Autos Peco Road Lahore', 'N-0235', 'Lahore  Peco Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('236', 'Ahsan Autos Badami Bagh-Lahore', 'N-0236', 'Lahore  Badami Bagh', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('237', 'Akhter Autos Narowal-Lahore', 'N-0237', 'Lahore  Narowal', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('238', 'Al Hadi Auto Badami Bagh-Lahore', 'N-0238', 'Lahore  Badami Bagh', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('239', 'Al Khan Auto Lahore', 'N-0239', 'Lahore  Badami Bagh', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('240', 'Al Madina Auto Shop #1 Peco Road', 'N-0240', 'Lahore  Peco Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('241', 'Al Munir Auto Badami Bagh Lhr', 'N-0241', 'Lahore  Badami Bagh', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('242', 'Al Noor Motors LG 92-93 Auto Centre 2 BB', 'N-0242', 'Lahore  Badami Bagh', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('243', 'Al Wahab Autos Badami Bagh-Lahore', 'N-0243', 'Lahore  Badami Bagh', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('244', 'Al-Waqar Lube Shop-Sargodha', 'N-0244', 'Lahore  Sargodha', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('245', 'Ali Auto Qasoor Centre Badami Bagh', 'N-0245', 'Lahore  Badami Bagh', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('246', 'Ali Usman Auto Badami Bagh', 'N-0246', 'Lahore  Badami Bagh', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('247', 'Altaf Traders 11 Auto Centre Badami Bagh', 'N-0247', 'Lahore  Badami Bagh', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('248', 'Amaan Autos Badami Bagh-Lahore', 'N-0248', 'Lahore  Badami Bagh', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('249', 'Anas Traders Old Anarkali-Lahore', 'N-0249', 'Lahore  Anarkali', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('250', 'Arif Autos A.Block Model Town-Lahore', 'N-0250', 'Lahore  Model Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('251', 'Arshad &amp; Co Arms Nila Gumbad-Lahore', 'N-0251', 'Lahore  Nila Gumbad', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('252', 'Arshad Ali Arms 101 Ravi Road-Lahore', 'N-0252', 'Lahore  Ravi Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('253', 'Arshad Auto Taj Chamber Basement BB', 'N-0253', 'Lahore  Badami Bagh', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('254', 'Asif Auto Green Market Badami Bagh', 'N-0254', 'Lahore  Badami Bagh', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('255', 'Asif Auto Model Town-Lahore', 'N-0255', 'Lahore  Model Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('256', 'Asif Filter Badami Bagh-Lahore', 'N-0256', 'Lahore  Badami Bagh', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('257', 'Auto Centre Shad Bagh Near Allied Bank', 'N-0257', 'Lahore  Shad Bagh', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('258', 'Ayub Arm Misri Shah Ganda Nala-Lahore', 'N-0258', 'Lahore  Misri Shah', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('259', 'Bakhshi Auto Peco Road Kot Lakh Pat', 'N-0259', 'Lahore  Peco Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('260', 'Bakhar Aslah House,Sargodha-Lahore', 'N-0260', 'Lahore  Sargodha', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('261', 'Bilal Autos Badami Bagh-Lahore', 'N-0261', 'Lahore  Badami Bagh', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('262', 'Bismillah Autos Township-Lahore', 'N-0262', 'Lahore  Township', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('263', 'Bismillah Oil Township-Lahore', 'N-0263', 'Lahore  Township', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('264', 'Bukhari Traders Peco Road-Lahore', 'N-0264', 'Lahore  Peco Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('265', 'Buraq Motors Peco Road Kot Lakpat-Lahore', 'N-0265', 'Lahore  Peco Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('266', 'Butt Auto Shad Bagh Near Allied Bank', 'N-0266', 'Lahore  Shad Bagh', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('267', 'Car Care Township Peco Road-Lahore', 'N-0267', 'Lahore  Peco Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('268', 'Chand Terminal Supplier Badami Bagh', 'N-0268', 'Lahore  Badami Bagh', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('269', 'Chaudhry Arms Nila Gumbad Lahore', 'N-0269', 'Lahore  Nila Gumbad', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('270', 'Dar Autos Badami Bagh-Lahore', 'N-0270', 'Lahore  Badami Bagh', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('271', 'Ebba Motors Autos Centre Badami Bagh Lhr', 'N-0271', 'Lahore  Badami Bagh', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('272', 'Ehsan Autos Qadri Chowk Town Ship-Lahore', 'N-0272', 'Lahore  Township', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('273', 'Faisal Supplier Township-Lahore', 'N-0273', 'Lahore  Township', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('274', 'FOCOUS ARMS NILS GUMBAND MALL VIEW LHR', 'N-0274', 'Lahore  Nila Gumbad', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('275', 'Friends Arms', 'N-0275', 'Lahore  Badami Bagh', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('276', 'G.M Autos A-Block Model Town-Lahore', 'N-0276', 'Lahore  Model Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('277', 'Green Autos Badami Bagh-Lahore', 'N-0277', 'Lahore  Badami Bagh', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('278', 'H Hamid&amp;co Pvt (ltd) Mall View LHR', 'N-0278', 'Lahore  Nila Gumbad', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('279', 'Hafiz Traders Badami Bagh Lahore', 'N-0279', 'Lahore  Badami Bagh', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('280', 'Haider Arms Mall View Nila Gumbad', 'N-0280', 'Lahore  Nila Gumbad', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('281', 'Haji Auto Chowk Na Khuda-Lahore', 'N-0281', 'Lahore  Chowk Nakhuda', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('282', 'Haji Jannat Arms 63 Ravi Road-Lahore', 'N-0282', 'Lahore  Ravi Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('283', 'Haji Zar Wali Arms Bhatti Chowk LHR', 'N-0283', 'Lahore  Bhatti Chowk', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('284', 'Hajveri Auot Khokhar Road-Lahore', 'N-0284', 'Lahore  Khokhar Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('285', 'Hamza Autos Model Town-Lahore', 'N-0285', 'Lahore  Model Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('286', 'Hamza Eagle Eye Phase II Badami Bagh', 'N-0286', 'Lahore  Badami Bagh', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('287', 'HANAN TAYYAB AUTO BADAMI BAGH LHR', 'N-0287', 'Lahore  Badami Bagh', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('288', 'Haq Auto Model Town-Lahore', 'N-0288', 'Lahore  Model Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('289', 'Hassan Ali Auto,Auto Centre Badami Bagh', 'N-0289', 'Lahore  Badami Bagh', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('290', 'Hassan Khan Arms Ravi Road-Lahore', 'N-0290', 'Lahore  Ravi Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('291', 'Heera Autos Peco Road-Lahore', 'N-0291', 'Lahore  Peco Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('292', 'Hira Arms Nila Gumbad-Lahore', 'N-0292', 'Lahore  Nila Gumbad', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('293', 'Honda Canal Bank Motor Johar Town-Lahore', 'N-0293', 'Lahore  Johar Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('294', 'Honda City Sale Ferozpur Road Lhr', 'N-0294', 'Lahore  Ferozpur Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('295', 'Honda Fort Pvt Ltd Queen Road-Lahore', 'N-0295', 'Lahore  Queens Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('296', 'Honda Point Pvt Ltd Airport Road-Lahore', 'N-0296', 'Lahore  Airport Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('297', 'Honda Town Ship Peco Road Lahore', 'N-0297', 'Lahore  Peco Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('298', 'Hundai Town Ship Motors Peco Road-Lahore', 'N-0298', 'Lahore  Peco Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('299', 'Hyundai Motors Airport Road Lahore', 'N-0299', 'Lahore  Airport Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('300', 'I.F Suzuki Peco Road-Lahore', 'N-0300', 'Lahore  Peco Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('301', 'Ikhlaq Auto Khalid Centre Township', 'N-0301', 'Lahore  Township', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('302', 'Imran &amp; Co. Arms Nila Gumbad - Lahore', 'N-0302', 'Lahore  Nila Gumbad', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('303', 'Inaam Auto G 39-40 Auto Centre Badami B', 'N-0303', 'Lahore  Badami Bagh', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('304', 'Iqbal Aslah House,Sargodha-Lahore', 'N-0304', 'Lahore  Sargodha', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('305', 'Iqbal Auto Naqi Road Nila Gumbad', 'N-0305', 'Lahore  Nila Gumbad', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('306', 'Ishfaq Auto, Auto Centre Basement B.Bagh', 'N-0306', 'Lahore  Badami Bagh', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('307', 'Isuzu Ravi Motors Tokhar Niaz Baig Lhr', 'N-0307', 'Lahore  Lahore-Branch', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('308', 'Itefaq Autos Peco Road-Lahore', 'N-0308', 'Lahore  Peco Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('309', 'Jabir Khan Arm Ravi Road-Lahore', 'N-0309', 'Lahore  Ravi Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('310', 'Japan Autos Peco Road-Lahore', 'N-0310', 'Lahore  Peco Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('311', 'Javed Sons Qasoor Centre Badami Bagh', 'N-0311', 'Lahore  Badami Bagh', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('312', 'Junaid Autos Q.Block Model Town-Lahore', 'N-0312', 'Lahore  Model Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('313', 'K G N Auto Supply Badami Bagh Lahore', 'N-0313', 'Lahore  Badami Bagh', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('314', 'Kamboo Auto Al Nasir Plaza Badami Bagh', 'N-0314', 'Lahore  Badami Bagh', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('315', 'Kazim Battery Model Town Lahore', 'N-0315', 'Lahore  Model Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('316', 'Khalid Motors Nabi Park-Lahore', 'N-0316', 'Lahore  Nabi Park', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('317', 'Khalid Motors Oil Ravi Road-Lahore', 'N-0317', 'Lahore  Ravi Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('318', 'Khan Arm Misri Shah-Lahore', 'N-0318', 'Lahore  Misri Shah', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('319', 'Khan Brother Aslah Dealer Ravi Road Lhr', 'N-0319', 'Lahore  Ravi Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('320', 'Khan Industries 23/191,Mori Gate-Sialkot', 'N-0320', 'Lahore  Sialkot', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('321', 'Khizar Motor 58-Ravi Road-Lahore', 'N-0321', 'Lahore  Ravi Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('322', 'Khurram Ashraf House No 2 Badami Bagh', 'N-0322', 'Lahore  Badami Bagh', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('323', 'Kia Motors Kings Gate Multan Road LHR', 'N-0323', 'Lahore  Multan Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('324', 'Labaik Petroleum Badami Bagh Lahore', 'N-0324', 'Lahore  Badami Bagh', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('325', 'Lahore Auto Model Town-Lahore', 'N-0325', 'Lahore  Model Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('326', 'Lahore Light Centre 189 Green Market BB', 'N-0326', 'Lahore  Badami Bagh', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('327', 'Lal Din &amp; Sons Badami Bagh Lahore', 'N-0327', 'Lahore  Badami Bagh', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('328', 'Latif Autos Badami Bagh-Lahore', 'N-0328', 'Lahore  Badami Bagh', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('329', 'LDS TRADER BADAMI BAGH LHR', 'N-0329', 'Lahore  Badami Bagh', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('330', 'MG Motors Packages Mall Lahore', 'N-0330', 'Lahore  Mall', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('331', 'M Ali Brothers Badami Bagh', 'N-0331', 'Lahore  Badami Bagh', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('332', 'M.A Autos Model Town-Lahore', 'N-0332', 'Lahore  Model Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('333', 'M.Abbas &amp; Brothers Badami Bagh-Lahore', 'N-0333', 'Lahore  Badami Bagh', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('334', 'M.Anwar-ul-Haq &amp; Sons Nila Gumbad-Lahore', 'N-0334', 'Lahore  Nila Gumbad', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('335', 'M.Iqbal Ishaq Arms Nila Gumbad-Lahore', 'N-0335', 'Lahore  Nila Gumbad', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('336', 'M.T.C Auto,Auto Centre Badami Bagh', 'N-0336', 'Lahore  Badami Bagh', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('337', 'Madina Auto Peco Road-Lahore', 'N-0337', 'Lahore  Peco Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('338', 'Madina Motor Auto Center Badami Bagh-LHR', 'N-0338', 'Lahore  Badami Bagh', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('339', 'Madina Oil Traders Badami Bagh-Lahore', 'N-0339', 'Lahore  Badami Bagh', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('340', 'Madni Auto Khokhar Road Near City Kanta', 'N-0340', 'Lahore  Khokhar Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('341', 'Makkhan Air Gun Block No 5 Lahore', 'N-0341', 'Lahore  Badami Bagh', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('342', 'Makki Oil Traders Peco Road-Lahore', 'N-0342', 'Lahore  Peco Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('343', 'Malik Arm Misri Shah-Lahore', 'N-0343', 'Lahore  Misri Shah', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('344', 'Malik Auto Khokhar Road-Lahore', 'N-0344', 'Lahore  Khokhar Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('345', 'Malik G Auto 516 Main Peco Road', 'N-0345', 'Lahore  Peco Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('346', 'Malik Ji Oil Peco Road-Lahore', 'N-0346', 'Lahore  Peco Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('347', 'Malik Traders Arms Nila Gumbad-Lahore', 'N-0347', 'Lahore  Nila Gumbad', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('348', 'Mansoor Mehboob Autos Model Town Lhr', 'N-0348', 'Lahore  Model Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('349', 'Manzoor Autos Model Town-Lahore', 'N-0349', 'Lahore  Model Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('350', 'Mian Akram Auto Qadri Chowk Township', 'N-0350', 'Lahore  Township', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('351', 'Mian Autos Model Town-Lahore', 'N-0351', 'Lahore  Model Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('352', 'Modern Poshash Badami Bagh-Lahore', 'N-0352', 'Lahore  Badami Bagh', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('353', 'Mohsin Auto Green Market Badami Bagh', 'N-0353', 'Lahore  Badami Bagh', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('354', 'Mokal International Arms Nila Gumbad-LHR', 'N-0354', 'Lahore  Nila Gumbad', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('355', 'Montgomery Autos Township-Lahore', 'N-0355', 'Lahore  Township', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('356', 'Muaz Autos Badami Bagh-Lahore', 'N-0356', 'Lahore  Badami Bagh', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('357', 'Muraad Engineering Co. Johar Town-Lahore', 'N-0357', 'Lahore  Johar Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('358', 'Mueed Saleem MIB Data Centre Kot Lakh Pa', 'N-0358', 'Lahore  Kot Lakh Pat', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('359', 'Mughal Auto G.T Road Mian Channu', 'N-0359', 'Lahore  Mian Channu', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('360', 'Nadeem Auto Badami Bagh', 'N-0360', 'Lahore  Badami Bagh', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('361', 'Naeem Auto Misri Shah-Lahore', 'N-0361', 'Lahore  Misri Shah', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('362', 'Naeem Sons Badami Bagh-Lahore', 'N-0362', 'Lahore  Badami Bagh', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('363', 'Naveed Khan &amp; Co Ravi Road Lahore', 'N-0363', 'Lahore  Ravi Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('364', 'Nazir Arms Ravi Road Lahore', 'N-0364', 'Lahore  Ravi Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('365', 'New Alfalah Autos Ravi Road-Lahore', 'N-0365', 'Lahore  Ravi Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('366', 'New Auto World Qadri Chowk Township', 'N-0366', 'Lahore  Township', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('367', 'New Faiz Lasani Autos Badami Bagh-Lahore', 'N-0367', 'Lahore  Badami Bagh', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0');
INSERT INTO `0_debtors_master` VALUES
('368', 'New Khan Road Runners LTD-Lahore', 'N-0368', 'Lahore  Badami Bagh', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('369', 'New Punjab Auto Model Town-Lahore', 'N-0369', 'Lahore  Model Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('370', 'Nisar Khan Supplier Badami Bagh Lahore', 'N-0370', 'Lahore  Badami Bagh', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('371', 'Noman Auto Badami Bagh Lahore', 'N-0371', 'Lahore  Badami Bagh', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('372', 'Noman Autos Badami Bagh-Lahore', 'N-0372', 'Lahore  Badami Bagh', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('373', 'Orient Trader Mall View Nila Gumbad', 'N-0373', 'Lahore  Nila Gumbad', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('374', 'Pak Auto Agency Badami Bagh', 'N-0374', 'Lahore  Badami Bagh', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('375', 'Pakistan Auto Oil Ravi Road', 'N-0375', 'Lahore  Ravi Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('376', 'Prime Motors Badami Bagh Lahore', 'N-0376', 'Lahore  Badami Bagh', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('377', 'Punjab Filter House Fasilabad', 'N-0377', 'Lahore  Faislabad', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('378', 'Qadria Motor Naqi Road Nila Gumbad', 'N-0378', 'Lahore  Nila Gumbad', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('379', 'Ramzan Auto Ramzan Chamber Badami Bagh', 'N-0379', 'Lahore  Badami Bagh', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('380', 'Rashad Auto A Block Model Town', 'N-0380', 'Lahore  Model Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('381', 'Rashid Arm Mall View Nila Gumbad', 'N-0381', 'Lahore  Nila Gumbad', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('382', 'Ratta Auto Main Peco Road Town Ship', 'N-0382', 'Lahore  Township', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('383', 'Ravi Auto 227-N Block Model Town Ext', 'N-0383', 'Lahore  Model Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('384', 'Rehman Auto Centre Badami Bagh Lhr', 'N-0384', 'Lahore  Badami Bagh', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('385', 'Rehman Autos Qadri Chowk-Lahore', 'N-0385', 'Lahore  Township', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('386', 'Rizwan Oil Store Green Market BB', 'N-0386', 'Lahore  Badami Bagh', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('387', 'Sabri Trading Co. Railway Road-Lahore', 'N-0387', 'Lahore  Railway Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('388', 'Saad Traders Sargodha Road Mianwali', 'N-0388', 'Lahore  Mianwali', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('389', 'Saeed Air Guns Arms Mall View', 'N-0389', 'Lahore  Nila Gumbad', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('390', 'Salman Autos Peco Road-Lahore', 'N-0390', 'Lahore  Peco Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('391', 'Saqib Auto Badami Bagh-Lahore', 'N-0391', 'Lahore  Badami Bagh', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('392', 'Shabir Oil Store Township-Lahore', 'N-0392', 'Lahore  Township', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('393', 'Shah Mehmood Shad Bagh Near Meezan Bank', 'N-0393', 'Lahore  Shad Bagh', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('394', 'Shah Wali &amp; Son Arms New Anarkali-Lahore', 'N-0394', 'Lahore  Anarkali', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('395', 'Shahbaz Autos Badami Bagh-Lahore', 'N-0395', 'Lahore  Badami Bagh', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('396', 'Shahid Sons Autos Badami Bagh-Lahore', 'N-0396', 'Lahore  Badami Bagh', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('397', 'Shaheen Auto Store Narowal-Lahore', 'N-0397', 'Lahore  Narowal', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('398', 'Shakil Autos Badami Bagh-Lahore', 'N-0398', 'Lahore  Badami Bagh', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('399', 'Shalimar Arms Co Mall Road Lahore', 'N-0399', 'Lahore  Mall Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('400', 'Shamim Auto Naqi Road Nila Gumbad', 'N-0400', 'Lahore  Nila Gumbad', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('401', 'Shan Auto Ghory Shah Road-Lahore', 'N-0401', 'Lahore  Ghory Shah', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('402', 'Sheikh Auto New LMC Market Badami Bagh', 'N-0402', 'Lahore  Badami Bagh', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('403', 'Sheikh Autos Qadri Chowk Township-Lahore', 'N-0403', 'Lahore  Township', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('404', 'Sheikh Ehsan Auto Qadri Chowk Township', 'N-0404', 'Lahore  Township', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('405', 'Sheraz Oil Traders New LMC Market BB', 'N-0405', 'Lahore  Badami Bagh', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('406', 'Shoaib Autos Badami Bagh-Lahore', 'N-0406', 'Lahore  Badami Bagh', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('407', 'Sigma Motors DHA Phase 8-Lahore', 'N-0407', 'Lahore  Dha Phase 8', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('408', 'Smart Honda Badian Road Lahore', 'N-0408', 'Lahore  Badian Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('409', 'Sufi Autos Nila Gumbad-Lahore', 'N-0409', 'Lahore  Nila Gumbad', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('410', 'Sunny Autos Peco Road Lahore', 'N-0410', 'Lahore  Peco Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('411', 'Suntec Autos Peco Road-Lahore', 'N-0411', 'Lahore  Peco Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('412', 'Suzuki Canal Motors 13 Km Multan Road', 'N-0412', 'Lahore  Multan Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('413', 'SUZUKI PUNJAB MOTORS 17 KM MULTAN RD LHR', 'N-0413', 'Lahore  Multan Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('414', 'Suzuki Raiwind Motors Raiwind Road LHR', 'N-0414', 'Lahore  Raiwind Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('415', 'Suzuki Summit Motor 16 Km S.Pura Road', 'N-0415', 'Lahore  Sheikhupura Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('431', 'Suzuki Town Ship Motors Peco Road-Lahore', 'N-0416', 'Lahore  Peco Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('432', 'Tariq Motors Badami Bagh-Lahore', 'N-0417', 'Lahore  Badami Bagh', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('433', 'Tayyab Autos Badami Bagh-Lahore', 'N-0418', 'Lahore  Badami Bagh', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('434', 'TM KHAN ARMS RAVI ROAD LAHORE', 'N-0419', 'Lahore  Ravi Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('435', 'Touqeer Auto,Auto Centre Badami Bagh', 'N-0420', 'Lahore  Badami Bagh', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('436', 'Town Autos Peco Road-Lahore', 'N-0421', 'Lahore  Peco Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('437', 'Toyota Garden Motors FerozPur Rd Lhr', 'N-0422', 'Lahore  Ferozpur Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('438', 'Toyota Jinnah Motors FerozPur Rd Lhr', 'N-0423', 'Lahore  Ferozpur Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('439', 'Toyota Motors Airport Road-Lahore', 'N-0424', 'Lahore  Airport Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('440', 'Toyota Ravi Motors Thokar Niaz Baig-LHR', 'N-0425', 'Lahore  Thokar Niaz Baig', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('441', 'Toyota Sahara Motors Jail Road-Lahore', 'N-0426', 'Lahore  Jail Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('442', 'Toyota Town Ship Motors Peco Road-Lahore', 'N-0427', 'Lahore  Peco Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('443', 'Toyota Walton Motor Walton Road-Lahore', 'N-0428', 'Lahore  Walton Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('444', 'UK Motors Ramzan Chamber Badami Bagh', 'N-0429', 'Lahore  Badami Bagh', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('445', 'Umer Brothers Ik Auto Badami Bagh', 'N-0430', 'Lahore  Badami Bagh', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('446', 'Unique Oil Change Peco Road-Lahore', 'N-0431', 'Lahore  Peco Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('447', 'Usman Ali Auto Badami Bagh LHR', 'N-0432', 'Lahore  Badami Bagh', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('448', 'Usman Autos Model Town-Lahore', 'N-0433', 'Lahore  Model Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('449', 'Vital Oil Store Peco Road-Lahore', 'N-0434', 'Lahore  Peco Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('450', 'Wahab Autos Model Town-Lahore', 'N-0435', 'Lahore  Model Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('451', 'Waheed Autos Badami Bagh-Lahore', 'N-0436', 'Lahore  Badami Bagh', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('452', 'Waheed Supplier Badami Bagh-Lahore', 'N-0437', 'Lahore  Badami Bagh', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('453', 'Waqar Autos Badami Bagh-Lahore', 'N-0438', 'Lahore  Badami Bagh', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('454', 'Yaseen Autos Badami Bagh-Lahore', 'N-0439', 'Lahore  Badami Bagh', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('455', 'Younis Arms Nila Gumbad-Lahore', 'N-0440', 'Lahore  Nila Gumbad', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('456', 'Zahid Autos Badami Bagh-Lahore', 'N-0441', 'Lahore  Badami Bagh', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('457', 'Zahid Mehmood Auto Badami Bagh Lahore', 'N-0442', 'Lahore  Badami Bagh', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('458', 'Zaiyad Autos Badami Bagh Lahore', 'N-0443', 'Lahore  Badami Bagh', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('459', '2.S.Motors -Lahore', 'N-0444', 'Johar Town-Lahore', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('460', '786 Auto Motors Montgomery  Road Lahore', 'N-0445', 'Lahore  Montgomery Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('461', '786 Auto Parts Multan Road Lahore', 'N-0446', 'Lahore  Multan Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('462', '786 Montgomery Road Lahore', 'N-0447', 'Lahore  Montgomery Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('463', 'A&amp;N motors w/shop joher town', 'N-0448', 'Lahore  Johar Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('464', 'A.A Auto Main Gulshan E Ravi-Lahore', 'N-0449', 'Lahore  Gulshan E Ravi', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('465', 'A.R Traders GT Road Okara-Lahore', 'N-0450', 'Lahore  Okara', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('466', 'A.S Classic Motors Johar Town-Lahore', 'N-0451', 'Lahore  Johar Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('467', 'AA Cool Centre 65-Kacha Ferozpur LOS', 'N-0452', 'Lahore  Ferozpur Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('468', 'Aamir Auto Main Walto Road Cantt', 'N-0453', 'Lahore  Walton Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('469', 'Aamir Auto Near Pepsi Factory Gulberg 3', 'N-0454', 'Lahore  Gulberg', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('470', 'Abbas Auto Near Canal View Gate-Lahore', 'N-0455', 'Lahore  Canal View', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('471', 'Abdul Rehman Autos Hafizabad-Lahore', 'N-0456', 'Lahore  Hafizabad', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('472', 'Abdul Wahab Auto Sadar Cantt', 'N-0457', 'Lahore  Sadar', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('473', 'Abdullah Auto Baba Market 10 Montgomery', 'N-0458', 'Lahore  Montgomery Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('474', 'Abdullah Auto Montgomery Road Lahore', 'N-0459', 'Lahore  Montgomery Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('475', 'Abdullah Autos Johar Town-Lahore', 'N-0460', 'Lahore  Johar Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('476', 'Abdullah Autos Qasoor-Lahore', 'N-0461', 'Lahore  Qasoor', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('477', 'Abrar Radiator Canal View Multan Road', 'N-0462', 'Lahore  Canal View', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('478', 'ABW Auto Revenue Society Johar Town', 'N-0463', 'Lahore  Johar Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('479', 'Acha Oil Change Mian Sabzazar PSO Pump', 'N-0464', 'Lahore  Sabzazar', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('480', 'Adil Zafar Motors Main Multan Road LHR', 'N-0465', 'Lahore  Multan Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('481', 'Aftab Arms Multan Road Chauburji-Lahore', 'N-0466', 'Lahore  Chauburji', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('482', 'Ahmad Auto 422 Park Iqbal Town', 'N-0467', 'Lahore  Iqbal Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('483', 'Ahmad Autos Gujranwala Hafizabad Lhr', 'N-0468', 'Lahore  Hafizabad', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('484', 'Ahmed Auto Engineering 22/A A.Karim Road', 'N-0469', 'Lahore  Karim Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('485', 'Ahmed Autos Khokha Stop Band Rd-Lahore', 'N-0470', 'Lahore  Band Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('486', 'Ahmed Autos Samnabad-Lahore', 'N-0471', 'Lahore  Samnabad', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('487', 'Ahmed Oil Point Iqbal Town-Lahore', 'N-0472', 'Lahore  Iqbal Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('488', 'Ahmed Oil Store 5 B/b OR Society Johar T', 'N-0473', 'Lahore  Johar Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('489', 'Akeel Auto Queens Road Lhr', 'N-0474', 'Lahore  Queens Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('490', 'Akhtar Saeed Arms Multan Road Lahore', 'N-0475', 'Lahore  Multan Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('491', 'Akram Autos GT Road Okara-Lahore', 'N-0476', 'Lahore  Okara', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('492', 'Akram Radiator Works Gurjranwal - Lhr', 'N-0477', 'Lahore  Gujranwala', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('493', 'Al - Sheikh Autos GT Rd Gujranwala Lhr', 'N-0478', 'Lahore  Gujranwala', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('494', 'Al Akhwan Auto Gt Road-Lahore', 'N-0479', 'Lahore  Gt Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('495', 'Al Aqeel Auto Store Sheikhpura-Lahore', 'N-0480', 'Lahore  Sheikhpura', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('496', 'Al Fazal Auto &amp; Oil Mandi Stop Multan Ro', 'N-0481', 'Lahore  Multan Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('497', 'Al Hafeez Bhola Radiator Sheikhpura-LHR', 'N-0482', 'Lahore  Sheikhpura', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('498', 'Al Hamad Oil Change 12-A Nawab Town', 'N-0483', 'Lahore  Nawab Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('499', 'Al Haram Car Point PIA Housing Society', 'N-0484', 'Lahore  Pia Housing Society', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('500', 'Al Karam Oil Johar Town-Lahore', 'N-0485', 'Lahore  Johar Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('501', 'Al Khair Autos Johar Town-Lahore', 'N-0486', 'Lahore  Johar Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('502', 'Al Madina Oil Store 25 No Stop S.Pura Ro', 'N-0487', 'Lahore  Sheikhupura Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('503', 'Al Madina Oil Store Shahdra-Lahore', 'N-0488', 'Lahore  Shahdara', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('504', 'Al Madina Oil Store Sheikhupura Road Lhr', 'N-0489', 'Lahore  Sheikhupura Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('505', 'Al Makkah Oil Shadara-Lahore', 'N-0490', 'Lahore  Shahdara', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('506', 'Al Makkah Oil Sheikhpura Road-Lahore', 'N-0491', 'Lahore  Sheikhpura', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('507', 'Al Qadri LX 273 Ravi Block AIT', 'N-0492', 'Lahore  Allama Iqbal Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('508', 'Al Qasim Auto Ghazi Road Punjab Society', 'N-0493', 'Lahore  Ghazi Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('509', 'Al Rauf Auto Parts Gujranwala-Lahore', 'N-0494', 'Lahore  Gujranwala', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('510', 'AL Rehman Auto Fsilabad Road Shekhupura', 'N-0495', 'Lahore  Sheikhpura', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('511', 'Al Rehman Auto Plot 6 Wahdat Road', 'N-0496', 'Lahore  Wahdat Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('512', 'Al Riaz Autos Ferozpur Road-Lahore', 'N-0497', 'Lahore  Ferozpur Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('513', 'Al Subhan Autos Gujranwala-Lahore', 'N-0498', 'Lahore  Gujranwala', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('514', 'Alaf Autos Johar Town-Lahore', 'N-0499', 'Lahore  Johar Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('515', 'Alam Oil Store Johar Town-Lahore', 'N-0500', 'Lahore  Johar Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('516', 'Ali Ahmed Autos Gulberg-Lahore', 'N-0501', 'Lahore  Gulberg', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('517', 'Ali Auto Main Gulshan E Ravi-Lahore', 'N-0502', 'Lahore  Gulshan E Ravi', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('518', 'Ali Auto Shade Wal Chowk Joher Town', 'N-0503', 'Lahore  Johar Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('519', 'Ali Baba Decoration Pak Block Iqbal Town', 'N-0504', 'Lahore  Iqbal Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('520', 'Ali Lube Shop Steel Bagh Mor Qasoor', 'N-0505', 'Lahore  Qasoor', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('521', 'Ali Lube Shope Shekhupura', 'N-0506', 'Lahore  Sheikhpura', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('522', 'ALLAH Hu Motor Gulshan E Ravi-Lahore', 'N-0507', 'Lahore  Gulshan E Ravi', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('523', 'Alpha Auto Decoration Gujranwala-Lahore', 'N-0508', 'Lahore  Gujranwala', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('524', 'Altaf Auto Montgomery Road Lahore', 'N-0509', 'Lahore  Montgomery Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('525', 'Amin Sons HardWare Sheikhupura Lahore', 'N-0510', 'Lahore  Sheikhpura', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('526', 'Amir Auto Workshop Canal Park Gulberg 2', 'N-0511', 'Lahore  Gulberg', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('527', 'Amjad Auto Montgomery Road', 'N-0512', 'Lahore  Montgomery Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('528', 'Amjad Autos Patoki-Lahore', 'N-0513', 'Lahore  Patoki', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('529', 'Arsalan &amp; Co Gulberg Lahore', 'N-0514', 'Lahore  Gulberg', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('530', 'Asad Auto Oil Pak Block Iqbal Town', 'N-0515', 'Lahore  Iqbal Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('531', 'Ashfaq Autos Lari Adda Qasoor Lhr', 'N-0516', 'Lahore  Qasoor', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('532', 'Ashraf Auto Pak Block Iqbal Town', 'N-0517', 'Lahore  Iqbal Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('533', 'Asif Auto Parts Gurumanget Gulberg III', 'N-0518', 'Lahore  Gulberg', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('534', 'Asif Auto Spare Parts Gujrawala', 'N-0519', 'Lahore  Gujranwala', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('535', 'Asif Autos Sheikhpura Road-Lahore', 'N-0520', 'Lahore  Sheikhupura Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('536', 'Asif Battery Autos Gulberg ll lahore', 'N-0521', 'Lahore  Gulberg', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('537', 'Asif Oil Change Kacha Ferozpur Road', 'N-0522', 'Lahore  Ferozpur Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('538', 'Atteeq Oil Faisalabad Rd Sheikhupura Lhr', 'N-0523', 'Lahore  Sheikhpura', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('539', 'AUTO BANK SHEIKHUPURA', 'N-0524', 'Lahore  Sheikhupura ', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('540', 'Auto Care Clinic Wahdat Road-Lahore', 'N-0525', 'Lahore  Wahadat Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('541', 'Auto Centre 35/B Faisal Town Opp Kotha', 'N-0526', 'Lahore  Faisal Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('542', 'Auto Club Walton Road-Lahore', 'N-0527', 'Lahore  Walton Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('543', 'Auto Expert 6 Rasool Park LOS-Lahore', 'N-0528', 'Lahore  Rasool Park', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('544', 'Auto King Oil Store Johar Town-Lahore', 'N-0529', 'Lahore  Johar Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('545', 'Auto Solutions 8-Montgomery Road', 'N-0530', 'Lahore  Montgomery Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('546', 'Auto Spot PIA Society Near Goga Neelam', 'N-0531', 'Lahore  Pia Housing Society', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('547', 'Auto Zone Spare Parts Gujrawala', 'N-0532', 'Lahore  Gujranwala', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('548', 'Awami Autos Gulberg-Lahore', 'N-0533', 'Lahore  Gulberg', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('549', 'Awan Autos Gujranwala-Lahore', 'N-0534', 'Lahore  Gujranwala', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('550', 'Awan Autos Gulberg-Lahore', 'N-0535', 'Lahore  Gulberg', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('551', 'Awan Autos Khark Nala Multan Road-Lahore', 'N-0536', 'Lahore  Multan Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('552', 'Awan Autos Okara-Lahore', 'N-0537', 'Lahore  Okara', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('553', 'Azaan Oil Change 32-29 Islamia Park LOS', 'N-0538', 'Lahore  Los', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('554', 'Azeem Electronics Data Market Hall Road', 'N-0539', 'Lahore  Hall Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('555', 'Babar Motors Montgomery Road', 'N-0540', 'Lahore  Montgomery Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('556', 'Babar Oil Store GT Road Okara-Lahore', 'N-0541', 'Lahore  Okara', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('557', 'Badami Bagh Autos Iqbal Town-Lahore', 'N-0542', 'Lahore  Iqbal Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('558', 'Bahoo Autos Sabzazar-Lahore', 'N-0543', 'Lahore  Sabzazar', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('559', 'Bari Auto Work Shop Iqbal Town Lahore', 'N-0544', 'Lahore  Iqbal Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('560', 'Barkat Auto Lariada Okara', 'N-0545', 'Lahore  Okara', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('561', 'Basra Enterprises 5-a Montgomery Park', 'N-0546', 'Lahore  Montgomery Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('562', 'Bhatti Autos Jia Moosa Lahore', 'N-0547', 'Lahore  Jia Moosa', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('563', 'Bismillah Arms Shop Hafizabad-Lahore', 'N-0548', 'Lahore  Hafizabad', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('564', 'Bismillah Auto Gulberg 2 LHR', 'N-0549', 'Lahore  Gulberg', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('565', 'Bismillah Auto Jinnah Chowk Hafizabad', 'N-0550', 'Lahore  Hafizabad', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('566', 'Bismillah Auto Parts Barkat Town GT Road', 'N-0551', 'Lahore  Barkat Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('567', 'Bismillah Auto Scheme Mor Iqbal Town', 'N-0552', 'Lahore  Iqbal Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('568', 'Bismillah Auto Shade Wal Chowk J.T', 'N-0553', 'Lahore  Johar Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('569', 'Bismillah Auto Spare Parts Kala Khtatai', 'N-0554', 'Lahore  Kala Khatai', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('570', 'Bismillah Autos Chauburji-Lahore', 'N-0555', 'Lahore  Chauburji', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('571', 'Bismillah Autos Diyal Singh-Lahore', 'N-0556', 'Lahore  Dayal Singh Mention', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('572', 'Bismillah Autos Gulberg Lll Lahore', 'N-0557', 'Lahore  Gulberg', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('573', 'Bismillah Rehman Autos Faisal Town Lhr', 'N-0558', 'Lahore  Faisal Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('574', 'BM Auto Decoration H Block Bijli Ghr', 'N-0559', 'Lahore  Sabzazar', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('575', 'Bobi Auto Allam Iqbal Road-Lahore', 'N-0560', 'Lahore  Allama Iqbal Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('576', 'Bright Autos Qasoor-Lahore', 'N-0561', 'Lahore  Qasoor', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('577', 'Brother Auto Imamia Colony Phatak GT Roa', 'N-0562', 'Lahore  Gt Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('578', 'Brother Auto Joher Town', 'N-0563', 'Lahore  Johar Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('579', 'Butt Auto Store Rasheed Plaza Sabzazar', 'N-0564', 'Lahore  Sabzazar', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('580', 'Butt Autos Band Road Lahore', 'N-0565', 'Lahore  Band Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('581', 'Butt Autos G.T Road Okara Lahore', 'N-0566', 'Lahore  Okara', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('582', 'Butt Oil 308 Kalma Chowk Near Silk Bank', 'N-0567', 'Lahore  Kalma Chowk', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('583', 'Butt Rubber Decor Masjid Market Montgome', 'N-0568', 'Lahore  Montgomery Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('584', 'Caltex Auto Care Sheikhpura-Lahore', 'N-0569', 'Lahore  Sheikhpura', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('585', 'Cantt Autos Walton Road-Lahore', 'N-0570', 'Lahore  Walton Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('586', 'Car Care 8-C Nawab Town Raiwind Road', 'N-0571', 'Lahore  Nawab Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('587', 'Car Help Line 150 Garden Block Garden T', 'N-0572', 'Lahore  Garden Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('588', 'Ch.Faiz Oil Auto Store Montgomery Rd-LHR', 'N-0573', 'Lahore  Montgomery Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('589', 'Channo Auto Chughtai Market 10 Montgomer', 'N-0574', 'Lahore  Montgomery Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('590', 'Chaudhary Auto G T Toad Gujrat', 'N-0575', 'Lahore  Gujrat', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('591', 'Chaudhary Auto Opp Packages Mall Walton', 'N-0576', 'Lahore  Walton Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('592', 'Chaudhary Auto Store 17-A Montgomery Roa', 'N-0577', 'Lahore  Montgomery Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('593', 'Chaudhary Auto Wahdat Road Iqbal Town', 'N-0578', 'Lahore  Iqbal Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('594', 'Chaudhary Oil Store 14 Km Multan Road', 'N-0579', 'Lahore  Multan Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('595', 'Chaudhry Arms Dealer Qasoor-Lahore', 'N-0580', 'Lahore  Qasoor', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('596', 'Chaudhry Arms Gulberg III-Lahore', 'N-0581', 'Lahore  Gulberg', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('597', 'Chaudhry Autos G T Road Okara', 'N-0582', 'Lahore  Okara', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('598', 'Chaudhry Autos-Gujranwala', 'N-0583', 'Lahore  Gujranwala', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('599', 'Chaudhry Car Clinic Karim Block Iqbal To', 'N-0584', 'Lahore  Iqbal Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('600', 'Cheema Oil 45-A Revenue Society Johar.T', 'N-0585', 'Lahore  Johar Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('601', 'Chevrolet Platinum Abbat Road-Lahore', 'N-0586', 'Lahore  Abbat Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('602', 'City Autos Multan Road Patoki-Lahore', 'N-0587', 'Lahore  Patoki', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('603', 'City Car Care 25 No.Stop-Lahore', 'N-0588', 'Lahore  Shahdra', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('604', 'Crystal Autos GT Road Gujrat-Lahore', 'N-0589', 'Lahore  Gujrat', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('605', 'Danewal Auto Wahdat Road', 'N-0590', 'Lahore  Wahdat Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('606', 'Dar Lube Naqsha Stop Wahdat Road', 'N-0591', 'Lahore  Wahdat Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('607', 'Data Oil Store Faisal Town Lahore', 'N-0592', 'Lahore  Faisal Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('608', 'Dawn Motors 17-A Montgomery Road', 'N-0593', 'Lahore  Montgomery Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('609', 'Dildar Oil Montgomery Road-Lahore', 'N-0594', 'Lahore  Montgomery Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('610', 'Doctor Auto Main Gulshan E Ravi', 'N-0595', 'Lahore  Gulshan E Ravi', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('611', 'Dogar Oil Store Gulshan E Ravi-Lahore', 'N-0596', 'Lahore  Gulshan E Ravi', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('612', 'Dubai Autos Band Road Lahore', 'N-0597', 'Lahore  Band Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('613', 'Elahi Oil Store GT Road-Okara', 'N-0598', 'Lahore  Okara', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('614', 'Ettehad Auto Chowk Beighum Kot-Lahore', 'N-0599', 'Lahore  Beighum Kot', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('615', 'Ettehad Auto Ghazi Road Punjab Society', 'N-0600', 'Lahore  Punjab Society', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('616', 'Express Auto Johar Town Lahore', 'N-0601', 'Lahore  Johar Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('617', 'Fahad Auto Montgomery Road Lahore', 'N-0602', 'Lahore  Montgomery Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('618', 'Faisal Movers Bund Road Lahore', 'N-0603', 'Lahore  Band Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('619', 'Faisal Movers Bund Road Near Abdullah Tr', 'N-0604', 'Lahore  Band Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('620', 'Faizan Auto Spare Parts Walton Road', 'N-0605', 'Lahore  Walton Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('621', 'Faizan E Muhammadi Oil LOS Samanabad', 'N-0606', 'Lahore  Samnabad', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('622', 'Fareed Khan Lodhi Oil G.T Rd Okara Lhr', 'N-0607', 'Lahore  Okara', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('623', 'Farooq Brother G.T Road Gujranwala-Lahor', 'N-0608', 'Lahore  Gujranwala', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('624', 'Fazal Autos Wahdat Road-Lahore', 'N-0609', 'Lahore  Wahadat Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('625', 'Fiazan Auto Spare Parts Walton  Road', 'N-0610', 'Lahore  Walton Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('626', 'Fine Auto main Market Gulberg Lhr', 'N-0611', 'Lahore  Gulberg', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('627', 'Fine Autos Gulberg ll Lahore', 'N-0612', 'Lahore  Gulberg', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('628', 'Finish Line Autos Multan Road Lhr', 'N-0613', 'Lahore  Multan Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('629', 'Five Star Work Shop Joher Town', 'N-0614', 'Lahore  Johar Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('630', 'G.A Suzuki Center Chuburji-Lahore', 'N-0615', 'Lahore  Chuburji', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('631', 'Geely Ravi Motors Bypass Road-Lahore', 'N-0616', 'Lahore  ', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('632', 'General Autos Hafizabad-Lahore', 'N-0617', 'Lahore  Hafizabad', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('633', 'Geo Oil Store Gulberg III-Lahore', 'N-0618', 'Lahore  Gulberg', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('634', 'Ghaus Autos Johar Town-Lahore', 'N-0619', 'Lahore  Johar Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('635', 'Ghous Auto Parts Johar Town', 'N-0620', 'Lahore  Johar Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('636', 'Ghousia Auto Super Auto Market Chuburji', 'N-0621', 'Lahore  Chuburji', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('637', 'GM Auto 1071 A Block Sabzazar Multan Roa', 'N-0622', 'Lahore  Multan Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('638', 'Go-4 Repair Autos GT Road Gujrat-Lahore', 'N-0623', 'Lahore  Gujrat', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('639', 'Gold Autos Gujranwala-Lahore', 'N-0624', 'Lahore  Gujranwala', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('640', 'Gondal  Autos GT Road  Okara Lahore', 'N-0625', 'Lahore  Okara', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('641', 'Green Suzuki Autos Montgomery Road', 'N-0626', 'Lahore  Montgomery Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('642', 'Gujranwala Autos Oil Gujranwala-Lahore', 'N-0627', 'Lahore  Gujranwala', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('643', 'H.I Motor Auto Parts Waris Road-Lahore', 'N-0628', 'Lahore  Waris Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('644', 'H.M Engineering Co.Johar Town-Lahore', 'N-0629', 'Lahore  Johar Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('645', 'Habib &amp; Sons Hardwere Store-Gujranwala', 'N-0630', 'Lahore  Gujranwala', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('646', 'Hafiz Auto Spare Parts 22 Lawrence Road', 'N-0631', 'Lahore  Lawrence Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('647', 'Hafiz Autos Waris Road-Lahore', 'N-0632', 'Lahore  Waris Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('648', 'Hafiz Brothers Walton Road-Lahore', 'N-0633', 'Lahore  Walton Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('649', 'Hafiz G Oil Change Bijli Ghr Sabzazar', 'N-0634', 'Lahore  Sabzazar', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('650', 'Hafiz Kamran Autos Johar Town Lahore', 'N-0635', 'Lahore  Johar Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('651', 'Hafiz Karachi Autos Gujranwala-Lahore', 'N-0636', 'Lahore  Gujranwala', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('652', 'Hafiz Karachi Autos Oil Shaikhpura Rd Lhr', 'N-0637', 'Lahore  Sheikhpura', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('653', 'Haider Auto 25 Fateh Shair Road Mozang', 'N-0638', 'Lahore  Fateh Shair Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('654', 'Haider Autos Faislabad Road Sheikhupura', 'N-0639', 'Lahore  Sheikhupura', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('655', 'Haji Abdul Al Rashid G-market Qasoor Lhr', 'N-0640', 'Lahore  Qasoor', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('656', 'Haji Auto Main Walton Road Cantt', 'N-0641', 'Lahore  Walton Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('657', 'Haji Ibrahim Mill Store-Lahore', 'N-0642', 'Lahore  ', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('658', 'Hajveri Oil Change Bund Road Niazi Adda', 'N-0643', 'Lahore  Band Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('659', 'Hajveri Oil Store Johar Town-Lahore', 'N-0644', 'Lahore  Johar Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('660', 'Hannan Auto Joher Town Lahore', 'N-0645', 'Lahore  Johar Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('661', 'HARRON AUTO CANAL BANK GULBERG 2 LAHORE', 'N-0646', 'Lahore  Gulberg', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('662', 'Hasnain Auto Joher Town', 'N-0647', 'Lahore  Johar Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('663', 'Hassan Auto Safa Wala Chowk Ganga Ram Lh', 'N-0648', 'Lahore  Gangaram', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('664', 'Highway Autos Sheikhpura-Lahore', 'N-0649', 'Lahore  Sheikhpura', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('665', 'Honda Hub Montgomery Road-Lahore', 'N-0650', 'Lahore  Montgomery Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('666', 'Honda Johar Town Motors Johar Town-LHR', 'N-0651', 'Lahore  Johar Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('667', 'Honda Ring Road Motors Ring Road Lahore', 'N-0652', 'Lahore  Ring Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('668', 'Honda Samanabad Motors-Lahore', 'N-0653', 'Lahore  Samnabad', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('669', 'Hussain Auto Spare Parts Opp Canal View', 'N-0654', 'Lahore  Canal View', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('670', 'I.A Traders Walton Road-Lahore', 'N-0655', 'Lahore  Walton Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('671', 'Ikhlaq Autos Khokha Stop Band Rd-Lahore', 'N-0656', 'Lahore  Band Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('672', 'Imran Auto Samsani Road Johar Town', 'N-0657', 'Lahore  Johar Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('673', 'Inam &amp; Co G.T Road Gujranwala Lhr', 'N-0658', 'Lahore  Gujranwala', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('674', 'Inayat Ali &amp;company HafizaBad', 'N-0659', 'Lahore  Hafizabad', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('675', 'International Autos Chauburji-Lahore', 'N-0660', 'Lahore  Chauburji', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('676', 'Iqbal Auto Abbot Road-Lahore', 'N-0661', 'Lahore  Abbot Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('677', 'Ishfaq Auto Store Lari Adda Qasoor', 'N-0662', 'Lahore  Qasoor', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('678', 'Ishfaq Autos Gulshan E Ravi Road-Lahore', 'N-0663', 'Lahore  Gulshan E Ravi', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('679', 'Ishfaq Autos Sheikuhpura-Lahore', 'N-0664', 'Lahore  Sheikhpura', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('680', 'Israr Autos Super Market Okara-Lahore', 'N-0665', 'Lahore  Okara', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('681', 'Itehad Autos Sheikhpura Road-Lahore', 'N-0666', 'Lahore  Sheikhpura', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('682', 'Ittefaq Motors Montgomery Road-Lahore', 'N-0667', 'Lahore  Montgomery Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('683', 'Jalandar Auto Chungi No 7 Okara', 'N-0668', 'Lahore  Okara', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('684', 'Jamil Autos Faisalabad Road Okara Lhr', 'N-0669', 'Lahore  Okara', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('685', 'Jani Autos Band Road-Lahore', 'N-0670', 'Lahore  Band Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('686', 'Javaid Auto Oil Store Bund Road LHR', 'N-0671', 'Lahore  Band Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('687', 'Jawed Auto Store Patoki-Lahore', 'N-0672', 'Lahore  Patoki', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('688', 'K&amp;W Oil Store 63 Kacha Ferozpur Road LOS', 'N-0673', 'Lahore  Ferozpur Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('689', 'K.G.N Oil Store Joher Town', 'N-0674', 'Lahore  Johar Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('690', 'Kar Kraft Model Town Ext Main Faisal Tow', 'N-0675', 'Lahore  Faisal Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('691', 'Karim Auto Bijli Ghar Stop Sabzazar', 'N-0676', 'Lahore  Sabzazar', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('692', 'Khadim Suzuki House Chauburji-Lahore', 'N-0677', 'Lahore  Chauburji', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('693', 'Khalid Autos G.T Road Gujarat Lhr', 'N-0678', 'Lahore  Gujrat', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('694', 'Khalid Autos Multan Road-Lahore', 'N-0679', 'Lahore  Multan Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('695', 'Khan &amp; Son Autos Chauburji-Lahore', 'N-0680', 'Lahore  Chauburji', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('696', 'Khan Auto Oil Change Canal View Gate', 'N-0681', 'Lahore  Canal View', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('697', 'Khan Baba Aslah Dealer Gujrat - Lahore', 'N-0682', 'Lahore  Gujrat', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('698', 'Khokhar Agri Parts Gujranwala-Lahore', 'N-0683', 'Lahore  Gujranwala', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('699', 'Khursheed Auto Montgomery Road Lahore', 'N-0684', 'Lahore  Montgomery Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('700', 'K-Jalil &amp; Company Chowk Begium Rd LHR', 'N-0685', 'Lahore  Beighum Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('701', 'Lahore Auto Near Bank Alfalah Montgomery', 'N-0686', 'Lahore  Montgomery Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('702', 'Lahore Oil Shadara Mor-Lahore', 'N-0687', 'Lahore  Shahdara', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('703', 'Lahore Oil Store Johar Town -Lahore', 'N-0688', 'Lahore  Johar Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('704', 'Lahoria Autos Gujranwala-Lahore', 'N-0689', 'Lahore  Gujranwala', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('705', 'Latif Autos Waris Road Lahore', 'N-0690', 'Lahore  Waris Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('706', 'Lube Shop Johar Town-Lahore', 'N-0691', 'Lahore  Johar Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('707', 'Lubes Shop 2 GT Roadnear Lal Haveli', 'N-0692', 'Lahore  Lal Haveli', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('708', 'M Ahmed Auto Spare Parts Shahdra', 'N-0693', 'Lahore  Shahdra', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('709', 'M BASHIR AUTO BHALA CHOWK JOHER TOWN', 'N-0694', 'Lahore  Johar Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('710', 'M Ilyas Oil Change Samsani Road J.Town', 'N-0695', 'Lahore  Johar Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('711', 'M Tariq Oil Store Faisal Town-Lahore', 'N-0696', 'Lahore  Faisal Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('712', 'M Usman Nes Pak Society Canal Bank Road', 'N-0697', 'Lahore  Canal Bank', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0');
INSERT INTO `0_debtors_master` VALUES
('713', 'MA Auto Oil Change Iqbal Town Lahore', 'N-0698', 'Lahore  Iqbal Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('714', 'Madina Auto Main Boulevard Ghazi Road', 'N-0699', 'Lahore  Ghazi Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('715', 'Madina Auto Store Multan Road-Lahore', 'N-0700', 'Lahore  Multan Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('716', 'Madina Motors Main Ferozpur Road-Lahore', 'N-0701', 'Lahore  Ferozpur Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('717', 'Madina Oil Store Patoki-Lahore', 'N-0702', 'Lahore  Patoki', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('718', 'Madni Motors Industrial Area Gulberg-LHR', 'N-0703', 'Lahore  Gulberg', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('719', 'Majid Auto Traders Sharif Mension Gangar', 'N-0704', 'Lahore  Sharif Mension', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('720', 'Makkah Autos GT Road Gujrat-Lahore', 'N-0705', 'Lahore  Gujrat', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('721', 'Makkah Autso Johar Town Lhr', 'N-0706', 'Lahore  Johar Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('722', 'Makkah Poshish Sadat Market 8-Montgomery', 'N-0707', 'Lahore  Montgomery Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('723', 'Makki Oil Store Faisal Town-Lahore', 'N-0708', 'Lahore  Faisal Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('724', 'Makki Oil Store Wapda Town-Lahore', 'N-0709', 'Lahore  Wapdatown', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('725', 'Malik Auto Bank Stop Main Walton Road', 'N-0710', 'Lahore  Walton Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('726', 'Malik Auto Suzuki Parts 8-Montgomery', 'N-0711', 'Lahore  Montgomery Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('727', 'Malik Autos Main Johar Town-Lahore', 'N-0712', 'Lahore  Johar Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('728', 'Malik Autos Qasoor-Lahore', 'N-0713', 'Lahore  Qasoor', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('729', 'Malik Autos Walton Road-Lahore', 'N-0714', 'Lahore  Walton Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('730', 'Malik Imran Auto 222 Multan Road', 'N-0715', 'Lahore  Multan Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('731', 'Malik Paper Badar Pura Stop Multan Road', 'N-0716', 'Lahore  Multan Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('732', 'Mansoor &amp; Zahoor Oil Shalimar Link Road', 'N-0717', 'Lahore  Shalimar Link Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('733', 'Mansoor Bro Oil Store GT Road Okara', 'N-0718', 'Lahore  Okara', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('734', 'Mansoor Brothers Autos GT Road Okara-LHR', 'N-0719', 'Lahore  Okara', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('735', 'Mashallah Auto Canal Park Gulberg', 'N-0720', 'Lahore  Gulberg', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('736', 'Mashallah Auto Joher Town', 'N-0721', 'Lahore  Johar Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('737', 'Master Auto Main Walton Road Cantt Marke', 'N-0722', 'Lahore  Walton Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('738', 'Master Autos Walton Road-Lahore', 'N-0723', 'Lahore  Walton Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('739', 'Meer Autos Gujrat Lahore', 'N-0724', 'Lahore  Gujrat', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('740', 'Mian Auto 326-D Main PIA Road,Johar Town', 'N-0725', 'Lahore  Johar Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('741', 'Mian Auto Bhalla Stop Johar Town', 'N-0726', 'Lahore  Johar Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('742', 'Mian Auto near Wali Hospital Kasoor', 'N-0727', 'Lahore  Qasoor', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('743', 'Mian Auto Parts Canda Qila Gujrawala', 'N-0728', 'Lahore  Gujranwala', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('744', 'Mian Auto Wahdat Road Near Orange Train', 'N-0729', 'Lahore  Wahdat Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('745', 'Mian Auto Walton Road', 'N-0730', 'Lahore  Walton Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('746', 'Mian Autos Johar Town-Lahore', 'N-0731', 'Lahore  Johar Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('747', 'Mian Autos Sabzazar-Lahore', 'N-0732', 'Lahore  Sabzazar', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('748', 'Mian Bro s Main Boulevard Road Sabzazar', 'N-0733', 'Lahore  Sabzazar', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('749', 'Mian Khalil Autos Bahawalpur Rd-Lahore', 'N-0734', 'Lahore  Bahawalpur Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('750', 'Mian Shuja &amp; Bro Shahdra Chowk-Lahore', 'N-0735', 'Lahore  Shahdra', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('751', 'Mian Yaqoob Autos G.T Rd Okara Lhr', 'N-0736', 'Lahore  Okara', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('752', 'Millat Rubber Store-Lahore', 'N-0737', 'Lahore  ', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('753', 'Minhaj Autos Walton Road-Lahore', 'N-0738', 'Lahore  Walton Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('754', 'Mini Motors Gulberg III-Lahore', 'N-0739', 'Lahore  Gulberg', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('755', 'MIR Auto Gujrawala Golden Market', 'N-0740', 'Lahore  Gujranwala', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('756', 'Mirza Auto Store G T Road Gujrat', 'N-0741', 'Lahore  Gujrat', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('757', 'Mobeen Autos Gujranwala Rd Hafizabad-Lhr', 'N-0742', 'Lahore  Hafizabad', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('758', 'Model Lube Shop Allama Iqbal Road', 'N-0743', 'Lahore  Iqbal Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('759', 'Modern Auto Workshop Johar Town', 'N-0744', 'Lahore  Johar Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('760', 'Mohsin Autos Johar Town-Lahore', 'N-0745', 'Lahore  Johar Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('761', 'MOON AUTO GANA RAM LAHORE', 'N-0746', 'Lahore  Gangaram', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('762', 'Mother Autos Johar Town-Lahore', 'N-0747', 'Lahore  Johar Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('763', 'Motor Clean Opposite Packages Mall', 'N-0748', 'Lahore  Pacakages Mall', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('764', 'MS Auto Back Side Dayal Singh Mention', 'N-0749', 'Lahore  Dayal Singh Mention', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('765', 'MSB Motors/Auto Johar Town Lahore', 'N-0750', 'Lahore  Johar Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('766', 'Mughal Arms Gujranwala Road Hafizabad', 'N-0751', 'Lahore  Hafizabad', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('767', 'Mughal Auto Ghazi Road Punjab Society', 'N-0752', 'Lahore  Punjab Society', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('768', 'Mughal Autos Band Road Lahore', 'N-0753', 'Lahore  Band Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('769', 'Mughal Autos GT Road Gujrat-Lahore', 'N-0754', 'Lahore  Gujrat', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('770', 'Mughal Autos GT Road Okara-Lahore', 'N-0755', 'Lahore  Okara', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('771', 'Mughal Autos Johar Town Lahore', 'N-0756', 'Lahore  Johar Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('772', 'Mughal Autos Montgomery Road-Lahore', 'N-0757', 'Lahore  Montgomery Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('773', 'Muhammadan Auto 426 Pak Block Iqbal Town', 'N-0758', 'Lahore  Iqbal Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('774', 'Muhammadan Autos Iqbal Town-Lahore', 'N-0759', 'Lahore  Iqbal Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('775', 'Multi Autos Gujrat General Bus Stand Lhr', 'N-0760', 'Lahore  Gujrat', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('776', 'Munawar Sons Chauburji-Lahore', 'N-0761', 'Lahore  Chauburji', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('777', 'N Hydari Auto Main Boulevard Ghazi Road', 'N-0762', 'Lahore  Ghazi Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('778', 'Nadeem Autos Montgomery Road LHR', 'N-0763', 'Lahore  Montgomery Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('779', 'Naeem &amp; Sons Montgomery', 'N-0764', 'Lahore  Montgomery Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('780', 'Naeem AM Industries Bilal Ganj-Lahore', 'N-0765', 'Lahore  Bilal Ganj', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('781', 'Nasir Auto Montgomery Road LHR', 'N-0766', 'Lahore  Montgomery Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('782', 'Nasir Autos Walton Road-Lahore', 'N-0767', 'Lahore  Walton Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('783', 'Nawaz Auto Near Metro Stop Multan Road', 'N-0768', 'Lahore  Multan Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('784', 'Nazir Autos Montgomery Road-Lahore', 'N-0769', 'Lahore  Montgomery Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('785', 'New Al Madina Autos Okara-Lahore', 'N-0770', 'Lahore  Okara', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('786', 'New Bilal Auto GT Road Gujranwala-Lahore', 'N-0771', 'Lahore  Gujranwala', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('787', 'New Khalid Auto Parts Multan Rd-Lahore', 'N-0772', 'Lahore  Multan Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('788', 'New Lahore Autos Ferozpur Road-Lahore', 'N-0773', 'Lahore  Ferozpur Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('789', 'New M.A Electric Store Mughal Centre Lhr', 'N-0774', 'Lahore  ', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('790', 'New Mian Bhai Auto 10-Montgomery Road', 'N-0775', 'Lahore  Montgomery Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('791', 'New Pak Auto P Block Main Sabzazar', 'N-0776', 'Lahore  Sabzazar', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('792', 'New Pak Autos Gujrat-Lahore', 'N-0777', 'Lahore  Gujrat', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('793', 'New Suzuki Centre Montgomery Road Lahore', 'N-0778', 'Lahore  Montgomery Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('794', 'Niazi # 99 Bund Road-Lahore', 'N-0779', 'Lahore  Band Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('795', 'Niazi Arms Multan Road-Lahore', 'N-0780', 'Lahore  Multan Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('796', 'Niazi Autos Montgomery Road-Lahore', 'N-0781', 'Lahore  Montgomery Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('797', 'Noor Autos GT Road Gujrat-Lahore', 'N-0782', 'Lahore  Gujrat', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('798', 'Noor Filter House Montgomery Road-Lahore', 'N-0783', 'Lahore  Montgomery Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('799', 'Norani Autos Multan Road-Lahore', 'N-0784', 'Lahore  Multan Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('800', 'Norani Bearing Store-Gujranwala', 'N-0785', 'Lahore  Gujranwala', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('801', 'O.R Motors Gurumanget Gulberg-Lahore', 'N-0786', 'Lahore  Gulberg', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('802', 'P.M Oil Traders Chauburji-Lahore', 'N-0787', 'Lahore  Chauburji', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('803', 'Pak auto said pur Multan road', 'N-0788', 'Lahore  Multan Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('804', 'Pak Auto Store Badar Pura Multan Road', 'N-0789', 'Lahore  Multan Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('805', 'Pak Autos Sheikhpura-Lahore', 'N-0790', 'Lahore  Sheikhpura', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('806', 'Pak Madina Autos Sheikhpura Rd-Lahore', 'N-0791', 'Lahore  Sheikhpura', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('807', 'Pak Madina Oil Shadara-Lahore', 'N-0792', 'Lahore  Shahdara', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('808', 'Pak Motors Rehmat Market-Lahore', 'N-0793', 'Lahore  Rehmat Market', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('809', 'Pak Poshish Sadat Market 8-Montgomery', 'N-0794', 'Lahore  Montgomery Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('810', 'Pakistan Arms Chuburji Centre LHR', 'N-0795', 'Lahore  Chauburji', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('811', 'Pakistan Auto Kot Khawaja Saeed', 'N-0796', 'Lahore  Kot Khawaja Saeed', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('812', 'Pakistan Oil Change Mustafa Town Wahdat', 'N-0797', 'Lahore  Mustafa Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('813', 'Pakistan Oil Change,Go Pump Sabzazar', 'N-0798', 'Lahore  Sabzazar', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('814', 'Pakistan Oil Traders GT Road Gujrat-LHR', 'N-0799', 'Lahore  Gujrat', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('815', 'Paracha Poshish Queens Road', 'N-0800', 'Lahore  Queens Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('816', 'Parwaiz Asla Dealer Khachri Bazar Okara', 'N-0801', 'Lahore  Okara', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('817', 'Pervez Brothgers &amp; Co Kachehri Road Lhr', 'N-0802', 'Lahore  Okara', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('818', 'Peshawar Auto Samsani Road Johar Town', 'N-0803', 'Lahore  Johar Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('819', 'Pioneer Motors Ferozpur Road-Lahore', 'N-0804', 'Lahore  Ferozpur Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('820', 'Prime Car Care Main Multan Road', 'N-0805', 'Lahore  Multan Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('821', 'Prince Auto Care Abbat Road Lahore', 'N-0806', 'Lahore  Montgomery Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('822', 'Prince Suzuki Center Montgomery Road-LHR', 'N-0807', 'Lahore  Montgomery Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('823', 'Punjab Autos Gold Plaza Gujranwala Lhr', 'N-0808', 'Lahore  Gujranwala', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('824', 'Punjab Autos Johar Town-Lahore', 'N-0809', 'Lahore  Johar Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('825', 'Punjab Autos Qasoor-Lahore', 'N-0810', 'Lahore  Qasoor', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('826', 'Qasim Auto Gulshan E Ravi Near Bund Road', 'N-0811', 'Lahore  Band Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('827', 'Quality Lube Shop Gulberg Lahore', 'N-0812', 'Lahore  Gulberg', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('828', 'Rahim Oil Stor Joher Town', 'N-0813', 'Lahore  Johar Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('829', 'Raja Auto Workshop Faisal Town Lahore', 'N-0814', 'Lahore  Faisal Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('830', 'Rajpoot MOtors Rana Town Lahore', 'N-0815', 'Lahore  Rana Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('831', 'Rana Asif Autos Iqbal Town-Lahore', 'N-0816', 'Lahore  Iqbal Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('832', 'Rana Auto Care WorkShop Gujrnwala-Lahore', 'N-0817', 'Lahore  Gujranwala', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('833', 'Rana Autos Johar Town-Lahore', 'N-0818', 'Lahore  Johar Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('834', 'Rana Autos Multan Road-Lahore', 'N-0819', 'Lahore  Multan Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('835', 'Rana Autos Oil Gujranwala-Lahore', 'N-0820', 'Lahore  Gujranwala', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('836', 'Rao Autos Sabzazar Multan Rd-Lahore', 'N-0821', 'Lahore  Multan Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('837', 'Ravi Auto Store Band Raod-Lahore', 'N-0822', 'Lahore  Band Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('838', 'Razaq Autos Ferozpur Road-Lahore', 'N-0823', 'Lahore  Ferozpur Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('839', 'Rehman Auto Waris Road', 'N-0824', 'Lahore  Waris Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('840', 'Rehman Autos Ferozpur Road-Lahore', 'N-0825', 'Lahore  Ferozpur Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('841', 'Rehman Autos Johar Town-Lahore', 'N-0826', 'Lahore  Johar Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('842', 'Riaz Auto Shahdra Chowk-Lahore', 'N-0827', 'Lahore  Shahdara', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('843', 'Roa Abdullah Autos  Okara Lahore', 'N-0828', 'Lahore  Okara', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('844', 'Sadiq Autos Gujranwala-Lahore', 'N-0829', 'Lahore  Gujranwala', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('845', 'Saeed Suzuki Autos Sabzazar-Lahore', 'N-0830', 'Lahore  Sabzazar', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('846', 'Saigal Autos Montcomery Road-Lahore', 'N-0831', 'Lahore  Montgomery Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('847', 'Sajid Autos Gulberg Industrial Area-LHR', 'N-0832', 'Lahore  Gulberg', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('848', 'Sajjad Auto Super Auto Market Chuburji', 'N-0833', 'Lahore  Chauburji', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('849', 'Sajjad Autos Sheikhpura-Lahore', 'N-0834', 'Lahore  Sheikhpura', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('850', 'Saqib Auto Khiyali Bypass Gujrawala', 'N-0835', 'Lahore  Gujranwala', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('851', 'Sardar Auto Near PSO Pump Multan Road', 'N-0836', 'Lahore  Multan Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('852', 'Sarwar Oil Store Rasool Park LOS', 'N-0837', 'Lahore  Los', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('853', 'Seigal Auto Montgomery Road', 'N-0838', 'Lahore  Montgomery Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('854', 'Shafqat Auto Main Montgomery Road-Lahore', 'N-0839', 'Lahore  Montgomery Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('855', 'Shah Jamal Autos Iqbal Town-Lahore', 'N-0840', 'Lahore  Iqbal Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('856', 'Shah Jee Autos Qasoor-Lahore', 'N-0841', 'Lahore  Qasoor', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('857', 'Shah Nafees Auto Waris Road', 'N-0842', 'Lahore  Waris Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('858', 'Shahbaz Oil Change Tokey Wala Chowk', 'N-0843', 'Lahore  Tokey Wala Chowk', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('859', 'Shahid Auto PAk Block Iqbal Town', 'N-0844', 'Lahore  Iqbal Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('860', 'Shahid Bhai Auto Yateem Khana Multan Roa', 'N-0845', 'Lahore  Multan Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('861', 'Shahzad Autos Johar Town-Lahore', 'N-0846', 'Lahore  Johar Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('862', 'Shalimar Auto Steel Bagh Qasoor', 'N-0847', 'Lahore  Qasoor', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('863', 'Shalimar Autos Qasoor-Lahore', 'N-0848', 'Lahore  Qasoor', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('864', 'Sharif Autos Qasoor-Lahore', 'N-0849', 'Lahore  Qasoor', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('865', 'Sharjah Oil Harbanspura Canal Park', 'N-0850', 'Lahore  Canal Park', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('866', 'Shehnaz &amp; Sons GT Road-Gujranwala', 'N-0851', 'Lahore  Gujranwala', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('867', 'Sheikh Auto Pak Block Iqbal Town', 'N-0852', 'Lahore  Iqbal Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('868', 'Sheikh Auto Purana Lari Adda Qasoor', 'N-0853', 'Lahore  Qasoor', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('869', 'Sheikh Auto Spare Parts Main Walton Road', 'N-0854', 'Lahore  Walton Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('870', 'Shenshah Car Poshish Bijli Ghar Stop', 'N-0855', 'Lahore  Sabzazar', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('871', 'Sher E Imam Autos Montgomery  Road Lhr', 'N-0856', 'Lahore  Montgomery Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('872', 'Sher E Rabani Autos Hafizabad Gujranwala', 'N-0857', 'Lahore  Gujranwala', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('873', 'SKY LINE AUTO SHO[ JOHER TOWN', 'N-0858', 'Lahore  Johar Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('874', 'Subhan Auto Battery Gulberg 2 LHR', 'N-0859', 'Lahore  Gulberg', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('875', 'Subhan Auto Gulberg II Lahore', 'N-0860', 'Lahore  Gulberg', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('876', 'Subhan Auto Pepsi Road Gulberg III', 'N-0861', 'Lahore  Gulberg', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('877', 'Subhan Autos Gulberg ll Lahore', 'N-0862', 'Lahore  Gulberg', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('878', 'Subhan Oil &amp; Auto Sheikhpura Road-Lahore', 'N-0863', 'Lahore  Sheikhpura', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('879', 'Sun Shine Lube Workshop Walinshia Town', 'N-0864', 'Lahore  Walansia Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('880', 'Suntec Company Gulberg-Lahore', 'N-0865', 'Lahore  Gulberg', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('881', 'Suzuki Ali Jan Queens Road', 'N-0866', 'Lahore  Queens Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('882', 'Suzuki Auto Center Sabzazar-Lahore', 'N-0867', 'Lahore  Sabzazar', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('883', 'Suzuki Auto House Auto Gujrawala', 'N-0868', 'Lahore  Gujranwala', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('884', 'Suzuki Centre Super Market Chauburji Lhr', 'N-0869', 'Lahore  Chauburji', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('885', 'Suzuki House Gujranwala Road-Lahore', 'N-0870', 'Lahore  Gujranwala', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('886', 'Suzuki Motors Diyal Singh-Lahore', 'N-0871', 'Lahore  Dayal Singh Mention', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('887', 'Syed Masood Shah Auto Queens Road', 'N-0872', 'Lahore  Queens Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('888', 'T&amp;T AUTOS JOHER TOWN', 'N-0873', 'Lahore  Johar Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('889', 'Taha Auto Rehman Garden-Lahore', 'N-0874', 'Lahore  Rehman Garden', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('890', 'Tanveer Autos Montgomery Road-Lahore', 'N-0875', 'Lahore  Montgomery Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('891', 'Tariq &amp; Sons Auto 6-A Montgomery Road', 'N-0876', 'Lahore  Montgomery Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('892', 'Tariq Auto Shedewal Johar Town-Lahore', 'N-0877', 'Lahore  Johar Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('893', 'Tariq Car A/C GT Road Okara-Lahore', 'N-0878', 'Lahore  Okara', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('894', 'Tariq Suzuki Autos Johar Town-Lahore', 'N-0879', 'Lahore  Johar Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('895', 'Tassawur Auto Pepsi Road Gulberg II', 'N-0880', 'Lahore  Gulberg', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('896', 'Techno Auto W/Shop Shahdra Chowk', 'N-0881', 'Lahore  Shahdra', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('897', 'Toyota Cantt Main Walton Road', 'N-0882', 'Lahore  Walton Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('898', 'Toyota Suzuki House Sheikhpura-Lahore', 'N-0883', 'Lahore  Sheikhpura', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('899', 'Umar Autos Johar Town-Lahore', 'N-0884', 'Lahore  Johar Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('900', 'Umer Auto Oil Store Multan Raod Lahore', 'N-0885', 'Lahore  Multan Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('901', 'Usman Autos Chauburji-Lahore', 'N-0886', 'Lahore  Chauburji', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('902', 'Usman Autos Hafizabad-Lahore', 'N-0887', 'Lahore  Hafizabad', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('903', 'Usman Autos Saddar Bazar Lahore', 'N-0888', 'Lahore  Sadar', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('904', 'Usman Autos Zaki Ada Qasoor Lhr', 'N-0889', 'Lahore  Qasoor', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('905', 'Victory Auto 10-Montgomery Road Lahore', 'N-0890', 'Lahore  Montgomery Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('906', 'Wahab Auto Pepsi Road Gurumanget Gulberg', 'N-0891', 'Lahore  Gulberg', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('907', 'Waheed Motors Montgomery Road LHR', 'N-0892', 'Lahore  Montgomery Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('908', 'Waqas Auto Canal Bank Hajveri Colony', 'N-0893', 'Lahore  Canal Bank', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('909', 'Waqas Autos Gujranwala Rd Hafizabad Lhr', 'N-0894', 'Lahore  Hafizabad', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('910', 'Yaseen Autos GT Road Gujrat-Lahore', 'N-0895', 'Lahore  Gujrat', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('911', 'Yousaf Auto Shade Wal Chowk Joher Town', 'N-0896', 'Lahore  Johar Town', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('912', 'ZA Auto Montgomery Road-Lahore', 'N-0897', 'Lahore  Montgomery Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('913', 'Zaheer Autos Multan Road-Lahore', 'N-0898', 'Lahore  Multan Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('914', 'Zahid Auto Osaka Display Walton Road', 'N-0899', 'Lahore  Walton Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('915', 'Zahid Mehmood Tools Latif Centre Nishtar', 'N-0900', 'Lahore  Nishtar Colony', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('916', 'Zain Auto near Toyota Motros Walton Lhr', 'N-0901', 'Lahore  Walton Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('917', 'Zameer Autos Gujranwala-Lahore', 'N-0902', 'Lahore  Gujranwala', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('918', 'Zeeshan &amp; Co Qasoor-Lahore', 'N-0903', 'Lahore  Qasoor', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('919', 'Zeeshan Autos Infentri Road-Lahore', 'N-0904', 'Lahore  Infentri Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('920', 'Zubair Autos Qasoor-Lahore', 'N-0905', 'Lahore  Qasoor', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('921', 'A Y Lube Shop Jorry Pull-Lahore', 'N-0906', 'Lahore  Jorry Pull', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('922', 'A.G Auto Bao Wala-Lahore', 'N-0907', 'Lahore  Bao Wala', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('923', 'A.H Oil Ghazi Abad Near Imran Bakery', 'N-0908', 'Lahore  Ghazi Abad', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('924', 'Abdullah Auto Dera Gujjran-Lahore', 'N-0909', 'Lahore  Dera Gujjran', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('925', 'Afzal &amp; Sons Sukh Nehar GT Road-Lahore', 'N-0910', 'Lahore  Gt Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('926', 'Ahmed Auto Zone Ali Pur Garden Badian', 'N-0911', 'Lahore  Ali Pur Garden', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('927', 'Al Awan Auto Jorry Pull-Lahore', 'N-0912', 'Lahore  Jorry Pull', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('928', 'Al Aziz Auto Bhatta Chowk-Lahore', 'N-0913', 'Lahore  Bhatta Chowk', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('929', 'Al Aziz Oil Para Gon Society-Lahore', 'N-0914', 'Lahore  Para Gon Society', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('930', 'Al Fareed Oil Zaitoon Colony Salamat Pur', 'N-0915', 'Lahore  Salamt Pura', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('931', 'Al Kareem Auto Bhatta Chowk-Lahore', 'N-0916', 'Lahore  Bhatta Chowk', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('932', 'Al Khair Oil Tajpura-Lahore', 'N-0917', 'Lahore  Tajpura', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('933', 'Al Kuwait Auto GT Raod-Lahore', 'N-0918', 'Lahore  Gt Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('934', 'Al Madina Auto 204 Q-Block Defence', 'N-0919', 'Lahore  Defence', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('935', 'Al Madina Auto Bhatta Chowk', 'N-0920', 'Lahore  Bhatta Chowk', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('936', 'Al Madina Auto near Rangers HQ', 'N-0921', 'Lahore  Bhatta Chowk', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('937', 'Al Rehman Oil Store Mughalpura-Lahore', 'N-0922', 'Lahore  Mughalpura', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('938', 'Al Riaz Oil House Infentri Road-Lahore', 'N-0923', 'Lahore  Infentri Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('939', 'Al Sadiq Auto Durand Road-Lahore', 'N-0924', 'Lahore  Durand Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('940', 'Al Saeed Oil Mew Garden-Lahore', 'N-0925', 'Lahore  Mew Garden', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('941', 'Ali Auto Sadar Near Dipu Stop-Lahore', 'N-0926', 'Lahore  Sadar', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('942', 'Ali Haider Auto Bao Wala-Lahore', 'N-0927', 'Lahore  Bao Wala', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('943', 'Ali Hajveri Auto Allama Iqbal Road', 'N-0928', 'Lahore  Allama Iqbal Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('944', 'Ali Hajveri Auto Jallo Pind-Lahore', 'N-0929', 'Lahore  Jallo Pind', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('945', 'Ali Oil Store Infentri Road-Lahore', 'N-0930', 'Lahore  Infentri Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('946', 'Altaf Auto Daroghywala-Lahore', 'N-0931', 'Lahore  Daroghywala', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('947', 'Anwar E Sidra Auto Gt Road-Lahore', 'N-0932', 'Lahore  Gt Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('948', 'Auto Speed Infentri Road-Lahore', 'N-0933', 'Lahore  Infentri Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('949', 'Ayesha Auto Gari Shahu-Lahore', 'N-0934', 'Lahore  Gari Shahu', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('950', 'Aziz Auto Infentry Road Lahore', 'N-0935', 'Lahore  Infentri Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('951', 'Badami Bagh Auto Daroghy Wala-Lahore', 'N-0936', 'Lahore  Daroghywala', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('952', 'Badami Bagh Auto Jorry Pull-Lahore', 'N-0937', 'Lahore  Jorry Pull', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('953', 'Basheer &amp; Sons Infentri Road-Lahore', 'N-0938', 'Lahore  Infentri Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('954', 'Bilal Auto Bata Pur-Lahore', 'N-0939', 'Lahore  Bata Pur', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('955', 'Bilal Auto GT Road-Lahore', 'N-0940', 'Lahore  Gt Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('956', 'Bilal Auto Tajpura-Lahore', 'N-0941', 'Lahore  Tajpura', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('957', 'Billa Auto Bata Pur-Lahore', 'N-0942', 'Lahore  Bata Pur', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('958', 'Bismillah Auto Bao Wala-Lahore', 'N-0943', 'Lahore  Bao Wala', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('959', 'Bismillah Auto Jorry Pull-Lahore', 'N-0944', 'Lahore  Jorry Pull', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('960', 'Bismillah Tyres Pakistan Mint-Lahore', 'N-0945', 'Lahore  Pakistan Mint', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('961', 'Butt Auto Barki Road-Lahore', 'N-0946', 'Lahore  Barki Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('962', 'Butt Auto Para Gon Society-Lahore', 'N-0947', 'Lahore  Para Gon Society', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('963', 'C.P Auto Bao Wala-Lahore', 'N-0948', 'Lahore  Bao Wala', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('964', 'Car Decoration Bata Pur-Lahore', 'N-0949', 'Lahore  Bata Pur', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('965', 'Car Mechanic Soutter Mill Mani Road-LHR', 'N-0950', 'Lahore  Soutter Mill', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('966', 'Car Point Bhatta Chowk-Lahore', 'N-0951', 'Lahore  Bhatta Chowk', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('967', 'Car Saloon Fateh Ghar-Lahore', 'N-0952', 'Lahore  Fateh Ghar', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('968', 'Car View Auto Batapur-Lahore', 'N-0953', 'Lahore  Bata Pur', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('969', 'Chohan Auto Bao Wala-Lahore', 'N-0954', 'Lahore  Bao Wala', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('970', 'City Auto Workshop Airport Chowk-Lahore', 'N-0955', 'Lahore  Airport Chowk', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('971', 'Coast To Coast Oil Daroghywala-Lahore', 'N-0956', 'Lahore  Daroghywala', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('972', 'DATA Auto GT ROAD LAHORE', 'N-0957', 'Lahore  Gt Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('973', 'Dawoud Auto Bhatta Chowk-Lahore', 'N-0958', 'Lahore  Bhatta Chowk', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('974', 'Decent Auto Manawan-Lahore', 'N-0959', 'Lahore  Manawan', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('975', 'Defence Auto Bhatta Chowk-Lahore', 'N-0960', 'Lahore  Bhatta Chowk', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('976', 'Extreme Performance Bhatta Chowk', 'N-0961', 'Lahore  Bhatta Chowk', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('977', 'Faraz Auto GT Road Near Gourmet Resturan', 'N-0962', 'Lahore  Gt Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('978', 'Faridi Auto Daroghy Wala Near Bund Road', 'N-0963', 'Lahore  Daroghywala', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('979', 'Farooq Auto Sadar Near Dipu Stop-Lahore', 'N-0964', 'Lahore  Sadar', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('980', 'Filter Land Para Gone Society-Lahore', 'N-0965', 'Lahore  Para Gon Society', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('981', 'Fine Auto Mew Garden-Lahore', 'N-0966', 'Lahore  Mew Garden', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('982', 'Fine Oil Land Dhaka Road Sadar-Lahore', 'N-0967', 'Lahore  Sadar', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('983', 'Future Auto Bata Pur-Lahore', 'N-0968', 'Lahore  Bata Pur', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('984', 'Ganj Baksh Auto Opposite UET GT Road', 'N-0969', 'Lahore  Gt Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('985', 'Ghousia Auto Durand Road-Lahore', 'N-0970', 'Lahore  Durand Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('986', 'Golden Star Auto Mian Infentry Road Laho', 'N-0971', 'Lahore  Infentri Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('987', 'Habibi Auto New Pull Near Auto Market', 'N-0972', 'Lahore  Tajpura', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('988', 'Hafiz Oil Store Bahar Shah Road-Lahore', 'N-0973', 'Lahore  Bahar Shah Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('989', 'Hamdard Auto Bhatta Chowk-Lahore', 'N-0974', 'Lahore  Bhatta Chowk', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('990', 'Hamza Auto Salamat Pura-Lahore', 'N-0975', 'Lahore  Salamt Pura', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('991', 'Haq Bahu Auto Manawan Bagh Wali Puli', 'N-0976', 'Lahore  Manawan', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('992', 'Hascol Oil Sukh Nehar-Lahore', 'N-0977', 'Lahore  Gt Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('993', 'Hussain Auto GT Road-Lahore', 'N-0978', 'Lahore  Gt Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('994', 'Hussain Auto Sadar Near Dipu Stop-Lahore', 'N-0979', 'Lahore  Sadar', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('995', 'I.A Oil Change Bhatta Chowk-Lahore', 'N-0980', 'Lahore  Bhatta Chowk', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('996', 'I.N.H Auto Bhatta Chowk-Lahore', 'N-0981', 'Lahore  Bhatta Chowk', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('997', 'Imran Oil Centre Infentri Road Sadar', 'N-0982', 'Lahore  Infentri Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('998', 'Irfan Auto Sadar Dhaka Road-Lahore', 'N-0983', 'Lahore  Sadar', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('999', 'Japan Auto Bhatta Chowk-Lahore', 'N-0984', 'Lahore  Bhatta Chowk', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1000', 'Japan Auto Mew Garden-Lahore', 'N-0985', 'Lahore  Mew Garden', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1001', 'Japan Autos Infentri Road-Lahore', 'N-0986', 'Lahore  Infentri Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1002', 'Javaid Auto Shadi Pura-Lahore', 'N-0987', 'Lahore  Shadi Pura', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1003', 'Junaid Auto Jallo Mor', 'N-0988', 'Lahore  Jallo Mor', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1004', 'Junaid Auto Sadar Dhaka Road-Lahore', 'N-0989', 'Lahore  Sadar', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1005', 'K2S Auto Jallo Pind Near Ghurki Hospital', 'N-0990', 'Lahore  Jallo Pind', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1006', 'Khan Auto Daroghywala-Lahore', 'N-0991', 'Lahore  Daroghywala', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1007', 'Khan Auto Tajpura Near Railway Crossing', 'N-0992', 'Lahore  Tajpura', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1008', 'Lahore Oil Bao Wala-Lahore', 'N-0993', 'Lahore  Bao Wala', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1009', 'Lahore Oil Gt Road-Lahore', 'N-0994', 'Lahore  Gt Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1010', 'M R Oil Change Jorry Pull', 'N-0995', 'Lahore  Jorry Pull', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1011', 'M.R Auto Gt Road-Lahore', 'N-0996', 'Lahore  Gt Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1012', 'Macca Auto Jorry Pull-Lahore', 'N-0997', 'Lahore  Jorry Pull', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1013', 'Madina Auto Badian Road-Lahore', 'N-0998', 'Lahore  Badian ', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1014', 'Madina Auto Gari Shahu-Lahore', 'N-0999', 'Lahore  Gari Shahu', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1015', 'Madina Auto Imamia Colony GT Road-Lahore', 'N-1000', 'Lahore  Gt Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1016', 'Malik Auto Jorry Pull-Lahore', 'N-1001', 'Lahore  Jorry Pull', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1017', 'Malik Auto Momin Pura-Lahore', 'N-1002', 'Lahore  Momin Pura', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1018', 'Malik Brother Auto Bao Wala-Lahore', 'N-1003', 'Lahore  Bao Wala', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1019', 'MASHALLAH Auto Jallo Pind Ghurki Hospita', 'N-1004', 'Lahore  Jallo Pind', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1020', 'Mashallah Auto Quaid E Azam Interchange', 'N-1005', 'Lahore  Quaid E Azam Inerchange', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1021', 'MASHALLAH Auto Tajpura', 'N-1006', 'Lahore  Tajpura', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1022', 'MASHALLAH Oil Change Manawan-Lahore', 'N-1007', 'Lahore  Manawan', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1023', 'Master Auto Tajpura-Lahore', 'N-1008', 'Lahore  Tajpura', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1024', 'Master Latif Auto Jallo Pind-Lahore', 'N-1009', 'Lahore  Jallo Pind', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1025', 'Mehar Auto Workshop Manawan-Lahore', 'N-1010', 'Lahore  Manawan', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1026', 'Mehar Latif Mehmood Booti Ring Road', 'N-1011', 'Lahore  Mehmood Booti', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1027', 'Mian Auto Badian Road-Lahore', 'N-1012', 'Lahore  Badian ', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1028', 'Mian Auto Gt Road-Lahore', 'N-1013', 'Lahore  Gt Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1029', 'Mian Filter Bata Pur-Lahore', 'N-1014', 'Lahore  Bata Pur', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1030', 'Mian Meer Oil Infentri Road-Lahore', 'N-1015', 'Lahore  Infentri Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1031', 'Mian Oil Change Imamia Colony-Lahore', 'N-1016', 'Lahore  Imamia Colony', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1032', 'Mubashir Khan Oil Tajpura-Lahore', 'N-1017', 'Lahore  Tajpura', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1033', 'Mubashir Oil Allama Iqbal Road-Lahore', 'N-1018', 'Lahore  Allama Iqbal Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1034', 'Mubashir Oil Bao Wala-Lahore', 'N-1019', 'Lahore  Bao Wala', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1035', 'Muhammadi Oil Change Gari Shahu', 'N-1020', 'Lahore  Gari Shahu', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1036', 'Mujahid Autos GT Road-Lahore', 'N-1021', 'Lahore  Gt Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1037', 'Mushtaq Autos GT Road-Lahore', 'N-1022', 'Lahore  Gt Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1038', 'Muzammil Auto Harbanspura-Lahore', 'N-1023', 'Lahore  Harbanspura', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1039', 'Nadeem Auto Tajpura-Lahore', 'N-1024', 'Lahore  Tajpura', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1040', 'Najaf Oil Harbanspura-Lahore', 'N-1025', 'Lahore  Harbanspura', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1041', 'Naveed Auto Tajpura-Lahore', 'N-1026', 'Lahore  Tajpura', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1042', 'Nawaz Auto Gt Road-Lahore', 'N-1027', 'Lahore  Gt Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1043', 'New Al Madina Auto Manawan Hospital', 'N-1028', 'Lahore  Manawan', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1044', 'New Bismillah Auto Jorry-Lahore', 'N-1029', 'Lahore  Jorry Pull', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1045', 'New Friend Auto Daroghywala-Lahore', 'N-1030', 'Lahore  Daroghywala', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0');
INSERT INTO `0_debtors_master` VALUES
('1046', 'New Khan Auto Para Gon Society-Lahore', 'N-1031', 'Lahore  Para Gon Society', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1047', 'New Madni Auto Airport Road Bhatta Chowk', 'N-1032', 'Lahore  Bhatta Chowk', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1048', 'New Muhammadi Oil Centre Sadar Gol Chakk', 'N-1033', 'Lahore  Sadar', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1049', 'New Rafique Auto Mew Garden-Lahore', 'N-1034', 'Lahore  Mew Garden', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1050', 'New Safi Mazda Bund Road Daroghywala', 'N-1035', 'Lahore  Daroghywala', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1051', 'New Shalimar Oil Gt Road-Lahore', 'N-1036', 'Lahore  Gt Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1052', 'New Siddique Auto Taj Pura-Lahore', 'N-1037', 'Lahore  Tajpura', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1053', 'New Tayyab Auto Kot Khawaja Saeed', 'N-1038', 'Lahore  Kot Khawaja Saeed', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1054', 'New Umer Oil Store Harbanspura Phatak', 'N-1039', 'Lahore  Harbanspura', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1055', 'New Usman Auto Sadar Dhaka Road-Lahore', 'N-1040', 'Lahore  Sadar', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1056', 'Nisar Sons Jorry Pull-Lahore', 'N-1041', 'Lahore  Jorry Pull', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1057', 'NoShahi Auto Tajpura-Lahore', 'N-1042', 'Lahore  Tajpura', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1058', 'Number Dar Auto Near Rangers HQ', 'N-1043', 'Lahore  Bhatta Chowk', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1059', 'Oil Change Taj Bagh-Lahore', 'N-1044', 'Lahore  Taj Bagh', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1060', 'P.R.O Lube Shop Barki Road-Lahore', 'N-1045', 'Lahore  Bao Wala', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1061', 'Pak Madina Oil Allama Iqbal Road-Lahore', 'N-1046', 'Lahore  Allama Iqbal Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1062', 'PSO Pump Sadar-Lahore', 'N-1047', 'Lahore  Sadar', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1063', 'Punjab Oil Jorry Pull-Lahore', 'N-1048', 'Lahore  Jorry Pull', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1064', 'Qasim Auto Badian Road-Lahore', 'N-1049', 'Lahore  Badian ', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1065', 'Qazi Golden Motor Dhaka Road Sadar', 'N-1050', 'Lahore  Sadar', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1066', 'Rafai Auto Tajpura Near Railway Crossing', 'N-1051', 'Lahore  Tajpura', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1067', 'Rafaqat Oil GT Road-Lahore', 'N-1052', 'Lahore  Gt Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1068', 'Rafiq Auto Dharam Pura-Lahore', 'N-1053', 'Lahore  Dharam Pura', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1069', 'Rafiq Oil Badian Road-Lahore', 'N-1054', 'Lahore  Badian ', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1070', 'Rehan Auto Sher Shah Road-Lahore', 'N-1055', 'Lahore  Sher Shah Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1071', 'Royal Auto Harbanspura Railway Crossing', 'N-1056', 'Lahore  Harbanspura', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1072', 'Sabir Auto Manawan-Lahore', 'N-1057', 'Lahore  Manawan', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1073', 'Sagheer &amp; Son Auto Harbanspure Near 1122', 'N-1058', 'Lahore  Harbanspura', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1074', 'Saleem Auto Bao Wala-Lahore', 'N-1059', 'Lahore  Bao Wala', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1075', 'Sarwar Lube Shop Allama Iqbal Road', 'N-1060', 'Lahore  Allama Iqbal Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1076', 'Shafqat Ali Arm Gt Road phatak-Lahore', 'N-1061', 'Lahore  Gt Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1077', 'Shah G Battery Centre Sadar-Lahore', 'N-1062', 'Lahore  Sadar', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1078', 'Shahbaz Auto Jorry Pull-Lahore', 'N-1063', 'Lahore  Jorry Pull', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1079', 'Shahbaz Bro Dhaka Road Sadar Cantt', 'N-1064', 'Lahore  Sadar', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1080', 'Shahid Auto Momin Pura Near Daroghy Wala', 'N-1065', 'Lahore  Daroghywala', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1081', 'Shalimar Auto Gt Road-Lahore', 'N-1066', 'Lahore  Gt Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1082', 'Shalimar Auto Manawan-Lahore', 'N-1067', 'Lahore  Manawan', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1083', 'Sharif Autos Saddar Bazar Cantt-Lahore', 'N-1068', 'Lahore  Sadar', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1084', 'Sheraz Oil Sukh Neahr GT Road-Lahore', 'N-1069', 'Lahore  Gt Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1085', 'Siddiqui Auto New Pull Near Auto Market', 'N-1070', 'Lahore  Tajpura', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1086', 'Sohni Autos G.T Road Singhpura-Lahore', 'N-1071', 'Lahore  Gt Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1087', 'Subhan Auto Islam Park Gt Road-Lahore', 'N-1072', 'Lahore  Gt Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1088', 'Subhan Auto Near Jorry Pull-Lahore', 'N-1073', 'Lahore  Jorry Pull', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1089', 'Subhan Auto Souter Mill Mani Road-Lahore', 'N-1074', 'Lahore  Soutter Mill', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1090', 'Sunny Auto GT Road-Lahore', 'N-1075', 'Lahore  Gt Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1091', 'Super Car Wash Qalandar Pura-Lahore', 'N-1076', 'Lahore  Qalandarpura', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1092', 'Syed Auto Bata Pur-Lahore', 'N-1077', 'Lahore  Bata Pur', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1093', 'Tahir Auto Parts Bund Road Daroghy Wala', 'N-1078', 'Lahore  Daroghywala', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1094', 'Taimoor Auto Copper Store-Lahore', 'N-1079', 'Lahore  Copper Store', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1095', 'Taimoor Auto Gt Road-Lahore', 'N-1080', 'Lahore  Gt Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1096', 'Taj Din Auto GT Road Pso Pump Lahore', 'N-1081', 'Lahore  Gt Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1097', 'Tayyeba Lube ShopTufail Road Saddar Cant', 'N-1082', 'Lahore  Sadar', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1098', 'Touheed Auto Infentri Road-Lahore', 'N-1083', 'Lahore  Infentri Road', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1099', 'Umer Oil Centre Airport Road Bhatta Chow', 'N-1084', 'Lahore  Bhatta Chowk', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1100', 'Unique Auto 204 DHA Phase I Cantt', 'N-1085', 'Lahore  Dha  ', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1101', 'Unique Auto Bhatta Chowk-Lahore', 'N-1086', 'Lahore  Bhatta Chowk', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1102', 'Unique Oil Bhatta Chowk-Lahore', 'N-1087', 'Lahore  Bhatta Chowk', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1103', 'Usama Battaries Centre New Pull Tajpura', 'N-1088', 'Lahore  Tajpura', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1104', 'Usman Auto Bata Pur-Lahore', 'N-1089', 'Lahore  Bata Pur', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1105', 'Usman Auto Taj Bagh-Lahore', 'N-1090', 'Lahore  Taj Bagh', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1106', 'Waheed Auto Daroghy Wala-Lahore', 'N-1091', 'Lahore  Daroghywala', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1107', 'Yaqoob Auto Badian Road-Lahore', 'N-1092', 'Lahore  Badian ', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1108', 'Yaseen Auto Gari Shahu-Lahore', 'N-1093', 'Lahore  Gari Shahu', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1109', 'Yaseen Oil Store Bund Road Daroghy Wala', 'N-1094', 'Lahore  Daroghywala', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1110', 'Z.A Auto Tajpura-Lahore', 'N-1095', 'Lahore  Tajpura', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0'),
('1111', 'Zeeshan Oil Bhatta Chowk-Lahore', 'N-1096', 'Lahore  Bhatta Chowk', '', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', NULL, '0', '0');

### Structure of table `0_dimensions` ###

DROP TABLE IF EXISTS `0_dimensions`;

CREATE TABLE `0_dimensions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reference` varchar(60) NOT NULL DEFAULT '',
  `name` varchar(60) NOT NULL DEFAULT '',
  `type_` tinyint(1) NOT NULL DEFAULT 1,
  `closed` tinyint(1) NOT NULL DEFAULT 0,
  `date_` date NOT NULL DEFAULT '0000-00-00',
  `due_date` date NOT NULL DEFAULT '0000-00-00',
  `dimension_id` int(11) DEFAULT NULL COMMENT 'dimension_id is sub id of dimension l..',
  PRIMARY KEY (`id`),
  UNIQUE KEY `reference` (`reference`),
  KEY `date_` (`date_`),
  KEY `due_date` (`due_date`),
  KEY `type_` (`type_`)
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_dimensions` ###

INSERT INTO `0_dimensions` VALUES
('17', 'CC/001/2023', 'Admin &amp; HR', '1', '0', '2023-01-01', '2023-01-01', '0'),
('18', 'CC/002/2023', 'Accounts &amp; Finance', '1', '0', '2023-01-01', '2023-01-01', '0'),
('19', 'CC/003/2023', 'Sales &amp; Marketing', '1', '0', '2023-01-01', '2023-01-01', '0'),
('20', 'CC/004/2023', 'Procurement Department', '1', '0', '2023-01-01', '2023-01-01', '0'),
('21', 'CC/005/2023', 'Inventory Department', '1', '0', '2023-01-01', '2023-01-01', '0'),
('22', 'CC/006/2023', 'Import Department', '1', '0', '2023-01-01', '2023-01-01', '0'),
('23', 'CC/007/2023', 'Production Department', '1', '0', '2023-01-01', '2023-01-01', '0'),
('24', 'CC/008/2023', 'Maintenance Department', '1', '0', '2023-01-01', '2023-01-01', '0'),
('25', 'CC/009/2023', 'Karachi', '2', '0', '2023-01-01', '2023-01-01', '17'),
('26', 'CC/010/2023', 'Warehouse - Korangi', '2', '0', '2023-01-01', '2023-01-01', '17'),
('27', 'CC/011/2023', 'Hyderabad', '2', '0', '2023-01-01', '2023-01-01', '17'),
('28', 'CC/012/2023', 'Lahore', '2', '0', '2023-01-01', '2023-01-01', '17'),
('29', 'CC/013/2023', 'Hub Factory', '2', '0', '2023-01-01', '2023-01-01', '17');

### Structure of table `0_exchange_rates` ###

DROP TABLE IF EXISTS `0_exchange_rates`;

CREATE TABLE `0_exchange_rates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `curr_code` char(3) NOT NULL DEFAULT '',
  `rate_buy` double NOT NULL DEFAULT 0,
  `rate_sell` double NOT NULL DEFAULT 0,
  `date_` date NOT NULL DEFAULT '0000-00-00',
  PRIMARY KEY (`id`),
  UNIQUE KEY `curr_code` (`curr_code`,`date_`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_exchange_rates` ###

INSERT INTO `0_exchange_rates` VALUES
('1', 'USD', '189.28', '189.28', '2022-05-11'),
('2', 'USD', '189.28', '189.28', '2022-05-17'),
('3', 'USD', '189.28', '189.28', '2022-05-19'),
('4', 'USD', '189.28', '189.28', '2022-05-20'),
('5', 'USD', '189.28', '189.28', '2022-05-22'),
('6', 'USD', '189.28', '189.28', '2022-06-02'),
('7', 'USD', '189.28', '189.28', '2022-06-03'),
('8', 'USD', '189.28', '189.28', '2022-06-09'),
('9', 'USD', '189.28', '189.28', '2022-06-15'),
('10', 'USD', '230', '230', '2022-10-20');

### Structure of table `0_fiscal_year` ###

DROP TABLE IF EXISTS `0_fiscal_year`;

CREATE TABLE `0_fiscal_year` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `begin` date DEFAULT '0000-00-00',
  `end` date DEFAULT '0000-00-00',
  `closed` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `begin` (`begin`),
  UNIQUE KEY `end` (`end`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_fiscal_year` ###

INSERT INTO `0_fiscal_year` VALUES
('1', '2020-01-01', '2020-12-31', '1'),
('2', '2021-01-01', '2021-12-31', '0'),
('3', '2022-01-01', '2022-12-31', '0'),
('4', '2023-01-01', '2023-12-31', '0');

### Structure of table `0_gl_trans` ###

DROP TABLE IF EXISTS `0_gl_trans`;

CREATE TABLE `0_gl_trans` (
  `counter` int(11) NOT NULL AUTO_INCREMENT,
  `type` smallint(6) NOT NULL DEFAULT 0,
  `type_no` int(11) NOT NULL DEFAULT 0,
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `account` varchar(15) NOT NULL DEFAULT '',
  `memo_` tinytext NOT NULL,
  `amount` double NOT NULL DEFAULT 0,
  `dimension_id` int(11) NOT NULL DEFAULT 0,
  `dimension2_id` int(11) NOT NULL DEFAULT 0,
  `person_type_id` int(11) DEFAULT NULL,
  `person_id` tinyblob DEFAULT NULL,
  PRIMARY KEY (`counter`),
  KEY `Type_and_Number` (`type`,`type_no`),
  KEY `dimension_id` (`dimension_id`),
  KEY `dimension2_id` (`dimension2_id`),
  KEY `tran_date` (`tran_date`),
  KEY `account_and_tran_date` (`account`,`tran_date`)
) ENGINE=InnoDB AUTO_INCREMENT=573 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_gl_trans` ###

INSERT INTO `0_gl_trans` VALUES
('1', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-3446.16', '0', '0', NULL, NULL),
('2', '17', '1', '2023-01-16', '1510', 'Opening Balance', '3446.16', '0', '0', NULL, NULL),
('3', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-53058.5', '0', '0', NULL, NULL),
('4', '17', '1', '2023-01-16', '1510', 'Opening Balance', '53058.5', '0', '0', NULL, NULL),
('5', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-24202.75', '0', '0', NULL, NULL),
('6', '17', '1', '2023-01-16', '1510', 'Opening Balance', '24202.75', '0', '0', NULL, NULL),
('7', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-40315.35', '0', '0', NULL, NULL),
('8', '17', '1', '2023-01-16', '1510', 'Opening Balance', '40315.35', '0', '0', NULL, NULL),
('9', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-232108.68', '0', '0', NULL, NULL),
('10', '17', '1', '2023-01-16', '1510', 'Opening Balance', '232108.68', '0', '0', NULL, NULL),
('11', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-703273.8', '0', '0', NULL, NULL),
('12', '17', '1', '2023-01-16', '1510', 'Opening Balance', '703273.8', '0', '0', NULL, NULL),
('13', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-8615.4', '0', '0', NULL, NULL),
('14', '17', '1', '2023-01-16', '1510', 'Opening Balance', '8615.4', '0', '0', NULL, NULL),
('15', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-5984311.26', '0', '0', NULL, NULL),
('16', '17', '1', '2023-01-16', '1510', 'Opening Balance', '5984311.26', '0', '0', NULL, NULL),
('17', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-949143.3', '0', '0', NULL, NULL),
('18', '17', '1', '2023-01-16', '1510', 'Opening Balance', '949143.3', '0', '0', NULL, NULL),
('19', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-11569.05', '0', '0', NULL, NULL),
('20', '17', '1', '2023-01-16', '1510', 'Opening Balance', '11569.05', '0', '0', NULL, NULL),
('21', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-1480.82', '0', '0', NULL, NULL),
('22', '17', '1', '2023-01-16', '1510', 'Opening Balance', '1480.82', '0', '0', NULL, NULL),
('23', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-2026.91', '0', '0', NULL, NULL),
('24', '17', '1', '2023-01-16', '1510', 'Opening Balance', '2026.91', '0', '0', NULL, NULL),
('25', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-1669.22', '0', '0', NULL, NULL),
('26', '17', '1', '2023-01-16', '1510', 'Opening Balance', '1669.22', '0', '0', NULL, NULL),
('27', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-210679.41', '0', '0', NULL, NULL),
('28', '17', '1', '2023-01-16', '1510', 'Opening Balance', '210679.41', '0', '0', NULL, NULL),
('29', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-1461.55', '0', '0', NULL, NULL),
('30', '17', '1', '2023-01-16', '1510', 'Opening Balance', '1461.55', '0', '0', NULL, NULL),
('31', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-300817.29', '0', '0', NULL, NULL),
('32', '17', '1', '2023-01-16', '1510', 'Opening Balance', '300817.29', '0', '0', NULL, NULL),
('33', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-1192.3', '0', '0', NULL, NULL),
('34', '17', '1', '2023-01-16', '1510', 'Opening Balance', '1192.3', '0', '0', NULL, NULL),
('35', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-5046.16', '0', '0', NULL, NULL),
('36', '17', '1', '2023-01-16', '1510', 'Opening Balance', '5046.16', '0', '0', NULL, NULL),
('37', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-3153.85', '0', '0', NULL, NULL),
('38', '17', '1', '2023-01-16', '1510', 'Opening Balance', '3153.85', '0', '0', NULL, NULL),
('39', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-2284.59', '0', '0', NULL, NULL),
('40', '17', '1', '2023-01-16', '1510', 'Opening Balance', '2284.59', '0', '0', NULL, NULL),
('41', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-41953.38', '0', '0', NULL, NULL),
('42', '17', '1', '2023-01-16', '1510', 'Opening Balance', '41953.38', '0', '0', NULL, NULL),
('43', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-2284.59', '0', '0', NULL, NULL),
('44', '17', '1', '2023-01-16', '1510', 'Opening Balance', '2284.59', '0', '0', NULL, NULL),
('45', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-2861.52', '0', '0', NULL, NULL),
('46', '17', '1', '2023-01-16', '1510', 'Opening Balance', '2861.52', '0', '0', NULL, NULL),
('47', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-5000.06', '0', '0', NULL, NULL),
('48', '17', '1', '2023-01-16', '1510', 'Opening Balance', '5000.06', '0', '0', NULL, NULL),
('49', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-26184.16', '0', '0', NULL, NULL),
('50', '17', '1', '2023-01-16', '1510', 'Opening Balance', '26184.16', '0', '0', NULL, NULL),
('51', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-102785.22', '0', '0', NULL, NULL),
('52', '17', '1', '2023-01-16', '1510', 'Opening Balance', '102785.22', '0', '0', NULL, NULL),
('53', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-2630.76', '0', '0', NULL, NULL),
('54', '17', '1', '2023-01-16', '1510', 'Opening Balance', '2630.76', '0', '0', NULL, NULL),
('55', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-2430.76', '0', '0', NULL, NULL),
('56', '17', '1', '2023-01-16', '1510', 'Opening Balance', '2430.76', '0', '0', NULL, NULL),
('57', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-176923', '0', '0', NULL, NULL),
('58', '17', '1', '2023-01-16', '1510', 'Opening Balance', '176923', '0', '0', NULL, NULL),
('59', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-176.92', '0', '0', NULL, NULL),
('60', '17', '1', '2023-01-16', '1510', 'Opening Balance', '176.92', '0', '0', NULL, NULL),
('61', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-815.4', '0', '0', NULL, NULL),
('62', '17', '1', '2023-01-16', '1510', 'Opening Balance', '815.4', '0', '0', NULL, NULL),
('63', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-5484.52', '0', '0', NULL, NULL),
('64', '17', '1', '2023-01-16', '1510', 'Opening Balance', '5484.52', '0', '0', NULL, NULL),
('65', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-6146.19', '0', '0', NULL, NULL),
('66', '17', '1', '2023-01-16', '1510', 'Opening Balance', '6146.19', '0', '0', NULL, NULL),
('67', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-4865.42', '0', '0', NULL, NULL),
('68', '17', '1', '2023-01-16', '1510', 'Opening Balance', '4865.42', '0', '0', NULL, NULL),
('69', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-266646.63', '0', '0', NULL, NULL),
('70', '17', '1', '2023-01-16', '1510', 'Opening Balance', '266646.63', '0', '0', NULL, NULL),
('71', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-15917.55', '0', '0', NULL, NULL),
('72', '17', '1', '2023-01-16', '1510', 'Opening Balance', '15917.55', '0', '0', NULL, NULL),
('73', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-24202.75', '0', '0', NULL, NULL),
('74', '17', '1', '2023-01-16', '1510', 'Opening Balance', '24202.75', '0', '0', NULL, NULL),
('75', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-40315.35', '0', '0', NULL, NULL),
('76', '17', '1', '2023-01-16', '1510', 'Opening Balance', '40315.35', '0', '0', NULL, NULL),
('77', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-316782.06', '0', '0', NULL, NULL),
('78', '17', '1', '2023-01-16', '1510', 'Opening Balance', '316782.06', '0', '0', NULL, NULL),
('79', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-278561.9', '0', '0', NULL, NULL),
('80', '17', '1', '2023-01-16', '1510', 'Opening Balance', '278561.9', '0', '0', NULL, NULL),
('81', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-36968.82', '0', '0', NULL, NULL),
('82', '17', '1', '2023-01-16', '1510', 'Opening Balance', '36968.82', '0', '0', NULL, NULL),
('83', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-1904006.73', '0', '0', NULL, NULL),
('84', '17', '1', '2023-01-16', '1510', 'Opening Balance', '1904006.73', '0', '0', NULL, NULL),
('85', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-353073', '0', '0', NULL, NULL),
('86', '17', '1', '2023-01-16', '1510', 'Opening Balance', '353073', '0', '0', NULL, NULL),
('87', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-1389024.45', '0', '0', NULL, NULL),
('88', '17', '1', '2023-01-16', '1510', 'Opening Balance', '1389024.45', '0', '0', NULL, NULL),
('89', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-79829.66', '0', '0', NULL, NULL),
('90', '17', '1', '2023-01-16', '1510', 'Opening Balance', '79829.66', '0', '0', NULL, NULL),
('91', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-36245.92', '0', '0', NULL, NULL),
('92', '17', '1', '2023-01-16', '1510', 'Opening Balance', '36245.92', '0', '0', NULL, NULL),
('93', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-40538.2', '0', '0', NULL, NULL),
('94', '17', '1', '2023-01-16', '1510', 'Opening Balance', '40538.2', '0', '0', NULL, NULL),
('95', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-21692.4', '0', '0', NULL, NULL),
('96', '17', '1', '2023-01-16', '1510', 'Opening Balance', '21692.4', '0', '0', NULL, NULL),
('97', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-19523.16', '0', '0', NULL, NULL),
('98', '17', '1', '2023-01-16', '1510', 'Opening Balance', '19523.16', '0', '0', NULL, NULL),
('99', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-40299.74', '0', '0', NULL, NULL),
('100', '17', '1', '2023-01-16', '1510', 'Opening Balance', '40299.74', '0', '0', NULL, NULL),
('101', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-38877.23', '0', '0', NULL, NULL),
('102', '17', '1', '2023-01-16', '1510', 'Opening Balance', '38877.23', '0', '0', NULL, NULL),
('103', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-113268.5', '0', '0', NULL, NULL),
('104', '17', '1', '2023-01-16', '1510', 'Opening Balance', '113268.5', '0', '0', NULL, NULL),
('105', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-21580.63', '0', '0', NULL, NULL),
('106', '17', '1', '2023-01-16', '1510', 'Opening Balance', '21580.63', '0', '0', NULL, NULL),
('107', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-35769', '0', '0', NULL, NULL),
('108', '17', '1', '2023-01-16', '1510', 'Opening Balance', '35769', '0', '0', NULL, NULL),
('109', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-76323.17', '0', '0', NULL, NULL),
('110', '17', '1', '2023-01-16', '1510', 'Opening Balance', '76323.17', '0', '0', NULL, NULL),
('111', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-68953.08', '0', '0', NULL, NULL),
('112', '17', '1', '2023-01-16', '1510', 'Opening Balance', '68953.08', '0', '0', NULL, NULL),
('113', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-122952.48', '0', '0', NULL, NULL),
('114', '17', '1', '2023-01-16', '1510', 'Opening Balance', '122952.48', '0', '0', NULL, NULL),
('115', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-123990.93', '0', '0', NULL, NULL),
('116', '17', '1', '2023-01-16', '1510', 'Opening Balance', '123990.93', '0', '0', NULL, NULL),
('117', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-80837.94', '0', '0', NULL, NULL),
('118', '17', '1', '2023-01-16', '1510', 'Opening Balance', '80837.94', '0', '0', NULL, NULL),
('119', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-8077.02', '0', '0', NULL, NULL),
('120', '17', '1', '2023-01-16', '1510', 'Opening Balance', '8077.02', '0', '0', NULL, NULL),
('121', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-16984.32', '0', '0', NULL, NULL),
('122', '17', '1', '2023-01-16', '1510', 'Opening Balance', '16984.32', '0', '0', NULL, NULL),
('123', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-55969.56', '0', '0', NULL, NULL),
('124', '17', '1', '2023-01-16', '1510', 'Opening Balance', '55969.56', '0', '0', NULL, NULL),
('125', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-17692.3', '0', '0', NULL, NULL),
('126', '17', '1', '2023-01-16', '1510', 'Opening Balance', '17692.3', '0', '0', NULL, NULL),
('127', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-41576.2', '0', '0', NULL, NULL),
('128', '17', '1', '2023-01-16', '1510', 'Opening Balance', '41576.2', '0', '0', NULL, NULL),
('129', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-112932.9', '0', '0', NULL, NULL),
('130', '17', '1', '2023-01-16', '1510', 'Opening Balance', '112932.9', '0', '0', NULL, NULL),
('131', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-27776.44', '0', '0', NULL, NULL),
('132', '17', '1', '2023-01-16', '1510', 'Opening Balance', '27776.44', '0', '0', NULL, NULL),
('133', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-449064.18', '0', '0', NULL, NULL),
('134', '17', '1', '2023-01-16', '1510', 'Opening Balance', '449064.18', '0', '0', NULL, NULL),
('135', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-146174.14', '0', '0', NULL, NULL),
('136', '17', '1', '2023-01-16', '1510', 'Opening Balance', '146174.14', '0', '0', NULL, NULL),
('137', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-125354.07', '0', '0', NULL, NULL),
('138', '17', '1', '2023-01-16', '1510', 'Opening Balance', '125354.07', '0', '0', NULL, NULL),
('139', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-23240.5', '0', '0', NULL, NULL),
('140', '17', '1', '2023-01-16', '1510', 'Opening Balance', '23240.5', '0', '0', NULL, NULL),
('141', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-27824.7', '0', '0', NULL, NULL),
('142', '17', '1', '2023-01-16', '1510', 'Opening Balance', '27824.7', '0', '0', NULL, NULL),
('143', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-21915.74', '0', '0', NULL, NULL),
('144', '17', '1', '2023-01-16', '1510', 'Opening Balance', '21915.74', '0', '0', NULL, NULL),
('145', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-135188.75', '0', '0', NULL, NULL),
('146', '17', '1', '2023-01-16', '1510', 'Opening Balance', '135188.75', '0', '0', NULL, NULL),
('147', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-8446.06', '0', '0', NULL, NULL),
('148', '17', '1', '2023-01-16', '1510', 'Opening Balance', '8446.06', '0', '0', NULL, NULL),
('149', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-351659.94', '0', '0', NULL, NULL),
('150', '17', '1', '2023-01-16', '1510', 'Opening Balance', '351659.94', '0', '0', NULL, NULL),
('151', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-192113.25', '0', '0', NULL, NULL),
('152', '17', '1', '2023-01-16', '1510', 'Opening Balance', '192113.25', '0', '0', NULL, NULL),
('153', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-81229.5', '0', '0', NULL, NULL),
('154', '17', '1', '2023-01-16', '1510', 'Opening Balance', '81229.5', '0', '0', NULL, NULL),
('155', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-4038.6', '0', '0', NULL, NULL),
('156', '17', '1', '2023-01-16', '1510', 'Opening Balance', '4038.6', '0', '0', NULL, NULL),
('157', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-100391.66', '0', '0', NULL, NULL),
('158', '17', '1', '2023-01-16', '1510', 'Opening Balance', '100391.66', '0', '0', NULL, NULL),
('159', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-36246.44', '0', '0', NULL, NULL),
('160', '17', '1', '2023-01-16', '1510', 'Opening Balance', '36246.44', '0', '0', NULL, NULL),
('161', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-17049.89', '0', '0', NULL, NULL),
('162', '17', '1', '2023-01-16', '1510', 'Opening Balance', '17049.89', '0', '0', NULL, NULL),
('163', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-14784.52', '0', '0', NULL, NULL),
('164', '17', '1', '2023-01-16', '1510', 'Opening Balance', '14784.52', '0', '0', NULL, NULL),
('165', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-16407.51', '0', '0', NULL, NULL),
('166', '17', '1', '2023-01-16', '1510', 'Opening Balance', '16407.51', '0', '0', NULL, NULL),
('167', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-46107.18', '0', '0', NULL, NULL),
('168', '17', '1', '2023-01-16', '1510', 'Opening Balance', '46107.18', '0', '0', NULL, NULL),
('169', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-37915.14', '0', '0', NULL, NULL),
('170', '17', '1', '2023-01-16', '1510', 'Opening Balance', '37915.14', '0', '0', NULL, NULL),
('171', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-71539.32', '0', '0', NULL, NULL),
('172', '17', '1', '2023-01-16', '1510', 'Opening Balance', '71539.32', '0', '0', NULL, NULL),
('173', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-3892.24', '0', '0', NULL, NULL),
('174', '17', '1', '2023-01-16', '1510', 'Opening Balance', '3892.24', '0', '0', NULL, NULL),
('175', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-41846.4', '0', '0', NULL, NULL),
('176', '17', '1', '2023-01-16', '1510', 'Opening Balance', '41846.4', '0', '0', NULL, NULL),
('177', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-34638.34', '0', '0', NULL, NULL),
('178', '17', '1', '2023-01-16', '1510', 'Opening Balance', '34638.34', '0', '0', NULL, NULL),
('179', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-41322.92', '0', '0', NULL, NULL),
('180', '17', '1', '2023-01-16', '1510', 'Opening Balance', '41322.92', '0', '0', NULL, NULL),
('181', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-15692.32', '0', '0', NULL, NULL),
('182', '17', '1', '2023-01-16', '1510', 'Opening Balance', '15692.32', '0', '0', NULL, NULL),
('183', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-42461.52', '0', '0', NULL, NULL),
('184', '17', '1', '2023-01-16', '1510', 'Opening Balance', '42461.52', '0', '0', NULL, NULL),
('185', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-12030.56', '0', '0', NULL, NULL),
('186', '17', '1', '2023-01-16', '1510', 'Opening Balance', '12030.56', '0', '0', NULL, NULL),
('187', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-52797.15', '0', '0', NULL, NULL),
('188', '17', '1', '2023-01-16', '1510', 'Opening Balance', '52797.15', '0', '0', NULL, NULL),
('189', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-118085.31', '0', '0', NULL, NULL),
('190', '17', '1', '2023-01-16', '1510', 'Opening Balance', '118085.31', '0', '0', NULL, NULL),
('191', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-115923.92', '0', '0', NULL, NULL),
('192', '17', '1', '2023-01-16', '1510', 'Opening Balance', '115923.92', '0', '0', NULL, NULL),
('193', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-12492.33', '0', '0', NULL, NULL),
('194', '17', '1', '2023-01-16', '1510', 'Opening Balance', '12492.33', '0', '0', NULL, NULL),
('195', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-33423.06', '0', '0', NULL, NULL),
('196', '17', '1', '2023-01-16', '1510', 'Opening Balance', '33423.06', '0', '0', NULL, NULL),
('197', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-160271.75', '0', '0', NULL, NULL),
('198', '17', '1', '2023-01-16', '1510', 'Opening Balance', '160271.75', '0', '0', NULL, NULL),
('199', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-4676.96', '0', '0', NULL, NULL),
('200', '17', '1', '2023-01-16', '1510', 'Opening Balance', '4676.96', '0', '0', NULL, NULL),
('201', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-88585.45', '0', '0', NULL, NULL),
('202', '17', '1', '2023-01-16', '1510', 'Opening Balance', '88585.45', '0', '0', NULL, NULL),
('203', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-24879.75', '0', '0', NULL, NULL),
('204', '17', '1', '2023-01-16', '1510', 'Opening Balance', '24879.75', '0', '0', NULL, NULL),
('205', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-211188.04', '0', '0', NULL, NULL),
('206', '17', '1', '2023-01-16', '1510', 'Opening Balance', '211188.04', '0', '0', NULL, NULL),
('207', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-511579.1', '0', '0', NULL, NULL),
('208', '17', '1', '2023-01-16', '1510', 'Opening Balance', '511579.1', '0', '0', NULL, NULL),
('209', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-1938.44', '0', '0', NULL, NULL),
('210', '17', '1', '2023-01-16', '1510', 'Opening Balance', '1938.44', '0', '0', NULL, NULL),
('211', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-6461.55', '0', '0', NULL, NULL),
('212', '17', '1', '2023-01-16', '1510', 'Opening Balance', '6461.55', '0', '0', NULL, NULL),
('213', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-3574476.06', '0', '0', NULL, NULL),
('214', '17', '1', '2023-01-16', '1510', 'Opening Balance', '3574476.06', '0', '0', NULL, NULL),
('215', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-1082687.97', '0', '0', NULL, NULL),
('216', '17', '1', '2023-01-16', '1510', 'Opening Balance', '1082687.97', '0', '0', NULL, NULL),
('217', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-1127859.3', '0', '0', NULL, NULL),
('218', '17', '1', '2023-01-16', '1510', 'Opening Balance', '1127859.3', '0', '0', NULL, NULL),
('219', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-310972.2', '0', '0', NULL, NULL),
('220', '17', '1', '2023-01-16', '1510', 'Opening Balance', '310972.2', '0', '0', NULL, NULL),
('221', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-6438.42', '0', '0', NULL, NULL),
('222', '17', '1', '2023-01-16', '1510', 'Opening Balance', '6438.42', '0', '0', NULL, NULL),
('223', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-350893.89', '0', '0', NULL, NULL),
('224', '17', '1', '2023-01-16', '1510', 'Opening Balance', '350893.89', '0', '0', NULL, NULL),
('225', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-61385.1', '0', '0', NULL, NULL),
('226', '17', '1', '2023-01-16', '1510', 'Opening Balance', '61385.1', '0', '0', NULL, NULL),
('227', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-180991.14', '0', '0', NULL, NULL),
('228', '17', '1', '2023-01-16', '1510', 'Opening Balance', '180991.14', '0', '0', NULL, NULL),
('229', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-61461.46', '0', '0', NULL, NULL),
('230', '17', '1', '2023-01-16', '1510', 'Opening Balance', '61461.46', '0', '0', NULL, NULL),
('231', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-329670.95', '0', '0', NULL, NULL),
('232', '17', '1', '2023-01-16', '1510', 'Opening Balance', '329670.95', '0', '0', NULL, NULL),
('233', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-17407.58', '0', '0', NULL, NULL),
('234', '17', '1', '2023-01-16', '1510', 'Opening Balance', '17407.58', '0', '0', NULL, NULL),
('235', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-127937.04', '0', '0', NULL, NULL),
('236', '17', '1', '2023-01-16', '1510', 'Opening Balance', '127937.04', '0', '0', NULL, NULL),
('237', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-496379.1', '0', '0', NULL, NULL),
('238', '17', '1', '2023-01-16', '1510', 'Opening Balance', '496379.1', '0', '0', NULL, NULL),
('239', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-64176.21', '0', '0', NULL, NULL),
('240', '17', '1', '2023-01-16', '1510', 'Opening Balance', '64176.21', '0', '0', NULL, NULL),
('241', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-3576.9', '0', '0', NULL, NULL),
('242', '17', '1', '2023-01-16', '1510', 'Opening Balance', '3576.9', '0', '0', NULL, NULL),
('243', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-4230.82', '0', '0', NULL, NULL),
('244', '17', '1', '2023-01-16', '1510', 'Opening Balance', '4230.82', '0', '0', NULL, NULL),
('245', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-109336.56', '0', '0', NULL, NULL),
('246', '17', '1', '2023-01-16', '1510', 'Opening Balance', '109336.56', '0', '0', NULL, NULL),
('247', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-63292.68', '0', '0', NULL, NULL),
('248', '17', '1', '2023-01-16', '1510', 'Opening Balance', '63292.68', '0', '0', NULL, NULL),
('249', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-352521.84', '0', '0', NULL, NULL),
('250', '17', '1', '2023-01-16', '1510', 'Opening Balance', '352521.84', '0', '0', NULL, NULL),
('251', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-281968.16', '0', '0', NULL, NULL),
('252', '17', '1', '2023-01-16', '1510', 'Opening Balance', '281968.16', '0', '0', NULL, NULL),
('253', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-306000.24', '0', '0', NULL, NULL),
('254', '17', '1', '2023-01-16', '1510', 'Opening Balance', '306000.24', '0', '0', NULL, NULL),
('255', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-226461.44', '0', '0', NULL, NULL),
('256', '17', '1', '2023-01-16', '1510', 'Opening Balance', '226461.44', '0', '0', NULL, NULL),
('257', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-111813.44', '0', '0', NULL, NULL),
('258', '17', '1', '2023-01-16', '1510', 'Opening Balance', '111813.44', '0', '0', NULL, NULL),
('259', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-267247.35', '0', '0', NULL, NULL),
('260', '17', '1', '2023-01-16', '1510', 'Opening Balance', '267247.35', '0', '0', NULL, NULL),
('261', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-78729.4', '0', '0', NULL, NULL),
('262', '17', '1', '2023-01-16', '1510', 'Opening Balance', '78729.4', '0', '0', NULL, NULL),
('263', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-462010.41', '0', '0', NULL, NULL),
('264', '17', '1', '2023-01-16', '1510', 'Opening Balance', '462010.41', '0', '0', NULL, NULL),
('265', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-471734.2', '0', '0', NULL, NULL),
('266', '17', '1', '2023-01-16', '1510', 'Opening Balance', '471734.2', '0', '0', NULL, NULL),
('267', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-893500', '0', '0', NULL, NULL),
('268', '17', '1', '2023-01-16', '1510', 'Opening Balance', '893500', '0', '0', NULL, NULL),
('269', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-295542.87', '0', '0', NULL, NULL),
('270', '17', '1', '2023-01-16', '1510', 'Opening Balance', '295542.87', '0', '0', NULL, NULL),
('271', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-176.92', '0', '0', NULL, NULL),
('272', '17', '1', '2023-01-16', '1510', 'Opening Balance', '176.92', '0', '0', NULL, NULL),
('273', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-147044.16', '0', '0', NULL, NULL),
('274', '17', '1', '2023-01-16', '1510', 'Opening Balance', '147044.16', '0', '0', NULL, NULL),
('275', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-6923.07', '0', '0', NULL, NULL),
('276', '17', '1', '2023-01-16', '1510', 'Opening Balance', '6923.07', '0', '0', NULL, NULL),
('277', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-2238.45', '0', '0', NULL, NULL),
('278', '17', '1', '2023-01-16', '1510', 'Opening Balance', '2238.45', '0', '0', NULL, NULL),
('279', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-7038.45', '0', '0', NULL, NULL),
('280', '17', '1', '2023-01-16', '1510', 'Opening Balance', '7038.45', '0', '0', NULL, NULL),
('281', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-8153.85', '0', '0', NULL, NULL),
('282', '17', '1', '2023-01-16', '1510', 'Opening Balance', '8153.85', '0', '0', NULL, NULL),
('283', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-6776', '0', '0', NULL, NULL),
('284', '17', '1', '2023-01-16', '1510', 'Opening Balance', '6776', '0', '0', NULL, NULL),
('285', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-210208.7', '0', '0', NULL, NULL),
('286', '17', '1', '2023-01-16', '1510', 'Opening Balance', '210208.7', '0', '0', NULL, NULL),
('287', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-304136.7', '0', '0', NULL, NULL),
('288', '17', '1', '2023-01-16', '1510', 'Opening Balance', '304136.7', '0', '0', NULL, NULL),
('289', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-210150.45', '0', '0', NULL, NULL),
('290', '17', '1', '2023-01-16', '1510', 'Opening Balance', '210150.45', '0', '0', NULL, NULL),
('291', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-30120', '0', '0', NULL, NULL),
('292', '17', '1', '2023-01-16', '1510', 'Opening Balance', '30120', '0', '0', NULL, NULL),
('293', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-253294', '0', '0', NULL, NULL),
('294', '17', '1', '2023-01-16', '1510', 'Opening Balance', '253294', '0', '0', NULL, NULL),
('295', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-4987.5', '0', '0', NULL, NULL),
('296', '17', '1', '2023-01-16', '1510', 'Opening Balance', '4987.5', '0', '0', NULL, NULL),
('297', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-46688.51', '0', '0', NULL, NULL),
('298', '17', '1', '2023-01-16', '1510', 'Opening Balance', '46688.51', '0', '0', NULL, NULL),
('299', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-628538.94', '0', '0', NULL, NULL),
('300', '17', '1', '2023-01-16', '1510', 'Opening Balance', '628538.94', '0', '0', NULL, NULL),
('301', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-3342000', '0', '0', NULL, NULL),
('302', '17', '1', '2023-01-16', '1510', 'Opening Balance', '3342000', '0', '0', NULL, NULL),
('303', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-137037.5', '0', '0', NULL, NULL),
('304', '17', '1', '2023-01-16', '1510', 'Opening Balance', '137037.5', '0', '0', NULL, NULL),
('305', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-17331.2', '0', '0', NULL, NULL),
('306', '17', '1', '2023-01-16', '1510', 'Opening Balance', '17331.2', '0', '0', NULL, NULL),
('307', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-161824', '0', '0', NULL, NULL),
('308', '17', '1', '2023-01-16', '1510', 'Opening Balance', '161824', '0', '0', NULL, NULL),
('309', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-61455', '0', '0', NULL, NULL),
('310', '17', '1', '2023-01-16', '1510', 'Opening Balance', '61455', '0', '0', NULL, NULL),
('311', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-17400', '0', '0', NULL, NULL),
('312', '17', '1', '2023-01-16', '1510', 'Opening Balance', '17400', '0', '0', NULL, NULL),
('313', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-3517.4', '0', '0', NULL, NULL),
('314', '17', '1', '2023-01-16', '1510', 'Opening Balance', '3517.4', '0', '0', NULL, NULL),
('315', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-693', '0', '0', NULL, NULL),
('316', '17', '1', '2023-01-16', '1510', 'Opening Balance', '693', '0', '0', NULL, NULL),
('317', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-8159.75', '0', '0', NULL, NULL),
('318', '17', '1', '2023-01-16', '1510', 'Opening Balance', '8159.75', '0', '0', NULL, NULL),
('319', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-48036', '0', '0', NULL, NULL),
('320', '17', '1', '2023-01-16', '1510', 'Opening Balance', '48036', '0', '0', NULL, NULL),
('321', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-1539', '0', '0', NULL, NULL),
('322', '17', '1', '2023-01-16', '1510', 'Opening Balance', '1539', '0', '0', NULL, NULL),
('323', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-30000', '0', '0', NULL, NULL),
('324', '17', '1', '2023-01-16', '1510', 'Opening Balance', '30000', '0', '0', NULL, NULL),
('325', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-13860', '0', '0', NULL, NULL),
('326', '17', '1', '2023-01-16', '1510', 'Opening Balance', '13860', '0', '0', NULL, NULL),
('327', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-41100', '0', '0', NULL, NULL),
('328', '17', '1', '2023-01-16', '1510', 'Opening Balance', '41100', '0', '0', NULL, NULL),
('329', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-45320', '0', '0', NULL, NULL),
('330', '17', '1', '2023-01-16', '1510', 'Opening Balance', '45320', '0', '0', NULL, NULL),
('331', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-20528', '0', '0', NULL, NULL),
('332', '17', '1', '2023-01-16', '1510', 'Opening Balance', '20528', '0', '0', NULL, NULL),
('333', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-1552050', '0', '0', NULL, NULL),
('334', '17', '1', '2023-01-16', '1510', 'Opening Balance', '1552050', '0', '0', NULL, NULL),
('335', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-653705', '0', '0', NULL, NULL),
('336', '17', '1', '2023-01-16', '1510', 'Opening Balance', '653705', '0', '0', NULL, NULL),
('337', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-24517.5', '0', '0', NULL, NULL),
('338', '17', '1', '2023-01-16', '1510', 'Opening Balance', '24517.5', '0', '0', NULL, NULL),
('339', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-79180', '0', '0', NULL, NULL),
('340', '17', '1', '2023-01-16', '1510', 'Opening Balance', '79180', '0', '0', NULL, NULL),
('341', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-35250', '0', '0', NULL, NULL),
('342', '17', '1', '2023-01-16', '1510', 'Opening Balance', '35250', '0', '0', NULL, NULL),
('343', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-21920', '0', '0', NULL, NULL),
('344', '17', '1', '2023-01-16', '1510', 'Opening Balance', '21920', '0', '0', NULL, NULL),
('345', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-35224', '0', '0', NULL, NULL),
('346', '17', '1', '2023-01-16', '1510', 'Opening Balance', '35224', '0', '0', NULL, NULL),
('347', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-36030', '0', '0', NULL, NULL),
('348', '17', '1', '2023-01-16', '1510', 'Opening Balance', '36030', '0', '0', NULL, NULL),
('349', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-44880', '0', '0', NULL, NULL),
('350', '17', '1', '2023-01-16', '1510', 'Opening Balance', '44880', '0', '0', NULL, NULL),
('351', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-28085', '0', '0', NULL, NULL),
('352', '17', '1', '2023-01-16', '1510', 'Opening Balance', '28085', '0', '0', NULL, NULL),
('353', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-671781.38', '0', '0', NULL, NULL),
('354', '17', '1', '2023-01-16', '1510', 'Opening Balance', '671781.38', '0', '0', NULL, NULL),
('355', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-614320.08', '0', '0', NULL, NULL),
('356', '17', '1', '2023-01-16', '1510', 'Opening Balance', '614320.08', '0', '0', NULL, NULL),
('357', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-5400', '0', '0', NULL, NULL),
('358', '17', '1', '2023-01-16', '1510', 'Opening Balance', '5400', '0', '0', NULL, NULL),
('359', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-20520', '0', '0', NULL, NULL),
('360', '17', '1', '2023-01-16', '1510', 'Opening Balance', '20520', '0', '0', NULL, NULL),
('361', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-8921.5', '0', '0', NULL, NULL),
('362', '17', '1', '2023-01-16', '1510', 'Opening Balance', '8921.5', '0', '0', NULL, NULL),
('363', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-319080', '0', '0', NULL, NULL),
('364', '17', '1', '2023-01-16', '1510', 'Opening Balance', '319080', '0', '0', NULL, NULL),
('365', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-3540', '0', '0', NULL, NULL),
('366', '17', '1', '2023-01-16', '1510', 'Opening Balance', '3540', '0', '0', NULL, NULL),
('367', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-2156', '0', '0', NULL, NULL),
('368', '17', '1', '2023-01-16', '1510', 'Opening Balance', '2156', '0', '0', NULL, NULL),
('369', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-1355600', '0', '0', NULL, NULL),
('370', '17', '1', '2023-01-16', '1510', 'Opening Balance', '1355600', '0', '0', NULL, NULL),
('371', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-1096425', '0', '0', NULL, NULL),
('372', '17', '1', '2023-01-16', '1510', 'Opening Balance', '1096425', '0', '0', NULL, NULL),
('373', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-805644', '0', '0', NULL, NULL),
('374', '17', '1', '2023-01-16', '1510', 'Opening Balance', '805644', '0', '0', NULL, NULL),
('375', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-242643.9', '0', '0', NULL, NULL),
('376', '17', '1', '2023-01-16', '1510', 'Opening Balance', '242643.9', '0', '0', NULL, NULL),
('377', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-385883.68', '0', '0', NULL, NULL),
('378', '17', '1', '2023-01-16', '1510', 'Opening Balance', '385883.68', '0', '0', NULL, NULL),
('379', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-81600', '0', '0', NULL, NULL),
('380', '17', '1', '2023-01-16', '1510', 'Opening Balance', '81600', '0', '0', NULL, NULL),
('381', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-18272', '0', '0', NULL, NULL),
('382', '17', '1', '2023-01-16', '1510', 'Opening Balance', '18272', '0', '0', NULL, NULL),
('383', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-197078', '0', '0', NULL, NULL),
('384', '17', '1', '2023-01-16', '1510', 'Opening Balance', '197078', '0', '0', NULL, NULL),
('385', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-58092.5', '0', '0', NULL, NULL),
('386', '17', '1', '2023-01-16', '1510', 'Opening Balance', '58092.5', '0', '0', NULL, NULL),
('387', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-13167', '0', '0', NULL, NULL),
('388', '17', '1', '2023-01-16', '1510', 'Opening Balance', '13167', '0', '0', NULL, NULL),
('389', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-1276784.6', '0', '0', NULL, NULL),
('390', '17', '1', '2023-01-16', '1510', 'Opening Balance', '1276784.6', '0', '0', NULL, NULL),
('391', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-10128', '0', '0', NULL, NULL),
('392', '17', '1', '2023-01-16', '1510', 'Opening Balance', '10128', '0', '0', NULL, NULL),
('393', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-2783722.08', '0', '0', NULL, NULL),
('394', '17', '1', '2023-01-16', '1510', 'Opening Balance', '2783722.08', '0', '0', NULL, NULL),
('395', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-1060109.91', '0', '0', NULL, NULL),
('396', '17', '1', '2023-01-16', '1510', 'Opening Balance', '1060109.91', '0', '0', NULL, NULL),
('397', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-4472', '0', '0', NULL, NULL),
('398', '17', '1', '2023-01-16', '1510', 'Opening Balance', '4472', '0', '0', NULL, NULL),
('399', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-2988983.04', '0', '0', NULL, NULL),
('400', '17', '1', '2023-01-16', '1510', 'Opening Balance', '2988983.04', '0', '0', NULL, NULL),
('401', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-2035719.4', '0', '0', NULL, NULL),
('402', '17', '1', '2023-01-16', '1510', 'Opening Balance', '2035719.4', '0', '0', NULL, NULL),
('403', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-188448', '0', '0', NULL, NULL),
('404', '17', '1', '2023-01-16', '1510', 'Opening Balance', '188448', '0', '0', NULL, NULL),
('405', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-438060', '0', '0', NULL, NULL),
('406', '17', '1', '2023-01-16', '1510', 'Opening Balance', '438060', '0', '0', NULL, NULL),
('407', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-1133118', '0', '0', NULL, NULL),
('408', '17', '1', '2023-01-16', '1510', 'Opening Balance', '1133118', '0', '0', NULL, NULL),
('409', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-82574', '0', '0', NULL, NULL),
('410', '17', '1', '2023-01-16', '1510', 'Opening Balance', '82574', '0', '0', NULL, NULL),
('411', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-223389.7', '0', '0', NULL, NULL),
('412', '17', '1', '2023-01-16', '1510', 'Opening Balance', '223389.7', '0', '0', NULL, NULL),
('413', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-138527.15', '0', '0', NULL, NULL),
('414', '17', '1', '2023-01-16', '1510', 'Opening Balance', '138527.15', '0', '0', NULL, NULL),
('415', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-72000', '0', '0', NULL, NULL),
('416', '17', '1', '2023-01-16', '1510', 'Opening Balance', '72000', '0', '0', NULL, NULL),
('417', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-122724', '0', '0', NULL, NULL),
('418', '17', '1', '2023-01-16', '1510', 'Opening Balance', '122724', '0', '0', NULL, NULL),
('419', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-3108', '0', '0', NULL, NULL),
('420', '17', '1', '2023-01-16', '1510', 'Opening Balance', '3108', '0', '0', NULL, NULL),
('421', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-41818', '0', '0', NULL, NULL),
('422', '17', '1', '2023-01-16', '1510', 'Opening Balance', '41818', '0', '0', NULL, NULL),
('423', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-15300', '0', '0', NULL, NULL),
('424', '17', '1', '2023-01-16', '1510', 'Opening Balance', '15300', '0', '0', NULL, NULL),
('425', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-42800', '0', '0', NULL, NULL),
('426', '17', '1', '2023-01-16', '1510', 'Opening Balance', '42800', '0', '0', NULL, NULL),
('427', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-24100', '0', '0', NULL, NULL),
('428', '17', '1', '2023-01-16', '1510', 'Opening Balance', '24100', '0', '0', NULL, NULL),
('429', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-105850', '0', '0', NULL, NULL),
('430', '17', '1', '2023-01-16', '1510', 'Opening Balance', '105850', '0', '0', NULL, NULL),
('431', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-113176', '0', '0', NULL, NULL),
('432', '17', '1', '2023-01-16', '1510', 'Opening Balance', '113176', '0', '0', NULL, NULL),
('433', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-216016', '0', '0', NULL, NULL),
('434', '17', '1', '2023-01-16', '1510', 'Opening Balance', '216016', '0', '0', NULL, NULL),
('435', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-5760', '0', '0', NULL, NULL),
('436', '17', '1', '2023-01-16', '1510', 'Opening Balance', '5760', '0', '0', NULL, NULL),
('437', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-20400', '0', '0', NULL, NULL),
('438', '17', '1', '2023-01-16', '1510', 'Opening Balance', '20400', '0', '0', NULL, NULL),
('439', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-26640', '0', '0', NULL, NULL),
('440', '17', '1', '2023-01-16', '1510', 'Opening Balance', '26640', '0', '0', NULL, NULL),
('441', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-4050', '0', '0', NULL, NULL),
('442', '17', '1', '2023-01-16', '1510', 'Opening Balance', '4050', '0', '0', NULL, NULL),
('443', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-154350', '0', '0', NULL, NULL),
('444', '17', '1', '2023-01-16', '1510', 'Opening Balance', '154350', '0', '0', NULL, NULL),
('445', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-59280', '0', '0', NULL, NULL),
('446', '17', '1', '2023-01-16', '1510', 'Opening Balance', '59280', '0', '0', NULL, NULL),
('447', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-166405', '0', '0', NULL, NULL),
('448', '17', '1', '2023-01-16', '1510', 'Opening Balance', '166405', '0', '0', NULL, NULL),
('449', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-156200', '0', '0', NULL, NULL),
('450', '17', '1', '2023-01-16', '1510', 'Opening Balance', '156200', '0', '0', NULL, NULL),
('451', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-99820', '0', '0', NULL, NULL),
('452', '17', '1', '2023-01-16', '1510', 'Opening Balance', '99820', '0', '0', NULL, NULL),
('453', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-16905', '0', '0', NULL, NULL),
('454', '17', '1', '2023-01-16', '1510', 'Opening Balance', '16905', '0', '0', NULL, NULL),
('455', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-61270', '0', '0', NULL, NULL),
('456', '17', '1', '2023-01-16', '1510', 'Opening Balance', '61270', '0', '0', NULL, NULL),
('457', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-44550', '0', '0', NULL, NULL),
('458', '17', '1', '2023-01-16', '1510', 'Opening Balance', '44550', '0', '0', NULL, NULL),
('459', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-12710', '0', '0', NULL, NULL),
('460', '17', '1', '2023-01-16', '1510', 'Opening Balance', '12710', '0', '0', NULL, NULL),
('461', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-81400', '0', '0', NULL, NULL),
('462', '17', '1', '2023-01-16', '1510', 'Opening Balance', '81400', '0', '0', NULL, NULL),
('463', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-35090', '0', '0', NULL, NULL),
('464', '17', '1', '2023-01-16', '1510', 'Opening Balance', '35090', '0', '0', NULL, NULL),
('465', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-62930', '0', '0', NULL, NULL),
('466', '17', '1', '2023-01-16', '1510', 'Opening Balance', '62930', '0', '0', NULL, NULL),
('467', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-35640', '0', '0', NULL, NULL),
('468', '17', '1', '2023-01-16', '1510', 'Opening Balance', '35640', '0', '0', NULL, NULL),
('469', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-78800', '0', '0', NULL, NULL),
('470', '17', '1', '2023-01-16', '1510', 'Opening Balance', '78800', '0', '0', NULL, NULL),
('471', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-35530', '0', '0', NULL, NULL),
('472', '17', '1', '2023-01-16', '1510', 'Opening Balance', '35530', '0', '0', NULL, NULL),
('473', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-2310', '0', '0', NULL, NULL),
('474', '17', '1', '2023-01-16', '1510', 'Opening Balance', '2310', '0', '0', NULL, NULL),
('475', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-11130', '0', '0', NULL, NULL),
('476', '17', '1', '2023-01-16', '1510', 'Opening Balance', '11130', '0', '0', NULL, NULL),
('477', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-6300', '0', '0', NULL, NULL),
('478', '17', '1', '2023-01-16', '1510', 'Opening Balance', '6300', '0', '0', NULL, NULL),
('479', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-1365', '0', '0', NULL, NULL),
('480', '17', '1', '2023-01-16', '1510', 'Opening Balance', '1365', '0', '0', NULL, NULL),
('481', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-6205', '0', '0', NULL, NULL),
('482', '17', '1', '2023-01-16', '1510', 'Opening Balance', '6205', '0', '0', NULL, NULL),
('483', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-15600', '0', '0', NULL, NULL),
('484', '17', '1', '2023-01-16', '1510', 'Opening Balance', '15600', '0', '0', NULL, NULL),
('485', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-52360', '0', '0', NULL, NULL),
('486', '17', '1', '2023-01-16', '1510', 'Opening Balance', '52360', '0', '0', NULL, NULL),
('487', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-64960', '0', '0', NULL, NULL),
('488', '17', '1', '2023-01-16', '1510', 'Opening Balance', '64960', '0', '0', NULL, NULL),
('489', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-49875', '0', '0', NULL, NULL),
('490', '17', '1', '2023-01-16', '1510', 'Opening Balance', '49875', '0', '0', NULL, NULL),
('491', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-2500', '0', '0', NULL, NULL),
('492', '17', '1', '2023-01-16', '1510', 'Opening Balance', '2500', '0', '0', NULL, NULL),
('493', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-21780', '0', '0', NULL, NULL),
('494', '17', '1', '2023-01-16', '1510', 'Opening Balance', '21780', '0', '0', NULL, NULL),
('495', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-10275', '0', '0', NULL, NULL),
('496', '17', '1', '2023-01-16', '1510', 'Opening Balance', '10275', '0', '0', NULL, NULL),
('497', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-8050', '0', '0', NULL, NULL),
('498', '17', '1', '2023-01-16', '1510', 'Opening Balance', '8050', '0', '0', NULL, NULL),
('499', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-3885', '0', '0', NULL, NULL),
('500', '17', '1', '2023-01-16', '1510', 'Opening Balance', '3885', '0', '0', NULL, NULL),
('501', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-26960', '0', '0', NULL, NULL),
('502', '17', '1', '2023-01-16', '1510', 'Opening Balance', '26960', '0', '0', NULL, NULL),
('503', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-7040', '0', '0', NULL, NULL),
('504', '17', '1', '2023-01-16', '1510', 'Opening Balance', '7040', '0', '0', NULL, NULL),
('505', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-225000', '0', '0', NULL, NULL),
('506', '17', '1', '2023-01-16', '1510', 'Opening Balance', '225000', '0', '0', NULL, NULL),
('507', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-144378', '0', '0', NULL, NULL),
('508', '17', '1', '2023-01-16', '1510', 'Opening Balance', '144378', '0', '0', NULL, NULL),
('509', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-1056.5', '0', '0', NULL, NULL),
('510', '17', '1', '2023-01-16', '1510', 'Opening Balance', '1056.5', '0', '0', NULL, NULL),
('511', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-1026', '0', '0', NULL, NULL),
('512', '17', '1', '2023-01-16', '1510', 'Opening Balance', '1026', '0', '0', NULL, NULL),
('513', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-540', '0', '0', NULL, NULL),
('514', '17', '1', '2023-01-16', '1510', 'Opening Balance', '540', '0', '0', NULL, NULL),
('515', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-7372', '0', '0', NULL, NULL),
('516', '17', '1', '2023-01-16', '1510', 'Opening Balance', '7372', '0', '0', NULL, NULL),
('517', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-142375', '0', '0', NULL, NULL),
('518', '17', '1', '2023-01-16', '1510', 'Opening Balance', '142375', '0', '0', NULL, NULL),
('519', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-32500', '0', '0', NULL, NULL),
('520', '17', '1', '2023-01-16', '1510', 'Opening Balance', '32500', '0', '0', NULL, NULL),
('521', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-28000', '0', '0', NULL, NULL),
('522', '17', '1', '2023-01-16', '1510', 'Opening Balance', '28000', '0', '0', NULL, NULL),
('523', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-1675', '0', '0', NULL, NULL),
('524', '17', '1', '2023-01-16', '1510', 'Opening Balance', '1675', '0', '0', NULL, NULL),
('525', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-10050', '0', '0', NULL, NULL),
('526', '17', '1', '2023-01-16', '1510', 'Opening Balance', '10050', '0', '0', NULL, NULL),
('527', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-6760', '0', '0', NULL, NULL),
('528', '17', '1', '2023-01-16', '1510', 'Opening Balance', '6760', '0', '0', NULL, NULL),
('529', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-42900', '0', '0', NULL, NULL),
('530', '17', '1', '2023-01-16', '1510', 'Opening Balance', '42900', '0', '0', NULL, NULL),
('531', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-13400', '0', '0', NULL, NULL),
('532', '17', '1', '2023-01-16', '1510', 'Opening Balance', '13400', '0', '0', NULL, NULL),
('533', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-23637.6', '0', '0', NULL, NULL),
('534', '17', '1', '2023-01-16', '1510', 'Opening Balance', '23637.6', '0', '0', NULL, NULL),
('535', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-10519', '0', '0', NULL, NULL),
('536', '17', '1', '2023-01-16', '1510', 'Opening Balance', '10519', '0', '0', NULL, NULL),
('537', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-960', '0', '0', NULL, NULL),
('538', '17', '1', '2023-01-16', '1510', 'Opening Balance', '960', '0', '0', NULL, NULL),
('539', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-2400', '0', '0', NULL, NULL),
('540', '17', '1', '2023-01-16', '1510', 'Opening Balance', '2400', '0', '0', NULL, NULL),
('541', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-2400', '0', '0', NULL, NULL),
('542', '17', '1', '2023-01-16', '1510', 'Opening Balance', '2400', '0', '0', NULL, NULL);
INSERT INTO `0_gl_trans` VALUES
('543', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-8748', '0', '0', NULL, NULL),
('544', '17', '1', '2023-01-16', '1510', 'Opening Balance', '8748', '0', '0', NULL, NULL),
('545', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-5083', '0', '0', NULL, NULL),
('546', '17', '1', '2023-01-16', '1510', 'Opening Balance', '5083', '0', '0', NULL, NULL),
('547', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-18804', '0', '0', NULL, NULL),
('548', '17', '1', '2023-01-16', '1510', 'Opening Balance', '18804', '0', '0', NULL, NULL),
('549', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-21390', '0', '0', NULL, NULL),
('550', '17', '1', '2023-01-16', '1510', 'Opening Balance', '21390', '0', '0', NULL, NULL),
('551', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-138000', '0', '0', NULL, NULL),
('552', '17', '1', '2023-01-16', '1510', 'Opening Balance', '138000', '0', '0', NULL, NULL),
('553', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-22177', '0', '0', NULL, NULL),
('554', '17', '1', '2023-01-16', '1510', 'Opening Balance', '22177', '0', '0', NULL, NULL),
('555', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-6014', '0', '0', NULL, NULL),
('556', '17', '1', '2023-01-16', '1510', 'Opening Balance', '6014', '0', '0', NULL, NULL),
('557', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-17169', '0', '0', NULL, NULL),
('558', '17', '1', '2023-01-16', '1510', 'Opening Balance', '17169', '0', '0', NULL, NULL),
('559', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-5369', '0', '0', NULL, NULL),
('560', '17', '1', '2023-01-16', '1510', 'Opening Balance', '5369', '0', '0', NULL, NULL),
('561', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-2832', '0', '0', NULL, NULL),
('562', '17', '1', '2023-01-16', '1510', 'Opening Balance', '2832', '0', '0', NULL, NULL),
('563', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-3825', '0', '0', NULL, NULL),
('564', '17', '1', '2023-01-16', '1510', 'Opening Balance', '3825', '0', '0', NULL, NULL),
('565', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-9911.2', '0', '0', NULL, NULL),
('566', '17', '1', '2023-01-16', '1510', 'Opening Balance', '9911.2', '0', '0', NULL, NULL),
('567', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-31164.9', '0', '0', NULL, NULL),
('568', '17', '1', '2023-01-16', '1510', 'Opening Balance', '31164.9', '0', '0', NULL, NULL),
('569', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-8420.6', '0', '0', NULL, NULL),
('570', '17', '1', '2023-01-16', '1510', 'Opening Balance', '8420.6', '0', '0', NULL, NULL),
('571', '17', '1', '2023-01-16', '5040', 'Opening Balance', '-13155.5', '0', '0', NULL, NULL),
('572', '17', '1', '2023-01-16', '1510', 'Opening Balance', '13155.5', '0', '0', NULL, NULL);

### Structure of table `0_grn_batch` ###

DROP TABLE IF EXISTS `0_grn_batch`;

CREATE TABLE `0_grn_batch` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `supplier_id` int(11) NOT NULL DEFAULT 0,
  `purch_order_no` int(11) DEFAULT NULL,
  `reference` varchar(60) NOT NULL DEFAULT '',
  `delivery_date` date NOT NULL DEFAULT '0000-00-00',
  `loc_code` varchar(5) DEFAULT NULL,
  `rate` double DEFAULT 1,
  `dc_no` varchar(20) NOT NULL DEFAULT '0',
  `vehicle_no` varchar(100) NOT NULL,
  `tax_group_id` int(11) NOT NULL,
  `dimension_id` int(11) NOT NULL,
  `dimension2_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `delivery_date` (`delivery_date`),
  KEY `purch_order_no` (`purch_order_no`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_grn_batch` ###


### Structure of table `0_grn_items` ###

DROP TABLE IF EXISTS `0_grn_items`;

CREATE TABLE `0_grn_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `grn_batch_id` int(11) DEFAULT NULL,
  `po_detail_item` int(11) NOT NULL DEFAULT 0,
  `item_code` varchar(20) NOT NULL DEFAULT '',
  `batch_no` varchar(30) NOT NULL,
  `exp_date` date DEFAULT NULL,
  `description` tinytext DEFAULT NULL,
  `qty_recd` double NOT NULL DEFAULT 0,
  `quantity_inv` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `grn_batch_id` (`grn_batch_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_grn_items` ###


### Structure of table `0_groups` ###

DROP TABLE IF EXISTS `0_groups`;

CREATE TABLE `0_groups` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(60) NOT NULL DEFAULT '',
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `description` (`description`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_groups` ###

INSERT INTO `0_groups` VALUES
('1', 'Karachi', '0'),
('2', 'Hydrabad', '0'),
('3', 'Lahore', '0');

### Structure of table `0_inward_grn` ###

DROP TABLE IF EXISTS `0_inward_grn`;

CREATE TABLE `0_inward_grn` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` int(11) NOT NULL,
  `order_no` int(11) NOT NULL,
  `po_line_id` int(11) NOT NULL,
  `ord_date` date NOT NULL DEFAULT '0000-00-00',
  `qty` double NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=331 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ;

### Data of table `0_inward_grn` ###

INSERT INTO `0_inward_grn` VALUES
('1', '47', '1', '1', '2022-12-31', '500'),
('2', '47', '1', '2', '2022-12-31', '50'),
('3', '47', '1', '3', '2022-12-31', '8'),
('4', '47', '1', '4', '2022-12-31', '10'),
('5', '47', '1', '5', '2022-12-31', '1'),
('6', '47', '2', '6', '2022-12-31', '500'),
('7', '47', '2', '7', '2022-12-31', '50'),
('8', '47', '2', '8', '2022-12-31', '7'),
('9', '48', '1', '1', '2022-12-31', '500'),
('10', '48', '1', '2', '2022-12-31', '50'),
('11', '48', '1', '3', '2022-12-31', '8'),
('12', '48', '1', '4', '2022-12-31', '10'),
('13', '48', '1', '5', '2022-12-31', '1'),
('14', '47', '1', '1', '2022-12-31', '400'),
('15', '47', '1', '2', '2022-12-31', '50'),
('16', '47', '1', '3', '2022-12-31', '8'),
('17', '47', '1', '4', '2022-12-31', '10'),
('18', '47', '1', '5', '2022-12-31', '1'),
('19', '48', '1', '1', '2022-12-31', '500'),
('20', '48', '1', '2', '2022-12-31', '50'),
('21', '48', '1', '3', '2022-12-31', '8'),
('22', '48', '1', '4', '2022-12-31', '10'),
('23', '48', '1', '5', '2022-12-31', '1'),
('24', '47', '3', '9', '2023-01-02', '800'),
('25', '47', '3', '10', '2023-01-02', '800'),
('26', '47', '3', '11', '2023-01-02', '100'),
('27', '45', '3', '9', '2023-01-02', '800'),
('28', '45', '3', '10', '2023-01-02', '800'),
('29', '45', '3', '11', '2023-01-02', '100'),
('30', '47', '4', '12', '2023-01-02', '500'),
('31', '47', '4', '13', '2023-01-02', '500'),
('32', '47', '4', '14', '2023-01-02', '1500'),
('33', '45', '2', '6', '2023-01-02', '400'),
('34', '45', '2', '7', '2023-01-02', '40'),
('35', '45', '2', '8', '2023-01-02', '7'),
('36', '45', '2', '6', '2023-01-02', '100'),
('37', '45', '2', '7', '2023-01-02', '10'),
('38', '45', '2', '8', '2023-01-02', '0'),
('39', '47', '4', '12', '2023-01-02', '200'),
('40', '47', '4', '13', '2023-01-02', '200'),
('41', '47', '4', '14', '2023-01-02', '0'),
('42', '45', '4', '12', '2023-01-02', '700'),
('43', '45', '4', '13', '2023-01-02', '700'),
('44', '45', '4', '14', '2023-01-02', '1500'),
('45', '47', '5', '15', '2023-01-02', '500'),
('46', '47', '5', '16', '2023-01-02', '50.2'),
('47', '47', '5', '17', '2023-01-02', '10.3'),
('48', '47', '5', '18', '2023-01-02', '4.3'),
('49', '47', '5', '19', '2023-01-02', '0.1'),
('50', '45', '5', '15', '2023-01-02', '400'),
('51', '45', '5', '16', '2023-01-02', '30.2'),
('52', '45', '5', '17', '2023-01-02', '10.3'),
('53', '45', '5', '18', '2023-01-02', '4.3'),
('54', '45', '5', '19', '2023-01-02', '0.1'),
('55', '47', '5', '15', '2023-01-02', '290'),
('56', '47', '5', '16', '2023-01-02', '12'),
('57', '47', '5', '17', '2023-01-02', '0'),
('58', '47', '5', '18', '2023-01-02', '0'),
('59', '47', '5', '19', '2023-01-02', '0'),
('60', '45', '5', '15', '2023-01-02', '290'),
('61', '45', '5', '16', '2023-01-02', '32'),
('62', '45', '5', '17', '2023-01-02', '0'),
('63', '45', '5', '18', '2023-01-02', '0'),
('64', '45', '5', '19', '2023-01-02', '0'),
('65', '48', '5', '15', '2023-01-02', '100'),
('66', '48', '5', '16', '2023-01-02', '0'),
('67', '48', '5', '17', '2023-01-02', '0'),
('68', '48', '5', '18', '2023-01-02', '0'),
('69', '48', '5', '19', '2023-01-02', '0'),
('70', '48', '5', '15', '2023-01-02', '100'),
('71', '48', '5', '16', '2023-01-02', '0'),
('72', '48', '5', '17', '2023-01-02', '0'),
('73', '48', '5', '18', '2023-01-02', '0'),
('74', '48', '5', '19', '2023-01-02', '0'),
('75', '47', '5', '15', '2023-01-02', '200'),
('76', '47', '5', '16', '2023-01-02', '0'),
('77', '47', '5', '17', '2023-01-02', '0'),
('78', '47', '5', '18', '2023-01-02', '0'),
('79', '47', '5', '19', '2023-01-02', '0'),
('80', '45', '5', '15', '2023-01-02', '100'),
('81', '45', '5', '16', '2023-01-02', '0'),
('82', '45', '5', '17', '2023-01-02', '0'),
('83', '45', '5', '18', '2023-01-02', '0'),
('84', '45', '5', '19', '2023-01-02', '0'),
('85', '47', '6', '20', '2023-01-04', '450'),
('86', '45', '6', '20', '2023-01-04', '250'),
('87', '45', '6', '20', '2023-01-04', '150'),
('88', '45', '6', '20', '2023-01-04', '50'),
('89', '47', '7', '21', '2023-01-04', '100'),
('90', '45', '7', '21', '2023-01-04', '50'),
('91', '47', '7', '21', '2023-01-04', '100'),
('92', '45', '7', '21', '2023-01-04', '125'),
('93', '48', '7', '21', '2023-01-04', '25'),
('94', '47', '8', '22', '2023-01-04', '20'),
('95', '47', '8', '23', '2023-01-04', '150'),
('96', '45', '8', '22', '2023-01-04', '20'),
('97', '45', '8', '23', '2023-01-04', '150'),
('98', '47', '9', '24', '2023-01-04', '1500'),
('99', '47', '9', '25', '2023-01-04', '1500'),
('100', '45', '9', '24', '2023-01-04', '1500'),
('101', '45', '9', '25', '2023-01-04', '1500'),
('102', '47', '10', '26', '2023-01-04', '30'),
('103', '47', '10', '27', '2023-01-04', '20'),
('104', '45', '10', '26', '2023-01-04', '30'),
('105', '45', '10', '27', '2023-01-04', '20'),
('106', '47', '7', '21', '2023-01-04', '25'),
('107', '45', '7', '21', '2023-01-04', '25'),
('108', '47', '11', '28', '2023-01-06', '2000'),
('109', '47', '11', '29', '2023-01-06', '400'),
('110', '45', '11', '28', '2023-01-06', '1000'),
('111', '45', '11', '29', '2023-01-06', '400'),
('112', '45', '11', '28', '2023-01-06', '1000'),
('113', '45', '11', '29', '2023-01-06', '0'),
('114', '47', '11', '28', '2023-01-06', '2000'),
('115', '47', '11', '29', '2023-01-06', '0'),
('116', '45', '11', '28', '2023-01-06', '2000'),
('117', '45', '11', '29', '2023-01-06', '0'),
('118', '47', '12', '30', '2023-01-06', '50'),
('119', '47', '12', '31', '2023-01-06', '30'),
('120', '47', '12', '32', '2023-01-06', '2'),
('121', '45', '12', '30', '2023-01-06', '50'),
('122', '45', '12', '31', '2023-01-06', '30'),
('123', '45', '12', '32', '2023-01-06', '2'),
('124', '47', '13', '33', '2023-01-06', '1000'),
('125', '47', '13', '34', '2023-01-06', '1000'),
('126', '47', '13', '35', '2023-01-06', '100'),
('127', '45', '13', '33', '2023-01-06', '1000'),
('128', '45', '13', '34', '2023-01-06', '1000'),
('129', '45', '13', '35', '2023-01-06', '100'),
('130', '47', '15', '37', '2023-01-09', '50'),
('131', '45', '15', '37', '2023-01-09', '50'),
('132', '47', '16', '38', '2023-01-10', '800'),
('133', '47', '16', '39', '2023-01-10', '70'),
('134', '47', '16', '40', '2023-01-10', '10.3'),
('135', '47', '16', '41', '2023-01-10', '4.3'),
('136', '47', '16', '42', '2023-01-10', '0.1'),
('137', '45', '16', '38', '2023-01-10', '800'),
('138', '45', '16', '39', '2023-01-10', '70'),
('139', '45', '16', '40', '2023-01-10', '10.3'),
('140', '45', '16', '41', '2023-01-10', '4.3'),
('141', '45', '16', '42', '2023-01-10', '0.1'),
('142', '47', '17', '43', '2023-01-10', '1000'),
('143', '47', '17', '44', '2023-01-10', '1000'),
('144', '47', '17', '45', '2023-01-10', '100'),
('145', '45', '17', '43', '2023-01-10', '1000'),
('146', '45', '17', '44', '2023-01-10', '1000'),
('147', '45', '17', '45', '2023-01-10', '100'),
('148', '47', '18', '46', '2023-01-11', '500'),
('149', '47', '18', '47', '2023-01-11', '80'),
('150', '47', '19', '48', '2023-01-11', '20'),
('151', '47', '19', '49', '2023-01-11', '4.3'),
('152', '47', '19', '50', '2023-01-11', '1'),
('153', '45', '18', '46', '2023-01-11', '400'),
('154', '45', '18', '47', '2023-01-11', '0'),
('155', '47', '18', '46', '2023-01-11', '300'),
('156', '47', '18', '47', '2023-01-11', '0'),
('157', '45', '18', '46', '2023-01-11', '400'),
('158', '45', '18', '47', '2023-01-11', '80'),
('159', '45', '19', '48', '2023-01-11', '20'),
('160', '45', '19', '49', '2023-01-11', '4.3'),
('161', '45', '19', '50', '2023-01-11', '1'),
('162', '47', '20', '51', '2023-01-11', '2000'),
('163', '47', '20', '52', '2023-01-11', '2000'),
('164', '47', '20', '53', '2023-01-11', '100'),
('165', '47', '1', '1', '2023-01-12', '1000'),
('166', '47', '1', '2', '2023-01-12', '100'),
('167', '47', '1', '3', '2023-01-12', '15'),
('168', '47', '1', '4', '2023-01-12', '5'),
('169', '47', '1', '5', '2023-01-12', '5'),
('170', '45', '1', '1', '2023-01-12', '500'),
('171', '45', '1', '2', '2023-01-12', '100'),
('172', '45', '1', '3', '2023-01-12', '15'),
('173', '45', '1', '4', '2023-01-12', '5'),
('174', '45', '1', '5', '2023-01-12', '5'),
('175', '45', '1', '1', '2023-01-12', '500'),
('176', '45', '1', '2', '2023-01-12', '0'),
('177', '45', '1', '3', '2023-01-12', '0'),
('178', '45', '1', '4', '2023-01-12', '0'),
('179', '45', '1', '5', '2023-01-12', '0'),
('180', '47', '2', '6', '2023-01-12', '1000'),
('181', '47', '2', '7', '2023-01-12', '1000'),
('182', '47', '2', '8', '2023-01-12', '100'),
('183', '45', '2', '6', '2023-01-12', '1000'),
('184', '45', '2', '7', '2023-01-12', '1000'),
('185', '45', '2', '8', '2023-01-12', '100'),
('186', '47', '3', '9', '2023-01-12', '500'),
('187', '47', '3', '10', '2023-01-12', '500'),
('188', '47', '3', '11', '2023-01-12', '50'),
('189', '47', '3', '12', '2023-01-12', '500'),
('190', '45', '3', '9', '2023-01-12', '500'),
('191', '45', '3', '10', '2023-01-12', '500'),
('192', '45', '3', '11', '2023-01-12', '50'),
('193', '45', '3', '12', '2023-01-12', '500'),
('194', '47', '4', '13', '2023-01-12', '1000'),
('195', '47', '4', '14', '2023-01-12', '500'),
('196', '47', '4', '15', '2023-01-12', '30'),
('197', '47', '4', '16', '2023-01-12', '180'),
('198', '47', '4', '13', '2023-01-12', '1000'),
('199', '47', '4', '14', '2023-01-12', '500'),
('200', '47', '4', '15', '2023-01-12', '30'),
('201', '47', '4', '16', '2023-01-12', '180'),
('202', '45', '4', '13', '2023-01-12', '1000'),
('203', '45', '4', '14', '2023-01-12', '500'),
('204', '45', '4', '15', '2023-01-12', '30'),
('205', '45', '4', '16', '2023-01-12', '180'),
('206', '47', '5', '17', '2023-01-14', '500'),
('207', '47', '5', '18', '2023-01-14', '200'),
('208', '47', '5', '19', '2023-01-14', '1'),
('209', '47', '5', '20', '2023-01-14', '25'),
('210', '45', '5', '17', '2023-01-14', '500'),
('211', '45', '5', '18', '2023-01-14', '200'),
('212', '45', '5', '19', '2023-01-14', '1'),
('213', '45', '5', '20', '2023-01-14', '25'),
('214', '47', '6', '21', '2023-01-14', '700'),
('215', '45', '6', '21', '2023-01-14', '700'),
('216', '47', '7', '22', '2023-01-16', '2000'),
('217', '47', '7', '23', '2023-01-16', '41000'),
('218', '47', '7', '24', '2023-01-16', '500'),
('219', '45', '7', '22', '2023-01-16', '1000'),
('220', '45', '7', '23', '2023-01-16', '41000'),
('221', '45', '7', '24', '2023-01-16', '500'),
('222', '45', '7', '22', '2023-01-16', '1000'),
('223', '45', '7', '23', '2023-01-16', '41000'),
('224', '45', '7', '24', '2023-01-16', '500'),
('225', '47', '8', '25', '2023-01-16', '1000'),
('226', '47', '8', '26', '2023-01-16', '500'),
('227', '47', '8', '27', '2023-01-16', '16.6'),
('228', '47', '8', '28', '2023-01-16', '500'),
('229', '45', '8', '25', '2023-01-16', '1000'),
('230', '45', '8', '26', '2023-01-16', '500'),
('231', '45', '8', '27', '2023-01-16', '16.6'),
('232', '45', '8', '28', '2023-01-16', '500'),
('233', '47', '9', '29', '2023-01-16', '2000'),
('234', '47', '9', '30', '2023-01-16', '62.2'),
('235', '47', '9', '31', '2023-01-16', '0'),
('236', '47', '9', '32', '2023-01-16', '0'),
('237', '47', '9', '33', '2023-01-16', '0'),
('238', '45', '9', '29', '2023-01-16', '2000'),
('239', '45', '9', '30', '2023-01-16', '62.2'),
('240', '45', '9', '31', '2023-01-16', '0'),
('241', '45', '9', '32', '2023-01-16', '0'),
('242', '45', '9', '33', '2023-01-16', '0'),
('243', '47', '9', '29', '2023-01-16', '0'),
('244', '47', '9', '30', '2023-01-16', '0'),
('245', '47', '9', '31', '2023-01-16', '10.3'),
('246', '47', '9', '32', '2023-01-16', '4.3'),
('247', '47', '9', '33', '2023-01-16', '0.1'),
('248', '45', '9', '29', '2023-01-16', '0'),
('249', '45', '9', '30', '2023-01-16', '0'),
('250', '45', '9', '31', '2023-01-16', '10.3'),
('251', '45', '9', '32', '2023-01-16', '4.3'),
('252', '45', '9', '33', '2023-01-16', '0.1'),
('253', '47', '10', '34', '2023-01-16', '1000'),
('254', '47', '10', '35', '2023-01-16', '1000'),
('255', '47', '10', '36', '2023-01-16', '83.3'),
('256', '45', '10', '34', '2023-01-16', '1000'),
('257', '45', '10', '35', '2023-01-16', '1000'),
('258', '45', '10', '36', '2023-01-16', '83.3'),
('259', '47', '11', '37', '2023-01-18', '2000'),
('260', '47', '11', '38', '2023-01-18', '1000'),
('261', '47', '11', '39', '2023-01-18', '100'),
('262', '45', '11', '37', '2023-01-18', '1000'),
('263', '45', '11', '38', '2023-01-18', '1000'),
('264', '45', '11', '39', '2023-01-18', '100'),
('265', '48', '11', '37', '2023-01-18', '1000'),
('266', '48', '11', '38', '2023-01-18', '0'),
('267', '48', '11', '39', '2023-01-18', '0'),
('268', '47', '11', '37', '2023-01-18', '1000'),
('269', '47', '11', '38', '2023-01-18', '0'),
('270', '47', '11', '39', '2023-01-18', '0'),
('271', '45', '11', '37', '2023-01-18', '1000'),
('272', '45', '11', '38', '2023-01-18', '0'),
('273', '45', '11', '39', '2023-01-18', '0'),
('274', '47', '12', '40', '2023-01-18', '622'),
('275', '47', '12', '41', '2023-01-18', '184.8'),
('276', '47', '12', '42', '2023-01-18', '0.6'),
('277', '47', '13', '43', '2023-01-18', '2000'),
('278', '47', '13', '44', '2023-01-18', '500'),
('279', '47', '13', '45', '2023-01-18', '500'),
('280', '47', '14', '46', '2023-01-18', '2000'),
('281', '47', '14', '47', '2023-01-18', '2000'),
('282', '47', '14', '48', '2023-01-18', '100'),
('283', '47', '14', '49', '2023-01-18', '100'),
('284', '45', '13', '43', '2023-01-18', '2000'),
('285', '45', '13', '44', '2023-01-18', '500'),
('286', '45', '13', '45', '2023-01-18', '500'),
('287', '45', '14', '46', '2023-01-18', '2000'),
('288', '45', '14', '47', '2023-01-18', '2000'),
('289', '45', '14', '48', '2023-01-18', '100'),
('290', '45', '14', '49', '2023-01-18', '100'),
('291', '47', '15', '50', '2023-01-18', '622'),
('292', '47', '15', '51', '2023-01-18', '184.8'),
('293', '47', '15', '52', '2023-01-18', '0.6'),
('294', '45', '15', '50', '2023-01-18', '622'),
('295', '45', '15', '51', '2023-01-18', '184.8'),
('296', '45', '15', '52', '2023-01-18', '0.6'),
('297', '47', '16', '53', '2023-01-18', '740'),
('298', '47', '16', '54', '2023-01-18', '241.8'),
('299', '47', '16', '55', '2023-01-18', '3.5'),
('300', '47', '16', '56', '2023-01-18', '4.9'),
('301', '45', '16', '53', '2023-01-18', '740'),
('302', '45', '16', '54', '2023-01-18', '241.8'),
('303', '45', '16', '55', '2023-01-18', '3.5'),
('304', '45', '16', '56', '2023-01-18', '4.9'),
('305', '47', '17', '57', '2023-01-18', '1000'),
('306', '47', '17', '58', '2023-01-18', '100'),
('307', '47', '17', '59', '2023-01-18', '100'),
('308', '47', '17', '60', '2023-01-18', '10'),
('309', '45', '17', '57', '2023-01-18', '1000'),
('310', '45', '17', '58', '2023-01-18', '100'),
('311', '45', '17', '59', '2023-01-18', '100'),
('312', '45', '17', '60', '2023-01-18', '10'),
('313', '47', '18', '61', '2023-01-19', '100'),
('314', '45', '18', '61', '2023-01-19', '100'),
('315', '47', '19', '62', '2023-01-19', '3000'),
('316', '47', '19', '63', '2023-01-19', '3000'),
('317', '47', '19', '64', '2023-01-19', '200'),
('318', '47', '19', '65', '2023-01-19', '100'),
('319', '45', '19', '62', '2023-01-19', '3000'),
('320', '45', '19', '63', '2023-01-19', '3000'),
('321', '45', '19', '64', '2023-01-19', '200'),
('322', '45', '19', '65', '2023-01-19', '100'),
('323', '47', '20', '66', '2023-01-19', '2000'),
('324', '47', '20', '67', '2023-01-19', '2000'),
('325', '47', '20', '68', '2023-01-19', '100'),
('326', '47', '20', '69', '2023-01-19', '70'),
('327', '45', '20', '66', '2023-01-19', '2000'),
('328', '45', '20', '67', '2023-01-19', '2000'),
('329', '45', '20', '68', '2023-01-19', '100'),
('330', '45', '20', '69', '2023-01-19', '70');

### Structure of table `0_item_codes` ###

DROP TABLE IF EXISTS `0_item_codes`;

CREATE TABLE `0_item_codes` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `item_code` varchar(20) NOT NULL,
  `stock_id` varchar(20) NOT NULL,
  `description` varchar(200) NOT NULL DEFAULT '',
  `category_id` smallint(6) unsigned NOT NULL,
  `quantity` double NOT NULL DEFAULT 1,
  `is_foreign` tinyint(1) NOT NULL DEFAULT 0,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `stock_id` (`stock_id`,`item_code`),
  KEY `item_code` (`item_code`)
) ENGINE=InnoDB AUTO_INCREMENT=312 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_item_codes` ###

INSERT INTO `0_item_codes` VALUES
('1', 'FG-001', 'FG-001', 'Nasa ATF - 1 Ltr', '8', '1', '0', '0'),
('2', 'FG-002', 'FG-002', 'Nasa Battery Mixture - 30 Ltr', '8', '1', '0', '0'),
('3', 'FG-003', 'FG-003', 'Nasa Battery Water - 1.5 Ltr', '8', '1', '0', '0'),
('4', 'FG-004', 'FG-004', 'Nasa Battery Water - 20 Ltr', '8', '1', '0', '0'),
('5', 'FG-005', 'FG-005', 'Pak Suzuki Battery Water - 600 ml', '8', '1', '0', '0'),
('6', 'FG-006', 'FG-006', 'Nasa Battery Water - 600 ml', '8', '1', '0', '0'),
('7', 'FG-007', 'FG-007', 'Nasa Brake Cleaner - 450 ml', '8', '1', '0', '0'),
('8', 'FG-008', 'FG-008', 'Nasa Brake Fluid - 1 Ltr', '8', '1', '0', '0'),
('9', 'FG-009', 'FG-009', 'Nasa Brake Fluid - 355 ml', '8', '1', '0', '0'),
('10', 'FG-010', 'FG-010', 'Nasa Car Shampoo - 500 ml', '8', '1', '0', '0'),
('11', 'FG-011', 'FG-011', 'Nasa Car Shampoo - 10 Ltr', '8', '1', '0', '0'),
('12', 'FG-012', 'FG-012', 'Nasa Car Shampoo - 20 Ltr', '8', '1', '0', '0'),
('13', 'FG-013', 'FG-013', 'Nasa Carb Clean - 300 ml', '8', '1', '0', '0'),
('14', 'FG-014', 'FG-014', 'Nasa Carb Clean - 450 ml', '8', '1', '0', '0'),
('15', 'FG-015', 'FG-015', 'Nasa Carb Clean - 650 ml', '8', '1', '0', '0'),
('16', 'FG-016', 'FG-016', 'Nasa Contact Cleaner - 200 ml', '8', '1', '0', '0'),
('17', 'FG-017', 'FG-017', 'Nasa Coolant Blue Regular - 1 Ltr', '8', '1', '0', '0'),
('18', 'FG-018', 'FG-018', 'Nasa Coolant Blue Super - 1 Ltr', '8', '1', '0', '0'),
('19', 'FG-019', 'FG-019', 'Nasa Coolant Concentrate Green - 1 Ltr', '8', '1', '0', '0'),
('20', 'FG-020', 'FG-020', 'Nasa Coolant Concentrate Red - 1 Ltr', '8', '1', '0', '0'),
('21', 'FG-021', 'FG-021', 'Nasa Coolant Green Regular - 1 Ltr', '8', '1', '0', '0'),
('22', 'FG-022', 'FG-022', 'Nasa Coolant Green Regular - 3 Ltr', '8', '1', '0', '0'),
('23', 'FG-023', 'FG-023', 'Nasa Coolant Green Regular - 500 ml', '8', '1', '0', '0'),
('24', 'FG-024', 'FG-024', 'Nasa Coolant Green Super - 1 Ltr', '8', '1', '0', '0'),
('25', 'FG-025', 'FG-025', 'Nasa Coolant Green Super - 10 Ltr', '8', '1', '0', '0'),
('26', 'FG-026', 'FG-026', 'Nasa Coolant Green Super - 20 Ltr ', '8', '1', '0', '0'),
('27', 'FG-027', 'FG-027', 'Nasa Coolant Green Super - 200 Ltr', '8', '1', '0', '0'),
('28', 'FG-028', 'FG-028', 'Nasa Coolant Red Regular - 1 Ltr', '8', '1', '0', '0'),
('29', 'FG-029', 'FG-029', 'Nasa Coolant Red Super - 1 Ltr ', '8', '1', '0', '0'),
('30', 'FG-030', 'FG-030', 'Nasa Coolant Red Super - 3 Ltr ', '8', '1', '0', '0'),
('31', 'FG-031', 'FG-031', 'Nasa Coolant Red Super - 2.5 Ltr ', '8', '1', '0', '0'),
('32', 'FG-032', 'FG-032', 'Nasa Coolant Red Super - 20 Ltr', '8', '1', '0', '0'),
('33', 'FG-033', 'FG-033', 'Nasa Coolant Concentrate - 20 Ltr', '8', '1', '0', '0'),
('34', 'FG-034', 'FG-034', 'Nasa Coolant Concentrate - 3 Ltr ', '8', '1', '0', '0'),
('35', 'FG-035', 'FG-035', 'Nasa Coolant Concentrate - 30 Ltr', '8', '1', '0', '0'),
('36', 'FG-036', 'FG-036', 'Nasa Coolant Concentrate Drum - 200 Ltr', '8', '1', '0', '0'),
('37', 'FG-037', 'FG-037', 'Nasa Coolant Green Regular - 200 Ltr', '8', '1', '0', '0'),
('38', 'FG-038', 'FG-038', 'Nasa Coolant Green Regular - 20 Ltr', '8', '1', '0', '0'),
('39', 'FG-039', 'FG-039', 'Nasa Dashboard &amp; Leather Wax - Car fresh', '8', '1', '0', '0'),
('40', 'FG-040', 'FG-040', 'Nasa Dashboard &amp; Leather Wax - Cool water', '8', '1', '0', '0'),
('41', 'FG-041', 'FG-041', 'Nasa Dashboard &amp; Leather Wax - lemon', '8', '1', '0', '0'),
('42', 'FG-042', 'FG-042', 'Nasa Gear Oil  SAE 80W/90 - 1 Ltr', '8', '1', '0', '0'),
('43', 'FG-043', 'FG-043', 'Nasa Gear Oil SAE 85W/140 - 1 Ltr', '8', '1', '0', '0'),
('44', 'FG-044', 'FG-044', 'Nasa Glass Cleaner - 500 ml ', '8', '1', '0', '0'),
('45', 'FG-045', 'FG-045', 'Nasa Grease Golden', '8', '1', '0', '0'),
('46', 'FG-046', 'FG-046', 'Nasa Grease Golden - 500 Gm', '8', '1', '0', '0'),
('47', 'FG-047', 'FG-047', 'Nasa Grease Golden - 1 KG', '8', '1', '0', '0'),
('48', 'FG-048', 'FG-048', 'Nasa Grease Golden - 3 KG', '8', '1', '0', '0'),
('49', 'FG-049', 'FG-049', 'Nasa Grease Golden - 5 KG', '8', '1', '0', '0'),
('50', 'FG-050', 'FG-050', 'Nasa Grease Golden - 10 KG', '8', '1', '0', '0'),
('51', 'FG-051', 'FG-051', 'Nasa Grease Crystal - 5 KG', '8', '1', '0', '0'),
('52', 'FG-052', 'FG-052', 'Nasa Grease Crystal White - 500 Gm', '8', '1', '0', '0'),
('53', 'FG-053', 'FG-053', 'Nasa Liquid Grease - 200 ml', '8', '1', '0', '0'),
('54', 'FG-054', 'FG-054', 'Nasa Power Steering Fluid - 350 ml', '8', '1', '0', '0'),
('55', 'FG-055', 'FG-055', 'Nasa Radiator Cleaner - 1 Ltr', '8', '1', '0', '0'),
('56', 'FG-056', 'FG-056', 'Nasa Rustonil - 100 ml', '8', '1', '0', '0'),
('57', 'FG-057', 'FG-057', 'Nasa Rustonil - 200 ml', '8', '1', '0', '0'),
('58', 'FG-058', 'FG-058', 'Nasa Rustonil - 350 ml', '8', '1', '0', '0'),
('59', 'FG-059', 'FG-059', 'Nasa Rustonil - 450 ml', '8', '1', '0', '0'),
('60', 'FG-060', 'FG-060', 'Nasa Tune Up - 300 ml', '8', '1', '0', '0'),
('61', 'FG-061', 'FG-061', 'Pak Suzuki Car Care Kit ', '8', '1', '0', '0'),
('62', 'FG-062', 'FG-062', 'Cupric Acetate', '8', '1', '0', '0'),
('63', 'FG-063', 'FG-063', 'Micro Fibber Cloth', '8', '1', '0', '0'),
('64', 'RM-001', 'RM-001', 'Can Rusto Nil RN-100 (100ml x 240)', '9', '1', '0', '0'),
('65', 'RM-002', 'RM-002', 'Can Rusto Nil RN-100 (350ml x 80)', '9', '1', '0', '0'),
('66', 'RM-003', 'RM-003', 'Plastic Bottle Brake Fluid (355ml x 72)', '9', '1', '0', '0'),
('67', 'RM-004', 'RM-004', 'Can Carb Clean - (300ml x 172)', '9', '1', '0', '0'),
('68', 'RM-005', 'RM-005', 'Can Carb Clean - (450ml x 80)', '9', '1', '0', '0'),
('69', 'RM-006', 'RM-006', 'Can Carb Clean - (650ml x 80) 400 gm', '9', '1', '0', '0'),
('70', 'RM-007', 'RM-007', 'Can Carb Chowk Cleaner - (300ml x 96)', '9', '1', '0', '0'),
('71', 'RM-008', 'RM-008', 'Can Brake Cleaner - 450 ml', '9', '1', '0', '0'),
('72', 'RM-009', 'RM-009', 'Can Contact Cleaner - (200ml x 144)', '9', '1', '0', '0'),
('73', 'RM-010', 'RM-010', 'Can Nasa Liquid Grease - 200 ml', '9', '1', '0', '0'),
('74', 'RM-011', 'RM-011', 'Aerosol Tin - (450ml x 80) W/o Print', '9', '1', '0', '0'),
('75', 'RM-012', 'RM-012', 'Plastic Bottle Battery Water - 600 ml', '9', '1', '0', '0'),
('76', 'RM-013', 'RM-013', 'Plastic Bottle Battery Water - 1.5 Ltr', '9', '1', '0', '0'),
('77', 'RM-014', 'RM-014', 'Nasa Grease Jar - 500 gm (Printed)', '9', '1', '0', '0'),
('78', 'RM-015', 'RM-015', 'Grease Jar - 500 gm (W/o Printed)', '9', '1', '0', '0'),
('79', 'RM-016', 'RM-016', 'Grease Jar - 01 kg', '9', '1', '0', '0'),
('80', 'RM-017', 'RM-017', 'Grease Bucket - 05 kg', '9', '1', '0', '0'),
('81', 'RM-018', 'RM-018', 'Grease Bucket - 10 kg', '9', '1', '0', '0'),
('82', 'RM-019', 'RM-019', 'Plastic Bottle Car Shampoo - 500 ml', '9', '1', '0', '0'),
('83', 'RM-020', 'RM-020', 'Plastic Bottle Power Steering - 350 ml', '9', '1', '0', '0'),
('84', 'RM-021', 'RM-021', 'Plastic Bottle Green - 01 Ltr', '9', '1', '0', '0'),
('85', 'RM-022', 'RM-022', 'Plastic Bottle Red - 01 Ltr', '9', '1', '0', '0'),
('86', 'RM-023', 'RM-023', 'Plastic Bottle White - 01 Ltr (Printed)', '9', '1', '0', '0'),
('87', 'RM-024', 'RM-024', 'Plastic Bottle Black - 01 Ltr', '9', '1', '0', '0'),
('88', 'RM-025', 'RM-025', 'Plastic Bottle White - 01 Ltr', '9', '1', '0', '0'),
('89', 'RM-026', 'RM-026', 'Plastic Bottle Radiator Cleaner White - 01 Ltr', '9', '1', '0', '0'),
('90', 'RM-027', 'RM-027', 'Plastic Bottle White - 03 Ltr', '9', '1', '0', '0'),
('91', 'RM-028', 'RM-028', 'Plastic Bottle Red - 03 Ltr', '9', '1', '0', '0'),
('92', 'RM-029', 'RM-029', 'Plastic Gallen Green - 10 Ltr', '9', '1', '0', '0'),
('93', 'RM-030', 'RM-030', 'Plastic Gallen White - 10 Ltr', '9', '1', '0', '0'),
('94', 'RM-031', 'RM-031', 'Plastic Gallen Grey - 10 Ltr', '9', '1', '0', '0'),
('95', 'RM-032', 'RM-032', 'Plastic Gallen Grey - 20 Ltr', '9', '1', '0', '0'),
('96', 'RM-033', 'RM-033', 'Plastic Gallen White - 20 Ltr', '9', '1', '0', '0'),
('97', 'RM-034', 'RM-034', 'Plastic Gallon Blue - 30 Ltr', '9', '1', '0', '0'),
('98', 'RM-035', 'RM-035', 'Plastic Bottle Glass Cleaner - 500 ml', '9', '1', '0', '0'),
('99', 'RM-036', 'RM-036', 'Carton-Carb Clean - (300ml x 48) Master', '9', '1', '0', '0'),
('100', 'RM-037', 'RM-037', 'Carton-Carb Clean - (300ml x 24) Inner', '9', '1', '0', '0'),
('101', 'RM-038', 'RM-038', 'Carton-Carb Clean - (450ml x 24)', '9', '1', '0', '0'),
('102', 'RM-039', 'RM-039', 'Carton-Coolant Green Super - (01Ltr x 12)', '9', '1', '0', '0'),
('103', 'RM-040', 'RM-040', 'Carton-Carb Clean - (650ml x 48) - 400 gm Master', '9', '1', '0', '0'),
('104', 'RM-041', 'RM-041', 'Carton-Carb Clean - (650ml x 12) - 400 gm Inner', '9', '1', '0', '0'),
('105', 'RM-042', 'RM-042', 'Carton-Carb Chowk Cleaner &amp; TUNE UP - (300ml x 24)', '9', '1', '0', '0'),
('106', 'RM-043', 'RM-043', 'Carton-Coolant Red Regular - (01Ltr x 12)', '9', '1', '0', '0'),
('107', 'RM-044', 'RM-044', 'Carton-Coolant Red Super - (03Ltr x 6)', '9', '1', '0', '0'),
('108', 'RM-045', 'RM-045', 'Carton-Coolant Green Regular - (01Ltr x 12)', '9', '1', '0', '0'),
('109', 'RM-046', 'RM-046', 'Carton-Coolant Green Regular - (3Ltr x 6)', '9', '1', '0', '0'),
('110', 'RM-047', 'RM-047', 'Carton-Coolant Red Super - (01Ltr x 12)', '9', '1', '0', '0'),
('111', 'RM-048', 'RM-048', 'Carton-Rusto Nil RN-100 - (350ml x 24)', '9', '1', '0', '0'),
('112', 'RM-049', 'RM-049', 'Carton-Radiator Coolant - (500ml x 24) Old Stock', '9', '1', '0', '0'),
('113', 'RM-050', 'RM-050', 'Carton-D/Leather Wax - (450ml x 24) Old Stock', '9', '1', '0', '0'),
('114', 'RM-051', 'RM-051', 'Carton-Rusto Nil RN-100 - (100ml x 48)', '9', '1', '0', '0'),
('115', 'RM-052', 'RM-052', 'Carton-Grease Crystal - (500Gm x 12)', '9', '1', '0', '0'),
('116', 'RM-053', 'RM-053', 'Carton-Grease Pouch - (500Gm x 24 Pouches)', '9', '1', '0', '0'),
('117', 'RM-054', 'RM-054', 'Carton-Brake Fluid - (355ml x 24)', '9', '1', '0', '0'),
('118', 'RM-055', 'RM-055', 'Carton-D/Leather Wax Cool Water - (450ml x 24) Blue', '9', '1', '0', '0'),
('119', 'RM-056', 'RM-056', 'Carton-D/Leather Wax Lemon - (450ml x 24) Yellow', '9', '1', '0', '0'),
('120', 'RM-057', 'RM-057', 'Carton-D/Leather Wax Car Fresh - (450ml x 24) Brown', '9', '1', '0', '0'),
('121', 'RM-058', 'RM-058', 'Carton-Nasa Glass Cleaner - (500ml x 12)', '9', '1', '0', '0'),
('122', 'RM-059', 'RM-059', 'Carton-Nasa Car Shampoo - (500ml x 12)', '9', '1', '0', '0'),
('123', 'RM-060', 'RM-060', 'Carton-Novel Hand Sanitizer - (60ml x 96)', '9', '1', '0', '0'),
('124', 'RM-061', 'RM-061', 'Carton-Radiator Cleaner - (1 Ltr x 24)', '9', '1', '0', '0'),
('125', 'RM-062', 'RM-062', 'Carton-Nasa Rusto Nil - (450ml x 24) Old Stock', '9', '1', '0', '0'),
('126', 'RM-063', 'RM-063', 'Carton-Nasa Rusto Nil - (200ml x 48) Old Stock', '9', '1', '0', '0'),
('127', 'RM-064', 'RM-064', 'Carton-Suzuki ECSTAR Multiple Shiner - (01 x 12)', '9', '1', '0', '0'),
('128', 'RM-065', 'RM-065', 'Carton-Suzuki ECSTAR Glass Cleaner - (01 x 12)', '9', '1', '0', '0'),
('129', 'RM-066', 'RM-066', 'Carton-Suzuki ECSTAR Wax Shampoo - (500ml x 12)', '9', '1', '0', '0'),
('130', 'RM-067', 'RM-067', 'Carton-Suzuki ECSTAR Glass Shampoo - (01Ltr x 12)', '9', '1', '0', '0'),
('131', 'RM-068', 'RM-068', 'Carton-Suzuki ECSTAR Air Freshner GEL - (01 x 24)', '9', '1', '0', '0'),
('132', 'RM-069', 'RM-069', 'Carton-Suzuki Car Care Kit - (12 Pack)', '9', '1', '0', '0'),
('133', 'RM-070', 'RM-070', 'Carton-ATF Dx III - (01Ltr x 12)', '9', '1', '0', '0'),
('134', 'RM-071', 'RM-071', 'Carton-Battery Water - (1.5Ltr x 12)', '9', '1', '0', '0'),
('135', 'RM-072', 'RM-072', 'Carton-Nasa Grease - (01Kg x 12)', '9', '1', '0', '0'),
('136', 'RM-073', 'RM-073', 'Carton-Nasa Grease - (03Kg x 04)', '9', '1', '0', '0'),
('137', 'RM-074', 'RM-074', 'Carton-Novel Hand Sanitizer - (100ml x 72)', '9', '1', '0', '0'),
('138', 'RM-075', 'RM-075', 'Carton-Novel Hand Sanitizer - (500ml x 24)', '9', '1', '0', '0'),
('139', 'RM-076', 'RM-076', 'Carton-Novel Hand Sanitizer - (250ml x 36)', '9', '1', '0', '0'),
('140', 'RM-077', 'RM-077', 'Carton-Contact Cleaner - (200ml x 48)', '9', '1', '0', '0'),
('141', 'RM-078', 'RM-078', 'Carton-Contact Cleaner - (200ml x 24)', '9', '1', '0', '0'),
('142', 'RM-079', 'RM-079', 'Carton-Nasa Liquid Grease - (200ml x 48)', '9', '1', '0', '0'),
('143', 'RM-080', 'RM-080', 'Carton-Nasa Liquid Grease - (200ml x 24)', '9', '1', '0', '0'),
('144', 'RM-081', 'RM-081', 'Carton-Brake Cleaner - (450ml x 48)', '9', '1', '0', '0'),
('145', 'RM-082', 'RM-082', 'Carton-Brake Cleaner - (450ml x 24)', '9', '1', '0', '0'),
('146', 'RM-083', 'RM-083', 'Carton-Nasa Gear Oil GL-04 - (01Ltr x 12)', '9', '1', '0', '0'),
('147', 'RM-084', 'RM-084', 'Carton-Nasa Gear Oil GL-05 - (01Ltr x 12)', '9', '1', '0', '0'),
('148', 'RM-085', 'RM-085', 'Caps-Carb Clean - 300 ml (52mm)', '9', '1', '0', '0'),
('149', 'RM-086', 'RM-086', 'Caps-Carb Clean - 450 ml / 650 ml (65mm)', '9', '1', '0', '0'),
('150', 'RM-087', 'RM-087', 'Caps-Suzuki Shainer - 450 ml (Blue)', '9', '1', '0', '0'),
('151', 'RM-088', 'RM-088', 'Seal-Coolant - 01 Ltr', '9', '1', '0', '0'),
('152', 'RM-089', 'RM-089', 'Seal-Coolant Induction Seal - 01 Ltr', '9', '1', '0', '0'),
('153', 'RM-090', 'RM-090', 'Seal-Coolant - 03 Ltr', '9', '1', '0', '0'),
('154', 'RM-091', 'RM-091', 'Seal-Power Steering - 350 ml', '9', '1', '0', '0'),
('155', 'RM-092', 'RM-092', 'Seal-Power Steering Induction Seal - 350 ml (31.5mm)', '9', '1', '0', '0'),
('156', 'RM-093', 'RM-093', 'Seal-Brake Fluid - 355 ml', '9', '1', '0', '0'),
('157', 'RM-094', 'RM-094', 'Seal-Brake Fluid Induction Seal - 355 ml (29mm)', '9', '1', '0', '0'),
('158', 'RM-095', 'RM-095', 'Seal-Brake Fluid Stopper - 355 ml', '9', '1', '0', '0'),
('159', 'RM-096', 'RM-096', 'Stickers-Coolant Green Regular - 01 Ltr', '9', '1', '0', '0'),
('160', 'RM-097', 'RM-097', 'Stickers-Coolant Green Regular - 03 Ltr', '9', '1', '0', '0'),
('161', 'RM-098', 'RM-098', 'Stickers-Coolant Green Regular - 20 Ltr ', '9', '1', '0', '0'),
('162', 'RM-099', 'RM-099', 'Stickers-Coolant Green Super - 01 Ltr', '9', '1', '0', '0'),
('163', 'RM-100', 'RM-100', 'Stickers-Coolant Green Super - 03 Ltr', '9', '1', '0', '0'),
('164', 'RM-101', 'RM-101', 'Stickers-Coolant Green Super - 20 Ltr ', '9', '1', '0', '0'),
('165', 'RM-102', 'RM-102', 'Stickers-Coolant Red Regular - 01 Ltr', '9', '1', '0', '0'),
('166', 'RM-103', 'RM-103', 'Stickers-Coolant Red Super - 01 Ltr', '9', '1', '0', '0'),
('167', 'RM-104', 'RM-104', 'Stickers-Coolant Red Super - 2.5 Ltr', '9', '1', '0', '0'),
('168', 'RM-105', 'RM-105', 'Stickers-Coolant Red Super - 03 Ltr', '9', '1', '0', '0'),
('169', 'RM-106', 'RM-106', 'Stickers-Coolant Blue Super - 01 Ltr', '9', '1', '0', '0'),
('170', 'RM-107', 'RM-107', 'Stickers-Nasa Gear Oil GL-4 - 01 Ltr', '9', '1', '0', '0'),
('171', 'RM-108', 'RM-108', 'Stickers-Nasa Gear Oil GL-5 - 01 Ltr', '9', '1', '0', '0'),
('172', 'RM-109', 'RM-109', 'Stickers-D/Leather Wax Cool Water - 450 ml', '9', '1', '0', '0'),
('173', 'RM-110', 'RM-110', 'Stickers-D/Leather Wax Lemon - 450 ml', '9', '1', '0', '0'),
('174', 'RM-111', 'RM-111', 'Stickers-D/Leather Wax Car Fresh - 450 ml', '9', '1', '0', '0'),
('175', 'RM-112', 'RM-112', 'Stickers-Power Steering Fluid - 350 ml', '9', '1', '0', '0'),
('176', 'RM-113', 'RM-113', 'Stickers-Battery Water Label - 1.5 Ltr', '9', '1', '0', '0'),
('177', 'RM-114', 'RM-114', 'Stickers-Battery Water Nasa Label - 600 ml', '9', '1', '0', '0'),
('178', 'RM-115', 'RM-115', 'Stickers-Battery Water Suzuki Label - 600 ml', '9', '1', '0', '0'),
('179', 'RM-116', 'RM-116', 'Stickers-Brake Fluid - 355 ml (Sharing Wrap)', '9', '1', '0', '0'),
('180', 'RM-117', 'RM-117', 'Stickers-Brake Fluid - 355 ml', '9', '1', '0', '0'),
('181', 'RM-118', 'RM-118', 'Stickers-Brake Fluid - 1 Ltr', '9', '1', '0', '0'),
('182', 'RM-119', 'RM-119', 'Stickers-Grease Golden - 01 kg', '9', '1', '0', '0'),
('183', 'RM-120', 'RM-120', 'Stickers-Grease Golden - 05 kg', '9', '1', '0', '0'),
('184', 'RM-121', 'RM-121', 'Stickers-Grease Golden - 10 kg', '9', '1', '0', '0'),
('185', 'RM-122', 'RM-122', 'Stickers-Grease Golden - 03 kg', '9', '1', '0', '0'),
('186', 'RM-123', 'RM-123', 'Stickers-Grease Crystal - 500 gm', '9', '1', '0', '0'),
('187', 'RM-124', 'RM-124', 'Stickers-Coolant Concentrate - 01 Ltr', '9', '1', '0', '0'),
('188', 'RM-125', 'RM-125', 'Stickers-ATF Dx III - 01 Ltr', '9', '1', '0', '0'),
('189', 'RM-126', 'RM-126', 'Tape 1/2 - (144Pack)', '9', '1', '0', '0'),
('190', 'RM-127', 'RM-127', 'Tape 2 - (72Pack)', '9', '1', '0', '0'),
('191', 'RM-128', 'RM-128', 'Tape 3 - (48 Pack)', '9', '1', '0', '0'),
('192', 'RM-129', 'RM-129', 'Paper Tape - 2', '9', '1', '0', '0'),
('193', 'RM-130', 'RM-130', 'Pouch-Grease Nasa - 500 gm', '9', '1', '0', '0'),
('194', 'RM-131', 'RM-131', 'Poy Bag-Grease - 01 kg (6 x 9)', '9', '1', '0', '0'),
('195', 'RM-132', 'RM-132', 'Poy Bag-Grease - 5 kg (16 x 22)', '9', '1', '0', '0'),
('196', 'RM-133', 'RM-133', 'Poy Bag-Grease - 10 kg (18 x 24)', '9', '1', '0', '0'),
('197', 'CM-001', 'CM-001', 'Acetic Acid - (1803)', '10', '1', '0', '0'),
('198', 'CM-002', 'CM-002', 'Addtive A-T-F - (G4500)', '10', '1', '0', '0'),
('199', 'CM-003', 'CM-003', 'Addtive Gear OIL - (7001)', '10', '1', '0', '0'),
('200', 'CM-004', 'CM-004', 'Addtive Gear OIL - (G5100)', '10', '1', '0', '0'),
('201', 'CM-005', 'CM-005', 'Ammonia Liqure - (1802)', '10', '1', '0', '0'),
('202', 'CM-006', 'CM-006', 'Anti Foam - (GLS-025)', '10', '1', '0', '0'),
('203', 'CM-007', 'CM-007', 'Benzene - (CBN-200)', '10', '1', '0', '0'),
('204', 'CM-008', 'CM-008', 'Benzyal Alchole - (1400)', '10', '1', '0', '0'),
('205', 'CM-009', 'CM-009', 'Borex - (1609)', '10', '1', '0', '0'),
('206', 'CM-010', 'CM-010', 'Butyle Glycol - (BOG-400)', '10', '1', '0', '0'),
('207', 'CM-011', 'CM-011', 'Castic Soda', '10', '1', '0', '0'),
('208', 'CM-012', 'CM-012', 'Coper Oxide', '10', '1', '0', '0'),
('209', 'CM-013', 'CM-013', 'Di Etylamine - (DEA-022)', '10', '1', '0', '0'),
('210', 'CM-014', 'CM-014', 'Die -Etylene Glycol - (1800)', '10', '1', '0', '0'),
('211', 'CM-015', 'CM-015', 'DOC - (DRC-500)', '10', '1', '0', '0'),
('212', 'CM-016', 'CM-016', 'E-D-T-A - (1608)', '10', '1', '0', '0'),
('213', 'CM-017', 'CM-017', 'Gear oil (green) - (1901)', '10', '1', '0', '0'),
('214', 'CM-018', 'CM-018', 'H-C-L - (1402)', '10', '1', '0', '0'),
('215', 'CM-019', 'CM-019', 'Hexene - (DCC-800)', '10', '1', '0', '0'),
('216', 'CM-020', 'CM-020', 'Methanol - (AMT-100)', '10', '1', '0', '0'),
('217', 'CM-021', 'CM-021', 'Methylene chloride - (CMC-300)', '10', '1', '0', '0'),
('218', 'CM-022', 'CM-022', 'Mono Ethyl Glycol - (1601)', '10', '1', '0', '0'),
('219', 'CM-023', 'CM-023', 'Proma - (2001)', '10', '1', '0', '0'),
('220', 'CM-024', 'CM-024', 'Silicon Oil - (1904)', '10', '1', '0', '0'),
('221', 'CM-025', 'CM-025', 'Sodium Benoate - (AFR-700)', '10', '1', '0', '0'),
('222', 'CM-026', 'CM-026', 'Sodium Chloride - (SCL-24)', '10', '1', '0', '0'),
('223', 'CM-027', 'CM-027', 'Sodium Loyral Ether Sulfate - (STB-200)', '10', '1', '0', '0'),
('224', 'CM-028', 'CM-028', 'Sulfuric Acid - (SLA-021)', '10', '1', '0', '0'),
('225', 'CM-029', 'CM-029', 'Trichloroethylene - (TBE-001)', '10', '1', '0', '0'),
('226', 'CM-030', 'CM-030', 'White Oil - (WRO-600)', '10', '1', '0', '0'),
('227', 'CM-031', 'CM-031', 'Color Blue', '11', '1', '0', '0'),
('228', 'CM-032', 'CM-032', 'Colour Green - (1605)', '11', '1', '0', '0'),
('229', 'CM-033', 'CM-033', 'Colour Red - (1704)', '11', '1', '0', '0'),
('230', 'CM-034', 'CM-034', 'Colour Yellow - (1606)', '11', '1', '0', '0'),
('231', 'CM-035', 'CM-035', 'Fragrance Cool Water', '12', '1', '0', '0'),
('232', 'CM-036', 'CM-036', 'Fragrance Vanilla - (2400)', '12', '1', '0', '0'),
('233', 'CM-037', 'CM-037', 'Golden Grease', '13', '1', '0', '0'),
('234', 'CM-038', 'CM-038', 'LPG - (1209)', '14', '1', '0', '0'),
('237', 'KT-01', 'FG-013', 'For Sample Item Carb alean 300', '1', '1', '0', '0'),
('238', 'SFG-101', 'SFG-101', 'ATF-Lubricanta', '15', '1', '0', '0'),
('239', 'FA-01', 'FA-01', 'Generator', '5', '1', '0', '0'),
('242', 'SFG-102', 'SFG-102', 'Carb Clean - Solution', '15', '1', '0', '0'),
('243', 'SFG-103', 'SFG-103', 'Coolant Red Regular - Solution', '15', '1', '0', '0'),
('244', 'SFG-104', 'SFG-104', 'Coolant Green Super - Solution', '15', '1', '0', '0'),
('245', 'SFG-105', 'SFG-105', 'Nasa Battery Water - Solution', '15', '1', '0', '0'),
('246', 'SFG-106', 'SFG-106', 'Leather &amp; Dashboard Wax - Solution', '1', '1', '0', '0'),
('247', 'SFG-107', 'SFG-107', 'Gear Oil - 4 85w/140 - Lubricant', '15', '1', '0', '0'),
('248', 'SFG-108', 'SFG-108', 'Gear Oil - 5 80w/90 - Lubricant', '15', '1', '0', '0'),
('249', 'SFG-109', 'SFG-109', 'Coolant  Red Super - Solution', '15', '1', '0', '0'),
('250', 'SFG-110', 'SFG-110', 'Car Shampoo Orange - Solution', '1', '1', '0', '0'),
('251', 'SFG-111', 'SFG-111', 'Car Shampoo Green - Solution', '1', '1', '0', '0'),
('252', 'SFG-112', 'SFG-112', 'Liquid Grease ', '15', '1', '0', '0'),
('253', 'SFG-113', 'SFG-113', 'Air Freshner Gel', '15', '1', '0', '0'),
('254', 'SFG-114', 'SFG-114', 'Glass Cleaner - Solution', '15', '1', '0', '0'),
('255', 'SFG-115', 'SFG-115', 'Tune Up Carb Clean - Solution', '15', '1', '0', '0'),
('256', 'SFG-116', 'SFG-116', 'Tune Up ATF - Lubricant', '15', '1', '0', '0'),
('257', 'SFG-117', 'SFG-117', 'Tune Up Gear Oil - Lubricant', '15', '1', '0', '0'),
('258', 'SFG-118', 'SFG-118', 'Tune Up Rustonil - Solution', '15', '1', '0', '0'),
('259', 'CM-039', 'CM-039', 'Fragrance - Lemon', '12', '1', '0', '0'),
('260', 'CM-040', 'CM-040', 'Fragrance - Car Fresh', '12', '1', '0', '0'),
('261', 'CM-041', 'CM-041', 'HCL', '10', '1', '0', '0'),
('262', 'CM-042', 'CM-042', 'Sulphunic Acid', '10', '1', '0', '0'),
('263', 'SFG-119', 'SFG-119', 'Deionized water', '15', '1', '0', '0'),
('264', 'CM-043', 'CM-043', 'BSHVI', '10', '1', '0', '0'),
('265', 'CM-044', 'CM-044', 'Gelatin', '10', '1', '0', '0'),
('266', 'CM-045', 'CM-045', 'CAPB', '10', '1', '0', '0'),
('267', 'CM-046', 'CM-046', 'Color - Orange', '11', '1', '0', '0'),
('268', 'CM-047', 'CM-047', 'Fragrance - Orange', '12', '1', '0', '0'),
('269', 'SFG-120', 'SFG-120', 'Rustonil - Solution', '15', '1', '0', '0'),
('270', 'SFG-121', 'SFG-121', 'Brake Cleaner - Lubricant', '15', '1', '0', '0'),
('271', 'SFG-122', 'SFG-122', 'Brake Fluid - Lubricant', '15', '1', '0', '0'),
('272', 'CM-048', 'CM-048', 'Tetra Choloro Ethylene', '10', '1', '0', '0'),
('273', 'CM-049', 'CM-049', 'DEG', '10', '1', '0', '0'),
('274', 'SFG-123', 'SFG-123', 'Coolant Green Regular - Solution', '15', '1', '0', '0'),
('275', 'SFG-124', 'SFG-124', 'Coolant Blue Regular - Solution', '15', '1', '0', '0'),
('276', 'SFG-125', 'SFG-125', 'Coolant Blue Super - Solution', '15', '1', '0', '0'),
('277', 'SFG-126', 'SFG-126', 'Radiator Cleaner', '15', '1', '0', '0'),
('278', 'CM-050', 'CM-050', 'Water Noraml', '10', '1', '0', '0'),
('279', 'CM-051', 'CM-051', 'Water Normal', '10', '1', '0', '0'),
('280', 'SFG-127', 'SFG-127', 'Battery Mixture - Solution', '10', '1', '0', '0'),
('281', 'SFG-128', 'SFG-128', 'Power Steering - Lubricant', '15', '1', '0', '0'),
('282', 'CM-052', 'CM-052', 'Base Oil 100 NHVI', '10', '1', '0', '0'),
('283', 'CM-053', 'CM-053', 'Base Oil HD-50', '10', '1', '0', '0'),
('284', 'CM-054', 'CM-054', 'Cab-o-Sil', '10', '1', '0', '0'),
('285', 'CM-055', 'CM-055', 'Carbo Pole', '10', '1', '0', '0'),
('286', 'CM-056', 'CM-056', 'Colour Apple Green H-9195', '10', '1', '0', '0'),
('287', 'CM-057', 'CM-057', 'Colour Brilliant Blue H-7250', '10', '1', '0', '0'),
('288', 'CM-058', 'CM-058', 'Colour Orange Red H-9194', '10', '1', '0', '0'),
('289', 'CM-059', 'CM-059', 'Color Purple ATF', '10', '1', '0', '0'),
('290', 'CM-060', 'CM-060', 'Color Red ATF', '10', '1', '0', '0'),
('291', 'CM-061', 'CM-061', 'Fragrance Jasmine', '10', '1', '0', '0'),
('292', 'CM-062', 'CM-062', 'Fragrance Lavendar', '10', '1', '0', '0'),
('293', 'CM-063', 'CM-063', 'Gear Oil BSMVI', '10', '1', '0', '0'),
('294', 'CM-064', 'CM-064', 'Glycrine', '10', '1', '0', '0'),
('295', 'CM-065', 'CM-065', 'I-P-A', '10', '1', '0', '0'),
('296', 'CM-066', 'CM-066', 'Kerosene Oil', '10', '1', '0', '0'),
('297', 'CM-067', 'CM-067', 'Liquid Bleach', '10', '1', '0', '0'),
('298', 'CM-069', 'CM-069', 'Recycle Oil', '10', '1', '0', '0'),
('299', 'CM-070', 'CM-070', 'Turpene', '10', '1', '0', '0'),
('300', 'CM-071', 'CM-071', 'Zinc Choloride', '10', '1', '0', '0'),
('301', 'RM-134', 'RM-134', 'Tune Up (100ml x 240)', '9', '1', '0', '0'),
('302', 'RM-135', 'RM-135', 'Tune Up (100ml x 240)', '9', '1', '0', '0'),
('303', 'RM-136', 'RM-136', 'Tune Up (300ml x 172)', '9', '1', '0', '0'),
('304', 'FG-064', 'FG-064', 'Nasa Tune Up - 100 ml', '8', '1', '0', '0'),
('305', 'FG-065', 'FG-065', 'Pak Suzuki Glass Cleaneer - 500 ml', '8', '1', '0', '0'),
('306', 'FG-066', 'FG-066', 'Nasa Grease Pouch - 500 Gm', '8', '1', '0', '0'),
('307', 'FG-067', 'FG-067', 'Nasa Grease Food Grade - 500 Gm', '8', '1', '0', '0'),
('308', 'FG-068', 'FG-068', 'Nasa Coolant Green Regular - 10 Ltr', '8', '1', '0', '0'),
('309', 'FG-069', 'FG-069', 'Nasa Coolant Green Regular - 20 Ltr', '8', '1', '0', '0'),
('310', 'FG-070', 'FG-070', 'Nasa ATF - 20 Ltr', '8', '1', '0', '0'),
('311', 'ST-0001', 'ST-0001', 'Stationery - Office Files', '16', '1', '0', '0');

### Structure of table `0_item_group` ###

DROP TABLE IF EXISTS `0_item_group`;

CREATE TABLE `0_item_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` varchar(100) NOT NULL,
  `inactive` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_item_group` ###

INSERT INTO `0_item_group` VALUES
('1', 'lubriacnt', '0'),
('2', 'Battery Water', '0'),
('3', 'Coolant Regular', '0'),
('4', 'Coolant Super', '0'),
('5', 'Carb Clean', '0'),
('6', 'Grease', '0'),
('7', 'Leather &amp; Dashboard', '0'),
('8', 'Chemicals', '0'),
('9', 'Cleaners', '0'),
('10', 'Fragrance', '0'),
('11', 'Colors', '0'),
('12', 'Rustonil', '0'),
('13', 'Stationery Items', '0');

### Structure of table `0_item_tax_type_exemptions` ###

DROP TABLE IF EXISTS `0_item_tax_type_exemptions`;

CREATE TABLE `0_item_tax_type_exemptions` (
  `item_tax_type_id` int(11) NOT NULL DEFAULT 0,
  `tax_type_id` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`item_tax_type_id`,`tax_type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_item_tax_type_exemptions` ###


### Structure of table `0_item_tax_types` ###

DROP TABLE IF EXISTS `0_item_tax_types`;

CREATE TABLE `0_item_tax_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(60) NOT NULL DEFAULT '',
  `exempt` tinyint(1) NOT NULL DEFAULT 0,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_item_tax_types` ###

INSERT INTO `0_item_tax_types` VALUES
('1', 'Regular', '0', '0');

### Structure of table `0_item_units` ###

DROP TABLE IF EXISTS `0_item_units`;

CREATE TABLE `0_item_units` (
  `abbr` varchar(20) NOT NULL,
  `name` varchar(40) NOT NULL,
  `decimals` tinyint(2) NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`abbr`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_item_units` ###

INSERT INTO `0_item_units` VALUES
('BG', 'Bag', '4', '0'),
('each', 'Each', '0', '0'),
('GRM', 'GRM', '4', '0'),
('hr', 'Hours', '0', '0'),
('KG', 'KG', '5', '0'),
('LTR', 'Liter', '4', '0'),
('MT', 'MT', '4', '0'),
('Pair', 'Pair', '0', '0'),
('Pcs', 'Pcs', '2', '0');

### Structure of table `0_journal` ###

DROP TABLE IF EXISTS `0_journal`;

CREATE TABLE `0_journal` (
  `type` smallint(6) NOT NULL DEFAULT 0,
  `trans_no` int(11) NOT NULL DEFAULT 0,
  `tran_date` date DEFAULT '0000-00-00',
  `reference` varchar(60) NOT NULL DEFAULT '',
  `source_ref` varchar(60) NOT NULL DEFAULT '',
  `event_date` date DEFAULT '0000-00-00',
  `doc_date` date NOT NULL DEFAULT '0000-00-00',
  `currency` char(3) NOT NULL DEFAULT '',
  `amount` double NOT NULL DEFAULT 0,
  `rate` double NOT NULL DEFAULT 1,
  PRIMARY KEY (`type`,`trans_no`),
  KEY `tran_date` (`tran_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_journal` ###


### Structure of table `0_kv_bank_trans_settings` ###

DROP TABLE IF EXISTS `0_kv_bank_trans_settings`;

CREATE TABLE `0_kv_bank_trans_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_name` varchar(250) DEFAULT NULL,
  `pay_type` int(11) DEFAULT -1,
  `person_id` text NOT NULL,
  `keyword` text NOT NULL,
  `min_price` int(11) NOT NULL,
  `max_price` int(11) NOT NULL,
  `negative_only` tinyint(4) NOT NULL DEFAULT 0,
  `notes` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_kv_bank_trans_settings` ###


### Structure of table `0_loc_stock` ###

DROP TABLE IF EXISTS `0_loc_stock`;

CREATE TABLE `0_loc_stock` (
  `loc_code` char(5) NOT NULL DEFAULT '',
  `stock_id` char(20) NOT NULL DEFAULT '',
  `reorder_level` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`loc_code`,`stock_id`),
  KEY `stock_id` (`stock_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_loc_stock` ###

INSERT INTO `0_loc_stock` VALUES
('001', 'CM-039', '0'),
('001', 'CM-040', '0'),
('001', 'CM-041', '0'),
('001', 'CM-042', '0'),
('001', 'CM-043', '0'),
('001', 'CM-044', '0'),
('001', 'CM-045', '0'),
('001', 'CM-046', '0'),
('001', 'CM-047', '0'),
('001', 'CM-048', '0'),
('001', 'CM-049', '0'),
('001', 'CM-050', '0'),
('001', 'CM-051', '0'),
('001', 'CM-052', '0'),
('001', 'CM-053', '0'),
('001', 'CM-054', '0'),
('001', 'CM-055', '0'),
('001', 'CM-056', '0'),
('001', 'CM-057', '0'),
('001', 'CM-058', '0'),
('001', 'CM-059', '0'),
('001', 'CM-060', '0'),
('001', 'CM-061', '0'),
('001', 'CM-062', '0'),
('001', 'CM-063', '0'),
('001', 'CM-064', '0'),
('001', 'CM-065', '0'),
('001', 'CM-066', '0'),
('001', 'CM-067', '0'),
('001', 'CM-069', '0'),
('001', 'CM-070', '0'),
('001', 'CM-071', '0'),
('001', 'FA-01', '0'),
('001', 'FG-064', '0'),
('001', 'FG-065', '0'),
('001', 'FG-066', '0'),
('001', 'FG-067', '0'),
('001', 'FG-068', '0'),
('001', 'FG-069', '0'),
('001', 'FG-070', '0'),
('001', 'RM-134', '0'),
('001', 'RM-135', '0'),
('001', 'RM-136', '0'),
('001', 'SFG-101', '0'),
('001', 'SFG-102', '0'),
('001', 'SFG-103', '0'),
('001', 'SFG-104', '0'),
('001', 'SFG-105', '0'),
('001', 'SFG-106', '0'),
('001', 'SFG-107', '0'),
('001', 'SFG-108', '0'),
('001', 'SFG-109', '0'),
('001', 'SFG-110', '0'),
('001', 'SFG-111', '0'),
('001', 'SFG-112', '0'),
('001', 'SFG-113', '0'),
('001', 'SFG-114', '0'),
('001', 'SFG-115', '0'),
('001', 'SFG-116', '0'),
('001', 'SFG-117', '0'),
('001', 'SFG-118', '0'),
('001', 'SFG-119', '0'),
('001', 'SFG-120', '0'),
('001', 'SFG-121', '0'),
('001', 'SFG-122', '0'),
('001', 'SFG-123', '0'),
('001', 'SFG-124', '0'),
('001', 'SFG-125', '0'),
('001', 'SFG-126', '0'),
('001', 'SFG-127', '0'),
('001', 'SFG-128', '0'),
('001', 'ST-0001', '0'),
('CHMST', 'CM-001', '0'),
('CHMST', 'CM-002', '0'),
('CHMST', 'CM-003', '0'),
('CHMST', 'CM-004', '0'),
('CHMST', 'CM-005', '0'),
('CHMST', 'CM-006', '0'),
('CHMST', 'CM-007', '0'),
('CHMST', 'CM-008', '0'),
('CHMST', 'CM-009', '0'),
('CHMST', 'CM-010', '0'),
('CHMST', 'CM-011', '0'),
('CHMST', 'CM-012', '0'),
('CHMST', 'CM-013', '0'),
('CHMST', 'CM-014', '0'),
('CHMST', 'CM-015', '0'),
('CHMST', 'CM-016', '0'),
('CHMST', 'CM-017', '0'),
('CHMST', 'CM-018', '0'),
('CHMST', 'CM-019', '0'),
('CHMST', 'CM-020', '0'),
('CHMST', 'CM-021', '0'),
('CHMST', 'CM-022', '0'),
('CHMST', 'CM-023', '0'),
('CHMST', 'CM-024', '0'),
('CHMST', 'CM-025', '0'),
('CHMST', 'CM-026', '0'),
('CHMST', 'CM-027', '0'),
('CHMST', 'CM-028', '0'),
('CHMST', 'CM-029', '0'),
('CHMST', 'CM-030', '0'),
('CHMST', 'CM-031', '0'),
('CHMST', 'CM-032', '0'),
('CHMST', 'CM-033', '0'),
('CHMST', 'CM-034', '0'),
('CHMST', 'CM-035', '0'),
('CHMST', 'CM-036', '0'),
('CHMST', 'CM-037', '0'),
('CHMST', 'CM-038', '0'),
('CHMST', 'CM-039', '0'),
('CHMST', 'CM-040', '0'),
('CHMST', 'CM-041', '0'),
('CHMST', 'CM-042', '0'),
('CHMST', 'CM-043', '0'),
('CHMST', 'CM-044', '0'),
('CHMST', 'CM-045', '0'),
('CHMST', 'CM-046', '0'),
('CHMST', 'CM-047', '0'),
('CHMST', 'CM-048', '0'),
('CHMST', 'CM-049', '0'),
('CHMST', 'CM-050', '0'),
('CHMST', 'CM-051', '0'),
('CHMST', 'CM-052', '0'),
('CHMST', 'CM-053', '0'),
('CHMST', 'CM-054', '0'),
('CHMST', 'CM-055', '0'),
('CHMST', 'CM-056', '0'),
('CHMST', 'CM-057', '0'),
('CHMST', 'CM-058', '0'),
('CHMST', 'CM-059', '0'),
('CHMST', 'CM-060', '0'),
('CHMST', 'CM-061', '0'),
('CHMST', 'CM-062', '0'),
('CHMST', 'CM-063', '0'),
('CHMST', 'CM-064', '0'),
('CHMST', 'CM-065', '0'),
('CHMST', 'CM-066', '0'),
('CHMST', 'CM-067', '0'),
('CHMST', 'CM-069', '0'),
('CHMST', 'CM-070', '0'),
('CHMST', 'CM-071', '0'),
('CHMST', 'FA-01', '0'),
('CHMST', 'FG-001', '0'),
('CHMST', 'FG-002', '0'),
('CHMST', 'FG-003', '0'),
('CHMST', 'FG-004', '0'),
('CHMST', 'FG-005', '0'),
('CHMST', 'FG-006', '0'),
('CHMST', 'FG-007', '0'),
('CHMST', 'FG-008', '0'),
('CHMST', 'FG-009', '0'),
('CHMST', 'FG-010', '0'),
('CHMST', 'FG-011', '0'),
('CHMST', 'FG-012', '0'),
('CHMST', 'FG-013', '0'),
('CHMST', 'FG-014', '0'),
('CHMST', 'FG-015', '0'),
('CHMST', 'FG-016', '0'),
('CHMST', 'FG-017', '0'),
('CHMST', 'FG-018', '0'),
('CHMST', 'FG-019', '0'),
('CHMST', 'FG-020', '0'),
('CHMST', 'FG-021', '0'),
('CHMST', 'FG-022', '0'),
('CHMST', 'FG-023', '0'),
('CHMST', 'FG-024', '0'),
('CHMST', 'FG-025', '0'),
('CHMST', 'FG-026', '0'),
('CHMST', 'FG-027', '0'),
('CHMST', 'FG-028', '0'),
('CHMST', 'FG-029', '0'),
('CHMST', 'FG-030', '0'),
('CHMST', 'FG-031', '0'),
('CHMST', 'FG-032', '0'),
('CHMST', 'FG-033', '0'),
('CHMST', 'FG-034', '0'),
('CHMST', 'FG-035', '0'),
('CHMST', 'FG-036', '0'),
('CHMST', 'FG-037', '0'),
('CHMST', 'FG-038', '0'),
('CHMST', 'FG-039', '0'),
('CHMST', 'FG-040', '0'),
('CHMST', 'FG-041', '0'),
('CHMST', 'FG-042', '0'),
('CHMST', 'FG-043', '0'),
('CHMST', 'FG-044', '0'),
('CHMST', 'FG-045', '0'),
('CHMST', 'FG-046', '0'),
('CHMST', 'FG-047', '0'),
('CHMST', 'FG-048', '0'),
('CHMST', 'FG-049', '0'),
('CHMST', 'FG-050', '0'),
('CHMST', 'FG-051', '0'),
('CHMST', 'FG-052', '0'),
('CHMST', 'FG-053', '0'),
('CHMST', 'FG-054', '0'),
('CHMST', 'FG-055', '0'),
('CHMST', 'FG-056', '0'),
('CHMST', 'FG-057', '0'),
('CHMST', 'FG-058', '0'),
('CHMST', 'FG-059', '0'),
('CHMST', 'FG-060', '0'),
('CHMST', 'FG-061', '0'),
('CHMST', 'FG-062', '0'),
('CHMST', 'FG-063', '0'),
('CHMST', 'FG-064', '0'),
('CHMST', 'FG-065', '0'),
('CHMST', 'FG-066', '0'),
('CHMST', 'FG-067', '0'),
('CHMST', 'FG-068', '0'),
('CHMST', 'FG-069', '0'),
('CHMST', 'FG-070', '0'),
('CHMST', 'RM-001', '0'),
('CHMST', 'RM-002', '0'),
('CHMST', 'RM-003', '0'),
('CHMST', 'RM-004', '0'),
('CHMST', 'RM-005', '0'),
('CHMST', 'RM-006', '0'),
('CHMST', 'RM-007', '0'),
('CHMST', 'RM-008', '0'),
('CHMST', 'RM-009', '0'),
('CHMST', 'RM-010', '0'),
('CHMST', 'RM-011', '0'),
('CHMST', 'RM-012', '0'),
('CHMST', 'RM-013', '0'),
('CHMST', 'RM-014', '0'),
('CHMST', 'RM-015', '0'),
('CHMST', 'RM-016', '0'),
('CHMST', 'RM-017', '0'),
('CHMST', 'RM-018', '0'),
('CHMST', 'RM-019', '0'),
('CHMST', 'RM-020', '0'),
('CHMST', 'RM-021', '0'),
('CHMST', 'RM-022', '0'),
('CHMST', 'RM-023', '0'),
('CHMST', 'RM-024', '0'),
('CHMST', 'RM-025', '0'),
('CHMST', 'RM-026', '0'),
('CHMST', 'RM-027', '0'),
('CHMST', 'RM-028', '0'),
('CHMST', 'RM-029', '0'),
('CHMST', 'RM-030', '0'),
('CHMST', 'RM-031', '0'),
('CHMST', 'RM-032', '0'),
('CHMST', 'RM-033', '0'),
('CHMST', 'RM-034', '0'),
('CHMST', 'RM-035', '0'),
('CHMST', 'RM-036', '0'),
('CHMST', 'RM-037', '0'),
('CHMST', 'RM-038', '0'),
('CHMST', 'RM-039', '0'),
('CHMST', 'RM-040', '0'),
('CHMST', 'RM-041', '0'),
('CHMST', 'RM-042', '0'),
('CHMST', 'RM-043', '0'),
('CHMST', 'RM-044', '0'),
('CHMST', 'RM-045', '0'),
('CHMST', 'RM-046', '0'),
('CHMST', 'RM-047', '0'),
('CHMST', 'RM-048', '0'),
('CHMST', 'RM-049', '0'),
('CHMST', 'RM-050', '0'),
('CHMST', 'RM-051', '0'),
('CHMST', 'RM-052', '0'),
('CHMST', 'RM-053', '0'),
('CHMST', 'RM-054', '0'),
('CHMST', 'RM-055', '0'),
('CHMST', 'RM-056', '0'),
('CHMST', 'RM-057', '0'),
('CHMST', 'RM-058', '0'),
('CHMST', 'RM-059', '0'),
('CHMST', 'RM-060', '0'),
('CHMST', 'RM-061', '0'),
('CHMST', 'RM-062', '0'),
('CHMST', 'RM-063', '0'),
('CHMST', 'RM-064', '0'),
('CHMST', 'RM-065', '0'),
('CHMST', 'RM-066', '0'),
('CHMST', 'RM-067', '0'),
('CHMST', 'RM-068', '0'),
('CHMST', 'RM-069', '0'),
('CHMST', 'RM-070', '0'),
('CHMST', 'RM-071', '0'),
('CHMST', 'RM-072', '0'),
('CHMST', 'RM-073', '0'),
('CHMST', 'RM-074', '0'),
('CHMST', 'RM-075', '0'),
('CHMST', 'RM-076', '0'),
('CHMST', 'RM-077', '0'),
('CHMST', 'RM-078', '0'),
('CHMST', 'RM-079', '0'),
('CHMST', 'RM-080', '0'),
('CHMST', 'RM-081', '0'),
('CHMST', 'RM-082', '0'),
('CHMST', 'RM-083', '0'),
('CHMST', 'RM-084', '0'),
('CHMST', 'RM-085', '0'),
('CHMST', 'RM-086', '0'),
('CHMST', 'RM-087', '0'),
('CHMST', 'RM-088', '0'),
('CHMST', 'RM-089', '0'),
('CHMST', 'RM-090', '0'),
('CHMST', 'RM-091', '0'),
('CHMST', 'RM-092', '0'),
('CHMST', 'RM-093', '0'),
('CHMST', 'RM-094', '0'),
('CHMST', 'RM-095', '0'),
('CHMST', 'RM-096', '0'),
('CHMST', 'RM-097', '0'),
('CHMST', 'RM-098', '0'),
('CHMST', 'RM-099', '0'),
('CHMST', 'RM-100', '0'),
('CHMST', 'RM-101', '0'),
('CHMST', 'RM-102', '0'),
('CHMST', 'RM-103', '0'),
('CHMST', 'RM-104', '0'),
('CHMST', 'RM-105', '0'),
('CHMST', 'RM-106', '0'),
('CHMST', 'RM-107', '0'),
('CHMST', 'RM-108', '0'),
('CHMST', 'RM-109', '0'),
('CHMST', 'RM-110', '0'),
('CHMST', 'RM-111', '0'),
('CHMST', 'RM-112', '0'),
('CHMST', 'RM-113', '0'),
('CHMST', 'RM-114', '0'),
('CHMST', 'RM-115', '0'),
('CHMST', 'RM-116', '0'),
('CHMST', 'RM-117', '0'),
('CHMST', 'RM-118', '0'),
('CHMST', 'RM-119', '0'),
('CHMST', 'RM-120', '0'),
('CHMST', 'RM-121', '0'),
('CHMST', 'RM-122', '0'),
('CHMST', 'RM-123', '0'),
('CHMST', 'RM-124', '0'),
('CHMST', 'RM-125', '0'),
('CHMST', 'RM-126', '0'),
('CHMST', 'RM-127', '0'),
('CHMST', 'RM-128', '0'),
('CHMST', 'RM-129', '0'),
('CHMST', 'RM-130', '0'),
('CHMST', 'RM-131', '0'),
('CHMST', 'RM-132', '0'),
('CHMST', 'RM-133', '0'),
('CHMST', 'RM-134', '0'),
('CHMST', 'RM-135', '0'),
('CHMST', 'RM-136', '0'),
('CHMST', 'SFG-101', '0'),
('CHMST', 'SFG-102', '0'),
('CHMST', 'SFG-103', '0'),
('CHMST', 'SFG-104', '0'),
('CHMST', 'SFG-105', '0'),
('CHMST', 'SFG-106', '0'),
('CHMST', 'SFG-107', '0'),
('CHMST', 'SFG-108', '0'),
('CHMST', 'SFG-109', '0'),
('CHMST', 'SFG-110', '0'),
('CHMST', 'SFG-111', '0'),
('CHMST', 'SFG-112', '0'),
('CHMST', 'SFG-113', '0'),
('CHMST', 'SFG-114', '0'),
('CHMST', 'SFG-115', '0'),
('CHMST', 'SFG-116', '0'),
('CHMST', 'SFG-117', '0'),
('CHMST', 'SFG-118', '0'),
('CHMST', 'SFG-119', '0'),
('CHMST', 'SFG-120', '0'),
('CHMST', 'SFG-121', '0'),
('CHMST', 'SFG-122', '0'),
('CHMST', 'SFG-123', '0'),
('CHMST', 'SFG-124', '0'),
('CHMST', 'SFG-125', '0'),
('CHMST', 'SFG-126', '0'),
('CHMST', 'SFG-127', '0'),
('CHMST', 'SFG-128', '0'),
('CHMST', 'ST-0001', '0'),
('DEF', 'CM-001', '0'),
('DEF', 'CM-002', '0'),
('DEF', 'CM-003', '0'),
('DEF', 'CM-004', '0'),
('DEF', 'CM-005', '0'),
('DEF', 'CM-006', '0'),
('DEF', 'CM-007', '0'),
('DEF', 'CM-008', '0'),
('DEF', 'CM-009', '0'),
('DEF', 'CM-010', '0'),
('DEF', 'CM-011', '0'),
('DEF', 'CM-012', '0'),
('DEF', 'CM-013', '0'),
('DEF', 'CM-014', '0'),
('DEF', 'CM-015', '0'),
('DEF', 'CM-016', '0'),
('DEF', 'CM-017', '0'),
('DEF', 'CM-018', '0'),
('DEF', 'CM-019', '0'),
('DEF', 'CM-020', '0'),
('DEF', 'CM-021', '0'),
('DEF', 'CM-022', '0'),
('DEF', 'CM-023', '0'),
('DEF', 'CM-024', '0'),
('DEF', 'CM-025', '0'),
('DEF', 'CM-026', '0'),
('DEF', 'CM-027', '0'),
('DEF', 'CM-028', '0'),
('DEF', 'CM-029', '0'),
('DEF', 'CM-030', '0'),
('DEF', 'CM-031', '0'),
('DEF', 'CM-032', '0'),
('DEF', 'CM-033', '0'),
('DEF', 'CM-034', '0'),
('DEF', 'CM-035', '0'),
('DEF', 'CM-036', '0'),
('DEF', 'CM-037', '0'),
('DEF', 'CM-038', '0'),
('DEF', 'CM-039', '0'),
('DEF', 'CM-040', '0'),
('DEF', 'CM-041', '0'),
('DEF', 'CM-042', '0'),
('DEF', 'CM-043', '0'),
('DEF', 'CM-044', '0'),
('DEF', 'CM-045', '0'),
('DEF', 'CM-046', '0'),
('DEF', 'CM-047', '0'),
('DEF', 'CM-048', '0'),
('DEF', 'CM-049', '0'),
('DEF', 'CM-050', '0'),
('DEF', 'CM-051', '0'),
('DEF', 'CM-052', '0'),
('DEF', 'CM-053', '0'),
('DEF', 'CM-054', '0'),
('DEF', 'CM-055', '0'),
('DEF', 'CM-056', '0'),
('DEF', 'CM-057', '0'),
('DEF', 'CM-058', '0'),
('DEF', 'CM-059', '0'),
('DEF', 'CM-060', '0'),
('DEF', 'CM-061', '0'),
('DEF', 'CM-062', '0'),
('DEF', 'CM-063', '0'),
('DEF', 'CM-064', '0'),
('DEF', 'CM-065', '0'),
('DEF', 'CM-066', '0'),
('DEF', 'CM-067', '0'),
('DEF', 'CM-069', '0'),
('DEF', 'CM-070', '0'),
('DEF', 'CM-071', '0'),
('DEF', 'FA-01', '0'),
('DEF', 'FG-001', '0'),
('DEF', 'FG-002', '0'),
('DEF', 'FG-003', '0'),
('DEF', 'FG-004', '0'),
('DEF', 'FG-005', '0'),
('DEF', 'FG-006', '0'),
('DEF', 'FG-007', '0'),
('DEF', 'FG-008', '0'),
('DEF', 'FG-009', '0'),
('DEF', 'FG-010', '0'),
('DEF', 'FG-011', '0'),
('DEF', 'FG-012', '0'),
('DEF', 'FG-013', '0'),
('DEF', 'FG-014', '0'),
('DEF', 'FG-015', '0'),
('DEF', 'FG-016', '0'),
('DEF', 'FG-017', '0'),
('DEF', 'FG-018', '0'),
('DEF', 'FG-019', '0'),
('DEF', 'FG-020', '0'),
('DEF', 'FG-021', '0'),
('DEF', 'FG-022', '0'),
('DEF', 'FG-023', '0'),
('DEF', 'FG-024', '0'),
('DEF', 'FG-025', '0'),
('DEF', 'FG-026', '0'),
('DEF', 'FG-027', '0'),
('DEF', 'FG-028', '0'),
('DEF', 'FG-029', '0'),
('DEF', 'FG-030', '0'),
('DEF', 'FG-031', '0'),
('DEF', 'FG-032', '0'),
('DEF', 'FG-033', '0'),
('DEF', 'FG-034', '0'),
('DEF', 'FG-035', '0'),
('DEF', 'FG-036', '0'),
('DEF', 'FG-037', '0'),
('DEF', 'FG-038', '0'),
('DEF', 'FG-039', '0'),
('DEF', 'FG-040', '0'),
('DEF', 'FG-041', '0'),
('DEF', 'FG-042', '0'),
('DEF', 'FG-043', '0'),
('DEF', 'FG-044', '0'),
('DEF', 'FG-045', '0'),
('DEF', 'FG-046', '0'),
('DEF', 'FG-047', '0'),
('DEF', 'FG-048', '0'),
('DEF', 'FG-049', '0'),
('DEF', 'FG-050', '0'),
('DEF', 'FG-051', '0'),
('DEF', 'FG-052', '0'),
('DEF', 'FG-053', '0'),
('DEF', 'FG-054', '0'),
('DEF', 'FG-055', '0'),
('DEF', 'FG-056', '0'),
('DEF', 'FG-057', '0'),
('DEF', 'FG-058', '0'),
('DEF', 'FG-059', '0'),
('DEF', 'FG-060', '0'),
('DEF', 'FG-061', '0'),
('DEF', 'FG-062', '0'),
('DEF', 'FG-063', '0'),
('DEF', 'FG-064', '0'),
('DEF', 'FG-065', '0'),
('DEF', 'FG-066', '0'),
('DEF', 'FG-067', '0'),
('DEF', 'FG-068', '0'),
('DEF', 'FG-069', '0'),
('DEF', 'FG-070', '0'),
('DEF', 'RM-001', '0'),
('DEF', 'RM-002', '0'),
('DEF', 'RM-003', '0'),
('DEF', 'RM-004', '0'),
('DEF', 'RM-005', '0'),
('DEF', 'RM-006', '0'),
('DEF', 'RM-007', '0'),
('DEF', 'RM-008', '0'),
('DEF', 'RM-009', '0'),
('DEF', 'RM-010', '0'),
('DEF', 'RM-011', '0'),
('DEF', 'RM-012', '0'),
('DEF', 'RM-013', '0'),
('DEF', 'RM-014', '0'),
('DEF', 'RM-015', '0'),
('DEF', 'RM-016', '0'),
('DEF', 'RM-017', '0'),
('DEF', 'RM-018', '0'),
('DEF', 'RM-019', '0'),
('DEF', 'RM-020', '0'),
('DEF', 'RM-021', '0'),
('DEF', 'RM-022', '0'),
('DEF', 'RM-023', '0'),
('DEF', 'RM-024', '0'),
('DEF', 'RM-025', '0'),
('DEF', 'RM-026', '0'),
('DEF', 'RM-027', '0'),
('DEF', 'RM-028', '0'),
('DEF', 'RM-029', '0'),
('DEF', 'RM-030', '0'),
('DEF', 'RM-031', '0'),
('DEF', 'RM-032', '0'),
('DEF', 'RM-033', '0'),
('DEF', 'RM-034', '0'),
('DEF', 'RM-035', '0'),
('DEF', 'RM-036', '0'),
('DEF', 'RM-037', '0'),
('DEF', 'RM-038', '0'),
('DEF', 'RM-039', '0'),
('DEF', 'RM-040', '0'),
('DEF', 'RM-041', '0'),
('DEF', 'RM-042', '0'),
('DEF', 'RM-043', '0'),
('DEF', 'RM-044', '0'),
('DEF', 'RM-045', '0'),
('DEF', 'RM-046', '0'),
('DEF', 'RM-047', '0'),
('DEF', 'RM-048', '0'),
('DEF', 'RM-049', '0'),
('DEF', 'RM-050', '0'),
('DEF', 'RM-051', '0'),
('DEF', 'RM-052', '0'),
('DEF', 'RM-053', '0'),
('DEF', 'RM-054', '0'),
('DEF', 'RM-055', '0'),
('DEF', 'RM-056', '0'),
('DEF', 'RM-057', '0'),
('DEF', 'RM-058', '0'),
('DEF', 'RM-059', '0'),
('DEF', 'RM-060', '0'),
('DEF', 'RM-061', '0'),
('DEF', 'RM-062', '0'),
('DEF', 'RM-063', '0'),
('DEF', 'RM-064', '0'),
('DEF', 'RM-065', '0'),
('DEF', 'RM-066', '0'),
('DEF', 'RM-067', '0'),
('DEF', 'RM-068', '0'),
('DEF', 'RM-069', '0'),
('DEF', 'RM-070', '0'),
('DEF', 'RM-071', '0'),
('DEF', 'RM-072', '0'),
('DEF', 'RM-073', '0'),
('DEF', 'RM-074', '0'),
('DEF', 'RM-075', '0'),
('DEF', 'RM-076', '0'),
('DEF', 'RM-077', '0'),
('DEF', 'RM-078', '0'),
('DEF', 'RM-079', '0'),
('DEF', 'RM-080', '0'),
('DEF', 'RM-081', '0'),
('DEF', 'RM-082', '0'),
('DEF', 'RM-083', '0'),
('DEF', 'RM-084', '0'),
('DEF', 'RM-085', '0'),
('DEF', 'RM-086', '0'),
('DEF', 'RM-087', '0'),
('DEF', 'RM-088', '0'),
('DEF', 'RM-089', '0'),
('DEF', 'RM-090', '0'),
('DEF', 'RM-091', '0'),
('DEF', 'RM-092', '0'),
('DEF', 'RM-093', '0'),
('DEF', 'RM-094', '0'),
('DEF', 'RM-095', '0'),
('DEF', 'RM-096', '0'),
('DEF', 'RM-097', '0'),
('DEF', 'RM-098', '0'),
('DEF', 'RM-099', '0'),
('DEF', 'RM-100', '0'),
('DEF', 'RM-101', '0'),
('DEF', 'RM-102', '0'),
('DEF', 'RM-103', '0'),
('DEF', 'RM-104', '0'),
('DEF', 'RM-105', '0'),
('DEF', 'RM-106', '0'),
('DEF', 'RM-107', '0'),
('DEF', 'RM-108', '0'),
('DEF', 'RM-109', '0'),
('DEF', 'RM-110', '0'),
('DEF', 'RM-111', '0'),
('DEF', 'RM-112', '0'),
('DEF', 'RM-113', '0'),
('DEF', 'RM-114', '0'),
('DEF', 'RM-115', '0'),
('DEF', 'RM-116', '0'),
('DEF', 'RM-117', '0'),
('DEF', 'RM-118', '0'),
('DEF', 'RM-119', '0'),
('DEF', 'RM-120', '0'),
('DEF', 'RM-121', '0'),
('DEF', 'RM-122', '0'),
('DEF', 'RM-123', '0'),
('DEF', 'RM-124', '0'),
('DEF', 'RM-125', '0'),
('DEF', 'RM-126', '0'),
('DEF', 'RM-127', '0'),
('DEF', 'RM-128', '0'),
('DEF', 'RM-129', '0'),
('DEF', 'RM-130', '0'),
('DEF', 'RM-131', '0'),
('DEF', 'RM-132', '0'),
('DEF', 'RM-133', '0'),
('DEF', 'RM-134', '0'),
('DEF', 'RM-135', '0'),
('DEF', 'RM-136', '0'),
('DEF', 'SFG-101', '0'),
('DEF', 'SFG-102', '0'),
('DEF', 'SFG-103', '0'),
('DEF', 'SFG-104', '0'),
('DEF', 'SFG-105', '0'),
('DEF', 'SFG-106', '0'),
('DEF', 'SFG-107', '0'),
('DEF', 'SFG-108', '0'),
('DEF', 'SFG-109', '0'),
('DEF', 'SFG-110', '0'),
('DEF', 'SFG-111', '0'),
('DEF', 'SFG-112', '0'),
('DEF', 'SFG-113', '0'),
('DEF', 'SFG-114', '0'),
('DEF', 'SFG-115', '0'),
('DEF', 'SFG-116', '0'),
('DEF', 'SFG-117', '0'),
('DEF', 'SFG-118', '0'),
('DEF', 'SFG-119', '0'),
('DEF', 'SFG-120', '0'),
('DEF', 'SFG-121', '0'),
('DEF', 'SFG-122', '0'),
('DEF', 'SFG-123', '0'),
('DEF', 'SFG-124', '0'),
('DEF', 'SFG-125', '0'),
('DEF', 'SFG-126', '0'),
('DEF', 'SFG-127', '0'),
('DEF', 'SFG-128', '0'),
('DEF', 'ST-0001', '0'),
('DMGST', 'CM-001', '0'),
('DMGST', 'CM-002', '0'),
('DMGST', 'CM-003', '0'),
('DMGST', 'CM-004', '0'),
('DMGST', 'CM-005', '0'),
('DMGST', 'CM-006', '0'),
('DMGST', 'CM-007', '0'),
('DMGST', 'CM-008', '0'),
('DMGST', 'CM-009', '0'),
('DMGST', 'CM-010', '0'),
('DMGST', 'CM-011', '0'),
('DMGST', 'CM-012', '0'),
('DMGST', 'CM-013', '0'),
('DMGST', 'CM-014', '0'),
('DMGST', 'CM-015', '0'),
('DMGST', 'CM-016', '0'),
('DMGST', 'CM-017', '0'),
('DMGST', 'CM-018', '0'),
('DMGST', 'CM-019', '0'),
('DMGST', 'CM-020', '0'),
('DMGST', 'CM-021', '0'),
('DMGST', 'CM-022', '0'),
('DMGST', 'CM-023', '0'),
('DMGST', 'CM-024', '0'),
('DMGST', 'CM-025', '0'),
('DMGST', 'CM-026', '0'),
('DMGST', 'CM-027', '0'),
('DMGST', 'CM-028', '0'),
('DMGST', 'CM-029', '0'),
('DMGST', 'CM-030', '0'),
('DMGST', 'CM-031', '0'),
('DMGST', 'CM-032', '0'),
('DMGST', 'CM-033', '0'),
('DMGST', 'CM-034', '0'),
('DMGST', 'CM-035', '0'),
('DMGST', 'CM-036', '0'),
('DMGST', 'CM-037', '0'),
('DMGST', 'CM-038', '0'),
('DMGST', 'CM-039', '0'),
('DMGST', 'CM-040', '0'),
('DMGST', 'CM-041', '0'),
('DMGST', 'CM-042', '0'),
('DMGST', 'CM-043', '0'),
('DMGST', 'CM-044', '0'),
('DMGST', 'CM-045', '0'),
('DMGST', 'CM-046', '0'),
('DMGST', 'CM-047', '0'),
('DMGST', 'CM-048', '0'),
('DMGST', 'CM-049', '0'),
('DMGST', 'CM-050', '0'),
('DMGST', 'CM-051', '0'),
('DMGST', 'CM-052', '0'),
('DMGST', 'CM-053', '0'),
('DMGST', 'CM-054', '0'),
('DMGST', 'CM-055', '0'),
('DMGST', 'CM-056', '0'),
('DMGST', 'CM-057', '0'),
('DMGST', 'CM-058', '0'),
('DMGST', 'CM-059', '0'),
('DMGST', 'CM-060', '0'),
('DMGST', 'CM-061', '0'),
('DMGST', 'CM-062', '0'),
('DMGST', 'CM-063', '0'),
('DMGST', 'CM-064', '0'),
('DMGST', 'CM-065', '0'),
('DMGST', 'CM-066', '0'),
('DMGST', 'CM-067', '0'),
('DMGST', 'CM-069', '0'),
('DMGST', 'CM-070', '0'),
('DMGST', 'CM-071', '0'),
('DMGST', 'FA-01', '0'),
('DMGST', 'FG-001', '0'),
('DMGST', 'FG-002', '0'),
('DMGST', 'FG-003', '0'),
('DMGST', 'FG-004', '0'),
('DMGST', 'FG-005', '0'),
('DMGST', 'FG-006', '0'),
('DMGST', 'FG-007', '0'),
('DMGST', 'FG-008', '0'),
('DMGST', 'FG-009', '0'),
('DMGST', 'FG-010', '0'),
('DMGST', 'FG-011', '0'),
('DMGST', 'FG-012', '0'),
('DMGST', 'FG-013', '0'),
('DMGST', 'FG-014', '0'),
('DMGST', 'FG-015', '0'),
('DMGST', 'FG-016', '0'),
('DMGST', 'FG-017', '0'),
('DMGST', 'FG-018', '0'),
('DMGST', 'FG-019', '0'),
('DMGST', 'FG-020', '0'),
('DMGST', 'FG-021', '0'),
('DMGST', 'FG-022', '0'),
('DMGST', 'FG-023', '0'),
('DMGST', 'FG-024', '0'),
('DMGST', 'FG-025', '0'),
('DMGST', 'FG-026', '0'),
('DMGST', 'FG-027', '0'),
('DMGST', 'FG-028', '0'),
('DMGST', 'FG-029', '0'),
('DMGST', 'FG-030', '0'),
('DMGST', 'FG-031', '0'),
('DMGST', 'FG-032', '0'),
('DMGST', 'FG-033', '0'),
('DMGST', 'FG-034', '0'),
('DMGST', 'FG-035', '0'),
('DMGST', 'FG-036', '0'),
('DMGST', 'FG-037', '0'),
('DMGST', 'FG-038', '0'),
('DMGST', 'FG-039', '0'),
('DMGST', 'FG-040', '0'),
('DMGST', 'FG-041', '0'),
('DMGST', 'FG-042', '0'),
('DMGST', 'FG-043', '0'),
('DMGST', 'FG-044', '0'),
('DMGST', 'FG-045', '0'),
('DMGST', 'FG-046', '0'),
('DMGST', 'FG-047', '0'),
('DMGST', 'FG-048', '0'),
('DMGST', 'FG-049', '0'),
('DMGST', 'FG-050', '0'),
('DMGST', 'FG-051', '0'),
('DMGST', 'FG-052', '0'),
('DMGST', 'FG-053', '0'),
('DMGST', 'FG-054', '0'),
('DMGST', 'FG-055', '0'),
('DMGST', 'FG-056', '0'),
('DMGST', 'FG-057', '0'),
('DMGST', 'FG-058', '0'),
('DMGST', 'FG-059', '0'),
('DMGST', 'FG-060', '0'),
('DMGST', 'FG-061', '0'),
('DMGST', 'FG-062', '0'),
('DMGST', 'FG-063', '0'),
('DMGST', 'FG-064', '0'),
('DMGST', 'FG-065', '0'),
('DMGST', 'FG-066', '0'),
('DMGST', 'FG-067', '0'),
('DMGST', 'FG-068', '0'),
('DMGST', 'FG-069', '0'),
('DMGST', 'FG-070', '0'),
('DMGST', 'RM-001', '0'),
('DMGST', 'RM-002', '0'),
('DMGST', 'RM-003', '0'),
('DMGST', 'RM-004', '0'),
('DMGST', 'RM-005', '0'),
('DMGST', 'RM-006', '0'),
('DMGST', 'RM-007', '0'),
('DMGST', 'RM-008', '0'),
('DMGST', 'RM-009', '0'),
('DMGST', 'RM-010', '0'),
('DMGST', 'RM-011', '0'),
('DMGST', 'RM-012', '0'),
('DMGST', 'RM-013', '0'),
('DMGST', 'RM-014', '0'),
('DMGST', 'RM-015', '0'),
('DMGST', 'RM-016', '0'),
('DMGST', 'RM-017', '0'),
('DMGST', 'RM-018', '0'),
('DMGST', 'RM-019', '0'),
('DMGST', 'RM-020', '0'),
('DMGST', 'RM-021', '0'),
('DMGST', 'RM-022', '0'),
('DMGST', 'RM-023', '0'),
('DMGST', 'RM-024', '0'),
('DMGST', 'RM-025', '0'),
('DMGST', 'RM-026', '0'),
('DMGST', 'RM-027', '0'),
('DMGST', 'RM-028', '0'),
('DMGST', 'RM-029', '0'),
('DMGST', 'RM-030', '0'),
('DMGST', 'RM-031', '0'),
('DMGST', 'RM-032', '0'),
('DMGST', 'RM-033', '0'),
('DMGST', 'RM-034', '0'),
('DMGST', 'RM-035', '0'),
('DMGST', 'RM-036', '0'),
('DMGST', 'RM-037', '0'),
('DMGST', 'RM-038', '0'),
('DMGST', 'RM-039', '0'),
('DMGST', 'RM-040', '0'),
('DMGST', 'RM-041', '0'),
('DMGST', 'RM-042', '0'),
('DMGST', 'RM-043', '0'),
('DMGST', 'RM-044', '0'),
('DMGST', 'RM-045', '0'),
('DMGST', 'RM-046', '0'),
('DMGST', 'RM-047', '0'),
('DMGST', 'RM-048', '0'),
('DMGST', 'RM-049', '0'),
('DMGST', 'RM-050', '0'),
('DMGST', 'RM-051', '0'),
('DMGST', 'RM-052', '0'),
('DMGST', 'RM-053', '0'),
('DMGST', 'RM-054', '0'),
('DMGST', 'RM-055', '0'),
('DMGST', 'RM-056', '0'),
('DMGST', 'RM-057', '0'),
('DMGST', 'RM-058', '0'),
('DMGST', 'RM-059', '0'),
('DMGST', 'RM-060', '0'),
('DMGST', 'RM-061', '0'),
('DMGST', 'RM-062', '0'),
('DMGST', 'RM-063', '0'),
('DMGST', 'RM-064', '0'),
('DMGST', 'RM-065', '0'),
('DMGST', 'RM-066', '0'),
('DMGST', 'RM-067', '0'),
('DMGST', 'RM-068', '0'),
('DMGST', 'RM-069', '0'),
('DMGST', 'RM-070', '0'),
('DMGST', 'RM-071', '0'),
('DMGST', 'RM-072', '0'),
('DMGST', 'RM-073', '0'),
('DMGST', 'RM-074', '0'),
('DMGST', 'RM-075', '0'),
('DMGST', 'RM-076', '0'),
('DMGST', 'RM-077', '0'),
('DMGST', 'RM-078', '0'),
('DMGST', 'RM-079', '0'),
('DMGST', 'RM-080', '0'),
('DMGST', 'RM-081', '0'),
('DMGST', 'RM-082', '0'),
('DMGST', 'RM-083', '0'),
('DMGST', 'RM-084', '0'),
('DMGST', 'RM-085', '0'),
('DMGST', 'RM-086', '0'),
('DMGST', 'RM-087', '0'),
('DMGST', 'RM-088', '0'),
('DMGST', 'RM-089', '0'),
('DMGST', 'RM-090', '0'),
('DMGST', 'RM-091', '0'),
('DMGST', 'RM-092', '0'),
('DMGST', 'RM-093', '0'),
('DMGST', 'RM-094', '0'),
('DMGST', 'RM-095', '0'),
('DMGST', 'RM-096', '0'),
('DMGST', 'RM-097', '0'),
('DMGST', 'RM-098', '0'),
('DMGST', 'RM-099', '0'),
('DMGST', 'RM-100', '0'),
('DMGST', 'RM-101', '0'),
('DMGST', 'RM-102', '0'),
('DMGST', 'RM-103', '0'),
('DMGST', 'RM-104', '0'),
('DMGST', 'RM-105', '0'),
('DMGST', 'RM-106', '0'),
('DMGST', 'RM-107', '0'),
('DMGST', 'RM-108', '0'),
('DMGST', 'RM-109', '0'),
('DMGST', 'RM-110', '0'),
('DMGST', 'RM-111', '0'),
('DMGST', 'RM-112', '0'),
('DMGST', 'RM-113', '0'),
('DMGST', 'RM-114', '0'),
('DMGST', 'RM-115', '0'),
('DMGST', 'RM-116', '0'),
('DMGST', 'RM-117', '0'),
('DMGST', 'RM-118', '0'),
('DMGST', 'RM-119', '0'),
('DMGST', 'RM-120', '0'),
('DMGST', 'RM-121', '0'),
('DMGST', 'RM-122', '0'),
('DMGST', 'RM-123', '0'),
('DMGST', 'RM-124', '0'),
('DMGST', 'RM-125', '0'),
('DMGST', 'RM-126', '0'),
('DMGST', 'RM-127', '0'),
('DMGST', 'RM-128', '0'),
('DMGST', 'RM-129', '0'),
('DMGST', 'RM-130', '0'),
('DMGST', 'RM-131', '0'),
('DMGST', 'RM-132', '0'),
('DMGST', 'RM-133', '0'),
('DMGST', 'RM-134', '0'),
('DMGST', 'RM-135', '0'),
('DMGST', 'RM-136', '0'),
('DMGST', 'SFG-101', '0'),
('DMGST', 'SFG-102', '0'),
('DMGST', 'SFG-103', '0'),
('DMGST', 'SFG-104', '0'),
('DMGST', 'SFG-105', '0'),
('DMGST', 'SFG-106', '0'),
('DMGST', 'SFG-107', '0'),
('DMGST', 'SFG-108', '0'),
('DMGST', 'SFG-109', '0'),
('DMGST', 'SFG-110', '0'),
('DMGST', 'SFG-111', '0'),
('DMGST', 'SFG-112', '0'),
('DMGST', 'SFG-113', '0'),
('DMGST', 'SFG-114', '0'),
('DMGST', 'SFG-115', '0'),
('DMGST', 'SFG-116', '0'),
('DMGST', 'SFG-117', '0'),
('DMGST', 'SFG-118', '0'),
('DMGST', 'SFG-119', '0'),
('DMGST', 'SFG-120', '0'),
('DMGST', 'SFG-121', '0'),
('DMGST', 'SFG-122', '0'),
('DMGST', 'SFG-123', '0'),
('DMGST', 'SFG-124', '0'),
('DMGST', 'SFG-125', '0'),
('DMGST', 'SFG-126', '0'),
('DMGST', 'SFG-127', '0'),
('DMGST', 'SFG-128', '0'),
('DMGST', 'ST-0001', '0'),
('FGHOF', 'CM-001', '0'),
('FGHOF', 'CM-002', '0'),
('FGHOF', 'CM-003', '0'),
('FGHOF', 'CM-004', '0'),
('FGHOF', 'CM-005', '0'),
('FGHOF', 'CM-006', '0'),
('FGHOF', 'CM-007', '0'),
('FGHOF', 'CM-008', '0'),
('FGHOF', 'CM-009', '0'),
('FGHOF', 'CM-010', '0'),
('FGHOF', 'CM-011', '0'),
('FGHOF', 'CM-012', '0'),
('FGHOF', 'CM-013', '0'),
('FGHOF', 'CM-014', '0'),
('FGHOF', 'CM-015', '0'),
('FGHOF', 'CM-016', '0'),
('FGHOF', 'CM-017', '0'),
('FGHOF', 'CM-018', '0'),
('FGHOF', 'CM-019', '0'),
('FGHOF', 'CM-020', '0'),
('FGHOF', 'CM-021', '0'),
('FGHOF', 'CM-022', '0'),
('FGHOF', 'CM-023', '0'),
('FGHOF', 'CM-024', '0'),
('FGHOF', 'CM-025', '0'),
('FGHOF', 'CM-026', '0'),
('FGHOF', 'CM-027', '0'),
('FGHOF', 'CM-028', '0'),
('FGHOF', 'CM-029', '0'),
('FGHOF', 'CM-030', '0'),
('FGHOF', 'CM-031', '0'),
('FGHOF', 'CM-032', '0'),
('FGHOF', 'CM-033', '0'),
('FGHOF', 'CM-034', '0'),
('FGHOF', 'CM-035', '0'),
('FGHOF', 'CM-036', '0'),
('FGHOF', 'CM-037', '0'),
('FGHOF', 'CM-038', '0'),
('FGHOF', 'CM-039', '0'),
('FGHOF', 'CM-040', '0'),
('FGHOF', 'CM-041', '0'),
('FGHOF', 'CM-042', '0'),
('FGHOF', 'CM-043', '0'),
('FGHOF', 'CM-044', '0'),
('FGHOF', 'CM-045', '0'),
('FGHOF', 'CM-046', '0'),
('FGHOF', 'CM-047', '0'),
('FGHOF', 'CM-048', '0'),
('FGHOF', 'CM-049', '0'),
('FGHOF', 'CM-050', '0'),
('FGHOF', 'CM-051', '0'),
('FGHOF', 'CM-052', '0'),
('FGHOF', 'CM-053', '0'),
('FGHOF', 'CM-054', '0'),
('FGHOF', 'CM-055', '0'),
('FGHOF', 'CM-056', '0'),
('FGHOF', 'CM-057', '0'),
('FGHOF', 'CM-058', '0'),
('FGHOF', 'CM-059', '0'),
('FGHOF', 'CM-060', '0'),
('FGHOF', 'CM-061', '0'),
('FGHOF', 'CM-062', '0'),
('FGHOF', 'CM-063', '0'),
('FGHOF', 'CM-064', '0'),
('FGHOF', 'CM-065', '0'),
('FGHOF', 'CM-066', '0'),
('FGHOF', 'CM-067', '0'),
('FGHOF', 'CM-069', '0'),
('FGHOF', 'CM-070', '0'),
('FGHOF', 'CM-071', '0'),
('FGHOF', 'FA-01', '0'),
('FGHOF', 'FG-001', '0'),
('FGHOF', 'FG-002', '0'),
('FGHOF', 'FG-003', '0'),
('FGHOF', 'FG-004', '0'),
('FGHOF', 'FG-005', '0'),
('FGHOF', 'FG-006', '0'),
('FGHOF', 'FG-007', '0'),
('FGHOF', 'FG-008', '0'),
('FGHOF', 'FG-009', '0'),
('FGHOF', 'FG-010', '0'),
('FGHOF', 'FG-011', '0'),
('FGHOF', 'FG-012', '0'),
('FGHOF', 'FG-013', '0'),
('FGHOF', 'FG-014', '0'),
('FGHOF', 'FG-015', '0'),
('FGHOF', 'FG-016', '0'),
('FGHOF', 'FG-017', '0'),
('FGHOF', 'FG-018', '0'),
('FGHOF', 'FG-019', '0'),
('FGHOF', 'FG-020', '0'),
('FGHOF', 'FG-021', '0'),
('FGHOF', 'FG-022', '0'),
('FGHOF', 'FG-023', '0'),
('FGHOF', 'FG-024', '0'),
('FGHOF', 'FG-025', '0'),
('FGHOF', 'FG-026', '0'),
('FGHOF', 'FG-027', '0'),
('FGHOF', 'FG-028', '0'),
('FGHOF', 'FG-029', '0'),
('FGHOF', 'FG-030', '0'),
('FGHOF', 'FG-031', '0'),
('FGHOF', 'FG-032', '0'),
('FGHOF', 'FG-033', '0'),
('FGHOF', 'FG-034', '0'),
('FGHOF', 'FG-035', '0'),
('FGHOF', 'FG-036', '0'),
('FGHOF', 'FG-037', '0'),
('FGHOF', 'FG-038', '0'),
('FGHOF', 'FG-039', '0'),
('FGHOF', 'FG-040', '0'),
('FGHOF', 'FG-041', '0'),
('FGHOF', 'FG-042', '0'),
('FGHOF', 'FG-043', '0'),
('FGHOF', 'FG-044', '0'),
('FGHOF', 'FG-045', '0'),
('FGHOF', 'FG-046', '0'),
('FGHOF', 'FG-047', '0'),
('FGHOF', 'FG-048', '0'),
('FGHOF', 'FG-049', '0'),
('FGHOF', 'FG-050', '0'),
('FGHOF', 'FG-051', '0'),
('FGHOF', 'FG-052', '0'),
('FGHOF', 'FG-053', '0'),
('FGHOF', 'FG-054', '0'),
('FGHOF', 'FG-055', '0'),
('FGHOF', 'FG-056', '0'),
('FGHOF', 'FG-057', '0'),
('FGHOF', 'FG-058', '0'),
('FGHOF', 'FG-059', '0'),
('FGHOF', 'FG-060', '0'),
('FGHOF', 'FG-061', '0'),
('FGHOF', 'FG-062', '0'),
('FGHOF', 'FG-063', '0'),
('FGHOF', 'FG-064', '0'),
('FGHOF', 'FG-065', '0'),
('FGHOF', 'FG-066', '0'),
('FGHOF', 'FG-067', '0'),
('FGHOF', 'FG-068', '0'),
('FGHOF', 'FG-069', '0'),
('FGHOF', 'FG-070', '0'),
('FGHOF', 'RM-001', '0'),
('FGHOF', 'RM-002', '0'),
('FGHOF', 'RM-003', '0'),
('FGHOF', 'RM-004', '0'),
('FGHOF', 'RM-005', '0'),
('FGHOF', 'RM-006', '0'),
('FGHOF', 'RM-007', '0'),
('FGHOF', 'RM-008', '0'),
('FGHOF', 'RM-009', '0'),
('FGHOF', 'RM-010', '0'),
('FGHOF', 'RM-011', '0'),
('FGHOF', 'RM-012', '0'),
('FGHOF', 'RM-013', '0'),
('FGHOF', 'RM-014', '0'),
('FGHOF', 'RM-015', '0'),
('FGHOF', 'RM-016', '0'),
('FGHOF', 'RM-017', '0'),
('FGHOF', 'RM-018', '0'),
('FGHOF', 'RM-019', '0'),
('FGHOF', 'RM-020', '0'),
('FGHOF', 'RM-021', '0'),
('FGHOF', 'RM-022', '0'),
('FGHOF', 'RM-023', '0'),
('FGHOF', 'RM-024', '0'),
('FGHOF', 'RM-025', '0'),
('FGHOF', 'RM-026', '0'),
('FGHOF', 'RM-027', '0'),
('FGHOF', 'RM-028', '0'),
('FGHOF', 'RM-029', '0'),
('FGHOF', 'RM-030', '0'),
('FGHOF', 'RM-031', '0'),
('FGHOF', 'RM-032', '0'),
('FGHOF', 'RM-033', '0'),
('FGHOF', 'RM-034', '0'),
('FGHOF', 'RM-035', '0'),
('FGHOF', 'RM-036', '0'),
('FGHOF', 'RM-037', '0'),
('FGHOF', 'RM-038', '0'),
('FGHOF', 'RM-039', '0'),
('FGHOF', 'RM-040', '0'),
('FGHOF', 'RM-041', '0'),
('FGHOF', 'RM-042', '0'),
('FGHOF', 'RM-043', '0'),
('FGHOF', 'RM-044', '0'),
('FGHOF', 'RM-045', '0'),
('FGHOF', 'RM-046', '0'),
('FGHOF', 'RM-047', '0'),
('FGHOF', 'RM-048', '0'),
('FGHOF', 'RM-049', '0'),
('FGHOF', 'RM-050', '0'),
('FGHOF', 'RM-051', '0'),
('FGHOF', 'RM-052', '0'),
('FGHOF', 'RM-053', '0'),
('FGHOF', 'RM-054', '0'),
('FGHOF', 'RM-055', '0'),
('FGHOF', 'RM-056', '0'),
('FGHOF', 'RM-057', '0'),
('FGHOF', 'RM-058', '0'),
('FGHOF', 'RM-059', '0'),
('FGHOF', 'RM-060', '0'),
('FGHOF', 'RM-061', '0'),
('FGHOF', 'RM-062', '0'),
('FGHOF', 'RM-063', '0'),
('FGHOF', 'RM-064', '0'),
('FGHOF', 'RM-065', '0'),
('FGHOF', 'RM-066', '0'),
('FGHOF', 'RM-067', '0'),
('FGHOF', 'RM-068', '0'),
('FGHOF', 'RM-069', '0'),
('FGHOF', 'RM-070', '0'),
('FGHOF', 'RM-071', '0'),
('FGHOF', 'RM-072', '0'),
('FGHOF', 'RM-073', '0'),
('FGHOF', 'RM-074', '0'),
('FGHOF', 'RM-075', '0'),
('FGHOF', 'RM-076', '0'),
('FGHOF', 'RM-077', '0'),
('FGHOF', 'RM-078', '0'),
('FGHOF', 'RM-079', '0'),
('FGHOF', 'RM-080', '0'),
('FGHOF', 'RM-081', '0'),
('FGHOF', 'RM-082', '0'),
('FGHOF', 'RM-083', '0'),
('FGHOF', 'RM-084', '0'),
('FGHOF', 'RM-085', '0'),
('FGHOF', 'RM-086', '0'),
('FGHOF', 'RM-087', '0'),
('FGHOF', 'RM-088', '0'),
('FGHOF', 'RM-089', '0'),
('FGHOF', 'RM-090', '0'),
('FGHOF', 'RM-091', '0'),
('FGHOF', 'RM-092', '0'),
('FGHOF', 'RM-093', '0'),
('FGHOF', 'RM-094', '0'),
('FGHOF', 'RM-095', '0'),
('FGHOF', 'RM-096', '0'),
('FGHOF', 'RM-097', '0'),
('FGHOF', 'RM-098', '0'),
('FGHOF', 'RM-099', '0'),
('FGHOF', 'RM-100', '0'),
('FGHOF', 'RM-101', '0'),
('FGHOF', 'RM-102', '0'),
('FGHOF', 'RM-103', '0'),
('FGHOF', 'RM-104', '0'),
('FGHOF', 'RM-105', '0'),
('FGHOF', 'RM-106', '0'),
('FGHOF', 'RM-107', '0'),
('FGHOF', 'RM-108', '0'),
('FGHOF', 'RM-109', '0'),
('FGHOF', 'RM-110', '0'),
('FGHOF', 'RM-111', '0'),
('FGHOF', 'RM-112', '0'),
('FGHOF', 'RM-113', '0'),
('FGHOF', 'RM-114', '0'),
('FGHOF', 'RM-115', '0'),
('FGHOF', 'RM-116', '0'),
('FGHOF', 'RM-117', '0'),
('FGHOF', 'RM-118', '0'),
('FGHOF', 'RM-119', '0'),
('FGHOF', 'RM-120', '0'),
('FGHOF', 'RM-121', '0'),
('FGHOF', 'RM-122', '0'),
('FGHOF', 'RM-123', '0'),
('FGHOF', 'RM-124', '0'),
('FGHOF', 'RM-125', '0'),
('FGHOF', 'RM-126', '0'),
('FGHOF', 'RM-127', '0'),
('FGHOF', 'RM-128', '0'),
('FGHOF', 'RM-129', '0'),
('FGHOF', 'RM-130', '0'),
('FGHOF', 'RM-131', '0'),
('FGHOF', 'RM-132', '0'),
('FGHOF', 'RM-133', '0'),
('FGHOF', 'RM-134', '0'),
('FGHOF', 'RM-135', '0'),
('FGHOF', 'RM-136', '0'),
('FGHOF', 'SFG-101', '0'),
('FGHOF', 'SFG-102', '0'),
('FGHOF', 'SFG-103', '0'),
('FGHOF', 'SFG-104', '0'),
('FGHOF', 'SFG-105', '0'),
('FGHOF', 'SFG-106', '0'),
('FGHOF', 'SFG-107', '0'),
('FGHOF', 'SFG-108', '0'),
('FGHOF', 'SFG-109', '0'),
('FGHOF', 'SFG-110', '0'),
('FGHOF', 'SFG-111', '0'),
('FGHOF', 'SFG-112', '0'),
('FGHOF', 'SFG-113', '0'),
('FGHOF', 'SFG-114', '0'),
('FGHOF', 'SFG-115', '0'),
('FGHOF', 'SFG-116', '0'),
('FGHOF', 'SFG-117', '0'),
('FGHOF', 'SFG-118', '0'),
('FGHOF', 'SFG-119', '0'),
('FGHOF', 'SFG-120', '0'),
('FGHOF', 'SFG-121', '0'),
('FGHOF', 'SFG-122', '0'),
('FGHOF', 'SFG-123', '0'),
('FGHOF', 'SFG-124', '0'),
('FGHOF', 'SFG-125', '0'),
('FGHOF', 'SFG-126', '0'),
('FGHOF', 'SFG-127', '0'),
('FGHOF', 'SFG-128', '0'),
('FGHOF', 'ST-0001', '0'),
('FGHUB', 'CM-001', '0'),
('FGHUB', 'CM-002', '0'),
('FGHUB', 'CM-003', '0'),
('FGHUB', 'CM-004', '0'),
('FGHUB', 'CM-005', '0'),
('FGHUB', 'CM-006', '0'),
('FGHUB', 'CM-007', '0'),
('FGHUB', 'CM-008', '0'),
('FGHUB', 'CM-009', '0'),
('FGHUB', 'CM-010', '0'),
('FGHUB', 'CM-011', '0'),
('FGHUB', 'CM-012', '0'),
('FGHUB', 'CM-013', '0'),
('FGHUB', 'CM-014', '0'),
('FGHUB', 'CM-015', '0'),
('FGHUB', 'CM-016', '0'),
('FGHUB', 'CM-017', '0'),
('FGHUB', 'CM-018', '0'),
('FGHUB', 'CM-019', '0'),
('FGHUB', 'CM-020', '0'),
('FGHUB', 'CM-021', '0'),
('FGHUB', 'CM-022', '0'),
('FGHUB', 'CM-023', '0'),
('FGHUB', 'CM-024', '0'),
('FGHUB', 'CM-025', '0'),
('FGHUB', 'CM-026', '0'),
('FGHUB', 'CM-027', '0'),
('FGHUB', 'CM-028', '0'),
('FGHUB', 'CM-029', '0'),
('FGHUB', 'CM-030', '0'),
('FGHUB', 'CM-031', '0'),
('FGHUB', 'CM-032', '0'),
('FGHUB', 'CM-033', '0'),
('FGHUB', 'CM-034', '0'),
('FGHUB', 'CM-035', '0'),
('FGHUB', 'CM-036', '0'),
('FGHUB', 'CM-037', '0'),
('FGHUB', 'CM-038', '0'),
('FGHUB', 'CM-039', '0'),
('FGHUB', 'CM-040', '0'),
('FGHUB', 'CM-041', '0'),
('FGHUB', 'CM-042', '0'),
('FGHUB', 'CM-043', '0'),
('FGHUB', 'CM-044', '0'),
('FGHUB', 'CM-045', '0'),
('FGHUB', 'CM-046', '0'),
('FGHUB', 'CM-047', '0'),
('FGHUB', 'CM-048', '0'),
('FGHUB', 'CM-049', '0'),
('FGHUB', 'CM-050', '0'),
('FGHUB', 'CM-051', '0'),
('FGHUB', 'CM-052', '0'),
('FGHUB', 'CM-053', '0'),
('FGHUB', 'CM-054', '0'),
('FGHUB', 'CM-055', '0'),
('FGHUB', 'CM-056', '0'),
('FGHUB', 'CM-057', '0'),
('FGHUB', 'CM-058', '0'),
('FGHUB', 'CM-059', '0'),
('FGHUB', 'CM-060', '0'),
('FGHUB', 'CM-061', '0'),
('FGHUB', 'CM-062', '0'),
('FGHUB', 'CM-063', '0'),
('FGHUB', 'CM-064', '0'),
('FGHUB', 'CM-065', '0'),
('FGHUB', 'CM-066', '0'),
('FGHUB', 'CM-067', '0'),
('FGHUB', 'CM-069', '0'),
('FGHUB', 'CM-070', '0'),
('FGHUB', 'CM-071', '0'),
('FGHUB', 'FA-01', '0'),
('FGHUB', 'FG-001', '0'),
('FGHUB', 'FG-002', '0'),
('FGHUB', 'FG-003', '0'),
('FGHUB', 'FG-004', '0'),
('FGHUB', 'FG-005', '0'),
('FGHUB', 'FG-006', '0'),
('FGHUB', 'FG-007', '0'),
('FGHUB', 'FG-008', '0'),
('FGHUB', 'FG-009', '0'),
('FGHUB', 'FG-010', '0'),
('FGHUB', 'FG-011', '0'),
('FGHUB', 'FG-012', '0'),
('FGHUB', 'FG-013', '0'),
('FGHUB', 'FG-014', '0'),
('FGHUB', 'FG-015', '0'),
('FGHUB', 'FG-016', '0'),
('FGHUB', 'FG-017', '0'),
('FGHUB', 'FG-018', '0'),
('FGHUB', 'FG-019', '0'),
('FGHUB', 'FG-020', '0'),
('FGHUB', 'FG-021', '0'),
('FGHUB', 'FG-022', '0'),
('FGHUB', 'FG-023', '0'),
('FGHUB', 'FG-024', '0'),
('FGHUB', 'FG-025', '0'),
('FGHUB', 'FG-026', '0'),
('FGHUB', 'FG-027', '0'),
('FGHUB', 'FG-028', '0'),
('FGHUB', 'FG-029', '0'),
('FGHUB', 'FG-030', '0'),
('FGHUB', 'FG-031', '0'),
('FGHUB', 'FG-032', '0'),
('FGHUB', 'FG-033', '0'),
('FGHUB', 'FG-034', '0'),
('FGHUB', 'FG-035', '0'),
('FGHUB', 'FG-036', '0'),
('FGHUB', 'FG-037', '0'),
('FGHUB', 'FG-038', '0'),
('FGHUB', 'FG-039', '0'),
('FGHUB', 'FG-040', '0'),
('FGHUB', 'FG-041', '0'),
('FGHUB', 'FG-042', '0'),
('FGHUB', 'FG-043', '0'),
('FGHUB', 'FG-044', '0'),
('FGHUB', 'FG-045', '0'),
('FGHUB', 'FG-046', '0'),
('FGHUB', 'FG-047', '0'),
('FGHUB', 'FG-048', '0'),
('FGHUB', 'FG-049', '0'),
('FGHUB', 'FG-050', '0'),
('FGHUB', 'FG-051', '0'),
('FGHUB', 'FG-052', '0'),
('FGHUB', 'FG-053', '0'),
('FGHUB', 'FG-054', '0'),
('FGHUB', 'FG-055', '0'),
('FGHUB', 'FG-056', '0'),
('FGHUB', 'FG-057', '0'),
('FGHUB', 'FG-058', '0'),
('FGHUB', 'FG-059', '0'),
('FGHUB', 'FG-060', '0'),
('FGHUB', 'FG-061', '0'),
('FGHUB', 'FG-062', '0'),
('FGHUB', 'FG-063', '0'),
('FGHUB', 'FG-064', '0'),
('FGHUB', 'FG-065', '0'),
('FGHUB', 'FG-066', '0'),
('FGHUB', 'FG-067', '0'),
('FGHUB', 'FG-068', '0'),
('FGHUB', 'FG-069', '0'),
('FGHUB', 'FG-070', '0'),
('FGHUB', 'RM-001', '0'),
('FGHUB', 'RM-002', '0'),
('FGHUB', 'RM-003', '0'),
('FGHUB', 'RM-004', '0'),
('FGHUB', 'RM-005', '0'),
('FGHUB', 'RM-006', '0'),
('FGHUB', 'RM-007', '0'),
('FGHUB', 'RM-008', '0'),
('FGHUB', 'RM-009', '0'),
('FGHUB', 'RM-010', '0'),
('FGHUB', 'RM-011', '0'),
('FGHUB', 'RM-012', '0'),
('FGHUB', 'RM-013', '0'),
('FGHUB', 'RM-014', '0'),
('FGHUB', 'RM-015', '0'),
('FGHUB', 'RM-016', '0'),
('FGHUB', 'RM-017', '0'),
('FGHUB', 'RM-018', '0'),
('FGHUB', 'RM-019', '0'),
('FGHUB', 'RM-020', '0'),
('FGHUB', 'RM-021', '0'),
('FGHUB', 'RM-022', '0'),
('FGHUB', 'RM-023', '0'),
('FGHUB', 'RM-024', '0'),
('FGHUB', 'RM-025', '0'),
('FGHUB', 'RM-026', '0'),
('FGHUB', 'RM-027', '0'),
('FGHUB', 'RM-028', '0'),
('FGHUB', 'RM-029', '0'),
('FGHUB', 'RM-030', '0'),
('FGHUB', 'RM-031', '0'),
('FGHUB', 'RM-032', '0'),
('FGHUB', 'RM-033', '0'),
('FGHUB', 'RM-034', '0'),
('FGHUB', 'RM-035', '0'),
('FGHUB', 'RM-036', '0'),
('FGHUB', 'RM-037', '0'),
('FGHUB', 'RM-038', '0'),
('FGHUB', 'RM-039', '0'),
('FGHUB', 'RM-040', '0'),
('FGHUB', 'RM-041', '0'),
('FGHUB', 'RM-042', '0'),
('FGHUB', 'RM-043', '0'),
('FGHUB', 'RM-044', '0'),
('FGHUB', 'RM-045', '0'),
('FGHUB', 'RM-046', '0'),
('FGHUB', 'RM-047', '0'),
('FGHUB', 'RM-048', '0'),
('FGHUB', 'RM-049', '0'),
('FGHUB', 'RM-050', '0'),
('FGHUB', 'RM-051', '0'),
('FGHUB', 'RM-052', '0'),
('FGHUB', 'RM-053', '0'),
('FGHUB', 'RM-054', '0'),
('FGHUB', 'RM-055', '0'),
('FGHUB', 'RM-056', '0'),
('FGHUB', 'RM-057', '0'),
('FGHUB', 'RM-058', '0'),
('FGHUB', 'RM-059', '0'),
('FGHUB', 'RM-060', '0'),
('FGHUB', 'RM-061', '0'),
('FGHUB', 'RM-062', '0'),
('FGHUB', 'RM-063', '0'),
('FGHUB', 'RM-064', '0'),
('FGHUB', 'RM-065', '0'),
('FGHUB', 'RM-066', '0'),
('FGHUB', 'RM-067', '0'),
('FGHUB', 'RM-068', '0'),
('FGHUB', 'RM-069', '0'),
('FGHUB', 'RM-070', '0'),
('FGHUB', 'RM-071', '0'),
('FGHUB', 'RM-072', '0'),
('FGHUB', 'RM-073', '0'),
('FGHUB', 'RM-074', '0'),
('FGHUB', 'RM-075', '0'),
('FGHUB', 'RM-076', '0'),
('FGHUB', 'RM-077', '0'),
('FGHUB', 'RM-078', '0'),
('FGHUB', 'RM-079', '0'),
('FGHUB', 'RM-080', '0'),
('FGHUB', 'RM-081', '0'),
('FGHUB', 'RM-082', '0'),
('FGHUB', 'RM-083', '0'),
('FGHUB', 'RM-084', '0'),
('FGHUB', 'RM-085', '0'),
('FGHUB', 'RM-086', '0'),
('FGHUB', 'RM-087', '0'),
('FGHUB', 'RM-088', '0'),
('FGHUB', 'RM-089', '0'),
('FGHUB', 'RM-090', '0'),
('FGHUB', 'RM-091', '0'),
('FGHUB', 'RM-092', '0'),
('FGHUB', 'RM-093', '0'),
('FGHUB', 'RM-094', '0'),
('FGHUB', 'RM-095', '0'),
('FGHUB', 'RM-096', '0'),
('FGHUB', 'RM-097', '0'),
('FGHUB', 'RM-098', '0'),
('FGHUB', 'RM-099', '0'),
('FGHUB', 'RM-100', '0'),
('FGHUB', 'RM-101', '0'),
('FGHUB', 'RM-102', '0'),
('FGHUB', 'RM-103', '0'),
('FGHUB', 'RM-104', '0'),
('FGHUB', 'RM-105', '0'),
('FGHUB', 'RM-106', '0'),
('FGHUB', 'RM-107', '0'),
('FGHUB', 'RM-108', '0'),
('FGHUB', 'RM-109', '0'),
('FGHUB', 'RM-110', '0'),
('FGHUB', 'RM-111', '0'),
('FGHUB', 'RM-112', '0'),
('FGHUB', 'RM-113', '0'),
('FGHUB', 'RM-114', '0'),
('FGHUB', 'RM-115', '0'),
('FGHUB', 'RM-116', '0'),
('FGHUB', 'RM-117', '0'),
('FGHUB', 'RM-118', '0'),
('FGHUB', 'RM-119', '0'),
('FGHUB', 'RM-120', '0'),
('FGHUB', 'RM-121', '0'),
('FGHUB', 'RM-122', '0'),
('FGHUB', 'RM-123', '0'),
('FGHUB', 'RM-124', '0'),
('FGHUB', 'RM-125', '0'),
('FGHUB', 'RM-126', '0'),
('FGHUB', 'RM-127', '0'),
('FGHUB', 'RM-128', '0'),
('FGHUB', 'RM-129', '0'),
('FGHUB', 'RM-130', '0'),
('FGHUB', 'RM-131', '0'),
('FGHUB', 'RM-132', '0'),
('FGHUB', 'RM-133', '0'),
('FGHUB', 'RM-134', '0'),
('FGHUB', 'RM-135', '0'),
('FGHUB', 'RM-136', '0'),
('FGHUB', 'SFG-101', '0'),
('FGHUB', 'SFG-102', '0'),
('FGHUB', 'SFG-103', '0'),
('FGHUB', 'SFG-104', '0'),
('FGHUB', 'SFG-105', '0'),
('FGHUB', 'SFG-106', '0'),
('FGHUB', 'SFG-107', '0'),
('FGHUB', 'SFG-108', '0'),
('FGHUB', 'SFG-109', '0'),
('FGHUB', 'SFG-110', '0'),
('FGHUB', 'SFG-111', '0'),
('FGHUB', 'SFG-112', '0'),
('FGHUB', 'SFG-113', '0'),
('FGHUB', 'SFG-114', '0'),
('FGHUB', 'SFG-115', '0'),
('FGHUB', 'SFG-116', '0'),
('FGHUB', 'SFG-117', '0'),
('FGHUB', 'SFG-118', '0'),
('FGHUB', 'SFG-119', '0'),
('FGHUB', 'SFG-120', '0'),
('FGHUB', 'SFG-121', '0'),
('FGHUB', 'SFG-122', '0'),
('FGHUB', 'SFG-123', '0'),
('FGHUB', 'SFG-124', '0'),
('FGHUB', 'SFG-125', '0'),
('FGHUB', 'SFG-126', '0'),
('FGHUB', 'SFG-127', '0'),
('FGHUB', 'SFG-128', '0'),
('FGHUB', 'ST-0001', '0'),
('FGHYD', 'CM-001', '0'),
('FGHYD', 'CM-002', '0'),
('FGHYD', 'CM-003', '0'),
('FGHYD', 'CM-004', '0'),
('FGHYD', 'CM-005', '0'),
('FGHYD', 'CM-006', '0'),
('FGHYD', 'CM-007', '0'),
('FGHYD', 'CM-008', '0'),
('FGHYD', 'CM-009', '0'),
('FGHYD', 'CM-010', '0'),
('FGHYD', 'CM-011', '0'),
('FGHYD', 'CM-012', '0'),
('FGHYD', 'CM-013', '0'),
('FGHYD', 'CM-014', '0'),
('FGHYD', 'CM-015', '0'),
('FGHYD', 'CM-016', '0'),
('FGHYD', 'CM-017', '0'),
('FGHYD', 'CM-018', '0'),
('FGHYD', 'CM-019', '0'),
('FGHYD', 'CM-020', '0'),
('FGHYD', 'CM-021', '0'),
('FGHYD', 'CM-022', '0'),
('FGHYD', 'CM-023', '0'),
('FGHYD', 'CM-024', '0'),
('FGHYD', 'CM-025', '0'),
('FGHYD', 'CM-026', '0'),
('FGHYD', 'CM-027', '0'),
('FGHYD', 'CM-028', '0'),
('FGHYD', 'CM-029', '0'),
('FGHYD', 'CM-030', '0'),
('FGHYD', 'CM-031', '0'),
('FGHYD', 'CM-032', '0'),
('FGHYD', 'CM-033', '0'),
('FGHYD', 'CM-034', '0'),
('FGHYD', 'CM-035', '0'),
('FGHYD', 'CM-036', '0'),
('FGHYD', 'CM-037', '0'),
('FGHYD', 'CM-038', '0'),
('FGHYD', 'CM-039', '0'),
('FGHYD', 'CM-040', '0'),
('FGHYD', 'CM-041', '0'),
('FGHYD', 'CM-042', '0'),
('FGHYD', 'CM-043', '0'),
('FGHYD', 'CM-044', '0'),
('FGHYD', 'CM-045', '0'),
('FGHYD', 'CM-046', '0'),
('FGHYD', 'CM-047', '0'),
('FGHYD', 'CM-048', '0'),
('FGHYD', 'CM-049', '0'),
('FGHYD', 'CM-050', '0'),
('FGHYD', 'CM-051', '0'),
('FGHYD', 'CM-052', '0'),
('FGHYD', 'CM-053', '0'),
('FGHYD', 'CM-054', '0'),
('FGHYD', 'CM-055', '0'),
('FGHYD', 'CM-056', '0'),
('FGHYD', 'CM-057', '0'),
('FGHYD', 'CM-058', '0'),
('FGHYD', 'CM-059', '0'),
('FGHYD', 'CM-060', '0'),
('FGHYD', 'CM-061', '0'),
('FGHYD', 'CM-062', '0'),
('FGHYD', 'CM-063', '0'),
('FGHYD', 'CM-064', '0'),
('FGHYD', 'CM-065', '0'),
('FGHYD', 'CM-066', '0'),
('FGHYD', 'CM-067', '0'),
('FGHYD', 'CM-069', '0'),
('FGHYD', 'CM-070', '0'),
('FGHYD', 'CM-071', '0'),
('FGHYD', 'FA-01', '0'),
('FGHYD', 'FG-001', '0'),
('FGHYD', 'FG-002', '0'),
('FGHYD', 'FG-003', '0'),
('FGHYD', 'FG-004', '0'),
('FGHYD', 'FG-005', '0'),
('FGHYD', 'FG-006', '0'),
('FGHYD', 'FG-007', '0'),
('FGHYD', 'FG-008', '0'),
('FGHYD', 'FG-009', '0'),
('FGHYD', 'FG-010', '0'),
('FGHYD', 'FG-011', '0'),
('FGHYD', 'FG-012', '0'),
('FGHYD', 'FG-013', '2400'),
('FGHYD', 'FG-014', '0'),
('FGHYD', 'FG-015', '0'),
('FGHYD', 'FG-016', '0'),
('FGHYD', 'FG-017', '0'),
('FGHYD', 'FG-018', '0'),
('FGHYD', 'FG-019', '0'),
('FGHYD', 'FG-020', '0'),
('FGHYD', 'FG-021', '0'),
('FGHYD', 'FG-022', '0'),
('FGHYD', 'FG-023', '0'),
('FGHYD', 'FG-024', '0'),
('FGHYD', 'FG-025', '0'),
('FGHYD', 'FG-026', '0'),
('FGHYD', 'FG-027', '0'),
('FGHYD', 'FG-028', '0'),
('FGHYD', 'FG-029', '0'),
('FGHYD', 'FG-030', '0'),
('FGHYD', 'FG-031', '0'),
('FGHYD', 'FG-032', '0'),
('FGHYD', 'FG-033', '0'),
('FGHYD', 'FG-034', '0'),
('FGHYD', 'FG-035', '0'),
('FGHYD', 'FG-036', '0'),
('FGHYD', 'FG-037', '0'),
('FGHYD', 'FG-038', '0'),
('FGHYD', 'FG-039', '0'),
('FGHYD', 'FG-040', '0'),
('FGHYD', 'FG-041', '0'),
('FGHYD', 'FG-042', '0'),
('FGHYD', 'FG-043', '0'),
('FGHYD', 'FG-044', '0'),
('FGHYD', 'FG-045', '0'),
('FGHYD', 'FG-046', '0'),
('FGHYD', 'FG-047', '0'),
('FGHYD', 'FG-048', '0'),
('FGHYD', 'FG-049', '0'),
('FGHYD', 'FG-050', '0'),
('FGHYD', 'FG-051', '0'),
('FGHYD', 'FG-052', '0'),
('FGHYD', 'FG-053', '0'),
('FGHYD', 'FG-054', '0'),
('FGHYD', 'FG-055', '0'),
('FGHYD', 'FG-056', '0'),
('FGHYD', 'FG-057', '0'),
('FGHYD', 'FG-058', '0'),
('FGHYD', 'FG-059', '0'),
('FGHYD', 'FG-060', '0'),
('FGHYD', 'FG-061', '0'),
('FGHYD', 'FG-062', '0'),
('FGHYD', 'FG-063', '0'),
('FGHYD', 'FG-064', '0'),
('FGHYD', 'FG-065', '0'),
('FGHYD', 'FG-066', '0'),
('FGHYD', 'FG-067', '0'),
('FGHYD', 'FG-068', '0'),
('FGHYD', 'FG-069', '0'),
('FGHYD', 'FG-070', '0'),
('FGHYD', 'RM-001', '0'),
('FGHYD', 'RM-002', '0'),
('FGHYD', 'RM-003', '0'),
('FGHYD', 'RM-004', '0'),
('FGHYD', 'RM-005', '0'),
('FGHYD', 'RM-006', '0'),
('FGHYD', 'RM-007', '0'),
('FGHYD', 'RM-008', '0'),
('FGHYD', 'RM-009', '0'),
('FGHYD', 'RM-010', '0'),
('FGHYD', 'RM-011', '0'),
('FGHYD', 'RM-012', '0'),
('FGHYD', 'RM-013', '0'),
('FGHYD', 'RM-014', '0'),
('FGHYD', 'RM-015', '0'),
('FGHYD', 'RM-016', '0'),
('FGHYD', 'RM-017', '0'),
('FGHYD', 'RM-018', '0'),
('FGHYD', 'RM-019', '0'),
('FGHYD', 'RM-020', '0'),
('FGHYD', 'RM-021', '0'),
('FGHYD', 'RM-022', '0'),
('FGHYD', 'RM-023', '0'),
('FGHYD', 'RM-024', '0'),
('FGHYD', 'RM-025', '0'),
('FGHYD', 'RM-026', '0'),
('FGHYD', 'RM-027', '0'),
('FGHYD', 'RM-028', '0'),
('FGHYD', 'RM-029', '0'),
('FGHYD', 'RM-030', '0'),
('FGHYD', 'RM-031', '0'),
('FGHYD', 'RM-032', '0'),
('FGHYD', 'RM-033', '0'),
('FGHYD', 'RM-034', '0'),
('FGHYD', 'RM-035', '0'),
('FGHYD', 'RM-036', '0'),
('FGHYD', 'RM-037', '0'),
('FGHYD', 'RM-038', '0'),
('FGHYD', 'RM-039', '0'),
('FGHYD', 'RM-040', '0'),
('FGHYD', 'RM-041', '0'),
('FGHYD', 'RM-042', '0'),
('FGHYD', 'RM-043', '0'),
('FGHYD', 'RM-044', '0'),
('FGHYD', 'RM-045', '0'),
('FGHYD', 'RM-046', '0'),
('FGHYD', 'RM-047', '0'),
('FGHYD', 'RM-048', '0'),
('FGHYD', 'RM-049', '0'),
('FGHYD', 'RM-050', '0'),
('FGHYD', 'RM-051', '0'),
('FGHYD', 'RM-052', '0'),
('FGHYD', 'RM-053', '0'),
('FGHYD', 'RM-054', '0'),
('FGHYD', 'RM-055', '0'),
('FGHYD', 'RM-056', '0'),
('FGHYD', 'RM-057', '0'),
('FGHYD', 'RM-058', '0'),
('FGHYD', 'RM-059', '0'),
('FGHYD', 'RM-060', '0'),
('FGHYD', 'RM-061', '0'),
('FGHYD', 'RM-062', '0'),
('FGHYD', 'RM-063', '0'),
('FGHYD', 'RM-064', '0'),
('FGHYD', 'RM-065', '0'),
('FGHYD', 'RM-066', '0'),
('FGHYD', 'RM-067', '0'),
('FGHYD', 'RM-068', '0'),
('FGHYD', 'RM-069', '0'),
('FGHYD', 'RM-070', '0'),
('FGHYD', 'RM-071', '0'),
('FGHYD', 'RM-072', '0'),
('FGHYD', 'RM-073', '0'),
('FGHYD', 'RM-074', '0'),
('FGHYD', 'RM-075', '0'),
('FGHYD', 'RM-076', '0'),
('FGHYD', 'RM-077', '0'),
('FGHYD', 'RM-078', '0'),
('FGHYD', 'RM-079', '0'),
('FGHYD', 'RM-080', '0'),
('FGHYD', 'RM-081', '0'),
('FGHYD', 'RM-082', '0'),
('FGHYD', 'RM-083', '0'),
('FGHYD', 'RM-084', '0'),
('FGHYD', 'RM-085', '0'),
('FGHYD', 'RM-086', '0'),
('FGHYD', 'RM-087', '0'),
('FGHYD', 'RM-088', '0'),
('FGHYD', 'RM-089', '0'),
('FGHYD', 'RM-090', '0'),
('FGHYD', 'RM-091', '0'),
('FGHYD', 'RM-092', '0'),
('FGHYD', 'RM-093', '0'),
('FGHYD', 'RM-094', '0'),
('FGHYD', 'RM-095', '0'),
('FGHYD', 'RM-096', '0'),
('FGHYD', 'RM-097', '0'),
('FGHYD', 'RM-098', '0'),
('FGHYD', 'RM-099', '0'),
('FGHYD', 'RM-100', '0'),
('FGHYD', 'RM-101', '0'),
('FGHYD', 'RM-102', '0'),
('FGHYD', 'RM-103', '0'),
('FGHYD', 'RM-104', '0'),
('FGHYD', 'RM-105', '0'),
('FGHYD', 'RM-106', '0'),
('FGHYD', 'RM-107', '0'),
('FGHYD', 'RM-108', '0'),
('FGHYD', 'RM-109', '0'),
('FGHYD', 'RM-110', '0'),
('FGHYD', 'RM-111', '0'),
('FGHYD', 'RM-112', '0'),
('FGHYD', 'RM-113', '0'),
('FGHYD', 'RM-114', '0'),
('FGHYD', 'RM-115', '0'),
('FGHYD', 'RM-116', '0'),
('FGHYD', 'RM-117', '0'),
('FGHYD', 'RM-118', '0'),
('FGHYD', 'RM-119', '0'),
('FGHYD', 'RM-120', '0'),
('FGHYD', 'RM-121', '0'),
('FGHYD', 'RM-122', '0'),
('FGHYD', 'RM-123', '0'),
('FGHYD', 'RM-124', '0'),
('FGHYD', 'RM-125', '0'),
('FGHYD', 'RM-126', '0'),
('FGHYD', 'RM-127', '0'),
('FGHYD', 'RM-128', '0'),
('FGHYD', 'RM-129', '0'),
('FGHYD', 'RM-130', '0'),
('FGHYD', 'RM-131', '0'),
('FGHYD', 'RM-132', '0'),
('FGHYD', 'RM-133', '0'),
('FGHYD', 'RM-134', '0'),
('FGHYD', 'RM-135', '0'),
('FGHYD', 'RM-136', '0'),
('FGHYD', 'SFG-101', '0'),
('FGHYD', 'SFG-102', '0'),
('FGHYD', 'SFG-103', '0'),
('FGHYD', 'SFG-104', '0'),
('FGHYD', 'SFG-105', '0'),
('FGHYD', 'SFG-106', '0'),
('FGHYD', 'SFG-107', '0'),
('FGHYD', 'SFG-108', '0'),
('FGHYD', 'SFG-109', '0'),
('FGHYD', 'SFG-110', '0'),
('FGHYD', 'SFG-111', '0'),
('FGHYD', 'SFG-112', '0'),
('FGHYD', 'SFG-113', '0'),
('FGHYD', 'SFG-114', '0'),
('FGHYD', 'SFG-115', '0'),
('FGHYD', 'SFG-116', '0'),
('FGHYD', 'SFG-117', '0'),
('FGHYD', 'SFG-118', '0'),
('FGHYD', 'SFG-119', '0'),
('FGHYD', 'SFG-120', '0'),
('FGHYD', 'SFG-121', '0'),
('FGHYD', 'SFG-122', '0'),
('FGHYD', 'SFG-123', '0'),
('FGHYD', 'SFG-124', '0'),
('FGHYD', 'SFG-125', '0'),
('FGHYD', 'SFG-126', '0'),
('FGHYD', 'SFG-127', '0'),
('FGHYD', 'SFG-128', '0'),
('FGHYD', 'ST-0001', '0'),
('FGKAR', 'CM-001', '0'),
('FGKAR', 'CM-002', '0'),
('FGKAR', 'CM-003', '0'),
('FGKAR', 'CM-004', '0'),
('FGKAR', 'CM-005', '0'),
('FGKAR', 'CM-006', '0'),
('FGKAR', 'CM-007', '0'),
('FGKAR', 'CM-008', '0'),
('FGKAR', 'CM-009', '0'),
('FGKAR', 'CM-010', '0'),
('FGKAR', 'CM-011', '0'),
('FGKAR', 'CM-012', '0'),
('FGKAR', 'CM-013', '0'),
('FGKAR', 'CM-014', '0'),
('FGKAR', 'CM-015', '0'),
('FGKAR', 'CM-016', '0'),
('FGKAR', 'CM-017', '0'),
('FGKAR', 'CM-018', '0'),
('FGKAR', 'CM-019', '0'),
('FGKAR', 'CM-020', '0'),
('FGKAR', 'CM-021', '0'),
('FGKAR', 'CM-022', '0'),
('FGKAR', 'CM-023', '0'),
('FGKAR', 'CM-024', '0'),
('FGKAR', 'CM-025', '0'),
('FGKAR', 'CM-026', '0'),
('FGKAR', 'CM-027', '0'),
('FGKAR', 'CM-028', '0'),
('FGKAR', 'CM-029', '0'),
('FGKAR', 'CM-030', '0'),
('FGKAR', 'CM-031', '0'),
('FGKAR', 'CM-032', '0'),
('FGKAR', 'CM-033', '0'),
('FGKAR', 'CM-034', '0'),
('FGKAR', 'CM-035', '0'),
('FGKAR', 'CM-036', '0'),
('FGKAR', 'CM-037', '0'),
('FGKAR', 'CM-038', '0'),
('FGKAR', 'CM-039', '0'),
('FGKAR', 'CM-040', '0'),
('FGKAR', 'CM-041', '0'),
('FGKAR', 'CM-042', '0'),
('FGKAR', 'CM-043', '0'),
('FGKAR', 'CM-044', '0'),
('FGKAR', 'CM-045', '0'),
('FGKAR', 'CM-046', '0'),
('FGKAR', 'CM-047', '0'),
('FGKAR', 'CM-048', '0'),
('FGKAR', 'CM-049', '0'),
('FGKAR', 'CM-050', '0'),
('FGKAR', 'CM-051', '0'),
('FGKAR', 'CM-052', '0'),
('FGKAR', 'CM-053', '0'),
('FGKAR', 'CM-054', '0'),
('FGKAR', 'CM-055', '0'),
('FGKAR', 'CM-056', '0'),
('FGKAR', 'CM-057', '0'),
('FGKAR', 'CM-058', '0'),
('FGKAR', 'CM-059', '0'),
('FGKAR', 'CM-060', '0'),
('FGKAR', 'CM-061', '0'),
('FGKAR', 'CM-062', '0'),
('FGKAR', 'CM-063', '0'),
('FGKAR', 'CM-064', '0'),
('FGKAR', 'CM-065', '0'),
('FGKAR', 'CM-066', '0'),
('FGKAR', 'CM-067', '0'),
('FGKAR', 'CM-069', '0'),
('FGKAR', 'CM-070', '0'),
('FGKAR', 'CM-071', '0'),
('FGKAR', 'FA-01', '0'),
('FGKAR', 'FG-001', '0'),
('FGKAR', 'FG-002', '0'),
('FGKAR', 'FG-003', '0'),
('FGKAR', 'FG-004', '0'),
('FGKAR', 'FG-005', '0'),
('FGKAR', 'FG-006', '0'),
('FGKAR', 'FG-007', '0'),
('FGKAR', 'FG-008', '0'),
('FGKAR', 'FG-009', '0'),
('FGKAR', 'FG-010', '0'),
('FGKAR', 'FG-011', '0'),
('FGKAR', 'FG-012', '0'),
('FGKAR', 'FG-013', '5000'),
('FGKAR', 'FG-014', '0'),
('FGKAR', 'FG-015', '0'),
('FGKAR', 'FG-016', '0'),
('FGKAR', 'FG-017', '0'),
('FGKAR', 'FG-018', '0'),
('FGKAR', 'FG-019', '0'),
('FGKAR', 'FG-020', '0'),
('FGKAR', 'FG-021', '0'),
('FGKAR', 'FG-022', '0'),
('FGKAR', 'FG-023', '0'),
('FGKAR', 'FG-024', '0'),
('FGKAR', 'FG-025', '0'),
('FGKAR', 'FG-026', '0'),
('FGKAR', 'FG-027', '0'),
('FGKAR', 'FG-028', '0'),
('FGKAR', 'FG-029', '0'),
('FGKAR', 'FG-030', '0'),
('FGKAR', 'FG-031', '0'),
('FGKAR', 'FG-032', '0'),
('FGKAR', 'FG-033', '0'),
('FGKAR', 'FG-034', '0'),
('FGKAR', 'FG-035', '0'),
('FGKAR', 'FG-036', '0'),
('FGKAR', 'FG-037', '0'),
('FGKAR', 'FG-038', '0'),
('FGKAR', 'FG-039', '0'),
('FGKAR', 'FG-040', '0'),
('FGKAR', 'FG-041', '0'),
('FGKAR', 'FG-042', '0'),
('FGKAR', 'FG-043', '0'),
('FGKAR', 'FG-044', '0'),
('FGKAR', 'FG-045', '0'),
('FGKAR', 'FG-046', '0'),
('FGKAR', 'FG-047', '0'),
('FGKAR', 'FG-048', '0'),
('FGKAR', 'FG-049', '0'),
('FGKAR', 'FG-050', '0'),
('FGKAR', 'FG-051', '0'),
('FGKAR', 'FG-052', '0'),
('FGKAR', 'FG-053', '0'),
('FGKAR', 'FG-054', '0'),
('FGKAR', 'FG-055', '0'),
('FGKAR', 'FG-056', '0'),
('FGKAR', 'FG-057', '0'),
('FGKAR', 'FG-058', '0'),
('FGKAR', 'FG-059', '0'),
('FGKAR', 'FG-060', '0'),
('FGKAR', 'FG-061', '0'),
('FGKAR', 'FG-062', '0'),
('FGKAR', 'FG-063', '0'),
('FGKAR', 'FG-064', '0'),
('FGKAR', 'FG-065', '0'),
('FGKAR', 'FG-066', '0'),
('FGKAR', 'FG-067', '0'),
('FGKAR', 'FG-068', '0'),
('FGKAR', 'FG-069', '0'),
('FGKAR', 'FG-070', '0'),
('FGKAR', 'RM-001', '0'),
('FGKAR', 'RM-002', '0'),
('FGKAR', 'RM-003', '0'),
('FGKAR', 'RM-004', '0'),
('FGKAR', 'RM-005', '0'),
('FGKAR', 'RM-006', '0'),
('FGKAR', 'RM-007', '0'),
('FGKAR', 'RM-008', '0'),
('FGKAR', 'RM-009', '0'),
('FGKAR', 'RM-010', '0'),
('FGKAR', 'RM-011', '0'),
('FGKAR', 'RM-012', '0'),
('FGKAR', 'RM-013', '0'),
('FGKAR', 'RM-014', '0'),
('FGKAR', 'RM-015', '0'),
('FGKAR', 'RM-016', '0'),
('FGKAR', 'RM-017', '0'),
('FGKAR', 'RM-018', '0'),
('FGKAR', 'RM-019', '0'),
('FGKAR', 'RM-020', '0'),
('FGKAR', 'RM-021', '0'),
('FGKAR', 'RM-022', '0'),
('FGKAR', 'RM-023', '0'),
('FGKAR', 'RM-024', '0'),
('FGKAR', 'RM-025', '0'),
('FGKAR', 'RM-026', '0'),
('FGKAR', 'RM-027', '0'),
('FGKAR', 'RM-028', '0'),
('FGKAR', 'RM-029', '0'),
('FGKAR', 'RM-030', '0'),
('FGKAR', 'RM-031', '0'),
('FGKAR', 'RM-032', '0'),
('FGKAR', 'RM-033', '0'),
('FGKAR', 'RM-034', '0'),
('FGKAR', 'RM-035', '0'),
('FGKAR', 'RM-036', '0'),
('FGKAR', 'RM-037', '0'),
('FGKAR', 'RM-038', '0'),
('FGKAR', 'RM-039', '0'),
('FGKAR', 'RM-040', '0'),
('FGKAR', 'RM-041', '0'),
('FGKAR', 'RM-042', '0'),
('FGKAR', 'RM-043', '0'),
('FGKAR', 'RM-044', '0'),
('FGKAR', 'RM-045', '0'),
('FGKAR', 'RM-046', '0'),
('FGKAR', 'RM-047', '0'),
('FGKAR', 'RM-048', '0'),
('FGKAR', 'RM-049', '0'),
('FGKAR', 'RM-050', '0'),
('FGKAR', 'RM-051', '0'),
('FGKAR', 'RM-052', '0'),
('FGKAR', 'RM-053', '0'),
('FGKAR', 'RM-054', '0'),
('FGKAR', 'RM-055', '0'),
('FGKAR', 'RM-056', '0');
INSERT INTO `0_loc_stock` VALUES
('FGKAR', 'RM-057', '0'),
('FGKAR', 'RM-058', '0'),
('FGKAR', 'RM-059', '0'),
('FGKAR', 'RM-060', '0'),
('FGKAR', 'RM-061', '0'),
('FGKAR', 'RM-062', '0'),
('FGKAR', 'RM-063', '0'),
('FGKAR', 'RM-064', '0'),
('FGKAR', 'RM-065', '0'),
('FGKAR', 'RM-066', '0'),
('FGKAR', 'RM-067', '0'),
('FGKAR', 'RM-068', '0'),
('FGKAR', 'RM-069', '0'),
('FGKAR', 'RM-070', '0'),
('FGKAR', 'RM-071', '0'),
('FGKAR', 'RM-072', '0'),
('FGKAR', 'RM-073', '0'),
('FGKAR', 'RM-074', '0'),
('FGKAR', 'RM-075', '0'),
('FGKAR', 'RM-076', '0'),
('FGKAR', 'RM-077', '0'),
('FGKAR', 'RM-078', '0'),
('FGKAR', 'RM-079', '0'),
('FGKAR', 'RM-080', '0'),
('FGKAR', 'RM-081', '0'),
('FGKAR', 'RM-082', '0'),
('FGKAR', 'RM-083', '0'),
('FGKAR', 'RM-084', '0'),
('FGKAR', 'RM-085', '0'),
('FGKAR', 'RM-086', '0'),
('FGKAR', 'RM-087', '0'),
('FGKAR', 'RM-088', '0'),
('FGKAR', 'RM-089', '0'),
('FGKAR', 'RM-090', '0'),
('FGKAR', 'RM-091', '0'),
('FGKAR', 'RM-092', '0'),
('FGKAR', 'RM-093', '0'),
('FGKAR', 'RM-094', '0'),
('FGKAR', 'RM-095', '0'),
('FGKAR', 'RM-096', '0'),
('FGKAR', 'RM-097', '0'),
('FGKAR', 'RM-098', '0'),
('FGKAR', 'RM-099', '0'),
('FGKAR', 'RM-100', '0'),
('FGKAR', 'RM-101', '0'),
('FGKAR', 'RM-102', '0'),
('FGKAR', 'RM-103', '0'),
('FGKAR', 'RM-104', '0'),
('FGKAR', 'RM-105', '0'),
('FGKAR', 'RM-106', '0'),
('FGKAR', 'RM-107', '0'),
('FGKAR', 'RM-108', '0'),
('FGKAR', 'RM-109', '0'),
('FGKAR', 'RM-110', '0'),
('FGKAR', 'RM-111', '0'),
('FGKAR', 'RM-112', '0'),
('FGKAR', 'RM-113', '0'),
('FGKAR', 'RM-114', '0'),
('FGKAR', 'RM-115', '0'),
('FGKAR', 'RM-116', '0'),
('FGKAR', 'RM-117', '0'),
('FGKAR', 'RM-118', '0'),
('FGKAR', 'RM-119', '0'),
('FGKAR', 'RM-120', '0'),
('FGKAR', 'RM-121', '0'),
('FGKAR', 'RM-122', '0'),
('FGKAR', 'RM-123', '0'),
('FGKAR', 'RM-124', '0'),
('FGKAR', 'RM-125', '0'),
('FGKAR', 'RM-126', '0'),
('FGKAR', 'RM-127', '0'),
('FGKAR', 'RM-128', '0'),
('FGKAR', 'RM-129', '0'),
('FGKAR', 'RM-130', '0'),
('FGKAR', 'RM-131', '0'),
('FGKAR', 'RM-132', '0'),
('FGKAR', 'RM-133', '0'),
('FGKAR', 'RM-134', '0'),
('FGKAR', 'RM-135', '0'),
('FGKAR', 'RM-136', '0'),
('FGKAR', 'SFG-101', '0'),
('FGKAR', 'SFG-102', '0'),
('FGKAR', 'SFG-103', '0'),
('FGKAR', 'SFG-104', '0'),
('FGKAR', 'SFG-105', '0'),
('FGKAR', 'SFG-106', '0'),
('FGKAR', 'SFG-107', '0'),
('FGKAR', 'SFG-108', '0'),
('FGKAR', 'SFG-109', '0'),
('FGKAR', 'SFG-110', '0'),
('FGKAR', 'SFG-111', '0'),
('FGKAR', 'SFG-112', '0'),
('FGKAR', 'SFG-113', '0'),
('FGKAR', 'SFG-114', '0'),
('FGKAR', 'SFG-115', '0'),
('FGKAR', 'SFG-116', '0'),
('FGKAR', 'SFG-117', '0'),
('FGKAR', 'SFG-118', '0'),
('FGKAR', 'SFG-119', '0'),
('FGKAR', 'SFG-120', '0'),
('FGKAR', 'SFG-121', '0'),
('FGKAR', 'SFG-122', '0'),
('FGKAR', 'SFG-123', '0'),
('FGKAR', 'SFG-124', '0'),
('FGKAR', 'SFG-125', '0'),
('FGKAR', 'SFG-126', '0'),
('FGKAR', 'SFG-127', '0'),
('FGKAR', 'SFG-128', '0'),
('FGKAR', 'ST-0001', '0'),
('FGLHR', 'CM-001', '0'),
('FGLHR', 'CM-002', '0'),
('FGLHR', 'CM-003', '0'),
('FGLHR', 'CM-004', '0'),
('FGLHR', 'CM-005', '0'),
('FGLHR', 'CM-006', '0'),
('FGLHR', 'CM-007', '0'),
('FGLHR', 'CM-008', '0'),
('FGLHR', 'CM-009', '0'),
('FGLHR', 'CM-010', '0'),
('FGLHR', 'CM-011', '0'),
('FGLHR', 'CM-012', '0'),
('FGLHR', 'CM-013', '0'),
('FGLHR', 'CM-014', '0'),
('FGLHR', 'CM-015', '0'),
('FGLHR', 'CM-016', '0'),
('FGLHR', 'CM-017', '0'),
('FGLHR', 'CM-018', '0'),
('FGLHR', 'CM-019', '0'),
('FGLHR', 'CM-020', '0'),
('FGLHR', 'CM-021', '0'),
('FGLHR', 'CM-022', '0'),
('FGLHR', 'CM-023', '0'),
('FGLHR', 'CM-024', '0'),
('FGLHR', 'CM-025', '0'),
('FGLHR', 'CM-026', '0'),
('FGLHR', 'CM-027', '0'),
('FGLHR', 'CM-028', '0'),
('FGLHR', 'CM-029', '0'),
('FGLHR', 'CM-030', '0'),
('FGLHR', 'CM-031', '0'),
('FGLHR', 'CM-032', '0'),
('FGLHR', 'CM-033', '0'),
('FGLHR', 'CM-034', '0'),
('FGLHR', 'CM-035', '0'),
('FGLHR', 'CM-036', '0'),
('FGLHR', 'CM-037', '0'),
('FGLHR', 'CM-038', '0'),
('FGLHR', 'CM-039', '0'),
('FGLHR', 'CM-040', '0'),
('FGLHR', 'CM-041', '0'),
('FGLHR', 'CM-042', '0'),
('FGLHR', 'CM-043', '0'),
('FGLHR', 'CM-044', '0'),
('FGLHR', 'CM-045', '0'),
('FGLHR', 'CM-046', '0'),
('FGLHR', 'CM-047', '0'),
('FGLHR', 'CM-048', '0'),
('FGLHR', 'CM-049', '0'),
('FGLHR', 'CM-050', '0'),
('FGLHR', 'CM-051', '0'),
('FGLHR', 'CM-052', '0'),
('FGLHR', 'CM-053', '0'),
('FGLHR', 'CM-054', '0'),
('FGLHR', 'CM-055', '0'),
('FGLHR', 'CM-056', '0'),
('FGLHR', 'CM-057', '0'),
('FGLHR', 'CM-058', '0'),
('FGLHR', 'CM-059', '0'),
('FGLHR', 'CM-060', '0'),
('FGLHR', 'CM-061', '0'),
('FGLHR', 'CM-062', '0'),
('FGLHR', 'CM-063', '0'),
('FGLHR', 'CM-064', '0'),
('FGLHR', 'CM-065', '0'),
('FGLHR', 'CM-066', '0'),
('FGLHR', 'CM-067', '0'),
('FGLHR', 'CM-069', '0'),
('FGLHR', 'CM-070', '0'),
('FGLHR', 'CM-071', '0'),
('FGLHR', 'FA-01', '0'),
('FGLHR', 'FG-001', '0'),
('FGLHR', 'FG-002', '0'),
('FGLHR', 'FG-003', '0'),
('FGLHR', 'FG-004', '0'),
('FGLHR', 'FG-005', '0'),
('FGLHR', 'FG-006', '0'),
('FGLHR', 'FG-007', '0'),
('FGLHR', 'FG-008', '0'),
('FGLHR', 'FG-009', '0'),
('FGLHR', 'FG-010', '0'),
('FGLHR', 'FG-011', '0'),
('FGLHR', 'FG-012', '0'),
('FGLHR', 'FG-013', '2400'),
('FGLHR', 'FG-014', '0'),
('FGLHR', 'FG-015', '0'),
('FGLHR', 'FG-016', '0'),
('FGLHR', 'FG-017', '0'),
('FGLHR', 'FG-018', '0'),
('FGLHR', 'FG-019', '0'),
('FGLHR', 'FG-020', '0'),
('FGLHR', 'FG-021', '0'),
('FGLHR', 'FG-022', '0'),
('FGLHR', 'FG-023', '0'),
('FGLHR', 'FG-024', '0'),
('FGLHR', 'FG-025', '0'),
('FGLHR', 'FG-026', '0'),
('FGLHR', 'FG-027', '0'),
('FGLHR', 'FG-028', '0'),
('FGLHR', 'FG-029', '0'),
('FGLHR', 'FG-030', '0'),
('FGLHR', 'FG-031', '0'),
('FGLHR', 'FG-032', '0'),
('FGLHR', 'FG-033', '0'),
('FGLHR', 'FG-034', '0'),
('FGLHR', 'FG-035', '0'),
('FGLHR', 'FG-036', '0'),
('FGLHR', 'FG-037', '0'),
('FGLHR', 'FG-038', '0'),
('FGLHR', 'FG-039', '0'),
('FGLHR', 'FG-040', '0'),
('FGLHR', 'FG-041', '0'),
('FGLHR', 'FG-042', '0'),
('FGLHR', 'FG-043', '0'),
('FGLHR', 'FG-044', '0'),
('FGLHR', 'FG-045', '0'),
('FGLHR', 'FG-046', '0'),
('FGLHR', 'FG-047', '0'),
('FGLHR', 'FG-048', '0'),
('FGLHR', 'FG-049', '0'),
('FGLHR', 'FG-050', '0'),
('FGLHR', 'FG-051', '0'),
('FGLHR', 'FG-052', '0'),
('FGLHR', 'FG-053', '0'),
('FGLHR', 'FG-054', '0'),
('FGLHR', 'FG-055', '0'),
('FGLHR', 'FG-056', '0'),
('FGLHR', 'FG-057', '0'),
('FGLHR', 'FG-058', '0'),
('FGLHR', 'FG-059', '0'),
('FGLHR', 'FG-060', '0'),
('FGLHR', 'FG-061', '0'),
('FGLHR', 'FG-062', '0'),
('FGLHR', 'FG-063', '0'),
('FGLHR', 'FG-064', '0'),
('FGLHR', 'FG-065', '0'),
('FGLHR', 'FG-066', '0'),
('FGLHR', 'FG-067', '0'),
('FGLHR', 'FG-068', '0'),
('FGLHR', 'FG-069', '0'),
('FGLHR', 'FG-070', '0'),
('FGLHR', 'RM-001', '0'),
('FGLHR', 'RM-002', '0'),
('FGLHR', 'RM-003', '0'),
('FGLHR', 'RM-004', '0'),
('FGLHR', 'RM-005', '0'),
('FGLHR', 'RM-006', '0'),
('FGLHR', 'RM-007', '0'),
('FGLHR', 'RM-008', '0'),
('FGLHR', 'RM-009', '0'),
('FGLHR', 'RM-010', '0'),
('FGLHR', 'RM-011', '0'),
('FGLHR', 'RM-012', '0'),
('FGLHR', 'RM-013', '0'),
('FGLHR', 'RM-014', '0'),
('FGLHR', 'RM-015', '0'),
('FGLHR', 'RM-016', '0'),
('FGLHR', 'RM-017', '0'),
('FGLHR', 'RM-018', '0'),
('FGLHR', 'RM-019', '0'),
('FGLHR', 'RM-020', '0'),
('FGLHR', 'RM-021', '0'),
('FGLHR', 'RM-022', '0'),
('FGLHR', 'RM-023', '0'),
('FGLHR', 'RM-024', '0'),
('FGLHR', 'RM-025', '0'),
('FGLHR', 'RM-026', '0'),
('FGLHR', 'RM-027', '0'),
('FGLHR', 'RM-028', '0'),
('FGLHR', 'RM-029', '0'),
('FGLHR', 'RM-030', '0'),
('FGLHR', 'RM-031', '0'),
('FGLHR', 'RM-032', '0'),
('FGLHR', 'RM-033', '0'),
('FGLHR', 'RM-034', '0'),
('FGLHR', 'RM-035', '0'),
('FGLHR', 'RM-036', '0'),
('FGLHR', 'RM-037', '0'),
('FGLHR', 'RM-038', '0'),
('FGLHR', 'RM-039', '0'),
('FGLHR', 'RM-040', '0'),
('FGLHR', 'RM-041', '0'),
('FGLHR', 'RM-042', '0'),
('FGLHR', 'RM-043', '0'),
('FGLHR', 'RM-044', '0'),
('FGLHR', 'RM-045', '0'),
('FGLHR', 'RM-046', '0'),
('FGLHR', 'RM-047', '0'),
('FGLHR', 'RM-048', '0'),
('FGLHR', 'RM-049', '0'),
('FGLHR', 'RM-050', '0'),
('FGLHR', 'RM-051', '0'),
('FGLHR', 'RM-052', '0'),
('FGLHR', 'RM-053', '0'),
('FGLHR', 'RM-054', '0'),
('FGLHR', 'RM-055', '0'),
('FGLHR', 'RM-056', '0'),
('FGLHR', 'RM-057', '0'),
('FGLHR', 'RM-058', '0'),
('FGLHR', 'RM-059', '0'),
('FGLHR', 'RM-060', '0'),
('FGLHR', 'RM-061', '0'),
('FGLHR', 'RM-062', '0'),
('FGLHR', 'RM-063', '0'),
('FGLHR', 'RM-064', '0'),
('FGLHR', 'RM-065', '0'),
('FGLHR', 'RM-066', '0'),
('FGLHR', 'RM-067', '0'),
('FGLHR', 'RM-068', '0'),
('FGLHR', 'RM-069', '0'),
('FGLHR', 'RM-070', '0'),
('FGLHR', 'RM-071', '0'),
('FGLHR', 'RM-072', '0'),
('FGLHR', 'RM-073', '0'),
('FGLHR', 'RM-074', '0'),
('FGLHR', 'RM-075', '0'),
('FGLHR', 'RM-076', '0'),
('FGLHR', 'RM-077', '0'),
('FGLHR', 'RM-078', '0'),
('FGLHR', 'RM-079', '0'),
('FGLHR', 'RM-080', '0'),
('FGLHR', 'RM-081', '0'),
('FGLHR', 'RM-082', '0'),
('FGLHR', 'RM-083', '0'),
('FGLHR', 'RM-084', '0'),
('FGLHR', 'RM-085', '0'),
('FGLHR', 'RM-086', '0'),
('FGLHR', 'RM-087', '0'),
('FGLHR', 'RM-088', '0'),
('FGLHR', 'RM-089', '0'),
('FGLHR', 'RM-090', '0'),
('FGLHR', 'RM-091', '0'),
('FGLHR', 'RM-092', '0'),
('FGLHR', 'RM-093', '0'),
('FGLHR', 'RM-094', '0'),
('FGLHR', 'RM-095', '0'),
('FGLHR', 'RM-096', '0'),
('FGLHR', 'RM-097', '0'),
('FGLHR', 'RM-098', '0'),
('FGLHR', 'RM-099', '0'),
('FGLHR', 'RM-100', '0'),
('FGLHR', 'RM-101', '0'),
('FGLHR', 'RM-102', '0'),
('FGLHR', 'RM-103', '0'),
('FGLHR', 'RM-104', '0'),
('FGLHR', 'RM-105', '0'),
('FGLHR', 'RM-106', '0'),
('FGLHR', 'RM-107', '0'),
('FGLHR', 'RM-108', '0'),
('FGLHR', 'RM-109', '0'),
('FGLHR', 'RM-110', '0'),
('FGLHR', 'RM-111', '0'),
('FGLHR', 'RM-112', '0'),
('FGLHR', 'RM-113', '0'),
('FGLHR', 'RM-114', '0'),
('FGLHR', 'RM-115', '0'),
('FGLHR', 'RM-116', '0'),
('FGLHR', 'RM-117', '0'),
('FGLHR', 'RM-118', '0'),
('FGLHR', 'RM-119', '0'),
('FGLHR', 'RM-120', '0'),
('FGLHR', 'RM-121', '0'),
('FGLHR', 'RM-122', '0'),
('FGLHR', 'RM-123', '0'),
('FGLHR', 'RM-124', '0'),
('FGLHR', 'RM-125', '0'),
('FGLHR', 'RM-126', '0'),
('FGLHR', 'RM-127', '0'),
('FGLHR', 'RM-128', '0'),
('FGLHR', 'RM-129', '0'),
('FGLHR', 'RM-130', '0'),
('FGLHR', 'RM-131', '0'),
('FGLHR', 'RM-132', '0'),
('FGLHR', 'RM-133', '0'),
('FGLHR', 'RM-134', '0'),
('FGLHR', 'RM-135', '0'),
('FGLHR', 'RM-136', '0'),
('FGLHR', 'SFG-101', '0'),
('FGLHR', 'SFG-102', '0'),
('FGLHR', 'SFG-103', '0'),
('FGLHR', 'SFG-104', '0'),
('FGLHR', 'SFG-105', '0'),
('FGLHR', 'SFG-106', '0'),
('FGLHR', 'SFG-107', '0'),
('FGLHR', 'SFG-108', '0'),
('FGLHR', 'SFG-109', '0'),
('FGLHR', 'SFG-110', '0'),
('FGLHR', 'SFG-111', '0'),
('FGLHR', 'SFG-112', '0'),
('FGLHR', 'SFG-113', '0'),
('FGLHR', 'SFG-114', '0'),
('FGLHR', 'SFG-115', '0'),
('FGLHR', 'SFG-116', '0'),
('FGLHR', 'SFG-117', '0'),
('FGLHR', 'SFG-118', '0'),
('FGLHR', 'SFG-119', '0'),
('FGLHR', 'SFG-120', '0'),
('FGLHR', 'SFG-121', '0'),
('FGLHR', 'SFG-122', '0'),
('FGLHR', 'SFG-123', '0'),
('FGLHR', 'SFG-124', '0'),
('FGLHR', 'SFG-125', '0'),
('FGLHR', 'SFG-126', '0'),
('FGLHR', 'SFG-127', '0'),
('FGLHR', 'SFG-128', '0'),
('FGLHR', 'ST-0001', '0'),
('PFLOR', 'CM-001', '0'),
('PFLOR', 'CM-002', '0'),
('PFLOR', 'CM-003', '0'),
('PFLOR', 'CM-004', '0'),
('PFLOR', 'CM-005', '0'),
('PFLOR', 'CM-006', '0'),
('PFLOR', 'CM-007', '0'),
('PFLOR', 'CM-008', '0'),
('PFLOR', 'CM-009', '0'),
('PFLOR', 'CM-010', '0'),
('PFLOR', 'CM-011', '0'),
('PFLOR', 'CM-012', '0'),
('PFLOR', 'CM-013', '0'),
('PFLOR', 'CM-014', '0'),
('PFLOR', 'CM-015', '0'),
('PFLOR', 'CM-016', '0'),
('PFLOR', 'CM-017', '0'),
('PFLOR', 'CM-018', '0'),
('PFLOR', 'CM-019', '0'),
('PFLOR', 'CM-020', '0'),
('PFLOR', 'CM-021', '0'),
('PFLOR', 'CM-022', '0'),
('PFLOR', 'CM-023', '46'),
('PFLOR', 'CM-024', '0'),
('PFLOR', 'CM-025', '0'),
('PFLOR', 'CM-026', '0'),
('PFLOR', 'CM-027', '0'),
('PFLOR', 'CM-028', '0'),
('PFLOR', 'CM-029', '0'),
('PFLOR', 'CM-030', '0'),
('PFLOR', 'CM-031', '0'),
('PFLOR', 'CM-032', '0'),
('PFLOR', 'CM-033', '0'),
('PFLOR', 'CM-034', '0'),
('PFLOR', 'CM-035', '0'),
('PFLOR', 'CM-036', '0'),
('PFLOR', 'CM-037', '0'),
('PFLOR', 'CM-038', '0'),
('PFLOR', 'CM-039', '0'),
('PFLOR', 'CM-040', '0'),
('PFLOR', 'CM-041', '0'),
('PFLOR', 'CM-042', '0'),
('PFLOR', 'CM-043', '0'),
('PFLOR', 'CM-044', '0'),
('PFLOR', 'CM-045', '0'),
('PFLOR', 'CM-046', '0'),
('PFLOR', 'CM-047', '0'),
('PFLOR', 'CM-048', '0'),
('PFLOR', 'CM-049', '0'),
('PFLOR', 'CM-050', '0'),
('PFLOR', 'CM-051', '0'),
('PFLOR', 'CM-052', '0'),
('PFLOR', 'CM-053', '0'),
('PFLOR', 'CM-054', '0'),
('PFLOR', 'CM-055', '0'),
('PFLOR', 'CM-056', '0'),
('PFLOR', 'CM-057', '0'),
('PFLOR', 'CM-058', '0'),
('PFLOR', 'CM-059', '0'),
('PFLOR', 'CM-060', '0'),
('PFLOR', 'CM-061', '0'),
('PFLOR', 'CM-062', '0'),
('PFLOR', 'CM-063', '0'),
('PFLOR', 'CM-064', '0'),
('PFLOR', 'CM-065', '0'),
('PFLOR', 'CM-066', '0'),
('PFLOR', 'CM-067', '0'),
('PFLOR', 'CM-069', '0'),
('PFLOR', 'CM-070', '0'),
('PFLOR', 'CM-071', '0'),
('PFLOR', 'FA-01', '0'),
('PFLOR', 'FG-001', '0'),
('PFLOR', 'FG-002', '0'),
('PFLOR', 'FG-003', '0'),
('PFLOR', 'FG-004', '0'),
('PFLOR', 'FG-005', '0'),
('PFLOR', 'FG-006', '0'),
('PFLOR', 'FG-007', '0'),
('PFLOR', 'FG-008', '0'),
('PFLOR', 'FG-009', '0'),
('PFLOR', 'FG-010', '0'),
('PFLOR', 'FG-011', '0'),
('PFLOR', 'FG-012', '0'),
('PFLOR', 'FG-013', '0'),
('PFLOR', 'FG-014', '0'),
('PFLOR', 'FG-015', '0'),
('PFLOR', 'FG-016', '0'),
('PFLOR', 'FG-017', '0'),
('PFLOR', 'FG-018', '0'),
('PFLOR', 'FG-019', '0'),
('PFLOR', 'FG-020', '0'),
('PFLOR', 'FG-021', '0'),
('PFLOR', 'FG-022', '0'),
('PFLOR', 'FG-023', '0'),
('PFLOR', 'FG-024', '0'),
('PFLOR', 'FG-025', '0'),
('PFLOR', 'FG-026', '0'),
('PFLOR', 'FG-027', '0'),
('PFLOR', 'FG-028', '0'),
('PFLOR', 'FG-029', '0'),
('PFLOR', 'FG-030', '0'),
('PFLOR', 'FG-031', '0'),
('PFLOR', 'FG-032', '0'),
('PFLOR', 'FG-033', '0'),
('PFLOR', 'FG-034', '0'),
('PFLOR', 'FG-035', '0'),
('PFLOR', 'FG-036', '0'),
('PFLOR', 'FG-037', '0'),
('PFLOR', 'FG-038', '0'),
('PFLOR', 'FG-039', '0'),
('PFLOR', 'FG-040', '0'),
('PFLOR', 'FG-041', '0'),
('PFLOR', 'FG-042', '0'),
('PFLOR', 'FG-043', '0'),
('PFLOR', 'FG-044', '0'),
('PFLOR', 'FG-045', '0'),
('PFLOR', 'FG-046', '0'),
('PFLOR', 'FG-047', '0'),
('PFLOR', 'FG-048', '0'),
('PFLOR', 'FG-049', '0'),
('PFLOR', 'FG-050', '0'),
('PFLOR', 'FG-051', '0'),
('PFLOR', 'FG-052', '0'),
('PFLOR', 'FG-053', '0'),
('PFLOR', 'FG-054', '0'),
('PFLOR', 'FG-055', '0'),
('PFLOR', 'FG-056', '0'),
('PFLOR', 'FG-057', '0'),
('PFLOR', 'FG-058', '0'),
('PFLOR', 'FG-059', '0'),
('PFLOR', 'FG-060', '0'),
('PFLOR', 'FG-061', '0'),
('PFLOR', 'FG-062', '0'),
('PFLOR', 'FG-063', '0'),
('PFLOR', 'FG-064', '0'),
('PFLOR', 'FG-065', '0'),
('PFLOR', 'FG-066', '0'),
('PFLOR', 'FG-067', '0'),
('PFLOR', 'FG-068', '0'),
('PFLOR', 'FG-069', '0'),
('PFLOR', 'FG-070', '0'),
('PFLOR', 'RM-001', '0'),
('PFLOR', 'RM-002', '0'),
('PFLOR', 'RM-003', '0'),
('PFLOR', 'RM-004', '0'),
('PFLOR', 'RM-005', '0'),
('PFLOR', 'RM-006', '0'),
('PFLOR', 'RM-007', '0'),
('PFLOR', 'RM-008', '0'),
('PFLOR', 'RM-009', '0'),
('PFLOR', 'RM-010', '0'),
('PFLOR', 'RM-011', '0'),
('PFLOR', 'RM-012', '0'),
('PFLOR', 'RM-013', '0'),
('PFLOR', 'RM-014', '0'),
('PFLOR', 'RM-015', '0'),
('PFLOR', 'RM-016', '0'),
('PFLOR', 'RM-017', '0'),
('PFLOR', 'RM-018', '0'),
('PFLOR', 'RM-019', '0'),
('PFLOR', 'RM-020', '0'),
('PFLOR', 'RM-021', '0'),
('PFLOR', 'RM-022', '0'),
('PFLOR', 'RM-023', '0'),
('PFLOR', 'RM-024', '0'),
('PFLOR', 'RM-025', '0'),
('PFLOR', 'RM-026', '0'),
('PFLOR', 'RM-027', '0'),
('PFLOR', 'RM-028', '0'),
('PFLOR', 'RM-029', '0'),
('PFLOR', 'RM-030', '0'),
('PFLOR', 'RM-031', '0'),
('PFLOR', 'RM-032', '0'),
('PFLOR', 'RM-033', '0'),
('PFLOR', 'RM-034', '0'),
('PFLOR', 'RM-035', '0'),
('PFLOR', 'RM-036', '0'),
('PFLOR', 'RM-037', '0'),
('PFLOR', 'RM-038', '0'),
('PFLOR', 'RM-039', '0'),
('PFLOR', 'RM-040', '0'),
('PFLOR', 'RM-041', '0'),
('PFLOR', 'RM-042', '0'),
('PFLOR', 'RM-043', '0'),
('PFLOR', 'RM-044', '0'),
('PFLOR', 'RM-045', '0'),
('PFLOR', 'RM-046', '0'),
('PFLOR', 'RM-047', '0'),
('PFLOR', 'RM-048', '0'),
('PFLOR', 'RM-049', '0'),
('PFLOR', 'RM-050', '0'),
('PFLOR', 'RM-051', '0'),
('PFLOR', 'RM-052', '0'),
('PFLOR', 'RM-053', '0'),
('PFLOR', 'RM-054', '0'),
('PFLOR', 'RM-055', '0'),
('PFLOR', 'RM-056', '0'),
('PFLOR', 'RM-057', '0'),
('PFLOR', 'RM-058', '0'),
('PFLOR', 'RM-059', '0'),
('PFLOR', 'RM-060', '0'),
('PFLOR', 'RM-061', '0'),
('PFLOR', 'RM-062', '0'),
('PFLOR', 'RM-063', '0'),
('PFLOR', 'RM-064', '0'),
('PFLOR', 'RM-065', '0'),
('PFLOR', 'RM-066', '0'),
('PFLOR', 'RM-067', '0'),
('PFLOR', 'RM-068', '0'),
('PFLOR', 'RM-069', '0'),
('PFLOR', 'RM-070', '0'),
('PFLOR', 'RM-071', '0'),
('PFLOR', 'RM-072', '0'),
('PFLOR', 'RM-073', '0'),
('PFLOR', 'RM-074', '0'),
('PFLOR', 'RM-075', '0'),
('PFLOR', 'RM-076', '0'),
('PFLOR', 'RM-077', '0'),
('PFLOR', 'RM-078', '0'),
('PFLOR', 'RM-079', '0'),
('PFLOR', 'RM-080', '0'),
('PFLOR', 'RM-081', '0'),
('PFLOR', 'RM-082', '0'),
('PFLOR', 'RM-083', '0'),
('PFLOR', 'RM-084', '0'),
('PFLOR', 'RM-085', '0'),
('PFLOR', 'RM-086', '0'),
('PFLOR', 'RM-087', '0'),
('PFLOR', 'RM-088', '0'),
('PFLOR', 'RM-089', '0'),
('PFLOR', 'RM-090', '0'),
('PFLOR', 'RM-091', '0'),
('PFLOR', 'RM-092', '0'),
('PFLOR', 'RM-093', '0'),
('PFLOR', 'RM-094', '0'),
('PFLOR', 'RM-095', '0'),
('PFLOR', 'RM-096', '0'),
('PFLOR', 'RM-097', '0'),
('PFLOR', 'RM-098', '0'),
('PFLOR', 'RM-099', '0'),
('PFLOR', 'RM-100', '0'),
('PFLOR', 'RM-101', '0'),
('PFLOR', 'RM-102', '0'),
('PFLOR', 'RM-103', '0'),
('PFLOR', 'RM-104', '0'),
('PFLOR', 'RM-105', '0'),
('PFLOR', 'RM-106', '0'),
('PFLOR', 'RM-107', '0'),
('PFLOR', 'RM-108', '0'),
('PFLOR', 'RM-109', '0'),
('PFLOR', 'RM-110', '0'),
('PFLOR', 'RM-111', '0'),
('PFLOR', 'RM-112', '0'),
('PFLOR', 'RM-113', '0'),
('PFLOR', 'RM-114', '0'),
('PFLOR', 'RM-115', '0'),
('PFLOR', 'RM-116', '0'),
('PFLOR', 'RM-117', '0'),
('PFLOR', 'RM-118', '0'),
('PFLOR', 'RM-119', '0'),
('PFLOR', 'RM-120', '0'),
('PFLOR', 'RM-121', '0'),
('PFLOR', 'RM-122', '0'),
('PFLOR', 'RM-123', '0'),
('PFLOR', 'RM-124', '0'),
('PFLOR', 'RM-125', '0'),
('PFLOR', 'RM-126', '0'),
('PFLOR', 'RM-127', '0'),
('PFLOR', 'RM-128', '0'),
('PFLOR', 'RM-129', '0'),
('PFLOR', 'RM-130', '0'),
('PFLOR', 'RM-131', '0'),
('PFLOR', 'RM-132', '0'),
('PFLOR', 'RM-133', '0'),
('PFLOR', 'RM-134', '0'),
('PFLOR', 'RM-135', '0'),
('PFLOR', 'RM-136', '0'),
('PFLOR', 'SFG-101', '0'),
('PFLOR', 'SFG-102', '0'),
('PFLOR', 'SFG-103', '0'),
('PFLOR', 'SFG-104', '0'),
('PFLOR', 'SFG-105', '0'),
('PFLOR', 'SFG-106', '0'),
('PFLOR', 'SFG-107', '0'),
('PFLOR', 'SFG-108', '0'),
('PFLOR', 'SFG-109', '0'),
('PFLOR', 'SFG-110', '0'),
('PFLOR', 'SFG-111', '0'),
('PFLOR', 'SFG-112', '0'),
('PFLOR', 'SFG-113', '0'),
('PFLOR', 'SFG-114', '0'),
('PFLOR', 'SFG-115', '0'),
('PFLOR', 'SFG-116', '0'),
('PFLOR', 'SFG-117', '0'),
('PFLOR', 'SFG-118', '0'),
('PFLOR', 'SFG-119', '0'),
('PFLOR', 'SFG-120', '0'),
('PFLOR', 'SFG-121', '0'),
('PFLOR', 'SFG-122', '0'),
('PFLOR', 'SFG-123', '0'),
('PFLOR', 'SFG-124', '0'),
('PFLOR', 'SFG-125', '0'),
('PFLOR', 'SFG-126', '0'),
('PFLOR', 'SFG-127', '0'),
('PFLOR', 'SFG-128', '0'),
('PFLOR', 'ST-0001', '0'),
('PFLR2', 'CM-001', '0'),
('PFLR2', 'CM-002', '0'),
('PFLR2', 'CM-003', '0'),
('PFLR2', 'CM-004', '0'),
('PFLR2', 'CM-005', '0'),
('PFLR2', 'CM-006', '0'),
('PFLR2', 'CM-007', '0'),
('PFLR2', 'CM-008', '0'),
('PFLR2', 'CM-009', '0'),
('PFLR2', 'CM-010', '0'),
('PFLR2', 'CM-011', '0'),
('PFLR2', 'CM-012', '0'),
('PFLR2', 'CM-013', '0'),
('PFLR2', 'CM-014', '0'),
('PFLR2', 'CM-015', '0'),
('PFLR2', 'CM-016', '0'),
('PFLR2', 'CM-017', '0'),
('PFLR2', 'CM-018', '0'),
('PFLR2', 'CM-019', '0'),
('PFLR2', 'CM-020', '0'),
('PFLR2', 'CM-021', '0'),
('PFLR2', 'CM-022', '0'),
('PFLR2', 'CM-023', '0'),
('PFLR2', 'CM-024', '0'),
('PFLR2', 'CM-025', '0'),
('PFLR2', 'CM-026', '0'),
('PFLR2', 'CM-027', '0'),
('PFLR2', 'CM-028', '0'),
('PFLR2', 'CM-029', '0'),
('PFLR2', 'CM-030', '0'),
('PFLR2', 'CM-031', '0'),
('PFLR2', 'CM-032', '0'),
('PFLR2', 'CM-033', '0'),
('PFLR2', 'CM-034', '0'),
('PFLR2', 'CM-035', '0'),
('PFLR2', 'CM-036', '0'),
('PFLR2', 'CM-037', '0'),
('PFLR2', 'CM-038', '0'),
('PFLR2', 'CM-039', '0'),
('PFLR2', 'CM-040', '0'),
('PFLR2', 'CM-041', '0'),
('PFLR2', 'CM-042', '0'),
('PFLR2', 'CM-043', '0'),
('PFLR2', 'CM-044', '0'),
('PFLR2', 'CM-045', '0'),
('PFLR2', 'CM-046', '0'),
('PFLR2', 'CM-047', '0'),
('PFLR2', 'CM-048', '0'),
('PFLR2', 'CM-049', '0'),
('PFLR2', 'CM-050', '0'),
('PFLR2', 'CM-051', '0'),
('PFLR2', 'CM-052', '0'),
('PFLR2', 'CM-053', '0'),
('PFLR2', 'CM-054', '0'),
('PFLR2', 'CM-055', '0'),
('PFLR2', 'CM-056', '0'),
('PFLR2', 'CM-057', '0'),
('PFLR2', 'CM-058', '0'),
('PFLR2', 'CM-059', '0'),
('PFLR2', 'CM-060', '0'),
('PFLR2', 'CM-061', '0'),
('PFLR2', 'CM-062', '0'),
('PFLR2', 'CM-063', '0'),
('PFLR2', 'CM-064', '0'),
('PFLR2', 'CM-065', '0'),
('PFLR2', 'CM-066', '0'),
('PFLR2', 'CM-067', '0'),
('PFLR2', 'CM-069', '0'),
('PFLR2', 'CM-070', '0'),
('PFLR2', 'CM-071', '0'),
('PFLR2', 'FA-01', '0'),
('PFLR2', 'FG-001', '0'),
('PFLR2', 'FG-002', '0'),
('PFLR2', 'FG-003', '0'),
('PFLR2', 'FG-004', '0'),
('PFLR2', 'FG-005', '0'),
('PFLR2', 'FG-006', '0'),
('PFLR2', 'FG-007', '0'),
('PFLR2', 'FG-008', '0'),
('PFLR2', 'FG-009', '0'),
('PFLR2', 'FG-010', '0'),
('PFLR2', 'FG-011', '0'),
('PFLR2', 'FG-012', '0'),
('PFLR2', 'FG-013', '0'),
('PFLR2', 'FG-014', '0'),
('PFLR2', 'FG-015', '0'),
('PFLR2', 'FG-016', '0'),
('PFLR2', 'FG-017', '0'),
('PFLR2', 'FG-018', '0'),
('PFLR2', 'FG-019', '0'),
('PFLR2', 'FG-020', '0'),
('PFLR2', 'FG-021', '0'),
('PFLR2', 'FG-022', '0'),
('PFLR2', 'FG-023', '0'),
('PFLR2', 'FG-024', '0'),
('PFLR2', 'FG-025', '0'),
('PFLR2', 'FG-026', '0'),
('PFLR2', 'FG-027', '0'),
('PFLR2', 'FG-028', '0'),
('PFLR2', 'FG-029', '0'),
('PFLR2', 'FG-030', '0'),
('PFLR2', 'FG-031', '0'),
('PFLR2', 'FG-032', '0'),
('PFLR2', 'FG-033', '0'),
('PFLR2', 'FG-034', '0'),
('PFLR2', 'FG-035', '0'),
('PFLR2', 'FG-036', '0'),
('PFLR2', 'FG-037', '0'),
('PFLR2', 'FG-038', '0'),
('PFLR2', 'FG-039', '0'),
('PFLR2', 'FG-040', '0'),
('PFLR2', 'FG-041', '0'),
('PFLR2', 'FG-042', '0'),
('PFLR2', 'FG-043', '0'),
('PFLR2', 'FG-044', '0'),
('PFLR2', 'FG-045', '0'),
('PFLR2', 'FG-046', '0'),
('PFLR2', 'FG-047', '0'),
('PFLR2', 'FG-048', '0'),
('PFLR2', 'FG-049', '0'),
('PFLR2', 'FG-050', '0'),
('PFLR2', 'FG-051', '0'),
('PFLR2', 'FG-052', '0'),
('PFLR2', 'FG-053', '0'),
('PFLR2', 'FG-054', '0'),
('PFLR2', 'FG-055', '0'),
('PFLR2', 'FG-056', '0'),
('PFLR2', 'FG-057', '0'),
('PFLR2', 'FG-058', '0'),
('PFLR2', 'FG-059', '0'),
('PFLR2', 'FG-060', '0'),
('PFLR2', 'FG-061', '0'),
('PFLR2', 'FG-062', '0'),
('PFLR2', 'FG-063', '0'),
('PFLR2', 'FG-064', '0'),
('PFLR2', 'FG-065', '0'),
('PFLR2', 'FG-066', '0'),
('PFLR2', 'FG-067', '0'),
('PFLR2', 'FG-068', '0'),
('PFLR2', 'FG-069', '0'),
('PFLR2', 'FG-070', '0'),
('PFLR2', 'RM-001', '0'),
('PFLR2', 'RM-002', '0'),
('PFLR2', 'RM-003', '0'),
('PFLR2', 'RM-004', '0'),
('PFLR2', 'RM-005', '0'),
('PFLR2', 'RM-006', '0'),
('PFLR2', 'RM-007', '0'),
('PFLR2', 'RM-008', '0'),
('PFLR2', 'RM-009', '0'),
('PFLR2', 'RM-010', '0'),
('PFLR2', 'RM-011', '0'),
('PFLR2', 'RM-012', '0'),
('PFLR2', 'RM-013', '0'),
('PFLR2', 'RM-014', '0'),
('PFLR2', 'RM-015', '0'),
('PFLR2', 'RM-016', '0'),
('PFLR2', 'RM-017', '0'),
('PFLR2', 'RM-018', '0'),
('PFLR2', 'RM-019', '0'),
('PFLR2', 'RM-020', '0'),
('PFLR2', 'RM-021', '0'),
('PFLR2', 'RM-022', '0'),
('PFLR2', 'RM-023', '0'),
('PFLR2', 'RM-024', '0'),
('PFLR2', 'RM-025', '0'),
('PFLR2', 'RM-026', '0'),
('PFLR2', 'RM-027', '0'),
('PFLR2', 'RM-028', '0'),
('PFLR2', 'RM-029', '0'),
('PFLR2', 'RM-030', '0'),
('PFLR2', 'RM-031', '0'),
('PFLR2', 'RM-032', '0'),
('PFLR2', 'RM-033', '0'),
('PFLR2', 'RM-034', '0'),
('PFLR2', 'RM-035', '0'),
('PFLR2', 'RM-036', '0'),
('PFLR2', 'RM-037', '0'),
('PFLR2', 'RM-038', '0'),
('PFLR2', 'RM-039', '0'),
('PFLR2', 'RM-040', '0'),
('PFLR2', 'RM-041', '0'),
('PFLR2', 'RM-042', '0'),
('PFLR2', 'RM-043', '0'),
('PFLR2', 'RM-044', '0'),
('PFLR2', 'RM-045', '0'),
('PFLR2', 'RM-046', '0'),
('PFLR2', 'RM-047', '0'),
('PFLR2', 'RM-048', '0'),
('PFLR2', 'RM-049', '0'),
('PFLR2', 'RM-050', '0'),
('PFLR2', 'RM-051', '0'),
('PFLR2', 'RM-052', '0'),
('PFLR2', 'RM-053', '0'),
('PFLR2', 'RM-054', '0'),
('PFLR2', 'RM-055', '0'),
('PFLR2', 'RM-056', '0'),
('PFLR2', 'RM-057', '0'),
('PFLR2', 'RM-058', '0'),
('PFLR2', 'RM-059', '0'),
('PFLR2', 'RM-060', '0'),
('PFLR2', 'RM-061', '0'),
('PFLR2', 'RM-062', '0'),
('PFLR2', 'RM-063', '0'),
('PFLR2', 'RM-064', '0'),
('PFLR2', 'RM-065', '0'),
('PFLR2', 'RM-066', '0'),
('PFLR2', 'RM-067', '0'),
('PFLR2', 'RM-068', '0'),
('PFLR2', 'RM-069', '0'),
('PFLR2', 'RM-070', '0'),
('PFLR2', 'RM-071', '0'),
('PFLR2', 'RM-072', '0'),
('PFLR2', 'RM-073', '0'),
('PFLR2', 'RM-074', '0'),
('PFLR2', 'RM-075', '0'),
('PFLR2', 'RM-076', '0'),
('PFLR2', 'RM-077', '0'),
('PFLR2', 'RM-078', '0'),
('PFLR2', 'RM-079', '0'),
('PFLR2', 'RM-080', '0'),
('PFLR2', 'RM-081', '0'),
('PFLR2', 'RM-082', '0'),
('PFLR2', 'RM-083', '0'),
('PFLR2', 'RM-084', '0'),
('PFLR2', 'RM-085', '0'),
('PFLR2', 'RM-086', '0'),
('PFLR2', 'RM-087', '0'),
('PFLR2', 'RM-088', '0'),
('PFLR2', 'RM-089', '0'),
('PFLR2', 'RM-090', '0'),
('PFLR2', 'RM-091', '0'),
('PFLR2', 'RM-092', '0'),
('PFLR2', 'RM-093', '0'),
('PFLR2', 'RM-094', '0'),
('PFLR2', 'RM-095', '0'),
('PFLR2', 'RM-096', '0'),
('PFLR2', 'RM-097', '0'),
('PFLR2', 'RM-098', '0'),
('PFLR2', 'RM-099', '0'),
('PFLR2', 'RM-100', '0'),
('PFLR2', 'RM-101', '0'),
('PFLR2', 'RM-102', '0'),
('PFLR2', 'RM-103', '0'),
('PFLR2', 'RM-104', '0'),
('PFLR2', 'RM-105', '0'),
('PFLR2', 'RM-106', '0'),
('PFLR2', 'RM-107', '0'),
('PFLR2', 'RM-108', '0'),
('PFLR2', 'RM-109', '0'),
('PFLR2', 'RM-110', '0'),
('PFLR2', 'RM-111', '0'),
('PFLR2', 'RM-112', '0'),
('PFLR2', 'RM-113', '0'),
('PFLR2', 'RM-114', '0'),
('PFLR2', 'RM-115', '0'),
('PFLR2', 'RM-116', '0'),
('PFLR2', 'RM-117', '0'),
('PFLR2', 'RM-118', '0'),
('PFLR2', 'RM-119', '0'),
('PFLR2', 'RM-120', '0'),
('PFLR2', 'RM-121', '0'),
('PFLR2', 'RM-122', '0'),
('PFLR2', 'RM-123', '0'),
('PFLR2', 'RM-124', '0'),
('PFLR2', 'RM-125', '0'),
('PFLR2', 'RM-126', '0'),
('PFLR2', 'RM-127', '0'),
('PFLR2', 'RM-128', '0'),
('PFLR2', 'RM-129', '0'),
('PFLR2', 'RM-130', '0'),
('PFLR2', 'RM-131', '0'),
('PFLR2', 'RM-132', '0'),
('PFLR2', 'RM-133', '0'),
('PFLR2', 'RM-134', '0'),
('PFLR2', 'RM-135', '0'),
('PFLR2', 'RM-136', '0'),
('PFLR2', 'SFG-101', '0'),
('PFLR2', 'SFG-102', '0'),
('PFLR2', 'SFG-103', '0'),
('PFLR2', 'SFG-104', '0'),
('PFLR2', 'SFG-105', '0'),
('PFLR2', 'SFG-106', '0'),
('PFLR2', 'SFG-107', '0'),
('PFLR2', 'SFG-108', '0'),
('PFLR2', 'SFG-109', '0'),
('PFLR2', 'SFG-110', '0'),
('PFLR2', 'SFG-111', '0'),
('PFLR2', 'SFG-112', '0'),
('PFLR2', 'SFG-113', '0'),
('PFLR2', 'SFG-114', '0'),
('PFLR2', 'SFG-115', '0'),
('PFLR2', 'SFG-116', '0'),
('PFLR2', 'SFG-117', '0'),
('PFLR2', 'SFG-118', '0'),
('PFLR2', 'SFG-119', '0'),
('PFLR2', 'SFG-120', '0'),
('PFLR2', 'SFG-121', '0'),
('PFLR2', 'SFG-122', '0'),
('PFLR2', 'SFG-123', '0'),
('PFLR2', 'SFG-124', '0'),
('PFLR2', 'SFG-125', '0'),
('PFLR2', 'SFG-126', '0'),
('PFLR2', 'SFG-127', '0'),
('PFLR2', 'SFG-128', '0'),
('PFLR2', 'ST-0001', '0'),
('PKGST', 'CM-039', '0'),
('PKGST', 'CM-040', '0'),
('PKGST', 'CM-041', '0'),
('PKGST', 'CM-042', '0'),
('PKGST', 'CM-043', '0'),
('PKGST', 'CM-044', '0'),
('PKGST', 'CM-045', '0'),
('PKGST', 'CM-046', '0'),
('PKGST', 'CM-047', '0'),
('PKGST', 'CM-048', '0'),
('PKGST', 'CM-049', '0'),
('PKGST', 'CM-050', '0'),
('PKGST', 'CM-051', '0'),
('PKGST', 'CM-052', '0'),
('PKGST', 'CM-053', '0'),
('PKGST', 'CM-054', '0'),
('PKGST', 'CM-055', '0'),
('PKGST', 'CM-056', '0'),
('PKGST', 'CM-057', '0'),
('PKGST', 'CM-058', '0'),
('PKGST', 'CM-059', '0'),
('PKGST', 'CM-060', '0'),
('PKGST', 'CM-061', '0'),
('PKGST', 'CM-062', '0'),
('PKGST', 'CM-063', '0'),
('PKGST', 'CM-064', '0'),
('PKGST', 'CM-065', '0'),
('PKGST', 'CM-066', '0'),
('PKGST', 'CM-067', '0'),
('PKGST', 'CM-069', '0'),
('PKGST', 'CM-070', '0'),
('PKGST', 'CM-071', '0'),
('PKGST', 'FA-01', '0'),
('PKGST', 'FG-064', '0'),
('PKGST', 'FG-065', '0'),
('PKGST', 'FG-066', '0'),
('PKGST', 'FG-067', '0'),
('PKGST', 'FG-068', '0'),
('PKGST', 'FG-069', '0'),
('PKGST', 'FG-070', '0'),
('PKGST', 'RM-134', '0'),
('PKGST', 'RM-135', '0'),
('PKGST', 'RM-136', '0'),
('PKGST', 'SFG-101', '0'),
('PKGST', 'SFG-102', '0'),
('PKGST', 'SFG-103', '0'),
('PKGST', 'SFG-104', '0'),
('PKGST', 'SFG-105', '0'),
('PKGST', 'SFG-106', '0'),
('PKGST', 'SFG-107', '0'),
('PKGST', 'SFG-108', '0'),
('PKGST', 'SFG-109', '0'),
('PKGST', 'SFG-110', '0'),
('PKGST', 'SFG-111', '0'),
('PKGST', 'SFG-112', '0'),
('PKGST', 'SFG-113', '0'),
('PKGST', 'SFG-114', '0'),
('PKGST', 'SFG-115', '0'),
('PKGST', 'SFG-116', '0'),
('PKGST', 'SFG-117', '0'),
('PKGST', 'SFG-118', '0'),
('PKGST', 'SFG-119', '0'),
('PKGST', 'SFG-120', '0'),
('PKGST', 'SFG-121', '0'),
('PKGST', 'SFG-122', '0'),
('PKGST', 'SFG-123', '0'),
('PKGST', 'SFG-124', '0'),
('PKGST', 'SFG-125', '0'),
('PKGST', 'SFG-126', '0'),
('PKGST', 'SFG-127', '0'),
('PKGST', 'SFG-128', '0'),
('PKGST', 'ST-0001', '0'),
('SHINV', 'CM-001', '0'),
('SHINV', 'CM-002', '0'),
('SHINV', 'CM-003', '0'),
('SHINV', 'CM-004', '0'),
('SHINV', 'CM-005', '0'),
('SHINV', 'CM-006', '0'),
('SHINV', 'CM-007', '0'),
('SHINV', 'CM-008', '0'),
('SHINV', 'CM-009', '0'),
('SHINV', 'CM-010', '0'),
('SHINV', 'CM-011', '0'),
('SHINV', 'CM-012', '0'),
('SHINV', 'CM-013', '0'),
('SHINV', 'CM-014', '0'),
('SHINV', 'CM-015', '0'),
('SHINV', 'CM-016', '0'),
('SHINV', 'CM-017', '0'),
('SHINV', 'CM-018', '0'),
('SHINV', 'CM-019', '0'),
('SHINV', 'CM-020', '0'),
('SHINV', 'CM-021', '0'),
('SHINV', 'CM-022', '0'),
('SHINV', 'CM-023', '0'),
('SHINV', 'CM-024', '0'),
('SHINV', 'CM-025', '0'),
('SHINV', 'CM-026', '0'),
('SHINV', 'CM-027', '0'),
('SHINV', 'CM-028', '0'),
('SHINV', 'CM-029', '0'),
('SHINV', 'CM-030', '0'),
('SHINV', 'CM-031', '0'),
('SHINV', 'CM-032', '0'),
('SHINV', 'CM-033', '0'),
('SHINV', 'CM-034', '0'),
('SHINV', 'CM-035', '0'),
('SHINV', 'CM-036', '0'),
('SHINV', 'CM-037', '0'),
('SHINV', 'CM-038', '0'),
('SHINV', 'CM-039', '0'),
('SHINV', 'CM-040', '0'),
('SHINV', 'CM-041', '0'),
('SHINV', 'CM-042', '0'),
('SHINV', 'CM-043', '0'),
('SHINV', 'CM-044', '0'),
('SHINV', 'CM-045', '0'),
('SHINV', 'CM-046', '0'),
('SHINV', 'CM-047', '0'),
('SHINV', 'CM-048', '0'),
('SHINV', 'CM-049', '0'),
('SHINV', 'CM-050', '0'),
('SHINV', 'CM-051', '0'),
('SHINV', 'CM-052', '0'),
('SHINV', 'CM-053', '0'),
('SHINV', 'CM-054', '0'),
('SHINV', 'CM-055', '0'),
('SHINV', 'CM-056', '0'),
('SHINV', 'CM-057', '0'),
('SHINV', 'CM-058', '0'),
('SHINV', 'CM-059', '0'),
('SHINV', 'CM-060', '0'),
('SHINV', 'CM-061', '0'),
('SHINV', 'CM-062', '0'),
('SHINV', 'CM-063', '0'),
('SHINV', 'CM-064', '0'),
('SHINV', 'CM-065', '0'),
('SHINV', 'CM-066', '0'),
('SHINV', 'CM-067', '0'),
('SHINV', 'CM-069', '0'),
('SHINV', 'CM-070', '0'),
('SHINV', 'CM-071', '0'),
('SHINV', 'FA-01', '0'),
('SHINV', 'FG-001', '0'),
('SHINV', 'FG-002', '0'),
('SHINV', 'FG-003', '0'),
('SHINV', 'FG-004', '0'),
('SHINV', 'FG-005', '0'),
('SHINV', 'FG-006', '0'),
('SHINV', 'FG-007', '0'),
('SHINV', 'FG-008', '0'),
('SHINV', 'FG-009', '0'),
('SHINV', 'FG-010', '0'),
('SHINV', 'FG-011', '0'),
('SHINV', 'FG-012', '0'),
('SHINV', 'FG-013', '0'),
('SHINV', 'FG-014', '0'),
('SHINV', 'FG-015', '0'),
('SHINV', 'FG-016', '0'),
('SHINV', 'FG-017', '0'),
('SHINV', 'FG-018', '0'),
('SHINV', 'FG-019', '0'),
('SHINV', 'FG-020', '0'),
('SHINV', 'FG-021', '0'),
('SHINV', 'FG-022', '0'),
('SHINV', 'FG-023', '0'),
('SHINV', 'FG-024', '0'),
('SHINV', 'FG-025', '0'),
('SHINV', 'FG-026', '0'),
('SHINV', 'FG-027', '0'),
('SHINV', 'FG-028', '0'),
('SHINV', 'FG-029', '0'),
('SHINV', 'FG-030', '0'),
('SHINV', 'FG-031', '0'),
('SHINV', 'FG-032', '0'),
('SHINV', 'FG-033', '0'),
('SHINV', 'FG-034', '0'),
('SHINV', 'FG-035', '0'),
('SHINV', 'FG-036', '0'),
('SHINV', 'FG-037', '0'),
('SHINV', 'FG-038', '0'),
('SHINV', 'FG-039', '0'),
('SHINV', 'FG-040', '0'),
('SHINV', 'FG-041', '0'),
('SHINV', 'FG-042', '0'),
('SHINV', 'FG-043', '0'),
('SHINV', 'FG-044', '0'),
('SHINV', 'FG-045', '0'),
('SHINV', 'FG-046', '0'),
('SHINV', 'FG-047', '0'),
('SHINV', 'FG-048', '0'),
('SHINV', 'FG-049', '0'),
('SHINV', 'FG-050', '0'),
('SHINV', 'FG-051', '0'),
('SHINV', 'FG-052', '0'),
('SHINV', 'FG-053', '0'),
('SHINV', 'FG-054', '0'),
('SHINV', 'FG-055', '0'),
('SHINV', 'FG-056', '0'),
('SHINV', 'FG-057', '0'),
('SHINV', 'FG-058', '0'),
('SHINV', 'FG-059', '0'),
('SHINV', 'FG-060', '0'),
('SHINV', 'FG-061', '0'),
('SHINV', 'FG-062', '0'),
('SHINV', 'FG-063', '0'),
('SHINV', 'FG-064', '0'),
('SHINV', 'FG-065', '0'),
('SHINV', 'FG-066', '0'),
('SHINV', 'FG-067', '0'),
('SHINV', 'FG-068', '0'),
('SHINV', 'FG-069', '0'),
('SHINV', 'FG-070', '0'),
('SHINV', 'RM-001', '0'),
('SHINV', 'RM-002', '0'),
('SHINV', 'RM-003', '0'),
('SHINV', 'RM-004', '0'),
('SHINV', 'RM-005', '0'),
('SHINV', 'RM-006', '0'),
('SHINV', 'RM-007', '0'),
('SHINV', 'RM-008', '0'),
('SHINV', 'RM-009', '0'),
('SHINV', 'RM-010', '0'),
('SHINV', 'RM-011', '0'),
('SHINV', 'RM-012', '0'),
('SHINV', 'RM-013', '0'),
('SHINV', 'RM-014', '0'),
('SHINV', 'RM-015', '0'),
('SHINV', 'RM-016', '0'),
('SHINV', 'RM-017', '0'),
('SHINV', 'RM-018', '0'),
('SHINV', 'RM-019', '0'),
('SHINV', 'RM-020', '0'),
('SHINV', 'RM-021', '0'),
('SHINV', 'RM-022', '0'),
('SHINV', 'RM-023', '0'),
('SHINV', 'RM-024', '0'),
('SHINV', 'RM-025', '0'),
('SHINV', 'RM-026', '0'),
('SHINV', 'RM-027', '0'),
('SHINV', 'RM-028', '0'),
('SHINV', 'RM-029', '0'),
('SHINV', 'RM-030', '0'),
('SHINV', 'RM-031', '0'),
('SHINV', 'RM-032', '0'),
('SHINV', 'RM-033', '0'),
('SHINV', 'RM-034', '0'),
('SHINV', 'RM-035', '0'),
('SHINV', 'RM-036', '0'),
('SHINV', 'RM-037', '0'),
('SHINV', 'RM-038', '0'),
('SHINV', 'RM-039', '0'),
('SHINV', 'RM-040', '0'),
('SHINV', 'RM-041', '0'),
('SHINV', 'RM-042', '0'),
('SHINV', 'RM-043', '0'),
('SHINV', 'RM-044', '0'),
('SHINV', 'RM-045', '0'),
('SHINV', 'RM-046', '0'),
('SHINV', 'RM-047', '0'),
('SHINV', 'RM-048', '0'),
('SHINV', 'RM-049', '0'),
('SHINV', 'RM-050', '0'),
('SHINV', 'RM-051', '0'),
('SHINV', 'RM-052', '0'),
('SHINV', 'RM-053', '0'),
('SHINV', 'RM-054', '0'),
('SHINV', 'RM-055', '0'),
('SHINV', 'RM-056', '0'),
('SHINV', 'RM-057', '0'),
('SHINV', 'RM-058', '0'),
('SHINV', 'RM-059', '0'),
('SHINV', 'RM-060', '0'),
('SHINV', 'RM-061', '0'),
('SHINV', 'RM-062', '0'),
('SHINV', 'RM-063', '0'),
('SHINV', 'RM-064', '0'),
('SHINV', 'RM-065', '0'),
('SHINV', 'RM-066', '0'),
('SHINV', 'RM-067', '0'),
('SHINV', 'RM-068', '0'),
('SHINV', 'RM-069', '0'),
('SHINV', 'RM-070', '0'),
('SHINV', 'RM-071', '0'),
('SHINV', 'RM-072', '0'),
('SHINV', 'RM-073', '0'),
('SHINV', 'RM-074', '0'),
('SHINV', 'RM-075', '0'),
('SHINV', 'RM-076', '0'),
('SHINV', 'RM-077', '0'),
('SHINV', 'RM-078', '0'),
('SHINV', 'RM-079', '0'),
('SHINV', 'RM-080', '0'),
('SHINV', 'RM-081', '0'),
('SHINV', 'RM-082', '0'),
('SHINV', 'RM-083', '0'),
('SHINV', 'RM-084', '0'),
('SHINV', 'RM-085', '0'),
('SHINV', 'RM-086', '0'),
('SHINV', 'RM-087', '0'),
('SHINV', 'RM-088', '0'),
('SHINV', 'RM-089', '0'),
('SHINV', 'RM-090', '0'),
('SHINV', 'RM-091', '0'),
('SHINV', 'RM-092', '0'),
('SHINV', 'RM-093', '0'),
('SHINV', 'RM-094', '0'),
('SHINV', 'RM-095', '0'),
('SHINV', 'RM-096', '0'),
('SHINV', 'RM-097', '0'),
('SHINV', 'RM-098', '0'),
('SHINV', 'RM-099', '0'),
('SHINV', 'RM-100', '0'),
('SHINV', 'RM-101', '0'),
('SHINV', 'RM-102', '0'),
('SHINV', 'RM-103', '0'),
('SHINV', 'RM-104', '0'),
('SHINV', 'RM-105', '0'),
('SHINV', 'RM-106', '0'),
('SHINV', 'RM-107', '0'),
('SHINV', 'RM-108', '0'),
('SHINV', 'RM-109', '0'),
('SHINV', 'RM-110', '0'),
('SHINV', 'RM-111', '0'),
('SHINV', 'RM-112', '0'),
('SHINV', 'RM-113', '0'),
('SHINV', 'RM-114', '0'),
('SHINV', 'RM-115', '0'),
('SHINV', 'RM-116', '0'),
('SHINV', 'RM-117', '0'),
('SHINV', 'RM-118', '0'),
('SHINV', 'RM-119', '0'),
('SHINV', 'RM-120', '0'),
('SHINV', 'RM-121', '0'),
('SHINV', 'RM-122', '0'),
('SHINV', 'RM-123', '0'),
('SHINV', 'RM-124', '0'),
('SHINV', 'RM-125', '0'),
('SHINV', 'RM-126', '0'),
('SHINV', 'RM-127', '0'),
('SHINV', 'RM-128', '0'),
('SHINV', 'RM-129', '0'),
('SHINV', 'RM-130', '0'),
('SHINV', 'RM-131', '0'),
('SHINV', 'RM-132', '0'),
('SHINV', 'RM-133', '0'),
('SHINV', 'RM-134', '0'),
('SHINV', 'RM-135', '0'),
('SHINV', 'RM-136', '0'),
('SHINV', 'SFG-101', '0'),
('SHINV', 'SFG-102', '0'),
('SHINV', 'SFG-103', '0'),
('SHINV', 'SFG-104', '0'),
('SHINV', 'SFG-105', '0'),
('SHINV', 'SFG-106', '0'),
('SHINV', 'SFG-107', '0'),
('SHINV', 'SFG-108', '0'),
('SHINV', 'SFG-109', '0'),
('SHINV', 'SFG-110', '0'),
('SHINV', 'SFG-111', '0'),
('SHINV', 'SFG-112', '0'),
('SHINV', 'SFG-113', '0'),
('SHINV', 'SFG-114', '0'),
('SHINV', 'SFG-115', '0'),
('SHINV', 'SFG-116', '0'),
('SHINV', 'SFG-117', '0'),
('SHINV', 'SFG-118', '0'),
('SHINV', 'SFG-119', '0'),
('SHINV', 'SFG-120', '0'),
('SHINV', 'SFG-121', '0'),
('SHINV', 'SFG-122', '0'),
('SHINV', 'SFG-123', '0'),
('SHINV', 'SFG-124', '0'),
('SHINV', 'SFG-125', '0'),
('SHINV', 'SFG-126', '0'),
('SHINV', 'SFG-127', '0'),
('SHINV', 'SFG-128', '0'),
('SHINV', 'ST-0001', '0'),
('STADM', 'CM-001', '0'),
('STADM', 'CM-002', '0'),
('STADM', 'CM-003', '0'),
('STADM', 'CM-004', '0'),
('STADM', 'CM-005', '0'),
('STADM', 'CM-006', '0'),
('STADM', 'CM-007', '0'),
('STADM', 'CM-008', '0'),
('STADM', 'CM-009', '0'),
('STADM', 'CM-010', '0'),
('STADM', 'CM-011', '0'),
('STADM', 'CM-012', '0'),
('STADM', 'CM-013', '0'),
('STADM', 'CM-014', '0'),
('STADM', 'CM-015', '0'),
('STADM', 'CM-016', '0'),
('STADM', 'CM-017', '0'),
('STADM', 'CM-018', '0'),
('STADM', 'CM-019', '0'),
('STADM', 'CM-020', '0'),
('STADM', 'CM-021', '0'),
('STADM', 'CM-022', '0'),
('STADM', 'CM-023', '0'),
('STADM', 'CM-024', '0'),
('STADM', 'CM-025', '0'),
('STADM', 'CM-026', '0'),
('STADM', 'CM-027', '0'),
('STADM', 'CM-028', '0'),
('STADM', 'CM-029', '0'),
('STADM', 'CM-030', '0'),
('STADM', 'CM-031', '0'),
('STADM', 'CM-032', '0'),
('STADM', 'CM-033', '0'),
('STADM', 'CM-034', '0'),
('STADM', 'CM-035', '0'),
('STADM', 'CM-036', '0'),
('STADM', 'CM-037', '0'),
('STADM', 'CM-038', '0'),
('STADM', 'CM-039', '0'),
('STADM', 'CM-040', '0'),
('STADM', 'CM-041', '0'),
('STADM', 'CM-042', '0'),
('STADM', 'CM-043', '0'),
('STADM', 'CM-044', '0'),
('STADM', 'CM-045', '0'),
('STADM', 'CM-046', '0'),
('STADM', 'CM-047', '0'),
('STADM', 'CM-048', '0'),
('STADM', 'CM-049', '0'),
('STADM', 'CM-050', '0'),
('STADM', 'CM-051', '0'),
('STADM', 'CM-052', '0'),
('STADM', 'CM-053', '0'),
('STADM', 'CM-054', '0'),
('STADM', 'CM-055', '0'),
('STADM', 'CM-056', '0'),
('STADM', 'CM-057', '0'),
('STADM', 'CM-058', '0'),
('STADM', 'CM-059', '0'),
('STADM', 'CM-060', '0'),
('STADM', 'CM-061', '0'),
('STADM', 'CM-062', '0'),
('STADM', 'CM-063', '0'),
('STADM', 'CM-064', '0'),
('STADM', 'CM-065', '0'),
('STADM', 'CM-066', '0'),
('STADM', 'CM-067', '0'),
('STADM', 'CM-069', '0'),
('STADM', 'CM-070', '0'),
('STADM', 'CM-071', '0'),
('STADM', 'FA-01', '0'),
('STADM', 'FG-001', '0'),
('STADM', 'FG-002', '0'),
('STADM', 'FG-003', '0'),
('STADM', 'FG-004', '0'),
('STADM', 'FG-005', '0'),
('STADM', 'FG-006', '0'),
('STADM', 'FG-007', '0'),
('STADM', 'FG-008', '0'),
('STADM', 'FG-009', '0'),
('STADM', 'FG-010', '0'),
('STADM', 'FG-011', '0'),
('STADM', 'FG-012', '0'),
('STADM', 'FG-013', '0'),
('STADM', 'FG-014', '0'),
('STADM', 'FG-015', '0'),
('STADM', 'FG-016', '0'),
('STADM', 'FG-017', '0'),
('STADM', 'FG-018', '0'),
('STADM', 'FG-019', '0'),
('STADM', 'FG-020', '0'),
('STADM', 'FG-021', '0'),
('STADM', 'FG-022', '0'),
('STADM', 'FG-023', '0'),
('STADM', 'FG-024', '0'),
('STADM', 'FG-025', '0'),
('STADM', 'FG-026', '0'),
('STADM', 'FG-027', '0'),
('STADM', 'FG-028', '0'),
('STADM', 'FG-029', '0'),
('STADM', 'FG-030', '0'),
('STADM', 'FG-031', '0'),
('STADM', 'FG-032', '0'),
('STADM', 'FG-033', '0'),
('STADM', 'FG-034', '0'),
('STADM', 'FG-035', '0'),
('STADM', 'FG-036', '0'),
('STADM', 'FG-037', '0'),
('STADM', 'FG-038', '0'),
('STADM', 'FG-039', '0'),
('STADM', 'FG-040', '0'),
('STADM', 'FG-041', '0'),
('STADM', 'FG-042', '0'),
('STADM', 'FG-043', '0'),
('STADM', 'FG-044', '0'),
('STADM', 'FG-045', '0'),
('STADM', 'FG-046', '0'),
('STADM', 'FG-047', '0'),
('STADM', 'FG-048', '0'),
('STADM', 'FG-049', '0'),
('STADM', 'FG-050', '0'),
('STADM', 'FG-051', '0'),
('STADM', 'FG-052', '0'),
('STADM', 'FG-053', '0'),
('STADM', 'FG-054', '0'),
('STADM', 'FG-055', '0'),
('STADM', 'FG-056', '0'),
('STADM', 'FG-057', '0'),
('STADM', 'FG-058', '0'),
('STADM', 'FG-059', '0'),
('STADM', 'FG-060', '0'),
('STADM', 'FG-061', '0'),
('STADM', 'FG-062', '0'),
('STADM', 'FG-063', '0'),
('STADM', 'FG-064', '0'),
('STADM', 'FG-065', '0'),
('STADM', 'FG-066', '0'),
('STADM', 'FG-067', '0'),
('STADM', 'FG-068', '0'),
('STADM', 'FG-069', '0'),
('STADM', 'FG-070', '0'),
('STADM', 'RM-001', '0'),
('STADM', 'RM-002', '0'),
('STADM', 'RM-003', '0'),
('STADM', 'RM-004', '0'),
('STADM', 'RM-005', '0'),
('STADM', 'RM-006', '0'),
('STADM', 'RM-007', '0'),
('STADM', 'RM-008', '0'),
('STADM', 'RM-009', '0'),
('STADM', 'RM-010', '0'),
('STADM', 'RM-011', '0'),
('STADM', 'RM-012', '0'),
('STADM', 'RM-013', '0'),
('STADM', 'RM-014', '0'),
('STADM', 'RM-015', '0'),
('STADM', 'RM-016', '0'),
('STADM', 'RM-017', '0'),
('STADM', 'RM-018', '0'),
('STADM', 'RM-019', '0'),
('STADM', 'RM-020', '0'),
('STADM', 'RM-021', '0'),
('STADM', 'RM-022', '0'),
('STADM', 'RM-023', '0'),
('STADM', 'RM-024', '0'),
('STADM', 'RM-025', '0'),
('STADM', 'RM-026', '0'),
('STADM', 'RM-027', '0'),
('STADM', 'RM-028', '0'),
('STADM', 'RM-029', '0'),
('STADM', 'RM-030', '0'),
('STADM', 'RM-031', '0'),
('STADM', 'RM-032', '0'),
('STADM', 'RM-033', '0'),
('STADM', 'RM-034', '0'),
('STADM', 'RM-035', '0'),
('STADM', 'RM-036', '0'),
('STADM', 'RM-037', '0'),
('STADM', 'RM-038', '0'),
('STADM', 'RM-039', '0'),
('STADM', 'RM-040', '0'),
('STADM', 'RM-041', '0'),
('STADM', 'RM-042', '0'),
('STADM', 'RM-043', '0'),
('STADM', 'RM-044', '0'),
('STADM', 'RM-045', '0'),
('STADM', 'RM-046', '0'),
('STADM', 'RM-047', '0'),
('STADM', 'RM-048', '0'),
('STADM', 'RM-049', '0'),
('STADM', 'RM-050', '0'),
('STADM', 'RM-051', '0'),
('STADM', 'RM-052', '0'),
('STADM', 'RM-053', '0'),
('STADM', 'RM-054', '0'),
('STADM', 'RM-055', '0'),
('STADM', 'RM-056', '0'),
('STADM', 'RM-057', '0'),
('STADM', 'RM-058', '0'),
('STADM', 'RM-059', '0'),
('STADM', 'RM-060', '0'),
('STADM', 'RM-061', '0'),
('STADM', 'RM-062', '0'),
('STADM', 'RM-063', '0'),
('STADM', 'RM-064', '0'),
('STADM', 'RM-065', '0'),
('STADM', 'RM-066', '0'),
('STADM', 'RM-067', '0'),
('STADM', 'RM-068', '0'),
('STADM', 'RM-069', '0'),
('STADM', 'RM-070', '0'),
('STADM', 'RM-071', '0'),
('STADM', 'RM-072', '0'),
('STADM', 'RM-073', '0'),
('STADM', 'RM-074', '0'),
('STADM', 'RM-075', '0'),
('STADM', 'RM-076', '0'),
('STADM', 'RM-077', '0'),
('STADM', 'RM-078', '0'),
('STADM', 'RM-079', '0'),
('STADM', 'RM-080', '0'),
('STADM', 'RM-081', '0'),
('STADM', 'RM-082', '0'),
('STADM', 'RM-083', '0'),
('STADM', 'RM-084', '0'),
('STADM', 'RM-085', '0'),
('STADM', 'RM-086', '0'),
('STADM', 'RM-087', '0'),
('STADM', 'RM-088', '0'),
('STADM', 'RM-089', '0'),
('STADM', 'RM-090', '0'),
('STADM', 'RM-091', '0'),
('STADM', 'RM-092', '0'),
('STADM', 'RM-093', '0'),
('STADM', 'RM-094', '0'),
('STADM', 'RM-095', '0'),
('STADM', 'RM-096', '0'),
('STADM', 'RM-097', '0'),
('STADM', 'RM-098', '0'),
('STADM', 'RM-099', '0'),
('STADM', 'RM-100', '0'),
('STADM', 'RM-101', '0'),
('STADM', 'RM-102', '0'),
('STADM', 'RM-103', '0'),
('STADM', 'RM-104', '0'),
('STADM', 'RM-105', '0'),
('STADM', 'RM-106', '0'),
('STADM', 'RM-107', '0'),
('STADM', 'RM-108', '0'),
('STADM', 'RM-109', '0'),
('STADM', 'RM-110', '0'),
('STADM', 'RM-111', '0'),
('STADM', 'RM-112', '0'),
('STADM', 'RM-113', '0'),
('STADM', 'RM-114', '0'),
('STADM', 'RM-115', '0'),
('STADM', 'RM-116', '0'),
('STADM', 'RM-117', '0'),
('STADM', 'RM-118', '0'),
('STADM', 'RM-119', '0'),
('STADM', 'RM-120', '0'),
('STADM', 'RM-121', '0'),
('STADM', 'RM-122', '0'),
('STADM', 'RM-123', '0'),
('STADM', 'RM-124', '0'),
('STADM', 'RM-125', '0'),
('STADM', 'RM-126', '0'),
('STADM', 'RM-127', '0'),
('STADM', 'RM-128', '0'),
('STADM', 'RM-129', '0'),
('STADM', 'RM-130', '0'),
('STADM', 'RM-131', '0'),
('STADM', 'RM-132', '0'),
('STADM', 'RM-133', '0'),
('STADM', 'RM-134', '0'),
('STADM', 'RM-135', '0'),
('STADM', 'RM-136', '0'),
('STADM', 'SFG-101', '0'),
('STADM', 'SFG-102', '0'),
('STADM', 'SFG-103', '0'),
('STADM', 'SFG-104', '0'),
('STADM', 'SFG-105', '0'),
('STADM', 'SFG-106', '0'),
('STADM', 'SFG-107', '0'),
('STADM', 'SFG-108', '0'),
('STADM', 'SFG-109', '0'),
('STADM', 'SFG-110', '0'),
('STADM', 'SFG-111', '0'),
('STADM', 'SFG-112', '0'),
('STADM', 'SFG-113', '0'),
('STADM', 'SFG-114', '0'),
('STADM', 'SFG-115', '0'),
('STADM', 'SFG-116', '0'),
('STADM', 'SFG-117', '0'),
('STADM', 'SFG-118', '0'),
('STADM', 'SFG-119', '0'),
('STADM', 'SFG-120', '0'),
('STADM', 'SFG-121', '0'),
('STADM', 'SFG-122', '0'),
('STADM', 'SFG-123', '0'),
('STADM', 'SFG-124', '0'),
('STADM', 'SFG-125', '0'),
('STADM', 'SFG-126', '0'),
('STADM', 'SFG-127', '0'),
('STADM', 'SFG-128', '0'),
('STADM', 'ST-0001', '0'),
('STMNT', 'CM-001', '0'),
('STMNT', 'CM-002', '0'),
('STMNT', 'CM-003', '0'),
('STMNT', 'CM-004', '0'),
('STMNT', 'CM-005', '0'),
('STMNT', 'CM-006', '0'),
('STMNT', 'CM-007', '0'),
('STMNT', 'CM-008', '0'),
('STMNT', 'CM-009', '0'),
('STMNT', 'CM-010', '0'),
('STMNT', 'CM-011', '0'),
('STMNT', 'CM-012', '0'),
('STMNT', 'CM-013', '0'),
('STMNT', 'CM-014', '0'),
('STMNT', 'CM-015', '0'),
('STMNT', 'CM-016', '0'),
('STMNT', 'CM-017', '0'),
('STMNT', 'CM-018', '0'),
('STMNT', 'CM-019', '0'),
('STMNT', 'CM-020', '0'),
('STMNT', 'CM-021', '0'),
('STMNT', 'CM-022', '0'),
('STMNT', 'CM-023', '0'),
('STMNT', 'CM-024', '0'),
('STMNT', 'CM-025', '0'),
('STMNT', 'CM-026', '0'),
('STMNT', 'CM-027', '0'),
('STMNT', 'CM-028', '0'),
('STMNT', 'CM-029', '0'),
('STMNT', 'CM-030', '0'),
('STMNT', 'CM-031', '0'),
('STMNT', 'CM-032', '0'),
('STMNT', 'CM-033', '0'),
('STMNT', 'CM-034', '0'),
('STMNT', 'CM-035', '0'),
('STMNT', 'CM-036', '0'),
('STMNT', 'CM-037', '0'),
('STMNT', 'CM-038', '0'),
('STMNT', 'CM-039', '0'),
('STMNT', 'CM-040', '0'),
('STMNT', 'CM-041', '0'),
('STMNT', 'CM-042', '0'),
('STMNT', 'CM-043', '0'),
('STMNT', 'CM-044', '0'),
('STMNT', 'CM-045', '0'),
('STMNT', 'CM-046', '0'),
('STMNT', 'CM-047', '0'),
('STMNT', 'CM-048', '0'),
('STMNT', 'CM-049', '0'),
('STMNT', 'CM-050', '0'),
('STMNT', 'CM-051', '0'),
('STMNT', 'CM-052', '0'),
('STMNT', 'CM-053', '0'),
('STMNT', 'CM-054', '0'),
('STMNT', 'CM-055', '0'),
('STMNT', 'CM-056', '0'),
('STMNT', 'CM-057', '0'),
('STMNT', 'CM-058', '0'),
('STMNT', 'CM-059', '0'),
('STMNT', 'CM-060', '0'),
('STMNT', 'CM-061', '0'),
('STMNT', 'CM-062', '0'),
('STMNT', 'CM-063', '0'),
('STMNT', 'CM-064', '0'),
('STMNT', 'CM-065', '0'),
('STMNT', 'CM-066', '0'),
('STMNT', 'CM-067', '0'),
('STMNT', 'CM-069', '0'),
('STMNT', 'CM-070', '0'),
('STMNT', 'CM-071', '0'),
('STMNT', 'FA-01', '0'),
('STMNT', 'FG-001', '0'),
('STMNT', 'FG-002', '0'),
('STMNT', 'FG-003', '0'),
('STMNT', 'FG-004', '0'),
('STMNT', 'FG-005', '0'),
('STMNT', 'FG-006', '0'),
('STMNT', 'FG-007', '0'),
('STMNT', 'FG-008', '0'),
('STMNT', 'FG-009', '0'),
('STMNT', 'FG-010', '0'),
('STMNT', 'FG-011', '0'),
('STMNT', 'FG-012', '0'),
('STMNT', 'FG-013', '0'),
('STMNT', 'FG-014', '0'),
('STMNT', 'FG-015', '0'),
('STMNT', 'FG-016', '0'),
('STMNT', 'FG-017', '0'),
('STMNT', 'FG-018', '0'),
('STMNT', 'FG-019', '0'),
('STMNT', 'FG-020', '0'),
('STMNT', 'FG-021', '0'),
('STMNT', 'FG-022', '0'),
('STMNT', 'FG-023', '0'),
('STMNT', 'FG-024', '0'),
('STMNT', 'FG-025', '0'),
('STMNT', 'FG-026', '0'),
('STMNT', 'FG-027', '0'),
('STMNT', 'FG-028', '0'),
('STMNT', 'FG-029', '0'),
('STMNT', 'FG-030', '0'),
('STMNT', 'FG-031', '0'),
('STMNT', 'FG-032', '0'),
('STMNT', 'FG-033', '0'),
('STMNT', 'FG-034', '0'),
('STMNT', 'FG-035', '0'),
('STMNT', 'FG-036', '0'),
('STMNT', 'FG-037', '0'),
('STMNT', 'FG-038', '0'),
('STMNT', 'FG-039', '0'),
('STMNT', 'FG-040', '0'),
('STMNT', 'FG-041', '0'),
('STMNT', 'FG-042', '0'),
('STMNT', 'FG-043', '0'),
('STMNT', 'FG-044', '0'),
('STMNT', 'FG-045', '0'),
('STMNT', 'FG-046', '0'),
('STMNT', 'FG-047', '0'),
('STMNT', 'FG-048', '0'),
('STMNT', 'FG-049', '0'),
('STMNT', 'FG-050', '0'),
('STMNT', 'FG-051', '0'),
('STMNT', 'FG-052', '0'),
('STMNT', 'FG-053', '0'),
('STMNT', 'FG-054', '0'),
('STMNT', 'FG-055', '0'),
('STMNT', 'FG-056', '0'),
('STMNT', 'FG-057', '0'),
('STMNT', 'FG-058', '0'),
('STMNT', 'FG-059', '0'),
('STMNT', 'FG-060', '0'),
('STMNT', 'FG-061', '0'),
('STMNT', 'FG-062', '0'),
('STMNT', 'FG-063', '0'),
('STMNT', 'FG-064', '0'),
('STMNT', 'FG-065', '0'),
('STMNT', 'FG-066', '0'),
('STMNT', 'FG-067', '0'),
('STMNT', 'FG-068', '0'),
('STMNT', 'FG-069', '0'),
('STMNT', 'FG-070', '0'),
('STMNT', 'RM-001', '0'),
('STMNT', 'RM-002', '0'),
('STMNT', 'RM-003', '0'),
('STMNT', 'RM-004', '0'),
('STMNT', 'RM-005', '0'),
('STMNT', 'RM-006', '0'),
('STMNT', 'RM-007', '0'),
('STMNT', 'RM-008', '0'),
('STMNT', 'RM-009', '0'),
('STMNT', 'RM-010', '0'),
('STMNT', 'RM-011', '0'),
('STMNT', 'RM-012', '0'),
('STMNT', 'RM-013', '0'),
('STMNT', 'RM-014', '0'),
('STMNT', 'RM-015', '0'),
('STMNT', 'RM-016', '0'),
('STMNT', 'RM-017', '0'),
('STMNT', 'RM-018', '0'),
('STMNT', 'RM-019', '0'),
('STMNT', 'RM-020', '0'),
('STMNT', 'RM-021', '0'),
('STMNT', 'RM-022', '0'),
('STMNT', 'RM-023', '0'),
('STMNT', 'RM-024', '0'),
('STMNT', 'RM-025', '0'),
('STMNT', 'RM-026', '0'),
('STMNT', 'RM-027', '0'),
('STMNT', 'RM-028', '0'),
('STMNT', 'RM-029', '0'),
('STMNT', 'RM-030', '0'),
('STMNT', 'RM-031', '0'),
('STMNT', 'RM-032', '0'),
('STMNT', 'RM-033', '0'),
('STMNT', 'RM-034', '0'),
('STMNT', 'RM-035', '0'),
('STMNT', 'RM-036', '0'),
('STMNT', 'RM-037', '0'),
('STMNT', 'RM-038', '0'),
('STMNT', 'RM-039', '0'),
('STMNT', 'RM-040', '0'),
('STMNT', 'RM-041', '0'),
('STMNT', 'RM-042', '0'),
('STMNT', 'RM-043', '0'),
('STMNT', 'RM-044', '0'),
('STMNT', 'RM-045', '0'),
('STMNT', 'RM-046', '0'),
('STMNT', 'RM-047', '0'),
('STMNT', 'RM-048', '0'),
('STMNT', 'RM-049', '0'),
('STMNT', 'RM-050', '0'),
('STMNT', 'RM-051', '0'),
('STMNT', 'RM-052', '0'),
('STMNT', 'RM-053', '0'),
('STMNT', 'RM-054', '0'),
('STMNT', 'RM-055', '0'),
('STMNT', 'RM-056', '0'),
('STMNT', 'RM-057', '0'),
('STMNT', 'RM-058', '0'),
('STMNT', 'RM-059', '0'),
('STMNT', 'RM-060', '0'),
('STMNT', 'RM-061', '0'),
('STMNT', 'RM-062', '0'),
('STMNT', 'RM-063', '0'),
('STMNT', 'RM-064', '0'),
('STMNT', 'RM-065', '0'),
('STMNT', 'RM-066', '0'),
('STMNT', 'RM-067', '0'),
('STMNT', 'RM-068', '0'),
('STMNT', 'RM-069', '0'),
('STMNT', 'RM-070', '0'),
('STMNT', 'RM-071', '0'),
('STMNT', 'RM-072', '0'),
('STMNT', 'RM-073', '0'),
('STMNT', 'RM-074', '0'),
('STMNT', 'RM-075', '0'),
('STMNT', 'RM-076', '0'),
('STMNT', 'RM-077', '0'),
('STMNT', 'RM-078', '0'),
('STMNT', 'RM-079', '0'),
('STMNT', 'RM-080', '0'),
('STMNT', 'RM-081', '0'),
('STMNT', 'RM-082', '0'),
('STMNT', 'RM-083', '0'),
('STMNT', 'RM-084', '0'),
('STMNT', 'RM-085', '0'),
('STMNT', 'RM-086', '0'),
('STMNT', 'RM-087', '0'),
('STMNT', 'RM-088', '0'),
('STMNT', 'RM-089', '0'),
('STMNT', 'RM-090', '0'),
('STMNT', 'RM-091', '0'),
('STMNT', 'RM-092', '0'),
('STMNT', 'RM-093', '0'),
('STMNT', 'RM-094', '0'),
('STMNT', 'RM-095', '0'),
('STMNT', 'RM-096', '0'),
('STMNT', 'RM-097', '0'),
('STMNT', 'RM-098', '0'),
('STMNT', 'RM-099', '0'),
('STMNT', 'RM-100', '0'),
('STMNT', 'RM-101', '0'),
('STMNT', 'RM-102', '0'),
('STMNT', 'RM-103', '0'),
('STMNT', 'RM-104', '0'),
('STMNT', 'RM-105', '0'),
('STMNT', 'RM-106', '0'),
('STMNT', 'RM-107', '0'),
('STMNT', 'RM-108', '0'),
('STMNT', 'RM-109', '0'),
('STMNT', 'RM-110', '0'),
('STMNT', 'RM-111', '0'),
('STMNT', 'RM-112', '0'),
('STMNT', 'RM-113', '0'),
('STMNT', 'RM-114', '0'),
('STMNT', 'RM-115', '0'),
('STMNT', 'RM-116', '0'),
('STMNT', 'RM-117', '0'),
('STMNT', 'RM-118', '0'),
('STMNT', 'RM-119', '0'),
('STMNT', 'RM-120', '0'),
('STMNT', 'RM-121', '0'),
('STMNT', 'RM-122', '0'),
('STMNT', 'RM-123', '0'),
('STMNT', 'RM-124', '0'),
('STMNT', 'RM-125', '0'),
('STMNT', 'RM-126', '0'),
('STMNT', 'RM-127', '0'),
('STMNT', 'RM-128', '0'),
('STMNT', 'RM-129', '0'),
('STMNT', 'RM-130', '0'),
('STMNT', 'RM-131', '0'),
('STMNT', 'RM-132', '0'),
('STMNT', 'RM-133', '0'),
('STMNT', 'RM-134', '0'),
('STMNT', 'RM-135', '0'),
('STMNT', 'RM-136', '0'),
('STMNT', 'SFG-101', '0'),
('STMNT', 'SFG-102', '0'),
('STMNT', 'SFG-103', '0'),
('STMNT', 'SFG-104', '0'),
('STMNT', 'SFG-105', '0'),
('STMNT', 'SFG-106', '0'),
('STMNT', 'SFG-107', '0'),
('STMNT', 'SFG-108', '0'),
('STMNT', 'SFG-109', '0'),
('STMNT', 'SFG-110', '0'),
('STMNT', 'SFG-111', '0'),
('STMNT', 'SFG-112', '0'),
('STMNT', 'SFG-113', '0'),
('STMNT', 'SFG-114', '0'),
('STMNT', 'SFG-115', '0'),
('STMNT', 'SFG-116', '0'),
('STMNT', 'SFG-117', '0'),
('STMNT', 'SFG-118', '0'),
('STMNT', 'SFG-119', '0'),
('STMNT', 'SFG-120', '0'),
('STMNT', 'SFG-121', '0'),
('STMNT', 'SFG-122', '0'),
('STMNT', 'SFG-123', '0'),
('STMNT', 'SFG-124', '0'),
('STMNT', 'SFG-125', '0'),
('STMNT', 'SFG-126', '0'),
('STMNT', 'SFG-127', '0'),
('STMNT', 'SFG-128', '0'),
('STMNT', 'ST-0001', '0');

### Structure of table `0_locations` ###

DROP TABLE IF EXISTS `0_locations`;

CREATE TABLE `0_locations` (
  `loc_code` varchar(5) NOT NULL DEFAULT '',
  `location_name` varchar(60) NOT NULL DEFAULT '',
  `delivery_address` tinytext NOT NULL,
  `phone` varchar(30) NOT NULL DEFAULT '',
  `phone2` varchar(30) NOT NULL DEFAULT '',
  `fax` varchar(30) NOT NULL DEFAULT '',
  `email` varchar(100) NOT NULL DEFAULT '',
  `contact` varchar(30) NOT NULL DEFAULT '',
  `fixed_asset` tinyint(1) NOT NULL DEFAULT 0,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`loc_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_locations` ###

INSERT INTO `0_locations` VALUES
('001', 'Fixed assets Loc', 'Fixed assets Loc', '', '', '', '', '', '1', '0'),
('CHMST', 'RMC-Chemicals', 'Hub Factory', '', '', '', '', 'Tanveer', '0', '0'),
('DEF', 'Store - Admin Head Office', 'Head Office Karachi', '', '', '', '', 'Mughees', '0', '0'),
('DMGST', 'Store - Damage Stock (Hub)', 'Factory - Hub', '', '', '', '', 'Arif', '0', '0'),
('FGHOF', 'FGS - Head Office', 'Head Office Karachi', '', '', '', '', 'Ammar', '0', '0'),
('FGHUB', 'FGS - Factory', 'Factory - Hub', '', '', '', '', 'Arif', '0', '0'),
('FGHYD', 'FGS - Hyderabad', 'Hyderabad', '', '', '', '', 'Shahid', '0', '0'),
('FGKAR', 'FGS - Karachi', 'Korangi - Karachi', '', '', '', '', 'Qaiser', '0', '0'),
('FGLHR', 'FGS - Lahore', 'Lahore', '', '', '', '', 'Ammar', '0', '0'),
('PFLOR', 'Blending Floor', 'Hub Factory', '', '', '', '', 'Habib', '0', '0'),
('PFLR2', 'Packaging Floor', 'Factory Hub', '', '', '', '', 'Habib', '0', '0'),
('PKGST', 'RMC-Packaging', 'Factory - Hub', '', '', '', '', 'Packing Station', '0', '0'),
('SHINV', 'RMC-Short Inventory', 'Hub Factory', '', '', '', '', 'Arif', '0', '0'),
('STADM', 'Store - Admin HUB', 'Hub Factory', '', '', '', '', 'Raja Ghazanfar', '0', '0'),
('STMNT', 'Store - Maintenance', 'Hub Factory', '', '', '', '', 'Muhammad Haris', '0', '0');

### Structure of table `0_master_login` ###

DROP TABLE IF EXISTS `0_master_login`;

CREATE TABLE `0_master_login` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(60) NOT NULL,
  `role` int(11) NOT NULL,
  `companies` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_master_login` ###

INSERT INTO `0_master_login` VALUES
('1', 'admin', '2', 'YToxOntpOjA7aTowO30=');

### Structure of table `0_payment_terms` ###

DROP TABLE IF EXISTS `0_payment_terms`;

CREATE TABLE `0_payment_terms` (
  `terms_indicator` int(11) NOT NULL AUTO_INCREMENT,
  `terms` char(80) NOT NULL DEFAULT '',
  `days_before_due` smallint(6) NOT NULL DEFAULT 0,
  `day_in_following_month` smallint(6) NOT NULL DEFAULT 0,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`terms_indicator`),
  UNIQUE KEY `terms` (`terms`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_payment_terms` ###

INSERT INTO `0_payment_terms` VALUES
('1', 'Due 15th Of the Following Month', '0', '17', '0'),
('2', 'Due By End Of The Following Month', '0', '30', '0'),
('3', 'Payment due within 10 days', '10', '0', '0'),
('4', 'Cash Only', '1', '0', '0'),
('5', 'Prepaid', '-1', '0', '0');

### Structure of table `0_prices` ###

DROP TABLE IF EXISTS `0_prices`;

CREATE TABLE `0_prices` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `stock_id` varchar(20) NOT NULL DEFAULT '',
  `sales_type_id` int(11) NOT NULL DEFAULT 0,
  `curr_abrev` char(3) NOT NULL DEFAULT '',
  `price` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `price` (`stock_id`,`sales_type_id`,`curr_abrev`)
) ENGINE=InnoDB AUTO_INCREMENT=207 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_prices` ###

INSERT INTO `0_prices` VALUES
('1', 'FG-001', '3', 'PKR', '540'),
('2', 'FG-001', '1', 'PKR', '500'),
('3', 'FG-001', '4', 'PKR', '560'),
('4', 'FG-001', '5', 'PKR', '560'),
('5', 'FG-001', '2', 'PKR', '520'),
('6', 'FG-021', '3', 'PKR', '150'),
('7', 'FG-021', '1', 'PKR', '140'),
('8', 'FG-021', '4', 'PKR', '155'),
('9', 'FG-021', '5', 'PKR', '155'),
('10', 'FG-021', '2', 'PKR', '145'),
('11', 'FG-029', '3', 'PKR', '300'),
('12', 'FG-029', '1', 'PKR', '280'),
('13', 'FG-029', '4', 'PKR', '310'),
('14', 'FG-029', '5', 'PKR', '310'),
('15', 'FG-029', '2', 'PKR', '290'),
('16', 'FG-003', '3', 'PKR', '56'),
('17', 'FG-003', '1', 'PKR', '53'),
('18', 'FG-003', '4', 'PKR', '57'),
('19', 'FG-003', '5', 'PKR', '57'),
('20', 'FG-003', '2', 'PKR', '55'),
('21', 'FG-006', '2', 'PKR', '41'),
('22', 'FG-006', '3', 'PKR', '42'),
('23', 'FG-006', '1', 'PKR', '39'),
('24', 'FG-006', '5', 'PKR', '44'),
('25', 'FG-006', '4', 'PKR', '44'),
('26', 'FG-013', '3', 'PKR', '215'),
('27', 'FG-013', '1', 'PKR', '205'),
('28', 'FG-013', '4', 'PKR', '220'),
('29', 'FG-013', '5', 'PKR', '220'),
('30', 'FG-013', '2', 'PKR', '210'),
('31', 'FG-014', '3', 'PKR', '260'),
('32', 'FG-014', '1', 'PKR', '245'),
('33', 'FG-014', '4', 'PKR', '265'),
('34', 'FG-014', '5', 'PKR', '270'),
('35', 'FG-014', '2', 'PKR', '250'),
('36', 'FG-008', '3', 'PKR', '465'),
('37', 'FG-008', '1', 'PKR', '450'),
('38', 'FG-008', '4', 'PKR', '470'),
('39', 'FG-008', '5', 'PKR', '470'),
('40', 'FG-008', '2', 'PKR', '455'),
('41', 'FG-009', '3', 'PKR', '185'),
('42', 'FG-009', '1', 'PKR', '175'),
('43', 'FG-009', '4', 'PKR', '190'),
('44', 'FG-009', '5', 'PKR', '190'),
('45', 'FG-009', '2', 'PKR', '180'),
('46', 'FG-018', '1', 'PKR', '280'),
('47', 'FG-018', '2', 'PKR', '290'),
('48', 'FG-018', '3', 'PKR', '300'),
('49', 'FG-018', '4', 'PKR', '310'),
('50', 'FG-018', '5', 'PKR', '310'),
('51', 'FG-024', '1', 'PKR', '280'),
('52', 'FG-024', '2', 'PKR', '290'),
('53', 'FG-024', '3', 'PKR', '300'),
('54', 'FG-024', '4', 'PKR', '310'),
('55', 'FG-024', '5', 'PKR', '310'),
('56', 'FG-030', '1', 'PKR', '750'),
('57', 'FG-030', '2', 'PKR', '770'),
('58', 'FG-030', '3', 'PKR', '800'),
('59', 'FG-030', '4', 'PKR', '820'),
('60', 'FG-030', '5', 'PKR', '820'),
('61', 'FG-025', '1', 'PKR', '2300'),
('62', 'FG-025', '2', 'PKR', '2400'),
('63', 'FG-025', '3', 'PKR', '2800'),
('64', 'FG-025', '4', 'PKR', '2900'),
('65', 'FG-025', '5', 'PKR', '2900'),
('66', 'FG-032', '1', 'PKR', '4000'),
('67', 'FG-032', '2', 'PKR', '4200'),
('68', 'FG-032', '3', 'PKR', '4600'),
('69', 'FG-032', '4', 'PKR', '4700'),
('70', 'FG-032', '5', 'PKR', '4700'),
('71', 'FG-017', '1', 'PKR', '140'),
('72', 'FG-017', '2', 'PKR', '145'),
('73', 'FG-017', '3', 'PKR', '150'),
('74', 'FG-017', '4', 'PKR', '155'),
('75', 'FG-017', '5', 'PKR', '155'),
('76', 'FG-028', '1', 'PKR', '140'),
('77', 'FG-028', '2', 'PKR', '145'),
('78', 'FG-028', '3', 'PKR', '150'),
('79', 'FG-028', '4', 'PKR', '155'),
('80', 'FG-028', '5', 'PKR', '155'),
('81', 'FG-022', '1', 'PKR', '340'),
('82', 'FG-022', '2', 'PKR', '350'),
('83', 'FG-022', '3', 'PKR', '370'),
('84', 'FG-022', '4', 'PKR', '380'),
('85', 'FG-022', '5', 'PKR', '380'),
('86', 'FG-038', '1', 'PKR', '1750'),
('87', 'FG-038', '2', 'PKR', '1770'),
('88', 'FG-038', '3', 'PKR', '1800'),
('89', 'FG-038', '4', 'PKR', '1830'),
('90', 'FG-038', '5', 'PKR', '1830'),
('91', 'FG-042', '1', 'PKR', '425'),
('92', 'FG-042', '2', 'PKR', '435'),
('93', 'FG-042', '3', 'PKR', '450'),
('94', 'FG-042', '4', 'PKR', '465'),
('95', 'FG-042', '5', 'PKR', '465'),
('96', 'FG-043', '1', 'PKR', '460'),
('97', 'FG-043', '2', 'PKR', '475'),
('98', 'FG-043', '3', 'PKR', '485'),
('99', 'FG-043', '4', 'PKR', '500'),
('100', 'FG-043', '5', 'PKR', '500'),
('101', 'FG-054', '1', 'PKR', '240'),
('102', 'FG-054', '2', 'PKR', '245'),
('103', 'FG-054', '3', 'PKR', '255'),
('104', 'FG-054', '4', 'PKR', '265'),
('105', 'FG-054', '5', 'PKR', '265'),
('106', 'FG-046', '1', 'PKR', '275'),
('107', 'FG-046', '2', 'PKR', '280'),
('108', 'FG-046', '3', 'PKR', '290'),
('109', 'FG-046', '4', 'PKR', '295'),
('110', 'FG-046', '5', 'PKR', '295'),
('111', 'FG-047', '1', 'PKR', '550'),
('112', 'FG-047', '2', 'PKR', '555'),
('113', 'FG-047', '3', 'PKR', '560'),
('114', 'FG-047', '4', 'PKR', '570'),
('115', 'FG-047', '5', 'PKR', '570'),
('116', 'FG-048', '1', 'PKR', '1500'),
('117', 'FG-048', '2', 'PKR', '1530'),
('118', 'FG-048', '3', 'PKR', '1560'),
('119', 'FG-048', '4', 'PKR', '1580'),
('120', 'FG-048', '5', 'PKR', '1580'),
('121', 'FG-049', '1', 'PKR', '2300'),
('122', 'FG-049', '2', 'PKR', '2350'),
('123', 'FG-049', '3', 'PKR', '2450'),
('124', 'FG-049', '4', 'PKR', '2550'),
('125', 'FG-049', '5', 'PKR', '2550'),
('126', 'FG-050', '1', 'PKR', '4300'),
('127', 'FG-050', '2', 'PKR', '4400'),
('128', 'FG-050', '3', 'PKR', '4500'),
('129', 'FG-050', '4', 'PKR', '4600'),
('130', 'FG-050', '5', 'PKR', '4600'),
('131', 'FG-007', '1', 'PKR', '335'),
('132', 'FG-007', '2', 'PKR', '345'),
('133', 'FG-007', '3', 'PKR', '360'),
('134', 'FG-007', '4', 'PKR', '370'),
('135', 'FG-007', '5', 'PKR', '370'),
('136', 'FG-016', '1', 'PKR', '160'),
('137', 'FG-016', '2', 'PKR', '165'),
('138', 'FG-016', '3', 'PKR', '170'),
('139', 'FG-016', '4', 'PKR', '175'),
('140', 'FG-016', '5', 'PKR', '175'),
('142', 'FG-015', '1', 'PKR', '300'),
('143', 'FG-015', '2', 'PKR', '305'),
('144', 'FG-015', '3', 'PKR', '315'),
('145', 'FG-015', '4', 'PKR', '320'),
('146', 'FG-015', '5', 'PKR', '320'),
('147', 'FG-039', '1', 'PKR', '230'),
('148', 'FG-039', '2', 'PKR', '235'),
('149', 'FG-039', '3', 'PKR', '240'),
('150', 'FG-039', '4', 'PKR', '245'),
('151', 'FG-039', '5', 'PKR', '245'),
('152', 'FG-040', '1', 'PKR', '230'),
('153', 'FG-040', '2', 'PKR', '235'),
('154', 'FG-040', '3', 'PKR', '240'),
('155', 'FG-040', '4', 'PKR', '245'),
('156', 'FG-040', '5', 'PKR', '245'),
('157', 'FG-041', '1', 'PKR', '230'),
('158', 'FG-041', '2', 'PKR', '235'),
('159', 'FG-041', '3', 'PKR', '240'),
('160', 'FG-041', '4', 'PKR', '245'),
('161', 'FG-041', '5', 'PKR', '245'),
('162', 'FG-053', '1', 'PKR', '215'),
('163', 'FG-053', '2', 'PKR', '220'),
('164', 'FG-053', '3', 'PKR', '225'),
('165', 'FG-053', '4', 'PKR', '230'),
('166', 'FG-053', '5', 'PKR', '230'),
('167', 'FG-056', '1', 'PKR', '155'),
('168', 'FG-056', '2', 'PKR', '160'),
('169', 'FG-056', '3', 'PKR', '165'),
('170', 'FG-056', '4', 'PKR', '170'),
('171', 'FG-056', '5', 'PKR', '170'),
('172', 'FG-058', '1', 'PKR', '260'),
('173', 'FG-058', '2', 'PKR', '265'),
('174', 'FG-058', '3', 'PKR', '270'),
('175', 'FG-058', '4', 'PKR', '275'),
('176', 'FG-058', '5', 'PKR', '275'),
('177', 'FG-010', '1', 'PKR', '165'),
('178', 'FG-010', '2', 'PKR', '170'),
('179', 'FG-010', '3', 'PKR', '175'),
('180', 'FG-010', '4', 'PKR', '180'),
('181', 'FG-010', '5', 'PKR', '180'),
('182', 'FG-011', '1', 'PKR', '2500'),
('183', 'FG-011', '2', 'PKR', '2600'),
('184', 'FG-011', '3', 'PKR', '2700'),
('185', 'FG-011', '4', 'PKR', '2800'),
('186', 'FG-011', '5', 'PKR', '2800'),
('187', 'FG-044', '1', 'PKR', '200'),
('188', 'FG-044', '2', 'PKR', '210'),
('189', 'FG-044', '3', 'PKR', '220'),
('190', 'FG-044', '4', 'PKR', '230'),
('191', 'FG-044', '5', 'PKR', '230'),
('192', 'FG-004', '1', 'PKR', '680'),
('193', 'FG-004', '2', 'PKR', '720'),
('194', 'FG-004', '3', 'PKR', '740'),
('195', 'FG-004', '4', 'PKR', '760'),
('196', 'FG-004', '5', 'PKR', '760'),
('197', 'FG-002', '1', 'PKR', '3800'),
('198', 'FG-002', '2', 'PKR', '3850'),
('199', 'FG-002', '3', 'PKR', '3900'),
('200', 'FG-002', '4', 'PKR', '3950'),
('201', 'FG-002', '5', 'PKR', '3950'),
('202', 'FG-055', '1', 'PKR', '200'),
('203', 'FG-055', '2', 'PKR', '210'),
('204', 'FG-055', '3', 'PKR', '220'),
('205', 'FG-055', '4', 'PKR', '230'),
('206', 'FG-055', '5', 'PKR', '230');

### Structure of table `0_print_profiles` ###

DROP TABLE IF EXISTS `0_print_profiles`;

CREATE TABLE `0_print_profiles` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `profile` varchar(30) NOT NULL,
  `report` varchar(5) DEFAULT NULL,
  `printer` tinyint(3) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `profile` (`profile`,`report`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_print_profiles` ###

INSERT INTO `0_print_profiles` VALUES
('1', 'Out of office', NULL, '0'),
('2', 'Sales Department', NULL, '0'),
('3', 'Central', NULL, '2'),
('4', 'Sales Department', '104', '2'),
('5', 'Sales Department', '105', '2'),
('6', 'Sales Department', '107', '2'),
('7', 'Sales Department', '109', '2'),
('8', 'Sales Department', '110', '2'),
('9', 'Sales Department', '201', '2');

### Structure of table `0_printers` ###

DROP TABLE IF EXISTS `0_printers`;

CREATE TABLE `0_printers` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(20) NOT NULL,
  `description` varchar(60) NOT NULL,
  `queue` varchar(20) NOT NULL,
  `host` varchar(40) NOT NULL,
  `port` smallint(11) unsigned NOT NULL,
  `timeout` tinyint(3) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_printers` ###

INSERT INTO `0_printers` VALUES
('1', 'QL500', 'Label printer', 'QL500', 'server', '127', '20'),
('2', 'Samsung', 'Main network printer', 'scx4521F', 'server', '515', '5'),
('3', 'Local', 'Local print server at user IP', 'lp', '', '515', '10');

### Structure of table `0_production_planing` ###

DROP TABLE IF EXISTS `0_production_planing`;

CREATE TABLE `0_production_planing` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tran_date` varchar(20) NOT NULL,
  `item` varchar(20) NOT NULL,
  `target_qty` int(11) NOT NULL,
  `order_qty` int(11) NOT NULL,
  `status` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_production_planing` ###

INSERT INTO `0_production_planing` VALUES
('1', '2022-07-26', 'CM-001', '100', '50', '0'),
('2', '2022-07-26', 'FG-009', '120', '60', '1'),
('3', '2022-07-26', 'FG-009', '120', '80', '2'),
('4', '2022-07-26', 'FG-009', '100', '95', '0'),
('5', '2022-08-01', 'FG-008', '100', '80', '0');

### Structure of table `0_purch_data` ###

DROP TABLE IF EXISTS `0_purch_data`;

CREATE TABLE `0_purch_data` (
  `supplier_id` int(11) NOT NULL DEFAULT 0,
  `stock_id` char(20) NOT NULL DEFAULT '',
  `price` double NOT NULL DEFAULT 0,
  `suppliers_uom` char(50) NOT NULL DEFAULT '',
  `conversion_factor` double NOT NULL DEFAULT 1,
  `supplier_description` char(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`supplier_id`,`stock_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_purch_data` ###

INSERT INTO `0_purch_data` VALUES
('1', 'CM-002', '5200', '', '1', 'Addtive A-T-F - (G4500)'),
('1', 'CM-003', '6500', '', '1', 'Addtive Gear OIL - (7001)'),
('1', 'CM-007', '550', '', '1', 'Benzene - (CBN-200)'),
('1', 'CM-020', '350', '', '1', 'Methanol - (AMT-100)'),
('1', 'CM-021', '500', '', '1', 'Methylene chloride - (CMC-300)'),
('1', 'CM-023', '680', '', '1', 'Proma - (2001)'),
('1', 'CM-030', '650', '', '1', 'White Oil - (WRO-600)'),
('1', 'CM-032', '4000', '', '1', 'Colour Green - (1605)'),
('1', 'CM-033', '30000', '', '1', 'Colour Red - (1704)'),
('1', 'CM-038', '120', '', '1', 'LPG - (1209)'),
('1', 'RM-004', '70', '', '1', 'Can Carb Clean - (300ml x 172)'),
('1', 'RM-020', '45', '', '1', 'Bottle Power Steering Fluid (350 ml)  -  Bottles'),
('1', 'RM-021', '55', '', '1', 'Plastic Bottle (Green 01Ltr)  -  Bottles  -   Bott'),
('1', 'RM-022', '55', '', '1', 'Plastic Bottle (Red 01Ltr)  -  Bottles  -   Bottle'),
('1', 'RM-023', '55', '', '1', 'Plastic Bottle White - 01 Ltr (Printed)'),
('1', 'RM-036', '160', '', '1', 'Carton-Carb Clean - (300ml x 48) Master'),
('1', 'RM-037', '90', '', '1', 'Carton-Carb Clean - (300ml x 24) Inner'),
('1', 'RM-070', '140', '', '1', 'Carton-ATF Dx III - (01Ltr x 12)'),
('1', 'RM-085', '6', '', '1', 'Caps-Carb Clean - 300 ml (52mm)'),
('1', 'RM-125', '7', '', '1', 'Stickers-ATF Dx III - 01 Ltr'),
('1', 'SFG-101', '130', '', '1', 'ATF-Lubricanta'),
('1', 'ST-0001', '150', '', '1', 'Stationery - Office Files'),
('4', 'FG-001', '310', '', '1', 'Nasa ATF - 1 Ltr'),
('4', 'RM-022', '0', '', '1', 'Plastic Bottle (Red 01Ltr)  -  Bottles  -   Bottle'),
('5', 'CM-002', '2000', '', '1', 'Addtive A-T-F - (G4500)'),
('5', 'CM-003', '2500', '', '1', 'Addtive Gear OIL - (7001)'),
('5', 'CM-013', '520', '', '1', 'Di Etylamine - (DEA-022)'),
('5', 'CM-023', '0', '', '1', 'Proma - (2001)'),
('5', 'CM-030', '0', '', '1', 'White Oil - (WRO-600)'),
('5', 'CM-033', '1500', '', '1', 'Colour Red - (1704)'),
('5', 'RM-021', '55', '', '1', 'Plastic Bottle Green - 01 Ltr'),
('5', 'RM-045', '170', '', '1', 'Carton-Coolant Green Regular - (01Ltr x 12)'),
('5', 'RM-088', '1', '', '1', 'Seal-Coolant - 01 Ltr'),
('5', 'RM-096', '6', '', '1', 'Stickers-Coolant Green Regular - 01 Ltr'),
('6', 'CM-020', '225', '', '1', 'Methanol-(AMT-100)'),
('6', 'CM-023', '320', '', '1', 'Proma-(2001)'),
('6', 'RM-003', '60', '', '1', 'Plastic Bottle Brake Fluid (355ml x 72)'),
('6', 'RM-004', '60', '', '1', 'Can Carb Clean - (300ml x 172)'),
('6', 'RM-021', '55', '', '1', 'Plastic Bottle Green - 01 Ltr'),
('6', 'RM-023', '65', '', '1', 'Plastic Bottle White - 01 Ltr (Printed)'),
('6', 'RM-025', '50', '', '1', 'Plastic Bottle White - 01 Ltr'),
('6', 'RM-045', '150', '', '1', 'Carton-Coolant Green Regular - (01Ltr x 12)'),
('6', 'RM-054', '170', '', '1', 'Carton-Brake Fluid - (355ml x 24)'),
('6', 'RM-070', '155', '', '1', 'Carton-ATF Dx III - (01Ltr x 12)'),
('6', 'RM-085', '5.5', '', '1', 'Caps-Carb Clean - 300 ml (52mm)'),
('6', 'RM-088', '0.6', '', '1', 'Seal-Coolant - 01 Ltr'),
('6', 'RM-094', '0.5', '', '1', 'Seal-Brake Fluid Induction Seal - 355 ml (29mm)'),
('6', 'RM-096', '4.5', '', '1', 'Stickers-Coolant Green Regular - 01 Ltr'),
('6', 'RM-117', '3.5', '', '1', 'Stickers-Brake Fluid - 355 ml'),
('6', 'RM-125', '6.5', '', '1', 'Stickers-ATF Dx III - 01 Ltr'),
('7', 'CM-001', '150', '', '1', 'Acetic Acid - (1803)'),
('7', 'CM-002', '4500', '', '1', 'Addtive A-T-F - (G4500)'),
('7', 'CM-003', '6000', '', '1', 'Addtive Gear OIL - (7001)'),
('7', 'CM-008', '290', '', '1', 'Benzyal Alchole - (1400)'),
('7', 'CM-014', '235', '', '1', 'Die -Etylene Glycol - (1800)'),
('7', 'CM-021', '450', '', '1', 'Methylene chloride - (CMC-300)'),
('7', 'CM-023', '450', '', '1', 'Proma - (2001)'),
('7', 'CM-026', '325', '', '1', 'Sodium Chloride-(SCL-24)'),
('7', 'CM-030', '350', '', '1', 'White Oil - (WRO-600)'),
('7', 'CM-033', '30000', '', '1', 'Colour Red - (1704)'),
('7', 'RM-023', '60', '', '1', 'Plastic Bottle White - 01 Ltr (Printed)'),
('8', 'CM-007', '110', '', '1', 'Benzene - (CBN-200)'),
('8', 'RM-023', '55', '', '1', 'Plastic Bottle White - 01 Ltr (Printed)'),
('8', 'RM-036', '95', '', '1', 'Carton-Carb Clean - (300ml x 48) Master'),
('8', 'RM-037', '50', '', '1', 'Carton-Carb Clean - (300ml x 24) Inner'),
('8', 'RM-070', '120', '', '1', 'Carton-ATF Dx III - (01Ltr x 12)'),
('8', 'RM-125', '3.5', '', '1', 'Stickers-ATF Dx III - 01 Ltr'),
('8', 'SFG-101', '300', '', '1', 'ATF-Lubricanta'),
('9', 'CM-001', '350', '', '1', 'Acetic Acid - (1803)'),
('9', 'CM-002', '4500', '', '1', 'Addtive A-T-F - (G4500)'),
('9', 'CM-003', '1000', '', '1', 'Addtive Gear OIL - (7001)'),
('9', 'CM-007', '600', '', '1', 'Benzene - (CBN-200)'),
('9', 'CM-009', '450', '', '1', 'Borex - (1609)'),
('9', 'CM-010', '490', '', '1', 'Butyle Glycol - (BOG-400)'),
('9', 'CM-016', '600', '', '1', 'E-D-T-A - (1608)'),
('9', 'CM-020', '750', '', '1', 'Methanol - (AMT-100)'),
('9', 'CM-021', '550', '', '1', 'Methylene chloride-(CMC-300)'),
('9', 'CM-022', '300', '', '1', 'Mono Ethyl Glycol - (1601)'),
('9', 'CM-023', '450', '', '1', 'Proma - (2001)'),
('9', 'CM-025', '750', '', '1', 'Sodium Benoate - (AFR-700)'),
('9', 'CM-030', '450', '', '1', 'White Oil - (WRO-600)'),
('9', 'CM-032', '2500', '', '1', 'Colour Green - (1605)'),
('9', 'CM-033', '4000', '', '1', 'Colour Red - (1704)'),
('9', 'CM-034', '1500', '', '1', 'Colour Yellow - (1606)'),
('9', 'CM-038', '150', '', '1', 'LPG - (1209)'),
('9', 'FA-01', '18000', '', '1', 'Generator'),
('10', 'CM-007', '550', '', '1', 'Benzene - (CBN-200)'),
('10', 'CM-020', '550', '', '1', 'Methanol - (AMT-100)'),
('10', 'CM-021', '235', '', '1', 'Methylene chloride - (CMC-300)'),
('10', 'CM-027', '350', '', '1', 'Sodium Loyral Ether Sulfate-(STB-200)'),
('10', 'CM-038', '100', '', '1', 'LPG - (1209)'),
('10', 'RM-045', '155', '', '1', 'Carton-Coolant Green Regular - (01Ltr x 12)'),
('10', 'RM-088', '0.7', '', '1', 'Seal-Coolant - 01 Ltr'),
('10', 'RM-096', '6.5', '', '1', 'Stickers-Coolant Green Regular - 01 Ltr'),
('11', 'CM-020', '350', '', '1', 'Methanol - (AMT-100)'),
('11', 'CM-038', '120', '', '1', 'LPG - (1209)');

### Structure of table `0_purch_order_details` ###

DROP TABLE IF EXISTS `0_purch_order_details`;

CREATE TABLE `0_purch_order_details` (
  `po_detail_item` int(11) NOT NULL AUTO_INCREMENT,
  `order_no` int(11) NOT NULL DEFAULT 0,
  `item_code` varchar(20) NOT NULL DEFAULT '',
  `description` tinytext DEFAULT NULL,
  `delivery_date` date NOT NULL DEFAULT '0000-00-00',
  `qty_invoiced` double NOT NULL DEFAULT 0,
  `unit_price` double NOT NULL DEFAULT 0,
  `act_price` double NOT NULL DEFAULT 0,
  `std_cost_unit` double NOT NULL DEFAULT 0,
  `quantity_ordered` double NOT NULL DEFAULT 0,
  `quantity_received` double NOT NULL DEFAULT 0,
  `in_ward_qty` double NOT NULL DEFAULT 0,
  `qc_qty` double NOT NULL DEFAULT 0,
  `out_ward_qty` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`po_detail_item`),
  KEY `order` (`order_no`,`po_detail_item`),
  KEY `itemcode` (`item_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_purch_order_details` ###


### Structure of table `0_purch_orders` ###

DROP TABLE IF EXISTS `0_purch_orders`;

CREATE TABLE `0_purch_orders` (
  `order_no` int(11) NOT NULL AUTO_INCREMENT,
  `supplier_id` int(11) NOT NULL DEFAULT 0,
  `comments` tinytext DEFAULT NULL,
  `ord_date` date NOT NULL DEFAULT '0000-00-00',
  `qc_req_date` date NOT NULL DEFAULT '0000-00-00',
  `reference` tinytext NOT NULL,
  `requisition_no` tinytext DEFAULT NULL,
  `into_stock_location` varchar(5) NOT NULL DEFAULT '',
  `delivery_address` tinytext NOT NULL,
  `total` double NOT NULL DEFAULT 0,
  `prep_amount` double NOT NULL DEFAULT 0,
  `alloc` double NOT NULL DEFAULT 0,
  `tax_group_id` int(11) NOT NULL,
  `tax_included` tinyint(1) NOT NULL DEFAULT 0,
  `req_no` int(11) DEFAULT NULL,
  `is_qc_complete` int(11) NOT NULL DEFAULT 0,
  `is_close` int(11) DEFAULT 0,
  `dimension_id` int(11) NOT NULL DEFAULT 0,
  `dimension2_id` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_no`),
  KEY `ord_date` (`ord_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_purch_orders` ###


### Structure of table `0_purch_quotation` ###

DROP TABLE IF EXISTS `0_purch_quotation`;

CREATE TABLE `0_purch_quotation` (
  `order_no` int(11) NOT NULL AUTO_INCREMENT,
  `supplier_id` int(11) NOT NULL DEFAULT 0,
  `comments` tinytext DEFAULT NULL,
  `ord_date` date NOT NULL DEFAULT '0000-00-00',
  `reference` tinytext NOT NULL,
  `requisition_no` tinytext DEFAULT NULL,
  `into_stock_location` varchar(5) NOT NULL DEFAULT '',
  `delivery_address` tinytext NOT NULL,
  `total` double NOT NULL DEFAULT 0,
  `prep_amount` double NOT NULL DEFAULT 0,
  `alloc` double NOT NULL DEFAULT 0,
  `tax_group_id` int(11) NOT NULL,
  `tax_included` tinyint(1) NOT NULL DEFAULT 0,
  `req_no` int(11) DEFAULT NULL,
  `is_qc_complete` int(11) NOT NULL DEFAULT 0,
  `is_close` int(11) DEFAULT 0,
  PRIMARY KEY (`order_no`),
  KEY `ord_date` (`ord_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_purch_quotation` ###


### Structure of table `0_purch_quotation_details` ###

DROP TABLE IF EXISTS `0_purch_quotation_details`;

CREATE TABLE `0_purch_quotation_details` (
  `po_detail_item` int(11) NOT NULL AUTO_INCREMENT,
  `order_no` int(11) NOT NULL DEFAULT 0,
  `item_code` varchar(20) NOT NULL DEFAULT '',
  `description` tinytext DEFAULT NULL,
  `delivery_date` date NOT NULL DEFAULT '0000-00-00',
  `qty_invoiced` double NOT NULL DEFAULT 0,
  `unit_price` double NOT NULL DEFAULT 0,
  `act_price` double NOT NULL DEFAULT 0,
  `std_cost_unit` double NOT NULL DEFAULT 0,
  `quantity_ordered` double NOT NULL DEFAULT 0,
  `quantity_received` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`po_detail_item`),
  KEY `order` (`order_no`,`po_detail_item`),
  KEY `itemcode` (`item_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_purch_quotation_details` ###


### Structure of table `0_qc_setup` ###

DROP TABLE IF EXISTS `0_qc_setup`;

CREATE TABLE `0_qc_setup` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type_id` int(11) NOT NULL,
  `name` varchar(100) NOT NULL,
  `qc_type` int(11) NOT NULL,
  `min` int(11) DEFAULT NULL,
  `max` int(11) DEFAULT NULL,
  `options` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=79 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_qc_setup` ###

INSERT INTO `0_qc_setup` VALUES
('6', '1', 'Name', '1', '0', '0', NULL),
('7', '1', 'Qty', '2', '1', '50', NULL),
('8', '1', 'Expiry date', '3', '0', '0', NULL),
('9', '1', 'All correct', '5', '0', '0', NULL),
('10', '1', 'Defact Type', '6', '0', '0', 'all defected , half defected , some defected'),
('11', '1', 'Detals', '4', '0', '0', NULL),
('12', '2', 'Defact Type', '6', '0', '0', 'all defected , half defected , some defected'),
('13', '2', 'Name', '1', '0', '0', NULL),
('14', '2', 'Qty', '2', '1', '50', NULL),
('15', '2', 'Expiry date', '3', '0', '0', NULL),
('16', '2', 'All correct', '5', '0', '0', NULL),
('17', '2', 'Detals', '4', '0', '0', NULL),
('18', '2', 'Defact Type', '6', '0', '0', 'all defected , half defected , some defected'),
('19', '3', 'Name', '1', '0', '0', NULL),
('20', '3', 'Qty', '2', '1', '50', NULL),
('21', '3', 'Expiry date', '3', '0', '0', NULL),
('22', '3', 'All correct', '5', '0', '0', NULL),
('23', '3', 'Detals', '4', '0', '0', NULL),
('24', '2', 'Defact Type', '6', '0', '0', 'all defected , half defected , some defected'),
('25', '4', 'Name', '1', '0', '0', NULL),
('26', '4', 'Qty', '2', '1', '50', NULL),
('27', '4', 'Expiry date', '3', '0', '0', NULL),
('28', '4', 'All correct', '5', '0', '0', NULL),
('29', '4', 'Detals', '4', '0', '0', NULL),
('30', '8', 'Composition', '5', '0', '0', NULL),
('31', '8', 'Color', '5', '0', '0', NULL),
('32', '8', 'Quantity', '2', '0', '100000', NULL),
('33', '10', 'Name', '1', '0', '0', NULL),
('34', '10', 'Quantity', '1', '0', '0', NULL),
('35', '9', 'Weight', '2', '1', '100000', NULL),
('36', '9', 'Packaging', '5', '0', '0', NULL),
('37', '8', 'Bottle/Can', '5', '0', '0', NULL),
('38', '8', 'Valve', '5', '0', '0', NULL),
('39', '8', 'Caps', '5', '0', '0', NULL),
('40', '8', 'Sticker', '5', '0', '0', NULL),
('41', '8', 'Packaging', '5', '0', '0', NULL),
('42', '9', 'Chemical ', '5', '0', '0', NULL),
('43', '14', 'Quantity', '5', '0', '0', NULL),
('44', '10', 'Appearence', '1', '0', '0', NULL),
('45', '10', 'Viscosity @ 100 C', '1', '0', '0', NULL),
('46', '10', 'Viscosity @ 40 C', '1', '0', '0', NULL),
('47', '10', 'Viscosity Index', '4', '0', '0', NULL),
('48', '10', 'Density at Room Temeoearture', '4', '0', '0', NULL),
('49', '10', 'Boiling Point', '1', '0', '0', NULL),
('50', '10', 'Color', '1', '0', '0', NULL),
('51', '10', 'Evaporation Rate', '1', '0', '0', NULL),
('52', '15', 'Name', '1', '0', '0', NULL),
('53', '15', 'Quantity', '1', '0', '0', NULL),
('54', '15', 'Appearence', '1', '0', '0', NULL),
('55', '15', 'Color', '1', '0', '0', NULL),
('56', '15', 'Viscosity @ 100 C', '1', '0', '0', NULL),
('57', '15', 'Viscosity @ 40 C', '1', '0', '0', NULL),
('58', '15', 'Viscosity Index', '1', '0', '0', NULL),
('59', '15', 'Specific Gravity', '1', '0', '0', NULL),
('60', '15', 'Freezing Point', '1', '0', '0', NULL),
('61', '10', 'Freezing Point', '1', '0', '0', NULL),
('62', '15', 'PH Value', '1', '0', '0', NULL),
('63', '15', 'Moisture', '6', '0', '0', 'Yes,No'),
('64', '15', 'Density at Room Temeoearture', '1', '0', '0', NULL),
('65', '15', 'Boiling Point', '1', '0', '0', NULL),
('66', '15', 'Pour Point', '1', '0', '0', NULL),
('67', '15', 'Evaporation Rate', '1', '0', '0', NULL),
('68', '11', 'Name', '1', '0', '0', NULL),
('69', '12', 'Name', '1', '0', '0', NULL),
('70', '12', 'Quantity', '1', '0', '0', NULL),
('71', '12', 'Frangnance', '1', '0', '0', NULL),
('72', '11', 'Quantity', '1', '0', '0', NULL),
('73', '11', 'Color', '1', '0', '0', NULL),
('74', '13', 'Name', '1', '0', '0', NULL),
('75', '13', 'Quantity', '1', '0', '0', NULL),
('76', '13', 'Appearence', '1', '0', '0', NULL),
('77', '13', 'Temeprature ', '6', '0', '0', 'Melt, Non Melt'),
('78', '10', 'PH Value', '1', '0', '0', NULL);

### Structure of table `0_qc_trans` ###

DROP TABLE IF EXISTS `0_qc_trans`;

CREATE TABLE `0_qc_trans` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `trans_no` int(11) NOT NULL COMMENT 'QC trans No',
  `po_order_no` int(11) NOT NULL,
  `type` int(11) NOT NULL,
  `field_id` int(11) NOT NULL,
  `label_name` varchar(200) DEFAULT NULL,
  `value` text DEFAULT NULL,
  `date_time` datetime NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_qc_trans` ###


### Structure of table `0_quick_entries` ###

DROP TABLE IF EXISTS `0_quick_entries`;

CREATE TABLE `0_quick_entries` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `type` tinyint(1) NOT NULL DEFAULT 0,
  `description` varchar(60) NOT NULL,
  `usage` varchar(120) DEFAULT NULL,
  `base_amount` double NOT NULL DEFAULT 0,
  `base_desc` varchar(60) DEFAULT NULL,
  `bal_type` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `description` (`description`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_quick_entries` ###


### Structure of table `0_quick_entry_lines` ###

DROP TABLE IF EXISTS `0_quick_entry_lines`;

CREATE TABLE `0_quick_entry_lines` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `qid` smallint(6) unsigned NOT NULL,
  `amount` double DEFAULT 0,
  `memo` tinytext NOT NULL,
  `action` varchar(2) NOT NULL,
  `dest_id` varchar(15) NOT NULL DEFAULT '',
  `dimension_id` smallint(6) unsigned DEFAULT NULL,
  `dimension2_id` smallint(6) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `qid` (`qid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_quick_entry_lines` ###


### Structure of table `0_recurrent_invoices` ###

DROP TABLE IF EXISTS `0_recurrent_invoices`;

CREATE TABLE `0_recurrent_invoices` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(60) NOT NULL DEFAULT '',
  `order_no` int(11) unsigned NOT NULL,
  `debtor_no` int(11) unsigned DEFAULT NULL,
  `group_no` smallint(6) unsigned DEFAULT NULL,
  `days` int(11) NOT NULL DEFAULT 0,
  `monthly` int(11) NOT NULL DEFAULT 0,
  `begin` date NOT NULL DEFAULT '0000-00-00',
  `end` date NOT NULL DEFAULT '0000-00-00',
  `last_sent` date NOT NULL DEFAULT '0000-00-00',
  PRIMARY KEY (`id`),
  UNIQUE KEY `description` (`description`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_recurrent_invoices` ###


### Structure of table `0_reflines` ###

DROP TABLE IF EXISTS `0_reflines`;

CREATE TABLE `0_reflines` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `trans_type` int(11) NOT NULL,
  `prefix` char(5) NOT NULL DEFAULT '',
  `pattern` varchar(35) NOT NULL DEFAULT '1',
  `description` varchar(60) NOT NULL DEFAULT '',
  `default` tinyint(1) NOT NULL DEFAULT 0,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `prefix` (`trans_type`,`prefix`)
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_reflines` ###

INSERT INTO `0_reflines` VALUES
('1', '0', '', 'JE/{001}/{YYYY}', '', '1', '0'),
('2', '1', '', 'BP/{001}/{YYYY}', '', '1', '0'),
('3', '2', '', 'BD/{001}/{YYYY}', '', '1', '0'),
('4', '4', '', 'BT/{001}/{YYYY}', '', '1', '0'),
('5', '10', '', 'SI/{001}/{YYYY}', '', '1', '0'),
('6', '11', '', 'CN/{001}/{YYYY}', '', '1', '0'),
('7', '12', '', 'CP/{001}/{YYYY}', '', '1', '0'),
('8', '13', '', 'DN/{001}/{YYYY}', '', '1', '0'),
('9', '16', '', 'LT/{001}/{YYYY}', '', '1', '0'),
('10', '17', '', 'IA/{001}/{YYYY}', '', '1', '0'),
('11', '18', '', 'PO/{001}/{YYYY}', '', '1', '0'),
('12', '20', '', 'SPI/{001}/{YYYY}', '', '1', '0'),
('13', '21', '', 'SC/{001}/{YYYY}', '', '1', '0'),
('14', '22', '', 'SP/{001}/{YYYY}', '', '1', '0'),
('15', '25', '', 'GRN/{001}/{YYYY}', '', '1', '0'),
('16', '26', '', 'WO/{001}/{YYYY}', '', '1', '0'),
('17', '28', '', 'WOIS/{001}/{YYYY}', '', '1', '0'),
('18', '29', '', 'WORC/{001}/{YYYY}', '', '1', '0'),
('19', '30', '', 'SO/{001}/{YYYY}', '', '1', '0'),
('20', '32', '', 'SQ/{001}/{YYYY}', '', '1', '0'),
('21', '35', '', 'CUP/{001}/{YYYY}', '', '1', '0'),
('22', '40', '', 'CC/{001}/{YYYY}', '', '1', '0'),
('23', '43', '', 'REQ/{001}/{YYYY}', '', '1', '0'),
('24', '111', '', '{00001}', '', '1', '0'),
('25', '37', '', 'IC/{001}/{YYYY}', '', '1', '0'),
('26', '46', '', 'PQ/{001}/{YYYY}', '', '1', '0');

### Structure of table `0_refs` ###

DROP TABLE IF EXISTS `0_refs`;

CREATE TABLE `0_refs` (
  `id` int(11) NOT NULL DEFAULT 0,
  `type` int(11) NOT NULL DEFAULT 0,
  `reference` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`,`type`),
  KEY `Type_and_Reference` (`type`,`reference`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_refs` ###

INSERT INTO `0_refs` VALUES
('1', '17', 'IA/001/2023');

### Structure of table `0_req_order_details` ###

DROP TABLE IF EXISTS `0_req_order_details`;

CREATE TABLE `0_req_order_details` (
  `po_detail_item` int(11) NOT NULL AUTO_INCREMENT,
  `order_no` int(11) NOT NULL DEFAULT 0,
  `item_code` varchar(20) NOT NULL DEFAULT '',
  `description` tinytext DEFAULT NULL,
  `unit_code` varchar(20) NOT NULL DEFAULT '0',
  `delivery_date` date NOT NULL DEFAULT '0000-00-00',
  `qty_invoiced` double NOT NULL DEFAULT 0,
  `unit_price` double NOT NULL DEFAULT 0,
  `act_price` double NOT NULL DEFAULT 0,
  `std_cost_unit` double NOT NULL DEFAULT 0,
  `quantity_ordered` double NOT NULL DEFAULT 0,
  `quantity_received` double NOT NULL DEFAULT 0,
  `qty_delivered` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`po_detail_item`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_req_order_details` ###


### Structure of table `0_req_orders` ###

DROP TABLE IF EXISTS `0_req_orders`;

CREATE TABLE `0_req_orders` (
  `order_no` int(11) NOT NULL AUTO_INCREMENT,
  `supplier_id` int(11) NOT NULL DEFAULT 0,
  `comments` tinytext DEFAULT NULL,
  `ord_date` date NOT NULL DEFAULT '0000-00-00',
  `reference` tinytext NOT NULL,
  `requisition_no` tinytext DEFAULT NULL,
  `into_stock_location` varchar(5) DEFAULT NULL COMMENT 'To Location',
  `delivery_address` tinytext NOT NULL,
  `total` double NOT NULL DEFAULT 0,
  `prep_amount` double NOT NULL DEFAULT 0,
  `alloc` double NOT NULL DEFAULT 0,
  `tax_included` tinyint(1) NOT NULL DEFAULT 0,
  `lot_no` varchar(20) DEFAULT NULL,
  `approved` int(11) DEFAULT 0,
  `is_complete` int(11) NOT NULL DEFAULT 0,
  `request_location` varchar(15) DEFAULT NULL COMMENT 'From Location',
  `is_store_issue` int(11) NOT NULL DEFAULT 0,
  `is_purchase_request` int(11) NOT NULL DEFAULT 0,
  `is_purch_req_no` int(11) NOT NULL DEFAULT 0 COMMENT 'Requsition To send Purch Req to save Prv req No',
  `wo_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_no`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_req_orders` ###


### Structure of table `0_requisition_details` ###

DROP TABLE IF EXISTS `0_requisition_details`;

CREATE TABLE `0_requisition_details` (
  `requisition_detail_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `requisition_id` int(11) DEFAULT NULL,
  `item_code` varchar(20) DEFAULT NULL,
  `supplier_id` int(11) DEFAULT NULL,
  `lpo_id` int(11) DEFAULT 0,
  `order_quantity` int(11) NOT NULL DEFAULT 0,
  `estimate_price` double NOT NULL DEFAULT 0,
  `quantity` int(11) NOT NULL DEFAULT 0,
  `price` double NOT NULL DEFAULT 0,
  `purpose` varchar(320) DEFAULT NULL,
  PRIMARY KEY (`requisition_detail_id`),
  KEY `0_requisition_details_requisition_id` (`requisition_id`),
  KEY `0_requisition_details_item_code` (`item_code`),
  KEY `0_requisition_details_supplier_id` (`supplier_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_requisition_details` ###

INSERT INTO `0_requisition_details` VALUES
('1', '1', 'CM-003', '9', '0', '30', '120', '30', '120', 'Office'),
('2', '1', 'RM-067', '11', '0', '10', '320', '10', '320', 'Office');

### Structure of table `0_requisitions` ###

DROP TABLE IF EXISTS `0_requisitions`;

CREATE TABLE `0_requisitions` (
  `requisition_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `point_of_use` varchar(50) DEFAULT NULL,
  `narrative` varchar(240) DEFAULT NULL,
  `application_date` timestamp NOT NULL DEFAULT current_timestamp(),
  `completed` tinyint(4) NOT NULL DEFAULT 0,
  `processed` tinyint(4) NOT NULL DEFAULT 0,
  `inactive` tinyint(4) NOT NULL DEFAULT 0,
  `details` text DEFAULT NULL,
  PRIMARY KEY (`requisition_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_requisitions` ###

INSERT INTO `0_requisitions` VALUES
('1', 'pen', 'pen ', '2022-10-20 07:59:34', '1', '0', '0', 'pen  ');

### Structure of table `0_sales_order_details` ###

DROP TABLE IF EXISTS `0_sales_order_details`;

CREATE TABLE `0_sales_order_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `order_no` int(11) NOT NULL DEFAULT 0,
  `trans_type` smallint(6) NOT NULL DEFAULT 30,
  `stk_code` varchar(20) NOT NULL DEFAULT '',
  `description` tinytext DEFAULT NULL,
  `qty_sent` double NOT NULL DEFAULT 0,
  `unit_price` double NOT NULL DEFAULT 0,
  `quantity` double NOT NULL DEFAULT 0,
  `invoiced` double NOT NULL DEFAULT 0,
  `discount_percent` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `sorder` (`trans_type`,`order_no`),
  KEY `stkcode` (`stk_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_sales_order_details` ###


### Structure of table `0_sales_orders` ###

DROP TABLE IF EXISTS `0_sales_orders`;

CREATE TABLE `0_sales_orders` (
  `order_no` int(11) NOT NULL,
  `trans_type` smallint(6) NOT NULL DEFAULT 30,
  `version` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `type` tinyint(1) NOT NULL DEFAULT 0,
  `debtor_no` int(11) NOT NULL DEFAULT 0,
  `branch_code` int(11) NOT NULL DEFAULT 0,
  `reference` varchar(100) NOT NULL DEFAULT '',
  `customer_ref` tinytext NOT NULL,
  `comments` tinytext DEFAULT NULL,
  `ord_date` date NOT NULL DEFAULT '0000-00-00',
  `order_type` int(11) NOT NULL DEFAULT 0,
  `ship_via` int(11) NOT NULL DEFAULT 0,
  `delivery_address` tinytext NOT NULL,
  `contact_phone` varchar(30) DEFAULT NULL,
  `contact_email` varchar(100) DEFAULT NULL,
  `deliver_to` tinytext NOT NULL,
  `freight_cost` double NOT NULL DEFAULT 0,
  `from_stk_loc` varchar(5) NOT NULL DEFAULT '',
  `delivery_date` date NOT NULL DEFAULT '0000-00-00',
  `payment_terms` int(11) DEFAULT NULL,
  `sales_person` int(11) NOT NULL DEFAULT 0,
  `total` double NOT NULL DEFAULT 0,
  `prep_amount` double NOT NULL DEFAULT 0,
  `alloc` double NOT NULL DEFAULT 0,
  `dimension_id` int(11) NOT NULL DEFAULT 0,
  `dimension2_id` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`trans_type`,`order_no`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_sales_orders` ###


### Structure of table `0_sales_pos` ###

DROP TABLE IF EXISTS `0_sales_pos`;

CREATE TABLE `0_sales_pos` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `pos_name` varchar(30) NOT NULL,
  `cash_sale` tinyint(1) NOT NULL,
  `credit_sale` tinyint(1) NOT NULL,
  `pos_location` varchar(5) NOT NULL,
  `pos_account` smallint(6) unsigned NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `pos_name` (`pos_name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_sales_pos` ###

INSERT INTO `0_sales_pos` VALUES
('1', 'Default', '1', '1', 'DEF', '2', '0');

### Structure of table `0_sales_types` ###

DROP TABLE IF EXISTS `0_sales_types`;

CREATE TABLE `0_sales_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sales_type` char(50) NOT NULL DEFAULT '',
  `tax_included` int(1) NOT NULL DEFAULT 0,
  `factor` double NOT NULL DEFAULT 1,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `sales_type` (`sales_type`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_sales_types` ###

INSERT INTO `0_sales_types` VALUES
('1', 'Regional', '0', '1', '0'),
('2', 'Disttributpr', '0', '1', '0'),
('3', 'Wholesale', '0', '1', '0'),
('4', 'Retail', '1', '1', '0'),
('5', 'Corporate', '0', '1', '0');

### Structure of table `0_salesman` ###

DROP TABLE IF EXISTS `0_salesman`;

CREATE TABLE `0_salesman` (
  `salesman_code` int(11) NOT NULL AUTO_INCREMENT,
  `salesman_name` char(60) NOT NULL DEFAULT '',
  `salesman_phone` char(30) NOT NULL DEFAULT '',
  `salesman_fax` char(30) NOT NULL DEFAULT '',
  `salesman_email` varchar(100) NOT NULL DEFAULT '',
  `provision` double NOT NULL DEFAULT 0,
  `break_pt` double NOT NULL DEFAULT 0,
  `provision2` double NOT NULL DEFAULT 0,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`salesman_code`),
  UNIQUE KEY `salesman_name` (`salesman_name`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_salesman` ###

INSERT INTO `0_salesman` VALUES
('1', 'Asad', '', '', '', '5', '1000', '4', '0'),
('2', 'Irfan', '', '', '', '5', '1000', '4', '0'),
('3', 'Faheem', '', '', '', '5', '1000', '4', '0'),
('4', 'Badar', '', '', '', '5', '1000', '4', '0'),
('5', 'Haji Arif', '', '', '', '5', '1000', '4', '0'),
('6', 'Abdul Habib', '', '', '', '5', '1000', '4', '0');

### Structure of table `0_security_roles` ###

DROP TABLE IF EXISTS `0_security_roles`;

CREATE TABLE `0_security_roles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `role` varchar(30) NOT NULL,
  `description` varchar(50) DEFAULT NULL,
  `sections` text DEFAULT NULL,
  `areas` text DEFAULT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `role` (`role`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_security_roles` ###

INSERT INTO `0_security_roles` VALUES
('1', 'Inquiries', 'Inquiries', '768;2816;3072;3328;5632;5888;8192;8448;10752;11008;13312;15872;16128', '257;258;259;260;513;514;515;516;517;518;519;520;521;522;523;524;525;773;774;2822;3073;3075;3076;3077;3329;3330;3331;3332;3333;3334;3335;5377;5633;5640;5889;5890;5891;7937;7938;7939;7940;8193;8194;8450;8451;10497;10753;11009;11010;11012;13313;13315;15617;15618;15619;15620;15621;15622;15623;15624;15625;15626;15873;15882;16129;16130;16131;16132;775', '0'),
('2', 'System Administrator', 'System Administrator', '256;512;768;2816;3072;3328;5376;5632;5888;7936;8192;8448;9216;9472;9728;10496;10752;11008;13056;13312;15616;15872;16128;18176;18432;20736;353280;418816', '257;258;259;260;513;514;515;516;517;518;519;520;521;522;523;524;525;526;769;770;771;772;773;774;775;2817;2818;2819;2820;2821;2822;2823;3073;3074;3082;3075;3076;3077;3078;3079;3080;3081;3329;3330;3331;3332;3333;3334;3335;5377;5633;5646;5647;5648;5649;5634;5635;5636;5637;5641;5638;5639;5640;5642;5643;5644;5645;5889;5890;5891;5892;7937;7938;7939;7940;8193;8194;8195;8196;8197;8198;8199;8449;8450;8451;9217;9218;9220;9473;9474;9475;9476;9729;10497;10753;10754;10755;10756;10757;11009;11010;11011;11012;13057;13313;13314;13315;15617;15618;15619;15620;15621;15622;15623;15624;15628;15625;15626;15627;15630;15873;15874;15875;15876;15877;15878;15879;15880;15883;15881;15882;15884;16129;16130;16131;16132;18177;18434;20737;20738;20739;20740;20741;20742;20743;20744;20745;20746;20747;20748;20749;20750;20751;20752;20753;20754;20755;20756;20757;20758;20759;20760;20761;20762;20763;20764;20765;20766;20767;20768;353380;418916;418917', '0'),
('3', 'Salesman', 'Salesman', '768;3072;5632;8192;15872', '773;774;775;3073;3075;3081;5633;5644;8194;15873', '0'),
('4', 'Stock Manager', 'Stock Manager', '5632;5888;8192;8448;18176;18432;20736', '5633;5647;5648;5649;5636;5641;5642;5644;5889;5892;8193;8194;8196;8199;8449;8450;8451;18177;18434;20747;20748;20749;2818;2822;3073;3076;3077;3329;3330;3331;3332;3333;3334;3335;10753;11009;11010;11012;13313;13315;15882;16129;16130;16131;16132', '0'),
('5', 'Production Manager', 'Production Manager', '5632;5888;8192;10496;10752;11008;20736', '5647;5642;5643;5644;5889;5892;8194;8196;8199;10497;10753;10754;10755;10756;10757;11009;11010;11011;11012;20746;20748;20751;3329;3330;3331;3332;3333;3334;3335;8450;8451;13313;13315;15617;15619;15620;15621;15624;15876;15877;15880;15882;16129;16130;16131;16132', '0'),
('6', 'Purchase Officer', 'Purchase Officer', '5632;5888;8448;20736', '5633;5635;5637;5638;5644;5645;5889;5892;8450;20749;20750;773;774;775;2821;2822;2823;3073;3074;3076;3077;3078;3079;3080;3081;3329;3330;3331;3332;3333;3334;3335;5377;11009;11010;11012;13313;13315;15617;15619;15620;15621;15624;15876;15877;15880;15882;16129;16130;16131;16132', '0'),
('7', 'AR Officer', 'AR Officer', '512;768;2816;3072;3328;5632;5888;8192;8448;10752;11008;13312;15616;15872;16128', '521;523;524;771;773;774;2818;2819;2820;2821;2822;2823;3073;3073;3074;3075;3076;3077;3078;3079;3080;3081;3081;3329;3330;3330;3330;3331;3331;3332;3333;3334;3335;5633;5633;5634;5637;5638;5639;5640;5640;5889;5890;5891;8193;8194;8194;8196;8197;8450;8451;10753;10755;11009;11010;11012;13313;13315;15617;15619;15620;15621;15624;15624;15873;15876;15877;15878;15880;15882;16129;16130;16131;16132;775', '0'),
('8', 'AP Officer', 'AP Officer', '512;768;2816;3072;3328;5376;5632;5888;8192;8448;10752;11008;13312;15616;15872;16128', '257;258;259;260;521;523;524;769;770;771;772;773;774;2818;2819;2820;2821;2822;2823;3073;3074;3082;3076;3077;3078;3079;3080;3081;3329;3330;3331;3332;3333;3334;3335;5377;5633;5635;5640;5889;5890;5891;7937;7938;7939;7940;8193;8194;8196;8197;8449;8450;8451;10497;10753;10755;11009;11010;11012;13057;13313;13315;15617;15619;15620;15621;15624;15876;15877;15880;15882;16129;16130;16131;16132;775', '0'),
('9', 'Accountant', 'New Accountant', '512;768;2816;3072;3328;5376;5632;5888;8192;8448;10752;11008;13312;15616;15872;16128', '257;258;259;260;521;523;524;771;772;773;774;2818;2819;2820;2821;2822;2823;3073;3074;3075;3076;3077;3078;3079;3080;3081;3329;3330;3331;3332;3333;3334;3335;5377;5633;5634;5635;5637;5638;5639;5640;5889;5890;5891;7937;7938;7939;7940;8193;8194;8196;8197;8449;8450;8451;10497;10753;10755;11009;11010;11012;13313;13315;15617;15618;15619;15620;15621;15624;15873;15876;15877;15878;15880;15882;16129;16130;16131;16132;775', '0'),
('10', 'Sub Admin', 'Sub Admin', '512;768;2816;3072;3328;5376;5632;5888;8192;8448;10752;11008;13312;15616;15872;16128', '257;258;259;260;521;523;524;771;772;773;774;2818;2819;2820;2821;2822;2823;3073;3074;3082;3075;3076;3077;3078;3079;3080;3081;3329;3330;3331;3332;3333;3334;3335;5377;5633;5634;5635;5637;5638;5639;5640;5889;5890;5891;7937;7938;7939;7940;8193;8194;8196;8197;8449;8450;8451;10497;10753;10755;11009;11010;11012;13057;13313;13315;15617;15619;15620;15621;15624;15873;15874;15876;15877;15878;15879;15880;15882;16129;16130;16131;16132;775', '0'),
('11', 'Trading', 'Trading', '2816;3072;3328;5376;5632;5888;7936;8192;8448;15616;15872;16128;287744', '2817;2818;2819;2820;2821;2822;2823;3073;3074;3082;3075;3076;3077;3078;3079;3080;3081;3329;3330;3331;3332;3333;3334;3335;5377;5633;5634;5635;5636;5637;5641;5638;5639;5640;5889;5890;5891;7937;7938;7939;7940;8193;8194;8195;8196;8197;8449;8450;8451;15617;15618;15619;15620;15621;15622;15623;15624;15628;15625;15626;15627;15630;15873;15874;15875;15876;15877;15878;15879;15880;15883;15881;15882;15884;16129;16130;16131;16132;287844;287845', '0'),
('12', 'ERP', 'ERP', '2816;3072;3328;5376;5632;5888;7936;8192;8448;9216;9472;9728;10496;10752;11008;13056;13312;15616;15872;16128;287744', '2817;2818;2819;2820;2821;2822;2823;3073;3074;3082;3075;3076;3077;3078;3079;3080;3081;3329;3330;3331;3332;3333;3334;3335;5377;5633;5634;5635;5636;5637;5641;5638;5639;5640;5889;5890;5891;7937;7938;7939;7940;8193;8194;8195;8196;8197;8449;8450;8451;9217;9218;9220;9473;9474;9475;9476;9729;10497;10753;10754;10755;10756;10757;11009;11010;11011;11012;13057;13313;13314;13315;15617;15618;15619;15620;15621;15622;15623;15624;15628;15625;15626;15627;15630;15873;15874;15875;15876;15877;15878;15879;15880;15883;15881;15882;15884;16129;16130;16131;16132;287844;287845', '0'),
('13', 'Finish To Deliver', 'Finish To Deliver', '3072;5632;5888;8192;20736', '3073;3076;3078;5644;5892;8193;8194;8196;20743;20744;20746;20747', '0'),
('14', 'Asst Sales Manager', 'Asst Sales Manager', '3072;5632;5888;8192;20736', '3073;3082;3075;5644;5892;8193;20743;20744;20745', '0'),
('15', 'Branch Manager ', 'Branch Manager ', '3072;3328;5632;7936;8192;15872;20736', '3073;3075;3076;3077;3078;3080;3081;3329;3330;5644;7937;8193;8194;8196;8199;15873;15874;15876;15880;20743;20744;20745;20747', '0');

### Structure of table `0_shippers` ###

DROP TABLE IF EXISTS `0_shippers`;

CREATE TABLE `0_shippers` (
  `shipper_id` int(11) NOT NULL AUTO_INCREMENT,
  `shipper_name` varchar(60) NOT NULL DEFAULT '',
  `phone` varchar(30) NOT NULL DEFAULT '',
  `phone2` varchar(30) NOT NULL DEFAULT '',
  `contact` tinytext NOT NULL,
  `address` tinytext NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`shipper_id`),
  UNIQUE KEY `name` (`shipper_name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_shippers` ###

INSERT INTO `0_shippers` VALUES
('1', 'Default', '', '', '', '', '0');

### Structure of table `0_sql_trail` ###

DROP TABLE IF EXISTS `0_sql_trail`;

CREATE TABLE `0_sql_trail` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `sql` text NOT NULL,
  `result` tinyint(1) NOT NULL,
  `msg` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_sql_trail` ###


### Structure of table `0_stock_category` ###

DROP TABLE IF EXISTS `0_stock_category`;

CREATE TABLE `0_stock_category` (
  `category_id` int(11) NOT NULL AUTO_INCREMENT,
  `description` varchar(60) NOT NULL DEFAULT '',
  `dflt_tax_type` int(11) NOT NULL DEFAULT 1,
  `dflt_units` varchar(20) NOT NULL DEFAULT 'each',
  `dflt_mb_flag` char(1) NOT NULL DEFAULT 'B',
  `dflt_sales_act` varchar(15) NOT NULL DEFAULT '',
  `dflt_cogs_act` varchar(15) NOT NULL DEFAULT '',
  `dflt_inventory_act` varchar(15) NOT NULL DEFAULT '',
  `dflt_adjustment_act` varchar(15) NOT NULL DEFAULT '',
  `dflt_wip_act` varchar(15) NOT NULL DEFAULT '',
  `dflt_dim1` int(11) DEFAULT NULL,
  `dflt_dim2` int(11) DEFAULT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  `dflt_no_sale` tinyint(1) NOT NULL DEFAULT 0,
  `dflt_no_purchase` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`category_id`),
  UNIQUE KEY `description` (`description`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_stock_category` ###

INSERT INTO `0_stock_category` VALUES
('1', 'Components', '1', 'each', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0'),
('2', 'Charges', '1', 'each', 'D', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0'),
('3', 'Systems', '1', 'each', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0'),
('4', 'Services', '1', 'hr', 'D', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0'),
('5', 'Machanical', '1', 'each', 'F', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0'),
('7', 'Bottle', '1', 'each', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0'),
('8', 'Finished Goods', '1', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '1'),
('9', 'Raw Material', '1', 'Pcs', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '1', '0'),
('10', 'Chemicals', '1', 'KG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '1', '0'),
('11', 'Color', '1', 'KG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '1', '0'),
('12', 'Frangrance', '1', 'KG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '1', '0'),
('13', 'Gresae', '1', 'BG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '1', '0'),
('14', 'LPG', '1', 'BG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '1', '0'),
('15', 'WIP', '1', 'LTR', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0'),
('16', 'Stationery Items', '1', 'Pcs', 'B', '4010', '5010', '1510', '3590', '1530', '0', '0', '0', '0', '0');

### Structure of table `0_stock_fa_class` ###

DROP TABLE IF EXISTS `0_stock_fa_class`;

CREATE TABLE `0_stock_fa_class` (
  `fa_class_id` varchar(20) NOT NULL DEFAULT '',
  `parent_id` varchar(20) NOT NULL DEFAULT '',
  `description` varchar(200) NOT NULL DEFAULT '',
  `long_description` tinytext NOT NULL,
  `depreciation_rate` double NOT NULL DEFAULT 0,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`fa_class_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_stock_fa_class` ###

INSERT INTO `0_stock_fa_class` VALUES
('001', '01', 'Equipment', 'Equipment', '10', '0');

### Structure of table `0_stock_master` ###

DROP TABLE IF EXISTS `0_stock_master`;

CREATE TABLE `0_stock_master` (
  `stock_id` varchar(20) NOT NULL DEFAULT '',
  `category_id` int(11) NOT NULL DEFAULT 0,
  `item_group_id` int(11) NOT NULL DEFAULT 0,
  `tax_type_id` int(11) NOT NULL DEFAULT 0,
  `description` varchar(200) NOT NULL DEFAULT '',
  `long_description` tinytext NOT NULL,
  `units` varchar(20) NOT NULL DEFAULT 'each',
  `mb_flag` char(1) NOT NULL DEFAULT 'B',
  `sales_account` varchar(15) NOT NULL DEFAULT '',
  `cogs_account` varchar(15) NOT NULL DEFAULT '',
  `inventory_account` varchar(15) NOT NULL DEFAULT '',
  `adjustment_account` varchar(15) NOT NULL DEFAULT '',
  `wip_account` varchar(15) NOT NULL DEFAULT '',
  `dimension_id` int(11) DEFAULT NULL,
  `dimension2_id` int(11) DEFAULT NULL,
  `purchase_cost` double NOT NULL DEFAULT 0,
  `material_cost` double NOT NULL DEFAULT 0,
  `labour_cost` double NOT NULL DEFAULT 0,
  `overhead_cost` double NOT NULL DEFAULT 0,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  `no_sale` tinyint(1) NOT NULL DEFAULT 0,
  `no_purchase` tinyint(1) NOT NULL DEFAULT 0,
  `editable` tinyint(1) NOT NULL DEFAULT 0,
  `is_cunsumption` int(11) NOT NULL DEFAULT 0,
  `depreciation_method` char(1) NOT NULL DEFAULT 'S',
  `depreciation_rate` double NOT NULL DEFAULT 0,
  `depreciation_factor` double NOT NULL DEFAULT 1,
  `depreciation_start` date NOT NULL DEFAULT '0000-00-00',
  `depreciation_date` date NOT NULL DEFAULT '0000-00-00',
  `fa_class_id` varchar(20) NOT NULL DEFAULT '',
  PRIMARY KEY (`stock_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_stock_master` ###

INSERT INTO `0_stock_master` VALUES
('CM-001', '10', '3', '1', 'Acetic Acid - (1803)', '', 'KG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '220', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('CM-002', '10', '3', '1', 'Addtive A-T-F - (G4500)', '', 'KG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '4700', '1667', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('CM-003', '10', '3', '1', 'Addtive Gear OIL - (7001)', '', 'KG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '5000', '1539', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('CM-004', '10', '3', '1', 'Addtive Gear OIL - (G5100)', '', 'KG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '1731', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('CM-005', '10', '3', '1', 'Ammonia Liqure - (1802)', '', 'KG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '80', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('CM-006', '10', '3', '1', 'Anti Foam - (GLS-025)', '', 'KG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '750', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('CM-007', '10', '3', '1', 'Benzene - (CBN-200)', '', 'KG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '550', '600', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('CM-008', '10', '3', '1', 'Benzyal Alchole - (1400)', '', 'KG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '290', '950', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('CM-009', '10', '3', '1', 'Borex - (1609)', '', 'KG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '450', '320', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('CM-010', '10', '3', '1', 'Butyle Glycol - (BOG-400)', '', 'KG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '490', '520', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('CM-011', '10', '3', '1', 'Castic Soda', '', 'KG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '172', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('CM-012', '10', '3', '1', 'Coper Oxide', '', 'KG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('CM-013', '10', '3', '1', 'Di Etylamine - (DEA-022)', '', 'KG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '400', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('CM-014', '10', '3', '1', 'Die -Etylene Glycol - (1800)', '', 'KG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '235', '300', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('CM-015', '10', '3', '1', 'DOC - (DRC-500)', '', 'KG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '650', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', ''),
('CM-016', '10', '3', '1', 'E-D-T-A - (1608)', '', 'KG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '600', '1050', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('CM-017', '10', '3', '1', 'Gear oil (green) - (1901)', '', 'LTR', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('CM-018', '10', '3', '1', 'H-C-L - (1402)', '', 'KG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('CM-019', '10', '3', '1', 'Hexene - (DCC-800)', '', 'KG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '360', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('CM-020', '10', '3', '1', 'Methanol - (AMT-100)', '', 'KG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '350', '178', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('CM-021', '10', '8', '1', 'Methylene chloride - (CMC-300)', '', 'KG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '2200', '198', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', ''),
('CM-022', '10', '3', '1', 'Mono Ethyl Glycol - (1601)', '', 'KG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '300', '200', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('CM-023', '10', '3', '1', 'Proma - (2001)', '', 'LTR', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '545', '321', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('CM-024', '10', '3', '1', 'Silicon Oil - (1904)', '', 'KG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '1600', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('CM-025', '10', '3', '1', 'Sodium Benoate - (AFR-700)', '', 'KG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '750', '400', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('CM-026', '10', '3', '1', 'Sodium Chloride - (SCL-24)', '', 'KG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '325', '325', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('CM-027', '10', '3', '1', 'Sodium Loyral Ether Sulfate - (STB-200)', '', 'KG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '350', '490', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('CM-028', '10', '3', '1', 'Sulfuric Acid - (SLA-021)', '', 'KG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('CM-029', '10', '3', '1', 'Trichloroethylene - (TBE-001)', '', 'KG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('CM-030', '10', '3', '1', 'White Oil - (WRO-600)', '', 'KG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '350', '434', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('CM-031', '11', '3', '1', 'Color Blue', '', 'KG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('CM-032', '11', '3', '1', 'Colour Green - (1605)', '', 'KG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '2500', '1200', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('CM-033', '11', '3', '1', 'Colour Red - (1704)', '', 'KG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '30000', '6000', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('CM-034', '11', '3', '1', 'Colour Yellow - (1606)', '', 'KG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '1500', '2200', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('CM-035', '12', '3', '1', 'Fragrance Cool Water', '', 'KG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '7500', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('CM-036', '12', '3', '1', 'Fragrance Vanilla - (2400)', '', 'KG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '4100', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('CM-037', '13', '3', '1', 'Golden Grease', '', 'KG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('CM-038', '14', '3', '1', 'LPG - (1209)', '', 'LTR', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '120', '120', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('CM-039', '12', '1', '1', 'Fragrance - Lemon', '', 'KG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '3000', '0', '0', '0', '1', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', ''),
('CM-040', '12', '1', '1', 'Fragrance - Car Fresh', '', 'KG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '7400', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', ''),
('CM-041', '10', '8', '1', 'HCL', '', 'KG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '35', '0', '0', '0', '1', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', ''),
('CM-042', '10', '8', '1', 'Sulphunic Acid', '', 'KG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', ''),
('CM-043', '10', '8', '1', 'BSHVI', '', 'KG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '345.78', '0', '0', '0', '1', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', ''),
('CM-044', '10', '8', '1', 'Gelatin', '', 'KG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '1800', '0', '0', '0', '1', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', ''),
('CM-045', '10', '8', '1', 'CAPB', '', 'KG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', ''),
('CM-046', '11', '11', '1', 'Color - Orange', '', 'KG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', ''),
('CM-047', '12', '10', '1', 'Fragrance - Orange', '', 'KG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '6600', '0', '0', '0', '1', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', ''),
('CM-048', '10', '8', '1', 'Tetra Choloro Ethylene', '', 'KG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '475', '0', '0', '0', '1', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', ''),
('CM-049', '10', '8', '1', 'DEG', '', 'KG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', ''),
('CM-050', '10', '8', '1', 'Water Noraml', '', 'KG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', ''),
('CM-051', '10', '8', '1', 'Water Normal', '', 'KG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '1', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', ''),
('CM-052', '10', '8', '1', 'Base Oil 100 NHVI', '', 'KG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '276.1', '0', '0', '0', '1', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', ''),
('CM-053', '10', '8', '1', 'Base Oil HD-50', '', 'KG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '243', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', ''),
('CM-054', '10', '8', '1', 'Cab-o-Sil', '', 'KG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '1700', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', ''),
('CM-055', '10', '8', '1', 'Carbo Pole', '', 'KG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '3000', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', ''),
('CM-056', '10', '11', '1', 'Colour Apple Green H-9195', '', 'KG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '900', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', ''),
('CM-057', '10', '8', '1', 'Colour Brilliant Blue H-7250', '', 'KG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '6425', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', ''),
('CM-058', '10', '11', '1', 'Colour Orange Red H-9194', '', 'KG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '1900', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', ''),
('CM-059', '10', '11', '1', 'Color Purple ATF', '', 'KG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '30000', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', ''),
('CM-060', '10', '11', '1', 'Color Red ATF', '', 'KG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '6000', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', ''),
('CM-061', '10', '10', '1', 'Fragrance Jasmine', '', 'KG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '3200', '0', '0', '0', '1', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', ''),
('CM-062', '10', '10', '1', 'Fragrance Lavendar', '', 'KG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '5600', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', ''),
('CM-063', '10', '8', '1', 'Gear Oil BSMVI', '', 'KG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '297.06', '0', '0', '0', '1', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', ''),
('CM-064', '10', '8', '1', 'Glycrine', '', 'KG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '400', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', ''),
('CM-065', '10', '8', '1', 'I-P-A', '', 'KG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '400', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', ''),
('CM-066', '10', '8', '1', 'Kerosene Oil', '', 'KG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '300', '0', '0', '0', '1', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', ''),
('CM-067', '10', '8', '1', 'Liquid Bleach', '', 'KG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '70', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', ''),
('CM-069', '10', '8', '1', 'Recycle Oil', '', 'KG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '221', '0', '0', '0', '1', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', ''),
('CM-070', '10', '8', '1', 'Turpene', '', 'KG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '570', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', ''),
('CM-071', '10', '8', '1', 'Zinc Choloride', '', 'KG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '480', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', ''),
('FA-01', '5', '6', '1', 'Generator', 'Generator', 'each', 'F', '4010', '5010', '1510', '5040', '1530', '0', '0', '18000', '18000', '0', '0', '0', '0', '0', '0', '0', 'D', '10', '1', '2022-10-01', '2022-10-01', '001'),
('FG-001', '8', '1', '1', 'Nasa ATF - 1 Ltr', '', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '71300', '430.77', '0', '0', '0', '0', '0', '1', '1', '', '0', '0', '0000-00-00', '0000-00-00', ''),
('FG-002', '8', '2', '1', 'Nasa Battery Mixture - 30 Ltr', '', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '12', '3038.46', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('FG-003', '8', '2', '1', 'Nasa Battery Water - 1.5 Ltr', '', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '43.85', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('FG-004', '8', '2', '1', 'Nasa Battery Water - 20 Ltr', '', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '584.62', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('FG-005', '8', '2', '1', 'Pak Suzuki Battery Water - 600 ml', '', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '33.85', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('FG-006', '8', '2', '1', 'Nasa Battery Water - 600 ml', '', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '10', '33.85', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('FG-007', '8', '4', '1', 'Nasa Brake Cleaner - 450 ml', '', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '284.62', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('FG-008', '8', '1', '1', 'Nasa Brake Fluid - 1 Ltr', '', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '361.54', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('FG-009', '8', '1', '1', 'Nasa Brake Fluid - 355 ml', '', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '146.15', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('FG-010', '8', '5', '1', 'Nasa Car Shampoo - 500 ml', '', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '138.46', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('FG-011', '8', '5', '1', 'Nasa Car Shampoo - 10 Ltr', '', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '2153.85', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('FG-012', '8', '5', '1', 'Nasa Car Shampoo - 20 Ltr', '', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('FG-013', '8', '5', '1', 'Nasa Carb Clean - 300 ml', '', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '169.23', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('FG-014', '8', '5', '1', 'Nasa Carb Clean - 450 ml', '', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '207.69', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('FG-015', '8', '5', '1', 'Nasa Carb Clean - 650 ml', '', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '246.15', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('FG-016', '8', '4', '1', 'Nasa Contact Cleaner - 200 ml', '', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '134.62', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('FG-017', '8', '6', '1', 'Nasa Coolant Blue Regular - 1 Ltr', '', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '119.23', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('FG-018', '8', '6', '1', 'Nasa Coolant Blue Super - 1 Ltr', '', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '238.46', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('FG-019', '8', '6', '1', 'Nasa Coolant Concentrate Green - 1 Ltr', '', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '361.54', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('FG-020', '8', '6', '1', 'Nasa Coolant Concentrate Red - 1 Ltr', '', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '361.54', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('FG-021', '8', '6', '1', 'Nasa Coolant Green Regular - 1 Ltr', '', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '119.23', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('FG-022', '8', '6', '1', 'Nasa Coolant Green Regular - 3 Ltr', '', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '292.31', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('FG-023', '8', '6', '1', 'Nasa Coolant Green Regular - 500 ml', '', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('FG-024', '8', '6', '1', 'Nasa Coolant Green Super - 1 Ltr', '', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '238.46', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('FG-025', '8', '6', '1', 'Nasa Coolant Green Super - 10 Ltr', '', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('FG-026', '8', '6', '1', 'Nasa Coolant Green Super - 20 Ltr ', '', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '3615.38', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('FG-027', '8', '6', '1', 'Nasa Coolant Green Super - 200 Ltr', '', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('FG-028', '8', '6', '1', 'Nasa Coolant Red Regular - 1 Ltr', '', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '119.23', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('FG-029', '8', '6', '1', 'Nasa Coolant Red Super - 1 Ltr ', '', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '238.46', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('FG-030', '8', '6', '1', 'Nasa Coolant Red Super - 3 Ltr ', '', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '630.77', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('FG-031', '8', '6', '1', 'Nasa Coolant Red Super - 2.5 Ltr ', '', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '630.77', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('FG-032', '8', '6', '1', 'Nasa Coolant Red Super - 20 Ltr', '', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('FG-033', '8', '6', '1', 'Nasa Coolant Concentrate - 20 Ltr', '', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('FG-034', '8', '6', '1', 'Nasa Coolant Concentrate - 3 Ltr ', '', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('FG-035', '8', '6', '1', 'Nasa Coolant Concentrate - 30 Ltr', '', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('FG-036', '8', '6', '1', 'Nasa Coolant Concentrate Drum - 200 Ltr', '', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('FG-037', '8', '6', '1', 'Nasa Coolant Green Regular - 200 Ltr', '', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('FG-038', '8', '6', '1', 'Nasa Coolant Green Regular - 20 Ltr', '', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('FG-039', '8', '7', '1', 'Nasa Dashboard &amp; Leather Wax - Car fresh', '', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '207.69', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('FG-040', '8', '7', '1', 'Nasa Dashboard &amp; Leather Wax - Cool water', '', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '207.69', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('FG-041', '8', '7', '1', 'Nasa Dashboard &amp; Leather Wax - lemon', '', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '207.69', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('FG-042', '8', '1', '1', 'Nasa Gear Oil  SAE 80W/90 - 1 Ltr', '', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '357.69', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('FG-043', '8', '1', '1', 'Nasa Gear Oil SAE 85W/140 - 1 Ltr', '', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '384.62', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('FG-044', '8', '4', '1', 'Nasa Glass Cleaner - 500 ml ', '', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '176.92', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('FG-045', '8', '8', '1', 'Nasa Grease Golden', '', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('FG-046', '8', '8', '1', 'Nasa Grease Golden - 500 Gm', '', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '261.54', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('FG-047', '8', '8', '1', 'Nasa Grease Golden - 1 KG', '', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '438.46', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('FG-048', '8', '8', '1', 'Nasa Grease Golden - 3 KG', '', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '1215.38', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('FG-049', '8', '8', '1', 'Nasa Grease Golden - 5 KG', '', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '1961.54', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('FG-050', '8', '8', '1', 'Nasa Grease Golden - 10 KG', '', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '3538.46', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('FG-051', '8', '8', '1', 'Nasa Grease Crystal - 5 KG', '', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('FG-052', '8', '8', '1', 'Nasa Grease Crystal White - 500 Gm', '', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('FG-053', '8', '8', '1', 'Nasa Liquid Grease - 200 ml', '', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '176.92', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('FG-054', '8', '1', '1', 'Nasa Power Steering Fluid - 350 ml', '', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '203.85', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('FG-055', '8', '4', '1', 'Nasa Radiator Cleaner - 1 Ltr', '', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '176.92', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('FG-056', '8', '9', '1', 'Nasa Rustonil - 100 ml', '', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '130.77', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('FG-057', '8', '9', '1', 'Nasa Rustonil - 200 ml', '', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('FG-058', '8', '9', '1', 'Nasa Rustonil - 350 ml', '', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '211.54', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('FG-059', '8', '9', '1', 'Nasa Rustonil - 450 ml', '', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('FG-060', '8', '4', '1', 'Nasa Tune Up - 300 ml', '', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '100', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('FG-061', '8', '10', '1', 'Pak Suzuki Car Care Kit ', '', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('FG-062', '8', '11', '1', 'Cupric Acetate', '', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('FG-063', '8', '4', '1', 'Micro Fibber Cloth', '', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('FG-064', '8', '5', '1', 'Nasa Tune Up - 100 ml', '', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '69.23', '0', '0', '0', '0', '0', '1', '0', '', '0', '0', '0000-00-00', '0000-00-00', ''),
('FG-065', '8', '9', '1', 'Pak Suzuki Glass Cleaneer - 500 ml', '', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '176.92', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', ''),
('FG-066', '8', '6', '1', 'Nasa Grease Pouch - 500 Gm', '', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '226.92', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', ''),
('FG-067', '8', '6', '1', 'Nasa Grease Food Grade - 500 Gm', '', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '2307.69', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', ''),
('FG-068', '8', '3', '1', 'Nasa Coolant Green Regular - 10 Ltr', '', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '746.15', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', ''),
('FG-069', '8', '3', '1', 'Nasa Coolant Green Regular - 20 Ltr', '', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '1407.69', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', ''),
('FG-070', '8', '1', '1', 'Nasa ATF - 20 Ltr', '', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '8153.85', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', ''),
('RM-001', '9', '12', '1', 'Can Rusto Nil RN-100 (100ml x 240)', '', 'Pcs', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('RM-002', '9', '12', '1', 'Can Rusto Nil RN-100 (350ml x 80)', '', 'Pcs', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('RM-003', '9', '14', '1', 'Plastic Bottle Brake Fluid (355ml x 72)', '', 'Pcs', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '60', '24', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('RM-004', '9', '12', '1', 'Can Carb Clean - (300ml x 172)', '', 'Pcs', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '60', '42', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('RM-005', '9', '12', '1', 'Can Carb Clean - (450ml x 80)', '', 'Pcs', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '47.087206621152', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('RM-006', '9', '12', '1', 'Can Carb Clean - (650ml x 80) 400 gm', '', 'Pcs', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '43', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('RM-007', '9', '12', '1', 'Can Carb Chowk Cleaner - (300ml x 96)', '', 'Pcs', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '43.44', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('RM-008', '9', '12', '1', 'Can Brake Cleaner - 450 ml', '', 'Pcs', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '52', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('RM-009', '9', '12', '1', 'Can Contact Cleaner - (200ml x 144)', '', 'Pcs', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('RM-010', '9', '12', '1', 'Can Nasa Liquid Grease - 200 ml', '', 'Pcs', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', ''),
('RM-011', '9', '12', '1', 'Aerosol Tin - (450ml x 80) W/o Print