<?php
/**********************************************************************
  Copyright (C) FrontAccounting, LLC.
  Released under the terms of the GNU General Public License, GPL, 
  as published by the Free Software Foundation, either version 3 
  of the License, or (at your option) any later version.
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
  See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
 ***********************************************************************/

function next_depreciation_date($depreciation_date) {

  $start = strtotime($depreciation_date);

  $y = date('Y', $start);
  $m = date('n', $start) + 1;
// display_error($y." = ".$m." == ".$depreciation_date);

  if ($m > 12) {
    $m = 1;
    $y++;
  }

  return strtotime("$y-$m-1");
}

function depreciation_months($depreciation_start) {

  // assume that depreciation start is the same fiscal year
  //$start = strtotime($depreciation_start);
  //$end = strtotime($year['end']);

  $start = next_depreciation_date($depreciation_start);

  return   date('n', $start)-date('n', strtotime($depreciation_start));

  //$d1 = date('j', $start); // day of the month
  //$d2 = date('t', $start); // number of days in month

  //if ($d2 > $d1)
    //$months++;
}

function months_between_dates($start, $end) {
  $start = strtotime($start);
  $end = strtotime($end);

  $y1 = date('Y', $start);
  $m1 = date('n', $start);

  $y2 = date('Y', $end);
  $m2 = date('n', $end);

  return 12 * ($y2 - $y1) + $m2 - $m1;
}

function compute_gl_rows_for_depreciation($item, $no_months, $period) {
  $rows = array();

  $year = get_current_fiscalyear();
  $y = date('Y', strtotime($year['end']));

  switch ($item['depreciation_method']) {
	case 'D':
		$line_value = $item['purchase_cost']*$item['depreciation_rate']/100/12;
		$value = $item['material_cost'] * $item['depreciation_rate'] * $item['depreciation_factor']/100/12;
		if ($value < $line_value)
			$value = $line_value;
		break;

    case 'S':	// purchase_cost stores start cost of item
		$done_months = months_between_dates($item['depreciation_start'], $item['depreciation_date']);
		$remaining_months = 12.0 * 100.0/$item['depreciation_rate'] - $done_months;
		$value = $item['purchase_cost']*$item['depreciation_rate']/100/12;
		break;

	case 'N':
		$N = $item['depreciation_rate'];
		$done_years = months_between_dates($item['depreciation_start'], $item['depreciation_date'])/12;
		$value = $item['purchase_cost']* ($N-$done_years)/($N*($N+1)/2)/12;
		break;

    case 'O':
		$value = $item['material_cost'];
		break;
  }

  $next = next_depreciation_date($item['depreciation_date']);
  $m = date('n', $next);

  $total = 0;
  $cnt = 0;
  for ($i=$m; $i < $m + $no_months; $i++) {

	if ($item['depreciation_method'] == 'S') {
		if ($cnt >= $remaining_months)
			$value = 0;
	}

    $date = sql2date(date("$y-$i-t", strtotime("$y-$i-1")));

    $total += $value;

    if (FA_YEARLY == $period) {
      // yearly
      if ($i == $m + $no_months - 1)
        $rows[] = array('date' => $date, 'value' => $total , 'stock_id' => $item['stock_id'] );
      /*else
        $rows[] = array('date' => $date, 'value' => 0);
        */
    }
    else {
      // monthly
      $rows[] = array('date' => $date, 'value' => $value , 'stock_id' => $item['stock_id']);
    }

    $cnt++;

	if ($item['depreciation_method'] == 'O') {
		// depreciate only in the first month
		$value = 0;
	}
 }

  return $rows;
}


function all_compute_gl_rows_for_depreciation( $no_months, $period,$dep_date='') {
  $rows = array();


  $year = get_current_fiscalyear();
  $y = date('Y', strtotime($year['end']));


  $res = get_all_depreciation_item_days($dep_date);
while ($stk_item =db_fetch($res)) {
  // echo "<pre>";
  // print_r($stk_item);

  $item=get_item($stk_item['stock_id']);
  # code...
  $item_dep_date=($item['depreciation_date']!='0000-00-00') ? $item['depreciation_date'] : $item['depreciation_start'];
  $date1=sql2date($item_dep_date);
  $date2=$dep_date;
  


   $days=date_diff2($date2, $date1, 'd') ;
   if($days<=0)
    continue;
    
      $purchase = get_fixed_asset_purchase($stk_item['stock_id']);
    $d = sql2date($purchase['tran_date']);
    if (date1_greater_date2($d, $date2))
      continue;
   // display_error( $date1." == ". $date2." == ".$days." ==== ".$stk_item['stock_id']);

  switch ($item['depreciation_method']) {
  case 'D':

  // display_error($stk_item['stock_id']." ".$item['depreciation_date']);
    // $line_value = $item['purchase_cost']*$item['depreciation_rate']/100/12;
    // $value = $item['material_cost'] * $item['depreciation_rate'] * $item['depreciation_factor']/100/12;
      // $line_value = (($item['purchase_cost']*$item['depreciation_rate'])/100/365) * $days ;
      // display_error($item['material_cost']);
    $value = (( $item['material_cost'] * $item['depreciation_rate'] * $item['depreciation_factor'])/100/365) * $days;
    // if ($value < $line_value)
    //   $value = $line_value;
    break;

    case 'S': // purchase_cost stores start cost of item
    $done_months = months_between_dates($item['depreciation_start'], $item['depreciation_date']);
    $remaining_months = 12.0 * 100.0/$item['depreciation_rate'] - $done_months;
    $value = $item['purchase_cost']*$item['depreciation_rate']/100/12;
    break;

  case 'N':
    $N = $item['depreciation_rate'];
    $done_years = months_between_dates($item['depreciation_start'], $item['depreciation_date'])/12;
    $value = $item['purchase_cost']* ($N-$done_years)/($N*($N+1)/2)/12;
    break;

    case 'O':
    $value = $item['material_cost'];
    break;
  }

  $next = next_depreciation_date($item['depreciation_date']);
  $m = date('n', $next);

  $total = 0;
  $cnt = 0;
  // for ($i=$m; $i < $m + $no_months; $i++) {

  if ($item['depreciation_method'] == 'S') {
    if ($cnt >= $remaining_months)
      $value = 0;
  }

    $date = sql2date(date("$y-$i-t", strtotime("$y-$i-1")));

    $total += $value;

    if (FA_YEARLY == $period) {
      // yearly
      if ($i == $m + $no_months - 1)
        $rows[] = array('date' => $date, 'value' => $total , 'stock_id' => $item['stock_id'] , 'description' => $item['description']   );
      /*else
        $rows[] = array('date' => $date, 'value' => 0);
        */
    }
    else {
      // monthly
      $rows[] = array('date' => $date, 'days' => $days ,  'value' => $value , 'stock_id' => $item['stock_id']  , 'description' => $item['description'] );
    }

    $cnt++;

  if ($item['depreciation_method'] == 'O') {
    // depreciate only in the first month
    $value = 0;
  }
 // }

}
  return $rows;
}



function get_all_depreciation_item(){

$year = get_current_fiscalyear();
  $begin = date2sql(add_months(sql2date($year['begin']), -1));
  $end = date2sql(add_months(sql2date($year['end']), -1));


$sql = "SELECT stock_id, s.description, c.description, s.inactive, s.editable FROM 0_stock_master s,0_stock_category c WHERE s.category_id=c.category_id AND s.category_id IN (".$_SESSION['wa_current_user']->item_category.") AND mb_flag='F' AND stock_id IN ( SELECT stock_id FROM 0_stock_moves WHERE (type=25 OR (type=17 AND qty>0) ) AND qty!=0 ) AND stock_id NOT IN ( SELECT stock_id FROM 0_stock_moves WHERE (type=13 OR (type=17 AND qty<0) ) AND qty!=0 ) AND depreciation_date <= '".$end."' AND depreciation_date >= '".$begin."' AND material_cost > 0 AND mb_flag='F'";

return db_query($sql);

}

function get_all_depreciation_item_days($date){

$year = get_current_fiscalyear();
  $begin = date2sql(add_months(sql2date($year['begin']), -1));
//   $end = date2sql(add_months(sql2date($year['end']), -1));

    // $begin = date2sql($date);
  $end = date2sql($date);



$sql = "SELECT stock_id, s.description, c.description, s.inactive, s.editable FROM 0_stock_master s,0_stock_category c WHERE s.category_id=c.category_id AND s.category_id IN (".$_SESSION['wa_current_user']->item_category.") AND mb_flag='F' AND stock_id IN ( SELECT stock_id FROM 0_stock_moves WHERE (type=25 OR (type=17 AND qty>0) ) AND qty!=0 ) AND stock_id NOT IN ( SELECT stock_id FROM 0_stock_moves WHERE (type=13 OR (type=17 AND qty<0) ) AND qty!=0 ) AND depreciation_date <= '".$end."' AND depreciation_date >= '".$begin."' AND material_cost > 0 AND mb_flag='F'";
// display_error($sql);
return db_query($sql);

}