<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/

function add_dollar_booking($booking_date='', $customer='', $receiving_date='', $due_date='',
	$amount=0, $currency='', $exchange_rate=0, $total_amount=0, $gl_account='', $bank_account='',
	$deduction=0, $deduction_gl_account='', $gain_loss_acc='')
{
	$sql = "INSERT INTO ".TB_PREF."dollar_booking (booking_date, customer, receiving_date, due_date,
	amount, currency, exchange_rate, total_amount, gl_account, bank_account, deduction, 
	deduction_gl_account, gain_loss_acc) VALUES ('".date2sql($booking_date) . "', ".db_escape($customer) . ", '".date2sql($receiving_date) . "',
	'".date2sql($due_date) . "',  ".db_escape($amount) . ",  ".db_escape($currency) . ",  
	".db_escape($exchange_rate) . ", ".db_escape($total_amount) . ", ".db_escape($gl_account) . ", 
	".db_escape($bank_account) . ", ".db_escape($deduction) . ", ".db_escape($deduction_gl_account) . ", ".db_escape($gain_loss_acc) . ")";
   	db_query($sql,"The dollar booking could not be added");
    $dollar_booking_id = db_insert_id();
    return $dollar_booking_id;
}

function update_dollar_booking($selected_id, $booking_date='', $customer='', $receiving_date='', 
	$due_date='', $amount=0, $currency='', $exchange_rate=0, $total_amount=0, $gl_account='', 
	$bank_account='', $deduction=0, $deduction_gl_account='', $gain_loss_acc='')
{
	$sql = "UPDATE ".TB_PREF."dollar_booking SET booking_date='".date2sql($booking_date)."',
		customer=".db_escape($customer).", receiving_date='".date2sql($receiving_date)."',
		due_date='".date2sql($due_date)."', amount=".db_escape($amount).",
		currency=".db_escape($currency).", exchange_rate=".db_escape($exchange_rate).",
		total_amount=".db_escape($total_amount).", gl_account=".db_escape($gl_account).",
		bank_account=".db_escape($bank_account).", deduction=".db_escape($deduction).", 
		deduction_gl_account=".db_escape($deduction_gl_account).", 
		gain_loss_acc=".db_escape($gain_loss_acc)."
		WHERE id = ".db_escape($selected_id);
   	db_query($sql,"The dollar booking could not be updated");
}

function delete_dollar_booking($selected_id)
{
	$sql="DELETE FROM ".TB_PREF."dollar_booking WHERE id=".db_escape($selected_id);
	db_query($sql,"could not delete dollar booking");
}

function get_dollar_bookings($show_inactive)
{
	$sql = "SELECT * FROM ".TB_PREF."dollar_booking";
	if (!$show_inactive) $sql .= " WHERE !inactive";
	return db_query($sql,"could not get dollar booking");
}

function get_dollar_booking($selected_id)
{
	$sql = "SELECT * FROM ".TB_PREF."dollar_booking WHERE id=".db_escape($selected_id);
	$result = db_query($sql,"could not get dollar booking");
	return db_fetch($result);
}

function get_dollar_booking_name($id)
{
	$sql = "SELECT name FROM ".TB_PREF."dollar_booking WHERE id=".db_escape($id);
	$result = db_query($sql, "could not get dollar booking");
	$row = db_fetch_row($result);
	return is_array($row) ? $row[0] : false;
}

function get_dollar_booking_inquiry($customer_id='')
{
	$sql = "SELECT 
			id,
			booking_date,
			customer,
			receiving_date,
			due_date,
			total_amount,
			receiving_status,
			due_date_receiving_status
	 FROM ".TB_PREF."dollar_booking WHERE id";

	// if($due_date != "")
	// 	$sql .= " AND due_date = '" . date2sql($due_date) . "'";
	if($customer_id != '')
		$sql .= " AND customer=".db_escape($customer_id);
	return $sql;
}

function update_receiving_status($dollar_booking_id)
{
	$sql = "UPDATE ".TB_PREF."dollar_booking SET receiving_status = 1 WHERE id = ".db_escape($dollar_booking_id);
   	db_query($sql,"The sales group could not be updated");
}

function update_due_date_receiving_status($dollar_booking_id)
{
	$sql = "UPDATE ".TB_PREF."dollar_booking SET due_date_receiving_status = 1 WHERE id = ".db_escape($dollar_booking_id);
   	db_query($sql,"The sales group could not be updated");
}

function update_jounral_entry_no($journal_entry_no, $dollar_booking_id)
{
	$sql = "UPDATE ".TB_PREF."dollar_booking SET journal_entry_no=".db_escape($journal_entry_no)." WHERE id = ".db_escape($dollar_booking_id);
   	db_query($sql,"The sales group could not be updated");
}

function update_due_date_jounral_entry_no($journal_entry_no, $dollar_booking_id)
{
	$sql = "UPDATE ".TB_PREF."dollar_booking SET due_date_journal_entry_no=".db_escape($journal_entry_no)." WHERE id = ".db_escape($dollar_booking_id);
   	db_query($sql,"The sales group could not be updated");
}