<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_DOLLAR_BOOKING';
$path_to_root="../..";
include_once($path_to_root . "/includes/db_pager.inc");
include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/sales/includes/sales_ui.inc");
include_once($path_to_root . "/reporting/includes/reporting.inc");
include_once($path_to_root . "/gl/includes/db/dollar_booking_db.inc");

$js = "";
if ($SysPrefs->use_popup_windows)
	$js .= get_js_open_window(900, 500);
if (user_use_date_picker())
	$js .= get_js_date_picker();
page(_($help_context = "Dollar Booking Inquiry"), false, false, "", $js);

//---------------------------------------------------------------------------------------------

function trans_view($row)
{
	return viewer_link($row['id'] , '/gl/view/dollar_booking_view.php?dollar_booking_id='.$row['id']);
}
	
function customer_name($row)
{
	if($row['customer'])
	return get_customer_name($row['customer']);
	else
	return 'No Customer';
}
	
function receiving_journal_entry($row)
{
	if($row['receiving_status'] != 1)
	return pager_link(_("Receiving Journal Entry"),
			"/gl/gl_journal.php?NewJournal=Yes&dollar_booking_id=" .$row["id"], ICON_RECEIVE);
	else
	return '-';
}

function due_date_journal_entry($row)
{
	if($row['receiving_status'] == 1 && $row['due_date_receiving_status'] != 1)
	return pager_link(_("Due Date Journal Entry"),
			"/gl/gl_journal.php?NewJournal=Yes&due_dollar_booking_id=" .$row["id"], ICON_RECEIVE);
	else
	return '-';
}

function edit_link($row)
{
	if($row['receiving_status'] != 1)
	return pager_link(_("Edit"),
			"/gl/manage/dollar_booking.php?dollar_booking_id=" .$row["id"], ICON_EDIT);
	else
	return '-';
}

function delete_link($row)
{
	if($row['receiving_status'] != 1)
	return  button("Delete".$row['id'], _("Delete"), _('Remove dollar booking'), ICON_DELETE);
	else
	return '-';
}

//-----------------------------------------------------------------------------------
// Ajax updates
//
if (get_post('SearchOrders')) 
{
	$Ajax->activate('orders_tbl');
	$Ajax->addDisable(true, 'due_date');
	$Ajax->addDisable(true, 'customer_id');
}

//---------------------------------------------------------------------------------------------

start_form();

$id = find_submit('Delete');
if ($id!=-1){

	delete_dollar_booking($id);
	display_notification(_('Selected dollar booking has been deleted'));
	$Ajax->activate('orders_tbl');
}

start_table(TABLESTYLE_NOBORDER);
start_row();
// date_cells(_("Due Date:"), 'due_date');
customer_list_cells(_("Select a customer: "), 'customer_id', null, true, true);
submit_cells('SearchOrders', _("Search"),'',_('Select documents'), 'default');
end_row();
end_table();

if (get_post('SearchOrders'))
{
	$Ajax->activate('_page_body');
	$Ajax->activate('totals_tbl');
}
//---------------------------------------------------------------------------------------------

$sql = get_dollar_booking_inquiry(get_post('customer_id')); //get_post('due_date'), 

$cols = array(
		_("Dollar Booking #") => array('fun'=>'trans_view', 'ord'=>'', 'align'=>'center'), 
		_("Booking Date") => array('name'=>'booking_date', 'type'=>'date', 'ord'=>'desc'),
		_("Customer") => array('fun'=>'customer_name', 'ord'=>'', 'align'=>'center'), 
		_("Receiving Date") => array('name'=>'receiving_date', 'type'=>'date', 'ord'=>'desc'),
		_("Due Date") => array('name'=>'due_date', 'type'=>'date', 'ord'=>'desc'),
		_("Total Amount") => array('align'=>'center'), 
		_("Receiving Journal Entry") => array('fun'=>'receiving_journal_entry', 'ord'=>'', 'align'=>'center'), 
		_("Due Date Journal Entry") => array('fun'=>'due_date_journal_entry', 'ord'=>'', 'align'=>'center'), 
		_("Edit") => array('fun'=>'edit_link', 'ord'=>'', 'align'=>'center'), 
		_("Delete") => array('fun'=>'delete_link', 'ord'=>'', 'align'=>'center'), 
);

//---------------------------------------------------------------------------------------------------

$table =& new_db_pager('orders_tbl', $sql, $cols);

$table->width = "80%";

display_db_pager($table);

end_form();
end_page();
