<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_CANCEL_CHEQUE';
$path_to_root = "../..";
include($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/gl/includes/db/cancel_cheque_db.inc");

page(_($help_context = "Cancel Cheque No"));

include($path_to_root . "/includes/ui.inc");

simple_page_mode(true);

if ($Mode=='ADD_ITEM' || $Mode=='UPDATE_ITEM') 
{

	$input_error = 0;

	if (strlen($_POST['cheque_no']) == 0) 
	{
		$input_error = 1;
		display_error(_("The cheque no cannot be empty."));
		set_focus('cheque_no');
	}

	// $duplicate = duplicate_item_brand($_POST['brand']);
	// if ($duplicate != 0) {
	// 	$input_error = 1;
	// 	display_error(_("The brand cannot be add cuz duplicate."));
	// 	set_focus('brand');
	// }

	if ($input_error != 1)
	{
    	if ($selected_id != -1) 
    	{
    		update_cheque($selected_id, $_POST['account_type_id'], $_POST['bank_id'], $_POST['cheque_no']);
			$note = _('Selected cheque no has been updated');
    	} 
    	else 
    	{
    		// display_error($_POST['name']);
    		cancel_cheque($_POST['account_type_id'], $_POST['bank_id'], $_POST['cheque_no']);
			$note = _('New cheque no has been added');
    	}
    
		display_notification($note);    	
		$Mode = 'RESET';
	}
}

//----------------------------------------------------------------------------------

if ($Mode == 'Delete')
{

	// PREVENT DELETES IF DEPENDENT RECORDS IN 'stock_master'

	// if (item_unit_used($selected_id))
	// {
	// 	display_error(_("Cannot delete this unit of measure because items have been created using this unit."));

	// }
	// else
	// {
		delete_cheque($selected_id);
		display_notification(_('Selected unit has been deleted'));
	// }
	$Mode = 'RESET';
}

if ($Mode == 'RESET')
{
	$selected_id = -1;
	$sav = get_post('show_inactive');
	unset($_POST);
	$_POST['show_inactive'] = $sav;
}

//----------------------------------------------------------------------------------
start_form();
start_table(TABLESTYLE, "width='40%'");
bank_accounts_list_cells(_("Bank Account:"), 'bank_id', null, true,false,1);
end_table(1);

$result = get_cheque_num(check_value('show_inactive'), $_POST['bank_id']);
start_table(TABLESTYLE, "width='40%'");
$th = array(_('Bank Account'), _('Cheque No'), _('User'), _('Cancel Date')); //_('Account Type'), 
inactive_control_column($th);

table_header($th);
$k = 0; //row colour counter

while ($myrow = db_fetch($result))
{

	alt_table_row_color($k);
	// $bankacc = get_bank_account($myrow['bank_account_id']);
	// print_r($bankacc);
	// label_cell($bankacc['account_type']);
	label_cell(get_bank_account_name($myrow["bank_account_id"]));
	label_cell($myrow["cheque_no"]);
	$data = get_user($myrow["user_id"]);
	label_cell($data['real_name']);
	label_cell($myrow["currentdate"]);
	inactive_control_cell($myrow["id"], $myrow["inactive"], 'cancel_cheque', 'id');
 	// edit_button_cell("Edit".$myrow["id"], _("Edit"));
 	// delete_button_cell("Delete".$myrow["id"], _("Delete"));
	end_row();
}

inactive_control_row($th);
end_table(1);

//----------------------------------------------------------------------------------

start_table(TABLESTYLE2);

if ($selected_id != -1) 
{
 	if ($Mode == 'Edit') {
		//editing an existing item category

		$myrow = get_cheque($selected_id);

		$_POST['account_type_id'] = $myrow["account_type_id"];
		$_POST['bank_id'] = $myrow["bank_account_id"];
		$_POST['cheque_no'] = $myrow["cheque_no"];
	}
	hidden('selected_id', $myrow["id"]);
}

    // text_row(_("Brand Name:"), 'brand', null, 30, 70);
// $_SESSION["wa_current_user"]->user
		display_heading("This section cancelled selected Bank Cheque Serial #");
		echo '<br>';
    	// bank_account_types_list_row(_("Account Type:"), 'account_type_id', null,true);
    	hidden('account_type_id',1);
		// bank_accounts_list_row(_("Bank Account:"), 'bank_id', null, true,false, 1);
		// text_row_ex(_("Cheque No:"), 'cheque_no', 20, null, null, null, null, null, true);
		bank_serial_row(_("Cheque No:"), 'cheque_no', null , true, $_POST['bank_id']);

end_table(1);

submit_add_or_update_center($selected_id == -1, '', 'both');

end_form();

end_page();

