<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
    Released under the terms of the GNU General Public License, GPL, 
    as published by the Free Software Foundation, either version 3 
    of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_DOLLAR_BOOKING';
$path_to_root = "../..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/gl/includes/db/dollar_booking_db.inc");
include_once($path_to_root . "/includes/ui.inc");

$js = "";
if ($SysPrefs->use_popup_windows)
    $js .= get_js_open_window(900, 500);
if (user_use_date_picker())
    $js .= get_js_date_picker();
page(_($help_context = "Dollar Booking"), false, false, "", $js);

//---------------------------------------------------------------------------------------
if (isset($_GET['dollar_booking_id']))
{
    $selected_id = $_GET['dollar_booking_id'];
} 
elseif(isset($_POST['selected_id']))
{
    $selected_id = $_POST['selected_id'];
}
else
    $selected_id = -1;

//---------------------------------------------------------------------------------------

if (isset($_GET['AddedID']))
{
    $id = $_GET['AddedID'];

    display_notification_centered(_("The dollar booking been added."));

    echo '<div style="margin-left: 45.5%;">' . viewer_link(_("View this dollar booking"), '/gl/view/dollar_booking_view.php?dollar_booking_id=' . $id) . '</div>';
     hyperlink_no_params($path_to_root."/gl/inquiry/dollar_booking_inquiry.php", _("Dollar Booking Inquiry"));
    hyperlink_no_params("", _("Enter a dollar booking"));
    display_footer_exit();
}

//---------------------------------------------------------------------------------------

if (isset($_GET['UpdatedID']))
{
    $id = $_GET['UpdatedID'];
    echo '<div style="margin-left: 45.5%;">' . viewer_link(_("View this dollar booking"), '/gl/view/dollar_booking_view.php?dollar_booking_id=' . $id) . '</div>';
     hyperlink_no_params($path_to_root."/gl/inquiry/dollar_booking_inquiry.php", _("Dollar Booking Inquiry"));
    display_notification_centered(_("The dollar booking been updated."));
    display_footer_exit();
}

//-------------------------------------------------------------------------------------

if (isset($_POST['ADD_ITEM']))
{
    $id = add_dollar_booking($_POST['booking_date'], input_num('customer'), $_POST['receiving_date'],
    		$_POST['due_date'], input_num('amount'), $_POST['currency'], input_num('exchange_rate'),
    		input_num('total_amount'), $_POST['gl_account'], $_POST['bank_account'], input_num('deduction'),
    		$_POST['deduction_gl_account'],$_POST['gain_loss_acc']);
    meta_forward($_SERVER['PHP_SELF'], "AddedID=$id");
}

//-------------------------------------------------------------------------------------

if (isset($_POST['UPDATE_ITEM']))
{

    update_dollar_booking($selected_id, $_POST['booking_date'], input_num('customer'), 
    			$_POST['receiving_date'], $_POST['due_date'], input_num('amount'), 
    			$_POST['currency'], input_num('exchange_rate'), input_num('total_amount'), 
    			$_POST['gl_account'], $_POST['bank_account'], input_num('deduction'), 
    			$_POST['deduction_gl_account'],$_POST['gain_loss_acc']);
    meta_forward($_SERVER['PHP_SELF'], "UpdatedID=$selected_id");
}

//-------------------------------------------------------------------------------------
if (get_post('_type_update')) 
{
  $Ajax->activate('_page_body');
}
//-------------------------------------------------------------------------------------

start_form();
start_table(TABLESTYLE2);

if ($selected_id != -1)
{
    $myrow = get_dollar_booking($selected_id);

    $_POST['booking_date'] = sql2date($myrow["booking_date"]);
    $_POST['customer'] = $myrow["customer"];
    $_POST['receiving_date'] = sql2date($myrow["receiving_date"]);
    $_POST['due_date'] = sql2date($myrow["due_date"]);
    if(!isset($_POST['amount']))
    $_POST['amount'] = $myrow["amount"];
    $_POST['currency'] = $myrow["currency"];
    if(!isset($_POST['exchange_rate']))
    $_POST['exchange_rate'] = $myrow['exchange_rate'];
    $_POST['total_amount'] = $myrow['total_amount'];
    if(!isset($_POST['gl_account']))
    $_POST['gl_account'] = $myrow['gl_account'];
    if(!isset($_POST['bank_account']))
    $_POST['bank_account'] = $myrow['bank_account'];
    if(!isset($_POST['deduction_gl_account']))
    $_POST['deduction_gl_account'] = $myrow['deduction_gl_account'];
    $_POST['deduction'] = $myrow['deduction'];
    hidden('selected_id', $selected_id);
} 

br();

date_row(_("Booking Date:"), 'booking_date');
customer_list_row(_("Customer:"), 'customer', null, false, true, false, true);
date_row(_("Receiving Date:"), 'receiving_date');
date_row(_("Due Date:"), 'due_date');
amount_row(_("Amount:"), 'amount', price_format($_POST['amount']), null, null, null, true);
    // amount_row(_("Credit Limit:"), 'credit_limit', $_POST['credit_limit']);
if(!isset($_POST['currency']))
	$_POST['currency'] = 'USD';
currencies_list_row(_("Currency:"), 'currency');
amount_row(_("Exchange Rate:"), 'exchange_rate', null, null, null, null, true);
if(input_changed('amount') || input_changed('exchange_rate'))
$_POST['total_amount'] = input_num('amount')*input_num('exchange_rate');

// display_error($_POST['total_amount']); $_POST['currency']
amount_row(_("Total Amount  :"), 'total_amount',null);
$_POST['gl_account']=get_company_pref('dollar_book_acc');
echo gl_all_accounts_list('gl_account', null, false, true, _('[Select dollar booking account]'), true, false, false);
bank_accounts_list_row(_("Bank Account:"), 'bank_account', null, true);
$_POST['deduction_gl_account']=get_company_pref('dollar_decduc_acc');
echo gl_all_accounts_list('deduction_gl_account', null, false, true, _('[Select deduction account]'), true, false, false);
// amount_row(_("Deduction Amount:"), 'deduction');

    percent_row(_("Deduction Percent:"), 'deduction', $_POST['deduction']);
    // print_r(get_company_pref());
$_POST['gain_loss_acc']=get_company_pref('dollar_gain_loss_acc');
 echo gl_all_accounts_list('gain_loss_acc', null, false, true, _('[Gain / Loss account]'), true, false, false);

end_table(1);

if ($selected_id != -1)
{
    echo "<table align=center><tr>";
    submit_cells('UPDATE_ITEM', _("Update Dollar Booking"), '', _('Save changes to job order'), 'default');
    echo "</tr></table>";
}
else
{
    submit_center('ADD_ITEM', _("Add Dollar Booking"), true, '', 'default');
}
  $Ajax->activate('_page_body');

end_form();
end_page();


?>

