<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
    Released under the terms of the GNU General Public License, GPL, 
    as published by the Free Software Foundation, either version 3 
    of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_DOLLAR_BOOKING';
$path_to_root = "../..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/includes/ui.inc");
include_once($path_to_root . "/gl/includes/db/dollar_booking_db.inc");

$js = "";
if ($SysPrefs->use_popup_windows)
    $js .= get_js_open_window(800, 500);
page(_($help_context = "View Dollar Booking"), true, false, "", $js);

//-------------------------------------------------------------------------------------------------
$dollar_booking_id = 0;
if ($_GET['dollar_booking_id'] != "")
{
    $dollar_booking_id = $_GET['dollar_booking_id'];
}

display_heading(_("Dollar Booking") . " # " . $dollar_booking_id);

$myrow = get_dollar_booking($dollar_booking_id);
$gl_account_name = get_gl_account_info($myrow['gl_account']);
$data = db_fetch($gl_account_name);
$gl_account_name2 = get_gl_account_info($myrow['deduction_gl_account']);
$data2 = db_fetch($gl_account_name2);
br();
start_table(TABLESTYLE2, "width='50%'");
start_row();
label_row(_("Booking Date: "), sql2date($myrow['booking_date']), "class='tableheader2'");
label_row(_("Customer: "), $myrow['customer'] ? get_customer_name($myrow['customer']) : '-', "class='tableheader2'");
label_row(_("Receiving Date: "), sql2date($myrow['receiving_date']), "class='tableheader2'");
label_row(_("Due Date: "), sql2date($myrow['due_date']), "class='tableheader2'");
label_row(_("Amount: "), $myrow['amount'], "class='tableheader2'");
label_row(_("Currency: "), $myrow['currency'], "class='tableheader2'");
label_row(_("Exchange Rate: "), $myrow['exchange_rate'], "class='tableheader2'");
label_row(_("Total Amount: "), $myrow['total_amount'], "class='tableheader2'");
label_row(_("GL Dollar Booking Account: "), $data['account_name'], "class='tableheader2'");
label_row(_("Bank Account: "), get_bank_account_name($myrow['bank_account']), "class='tableheader2'");
label_row(_("GL Deduction Account: "), $data2['account_name'], "class='tableheader2'");
label_row(_("Deduction Amount: "), $myrow['deduction'], "class='tableheader2'");

end_row();
end_table();

br();

start_table(TABLESTYLE2, "width='95%'", 5);
$result = get_gl_trans(ST_JOURNAL, $myrow['journal_entry_no']);
if ($myrow['journal_entry_no']) {
    echo "<tr valign=top><td>";
    display_heading("Receiving Journal Entry");
       echo "</td><td>";
    display_heading("Paid Journal Entry");
    echo "</td></tr>";

    echo "<tr valign=top><td>";
    start_table(TABLESTYLE, "width='50%'");
    $th = array(_("#"),_("Reference"),_("Journal Date"), _("Account Code"), _("Account Name"),  _("Debit"), _("Credit"), _("Memo"));
    table_header($th);
    while ($myrow2 = db_fetch($result)) 
    {
        // print_r($myrow2);
        // display_error($myrow2["type"].", ".$myrow2["type_no"]);
        label_cell(get_trans_view_str($myrow2["type"], $myrow2["type_no"]));
        label_cell($myrow2['reference']); 
        label_cell(sql2date($myrow2['tran_date']));
        label_cell($myrow2['account']);
        label_cell($myrow2['account_name']);
        display_debit_or_credit_cells($myrow2['amount']);
        label_cell($myrow2['memo_']);
        end_row();
        if ($myrow2['amount'] > 0 ) 
        $debit += $myrow2['amount'];
        else 
        $credit += $myrow2['amount'];
        $ex_change_rate = $myrow2['rate'];
    }
    label_cell(_("Total"), "colspan=3");
    amount_cell($debit);
    amount_cell(-$credit);
    label_cell('');
    start_row();
    label_cell(_("Exchange Rate"), null);
    amount_cell($ex_change_rate);
    end_row();
    end_table();
}

$result2 = get_gl_trans(ST_JOURNAL, $myrow['due_date_journal_entry_no']);
if ($myrow['due_date_journal_entry_no']) {

    echo "</td><td valign='top'>";
    start_table(TABLESTYLE, "width='50%'");
    $th = array(_("#"),_("Reference"),_("Journal Date"), _("Account Code"), _("Account Name"),  _("Debit"), _("Credit"), _("Memo"));
    table_header($th);
    while ($myrow3 = db_fetch($result2)) 
    {
          label_cell(get_trans_view_str($myrow3["type"], $myrow3["type_no"]));
        label_cell($myrow3['reference']); 
        label_cell(sql2date($myrow3['tran_date']));
        label_cell($myrow3['account']);
        label_cell($myrow3['account_name']);
        display_debit_or_credit_cells($myrow3['amount']);
    label_cell((str_word_count(strip_tags($myrow3['memo_']), 0) > 2) ? implode(' ', array_slice(str_word_count(strip_tags($myrow3['memo_']), 1), 0, 2)) . '...' : $myrow3['memo_']);

        end_row();
        if ($myrow3['amount'] > 0 ) 
        $debit2 += $myrow3['amount'];
        else 
        $credit2 += $myrow3['amount'];
        $ex_change_rate2 = $myrow3['rate'];
    }
    // label_cell(_("Total"), "colspan=3");
    // amount_cell($debit2);
    // amount_cell(-$credit2);
    // label_cell('');
    // start_row();
    // label_cell(_("Exchange Rate"), null);
    // amount_cell($ex_change_rate2);
    // end_row();
    // start_row();
    // $gain_amount = $credit-$credit2;
    // label_cell(_("Gain Amount"), null);
    // amount_cell($gain_amount);
    // end_row();
    end_table();
}
    end_table();

end_page(true, false, false, null, $dollar_booking_id);