<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_BANKTRANSVIEW';
$path_to_root = "../..";

include($path_to_root . "/includes/session.inc");

page(_($help_context = "View Post Date Trans"), true);

include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/ui.inc");

include_once($path_to_root . "/gl/includes/gl_db.inc");

if (isset($_GET["trans_no"]))
{
	$trans_no = $_GET["trans_no"];
}

global $SysPrefs;

// get the pay-from bank payment info
$result = get_post_date_trans($trans_no);
// if (db_num_rows($result) != 1)
// 	display_db_error("duplicate payment bank transaction found", "");

// $from_trans = $result;

$company_currency = get_company_currency();

$show_currencies = false;

if ($from_trans['bank_curr_code'] != $from_trans['settle_curr'])
{
	$show_currencies = true;
}
display_heading(_("Post Date Entry") . " #$trans_no");

echo "<br>";
start_table(TABLESTYLE, "width='80%'");

if ($show_currencies)
{
	$colspan1 = 1;
	$colspan2 = 7;
}
else
{
	$colspan1 = 3;
	$colspan2 = 5;
}
if ($trans_no) {
global $payment_person_types;
start_row();
label_cells(_("From Bank Account"), get_bank_account_name($result['bank_id']), "class='tableheader2'");
label_cells(_("Cheque No"), ($result['cheque_no']), "class='tableheader2'");
label_cells(_("Pay To"), ($payment_person_types[$result['pay_to']]), "class='tableheader2'", "colspan=$colspan1");
end_row();
start_row();
label_cells(_("Date"), sql2date($result['date_']), "class='tableheader2'");
label_cells(_("Post Date"), sql2date($result['post_date']), "class='tableheader2'");
label_cells(_("Comments"), ($result['comments']), "class='tableheader2'", "colspan=$colspan1");
end_row();
if ($result['pay_to'] == 0) {
	label_cells(_("Pay To Person"), $result['person_id'], "class='tableheader2'", "colspan=$colspan1");
}elseif($result['pay_to'] == 2){
	label_cells(_("Pay To Person"), get_customer_name($result['person_id']), "class='tableheader2'", "colspan=$colspan1");
}else
	label_cells(_("Pay To Person"), get_supplier_name($result['person_id']), "class='tableheader2'", "colspan=$colspan1");

}else{
$supp_pay = get_post_date_trans($_GET['supp_pay']);
print_r($check);
// display_error($_GET['supp_pay']);
start_row();
label_cells(_("Payment To"), get_supplier_name($supp_pay['person_id']), "class='tableheader2'");
label_cells(_("From Bank Account"), get_bank_account_name($supp_pay['bank_id']), "class='tableheader2'");
label_cells(_("Bank Charge"), ($supp_pay['charge']), "class='tableheader2'");
end_row();
start_row();
label_cells(_("Date Paid"), sql2date($supp_pay['date_']), "class='tableheader2'");
label_cells(_("Post Date"), sql2date($supp_pay['post_date']), "class='tableheader2'");
label_cells(_("Cheque No"), ($supp_pay['cheque_no']), "class='tableheader2'");
end_row();
start_row();
label_cells(_("Cost Center"), get_dimension_string($supp_pay['dimension_id']), "class='tableheader2'");
label_cells(_("Branch"), get_dimension_string($supp_pay['dimension2_id']), "class='tableheader2'", "colspan=$colspan1");
end_row();
}


comments_display_row(ST_BANKPAYMENT, $trans_no);
end_table(1);

$voided = is_voided_display(ST_BANKPAYMENT, $trans_no, _("This payment has been voided."));

$items = get_post_date_trans_details($trans_no);
if ($trans_no) {
if (db_num_rows($items)==0)
{
	display_note(_("There are no items for this payment."));
}
else
{

	display_heading2(_("Items for this post date entry"));
	if ($show_currencies)
		display_heading2(_("Item Amounts are Shown in:") . " " . $company_currency);

    echo "<br>";
    start_table(TABLESTYLE, "width='80%'");
    $dim = get_company_pref('use_dimension');
    if ($dim == 2)
        $th = array(_("Account Code"), _("Account Description"), _($SysPrefs->prefs['dim1_name']), _($SysPrefs->prefs['dim2_name']),
            _("Amount"), _("Memo"));
    elseif ($dim == 1)
        $th = array(_("Account Code"), _("Account Description"), _($SysPrefs->prefs['dim1_name']),
            _("Amount"), _("Memo"));
    else
        $th = array(_("Account Code"), _("Account Description"),
            _("Amount"), _("Memo"));
	table_header($th);

    $k = 0; //row colour counter
	$total_amount = 0;

    while ($item = db_fetch($items))
    {

		if ($item["account"] != $from_trans["account_code"])
		{
    		alt_table_row_color($k);

        	label_cell($item["account"]);
    		label_cell(get_gl_account_name($item["account"]));
            if ($dim >= 1)
                label_cell(get_dimension_string($item['dimension_id'], true));
            if ($dim > 1)
                label_cell(get_dimension_string($item['dimension2_id'], true));
    		amount_cell(number_format2($item["amount"]));
    		label_cell($item["memo_"]);
    		end_row();
    		$total_amount += $item["amount"];
		}
	}

	label_row(_("Total"), number_format2($total_amount, user_price_dec()),"colspan=".(2+$dim)." align=right", "align=right");

	end_table(1);

	if (!$voided)
		display_allocations_from($from_trans['person_type_id'], $from_trans['person_id'], 1, $trans_no, $from_trans['settled_amount']);
	}
}else{


$supp_pay_detail = get_post_date_trans_details($_GET['supp_pay']);
start_form();
start_table(TABLESTYLE, "width='30%'");
$th = array(_("Type"), _("Trans No."), _("Amount"));
table_header($th);
global $systypes_array;
while ($myrow = db_fetch($supp_pay_detail)) 
{
	label_cell($systypes_array[$myrow["invocie_type"]], "align='center'");
	label_cell(get_trans_view_str($myrow["invocie_type"], $myrow["invocie_trans_no"]), "align='center'");
	// label_cell($myrow["invocie_trans_no"], "align='center'");
	label_cell($myrow["amount"], "align='center'");
	end_row();
}
end_table();

}
end_page(true, false, false);
