<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/

function add_logistic($items, $bl_no, $inv_no, $inv_date, $shipment_line, $agent_name, $bank_account=0, $memo_)
{
	global $SysPrefs, $path_to_root, $Refs;

	begin_transaction();

	$sql = " INSERT INTO ".TB_PREF."logistic (bl_no, inv_no, inv_date, shipment_line, agent_name, bank_account, memo_) VALUES (".db_escape($bl_no) . ", ".db_escape($inv_no) . ", '".sql2date($inv_date) . "', 
	".db_escape($shipment_line) . ", ".db_escape($agent_name) . ", ".db_escape($bank_account) . ", 
	".db_escape($memo_) . ")";
   	db_query($sql,"The logistic could not be added");
   	$logistic_id = db_insert_id();

	$cart = new items_cart(0);
	foreach ($items as $line_item)
	{
		add_logistic_items($logistic_id, $line_item->gl_account, $line_item->quantity, $line_item->currency, 
			$line_item->rate, $line_item->foreign, $line_item->ex_rate);
		$total_amount += $line_item->foreign * $line_item->ex_rate;

		$cart->add_gl_item( $line_item->gl_account, 0,
		 $line_item->gl_account, $line_item->foreign * $line_item->ex_rate, "", '', get_post('person_id'));

	}

	add_audit_trail(ST_LOGISTIC, $logistic_id, Today());

	$cart->order_id = 0;
	$supplier = get_supplier($agent_name);
		$cart->add_gl_item( $supplier["payable_account"], 0,
		 $line_item->gl_account, -$total_amount , "", '', $agent_name);


	$cart->tran_date = $cart->doc_date = $cart->event_date = $inv_date;//new_doc_date();
	if (!is_date_in_fiscalyear($cart->tran_date))
	$cart->tran_date = end_fiscalyear();
	$cart->reference = $Refs->get_next(ST_JOURNAL, null, $cart->tran_date);
    $cart->source_ref = "logistic # ".$logistic_id;
	$cart->file_system=0;
	$cart->memo_ = $memo_;
	$cart->tax_info = false;
	$trans_no = write_journal_entries($cart);
	$cart->clear_items();
		$sql = "UPDATE ".TB_PREF."logistic SET 
		gl_no=".db_escape($trans_no);
		$sql .= " WHERE id = ".db_escape($logistic_id);
         db_query($sql);
	unset($cart);

	// $bank_account_code = get_bank_account($bank_account);
	// // display_error($_POST['bank_account'] .'=='. $bank_account_code['account_code'] . '=='.$total_amount );
	// // ------------------------------------------------------------------------------------//
	// // Auto Payment
	// // ------------------------------------------------------------------------------------
	// // include_once($path_to_root . "/includes/ui/items_cart.inc");
	// include_once($path_to_root . "/gl/includes/gl_db.inc");
    // $trans_no = 0;
    // if ($_POST['bank_account']) {
	//     if (isset($_SESSION['pay_items']))
    //     {
    //         unset ($_SESSION['pay_items']);
    //     }
	//     $cart = new items_cart(ST_BANKPAYMENT);
	//     $cart->order_id = 0;
	//     $cart->tran_date = new_doc_date();
	//     $cart->reference = $Refs->get_next($cart->trans_type, null, $cart->tran_date);
	//     if (!is_date_in_fiscalyear($cart->tran_date))
	//         $cart->tran_date = end_fiscalyear();
	//     $cart->add_gl_item($bank_account_code['account_code'], 0, 0, $total_amount, ' auto logistic payment');
	//     $_SESSION['pay_items'] = &$cart;
	//     // echo "<pre>";
	//     // print_r($_SESSION['pay_items']);
	//     begin_transaction();
	//     $_SESSION['pay_items'] = &$_SESSION['pay_items'];
	//     $new = $_SESSION['pay_items']->order_id == 0;
	//     add_new_exchange_rate(get_bank_account_currency(get_post('bank_account')), ToDay(), input_num('_ex_rate'));
	//     $trans = write_bank_transaction(
	//     $_SESSION['pay_items']->trans_type, $_SESSION['pay_items']->order_id, $_POST['bank_account'],
	//     $_SESSION['pay_items'], ToDay(),
	//       0, $_POST['person_id'], get_post('PersonDetailID'),
	//       $_SESSION['pay_items']->reference , ' auto logistic payment', true, input_num('settled_amount', null), 0, null, 0, '', 0);

	//     $trans_type = $trans[0];
	//     $trans_no = $trans[1];
	//     new_doc_date($_POST['date_']);
	//     $_SESSION['pay_items']->clear_items();
	//     unset($_SESSION['pay_items']);
	//     commit_transaction();
	// display_error($trans_type." == ".$trans_no);
	// }
	// // ------------------------------------------------------------------------------------//

	// add_comments(ST_BOM_TRANS, $logistic_id, $date_, $memo_);
	// $Refs->save(ST_BOM_TRANS, $logistic_id, $reference);

	commit_transaction();

	return $logistic_id;
}

//--------------------------------------------------------------------------------------------------

function add_logistic_items($logistic_id, $gl_account, $qty, $currency, $rate=0, $foreign=0, $ex_rate=0)
{
	$sql = "INSERT INTO ".TB_PREF."logistic_details (logistic_id, gl_account, qty, currency, rate,
		forign, ex_rate) VALUES (".db_escape($logistic_id) . ", 
		".db_escape($gl_account) . ", 
		".db_escape($qty) . ", 
		".db_escape($currency) . ", 
		".db_escape($rate ? $rate : 0)  . ", 
		".db_escape($foreign) . ", 
		".db_escape($ex_rate) . ")";
   	db_query($sql,"The logistic details could not be added");
}

function get_logistic_header($id)
{
	$sql = "SELECT * FROM ".TB_PREF."logistic WHERE id=".db_escape($id);
	$result = db_query($sql, "could not get packing list");
	return db_fetch($result);
}

function get_logistic_details($id)
{
	$sql = "SELECT * FROM ".TB_PREF."logistic_details WHERE logistic_id=".db_escape($id);
	return db_query($sql, "could not get packing list");
}

function get_logistic_inquiry($bl_number='')
{
	$sql = "SELECT 
			log.id,
			log.bl_no,
			log.inv_no,
			log.inv_date,
			log.agent_name,
			log.memo_
	 FROM ".TB_PREF."logistic as log , ".TB_PREF."logistic_details as log_d WHERE log.id=log_d.logistic_id";
	if($bl_number != '')
	 	$sql .= " AND log.bl_no=".db_escape($bl_number);
	$sql .= " GROUP BY log.id";
	return $sql;
}
