<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
include_once($path_to_root . "/includes/ui.inc");
include_once($path_to_root . "/includes/ui/items_cart.inc");

//--------------------------------------------------------------------------------

function add_to_order(&$order, $new_item, $new_item_qty, $standard_cost, $batch_no=null, $exp_date = null,
	$pack_size=0, $pack_unit="", $no_of_pack=0)
{
    //if ($order->find_cart_item($new_item))
         //display_error(_("For Part :") . $new_item . " " . "This item is already on this document. You can change the quantity on the existing line if necessary.");
	//else
         $order->add_to_cart (count($order->line_items), $new_item, $new_item_qty, $standard_cost, null, $batch_no, $exp_date, 0, $pack_size, $pack_unit, $no_of_pack);
}

//--------------------------------------------------------------------------------

function display_order_header(&$order)
{
	global $Refs;

	start_outer_table(TABLESTYLE2, "width='70%'"); // outer table
	table_section(1);

	locations_list_row(_("Location:"), 'StockLocation', null, false, false, $order->fixed_asset);
    date_row(_("Date:"), 'AdjDate', '', true);

	table_section(2, "50%");

	ref_row(_("Reference:"), 'ref', '', $Refs->get_next(ST_INVADJUST, null, array('location'=>get_post('StockLocation'), 'date'=>get_post('AdjDate'))),
		 false, ST_INVADJUST);
	file_system_list_row(_("File System:"), 'file_system', null, false, true);
	end_outer_table(1); // outer table
}

//---------------------------------------------------------------------------------

function display_adjustment_items($title, &$order)
{
	global $path_to_root;

	$kv_batch = get_company_pref('kv_batch');
	$kv_exp_date = get_company_pref('kv_exp_date');
	display_heading($title);
    div_start('items_table');
	start_table(TABLESTYLE, "width='80%'");

	if ($order->fixed_asset) {
		$th = array(_("Item Code"), _("Item Description"), _("Quantity"),
		_("Unit"), _("Unit Cost"), _("Initial Value"), "");
	} else {
		$th = array(_("Item Code"), _("Item Description"), _("Quantity"),
		_("Unit"), _("Unit Cost"), _("Total"), "");
		if ( count($order->line_items)) $th[] = '';
	}
	//if ( count($order->line_items)) $th[] = '';
	
	if(!$order->fixed_asset){
		if($kv_exp_date){
			array_splice( $th, 2, 0, _("Batch No") );
			array_splice( $th, 3, 0, _("Exp Date") );
		}elseif($kv_batch){
			array_splice( $th, 2, 0, _("Batch No") );
			// array_splice( $th, 3, 0, _("") );
		}
	}

	array_splice( $th, 6, 0, _("Pack Size") );
	array_splice( $th, 7, 0, _("Pack Unit") );
	array_splice( $th, 8, 0, _("No of Pack") );

	table_header($th);
	$total = 0;
	$k = 0;  //row colour counter

	$low_stock = $order->check_qoh($_POST['StockLocation'], $_POST['AdjDate']);
	$id = find_submit('Edit');
	foreach ($order->line_items as $line_no=>$stock_item)
	{

		$total += ($stock_item->standard_cost * $stock_item->quantity);

		if ($id != $line_no)
		{
			if (in_array($stock_item->stock_id, $low_stock))
				start_row("class='stockmankobg'");	// notice low stock status
			else 
				alt_table_row_color($k);

    		if ($order->fixed_asset)
				label_cell($stock_item->stock_id);
      		else
				view_stock_status_cell($stock_item->stock_id);

			label_cell($stock_item->item_description);
			if (!$order->fixed_asset) {
				if($kv_exp_date){
					label_cell($stock_item->batch_no);
					label_cell($stock_item->exp_date);
				}elseif($kv_batch) 
					label_cell($stock_item->batch_no);
			}
    		qty_cell($stock_item->quantity, false, get_qty_dec($stock_item->stock_id));
			label_cell($stock_item->units);
			amount_decimal_cell($stock_item->standard_cost);
			amount_cell($stock_item->pack_size, null, "align='center'");
			label_cell($stock_item->pack_unit, "align='center'");
    		qty_cell($stock_item->no_of_pack, false, get_qty_dec($stock_item->stock_id));
			if ($order->fixed_asset) {
    	   		$price = get_purchase_value($stock_item->stock_id);
				amount_cell($price);
      		} else
				amount_cell($stock_item->standard_cost * $stock_item->quantity);

      		if (!$order->fixed_asset) {
        		edit_button_cell("Edit$line_no", _("Edit"),	_('Edit document line'));
      		}
			delete_button_cell("Delete$line_no", _("Delete"), _('Remove line from document'));
			end_row();
		}
		else
		{
			adjustment_edit_item_controls($order, $line_no, $kv_batch, $kv_exp_date);
		}
	}

	if ($id == -1)
		adjustment_edit_item_controls($order, -1, $kv_batch, $kv_exp_date);
	if($kv_batch)
		$colspan = 9;
	else
		$colspan= 5; 
	label_row(_("Total"), number_format2($total,user_price_dec()), "align=right colspan=".$colspan, "align=right", 2);

    end_table();
	if ($low_stock)
		display_note(_("Marked items have insufficient quantities in stock as on day of adjustment."), 0, 1, "class='stockmankofg'");
	div_end();
}

//---------------------------------------------------------------------------------

function adjustment_edit_item_controls(&$order, $line_no=-1, $kv_batch=0, $kv_exp_date=0)
{
	global $Ajax;
	start_row();

	$dec2 = 0;
	$id = find_submit('Edit');
	if ($line_no != -1 && $line_no == $id)
	{
		$_POST['stock_id'] = $order->line_items[$id]->stock_id;
		$_POST['qty'] = qty_format($order->line_items[$id]->quantity, 
			$order->line_items[$id]->stock_id, $dec);
		//$_POST['std_cost'] = price_format($order->line_items[$id]->standard_cost);
		$_POST['std_cost'] = price_decimal_format($order->line_items[$id]->standard_cost, $dec2);
		$_POST['units'] = $order->line_items[$id]->units;

		hidden('stock_id', $_POST['stock_id']);
		label_cell($_POST['stock_id']);
		label_cell($order->line_items[$id]->item_description, 'nowrap');
		
		hidden('batch_no', $order->line_items[$id]->batch_no);
		hidden('exp_date', $order->line_items[$id]->exp_date);
		if($kv_exp_date){
			label_cell($order->line_items[$id]->batch_no);
			label_cell($order->line_items[$id]->exp_date);
		} if($kv_batch)
			label_cell($order->line_items[$id]->batch_no);

	    $Ajax->activate('items_table');
	}
	else
	{
		if ($order->fixed_asset)
			stock_disposable_fa_list_cells(null, 'stock_id', null, false, true, $order->line_items);
		else
			stock_costable_items_list_cells(null, 'stock_id', null, false, true);

		if (list_updated('stock_id')) {
			    $Ajax->activate('units');
			    $Ajax->activate('qty');
			    $Ajax->activate('std_cost');
			    $Ajax->activate('std_cost_view');
			    $Ajax->activate('initial_price');
			    $Ajax->activate('items_table');
		}
	if(!$order->fixed_asset){
		if($kv_batch || $kv_exp_date)
			text_cells(null,'batch_no', null, 25, 25);//kv_batch_list_cells(null, 'batch_no', null, true);
		else
			hidden('batch', 0);
		if(list_updated('stock_id') || list_updated('batch_no') || get_post('batch_no')){				
			if($kv_batch || $kv_exp_date) {
				// if(get_post('batch_no') != '' || get_post('batch_no') != null ){
				// 	$sql0 =" SELECT SUM(qty) AS Stock, exp_date FROM ".TB_PREF."stock_moves WHERE batch_no=".db_escape(get_post('batch_no'))." AND stock_id=".get_post('stock_id');  
				// 	$res = db_query($sql0, "can't execute the query");
				// 	$row_res = db_fetch_row($res);		
				// 	$_POST['qty'] = $row_res[0];
				// 	$exp_date = sql2date($row_res[1]);	
				// 	hidden('exp_date', $exp_date);
				// 	if($kv_exp_date)
				// 		label_cell($exp_date);					
				// } else {	
					// if($kv_exp_date)
					// 	date_cells(null, 'exp_date', null);
				if(!$_POST['pack_size'])
					$_POST['qty'] = 0;
				//}
			}else {					
				if(!$_POST['pack_size'])
					$_POST['qty'] = 0;
			}
			$Ajax->activate('items_table');
		}	else {
			if(!$_POST['pack_size'])
				$_POST['qty'] = 0;
			// date_cells(null, 'exp_date', null);
		}
	 }	
    	$item_info = get_item_edit_info(get_post('stock_id'));
    	if ($item_info) {
			$dec = $item_info['decimals'];
			if(!$_POST['pack_size'])
   				$_POST['qty'] = number_format2(0, $dec);
			if(!$_POST['pack_size'])
				$_POST['std_cost'] = price_decimal_format($item_info["material_cost"], $dec2);
			$_POST['units'] = $item_info["units"];
		} else
			$dec = 0;
	}

	if ($order->fixed_asset) {
		hidden('qty', -1);
		qty_cell(1, false, 0);
	} else
		qty_cells(null, 'qty', $_POST['qty'], null, null, $dec);

	label_cell($_POST['units'], '', 'units');

	if ($order->fixed_asset) {
		/* TODO: check if this is a correct way of creating a fixed item
			that still has to be submitted in the form */ 
		hidden('std_cost');
		label_cell($_POST['std_cost'], "nowrap align=right ", 'std_cost_view');
		$price = get_purchase_value($_POST['stock_id']);
		amount_cell($price, false, '', 'initial_price');
	} else {
		//amount_cells(null, 'std_cost', $_POST['std_cost']);

		amount_cells(null, 'std_cost', null, null, null, $dec2);
		amount_cells(null, 'pack_size', $_POST['pack_size'], null, null, $dec, true);
		stock_packing_unit_list_cells(null, 'pack_unit', $_POST['pack_unit']);
		if(input_num('pack_size')){

			$_POST['no_of_pack']=(input_num('qty'))/input_num('pack_size');
		}
		qty_cells(null, 'no_of_pack', $_POST[ 'no_of_pack'] , "align=right ", null, $dec,'readonly');
		label_cell("&nbsp;");
		$Ajax->activate('_page_body');
	}

	if ($id != -1)
	{
		button_cell('UpdateItem', _("Update"),
				_('Confirm changes'), ICON_UPDATE);
		button_cell('CancelItemChanges', _("Cancel"),
				_('Cancel changes'), ICON_CANCEL);
		hidden('LineNo', $line_no);
 		set_focus('qty');
	}
	else
	{
		submit_cells('AddItem', _("Add Item"), "colspan=2",
		    _('Add new item to document'), true);
	}

	end_row();
}


//---------------------------------------------------------------------------------

function adjustment_options_controls()
{
	  echo "<br>";
	  start_table();

	  textarea_row(_("Memo"), 'memo_', null, 50, 3);

	  end_table(1);
}


//---------------------------------------------------------------------------------

