<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
include_once($path_to_root . "/includes/ui.inc");
include_once($path_to_root . "/includes/ui/items_cart.inc");

//--------------------------------------------------------------------------------

function add_to_order(&$order, $gl_account, $qty, $currency, $rate=0, $foreign=0, $ex_rate=0)
{
         $order->add_to_logistic_cart (count($order->logistic_line_items), $gl_account, $qty, $currency, $rate, 
         	$foreign, $ex_rate );
}

//--------------------------------------------------------------------------------

function display_order_header(&$order)
{
	global $Refs, $Ajax;

	start_table(TABLESTYLE, "width='100%'");

	start_row();
	text_cells(_("BL No.").':', 'bl_no', $_POST['bl_no'],"","",false, "class='tableheader2'", "", "", true);
	if($_POST['bl_no'])
	$packing_slip = get_packing_list_bl_no($_POST['bl_no']);
	$Ajax->activate('_page_body');
	text_cells(_("Invoice No.").':', 'inv_no', $_POST['inv_no'],"","",false, "class='tableheader2' ", "", "", true);
	date_cells(_("Invoice Date").':', 'inv_date', '', null, 0, 0, 0, "class='tableheader2'");
	start_row();
	text_cells(_("Shipment Line").':', 'shipment_line', $_POST['shipment_line'],"","",false, "class='tableheader2'");
	// text_cells(_("Agent Name").':', 'agent_name', $_POST['agent_name'],"","",false, "class='tableheader2' ");
	supplier_list_cells(_("Agent Name"), 'agent_name', null, _("Select"), true, false, true);
	label_cells(_("Vessel Voyage"), $packing_slip['vessel_name'], "class='tableheader2'");
	end_row();

	start_row();
	if($packing_slip['order_no'])
	$sales_order = get_sales_order_header($packing_slip['order_no'], ST_SALESORDER);
	label_cells(_("Form 'E' No"), $packing_slip['form_e_no'], "class='tableheader2'");
	label_cells(_("Date"), sql2date($packing_slip['lc_contract_date']), "class='tableheader2'");
	label_cells(_("P.O.L"), $sales_order['port_of_loading'], "class='tableheader2' ");
	end_row();
	start_row();
	label_cells(_("P.O.D"), $sales_order['port_of_discharge'], "class='tableheader2' ");
	// bank_accounts_list_cells(_("Bank Account:"), 'bank_account', null, true, false, '', "class='tableheader2' ");
	label_cell(null, "colspan='3'");
	end_row();
	end_outer_table(1); // outer table
}

//---------------------------------------------------------------------------------

function display_adjustment_items($title, &$order)
{
	global $path_to_root;

	$kv_batch = get_company_pref('kv_batch');
	$kv_exp_date = get_company_pref('kv_exp_date');
	display_heading($title);
    div_start('items_table');
	start_table(TABLESTYLE, "width='80%'");

	if ($order->fixed_asset) {
		$th = array(_("Account Code"), _("Account Description"), _("Unit"),
		_("Currency"), _("Unit Cost"), _("Initial Value"), "");
	} else {
		$th = array(_("Account Code"), _("Account Description"), _("Unit"),
		_("Currency"), _("Rate"), _("Foreign"), _("Ex.Rate"), _("Amount"), "");
		if ( count($order->logistic_line_items)) $th[] = '';
	}
	
	table_header($th);
	$total = 0;
	$k = 0;  //row colour counter

	$low_stock = $order->check_qoh($_POST['StockLocation'], $_POST['AdjDate']);
	$id = find_submit('Edit');
	foreach ($order->logistic_line_items as $line_no=>$stock_item)
	{

		$total += ($stock_item->standard_cost * $stock_item->quantity);
		$dec = user_price_dec();

		if ($id != $line_no)
		{
			alt_table_row_color($k);

			label_cell($stock_item->gl_account);
			$gl_account_name = get_gl_account_name($stock_item->gl_account);
			label_cell($gl_account_name);
    		qty_cell($stock_item->quantity, false, $dec);
			label_cell($stock_item->currency, "align='center'");
			amount_cell($stock_item->rate, "align='center'");
			amount_cell($stock_item->foreign, "align='center'");
			amount_cell($stock_item->ex_rate, "align='center'");
			amount_cell($stock_item->foreign*$stock_item->ex_rate, "align='center'");

			$total += $stock_item->foreign*$stock_item->ex_rate;

      		if (!$order->fixed_asset) {
        		edit_button_cell("Edit$line_no", _("Edit"),	_('Edit document line'));
      		}
			delete_button_cell("Delete$line_no", _("Delete"), _('Remove line from document'));
			end_row();
		}
		else
		{
			adjustment_edit_item_controls($order, $line_no, $kv_batch, $kv_exp_date);
		}
	}

	if ($id == -1)
		adjustment_edit_item_controls($order, -1, $kv_batch, $kv_exp_date);

	$colspan= 7; 
	label_row(_("Total"), number_format2($total,user_price_dec()), "align=right colspan=".$colspan, "align=right", 2);

    end_table();
	if ($low_stock)
		display_note(_("Marked items have insufficient quantities in stock as on day of adjustment."), 0, 1, "class='stockmankofg'");
	div_end();
}

//---------------------------------------------------------------------------------

function adjustment_edit_item_controls(&$order, $line_no=-1, $kv_batch=0, $kv_exp_date=0)
{
	global $Ajax;
	start_row();

	$dec2 = user_price_dec();
	$id = find_submit('Edit');
	if ($line_no != -1 && $line_no == $id)
	{
		$_POST['gl_account'] = $order->logistic_line_items[$id]->gl_account;
		$_POST['qty'] = qty_format($order->logistic_line_items[$id]->quantity, 
			$order->logistic_line_items[$id]->stock_id, $dec);
		$_POST['rate'] = price_decimal_format($order->logistic_line_items[$id]->rate, $dec2);
		hidden('gl_account', $_POST['gl_account']);
		label_cell($_POST['gl_account']);
		$gl_account_name = get_gl_account_name($_POST['gl_account']);
		label_cell($gl_account_name, 'nowrap');
		
	    $Ajax->activate('items_table');
	}
	else
	{
		echo gl_all_accounts_list('gl_account', null, false, true, _('[Select logistic account]'), true, false, false);

		if (list_updated('gl_account')) {
			    $Ajax->activate('qty');
			    $Ajax->activate('rate');
			    $Ajax->activate('currency');
			    $Ajax->activate('foreign');
			    $Ajax->activate('ex_rate');
			    $Ajax->activate('items_table');
		}

	}
	
	qty_cells(null, 'qty', $_POST['qty'], null, null, $dec);
	currencies_list_cells(_(""), 'currency', null, false);
	amount_cells(null, 'rate', null, null, null, $dec2);
	amount_cells(null, 'foreign', null, null, null, $dec2);
	amount_cells(null, 'ex_rate', null, null, null, $dec2);
	label_cell("&nbsp;");

	if ($id != -1)
	{
		button_cell('UpdateItem', _("Update"),
				_('Confirm changes'), ICON_UPDATE);
		button_cell('CancelItemChanges', _("Cancel"),
				_('Cancel changes'), ICON_CANCEL);
		hidden('LineNo', $line_no);
 		set_focus('qty');
	}
	else
	{
		submit_cells('AddItem', _("Add Item"), "colspan=2",
		    _('Add new item to document'), true);
	}

	end_row();
}


//---------------------------------------------------------------------------------

function adjustment_options_controls()
{
	  echo "<br>";
	  start_table();

	  textarea_row(_("Memo"), 'memo_', null, 50, 3);

	  end_table(1);
}


//---------------------------------------------------------------------------------

